(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     50248,       1184]
NotebookOptionsPosition[     48391,       1147]
NotebookOutlinePosition[     48825,       1164]
CellTagsIndexPosition[     48782,       1161]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8122150258277173`*^9, 3.8122150288921566`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"0faaf5f5-babb-408b-abe7-f7c2db7fc841"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h"}], "}"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"CantMRutas", "[", 
  RowBox[{"grafo", ",", "4"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8122150519310036`*^9, 3.8122150566333704`*^9}, {
  3.812215259084219*^9, 3.812215267706832*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"94eafbe8-c46f-40f3-a2c8-36fe297c0674"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`f, $CellContext`g, \
$CellContext`c, $CellContext`d, $CellContext`h, $CellContext`e}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {2, 7}, {5, 6}, {5, 7}, {
       6, 1}, {6, 3}, {8, 3}, {8, 4}, {4, 7}}}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgBWImKL64wGTxcqMv9q3ZB/flfXhkvyOv4vecBYwOz9Qn
C1R7PrNHlzfcrlf6audj+xVnst6eOLoJQ35aV/rOidHv7dPs7b/9K/+BIV/t
k/y/xvyvPQMUoNvnMXeR5u6lbA633jAVdP18jOEeQvqNXzc0Ze5idNgZPvta
decPDPei60eXh4kLXN6Xf9XrPYZ/0M1Hl0fXj+4fdPvR5dHNBwChKsdg
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.2623669028489994, 0.5918496823972964}, 
          0.029014622913859034], 
         InsetBox["a", 
          Offset[{2, 2}, {1.2913815257628585, 0.6208643053111554}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.2034244199874955, 0.6964698146559811}, 
          0.029014622913859034], 
         InsetBox["b", 
          Offset[{2, 2}, {2.2324390429013548, 0.7254844375698402}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.6164448059769027, 0.07333045765226365}, 
          0.029014622913859034], 
         InsetBox["f", 
          Offset[{2, 2}, {0.6454594288907617, 0.10234508056612268}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9799278851681545, 1.529295884993155}, 
          0.029014622913859034], 
         InsetBox["g", 
          Offset[{2, 2}, {1.0089425080820136, 1.558310507907014}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.8309233906508418, 0.6242115199778724}, 
          0.029014622913859034], 
         InsetBox["c", 
          Offset[{2, 2}, {2.859938013564701, 0.6532261428917314}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8260469413842475, 0.}, 0.029014622913859034], 
         InsetBox["d", 
          Offset[{2, 2}, {1.8550615642981065, 0.029014622913859034}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.2160215564339523, 1.5335653670385752}, 
          0.029014622913859034], 
         InsetBox["h", 
          Offset[{2, 2}, {2.245036179347811, 1.5625799899524342}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.9778849775817395}, 0.029014622913859034], 
         InsetBox["e", 
          Offset[{2, 2}, {0.029014622913859034, 1.0068996004955986}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.8122152682489405`*^9, 3.8122152855095806`*^9}},
 CellLabel->"Out[2]=",ExpressionUUID->"888cdc9a-ab79-435f-af7e-a988f15608a8"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "34", "20", "21", "27", "16", "13", "8", "23"},
     {
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "20", "34", "23", "26", "5", "23", "22", "15"},
     {
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "21", "23", "21", "19", "6", "15", "13", "14"},
     {
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "27", "26", "19", "32", "12", "16", "14", "22"},
     {
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "16", "5", "6", "12", "10", "3", "1", "11"},
     {
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "13", "23", "15", "16", "3", "20", "18", "7"},
     {
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "8", "22", "13", "14", "1", "18", "19", "5"},
     {
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "23", "15", "14", "22", "11", "7", "5", "20"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]]}, {
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]]}}, TableAlignments -> Center]]]], "Output",
 CellChangeTimes->{{3.8122152682489405`*^9, 3.8122152855205803`*^9}},
 CellLabel->
  "Out[3]//TableForm=",ExpressionUUID->"b93d6f3b-21fa-4230-8c7d-bd6a6da861d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Lista", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CantRutas", "[", 
      RowBox[{"grafo", ",", "c", ",", "e", ",", 
       RowBox[{"rutas", "\[Rule]", "True"}]}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "#", "]"}], "\[Equal]", "4"}], "&"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PesoRuta", "[", 
    RowBox[{"grafo", ",", "i", ",", 
     RowBox[{"ruta", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "Lista"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.812216061583952*^9, 3.8122161341228704`*^9}, 
   3.8122161997627125`*^9, {3.8122163306415052`*^9, 3.81221637600091*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"30e08806-e34c-4563-812e-cad4296a01e9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "e"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.812216080499463*^9, 3.812216134944685*^9}, 
   3.8122162001703963`*^9, {3.812216363530501*^9, 3.8122163766955614`*^9}},
 CellLabel->"Out[15]=",ExpressionUUID->"ebde399e-ec12-4671-8982-2136b639f1fd"],

Cell[CellGroupData[{

Cell[BoxData["4"], "Print",
 CellChangeTimes->{3.8122163766988096`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[15]:=",ExpressionUUID->"3781d05a-9863-40a3-9f16-894606401f1e"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{3.8122163767470083`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[15]:=",ExpressionUUID->"3a2b6ce1-fb50-4ea7-aaf6-78192d718880"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{3.81221637675*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[15]:=",ExpressionUUID->"7902f667-036b-44c2-ba59-06405e6c4243"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{3.812216376752015*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[15]:=",ExpressionUUID->"61c366d9-4fab-442c-b35e-3e2c53d54b8c"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{3.81221637679193*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[15]:=",ExpressionUUID->"65c62c70-0b8f-4be3-b48c-cf086178825c"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{3.8122163767928867`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[15]:=",ExpressionUUID->"d08ead35-2335-4c16-98d4-14ae0cb99dd9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{$CellContext`a, $CellContext`b, $CellContext`f, $CellContext`g, \
$CellContext`c, $CellContext`d, $CellContext`h, $CellContext`e}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {2, 7}, {5, 6}, {5, 
         7}, {6, 1}, {6, 3}, {8, 3}, {8, 4}, {4, 7}}}, {GraphHighlight -> {
           UndirectedEdge[$CellContext`c, $CellContext`d], 
           UndirectedEdge[$CellContext`g, $CellContext`e], 
           UndirectedEdge[$CellContext`d, $CellContext`a], 
           UndirectedEdge[$CellContext`a, $CellContext`g]}, 
         GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
         VertexLabels -> {"Name"}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           2.2034244199874955`, 0.6964698146559811}}], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           0.6164448059769027, 0.07333045765226365}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
            0.9799278851681545, 1.529295884993155}}]}, 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
            1.8260469413842475`, 0.}}]}, 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           2.8309233906508418`, 0.6242115199778724}}], 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           2.2160215564339523`, 1.5335653670385752`}}], 
          LineBox[{{0.6164448059769027, 0.07333045765226365}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{0.6164448059769027, 0.07333045765226365}, {0., 
           0.9778849775817395}}], 
          LineBox[{{0.9799278851681545, 1.529295884993155}, {
           2.2160215564339523`, 1.5335653670385752`}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{0.9799278851681545, 1.529295884993155}, {0., 
            0.9778849775817395}}]}, 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
            1.8260469413842475`, 0.}}]}, 
          LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
           2.2160215564339523`, 1.5335653670385752`}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {
           DiskBox[{1.2623669028489994, 0.5918496823972964}, 
            0.029014622913859034], 
           InsetBox["a", 
            Offset[{2, 2}, {1.2913815257628585, 0.6208643053111554}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2034244199874955, 0.6964698146559811}, 
            0.029014622913859034], 
           InsetBox["b", 
            Offset[{2, 2}, {2.2324390429013548, 0.7254844375698402}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.6164448059769027, 0.07333045765226365}, 
            0.029014622913859034], 
           InsetBox["f", 
            Offset[{2, 2}, {0.6454594288907617, 0.10234508056612268}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.9799278851681545, 1.529295884993155}, 
            0.029014622913859034], 
           InsetBox["g", 
            Offset[{2, 2}, {1.0089425080820136, 1.558310507907014}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.8309233906508418, 0.6242115199778724}, 
            0.029014622913859034], 
           InsetBox["c", 
            Offset[{2, 2}, {2.859938013564701, 0.6532261428917314}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.8260469413842475, 0.}, 0.029014622913859034], 
           InsetBox["d", 
            Offset[{2, 2}, {1.8550615642981065, 0.029014622913859034}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2160215564339523, 1.5335653670385752}, 
            0.029014622913859034], 
           InsetBox["h", 
            Offset[{2, 2}, {2.245036179347811, 1.5625799899524342}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.9778849775817395}, 0.029014622913859034], 
           InsetBox["e", 
            Offset[{2, 2}, {0.029014622913859034, 1.0068996004955986}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->10], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{$CellContext`a, $CellContext`b, $CellContext`f, $CellContext`g, \
$CellContext`c, $CellContext`d, $CellContext`h, $CellContext`e}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {2, 7}, {5, 6}, {5, 
         7}, {6, 1}, {6, 3}, {8, 3}, {8, 4}, {4, 7}}}, {GraphHighlight -> {
           UndirectedEdge[$CellContext`c, $CellContext`d], 
           UndirectedEdge[$CellContext`f, $CellContext`e], 
           UndirectedEdge[$CellContext`d, $CellContext`a], 
           UndirectedEdge[$CellContext`a, $CellContext`f]}, 
         GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
         VertexLabels -> {"Name"}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           2.2034244199874955`, 0.6964698146559811}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
            0.6164448059769027, 0.07333045765226365}}]}, 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           0.9799278851681545, 1.529295884993155}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
            1.8260469413842475`, 0.}}]}, 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           2.8309233906508418`, 0.6242115199778724}}], 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           2.2160215564339523`, 1.5335653670385752`}}], 
          LineBox[{{0.6164448059769027, 0.07333045765226365}, {
           1.8260469413842475`, 0.}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{0.6164448059769027, 0.07333045765226365}, {0., 
            0.9778849775817395}}]}, 
          LineBox[{{0.9799278851681545, 1.529295884993155}, {
           2.2160215564339523`, 1.5335653670385752`}}], 
          LineBox[{{0.9799278851681545, 1.529295884993155}, {0., 
           0.9778849775817395}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
            1.8260469413842475`, 0.}}]}, 
          LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
           2.2160215564339523`, 1.5335653670385752`}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {
           DiskBox[{1.2623669028489994, 0.5918496823972964}, 
            0.029014622913859034], 
           InsetBox["a", 
            Offset[{2, 2}, {1.2913815257628585, 0.6208643053111554}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2034244199874955, 0.6964698146559811}, 
            0.029014622913859034], 
           InsetBox["b", 
            Offset[{2, 2}, {2.2324390429013548, 0.7254844375698402}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.6164448059769027, 0.07333045765226365}, 
            0.029014622913859034], 
           InsetBox["f", 
            Offset[{2, 2}, {0.6454594288907617, 0.10234508056612268}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.9799278851681545, 1.529295884993155}, 
            0.029014622913859034], 
           InsetBox["g", 
            Offset[{2, 2}, {1.0089425080820136, 1.558310507907014}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.8309233906508418, 0.6242115199778724}, 
            0.029014622913859034], 
           InsetBox["c", 
            Offset[{2, 2}, {2.859938013564701, 0.6532261428917314}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.8260469413842475, 0.}, 0.029014622913859034], 
           InsetBox["d", 
            Offset[{2, 2}, {1.8550615642981065, 0.029014622913859034}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2160215564339523, 1.5335653670385752}, 
            0.029014622913859034], 
           InsetBox["h", 
            Offset[{2, 2}, {2.245036179347811, 1.5625799899524342}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.9778849775817395}, 0.029014622913859034], 
           InsetBox["e", 
            Offset[{2, 2}, {0.029014622913859034, 1.0068996004955986}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->10], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{$CellContext`a, $CellContext`b, $CellContext`f, $CellContext`g, \
$CellContext`c, $CellContext`d, $CellContext`h, $CellContext`e}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {2, 7}, {5, 6}, {5, 
         7}, {6, 1}, {6, 3}, {8, 3}, {8, 4}, {4, 7}}}, {GraphHighlight -> {
           UndirectedEdge[$CellContext`g, $CellContext`e], 
           UndirectedEdge[$CellContext`b, $CellContext`h], 
           UndirectedEdge[$CellContext`h, $CellContext`g], 
           UndirectedEdge[$CellContext`c, $CellContext`b]}, 
         GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
         VertexLabels -> {"Name"}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           2.2034244199874955`, 0.6964698146559811}}], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           0.6164448059769027, 0.07333045765226365}}], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           0.9799278851681545, 1.529295884993155}}], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           1.8260469413842475`, 0.}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
            2.8309233906508418`, 0.6242115199778724}}]}, 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           1.8260469413842475`, 0.}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
            2.2160215564339523`, 1.5335653670385752`}}]}, 
          LineBox[{{0.6164448059769027, 0.07333045765226365}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{0.6164448059769027, 0.07333045765226365}, {0., 
           0.9778849775817395}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{0.9799278851681545, 1.529295884993155}, {
            2.2160215564339523`, 1.5335653670385752`}}]}, 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{0.9799278851681545, 1.529295884993155}, {0., 
            0.9778849775817395}}]}, 
          LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
           2.2160215564339523`, 1.5335653670385752`}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {
           DiskBox[{1.2623669028489994, 0.5918496823972964}, 
            0.029014622913859034], 
           InsetBox["a", 
            Offset[{2, 2}, {1.2913815257628585, 0.6208643053111554}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2034244199874955, 0.6964698146559811}, 
            0.029014622913859034], 
           InsetBox["b", 
            Offset[{2, 2}, {2.2324390429013548, 0.7254844375698402}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.6164448059769027, 0.07333045765226365}, 
            0.029014622913859034], 
           InsetBox["f", 
            Offset[{2, 2}, {0.6454594288907617, 0.10234508056612268}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.9799278851681545, 1.529295884993155}, 
            0.029014622913859034], 
           InsetBox["g", 
            Offset[{2, 2}, {1.0089425080820136, 1.558310507907014}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.8309233906508418, 0.6242115199778724}, 
            0.029014622913859034], 
           InsetBox["c", 
            Offset[{2, 2}, {2.859938013564701, 0.6532261428917314}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.8260469413842475, 0.}, 0.029014622913859034], 
           InsetBox["d", 
            Offset[{2, 2}, {1.8550615642981065, 0.029014622913859034}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2160215564339523, 1.5335653670385752}, 
            0.029014622913859034], 
           InsetBox["h", 
            Offset[{2, 2}, {2.245036179347811, 1.5625799899524342}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.9778849775817395}, 0.029014622913859034], 
           InsetBox["e", 
            Offset[{2, 2}, {0.029014622913859034, 1.0068996004955986}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->10], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{$CellContext`a, $CellContext`b, $CellContext`f, $CellContext`g, \
$CellContext`c, $CellContext`d, $CellContext`h, $CellContext`e}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {2, 7}, {5, 6}, {5, 
         7}, {6, 1}, {6, 3}, {8, 3}, {8, 4}, {4, 7}}}, {GraphHighlight -> {
           UndirectedEdge[$CellContext`f, $CellContext`e], 
           UndirectedEdge[$CellContext`d, $CellContext`f], 
           UndirectedEdge[$CellContext`b, $CellContext`d], 
           UndirectedEdge[$CellContext`c, $CellContext`b]}, 
         GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
         VertexLabels -> {"Name"}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           2.2034244199874955`, 0.6964698146559811}}], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           0.6164448059769027, 0.07333045765226365}}], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           0.9799278851681545, 1.529295884993155}}], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           1.8260469413842475`, 0.}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
            2.8309233906508418`, 0.6242115199778724}}]}, 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
            1.8260469413842475`, 0.}}]}, 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           2.2160215564339523`, 1.5335653670385752`}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{0.6164448059769027, 0.07333045765226365}, {
            1.8260469413842475`, 0.}}]}, 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{0.6164448059769027, 0.07333045765226365}, {0., 
            0.9778849775817395}}]}, 
          LineBox[{{0.9799278851681545, 1.529295884993155}, {
           2.2160215564339523`, 1.5335653670385752`}}], 
          LineBox[{{0.9799278851681545, 1.529295884993155}, {0., 
           0.9778849775817395}}], 
          LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
           2.2160215564339523`, 1.5335653670385752`}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {
           DiskBox[{1.2623669028489994, 0.5918496823972964}, 
            0.029014622913859034], 
           InsetBox["a", 
            Offset[{2, 2}, {1.2913815257628585, 0.6208643053111554}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2034244199874955, 0.6964698146559811}, 
            0.029014622913859034], 
           InsetBox["b", 
            Offset[{2, 2}, {2.2324390429013548, 0.7254844375698402}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.6164448059769027, 0.07333045765226365}, 
            0.029014622913859034], 
           InsetBox["f", 
            Offset[{2, 2}, {0.6454594288907617, 0.10234508056612268}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.9799278851681545, 1.529295884993155}, 
            0.029014622913859034], 
           InsetBox["g", 
            Offset[{2, 2}, {1.0089425080820136, 1.558310507907014}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.8309233906508418, 0.6242115199778724}, 
            0.029014622913859034], 
           InsetBox["c", 
            Offset[{2, 2}, {2.859938013564701, 0.6532261428917314}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.8260469413842475, 0.}, 0.029014622913859034], 
           InsetBox["d", 
            Offset[{2, 2}, {1.8550615642981065, 0.029014622913859034}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2160215564339523, 1.5335653670385752}, 
            0.029014622913859034], 
           InsetBox["h", 
            Offset[{2, 2}, {2.245036179347811, 1.5625799899524342}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.9778849775817395}, 0.029014622913859034], 
           InsetBox["e", 
            Offset[{2, 2}, {0.029014622913859034, 1.0068996004955986}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->10], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{$CellContext`a, $CellContext`b, $CellContext`f, $CellContext`g, \
$CellContext`c, $CellContext`d, $CellContext`h, $CellContext`e}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {2, 7}, {5, 6}, {5, 
         7}, {6, 1}, {6, 3}, {8, 3}, {8, 4}, {4, 7}}}, {GraphHighlight -> {
           UndirectedEdge[$CellContext`g, $CellContext`e], 
           UndirectedEdge[$CellContext`b, $CellContext`a], 
           UndirectedEdge[$CellContext`a, $CellContext`g], 
           UndirectedEdge[$CellContext`c, $CellContext`b]}, 
         GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
         VertexLabels -> {"Name"}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
            2.2034244199874955`, 0.6964698146559811}}]}, 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           0.6164448059769027, 0.07333045765226365}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
            0.9799278851681545, 1.529295884993155}}]}, 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           1.8260469413842475`, 0.}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
            2.8309233906508418`, 0.6242115199778724}}]}, 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           2.2160215564339523`, 1.5335653670385752`}}], 
          LineBox[{{0.6164448059769027, 0.07333045765226365}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{0.6164448059769027, 0.07333045765226365}, {0., 
           0.9778849775817395}}], 
          LineBox[{{0.9799278851681545, 1.529295884993155}, {
           2.2160215564339523`, 1.5335653670385752`}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{0.9799278851681545, 1.529295884993155}, {0., 
            0.9778849775817395}}]}, 
          LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
           2.2160215564339523`, 1.5335653670385752`}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {
           DiskBox[{1.2623669028489994, 0.5918496823972964}, 
            0.029014622913859034], 
           InsetBox["a", 
            Offset[{2, 2}, {1.2913815257628585, 0.6208643053111554}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2034244199874955, 0.6964698146559811}, 
            0.029014622913859034], 
           InsetBox["b", 
            Offset[{2, 2}, {2.2324390429013548, 0.7254844375698402}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.6164448059769027, 0.07333045765226365}, 
            0.029014622913859034], 
           InsetBox["f", 
            Offset[{2, 2}, {0.6454594288907617, 0.10234508056612268}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.9799278851681545, 1.529295884993155}, 
            0.029014622913859034], 
           InsetBox["g", 
            Offset[{2, 2}, {1.0089425080820136, 1.558310507907014}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.8309233906508418, 0.6242115199778724}, 
            0.029014622913859034], 
           InsetBox["c", 
            Offset[{2, 2}, {2.859938013564701, 0.6532261428917314}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.8260469413842475, 0.}, 0.029014622913859034], 
           InsetBox["d", 
            Offset[{2, 2}, {1.8550615642981065, 0.029014622913859034}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2160215564339523, 1.5335653670385752}, 
            0.029014622913859034], 
           InsetBox["h", 
            Offset[{2, 2}, {2.245036179347811, 1.5625799899524342}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.9778849775817395}, 0.029014622913859034], 
           InsetBox["e", 
            Offset[{2, 2}, {0.029014622913859034, 1.0068996004955986}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->10], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{$CellContext`a, $CellContext`b, $CellContext`f, $CellContext`g, \
$CellContext`c, $CellContext`d, $CellContext`h, $CellContext`e}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {2, 7}, {5, 6}, {5, 
         7}, {6, 1}, {6, 3}, {8, 3}, {8, 4}, {4, 7}}}, {GraphHighlight -> {
           UndirectedEdge[$CellContext`f, $CellContext`e], 
           UndirectedEdge[$CellContext`b, $CellContext`a], 
           UndirectedEdge[$CellContext`a, $CellContext`f], 
           UndirectedEdge[$CellContext`c, $CellContext`b]}, 
         GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
         VertexLabels -> {"Name"}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
            2.2034244199874955`, 0.6964698146559811}}]}, 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
            0.6164448059769027, 0.07333045765226365}}]}, 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           0.9799278851681545, 1.529295884993155}}], 
          LineBox[{{1.2623669028489994`, 0.5918496823972964}, {
           1.8260469413842475`, 0.}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
            2.8309233906508418`, 0.6242115199778724}}]}, 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{2.2034244199874955`, 0.6964698146559811}, {
           2.2160215564339523`, 1.5335653670385752`}}], 
          LineBox[{{0.6164448059769027, 0.07333045765226365}, {
           1.8260469413842475`, 0.}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{0.6164448059769027, 0.07333045765226365}, {0., 
            0.9778849775817395}}]}, 
          LineBox[{{0.9799278851681545, 1.529295884993155}, {
           2.2160215564339523`, 1.5335653670385752`}}], 
          LineBox[{{0.9799278851681545, 1.529295884993155}, {0., 
           0.9778849775817395}}], 
          LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
           1.8260469413842475`, 0.}}], 
          LineBox[{{2.8309233906508418`, 0.6242115199778724}, {
           2.2160215564339523`, 1.5335653670385752`}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {
           DiskBox[{1.2623669028489994, 0.5918496823972964}, 
            0.029014622913859034], 
           InsetBox["a", 
            Offset[{2, 2}, {1.2913815257628585, 0.6208643053111554}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2034244199874955, 0.6964698146559811}, 
            0.029014622913859034], 
           InsetBox["b", 
            Offset[{2, 2}, {2.2324390429013548, 0.7254844375698402}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.6164448059769027, 0.07333045765226365}, 
            0.029014622913859034], 
           InsetBox["f", 
            Offset[{2, 2}, {0.6454594288907617, 0.10234508056612268}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.9799278851681545, 1.529295884993155}, 
            0.029014622913859034], 
           InsetBox["g", 
            Offset[{2, 2}, {1.0089425080820136, 1.558310507907014}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.8309233906508418, 0.6242115199778724}, 
            0.029014622913859034], 
           InsetBox["c", 
            Offset[{2, 2}, {2.859938013564701, 0.6532261428917314}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.8260469413842475, 0.}, 0.029014622913859034], 
           InsetBox["d", 
            Offset[{2, 2}, {1.8550615642981065, 0.029014622913859034}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.2160215564339523, 1.5335653670385752}, 
            0.029014622913859034], 
           InsetBox["h", 
            Offset[{2, 2}, {2.245036179347811, 1.5625799899524342}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.9778849775817395}, 0.029014622913859034], 
           InsetBox["e", 
            Offset[{2, 2}, {0.029014622913859034, 1.0068996004955986}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->10]}], "}"}]], "Output",
 CellChangeTimes->{{3.812216080499463*^9, 3.812216134944685*^9}, 
   3.8122162001703963`*^9, {3.812216363530501*^9, 3.812216376874666*^9}},
 CellLabel->"Out[16]=",ExpressionUUID->"1f3f7106-85eb-494b-af07-c859d8621403"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CantMRutas", "[", 
  RowBox[{"grafo", ",", "4", ",", 
   RowBox[{"all", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8122178140387564`*^9, 3.8122178235310864`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"44e8f540-f448-41d2-8161-a78590c5f484"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi18$$ = 3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi18$$], 1, "k"}, 1, 4, 1}}, Typeset`size$$ = {
    621., {150.57500000000002`, 163.07500000000002`}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi18$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> TableForm[
        MatrixPower[
         Part[
          VilCretas`MGrafo[VilCretas`Private`GGrafoAuxiliar17, 
           Sort[
            VertexList[VilCretas`Private`GGrafoAuxiliar17]]], 1], 
         VilCretas`Private`Gi18$$], TableHeadings -> {
          Map[Style[#, Black]& , 
           Sort[
            VertexList[VilCretas`Private`GGrafoAuxiliar17]]], 
          Map[Style[#, Black]& , 
           Sort[
            VertexList[VilCretas`Private`GGrafoAuxiliar17]]]}, 
        TableAlignments -> Center], 
      "Specifications" :> {{{VilCretas`Private`Gi18$$, 1, "k"}, 1, 4, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{717., {254.25, 266.75}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.8122178241984124`*^9, 3.81221782943766*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[17]:=",ExpressionUUID->"591da3c4-3547-4a2c-b11f-2bab9babbbf8"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"072f2056-057c-406d-b2d4-62107d2e19cd"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 63, "Input",ExpressionUUID->"0faaf5f5-babb-408b-abe7-f7c2db7fc841"],
Cell[CellGroupData[{
Cell[785, 27, 1223, 35, 237, "Input",ExpressionUUID->"94eafbe8-c46f-40f3-a2c8-36fe297c0674"],
Cell[2011, 64, 3281, 72, 470, "Output",ExpressionUUID->"888cdc9a-ab79-435f-af7e-a988f15608a8"],
Cell[5295, 138, 6371, 207, 407, "Output",ExpressionUUID->"b93d6f3b-21fa-4230-8c7d-bd6a6da861d9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11703, 350, 863, 22, 458, "Input",ExpressionUUID->"30e08806-e34c-4563-812e-cad4296a01e9"],
Cell[12569, 374, 2020, 65, 317, "Output",ExpressionUUID->"ebde399e-ec12-4671-8982-2136b639f1fd"],
Cell[CellGroupData[{
Cell[14614, 443, 188, 4, 50, "Print",ExpressionUUID->"3781d05a-9863-40a3-9f16-894606401f1e"],
Cell[14805, 449, 188, 4, 50, "Print",ExpressionUUID->"3a2b6ce1-fb50-4ea7-aaf6-78192d718880"],
Cell[14996, 455, 182, 4, 50, "Print",ExpressionUUID->"7902f667-036b-44c2-ba59-06405e6c4243"],
Cell[15181, 461, 186, 4, 50, "Print",ExpressionUUID->"61c366d9-4fab-442c-b35e-3e2c53d54b8c"],
Cell[15370, 467, 185, 4, 50, "Print",ExpressionUUID->"65c62c70-0b8f-4be3-b48c-cf086178825c"],
Cell[15558, 473, 188, 4, 50, "Print",ExpressionUUID->"d08ead35-2335-4c16-98d4-14ae0cb99dd9"]
}, Open  ]],
Cell[15761, 480, 30092, 605, 1875, "Output",ExpressionUUID->"1f3f7106-85eb-494b-af07-c859d8621403"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45890, 1090, 284, 5, 125, "Input",ExpressionUUID->"44e8f540-f448-41d2-8161-a78590c5f484"],
Cell[46177, 1097, 2198, 47, 541, "Print",ExpressionUUID->"591da3c4-3547-4a2c-b11f-2bab9babbbf8"]
}, Open  ]]
}
]
*)

