(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     59390,       1325]
NotebookOptionsPosition[     56630,       1272]
NotebookOutlinePosition[     57064,       1289]
CellTagsIndexPosition[     57021,       1286]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8123632969520254`*^9, 3.812363304035056*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e978fc16-17d9-4815-9d96-53137b19d1a2"],

Cell["Algoritmo de Fleury", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.81271394371772*^9}},
 TextAlignment->Center,ExpressionUUID->"454695b5-2eaa-4a56-be60-be3d9c5272a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"h", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"h", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "b"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8127158975087757`*^9, 3.8127159029536953`*^9}, 
   3.8127362316073303`*^9},
 CellLabel->"In[65]:=",ExpressionUUID->"5bc7e845-c4e8-4306-903c-9b982debb845"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`e, $CellContext`d, $CellContext`f, \
$CellContext`h, $CellContext`c, $CellContext`g, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {2, 4}, {1, 3}, {3, 2}, {5, 6}, {5, 7}, {1, 4}, {
       8, 3}, {8, 2}, {8, 7}, {6, 3}, {6, 2}, {6, 4}, {3, 7}, {2, 7}, {1, 
       8}}}, {VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQBGImKFae0xFvMYnVQfrV1bM7FF/ba9lebpwh8ce+iHXt
DJtdH+zR5e8lnPt95/Yfe6cVNW9dlj3BkH82o5dB5SaDAwMUoMtbL/BNZ3jG
4OCoGOmX/OsXhn3o5qPLo5uPLr/tpkNqMNsH+yUJblfeBZzG0K86+RpHIMsH
e9EJle+EZn/HkEd3H7p70O1Hl0e3H10e3X50eXT70e1DNx8m/iAmZ+nhP68w
7EeXR7cfnY9uPwCcB/gE
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.696396585804466, 0.8478664417482976}, 
          0.02802197943104502], 
         InsetBox["a", 
          Offset[{2, 2}, {2.724418565235511, 0.8758884211793426}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7560048171324731, 1.0454679454709006}, 
          0.02802197943104502], 
         InsetBox["e", 
          Offset[{2, 2}, {1.7840267965635181, 1.0734899249019456}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.803677543275675, 0.6452965391556591}, 
          0.02802197943104502], 
         InsetBox["d", Offset[{2, 2}, {1.83169952270672, 0.6733185185867041}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.106025699921804, 0.}, 0.02802197943104502], 
         InsetBox["f", 
          Offset[{2, 2}, {2.134047679352849, 0.02802197943104502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.8433550101207423}, 0.02802197943104502], 
         InsetBox["h", 
          Offset[{2, 2}, {0.02802197943104502, 0.8713769895517873}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0015443759162799, 0.21340737690912193}, 
          0.02802197943104502], 
         InsetBox["c", 
          Offset[{2, 2}, {1.0295663553473249, 0.24142935634016693}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0010538430444254, 1.4753598514007582}, 
          0.02802197943104502], 
         InsetBox["g", 
          Offset[{2, 2}, {1.0290758224754704, 1.5033818308318032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1123054571690125, 1.6861298618769782}, 
          0.02802197943104502], 
         InsetBox["b", 
          Offset[{2, 2}, {2.1403274366000575, 1.7141518413080232}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.8127159032992783`*^9, {3.8127173998210735`*^9, 3.8127174047829304`*^9}, 
   3.812734962471692*^9, 3.812735947653854*^9, 3.812736237182694*^9, 
   3.8127378386983423`*^9, 3.812739335052205*^9, 3.8128859899821806`*^9, 
   3.812886318454527*^9, 3.8128864498129263`*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"b847d7a1-ce26-4265-9ab2-ca151504d9e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Valencias", "[", "grafo", "]"}]], "Input",
 CellChangeTimes->{{3.8127173901319685`*^9, 3.8127174118178945`*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"a5a92aae-2525-4608-9c7b-b6761f659027"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox["\<\"Grado o valencia\"\>",
       HoldForm], "4", "6", "6", "4", "2", "4", "4", "4"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{"Grado o valencia"}, {
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]]}}, TableAlignments -> Center]]]], "Output",
 CellChangeTimes->{3.812717412590275*^9, 3.8127349650053926`*^9, 
  3.8127362436440115`*^9, 3.81273784101248*^9, 3.8127393377495966`*^9, 
  3.8128859943613987`*^9, 3.8128863216696377`*^9, 3.81288645239586*^9},
 CellLabel->
  "Out[66]//TableForm=",ExpressionUUID->"00abcacf-9593-44d9-aab1-\
2c8a96e4f161"]
}, Open  ]],

Cell["Se toma a\[Rule]d\[Rule]e\[Rule]b\[Rule]g\[Rule]e\[Rule]a:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.812736395045576*^9, 
  3.8127364083423386`*^9}},ExpressionUUID->"957fe482-7988-4ba1-90f5-\
5747a23377e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "d", ",", "e", ",", "b", ",", "g", ",", "e", ",", "a"}], 
      "}"}], ",", "2", ",", "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
  3.812736414035801*^9, 3.81273643941556*^9}, {3.812885953634678*^9, 
  3.8128859758593*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"2ab78289-fda7-419b-86ec-5c467cde53a9"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`e, $CellContext`d, $CellContext`f, \
$CellContext`h, $CellContext`c, $CellContext`g, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {2, 4}, {1, 3}, {3, 2}, {5, 6}, {5, 7}, {1, 4}, {
       8, 3}, {8, 2}, {8, 7}, {6, 3}, {6, 2}, {6, 4}, {3, 7}, {2, 7}, {1, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`g, $CellContext`e], 
         UndirectedEdge[$CellContext`b, $CellContext`g], 
         UndirectedEdge[$CellContext`e, $CellContext`a], 
         UndirectedEdge[$CellContext`d, $CellContext`e], 
         UndirectedEdge[$CellContext`e, $CellContext`b], 
         UndirectedEdge[$CellContext`a, $CellContext`d]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {
          1.7560048171324731`, 1.0454679454709006`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {1.803677543275675,
           0.6452965391556591}}]}, 
        LineBox[{{2.696396585804466, 0.8478664417482976}, {2.106025699921804, 
         0.}}], LineBox[{{2.696396585804466, 0.8478664417482976}, {
         2.1123054571690125`, 1.6861298618769782`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.803677543275675, 0.6452965391556591}}]}, 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         2.106025699921804, 0.}}], 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         1.0015443759162799`, 0.21340737690912193`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.0010538430444254`, 1.4753598514007582`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        LineBox[{{1.803677543275675, 0.6452965391556591}, {2.106025699921804, 
         0.}}], LineBox[{{1.803677543275675, 0.6452965391556591}, {
         1.0015443759162799`, 0.21340737690912193`}}], 
        LineBox[{{1.803677543275675, 0.6452965391556591}, {
         1.0010538430444254`, 1.4753598514007582`}}], 
        LineBox[{{1.803677543275675, 0.6452965391556591}, {
         2.1123054571690125`, 1.6861298618769782`}}], 
        LineBox[{{2.106025699921804, 0.}, {1.0015443759162799`, 
         0.21340737690912193`}}], 
        LineBox[{{0., 0.8433550101207423}, {1.0015443759162799`, 
         0.21340737690912193`}}], 
        LineBox[{{0., 0.8433550101207423}, {1.0010538430444254`, 
         1.4753598514007582`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.0010538430444254`, 1.4753598514007582`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.696396585804466, 0.8478664417482976}, 
          0.02802197943104502], 
         InsetBox["a", 
          Offset[{2, 2}, {2.724418565235511, 0.8758884211793426}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7560048171324731, 1.0454679454709006}, 
          0.02802197943104502], 
         InsetBox["e", 
          Offset[{2, 2}, {1.7840267965635181, 1.0734899249019456}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.803677543275675, 0.6452965391556591}, 
          0.02802197943104502], 
         InsetBox["d", Offset[{2, 2}, {1.83169952270672, 0.6733185185867041}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.106025699921804, 0.}, 0.02802197943104502], 
         InsetBox["f", 
          Offset[{2, 2}, {2.134047679352849, 0.02802197943104502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.8433550101207423}, 0.02802197943104502], 
         InsetBox["h", 
          Offset[{2, 2}, {0.02802197943104502, 0.8713769895517873}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0015443759162799, 0.21340737690912193}, 
          0.02802197943104502], 
         InsetBox["c", 
          Offset[{2, 2}, {1.0295663553473249, 0.24142935634016693}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0010538430444254, 1.4753598514007582}, 
          0.02802197943104502], 
         InsetBox["g", 
          Offset[{2, 2}, {1.0290758224754704, 1.5033818308318032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1123054571690125, 1.6861298618769782}, 
          0.02802197943104502], 
         InsetBox["b", 
          Offset[{2, 2}, {2.1403274366000575, 1.7141518413080232}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.8127140899690084`*^9, 3.812715532131604*^9, 3.8127158215615683`*^9, 
   3.812734968421445*^9, 3.8127364402118483`*^9, 3.81273934083506*^9, {
   3.812885977795931*^9, 3.812885996554264*^9}, 3.812886324784733*^9, 
   3.81288645699065*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"6005c6d3-c395-475d-8f4e-a834d6b654cf"]
}, Open  ]],

Cell["\<\
Se eliminan las aristas {{a,d},{d,e},{e,b},{b,g},{g,e},{e,a}}:\
\>", "Text",
 CellChangeTimes->{{3.8127141102713957`*^9, 3.812714131076416*^9}, 
   3.812736482122649*^9},ExpressionUUID->"4fc16894-dd73-48c7-a6c9-\
548a89737e2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"h", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"h", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"e", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"a", "\[UndirectedEdge]", "b"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8127137131151752`*^9, 3.812713814524122*^9}, {
  3.8127364939610023`*^9, 3.812736584861253*^9}, {3.812736632875793*^9, 
  3.8127366333704677`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"3f7659e4-09c8-4c4d-9b40-88864b67266e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`e, $CellContext`d, $CellContext`f, \
$CellContext`h, $CellContext`c, $CellContext`g, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {2, 4}, {1, 3}, {3, 2}, {5, 6}, {5, 7}, {1, 4}, {
       8, 3}, {8, 2}, {8, 7}, {6, 3}, {6, 2}, {6, 4}, {3, 7}, {2, 7}, {1, 
       8}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`b, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`e] -> {
           GrayLevel[0, 0]}}, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {
          1.7560048171324731`, 1.0454679454709006`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {1.803677543275675,
           0.6452965391556591}}]}, 
        LineBox[{{2.696396585804466, 0.8478664417482976}, {2.106025699921804, 
         0.}}], LineBox[{{2.696396585804466, 0.8478664417482976}, {
         2.1123054571690125`, 1.6861298618769782`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.803677543275675, 0.6452965391556591}}]}, 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         2.106025699921804, 0.}}], 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         1.0015443759162799`, 0.21340737690912193`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.0010538430444254`, 1.4753598514007582`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        LineBox[{{1.803677543275675, 0.6452965391556591}, {2.106025699921804, 
         0.}}], LineBox[{{1.803677543275675, 0.6452965391556591}, {
         1.0015443759162799`, 0.21340737690912193`}}], 
        LineBox[{{1.803677543275675, 0.6452965391556591}, {
         1.0010538430444254`, 1.4753598514007582`}}], 
        LineBox[{{1.803677543275675, 0.6452965391556591}, {
         2.1123054571690125`, 1.6861298618769782`}}], 
        LineBox[{{2.106025699921804, 0.}, {1.0015443759162799`, 
         0.21340737690912193`}}], 
        LineBox[{{0., 0.8433550101207423}, {1.0015443759162799`, 
         0.21340737690912193`}}], 
        LineBox[{{0., 0.8433550101207423}, {1.0010538430444254`, 
         1.4753598514007582`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.0010538430444254`, 1.4753598514007582`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.696396585804466, 0.8478664417482976}, 
          0.02802197943104502], 
         InsetBox["a", 
          Offset[{2, 2}, {2.724418565235511, 0.8758884211793426}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7560048171324731, 1.0454679454709006}, 
          0.02802197943104502], 
         InsetBox["e", 
          Offset[{2, 2}, {1.7840267965635181, 1.0734899249019456}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.803677543275675, 0.6452965391556591}, 
          0.02802197943104502], 
         InsetBox["d", Offset[{2, 2}, {1.83169952270672, 0.6733185185867041}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.106025699921804, 0.}, 0.02802197943104502], 
         InsetBox["f", 
          Offset[{2, 2}, {2.134047679352849, 0.02802197943104502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.8433550101207423}, 0.02802197943104502], 
         InsetBox["h", Offset[{2, 2}, {0.02802197943104502, 0.8713769895517873}]
          , ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0015443759162799, 0.21340737690912193}, 
          0.02802197943104502], 
         InsetBox["c", 
          Offset[{2, 2}, {1.0295663553473249, 0.24142935634016693}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0010538430444254, 1.4753598514007582}, 
          0.02802197943104502], 
         InsetBox["g", 
          Offset[{2, 2}, {1.0290758224754704, 1.5033818308318032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1123054571690125, 1.6861298618769782}, 
          0.02802197943104502], 
         InsetBox["b", 
          Offset[{2, 2}, {2.1403274366000575, 1.7141518413080232}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{3.8127138153838215`*^9, 3.8127141669101925`*^9, 
  3.812715535652377*^9, 3.812715824186742*^9, 3.812734972099332*^9, 
  3.812736634338876*^9, 3.8127393461135664`*^9, 3.81288600150118*^9, 
  3.8128863301707783`*^9, 3.812886464080536*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"8313c87d-9076-4dcb-8415-44ed598bb841"]
}, Open  ]],

Cell["Se toma \
g\[Rule]h\[Rule]c\[Rule]d\[Rule]f\[Rule]a\[Rule]b\[Rule]d\[Rule]g:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.8127141765942564`*^9, 
  3.8127141902733755`*^9}, {3.8127367130247164`*^9, 
  3.8127367316290903`*^9}},ExpressionUUID->"86c97fcf-3a4f-404e-9850-\
d76973c88bfc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "g", ",", "h", ",", "c", ",", "d", ",", "f", ",", "a", ",", "b", ",", 
       "d", ",", "g"}], "}"}], ",", "2", ",", "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
  3.812714192752296*^9, 3.8127142146441393`*^9}, {3.812736767339264*^9, 
  3.812736795599987*^9}, {3.812886006034622*^9, 3.8128860283988624`*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"e09276a5-6d1c-4777-9dd3-20ea4984cf34"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`e, $CellContext`d, $CellContext`f, \
$CellContext`h, $CellContext`c, $CellContext`g, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {2, 4}, {1, 3}, {3, 2}, {5, 6}, {5, 7}, {1, 4}, {
       8, 3}, {8, 2}, {8, 7}, {6, 3}, {6, 2}, {6, 4}, {3, 7}, {2, 7}, {1, 
       8}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`b, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`e] -> {
           GrayLevel[0, 0]}}, GraphHighlight -> {
         UndirectedEdge[$CellContext`f, $CellContext`a], 
         UndirectedEdge[$CellContext`b, $CellContext`d], 
         UndirectedEdge[$CellContext`a, $CellContext`b], 
         UndirectedEdge[$CellContext`d, $CellContext`f], 
         UndirectedEdge[$CellContext`c, $CellContext`d], 
         UndirectedEdge[$CellContext`d, $CellContext`g], 
         UndirectedEdge[$CellContext`h, $CellContext`c], 
         UndirectedEdge[$CellContext`g, $CellContext`h]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {
          1.7560048171324731`, 1.0454679454709006`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {1.803677543275675,
           0.6452965391556591}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {2.106025699921804,
           0.}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.803677543275675, 0.6452965391556591}}]}, 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         2.106025699921804, 0.}}], 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         1.0015443759162799`, 0.21340737690912193`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.0010538430444254`, 1.4753598514007582`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {2.106025699921804,
           0.}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {
          1.0015443759162799`, 0.21340737690912193`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {
          1.0010538430444254`, 1.4753598514007582`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        LineBox[{{2.106025699921804, 0.}, {1.0015443759162799`, 
         0.21340737690912193`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0., 0.8433550101207423}, {1.0015443759162799`, 
          0.21340737690912193`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0., 0.8433550101207423}, {1.0010538430444254`, 
          1.4753598514007582`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.0010538430444254`, 1.4753598514007582`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.696396585804466, 0.8478664417482976}, 
          0.02802197943104502], 
         InsetBox["a", 
          Offset[{2, 2}, {2.724418565235511, 0.8758884211793426}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7560048171324731, 1.0454679454709006}, 
          0.02802197943104502], 
         InsetBox["e", 
          Offset[{2, 2}, {1.7840267965635181, 1.0734899249019456}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.803677543275675, 0.6452965391556591}, 
          0.02802197943104502], 
         InsetBox["d", Offset[{2, 2}, {1.83169952270672, 0.6733185185867041}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.106025699921804, 0.}, 0.02802197943104502], 
         InsetBox["f", 
          Offset[{2, 2}, {2.134047679352849, 0.02802197943104502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.8433550101207423}, 0.02802197943104502], 
         InsetBox["h", 
          Offset[{2, 2}, {0.02802197943104502, 0.8713769895517873}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0015443759162799, 0.21340737690912193}, 
          0.02802197943104502], 
         InsetBox["c", 
          Offset[{2, 2}, {1.0295663553473249, 0.24142935634016693}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0010538430444254, 1.4753598514007582}, 
          0.02802197943104502], 
         InsetBox["g", 
          Offset[{2, 2}, {1.0290758224754704, 1.5033818308318032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1123054571690125, 1.6861298618769782}, 
          0.02802197943104502], 
         InsetBox["b", 
          Offset[{2, 2}, {2.1403274366000575, 1.7141518413080232}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8127142228731165`*^9, 3.812715539215757*^9, 
  3.8127158267724566`*^9, 3.812734974812092*^9, 3.81273680763328*^9, 
  3.81273935031806*^9, 3.8128860401341467`*^9, 3.8128864676596766`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"44444bcb-5d02-4b6b-a124-3abbbb883423"]
}, Open  ]],

Cell["\<\
Se eliminan las aristas {{g,h},{h,c},{c,d},{d,f},{f,a},{a,b},{b,d},{d,g}}:\
\>", "Text",
 CellChangeTimes->{{3.8127141102713957`*^9, 3.812714131076416*^9}, 
   3.812714240878522*^9, 
   3.8127368208881598`*^9},ExpressionUUID->"cb6984fb-a9a1-419b-90ee-\
89c23c54ba93"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"a", ",", "Transparent"}], "]"}], ",", "e", ",", 
      RowBox[{"Style", "[", 
       RowBox[{"d", ",", "Transparent"}], "]"}], ",", "f", ",", 
      RowBox[{"Style", "[", 
       RowBox[{"h", ",", "Transparent"}], "]"}], ",", "c", ",", 
      RowBox[{"Style", "[", 
       RowBox[{"g", ",", "Transparent"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"b", ",", "Transparent"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"h", "\[UndirectedEdge]", "c"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"h", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"e", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", "Transparent"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.812714252897423*^9, 3.8127143877413654`*^9}, 
   3.8127144392663517`*^9, {3.8127146815519857`*^9, 3.8127147248383636`*^9}, {
   3.812714757600453*^9, 3.8127147706960335`*^9}, {3.812715065268671*^9, 
   3.8127151362301545`*^9}, {3.812715168649596*^9, 3.8127151758365564`*^9}, {
   3.812715295421069*^9, 3.8127153491715436`*^9}, {3.812736834235741*^9, 
   3.8127369492562466`*^9}, {3.812736987643506*^9, 3.812737040334783*^9}, {
   3.812737086577406*^9, 3.812737156370026*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"6d13e9d7-b744-4a8a-9811-9b3df3fc7991"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`e, $CellContext`d, $CellContext`f, \
$CellContext`h, $CellContext`c, $CellContext`g, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {2, 4}, {1, 3}, {3, 2}, {5, 6}, {5, 7}, {1, 4}, {
       8, 3}, {8, 2}, {8, 7}, {6, 3}, {6, 2}, {6, 4}, {3, 7}, {2, 7}, {1, 
       8}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`h, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`h, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`f] -> {
           GrayLevel[0, 0]}}, VertexLabels -> {"Name"}, 
       VertexStyle -> {$CellContext`g -> {
           GrayLevel[0, 0]}, $CellContext`h -> {
           GrayLevel[0, 0]}, $CellContext`a -> {
           GrayLevel[0, 0]}, $CellContext`b -> {
           GrayLevel[0, 0]}, $CellContext`d -> {
           GrayLevel[0, 0]}}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {
          1.7560048171324731`, 1.0454679454709006`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {1.803677543275675,
           0.6452965391556591}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {2.106025699921804,
           0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.803677543275675, 0.6452965391556591}}]}, 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         2.106025699921804, 0.}}], 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         1.0015443759162799`, 0.21340737690912193`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.0010538430444254`, 1.4753598514007582`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {2.106025699921804,
           0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {
          1.0015443759162799`, 0.21340737690912193`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {
          1.0010538430444254`, 1.4753598514007582`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        LineBox[{{2.106025699921804, 0.}, {1.0015443759162799`, 
         0.21340737690912193`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.8433550101207423}, {1.0015443759162799`, 
          0.21340737690912193`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.8433550101207423}, {1.0010538430444254`, 
          1.4753598514007582`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.0010538430444254`, 1.4753598514007582`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{2.696396585804466, 0.8478664417482976}, 
           0.02802197943104502]}, 
         InsetBox["a", 
          Offset[{2, 2}, {2.724418565235511, 0.8758884211793426}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7560048171324731, 1.0454679454709006}, 
          0.02802197943104502], 
         InsetBox["e", 
          Offset[{2, 2}, {1.7840267965635181, 1.0734899249019456}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.803677543275675, 0.6452965391556591}, 
           0.02802197943104502]}, 
         InsetBox["d", Offset[{2, 2}, {1.83169952270672, 0.6733185185867041}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.106025699921804, 0.}, 0.02802197943104502], 
         InsetBox["f", 
          Offset[{2, 2}, {2.134047679352849, 0.02802197943104502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0., 0.8433550101207423}, 0.02802197943104502]}, 
         InsetBox["h", 
          Offset[{2, 2}, {0.02802197943104502, 0.8713769895517873}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0015443759162799, 0.21340737690912193}, 
          0.02802197943104502], 
         InsetBox["c", 
          Offset[{2, 2}, {1.0295663553473249, 0.24142935634016693}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.0010538430444254, 1.4753598514007582}, 
           0.02802197943104502]}, 
         InsetBox["g", 
          Offset[{2, 2}, {1.0290758224754704, 1.5033818308318032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{2.1123054571690125, 1.6861298618769782}, 
           0.02802197943104502]}, 
         InsetBox["b", 
          Offset[{2, 2}, {2.1403274366000575, 1.7141518413080232}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.812714341738451*^9, 3.812714388896782*^9}, 
   3.812714440442693*^9, {3.812714704857611*^9, 3.812714725198392*^9}, {
   3.8127147584551673`*^9, 3.8127147715263176`*^9}, 3.8127148834376993`*^9, 
   3.8127151050422554`*^9, 3.8127151373351755`*^9, {3.8127151695867014`*^9, 
   3.8127151766892667`*^9}, 3.812715350204957*^9, 3.812715543816053*^9, 
   3.812715830559408*^9, 3.8127349786308613`*^9, 3.812736950575758*^9, 
   3.812737041185376*^9, 3.812737087497497*^9, 3.812737157281872*^9, 
   3.8127393578517656`*^9, 3.812886060415859*^9, 3.8128864735295353`*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"63e6e552-9b50-44a9-b032-163a6f512df7"]
}, Open  ]],

Cell["Se toma f\[Rule]e\[Rule]c\[Rule]f:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.8127141765942564`*^9, 
  3.8127141902733755`*^9}, {3.8127154197989492`*^9, 3.812715432217738*^9}, {
  3.8127372517819214`*^9, 
  3.8127372596636972`*^9}},ExpressionUUID->"09c80b22-b893-4cef-a8bc-\
c5d8ff28061a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "e", ",", "c", ",", "f"}], "}"}], ",", "2", ",", 
     "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
  3.812714192752296*^9, 3.8127142146441393`*^9}, {3.812715439692197*^9, 
  3.8127154535930314`*^9}, {3.8127372620742874`*^9, 3.812737271588888*^9}, {
  3.8128860663835735`*^9, 3.8128860831896234`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"ac193b0f-aa30-4cc3-9bf8-131e029bb1de"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`e, $CellContext`d, $CellContext`f, \
$CellContext`h, $CellContext`c, $CellContext`g, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {2, 4}, {1, 3}, {3, 2}, {5, 6}, {5, 7}, {1, 4}, {
       8, 3}, {8, 2}, {8, 7}, {6, 3}, {6, 2}, {6, 4}, {3, 7}, {2, 7}, {1, 
       8}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`h, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`h, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`e] -> {
           GrayLevel[0, 0]}}, GraphHighlight -> {
         UndirectedEdge[$CellContext`c, $CellContext`f], 
         UndirectedEdge[$CellContext`f, $CellContext`e], 
         UndirectedEdge[$CellContext`e, $CellContext`c]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}, VertexStyle -> {$CellContext`h -> {
           GrayLevel[0, 0]}, $CellContext`b -> {
           GrayLevel[0, 0]}, $CellContext`a -> {
           GrayLevel[0, 0]}, $CellContext`d -> {
           GrayLevel[0, 0]}, $CellContext`g -> {
           GrayLevel[0, 0]}}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {
          1.7560048171324731`, 1.0454679454709006`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {1.803677543275675,
           0.6452965391556591}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {2.106025699921804,
           0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.803677543275675, 0.6452965391556591}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          2.106025699921804, 0.}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.0015443759162799`, 0.21340737690912193`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.0010538430444254`, 1.4753598514007582`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {2.106025699921804,
           0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {
          1.0015443759162799`, 0.21340737690912193`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {
          1.0010538430444254`, 1.4753598514007582`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.803677543275675, 0.6452965391556591}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.106025699921804, 0.}, {1.0015443759162799`, 
          0.21340737690912193`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.8433550101207423}, {1.0015443759162799`, 
          0.21340737690912193`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.8433550101207423}, {1.0010538430444254`, 
          1.4753598514007582`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.0010538430444254`, 1.4753598514007582`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{2.696396585804466, 0.8478664417482976}, 
           0.02802197943104502]}, 
         InsetBox["a", 
          Offset[{2, 2}, {2.724418565235511, 0.8758884211793426}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7560048171324731, 1.0454679454709006}, 
          0.02802197943104502], 
         InsetBox["e", 
          Offset[{2, 2}, {1.7840267965635181, 1.0734899249019456}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.803677543275675, 0.6452965391556591}, 
           0.02802197943104502]}, 
         InsetBox["d", Offset[{2, 2}, {1.83169952270672, 0.6733185185867041}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.106025699921804, 0.}, 0.02802197943104502], 
         InsetBox["f", 
          Offset[{2, 2}, {2.134047679352849, 0.02802197943104502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0., 0.8433550101207423}, 0.02802197943104502]}, 
         InsetBox["h", 
          Offset[{2, 2}, {0.02802197943104502, 0.8713769895517873}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0015443759162799, 0.21340737690912193}, 
          0.02802197943104502], 
         InsetBox["c", 
          Offset[{2, 2}, {1.0295663553473249, 0.24142935634016693}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.0010538430444254, 1.4753598514007582}, 
           0.02802197943104502]}, 
         InsetBox["g", 
          Offset[{2, 2}, {1.0290758224754704, 1.5033818308318032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{2.1123054571690125, 1.6861298618769782}, 
           0.02802197943104502]}, 
         InsetBox["b", 
          Offset[{2, 2}, {2.1403274366000575, 1.7141518413080232}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.812715454510084*^9, 3.8127158331979804`*^9, 
  3.8127349811954355`*^9, 3.8127372724725194`*^9, 3.8127393607477736`*^9, 
  3.8128861025129213`*^9, 3.812886476537044*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"5c9a3063-7d99-4e75-833b-d0eab56528c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grafo", "=", 
   RowBox[{"Grafo", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"h", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"h", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AnimarGrafo", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "d", ",", "e", ",", "b", ",", "g", ",", "h", ",", "c", ",", 
       "d", ",", "f", ",", "e", ",", "c", ",", "f", ",", "a", ",", "b", ",", 
       "d", ",", "g", ",", "e", ",", "a"}], "}"}], ",", "2", ",", "1"}], 
    "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.812715892843811*^9, 3.8127159148912573`*^9}, {
  3.8127159505813856`*^9, 3.812715967767354*^9}, {3.812716015446836*^9, 
  3.8127160904179473`*^9}, {3.8127162466821785`*^9, 3.8127162841899023`*^9}, {
  3.8127187863887033`*^9, 3.812718815765614*^9}, {3.8127361869677687`*^9, 
  3.812736204982585*^9}, {3.8127373140466614`*^9, 3.812737430758148*^9}, {
  3.812737472475891*^9, 3.812737479091012*^9}, {3.8128862471114116`*^9, 
  3.812886306778717*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"f5fab622-977c-461f-b889-a16850bd67ef"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 11, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 17, 1}}, 
    Typeset`size$$ = {658., {215., 226.0211604242274}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 17, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{754., {317.75, 330.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.8127162618752055`*^9, 3.8127162920518627`*^9}, {
   3.8127188099018774`*^9, 3.8127188188230624`*^9}, {3.812734985433897*^9, 
   3.8127349866067705`*^9}, {3.8127374279059253`*^9, 3.812737434861566*^9}, {
   3.8127375093943267`*^9, 3.8127375117289667`*^9}, {3.8127393649845715`*^9, 
   3.8127393667348175`*^9}, 3.812886307798251*^9, {3.8128864813750505`*^9, 
   3.8128864827726173`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[72]:=",ExpressionUUID->"82371e98-703b-47cc-9304-bbc4d0f35bc9"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"0d9572cf-cec9-44a7-a634-0d26e68dbf28"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"e978fc16-17d9-4815-9d96-53137b19d1a2"],
Cell[761, 25, 178, 2, 77, "Text",ExpressionUUID->"454695b5-2eaa-4a56-be60-be3d9c5272a8"],
Cell[CellGroupData[{
Cell[964, 31, 1271, 26, 335, "Input",ExpressionUUID->"5bc7e845-c4e8-4306-903c-9b982debb845"],
Cell[2238, 59, 3497, 75, 519, "Output",ExpressionUUID->"b847d7a1-ce26-4265-9ab2-ca151504d9e2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5772, 139, 215, 3, 91, "Input",ExpressionUUID->"a5a92aae-2525-4608-9c7b-b6761f659027"],
Cell[5990, 144, 3687, 117, 136, "Output",ExpressionUUID->"00abcacf-9593-44d9-aab1-2c8a96e4f161"]
}, Open  ]],
Cell[9692, 264, 300, 4, 77, "Text",ExpressionUUID->"957fe482-7988-4ba1-90f5-5747a23377e7"],
Cell[CellGroupData[{
Cell[10017, 272, 520, 12, 168, "Input",ExpressionUUID->"2ab78289-fda7-419b-86ec-5c467cde53a9"],
Cell[10540, 286, 5823, 116, 520, "Output",ExpressionUUID->"6005c6d3-c395-475d-8f4e-a834d6b654cf"]
}, Open  ]],
Cell[16378, 405, 237, 5, 128, "Text",ExpressionUUID->"4fc16894-dd73-48c7-a6c9-548a89737e2c"],
Cell[CellGroupData[{
Cell[16640, 414, 1841, 45, 652, "Input",ExpressionUUID->"3f7659e4-09c8-4c4d-9b40-88864b67266e"],
Cell[18484, 461, 5730, 111, 519, "Output",ExpressionUUID->"8313c87d-9076-4dcb-8415-44ed598bb841"]
}, Open  ]],
Cell[24229, 575, 373, 6, 77, "Text",ExpressionUUID->"86c97fcf-3a4f-404e-9850-d76973c88bfc"],
Cell[CellGroupData[{
Cell[24627, 585, 594, 12, 168, "Input",ExpressionUUID->"e09276a5-6d1c-4777-9dd3-20ea4984cf34"],
Cell[25224, 599, 6757, 132, 520, "Output",ExpressionUUID->"44444bcb-5d02-4b6b-a124-3abbbb883423"]
}, Open  ]],
Cell[31996, 734, 277, 6, 128, "Text",ExpressionUUID->"cb6984fb-a9a1-419b-90ee-89c23c54ba93"],
Cell[CellGroupData[{
Cell[32298, 744, 3325, 85, 1700, "Input",ExpressionUUID->"6d13e9d7-b744-4a8a-9811-9b3df3fc7991"],
Cell[35626, 831, 7505, 144, 519, "Output",ExpressionUUID->"63e6e552-9b50-44a9-b032-163a6f512df7"]
}, Open  ]],
Cell[43146, 978, 382, 6, 77, "Text",ExpressionUUID->"09c80b22-b893-4cef-a8bc-c5d8ff28061a"],
Cell[CellGroupData[{
Cell[43553, 988, 590, 12, 168, "Input",ExpressionUUID->"ac193b0f-aa30-4cc3-9bf8-131e029bb1de"],
Cell[44146, 1002, 7566, 147, 520, "Output",ExpressionUUID->"5c9a3063-7d99-4e75-833b-d0eab56528c8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51749, 1154, 2199, 58, 432, "Input",ExpressionUUID->"f5fab622-977c-461f-b889-a16850bd67ef"],
Cell[53951, 1214, 2663, 55, 668, "Print",ExpressionUUID->"82371e98-703b-47cc-9304-bbc4d0f35bc9"]
}, Open  ]]
}
]
*)

