(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     72475,       1665]
NotebookOptionsPosition[     68837,       1598]
NotebookOutlinePosition[     69271,       1615]
CellTagsIndexPosition[     69228,       1612]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8123632969520254`*^9, 3.812363304035056*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"9f3b7533-5537-47c8-a4ca-7b4bb25b98e9"],

Cell["Ruta de Euler", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.81271394371772*^9}, {
  3.812880454937168*^9, 3.8128804573639812`*^9}},
 TextAlignment->Center,ExpressionUUID->"49d99be4-0a3e-45ff-81e5-f55e865d6828"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"f", "\[UndirectedEdge]", "g"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8127158975087757`*^9, 3.8127159029536953`*^9}, 
   3.8127362316073303`*^9, 3.8128830385332875`*^9},
 CellLabel->
  "In[126]:=",ExpressionUUID->"c8ae111f-556a-4151-8632-01c846359e59"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 7}, {2, 3}, {2, 5}, {
       2, 6}, {7, 3}, {7, 4}, {7, 5}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {5, 
       6}}}, {VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQBGImKD4n5/RymucXe2Hf0/wepz7bd+mdCkh3/2LPAAXo
8g2KO3UN2V/Yr3khcjhr0jV7dHmG/2v3frqVbJ977e2i6d2fMORdTN1XTBJ9
YV+g+H3tvIg3GPJrdkhlScn/s++dsvVM56nHGO5Btx9dHt18dHlC5sPAjE3/
9L61bMHwL7r/0OXR7UeXR7cfw3w0+9HtQzcfXR5dP7p6dPsxzEPTDwDIW/Fo

         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.267966185727278, 1.2368851296385557}, 
          0.021651660966456876], 
         InsetBox["a", 
          Offset[{2, 2}, {1.289617846693735, 1.2585367906050124}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.267432513794946, 0.}, 0.021651660966456876], 
         InsetBox["b", 
          Offset[{2, 2}, {1.289084174761403, 0.021651660966456876}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.750877942374288, 0.35268658686585286}, 
          0.021651660966456876], 
         InsetBox["d", 
          Offset[{2, 2}, {0.7725296033407448, 0.37433824783230973}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0024237385782156506, 1.1590801586547983}, 
          0.021651660966456876], 
         InsetBox["e", 
          Offset[{2, 2}, {0.024075399544672527, 1.180731819621255}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7526334082300896, 0.8858178518067188}, 
          0.021651660966456876], 
         InsetBox["f", 
          Offset[{2, 2}, {0.7742850691965465, 0.9074695127731757}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8825935501768454, 0.6184739111164547}, 
          0.021651660966456876], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9042452111433024, 0.6401255720829115}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.0801538338407205}, 0.021651660966456876], 
         InsetBox["c", 
          Offset[{2, 2}, {0.021651660966456876, 0.10180549480717738}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.8127159032992783`*^9, {3.8127173998210735`*^9, 3.8127174047829304`*^9}, 
   3.812734962471692*^9, 3.812735947653854*^9, 3.812736237182694*^9, 
   3.8127378386983423`*^9, 3.812739335052205*^9, 3.812883042812317*^9, 
   3.8128865118717237`*^9, 3.8128866080892367`*^9, 3.8128869026642036`*^9, 
   3.8128893911801863`*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"17d428b1-5bcd-4900-83ba-f30761b00866"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Valencias", "[", "grafo", "]"}]], "Input",
 CellChangeTimes->{{3.8127173901319685`*^9, 3.8127174118178945`*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"46cb63aa-6014-4cfa-9c5a-4a319a53ca1a"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox["\<\"Grado o valencia\"\>",
       HoldForm], "5", "5", "6", "4", "6", "4", "4"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{"Grado o valencia"}, {
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]]}}, TableAlignments -> Center]]]], "Output",
 CellChangeTimes->{3.812717412590275*^9, 3.8127349650053926`*^9, 
  3.8127362436440115`*^9, 3.81273784101248*^9, 3.8127393377495966`*^9, 
  3.8128831391938915`*^9, 3.812886515061228*^9, 3.8128866108919296`*^9, 
  3.812886906111195*^9, 3.812889397171529*^9},
 CellLabel->
  "Out[127]//TableForm=",ExpressionUUID->"59236f82-d721-4f5b-9f8b-\
f38ee5a03365"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"f", "\[UndirectedEdge]", "g"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.812883423682727*^9, 3.812883434323213*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"759addbd-1866-4295-b605-d8415065bfdc"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 7}, {2, 3}, {2, 5}, {
       2, 6}, {7, 3}, {7, 4}, {7, 5}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {5, 
       6}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}}, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.267432513794946, 0.}}]}, 
        LineBox[{{1.267966185727278, 1.2368851296385557`}, {0.750877942374288,
          0.35268658686585286`}}], 
        LineBox[{{1.267966185727278, 1.2368851296385557`}, {
         0.0024237385782156506`, 1.1590801586547983`}}], 
        LineBox[{{1.267966185727278, 1.2368851296385557`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        LineBox[{{1.267966185727278, 1.2368851296385557`}, {
         1.8825935501768454`, 0.6184739111164547}}], 
        LineBox[{{1.267432513794946, 0.}, {0.750877942374288, 
         0.35268658686585286`}}], 
        LineBox[{{1.267432513794946, 0.}, {0.7526334082300896, 
         0.8858178518067188}}], 
        LineBox[{{1.267432513794946, 0.}, {1.8825935501768454`, 
         0.6184739111164547}}], 
        LineBox[{{1.267432513794946, 0.}, {0., 0.0801538338407205}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         0.0024237385782156506`, 1.1590801586547983`}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         1.8825935501768454`, 0.6184739111164547}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {0., 
         0.0801538338407205}}], 
        LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {0., 
         0.0801538338407205}}], 
        LineBox[{{0.7526334082300896, 0.8858178518067188}, {
         1.8825935501768454`, 0.6184739111164547}}], 
        LineBox[{{0.7526334082300896, 0.8858178518067188}, {0., 
         0.0801538338407205}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.267966185727278, 1.2368851296385557}, 
          0.021651660966456876], 
         InsetBox["a", 
          Offset[{2, 2}, {1.289617846693735, 1.2585367906050124}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.267432513794946, 0.}, 0.021651660966456876], 
         InsetBox["b", 
          Offset[{2, 2}, {1.289084174761403, 0.021651660966456876}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.750877942374288, 0.35268658686585286}, 
          0.021651660966456876], 
         InsetBox["d", 
          Offset[{2, 2}, {0.7725296033407448, 0.37433824783230973}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0024237385782156506, 1.1590801586547983}, 
          0.021651660966456876], 
         InsetBox["e", 
          Offset[{2, 2}, {0.024075399544672527, 1.180731819621255}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7526334082300896, 0.8858178518067188}, 
          0.021651660966456876], 
         InsetBox["f", 
          Offset[{2, 2}, {0.7742850691965465, 0.9074695127731757}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8825935501768454, 0.6184739111164547}, 
          0.021651660966456876], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9042452111433024, 0.6401255720829115}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.0801538338407205}, 0.021651660966456876], 
         InsetBox["c", 
          Offset[{2, 2}, {0.021651660966456876, 0.10180549480717738}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{3.812883435350732*^9, 3.8128865176068573`*^9, 
  3.8128866127888446`*^9, 3.8128869082927723`*^9, 3.812886939888434*^9, 
  3.812889400254423*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"fabb7ffe-2a2f-442f-9400-01b7a9a93ed6"]
}, Open  ]],

Cell["Se toma b\[Rule]c\[Rule]e\[Rule]a\[Rule]g\[Rule]b:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.812736395045576*^9, 
  3.8127364083423386`*^9}, {3.812883617004504*^9, 3.8128836273136945`*^9}, {
  3.8128846106421504`*^9, 
  3.81288462297439*^9}},ExpressionUUID->"a187d129-704f-443e-813b-\
4e3b8c491667"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "e", ",", "a", ",", "g", ",", "b"}], "}"}], 
     ",", "2", ",", "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
   3.812736414035801*^9, 3.81273643941556*^9}, {3.812883636859356*^9, 
   3.8128836515638313`*^9}, {3.812884627297655*^9, 3.8128846306926374`*^9}, 
   3.8128847429736223`*^9},
 CellLabel->
  "In[129]:=",ExpressionUUID->"a231b0fa-cb79-46cf-a032-b8f0ca38f3df"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 7}, {2, 3}, {2, 5}, {
       2, 6}, {7, 3}, {7, 4}, {7, 5}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {5, 
       6}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}}, GraphHighlight -> {
         UndirectedEdge[$CellContext`g, $CellContext`b], 
         UndirectedEdge[$CellContext`c, $CellContext`e], 
         UndirectedEdge[$CellContext`a, $CellContext`g], 
         UndirectedEdge[$CellContext`e, $CellContext`a], 
         UndirectedEdge[$CellContext`b, $CellContext`c]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.267432513794946, 0.}}]}, 
        LineBox[{{1.267966185727278, 1.2368851296385557`}, {0.750877942374288,
          0.35268658686585286`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.0024237385782156506`, 1.1590801586547983`}}]}, 
        LineBox[{{1.267966185727278, 1.2368851296385557`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        LineBox[{{1.267432513794946, 0.}, {0.750877942374288, 
         0.35268658686585286`}}], 
        LineBox[{{1.267432513794946, 0.}, {0.7526334082300896, 
         0.8858178518067188}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.267432513794946, 0.}, {1.8825935501768454`, 
          0.6184739111164547}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.267432513794946, 0.}, {0., 0.0801538338407205}}]}, 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         0.0024237385782156506`, 1.1590801586547983`}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         1.8825935501768454`, 0.6184739111164547}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {0., 
         0.0801538338407205}}], 
        LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {0., 
          0.0801538338407205}}]}, 
        LineBox[{{0.7526334082300896, 0.8858178518067188}, {
         1.8825935501768454`, 0.6184739111164547}}], 
        LineBox[{{0.7526334082300896, 0.8858178518067188}, {0., 
         0.0801538338407205}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.267966185727278, 1.2368851296385557}, 
          0.021651660966456876], 
         InsetBox["a", 
          Offset[{2, 2}, {1.289617846693735, 1.2585367906050124}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.267432513794946, 0.}, 0.021651660966456876], 
         InsetBox["b", 
          Offset[{2, 2}, {1.289084174761403, 0.021651660966456876}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.750877942374288, 0.35268658686585286}, 
          0.021651660966456876], 
         InsetBox["d", 
          Offset[{2, 2}, {0.7725296033407448, 0.37433824783230973}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0024237385782156506, 1.1590801586547983}, 
          0.021651660966456876], 
         InsetBox["e", 
          Offset[{2, 2}, {0.024075399544672527, 1.180731819621255}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7526334082300896, 0.8858178518067188}, 
          0.021651660966456876], 
         InsetBox["f", 
          Offset[{2, 2}, {0.7742850691965465, 0.9074695127731757}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8825935501768454, 0.6184739111164547}, 
          0.021651660966456876], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9042452111433024, 0.6401255720829115}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.0801538338407205}, 0.021651660966456876], 
         InsetBox["c", 
          Offset[{2, 2}, {0.021651660966456876, 0.10180549480717738}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8127140899690084`*^9, 3.812715532131604*^9, 
  3.8127158215615683`*^9, 3.812734968421445*^9, 3.8127364402118483`*^9, 
  3.81273934083506*^9, 3.812883653153699*^9, 3.8128865388983183`*^9, 
  3.8128866181880617`*^9, 3.812886648420041*^9, 3.8128869425568757`*^9, 
  3.81288940451363*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"4468dec7-112e-491a-a05a-09644bf0136e"]
}, Open  ]],

Cell["Se eliminan las aristas {{b,c},{c,e},{e,a},{a,g},{g,b}}:", "Text",
 CellChangeTimes->{{3.8127141102713957`*^9, 3.812714131076416*^9}, 
   3.812736482122649*^9, 3.8128836631519833`*^9, 
   3.8128866402562103`*^9},ExpressionUUID->"4b64cb52-38ec-4c02-909f-\
b61ae70edbc5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"a", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"f", "\[UndirectedEdge]", "g"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8127137131151752`*^9, 3.812713814524122*^9}, {
  3.8127364939610023`*^9, 3.812736584861253*^9}, {3.812736632875793*^9, 
  3.8127366333704677`*^9}, {3.8128836765401154`*^9, 3.812883747391261*^9}, {
  3.8128841449758577`*^9, 3.812884151520364*^9}, {3.8128865571301727`*^9, 
  3.8128865576170464`*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"4cb02966-eef0-471d-91d2-d8dfcb9353f4"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 7}, {2, 3}, {2, 5}, {
       2, 6}, {7, 3}, {7, 4}, {7, 5}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {5, 
       6}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`e] -> {
           GrayLevel[0, 0]}}, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.267432513794946, 0.}}]}, 
        LineBox[{{1.267966185727278, 1.2368851296385557`}, {0.750877942374288,
          0.35268658686585286`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.0024237385782156506`, 1.1590801586547983`}}]}, 
        LineBox[{{1.267966185727278, 1.2368851296385557`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        LineBox[{{1.267432513794946, 0.}, {0.750877942374288, 
         0.35268658686585286`}}], 
        LineBox[{{1.267432513794946, 0.}, {0.7526334082300896, 
         0.8858178518067188}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {1.8825935501768454`, 
          0.6184739111164547}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {0., 0.0801538338407205}}]}, 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         0.0024237385782156506`, 1.1590801586547983`}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         1.8825935501768454`, 0.6184739111164547}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {0., 
         0.0801538338407205}}], 
        LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {0., 
          0.0801538338407205}}]}, 
        LineBox[{{0.7526334082300896, 0.8858178518067188}, {
         1.8825935501768454`, 0.6184739111164547}}], 
        LineBox[{{0.7526334082300896, 0.8858178518067188}, {0., 
         0.0801538338407205}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.267966185727278, 1.2368851296385557}, 
          0.021651660966456876], 
         InsetBox["a", 
          Offset[{2, 2}, {1.289617846693735, 1.2585367906050124}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.267432513794946, 0.}, 0.021651660966456876], 
         InsetBox["b", 
          Offset[{2, 2}, {1.289084174761403, 0.021651660966456876}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.750877942374288, 0.35268658686585286}, 
          0.021651660966456876], 
         InsetBox["d", 
          Offset[{2, 2}, {0.7725296033407448, 0.37433824783230973}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0024237385782156506, 1.1590801586547983}, 
          0.021651660966456876], 
         InsetBox["e", 
          Offset[{2, 2}, {0.024075399544672527, 1.180731819621255}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7526334082300896, 0.8858178518067188}, 
          0.021651660966456876], 
         InsetBox["f", 
          Offset[{2, 2}, {0.7742850691965465, 0.9074695127731757}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8825935501768454, 0.6184739111164547}, 
          0.021651660966456876], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9042452111433024, 0.6401255720829115}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.0801538338407205}, 0.021651660966456876], 
         InsetBox["c", 
          Offset[{2, 2}, {0.021651660966456876, 0.10180549480717738}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.8127138153838215`*^9, 3.8127141669101925`*^9, 3.812715535652377*^9, 
   3.812715824186742*^9, 3.812734972099332*^9, 3.812736634338876*^9, 
   3.8127393461135664`*^9, 3.812883753563552*^9, {3.8128841428477235`*^9, 
   3.8128841521809454`*^9}, {3.812886543927619*^9, 3.812886558416855*^9}, 
   3.8128869456668806`*^9, 3.8128894090380907`*^9},
 CellLabel->
  "Out[130]=",ExpressionUUID->"4cd4c656-95dd-472f-94e3-64bc1f927a09"]
}, Open  ]],

Cell["Se toma \
c\[Rule]f\[Rule]a\[Rule]d\[Rule]b\[Rule]f\[Rule]g\[Rule]d\[Rule]c:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.8127141765942564`*^9, 
  3.8127141902733755`*^9}, {3.8127367130247164`*^9, 3.8127367316290903`*^9}, {
  3.812883875107436*^9, 
  3.812883895221257*^9}},ExpressionUUID->"e75f6a8f-da38-4966-ab1c-\
e256e8a01f20"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c", ",", "f", ",", "a", ",", "d", ",", "b", ",", "f", ",", "g", ",", 
       "d", ",", "c"}], "}"}], ",", "2", ",", "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
  3.812714192752296*^9, 3.8127142146441393`*^9}, {3.812736767339264*^9, 
  3.812736795599987*^9}, {3.812883908122301*^9, 3.812883929577176*^9}, {
  3.8128866614616456`*^9, 3.812886700334772*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"eeb7bfad-91fb-43f5-9225-170e056a15ef"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 7}, {2, 3}, {2, 5}, {
       2, 6}, {7, 3}, {7, 4}, {7, 5}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {5, 
       6}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`a, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`e] -> {
           GrayLevel[0, 0]}}, GraphHighlight -> {
         UndirectedEdge[$CellContext`b, $CellContext`f], 
         UndirectedEdge[$CellContext`f, $CellContext`a], 
         UndirectedEdge[$CellContext`d, $CellContext`c], 
         UndirectedEdge[$CellContext`g, $CellContext`d], 
         UndirectedEdge[$CellContext`f, $CellContext`g], 
         UndirectedEdge[$CellContext`c, $CellContext`f], 
         UndirectedEdge[$CellContext`a, $CellContext`d], 
         UndirectedEdge[$CellContext`d, $CellContext`b]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.267432513794946, 0.}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.750877942374288, 0.35268658686585286`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.0024237385782156506`, 1.1590801586547983`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.7526334082300896, 0.8858178518067188}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.267432513794946, 0.}, {0.750877942374288, 
          0.35268658686585286`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.267432513794946, 0.}, {0.7526334082300896, 
          0.8858178518067188}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {1.8825935501768454`, 
          0.6184739111164547}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {0., 0.0801538338407205}}]}, 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         0.0024237385782156506`, 1.1590801586547983`}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.750877942374288, 0.35268658686585286`}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.750877942374288, 0.35268658686585286`}, {0., 
          0.0801538338407205}}]}, 
        LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {0., 
          0.0801538338407205}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.7526334082300896, 0.8858178518067188}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.7526334082300896, 0.8858178518067188}, {0., 
          0.0801538338407205}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.267966185727278, 1.2368851296385557}, 
          0.021651660966456876], 
         InsetBox["a", 
          Offset[{2, 2}, {1.289617846693735, 1.2585367906050124}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.267432513794946, 0.}, 0.021651660966456876], 
         InsetBox["b", 
          Offset[{2, 2}, {1.289084174761403, 0.021651660966456876}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.750877942374288, 0.35268658686585286}, 
          0.021651660966456876], 
         InsetBox["d", 
          Offset[{2, 2}, {0.7725296033407448, 0.37433824783230973}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0024237385782156506, 1.1590801586547983}, 
          0.021651660966456876], 
         InsetBox["e", 
          Offset[{2, 2}, {0.024075399544672527, 1.180731819621255}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7526334082300896, 0.8858178518067188}, 
          0.021651660966456876], 
         InsetBox["f", 
          Offset[{2, 2}, {0.7742850691965465, 0.9074695127731757}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8825935501768454, 0.6184739111164547}, 
          0.021651660966456876], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9042452111433024, 0.6401255720829115}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.0801538338407205}, 0.021651660966456876], 
         InsetBox["c", 
          Offset[{2, 2}, {0.021651660966456876, 0.10180549480717738}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8128867007640095`*^9, 3.812886948452818*^9, 
  3.8128894215331755`*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"485ecc65-b5e5-452f-904a-acaa37ada187"]
}, Open  ]],

Cell["\<\
Se eliminan las aristas {{c,f},{f,a},{a,d},{d,b},{b,f},{f,g},{g,d},{d,c}}:\
\>", "Text",
 CellChangeTimes->{{3.8127141102713957`*^9, 3.812714131076416*^9}, 
   3.812714240878522*^9, 3.8127368208881598`*^9, 
   3.8128839552987223`*^9},ExpressionUUID->"2b2ee02d-b816-42cd-85d8-\
8883082920f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"a", ",", "Transparent"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"b", ",", "Transparent"}], "]"}], ",", "d", ",", "e", ",", "f",
       ",", 
      RowBox[{"Style", "[", 
       RowBox[{"g", ",", "Transparent"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"c", ",", "Transparent"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.812714252897423*^9, 3.8127143877413654`*^9}, 
   3.8127144392663517`*^9, {3.8127146815519857`*^9, 3.8127147248383636`*^9}, {
   3.812714757600453*^9, 3.8127147706960335`*^9}, {3.812715065268671*^9, 
   3.8127151362301545`*^9}, {3.812715168649596*^9, 3.8127151758365564`*^9}, {
   3.812715295421069*^9, 3.8127153491715436`*^9}, {3.812736834235741*^9, 
   3.8127369492562466`*^9}, {3.812736987643506*^9, 3.812737040334783*^9}, {
   3.812737086577406*^9, 3.812737156370026*^9}, {3.8128839688774776`*^9, 
   3.812884130262419*^9}, {3.8128841648155603`*^9, 3.8128841937155*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"f4ae399f-fac8-4b70-89f0-85aad2fc77a7"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 7}, {2, 3}, {2, 5}, {
       2, 6}, {7, 3}, {7, 4}, {7, 5}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {5, 
       6}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`c, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`f, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`e] -> {
           GrayLevel[0, 0]}}, VertexLabels -> {"Name"}, 
       VertexStyle -> {$CellContext`g -> {
           GrayLevel[0, 0]}, $CellContext`a -> {
           GrayLevel[0, 0]}, $CellContext`b -> {
           GrayLevel[0, 0]}, $CellContext`c -> {
           GrayLevel[0, 0]}}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.267432513794946, 0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.750877942374288, 0.35268658686585286`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.0024237385782156506`, 1.1590801586547983`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.7526334082300896, 0.8858178518067188}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {0.750877942374288, 
          0.35268658686585286`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {0.7526334082300896, 
          0.8858178518067188}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {1.8825935501768454`, 
          0.6184739111164547}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {0., 0.0801538338407205}}]}, 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         0.0024237385782156506`, 1.1590801586547983`}}], 
        LineBox[{{0.750877942374288, 0.35268658686585286`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.750877942374288, 0.35268658686585286`}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.750877942374288, 0.35268658686585286`}, {0., 
          0.0801538338407205}}]}, 
        LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {
         0.7526334082300896, 0.8858178518067188}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {0., 
          0.0801538338407205}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.7526334082300896, 0.8858178518067188}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.7526334082300896, 0.8858178518067188}, {0., 
          0.0801538338407205}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.267966185727278, 1.2368851296385557}, 
           0.021651660966456876]}, 
         InsetBox["a", 
          Offset[{2, 2}, {1.289617846693735, 1.2585367906050124}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.267432513794946, 0.}, 0.021651660966456876]}, 
         InsetBox["b", 
          Offset[{2, 2}, {1.289084174761403, 0.021651660966456876}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.750877942374288, 0.35268658686585286}, 
          0.021651660966456876], 
         InsetBox["d", 
          Offset[{2, 2}, {0.7725296033407448, 0.37433824783230973}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0024237385782156506, 1.1590801586547983}, 
          0.021651660966456876], 
         InsetBox["e", 
          Offset[{2, 2}, {0.024075399544672527, 1.180731819621255}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7526334082300896, 0.8858178518067188}, 
          0.021651660966456876], 
         InsetBox["f", 
          Offset[{2, 2}, {0.7742850691965465, 0.9074695127731757}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.8825935501768454, 0.6184739111164547}, 
           0.021651660966456876]}, 
         InsetBox["g", 
          Offset[{2, 2}, {1.9042452111433024, 0.6401255720829115}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0., 0.0801538338407205}, 0.021651660966456876]}, 
         InsetBox["c", 
          Offset[{2, 2}, {0.021651660966456876, 0.10180549480717738}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.812714341738451*^9, 3.812714388896782*^9}, 
   3.812714440442693*^9, {3.812714704857611*^9, 3.812714725198392*^9}, {
   3.8127147584551673`*^9, 3.8127147715263176`*^9}, 3.8127148834376993`*^9, 
   3.8127151050422554`*^9, 3.8127151373351755`*^9, {3.8127151695867014`*^9, 
   3.8127151766892667`*^9}, 3.812715350204957*^9, 3.812715543816053*^9, 
   3.812715830559408*^9, 3.8127349786308613`*^9, 3.812736950575758*^9, 
   3.812737041185376*^9, 3.812737087497497*^9, 3.812737157281872*^9, 
   3.8127393578517656`*^9, 3.812884076673604*^9, 3.812884132340345*^9, 
   3.812884194659029*^9, 3.8128865871619015`*^9, 3.8128867097555766`*^9, {
   3.8128869528288774`*^9, 3.8128869680371866`*^9}, 3.812889426074542*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"bf950632-c010-45ae-87b5-18d614eecedf"]
}, Open  ]],

Cell["Se toma d\[Rule]e\[Rule]f\[Rule]d:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.8127141765942564`*^9, 
  3.8127141902733755`*^9}, {3.8127154197989492`*^9, 3.812715432217738*^9}, {
  3.8127372517819214`*^9, 3.8127372596636972`*^9}, {3.8128842407775607`*^9, 
  3.812884247459303*^9}},ExpressionUUID->"7f162885-d518-4687-86c5-\
e84af0a1b7ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f", ",", "d"}], "}"}], ",", "2", ",", 
     "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
  3.812714192752296*^9, 3.8127142146441393`*^9}, {3.812715439692197*^9, 
  3.8127154535930314`*^9}, {3.8127372620742874`*^9, 3.812737271588888*^9}, {
  3.812884252074582*^9, 3.812884258483596*^9}, {3.8128867127318096`*^9, 
  3.8128867305478477`*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"c6fdd2d7-ea82-4a12-b0e6-298fe800de74"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 7}, {2, 3}, {2, 5}, {
       2, 6}, {7, 3}, {7, 4}, {7, 5}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {5, 
       6}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`f, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`e] -> {
           GrayLevel[0, 0]}}, GraphHighlight -> {
         UndirectedEdge[$CellContext`e, $CellContext`f], 
         UndirectedEdge[$CellContext`f, $CellContext`d], 
         UndirectedEdge[$CellContext`d, $CellContext`e]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}, VertexStyle -> {$CellContext`b -> {
           GrayLevel[0, 0]}, $CellContext`a -> {
           GrayLevel[0, 0]}, $CellContext`c -> {
           GrayLevel[0, 0]}, $CellContext`g -> {
           GrayLevel[0, 0]}}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.267432513794946, 0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.750877942374288, 0.35268658686585286`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.0024237385782156506`, 1.1590801586547983`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          0.7526334082300896, 0.8858178518067188}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267966185727278, 1.2368851296385557`}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {0.750877942374288, 
          0.35268658686585286`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {0.7526334082300896, 
          0.8858178518067188}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {1.8825935501768454`, 
          0.6184739111164547}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.267432513794946, 0.}, {0., 0.0801538338407205}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.750877942374288, 0.35268658686585286`}, {
          0.0024237385782156506`, 1.1590801586547983`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.750877942374288, 0.35268658686585286`}, {
          0.7526334082300896, 0.8858178518067188}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.750877942374288, 0.35268658686585286`}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.750877942374288, 0.35268658686585286`}, {0., 
          0.0801538338407205}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {
          0.7526334082300896, 0.8858178518067188}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.0024237385782156506`, 1.1590801586547983`}, {0., 
          0.0801538338407205}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.7526334082300896, 0.8858178518067188}, {
          1.8825935501768454`, 0.6184739111164547}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.7526334082300896, 0.8858178518067188}, {0., 
          0.0801538338407205}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.267966185727278, 1.2368851296385557}, 
           0.021651660966456876]}, 
         InsetBox["a", 
          Offset[{2, 2}, {1.289617846693735, 1.2585367906050124}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.267432513794946, 0.}, 0.021651660966456876]}, 
         InsetBox["b", 
          Offset[{2, 2}, {1.289084174761403, 0.021651660966456876}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.750877942374288, 0.35268658686585286}, 
          0.021651660966456876], 
         InsetBox["d", 
          Offset[{2, 2}, {0.7725296033407448, 0.37433824783230973}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0024237385782156506, 1.1590801586547983}, 
          0.021651660966456876], 
         InsetBox["e", 
          Offset[{2, 2}, {0.024075399544672527, 1.180731819621255}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7526334082300896, 0.8858178518067188}, 
          0.021651660966456876], 
         InsetBox["f", 
          Offset[{2, 2}, {0.7742850691965465, 0.9074695127731757}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.8825935501768454, 0.6184739111164547}, 
           0.021651660966456876]}, 
         InsetBox["g", 
          Offset[{2, 2}, {1.9042452111433024, 0.6401255720829115}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0., 0.0801538338407205}, 0.021651660966456876]}, 
         InsetBox["c", 
          Offset[{2, 2}, {0.021651660966456876, 0.10180549480717738}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.812715454510084*^9, 3.8127158331979804`*^9, 3.8127349811954355`*^9, 
   3.8127372724725194`*^9, 3.8127393607477736`*^9, 3.8128842615627213`*^9, 
   3.812886731353657*^9, {3.8128869715591307`*^9, 3.8128869874407363`*^9}, 
   3.8128894297637835`*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"2cb5fa34-f6cc-4061-aadb-a0ecb0351faf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "f", ",", "a", ",", "d", ",", "e", ",", "f",
      ",", "d", ",", "b", ",", "f", ",", "g", ",", "d", ",", "c", ",", "e", 
     ",", "a", ",", "g", ",", "b"}], "}"}], ",", "2", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->
  "In[134]:=",ExpressionUUID->"bbdc624d-3980-4fa3-a232-47d6e8675070"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "b"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8128887153133335`*^9, 3.8128894329427757`*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"891c07f0-1aea-48a3-abce-fd1c6f774d50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grafo", "=", 
   RowBox[{"Grafo", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "g"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AnimarGrafo", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "f", ",", "a", ",", "d", ",", "e", ",", 
       "f", ",", "d", ",", "b", ",", "f", ",", "g", ",", "d", ",", "c", ",", 
       "e", ",", "a", ",", "g", ",", "b"}], "}"}], ",", "2", ",", "1"}], 
    "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.812715892843811*^9, 3.8127159148912573`*^9}, {
  3.8127159505813856`*^9, 3.812715967767354*^9}, {3.812716015446836*^9, 
  3.8127160904179473`*^9}, {3.8127162466821785`*^9, 3.8127162841899023`*^9}, {
  3.8127187863887033`*^9, 3.812718815765614*^9}, {3.8127361869677687`*^9, 
  3.812736204982585*^9}, {3.8127373140466614`*^9, 3.812737430758148*^9}, {
  3.812737472475891*^9, 3.812737479091012*^9}, {3.812882986725561*^9, 
  3.8128830037581496`*^9}, {3.812884366739619*^9, 3.8128844599818425`*^9}, {
  3.812886744429389*^9, 3.812886873475515*^9}},
 CellLabel->
  "In[135]:=",ExpressionUUID->"7072892c-d927-4520-8f77-c188587d4f6f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 14, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 17, 1}}, 
    Typeset`size$$ = {540., {184., 191.03250919393895`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 17, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{606., {255., 263.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.812884501862727*^9, 3.8128845042920437`*^9}, {
  3.8128868552859864`*^9, 3.8128868896996665`*^9}, {3.8128869917576265`*^9, 
  3.8128869935453367`*^9}, {3.81288943515261*^9, 3.812889444655631*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"62143f7c-c0a7-4230-9b69-accbccbdcc63"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grafo", "=", 
   RowBox[{"Grafo", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "g"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RutaEulerQ", "[", "grafo", "]"}], "\[IndentingNewLine]", 
 RowBox[{"RutaEuler", "[", "grafo", "]"}], "\[IndentingNewLine]", 
 RowBox[{"RutaEuler", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"ruta", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.812889131322365*^9, 3.81288916916795*^9}, {
  3.8128892548719225`*^9, 3.812889266646962*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"29db91b6-a998-4f0a-89ec-05a7c570c17e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.8128891488087482`*^9, 3.812889169855649*^9}, 
   3.812889267321694*^9, {3.8128894382639847`*^9, 3.812889455613757*^9}},
 CellLabel->
  "Out[142]=",ExpressionUUID->"906177d5-bebe-4cae-a382-1156d30a2106"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8128891488087482`*^9, 3.812889169855649*^9}, 
   3.812889267321694*^9, {3.8128894382639847`*^9, 3.8128894557177114`*^9}},
 CellLabel->
  "Out[143]=",ExpressionUUID->"83850c80-26a9-49f5-b64b-0779a877709b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 17, 1}}, 
    Typeset`size$$ = {658., {224., 235.71554536447962`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 17, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{754., {305.75, 318.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{
  3.812889267572114*^9, {3.8128894385091987`*^9, 3.8128894558472605`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[141]:=",ExpressionUUID->"51579ddf-83b6-44d2-80f3-b75f3f67b327"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"59d1085e-7f8a-4253-9843-1f147458aff7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"9f3b7533-5537-47c8-a4ca-7b4bb25b98e9"],
Cell[761, 25, 223, 3, 75, "Text",ExpressionUUID->"49d99be4-0a3e-45ff-81e5-f55e865d6828"],
Cell[CellGroupData[{
Cell[1009, 32, 1299, 27, 222, "Input",ExpressionUUID->"c8ae111f-556a-4151-8632-01c846359e59"],
Cell[2311, 61, 3290, 72, 600, "Output",ExpressionUUID->"17d428b1-5bcd-4900-83ba-f30761b00866"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5638, 138, 219, 4, 63, "Input",ExpressionUUID->"46cb63aa-6014-4cfa-9c5a-4a319a53ca1a"],
Cell[5860, 144, 3415, 107, 137, "Output",ExpressionUUID->"59236f82-d721-4f5b-9f8b-f38ee5a03365"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9312, 256, 1326, 29, 222, "Input",ExpressionUUID->"759addbd-1866-4295-b605-d8415065bfdc"],
Cell[10641, 287, 4769, 98, 600, "Output",ExpressionUUID->"fabb7ffe-2a2f-442f-9400-01b7a9a93ed6"]
}, Open  ]],
Cell[15425, 388, 393, 6, 75, "Text",ExpressionUUID->"a187d129-704f-443e-813b-4e3b8c491667"],
Cell[CellGroupData[{
Cell[15843, 398, 588, 13, 98, "Input",ExpressionUUID->"a231b0fa-cb79-46cf-a032-b8f0ca38f3df"],
Cell[16434, 413, 5605, 113, 600, "Output",ExpressionUUID->"4468dec7-112e-491a-a05a-09644bf0136e"]
}, Open  ]],
Cell[22054, 529, 275, 4, 75, "Text",ExpressionUUID->"4b64cb52-38ec-4c02-909f-b61ae70edbc5"],
Cell[CellGroupData[{
Cell[22354, 537, 1997, 48, 340, "Input",ExpressionUUID->"4cb02966-eef0-471d-91d2-d8dfcb9353f4"],
Cell[24354, 587, 5569, 111, 600, "Output",ExpressionUUID->"4cd4c656-95dd-472f-94e3-64bc1f927a09"]
}, Open  ]],
Cell[29938, 701, 422, 7, 75, "Text",ExpressionUUID->"e75f6a8f-da38-4966-ab1c-e256e8a01f20"],
Cell[CellGroupData[{
Cell[30385, 712, 647, 14, 98, "Input",ExpressionUUID->"eeb7bfad-91fb-43f5-9225-170e056a15ef"],
Cell[31035, 728, 6343, 126, 624, "Output",ExpressionUUID->"485ecc65-b5e5-452f-904a-acaa37ada187"]
}, Open  ]],
Cell[37393, 857, 301, 6, 75, "Text",ExpressionUUID->"2b2ee02d-b816-42cd-85d8-8883082920f6"],
Cell[CellGroupData[{
Cell[37719, 867, 3350, 86, 823, "Input",ExpressionUUID->"f4ae399f-fac8-4b70-89f0-85aad2fc77a7"],
Cell[41072, 955, 7264, 139, 600, "Output",ExpressionUUID->"bf950632-c010-45ae-87b5-18d614eecedf"]
}, Open  ]],
Cell[48351, 1097, 430, 6, 75, "Text",ExpressionUUID->"7f162885-d518-4687-86c5-e84af0a1b7ea"],
Cell[CellGroupData[{
Cell[48806, 1107, 643, 14, 98, "Input",ExpressionUUID->"c6fdd2d7-ea82-4a12-b0e6-298fe800de74"],
Cell[49452, 1123, 7260, 142, 600, "Output",ExpressionUUID->"2cb5fa34-f6cc-4061-aadb-a0ecb0351faf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56749, 1270, 407, 10, 98, "Input",ExpressionUUID->"bbdc624d-3980-4fa3-a232-47d6e8675070"],
Cell[57159, 1282, 1207, 39, 117, "Output",ExpressionUUID->"891c07f0-1aea-48a3-abce-fd1c6f774d50"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58403, 1326, 2300, 60, 275, "Input",ExpressionUUID->"7072892c-d927-4520-8f77-c188587d4f6f"],
Cell[60706, 1388, 2473, 52, 798, "Print",ExpressionUUID->"62143f7c-c0a7-4230-9b69-accbccbdcc63"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63216, 1445, 1705, 49, 427, "Input",ExpressionUUID->"29db91b6-a998-4f0a-89ec-05a7c570c17e"],
Cell[64924, 1496, 256, 4, 100, "Output",ExpressionUUID->"906177d5-bebe-4cae-a382-1156d30a2106"],
Cell[65183, 1502, 1283, 40, 188, "Output",ExpressionUUID->"83850c80-26a9-49f5-b64b-0779a877709b"],
Cell[66469, 1544, 2352, 51, 644, "Print",ExpressionUUID->"51579ddf-83b6-44d2-80f3-b75f3f67b327"]
}, Open  ]]
}
]
*)

