(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     73837,       1643]
NotebookOptionsPosition[     70613,       1582]
NotebookOutlinePosition[     71047,       1599]
CellTagsIndexPosition[     71004,       1596]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8123632969520254`*^9, 3.812363304035056*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"12ea8779-2cc0-4aac-93ba-efc457e1f494"],

Cell["Ruta de Euler", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.81271394371772*^9}, {
  3.812880454937168*^9, 3.8128804573639812`*^9}},
 TextAlignment->Center,ExpressionUUID->"a515f0b1-8efd-46eb-8262-e4a40aa6e6bf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"g", "\[UndirectedEdge]", "d"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8127158975087757`*^9, 3.8127159029536953`*^9}, 
   3.8127362316073303`*^9, 3.8128830385332875`*^9, 3.8129685604985023`*^9},
 CellLabel->"In[85]:=",ExpressionUUID->"8bc82546-b349-4b80-9ffb-3c9768db0bc7"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`c, $CellContext`e, $CellContext`d, $CellContext`a, \
$CellContext`h, $CellContext`f, $CellContext`b, $CellContext`g}, {
      Null, {{1, 2}, {3, 2}, {3, 4}, {1, 3}, {2, 5}, {1, 5}, {1, 6}, {4, 7}, {
       4, 1}, {7, 1}, {7, 3}, {7, 5}, {3, 6}, {2, 6}, {6, 8}, {4, 8}, {8, 
       3}}}, {VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQBGImKDapvNOs/eadfcEmnRPMB1/Yv6qYGySn89KeYULr
1A/nve3R5R++fbqTmfOXfeKpj/eOnH6BIT/Nyb5M4vkf+67SS0xzj/7AkGeA
gvQbf75/O46pf5apeMrCl3/g6tDlOzrNd80yeGnvlTDfYvGRHxjuRXcfujy6
/ejy6Pajm4fuP3R5QvrR3Y8un/M45rHrfhaHJR93Leo6jmkfun50eXT96P5F
14/uXnT9AJ5tECg=
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.9663293433584728, 0.7735613736782181}, 
          0.027250873892722252], 
         InsetBox["c", 
          Offset[{2, 2}, {0.993580217251195, 0.8008122475709404}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7866355527474103, 0.0008487629629994053}, 
          0.027250873892722252], 
         InsetBox["e", 
          Offset[{2, 2}, {0.8138864266401326, 0.028099636855721657}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6272008191725649, 0.7748741487869887}, 
          0.027250873892722252], 
         InsetBox["d", Offset[{2, 2}, {1.654451693065287, 0.802125022679711}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8064198130634046, 1.54824544050584}, 
          0.027250873892722252], 
         InsetBox["a", 
          Offset[{2, 2}, {1.8336706869561268, 1.575496314398562}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.7744097560414617}, 0.027250873892722252], 
         InsetBox["h", 
          Offset[{2, 2}, {0.027250873892722252, 0.801660629934184}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8070386800567122, 0.}, 0.027250873892722252], 
         InsetBox["f", 
          Offset[{2, 2}, {1.8342895539494344, 0.027250873892722252}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7871831547784476, 1.5480072223490589}, 
          0.027250873892722252], 
         InsetBox["b", 
          Offset[{2, 2}, {0.8144340286711699, 1.575258096241781}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.593395019790867, 0.7743580988240422}, 
          0.027250873892722252], 
         InsetBox["g", 
          Offset[{2, 2}, {2.620645893683589, 0.8016089727167645}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.8127159032992783`*^9, {3.8127173998210735`*^9, 3.8127174047829304`*^9}, 
   3.812734962471692*^9, 3.812735947653854*^9, 3.812736237182694*^9, 
   3.8127378386983423`*^9, 3.812739335052205*^9, 3.812883042812317*^9, 
   3.8128865118717237`*^9, 3.8128866080892367`*^9, 3.8128869026642036`*^9, 
   3.8128893911801863`*^9, 3.8129684762614574`*^9, 3.812968564195078*^9, 
   3.8129703799646597`*^9, 3.8129705791806655`*^9, 3.8129740059915648`*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"8aaac784-e5ae-4edb-bd05-3c236dc16b7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Valencias", "[", "grafo", "]"}]], "Input",
 CellChangeTimes->{{3.8127173901319685`*^9, 3.8127174118178945`*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"adbfd6c6-440a-4ff1-a7be-dcf9bf407ac5"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox["\<\"Grado o valencia\"\>",
       HoldForm], "6", "4", "6", "4", "3", "4", "4", "3"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{"Grado o valencia"}, {
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]]}}, TableAlignments -> Center]]]], "Output",
 CellChangeTimes->{3.812717412590275*^9, 3.8127349650053926`*^9, 
  3.8127362436440115`*^9, 3.81273784101248*^9, 3.8127393377495966`*^9, 
  3.8128831391938915`*^9, 3.812886515061228*^9, 3.8128866108919296`*^9, 
  3.812886906111195*^9, 3.812889397171529*^9, 3.812968571032695*^9, 
  3.8129703834466314`*^9, 3.812970581533222*^9},
 CellLabel->
  "Out[74]//TableForm=",ExpressionUUID->"9ec83e9a-3517-4a5d-b7b1-\
9ae178195ee9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"g", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"g", "\[UndirectedEdge]", "d"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.812883423682727*^9, 3.812883434323213*^9}, {
  3.8129685852673264`*^9, 3.812968643790309*^9}, {3.8129698081189647`*^9, 
  3.812969825083725*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"65b8b019-e204-4986-9ec1-8891a5e8d740"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`g, $CellContext`h, $CellContext`c, $CellContext`e, \
$CellContext`d, $CellContext`a, $CellContext`f, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {5, 4}, {5, 6}, {3, 5}, {4, 2}, {3, 2}, {3, 7}, {
       6, 8}, {6, 3}, {8, 3}, {8, 5}, {8, 2}, {5, 7}, {4, 7}, {7, 1}, {6, 
       1}, {1, 5}}}, {VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQAmImKG6XK1G1inlrrzbLSWTn3Z/2MxbeiQrxeWvPAAXo
8lrfpWM/hL61v/HqZkjV9w/26PJGM90qQsP+2h/98GNeY9wXDHmYuQsUrs3z
T/6CYV8Tr79Jjf9be6bzL5T/XXmIIc+QIDk7ucPFvjk52uXo/6sY8lYZcz7M
8ftrf3broi2vX1y1RzcPXT+6PLr/0OXR/YdhPpr/0OXR3YfuHnT70eXRzUdX
j+4+DPMI6Ed3H7p56PIAwvwOTg==
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.917508195067925, 1.6166315833485299}, 
          0.021246659915075294], 
         InsetBox["g", 
          Offset[{2, 2}, {0.9387548549830003, 1.6378782432636052}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9155675673146559, 0.}, 0.021246659915075294], 
         InsetBox["h", 
          Offset[{2, 2}, {0.9368142272297313, 0.021246659915075294}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9159527799278495, 0.5572500897746695}, 
          0.021246659915075294], 
         InsetBox["c", 
          Offset[{2, 2}, {0.9371994398429249, 0.5784967496897448}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0006266104084700075, 0.3437359969662383}, 
          0.021246659915075294], 
         InsetBox["e", 
          Offset[{2, 2}, {0.021873270323545302, 0.3649826568813136}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9167405909099433, 1.0604193987371016}, 
          0.021246659915075294], 
         InsetBox["d", 
          Offset[{2, 2}, {0.9379872508250187, 1.081666058652177}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8335776041290726, 1.2730728349552447}, 
          0.021246659915075294], 
         InsetBox["a", Offset[{2, 2}, {1.854824264044148, 1.29431949487032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.2742458538578276}, 0.021246659915075294], 
         InsetBox["f", 
          Offset[{2, 2}, {0.021246659915075294, 1.295492513772903}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8316926382890544, 0.3423413528460884}, 
          0.021246659915075294], 
         InsetBox["b", 
          Offset[{2, 2}, {1.8529392982041297, 0.3635880127611637}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.812883435350732*^9, 3.8128865176068573`*^9, 3.8128866127888446`*^9, 
   3.8128869082927723`*^9, 3.812886939888434*^9, 3.812889400254423*^9, {
   3.8129686097011175`*^9, 3.812968644147352*^9}, 3.8129691626849394`*^9, 
   3.812969282804079*^9, 3.812969446325882*^9, 3.8129695407812557`*^9, {
   3.8129698134738507`*^9, 3.81296982594903*^9}, 3.812970385248258*^9, 
   3.8129705836582966`*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"e7728b68-609e-4e53-9bf5-5e393edc2b19"]
}, Open  ]],

Cell["Se toma \
h\[Rule]g\[Rule]f\[Rule]e\[Rule]h\[Rule]b\[Rule]a\[Rule]g\[Rule]d\[Rule]c\
\[Rule]h:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.812736395045576*^9, 
  3.8127364083423386`*^9}, {3.812883617004504*^9, 3.8128836273136945`*^9}, {
  3.8128846106421504`*^9, 3.81288462297439*^9}, {3.812968821296853*^9, 
  3.812968864563321*^9}, {3.812969226414893*^9, 3.8129692490706263`*^9}, {
  3.8129694531272087`*^9, 
  3.8129694754688063`*^9}},ExpressionUUID->"19418e65-f960-47ae-b63e-\
bbd34ea7be60"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "h", ",", "g", ",", "f", ",", "e", ",", "h", ",", "b", ",", "a", ",", 
       "g", ",", "d", ",", "c", ",", "h"}], "}"}], ",", "2", ",", "1"}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
   3.812736414035801*^9, 3.81273643941556*^9}, {3.812883636859356*^9, 
   3.8128836515638313`*^9}, {3.812884627297655*^9, 3.8128846306926374`*^9}, 
   3.8128847429736223`*^9, {3.8129688927447615`*^9, 3.812968906929475*^9}, {
   3.8129690424775004`*^9, 3.812969044028246*^9}, {3.8129691106956005`*^9, 
   3.812969115082814*^9}, {3.8129691793204527`*^9, 3.812969186591795*^9}, {
   3.812969480060935*^9, 3.812969497657611*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"104f45d3-526a-4d6d-8e97-9f502f113a5e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`g, $CellContext`h, $CellContext`c, $CellContext`e, \
$CellContext`d, $CellContext`a, $CellContext`f, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {5, 4}, {5, 6}, {3, 5}, {4, 2}, {3, 2}, {3, 7}, {
       6, 8}, {6, 3}, {8, 3}, {8, 5}, {8, 2}, {5, 7}, {4, 7}, {7, 1}, {6, 
       1}, {1, 5}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`h, $CellContext`b], 
         UndirectedEdge[$CellContext`f, $CellContext`e], 
         UndirectedEdge[$CellContext`c, $CellContext`h], 
         UndirectedEdge[$CellContext`b, $CellContext`a], 
         UndirectedEdge[$CellContext`d, $CellContext`c], 
         UndirectedEdge[$CellContext`a, $CellContext`g], 
         UndirectedEdge[$CellContext`g, $CellContext`d], 
         UndirectedEdge[$CellContext`g, $CellContext`f], 
         UndirectedEdge[$CellContext`h, $CellContext`g], 
         UndirectedEdge[$CellContext`e, $CellContext`h]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          0.9155675673146559, 0.}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {0., 
          1.2742458538578276`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9155675673146559, 0.}, {0.9159527799278495, 
          0.5572500897746695}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9155675673146559, 0.}, {0.0006266104084700075, 
          0.3437359969662383}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9155675673146559, 0.}, {1.8316926382890544`, 
          0.3423413528460884}}]}, 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {
         0.0006266104084700075, 0.3437359969662383}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {
         1.8335776041290726`, 1.2730728349552447`}}], 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {0., 
         1.2742458538578276`}}], 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {
         1.8316926382890544`, 0.3423413528460884}}], 
        LineBox[{{0.0006266104084700075, 0.3437359969662383}, {
         0.9167405909099433, 1.0604193987371016`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.0006266104084700075, 0.3437359969662383}, {0., 
          1.2742458538578276`}}]}, 
        LineBox[{{0.9167405909099433, 1.0604193987371016`}, {
         1.8335776041290726`, 1.2730728349552447`}}], 
        LineBox[{{0.9167405909099433, 1.0604193987371016`}, {0., 
         1.2742458538578276`}}], 
        LineBox[{{0.9167405909099433, 1.0604193987371016`}, {
         1.8316926382890544`, 0.3423413528460884}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.8335776041290726`, 1.2730728349552447`}, {
          1.8316926382890544`, 0.3423413528460884}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.917508195067925, 1.6166315833485299}, 
          0.021246659915075294], 
         InsetBox["g", 
          Offset[{2, 2}, {0.9387548549830003, 1.6378782432636052}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9155675673146559, 0.}, 0.021246659915075294], 
         InsetBox["h", 
          Offset[{2, 2}, {0.9368142272297313, 0.021246659915075294}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9159527799278495, 0.5572500897746695}, 
          0.021246659915075294], 
         InsetBox["c", 
          Offset[{2, 2}, {0.9371994398429249, 0.5784967496897448}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0006266104084700075, 0.3437359969662383}, 
          0.021246659915075294], 
         InsetBox["e", 
          Offset[{2, 2}, {0.021873270323545302, 0.3649826568813136}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9167405909099433, 1.0604193987371016}, 
          0.021246659915075294], 
         InsetBox["d", 
          Offset[{2, 2}, {0.9379872508250187, 1.081666058652177}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8335776041290726, 1.2730728349552447}, 
          0.021246659915075294], 
         InsetBox["a", Offset[{2, 2}, {1.854824264044148, 1.29431949487032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.2742458538578276}, 0.021246659915075294], 
         InsetBox["f", 
          Offset[{2, 2}, {0.021246659915075294, 1.295492513772903}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8316926382890544, 0.3423413528460884}, 
          0.021246659915075294], 
         InsetBox["b", 
          Offset[{2, 2}, {1.8529392982041297, 0.3635880127611637}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.8127140899690084`*^9, 3.812715532131604*^9, 3.8127158215615683`*^9, 
   3.812734968421445*^9, 3.8127364402118483`*^9, 3.81273934083506*^9, 
   3.812883653153699*^9, 3.8128865388983183`*^9, 3.8128866181880617`*^9, 
   3.812886648420041*^9, 3.8128869425568757`*^9, 3.81288940451363*^9, 
   3.8129689117436724`*^9, 3.812969045636141*^9, {3.8129691655641365`*^9, 
   3.812969188478095*^9}, 3.8129692855754538`*^9, 3.812969543365933*^9, 
   3.8129698287102365`*^9, 3.812970389323571*^9, 3.812970586674734*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"2f734798-36b8-4a27-a070-63de67f3bde3"]
}, Open  ]],

Cell["\<\
Se eliminan las aristas \
{{h,g},{g,f},{f,e},{e,h},{h,b},{b,a},{a,g},{g,d},{d,c},{c,h}}:\
\>", "Text",
 CellChangeTimes->{{3.8127141102713957`*^9, 3.812714131076416*^9}, 
   3.812736482122649*^9, 3.8128836631519833`*^9, 3.8128866402562103`*^9, 
   3.812968932267662*^9, {3.81296904990034*^9, 3.8129690523075137`*^9}, 
   3.8129692115173273`*^9, 
   3.812969563648984*^9},ExpressionUUID->"154a7759-e011-4a6e-8dd5-\
434e4bb71d70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"g", ",", "Transparent"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"h", ",", "Transparent"}], "]"}], ",", "c", ",", "e", ",", "d",
       ",", "a", ",", "f", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"g", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8127137131151752`*^9, 3.812713814524122*^9}, {
  3.8127364939610023`*^9, 3.812736584861253*^9}, {3.812736632875793*^9, 
  3.8127366333704677`*^9}, {3.8128836765401154`*^9, 3.812883747391261*^9}, {
  3.8128841449758577`*^9, 3.812884151520364*^9}, {3.8128865571301727`*^9, 
  3.8128865576170464`*^9}, {3.812968945687417*^9, 3.812968958683931*^9}, {
  3.812969305031898*^9, 3.8129693857623215`*^9}, {3.812969576722166*^9, 
  3.81296970549422*^9}, {3.812969783506592*^9, 3.8129698595102224`*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"aa540334-9839-4822-87f7-bad4bc480058"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`g, $CellContext`h, $CellContext`c, $CellContext`e, \
$CellContext`d, $CellContext`a, $CellContext`f, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {5, 4}, {5, 6}, {3, 5}, {4, 2}, {3, 2}, {3, 7}, {
       6, 8}, {6, 3}, {8, 3}, {8, 5}, {8, 2}, {5, 7}, {4, 7}, {7, 1}, {6, 
       1}, {1, 5}}}, {
      EdgeStyle -> {UndirectedEdge[$CellContext`f, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`f] -> {
           GrayLevel[0, 0]}}, VertexLabels -> {"Name"}, 
       VertexStyle -> {$CellContext`h -> {
           GrayLevel[0, 0]}, $CellContext`g -> {
           GrayLevel[0, 0]}}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          0.9155675673146559, 0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {0., 
          1.2742458538578276`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {0.9159527799278495, 
          0.5572500897746695}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {0.0006266104084700075, 
          0.3437359969662383}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {1.8316926382890544`, 
          0.3423413528460884}}]}, 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {
         0.0006266104084700075, 0.3437359969662383}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {
         1.8335776041290726`, 1.2730728349552447`}}], 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {0., 
         1.2742458538578276`}}], 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {
         1.8316926382890544`, 0.3423413528460884}}], 
        LineBox[{{0.0006266104084700075, 0.3437359969662383}, {
         0.9167405909099433, 1.0604193987371016`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.0006266104084700075, 0.3437359969662383}, {0., 
          1.2742458538578276`}}]}, 
        LineBox[{{0.9167405909099433, 1.0604193987371016`}, {
         1.8335776041290726`, 1.2730728349552447`}}], 
        LineBox[{{0.9167405909099433, 1.0604193987371016`}, {0., 
         1.2742458538578276`}}], 
        LineBox[{{0.9167405909099433, 1.0604193987371016`}, {
         1.8316926382890544`, 0.3423413528460884}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.8335776041290726`, 1.2730728349552447`}, {
          1.8316926382890544`, 0.3423413528460884}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.917508195067925, 1.6166315833485299}, 
           0.021246659915075294]}, 
         InsetBox["g", 
          Offset[{2, 2}, {0.9387548549830003, 1.6378782432636052}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.9155675673146559, 0.}, 0.021246659915075294]}, 
         InsetBox["h", 
          Offset[{2, 2}, {0.9368142272297313, 0.021246659915075294}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9159527799278495, 0.5572500897746695}, 
          0.021246659915075294], 
         InsetBox["c", 
          Offset[{2, 2}, {0.9371994398429249, 0.5784967496897448}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0006266104084700075, 0.3437359969662383}, 
          0.021246659915075294], 
         InsetBox["e", 
          Offset[{2, 2}, {0.021873270323545302, 0.3649826568813136}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9167405909099433, 1.0604193987371016}, 
          0.021246659915075294], 
         InsetBox["d", 
          Offset[{2, 2}, {0.9379872508250187, 1.081666058652177}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8335776041290726, 1.2730728349552447}, 
          0.021246659915075294], 
         InsetBox["a", Offset[{2, 2}, {1.854824264044148, 1.29431949487032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.2742458538578276}, 0.021246659915075294], 
         InsetBox["f", 
          Offset[{2, 2}, {0.021246659915075294, 1.295492513772903}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8316926382890544, 0.3423413528460884}, 
          0.021246659915075294], 
         InsetBox["b", 
          Offset[{2, 2}, {1.8529392982041297, 0.3635880127611637}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.8127138153838215`*^9, 3.8127141669101925`*^9, 3.812715535652377*^9, 
   3.812715824186742*^9, 3.812734972099332*^9, 3.812736634338876*^9, 
   3.8127393461135664`*^9, 3.812883753563552*^9, {3.8128841428477235`*^9, 
   3.8128841521809454`*^9}, {3.812886543927619*^9, 3.812886558416855*^9}, 
   3.8128869456668806`*^9, 3.8128894090380907`*^9, 3.812969776962282*^9, 
   3.8129698604720497`*^9, 3.812970393705434*^9, 3.8129705903269553`*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"237250b5-a146-433a-917e-47e1fb95bcbd"]
}, Open  ]],

Cell["Se toma f\[Rule]d\[Rule]a\[Rule]c\[Rule]f:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.8127141765942564`*^9, 
  3.8127141902733755`*^9}, {3.8127367130247164`*^9, 3.8127367316290903`*^9}, {
  3.812883875107436*^9, 3.812883895221257*^9}, {3.812969897845519*^9, 
  3.8129699058127184`*^9}},ExpressionUUID->"6297c55c-0545-4690-a11f-\
19250c03ee00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "d", ",", "a", ",", "c", ",", "f"}], "}"}], ",", "2", 
     ",", "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
  3.812714192752296*^9, 3.8127142146441393`*^9}, {3.812736767339264*^9, 
  3.812736795599987*^9}, {3.812883908122301*^9, 3.812883929577176*^9}, {
  3.8128866614616456`*^9, 3.812886700334772*^9}, {3.812969913397665*^9, 
  3.8129699165198727`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"7409bd87-e20a-4a14-bb74-2588fa0b6bae"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`g, $CellContext`h, $CellContext`c, $CellContext`e, \
$CellContext`d, $CellContext`a, $CellContext`f, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {5, 4}, {5, 6}, {3, 5}, {4, 2}, {3, 2}, {3, 7}, {
       6, 8}, {6, 3}, {8, 3}, {8, 5}, {8, 2}, {5, 7}, {4, 7}, {7, 1}, {6, 
       1}, {1, 5}}}, {
      EdgeStyle -> {UndirectedEdge[$CellContext`f, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`f] -> {
           GrayLevel[0, 0]}}, GraphHighlight -> {
         UndirectedEdge[$CellContext`a, $CellContext`c], 
         UndirectedEdge[$CellContext`f, $CellContext`d], 
         UndirectedEdge[$CellContext`d, $CellContext`a], 
         UndirectedEdge[$CellContext`c, $CellContext`f]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}, VertexStyle -> {$CellContext`h -> {
           GrayLevel[0, 0]}, $CellContext`g -> {
           GrayLevel[0, 0]}}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          0.9155675673146559, 0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {0., 
          1.2742458538578276`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {0.9159527799278495, 
          0.5572500897746695}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {0.0006266104084700075, 
          0.3437359969662383}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {1.8316926382890544`, 
          0.3423413528460884}}]}, 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {
         0.0006266104084700075, 0.3437359969662383}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {0., 
          1.2742458538578276`}}]}, 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {
         1.8316926382890544`, 0.3423413528460884}}], 
        LineBox[{{0.0006266104084700075, 0.3437359969662383}, {
         0.9167405909099433, 1.0604193987371016`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.0006266104084700075, 0.3437359969662383}, {0., 
          1.2742458538578276`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9167405909099433, 1.0604193987371016`}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9167405909099433, 1.0604193987371016`}, {0., 
          1.2742458538578276`}}]}, 
        LineBox[{{0.9167405909099433, 1.0604193987371016`}, {
         1.8316926382890544`, 0.3423413528460884}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.8335776041290726`, 1.2730728349552447`}, {
          1.8316926382890544`, 0.3423413528460884}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.917508195067925, 1.6166315833485299}, 
           0.021246659915075294]}, 
         InsetBox["g", 
          Offset[{2, 2}, {0.9387548549830003, 1.6378782432636052}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.9155675673146559, 0.}, 0.021246659915075294]}, 
         InsetBox["h", 
          Offset[{2, 2}, {0.9368142272297313, 0.021246659915075294}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9159527799278495, 0.5572500897746695}, 
          0.021246659915075294], 
         InsetBox["c", 
          Offset[{2, 2}, {0.9371994398429249, 0.5784967496897448}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0006266104084700075, 0.3437359969662383}, 
          0.021246659915075294], 
         InsetBox["e", 
          Offset[{2, 2}, {0.021873270323545302, 0.3649826568813136}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9167405909099433, 1.0604193987371016}, 
          0.021246659915075294], 
         InsetBox["d", 
          Offset[{2, 2}, {0.9379872508250187, 1.081666058652177}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8335776041290726, 1.2730728349552447}, 
          0.021246659915075294], 
         InsetBox["a", Offset[{2, 2}, {1.854824264044148, 1.29431949487032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.2742458538578276}, 0.021246659915075294], 
         InsetBox["f", 
          Offset[{2, 2}, {0.021246659915075294, 1.295492513772903}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8316926382890544, 0.3423413528460884}, 
          0.021246659915075294], 
         InsetBox["b", 
          Offset[{2, 2}, {1.8529392982041297, 0.3635880127611637}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8128867007640095`*^9, 3.812886948452818*^9, 
  3.8128894215331755`*^9, 3.812969919620332*^9, 3.812970396570896*^9, 
  3.8129705931018734`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"d073fb06-5d0e-46b4-947b-f2d9e2402dcb"]
}, Open  ]],

Cell["Se eliminan las aristas {{f,d},{d,a},{a,c},{c,f}}:", "Text",
 CellChangeTimes->{{3.8127141102713957`*^9, 3.812714131076416*^9}, 
   3.812714240878522*^9, 3.8127368208881598`*^9, 3.8128839552987223`*^9, 
   3.8129699377617435`*^9},ExpressionUUID->"f72f0dc6-2d26-4caa-8838-\
171f7e7ce748"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"g", ",", "Transparent"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"h", ",", "Transparent"}], "]"}], ",", "c", ",", "e", ",", "d",
       ",", 
      RowBox[{"Style", "[", 
       RowBox[{"a", ",", "Transparent"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"f", ",", "Transparent"}], "]"}], ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"g", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.812714252897423*^9, 3.8127143877413654`*^9}, 
   3.8127144392663517`*^9, {3.8127146815519857`*^9, 3.8127147248383636`*^9}, {
   3.812714757600453*^9, 3.8127147706960335`*^9}, {3.812715065268671*^9, 
   3.8127151362301545`*^9}, {3.812715168649596*^9, 3.8127151758365564`*^9}, {
   3.812715295421069*^9, 3.8127153491715436`*^9}, {3.812736834235741*^9, 
   3.8127369492562466`*^9}, {3.812736987643506*^9, 3.812737040334783*^9}, {
   3.812737086577406*^9, 3.812737156370026*^9}, {3.8128839688774776`*^9, 
   3.812884130262419*^9}, {3.8128841648155603`*^9, 3.8128841937155*^9}, {
   3.8129699605589657`*^9, 3.812970046352188*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"e67654b7-0f2c-40a1-9654-02a2053ae3a4"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`g, $CellContext`h, $CellContext`c, $CellContext`e, \
$CellContext`d, $CellContext`a, $CellContext`f, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {5, 4}, {5, 6}, {3, 5}, {4, 2}, {3, 2}, {3, 7}, {
       6, 8}, {6, 3}, {8, 3}, {8, 5}, {8, 2}, {5, 7}, {4, 7}, {7, 1}, {6, 
       1}, {1, 5}}}, {
      EdgeStyle -> {UndirectedEdge[$CellContext`c, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`f, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`a] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`f] -> {
           GrayLevel[0, 0]}}, VertexLabels -> {"Name"}, 
       VertexStyle -> {$CellContext`h -> {
           GrayLevel[0, 0]}, $CellContext`g -> {
           GrayLevel[0, 0]}, $CellContext`a -> {
           GrayLevel[0, 0]}, $CellContext`f -> {
           GrayLevel[0, 0]}}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          0.9155675673146559, 0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {0., 
          1.2742458538578276`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {0.9159527799278495, 
          0.5572500897746695}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {0.0006266104084700075, 
          0.3437359969662383}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {1.8316926382890544`, 
          0.3423413528460884}}]}, 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {
         0.0006266104084700075, 0.3437359969662383}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {0., 
          1.2742458538578276`}}]}, 
        LineBox[{{0.9159527799278495, 0.5572500897746695}, {
         1.8316926382890544`, 0.3423413528460884}}], 
        LineBox[{{0.0006266104084700075, 0.3437359969662383}, {
         0.9167405909099433, 1.0604193987371016`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.0006266104084700075, 0.3437359969662383}, {0., 
          1.2742458538578276`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9167405909099433, 1.0604193987371016`}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9167405909099433, 1.0604193987371016`}, {0., 
          1.2742458538578276`}}]}, 
        LineBox[{{0.9167405909099433, 1.0604193987371016`}, {
         1.8316926382890544`, 0.3423413528460884}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.8335776041290726`, 1.2730728349552447`}, {
          1.8316926382890544`, 0.3423413528460884}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.917508195067925, 1.6166315833485299}, 
           0.021246659915075294]}, 
         InsetBox["g", 
          Offset[{2, 2}, {0.9387548549830003, 1.6378782432636052}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.9155675673146559, 0.}, 0.021246659915075294]}, 
         InsetBox["h", 
          Offset[{2, 2}, {0.9368142272297313, 0.021246659915075294}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9159527799278495, 0.5572500897746695}, 
          0.021246659915075294], 
         InsetBox["c", 
          Offset[{2, 2}, {0.9371994398429249, 0.5784967496897448}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0006266104084700075, 0.3437359969662383}, 
          0.021246659915075294], 
         InsetBox["e", 
          Offset[{2, 2}, {0.021873270323545302, 0.3649826568813136}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9167405909099433, 1.0604193987371016}, 
          0.021246659915075294], 
         InsetBox["d", 
          Offset[{2, 2}, {0.9379872508250187, 1.081666058652177}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.8335776041290726, 1.2730728349552447}, 
           0.021246659915075294]}, 
         InsetBox["a", Offset[{2, 2}, {1.854824264044148, 1.29431949487032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0., 1.2742458538578276}, 0.021246659915075294]}, 
         InsetBox["f", 
          Offset[{2, 2}, {0.021246659915075294, 1.295492513772903}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8316926382890544, 0.3423413528460884}, 
          0.021246659915075294], 
         InsetBox["b", 
          Offset[{2, 2}, {1.8529392982041297, 0.3635880127611637}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.812714341738451*^9, 3.812714388896782*^9}, 
   3.812714440442693*^9, {3.812714704857611*^9, 3.812714725198392*^9}, {
   3.8127147584551673`*^9, 3.8127147715263176`*^9}, 3.8127148834376993`*^9, 
   3.8127151050422554`*^9, 3.8127151373351755`*^9, {3.8127151695867014`*^9, 
   3.8127151766892667`*^9}, 3.812715350204957*^9, 3.812715543816053*^9, 
   3.812715830559408*^9, 3.8127349786308613`*^9, 3.812736950575758*^9, 
   3.812737041185376*^9, 3.812737087497497*^9, 3.812737157281872*^9, 
   3.8127393578517656`*^9, 3.812884076673604*^9, 3.812884132340345*^9, 
   3.812884194659029*^9, 3.8128865871619015`*^9, 3.8128867097555766`*^9, {
   3.8128869528288774`*^9, 3.8128869680371866`*^9}, 3.812889426074542*^9, {
   3.812970020306507*^9, 3.8129700471791906`*^9}, 3.812970400906911*^9, 
   3.8129705972833014`*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"8f212a15-9108-4bde-bfc6-0ca3bfad21fe"]
}, Open  ]],

Cell["Se toma d\[Rule]e\[Rule]c\[Rule]b\[Rule]d:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.8127141765942564`*^9, 
  3.8127141902733755`*^9}, {3.8127154197989492`*^9, 3.812715432217738*^9}, {
  3.8127372517819214`*^9, 3.8127372596636972`*^9}, {3.8128842407775607`*^9, 
  3.812884247459303*^9}, {3.812970056451024*^9, 
  3.8129700630658207`*^9}},ExpressionUUID->"235298d4-7de3-4df7-9f73-\
3f44066a76b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "c", ",", "b", ",", "d"}], "}"}], ",", "2", 
     ",", "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
  3.812714192752296*^9, 3.8127142146441393`*^9}, {3.812715439692197*^9, 
  3.8127154535930314`*^9}, {3.8127372620742874`*^9, 3.812737271588888*^9}, {
  3.812884252074582*^9, 3.812884258483596*^9}, {3.8128867127318096`*^9, 
  3.8128867305478477`*^9}, {3.812970085480543*^9, 3.8129700909431143`*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"e334e2f8-544d-4ffb-8a33-f9ee4178b14b"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`g, $CellContext`h, $CellContext`c, $CellContext`e, \
$CellContext`d, $CellContext`a, $CellContext`f, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {5, 4}, {5, 6}, {3, 5}, {4, 2}, {3, 2}, {3, 7}, {
       6, 8}, {6, 3}, {8, 3}, {8, 5}, {8, 2}, {5, 7}, {4, 7}, {7, 1}, {6, 
       1}, {1, 5}}}, {
      EdgeStyle -> {UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`a] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`f, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`b] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`f] -> {
           GrayLevel[0, 0]}}, GraphHighlight -> {
         UndirectedEdge[$CellContext`b, $CellContext`d], 
         UndirectedEdge[$CellContext`d, $CellContext`e], 
         UndirectedEdge[$CellContext`c, $CellContext`b], 
         UndirectedEdge[$CellContext`e, $CellContext`c]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}, VertexStyle -> {$CellContext`h -> {
           GrayLevel[0, 0]}, $CellContext`f -> {
           GrayLevel[0, 0]}, $CellContext`a -> {
           GrayLevel[0, 0]}, $CellContext`g -> {
           GrayLevel[0, 0]}}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          0.9155675673146559, 0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.917508195067925, 1.6166315833485299`}, {0., 
          1.2742458538578276`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {0.9159527799278495, 
          0.5572500897746695}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {0.0006266104084700075, 
          0.3437359969662383}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9155675673146559, 0.}, {1.8316926382890544`, 
          0.3423413528460884}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {
          0.0006266104084700075, 0.3437359969662383}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {0., 
          1.2742458538578276`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9159527799278495, 0.5572500897746695}, {
          1.8316926382890544`, 0.3423413528460884}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.0006266104084700075, 0.3437359969662383}, {
          0.9167405909099433, 1.0604193987371016`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.0006266104084700075, 0.3437359969662383}, {0., 
          1.2742458538578276`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9167405909099433, 1.0604193987371016`}, {
          1.8335776041290726`, 1.2730728349552447`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.9167405909099433, 1.0604193987371016`}, {0., 
          1.2742458538578276`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.9167405909099433, 1.0604193987371016`}, {
          1.8316926382890544`, 0.3423413528460884}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.8335776041290726`, 1.2730728349552447`}, {
          1.8316926382890544`, 0.3423413528460884}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.917508195067925, 1.6166315833485299}, 
           0.021246659915075294]}, 
         InsetBox["g", 
          Offset[{2, 2}, {0.9387548549830003, 1.6378782432636052}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.9155675673146559, 0.}, 0.021246659915075294]}, 
         InsetBox["h", 
          Offset[{2, 2}, {0.9368142272297313, 0.021246659915075294}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9159527799278495, 0.5572500897746695}, 
          0.021246659915075294], 
         InsetBox["c", 
          Offset[{2, 2}, {0.9371994398429249, 0.5784967496897448}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.0006266104084700075, 0.3437359969662383}, 
          0.021246659915075294], 
         InsetBox["e", 
          Offset[{2, 2}, {0.021873270323545302, 0.3649826568813136}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9167405909099433, 1.0604193987371016}, 
          0.021246659915075294], 
         InsetBox["d", 
          Offset[{2, 2}, {0.9379872508250187, 1.081666058652177}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.8335776041290726, 1.2730728349552447}, 
           0.021246659915075294]}, 
         InsetBox["a", Offset[{2, 2}, {1.854824264044148, 1.29431949487032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0., 1.2742458538578276}, 0.021246659915075294]}, 
         InsetBox["f", 
          Offset[{2, 2}, {0.021246659915075294, 1.295492513772903}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8316926382890544, 0.3423413528460884}, 
          0.021246659915075294], 
         InsetBox["b", 
          Offset[{2, 2}, {1.8529392982041297, 0.3635880127611637}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.812715454510084*^9, 3.8127158331979804`*^9, 3.8127349811954355`*^9, 
   3.8127372724725194`*^9, 3.8127393607477736`*^9, 3.8128842615627213`*^9, 
   3.812886731353657*^9, {3.8128869715591307`*^9, 3.8128869874407363`*^9}, 
   3.8128894297637835`*^9, 3.8129700934784822`*^9, 3.8129704040707884`*^9, 
   3.8129706003511705`*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"0eb715d9-cdcd-4033-9ca4-04d299edb8a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grafo", "=", 
   RowBox[{"Grafo", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "a"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "d"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AnimarGrafo", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "g", ",", "f", ",", "d", ",", "e", ",", "c", ",", "b", ",", "d", ",", 
       "a", ",", "c", ",", "f", ",", "e", ",", "h", ",", "b", ",", "a", ",", 
       "g", ",", "d", ",", "c", ",", "h"}], "}"}], ",", "2", ",", "1"}], 
    "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.812715892843811*^9, 3.8127159148912573`*^9}, {
   3.8127159505813856`*^9, 3.812715967767354*^9}, {3.812716015446836*^9, 
   3.8127160904179473`*^9}, {3.8127162466821785`*^9, 
   3.8127162841899023`*^9}, {3.8127187863887033`*^9, 3.812718815765614*^9}, {
   3.8127361869677687`*^9, 3.812736204982585*^9}, {3.8127373140466614`*^9, 
   3.812737430758148*^9}, {3.812737472475891*^9, 3.812737479091012*^9}, {
   3.812882986725561*^9, 3.8128830037581496`*^9}, {3.812884366739619*^9, 
   3.8128844599818425`*^9}, {3.812886744429389*^9, 3.812886873475515*^9}, {
   3.8129701437501383`*^9, 3.812970144695815*^9}, {3.8129701809473643`*^9, 
   3.8129702121515074`*^9}, {3.8129702638853827`*^9, 3.812970273646878*^9}, 
   3.8129703212167673`*^9},
 CellLabel->"In[81]:=",ExpressionUUID->"87ba7bbb-bda1-45c2-9e28-49efb834a4cb"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 16, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 17, 1}}, 
    Typeset`size$$ = {658., {207., 217.74064898208263`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 17, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{754., {309.75, 322.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.812884501862727*^9, 3.8128845042920437`*^9}, {
   3.8128868552859864`*^9, 3.8128868896996665`*^9}, {3.8128869917576265`*^9, 
   3.8128869935453367`*^9}, {3.81288943515261*^9, 3.812889444655631*^9}, {
   3.8129702165791225`*^9, 3.812970229107417*^9}, {3.812970271011687*^9, 
   3.812970276648093*^9}, {3.8129703223830996`*^9, 3.8129703257734137`*^9}, 
   3.8129704073648534`*^9, 3.8129705540912943`*^9, {3.812970603977425*^9, 
   3.812970606283643*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"f6cb1d3f-b150-4632-a469-d9ffa47e9074"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grafo", "=", 
   RowBox[{"Grafo", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "a"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "d"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RutaEuler", "[", "grafo", "]"}]}], "Input",
 CellChangeTimes->{{3.812889131322365*^9, 3.81288916916795*^9}, {
  3.8128892548719225`*^9, 3.812889266646962*^9}, {3.812968520897251*^9, 
  3.812968523526717*^9}, {3.812970437611047*^9, 3.8129704540297832`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"3d6d4e4c-19c9-4c4f-b343-101a6fafcb8d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"h", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "g"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8128891488087482`*^9, 3.812889169855649*^9}, 
   3.812889267321694*^9, {3.8128894382639847`*^9, 3.812889455613757*^9}, {
   3.812968524949273*^9, 3.8129685334388084`*^9}, {3.8129704208894167`*^9, 
   3.8129704550658216`*^9}, 3.8129706178062487`*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"3439243a-acd5-42a5-ab8a-dd0a50a24021"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5b722e3b-c217-4cfa-956d-068ac452995c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"12ea8779-2cc0-4aac-93ba-efc457e1f494"],
Cell[761, 25, 223, 3, 77, "Text",ExpressionUUID->"a515f0b1-8efd-46eb-8262-e4a40aa6e6bf"],
Cell[CellGroupData[{
Cell[1009, 32, 1319, 26, 335, "Input",ExpressionUUID->"8bc82546-b349-4b80-9ffb-3c9768db0bc7"],
Cell[2331, 60, 3677, 77, 508, "Output",ExpressionUUID->"8aaac784-e5ae-4edb-bd05-3c236dc16b7f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6045, 142, 215, 3, 91, "Input",ExpressionUUID->"adbfd6c6-440a-4ff1-a7be-dcf9bf407ac5"],
Cell[6263, 147, 3806, 119, 136, "Output",ExpressionUUID->"9ec83e9a-3517-4a5d-b7b1-9ae178195ee9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10106, 271, 1394, 28, 335, "Input",ExpressionUUID->"65b8b019-e204-4986-9ec1-8891a5e8d740"],
Cell[11503, 301, 3650, 77, 682, "Output",ExpressionUUID->"e7728b68-609e-4e53-9bf5-5e393edc2b19"]
}, Open  ]],
Cell[15168, 381, 587, 10, 77, "Text",ExpressionUUID->"19418e65-f960-47ae-b63e-bbd34ea7be60"],
Cell[CellGroupData[{
Cell[15780, 395, 898, 17, 216, "Input",ExpressionUUID->"104f45d3-526a-4d6d-8e97-9f502f113a5e"],
Cell[16681, 414, 6689, 131, 673, "Output",ExpressionUUID->"2f734798-36b8-4a27-a070-63de67f3bde3"]
}, Open  ]],
Cell[23385, 548, 438, 9, 128, "Text",ExpressionUUID->"154a7759-e011-4a6e-8dd5-434e4bb71d70"],
Cell[CellGroupData[{
Cell[23848, 561, 2848, 69, 1136, "Input",ExpressionUUID->"aa540334-9839-4822-87f7-bad4bc480058"],
Cell[26699, 632, 6756, 132, 682, "Output",ExpressionUUID->"237250b5-a146-433a-917e-47e1fb95bcbd"]
}, Open  ]],
Cell[33470, 767, 436, 6, 77, "Text",ExpressionUUID->"6297c55c-0545-4690-a11f-19250c03ee00"],
Cell[CellGroupData[{
Cell[33931, 777, 645, 13, 168, "Input",ExpressionUUID->"7409bd87-e20a-4a14-bb74-2588fa0b6bae"],
Cell[34579, 792, 7029, 138, 673, "Output",ExpressionUUID->"d073fb06-5d0e-46b4-947b-f2d9e2402dcb"]
}, Open  ]],
Cell[41623, 933, 293, 4, 77, "Text",ExpressionUUID->"f72f0dc6-2d26-4caa-8838-171f7e7ce748"],
Cell[CellGroupData[{
Cell[41941, 941, 3461, 87, 1620, "Input",ExpressionUUID->"e67654b7-0f2c-40a1-9654-02a2053ae3a4"],
Cell[45405, 1030, 7784, 149, 682, "Output",ExpressionUUID->"8f212a15-9108-4bde-bfc6-0ca3bfad21fe"]
}, Open  ]],
Cell[53204, 1182, 489, 7, 77, "Text",ExpressionUUID->"235298d4-7de3-4df7-9f73-3f44066a76b9"],
Cell[CellGroupData[{
Cell[53718, 1193, 697, 13, 168, "Input",ExpressionUUID->"e334e2f8-544d-4ffb-8a33-f9ee4178b14b"],
Cell[54418, 1208, 7871, 153, 673, "Output",ExpressionUUID->"0eb715d9-cdcd-4033-9ca4-04d299edb8a4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62326, 1366, 2485, 62, 432, "Input",ExpressionUUID->"87ba7bbb-bda1-45c2-9e28-49efb834a4cb"],
Cell[64814, 1430, 2732, 56, 652, "Print",ExpressionUUID->"f6cb1d3f-b150-4632-a469-d9ffa47e9074"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67583, 1491, 1604, 45, 194, "Input",ExpressionUUID->"3d6d4e4c-19c9-4c4f-b343-101a6fafcb8d"],
Cell[69190, 1538, 1407, 41, 220, "Output",ExpressionUUID->"3439243a-acd5-42a5-ab8a-dd0a50a24021"]
}, Open  ]]
}
]
*)

