(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     19516,        494]
NotebookOptionsPosition[     18200,        466]
NotebookOutlinePosition[     18634,        483]
CellTagsIndexPosition[     18591,        480]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8129932043593683`*^9, 3.8129932123022966`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"5510f48a-d966-4e0a-9acd-733ae3ada581"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "i"}], "}"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Sort", "[", 
  RowBox[{"Sort", "/@", 
   RowBox[{"AristasWolframSystemToCombinatorica", "[", 
    RowBox[{"EdgeList", "[", 
     RowBox[{"GraphComplement", "[", "grafo", "]"}], "]"}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Valencias", "[", "grafo", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CircuitoHamiltonQ", "[", "grafo", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ExisteCircuitoHamilton", "[", "grafo", "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQnRffLbE1440j89tpYNrLJ0UBRNsIWyuB6GMl7Wog
WufMSU0QzaLRoA+im8yuG4JoI/UvFiDazfWfLYg+skTjFIgWKXE7DaLnnjgp
tQ1I38raLg2ij7RsVwLRccVPVUB0xYeJ3SDaXfNsH4je/p71CIhuM7h5FESv
0J/8FURznbj3B0QXfX5Z/RBIN3g+rAHRKT4Jco+AdFdHHpjOOnvYAEQblYob
geh3k1iCQXSewPUQEN1g2TwZRD9zvw+mq/zfnwbRHw7suQKi71+Z6fAfSP+o
fe4EonUuFcWC6LY7FQkgGgC83aa0
  "],
 CellLabel->"In[67]:=",ExpressionUUID->"2a26978e-abd9-45c3-b1f4-73e69cba6f72"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`c, $CellContext`f, $CellContext`a, $CellContext`e, \
$CellContext`g, $CellContext`h, $CellContext`i, $CellContext`b, \
$CellContext`d}, {
      Null, {{1, 2}, {3, 4}, {3, 2}, {3, 5}, {3, 6}, {3, 7}, {8, 4}, {8, 2}, {
       8, 5}, {8, 6}, {8, 7}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {9, 4}, {9, 
       5}, {9, 7}}}, {ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQAmImKI77NG0Kw8Xf9jObY48k/3tor8Gd+eZPIItDvp2Y
6K209/bo8mc/yai2HXprzwAF6PLdYU7bKxa9st+7zq1f7c9DDP1z9NvWcwex
OBhVPKyyMzmEIX8rNKVA9Nhbe/2mmhNFvz9iuCfH/mlqtehv+y/3brHNkzuA
IS/zxGmrk8Rv+02BnCYXP2KqR3c/ujy6+9Hl0d2PLo/ufnT70N2HLg8DsuJr
m7/9wQxPdP3o8uj60d2Lrh/dvYTk0c0HAMUjCSo=
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.7385259441645284, 0.5623034320125156}, 
          0.026847755882059426], 
         InsetBox["c", 
          Offset[{2, 2}, {1.765373700046588, 0.5891511878945751}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.54003319449966, 0.981305161652882}, 0.026847755882059426],
          InsetBox["f", 
          Offset[{2, 2}, {2.5668809503817194, 1.0081529175349413}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6927446346562318, 0.12593436560359061}, 
          0.026847755882059426], 
         InsetBox["a", 
          Offset[{2, 2}, {1.7195923905382913, 0.15278212148565004}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9299956059326974, 0.}, 0.026847755882059426], 
         InsetBox["e", 
          Offset[{2, 2}, {0.9568433618147568, 0.026847755882059426}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8323329524307196, 0.5620301054345515}, 
          0.026847755882059426], 
         InsetBox["g", 
          Offset[{2, 2}, {0.859180708312779, 0.5888778613166109}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.5400613510918912, 0.14221936225925585}, 
          0.026847755882059426], 
         InsetBox["h", 
          Offset[{2, 2}, {2.5669091069739505, 0.16906711814131528}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9304301448016148, 1.1238887626169676}, 
          0.026847755882059426], 
         InsetBox["i", 
          Offset[{2, 2}, {0.9572779006836742, 1.150736518499027}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6934229927558198, 0.9982687012039178}, 
          0.026847755882059426], 
         InsetBox["b", 
          Offset[{2, 2}, {1.7202707486378792, 1.0251164570859772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.5621292659568301}, 0.026847755882059426], 
         InsetBox["d", 
          Offset[{2, 2}, {0.026847755882059426, 0.5889770218388896}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.8129933033783627`*^9, 3.8129933592356653`*^9, {3.8129934910745273`*^9, 
   3.812993520422681*^9}, 3.812994650943924*^9, 3.81299529416873*^9, {
   3.8129953512608624`*^9, 3.8129953682168846`*^9}, {3.8129961903748894`*^9, 
   3.812996214769841*^9}, {3.812996652820267*^9, 3.8129966552758665`*^9}, 
   3.8129970958102474`*^9, 3.813083371732126*^9, 3.813084135895444*^9, 
   3.8130854287731194`*^9, {3.813085594631634*^9, 3.813085617418677*^9}, 
   3.8130858632264*^9, 3.8130863692637815`*^9, 3.813086820902217*^9, {
   3.8130868531187334`*^9, 3.8130868867237453`*^9}, 3.8130914391113443`*^9, 
   3.813143692568627*^9, {3.813145102609758*^9, 3.813145116035298*^9}, 
   3.8131453356424103`*^9, 3.8131456527642207`*^9, 3.8131457790810623`*^9, 
   3.813148833217889*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"c79f1bbf-8e4e-4b62-bb0d-507a73415c7f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "i"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "i"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "i"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "i"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8129933033783627`*^9, 3.8129933592356653`*^9, {3.8129934910745273`*^9, 
   3.812993520422681*^9}, 3.812994650943924*^9, 3.81299529416873*^9, {
   3.8129953512608624`*^9, 3.8129953682168846`*^9}, {3.8129961903748894`*^9, 
   3.812996214769841*^9}, {3.812996652820267*^9, 3.8129966552758665`*^9}, 
   3.8129970958102474`*^9, 3.813083371732126*^9, 3.813084135895444*^9, 
   3.8130854287731194`*^9, {3.813085594631634*^9, 3.813085617418677*^9}, 
   3.8130858632264*^9, 3.8130863692637815`*^9, 3.813086820902217*^9, {
   3.8130868531187334`*^9, 3.8130868867237453`*^9}, 3.8130914391113443`*^9, 
   3.813143692568627*^9, {3.813145102609758*^9, 3.813145116035298*^9}, 
   3.8131453356424103`*^9, 3.8131456527642207`*^9, 3.8131457790810623`*^9, 
   3.8131488332499647`*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"dc61ecad-203e-4ff8-a133-2922e6186051"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["i",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox["\<\"Grado o valencia\"\>",
       HoldForm], "5", "3", "5", "4", "4", "3", "4", "5", "3"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{"Grado o valencia"}, {
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]], 
       Style[$CellContext`i, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]]}}, TableAlignments -> Center]]]], "Output",
 CellChangeTimes->{
  3.8129933033783627`*^9, 3.8129933592356653`*^9, {3.8129934910745273`*^9, 
   3.812993520422681*^9}, 3.812994650943924*^9, 3.81299529416873*^9, {
   3.8129953512608624`*^9, 3.8129953682168846`*^9}, {3.8129961903748894`*^9, 
   3.812996214769841*^9}, {3.812996652820267*^9, 3.8129966552758665`*^9}, 
   3.8129970958102474`*^9, 3.813083371732126*^9, 3.813084135895444*^9, 
   3.8130854287731194`*^9, {3.813085594631634*^9, 3.813085617418677*^9}, 
   3.8130858632264*^9, 3.8130863692637815`*^9, 3.813086820902217*^9, {
   3.8130868531187334`*^9, 3.8130868867237453`*^9}, 3.8130914391113443`*^9, 
   3.813143692568627*^9, {3.813145102609758*^9, 3.813145116035298*^9}, 
   3.8131453356424103`*^9, 3.8131456527642207`*^9, 3.8131457790810623`*^9, 
   3.813148833253959*^9},
 CellLabel->
  "Out[69]//TableForm=",ExpressionUUID->"04dccf68-74ee-4ed7-b547-\
86e9c23284dc"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.8129933033783627`*^9, 3.8129933592356653`*^9, {3.8129934910745273`*^9, 
   3.812993520422681*^9}, 3.812994650943924*^9, 3.81299529416873*^9, {
   3.8129953512608624`*^9, 3.8129953682168846`*^9}, {3.8129961903748894`*^9, 
   3.812996214769841*^9}, {3.812996652820267*^9, 3.8129966552758665`*^9}, 
   3.8129970958102474`*^9, 3.813083371732126*^9, 3.813084135895444*^9, 
   3.8130854287731194`*^9, {3.813085594631634*^9, 3.813085617418677*^9}, 
   3.8130858632264*^9, 3.8130863692637815`*^9, 3.813086820902217*^9, {
   3.8130868531187334`*^9, 3.8130868867237453`*^9}, 3.8130914391113443`*^9, 
   3.813143692568627*^9, {3.813145102609758*^9, 3.813145116035298*^9}, 
   3.8131453356424103`*^9, 3.8131456527642207`*^9, 3.8131457790810623`*^9, 
   3.813148833268614*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"9ae53915-eba2-410c-9ebe-c899cd88ec4b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"No se satisface la propiedad de Ore, un contraejemplo ocurre \
en: \"\>", "\[InvisibleSpace]", "\<\"Valencia[\"\>", "\[InvisibleSpace]", "c",
    "\[InvisibleSpace]", "\<\"] + \"\>", 
   "\[InvisibleSpace]", "\<\"Valencia[\"\>", "\[InvisibleSpace]", "d", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" < n = \"\>", "\[InvisibleSpace]", "9"}],
  SequenceForm[
  "No se satisface la propiedad de Ore, un contraejemplo ocurre en: ", 
   "Valencia[", $CellContext`c, "] + ", "Valencia[", $CellContext`d, "] = ", 
   8, " < n = ", 9],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8131451026591544`*^9, 3.8131451160687537`*^9}, 
   3.813145335751069*^9, 3.813145652822903*^9, 3.8131457791479297`*^9, 
   3.813148833268614*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"b668fc8a-4045-43e7-8c14-9daf950a7efc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"No se cumple la propiedad de Dirac, un contrajemplo ocurre en: \
\"\>", "\[InvisibleSpace]", "\<\"Valencia[\"\>", "\[InvisibleSpace]", "f", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" < \\!\\(\\*FractionBox[\\(n\\), \\(2\\)]\\) = \
\"\>", "\[InvisibleSpace]", 
   FractionBox["9", "2"]}],
  SequenceForm[
  "No se cumple la propiedad de Dirac, un contrajemplo ocurre en: ", 
   "Valencia[", $CellContext`f, "] = ", 3, 
   " < \!\(\*FractionBox[\(n\), \(2\)]\) = ", 
   Rational[9, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8131451026591544`*^9, 3.8131451160687537`*^9}, 
   3.813145335751069*^9, 3.813145652822903*^9, 3.8131457791479297`*^9, 
   3.813148833289447*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"3d397ae8-5800-4b14-b278-e033dc5bac79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"No se satisface la propiedad de la cantidad de aristas, m = \"\
\>", "\[InvisibleSpace]", "18", "\[InvisibleSpace]", "\<\" < \"\>", 
   "\[InvisibleSpace]", \
"\<\"\\!\\(\\*FractionBox[\\(\\*SuperscriptBox[\\(n\\), \\(2\\)] - 3  n + \
6\\), \\(2\\)]\\) = \"\>", "\[InvisibleSpace]", "30"}],
  SequenceForm[
  "No se satisface la propiedad de la cantidad de aristas, m = ", 18, " < ", 
   "\!\(\*FractionBox[\(\*SuperscriptBox[\(n\), \(2\)] - 3  n + 6\), \(2\)]\) \
= ", 30],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8131451026591544`*^9, 3.8131451160687537`*^9}, 
   3.813145335751069*^9, 3.813145652822903*^9, 3.8131457791479297`*^9, 
   3.813148833293442*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"db59cb7b-9f6a-4247-ab2d-0686f68ba821"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"No hay criterio, sin embargo, el valor l\[OAcute]gico sobre la \
existencia de un circuito de Hamilton en el grafo es: \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "No hay criterio, sin embargo, el valor l\[OAcute]gico sobre la existencia \
de un circuito de Hamilton en el grafo es: ", False],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8131451026591544`*^9, 3.8131451160687537`*^9}, 
   3.813145335751069*^9, 3.813145652822903*^9, 3.8131457791479297`*^9, 
   3.813148833293442*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"c61b4a04-ed07-4e04-96ac-c296b6335662"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"37156366-78ad-46e4-bd72-f7bf3cefe544"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 63, "Input",ExpressionUUID->"5510f48a-d966-4e0a-9acd-733ae3ada581"],
Cell[CellGroupData[{
Cell[785, 27, 2165, 58, 636, "Input",ExpressionUUID->"2a26978e-abd9-45c3-b1f4-73e69cba6f72"],
Cell[2953, 87, 4348, 90, 411, "Output",ExpressionUUID->"c79f1bbf-8e4e-4b62-bb0d-507a73415c7f"],
Cell[7304, 179, 1984, 51, 188, "Output",ExpressionUUID->"dc61ecad-203e-4ff8-a133-2922e6186051"],
Cell[9291, 232, 4586, 137, 136, "Output",ExpressionUUID->"04dccf68-74ee-4ed7-b547-86e9c23284dc"],
Cell[13880, 371, 899, 13, 100, "Output",ExpressionUUID->"9ae53915-eba2-410c-9ebe-c899cd88ec4b"],
Cell[CellGroupData[{
Cell[14804, 388, 944, 18, 131, "Print",ExpressionUUID->"b668fc8a-4045-43e7-8c14-9daf950a7efc"],
Cell[15751, 408, 903, 19, 155, "Print",ExpressionUUID->"3d397ae8-5800-4b14-b278-e033dc5bac79"],
Cell[16657, 429, 838, 17, 121, "Print",ExpressionUUID->"db59cb7b-9f6a-4247-ab2d-0686f68ba821"],
Cell[17498, 448, 674, 14, 131, "Print",ExpressionUUID->"c61b4a04-ed07-4e04-96ac-c296b6335662"]
}, Open  ]]
}, Open  ]]
}
]
*)

