(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     34254,        621]
NotebookOptionsPosition[     33108,        593]
NotebookOutlinePosition[     33534,        610]
CellTagsIndexPosition[     33491,        607]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8202311176947727`*^9, 3.8202311208363905`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],

Cell["\<\
S\[IAcute]mbolos no terminales:
S: real
A: real con signo
B: real sin signo
C: parte real
D: entero sin signo
E: parte decimal
F: d\[IAcute]gito

S\[IAcute]mbolos terminales: -, ., 0, 1, 2, 3, 4, 5, 6, 7, 8, 9\
\>", "Text",
 CellChangeTimes->{{3.8208233582661295`*^9, 3.8208234161885967`*^9}, {
   3.820823517637452*^9, 3.820823653446206*^9}, {3.82082376063741*^9, 
   3.82082376978568*^9}, {3.82082385095278*^9, 3.820823862899785*^9}, {
   3.820828334376898*^9, 3.8208284083807836`*^9}, 3.8208284652144313`*^9, {
   3.8208300190022206`*^9, 
   3.820830031929524*^9}},ExpressionUUID->"7937de1c-b276-4ee7-9222-\
9af6821b47af"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Prueba", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"bandera", "=", "0"}], ",", "i", ",", "real", ",", 
      "valorLogico", ",", "valorReal", ",", 
      RowBox[{"vectorReales", "=", 
       RowBox[{"{", "}"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "100"}], ",", 
       RowBox[{"i", "\[LessEqual]", 
        RowBox[{"100", "+", "n", "-", "1"}]}], ",", 
       RowBox[{
        RowBox[{"SeedRandom", "[", 
         RowBox[{"i", "+", 
          RowBox[{"RandomInteger", "[", "1000", "]"}]}], "]"}], ";", 
        RowBox[{"real", "=", 
         RowBox[{"Random", "[", 
          RowBox[{"Real", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1000"}], "}"}], ",", "5"}], "]"}]}], ";", 
        RowBox[{"vectorReales", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"vectorReales", ",", "real"}], "]"}]}], ";", 
        RowBox[{"valorLogico", "=", 
         RowBox[{"ElementoLenguajeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\"\<S->A|B\>\"", ",", "\"\<A->-C\>\"", ",", "\"\<B->C\>\"", ",", 
             "\"\<C->D|0E|DE\>\"", ",", "\"\<E->.D\>\"", ",", 
             "\"\<D->F|FD\>\"", ",", "\"\<F->0|1|2|3|4|5|6|7|8|9\>\""}], 
            "}"}], ",", 
           RowBox[{"ToString", "[", "real", "]"}]}], "]"}]}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"valorLogico", "\[Equal]", "False"}], ",", 
          RowBox[{
           RowBox[{"bandera", "=", "1"}], ";", 
           RowBox[{"valorReal", "=", "real"}], ";", 
           RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
        RowBox[{"i", "++"}]}]}], "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"bandera", "\[Equal]", "0"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<La prueba fue exitosa en: \>\"", ",", "vectorReales"}], 
        "]"}], ",", 
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<La prueba no fue exitosa en el n\[UAcute]mero real: \>\"", ",", 
         "valorReal"}], "]"}]}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Prueba", "[", "20", "]"}]}], "Input",
 CellChangeTimes->{3.8208349974213915`*^9, 3.8327689449092455`*^9},
 CellLabel->"In[19]:=",ExpressionUUID->"a08049df-f3f5-4e8f-8b7d-c6756f592850"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La prueba fue exitosa en: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "121.5439841616898775101`5.", ",", "484.0995722915977239609`5.", ",", 
     "613.4632029570639133453`5.", ",", "338.5467659682035446167`5.", ",", 
     "51.4561445452272891998`5.", ",", "903.7851579487323760986`5.", ",", 
     "600.9912621229887008667`5.", ",", "346.2919818703085184097`5.", ",", 
     "474.9857068527489900589`5.", ",", "590.029596816748380661`5.", ",", 
     "440.651400713250041008`5.", ",", "702.6998805813491344452`5.", ",", 
     "297.2930795513093471527`5.", ",", "475.9139346424490213394`5.", ",", 
     "613.1227926816791296005`5.", ",", "982.6272458303719758987`5.", ",", 
     "763.7638167943805456161`5.", ",", "295.5373816657811403275`5.", ",", 
     "737.7861312124878168106`5.", ",", "889.4320521503686904907`5."}], 
    "}"}]}],
  SequenceForm[
  "La prueba fue exitosa en: ", {
   121.5439841616898775101`5., 484.0995722915977239609`5., 
    613.4632029570639133453`5., 338.5467659682035446167`5., 
    51.4561445452272891998`5., 903.7851579487323760986`5., 
    600.9912621229887008667`5., 346.2919818703085184097`5., 
    474.9857068527489900589`5., 590.029596816748380661`5., 
    440.651400713250041008`5., 702.6998805813491344452`5., 
    297.2930795513093471527`5., 475.9139346424490213394`5., 
    613.1227926816791296005`5., 982.6272458303719758987`5., 
    763.7638167943805456161`5., 295.5373816657811403275`5., 
    737.7861312124878168106`5., 889.4320521503686904907`5.}],
  Editable->False]], "Print",
 CellChangeTimes->{3.820835049910779*^9, 3.8208351338688793`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[80]:=",ExpressionUUID->"f31caadb-d5ca-4f20-933a-07aebe7afa46"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ElementosLenguaje", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<S->A|B\>\"", ",", "\"\<A->-C\>\"", ",", "\"\<B->C\>\"", ",", 
     "\"\<C->D|0E|DE\>\"", ",", "\"\<E->.D\>\"", ",", "\"\<D->F|FD\>\"", ",", 
     "\"\<F->0|1|2|3|4|5|6|7|8|9\>\""}], "}"}], ",", "7", ",", "3"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ElementosLenguaje", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<S\[Rule]A|B\>\"", ",", "\"\<A\[Rule]-C\>\"", ",", 
     "\"\<B\[Rule]C\>\"", ",", "\"\<C\[Rule]D|0E|DE\>\"", ",", 
     "\"\<E\[Rule].D\>\"", ",", "\"\<D\[Rule]F|FD\>\"", ",", 
     "\"\<F\[Rule]0|1|2|3|4|5|6|7|8|9\>\""}], "}"}], ",", "7", ",", "3", ",", 
   RowBox[{"derivaciones", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.820823429587946*^9, 3.8208234917398224`*^9}, {
   3.820823572517356*^9, 3.8208235845986457`*^9}, {3.8208236772089405`*^9, 
   3.820823699395233*^9}, {3.8208237316601486`*^9, 3.8208237557800984`*^9}, {
   3.8208238086285315`*^9, 3.82082383725289*^9}, {3.820823959792466*^9, 
   3.8208239644928865`*^9}, {3.8208240045015917`*^9, 3.820824011158896*^9}, {
   3.8208241161432004`*^9, 3.8208241340992985`*^9}, {3.8208241652902756`*^9, 
   3.8208241803417063`*^9}, {3.8208242621176414`*^9, 3.820824287015196*^9}, {
   3.82082451843407*^9, 3.820824567479201*^9}, {3.820824682207261*^9, 
   3.820824693303362*^9}, {3.820825561183046*^9, 3.820825637074468*^9}, 
   3.8208256725816145`*^9, {3.8208336505358047`*^9, 3.8208336628884068`*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"e2de7402-a111-4019-bb3c-af00c70bdc59"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"-0\"\>", ",", "\<\"0\"\>", ",", "\<\"-00\"\>", 
   ",", "\<\"0.0\"\>", ",", "\<\"00\"\>", ",", "\<\"-01\"\>", 
   ",", "\<\"0.1\"\>", ",", "\<\"01\"\>", ",", "\<\"-02\"\>", 
   ",", "\<\"0.2\"\>", ",", "\<\"02\"\>", ",", "\<\"-03\"\>", 
   ",", "\<\"0.3\"\>", ",", "\<\"03\"\>", ",", "\<\"-04\"\>", 
   ",", "\<\"0.4\"\>", ",", "\<\"04\"\>", ",", "\<\"-05\"\>", 
   ",", "\<\"0.5\"\>", ",", "\<\"05\"\>", ",", "\<\"-06\"\>", 
   ",", "\<\"0.6\"\>", ",", "\<\"06\"\>", ",", "\<\"-07\"\>", 
   ",", "\<\"0.7\"\>", ",", "\<\"07\"\>", ",", "\<\"-08\"\>", 
   ",", "\<\"0.8\"\>", ",", "\<\"08\"\>", ",", "\<\"-09\"\>", 
   ",", "\<\"0.9\"\>", ",", "\<\"09\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>",
    ",", "\<\"-10\"\>", ",", "\<\"10\"\>", ",", "\<\"-11\"\>", 
   ",", "\<\"11\"\>", ",", "\<\"-12\"\>", ",", "\<\"12\"\>", 
   ",", "\<\"-13\"\>", ",", "\<\"13\"\>", ",", "\<\"-14\"\>", 
   ",", "\<\"14\"\>", ",", "\<\"-15\"\>", ",", "\<\"15\"\>", 
   ",", "\<\"-16\"\>", ",", "\<\"16\"\>", ",", "\<\"-17\"\>", 
   ",", "\<\"17\"\>", ",", "\<\"-18\"\>", ",", "\<\"18\"\>", 
   ",", "\<\"-19\"\>", ",", "\<\"19\"\>", ",", "\<\"-2\"\>", ",", "\<\"2\"\>",
    ",", "\<\"-20\"\>", ",", "\<\"20\"\>", ",", "\<\"-21\"\>", 
   ",", "\<\"21\"\>", ",", "\<\"-22\"\>", ",", "\<\"22\"\>", 
   ",", "\<\"-23\"\>", ",", "\<\"23\"\>", ",", "\<\"-24\"\>", 
   ",", "\<\"24\"\>", ",", "\<\"-25\"\>", ",", "\<\"25\"\>", 
   ",", "\<\"-26\"\>", ",", "\<\"26\"\>", ",", "\<\"-27\"\>", 
   ",", "\<\"27\"\>", ",", "\<\"-28\"\>", ",", "\<\"28\"\>", 
   ",", "\<\"-29\"\>", ",", "\<\"29\"\>", ",", "\<\"-3\"\>", ",", "\<\"3\"\>",
    ",", "\<\"-30\"\>", ",", "\<\"30\"\>", ",", "\<\"-31\"\>", 
   ",", "\<\"31\"\>", ",", "\<\"-32\"\>", ",", "\<\"32\"\>", 
   ",", "\<\"-33\"\>", ",", "\<\"33\"\>", ",", "\<\"-34\"\>", 
   ",", "\<\"34\"\>", ",", "\<\"-35\"\>", ",", "\<\"35\"\>", 
   ",", "\<\"-36\"\>", ",", "\<\"36\"\>", ",", "\<\"-37\"\>", 
   ",", "\<\"37\"\>", ",", "\<\"-38\"\>", ",", "\<\"38\"\>", 
   ",", "\<\"-39\"\>", ",", "\<\"39\"\>", ",", "\<\"-4\"\>", ",", "\<\"4\"\>",
    ",", "\<\"-40\"\>", ",", "\<\"40\"\>", ",", "\<\"-41\"\>", 
   ",", "\<\"41\"\>", ",", "\<\"-42\"\>", ",", "\<\"42\"\>", 
   ",", "\<\"-43\"\>", ",", "\<\"43\"\>", ",", "\<\"-44\"\>", 
   ",", "\<\"44\"\>", ",", "\<\"-45\"\>", ",", "\<\"45\"\>", 
   ",", "\<\"-46\"\>", ",", "\<\"46\"\>", ",", "\<\"-47\"\>", 
   ",", "\<\"47\"\>", ",", "\<\"-48\"\>", ",", "\<\"48\"\>", 
   ",", "\<\"-49\"\>", ",", "\<\"49\"\>", ",", "\<\"-5\"\>", ",", "\<\"5\"\>",
    ",", "\<\"-50\"\>", ",", "\<\"50\"\>", ",", "\<\"-51\"\>", 
   ",", "\<\"51\"\>", ",", "\<\"-52\"\>", ",", "\<\"52\"\>", 
   ",", "\<\"-53\"\>", ",", "\<\"53\"\>", ",", "\<\"-54\"\>", 
   ",", "\<\"54\"\>", ",", "\<\"-55\"\>", ",", "\<\"55\"\>", 
   ",", "\<\"-56\"\>", ",", "\<\"56\"\>", ",", "\<\"-57\"\>", 
   ",", "\<\"57\"\>", ",", "\<\"-58\"\>", ",", "\<\"58\"\>", 
   ",", "\<\"-59\"\>", ",", "\<\"59\"\>", ",", "\<\"-6\"\>", ",", "\<\"6\"\>",
    ",", "\<\"-60\"\>", ",", "\<\"60\"\>", ",", "\<\"-61\"\>", 
   ",", "\<\"61\"\>", ",", "\<\"-62\"\>", ",", "\<\"62\"\>", 
   ",", "\<\"-63\"\>", ",", "\<\"63\"\>", ",", "\<\"-64\"\>", 
   ",", "\<\"64\"\>", ",", "\<\"-65\"\>", ",", "\<\"65\"\>", 
   ",", "\<\"-66\"\>", ",", "\<\"66\"\>", ",", "\<\"-67\"\>", 
   ",", "\<\"67\"\>", ",", "\<\"-68\"\>", ",", "\<\"68\"\>", 
   ",", "\<\"-69\"\>", ",", "\<\"69\"\>", ",", "\<\"-7\"\>", ",", "\<\"7\"\>",
    ",", "\<\"-70\"\>", ",", "\<\"70\"\>", ",", "\<\"-71\"\>", 
   ",", "\<\"71\"\>", ",", "\<\"-72\"\>", ",", "\<\"72\"\>", 
   ",", "\<\"-73\"\>", ",", "\<\"73\"\>", ",", "\<\"-74\"\>", 
   ",", "\<\"74\"\>", ",", "\<\"-75\"\>", ",", "\<\"75\"\>", 
   ",", "\<\"-76\"\>", ",", "\<\"76\"\>", ",", "\<\"-77\"\>", 
   ",", "\<\"77\"\>", ",", "\<\"-78\"\>", ",", "\<\"78\"\>", 
   ",", "\<\"-79\"\>", ",", "\<\"79\"\>", ",", "\<\"-8\"\>", ",", "\<\"8\"\>",
    ",", "\<\"-80\"\>", ",", "\<\"80\"\>", ",", "\<\"-81\"\>", 
   ",", "\<\"81\"\>", ",", "\<\"-82\"\>", ",", "\<\"82\"\>", 
   ",", "\<\"-83\"\>", ",", "\<\"83\"\>", ",", "\<\"-84\"\>", 
   ",", "\<\"84\"\>", ",", "\<\"-85\"\>", ",", "\<\"85\"\>", 
   ",", "\<\"-86\"\>", ",", "\<\"86\"\>", ",", "\<\"-87\"\>", 
   ",", "\<\"87\"\>", ",", "\<\"-88\"\>", ",", "\<\"88\"\>", 
   ",", "\<\"-89\"\>", ",", "\<\"89\"\>", ",", "\<\"-9\"\>", ",", "\<\"9\"\>",
    ",", "\<\"-90\"\>", ",", "\<\"90\"\>", ",", "\<\"-91\"\>", 
   ",", "\<\"91\"\>", ",", "\<\"-92\"\>", ",", "\<\"92\"\>", 
   ",", "\<\"-93\"\>", ",", "\<\"93\"\>", ",", "\<\"-94\"\>", 
   ",", "\<\"94\"\>", ",", "\<\"-95\"\>", ",", "\<\"95\"\>", 
   ",", "\<\"-96\"\>", ",", "\<\"96\"\>", ",", "\<\"-97\"\>", 
   ",", "\<\"97\"\>", ",", "\<\"-98\"\>", ",", "\<\"98\"\>", 
   ",", "\<\"-99\"\>", ",", "\<\"99\"\>"}], "}"}]], "Print",
 CellChangeTimes->{{3.820823952526455*^9, 3.820823964990547*^9}, 
   3.8208240118448367`*^9, {3.8208241193663654`*^9, 3.8208241346142673`*^9}, {
   3.8208241668873205`*^9, 3.820824181465266*^9}, {3.820824263144058*^9, 
   3.8208242875308304`*^9}, 3.820824522228434*^9, 3.8208245685196395`*^9, 
   3.8208247164324675`*^9, {3.8208255643553295`*^9, 3.8208256375577617`*^9}, 
   3.8208352360436153`*^9, 3.8208361424043393`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"5e0eac92-801f-44b0-bba7-f8b69c1ba11a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"-C\"\>", ",", "\<\"C\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"-0E\"\>", ",", "\<\"0E\"\>", ",", "\<\"-D\"\>", 
     ",", "\<\"D\"\>", ",", "\<\"-DE\"\>", ",", "\<\"DE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"0.D\"\>", ",", "\<\"D.D\"\>", ",", "\<\"-F\"\>", 
     ",", "\<\"F\"\>", ",", "\<\"-FD\"\>", ",", "\<\"FD\"\>", 
     ",", "\<\"FDE\"\>", ",", "\<\"-FE\"\>", ",", "\<\"FE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"-0\"\>", ",", "\<\"0\"\>", ",", "\<\"-0D\"\>", 
     ",", "\<\"0D\"\>", ",", "\<\"0DE\"\>", ",", "\<\"-0E\"\>", 
     ",", "\<\"0E\"\>", ",", "\<\"0.F\"\>", ",", "\<\"-1\"\>", 
     ",", "\<\"1\"\>", ",", "\<\"-1D\"\>", ",", "\<\"1D\"\>", 
     ",", "\<\"1DE\"\>", ",", "\<\"-1E\"\>", ",", "\<\"1E\"\>", 
     ",", "\<\"-2\"\>", ",", "\<\"2\"\>", ",", "\<\"-2D\"\>", 
     ",", "\<\"2D\"\>", ",", "\<\"2DE\"\>", ",", "\<\"-2E\"\>", 
     ",", "\<\"2E\"\>", ",", "\<\"-3\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"-3D\"\>", ",", "\<\"3D\"\>", ",", "\<\"3DE\"\>", 
     ",", "\<\"-3E\"\>", ",", "\<\"3E\"\>", ",", "\<\"-4\"\>", 
     ",", "\<\"4\"\>", ",", "\<\"-4D\"\>", ",", "\<\"4D\"\>", 
     ",", "\<\"4DE\"\>", ",", "\<\"-4E\"\>", ",", "\<\"4E\"\>", 
     ",", "\<\"-5\"\>", ",", "\<\"5\"\>", ",", "\<\"-5D\"\>", 
     ",", "\<\"5D\"\>", ",", "\<\"5DE\"\>", ",", "\<\"-5E\"\>", 
     ",", "\<\"5E\"\>", ",", "\<\"-6\"\>", ",", "\<\"6\"\>", 
     ",", "\<\"-6D\"\>", ",", "\<\"6D\"\>", ",", "\<\"6DE\"\>", 
     ",", "\<\"-6E\"\>", ",", "\<\"6E\"\>", ",", "\<\"-7\"\>", 
     ",", "\<\"7\"\>", ",", "\<\"-7D\"\>", ",", "\<\"7D\"\>", 
     ",", "\<\"7DE\"\>", ",", "\<\"-7E\"\>", ",", "\<\"7E\"\>", 
     ",", "\<\"-8\"\>", ",", "\<\"8\"\>", ",", "\<\"-8D\"\>", 
     ",", "\<\"8D\"\>", ",", "\<\"8DE\"\>", ",", "\<\"-8E\"\>", 
     ",", "\<\"8E\"\>", ",", "\<\"-9\"\>", ",", "\<\"9\"\>", 
     ",", "\<\"-9D\"\>", ",", "\<\"9D\"\>", ",", "\<\"9DE\"\>", 
     ",", "\<\"-9E\"\>", ",", "\<\"9E\"\>", ",", "\<\"D.F\"\>", 
     ",", "\<\"F.D\"\>", ",", "\<\"-FF\"\>", ",", "\<\"FF\"\>", 
     ",", "\<\"FFD\"\>", ",", "\<\"FFE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"0.0\"\>", ",", "\<\"0.1\"\>", ",", "\<\"0.2\"\>", 
     ",", "\<\"0.3\"\>", ",", "\<\"0.4\"\>", ",", "\<\"0.5\"\>", 
     ",", "\<\"0.6\"\>", ",", "\<\"0.7\"\>", ",", "\<\"0.8\"\>", 
     ",", "\<\"0.9\"\>", ",", "\<\"0.D\"\>", ",", "\<\"-0F\"\>", 
     ",", "\<\"0F\"\>", ",", "\<\"0FD\"\>", ",", "\<\"0FE\"\>", 
     ",", "\<\"1.D\"\>", ",", "\<\"-1F\"\>", ",", "\<\"1F\"\>", 
     ",", "\<\"1FD\"\>", ",", "\<\"1FE\"\>", ",", "\<\"2.D\"\>", 
     ",", "\<\"-2F\"\>", ",", "\<\"2F\"\>", ",", "\<\"2FD\"\>", 
     ",", "\<\"2FE\"\>", ",", "\<\"3.D\"\>", ",", "\<\"-3F\"\>", 
     ",", "\<\"3F\"\>", ",", "\<\"3FD\"\>", ",", "\<\"3FE\"\>", 
     ",", "\<\"4.D\"\>", ",", "\<\"-4F\"\>", ",", "\<\"4F\"\>", 
     ",", "\<\"4FD\"\>", ",", "\<\"4FE\"\>", ",", "\<\"5.D\"\>", 
     ",", "\<\"-5F\"\>", ",", "\<\"5F\"\>", ",", "\<\"5FD\"\>", 
     ",", "\<\"5FE\"\>", ",", "\<\"6.D\"\>", ",", "\<\"-6F\"\>", 
     ",", "\<\"6F\"\>", ",", "\<\"6FD\"\>", ",", "\<\"6FE\"\>", 
     ",", "\<\"7.D\"\>", ",", "\<\"-7F\"\>", ",", "\<\"7F\"\>", 
     ",", "\<\"7FD\"\>", ",", "\<\"7FE\"\>", ",", "\<\"8.D\"\>", 
     ",", "\<\"-8F\"\>", ",", "\<\"8F\"\>", ",", "\<\"8FD\"\>", 
     ",", "\<\"8FE\"\>", ",", "\<\"9.D\"\>", ",", "\<\"-9F\"\>", 
     ",", "\<\"9F\"\>", ",", "\<\"9FD\"\>", ",", "\<\"9FE\"\>", 
     ",", "\<\"D.0\"\>", ",", "\<\"D.1\"\>", ",", "\<\"D.2\"\>", 
     ",", "\<\"D.3\"\>", ",", "\<\"D.4\"\>", ",", "\<\"D.5\"\>", 
     ",", "\<\"D.6\"\>", ",", "\<\"D.7\"\>", ",", "\<\"D.8\"\>", 
     ",", "\<\"D.9\"\>", ",", "\<\"-F0\"\>", ",", "\<\"F0\"\>", 
     ",", "\<\"F0D\"\>", ",", "\<\"F0E\"\>", ",", "\<\"-F1\"\>", 
     ",", "\<\"F1\"\>", ",", "\<\"F1D\"\>", ",", "\<\"F1E\"\>", 
     ",", "\<\"-F2\"\>", ",", "\<\"F2\"\>", ",", "\<\"F2D\"\>", 
     ",", "\<\"F2E\"\>", ",", "\<\"-F3\"\>", ",", "\<\"F3\"\>", 
     ",", "\<\"F3D\"\>", ",", "\<\"F3E\"\>", ",", "\<\"-F4\"\>", 
     ",", "\<\"F4\"\>", ",", "\<\"F4D\"\>", ",", "\<\"F4E\"\>", 
     ",", "\<\"-F5\"\>", ",", "\<\"F5\"\>", ",", "\<\"F5D\"\>", 
     ",", "\<\"F5E\"\>", ",", "\<\"-F6\"\>", ",", "\<\"F6\"\>", 
     ",", "\<\"F6D\"\>", ",", "\<\"F6E\"\>", ",", "\<\"-F7\"\>", 
     ",", "\<\"F7\"\>", ",", "\<\"F7D\"\>", ",", "\<\"F7E\"\>", 
     ",", "\<\"-F8\"\>", ",", "\<\"F8\"\>", ",", "\<\"F8D\"\>", 
     ",", "\<\"F8E\"\>", ",", "\<\"-F9\"\>", ",", "\<\"F9\"\>", 
     ",", "\<\"F9D\"\>", ",", "\<\"F9E\"\>", ",", "\<\"F.F\"\>", 
     ",", "\<\"FFF\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"-00\"\>", ",", "\<\"00\"\>", ",", "\<\"00D\"\>", 
     ",", "\<\"00E\"\>", ",", "\<\"-01\"\>", ",", "\<\"01\"\>", 
     ",", "\<\"01D\"\>", ",", "\<\"01E\"\>", ",", "\<\"-02\"\>", 
     ",", "\<\"02\"\>", ",", "\<\"02D\"\>", ",", "\<\"02E\"\>", 
     ",", "\<\"-03\"\>", ",", "\<\"03\"\>", ",", "\<\"03D\"\>", 
     ",", "\<\"03E\"\>", ",", "\<\"-04\"\>", ",", "\<\"04\"\>", 
     ",", "\<\"04D\"\>", ",", "\<\"04E\"\>", ",", "\<\"-05\"\>", 
     ",", "\<\"05\"\>", ",", "\<\"05D\"\>", ",", "\<\"05E\"\>", 
     ",", "\<\"-06\"\>", ",", "\<\"06\"\>", ",", "\<\"06D\"\>", 
     ",", "\<\"06E\"\>", ",", "\<\"-07\"\>", ",", "\<\"07\"\>", 
     ",", "\<\"07D\"\>", ",", "\<\"07E\"\>", ",", "\<\"-08\"\>", 
     ",", "\<\"08\"\>", ",", "\<\"08D\"\>", ",", "\<\"08E\"\>", 
     ",", "\<\"-09\"\>", ",", "\<\"09\"\>", ",", "\<\"09D\"\>", 
     ",", "\<\"09E\"\>", ",", "\<\"0.F\"\>", ",", "\<\"0FF\"\>", 
     ",", "\<\"-10\"\>", ",", "\<\"10\"\>", ",", "\<\"10D\"\>", 
     ",", "\<\"10E\"\>", ",", "\<\"-11\"\>", ",", "\<\"11\"\>", 
     ",", "\<\"11D\"\>", ",", "\<\"11E\"\>", ",", "\<\"-12\"\>", 
     ",", "\<\"12\"\>", ",", "\<\"12D\"\>", ",", "\<\"12E\"\>", 
     ",", "\<\"-13\"\>", ",", "\<\"13\"\>", ",", "\<\"13D\"\>", 
     ",", "\<\"13E\"\>", ",", "\<\"-14\"\>", ",", "\<\"14\"\>", 
     ",", "\<\"14D\"\>", ",", "\<\"14E\"\>", ",", "\<\"-15\"\>", 
     ",", "\<\"15\"\>", ",", "\<\"15D\"\>", ",", "\<\"15E\"\>", 
     ",", "\<\"-16\"\>", ",", "\<\"16\"\>", ",", "\<\"16D\"\>", 
     ",", "\<\"16E\"\>", ",", "\<\"-17\"\>", ",", "\<\"17\"\>", 
     ",", "\<\"17D\"\>", ",", "\<\"17E\"\>", ",", "\<\"-18\"\>", 
     ",", "\<\"18\"\>", ",", "\<\"18D\"\>", ",", "\<\"18E\"\>", 
     ",", "\<\"-19\"\>", ",", "\<\"19\"\>", ",", "\<\"19D\"\>", 
     ",", "\<\"19E\"\>", ",", "\<\"1.F\"\>", ",", "\<\"1FF\"\>", 
     ",", "\<\"-20\"\>", ",", "\<\"20\"\>", ",", "\<\"20D\"\>", 
     ",", "\<\"20E\"\>", ",", "\<\"-21\"\>", ",", "\<\"21\"\>", 
     ",", "\<\"21D\"\>", ",", "\<\"21E\"\>", ",", "\<\"-22\"\>", 
     ",", "\<\"22\"\>", ",", "\<\"22D\"\>", ",", "\<\"22E\"\>", 
     ",", "\<\"-23\"\>", ",", "\<\"23\"\>", ",", "\<\"23D\"\>", 
     ",", "\<\"23E\"\>", ",", "\<\"-24\"\>", ",", "\<\"24\"\>", 
     ",", "\<\"24D\"\>", ",", "\<\"24E\"\>", ",", "\<\"-25\"\>", 
     ",", "\<\"25\"\>", ",", "\<\"25D\"\>", ",", "\<\"25E\"\>", 
     ",", "\<\"-26\"\>", ",", "\<\"26\"\>", ",", "\<\"26D\"\>", 
     ",", "\<\"26E\"\>", ",", "\<\"-27\"\>", ",", "\<\"27\"\>", 
     ",", "\<\"27D\"\>", ",", "\<\"27E\"\>", ",", "\<\"-28\"\>", 
     ",", "\<\"28\"\>", ",", "\<\"28D\"\>", ",", "\<\"28E\"\>", 
     ",", "\<\"-29\"\>", ",", "\<\"29\"\>", ",", "\<\"29D\"\>", 
     ",", "\<\"29E\"\>", ",", "\<\"2.F\"\>", ",", "\<\"2FF\"\>", 
     ",", "\<\"-30\"\>", ",", "\<\"30\"\>", ",", "\<\"30D\"\>", 
     ",", "\<\"30E\"\>", ",", "\<\"-31\"\>", ",", "\<\"31\"\>", 
     ",", "\<\"31D\"\>", ",", "\<\"31E\"\>", ",", "\<\"-32\"\>", 
     ",", "\<\"32\"\>", ",", "\<\"32D\"\>", ",", "\<\"32E\"\>", 
     ",", "\<\"-33\"\>", ",", "\<\"33\"\>", ",", "\<\"33D\"\>", 
     ",", "\<\"33E\"\>", ",", "\<\"-34\"\>", ",", "\<\"34\"\>", 
     ",", "\<\"34D\"\>", ",", "\<\"34E\"\>", ",", "\<\"-35\"\>", 
     ",", "\<\"35\"\>", ",", "\<\"35D\"\>", ",", "\<\"35E\"\>", 
     ",", "\<\"-36\"\>", ",", "\<\"36\"\>", ",", "\<\"36D\"\>", 
     ",", "\<\"36E\"\>", ",", "\<\"-37\"\>", ",", "\<\"37\"\>", 
     ",", "\<\"37D\"\>", ",", "\<\"37E\"\>", ",", "\<\"-38\"\>", 
     ",", "\<\"38\"\>", ",", "\<\"38D\"\>", ",", "\<\"38E\"\>", 
     ",", "\<\"-39\"\>", ",", "\<\"39\"\>", ",", "\<\"39D\"\>", 
     ",", "\<\"39E\"\>", ",", "\<\"3.F\"\>", ",", "\<\"3FF\"\>", 
     ",", "\<\"-40\"\>", ",", "\<\"40\"\>", ",", "\<\"40D\"\>", 
     ",", "\<\"40E\"\>", ",", "\<\"-41\"\>", ",", "\<\"41\"\>", 
     ",", "\<\"41D\"\>", ",", "\<\"41E\"\>", ",", "\<\"-42\"\>", 
     ",", "\<\"42\"\>", ",", "\<\"42D\"\>", ",", "\<\"42E\"\>", 
     ",", "\<\"-43\"\>", ",", "\<\"43\"\>", ",", "\<\"43D\"\>", 
     ",", "\<\"43E\"\>", ",", "\<\"-44\"\>", ",", "\<\"44\"\>", 
     ",", "\<\"44D\"\>", ",", "\<\"44E\"\>", ",", "\<\"-45\"\>", 
     ",", "\<\"45\"\>", ",", "\<\"45D\"\>", ",", "\<\"45E\"\>", 
     ",", "\<\"-46\"\>", ",", "\<\"46\"\>", ",", "\<\"46D\"\>", 
     ",", "\<\"46E\"\>", ",", "\<\"-47\"\>", ",", "\<\"47\"\>", 
     ",", "\<\"47D\"\>", ",", "\<\"47E\"\>", ",", "\<\"-48\"\>", 
     ",", "\<\"48\"\>", ",", "\<\"48D\"\>", ",", "\<\"48E\"\>", 
     ",", "\<\"-49\"\>", ",", "\<\"49\"\>", ",", "\<\"49D\"\>", 
     ",", "\<\"49E\"\>", ",", "\<\"4.F\"\>", ",", "\<\"4FF\"\>", 
     ",", "\<\"-50\"\>", ",", "\<\"50\"\>", ",", "\<\"50D\"\>", 
     ",", "\<\"50E\"\>", ",", "\<\"-51\"\>", ",", "\<\"51\"\>", 
     ",", "\<\"51D\"\>", ",", "\<\"51E\"\>", ",", "\<\"-52\"\>", 
     ",", "\<\"52\"\>", ",", "\<\"52D\"\>", ",", "\<\"52E\"\>", 
     ",", "\<\"-53\"\>", ",", "\<\"53\"\>", ",", "\<\"53D\"\>", 
     ",", "\<\"53E\"\>", ",", "\<\"-54\"\>", ",", "\<\"54\"\>", 
     ",", "\<\"54D\"\>", ",", "\<\"54E\"\>", ",", "\<\"-55\"\>", 
     ",", "\<\"55\"\>", ",", "\<\"55D\"\>", ",", "\<\"55E\"\>", 
     ",", "\<\"-56\"\>", ",", "\<\"56\"\>", ",", "\<\"56D\"\>", 
     ",", "\<\"56E\"\>", ",", "\<\"-57\"\>", ",", "\<\"57\"\>", 
     ",", "\<\"57D\"\>", ",", "\<\"57E\"\>", ",", "\<\"-58\"\>", 
     ",", "\<\"58\"\>", ",", "\<\"58D\"\>", ",", "\<\"58E\"\>", 
     ",", "\<\"-59\"\>", ",", "\<\"59\"\>", ",", "\<\"59D\"\>", 
     ",", "\<\"59E\"\>", ",", "\<\"5.F\"\>", ",", "\<\"5FF\"\>", 
     ",", "\<\"-60\"\>", ",", "\<\"60\"\>", ",", "\<\"60D\"\>", 
     ",", "\<\"60E\"\>", ",", "\<\"-61\"\>", ",", "\<\"61\"\>", 
     ",", "\<\"61D\"\>", ",", "\<\"61E\"\>", ",", "\<\"-62\"\>", 
     ",", "\<\"62\"\>", ",", "\<\"62D\"\>", ",", "\<\"62E\"\>", 
     ",", "\<\"-63\"\>", ",", "\<\"63\"\>", ",", "\<\"63D\"\>", 
     ",", "\<\"63E\"\>", ",", "\<\"-64\"\>", ",", "\<\"64\"\>", 
     ",", "\<\"64D\"\>", ",", "\<\"64E\"\>", ",", "\<\"-65\"\>", 
     ",", "\<\"65\"\>", ",", "\<\"65D\"\>", ",", "\<\"65E\"\>", 
     ",", "\<\"-66\"\>", ",", "\<\"66\"\>", ",", "\<\"66D\"\>", 
     ",", "\<\"66E\"\>", ",", "\<\"-67\"\>", ",", "\<\"67\"\>", 
     ",", "\<\"67D\"\>", ",", "\<\"67E\"\>", ",", "\<\"-68\"\>", 
     ",", "\<\"68\"\>", ",", "\<\"68D\"\>", ",", "\<\"68E\"\>", 
     ",", "\<\"-69\"\>", ",", "\<\"69\"\>", ",", "\<\"69D\"\>", 
     ",", "\<\"69E\"\>", ",", "\<\"6.F\"\>", ",", "\<\"6FF\"\>", 
     ",", "\<\"-70\"\>", ",", "\<\"70\"\>", ",", "\<\"70D\"\>", 
     ",", "\<\"70E\"\>", ",", "\<\"-71\"\>", ",", "\<\"71\"\>", 
     ",", "\<\"71D\"\>", ",", "\<\"71E\"\>", ",", "\<\"-72\"\>", 
     ",", "\<\"72\"\>", ",", "\<\"72D\"\>", ",", "\<\"72E\"\>", 
     ",", "\<\"-73\"\>", ",", "\<\"73\"\>", ",", "\<\"73D\"\>", 
     ",", "\<\"73E\"\>", ",", "\<\"-74\"\>", ",", "\<\"74\"\>", 
     ",", "\<\"74D\"\>", ",", "\<\"74E\"\>", ",", "\<\"-75\"\>", 
     ",", "\<\"75\"\>", ",", "\<\"75D\"\>", ",", "\<\"75E\"\>", 
     ",", "\<\"-76\"\>", ",", "\<\"76\"\>", ",", "\<\"76D\"\>", 
     ",", "\<\"76E\"\>", ",", "\<\"-77\"\>", ",", "\<\"77\"\>", 
     ",", "\<\"77D\"\>", ",", "\<\"77E\"\>", ",", "\<\"-78\"\>", 
     ",", "\<\"78\"\>", ",", "\<\"78D\"\>", ",", "\<\"78E\"\>", 
     ",", "\<\"-79\"\>", ",", "\<\"79\"\>", ",", "\<\"79D\"\>", 
     ",", "\<\"79E\"\>", ",", "\<\"7.F\"\>", ",", "\<\"7FF\"\>", 
     ",", "\<\"-80\"\>", ",", "\<\"80\"\>", ",", "\<\"80D\"\>", 
     ",", "\<\"80E\"\>", ",", "\<\"-81\"\>", ",", "\<\"81\"\>", 
     ",", "\<\"81D\"\>", ",", "\<\"81E\"\>", ",", "\<\"-82\"\>", 
     ",", "\<\"82\"\>", ",", "\<\"82D\"\>", ",", "\<\"82E\"\>", 
     ",", "\<\"-83\"\>", ",", "\<\"83\"\>", ",", "\<\"83D\"\>", 
     ",", "\<\"83E\"\>", ",", "\<\"-84\"\>", ",", "\<\"84\"\>", 
     ",", "\<\"84D\"\>", ",", "\<\"84E\"\>", ",", "\<\"-85\"\>", 
     ",", "\<\"85\"\>", ",", "\<\"85D\"\>", ",", "\<\"85E\"\>", 
     ",", "\<\"-86\"\>", ",", "\<\"86\"\>", ",", "\<\"86D\"\>", 
     ",", "\<\"86E\"\>", ",", "\<\"-87\"\>", ",", "\<\"87\"\>", 
     ",", "\<\"87D\"\>", ",", "\<\"87E\"\>", ",", "\<\"-88\"\>", 
     ",", "\<\"88\"\>", ",", "\<\"88D\"\>", ",", "\<\"88E\"\>", 
     ",", "\<\"-89\"\>", ",", "\<\"89\"\>", ",", "\<\"89D\"\>", 
     ",", "\<\"89E\"\>", ",", "\<\"8.F\"\>", ",", "\<\"8FF\"\>", 
     ",", "\<\"-90\"\>", ",", "\<\"90\"\>", ",", "\<\"90D\"\>", 
     ",", "\<\"90E\"\>", ",", "\<\"-91\"\>", ",", "\<\"91\"\>", 
     ",", "\<\"91D\"\>", ",", "\<\"91E\"\>", ",", "\<\"-92\"\>", 
     ",", "\<\"92\"\>", ",", "\<\"92D\"\>", ",", "\<\"92E\"\>", 
     ",", "\<\"-93\"\>", ",", "\<\"93\"\>", ",", "\<\"93D\"\>", 
     ",", "\<\"93E\"\>", ",", "\<\"-94\"\>", ",", "\<\"94\"\>", 
     ",", "\<\"94D\"\>", ",", "\<\"94E\"\>", ",", "\<\"-95\"\>", 
     ",", "\<\"95\"\>", ",", "\<\"95D\"\>", ",", "\<\"95E\"\>", 
     ",", "\<\"-96\"\>", ",", "\<\"96\"\>", ",", "\<\"96D\"\>", 
     ",", "\<\"96E\"\>", ",", "\<\"-97\"\>", ",", "\<\"97\"\>", 
     ",", "\<\"97D\"\>", ",", "\<\"97E\"\>", ",", "\<\"-98\"\>", 
     ",", "\<\"98\"\>", ",", "\<\"98D\"\>", ",", "\<\"98E\"\>", 
     ",", "\<\"-99\"\>", ",", "\<\"99\"\>", ",", "\<\"99D\"\>", 
     ",", "\<\"99E\"\>", ",", "\<\"9.F\"\>", ",", "\<\"9FF\"\>", 
     ",", "\<\"F.0\"\>", ",", "\<\"F0F\"\>", ",", "\<\"F.1\"\>", 
     ",", "\<\"F1F\"\>", ",", "\<\"F.2\"\>", ",", "\<\"F2F\"\>", 
     ",", "\<\"F.3\"\>", ",", "\<\"F3F\"\>", ",", "\<\"F.4\"\>", 
     ",", "\<\"F4F\"\>", ",", "\<\"F.5\"\>", ",", "\<\"F5F\"\>", 
     ",", "\<\"F.6\"\>", ",", "\<\"F6F\"\>", ",", "\<\"F.7\"\>", 
     ",", "\<\"F7F\"\>", ",", "\<\"F.8\"\>", ",", "\<\"F8F\"\>", 
     ",", "\<\"F.9\"\>", ",", "\<\"F9F\"\>", ",", "\<\"FF0\"\>", 
     ",", "\<\"FF1\"\>", ",", "\<\"FF2\"\>", ",", "\<\"FF3\"\>", 
     ",", "\<\"FF4\"\>", ",", "\<\"FF5\"\>", ",", "\<\"FF6\"\>", 
     ",", "\<\"FF7\"\>", ",", "\<\"FF8\"\>", ",", "\<\"FF9\"\>"}], "}"}]}], 
  "}"}]], "Print",
 CellChangeTimes->{{3.820823952526455*^9, 3.820823964990547*^9}, 
   3.8208240118448367`*^9, {3.8208241193663654`*^9, 3.8208241346142673`*^9}, {
   3.8208241668873205`*^9, 3.820824181465266*^9}, {3.820824263144058*^9, 
   3.8208242875308304`*^9}, 3.820824522228434*^9, 3.8208245685196395`*^9, 
   3.8208247164324675`*^9, {3.8208255643553295`*^9, 3.8208256375577617`*^9}, 
   3.8208352360436153`*^9, 3.8208361424372516`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"c4b51e87-339b-4272-970b-a26ba129cfae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"-0\"\>", ",", "\<\"0\"\>", ",", "\<\"-00\"\>", 
   ",", "\<\"0.0\"\>", ",", "\<\"00\"\>", ",", "\<\"-01\"\>", 
   ",", "\<\"0.1\"\>", ",", "\<\"01\"\>", ",", "\<\"-02\"\>", 
   ",", "\<\"0.2\"\>", ",", "\<\"02\"\>", ",", "\<\"-03\"\>", 
   ",", "\<\"0.3\"\>", ",", "\<\"03\"\>", ",", "\<\"-04\"\>", 
   ",", "\<\"0.4\"\>", ",", "\<\"04\"\>", ",", "\<\"-05\"\>", 
   ",", "\<\"0.5\"\>", ",", "\<\"05\"\>", ",", "\<\"-06\"\>", 
   ",", "\<\"0.6\"\>", ",", "\<\"06\"\>", ",", "\<\"-07\"\>", 
   ",", "\<\"0.7\"\>", ",", "\<\"07\"\>", ",", "\<\"-08\"\>", 
   ",", "\<\"0.8\"\>", ",", "\<\"08\"\>", ",", "\<\"-09\"\>", 
   ",", "\<\"0.9\"\>", ",", "\<\"09\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>",
    ",", "\<\"-10\"\>", ",", "\<\"10\"\>", ",", "\<\"-11\"\>", 
   ",", "\<\"11\"\>", ",", "\<\"-12\"\>", ",", "\<\"12\"\>", 
   ",", "\<\"-13\"\>", ",", "\<\"13\"\>", ",", "\<\"-14\"\>", 
   ",", "\<\"14\"\>", ",", "\<\"-15\"\>", ",", "\<\"15\"\>", 
   ",", "\<\"-16\"\>", ",", "\<\"16\"\>", ",", "\<\"-17\"\>", 
   ",", "\<\"17\"\>", ",", "\<\"-18\"\>", ",", "\<\"18\"\>", 
   ",", "\<\"-19\"\>", ",", "\<\"19\"\>", ",", "\<\"-2\"\>", ",", "\<\"2\"\>",
    ",", "\<\"-20\"\>", ",", "\<\"20\"\>", ",", "\<\"-21\"\>", 
   ",", "\<\"21\"\>", ",", "\<\"-22\"\>", ",", "\<\"22\"\>", 
   ",", "\<\"-23\"\>", ",", "\<\"23\"\>", ",", "\<\"-24\"\>", 
   ",", "\<\"24\"\>", ",", "\<\"-25\"\>", ",", "\<\"25\"\>", 
   ",", "\<\"-26\"\>", ",", "\<\"26\"\>", ",", "\<\"-27\"\>", 
   ",", "\<\"27\"\>", ",", "\<\"-28\"\>", ",", "\<\"28\"\>", 
   ",", "\<\"-29\"\>", ",", "\<\"29\"\>", ",", "\<\"-3\"\>", ",", "\<\"3\"\>",
    ",", "\<\"-30\"\>", ",", "\<\"30\"\>", ",", "\<\"-31\"\>", 
   ",", "\<\"31\"\>", ",", "\<\"-32\"\>", ",", "\<\"32\"\>", 
   ",", "\<\"-33\"\>", ",", "\<\"33\"\>", ",", "\<\"-34\"\>", 
   ",", "\<\"34\"\>", ",", "\<\"-35\"\>", ",", "\<\"35\"\>", 
   ",", "\<\"-36\"\>", ",", "\<\"36\"\>", ",", "\<\"-37\"\>", 
   ",", "\<\"37\"\>", ",", "\<\"-38\"\>", ",", "\<\"38\"\>", 
   ",", "\<\"-39\"\>", ",", "\<\"39\"\>", ",", "\<\"-4\"\>", ",", "\<\"4\"\>",
    ",", "\<\"-40\"\>", ",", "\<\"40\"\>", ",", "\<\"-41\"\>", 
   ",", "\<\"41\"\>", ",", "\<\"-42\"\>", ",", "\<\"42\"\>", 
   ",", "\<\"-43\"\>", ",", "\<\"43\"\>", ",", "\<\"-44\"\>", 
   ",", "\<\"44\"\>", ",", "\<\"-45\"\>", ",", "\<\"45\"\>", 
   ",", "\<\"-46\"\>", ",", "\<\"46\"\>", ",", "\<\"-47\"\>", 
   ",", "\<\"47\"\>", ",", "\<\"-48\"\>", ",", "\<\"48\"\>", 
   ",", "\<\"-49\"\>", ",", "\<\"49\"\>", ",", "\<\"-5\"\>", ",", "\<\"5\"\>",
    ",", "\<\"-50\"\>", ",", "\<\"50\"\>", ",", "\<\"-51\"\>", 
   ",", "\<\"51\"\>", ",", "\<\"-52\"\>", ",", "\<\"52\"\>", 
   ",", "\<\"-53\"\>", ",", "\<\"53\"\>", ",", "\<\"-54\"\>", 
   ",", "\<\"54\"\>", ",", "\<\"-55\"\>", ",", "\<\"55\"\>", 
   ",", "\<\"-56\"\>", ",", "\<\"56\"\>", ",", "\<\"-57\"\>", 
   ",", "\<\"57\"\>", ",", "\<\"-58\"\>", ",", "\<\"58\"\>", 
   ",", "\<\"-59\"\>", ",", "\<\"59\"\>", ",", "\<\"-6\"\>", ",", "\<\"6\"\>",
    ",", "\<\"-60\"\>", ",", "\<\"60\"\>", ",", "\<\"-61\"\>", 
   ",", "\<\"61\"\>", ",", "\<\"-62\"\>", ",", "\<\"62\"\>", 
   ",", "\<\"-63\"\>", ",", "\<\"63\"\>", ",", "\<\"-64\"\>", 
   ",", "\<\"64\"\>", ",", "\<\"-65\"\>", ",", "\<\"65\"\>", 
   ",", "\<\"-66\"\>", ",", "\<\"66\"\>", ",", "\<\"-67\"\>", 
   ",", "\<\"67\"\>", ",", "\<\"-68\"\>", ",", "\<\"68\"\>", 
   ",", "\<\"-69\"\>", ",", "\<\"69\"\>", ",", "\<\"-7\"\>", ",", "\<\"7\"\>",
    ",", "\<\"-70\"\>", ",", "\<\"70\"\>", ",", "\<\"-71\"\>", 
   ",", "\<\"71\"\>", ",", "\<\"-72\"\>", ",", "\<\"72\"\>", 
   ",", "\<\"-73\"\>", ",", "\<\"73\"\>", ",", "\<\"-74\"\>", 
   ",", "\<\"74\"\>", ",", "\<\"-75\"\>", ",", "\<\"75\"\>", 
   ",", "\<\"-76\"\>", ",", "\<\"76\"\>", ",", "\<\"-77\"\>", 
   ",", "\<\"77\"\>", ",", "\<\"-78\"\>", ",", "\<\"78\"\>", 
   ",", "\<\"-79\"\>", ",", "\<\"79\"\>", ",", "\<\"-8\"\>", ",", "\<\"8\"\>",
    ",", "\<\"-80\"\>", ",", "\<\"80\"\>", ",", "\<\"-81\"\>", 
   ",", "\<\"81\"\>", ",", "\<\"-82\"\>", ",", "\<\"82\"\>", 
   ",", "\<\"-83\"\>", ",", "\<\"83\"\>", ",", "\<\"-84\"\>", 
   ",", "\<\"84\"\>", ",", "\<\"-85\"\>", ",", "\<\"85\"\>", 
   ",", "\<\"-86\"\>", ",", "\<\"86\"\>", ",", "\<\"-87\"\>", 
   ",", "\<\"87\"\>", ",", "\<\"-88\"\>", ",", "\<\"88\"\>", 
   ",", "\<\"-89\"\>", ",", "\<\"89\"\>", ",", "\<\"-9\"\>", ",", "\<\"9\"\>",
    ",", "\<\"-90\"\>", ",", "\<\"90\"\>", ",", "\<\"-91\"\>", 
   ",", "\<\"91\"\>", ",", "\<\"-92\"\>", ",", "\<\"92\"\>", 
   ",", "\<\"-93\"\>", ",", "\<\"93\"\>", ",", "\<\"-94\"\>", 
   ",", "\<\"94\"\>", ",", "\<\"-95\"\>", ",", "\<\"95\"\>", 
   ",", "\<\"-96\"\>", ",", "\<\"96\"\>", ",", "\<\"-97\"\>", 
   ",", "\<\"97\"\>", ",", "\<\"-98\"\>", ",", "\<\"98\"\>", 
   ",", "\<\"-99\"\>", ",", "\<\"99\"\>"}], "}"}]], "Print",
 CellChangeTimes->{{3.820823952526455*^9, 3.820823964990547*^9}, 
   3.8208240118448367`*^9, {3.8208241193663654`*^9, 3.8208241346142673`*^9}, {
   3.8208241668873205`*^9, 3.820824181465266*^9}, {3.820824263144058*^9, 
   3.8208242875308304`*^9}, 3.820824522228434*^9, 3.8208245685196395`*^9, 
   3.8208247164324675`*^9, {3.8208255643553295`*^9, 3.8208256375577617`*^9}, 
   3.8208352360436153`*^9, 3.8208361425136404`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[85]:=",ExpressionUUID->"94f48ff7-c7b6-42b8-a82b-d97fe2c6a71b"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{949, 467},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.3 para Microsoft Windows (64-bit) (May 11, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a8572f35-c064-47f4-a398-4a1b85c180ca"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 42, "Input",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],
Cell[763, 25, 635, 18, 363, "Text",ExpressionUUID->"7937de1c-b276-4ee7-9222-9af6821b47af"],
Cell[CellGroupData[{
Cell[1423, 47, 2396, 59, 662, "Input",ExpressionUUID->"a08049df-f3f5-4e8f-8b7d-c6756f592850"],
Cell[3822, 108, 1769, 32, 86, "Print",ExpressionUUID->"f31caadb-d5ca-4f20-933a-07aebe7afa46"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5628, 145, 1586, 28, 150, "Input",ExpressionUUID->"e2de7402-a111-4019-bb3c-af00c70bdc59"],
Cell[CellGroupData[{
Cell[7239, 177, 5355, 84, 350, "Print",ExpressionUUID->"5e0eac92-801f-44b0-bba7-f8b69c1ba11a"],
Cell[12597, 263, 15125, 240, 1084, "Print",ExpressionUUID->"c4b51e87-339b-4272-970b-a26ba129cfae"],
Cell[27725, 505, 5355, 84, 349, "Print",ExpressionUUID->"94f48ff7-c7b6-42b8-a82b-d97fe2c6a71b"]
}, Open  ]]
}, Open  ]]
}
]
*)

