(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     53551,       1169]
NotebookOptionsPosition[     51697,       1132]
NotebookOutlinePosition[     52128,       1149]
CellTagsIndexPosition[     52085,       1146]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8199749238028493`*^9, 3.819974935536437*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Permutations", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "a", ",", "b", ",", "b"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.820078742590602*^9, 3.820078753675356*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"66e0d67b-ebbc-4fd1-9b6b-03a9e29320bd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b", ",", "a", ",", "a"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.820078754433279*^9, 3.820081317821017*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"8551906f-5f2e-48c7-a112-9147d6062a76"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"], ",", 
       SubscriptBox["\[Sigma]", "3"], ",", 
       SubscriptBox["\[Sigma]", "4"], ",", 
       SubscriptBox["\[Sigma]", "5"], ",", 
       SubscriptBox["\[Sigma]", "6"], ",", 
       SubscriptBox["\[Sigma]", "7"], ",", 
       SubscriptBox["\[Sigma]", "8"], ",", 
       SubscriptBox["\[Sigma]", "9"], ",", 
       SubscriptBox["\[Sigma]", "10"], ",", 
       SubscriptBox["\[Sigma]", "11"], ",", 
       SubscriptBox["\[Sigma]", "12"], ",", 
       SubscriptBox["\[Sigma]", "13"], ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     SubscriptBox["\[Sigma]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "8"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "5"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "4"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "4"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "5"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "6"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "5"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "7"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "6"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "6"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "7"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "7"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "8"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "9"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "8"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "12"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "9"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "10"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "9"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "11"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "10"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "10"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "11"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "11"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "12"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "13"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "12"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "13"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "13"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "14"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "14"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "14"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox["\[Sigma]", "4"], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToDiagrama", "[", 
  RowBox[{"A", ",", 
   RowBox[{"forma", "\[Rule]", "\"\<rectangular\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Prueba", "[", 
   RowBox[{"automata_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "=", 
       RowBox[{"LenguajeStrings", "[", 
        RowBox[{"automata", ",", "n", ",", 
         RowBox[{"limite", "\[Rule]", "True"}]}], "]"}]}], ",", 
      RowBox[{"valorLogico", "=", "True"}]}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"n", "\[GreaterEqual]", "4"}], ",", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ToString", "[", "L", "]"}], "\[NotEqual]", 
          RowBox[{"ToString", "[", 
           RowBox[{"Permutations", "[", 
            RowBox[{"{", 
             RowBox[{"a", ",", "a", ",", "b", ",", "b"}], "}"}], "]"}], 
           "]"}]}], ",", 
         RowBox[{"valorLogico", "=", "False"}]}], "]"}], ";", "valorLogico"}],
       ",", 
      RowBox[{
      "Print", "[", "\"\<La longitud debe ser mayor o igual a 4\>\"", "]"}]}],
      "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Prueba", "[", 
  RowBox[{"A", ",", "20"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LenguajeCantidad", "[", 
  RowBox[{"A", ",", "20", ",", 
   RowBox[{"limite", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQvSg4bgF/2RvHustCS0A0D0/eGhD9OmzHThDdl3vu
OoiWiDW+CaI/Np1/CKLP57u8BdGX9I94CwDpFWc2+ILoG2y2JwWBdMqbrPMg
+l/U438getsVr/8g2sRo5iU9IO17S+UqiHbyUGXTB9Jl/6ZzgOi0hSeqQbSN
65cGEM3q5dsKolN8V3aA6KSq2mUg+ltSwwoQfe7Cmw0guqntw0awObKFu0G0
2M0DYPqFcdcZEK36eTaY3lIgcBFE/wg5cAlE39hadwNEsy2YAaZ9lLe+A9HL
3m/4DqI5ft9VtATSIQsTlUB0zvpDIdYg8/fLhYNoAFqdoSU=
  "],
 CellLabel->"In[3]:=",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.24999993750001562, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.24999993750001562, 0.7500000624999844}],
    PolygonBox[{{0.259218726152405, 0.5503440985410274}, {0.2597056492649322, 
    0.5362223344302566}, {0.2716919941748475, 0.5437049042707803}}], 
   CircleBox[{0.10593805954105559, 0.6250000937499767}, 0.17755551863944025, {
    5.759486531581288, 6.8067840827778845`}], 
   InsetBox["\<\"b\"\>", {0.28349357795855146, 0.6249912159740484}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   PolygonBox[{{0.44963544787663046`, 0.7592174379532824}, {
    0.46377766556974354`, 0.759705774264901}, {0.4562836450717349, 
    0.7717091258971774}}], 
   CircleBox[{0.37499990625002344, 0.6059381845410244}, 0.17755551863944025, {
    1.0471975511965976`, 2.0943951023931957`}], 
   InsetBox["\<\"a\"\>", {0.37499990625002344, 0.7834937031804647}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.49999987500003124, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "1"], {0.49999987500003124, 0.7500000624999844}],
    PolygonBox[{{0.7315968597579255, 0.30742133791193826`}, {
    0.7424818004943247, 0.2867388427877706}, {0.7549508963173021, 
    0.30650672554626424`}}], 
   CircleBox[{0.25678425979356, 0.3158882833098634}, 0.4865714653835777, {
    6.223141585057825, 7.2704391362544225`}], 
   InsetBox["\<\"b\"\>", {0.6919962685438067, 0.5334711373335603}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9507734418334679, 0.5349182854448726}, {0.9719421472227942, 
    0.5248802420267894}, {0.9700509951324823, 0.5482319003682161}}], 
   CircleBox[{0.5658944503489267, 0.2567812700240052}, 0.4865714653835777, {
    0.5835573866715225, 1.6307549378681205`}], 
   InsetBox["\<\"a\"\>", {0.7834925849884671, 0.6919856389438434}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.5000001249999688}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "2"], {0.9999997500000625, 0.5000001249999688}], 
   PolygonBox[{{0.9888154082023023, 0.705799780077151}, {1.0012267152991376`, 
    0.7125201498395989}, {1.0008410726878245`, 0.6984114577183455}}], 
   CircleBox[{1.148438763543332, 0.6149032660661394}, 0.1766364717318937, {
    2.556060636164041, 3.6032581873606384`}], 
   InsetBox["\<\"a\"\>", {0.9721409481339895, 0.6258359431301312}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7848951287956404, 0.04917524868511142}, {0.7748799295268675,
     0.028057852777205836`}, {0.7981757304792737, 0.029943133740437944`}}], 
   CircleBox[{0.5067834456760695, 0.43410835528694564}, 0.4865724357601586, {
    5.295838922580481, 6.343136473777079}], 
   InsetBox["\<\"b\"\>", {0.9419761819765917, 0.2164847869106373}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 2.499999375293882*^-7}, 
    0.03749999062500234], InsetBox[
    SubscriptBox["\[Sigma]", 
     "3"], {0.7499998125000469, 2.499999375293882*^-7}], 
   PolygonBox[{{0.963539985893699, 0.7076941767644744}, {0.991364809244333, 
    0.7135077743417954}, {0.9824871207583556, 0.6865039716756713}}], 
   CircleBox[{1.4595447715355934, 0.17143574824715102}, 0.7162643077561517, {
    2.283182294059769, 3.330379845256367}], 
   InsetBox["\<\"a\"\>", {0.783053017601199, 0.40679391238038437}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7214027067674661, 0.45252014924825684`}, {
    0.7402941007351302, 0.4637779155696811}, {0.7405979153755206, 
    0.44178860532007175`}}], 
   CircleBox[{1.1097744263013667, 0.2463013083460897}, 0.42873276719888864, {
    2.609596698242374, 3.6567942494389714`}], 
   InsetBox["\<\"b\"\>", {0.681056774550665, 0.24990141214745207}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Sigma]", "4"], {0.7499998125000469, 0.5000001249999688}], 
   PolygonBox[{{0.9642360305801884, 0.7228494731928928}, {0.9812497546875613, 
    0.7175241179770541}, {0.9681309997327824, 0.7054524782950088}}], 
   CircleBox[{1.0352560921320857, 0.44096974145337264}, 0.28177829522263553, {
    1.763652115370354, 2.8108496665669565`}], 
   InsetBox["\<\"b,a\"\>", {0.8502080436779307, 0.6534696883283859}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "5"], {0.7499998125000469, 0.2500001874999531}], 
   PolygonBox[{{0.9487058952842682, 0.25479092076403415`}, {
    0.9628205769933378, 0.2548949184845223}, {0.9556731714709246, 
    0.26706659255066406`}}], 
   CircleBox[{0.8703548678889567, 0.10436157391923828}, 0.17666407440792664, {
    1.0199618178760936`, 2.0671593690768137`}], 
   InsetBox["\<\"b\"\>", {0.8751658486693039, 0.2809601289822415}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5491660893420619, 0.013829573132095135`}, {
    0.5374998656250336, 2.499999375293882*^-7}, {
    0.55530952263314, -0.003188334539162712}}], 
   CircleBox[{0.44599353755550597, 0.2765546265236202}, 0.29130007080529674, {
    5.031829964125448, 6.079027515322045}], 
   InsetBox["\<\"a\"\>", {0.6634981544498473, 0.08278292353059627}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 2.499999375293882*^-7}, 
    0.03749999062500234], InsetBox[
    SubscriptBox["\[Sigma]", 
     "6"], {0.49999987500003124, 2.499999375293882*^-7}], 
   PolygonBox[{{0.949843924662694, 0.7196834736138616}, {0.9803361456565031, 
    0.7180690123904874}, {0.9636918707267315, 0.6924692050037266}}], 
   CircleBox[{1.3433290119165664, -0.024446778670945135}, 
    0.8264947192398037, {2.0254994557963464`, 3.072697006992944}], 
   InsetBox["\<\"a\"\>", {0.6577100728121078, 0.43709432596932246}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7187903755459366, 0.4630787786172202}, {0.7424818004943246, 
    0.4632614697121513}, {0.7307943031493862, 0.4426527483075294}}], 
   CircleBox[{0.9856981673183017, 0.02915336442514327}, 0.49759827990752936, {
    2.0814877452903344`, 3.1286852964869323`}], 
   InsetBox["\<\"b\"\>", {0.5580125623890783, 0.28349382818043356}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "7"], {0.9999997500000625, 0.2500001874999531}], 
   PolygonBox[{{0.9904276369255289, 0.7032347904053448}, {1.009705461764979, 
    0.7137778530696967}, {1.009197109446274, 0.6918112356968503}}], 
   CircleBox[{1.3702736365434744, 0.48318933909951434}, 0.4279958778283652, {
    2.5726240844806343`, 3.6198216356772326`}], 
   InsetBox["\<\"b\"\>", {0.9427181804040183, 0.5026007626293474}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7649166432466047, 0.4501622704144628}, {0.7687465601243512, 
    0.4675223056398901}, {0.7818658332012908, 0.45552548271666526`}}], 
   CircleBox[{1.0381073614485872, 0.5446817585824393}, 0.28019425845014767, {
    3.4205759763358117`, 4.46777352753241}], 
   InsetBox["\<\"a\"\>", {0.8434137911893401, 0.34317931152996356}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 0.5000001249999688}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "8"], {0.24999993750001562, 0.5000001249999688}],
    PolygonBox[{{0.44964954184284145`, 0.5091306273186809}, {
    0.46377766556974354`, 0.5097058367648855}, {0.45621545771338257`, 
    0.5216535460970901}}], 
   CircleBox[{0.3760811653738624, 0.3556310839803061}, 0.17728425082735796, {
    1.0533457920111444`, 2.100543343192718}], 
   InsetBox["\<\"b\"\>", {0.3749911859755387, 0.5329119840692012}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6924985663061327, 0.7316128179130906}, {0.7132611572122294, 
    0.7424820504942622}, {0.693466830224245, 0.7550283653767399}}], 
   CircleBox[{0.6830103224261534, 0.25654193086900645}, 0.48688079944341833, {
    1.5086243701932853`, 2.5558219213898816`}], 
   InsetBox["\<\"a\"\>", {0.4662382540239538, 0.6925038365755649}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "9"], {0.7499998125000469, 0.7500000624999844}], 
   PolygonBox[{{0.3026144027528395, 0.03358815930944813}, {0.2867717036454836,
     0.00735460322903111}, {0.31741197919640646`, 0.006751201377756318}}], 
   CircleBox[{-0.10608642894794196, 0.7473270351856599}, 0.8377927622035186, {
    5.200357064841606, 6.247554616038204}], 
   InsetBox["\<\"b\"\>", {0.6040804658028238, 0.3028501583960385}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.54530050238102, 0.2834368011954998}, {0.5355754897830218, 
    0.26185872576095}, {0.559125157573118, 0.2642256555162347}}], 
   CircleBox[{0.25247897327165336, 0.6728040538160002}, 0.49901873743492275, {
    5.315520229545349, 6.3628177807419455`}], 
   InsetBox["\<\"a\"\>", {0.7031096947158366, 0.4584406866054638}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", 
     "10"], {0.49999987500003124, 0.2500001874999531}], 
   PolygonBox[{{0.9394949522775049, 0.7413213921785595}, {0.9655524472538393, 
    0.7351800547272029}, {0.9472051455195845, 0.7156842708443902}}], 
   CircleBox[{1.137396754619811, 0.12353034097960247}, 0.635331282325695, {
    1.8446877477840473`, 2.8918852989806445`}], 
   InsetBox["\<\"a\"\>", {0.6827503620713382, 0.5673123776195188}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6956578470489609, 0.4967965510288679}, {0.7133248447033251, 
    0.4921773356007401}, {0.7004909879698313, 0.4791868745375245}}], 
   CircleBox[{0.7839179778000958, 0.2050939138382495}, 0.29563538606073275, {
    1.8119102247505208`, 2.8591077759471184`}], 
   InsetBox["\<\"b\"\>", {0.579240820324311, 0.41841888354154344}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 2.499999375293882*^-7}, 
    0.03749999062500234], InsetBox[
    SubscriptBox["\[Sigma]", 
     "11"], {0.24999993750001562, 2.499999375293882*^-7}], 
   PolygonBox[{{0.9391359768464592, 0.7338914099667976}, {0.9714608505279518, 
    0.7256735232106398}, {0.9481815149909493, 0.7017883048064232}}], 
   CircleBox[{1.2249617560360755, -0.2272673516796575}, 0.9860826639436086, {
    1.8307944694391365`, 2.8779920206357335`}], 
   InsetBox["\<\"b\"\>", {0.5289530945385338, 0.47125320152584704}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6962678093776637, 0.4823828272548197}, {0.722149753404724, 
    0.4748879067534203}, {0.7027179898376372, 0.4562209459773589}}], 
   CircleBox[{0.8648636756216203, -0.1526996612764433}, 0.643609679184651, {
    1.7943947177559691`, 2.8415922689525672`}], 
   InsetBox["\<\"a\"\>", {0.42747600949313974, 0.3194501546282653}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 0.5000001249999688}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", 
     "12"], {0.49999987500003124, 0.5000001249999688}], 
   PolygonBox[{{0.9438633181056898, 0.7501367605969758}, {0.9644241352170719, 
    0.7618586007609812}, {0.9439923153002513, 0.7738038706200012}}], 
   CircleBox[{0.9514700853081377, 0.2654648106865405}, 0.49656278780584356, {
    1.5447059309785587`, 2.591903482175156}], 
   InsetBox["\<\"b\"\>", {0.7144917265739459, 0.7018314681263131}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.2991661518420461, 0.2638295106321105}, {
    0.28749992812501796`, 0.2500001874999531}, {0.3053095851331241, 
    0.24681160296085297`}}], 
   CircleBox[{0.1959936000554901, 0.5265545640236358}, 0.29130007080529685, {
    5.031829964125448, 6.079027515322046}], 
   InsetBox["\<\"a\"\>", {0.41349821694983174, 0.33278286103061194}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", 
     "13"], {0.24999993750001562, 0.2500001874999531}], 
   PolygonBox[{{0.6939138907991671, 0.5000663065105994}, {0.7144241977170563, 
    0.5118586632609656}, {0.6939565637418057, 0.5237249317160902}}], 
   CircleBox[{0.7032849225879875, 0.015789978933184567}, 0.496193735370668, {
    1.548344993364233, 2.5955425445608293`}], 
   InsetBox["\<\"a\"\>", {0.46489747566561523, 0.45096769914750073}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9347816325068472, 0.7664692443255354}, {0.9626293365310613, 
    0.753114784643476}, {0.9371401831804758, 0.7356751953624661}}], 
   CircleBox[{1.013856552147154, -0.09084273717527536}, 0.8455108078872954, {
    1.6314207540760497`, 2.6786183052726478`}], 
   InsetBox["\<\"b\"\>", {0.5475137211490988, 0.6144323086266772}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "14"], {0.9999997500000625, 0.7500000624999844}],
    CircleBox[{1.0382187896079802, 0.7859938624289157}, 
    0.01874999531250117, {-1.8625712978927922`, 3.373416458090196}], 
   PolygonBox[{{1.0462681344027769`, 0.7777253830813199}, {
    1.0328253041636106`, 0.7680363392427915}, {1.0479376773857405`, 
    0.761239028676176}}], 
   InsetBox["\<\"b,a\"\>", {1.051073718154027, 0.772344205426088}, 
    ImageScaled[{0, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.24999993750001562`, 0.8250000437499891}, {
     0.24999993750001562`, 0.7875000531249867}}], 
    PolygonBox[{{0.24999993750001562`, 0.7875000531249867}, {
     0.23749994062501484`, 0.8062500484374879}, {0.2624999343750164, 
     0.8062500484374879}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.8200596444053893`*^9, 3.820059656895215*^9}, {
   3.8200597063954697`*^9, 3.8200597180995245`*^9}, 3.820060407501458*^9, 
   3.8200606130581503`*^9, {3.8200794042042274`*^9, 3.8200794124165916`*^9}, {
   3.8200810469366293`*^9, 3.820081059622508*^9}, 3.8200813205948143`*^9, 
   3.8200817676290617`*^9, 3.820082019470281*^9, 3.8200839048023386`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"a127f5af-6aa4-4c4e-b4ed-cccb95c340d0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.8200596444053893`*^9, 3.820059656895215*^9}, {
   3.8200597063954697`*^9, 3.8200597180995245`*^9}, 3.820060407501458*^9, 
   3.8200606130581503`*^9, {3.8200794042042274`*^9, 3.8200794124165916`*^9}, {
   3.8200810469366293`*^9, 3.820081059622508*^9}, 3.8200813205948143`*^9, 
   3.8200817676290617`*^9, 3.820082019470281*^9, 3.820083904804333*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"deff726b-9b83-4457-8146-90d4beb38ab8"],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{{3.8200596444053893`*^9, 3.820059656895215*^9}, {
   3.8200597063954697`*^9, 3.8200597180995245`*^9}, 3.820060407501458*^9, 
   3.8200606130581503`*^9, {3.8200794042042274`*^9, 3.8200794124165916`*^9}, {
   3.8200810469366293`*^9, 3.820081059622508*^9}, 3.8200813205948143`*^9, 
   3.8200817676290617`*^9, 3.820082019470281*^9, 3.820083904808322*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"c813e185-da25-4b66-849c-6de0f3f80d37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"AutomataExactamente", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "2"}], "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ComponentesAutomata", "[", "G", "]"}]}], "Input",
 CellChangeTimes->{{3.8200585299214935`*^9, 3.8200586702568684`*^9}, {
  3.820084414989066*^9, 3.820084463230218*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-044bcbd8951b"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.24999993750001562, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.24999993750001562, 0.7500000624999844}],
    PolygonBox[{{0.259218726152405, 0.5503440985410274}, {0.2597056492649322, 
    0.5362223344302566}, {0.2716919941748475, 0.5437049042707803}}], 
   CircleBox[{0.10593805954105559, 0.6250000937499767}, 0.17755551863944025, {
    5.759486531581288, 6.8067840827778845`}], 
   InsetBox["\<\"b\"\>", {0.28349357795855146, 0.6249912159740484}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   PolygonBox[{{0.44963544787663046`, 0.7592174379532824}, {
    0.46377766556974354`, 0.759705774264901}, {0.4562836450717349, 
    0.7717091258971774}}], 
   CircleBox[{0.37499990625002344, 0.6059381845410244}, 0.17755551863944025, {
    1.0471975511965976`, 2.0943951023931957`}], 
   InsetBox["\<\"a\"\>", {0.37499990625002344, 0.7834937031804647}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.49999987500003124, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "1"], {0.49999987500003124, 0.7500000624999844}],
    PolygonBox[{{0.7315968597579255, 0.30742133791193826`}, {
    0.7424818004943247, 0.2867388427877706}, {0.7549508963173021, 
    0.30650672554626424`}}], 
   CircleBox[{0.25678425979356, 0.3158882833098634}, 0.4865714653835777, {
    6.223141585057825, 7.2704391362544225`}], 
   InsetBox["\<\"b\"\>", {0.6919962685438067, 0.5334711373335603}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9507734418334679, 0.5349182854448726}, {0.9719421472227942, 
    0.5248802420267894}, {0.9700509951324823, 0.5482319003682161}}], 
   CircleBox[{0.5658944503489267, 0.2567812700240052}, 0.4865714653835777, {
    0.5835573866715225, 1.6307549378681205`}], 
   InsetBox["\<\"a\"\>", {0.7834925849884671, 0.6919856389438434}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.5000001249999688}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "2"], {0.9999997500000625, 0.5000001249999688}], 
   PolygonBox[{{0.9888154082023023, 0.705799780077151}, {1.0012267152991376`, 
    0.7125201498395989}, {1.0008410726878245`, 0.6984114577183455}}], 
   CircleBox[{1.148438763543332, 0.6149032660661394}, 0.1766364717318937, {
    2.556060636164041, 3.6032581873606384`}], 
   InsetBox["\<\"a\"\>", {0.9721409481339895, 0.6258359431301312}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7848951287956404, 0.04917524868511142}, {0.7748799295268675,
     0.028057852777205836`}, {0.7981757304792737, 0.029943133740437944`}}], 
   CircleBox[{0.5067834456760695, 0.43410835528694564}, 0.4865724357601586, {
    5.295838922580481, 6.343136473777079}], 
   InsetBox["\<\"b\"\>", {0.9419761819765917, 0.2164847869106373}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 2.499999375293882*^-7}, 
    0.03749999062500234], InsetBox[
    SubscriptBox["\[Sigma]", 
     "3"], {0.7499998125000469, 2.499999375293882*^-7}], 
   PolygonBox[{{0.963539985893699, 0.7076941767644744}, {0.991364809244333, 
    0.7135077743417954}, {0.9824871207583556, 0.6865039716756713}}], 
   CircleBox[{1.4595447715355934, 0.17143574824715102}, 0.7162643077561517, {
    2.283182294059769, 3.330379845256367}], 
   InsetBox["\<\"a\"\>", {0.783053017601199, 0.40679391238038437}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7214027067674661, 0.45252014924825684`}, {
    0.7402941007351302, 0.4637779155696811}, {0.7405979153755206, 
    0.44178860532007175`}}], 
   CircleBox[{1.1097744263013667, 0.2463013083460897}, 0.42873276719888864, {
    2.609596698242374, 3.6567942494389714`}], 
   InsetBox["\<\"b\"\>", {0.681056774550665, 0.24990141214745207}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Sigma]", "4"], {0.7499998125000469, 0.5000001249999688}], 
   PolygonBox[{{0.9642360305801884, 0.7228494731928928}, {0.9812497546875613, 
    0.7175241179770541}, {0.9681309997327824, 0.7054524782950088}}], 
   CircleBox[{1.0352560921320857, 0.44096974145337264}, 0.28177829522263553, {
    1.763652115370354, 2.8108496665669565`}], 
   InsetBox["\<\"b,a\"\>", {0.8502080436779307, 0.6534696883283859}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "5"], {0.7499998125000469, 0.2500001874999531}], 
   PolygonBox[{{0.9487058952842682, 0.25479092076403415`}, {
    0.9628205769933378, 0.2548949184845223}, {0.9556731714709246, 
    0.26706659255066406`}}], 
   CircleBox[{0.8703548678889567, 0.10436157391923828}, 0.17666407440792664, {
    1.0199618178760936`, 2.0671593690768137`}], 
   InsetBox["\<\"b\"\>", {0.8751658486693039, 0.2809601289822415}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5491660893420619, 0.013829573132095135`}, {
    0.5374998656250336, 2.499999375293882*^-7}, {
    0.55530952263314, -0.003188334539162712}}], 
   CircleBox[{0.44599353755550597, 0.2765546265236202}, 0.29130007080529674, {
    5.031829964125448, 6.079027515322045}], 
   InsetBox["\<\"a\"\>", {0.6634981544498473, 0.08278292353059627}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 2.499999375293882*^-7}, 
    0.03749999062500234], InsetBox[
    SubscriptBox["\[Sigma]", 
     "6"], {0.49999987500003124, 2.499999375293882*^-7}], 
   PolygonBox[{{0.949843924662694, 0.7196834736138616}, {0.9803361456565031, 
    0.7180690123904874}, {0.9636918707267315, 0.6924692050037266}}], 
   CircleBox[{1.3433290119165664, -0.024446778670945135}, 
    0.8264947192398037, {2.0254994557963464`, 3.072697006992944}], 
   InsetBox["\<\"a\"\>", {0.6577100728121078, 0.43709432596932246}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7187903755459366, 0.4630787786172202}, {0.7424818004943246, 
    0.4632614697121513}, {0.7307943031493862, 0.4426527483075294}}], 
   CircleBox[{0.9856981673183017, 0.02915336442514327}, 0.49759827990752936, {
    2.0814877452903344`, 3.1286852964869323`}], 
   InsetBox["\<\"b\"\>", {0.5580125623890783, 0.28349382818043356}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "7"], {0.9999997500000625, 0.2500001874999531}], 
   PolygonBox[{{0.9904276369255289, 0.7032347904053448}, {1.009705461764979, 
    0.7137778530696967}, {1.009197109446274, 0.6918112356968503}}], 
   CircleBox[{1.3702736365434744, 0.48318933909951434}, 0.4279958778283652, {
    2.5726240844806343`, 3.6198216356772326`}], 
   InsetBox["\<\"b\"\>", {0.9427181804040183, 0.5026007626293474}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7649166432466047, 0.4501622704144628}, {0.7687465601243512, 
    0.4675223056398901}, {0.7818658332012908, 0.45552548271666526`}}], 
   CircleBox[{1.0381073614485872, 0.5446817585824393}, 0.28019425845014767, {
    3.4205759763358117`, 4.46777352753241}], 
   InsetBox["\<\"a\"\>", {0.8434137911893401, 0.34317931152996356}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 0.5000001249999688}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "8"], {0.24999993750001562, 0.5000001249999688}],
    PolygonBox[{{0.44964954184284145`, 0.5091306273186809}, {
    0.46377766556974354`, 0.5097058367648855}, {0.45621545771338257`, 
    0.5216535460970901}}], 
   CircleBox[{0.3760811653738624, 0.3556310839803061}, 0.17728425082735796, {
    1.0533457920111444`, 2.100543343192718}], 
   InsetBox["\<\"b\"\>", {0.3749911859755387, 0.5329119840692012}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6924985663061327, 0.7316128179130906}, {0.7132611572122294, 
    0.7424820504942622}, {0.693466830224245, 0.7550283653767399}}], 
   CircleBox[{0.6830103224261534, 0.25654193086900645}, 0.48688079944341833, {
    1.5086243701932853`, 2.5558219213898816`}], 
   InsetBox["\<\"a\"\>", {0.4662382540239538, 0.6925038365755649}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "9"], {0.7499998125000469, 0.7500000624999844}], 
   PolygonBox[{{0.3026144027528395, 0.03358815930944813}, {0.2867717036454836,
     0.00735460322903111}, {0.31741197919640646`, 0.006751201377756318}}], 
   CircleBox[{-0.10608642894794196, 0.7473270351856599}, 0.8377927622035186, {
    5.200357064841606, 6.247554616038204}], 
   InsetBox["\<\"b\"\>", {0.6040804658028238, 0.3028501583960385}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.54530050238102, 0.2834368011954998}, {0.5355754897830218, 
    0.26185872576095}, {0.559125157573118, 0.2642256555162347}}], 
   CircleBox[{0.25247897327165336, 0.6728040538160002}, 0.49901873743492275, {
    5.315520229545349, 6.3628177807419455`}], 
   InsetBox["\<\"a\"\>", {0.7031096947158366, 0.4584406866054638}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", 
     "10"], {0.49999987500003124, 0.2500001874999531}], 
   PolygonBox[{{0.9394949522775049, 0.7413213921785595}, {0.9655524472538393, 
    0.7351800547272029}, {0.9472051455195845, 0.7156842708443902}}], 
   CircleBox[{1.137396754619811, 0.12353034097960247}, 0.635331282325695, {
    1.8446877477840473`, 2.8918852989806445`}], 
   InsetBox["\<\"a\"\>", {0.6827503620713382, 0.5673123776195188}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6956578470489609, 0.4967965510288679}, {0.7133248447033251, 
    0.4921773356007401}, {0.7004909879698313, 0.4791868745375245}}], 
   CircleBox[{0.7839179778000958, 0.2050939138382495}, 0.29563538606073275, {
    1.8119102247505208`, 2.8591077759471184`}], 
   InsetBox["\<\"b\"\>", {0.579240820324311, 0.41841888354154344}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 2.499999375293882*^-7}, 
    0.03749999062500234], InsetBox[
    SubscriptBox["\[Sigma]", 
     "11"], {0.24999993750001562, 2.499999375293882*^-7}], 
   PolygonBox[{{0.9391359768464592, 0.7338914099667976}, {0.9714608505279518, 
    0.7256735232106398}, {0.9481815149909493, 0.7017883048064232}}], 
   CircleBox[{1.2249617560360755, -0.2272673516796575}, 0.9860826639436086, {
    1.8307944694391365`, 2.8779920206357335`}], 
   InsetBox["\<\"b\"\>", {0.5289530945385338, 0.47125320152584704}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6962678093776637, 0.4823828272548197}, {0.722149753404724, 
    0.4748879067534203}, {0.7027179898376372, 0.4562209459773589}}], 
   CircleBox[{0.8648636756216203, -0.1526996612764433}, 0.643609679184651, {
    1.7943947177559691`, 2.8415922689525672`}], 
   InsetBox["\<\"a\"\>", {0.42747600949313974, 0.3194501546282653}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 0.5000001249999688}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", 
     "12"], {0.49999987500003124, 0.5000001249999688}], 
   PolygonBox[{{0.9438633181056898, 0.7501367605969758}, {0.9644241352170719, 
    0.7618586007609812}, {0.9439923153002513, 0.7738038706200012}}], 
   CircleBox[{0.9514700853081377, 0.2654648106865405}, 0.49656278780584356, {
    1.5447059309785587`, 2.591903482175156}], 
   InsetBox["\<\"b\"\>", {0.7144917265739459, 0.7018314681263131}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.2991661518420461, 0.2638295106321105}, {
    0.28749992812501796`, 0.2500001874999531}, {0.3053095851331241, 
    0.24681160296085297`}}], 
   CircleBox[{0.1959936000554901, 0.5265545640236358}, 0.29130007080529685, {
    5.031829964125448, 6.079027515322046}], 
   InsetBox["\<\"a\"\>", {0.41349821694983174, 0.33278286103061194}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", 
     "13"], {0.24999993750001562, 0.2500001874999531}], 
   PolygonBox[{{0.6939138907991671, 0.5000663065105994}, {0.7144241977170563, 
    0.5118586632609656}, {0.6939565637418057, 0.5237249317160902}}], 
   CircleBox[{0.7032849225879875, 0.015789978933184567}, 0.496193735370668, {
    1.548344993364233, 2.5955425445608293`}], 
   InsetBox["\<\"a\"\>", {0.46489747566561523, 0.45096769914750073}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9347816325068472, 0.7664692443255354}, {0.9626293365310613, 
    0.753114784643476}, {0.9371401831804758, 0.7356751953624661}}], 
   CircleBox[{1.013856552147154, -0.09084273717527536}, 0.8455108078872954, {
    1.6314207540760497`, 2.6786183052726478`}], 
   InsetBox["\<\"b\"\>", {0.5475137211490988, 0.6144323086266772}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Sigma]", "14"], {0.9999997500000625, 0.7500000624999844}],
    CircleBox[{1.0382187896079802, 0.7859938624289157}, 
    0.01874999531250117, {-1.8625712978927922`, 3.373416458090196}], 
   PolygonBox[{{1.0462681344027769`, 0.7777253830813199}, {
    1.0328253041636106`, 0.7680363392427915}, {1.0479376773857405`, 
    0.761239028676176}}], 
   InsetBox["\<\"b,a\"\>", {1.051073718154027, 0.772344205426088}, 
    ImageScaled[{0, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.24999993750001562`, 0.8250000437499891}, {
     0.24999993750001562`, 0.7875000531249867}}], 
    PolygonBox[{{0.24999993750001562`, 0.7875000531249867}, {
     0.23749994062501484`, 0.8062500484374879}, {0.2624999343750164, 
     0.8062500484374879}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.8200844572126465`*^9, 3.820084463978096*^9}},
 CellLabel->"Out[11]=",ExpressionUUID->"ba89da73-b7b0-42e7-88eb-6118097b4728"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"], ",", 
     SubscriptBox["\[Sigma]", "4"], ",", 
     SubscriptBox["\[Sigma]", "5"], ",", 
     SubscriptBox["\[Sigma]", "6"], ",", 
     SubscriptBox["\[Sigma]", "7"], ",", 
     SubscriptBox["\[Sigma]", "8"], ",", 
     SubscriptBox["\[Sigma]", "9"], ",", 
     SubscriptBox["\[Sigma]", "10"], ",", 
     SubscriptBox["\[Sigma]", "11"], ",", 
     SubscriptBox["\[Sigma]", "12"], ",", 
     SubscriptBox["\[Sigma]", "13"], ",", 
     SubscriptBox["\[Sigma]", "14"]}], "}"}]}],
  SequenceForm["Estados: ", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2], 
    Subscript[$CellContext`\[Sigma], 3], 
    Subscript[$CellContext`\[Sigma], 4], 
    Subscript[$CellContext`\[Sigma], 5], 
    Subscript[$CellContext`\[Sigma], 6], 
    Subscript[$CellContext`\[Sigma], 7], 
    Subscript[$CellContext`\[Sigma], 8], 
    Subscript[$CellContext`\[Sigma], 9], 
    Subscript[$CellContext`\[Sigma], 10], 
    Subscript[$CellContext`\[Sigma], 11], 
    Subscript[$CellContext`\[Sigma], 12], 
    Subscript[$CellContext`\[Sigma], 13], 
    Subscript[$CellContext`\[Sigma], 14]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.820084463993056*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"d1b3e512-4e9a-4a4d-ac07-b94ce0ba17a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos de entrada: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}],
  SequenceForm[
  "S\[IAcute]mbolos de entrada: ", {$CellContext`a, $CellContext`b}],
  Editable->False]], "Print",
 CellChangeTimes->{3.820084464013002*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"11f8314c-b572-4f3e-b1a8-4b55379b71d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", 
   SubscriptBox["\[Sigma]", "0"]}],
  SequenceForm["Estado inicial: ", 
   Subscript[$CellContext`\[Sigma], 0]],
  Editable->False]], "Print",
 CellChangeTimes->{3.820084464015994*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"234b27fb-3967-485d-b73e-43dafa211afd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "4"], "}"}]}],
  SequenceForm["Estados aceptados: ", {
    Subscript[$CellContext`\[Sigma], 4]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8200844640169916`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"687cb95d-9c38-42ec-90e2-c07714c7798c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "a", "b"},
     {
      SubscriptBox["\[Sigma]", "0"], 
      SubscriptBox["\[Sigma]", "1"], 
      SubscriptBox["\[Sigma]", "8"]},
     {
      SubscriptBox["\[Sigma]", "1"], 
      SubscriptBox["\[Sigma]", "2"], 
      SubscriptBox["\[Sigma]", "5"]},
     {
      SubscriptBox["\[Sigma]", "2"], 
      SubscriptBox["\[Sigma]", "14"], 
      SubscriptBox["\[Sigma]", "3"]},
     {
      SubscriptBox["\[Sigma]", "3"], 
      SubscriptBox["\[Sigma]", "14"], 
      SubscriptBox["\[Sigma]", "4"]},
     {
      SubscriptBox["\[Sigma]", "4"], 
      SubscriptBox["\[Sigma]", "14"], 
      SubscriptBox["\[Sigma]", "14"]},
     {
      SubscriptBox["\[Sigma]", "5"], 
      SubscriptBox["\[Sigma]", "6"], 
      SubscriptBox["\[Sigma]", "7"]},
     {
      SubscriptBox["\[Sigma]", "6"], 
      SubscriptBox["\[Sigma]", "14"], 
      SubscriptBox["\[Sigma]", "4"]},
     {
      SubscriptBox["\[Sigma]", "7"], 
      SubscriptBox["\[Sigma]", "4"], 
      SubscriptBox["\[Sigma]", "14"]},
     {
      SubscriptBox["\[Sigma]", "8"], 
      SubscriptBox["\[Sigma]", "9"], 
      SubscriptBox["\[Sigma]", "12"]},
     {
      SubscriptBox["\[Sigma]", "9"], 
      SubscriptBox["\[Sigma]", "10"], 
      SubscriptBox["\[Sigma]", "11"]},
     {
      SubscriptBox["\[Sigma]", "10"], 
      SubscriptBox["\[Sigma]", "14"], 
      SubscriptBox["\[Sigma]", "4"]},
     {
      SubscriptBox["\[Sigma]", "11"], 
      SubscriptBox["\[Sigma]", "4"], 
      SubscriptBox["\[Sigma]", "14"]},
     {
      SubscriptBox["\[Sigma]", "12"], 
      SubscriptBox["\[Sigma]", "13"], 
      SubscriptBox["\[Sigma]", "14"]},
     {
      SubscriptBox["\[Sigma]", "13"], 
      SubscriptBox["\[Sigma]", "4"], 
      SubscriptBox["\[Sigma]", "14"]},
     {
      SubscriptBox["\[Sigma]", "14"], 
      SubscriptBox["\[Sigma]", "14"], 
      SubscriptBox["\[Sigma]", "14"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.8200844640189857`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"2ee9d6eb-3092-4994-826f-600f88ead0b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Funci\[OAcute]n de transici\[OAcute]n de estados con otro \
formato: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "8"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "4"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "4"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "5"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "6"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "5"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "7"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "6"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "6"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "7"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "7"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "8"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "9"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "8"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "12"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "9"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "10"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "9"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "11"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "10"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "10"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "11"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "11"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "12"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "13"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "12"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "13"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "13"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "14"], ",", "a", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "14"], ",", "b", ",", 
       SubscriptBox["\[Sigma]", "14"]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Funci\[OAcute]n de transici\[OAcute]n de estados con otro formato: ", {{
     Subscript[$CellContext`\[Sigma], 0], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 1]}, {
     Subscript[$CellContext`\[Sigma], 0], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 8]}, {
     Subscript[$CellContext`\[Sigma], 1], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 2]}, {
     Subscript[$CellContext`\[Sigma], 1], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 5]}, {
     Subscript[$CellContext`\[Sigma], 2], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 2], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 3]}, {
     Subscript[$CellContext`\[Sigma], 3], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 3], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 4]}, {
     Subscript[$CellContext`\[Sigma], 4], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 4], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 5], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 6]}, {
     Subscript[$CellContext`\[Sigma], 5], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 7]}, {
     Subscript[$CellContext`\[Sigma], 6], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 6], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 4]}, {
     Subscript[$CellContext`\[Sigma], 7], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 4]}, {
     Subscript[$CellContext`\[Sigma], 7], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 8], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 9]}, {
     Subscript[$CellContext`\[Sigma], 8], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 12]}, {
     Subscript[$CellContext`\[Sigma], 9], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 10]}, {
     Subscript[$CellContext`\[Sigma], 9], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 11]}, {
     Subscript[$CellContext`\[Sigma], 10], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 10], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 4]}, {
     Subscript[$CellContext`\[Sigma], 11], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 4]}, {
     Subscript[$CellContext`\[Sigma], 11], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 12], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 13]}, {
     Subscript[$CellContext`\[Sigma], 12], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 13], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 4]}, {
     Subscript[$CellContext`\[Sigma], 13], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 14], $CellContext`a, 
     Subscript[$CellContext`\[Sigma], 14]}, {
     Subscript[$CellContext`\[Sigma], 14], $CellContext`b, 
     Subscript[$CellContext`\[Sigma], 14]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.82008446402497*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"c1201a20-d9f1-4575-a4b3-9d1aed1f0805"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{949, 467},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5ba469ff-2b55-4c5e-872e-231d8c1374f3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 42, "Input",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],
Cell[CellGroupData[{
Cell[783, 27, 281, 6, 65, "Input",ExpressionUUID->"66e0d67b-ebbc-4fd1-9b6b-03a9e29320bd"],
Cell[1067, 35, 674, 17, 48, "Output",ExpressionUUID->"8551906f-5f2e-48c7-a112-9147d6062a76"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1778, 57, 7440, 197, 596, "Input",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],
Cell[9221, 256, 14003, 243, 569, "Output",ExpressionUUID->"a127f5af-6aa4-4c4e-b4ed-cccb95c340d0"],
Cell[23227, 501, 479, 6, 48, "Output",ExpressionUUID->"deff726b-9b83-4457-8146-90d4beb38ab8"],
Cell[23709, 509, 476, 6, 48, "Output",ExpressionUUID->"c813e185-da25-4b66-849c-6de0f3f80d37"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24222, 520, 494, 11, 72, "Input",ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-044bcbd8951b"],
Cell[24719, 533, 13700, 239, 569, "Output",ExpressionUUID->"ba89da73-b7b0-42e7-88eb-6118097b4728"],
Cell[CellGroupData[{
Cell[38444, 776, 1611, 40, 33, "Print",ExpressionUUID->"d1b3e512-4e9a-4a4d-ac07-b94ce0ba17a0"],
Cell[40058, 818, 436, 11, 33, "Print",ExpressionUUID->"11f8314c-b572-4f3e-b1a8-4b55379b71d0"],
Cell[40497, 831, 395, 10, 33, "Print",ExpressionUUID->"234b27fb-3967-485d-b73e-43dafa211afd"],
Cell[40895, 843, 431, 11, 33, "Print",ExpressionUUID->"687cb95d-9c38-42ec-90e2-c07714c7798c"],
Cell[41329, 856, 2474, 78, 378, "Print",ExpressionUUID->"2ee9d6eb-3092-4994-826f-600f88ead0b9"],
Cell[43806, 936, 7863, 192, 191, "Print",ExpressionUUID->"c1201a20-d9f1-4575-a4b3-9d1aed1f0805"]
}, Open  ]]
}, Open  ]]
}
]
*)

