(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     52682,       1201]
NotebookOptionsPosition[     49387,       1150]
NotebookOutlinePosition[     49871,       1168]
CellTagsIndexPosition[     49828,       1165]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8202311176947727`*^9, 3.8202311208363905`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Sigma]", "0"], ",", 
    SubscriptBox["\[Sigma]", "1"], ",", 
    SubscriptBox["\[Sigma]", "2"], ",", 
    SubscriptBox["\[Sigma]", "3"]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.8205743488207197`*^9, 3.820574362748187*^9}, {
  3.820574503634956*^9, 3.8205745064573283`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"603202cf-4fe8-46de-94bb-782e903e369c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "0"], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "1"], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "2"], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "3"], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8205743629133587`*^9, 3.8205745074202547`*^9, 
  3.8205996001529627`*^9, 3.820599968748043*^9, 3.820600340451709*^9, 
  3.820603831973875*^9, 3.8206041817897654`*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"fce8b189-3396-4b34-9ad6-d44b8df2cee3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"], ",", 
       SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     SubscriptBox["\[Sigma]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "1"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "3"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "1"], ",", 
           SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "3"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "1"], ",", 
           SubscriptBox["\[Sigma]", "2"], ",", 
           SubscriptBox["\[Sigma]", "3"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "a", ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "b", ",", 
         RowBox[{"{", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox["\[Sigma]", "1"], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataDeterministicoEquivalente", "[", "A", "]"}]}], "Input",
 CellChangeTimes->{{3.8202311310330486`*^9, 3.820231265805186*^9}, {
   3.820231862894062*^9, 3.8202319081620555`*^9}, {3.8202320078918257`*^9, 
   3.820232010904651*^9}, 3.8202321800940557`*^9, {3.8202331332510276`*^9, 
   3.8202331336190195`*^9}, {3.820310676202611*^9, 3.820310730815018*^9}, {
   3.820313080338834*^9, 3.8203130857585125`*^9}, {3.8203135274070387`*^9, 
   3.820313622393606*^9}, {3.8203137203789926`*^9, 3.8203138713359356`*^9}, {
   3.8203139618671274`*^9, 3.820314028995368*^9}, {3.8203140618640323`*^9, 
   3.8203140912089596`*^9}, {3.8203141490563393`*^9, 
   3.8203141767049627`*^9}, {3.82031659456876*^9, 3.8203167006102066`*^9}, {
   3.820316854244767*^9, 3.8203169370201435`*^9}, {3.8203171727548833`*^9, 
   3.8203171921060047`*^9}, {3.8203179402214584`*^9, 
   3.8203179520553885`*^9}, {3.820574321153582*^9, 3.820574369996811*^9}, {
   3.820574515126048*^9, 3.8205745840080614`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"7e877a78-b0d2-431a-b2e6-ca4b1233d0fe"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del aut\[OAcute]mata no \
determin\[IAcute]stico: \"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184636899*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"6959c2fe-361d-474d-8c80-182d38d29031"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.499999750000125, 0.500000249999875}], 
   PolygonBox[{{0.5184373226955117, 0.10068842190989287`}, {
    0.5194111686771047, 0.07244490074922978}, {0.5433838525037658, 
    0.08741003668899426}}], 
   CircleBox[{0.21187606611310772, 0.25000037499981254}, 
    0.35511094850116565, {5.759486531581288, 6.8067840827778845`}], 
   InsetBox["\<\"b\"\>", {0.5669870141703847, 0.24998261945239483}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702, 
    0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
   CircleBox[{0.7499996250001875, 0.21187656611285788}, 0.35511094850116554, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"a\"\>", {0.7499996250001875, 0.5669875146140234}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.04999997500001249], 
   InsetBox[
    SubscriptBox["\[Sigma]", "1"], {0.99999950000025, 0.500000249999875}], 
   PolygonBox[{{1.0210396681758105`, 0.10147907025061173`}, {
    1.0194109186772298`, 0.07244490074922978}, {1.0453696217925004`, 
    0.08555144705774861}}], 
   CircleBox[{0.7118758161132328, 0.28882321235377184}, 0.3760284737116068, {
    5.669954685114888, 6.717252236311485}], 
   InsetBox["\<\"a\"\>", {1.0863965017450563, 0.25518292288192723}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5875816011177202, 0.06496962421841512}, {0.5649516228080215,
     0.03750048124975942}, {0.6000555875939133, 0.031636916630797374`}}], 
   CircleBox[{0.38193901242210704, 0.5705129166357614}, 0.5635564495561942, {
    5.043031967407529, 6.090229518604127}], 
   InsetBox["\<\"b\"\>", {0.8069017881968377, 0.20037441412322987}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.052499473750263, 0.5909328719309301}, 
    0.03749998125000937, {-1.5707963267948966`, 3.665191429188092}], 
   PolygonBox[{{1.0726746437549575`, 0.5797256841324234}, {1.052499473750263, 
    0.5534328906809207}, {1.085357285818069, 0.5491070776569369}}], 
   InsetBox["\<\"a\"\>", {1.0849754101542113, 0.5721828813059254}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.99999950000025, 4.999997500476638*^-7}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "2"], {0.99999950000025, 4.999997500476638*^-7}],
    PolygonBox[{{0.9776308219968979, 0.4115997072543385}, {
    1.0024534299849182`, 0.4250404434190509}, {1.0016821449551132`, 
    0.3968230662308866}}], 
   CircleBox[{1.296877452867319, 0.2298067246805492}, 0.35327285514559587, {
    2.5560606361640397`, 3.6032581873606384`}], 
   InsetBox["\<\"b\"\>", {0.9442819101974977, 0.2516720733421971}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5874321879986137, -0.043417615940109656`}, {
    0.5724441507496048, -0.019410918677229667`}, {
    0.6007285790647257, -0.01843424629816045}}], 
   CircleBox[{0.7499996250001875, 0.2881241838867672}, 0.35511094850116554, {
    4.188790204786391, 5.235887755982988}], 
   InsetBox["\<\"b\"\>", {0.7499818694527698, -0.06698676417050964}, 
    ImageScaled[{Rational[1, 2], 0}]], 
   CircleBox[{1.07424567490175, -0.07424567490174998}, 
    0.03749998125000937, {-3.4033920413889422`, 1.8325957145940457`}], 
   PolygonBox[{{1.0253408324638988`, -0.09515857203874666}, {
    1.03802347452701, -0.06453996556326014}, {
    1.0581986445317046`, -0.09083275901476269}}], 
   InsetBox["\<\"b\"\>", {1.0477291838654998, -0.10076216593799998}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 0.07499996250001874],
    InsetBox[
    SubscriptBox["\[Sigma]", 
     "3"], {0.499999750000125, 4.999997500476638*^-7}], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184639891*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"634e21fe-1e8a-43dc-a483-03d8560188c6"],

Cell[BoxData["\<\"Estados del nuevo aut\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846439075`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"2f74106c-4c0d-4aec-a28f-37f7c8807c77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "0"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 0], "=", {}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846458735`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"87093f9d-9d5e-4d3e-9362-ce486aa73275"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "1"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "0"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 1], "=", {
    Subscript[$CellContext`\[Sigma], 0]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846468716`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"87a3d0a4-a022-4b1d-90e6-c599af62bc6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "2"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "1"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 2], "=", {
    Subscript[$CellContext`\[Sigma], 1]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184647869*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"e01a07df-fd27-44fb-8779-82fa1dab2666"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "3"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "2"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 3], "=", {
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846488667`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"6aaf496b-5efb-43f7-9399-03361cf5356a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "4"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "3"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 4], "=", {
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846498637`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"a5d47bfe-bc32-42a2-a5bc-6421b3878bd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "5"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 5], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.82060418465086*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"7da81b6d-75aa-40cf-a0ad-2d8a01c9ba1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "6"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 6], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846518574`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"9c620f9e-4c50-4108-8d38-e7ad944cb263"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "7"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 7], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184653852*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"36f4bbc2-2276-420b-beba-c19a6d55f2cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "8"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 8], "=", {
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184654851*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"d8fe4c31-7fd6-4ee3-bab0-67a73d4feba3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "9"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 9], "=", {
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846558485`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"6ceeb307-8c38-4b9a-8847-4f89b10beda3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "10"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 10], "=", {
    Subscript[$CellContext`\[Sigma], 2], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184656845*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"a14a269e-eea9-469d-8892-029319e085df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "11"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 11], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.82060418465884*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"e3a2c1a0-378f-4717-8271-fbbb396a8113"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "12"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 12], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846598377`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"fe720db0-e667-45a8-a32a-7239beb2f3b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "13"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 13], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 2], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846608343`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"3138e1a0-ec73-4a29-a71e-f12ff95b66d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "14"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 14], "=", {
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184661831*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"ad1b59ac-d255-42fc-b5f4-3c7b109d5e9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "15"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 15], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846628275`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"0db4742b-013e-4aaa-ae8f-3f8046fc8716"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", 
   SubscriptBox["\[Mu]", "1"]}],
  SequenceForm["Estado inicial: ", 
   Subscript[$CellContext`\[Mu], 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184663825*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"80fc0ddc-fdf2-438d-bb63-82a071c91414"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Mu]", "2"], ",", 
     SubscriptBox["\[Mu]", "5"], ",", 
     SubscriptBox["\[Mu]", "8"], ",", 
     SubscriptBox["\[Mu]", "9"], ",", 
     SubscriptBox["\[Mu]", "11"], ",", 
     SubscriptBox["\[Mu]", "12"], ",", 
     SubscriptBox["\[Mu]", "14"], ",", 
     SubscriptBox["\[Mu]", "15"]}], "}"}]}],
  SequenceForm["Estados aceptados: ", {
    Subscript[$CellContext`\[Mu], 2], 
    Subscript[$CellContext`\[Mu], 5], 
    Subscript[$CellContext`\[Mu], 8], 
    Subscript[$CellContext`\[Mu], 9], 
    Subscript[$CellContext`\[Mu], 11], 
    Subscript[$CellContext`\[Mu], 12], 
    Subscript[$CellContext`\[Mu], 14], 
    Subscript[$CellContext`\[Mu], 15]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846648226`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"513c89a2-906b-46fa-ac1f-11dd6320adea"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "a", "b"},
     {
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "4"]},
     {
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "4"]},
     {
      SubscriptBox["\[Mu]", "3"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "14"]},
     {
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "5"], 
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "4"]},
     {
      SubscriptBox["\[Mu]", "6"], 
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "14"]},
     {
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "4"]},
     {
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "14"]},
     {
      SubscriptBox["\[Mu]", "9"], 
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "4"]},
     {
      SubscriptBox["\[Mu]", "10"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "14"]},
     {
      SubscriptBox["\[Mu]", "11"], 
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "14"]},
     {
      SubscriptBox["\[Mu]", "12"], 
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "4"]},
     {
      SubscriptBox["\[Mu]", "13"], 
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "14"]},
     {
      SubscriptBox["\[Mu]", "14"], 
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "14"]},
     {
      SubscriptBox["\[Mu]", "15"], 
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "14"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184666817*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"6d7cf4d5-272d-4a55-aa6a-45e0589a5201"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del nuevo aut\[OAcute]mata: \
\"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846678143`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"5ef890fa-74f4-4fc1-991e-d7a1fd4e5017"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.7499998125000469, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Mu]", "0"], {0.7499998125000469, 0.7500000624999844}], 
   CircleBox[{0.7515732945668236, 0.8024764645875995}, 
    0.01874999531250117, {-1.077173134495344, 4.158814621487645}], 
   PolygonBox[{{0.763111738672119, 0.8023215130593229}, {0.7604574108531021, 
    0.7859648080374317}, {0.7759498968337767, 0.7918444452271369}}], 
   InsetBox["\<\"b,a\"\>", {0.7703148667409718, 0.8019145067066078}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.24999993750001562, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Mu]", "1"], {0.24999993750001562, 0.7500000624999844}], 
   PolygonBox[{{0.24134948641231202`, 0.5503551376490964}, {
    0.24029422573509904`, 0.5362223344302566}, {0.2530612226879073, 
    0.5423748534855953}}], 
   CircleBox[{0.09623234777613907, 0.6418108796504313}, 0.17861345291655714, {
    5.650593057378241, 6.697890608574838}], 
   InsetBox["\<\"b\"\>", {0.27378689562245884, 0.6223905783689341}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.44963544787663046`, 0.7592174379532824}, {
    0.46377766556974354`, 0.759705774264901}, {0.4562836450717349, 
    0.7717091258971774}}], 
   CircleBox[{0.37499990625002344, 0.6059381845410244}, 0.17755551863944025, {
    1.0471975511965976`, 2.0943951023931957`}], 
   InsetBox["\<\"a\"\>", {0.37499990625002344, 0.7834937031804647}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.49999987500003124, 0.7500000624999844}, 0.03749999062500234], 
   CircleBox[{0.49999987500003124, 0.7500000624999844}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "2"], {0.49999987500003124, 0.7500000624999844}], 
   PolygonBox[{{0.5105199617178319, 0.5507394228102177}, {0.5097055867649478, 
    0.5362223344302566}, {0.5226849415674201, 0.5427756092228339}}], 
   CircleBox[{0.35593799704107126, 0.6444115172798098}, 0.1880142838593508, {
    5.669954685114887, 6.717252236311485}], 
   InsetBox["\<\"a\"\>", {0.5431983866720569, 0.6275913683388524}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.29502311754679383`, 0.5305959666883849}, {
    0.2832833506942333, 0.5172762270782224}, {0.30068846699470814`, 
    0.5137691605544797}}], 
   CircleBox[{0.20109835692431838, 0.785470246073465}, 0.2805038413743768, {
    5.009642209577395, 6.056839760773991}], 
   InsetBox["\<\"b\"\>", {0.4063505407765564, 0.5942793831911908}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Mu]", "3"], {0.9999997500000625, 0.7500000624999844}], 
   PolygonBox[{{0.7937160424283433, 0.7282909991027916}, {0.7862220219303346, 
    0.7402943507350678}, {0.8003642396234475, 0.7407826870466864}}], 
   CircleBox[{0.8749997812500547, 0.8940619404589444}, 0.17755551863944025, {
    4.1887902047863905`, 5.235887755982989}], 
   InsetBox["\<\"a\"\>", {0.8749909034741264, 0.7165064220414485}, 
    ImageScaled[{Rational[1, 2], 0}]], 
   PolygonBox[{{0.31168464689245295`, 0.2753546912901454}, {
    0.2866568213931054, 0.2579072830554526}, {0.314280632904221, 
    0.24495625448887998`}}], 
   CircleBox[{0.22918026402666117, 1.08620431032279}, 0.8302888172356695, {
    4.781569164249046, 5.828766715445643}], 
   InsetBox["\<\"b\"\>", {0.6930360753433544, 0.3975699324891393}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 0.5000001249999688}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Mu]", "4"], {0.24999993750001562, 0.5000001249999688}], 
   PolygonBox[{{0.6922490191542421, 0.7319141742260565}, {0.7132611572122294, 
    0.7424820504942622}, {0.6936030388709189, 0.7553951577062022}}], 
   CircleBox[{0.6748681973986032, 0.2535924353072021}, 0.49039481563430287, {
    1.492426230820322, 2.5396237820169176`}], 
   InsetBox["\<\"b,a\"\>", {0.4636726683301492, 0.6961797416124076}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "5"], {0.7499998125000469, 0.5000001249999688}], 
   PolygonBox[{{0.5412531941600708, 0.46997705944129836`}, {
    0.5324758195229615, 0.4812501296874676}, {0.5466272720533453, 
    0.48321502397865285`}}], 
   CircleBox[{0.6062498484375387, 0.6465304866715629}, 0.18099780039293747, {
    4.292568780148034, 5.339666331344682}], 
   InsetBox["\<\"a\"\>", {0.6249908425264885, 0.46650554704474456}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.293258475091088, 0.4610404086306925}, {0.28169572038606466`,
     0.4799595001565239}, {0.3038615116164692, 0.4805135937058864}}], 
   CircleBox[{0.49849207622090236, 0.858043062425736}, 0.43583005857470875, {
    4.191751522838423, 5.238849074022228}], 
   InsetBox["\<\"b\"\>", {0.49976091434286246, 0.42221485084799254}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Mu]", "6"], {0.49999987500003124, 0.2500001874999531}], 
   PolygonBox[{{0.4904277619254977, 0.7032347904053446}, {0.5097055867649478, 
    0.7137778530696967}, {0.5091972344462428, 0.6918112356968502}}], 
   CircleBox[{0.8702737615434434, 0.4831893390995141}, 0.4279958778283652, {
    2.5726240844806343`, 3.6198216356772317`}], 
   InsetBox["\<\"a\"\>", {0.4427183054039874, 0.5026007626293474}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.2923842536286673, 0.2469206417724101}, {
    0.28622214693030334`, 0.2597058992648697}, {0.3003755580618807, 
    0.25864981146025334`}}], 
   CircleBox[{0.3918106921504776, 0.4037677772238264}, 0.17861345291655714, {
    4.079896730583335, 5.126994281779951}], 
   InsetBox["\<\"b\"\>", {0.3723903908689804, 0.22621322937750662}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 2.499999375293882*^-7}, 
    0.03749999062500234], InsetBox[
    SubscriptBox["\[Mu]", "7"], {0.24999993750001562, 2.499999375293882*^-7}],
    PolygonBox[{{0.4386845955121745, 0.7262232113228633}, {0.4664588637227872,
     0.7332295568613625}, {0.4586394028415129, 0.7056731622501997}}], 
   CircleBox[{0.964171425944662, 0.20286592928701275}, 0.7273261799545561, {
    2.3244457789668176`, 3.371643330163415}], 
   InsetBox["\<\"a\"\>", {0.2679578894907003, 0.4133180228987313}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.22140283176743494`, 0.45252014924825684`}, {
    0.24029422573509904`, 0.4637779155696811}, {0.24059804037548935`, 
    0.44178860532007175`}}], 
   CircleBox[{0.6097745513013355, 0.24630130834608968}, 0.42873276719888864, {
    2.609596698242374, 3.6567942494389714`}], 
   InsetBox["\<\"b\"\>", {0.18105689955063392, 0.24990141214745204}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.49999987500003124, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "8"], {0.49999987500003124, 0.5000001249999688}], 
   PolygonBox[{{0.29034309447876605`, 0.2877116154960039}, {
    0.2777921823972582, 0.27517637506771153`}, {0.294923475091459, 
    0.2705745865786069}}], 
   CircleBox[{0.21294294519573087, 0.547549812221235}, 0.279986986898399, {
    4.946026667532532, 5.993224218729129}], 
   InsetBox["\<\"b\"\>", {0.40527040387362384, 0.3440728811677428}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.4583488350475014, 0.5319600920329349}, 
    0.01874999531250117, {-0.13089969389957457`, 5.105088062083414}], 
   PolygonBox[{{0.465221185201281, 0.5412299628902331}, {0.47693842155086374`,
     0.5295127265406503}, {0.4812272277169575, 0.5455187690563268}}], 
   InsetBox["\<\"a\"\>", {0.46976310898784646, 0.5468354634445527}, 
    ImageScaled[{0, 0}]], 
   CircleBox[{0.9999997500000625, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.9999997500000625, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "9"], {0.9999997500000625, 0.5000001249999688}], 
   PolygonBox[{{0.5488678740729956, 0.48128705527557386`}, {
    0.5374998656250336, 0.5000001249999688}, {0.5593898636131301, 
    0.5004885742441425}}], 
   CircleBox[{0.7499998125000469, 0.8680608295931792}, 0.4249998937500268, {
    4.188790204786391, 5.235887755982988}], 
   InsetBox["\<\"a\"\>", {0.7499785625053682, 0.4430609363744023}, 
    ImageScaled[{Rational[1, 2], 0}]], 
   PolygonBox[{{0.301022760592791, 0.4774308791489939}, {0.2874661502870599, 
    0.5015914126141924}, {0.3151680911897714, 0.5012515147955623}}], 
   CircleBox[{0.6451110456422052, 1.080367976583478}, 0.6803618024064289, {
    4.158888004953759, 5.205985556150406}], 
   InsetBox["\<\"b\"\>", {0.6247357598581615, 0.4003113393076234}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Mu]", "10"], {0.7499998125000469, 0.2500001874999531}], 
   PolygonBox[{{0.7215240830057195, 0.7023769651163644}, {0.7402941007351302, 
    0.7137778530696968}, {0.7407825504637107, 0.6918220969098766}}], 
   CircleBox[{1.1105679872785426, 0.5000001249999688}, 0.42755545613945617, {
    2.6179938779914944`, 3.665191429188092}], 
   InsetBox["\<\"a\"\>", {0.6830125311390864, 0.5000001249999688}, 
    ImageScaled[{0, Rational[1, 2]}]], 
   PolygonBox[{{0.29765285338513875`, 0.22165802750872315`}, {
    0.28625842001011775`, 0.24043087493635276`}, {0.3082133994713248, 
    0.24091231998703538`}}], 
   CircleBox[{0.5001361367133279, 0.6106051484507589}, 0.42751920481859695, {
    4.188471156631429, 5.235568707874236}], 
   InsetBox["\<\"b\"\>", {0.49997836155303804, 0.18308597274547633}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 2.499999375293882*^-7}, 
    0.03749999062500234], 
   CircleBox[{0.49999987500003124, 2.499999375293882*^-7}, 
    0.02499999375000156], InsetBox[
    SubscriptBox["\[Mu]", 
     "11"], {0.49999987500003124, 2.499999375293882*^-7}], 
   PolygonBox[{{0.4715241455057038, 0.4523770276163487}, {
    0.49029416323511466`, 0.4637779155696811}, {0.49078261296369513`, 
    0.4418221594098608}}], 
   CircleBox[{0.8605680497785269, 0.2500001874999532}, 0.4275554561394561, {
    2.6179938779914944`, 3.665191429188092}], 
   InsetBox["\<\"a\"\>", {0.43301259363907074, 0.25000018749995323}, 
    ImageScaled[{0, Rational[1, 2]}]], 
   PolygonBox[{{0.24680270445077623`, 0.19465716967108287`}, {
    0.24999618750095937`, 0.21250019706245074`}, {0.263851960977214, 
    0.2008130459187532}}], 
   CircleBox[{0.5265524391865499, 0.3040097726326754}, 0.2913028711966746, {
    3.461142199090079, 4.508339750286676}], 
   InsetBox["\<\"b\"\>", {0.33280248743653784, 0.08648202965653373}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.2500001874999531}, 0.03749999062500234], 
   CircleBox[{0.9999997500000625, 0.2500001874999531}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "12"], {0.9999997500000625, 0.2500001874999531}], 
   PolygonBox[{{0.532468557297425, 0.45477965742086024`}, {0.5304192565235977,
     0.47807045275893956`}, {0.5516143273476322, 0.4681998016200295}}], 
   CircleBox[{0.9329734040007326, 0.7478754087210084}, 0.4846076308857882, {
    3.732059992643821, 4.779157543840417}], 
   InsetBox["\<\"a\"\>", {0.7192320173839559, 0.3129510755780191}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.2872273344135086, 0.45144679029279244`}, {
    0.2812920606880254, 0.4793348806689264}, {0.3084114922795353, 
    0.4705309333055422}}], 
   CircleBox[{0.8249049504714494, 0.9524411771160717}, 0.7206556332095246, {
    3.8577544963460024`, 4.904852047542602}], 
   InsetBox["\<\"b\"\>", {0.5906414501848928, 0.2709243731338724}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 2.499999375293882*^-7}, 
    0.03749999062500234], InsetBox[
    SubscriptBox["\[Mu]", "13"], {0.7499998125000469, 2.499999375293882*^-7}],
    PolygonBox[{{0.46721515850362577`, 0.693345242133403}, {
    0.48538363047072053`, 0.7154658085955686}, {0.4954563669895106, 
    0.6886711670930363}}], 
   CircleBox[{1.1998704501079995, 0.5846505434663318}, 0.7263635790884798, {
    2.960508481479961, 4.007706032676559}], 
   InsetBox["\<\"a\"\>", {0.515699081068347, 0.3406964764524083}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.27315148448964893`, 0.19541557513248187`}, {
    0.270831477463488, 0.2188185223804391}, {0.2922590278167266, 
    0.20912623377807427`}}], 
   CircleBox[{0.6750377106486841, 0.4963237342436734}, 0.49029768667313084, {
    3.7432302867810474`, 4.790327837977644}], 
   InsetBox["\<\"b\"\>", {0.4637153290540518, 0.05390462006098329}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 0.2500001874999531}, 0.03749999062500234], 
   CircleBox[{0.24999993750001562, 0.2500001874999531}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "14"], {0.24999993750001562, 0.2500001874999531}], 
   PolygonBox[{{0.4501678534661561, 0.4864784555987801}, {0.4675239304771009, 
    0.48125012968746766`}, {0.45431802891316747`, 0.4688334890416066}}], 
   CircleBox[{0.5265543140236983, 0.1959938500554279}, 0.29130007080529685, {
    1.7748541186524378`, 2.822051669849036}], 
   InsetBox["\<\"a\"\>", {0.33280436246118605, 0.41351784303251327}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.19749995069063733, 0.2500028124992958}, 0.01874999531250117, {
    0.5235487755982993, 5.759536531581288}], 
   PolygonBox[{{0.19730958970644807`, 0.2615407267407364}, {
    0.21373839168168762`, 0.2593769982452149}, {0.2073978345380818, 
    0.2746866223572771}}], 
   InsetBox["\<\"b\"\>", {0.19750088819040257, 0.26875280778835947}, 
    ImageScaled[{0, 0}]], 
   CircleBox[{0.9999997500000625, 2.499999375293882*^-7}, 
    0.03749999062500234], 
   CircleBox[{0.9999997500000625, 2.499999375293882*^-7}, 
    0.02499999375000156], InsetBox[
    SubscriptBox["\[Mu]", "15"], {0.9999997500000625, 2.499999375293882*^-7}],
    PolygonBox[{{0.5091138142304439, 0.43976564606508745`}, {
    0.5153789960463361, 0.46579878098078786`}, {0.5347917613155342, 
    0.44735640691104667`}}], 
   CircleBox[{1.1280594207977532, 0.634825167042901}, 0.6355684243720698, {
    3.4107769768536533`, 4.457974528050251}], 
   InsetBox["\<\"a\"\>", {0.6819758015926423, 0.1821038104275266}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.28959271163023936`, 0.20559270632685248`}, {
    0.28363141286809046`, 0.23341184335589105`}, {0.3107041416276727, 
    0.22466491100894145`}}], 
   CircleBox[{0.8242410390423953, 0.7051998277626632}, 0.7175253794416814, {
    3.8591163743256773`, 4.906213925522278}], 
   InsetBox["\<\"b\"\>", {0.5919194174791593, 0.02632625021146895}, 
    ImageScaled[{1, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.24999993750001562`, 0.8250000437499891}, {
     0.24999993750001562`, 0.7875000531249867}}], 
    PolygonBox[{{0.24999993750001562`, 0.7875000531249867}, {
     0.23749994062501484`, 0.8062500484374879}, {0.2624999343750164, 
     0.8062500484374879}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184674797*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"743b60e2-d549-4e31-98a1-e3a70b30718f"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n reducido del nuevo aut\
\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.8206041846767907`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"a915b50e-a261-41c3-8084-1fd5c200072f"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "0"], {0.6666664444445185, 0.3333335555554815}], 
   CircleBox[{0.7342812297464916, 0.3152162284374141}, 0.024999991666669445, {
    3.403392041388943, 8.639379797371932}], 
   PolygonBox[{{0.7130169679686124, 0.28684054277060517`}, {
    0.7101330921386441, 0.30874575446667574`}, {0.7305454998577013, 
    0.30029065834875296`}}], 
   InsetBox["\<\"b,a\"\>", {0.7278107557757532, 0.2910680908295666}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 0.6666667777777407}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "1"], {0.33333322222225925, 0.6666667777777407}], 
   PolygonBox[{{0.34562493940113553`, 0.400458848016453}, {
    0.34627417016373596`, 0.3816298307711765}, {0.3622559620451405, 
    0.39160658972714507`}}], 
   CircleBox[{0.14125073428384913, 0.5000001666666112}, 0.23674067179086933, {
    5.759486531581287, 6.8067840827778845`}], 
   InsetBox["\<\"b\"\>", {0.37799140577879264, 0.49998832963302653}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   PolygonBox[{{0.5995138805426964, 0.678956610691319}, {0.6183701692288235, 
    0.6796077257192175}, {0.608378142730814, 0.6956121932285473}}], 
   CircleBox[{0.4999998333333889, 0.47458428983933065}, 0.23674067179086933, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"a\"\>", {0.4999998333333889, 0.7113249616302}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.04999998333333889], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "2"], {0.6666664444445185, 0.6666667777777407}], 
   PolygonBox[{{0.3893093603899863, 0.3808647456804411}, {
    0.37300087601426973`, 0.3637716168598971}, {0.39595820199087906`, 
    0.35819461950357695`}}], 
   CircleBox[{0.2780288092870691, 0.7239413023480928}, 0.3724807321232893, {
    4.970107475123717, 6.017305026320314}], 
   InsetBox["\<\"b\"\>", {0.5403354301488177, 0.45948500642154}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.380084808389943, 0.06550111433901759}, {0.3665067088268969, 
    0.037410467252069604`}, {0.3976229725944603, 0.039696811638831236`}}], 
   CircleBox[{0.012196721966886655, 0.5827490742649662}, 0.650330502965613, {
    5.288457780889529, 6.335755332086126}], 
   InsetBox["\<\"a\"\>", {0.5916927180795569, 0.28759800518865186}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "4"], {0.33333322222225925, 0.3333335555554815}], 
   PolygonBox[{{0.599586057919772, 0.3451114226233999}, {0.6183701692288235, 
    0.3462745034969582}, {0.6079708559911405, 0.3619604806413321}}], 
   CircleBox[{0.5061930506321068, 0.13914875362912582}, 0.235552079581234, {
    1.0744332845146758`, 2.121630835712004}], 
   InsetBox["\<\"b,a\"\>", {0.49977841012619695, 0.37461347409107515}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Mu]", "8"], {0.33333322222225925, 3.333332222466012*^-7}],
    PolygonBox[{{0.5995138805426964, 0.012290166246800413`}, {
    0.6183701692288235, 0.012941281274698983`}, {0.608378142730814, 
    0.02894574878402883}}], 
   CircleBox[{0.4999998333333889, -0.19208215460518788}, 
    0.23674067179086933, {1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"b\"\>", {0.4999998333333889, 0.04465851718568145}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.26629180791417856, -0.020135343981118103}, 
    0.024999991666669445, {0.8153737466961952, 6.051361502679184}], 
   PolygonBox[{{0.261622773002139, -0.0054749062910730995`}, {
    0.28343171121391614`, -0.0019358028273091313`}, {0.26946228860178645`, 
    0.01518173996177308}}], 
   InsetBox["\<\"a\"\>", {0.2591004945876284, 0.003808018271767858}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Mu]", "14"], {0.6666664444445185, 3.333332222466012*^-7}],
    PolygonBox[{{0.39162152393596383`, -0.028945082117584425`}, {
    0.38162949743795427`, -0.012940614608254476`}, {
    0.4004857861240815, -0.012289499580355884`}}], 
   CircleBox[{0.4999998333333889, 0.19208282127163234}, 0.23674067179086933, {
    4.188790204786391, 5.235887755982988}], 
   InsetBox["\<\"a\"\>", {0.4999879962998042, -0.044657850223311146}, 
    ImageScaled[{Rational[1, 2], 0}]], 
   CircleBox[{0.736666421111193, 3.333332222466012*^-7}, 
    0.024999991666669445, {-2.617993877991494, 2.6179938779914944`}], 
   PolygonBox[{{0.7234708893513808, -0.03291207021916974}, {
    0.715015793233458, -0.012499662500112484`}, {
    0.7369210049295285, -0.015383538330080784`}}], 
   InsetBox["\<\"b\"\>", {0.736666421111193, -0.024999658333447198}, 
    ImageScaled[{0, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.33333322222225925`, 0.7666667444444185}, {
     0.33333322222225925`, 0.7166667611110796}}], 
    PolygonBox[{{0.33333322222225925`, 0.7166667611110796}, {
     0.31666656111114627`, 0.7416667527777491}, {0.34999988333337223`, 
     0.7416667527777491}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820574660749574*^9, 
  3.8205999721081924`*^9, 3.8206003444369383`*^9, 3.820603834753095*^9, 
  3.820604184679811*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"5f348cc2-6473-4f25-a24d-44892d89950e"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{813., 401.1428571428571},
WindowMargins->{{-823.2857142857143, Automatic}, {
  Automatic, 19.285714285714285`}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a8572f35-c064-47f4-a398-4a1b85c180ca"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 42, "Input",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],
Cell[CellGroupData[{
Cell[785, 27, 449, 10, 65, "Input",ExpressionUUID->"603202cf-4fe8-46de-94bb-782e903e369c"],
Cell[1237, 39, 2214, 65, 107, "Output",ExpressionUUID->"fce8b189-3396-4b34-9ad6-d44b8df2cee3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3488, 109, 3132, 75, 159, "Input",ExpressionUUID->"7e877a78-b0d2-431a-b2e6-ca4b1233d0fe"],
Cell[CellGroupData[{
Cell[6645, 188, 396, 7, 33, "Print",ExpressionUUID->"6959c2fe-361d-474d-8c80-182d38d29031"],
Cell[7044, 197, 4465, 81, 607, "Print",ExpressionUUID->"634e21fe-1e8a-43dc-a483-03d8560188c6"],
Cell[11512, 280, 353, 6, 33, "Print",ExpressionUUID->"2f74106c-4c0d-4aec-a28f-37f7c8807c77"],
Cell[11868, 288, 536, 14, 33, "Print",ExpressionUUID->"87093f9d-9d5e-4d3e-9362-ce486aa73275"],
Cell[12407, 304, 612, 16, 33, "Print",ExpressionUUID->"87a3d0a4-a022-4b1d-90e6-c599af62bc6c"],
Cell[13022, 322, 610, 16, 33, "Print",ExpressionUUID->"e01a07df-fd27-44fb-8779-82fa1dab2666"],
Cell[13635, 340, 612, 16, 33, "Print",ExpressionUUID->"6aaf496b-5efb-43f7-9399-03361cf5356a"],
Cell[14250, 358, 612, 16, 33, "Print",ExpressionUUID->"a5d47bfe-bc32-42a2-a5bc-6421b3878bd8"],
Cell[14865, 376, 709, 19, 33, "Print",ExpressionUUID->"7da81b6d-75aa-40cf-a0ad-2d8a01c9ba1f"],
Cell[15577, 397, 712, 19, 33, "Print",ExpressionUUID->"9c620f9e-4c50-4108-8d38-e7ad944cb263"],
Cell[16292, 418, 710, 19, 33, "Print",ExpressionUUID->"36f4bbc2-2276-420b-beba-c19a6d55f2cf"],
Cell[17005, 439, 710, 19, 33, "Print",ExpressionUUID->"d8fe4c31-7fd6-4ee3-bab0-67a73d4feba3"],
Cell[17718, 460, 712, 19, 33, "Print",ExpressionUUID->"6ceeb307-8c38-4b9a-8847-4f89b10beda3"],
Cell[18433, 481, 712, 19, 33, "Print",ExpressionUUID->"a14a269e-eea9-469d-8892-029319e085df"],
Cell[19148, 502, 795, 21, 33, "Print",ExpressionUUID->"e3a2c1a0-378f-4717-8271-fbbb396a8113"],
Cell[19946, 525, 798, 21, 33, "Print",ExpressionUUID->"fe720db0-e667-45a8-a32a-7239beb2f3b0"],
Cell[20747, 548, 798, 21, 33, "Print",ExpressionUUID->"3138e1a0-ec73-4a29-a71e-f12ff95b66d7"],
Cell[21548, 571, 796, 21, 33, "Print",ExpressionUUID->"ad1b59ac-d255-42fc-b5f4-3c7b109d5e9e"],
Cell[22347, 594, 882, 23, 33, "Print",ExpressionUUID->"0db4742b-013e-4aaa-ae8f-3f8046fc8716"],
Cell[23232, 619, 511, 12, 33, "Print",ExpressionUUID->"80fc0ddc-fdf2-438d-bb63-82a071c91414"],
Cell[23746, 633, 1117, 28, 33, "Print",ExpressionUUID->"513c89a2-906b-46fa-ac1f-11dd6320adea"],
Cell[24866, 663, 2564, 84, 418, "Print",ExpressionUUID->"6d7cf4d5-272d-4a55-aa6a-45e0589a5201"],
Cell[27433, 749, 378, 7, 33, "Print",ExpressionUUID->"5ef890fa-74f4-4fc1-991e-d7a1fd4e5017"],
Cell[27814, 758, 15345, 272, 553, "Print",ExpressionUUID->"743b60e2-d549-4e31-98a1-e3a70b30718f"],
Cell[43162, 1032, 387, 7, 33, "Print",ExpressionUUID->"a915b50e-a261-41c3-8084-1fd5c200072f"],
Cell[43552, 1041, 5807, 105, 660, "Print",ExpressionUUID->"5f348cc2-6473-4f25-a24d-44892d89950e"]
}, Open  ]]
}, Open  ]]
}
]
*)

