(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     59630,       1311]
NotebookOptionsPosition[     56354,       1261]
NotebookOutlinePosition[     56817,       1278]
CellTagsIndexPosition[     56774,       1275]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8202311176947727`*^9, 3.8202311208363905`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Sigma]", "0"], ",", 
    SubscriptBox["\[Sigma]", "1"], ",", 
    SubscriptBox["\[Sigma]", "2"], ",", 
    SubscriptBox["\[Sigma]", "3"]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.8205743488207197`*^9, 3.820574362748187*^9}, 
   3.8205747647344856`*^9},
 CellLabel->"In[39]:=",ExpressionUUID->"603202cf-4fe8-46de-94bb-782e903e369c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "0"], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "1"], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "2"], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "3"], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8205743629133587`*^9, 3.820574766415606*^9, 
  3.820603852294015*^9, 3.8206046167586823`*^9, 3.8206054823697276`*^9, 
  3.820606722970445*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"b806a771-307b-4215-bf42-e2cf9e3ccb0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"], ",", 
       SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     SubscriptBox["\[Sigma]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "1"], ",", 
           SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "0"], ",", 
           SubscriptBox["\[Sigma]", "3"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "1"], ",", 
           SubscriptBox["\[Sigma]", "3"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "0"], ",", 
           SubscriptBox["\[Sigma]", "3"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "1"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "a", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "2"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "b", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "2"], ",", 
           SubscriptBox["\[Sigma]", "3"]}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "3"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataDeterministicoEquivalente", "[", "A", "]"}]}], "Input",
 CellChangeTimes->{{3.8202311310330486`*^9, 3.820231265805186*^9}, {
   3.820231862894062*^9, 3.8202319081620555`*^9}, {3.8202320078918257`*^9, 
   3.820232010904651*^9}, 3.8202321800940557`*^9, {3.8202331332510276`*^9, 
   3.8202331336190195`*^9}, {3.820310676202611*^9, 3.820310730815018*^9}, {
   3.820313080338834*^9, 3.8203130857585125`*^9}, {3.8203135274070387`*^9, 
   3.820313622393606*^9}, {3.8203137203789926`*^9, 3.8203138713359356`*^9}, {
   3.8203139618671274`*^9, 3.820314028995368*^9}, {3.8203140618640323`*^9, 
   3.8203140912089596`*^9}, {3.8203141490563393`*^9, 
   3.8203141767049627`*^9}, {3.82031659456876*^9, 3.8203167006102066`*^9}, {
   3.820316854244767*^9, 3.8203169370201435`*^9}, {3.8203171727548833`*^9, 
   3.8203171921060047`*^9}, {3.8203179402214584`*^9, 
   3.8203179520553885`*^9}, {3.820574321153582*^9, 3.820574369996811*^9}, 
   3.820574709334383*^9, 3.820604161602508*^9},
 CellLabel->"In[40]:=",ExpressionUUID->"7e877a78-b0d2-431a-b2e6-ca4b1233d0fe"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del aut\[OAcute]mata no \
determin\[IAcute]stico: \"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255100327`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"27d1671a-0d19-4095-94de-c09e065f85d5"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.499999750000125, 0.500000249999875}], 
   PolygonBox[{{0.5129291925700409, 0.10199338597002337`}, {
    0.5134260078827435, 0.07378891355007407}, {0.5376033898424059, 
    0.0883214044418383}}], 
   CircleBox[{0.21004743494446984, 0.2558556826938861}, 0.35381756166777484, {
    5.742569772999188, 6.789867324195786}], 
   InsetBox["\<\"a\"\>", {0.5638140709445429, 0.2498528335602287}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702, 
    0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
   CircleBox[{0.7499996250001875, 0.21187656611285788}, 0.35511094850116554, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"a\"\>", {0.7499996250001875, 0.5669875146140234}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   PolygonBox[{{0.9366358394624774, 0.08943397794579509}, {0.9624995187502406,
     0.06495237280764654}, {0.9707693710814154, 0.09959177867525716}}], 
   CircleBox[{0.4194427433454762, -0.08056675170302807}, 0.5622156854014074, {
    0.2618122734893006, 1.3090098246858985`}], 
   InsetBox["\<\"b\"\>", {0.8169841442879253, 0.3169848945620694}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.3958980916067041, 0.5137054933303588}, 0.03749998125000937, {
    0.3926990816987246, 5.6286868376817125`}], 
   PolygonBox[{{0.398531479724809, 0.5366337250565242}, {0.43054355675314476`,
     0.5280561148687388}, {0.4219659465653593, 0.5600681918970746}}], 
   InsetBox["\<\"b\"\>", {0.40079282136759115, 0.5508846570422947}, 
    ImageScaled[{0, 0}]], 
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.04999997500001249], 
   InsetBox[
    SubscriptBox["\[Sigma]", "1"], {0.99999950000025, 0.500000249999875}], 
   PolygonBox[{{1.0184370726956367`, 0.1006884219098928}, {
    1.0194109186772298`, 0.07244490074922978}, {1.0433836025038907`, 
    0.08741003668899433}}], 
   CircleBox[{0.7118758161132328, 0.25000037499981254}, 0.35511094850116565, {
    5.759486531581288, 6.8067840827778845`}], 
   InsetBox["\<\"a\"\>", {1.0669867641705097, 0.24998261945239483}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   CircleBox[{1.07424567490175, 0.574246424901375}, 
    0.03749998125000937, {-1.8325957145940457`, 3.4033920413889427`}], 
   PolygonBox[{{1.0908327590147626`, 0.5581993945313295}, {
    1.0645399655632601`, 0.5380242245266351}, {1.0951585720387464`, 
    0.5253415824635241}}], 
   InsetBox["\<\"a\"\>", {1.100762165938, 0.547729933865125}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 0.07499996250001874],
    InsetBox[
    SubscriptBox["\[Sigma]", 
     "2"], {0.499999750000125, 4.999997500476638*^-7}], 
   PolygonBox[{{0.8993635865048231, 0.017796697672077602`}, {
    0.9275550992507702, 0.019411918676729784`}, {0.9120605204550416, 
    0.0430188743835067}}], 
   CircleBox[{0.7577710456030716, -0.2906670293910736}, 0.3535188522663558, {
    1.069835251788079, 2.117032802983944}], 
   InsetBox["\<\"a\"\>", {0.7497688751857114, 0.06276124363802782}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9000605564188323, 0.4689489364622962}, {0.9350476271923535, 
    0.46250026874986566`}, {0.9119693817460636, 0.43542491051220755`}}], 
   CircleBox[{1.1082707780564933, -0.07115380171228247}, 0.5610641023235405, {
    1.8846647688962923`, 2.9318623200928906`}], 
   InsetBox["\<\"b\"\>", {0.6914280936534895, 0.30439260470883894}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.45459154652682254`, 0.4144284442648523}, {
    0.48058833132314527`, 0.4275558492503953}, {0.47895860512823063`, 
    0.3984782707072913}}], 
   CircleBox[{0.7881234338871421, 0.21117753764585312}, 0.37602847371160686, {
    2.5284620315250943`, 3.575659582721692}], 
   InsetBox["\<\"a\"\>", {0.41360106670899666, 0.2447991010413736}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.99999950000025, 4.999997500476638*^-7}, 0.07499996250001874], 
   CircleBox[{0.99999950000025, 4.999997500476638*^-7}, 0.04999997500001249], 
   InsetBox[
    SubscriptBox["\[Sigma]", "3"], {0.99999950000025, 4.999997500476638*^-7}],
    PolygonBox[{{0.5871066603222185, -0.04494200284618295}, {
    0.5720034530772181, -0.0209866655589916}, {
    0.6003009873466506, -0.01988457304979578}}], 
   CircleBox[{0.7484146393345211, 0.28771796581042963}, 0.35555513788294246, {
    4.193222012583563, 5.2403195638227205`}], 
   InsetBox["\<\"b,a\"\>", {0.7499726086320123, -0.06783375870602704}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.07424567490175, -0.07424567490174998}, 
    0.03749998125000937, {-3.4033920413889422`, 1.8325957145940457`}], 
   PolygonBox[{{1.0253408324638988`, -0.09515857203874666}, {
    1.03802347452701, -0.06453996556326014}, {
    1.0581986445317046`, -0.09083275901476269}}], 
   InsetBox["\<\"b\"\>", {1.0477291838654998, -0.10076216593799998}, 
    ImageScaled[{1, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255439415`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"21857b65-3e48-4153-b3a6-1648e1616771"],

Cell[BoxData["\<\"Estados del nuevo aut\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255459356`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"eb7ed5c2-bd3e-4985-91dc-1ddc2629f543"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "0"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 0], "=", {}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255479307`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"4c9dfb8b-f0af-443c-866a-6dd4d64adfd9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "1"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "0"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 1], "=", {
    Subscript[$CellContext`\[Sigma], 0]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.820606725548928*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"7b75d0f0-1bbf-4a54-8a6d-ed4a934cbbe6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "2"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "1"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 2], "=", {
    Subscript[$CellContext`\[Sigma], 1]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.820606725549925*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"03adc74d-6139-4827-b148-ecfb45cffa34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "3"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "2"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 3], "=", {
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255509224`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"454ca7cc-6cf7-4182-acb6-2ee58ea54d0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "4"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "3"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 4], "=", {
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.82060672555192*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"287de901-2d17-41f3-908d-3f2d50370dd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "5"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 5], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255529175`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"46ff7eb5-b343-4ac9-b05b-a11858223b5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "6"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 6], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.820606725553914*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"88bf629c-7533-4d96-a713-4b7f6a15fab4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "7"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 7], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255549126`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"c5ab2374-0930-4e31-a539-0e3e5f960ade"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "8"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 8], "=", {
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255569077`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"f9842a63-661b-42c0-8853-ea8dda8d7aac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "9"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 9], "=", {
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255579042`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"54381b22-db72-4e1c-b3ca-dbe27bbbf1e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "10"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 10], "=", {
    Subscript[$CellContext`\[Sigma], 2], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255598993`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"7f052c75-8446-4ee4-ad0d-9f34c4056174"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "11"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 11], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.820606725560896*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"92c36cae-ba7c-4110-8e44-b39f465c86c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "12"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 12], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.820606725562891*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"0f2a0747-5ac5-4934-98fe-53b1b006b83d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "13"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 13], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 2], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.820606725563888*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"6663acef-5045-4fd6-a4b4-4ee763057b95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "14"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 14], "=", {
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.820606725564885*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"f3bf5ef6-22cc-4845-904b-d339818483d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "15"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     SubscriptBox["\[Sigma]", "3"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 15], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2], 
    Subscript[$CellContext`\[Sigma], 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255668797`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"2fd84845-45cf-4631-9a79-940f75291c36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", 
   SubscriptBox["\[Mu]", "1"]}],
  SequenceForm["Estado inicial: ", 
   Subscript[$CellContext`\[Mu], 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255678773`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"f33c567e-46d0-450d-bf6d-14d3d4aa33da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Mu]", "2"], ",", 
     SubscriptBox["\[Mu]", "4"], ",", 
     SubscriptBox["\[Mu]", "5"], ",", 
     SubscriptBox["\[Mu]", "7"], ",", 
     SubscriptBox["\[Mu]", "8"], ",", 
     SubscriptBox["\[Mu]", "9"], ",", 
     SubscriptBox["\[Mu]", "10"], ",", 
     SubscriptBox["\[Mu]", "11"], ",", 
     SubscriptBox["\[Mu]", "12"], ",", 
     SubscriptBox["\[Mu]", "13"], ",", 
     SubscriptBox["\[Mu]", "14"], ",", 
     SubscriptBox["\[Mu]", "15"]}], "}"}]}],
  SequenceForm["Estados aceptados: ", {
    Subscript[$CellContext`\[Mu], 2], 
    Subscript[$CellContext`\[Mu], 4], 
    Subscript[$CellContext`\[Mu], 5], 
    Subscript[$CellContext`\[Mu], 7], 
    Subscript[$CellContext`\[Mu], 8], 
    Subscript[$CellContext`\[Mu], 9], 
    Subscript[$CellContext`\[Mu], 10], 
    Subscript[$CellContext`\[Mu], 11], 
    Subscript[$CellContext`\[Mu], 12], 
    Subscript[$CellContext`\[Mu], 13], 
    Subscript[$CellContext`\[Mu], 14], 
    Subscript[$CellContext`\[Mu], 15]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255688744`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"a8763f52-c83c-480b-ad9a-fe34bc8d024e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "a", "b"},
     {
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "7"]},
     {
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "9"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "3"], 
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "2"]},
     {
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "3"], 
      SubscriptBox["\[Mu]", "10"]},
     {
      SubscriptBox["\[Mu]", "5"], 
      SubscriptBox["\[Mu]", "14"], 
      SubscriptBox["\[Mu]", "7"]},
     {
      SubscriptBox["\[Mu]", "6"], 
      SubscriptBox["\[Mu]", "15"], 
      SubscriptBox["\[Mu]", "12"]},
     {
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "13"]},
     {
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "12"], 
      SubscriptBox["\[Mu]", "2"]},
     {
      SubscriptBox["\[Mu]", "9"], 
      SubscriptBox["\[Mu]", "14"], 
      SubscriptBox["\[Mu]", "10"]},
     {
      SubscriptBox["\[Mu]", "10"], 
      SubscriptBox["\[Mu]", "13"], 
      SubscriptBox["\[Mu]", "14"]},
     {
      SubscriptBox["\[Mu]", "11"], 
      SubscriptBox["\[Mu]", "15"], 
      SubscriptBox["\[Mu]", "12"]},
     {
      SubscriptBox["\[Mu]", "12"], 
      SubscriptBox["\[Mu]", "14"], 
      SubscriptBox["\[Mu]", "13"]},
     {
      SubscriptBox["\[Mu]", "13"], 
      SubscriptBox["\[Mu]", "15"], 
      SubscriptBox["\[Mu]", "15"]},
     {
      SubscriptBox["\[Mu]", "14"], 
      SubscriptBox["\[Mu]", "15"], 
      SubscriptBox["\[Mu]", "14"]},
     {
      SubscriptBox["\[Mu]", "15"], 
      SubscriptBox["\[Mu]", "15"], 
      SubscriptBox["\[Mu]", "15"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255708694`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"d8d0eaef-545b-4eb9-80bc-0d374c5dcf4b"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del nuevo aut\[OAcute]mata: \
\"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255728664`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"348c113e-0166-439c-873b-06f85f33b6b7"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.49999987500003124, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Mu]", "0"], {0.49999987500003124, 0.2500001874999531}], 
   CircleBox[{0.46516771116248234, 0.2107195436117775}, 0.01874999531250117, {
    1.3689481055932404`, 6.604935861576228}], 
   PolygonBox[{{0.4532649717768456, 0.2345015403504891}, {
    0.46892671716534345`, 0.22908887125568625`}, {0.45640833553271637`, 
    0.21823173642904475`}}], 
   InsetBox["\<\"b,a\"\>", {0.4511389097738482, 0.22315960212518782}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.24999993750001562, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Mu]", "1"], {0.24999993750001562, 0.7500000624999844}], 
   PolygonBox[{{0.24134948641231202`, 0.5503551376490964}, {
    0.24029422573509904`, 0.5362223344302566}, {0.2530612226879073, 
    0.5423748534855953}}], 
   CircleBox[{0.09623234777613907, 0.6418108796504313}, 0.17861345291655714, {
    5.650593057378241, 6.697890608574838}], 
   InsetBox["\<\"a\"\>", {0.27378689562245884, 0.6223905783689341}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.44963544787663046`, 0.7592174379532824}, {
    0.46377766556974354`, 0.759705774264901}, {0.4562836450717349, 
    0.7717091258971774}}], 
   CircleBox[{0.37499990625002344, 0.6059381845410244}, 0.17755551863944025, {
    1.0471975511965976`, 2.0943951023931957`}], 
   InsetBox["\<\"b\"\>", {0.37499990625002344, 0.7834937031804647}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.7499998125000469, 0.7500000624999844}, 0.03749999062500234], 
   CircleBox[{0.7499998125000469, 0.7500000624999844}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "2"], {0.7499998125000469, 0.7500000624999844}], 
   PolygonBox[{{0.30225564261133775`, 0.033835556706047785`}, {
    0.2867717036454836, 0.00735460322903111}, {0.317446851555941, 
    0.007185595472461982}}], 
   CircleBox[{-0.11732787461469706, 0.7430893410732641}, 0.8394057860300811, {
    5.214553346253386, 6.261750897449984}], 
   InsetBox["\<\"a\"\>", {0.600456479631818, 0.3079023761723245}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5347373720875183, 0.29922976697686515`}, {
    0.5248799920268519, 0.27805779027722144`}, {0.5481441517274087, 
    0.280107037079748}}], 
   CircleBox[{0.2543225014876708, 0.6815828708565252}, 0.4858331466083729, {
    5.302930349434407, 6.350227900631004}], 
   InsetBox["\<\"b\"\>", {0.6903839920120568, 0.4673768419380011}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.2500001874999531}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Mu]", "3"], {0.7499998125000469, 0.2500001874999531}], 
   PolygonBox[{{0.7404616385142528, 0.7031901334019285}, {0.7597055242649634, 
    0.7137778530696967}, {0.7592528155900435, 0.691818299308172}}], 
   CircleBox[{1.1205808621014983, 0.48427059822333685}, 0.4276734612829574, {
    2.5751409668570404`, 3.622338518053638}], 
   InsetBox["\<\"b\"\>", {0.6933000245125873, 0.5025920423548463}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.4961515397632944, 0.6937768025942368}, {0.5087433722456132, 
    0.7135336320084794}, {0.5195573721754235, 0.6927503704914719}}], 
   CircleBox[{0.9943065028400855, 0.6820853834745657}, 0.48658046213196376, {
    3.076916435724437, 4.124113986921034}], 
   InsetBox["\<\"a\"\>", {0.5580723723372145, 0.4665388003122256}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 2.499999375293882*^-7}, 
    0.03749999062500234], 
   CircleBox[{0.49999987500003124, 2.499999375293882*^-7}, 
    0.02499999375000156], InsetBox[
    SubscriptBox["\[Mu]", "4"], {0.49999987500003124, 2.499999375293882*^-7}],
    PolygonBox[{{0.9401800032783576, 0.4895789271800524}, {0.9662602695104239,
     0.4836325731621234}, {0.9480704427549684, 0.46401957707665703`}}], 
   CircleBox[{1.1422622384400491, -0.1257547254132363}, 0.6342945472980827, {
    1.8519630204701452`, 2.8991605716667426`}], 
   InsetBox["\<\"b\"\>", {0.6851464129432343, 0.3139891714317854}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7002265382398588, 0.23596844311204943`}, {
    0.7175238679771165, 0.23125019218745196`}, {0.7047890779463569, 
    0.2186293906796495}}], 
   CircleBox[{0.7825136983812732, -0.04623958509171788}, 0.2849986921906912, {
    1.8008559118093723`, 2.8480534630059697`}], 
   InsetBox["\<\"a\"\>", {0.5874859656240463, 0.1615786961204509}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.2500001874999531}, 0.03749999062500234], 
   CircleBox[{0.9999997500000625, 0.2500001874999531}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "5"], {0.9999997500000625, 0.2500001874999531}], 
   PolygonBox[{{0.9639573569006987, 0.7050117645959211}, {0.9825880129085444, 
    0.7167874036432906}, {0.9834706874654395, 0.6947649627276424}}], 
   CircleBox[{1.359321259365964, 0.508178513981809}, 0.4306339603795119, {
    2.635889439794689, 3.683086990991286}], 
   InsetBox["\<\"a\"\>", {0.9287562526529141, 0.5004724886552073}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.525229128098336, 0.7054824947304182}, {0.5324739443610537, 
    0.7312468196867864}, {0.551164096153267, 0.7120904622793381}}], 
   CircleBox[{1.1505327116171316, 0.8767627328890364}, 0.6349578889794089, {
    3.3728217865375933`, 4.420019337734191}], 
   InsetBox["\<\"b\"\>", {0.6880360747427993, 0.44171287177295776}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 2.499999375293882*^-7}, 
    0.03749999062500234], InsetBox[
    SubscriptBox["\[Mu]", "6"], {0.7499998125000469, 2.499999375293882*^-7}], 
   PolygonBox[{{0.7394039136128148, 0.45287041487801244`}, {
    0.7586137200144719, 0.4635028662781388}, {0.7582167898306562, 
    0.44155046023245964`}}], 
   CircleBox[{1.119796760302484, 0.23507866629443552}, 0.42735325402983276, {
    2.5776658569920405`, 3.624863408188638}], 
   InsetBox["\<\"a\"\>", {0.6927909720051154, 0.25230830617545363}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.4913592886455473, 0.4427805354713501}, {0.5037743756613988, 
    0.4626905760663165}, {0.5148094330990933, 0.44198377502291153`}}], 
   CircleBox[{0.9910918425586794, 0.43596716402672414}, 0.48804964326820294, {
    3.086809735501875, 4.1340072866984725`}], 
   InsetBox["\<\"b\"\>", {0.5557008304979558, 0.21545158428016972}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 0.7500000624999844}, 0.03749999062500234], 
   CircleBox[{0.49999987500003124, 0.7500000624999844}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "7"], {0.49999987500003124, 0.7500000624999844}], 
   PolygonBox[{{0.29542943953014345`, 0.5291588959880241}, {
    0.28426187214579657`, 0.5152437837210074}, {0.3018964965577189, 
    0.5125299428011968}}], 
   CircleBox[{0.18882597245241795, 0.7819565235189807}, 0.28327318355401376, {
    5.055915818273703, 6.1031133694703}], 
   InsetBox["\<\"a\"\>", {0.4048139286330599, 0.598672865475676}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.26822844523290384`, 0.3075006150443119}, {
    0.25751794950573786`, 0.2867388427877706}, {0.2808534195710726, 
    0.28784416752919084`}}], 
   CircleBox[{0.0033682333722887176, 0.7011558535123092}, 
    0.4861414783667151, {5.262409081885241, 6.309706633081838}], 
   InsetBox["\<\"b\"\>", {0.430665257696549, 0.4693136873901652}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.24999993750001562, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "8"], {0.24999993750001562, 0.5000001249999688}], 
   PolygonBox[{{0.4497303979017672, 0.5076788589221948}, {
    0.46377766556974354`, 0.5097058367648855}, {0.4549986174310771, 
    0.5208576384977675}}], 
   CircleBox[{0.3918106921504792, 0.34623253527608133}, 0.17861345291655714, {
    1.1560910253996755`, 2.203288576596212}], 
   InsetBox["\<\"a\"\>", {0.372399268620646, 0.5237880539155215}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6922830828607677, 0.7319385841546553}, {0.7132445106937279, 
    0.7425638614536394}, {0.6935620367140735, 0.755404351807085}}], 
   CircleBox[{0.6764449231815856, 0.25436235932155027}, 0.48958647481838397, {
    1.4955607370872988`, 2.542758288283896}], 
   InsetBox["\<\"b\"\>", {0.46421354974984497, 0.6955570560897335}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 2.499999375293882*^-7}, 
    0.03749999062500234], 
   CircleBox[{0.24999993750001562, 2.499999375293882*^-7}, 
    0.02499999375000156], InsetBox[
    SubscriptBox["\[Mu]", "9"], {0.24999993750001562, 2.499999375293882*^-7}],
    PolygonBox[{{0.9351813915280713, 0.5199910859701481}, {0.9632279838545945,
     0.5073544782290624}, {0.9382610643698936, 0.4893837206552504}}], 
   CircleBox[{1.0339416341058008, -0.32848637174151185}, 0.8388267680584489, {
    1.6551971560880872`, 2.702394707284685}], 
   InsetBox["\<\"b\"\>", {0.5547813916086412, 0.36001621272818063}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.929831093541249, 0.757500808916905}, {0.9625076283891538, 
    0.7492318737288466}, {0.9390082530300958, 0.7250676320369428}}], 
   CircleBox[{1.222631457889554, -0.2236837035248913}, 1.007089433534543, {
    1.832050821825428, 2.8792483730220253`}], 
   InsetBox["\<\"a\"\>", {0.510899824785647, 0.48882398736424737}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.9999997500000625, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "10"], {0.9999997500000625, 0.5000001249999688}], 
   PolygonBox[{{0.9969202042725193, 0.7076157463713325}, {1.009705461764979, 
    0.7137778530696967}, {1.0086493739603628`, 0.6996244419381191}}], 
   CircleBox[{1.1537673397239376, 0.6081893078495224}, 0.178613452916557, {
    2.5091004037884446`, 3.55629795498505}], 
   InsetBox["\<\"b\"\>", {0.9762118210844976, 0.6276007313793555}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.3054436529534166, 0.21446030525682325`}, {
    0.28354094877725966`, 0.23322968186133108`}, {0.31074705781803924`, 
    0.24281329178720457`}}], 
   CircleBox[{0.4314024836671711, 0.9557922364985645}, 0.7375362220690485, {
    4.5105407591830335`, 5.55763831037963}], 
   InsetBox["\<\"a\"\>", {0.6645969308222632, 0.2560922803174056}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 2.499999375293882*^-7}, 
    0.03749999062500234], 
   CircleBox[{0.9999997500000625, 2.499999375293882*^-7}, 
    0.02499999375000156], InsetBox[
    SubscriptBox["\[Mu]", "11"], {0.9999997500000625, 2.499999375293882*^-7}],
    PolygonBox[{{0.7274056459547379, 0.44361305943529045`}, {
    0.7392110458724737, 0.4640856180211584}, {0.7510381017294326, 
    0.44362556249763047`}}], 
   CircleBox[{1.2342059448702565, 0.45411434520768124}, 0.49509532043369825, {
    3.1214511846185165`, 4.168648735815115}], 
   InsetBox["\<\"a\"\>", {0.8005421511877253, 0.21525227127332597}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5151709319255973, 0.44367613877986073`}, {0.521923462926203,
     0.4695763581503711}, {0.5409774453643519, 0.4507783850787494}}], 
   CircleBox[{1.1372048707929476, 0.6268878834348255}, 0.6350733239979496, {
    3.391904483043421, 4.439102034240017}], 
   InsetBox["\<\"b\"\>", {0.6830113037463191, 0.18301140229703822}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.49999987500003124, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "12"], {0.49999987500003124, 0.5000001249999688}], 
   PolygonBox[{{0.9438633181056898, 0.7501367605969758}, {0.9644241352170719, 
    0.7618586007609812}, {0.9439923153002513, 0.7738038706200012}}], 
   CircleBox[{0.9514700853081377, 0.2654648106865405}, 0.49656278780584356, {
    1.5447059309785587`, 2.591903482175156}], 
   InsetBox["\<\"a\"\>", {0.7144917265739459, 0.7018314681263131}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.29836972328484834`, 0.2719690520676472}, {
    0.28651606305638927`, 0.25853376068042194`}, {0.3040781968192021, 
    0.25498583548835974`}}], 
   CircleBox[{0.20289195868051565, 0.5316734027571985}, 0.2856540826007863, {
    5.009386426533997, 6.056583977730596}], 
   InsetBox["\<\"b\"\>", {0.41186290405054965, 0.3369186880577821}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 0.2500001874999531}, 0.03749999062500234], 
   CircleBox[{0.24999993750001562, 0.2500001874999531}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "13"], {0.24999993750001562, 0.2500001874999531}], 
   PolygonBox[{{0.6925008955860011, 0.4816096958793794}, {0.7132611572122294, 
    0.49248211299424655`}, {0.6934652369770996, 0.5050248183943379}}], 
   CircleBox[{0.683092481612277, 0.006561290944532727}, 0.48685644114967364, {
    1.5087903358629435`, 2.555987887059543}], 
   InsetBox["\<\"b,a\"\>", {0.4662589100555099, 0.44246540486737934}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.9999997500000625, 0.7500000624999844}, 0.03749999062500234], 
   CircleBox[{0.9999997500000625, 0.7500000624999844}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "14"], {0.9999997500000625, 0.7500000624999844}], 
   PolygonBox[{{0.7940961596846507, 0.5321611419749613}, {0.7824757570229772, 
    0.51875012031247}, {0.7999002438042349, 0.5153920672365021}}], 
   CircleBox[{0.6981256223979196, 0.7859455518510168}, 0.2801934043590888, {
    5.0180747031815045`, 6.065272254378104}], 
   InsetBox["\<\"a\"\>", {0.9047537742355095, 0.5967019239146507}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.0382187896079802, 0.7859938624289157}, 
    0.01874999531250117, {-1.8625712978927922`, 3.373416458090196}], 
   PolygonBox[{{1.0462681344027769`, 0.7777253830813199}, {
    1.0328253041636106`, 0.7680363392427915}, {1.0479376773857405`, 
    0.761239028676176}}], 
   InsetBox["\<\"b\"\>", {1.051073718154027, 0.772344205426088}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "15"], {0.7499998125000469, 0.5000001249999688}], 
   CircleBox[{0.7313716707072564, 0.5490841443466279}, 
    0.01874999531250117, {-0.6844740527966198, 4.551513703186369}], 
   PolygonBox[{{0.7420911004358554, 0.553356559195489}, {0.7458982613112509, 
    0.5372291669260356}, {0.7579614122756965, 0.548589961095149}}], 
   InsetBox["\<\"b,a\"\>", {0.7489016776167775, 0.5557370521297673}, 
    ImageScaled[{0, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.24999993750001562`, 0.8250000437499891}, {
     0.24999993750001562`, 0.7875000531249867}}], 
    PolygonBox[{{0.24999993750001562`, 0.7875000531249867}, {
     0.23749994062501484`, 0.8062500484374879}, {0.2624999343750164, 
     0.8062500484374879}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255788555`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"6f422971-ad4e-4272-9294-09b93f1a1974"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n reducido del nuevo aut\
\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.820606725582837*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"cea4ea75-10f6-47af-a310-c1383339ba94"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.24999993750001562, 2.499999375293882*^-7}, 
    0.03749999062500234], InsetBox[
    SubscriptBox["\[Mu]", "0"], {0.24999993750001562, 2.499999375293882*^-7}],
    CircleBox[{0.21056458768678696, -0.03465666571660887}, 
    0.01874999531250117, {1.2445931110464787`, 6.480580867029467}], 
   PolygonBox[{{0.20170355637561874`, -0.009581963368126795}, {
    0.21657300086075437`, -0.01689543559733755}, {
    0.20280462587781803`, -0.026116016147022064`}}], 
   InsetBox["\<\"b,a\"\>", {0.1981871177880204, -0.020572612211884347}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.24999993750001562, 0.7500000624999844}, 0.03749999062500234], 
   InsetBox[
    SubscriptBox["\[Mu]", "1"], {0.24999993750001562, 0.7500000624999844}], 
   PolygonBox[{{0.24134948641231202`, 0.5503551376490964}, {
    0.24029422573509904`, 0.5362223344302566}, {0.2530612226879073, 
    0.5423748534855953}}], 
   CircleBox[{0.09623234777613907, 0.6418108796504313}, 0.17861345291655714, {
    5.650593057378241, 6.697890608574838}], 
   InsetBox["\<\"a\"\>", {0.27378689562245884, 0.6223905783689341}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.44963544787663046`, 0.7592174379532824}, {
    0.46377766556974354`, 0.759705774264901}, {0.4562836450717349, 
    0.7717091258971774}}], 
   CircleBox[{0.37499990625002344, 0.6059381845410244}, 0.17755551863944025, {
    1.0471975511965976`, 2.0943951023931957`}], 
   InsetBox["\<\"b\"\>", {0.37499990625002344, 0.7834937031804647}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.7499998125000469, 0.7500000624999844}, 0.03749999062500234], 
   CircleBox[{0.7499998125000469, 0.7500000624999844}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "2"], {0.7499998125000469, 0.7500000624999844}], 
   PolygonBox[{{0.759219267645945, 0.3081288319737983}, {0.7597055242649635, 
    0.2862223969302408}, {0.7784339252095287, 0.2975967250368479}}], 
   CircleBox[{0.3894316377215512, 0.5000001249999688}, 0.42755545613945617, {
    5.759486531581288, 6.8067840827778845`}], 
   InsetBox["\<\"a\"\>", {0.816987093326563, 0.4999787472271707}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   PolygonBox[{{0.2946717098345577, 0.05038581979612724}, {
    0.27816804450946464`, 0.024755189797470677`}, {0.30861665386584725`, 
    0.023277911369712002`}}], 
   CircleBox[{-0.08924161542249956, 0.7678278165316481}, 0.828943174658524, {
    5.17148392803372, 6.218681479230318}], 
   InsetBox["\<\"b\"\>", {0.6004348120987725, 0.3079439049469442}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 0.7500000624999844}, 0.03749999062500234], 
   CircleBox[{0.49999987500003124, 0.7500000624999844}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "7"], {0.49999987500003124, 0.7500000624999844}], 
   PolygonBox[{{0.2961472241523359, 0.5284815981336091}, {
    0.28426187214579657`, 0.5152437837210074}, {0.301668831720963, 
    0.5115696741567248}}], 
   CircleBox[{0.20420851355622355, 0.7852567082079107}, 0.281630111336556, {
    5.000513047257545, 6.047710598454143}], 
   InsetBox["\<\"a\"\>", {0.4085238358376033, 0.5914249030455565}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.2685372016699511, 0.3073963884484589}, {
    0.25751794950573786`, 0.2867388427877706}, {0.2809175349098375, 
    0.2875246633131994}}], 
   CircleBox[{0.007984501732632918, 0.7064383298872674}, 0.4882771764368203, {
    5.248693458377977, 6.295991009574575}], 
   InsetBox["\<\"b\"\>", {0.4339246144306778, 0.4677133386863239}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.24999993750001562, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "8"], {0.24999993750001562, 0.5000001249999688}], 
   PolygonBox[{{0.4497303979017672, 0.5076788589221948}, {
    0.46377766556974354`, 0.5097058367648855}, {0.4549986174310771, 
    0.5208576384977675}}], 
   CircleBox[{0.3918106921504792, 0.34623253527608133}, 0.17861345291655714, {
    1.1560910253996755`, 2.203288576596212}], 
   InsetBox["\<\"a\"\>", {0.372399268620646, 0.5237880539155215}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6922984156070804, 0.7318604517630226}, {0.7132611572122294, 
    0.7424820504942622}, {0.6935812120795968, 0.7553255178916704}}], 
   CircleBox[{0.6763823960717076, 0.2543070375339549}, 0.4895660183285356, {
    1.495395405542019, 2.5425929567386163`}], 
   InsetBox["\<\"b\"\>", {0.4642328335993443, 0.6955183808206398}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.2500001874999531}, 0.03749999062500234], 
   CircleBox[{0.7499998125000469, 0.2500001874999531}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "9"], {0.7499998125000469, 0.2500001874999531}], 
   PolygonBox[{{0.7469202667725038, 0.457615808871317}, {0.7597055242649634, 
    0.4637779155696811}, {0.7586494364603472, 0.4496245044381037}}], 
   CircleBox[{0.9037674022239227, 0.35818937034950654}, 0.17861345291655725, {
    2.5091004037884455`, 3.5562979549850477`}], 
   InsetBox["\<\"a\"\>", {0.7262118835844824, 0.37760079387933976}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5446951530497142, 0.03165777674205489}, {0.5324758195229615,
     0.01875024531243869}, {0.5497637364045316, 0.014621757775764077`}}], 
   CircleBox[{0.4597194867659349, 0.2902805757340494}, 0.2811088833443729, {
    4.97408836818384, 6.0212859193804364`}], 
   InsetBox["\<\"b\"\>", {0.6584736060369157, 0.0914867016636019}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 2.499999375293882*^-7}, 
    0.03749999062500234], 
   CircleBox[{0.49999987500003124, 2.499999375293882*^-7}, 
    0.02499999375000156], InsetBox[
    SubscriptBox["\[Mu]", 
     "10"], {0.49999987500003124, 2.499999375293882*^-7}], 
   PolygonBox[{{0.690911579868188, 0.48543871067609573`}, {0.7144241977170563,
     0.48814158673897196`}, {0.7050086481263538, 0.4664276243409384}}], 
   CircleBox[{1.0018972318345736, 0.08325412473405897}, 0.49656278780584356, {
    2.1882070397718434`, 3.235404590968441}], 
   InsetBox["\<\"b\"\>", {0.5504945503833565, 0.2901604354453619}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.2646117419969947, 0.2002026014555472}, {
    0.26874668512431993`, 0.2175223681398744}, {0.28167857149690406`, 
    0.2052815190062433}}], 
   CircleBox[{0.5402770157334306, 0.2902824508959572}, 0.2811098541199952, {
    3.4034049266448507`, 4.450602477841448}], 
   InsetBox["\<\"a\"\>", {0.34150489290599473, 0.09150520554317612}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.49999987500003124, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.49999987500003124, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "12"], {0.49999987500003124, 0.5000001249999688}], 
   PolygonBox[{{0.6996353853766462, 0.5092175004532669}, {0.7137776030697592, 
    0.5097058367648855}, {0.7062835825717506, 0.5217091883971618}}], 
   CircleBox[{0.624999843750039, 0.35593824704100874}, 0.17755551863944036, {
    1.0471975511965974`, 2.094395102393195}], 
   InsetBox["\<\"a\"\>", {0.6249998437500391, 0.533493765680449}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   PolygonBox[{{0.2945887466687692, 0.28184513298885044`}, {
    0.28236053925737664`, 0.2689485581628029}, {0.299643404384237, 
    0.26480690731481554`}}], 
   CircleBox[{0.20983367597602115, 0.5404795906743649}, 0.2810502579864097, {
    4.973299070811302, 6.0204966220079}], 
   InsetBox["\<\"b\"\>", {0.4083894083633689, 0.3415703936764599}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.24999993750001562, 0.2500001874999531}, 0.03749999062500234], 
   CircleBox[{0.24999993750001562, 0.2500001874999531}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "13"], {0.24999993750001562, 0.2500001874999531}], 
   PolygonBox[{{0.4497303979017676, 0.25767892142217963`}, {
    0.46377766556974354`, 0.2597058992648697}, {0.45499861743107783`, 
    0.27085770099775164`}}], 
   CircleBox[{0.39181069215047765, 0.09623259777607984}, 
    0.17861345291655714, {1.1560910253996353`, 2.2032885765962518`}], 
   InsetBox["\<\"b,a\"\>", {0.37239926862064443, 0.2737881164155201}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.03749999062500234], 
   CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "14"], {0.7499998125000469, 0.5000001249999688}], 
   PolygonBox[{{0.5446996133104162, 0.28165449638551365`}, {
    0.5324758195229615, 0.2687501828124543}, {0.5497631797893586, 
    0.26461622364842585`}}], 
   CircleBox[{0.45979647589701816, 0.5403250847728573}, 0.28113202301534485, {
    4.973782811550407, 6.020980362747004}], 
   InsetBox["\<\"a\"\>", {0.6585061986848186, 0.3414541204912511}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7871229092315665, 0.5371232217314884}, 
    0.01874999531250117, {-1.8325957145940457`, 3.4033920413889427`}], 
   PolygonBox[{{0.7954164533614578, 0.5290997045405874}, {0.7822700533491082, 
    0.5190121170163445}, {0.7975793604141763, 0.5126707943994591}}], 
   InsetBox["\<\"b\"\>", {0.800381158064252, 0.5238649728988028}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.49999987500003124, 0.2500001874999531}, 0.03749999062500234], 
   CircleBox[{0.49999987500003124, 0.2500001874999531}, 0.02499999375000156], 
   InsetBox[
    SubscriptBox["\[Mu]", "15"], {0.49999987500003124, 0.2500001874999531}], 
   CircleBox[{0.506852498378428, 0.19794934529053865}, 
    0.01874999531250117, {-4.057890510886816, 1.178097245096172}], 
   PolygonBox[{{0.4810875993120484, 0.20453937942260098`}, {0.495438224438083,
     0.21282471670215644`}, {0.495438224438083, 0.19625404214304548`}}], 
   InsetBox["\<\"b,a\"\>", {0.4882629118750657, 0.19550197979825407}, 
    ImageScaled[{1, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.24999993750001562`, 0.8250000437499891}, {
     0.24999993750001562`, 0.7875000531249867}}], 
    PolygonBox[{{0.24999993750001562`, 0.7875000531249867}, {
     0.23749994062501484`, 0.8062500484374879}, {0.2624999343750164, 
     0.8062500484374879}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.8205747689798093`*^9, 
  3.8206038565950985`*^9, 3.8206041920703373`*^9, 3.820604619139394*^9, 
  3.8206054858592577`*^9, 3.8206067255868263`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"40725c3a-ffeb-4acb-83e0-c3a85b752ecb"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{822.8571428571428, 401.1428571428571},
WindowMargins->{{-828, Automatic}, {-1, Automatic}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a8572f35-c064-47f4-a398-4a1b85c180ca"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 42, "Input",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],
Cell[CellGroupData[{
Cell[785, 27, 426, 10, 65, "Input",ExpressionUUID->"603202cf-4fe8-46de-94bb-782e903e369c"],
Cell[1214, 39, 2190, 65, 107, "Output",ExpressionUUID->"b806a771-307b-4215-bf42-e2cf9e3ccb0d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3441, 109, 3436, 84, 159, "Input",ExpressionUUID->"7e877a78-b0d2-431a-b2e6-ca4b1233d0fe"],
Cell[CellGroupData[{
Cell[6902, 197, 424, 7, 33, "Print",ExpressionUUID->"27d1671a-0d19-4095-94de-c09e065f85d5"],
Cell[7329, 206, 5693, 102, 556, "Print",ExpressionUUID->"21857b65-3e48-4153-b3a6-1648e1616771"],
Cell[13025, 310, 379, 6, 33, "Print",ExpressionUUID->"eb7ed5c2-bd3e-4985-91dc-1ddc2629f543"],
Cell[13407, 318, 562, 14, 33, "Print",ExpressionUUID->"4c9dfb8b-f0af-443c-866a-6dd4d64adfd9"],
Cell[13972, 334, 636, 16, 33, "Print",ExpressionUUID->"7b75d0f0-1bbf-4a54-8a6d-ed4a934cbbe6"],
Cell[14611, 352, 636, 16, 33, "Print",ExpressionUUID->"03adc74d-6139-4827-b148-ecfb45cffa34"],
Cell[15250, 370, 638, 16, 33, "Print",ExpressionUUID->"454ca7cc-6cf7-4182-acb6-2ee58ea54d0b"],
Cell[15891, 388, 635, 16, 33, "Print",ExpressionUUID->"287de901-2d17-41f3-908d-3f2d50370dd8"],
Cell[16529, 406, 738, 19, 33, "Print",ExpressionUUID->"46ff7eb5-b343-4ac9-b05b-a11858223b5d"],
Cell[17270, 427, 736, 19, 33, "Print",ExpressionUUID->"88bf629c-7533-4d96-a713-4b7f6a15fab4"],
Cell[18009, 448, 738, 19, 33, "Print",ExpressionUUID->"c5ab2374-0930-4e31-a539-0e3e5f960ade"],
Cell[18750, 469, 738, 19, 33, "Print",ExpressionUUID->"f9842a63-661b-42c0-8853-ea8dda8d7aac"],
Cell[19491, 490, 738, 19, 33, "Print",ExpressionUUID->"54381b22-db72-4e1c-b3ca-dbe27bbbf1e1"],
Cell[20232, 511, 740, 19, 33, "Print",ExpressionUUID->"7f052c75-8446-4ee4-ad0d-9f34c4056174"],
Cell[20975, 532, 822, 21, 33, "Print",ExpressionUUID->"92c36cae-ba7c-4110-8e44-b39f465c86c2"],
Cell[21800, 555, 822, 21, 33, "Print",ExpressionUUID->"0f2a0747-5ac5-4934-98fe-53b1b006b83d"],
Cell[22625, 578, 822, 21, 33, "Print",ExpressionUUID->"6663acef-5045-4fd6-a4b4-4ee763057b95"],
Cell[23450, 601, 822, 21, 33, "Print",ExpressionUUID->"f3bf5ef6-22cc-4845-904b-d339818483d3"],
Cell[24275, 624, 908, 23, 33, "Print",ExpressionUUID->"2fd84845-45cf-4631-9a79-940f75291c36"],
Cell[25186, 649, 539, 12, 33, "Print",ExpressionUUID->"f33c567e-46d0-450d-bf6d-14d3d4aa33da"],
Cell[25728, 663, 1459, 36, 33, "Print",ExpressionUUID->"a8763f52-c83c-480b-ad9a-fe34bc8d024e"],
Cell[27190, 701, 2604, 84, 418, "Print",ExpressionUUID->"d8d0eaef-545b-4eb9-80bc-0d374c5dcf4b"],
Cell[29797, 787, 404, 7, 33, "Print",ExpressionUUID->"348c113e-0166-439c-873b-06f85f33b6b7"],
Cell[30204, 796, 15231, 266, 562, "Print",ExpressionUUID->"6f422971-ad4e-4272-9294-09b93f1a1974"],
Cell[45438, 1064, 411, 7, 33, "Print",ExpressionUUID->"cea4ea75-10f6-47af-a310-c1383339ba94"],
Cell[45852, 1073, 10474, 184, 660, "Print",ExpressionUUID->"40725c3a-ffeb-4acb-83e0-c3a85b752ecb"]
}, Open  ]]
}, Open  ]]
}
]
*)

