(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     52671,       1387]
NotebookOptionsPosition[     51538,       1361]
NotebookOutlinePosition[     51972,       1378]
CellTagsIndexPosition[     51929,       1375]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8116179030658407`*^9, 
  3.811617910486431*^9}},ExpressionUUID->"baad70ba-9f35-4cd7-b5f5-\
e654e819e809"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h"}], "}"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Lista", "=", 
  RowBox[{"GeneraRutas", "[", 
   RowBox[{"grafo", ",", "a", ",", "h", ",", "5"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ResaltarRuta", "[", 
    RowBox[{"grafo", ",", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "Lista"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8116170761970296`*^9, 3.811617113353012*^9}, {
   3.811617928667148*^9, 3.811617951190117*^9}, {3.811617997095969*^9, 
   3.8116180097378674`*^9}, 3.8116189109436817`*^9, 3.8116194854640694`*^9, 
   3.811619520066034*^9},
 CellLabel->"In[80]:=",ExpressionUUID->"a7758fe9-c2f2-4dbe-b56a-4f087db44b42"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`f, \
$CellContext`h, $CellContext`d, $CellContext`e, $CellContext`g}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 6}, {3, 6}, {3, 7}, {
       3, 5}, {6, 7}, {6, 4}, {7, 4}, {7, 5}, {4, 8}, {4, 5}, {8, 5}}}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQAGImKC7y+rXN9vNf+wsXorIjb3y3L16jcku2lt3hfEP4
tM+OH+3R5e/xNNZmf2BwSLZ98vihwCsM+TnX3j+rO/7RPpZrL8O0ngcY8i2z
fmR2TvxgbzXdSqVa7SOGfejmo8uHbWtaue0Zk8OJ3dV+ge4HMNSjm48uT0i/
uaGR8JWjP+wZoADdP+jmo8ujm48uT8h8mPis5cc9ezJfY9iHrh9dHl0/unvQ
9QMAcAXygA==
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.8718850276533456, 1.490319651941764}, 
          0.029779458503799247], 
         InsetBox["a", 
          Offset[{2, 2}, {1.9016644861571448, 1.5200991104455632}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.936092094654265, 1.07860144355077}, 0.029779458503799247],
          InsetBox["b", 
          Offset[{2, 2}, {2.965871553158064, 1.1083809020545692}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1173925213821425, 0.8145608378417076}, 
          0.029779458503799247], 
         InsetBox["c", 
          Offset[{2, 2}, {2.147171979885942, 0.8443402963455069}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.1112050076457427, 0.517161370699181}, 
          0.029779458503799247], 
         InsetBox["f", 
          Offset[{2, 2}, {1.1409844661495419, 0.5469408292029803}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0355314387794872, 1.071894780653976}, 
          0.029779458503799247], 
         InsetBox["h", 
          Offset[{2, 2}, {1.0653108972832863, 1.1016742391577752}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.36265308790352, 0.12717644054597899}, 
          0.029779458503799247], 
         InsetBox["d", 
          Offset[{2, 2}, {2.3924325464073193, 0.15695589904977825}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.548297953590987, 0.}, 0.029779458503799247], 
         InsetBox["e", 
          Offset[{2, 2}, {1.5780774120947862, 0.029779458503799247}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.8566342774404234}, 0.029779458503799247], 
         InsetBox["g", 
          Offset[{2, 2}, {0.029779458503799247, 0.8864137359442227}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.811617098997498*^9, 3.811617113734992*^9}, 
   3.811617952045024*^9, {3.8116180003676567`*^9, 3.8116180106411877`*^9}, 
   3.81161891143038*^9, 3.8116194867343483`*^9, 3.8116195209746056`*^9, 
   3.8116217992208457`*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"95096a82-39fa-403b-b68d-fe13d83d1a40"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "h"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "h"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.811617098997498*^9, 3.811617113734992*^9}, 
   3.811617952045024*^9, {3.8116180003676567`*^9, 3.8116180106411877`*^9}, 
   3.81161891143038*^9, 3.8116194867343483`*^9, 3.8116195209746056`*^9, 
   3.8116217992248955`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"82222f84-31f1-4e53-b8d7-806e49b1b99c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`f, \
$CellContext`h, $CellContext`d, $CellContext`e, $CellContext`g}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 6}, {3, 6}, {3, 
         7}, {3, 5}, {6, 7}, {6, 4}, {7, 4}, {7, 5}, {4, 8}, {4, 5}, {8, 
         5}}}, {GraphHighlight -> {
           UndirectedEdge[$CellContext`a, $CellContext`h]}, 
         GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
         VertexLabels -> {"Name"}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           2.936092094654265, 1.07860144355077}}], 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           2.1173925213821425`, 0.8145608378417076}}], 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           1.1112050076457427`, 0.517161370699181}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.8718850276533456`, 1.490319651941764}, {
            1.0355314387794872`, 1.071894780653976}}]}, 
          LineBox[{{2.936092094654265, 1.07860144355077}, {
           2.1173925213821425`, 0.8145608378417076}}], 
          LineBox[{{2.936092094654265, 1.07860144355077}, {2.36265308790352, 
           0.12717644054597899`}}], 
          LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
           1.0355314387794872`, 1.071894780653976}}], 
          LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
           2.36265308790352, 0.12717644054597899`}}], 
          LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
           1.548297953590987, 0.}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           1.0355314387794872`, 1.071894780653976}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           2.36265308790352, 0.12717644054597899`}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           1.548297953590987, 0.}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {0., 
           0.8566342774404234}}], 
          LineBox[{{1.0355314387794872`, 1.071894780653976}, {
           1.548297953590987, 0.}}], 
          LineBox[{{1.0355314387794872`, 1.071894780653976}, {0., 
           0.8566342774404234}}], 
          LineBox[{{2.36265308790352, 0.12717644054597899`}, {
           1.548297953590987, 0.}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {
           DiskBox[{1.8718850276533456, 1.490319651941764}, 
            0.029779458503799247], 
           InsetBox["a", 
            Offset[{2, 2}, {1.9016644861571448, 1.5200991104455632}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.936092094654265, 1.07860144355077}, 
            0.029779458503799247], 
           InsetBox["b", 
            Offset[{2, 2}, {2.965871553158064, 1.1083809020545692}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.1173925213821425, 0.8145608378417076}, 
            0.029779458503799247], 
           InsetBox["c", 
            Offset[{2, 2}, {2.147171979885942, 0.8443402963455069}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.1112050076457427, 0.517161370699181}, 
            0.029779458503799247], 
           InsetBox["f", 
            Offset[{2, 2}, {1.1409844661495419, 0.5469408292029803}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.0355314387794872, 1.071894780653976}, 
            0.029779458503799247], 
           InsetBox["h", 
            Offset[{2, 2}, {1.0653108972832863, 1.1016742391577752}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.36265308790352, 0.12717644054597899}, 
            0.029779458503799247], 
           InsetBox["d", 
            Offset[{2, 2}, {2.3924325464073193, 0.15695589904977825}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.548297953590987, 0.}, 0.029779458503799247], 
           InsetBox["e", 
            Offset[{2, 2}, {1.5780774120947862, 0.029779458503799247}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.8566342774404234}, 0.029779458503799247], 
           InsetBox["g", 
            Offset[{2, 2}, {0.029779458503799247, 0.8864137359442227}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->10], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`f, \
$CellContext`h, $CellContext`d, $CellContext`e, $CellContext`g}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 6}, {3, 6}, {3, 
         7}, {3, 5}, {6, 7}, {6, 4}, {7, 4}, {7, 5}, {4, 8}, {4, 5}, {8, 
         5}}}, {GraphHighlight -> {
           UndirectedEdge[$CellContext`a, $CellContext`f], 
           UndirectedEdge[$CellContext`f, $CellContext`h]}, 
         GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
         VertexLabels -> {"Name"}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           2.936092094654265, 1.07860144355077}}], 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           2.1173925213821425`, 0.8145608378417076}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.8718850276533456`, 1.490319651941764}, {
            1.1112050076457427`, 0.517161370699181}}]}, 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           1.0355314387794872`, 1.071894780653976}}], 
          LineBox[{{2.936092094654265, 1.07860144355077}, {
           2.1173925213821425`, 0.8145608378417076}}], 
          LineBox[{{2.936092094654265, 1.07860144355077}, {2.36265308790352, 
           0.12717644054597899`}}], 
          LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
           1.0355314387794872`, 1.071894780653976}}], 
          LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
           2.36265308790352, 0.12717644054597899`}}], 
          LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
           1.548297953590987, 0.}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.1112050076457427`, 0.517161370699181}, {
            1.0355314387794872`, 1.071894780653976}}]}, 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           2.36265308790352, 0.12717644054597899`}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           1.548297953590987, 0.}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {0., 
           0.8566342774404234}}], 
          LineBox[{{1.0355314387794872`, 1.071894780653976}, {
           1.548297953590987, 0.}}], 
          LineBox[{{1.0355314387794872`, 1.071894780653976}, {0., 
           0.8566342774404234}}], 
          LineBox[{{2.36265308790352, 0.12717644054597899`}, {
           1.548297953590987, 0.}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {
           DiskBox[{1.8718850276533456, 1.490319651941764}, 
            0.029779458503799247], 
           InsetBox["a", 
            Offset[{2, 2}, {1.9016644861571448, 1.5200991104455632}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.936092094654265, 1.07860144355077}, 
            0.029779458503799247], 
           InsetBox["b", 
            Offset[{2, 2}, {2.965871553158064, 1.1083809020545692}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.1173925213821425, 0.8145608378417076}, 
            0.029779458503799247], 
           InsetBox["c", 
            Offset[{2, 2}, {2.147171979885942, 0.8443402963455069}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.1112050076457427, 0.517161370699181}, 
            0.029779458503799247], 
           InsetBox["f", 
            Offset[{2, 2}, {1.1409844661495419, 0.5469408292029803}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.0355314387794872, 1.071894780653976}, 
            0.029779458503799247], 
           InsetBox["h", 
            Offset[{2, 2}, {1.0653108972832863, 1.1016742391577752}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.36265308790352, 0.12717644054597899}, 
            0.029779458503799247], 
           InsetBox["d", 
            Offset[{2, 2}, {2.3924325464073193, 0.15695589904977825}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.548297953590987, 0.}, 0.029779458503799247], 
           InsetBox["e", 
            Offset[{2, 2}, {1.5780774120947862, 0.029779458503799247}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.8566342774404234}, 0.029779458503799247], 
           InsetBox["g", 
            Offset[{2, 2}, {0.029779458503799247, 0.8864137359442227}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->10], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`f, \
$CellContext`h, $CellContext`d, $CellContext`e, $CellContext`g}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 6}, {3, 6}, {3, 
         7}, {3, 5}, {6, 7}, {6, 4}, {7, 4}, {7, 5}, {4, 8}, {4, 5}, {8, 
         5}}}, {GraphHighlight -> {
           UndirectedEdge[$CellContext`a, $CellContext`c], 
           UndirectedEdge[$CellContext`c, $CellContext`e], 
           UndirectedEdge[$CellContext`e, $CellContext`h]}, 
         GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
         VertexLabels -> {"Name"}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           2.936092094654265, 1.07860144355077}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.8718850276533456`, 1.490319651941764}, {
            2.1173925213821425`, 0.8145608378417076}}]}, 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           1.1112050076457427`, 0.517161370699181}}], 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           1.0355314387794872`, 1.071894780653976}}], 
          LineBox[{{2.936092094654265, 1.07860144355077}, {
           2.1173925213821425`, 0.8145608378417076}}], 
          LineBox[{{2.936092094654265, 1.07860144355077}, {2.36265308790352, 
           0.12717644054597899`}}], 
          LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
           1.0355314387794872`, 1.071894780653976}}], 
          LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
           2.36265308790352, 0.12717644054597899`}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
            1.548297953590987, 0.}}]}, 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           1.0355314387794872`, 1.071894780653976}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           2.36265308790352, 0.12717644054597899`}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           1.548297953590987, 0.}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {0., 
           0.8566342774404234}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.0355314387794872`, 1.071894780653976}, {
            1.548297953590987, 0.}}]}, 
          LineBox[{{1.0355314387794872`, 1.071894780653976}, {0., 
           0.8566342774404234}}], 
          LineBox[{{2.36265308790352, 0.12717644054597899`}, {
           1.548297953590987, 0.}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {
           DiskBox[{1.8718850276533456, 1.490319651941764}, 
            0.029779458503799247], 
           InsetBox["a", 
            Offset[{2, 2}, {1.9016644861571448, 1.5200991104455632}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.936092094654265, 1.07860144355077}, 
            0.029779458503799247], 
           InsetBox["b", 
            Offset[{2, 2}, {2.965871553158064, 1.1083809020545692}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.1173925213821425, 0.8145608378417076}, 
            0.029779458503799247], 
           InsetBox["c", 
            Offset[{2, 2}, {2.147171979885942, 0.8443402963455069}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.1112050076457427, 0.517161370699181}, 
            0.029779458503799247], 
           InsetBox["f", 
            Offset[{2, 2}, {1.1409844661495419, 0.5469408292029803}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.0355314387794872, 1.071894780653976}, 
            0.029779458503799247], 
           InsetBox["h", 
            Offset[{2, 2}, {1.0653108972832863, 1.1016742391577752}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.36265308790352, 0.12717644054597899}, 
            0.029779458503799247], 
           InsetBox["d", 
            Offset[{2, 2}, {2.3924325464073193, 0.15695589904977825}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.548297953590987, 0.}, 0.029779458503799247], 
           InsetBox["e", 
            Offset[{2, 2}, {1.5780774120947862, 0.029779458503799247}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.8566342774404234}, 0.029779458503799247], 
           InsetBox["g", 
            Offset[{2, 2}, {0.029779458503799247, 0.8864137359442227}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->10], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`f, \
$CellContext`h, $CellContext`d, $CellContext`e, $CellContext`g}, {
        Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 6}, {3, 6}, {3, 
         7}, {3, 5}, {6, 7}, {6, 4}, {7, 4}, {7, 5}, {4, 8}, {4, 5}, {8, 
         5}}}, {GraphHighlight -> {
           UndirectedEdge[$CellContext`c, $CellContext`h], 
           UndirectedEdge[$CellContext`b, $CellContext`c], 
           UndirectedEdge[$CellContext`a, $CellContext`b]}, 
         GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
         VertexLabels -> {"Name"}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{1.8718850276533456`, 1.490319651941764}, {
            2.936092094654265, 1.07860144355077}}]}, 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           2.1173925213821425`, 0.8145608378417076}}], 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           1.1112050076457427`, 0.517161370699181}}], 
          LineBox[{{1.8718850276533456`, 1.490319651941764}, {
           1.0355314387794872`, 1.071894780653976}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.936092094654265, 1.07860144355077}, {
            2.1173925213821425`, 0.8145608378417076}}]}, 
          LineBox[{{2.936092094654265, 1.07860144355077}, {2.36265308790352, 
           0.12717644054597899`}}], 
          {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
           LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
            1.0355314387794872`, 1.071894780653976}}]}, 
          LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
           2.36265308790352, 0.12717644054597899`}}], 
          LineBox[{{2.1173925213821425`, 0.8145608378417076}, {
           1.548297953590987, 0.}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           1.0355314387794872`, 1.071894780653976}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           2.36265308790352, 0.12717644054597899`}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {
           1.548297953590987, 0.}}], 
          LineBox[{{1.1112050076457427`, 0.517161370699181}, {0., 
           0.8566342774404234}}], 
          LineBox[{{1.0355314387794872`, 1.071894780653976}, {
           1.548297953590987, 0.}}], 
          LineBox[{{1.0355314387794872`, 1.071894780653976}, {0., 
           0.8566342774404234}}], 
          LineBox[{{2.36265308790352, 0.12717644054597899`}, {
           1.548297953590987, 0.}}]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {
           DiskBox[{1.8718850276533456, 1.490319651941764}, 
            0.029779458503799247], 
           InsetBox["a", 
            Offset[{2, 2}, {1.9016644861571448, 1.5200991104455632}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.936092094654265, 1.07860144355077}, 
            0.029779458503799247], 
           InsetBox["b", 
            Offset[{2, 2}, {2.965871553158064, 1.1083809020545692}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.1173925213821425, 0.8145608378417076}, 
            0.029779458503799247], 
           InsetBox["c", 
            Offset[{2, 2}, {2.147171979885942, 0.8443402963455069}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.1112050076457427, 0.517161370699181}, 
            0.029779458503799247], 
           InsetBox["f", 
            Offset[{2, 2}, {1.1409844661495419, 0.5469408292029803}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.0355314387794872, 1.071894780653976}, 
            0.029779458503799247], 
           InsetBox["h", 
            Offset[{2, 2}, {1.0653108972832863, 1.1016742391577752}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{2.36265308790352, 0.12717644054597899}, 
            0.029779458503799247], 
           InsetBox["d", 
            Offset[{2, 2}, {2.3924325464073193, 0.15695589904977825}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{1.548297953590987, 0.}, 0.029779458503799247], 
           InsetBox["e", 
            Offset[{2, 2}, {1.5780774120947862, 0.029779458503799247}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.8566342774404234}, 0.029779458503799247], 
           InsetBox["g", 
            Offset[{2, 2}, {0.029779458503799247, 0.8864137359442227}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FormatType->TraditionalForm,
    FrameTicks->None,
    ImagePadding->10]}], "}"}]], "Output",
 CellChangeTimes->{{3.811617098997498*^9, 3.811617113734992*^9}, 
   3.811617952045024*^9, {3.8116180003676567`*^9, 3.8116180106411877`*^9}, 
   3.81161891143038*^9, 3.8116194867343483`*^9, 3.8116195209746056`*^9, 
   3.811621799315117*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"857db761-7430-4e4f-889f-76e2ca864360"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grafo", "=", 
   RowBox[{"Grafo", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "h"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GeneraRutas", "[", 
  RowBox[{"grafo", ",", "a", ",", "h", ",", "5"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CantRutas", "[", 
  RowBox[{"grafo", ",", "a", ",", "h", ",", 
   RowBox[{"rutas", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.811618920190406*^9, 3.8116189440590754`*^9}, {
  3.811619085681084*^9, 3.811619123049724*^9}, {3.8116196186017036`*^9, 
  3.8116196212950315`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"e78672b8-d52c-49bc-9dbd-c250b67a21ee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "h"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "h"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8116189265264893`*^9, 3.811618944794029*^9}, {
   3.811619098059617*^9, 3.8116191237966337`*^9}, 3.8116196225754757`*^9, 
   3.8116196959182143`*^9, 3.811621805331086*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"2770ea10-8363-4df8-bf68-8e5d1f77aa29"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"55", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"a", ",", "h"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8116189265264893`*^9, 3.811618944794029*^9}, {
   3.811619098059617*^9, 3.8116191237966337`*^9}, 3.8116196225754757`*^9, 
   3.8116196959182143`*^9, 3.8116218053510337`*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"1f885bd2-2662-4307-97ba-e45cb4e8f155"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"1b4f9a03-75a6-4393-99aa-e66c77afc29b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 182, 4, 63, "Input",ExpressionUUID->"baad70ba-9f35-4cd7-b5f5-e654e819e809"],
Cell[CellGroupData[{
Cell[765, 28, 1795, 51, 384, "Input",ExpressionUUID->"a7758fe9-c2f2-4dbe-b56a-4f087db44b42"],
Cell[2563, 81, 3478, 75, 450, "Output",ExpressionUUID->"95096a82-39fa-403b-b68d-fe13d83d1a40"],
Cell[6044, 158, 1081, 32, 188, "Output",ExpressionUUID->"82222f84-31f1-4e53-b8d7-806e49b1b99c"],
Cell[7128, 192, 20814, 421, 1196, "Output",ExpressionUUID->"857db761-7430-4e4f-889f-76e2ca864360"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27979, 618, 1691, 48, 384, "Input",ExpressionUUID->"e78672b8-d52c-49bc-9dbd-c250b67a21ee"],
Cell[29673, 668, 1032, 31, 188, "Output",ExpressionUUID->"2770ea10-8363-4df8-bf68-8e5d1f77aa29"],
Cell[30708, 701, 20814, 657, 2591, "Output",ExpressionUUID->"1f885bd2-2662-4307-97ba-e45cb4e8f155"]
}, Open  ]]
}
]
*)

