(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     44612,        981]
NotebookOptionsPosition[     42130,        939]
NotebookOutlinePosition[     42565,        956]
CellTagsIndexPosition[     42522,        953]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8202311176947727`*^9, 3.8202311208363905`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Sigma]", "0"], ",", 
    SubscriptBox["\[Sigma]", "1"], ",", 
    SubscriptBox["\[Sigma]", "2"]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.8205743488207197`*^9, 3.820574362748187*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"603202cf-4fe8-46de-94bb-782e903e369c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "0"], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "1"], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "2"], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8205743629133587`*^9, 3.8205748121271453`*^9, 
  3.8205748847756624`*^9, 3.820657921055094*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"b3088cfc-1dab-4b53-ac5d-29437db7932b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     SubscriptBox["\[Sigma]", "2"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "0"], ",", 
           SubscriptBox["\[Sigma]", "1"], ",", 
           SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "1"], ",", 
           SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "c", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "0"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "d", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "0"], ",", 
           SubscriptBox["\[Sigma]", "1"], ",", 
           SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "0"], ",", 
           SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "c", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "0"], ",", 
           SubscriptBox["\[Sigma]", "1"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "d", ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "2"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "0"], ",", 
           SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "c", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "0"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "d", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "1"], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataDeterministicoEquivalente", "[", "A", "]"}]}], "Input",
 CellChangeTimes->{{3.8202311310330486`*^9, 3.820231265805186*^9}, {
   3.820231862894062*^9, 3.8202319081620555`*^9}, {3.8202320078918257`*^9, 
   3.820232010904651*^9}, 3.8202321800940557`*^9, {3.8202331332510276`*^9, 
   3.8202331336190195`*^9}, {3.820310676202611*^9, 3.820310730815018*^9}, {
   3.820313080338834*^9, 3.8203130857585125`*^9}, {3.8203135274070387`*^9, 
   3.820313622393606*^9}, {3.8203137203789926`*^9, 3.8203138713359356`*^9}, {
   3.8203139618671274`*^9, 3.820314028995368*^9}, {3.8203140618640323`*^9, 
   3.8203140912089596`*^9}, {3.8203141490563393`*^9, 
   3.8203141767049627`*^9}, {3.82031659456876*^9, 3.8203167006102066`*^9}, {
   3.820316854244767*^9, 3.8203169370201435`*^9}, {3.8203171727548833`*^9, 
   3.8203171921060047`*^9}, {3.8203179402214584`*^9, 
   3.8203179520553885`*^9}, {3.820574321153582*^9, 3.820574369996811*^9}, {
   3.8205748057346773`*^9, 3.820574809157371*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"7e877a78-b0d2-431a-b2e6-ca4b1233d0fe"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del aut\[OAcute]mata no \
determin\[IAcute]stico: \"\>"], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.820657923463339*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"c3b348d3-5faf-4a07-b21a-c0a6855aff39"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.04999997500001249], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.99999950000025, 0.500000249999875}], 
   PolygonBox[{{0.5880431180062965, 0.4570598695278279}, {0.5724441507496048, 
    0.4805888313228953}, {0.6006203130171525, 0.48233345234245834`}}], 
   CircleBox[{0.740709800600417, 0.7912774043431234}, 0.3533280604838605, {
    4.216025938104314, 5.263123489301952}], 
   InsetBox["\<\"d,b,a\"\>", {0.7503140998925111, 0.4380799018598889}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6002907396856809, 0.026667774255220763`}, {
    0.5749997125001437, 4.999997500476638*^-7}, {
    0.6107397630478366, -0.008568534902992638}}], 
   CircleBox[{0.41943899367211657, 0.5805610063278834}, 0.6010404634883338, {
    4.974088368183839, 6.021285919380437}], 
   InsetBox["\<\"d,b,a\"\>", {0.8443962790685449, 0.1555187209740968}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.097006802410284, 0.5401819903073393}, 
    0.03749998125000937, {-2.2252947962927703`, 3.010692959690218}], 
   PolygonBox[{{1.0976127270772782`, 0.48699678808123537`}, {
    1.074178260236728, 0.5104312549217856}, {1.1061903372650637`, 
    0.519008865109571}}], 
   InsetBox["\<\"d,c,a\"\>", {1.111357423948664, 0.5055365251608985}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 0.07499996250001874],
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
    0.04999997500001249], InsetBox[
    SubscriptBox["\[Sigma]", 
     "1"], {0.499999750000125, 4.999997500476638*^-7}], 
   PolygonBox[{{0.9059760489790732, 0.4625820305288293}, {0.9404980292291427, 
    0.45434316565276317`}, {0.9161019728230874, 0.42856568620529134`}}], 
   CircleBox[{1.0850199370165228, -0.08501993701652255}, 0.5583897727855898, {
    1.8325957145940464`, 2.879793265790644}], 
   InsetBox["\<\"c,b\"\>", {0.6901787421346166, 0.3098212578653833}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.45459154652682254`, 0.4144284442648523}, {
    0.48058833132314527`, 0.4275558492503953}, {0.47895860512823063`, 
    0.3984782707072913}}], 
   CircleBox[{0.7881234338871421, 0.21117753764585312}, 0.37602847371160686, {
    2.5284620315250943`, 3.575659582721692}], 
   InsetBox["\<\"b\"\>", {0.41360106670899666, 0.2447991010413736}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.45981800969266073, -0.09700680241028384}, 
    0.03749998125000937, {-4.581489286485114, 0.6544984694978737}], 
   PolygonBox[{{0.4217819390988849, -0.05982763869834785}, {
    0.45492327993177367`, -0.05982763869834781}, {
    0.43835260951532934`, -0.08852888177510804}}], 
   InsetBox["\<\"c\"\>", {0.42517254454622005, -0.08265618087190374}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "2"], {0.499999750000125, 0.500000249999875}], 
   PolygonBox[{{0.5095829239822125, 0.10254742081936055`}, {
    0.5097892095218991, 0.0743588274236221}, {0.5340981047297155, 
    0.08863177263929331}}], 
   CircleBox[{0.2087225956565094, 0.259290199399593}, 0.35332806048386056, {
    5.732250798262844, 6.779548349459441}], 
   InsetBox["\<\"d\"\>", {0.5619191359438289, 0.24965058040533092}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9180635962529156, 0.549457941866081}, {0.94696651792775, 
    0.5530332320723751}, {0.9294187649457804, 0.5762762513832265}}], 
   CircleBox[{0.7888224623541493, 0.21187656611283145}, 0.37602847371160686, {
    1.136729397663033, 2.1839269488595603`}], 
   InsetBox["\<\"c,b\"\>", {0.755200898958629, 0.5863989332909769}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.3958980916067041, 0.5137054933303588}, 0.03749998125000937, {
    0.3926990816987246, 5.6286868376817125`}], 
   PolygonBox[{{0.398531479724809, 0.5366337250565242}, {0.43054355675314476`,
     0.5280561148687388}, {0.4219659465653593, 0.5600681918970746}}], 
   InsetBox["\<\"b,a\"\>", {0.40079282136759115, 0.5508846570422947}, 
    ImageScaled[{0, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.820657923481552*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"e1c21f91-ac66-49d7-975f-1c85917dbee1"],

Cell[BoxData["\<\"Estados del nuevo aut\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.820657923481552*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"ce6a7ea9-3491-44b0-8fff-becff25bb948"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "0"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 0], "=", {}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.820657923481552*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"5cb4b4e0-bdf2-4bcc-825c-89af6b712b89"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "1"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "0"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 1], "=", {
    Subscript[$CellContext`\[Sigma], 0]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.82065792349818*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"ddeb4ba0-6937-4db0-a06d-1c5162cd34ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "2"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "1"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 2], "=", {
    Subscript[$CellContext`\[Sigma], 1]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.82065792349818*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"9f352cae-f7d6-411f-b6ca-a948633e8aa4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "3"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "2"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 3], "=", {
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.82065792349818*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"aa608962-c76b-4b01-9209-41ac31aaa070"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "4"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 4], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.82065792349818*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"903afdb2-edd9-4b3f-a874-ebe2786cb54e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "5"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 5], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.82065792349818*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"573b2871-e0f9-47ed-910a-767189cee64d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "6"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 6], "=", {
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.8206579235148306`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"6844eb5e-c83d-45b2-9540-5a722c7f320e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "7"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 7], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.8206579235148306`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"2f4dbada-8d9b-4548-8f1d-15744f6443e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", 
   SubscriptBox["\[Mu]", "3"]}],
  SequenceForm["Estado inicial: ", 
   Subscript[$CellContext`\[Mu], 3]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.8206579235148306`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"1f8d75de-67de-4974-a402-9e557d27c1c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Mu]", "1"], ",", 
     SubscriptBox["\[Mu]", "2"], ",", 
     SubscriptBox["\[Mu]", "4"], ",", 
     SubscriptBox["\[Mu]", "5"], ",", 
     SubscriptBox["\[Mu]", "6"], ",", 
     SubscriptBox["\[Mu]", "7"]}], "}"}]}],
  SequenceForm["Estados aceptados: ", {
    Subscript[$CellContext`\[Mu], 1], 
    Subscript[$CellContext`\[Mu], 2], 
    Subscript[$CellContext`\[Mu], 4], 
    Subscript[$CellContext`\[Mu], 5], 
    Subscript[$CellContext`\[Mu], 6], 
    Subscript[$CellContext`\[Mu], 7]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.8206579235148306`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"464fed56-ab5c-4ed2-9d66-b9528519e0e2"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "a", "b", "c", "d"},
     {
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "6"], 
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "7"]},
     {
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "5"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "3"], 
      SubscriptBox["\[Mu]", "3"], 
      SubscriptBox["\[Mu]", "5"], 
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "2"]},
     {
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "7"]},
     {
      SubscriptBox["\[Mu]", "5"], 
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "7"]},
     {
      SubscriptBox["\[Mu]", "6"], 
      SubscriptBox["\[Mu]", "3"], 
      SubscriptBox["\[Mu]", "5"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "2"]},
     {
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "7"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.8206579235148306`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"36cc83cf-6f66-449a-a5bc-a5f2fa65eb76"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del nuevo aut\[OAcute]mata: \
\"\>"], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.8206579235148306`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"b0d0936b-0283-4502-9a89-daad1f921fb3"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.9999996666667778, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "0"], {0.9999996666667778, 0.3333335555554815}], 
   CircleBox[{1.0676144519687507, 0.3152162284374141}, 0.024999991666669445, {
    3.403392041388943, 8.639379797371932}], 
   PolygonBox[{{1.0463501901908716`, 0.2868405427706052}, {
    1.0434663143609033`, 0.30874575446667574`}, {1.0638787220799604`, 
    0.3002906583487529}}], 
   InsetBox["\<\"d,c,b,a\"\>", {1.0611439779980123, 0.2910680908295666}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.04999998333333889], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "1"], {0.6666664444445185, 0.6666667777777407}], 
   PolygonBox[{{0.6779269477903279, 0.4003410823016719}, {0.6796073923859952, 
    0.3816298307711765}, {0.694971589250171, 0.3924407642459244}}], 
   CircleBox[{0.4695889370458834, 0.4879411229414184}, 0.23539295322152937, {
    5.814490198142703, 6.8617877493393005`}], 
   InsetBox["\<\"d,a\"\>", {0.7046265474727095, 0.5008703190185402}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6897756309921824, 0.07347731169501096}, {0.6903574192336803,
     0.04403141379774715}, {0.7155674207292045, 0.05925820614313934}}], 
   CircleBox[{0.18929387267119335, 0.3348321097799131}, 0.5793355870974006, {
    5.757227015645262, 6.8045245668418595`}], 
   InsetBox["\<\"b\"\>", {0.7686279147207057, 0.333494126198643}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6847837715625859, 0.7342815630797137}, 
    0.024999991666669445, {-1.3089969389957465`, 3.926990816987242}], 
   PolygonBox[{{0.699709341651247, 0.7305458331909234}, {0.6912542455333243, 
    0.7101334254718662}, {0.7131594572293947, 0.7130173013018346}}], 
   InsetBox["\<\"c\"\>", {0.7089319091704334, 0.7278110891089753}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.04999998333333889], 
   CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.033333322222225924],
    InsetBox[
    SubscriptBox["\[Mu]", "2"], {0.33333322222225925, 0.3333335555554815}], 
   PolygonBox[{{0.32311579838587534`, 0.06743177235246617}, {
    0.32039227428078254`, 0.048296608548917264`}, {0.33832557429277876`, 
    0.05550554938786206}}], 
   CircleBox[{0.1295860639246988, 0.20854610053465283}, 0.24917244950462814, {
    5.584510680271822, 6.631808231468419}], 
   InsetBox["\<\"c\"\>", {0.3749516661277726, 0.16515680637515534}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9224401704339512, 0.3455485856796155}, {0.9517033914510827, 
    0.3462745034969582}, {0.9364431176716385, 0.3712542373856815}}], 
   CircleBox[{0.6681081231561177, -0.1478335214531512}, 0.569709589640868, {
    1.0497485128465465`, 2.09694606405982}], 
   InsetBox["\<\"d,a\"\>", {0.6666548174127951, 0.42187421452309715}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9226441093291622, 0.6555162008865069}, {0.9501556354299496, 
    0.6706127736465003}, {0.9233258568593214, 0.6868901677666642}}], 
   CircleBox[{0.9223491576633254, 0.016451718392083148}, 0.6547517746576614, {
    1.528314818183175, 2.57551236937977}], 
   InsetBox["\<\"b\"\>", {0.6193497461717816, 0.5968750492921557}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 0.6666667777777407}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "3"], {0.33333322222225925, 0.6666667777777407}], 
   PolygonBox[{{0.3464724028463002, 0.40064716913054876`}, {
    0.34627417016373596`, 0.3816298307711765}, {0.3628427846365987, 
    0.39096682541190164`}}], 
   CircleBox[{0.14293190571090722, 0.5114400615094489}, 0.24124421758277997, {
    5.714920141477782, 6.76221769267438}], 
   InsetBox["\<\"d\"\>", {0.38393605006672776, 0.5006801860247372}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9351494874192043, 0.6995757570080561}, {0.9646443393925594, 
    0.7020221050519591}, {0.9477783138533635, 0.7263422221197946}}], 
   CircleBox[{0.7046073840526654, 0.18091423200929313}, 0.5823852964228071, {
    1.1079426974452558`, 2.155140248641832}], 
   InsetBox["\<\"b\"\>", {0.6692520567784472, 0.7622253658462547}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5992950572259599, 0.6799073619670818}, {0.6183701692288235, 
    0.6796077257192175}, {0.6090921058299368, 0.6962770754176629}}], 
   CircleBox[{0.48705888539191283, 0.4762879979569874}, 0.2420362885193262, {
    0.9973536268476104, 2.0445511780442613`}], 
   InsetBox["\<\"c\"\>", {0.49911792911710545, 0.7180236892080818}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.26334113384175467, 0.6677176333675364}, 
    0.024999991666669445, {0.508585983948926, 5.744573739931914}], 
   PolygonBox[{{0.2633175248969835, 0.6831035932950568}, {0.2851769746975905, 
    0.679891196422458}, {0.27702926709599524`, 0.7004282336988338}}], 
   InsetBox["\<\"a\"\>", {0.2637164394095388, 0.6927148077891452}, 
    ImageScaled[{0, 0}]], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Mu]", "4"], {0.33333322222225925, 3.333332222466012*^-7}],
    PolygonBox[{{0.6002416289284107, 0.31359348799193304`}, {
    0.6233651886890484, 0.30833356388881206`}, {0.6072481809134487, 
    0.2909379357617326}}], 
   CircleBox[{0.7239958684021209, -0.05180865266908996}, 
    0.37393709343518416, {1.8432664494698057`, 2.8904640006664026`}], 
   InsetBox["\<\"d,b,a\"\>", {0.456776035091554, 0.20976831598875362}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.2817238258486827, -0.0472909654361077}, 
    0.024999991666669445, {1.2653637076958892`, 6.501351463678878}], 
   PolygonBox[{{0.2692172948132596, -0.014110624155769514`}, {
    0.2892414683304087, -0.023448049615040635`}, {
    0.2711429339181618, -0.03612077984104377}}], 
   InsetBox["\<\"c\"\>", {0.2648340762882077, -0.02885903815983036}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.9999996666667778, 0.6666667777777407}, 0.04999998333333889], 
   CircleBox[{0.9999996666667778, 0.6666667777777407}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "5"], {0.9999996666667778, 0.6666667777777407}], 
   PolygonBox[{{0.7246530446390265, 0.6374603467446106}, {0.7149627196602135, 
    0.653725829836264}, {0.7338942037118181, 0.6539851558930162}}], 
   CircleBox[{0.838406627220954, 0.8576683931420135}, 0.23839246515266824, {
    4.168090596601463, 5.215188147797876}], 
   InsetBox["\<\"c\"\>", {0.8334604319202352, 0.6193272456378252}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7275437314502694, 0.3748574777547548}, {0.7099677001999886, 
    0.35833354722215094`}, {0.7330658594367333, 0.3513742229280004}}], 
   CircleBox[{0.6312605286967882, 0.7386752217030722}, 0.3884000620403987, {
    4.916346772242231, 5.963544323438829}], 
   InsetBox["\<\"d,b,a\"\>", {0.8895647714307747, 0.4486174233617636}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Mu]", "6"], {0.6666664444445185, 3.333332222466012*^-7}], 
   PolygonBox[{{0.9372254357123848, 0.6259284820096549}, {0.9684977450555439, 
    0.6278386015633749}, {0.9545158024417513, 0.5998009274603338}}], 
   CircleBox[{1.317274904040847, 0.07621686825101481}, 0.6526346936015524, {
    2.1346106894195214`, 3.181808240616119}], 
   InsetBox["\<\"b\"\>", {0.7394141574436304, 0.3795467230864722}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.3157647302679243, 0.5898057042047538}, {0.3318321691236202, 
    0.6166893311349877}, {0.3470803535632183, 0.5893327074470849}}], 
   CircleBox[{0.983572087530841, 0.5932821790097165}, 0.6521601153214343, {
    3.1056932171343377`, 4.152890768330935}], 
   InsetBox["\<\"a\"\>", {0.4074451854671549, 0.28768340817683796}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.33503364053746143`, 0.26018040630701106`}, {
    0.3398570510383419, 0.28376100275746013`}, {0.35786674135037977`, 
    0.2677935085055925}}], 
   CircleBox[{0.708443600319619, 0.3956704004424525}, 0.38520093146473217, {
    3.436365118715469, 4.483562669912067}], 
   InsetBox["\<\"d\"\>", {0.4451929839912841, 0.11446074448439486}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.3906156361635117, -0.0329741271589965}, {
    0.3803178376000162, -0.017100668132727363`}, {
    0.3992135556444444, -0.01611924248681995}}], 
   CircleBox[{0.49574129138111944, 0.19113872525040065}, 0.2380886780996488, {
    4.206263800175814, 5.25336135137146}], 
   InsetBox["\<\"c\"\>", {0.4998894422838158, -0.04691381408351747}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.04999998333333889], 
   CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "7"], {0.6666664444445185, 0.3333335555554815}], 
   PolygonBox[{{0.39877795693723267`, 0.02260209677226433}, {
    0.3831429405236071, 0.004358119018009926}, {
    0.40676019693168236`, -0.00006021350764929406}}], 
   CircleBox[{0.2650035988882063, 0.37108313849676194}, 0.3852844974220181, {
    5.023938221047153, 6.071135772243752}], 
   InsetBox["\<\"c\"\>", {0.5506519258906548, 0.11253106011710684}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7161639026284241, 0.2838360973715759}, 
    0.024999991666669445, {-3.4033920413889422`, 1.8325957145940457`}], 
   PolygonBox[{{0.6835606689026539, 0.26989416362325697`}, {
    0.6920157650205766, 0.29030657134231425`}, {0.7054658805987244, 
    0.2727780394532254}}], 
   InsetBox["\<\"d,b,a\"\>", {0.698486238991315, 0.26615843373446674}, 
    ImageScaled[{1, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.33333322222225925`, 0.7666667444444185}, {
     0.33333322222225925`, 0.7166667611110796}}], 
    PolygonBox[{{0.33333322222225925`, 0.7166667611110796}, {
     0.31666656111114627`, 0.7416667527777491}, {0.34999988333337223`, 
     0.7416667527777491}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.8206579235304546`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"51d17a19-1ce6-46b0-8fce-d72aeba9c20e"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n reducido del nuevo aut\
\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.8206579235314617`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"1a5f7884-f6d5-4f3b-861b-e418344bfa89"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.9999996666667778, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "0"], {0.9999996666667778, 0.3333335555554815}], 
   CircleBox[{1.0676144519687507, 0.3152162284374141}, 0.024999991666669445, {
    3.403392041388943, 8.639379797371932}], 
   PolygonBox[{{1.0463501901908716`, 0.2868405427706052}, {
    1.0434663143609033`, 0.30874575446667574`}, {1.0638787220799604`, 
    0.3002906583487529}}], 
   InsetBox["\<\"d,c,b,a\"\>", {1.0611439779980123, 0.2910680908295666}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.04999998333333889], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "1"], {0.6666664444445185, 0.6666667777777407}], 
   PolygonBox[{{0.6779269477903279, 0.4003410823016719}, {0.6796073923859952, 
    0.3816298307711765}, {0.694971589250171, 0.3924407642459244}}], 
   CircleBox[{0.4695889370458834, 0.4879411229414184}, 0.23539295322152937, {
    5.814490198142703, 6.8617877493393005`}], 
   InsetBox["\<\"d,a\"\>", {0.7046265474727095, 0.5008703190185402}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6897756309921824, 0.07347731169501096}, {0.6903574192336803,
     0.04403141379774715}, {0.7155674207292045, 0.05925820614313934}}], 
   CircleBox[{0.18929387267119335, 0.3348321097799131}, 0.5793355870974006, {
    5.757227015645262, 6.8045245668418595`}], 
   InsetBox["\<\"b\"\>", {0.7686279147207057, 0.333494126198643}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6847837715625859, 0.7342815630797137}, 
    0.024999991666669445, {-1.3089969389957465`, 3.926990816987242}], 
   PolygonBox[{{0.699709341651247, 0.7305458331909234}, {0.6912542455333243, 
    0.7101334254718662}, {0.7131594572293947, 0.7130173013018346}}], 
   InsetBox["\<\"c\"\>", {0.7089319091704334, 0.7278110891089753}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.04999998333333889], 
   CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.033333322222225924],
    InsetBox[
    SubscriptBox["\[Mu]", "2"], {0.33333322222225925, 0.3333335555554815}], 
   PolygonBox[{{0.32311579838587534`, 0.06743177235246617}, {
    0.32039227428078254`, 0.048296608548917264`}, {0.33832557429277876`, 
    0.05550554938786206}}], 
   CircleBox[{0.1295860639246988, 0.20854610053465283}, 0.24917244950462814, {
    5.584510680271822, 6.631808231468419}], 
   InsetBox["\<\"c\"\>", {0.3749516661277726, 0.16515680637515534}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9224401704339512, 0.3455485856796155}, {0.9517033914510827, 
    0.3462745034969582}, {0.9364431176716385, 0.3712542373856815}}], 
   CircleBox[{0.6681081231561177, -0.1478335214531512}, 0.569709589640868, {
    1.0497485128465465`, 2.09694606405982}], 
   InsetBox["\<\"d,a\"\>", {0.6666548174127951, 0.42187421452309715}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9226441093291622, 0.6555162008865069}, {0.9501556354299496, 
    0.6706127736465003}, {0.9233258568593214, 0.6868901677666642}}], 
   CircleBox[{0.9223491576633254, 0.016451718392083148}, 0.6547517746576614, {
    1.528314818183175, 2.57551236937977}], 
   InsetBox["\<\"b\"\>", {0.6193497461717816, 0.5968750492921557}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 0.6666667777777407}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "3"], {0.33333322222225925, 0.6666667777777407}], 
   PolygonBox[{{0.3464724028463002, 0.40064716913054876`}, {
    0.34627417016373596`, 0.3816298307711765}, {0.3628427846365987, 
    0.39096682541190164`}}], 
   CircleBox[{0.14293190571090722, 0.5114400615094489}, 0.24124421758277997, {
    5.714920141477782, 6.76221769267438}], 
   InsetBox["\<\"d\"\>", {0.38393605006672776, 0.5006801860247372}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9351494874192043, 0.6995757570080561}, {0.9646443393925594, 
    0.7020221050519591}, {0.9477783138533635, 0.7263422221197946}}], 
   CircleBox[{0.7046073840526654, 0.18091423200929313}, 0.5823852964228071, {
    1.1079426974452558`, 2.155140248641832}], 
   InsetBox["\<\"b\"\>", {0.6692520567784472, 0.7622253658462547}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5992950572259599, 0.6799073619670818}, {0.6183701692288235, 
    0.6796077257192175}, {0.6090921058299368, 0.6962770754176629}}], 
   CircleBox[{0.48705888539191283, 0.4762879979569874}, 0.2420362885193262, {
    0.9973536268476104, 2.0445511780442613`}], 
   InsetBox["\<\"c\"\>", {0.49911792911710545, 0.7180236892080818}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.26334113384175467, 0.6677176333675364}, 
    0.024999991666669445, {0.508585983948926, 5.744573739931914}], 
   PolygonBox[{{0.2633175248969835, 0.6831035932950568}, {0.2851769746975905, 
    0.679891196422458}, {0.27702926709599524`, 0.7004282336988338}}], 
   InsetBox["\<\"a\"\>", {0.2637164394095388, 0.6927148077891452}, 
    ImageScaled[{0, 0}]], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Mu]", "4"], {0.33333322222225925, 3.333332222466012*^-7}],
    PolygonBox[{{0.6002416289284107, 0.31359348799193304`}, {
    0.6233651886890484, 0.30833356388881206`}, {0.6072481809134487, 
    0.2909379357617326}}], 
   CircleBox[{0.7239958684021209, -0.05180865266908996}, 
    0.37393709343518416, {1.8432664494698057`, 2.8904640006664026`}], 
   InsetBox["\<\"d,b,a\"\>", {0.456776035091554, 0.20976831598875362}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.2817238258486827, -0.0472909654361077}, 
    0.024999991666669445, {1.2653637076958892`, 6.501351463678878}], 
   PolygonBox[{{0.2692172948132596, -0.014110624155769514`}, {
    0.2892414683304087, -0.023448049615040635`}, {
    0.2711429339181618, -0.03612077984104377}}], 
   InsetBox["\<\"c\"\>", {0.2648340762882077, -0.02885903815983036}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.9999996666667778, 0.6666667777777407}, 0.04999998333333889], 
   CircleBox[{0.9999996666667778, 0.6666667777777407}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "5"], {0.9999996666667778, 0.6666667777777407}], 
   PolygonBox[{{0.7246530446390265, 0.6374603467446106}, {0.7149627196602135, 
    0.653725829836264}, {0.7338942037118181, 0.6539851558930162}}], 
   CircleBox[{0.838406627220954, 0.8576683931420135}, 0.23839246515266824, {
    4.168090596601463, 5.215188147797876}], 
   InsetBox["\<\"c\"\>", {0.8334604319202352, 0.6193272456378252}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.7275437314502694, 0.3748574777547548}, {0.7099677001999886, 
    0.35833354722215094`}, {0.7330658594367333, 0.3513742229280004}}], 
   CircleBox[{0.6312605286967882, 0.7386752217030722}, 0.3884000620403987, {
    4.916346772242231, 5.963544323438829}], 
   InsetBox["\<\"d,b,a\"\>", {0.8895647714307747, 0.4486174233617636}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Mu]", "6"], {0.6666664444445185, 3.333332222466012*^-7}], 
   PolygonBox[{{0.9372254357123848, 0.6259284820096549}, {0.9684977450555439, 
    0.6278386015633749}, {0.9545158024417513, 0.5998009274603338}}], 
   CircleBox[{1.317274904040847, 0.07621686825101481}, 0.6526346936015524, {
    2.1346106894195214`, 3.181808240616119}], 
   InsetBox["\<\"b\"\>", {0.7394141574436304, 0.3795467230864722}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.3157647302679243, 0.5898057042047538}, {0.3318321691236202, 
    0.6166893311349877}, {0.3470803535632183, 0.5893327074470849}}], 
   CircleBox[{0.983572087530841, 0.5932821790097165}, 0.6521601153214343, {
    3.1056932171343377`, 4.152890768330935}], 
   InsetBox["\<\"a\"\>", {0.4074451854671549, 0.28768340817683796}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.33503364053746143`, 0.26018040630701106`}, {
    0.3398570510383419, 0.28376100275746013`}, {0.35786674135037977`, 
    0.2677935085055925}}], 
   CircleBox[{0.708443600319619, 0.3956704004424525}, 0.38520093146473217, {
    3.436365118715469, 4.483562669912067}], 
   InsetBox["\<\"d\"\>", {0.4451929839912841, 0.11446074448439486}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.3906156361635117, -0.0329741271589965}, {
    0.3803178376000162, -0.017100668132727363`}, {
    0.3992135556444444, -0.01611924248681995}}], 
   CircleBox[{0.49574129138111944, 0.19113872525040065}, 0.2380886780996488, {
    4.206263800175814, 5.25336135137146}], 
   InsetBox["\<\"c\"\>", {0.4998894422838158, -0.04691381408351747}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.04999998333333889], 
   CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "7"], {0.6666664444445185, 0.3333335555554815}], 
   PolygonBox[{{0.39877795693723267`, 0.02260209677226433}, {
    0.3831429405236071, 0.004358119018009926}, {
    0.40676019693168236`, -0.00006021350764929406}}], 
   CircleBox[{0.2650035988882063, 0.37108313849676194}, 0.3852844974220181, {
    5.023938221047153, 6.071135772243752}], 
   InsetBox["\<\"c\"\>", {0.5506519258906548, 0.11253106011710684}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7161639026284241, 0.2838360973715759}, 
    0.024999991666669445, {-3.4033920413889422`, 1.8325957145940457`}], 
   PolygonBox[{{0.6835606689026539, 0.26989416362325697`}, {
    0.6920157650205766, 0.29030657134231425`}, {0.7054658805987244, 
    0.2727780394532254}}], 
   InsetBox["\<\"d,b,a\"\>", {0.698486238991315, 0.26615843373446674}, 
    ImageScaled[{1, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.33333322222225925`, 0.7666667444444185}, {
     0.33333322222225925`, 0.7166667611110796}}], 
    PolygonBox[{{0.33333322222225925`, 0.7166667611110796}, {
     0.31666656111114627`, 0.7416667527777491}, {0.34999988333337223`, 
     0.7416667527777491}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{
  3.8205743710112963`*^9, 3.8205748143396*^9, {3.8205748869294243`*^9, 
   3.820574896518014*^9}, 3.8206579235314617`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"20fd54af-2b8b-45dd-b8d6-2b911ded09cf"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{949.5, 471.5},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a8572f35-c064-47f4-a398-4a1b85c180ca"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 42, "Input",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],
Cell[CellGroupData[{
Cell[785, 27, 356, 8, 65, "Input",ExpressionUUID->"603202cf-4fe8-46de-94bb-782e903e369c"],
Cell[1144, 37, 1006, 29, 48, "Output",ExpressionUUID->"b3088cfc-1dab-4b53-ac5d-29437db7932b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2187, 71, 4259, 106, 187, "Input",ExpressionUUID->"7e877a78-b0d2-431a-b2e6-ca4b1233d0fe"],
Cell[CellGroupData[{
Cell[6471, 181, 372, 7, 33, "Print",ExpressionUUID->"c3b348d3-5faf-4a07-b21a-c0a6855aff39"],
Cell[6846, 190, 4691, 85, 550, "Print",ExpressionUUID->"e1c21f91-ac66-49d7-975f-1c85917dbee1"],
Cell[11540, 277, 327, 6, 33, "Print",ExpressionUUID->"ce6a7ea9-3491-44b0-8fff-becff25bb948"],
Cell[11870, 285, 510, 14, 33, "Print",ExpressionUUID->"5cb4b4e0-bdf2-4bcc-825c-89af6b712b89"],
Cell[12383, 301, 585, 16, 33, "Print",ExpressionUUID->"ddeb4ba0-6937-4db0-a06d-1c5162cd34ef"],
Cell[12971, 319, 585, 16, 33, "Print",ExpressionUUID->"9f352cae-f7d6-411f-b6ca-a948633e8aa4"],
Cell[13559, 337, 585, 16, 33, "Print",ExpressionUUID->"aa608962-c76b-4b01-9209-41ac31aaa070"],
Cell[14147, 355, 685, 19, 33, "Print",ExpressionUUID->"903afdb2-edd9-4b3f-a874-ebe2786cb54e"],
Cell[14835, 376, 685, 19, 33, "Print",ExpressionUUID->"573b2871-e0f9-47ed-910a-767189cee64d"],
Cell[15523, 397, 688, 19, 33, "Print",ExpressionUUID->"6844eb5e-c83d-45b2-9540-5a722c7f320e"],
Cell[16214, 418, 772, 21, 33, "Print",ExpressionUUID->"2f4dbada-8d9b-4548-8f1d-15744f6443e5"],
Cell[16989, 441, 489, 12, 33, "Print",ExpressionUUID->"1f8d75de-67de-4974-a402-9e557d27c1c1"],
Cell[17481, 455, 929, 24, 33, "Print",ExpressionUUID->"464fed56-ab5c-4ed2-9d66-b9528519e0e2"],
Cell[18413, 481, 2202, 68, 224, "Print",ExpressionUUID->"36cc83cf-6f66-449a-a5bc-a5f2fa65eb76"],
Cell[20618, 551, 354, 7, 33, "Print",ExpressionUUID->"b0d0936b-0283-4502-9a89-daad1f921fb3"],
Cell[20975, 560, 10379, 182, 541, "Print",ExpressionUUID->"51d17a19-1ce6-46b0-8fce-d72aeba9c20e"],
Cell[31357, 744, 363, 7, 33, "Print",ExpressionUUID->"1a5f7884-f6d5-4f3b-861b-e418344bfa89"],
Cell[31723, 753, 10379, 182, 541, "Print",ExpressionUUID->"20fd54af-2b8b-45dd-b8d6-2b911ded09cf"]
}, Open  ]]
}, Open  ]]
}
]
*)

