(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30795,        724]
NotebookOptionsPosition[     29287,        689]
NotebookOutlinePosition[     29722,        706]
CellTagsIndexPosition[     29679,        703]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8066770709337845`*^9, 3.8066770737648563`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"32278328-43d7-4d78-8306-5fd12cb5fda2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "FindRRHL"}]], "Input",
 CellChangeTimes->{{3.8066881951736107`*^9, 3.806688200977329*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"43f141ba-333b-46a5-9956-8ded43aede7c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Comando que encuentra si existe, una \
relaci\[OAcute]n de recurrencia homog\[EAcute]nea lineal con coeficientes \
constantes y su soluci\[OAcute]n, dada una sucesi\[OAcute]n de \
n\[UAcute]meros reales a trav\[EAcute]s de una lista \[OpenCurlyDoubleQuote]L\
\[CloseCurlyDoubleQuote]. Sintaxis: FindRRHL[L, a, n] siendo \
\[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] el conjunto de datos, \
\[OpenCurlyDoubleQuote]a\[CloseCurlyDoubleQuote] el nombre de la relaci\
\[OAcute]n de recurrencia y \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] \
el par\[AAcute]metro con el que se mostrar\[AAcute] su soluci\[OAcute]n. Por \
defecto, retorna \[OpenCurlyDoubleQuote]NaD\[CloseCurlyDoubleQuote] si no hay \
resultado en el proceso por datos insuficientes o no existencia.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"FindRRHL", "[", 
                    RowBox[{
                    "VilCretas`Private`RcDatos_List", ",", 
                    "VilCretas`Private`Rcsoll_", ",", 
                    "VilCretas`Private`Rcsol_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{
                    "{", "VilCretas`Private`VerificandoParametroQ", "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`VerificandoParametroQ", "[", 
                    "VilCretas`Private`RcParametro_", "]"}], ":=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    RowBox[{"Solve", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcParametro", "\[Equal]", 
                    "VilCretas`Private`RcParametro"}], ",", 
                    "VilCretas`Private`RcParametro"}], "]"}], "]"}], ",", 
                    "True", ",", "False"}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`VerificandoParametroQ", "[", 
                    "VilCretas`Private`Rcsoll", "]"}], "&&", 
                    RowBox[{"VilCretas`Private`VerificandoParametroQ", "[", 
                    "VilCretas`Private`Rcsol", "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilCretas`Private`Rcsol", "]"}], 
                    "\[Equal]", "False"}], "&&", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilCretas`Private`Rcsol", "]"}],
                     "\[Equal]", "False"}], "&&", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilCretas`Private`Rcsoll", "]"}],
                     "\[Equal]", "False"}], "&&", 
                    RowBox[{
                    RowBox[{
                    "NumericQ", "[", "VilCretas`Private`Rcsoll", "]"}], 
                    "\[Equal]", "False"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`RcDatos", ",", "Null"}], "]"}],
                     "\[Equal]", "False"}], "&&", 
                    RowBox[{
                    "VectorQ", "[", "VilCretas`Private`RcDatos", "]"}], "&&", 
                    RowBox[{"VilCretas`Private`RcDatos", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcVl6", "=", 
                    RowBox[{
                    RowBox[{
                    "Variables", "[", "VilCretas`Private`Rcsol", "]"}], 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ",", 
                    RowBox[{"VilCretas`Private`RcList3", "=", 
                    RowBox[{"{", "}"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    RowBox[{"VilCretas`Private`Rcsoll", ",", 
                    "VilCretas`Private`Rcsol"}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{
                    "FindLinearRecurrence", "[", "VilCretas`Private`RcDatos", 
                    "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Vector", "=", 
                    RowBox[{
                    "FindLinearRecurrence", "[", "VilCretas`Private`RcDatos", 
                    "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`RcVl7", "=", 
                    RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                    RowBox[{"VilCretas`Private`Rci3", "=", "1"}], 
                    RowBox[{"Length", "[", "VilCretas`Private`Vector", "]"}]], 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Vector", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Rci3", "\[RightDoubleBracket]"}], " ", 
                    RowBox[{"VilCretas`Private`Rcsoll", "[", 
                    RowBox[{
                    "VilCretas`Private`RcVl6", "-", 
                    "VilCretas`Private`Rci3"}], "]"}]}]}]}], ";", 
                    RowBox[{"VilCretas`Private`RcVl7", "=", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rcsoll", "[", 
                    "VilCretas`Private`RcVl6", "]"}], "\[Equal]", 
                    "VilCretas`Private`RcVl7"}]}], ";", 
                    RowBox[{"VilCretas`Private`RcList3", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{
                    "VilCretas`Private`RcList3", ",", 
                    "VilCretas`Private`RcVl7"}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`RcVl8", "=", 
                    RowBox[{
                    "VilCretas`Private`RcDatos", "\[LeftDoubleBracket]", 
                    RowBox[{"1", ";;", 
                    RowBox[{
                    "Length", "[", "VilCretas`Private`Vector", "]"}]}], 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci3", "=", "1"}], ",", 
                    RowBox[{"VilCretas`Private`Rci3", "\[LessEqual]", 
                    RowBox[{"Length", "[", "VilCretas`Private`RcVl8", "]"}]}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcList3", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilCretas`Private`RcList3", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{
                    RowBox[{
                    "ToString", "[", "VilCretas`Private`Rcsoll", "]"}], 
                    "<>", "\<\"[\"\>", "<>", 
                    RowBox[{"ToString", "[", "VilCretas`Private`Rci3", "]"}], 
                    "<>", "\<\"]==\"\>", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RcVl8", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Rci3", "\[RightDoubleBracket]"}], 
                    "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`Rci3", "++"}]}]}], "]"}], ";", 
                    RowBox[{"VilCretas`Private`RcSolucion2", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"RSolve", "[", 
                    RowBox[{"VilCretas`Private`RcList3", ",", 
                    RowBox[{
                    "VilCretas`Private`Rcsoll", "[", 
                    "VilCretas`Private`RcVl6", "]"}], ",", 
                    "VilCretas`Private`RcVl6"}], "]"}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`RcSolucion2", "=", 
                    RowBox[{
                    RowBox[{
                    "Flatten", "[", "VilCretas`Private`RcSolucion2", "]"}], 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilCretas`Private`RcList3", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{
                    "VilCretas`Private`RcList3", ",", 
                    "VilCretas`Private`RcSolucion2"}], "]"}]}], ";", 
                    "VilCretas`Private`RcList3"}], ",", "\<\"NaD\"\>"}], 
                    "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`FindRRHL\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Comando que encuentra si existe, una \
relaci\[OAcute]n de recurrencia homog\[EAcute]nea lineal con coeficientes \
constantes y su soluci\[OAcute]n, dada una sucesi\[OAcute]n de \
n\[UAcute]meros reales a trav\[EAcute]s de una lista \[OpenCurlyDoubleQuote]L\
\[CloseCurlyDoubleQuote]. Sintaxis: FindRRHL[L, a, n] siendo \
\[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] el conjunto de datos, \
\[OpenCurlyDoubleQuote]a\[CloseCurlyDoubleQuote] el nombre de la relaci\
\[OAcute]n de recurrencia y \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] \
el par\[AAcute]metro con el que se mostrar\[AAcute] su soluci\[OAcute]n. Por \
defecto, retorna \[OpenCurlyDoubleQuote]NaD\[CloseCurlyDoubleQuote] si no hay \
resultado en el proceso por datos insuficientes o no existencia.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Comando que encuentra si existe, una relaci\[OAcute]n de recurrencia \
homog\[EAcute]nea lineal con coeficientes constantes y su soluci\[OAcute]n, \
dada una sucesi\[OAcute]n de n\[UAcute]meros reales a trav\[EAcute]s de una \
lista \[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote]. Sintaxis: FindRRHL[L, \
a, n] siendo \[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] el conjunto de \
datos, \[OpenCurlyDoubleQuote]a\[CloseCurlyDoubleQuote] el nombre de la \
relaci\[OAcute]n de recurrencia y \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] el par\[AAcute]metro con el que se mostrar\[AAcute] \
su soluci\[OAcute]n. Por defecto, retorna \[OpenCurlyDoubleQuote]NaD\
\[CloseCurlyDoubleQuote] si no hay resultado en el proceso por datos \
insuficientes o no existencia.", "Documentation" -> None, "OwnValues" -> None,
     "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`FindRRHL, {VilCretas`FindRRHL[
         Pattern[VilCretas`Private`RcDatos, 
          Blank[List]], 
         Pattern[VilCretas`Private`Rcsoll, 
          Blank[]], 
         Pattern[VilCretas`Private`Rcsol, 
          Blank[]]] :> 
       Module[{VilCretas`Private`VerificandoParametroQ}, 
         VilCretas`Private`VerificandoParametroQ[
            Pattern[VilCretas`Private`RcParametro, 
             Blank[]]] := Quiet[
            If[
             ListQ[
              Solve[
              VilCretas`Private`RcParametro == VilCretas`Private`RcParametro, 
               VilCretas`Private`RcParametro]], True, False]]; If[
           And[
            VilCretas`Private`VerificandoParametroQ[VilCretas`Private`Rcsoll], 
            VilCretas`Private`VerificandoParametroQ[VilCretas`Private`Rcsol]], 
           If[
            And[
            StringQ[VilCretas`Private`Rcsol] == False, 
             NumericQ[VilCretas`Private`Rcsol] == False, 
             StringQ[VilCretas`Private`Rcsoll] == False, 
             NumericQ[VilCretas`Private`Rcsoll] == False], 
            If[
             And[MemberQ[VilCretas`Private`RcDatos, Null] == False, 
              VectorQ[VilCretas`Private`RcDatos], 
              VilCretas`Private`RcDatos != {}], 
             Module[{VilCretas`Private`RcVl6 = Part[
                 Variables[VilCretas`Private`Rcsol], 1], 
               VilCretas`Private`RcList3 = {}}, 
              Clear[VilCretas`Private`Rcsoll, VilCretas`Private`Rcsol]; If[
                VectorQ[
                 FindLinearRecurrence[VilCretas`Private`RcDatos]], 
                VilCretas`Private`Vector = 
                 FindLinearRecurrence[VilCretas`Private`RcDatos]; 
                VilCretas`Private`RcVl7 = 
                 Sum[Part[VilCretas`Private`Vector, VilCretas`Private`Rci3] 
                   VilCretas`Private`Rcsoll[
                    VilCretas`Private`RcVl6 - VilCretas`Private`Rci3], {
                   VilCretas`Private`Rci3, 1, 
                    Length[VilCretas`Private`Vector]}]; 
                VilCretas`Private`RcVl7 = 
                 VilCretas`Private`Rcsoll[VilCretas`Private`RcVl6] == 
                  VilCretas`Private`RcVl7; 
                VilCretas`Private`RcList3 = 
                 Append[VilCretas`Private`RcList3, VilCretas`Private`RcVl7]; 
                VilCretas`Private`RcVl8 = Part[VilCretas`Private`RcDatos, 
                   Span[1, 
                    Length[VilCretas`Private`Vector]]]; 
                For[VilCretas`Private`Rci3 = 1, VilCretas`Private`Rci3 <= 
                  Length[VilCretas`Private`RcVl8], 
                  VilCretas`Private`RcList3 = 
                   Append[VilCretas`Private`RcList3, 
                    ToExpression[
                    StringJoin[
                    ToString[VilCretas`Private`Rcsoll], "[", 
                    ToString[VilCretas`Private`Rci3], "]==", 
                    ToString[
                    Part[VilCretas`Private`RcVl8, VilCretas`Private`Rci3]]]]]; 
                  Increment[VilCretas`Private`Rci3]]; 
                VilCretas`Private`RcSolucion2 = Quiet[
                   RSolve[VilCretas`Private`RcList3, 
                    VilCretas`Private`Rcsoll[VilCretas`Private`RcVl6], 
                    VilCretas`Private`RcVl6]]; 
                VilCretas`Private`RcSolucion2 = Part[
                   Flatten[VilCretas`Private`RcSolucion2], 1, 2]; 
                VilCretas`Private`RcList3 = 
                 Append[VilCretas`Private`RcList3, 
                   VilCretas`Private`RcSolucion2]; VilCretas`Private`RcList3, 
                "NaD"]]]]]]}], "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Protected}, "FullName" -> "VilCretas`FindRRHL"], 
   False]]], "Output",
 CellChangeTimes->{3.80668820196369*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"d12bf976-435f-4f58-8e02-ea8526eb184d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", 
     RowBox[{"-", "16"}], ",", 
     RowBox[{"-", "192"}], ",", 
     RowBox[{"-", "1280"}], ",", 
     RowBox[{"-", "7168"}], ",", 
     RowBox[{"-", "36864"}]}], "}"}], ",", "a", ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{{3.8066776780529594`*^9, 3.8066777173316755`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"bd7fd2d7-d230-4a8d-8396-1487901b65a8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}], "]"}]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], "\[Equal]", "3"}], ",", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], "\[Equal]", "4"}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"2", " ", "n"}]}]]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"2", " ", "n"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.806677711579813*^9, 3.806677718211997*^9}},
 CellLabel->"Out[22]=",ExpressionUUID->"8caba037-db6a-48d1-9be7-09fac315d30c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "2"], "-", 
     RowBox[{"8", "t"}], "+", "16"}], "\[Equal]", "0"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8066654188768425`*^9, 3.806665445152872*^9}, {
  3.8066760883424764`*^9, 3.8066760937549706`*^9}, {3.806676480542827*^9, 
  3.806676486660624*^9}, {3.806677726613453*^9, 3.8066777327970057`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"38bbeb13-daad-4673-882c-9cae440f1e7b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "4"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8066654472108765`*^9, 3.8066760945284157`*^9, 
  3.8066764886078453`*^9, 3.8066777337824535`*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"4e10ca77-060e-4e91-b301-9fc88b640246"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"4", "b1"}], "+", 
       RowBox[{"4", "b2"}]}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"16", "b1"}], "+", 
       RowBox[{"32", "b2"}]}], "\[Equal]", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806668475470456*^9, 3.806668482284413*^9}, {
  3.806668523605818*^9, 3.8066686157092896`*^9}, {3.806676832094433*^9, 
  3.8066768491785183`*^9}, {3.8066769516744747`*^9, 3.8066769521881475`*^9}, {
  3.806689260755001*^9, 3.8066892762324643`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"fbbbe517-0c99-44cb-9023-bf1e74ceaa9e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", 
     FractionBox["5", "4"]}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8066686197479615`*^9, 3.8066761006888175`*^9, 
  3.8066768518863945`*^9, 3.806676952909187*^9, 3.80668927717694*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"988d56c9-ebda-4431-b969-642654f581a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"2", " ", "n"}]}]]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       RowBox[{"2", " ", "n"}]}], ")"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      FractionBox["5", "4"], 
      SuperscriptBox["4", "n"]}], "-", 
     RowBox[{
      FractionBox["n", "2"], 
      SuperscriptBox["4", "n"]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806689966698166*^9, 3.806689975176879*^9}, {
  3.806690058956007*^9, 3.806690100561127*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"b4632643-1616-4f11-a9d2-5deb89affe4f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.8066901012980623`*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"0bb7079e-a8c3-4149-9152-ffa8e626bb7e"]
}, Open  ]]
},
WindowSize->{949, 478},
WindowMargins->{{29.5, Automatic}, {Automatic, 156.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2756e6bd-b8c8-4765-8598-c63294dca053"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 203, 3, 91, "Input",ExpressionUUID->"32278328-43d7-4d78-8306-5fd12cb5fda2"],
Cell[CellGroupData[{
Cell[786, 27, 198, 3, 91, "Input",ExpressionUUID->"43f141ba-333b-46a5-9956-8ded43aede7c"],
Cell[987, 32, 23405, 502, 688, "Output",ExpressionUUID->"d12bf976-435f-4f58-8e02-ea8526eb184d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24429, 539, 460, 11, 135, "Input",ExpressionUUID->"bd7fd2d7-d230-4a8d-8396-1487901b65a8"],
Cell[24892, 552, 938, 30, 156, "Output",ExpressionUUID->"8caba037-db6a-48d1-9be7-09fac315d30c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25867, 587, 496, 11, 131, "Input",ExpressionUUID->"38bbeb13-daad-4673-882c-9cae440f1e7b"],
Cell[26366, 600, 381, 9, 100, "Output",ExpressionUUID->"4e10ca77-060e-4e91-b301-9fc88b640246"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26784, 614, 747, 19, 173, "Input",ExpressionUUID->"fbbbe517-0c99-44cb-9023-bf1e74ceaa9e"],
Cell[27534, 635, 448, 11, 124, "Output",ExpressionUUID->"988d56c9-ebda-4431-b969-642654f581a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28019, 651, 798, 25, 228, "Input",ExpressionUUID->"b4632643-1616-4f11-a9d2-5deb89affe4f"],
Cell[28820, 678, 451, 8, 195, "Output",ExpressionUUID->"0bb7079e-a8c3-4149-9152-ffa8e626bb7e"]
}, Open  ]]
}
]
*)

