(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     10597,        244]
NotebookOptionsPosition[      9804,        223]
NotebookOutlinePosition[     10235,        240]
CellTagsIndexPosition[     10192,        237]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8199749238028493`*^9, 3.819974935536437*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     SubscriptBox["\[Sigma]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "0"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox["\[Sigma]", "2"], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToDiagrama", "[", 
  RowBox[{"A", ",", 
   RowBox[{"forma", "\[Rule]", "\"\<rectangular\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Prueba", "[", 
   RowBox[{"automata_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "=", 
       RowBox[{"LenguajeStrings", "[", 
        RowBox[{"automata", ",", "n", ",", 
         RowBox[{"limite", "\[Rule]", "True"}]}], "]"}]}], ",", 
      RowBox[{"valorLogico", "=", "True"}], ",", "m"}], "}"}], ",", 
    RowBox[{
     RowBox[{"m", "=", 
      RowBox[{"Length", "[", "L", "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Count", "[", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", "b"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "m"}], "}"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"OddQ", "[", "#", "]"}], "&"}]}], "]"}], "]"}], 
        "\[NotEqual]", "\"\<{}\>\""}], ",", 
       RowBox[{"valorLogico", "=", "False"}]}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"m", ",", "\"\< pruebas: \>\"", ",", "valorLogico"}], "]"}]}]}],
    "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Prueba", "[", 
  RowBox[{"A", ",", "20"}], "]"}]}], "Input",
 CellChangeTimes->{{3.819994370947709*^9, 3.819994400588317*^9}, {
   3.8199944674389706`*^9, 3.81999457376061*^9}, {3.8199948144508734`*^9, 
   3.819994825605114*^9}, {3.819994894484734*^9, 3.8199949861386485`*^9}, {
   3.8199957421308374`*^9, 3.8199957575249825`*^9}, {3.8199987939070854`*^9, 
   3.8199988433413563`*^9}, {3.8199992231048574`*^9, 
   3.8199992263384657`*^9}, {3.8200582607873783`*^9, 3.820058281151648*^9}, {
   3.8200586731650705`*^9, 3.820058692749812*^9}, {3.820059614269702*^9, 
   3.8200596556334515`*^9}, {3.8200596904152856`*^9, 3.820059717290697*^9}, {
   3.8200599559211893`*^9, 3.82005997201208*^9}, {3.820060039400489*^9, 
   3.8200600475164194`*^9}, {3.8200601235348463`*^9, 
   3.8200601260264997`*^9}, {3.820060260318836*^9, 3.8200602608734307`*^9}, {
   3.8200602965137577`*^9, 3.820060310010372*^9}, {3.8200603559596977`*^9, 
   3.820060356769534*^9}, {3.8200605336605587`*^9, 3.820060605529254*^9}, {
   3.8200608753350487`*^9, 3.8200609298756795`*^9}, {3.820060973287934*^9, 
   3.820060975459796*^9}, {3.8200610917967234`*^9, 3.8200611029204917`*^9}, 
   3.8200612160328636`*^9, {3.8200628843479366`*^9, 3.820063004275433*^9}, {
   3.820063186623036*^9, 3.820063212468465*^9}, {3.8200635004405675`*^9, 
   3.8200635088910437`*^9}, 3.8200639138163834`*^9, {3.8200639493465652`*^9, 
   3.8200639561403475`*^9}, 3.8200641864549913`*^9},
 CellLabel->"In[18]:=",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.499999750000125, 0.500000249999875}], 
   PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702, 
    0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
   CircleBox[{0.7499996250001875, 0.21187656611285788}, 0.35511094850116554, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"b\"\>", {0.7499996250001875, 0.5669875146140234}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.4360798319141684, 0.4166981909203249}, 
    0.03749998125000937, {-4.843288674284264, 0.3926990816987246}], 
   PolygonBox[{{0.4089624846467197, 0.4624549648200464}, {
    0.44097456167505544`, 0.4538773546322609}, {0.41754009483450516`, 
    0.43044288779171064`}}], 
   InsetBox["\<\"a\"\>", {0.40632909652861476, 0.43952673309388085}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "1"], {0.99999950000025, 0.500000249999875}], 
   PolygonBox[{{0.5893902837518628, 0.06331553765522902}, {0.5649516228080215,
     0.03750048124975942}, {0.599527447927207, 0.029243508240653027`}}], 
   CircleBox[{0.41943899367211673, 0.5805610063278832}, 0.5622176261343743, {
    4.974088368183839, 6.021285919380437}], 
   InsetBox["\<\"b\"\>", {0.8169471328370685, 0.18297335758387556}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.097006802410284, 0.5401819903073393}, 
    0.03749998125000937, {-2.2252947962927703`, 3.010692959690218}], 
   PolygonBox[{{1.0976127270772782`, 0.48699678808123537`}, {
    1.074178260236728, 0.5104312549217856}, {1.1061903372650637`, 
    0.519008865109571}}], 
   InsetBox["\<\"a\"\>", {1.111357423948664, 0.5055365251608985}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 0.07499996250001874],
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
    0.04999997500001249], InsetBox[
    SubscriptBox["\[Sigma]", 
     "2"], {0.499999750000125, 4.999997500476638*^-7}], 
   PolygonBox[{{0.9004082684806661, 0.4707705833509121}, {0.9350476271923535, 
    0.46250026874986566`}, {0.9105656452947143, 0.43663686143526587`}}], 
   CircleBox[{1.0805602563282581, -0.08056025632825814}, 0.5622176261343743, {
    1.832595714594046, 2.879793265790644}], 
   InsetBox["\<\"b\"\>", {0.683012360386039, 0.3169876396139611}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.425753575098625, -0.07424567490174998}, 
    0.03749998125000937, {-4.974188368183839, 0.26179938779914913`}], 
   PolygonBox[{{0.4048406779616283, -0.02534083246389893}, {
    0.43545928443711485`, -0.038023474527010104`}, {
    0.40916649098561225`, -0.05819864453170456}}], 
   InsetBox["\<\"a\"\>", {0.399237084062375, -0.047729183865499965}, 
    ImageScaled[{1, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.8200596444053893`*^9, 3.820059656895215*^9}, {
   3.8200597063954697`*^9, 3.8200597180995245`*^9}, 3.820060407501458*^9, 
   3.8200606130581503`*^9, 3.8200609483598185`*^9, {3.8200609832402887`*^9, 
   3.8200610022544036`*^9}, 3.8200611618409023`*^9, 3.82006121968056*^9, {
   3.8200632057568803`*^9, 3.8200632129345894`*^9}, 3.8200634316417947`*^9, 
   3.8200635093841243`*^9, 3.8200640741260324`*^9, 3.8200641873606815`*^9, 
   3.820083072795359*^9, 3.820083123442151*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"dbb76152-ed1e-4a88-9c4e-e4382b7dd2e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1048555", "\[InvisibleSpace]", "\<\" pruebas: \"\>", "\[InvisibleSpace]", 
   "True"}],
  SequenceForm[1048555, " pruebas: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8200609488135033`*^9, {3.820060984603219*^9, 3.820061003573601*^9}, 
   3.8200611856873736`*^9, 3.820061244242515*^9, {3.820063205954303*^9, 
   3.8200632259669733`*^9}, 3.820063444597276*^9, 3.8200635229926243`*^9, 
   3.8200640789431124`*^9, 3.8200641922919745`*^9, 3.820083079554201*^9, 
   3.820083128456627*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"0267e580-8988-407d-9b6a-c3d92e726dc1"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8200585299214935`*^9, 
  3.8200586702568684`*^9}},ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-\
044bcbd8951b"]
},
WindowSize->{949, 467},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5ba469ff-2b55-4c5e-872e-231d8c1374f3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 42, "Input",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],
Cell[CellGroupData[{
Cell[783, 27, 4360, 103, 456, "Input",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],
Cell[5146, 132, 3812, 66, 575, "Output",ExpressionUUID->"dbb76152-ed1e-4a88-9c4e-e4382b7dd2e4"],
Cell[8961, 200, 668, 15, 33, "Print",ExpressionUUID->"0267e580-8988-407d-9b6a-c3d92e726dc1"]
}, Open  ]],
Cell[9644, 218, 156, 3, 42, "Input",ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-044bcbd8951b"]
}
]
*)

