(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     57850,       1285]
NotebookOptionsPosition[     56258,       1249]
NotebookOutlinePosition[     56690,       1266]
CellTagsIndexPosition[     56647,       1263]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"3", " ", 
    SuperscriptBox["2", "n"]}], "+", 
   RowBox[{"7", 
    RowBox[{"Sum", "[", 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"n", "-", "j"}]], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "n"}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806259325091901*^9, 3.806259351539465*^9}, {
  3.8062599069554744`*^9, 3.806259916061303*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"8d545bdb-65c3-494f-af79-07393c3b7e78"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "7"}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["2", 
    RowBox[{"1", "+", "n"}]]}]}]], "Output",
 CellChangeTimes->{3.8062599192715406`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"494b3d0c-0aeb-46e0-8027-38bea339b347"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.806322977812872*^9, 
  3.8063229859532814`*^9}},ExpressionUUID->"0362b9fa-a6ca-4c32-9d1d-\
3928760c3478"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", "n", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806260089862234*^9, 3.806260123346716*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"8930e1b6-23ed-4d92-996b-a630d3155d7d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "7"}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["2", 
    RowBox[{"1", "+", "n"}]]}]}]], "Output",
 CellChangeTimes->{3.8062601271633186`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"641eaff4-59c5-46b3-9974-ffc67b96943c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "MetodoI"}]], "Input",
 CellChangeTimes->{{3.8062602920683126`*^9, 3.806260298060459*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"42c4bdfe-1b8b-4927-be53-f1a723143e83"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Muestra sobre una relaci\[OAcute]n de recurrencia \
lineal de orden uno, sus evaluaciones en \[OpenCurlyDoubleQuote]k\
\[CloseCurlyDoubleQuote] iteraciones de forma ascendente o descendente, seg\
\[UAcute]n lo escoja el usuario. El comando es una aplicaci\[OAcute]n directa \
del m\[EAcute]todo de resoluci\[OAcute]n de relaciones de recurrencia \
denominado: \[OpenCurlyDoubleQuote]iterativo\[CloseCurlyDoubleQuote]. \
Sintaxis: MetodoI[Coeficientes, k], o bien, MetodoI[Coeficientes, k, \
ascendente->True, inicio->Valor] siendo \[OpenCurlyDoubleQuote]Coeficientes\
\[CloseCurlyDoubleQuote] un vector de dimensi\[OAcute]n uno o dos que \
contiene un coeficiente y/o la parte no homog\[EAcute]nea (en funci\[OAcute]n \
de \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]) como su \[UAcute]ltima \
componente, \[OpenCurlyDoubleQuote]ascendente->True\[CloseCurlyDoubleQuote] \
opci\[OAcute]n que exhibe los resultados de forma ascendente (por defecto es \
descendente) e \[OpenCurlyDoubleQuote]inicio->Valor\[CloseCurlyDoubleQuote], \
el valor del \[IAcute]ndice con el que empieza la condici\[OAcute]n inicial. \
\[OpenCurlyDoubleQuote]MetodoI\[CloseCurlyDoubleQuote] solo acepta \
n\[UAcute]meros enteros.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"MetodoI", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenci_List", ",", 
                    "VilCretas`Private`Rckk_", ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`MetodoID", ",", 
                    "VilCretas`Private`MetodoIA"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", "n", "]"}], ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`MetodoID", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenc_List", ",", 
                    "VilCretas`Private`Rckkk_"}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"IntegerQ", "[", "VilCretas`Private`Rckkk", "]"}],
                     "&&", 
                    RowBox[{
                    "VilCretas`Private`Rckkk", "\[GreaterEqual]", "1"}]}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenc", ",", 
                    "VilCretas`Private`Rckkk"}], "}"}], ",", "Null"}], "]"}], 
                    "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcRecurrenc", "/.", "\[VeryThinSpace]", 
                    RowBox[{"n", "\[Rule]", "1"}]}], ",", "IntegerQ"}], "]"}],
                     ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`RcRecurrenc", ",", "Null"}], 
                    "]"}], "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcRecurrenc", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilCretas`Private`MetodoIDO", "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`MetodoIDO", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrencia_", ",", 
                    "VilCretas`Private`Rck_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`RcVl25", ",", 
                    "VilCretas`Private`RcVl26", ",", 
                    "VilCretas`Private`RcProductoria", ",", 
                    "VilCretas`Private`RcSumtoria", ",", 
                    "VilCretas`Private`RcFactoresPrimos"}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], ",", "\<\"n\"\>"}], "]"}], "||", 
                    RowBox[{"IntegerQ", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    RowBox[{"a", ",", "n"}], "]"}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcVl25", "[", "VilCretas`Private`Rci_",
                     "]"}], ":=", 
                    RowBox[{
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], "/.",
                     "\[VeryThinSpace]", 
                    RowBox[{"n", "\[Rule]", "VilCretas`Private`Rci"}]}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcVl26", "[", "VilCretas`Private`Rci_",
                     "]"}], ":=", 
                    RowBox[{
                    RowBox[{
                    "First", "[", "VilCretas`Private`RcRecurrencia", "]"}], "/.",
                     "\[VeryThinSpace]", 
                    RowBox[{"n", "\[Rule]", "VilCretas`Private`Rci"}]}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcFactoresPrimos", "[", 
                    "VilCretas`Private`Rcm_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{
                    "FactorInteger", "[", "VilCretas`Private`Rcm", "]"}], 
                    "]"}], "\[Equal]", "1"}], ",", 
                    RowBox[{
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{
                    "FactorInteger", "[", "VilCretas`Private`Rcm", "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}], "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"CenterDot", "@@", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{
                    "FactorInteger", "[", "VilCretas`Private`Rcm", "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcProductoria", "[", 
                    RowBox[{
                    "VilCretas`Private`RcProdinicio_", ",", 
                    "VilCretas`Private`RcProdfinal_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilCretas`Private`RcVl27", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcVl27", "=", 
                    RowBox[{
                    UnderoverscriptBox["\[Product]", 
                    RowBox[{
                    "VilCretas`Private`Rci16", "=", 
                    "VilCretas`Private`RcProdinicio"}], 
                    "VilCretas`Private`RcProdfinal"], 
                    RowBox[{"VilCretas`Private`RcVl26", "[", 
                    RowBox[{"n", "-", "VilCretas`Private`Rci16"}], "]"}]}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "NumericQ", "[", "VilCretas`Private`RcVl27", "]"}], 
                    "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilCretas`Private`RcVl27", "]"}], 
                    "\[NotEqual]", "0"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", 
                    RowBox[{
                    "VilCretas`Private`RcVl27", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], ",", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RcVl27", ",", 
                    RowBox[{"1", "\[Rule]", 
                    RowBox[{"VilCretas`Private`RcFactoresPrimos", "[", 
                    RowBox[{
                    "VilCretas`Private`RcVl27", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}]}]}], "]"}], ",", 
                    "VilCretas`Private`RcVl27"}], "]"}], ",", 
                    "VilCretas`Private`RcVl27"}], "]"}], ",", 
                    RowBox[{
                    "VilCretas`Private`RcFactoresPrimos", "[", 
                    "VilCretas`Private`RcVl27", "]"}]}], "]"}]}]}], "]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcSumtoria", "[", 
                    RowBox[{
                    "VilCretas`Private`RcSuminicio_", ",", 
                    "VilCretas`Private`RcSumfinal_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`RcVl28", "=", "0"}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rci17", "=", 
                    "VilCretas`Private`RcSuminicio"}], ",", 
                    RowBox[{
                    "VilCretas`Private`Rci17", "\[LessEqual]", 
                    "VilCretas`Private`RcSumfinal"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcVl28", "=", 
                    RowBox[{"VilCretas`Private`RcVl28", "+", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcProductoria", "[", 
                    RowBox[{"0", ",", 
                    RowBox[{"VilCretas`Private`Rci17", "-", "1"}]}], "]"}], 
                    " ", 
                    RowBox[{"VilCretas`Private`RcVl25", "[", 
                    RowBox[{"n", "-", "VilCretas`Private`Rci17"}], 
                    "]"}]}]}]}], ";", 
                    RowBox[{"VilCretas`Private`Rci17", "++"}]}]}], "]"}], ";",
                     "VilCretas`Private`RcVl28"}]}], "]"}]}], ";", 
                    RowBox[{
                    "Print", "[", "\<\"Por el m\[EAcute]todo iterativo:\"\>", 
                    "]"}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci18", "=", "1"}], ",", 
                    RowBox[{
                    "VilCretas`Private`Rci18", "\[LessEqual]", 
                    "VilCretas`Private`Rck"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\<\"n \[Rule] \"\>", ",", 
                    RowBox[{"n", "-", "VilCretas`Private`Rci18"}], 
                    ",", "\<\": \"\>", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcProductoria", "[", 
                    RowBox[{"0", ",", "VilCretas`Private`Rci18"}], "]"}], " ", 
                    RowBox[{"a", "[", 
                    RowBox[{"n", "-", "VilCretas`Private`Rci18", "-", "1"}], 
                    "]"}]}], "+", 
                    RowBox[{"VilCretas`Private`RcSumtoria", "[", 
                    RowBox[{"1", ",", "VilCretas`Private`Rci18"}], "]"}], "+", 
                    RowBox[{"VilCretas`Private`RcVl25", "[", "n", "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"VilCretas`Private`Rci18", "++"}]}]}], "]"}]}]}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrenc", "]"}], 
                    "\[Equal]", "2"}], ",", 
                    RowBox[{"VilCretas`Private`MetodoIDO", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenc", ",", 
                    "VilCretas`Private`Rckkk"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrenc", "]"}], 
                    "\[Equal]", "1"}], ",", 
                    RowBox[{"VilCretas`Private`MetodoIDO", "[", 
                    RowBox[{
                    RowBox[{"Append", "[", 
                    RowBox[{"VilCretas`Private`RcRecurrenc", ",", "0"}], 
                    "]"}], ",", "VilCretas`Private`Rckkk"}], "]"}]}], "]"}]}],
                     "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`MetodoIA", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenc_List", ",", 
                    "VilCretas`Private`Rckkk_", ",", 
                    "VilCretas`Private`Rcinicio_"}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"IntegerQ", "[", "VilCretas`Private`Rckkk", "]"}],
                     "&&", 
                    RowBox[{
                    "VilCretas`Private`Rckkk", "\[GreaterEqual]", "1"}]}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenc", ",", 
                    "VilCretas`Private`Rckkk"}], "}"}], ",", "Null"}], "]"}], 
                    "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcRecurrenc", "/.", "\[VeryThinSpace]", 
                    RowBox[{"n", "\[Rule]", "1"}]}], ",", "IntegerQ"}], "]"}],
                     ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`RcRecurrenc", ",", "Null"}], 
                    "]"}], "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcRecurrenc", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilCretas`Private`MetodoIDOA", "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`MetodoIDOA", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrencia_", ",", 
                    "VilCretas`Private`Rck_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RcVl29", ",", 
                    "VilCretas`Private`RcVl30", ",", 
                    "VilCretas`Private`RcFactoresPrimos"}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], ",", "\<\"n\"\>"}], "]"}], "||", 
                    RowBox[{"IntegerQ", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    RowBox[{"a", ",", "n"}], "]"}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcVl29", "[", "VilCretas`Private`Rci_",
                     "]"}], ":=", 
                    RowBox[{
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], "/.",
                     "\[VeryThinSpace]", 
                    RowBox[{"n", "\[Rule]", "VilCretas`Private`Rci"}]}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcVl30", "[", "VilCretas`Private`Rci_",
                     "]"}], ":=", 
                    RowBox[{
                    RowBox[{
                    "First", "[", "VilCretas`Private`RcRecurrencia", "]"}], "/.",
                     "\[VeryThinSpace]", 
                    RowBox[{"n", "\[Rule]", "VilCretas`Private`Rci"}]}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcFactoresPrimos", "[", 
                    "VilCretas`Private`Rcm_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{
                    "FactorInteger", "[", "VilCretas`Private`Rcm", "]"}], 
                    "]"}], "\[Equal]", "1"}], ",", 
                    RowBox[{
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{
                    "FactorInteger", "[", "VilCretas`Private`Rcm", "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}], "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"CenterDot", "@@", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{
                    "FactorInteger", "[", "VilCretas`Private`Rcm", "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{
                    "Print", "[", "\<\"Por el m\[EAcute]todo iterativo:\"\>", 
                    "]"}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci22", "=", "1"}], ",", 
                    RowBox[{
                    "VilCretas`Private`Rci22", "\[LessEqual]", 
                    "VilCretas`Private`Rck"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\<\"n \[Rule] \"\>", ",", 
                    RowBox[{
                    "VilCretas`Private`Rci22", "+", 
                    "VilCretas`Private`Rcinicio"}], ",", "\<\": \"\>", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcFactoresPrimos", "[", 
                    RowBox[{
                    UnderoverscriptBox["\[Product]", 
                    RowBox[{"VilCretas`Private`Rci19", "=", "1"}], 
                    "VilCretas`Private`Rci22"], 
                    RowBox[{"VilCretas`Private`RcVl30", "[", 
                    RowBox[{
                    "VilCretas`Private`Rcinicio", "+", 
                    "VilCretas`Private`Rci19"}], "]"}]}], "]"}], " ", 
                    RowBox[{"a", "[", "VilCretas`Private`Rcinicio", "]"}]}], 
                    "+", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                    RowBox[{"VilCretas`Private`Rci20", "=", "1"}], 
                    RowBox[{"VilCretas`Private`Rci22", "-", "1"}]], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    UnderoverscriptBox["\[Product]", 
                    RowBox[{"VilCretas`Private`Rci21", "=", 
                    RowBox[{"VilCretas`Private`Rci20", "+", "1"}]}], 
                    "VilCretas`Private`Rci22"], 
                    RowBox[{"VilCretas`Private`RcVl30", "[", 
                    RowBox[{
                    "VilCretas`Private`Rcinicio", "+", 
                    "VilCretas`Private`Rci21"}], "]"}]}], ")"}], " ", 
                    RowBox[{"VilCretas`Private`RcVl29", "[", 
                    RowBox[{
                    "VilCretas`Private`Rcinicio", "+", 
                    "VilCretas`Private`Rci20"}], "]"}]}]}], "\[NotEqual]", 
                    "0"}], ",", 
                    RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                    RowBox[{"VilCretas`Private`Rci20", "=", "1"}], 
                    RowBox[{"VilCretas`Private`Rci22", "-", "1"}]], 
                    RowBox[{"VilCretas`Private`RcFactoresPrimos", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    UnderoverscriptBox["\[Product]", 
                    RowBox[{"VilCretas`Private`Rci21", "=", 
                    RowBox[{"VilCretas`Private`Rci20", "+", "1"}]}], 
                    "VilCretas`Private`Rci22"], 
                    RowBox[{"VilCretas`Private`RcVl30", "[", 
                    RowBox[{
                    "VilCretas`Private`Rcinicio", "+", 
                    "VilCretas`Private`Rci21"}], "]"}]}], ")"}], " ", 
                    RowBox[{"VilCretas`Private`RcVl29", "[", 
                    RowBox[{
                    "VilCretas`Private`Rcinicio", "+", 
                    "VilCretas`Private`Rci20"}], "]"}]}], "]"}]}], ",", "0"}],
                     "]"}], "+", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcVl29", "[", 
                    RowBox[{
                    "VilCretas`Private`Rcinicio", "+", 
                    "VilCretas`Private`Rci22"}], "]"}], "\[NotEqual]", "0"}], 
                    ",", 
                    RowBox[{"VilCretas`Private`RcFactoresPrimos", "[", 
                    RowBox[{"VilCretas`Private`RcVl29", "[", 
                    RowBox[{
                    "VilCretas`Private`Rcinicio", "+", 
                    "VilCretas`Private`Rci22"}], "]"}], "]"}], ",", "0"}], 
                    "]"}]}]}], "]"}], ";", 
                    RowBox[{"VilCretas`Private`Rci22", "++"}]}]}], "]"}]}]}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrenc", "]"}], 
                    "\[Equal]", "2"}], ",", 
                    RowBox[{"VilCretas`Private`MetodoIDOA", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenc", ",", 
                    "VilCretas`Private`Rckkk"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrenc", "]"}], 
                    "\[Equal]", "1"}], ",", 
                    RowBox[{"VilCretas`Private`MetodoIDOA", "[", 
                    RowBox[{
                    RowBox[{"Append", "[", 
                    RowBox[{"VilCretas`Private`RcRecurrenc", ",", "0"}], 
                    "]"}], ",", "VilCretas`Private`Rckkk"}], "]"}]}], "]"}]}],
                     "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"IntegerQ", "[", 
                    RowBox[{"OptionValue", "[", "inicio", "]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "inicio", "]"}], 
                    "\[GreaterEqual]", "0"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "ascendente", "]"}], "]"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "ascendente", "]"}], ",", 
                    RowBox[{"VilCretas`Private`MetodoIA", "[", 
                    RowBox[{"VilCretas`Private`RcRecurrenci", ",", 
                    "VilCretas`Private`Rckk", ",", 
                    RowBox[{"OptionValue", "[", "inicio", "]"}]}], "]"}], ",", 
                    RowBox[{"VilCretas`Private`MetodoID", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenci", ",", 
                    "VilCretas`Private`Rckk"}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ascendente", "\[Rule]", "False"}], ",", 
                    RowBox[{"inicio", "\[Rule]", "1"}]}], "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`MetodoI\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Muestra sobre una relaci\[OAcute]n de recurrencia \
lineal de orden uno, sus evaluaciones en \[OpenCurlyDoubleQuote]k\
\[CloseCurlyDoubleQuote] iteraciones de forma ascendente o descendente, seg\
\[UAcute]n lo escoja el usuario. El comando es una aplicaci\[OAcute]n directa \
del m\[EAcute]todo de resoluci\[OAcute]n de relaciones de recurrencia \
denominado: \[OpenCurlyDoubleQuote]iterativo\[CloseCurlyDoubleQuote]. \
Sintaxis: MetodoI[Coeficientes, k], o bien, MetodoI[Coeficientes, k, \
ascendente->True, inicio->Valor] siendo \[OpenCurlyDoubleQuote]Coeficientes\
\[CloseCurlyDoubleQuote] un vector de dimensi\[OAcute]n uno o dos que \
contiene un coeficiente y/o la parte no homog\[EAcute]nea (en funci\[OAcute]n \
de \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]) como su \[UAcute]ltima \
componente, \[OpenCurlyDoubleQuote]ascendente->True\[CloseCurlyDoubleQuote] \
opci\[OAcute]n que exhibe los resultados de forma ascendente (por defecto es \
descendente) e \[OpenCurlyDoubleQuote]inicio->Valor\[CloseCurlyDoubleQuote], \
el valor del \[IAcute]ndice con el que empieza la condici\[OAcute]n inicial. \
\[OpenCurlyDoubleQuote]MetodoI\[CloseCurlyDoubleQuote] solo acepta \
n\[UAcute]meros enteros.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Muestra sobre una relaci\[OAcute]n de recurrencia lineal de orden uno, \
sus evaluaciones en \[OpenCurlyDoubleQuote]k\[CloseCurlyDoubleQuote] \
iteraciones de forma ascendente o descendente, seg\[UAcute]n lo escoja el \
usuario. El comando es una aplicaci\[OAcute]n directa del m\[EAcute]todo de \
resoluci\[OAcute]n de relaciones de recurrencia denominado: \
\[OpenCurlyDoubleQuote]iterativo\[CloseCurlyDoubleQuote]. Sintaxis: \
MetodoI[Coeficientes, k], o bien, MetodoI[Coeficientes, k, ascendente->True, \
inicio->Valor] siendo \[OpenCurlyDoubleQuote]Coeficientes\
\[CloseCurlyDoubleQuote] un vector de dimensi\[OAcute]n uno o dos que \
contiene un coeficiente y/o la parte no homog\[EAcute]nea (en funci\[OAcute]n \
de \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]) como su \[UAcute]ltima \
componente, \[OpenCurlyDoubleQuote]ascendente->True\[CloseCurlyDoubleQuote] \
opci\[OAcute]n que exhibe los resultados de forma ascendente (por defecto es \
descendente) e \[OpenCurlyDoubleQuote]inicio->Valor\[CloseCurlyDoubleQuote], \
el valor del \[IAcute]ndice con el que empieza la condici\[OAcute]n inicial. \
\[OpenCurlyDoubleQuote]MetodoI\[CloseCurlyDoubleQuote] solo acepta \
n\[UAcute]meros enteros.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`MetodoI, {VilCretas`MetodoI[
         Pattern[VilCretas`Private`RcRecurrenci, 
          Blank[List]], 
         Pattern[VilCretas`Private`Rckk, 
          Blank[]], 
         OptionsPattern[]] :> 
       Module[{VilCretas`Private`MetodoID, VilCretas`Private`MetodoIA}, 
         Clear[$CellContext`n]; VilCretas`Private`MetodoID[
            Pattern[VilCretas`Private`RcRecurrenc, 
             Blank[List]], 
            Pattern[VilCretas`Private`Rckkk, 
             Blank[]]] := If[
            And[
             IntegerQ[VilCretas`Private`Rckkk], VilCretas`Private`Rckkk >= 1], 
            If[
            MemberQ[{VilCretas`Private`RcRecurrenc, VilCretas`Private`Rckkk}, 
               Null] == False, 
             If[
              VectorQ[
               ReplaceAll[VilCretas`Private`RcRecurrenc, $CellContext`n -> 1],
                IntegerQ], 
              If[MemberQ[VilCretas`Private`RcRecurrenc, Null] == False, 
               If[VilCretas`Private`RcRecurrenc != {}, 
                
                Module[{VilCretas`Private`MetodoIDO}, 
                 VilCretas`Private`MetodoIDO[
                    Pattern[VilCretas`Private`RcRecurrencia, 
                    Blank[]], 
                    Pattern[VilCretas`Private`Rck, 
                    Blank[]]] := 
                  Module[{
                    VilCretas`Private`RcVl25, VilCretas`Private`RcVl26, 
                    VilCretas`Private`RcProductoria, 
                    VilCretas`Private`RcSumtoria, 
                    VilCretas`Private`RcFactoresPrimos}, 
                    If[
                    Or[
                    StringContainsQ[
                    ToString[
                    Last[VilCretas`Private`RcRecurrencia]], "n"], 
                    IntegerQ[
                    Last[VilCretas`Private`RcRecurrencia]]], 
                    Clear[$CellContext`a, $CellContext`n]; 
                    VilCretas`Private`RcVl25[
                    Pattern[VilCretas`Private`Rci, 
                    Blank[]]] := ReplaceAll[
                    Last[VilCretas`Private`RcRecurrencia], $CellContext`n -> 
                    VilCretas`Private`Rci]; VilCretas`Private`RcVl26[
                    Pattern[VilCretas`Private`Rci, 
                    Blank[]]] := ReplaceAll[
                    First[VilCretas`Private`RcRecurrencia], $CellContext`n -> 
                    VilCretas`Private`Rci]; VilCretas`Private`RcFactoresPrimos[
                    Pattern[VilCretas`Private`Rcm, 
                    Blank[]]] := Module[{}, 
                    If[Length[
                    FactorInteger[VilCretas`Private`Rcm]] == 1, 
                    Part[
                    Apply[Superscript, 
                    FactorInteger[VilCretas`Private`Rcm], {1}], 1], 
                    Apply[CenterDot, 
                    Apply[Superscript, 
                    FactorInteger[VilCretas`Private`Rcm], {1}]]]]; 
                    VilCretas`Private`RcProductoria[
                    Pattern[VilCretas`Private`RcProdinicio, 
                    Blank[]], 
                    Pattern[VilCretas`Private`RcProdfinal, 
                    Blank[]]] := 
                    Module[{VilCretas`Private`RcVl27}, 
                    VilCretas`Private`RcVl27 = Product[
                    
                    VilCretas`Private`RcVl26[$CellContext`n - 
                    VilCretas`Private`Rci16], {
                    VilCretas`Private`Rci16, VilCretas`Private`RcProdinicio, 
                    VilCretas`Private`RcProdfinal}]; 
                    If[NumericQ[VilCretas`Private`RcVl27] == False, 
                    If[Length[VilCretas`Private`RcVl27] != 0, 
                    If[
                    NumericQ[
                    Part[VilCretas`Private`RcVl27, 1]], 
                    ReplacePart[
                    VilCretas`Private`RcVl27, 1 -> 
                    VilCretas`Private`RcFactoresPrimos[
                    Part[VilCretas`Private`RcVl27, 1]]], 
                    VilCretas`Private`RcVl27], VilCretas`Private`RcVl27], 
                    VilCretas`Private`RcFactoresPrimos[
                    VilCretas`Private`RcVl27]]]; VilCretas`Private`RcSumtoria[
                    Pattern[VilCretas`Private`RcSuminicio, 
                    Blank[]], 
                    Pattern[VilCretas`Private`RcSumfinal, 
                    Blank[]]] := 
                    Module[{VilCretas`Private`RcVl28 = 0}, 
                    For[VilCretas`Private`Rci17 = 
                    VilCretas`Private`RcSuminicio, VilCretas`Private`Rci17 <= 
                    VilCretas`Private`RcSumfinal, 
                    VilCretas`Private`RcVl28 = 
                    VilCretas`Private`RcVl28 + 
                    VilCretas`Private`RcProductoria[
                    0, VilCretas`Private`Rci17 - 1] 
                    VilCretas`Private`RcVl25[$CellContext`n - 
                    VilCretas`Private`Rci17]; 
                    Increment[VilCretas`Private`Rci17]]; 
                    VilCretas`Private`RcVl28]; 
                    Print["Por el m\[EAcute]todo iterativo:"]; 
                    For[VilCretas`Private`Rci18 = 1, VilCretas`Private`Rci18 <= 
                    VilCretas`Private`Rck, 
                    Print["n \[Rule] ", $CellContext`n - 
                    VilCretas`Private`Rci18, ": ", 
                    VilCretas`Private`RcProductoria[
                    0, VilCretas`Private`Rci18] $CellContext`a[$CellContext`n - 
                    VilCretas`Private`Rci18 - 1] + 
                    VilCretas`Private`RcSumtoria[1, VilCretas`Private`Rci18] + 
                    VilCretas`Private`RcVl25[$CellContext`n]]; 
                    Increment[VilCretas`Private`Rci18]]]]; 
                 If[Length[VilCretas`Private`RcRecurrenc] == 2, 
                   VilCretas`Private`MetodoIDO[
                   VilCretas`Private`RcRecurrenc, VilCretas`Private`Rckkk], 
                   If[Length[VilCretas`Private`RcRecurrenc] == 1, 
                    VilCretas`Private`MetodoIDO[
                    Append[VilCretas`Private`RcRecurrenc, 0], 
                    VilCretas`Private`Rckkk]]]]]]]]]; 
         VilCretas`Private`MetodoIA[
            Pattern[VilCretas`Private`RcRecurrenc, 
             Blank[List]], 
            Pattern[VilCretas`Private`Rckkk, 
             Blank[]], 
            Pattern[VilCretas`Private`Rcinicio, 
             Blank[]]] := If[
            And[
             IntegerQ[VilCretas`Private`Rckkk], VilCretas`Private`Rckkk >= 1], 
            If[
            MemberQ[{VilCretas`Private`RcRecurrenc, VilCretas`Private`Rckkk}, 
               Null] == False, 
             If[
              VectorQ[
               ReplaceAll[VilCretas`Private`RcRecurrenc, $CellContext`n -> 1],
                IntegerQ], 
              If[MemberQ[VilCretas`Private`RcRecurrenc, Null] == False, 
               If[VilCretas`Private`RcRecurrenc != {}, 
                
                Module[{VilCretas`Private`MetodoIDOA}, 
                 VilCretas`Private`MetodoIDOA[
                    Pattern[VilCretas`Private`RcRecurrencia, 
                    Blank[]], 
                    Pattern[VilCretas`Private`Rck, 
                    Blank[]]] := 
                  Module[{
                    VilCretas`Private`RcVl29, VilCretas`Private`RcVl30, 
                    VilCretas`Private`RcFactoresPrimos}, 
                    If[
                    Or[
                    StringContainsQ[
                    ToString[
                    Last[VilCretas`Private`RcRecurrencia]], "n"], 
                    IntegerQ[
                    Last[VilCretas`Private`RcRecurrencia]]], 
                    Clear[$CellContext`a, $CellContext`n]; 
                    VilCretas`Private`RcVl29[
                    Pattern[VilCretas`Private`Rci, 
                    Blank[]]] := ReplaceAll[
                    Last[VilCretas`Private`RcRecurrencia], $CellContext`n -> 
                    VilCretas`Private`Rci]; VilCretas`Private`RcVl30[
                    Pattern[VilCretas`Private`Rci, 
                    Blank[]]] := ReplaceAll[
                    First[VilCretas`Private`RcRecurrencia], $CellContext`n -> 
                    VilCretas`Private`Rci]; VilCretas`Private`RcFactoresPrimos[
                    Pattern[VilCretas`Private`Rcm, 
                    Blank[]]] := Module[{}, 
                    If[Length[
                    FactorInteger[VilCretas`Private`Rcm]] == 1, 
                    Part[
                    Apply[Superscript, 
                    FactorInteger[VilCretas`Private`Rcm], {1}], 1], 
                    Apply[CenterDot, 
                    Apply[Superscript, 
                    FactorInteger[VilCretas`Private`Rcm], {1}]]]]; 
                    Print["Por el m\[EAcute]todo iterativo:"]; 
                    For[VilCretas`Private`Rci22 = 1, VilCretas`Private`Rci22 <= 
                    VilCretas`Private`Rck, 
                    Print["n \[Rule] ", VilCretas`Private`Rci22 + 
                    VilCretas`Private`Rcinicio, ": ", 
                    VilCretas`Private`RcFactoresPrimos[
                    Product[
                    VilCretas`Private`RcVl30[
                    VilCretas`Private`Rcinicio + VilCretas`Private`Rci19], {
                    VilCretas`Private`Rci19, 1, 
                    VilCretas`Private`Rci22}]] $CellContext`a[
                    VilCretas`Private`Rcinicio] + If[Sum[Product[
                    VilCretas`Private`RcVl30[
                    VilCretas`Private`Rcinicio + VilCretas`Private`Rci21], {
                    VilCretas`Private`Rci21, VilCretas`Private`Rci20 + 1, 
                    VilCretas`Private`Rci22}] 
                    VilCretas`Private`RcVl29[
                    VilCretas`Private`Rcinicio + VilCretas`Private`Rci20], {
                    VilCretas`Private`Rci20, 1, VilCretas`Private`Rci22 - 1}] != 
                    0, 
                    Sum[
                    VilCretas`Private`RcFactoresPrimos[Product[
                    VilCretas`Private`RcVl30[
                    VilCretas`Private`Rcinicio + VilCretas`Private`Rci21], {
                    VilCretas`Private`Rci21, VilCretas`Private`Rci20 + 1, 
                    VilCretas`Private`Rci22}] 
                    VilCretas`Private`RcVl29[
                    VilCretas`Private`Rcinicio + VilCretas`Private`Rci20]], {
                    VilCretas`Private`Rci20, 1, VilCretas`Private`Rci22 - 1}],
                     0] + If[
                    VilCretas`Private`RcVl29[
                    VilCretas`Private`Rcinicio + VilCretas`Private`Rci22] != 
                    0, 
                    VilCretas`Private`RcFactoresPrimos[
                    VilCretas`Private`RcVl29[
                    VilCretas`Private`Rcinicio + VilCretas`Private`Rci22]], 
                    0]]; Increment[VilCretas`Private`Rci22]]]]; 
                 If[Length[VilCretas`Private`RcRecurrenc] == 2, 
                   VilCretas`Private`MetodoIDOA[
                   VilCretas`Private`RcRecurrenc, VilCretas`Private`Rckkk], 
                   If[Length[VilCretas`Private`RcRecurrenc] == 1, 
                    VilCretas`Private`MetodoIDOA[
                    Append[VilCretas`Private`RcRecurrenc, 0], 
                    VilCretas`Private`Rckkk]]]]]]]]]; If[
           And[
            IntegerQ[
             OptionValue[VilCretas`inicio]], OptionValue[VilCretas`inicio] >= 
            0], 
           If[
            BooleanQ[
             OptionValue[VilCretas`ascendente]], 
            If[
             OptionValue[VilCretas`ascendente], 
             VilCretas`Private`MetodoIA[
             VilCretas`Private`RcRecurrenci, VilCretas`Private`Rckk, 
              OptionValue[VilCretas`inicio]], 
             VilCretas`Private`MetodoID[
             VilCretas`Private`RcRecurrenci, VilCretas`Private`Rckk]]]]]}], 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, 
    "Options" -> {VilCretas`ascendente -> False, VilCretas`inicio -> 1}, 
    "Attributes" -> {Protected}, "FullName" -> "VilCretas`MetodoI"], 
   False]]], "Output",
 CellChangeTimes->{3.8062602990593176`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"104bd798-68f9-48d5-bf70-7cfd541569f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.8062603176938877`*^9, 3.8062603197321057`*^9}, {
  3.806260612120199*^9, 3.8062606332202873`*^9}, {3.8062609700978084`*^9, 
  3.8062609746342144`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"34270c90-e180-443e-8ff9-b73158c1f5c2"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Por el m\[EAcute]todo iterativo:\"\>"], "Print",
 CellChangeTimes->{3.8062609753552246`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"c2c8d244-fde5-4cba-91fa-8f2b1147666c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "7"}], "+", 
   RowBox[{"7", " ", 
    TemplateBox[{"2", "1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2", "2"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -1 + $CellContext`n, ": ", 7 + 
   7 Superscript[2, 1] + $CellContext`a[-2 + $CellContext`n] 
    Superscript[2, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.806260975357219*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"3bf5da45-da71-4f0f-86d6-4aa28ff5323b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "7"}], "+", 
   RowBox[{"7", " ", 
    TemplateBox[{"2", "1"},
     "Superscript"]}], "+", 
   RowBox[{"7", " ", 
    TemplateBox[{"2", "2"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2", "3"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -2 + $CellContext`n, ": ", 7 + 7 Superscript[2, 1] + 
   7 Superscript[2, 2] + $CellContext`a[-3 + $CellContext`n] 
    Superscript[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8062609753602104`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"5720123f-fa5e-40ce-a742-42d3cb9cbaac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "7"}], "+", 
   RowBox[{"7", " ", 
    TemplateBox[{"2", "1"},
     "Superscript"]}], "+", 
   RowBox[{"7", " ", 
    TemplateBox[{"2", "2"},
     "Superscript"]}], "+", 
   RowBox[{"7", " ", 
    TemplateBox[{"2", "3"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "4"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2", "4"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -3 + $CellContext`n, ": ", 7 + 7 Superscript[2, 1] + 
   7 Superscript[2, 2] + 
   7 Superscript[2, 3] + $CellContext`a[-4 + $CellContext`n] 
    Superscript[2, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8062609753622055`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"34536612-e160-4c43-b06c-69a2f3588a08"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{946.5, 381.5},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"bc43dc81-b1a1-450b-bed3-391ed5a0b2d4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 528, 14, 104, "Input",ExpressionUUID->"8d545bdb-65c3-494f-af79-07393c3b7e78"],
Cell[1111, 38, 264, 7, 101, "Output",ExpressionUUID->"494b3d0c-0aeb-46e0-8027-38bea339b347"]
}, Open  ]],
Cell[1390, 48, 182, 4, 63, "Input",ExpressionUUID->"0362b9fa-a6ca-4c32-9d1d-3928760c3478"],
Cell[CellGroupData[{
Cell[1597, 56, 351, 8, 63, "Input",ExpressionUUID->"8930e1b6-23ed-4d92-996b-a630d3155d7d"],
Cell[1951, 66, 264, 7, 101, "Output",ExpressionUUID->"641eaff4-59c5-46b3-9974-ffc67b96943c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2252, 78, 197, 3, 63, "Input",ExpressionUUID->"42c4bdfe-1b8b-4927-be53-f1a723143e83"],
Cell[2452, 83, 50402, 1053, 1147, "Output",ExpressionUUID->"104bd798-68f9-48d5-bf70-7cfd541569f8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52891, 1141, 385, 8, 91, "Input",ExpressionUUID->"34270c90-e180-443e-8ff9-b73158c1f5c2"],
Cell[CellGroupData[{
Cell[53301, 1153, 227, 4, 50, "Print",ExpressionUUID->"c2c8d244-fde5-4cba-91fa-8f2b1147666c"],
Cell[53531, 1159, 794, 24, 50, "Print",ExpressionUUID->"3bf5da45-da71-4f0f-86d6-4aa28ff5323b"],
Cell[54328, 1185, 897, 27, 50, "Print",ExpressionUUID->"5720123f-fa5e-40ce-a742-42d3cb9cbaac"],
Cell[55228, 1214, 1002, 31, 50, "Print",ExpressionUUID->"34536612-e160-4c43-b06c-69a2f3588a08"]
}, Open  ]]
}, Open  ]]
}
]
*)

