(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     45040,        979]
NotebookOptionsPosition[     43386,        944]
NotebookOutlinePosition[     43820,        961]
CellTagsIndexPosition[     43777,        958]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8064297289656525`*^9, 3.806429736822343*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"afe23ceb-80d0-4f4f-9797-3a7c933f30f2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "CDFNRegions"}]], "Input",
 CellChangeTimes->{{3.8064297468435993`*^9, 3.8064297519645567`*^9}, {
  3.806430561649046*^9, 3.806430566521796*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"4a81f7b8-efbf-4318-95e3-425441aac4a8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Muestra sobre un plano el n\[UAcute]mero de \
regiones en las que queda dividido al emplear \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] rectas que se cortan dos a dos en un \[UAcute]nico \
punto con 1\[LessEqual]n\[LessEqual]6. Sintaxis: CDFNRegions[].\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"CDFNRegions", "[", "]"}], ":=", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`VNRegions", "]"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "1", "\[LessEqual]", "VilCretas`Private`VNRegions", 
                    "\[LessEqual]", "6"}], ",", 
                    RowBox[{"Column", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Show", "[", 
                    RowBox[{
                    RowBox[{"Plot", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`x", ",", 
                    RowBox[{"-", "VilCretas`Private`x"}], ",", 
                    RowBox[{"-", "5"}], ",", 
                    RowBox[{
                    RowBox[{"2", " ", "VilCretas`Private`x"}], "-", "5"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "VilCretas`Private`x"}], "+", 
                    "5"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "6"}], " ", "VilCretas`Private`x"}], "+", 
                    "6"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`x", ",", 
                    RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", 
                    RowBox[{"Frame", "\[Rule]", "False"}], ",", 
                    RowBox[{"Axes", "\[Rule]", "False"}], ",", 
                    RowBox[{"PlotStyle", "\[Rule]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "1"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "Black", ",", "Transparent", ",", "Transparent", ",", 
                    "Transparent", ",", "Transparent", ",", "Transparent"}], 
                    "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "2"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "Automatic", ",", "Automatic", ",", "Transparent", ",", 
                    "Transparent", ",", "Transparent", ",", "Transparent"}], 
                    "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "3"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "Automatic", ",", "Automatic", ",", "Automatic", ",", 
                    "Transparent", ",", "Transparent", ",", "Transparent"}], 
                    "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "4"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "Automatic", ",", "Automatic", ",", "Automatic", ",", 
                    "Automatic", ",", "Transparent", ",", "Transparent"}], 
                    "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "5"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "Automatic", ",", "Automatic", ",", "Automatic", ",", 
                    "Automatic", ",", "Automatic", ",", "Transparent"}], 
                    "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "6"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "Automatic", ",", "Automatic", ",", "Automatic", ",", 
                    "Automatic", ",", "Automatic", ",", "Automatic"}], 
                    "}"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "1"}], 
                    ",", 
                    RowBox[{"RegionPlot", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`y", ">", "VilCretas`Private`x"}], ",", 
                    RowBox[{
                    "VilCretas`Private`y", "<", "VilCretas`Private`x"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`x", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`y", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "2"}], 
                    ",", 
                    RowBox[{"RegionPlot", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`y", ">", "VilCretas`Private`x"}], ",", 
                    RowBox[{
                    "VilCretas`Private`y", "<", "VilCretas`Private`x"}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{"-", "VilCretas`Private`x"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{"-", "VilCretas`Private`x"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`x", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`y", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "3"}], 
                    ",", 
                    RowBox[{"RegionPlot", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`y", ">", "VilCretas`Private`x"}], ",", 
                    RowBox[{
                    "VilCretas`Private`y", "<", "VilCretas`Private`x"}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{"-", "VilCretas`Private`x"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{"-", "VilCretas`Private`x"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{"-", "5"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{"-", "5"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`x", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`y", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "4"}], 
                    ",", 
                    RowBox[{"RegionPlot", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`y", ">", "VilCretas`Private`x"}], ",", 
                    RowBox[{
                    "VilCretas`Private`y", "<", "VilCretas`Private`x"}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{"-", "VilCretas`Private`x"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{"-", "VilCretas`Private`x"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{"-", "5"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{"-", "5"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{
                    RowBox[{"2", " ", "VilCretas`Private`x"}], "-", "5"}]}], 
                    ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{
                    RowBox[{"2", " ", "VilCretas`Private`x"}], "-", "5"}]}]}],
                     "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`x", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`y", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "5"}], 
                    ",", 
                    RowBox[{"RegionPlot", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`y", ">", "VilCretas`Private`x"}], ",", 
                    RowBox[{
                    "VilCretas`Private`y", "<", "VilCretas`Private`x"}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{"-", "VilCretas`Private`x"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{"-", "VilCretas`Private`x"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{"-", "5"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{"-", "5"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{
                    RowBox[{"2", " ", "VilCretas`Private`x"}], "-", "5"}]}], 
                    ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{
                    RowBox[{"2", " ", "VilCretas`Private`x"}], "-", "5"}]}], 
                    ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "VilCretas`Private`x"}], "+", 
                    "5"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "VilCretas`Private`x"}], "+", 
                    "5"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`x", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`y", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "6"}], 
                    ",", 
                    RowBox[{"RegionPlot", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`y", ">", "VilCretas`Private`x"}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    "VilCretas`Private`x"}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{"-", "VilCretas`Private`x"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{"-", "VilCretas`Private`x"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{"-", "5"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{"-", "5"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{
                    RowBox[{"2", " ", "VilCretas`Private`x"}], "-", "5"}]}], 
                    ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{
                    RowBox[{"2", " ", "VilCretas`Private`x"}], "-", "5"}]}], 
                    ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "VilCretas`Private`x"}], "+", 
                    "5"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "VilCretas`Private`x"}], "+", 
                    "5"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", ">", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "6"}], " ", "VilCretas`Private`x"}], "+", 
                    "6"}]}], ",", 
                    RowBox[{"VilCretas`Private`y", "<", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "6"}], " ", "VilCretas`Private`x"}], "+", 
                    "6"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`x", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`y", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "1"}], 
                    ",", "\<\"Dos regiones\"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "2"}], 
                    ",", "\<\"Cuatro regiones\"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "3"}], 
                    ",", "\<\"Siete regiones\"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "4"}], 
                    ",", "\<\"Once regiones\"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "5"}], 
                    ",", "\<\"Dieciseis regiones\"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VNRegions", "\[Equal]", "6"}], 
                    ",", "\<\"Veintidos regiones\"\>"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}], "}"}], "]"}]}], "}"}], 
                    ",", "Center"}], "]"}], ",", "\<\"NaD\"\>"}], "]"}], 
                    ",", "\<\"NaD\"\>"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`VNRegions", ",", "1", 
                    ",", "\<\"n\"\>"}], "}"}], ",", "1", ",", "6", ",", "1", 
                    ",", 
                    RowBox[{"Appearance", "\[Rule]", "\<\"Open\"\>"}]}], 
                    "}"}], ",", 
                    RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`CDFNRegions\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Muestra sobre un plano el n\[UAcute]mero de \
regiones en las que queda dividido al emplear \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] rectas que se cortan dos a dos en un \[UAcute]nico \
punto con 1\[LessEqual]n\[LessEqual]6. Sintaxis: CDFNRegions[].\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Muestra sobre un plano el n\[UAcute]mero de regiones en las que queda \
dividido al emplear \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] rectas \
que se cortan dos a dos en un \[UAcute]nico punto con 1\[LessEqual]n\
\[LessEqual]6. Sintaxis: CDFNRegions[].", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`CDFNRegions, {VilCretas`CDFNRegions[] :> Manipulate[
         If[
          IntegerQ[VilCretas`Private`VNRegions], 
          If[1 <= VilCretas`Private`VNRegions <= 6, 
           Column[{
             Show[
              
              Plot[{VilCretas`Private`x, -VilCretas`Private`x, -5, 
                2 VilCretas`Private`x - 5, (-2) VilCretas`Private`x + 
                5, (-6) VilCretas`Private`x + 6}, {
               VilCretas`Private`x, -15, 15}, Frame -> False, Axes -> False, 
               PlotStyle -> 
               If[VilCretas`Private`VNRegions == 1, {
                 Black, Transparent, Transparent, Transparent, Transparent, 
                  Transparent}, 
                 If[
                 VilCretas`Private`VNRegions == 2, {
                  Automatic, Automatic, Transparent, Transparent, Transparent,
                    Transparent}, 
                  If[
                  VilCretas`Private`VNRegions == 3, {
                   Automatic, Automatic, Automatic, Transparent, Transparent, 
                    Transparent}, 
                   If[
                   VilCretas`Private`VNRegions == 4, {
                    Automatic, Automatic, Automatic, Automatic, Transparent, 
                    Transparent}, 
                    If[
                    VilCretas`Private`VNRegions == 5, {
                    Automatic, Automatic, Automatic, Automatic, Automatic, 
                    Transparent}, 
                    If[
                    VilCretas`Private`VNRegions == 6, {
                    Automatic, Automatic, Automatic, Automatic, Automatic, 
                    Automatic}]]]]]]], 
              If[VilCretas`Private`VNRegions == 1, 
               
               RegionPlot[{
                VilCretas`Private`y > VilCretas`Private`x, 
                 VilCretas`Private`y < VilCretas`Private`x}, {
                VilCretas`Private`x, -100, 100}, {
                VilCretas`Private`y, -100, 100}], 
               If[VilCretas`Private`VNRegions == 2, 
                
                RegionPlot[{
                 VilCretas`Private`y > VilCretas`Private`x, 
                  VilCretas`Private`y < VilCretas`Private`x, 
                  VilCretas`Private`y > -VilCretas`Private`x, 
                  VilCretas`Private`y < -VilCretas`Private`x}, {
                 VilCretas`Private`x, -100, 100}, {
                 VilCretas`Private`y, -100, 100}], 
                If[VilCretas`Private`VNRegions == 3, 
                 
                 RegionPlot[{
                  VilCretas`Private`y > VilCretas`Private`x, 
                   VilCretas`Private`y < VilCretas`Private`x, 
                   VilCretas`Private`y > -VilCretas`Private`x, 
                   VilCretas`Private`y < -VilCretas`Private`x, 
                   VilCretas`Private`y > -5, VilCretas`Private`y < -5}, {
                  VilCretas`Private`x, -100, 100}, {
                  VilCretas`Private`y, -100, 100}], 
                 If[VilCretas`Private`VNRegions == 4, 
                  
                  RegionPlot[{
                   VilCretas`Private`y > VilCretas`Private`x, 
                    VilCretas`Private`y < VilCretas`Private`x, 
                    VilCretas`Private`y > -VilCretas`Private`x, 
                    VilCretas`Private`y < -VilCretas`Private`x, 
                    VilCretas`Private`y > -5, VilCretas`Private`y < -5, 
                    VilCretas`Private`y > 2 VilCretas`Private`x - 5, 
                    VilCretas`Private`y < 2 VilCretas`Private`x - 5}, {
                   VilCretas`Private`x, -100, 100}, {
                   VilCretas`Private`y, -100, 100}], 
                  If[VilCretas`Private`VNRegions == 5, 
                   
                   RegionPlot[{
                    VilCretas`Private`y > VilCretas`Private`x, 
                    VilCretas`Private`y < VilCretas`Private`x, 
                    VilCretas`Private`y > -VilCretas`Private`x, 
                    VilCretas`Private`y < -VilCretas`Private`x, 
                    VilCretas`Private`y > -5, VilCretas`Private`y < -5, 
                    VilCretas`Private`y > 2 VilCretas`Private`x - 5, 
                    VilCretas`Private`y < 2 VilCretas`Private`x - 5, 
                    VilCretas`Private`y > (-2) VilCretas`Private`x + 5, 
                    VilCretas`Private`y < (-2) VilCretas`Private`x + 5}, {
                    VilCretas`Private`x, -100, 100}, {
                    VilCretas`Private`y, -100, 100}], 
                   If[VilCretas`Private`VNRegions == 6, 
                    
                    RegionPlot[{
                    VilCretas`Private`y > VilCretas`Private`x, 
                    VilCretas`Private`y < VilCretas`Private`x, 
                    VilCretas`Private`y > -VilCretas`Private`x, 
                    VilCretas`Private`y < -VilCretas`Private`x, 
                    VilCretas`Private`y > -5, VilCretas`Private`y < -5, 
                    VilCretas`Private`y > 2 VilCretas`Private`x - 5, 
                    VilCretas`Private`y < 2 VilCretas`Private`x - 5, 
                    VilCretas`Private`y > (-2) VilCretas`Private`x + 5, 
                    VilCretas`Private`y < (-2) VilCretas`Private`x + 5, 
                    VilCretas`Private`y > (-6) VilCretas`Private`x + 6, 
                    VilCretas`Private`y < (-6) VilCretas`Private`x + 6}, {
                    VilCretas`Private`x, -100, 100}, {
                    VilCretas`Private`y, -100, 100}]]]]]]]], 
             Row[{
               If[VilCretas`Private`VNRegions == 1, "Dos regiones", 
                If[VilCretas`Private`VNRegions == 2, "Cuatro regiones", 
                 If[VilCretas`Private`VNRegions == 3, "Siete regiones", 
                  If[VilCretas`Private`VNRegions == 4, "Once regiones", 
                   If[VilCretas`Private`VNRegions == 5, "Dieciseis regiones", 
                    If[
                    VilCretas`Private`VNRegions == 6, 
                    "Veintidos regiones"]]]]]]}]}, Center], "NaD"], "NaD"], {{
          VilCretas`Private`VNRegions, 1, "n"}, 1, 6, 1, Appearance -> 
          "Open"}, Alignment -> Center]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilCretas`CDFNRegions"], False]]], "Output",
 CellChangeTimes->{3.8064297527442904`*^9, 3.806430567095806*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"fa94b3ee-edb2-4bdc-8692-1b2cc0a57f24"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFNRegions", "[", "]"}]], "Input",
 CellChangeTimes->{{3.8064308221403065`*^9, 3.806430828715219*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"bfb70af5-a8b6-44fe-a53f-9ae44d7bf5cd"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`VNRegions$$ = 1, Typeset`show$$ = True,
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`VNRegions$$], 1, "n"}, 1, 6, 1}}, 
    Typeset`size$$ = {405., {138.6, 152.1}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`VNRegions$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[
        IntegerQ[VilCretas`Private`VNRegions$$], 
        If[1 <= VilCretas`Private`VNRegions$$ <= 6, 
         Column[{
           Show[
            
            Plot[{VilCretas`Private`x, -VilCretas`Private`x, -5, 
              2 VilCretas`Private`x - 5, (-2) VilCretas`Private`x + 
              5, (-6) VilCretas`Private`x + 6}, {
             VilCretas`Private`x, -15, 15}, Frame -> False, Axes -> False, 
             PlotStyle -> 
             If[VilCretas`Private`VNRegions$$ == 1, {
               Black, Transparent, Transparent, Transparent, Transparent, 
                Transparent}, 
               If[
               VilCretas`Private`VNRegions$$ == 2, {
                Automatic, Automatic, Transparent, Transparent, Transparent, 
                 Transparent}, 
                If[
                VilCretas`Private`VNRegions$$ == 3, {
                 Automatic, Automatic, Automatic, Transparent, Transparent, 
                  Transparent}, 
                 If[
                 VilCretas`Private`VNRegions$$ == 4, {
                  Automatic, Automatic, Automatic, Automatic, Transparent, 
                   Transparent}, 
                  If[
                  VilCretas`Private`VNRegions$$ == 5, {
                   Automatic, Automatic, Automatic, Automatic, Automatic, 
                    Transparent}, 
                   If[
                   VilCretas`Private`VNRegions$$ == 6, {
                    Automatic, Automatic, Automatic, Automatic, Automatic, 
                    Automatic}]]]]]]], 
            If[VilCretas`Private`VNRegions$$ == 1, 
             
             RegionPlot[{
              VilCretas`Private`y > VilCretas`Private`x, VilCretas`Private`y < 
               VilCretas`Private`x}, {VilCretas`Private`x, -100, 100}, {
              VilCretas`Private`y, -100, 100}], 
             If[VilCretas`Private`VNRegions$$ == 2, 
              
              RegionPlot[{
               VilCretas`Private`y > VilCretas`Private`x, VilCretas`Private`y < 
                VilCretas`Private`x, 
                VilCretas`Private`y > -VilCretas`Private`x, 
                VilCretas`Private`y < -VilCretas`Private`x}, {
               VilCretas`Private`x, -100, 100}, {
               VilCretas`Private`y, -100, 100}], 
              If[VilCretas`Private`VNRegions$$ == 3, 
               
               RegionPlot[{
                VilCretas`Private`y > VilCretas`Private`x, 
                 VilCretas`Private`y < VilCretas`Private`x, 
                 VilCretas`Private`y > -VilCretas`Private`x, 
                 VilCretas`Private`y < -VilCretas`Private`x, 
                 VilCretas`Private`y > -5, VilCretas`Private`y < -5}, {
                VilCretas`Private`x, -100, 100}, {
                VilCretas`Private`y, -100, 100}], 
               If[VilCretas`Private`VNRegions$$ == 4, 
                
                RegionPlot[{
                 VilCretas`Private`y > VilCretas`Private`x, 
                  VilCretas`Private`y < VilCretas`Private`x, 
                  VilCretas`Private`y > -VilCretas`Private`x, 
                  VilCretas`Private`y < -VilCretas`Private`x, 
                  VilCretas`Private`y > -5, VilCretas`Private`y < -5, 
                  VilCretas`Private`y > 2 VilCretas`Private`x - 5, 
                  VilCretas`Private`y < 2 VilCretas`Private`x - 5}, {
                 VilCretas`Private`x, -100, 100}, {
                 VilCretas`Private`y, -100, 100}], 
                If[VilCretas`Private`VNRegions$$ == 5, 
                 
                 RegionPlot[{
                  VilCretas`Private`y > VilCretas`Private`x, 
                   VilCretas`Private`y < VilCretas`Private`x, 
                   VilCretas`Private`y > -VilCretas`Private`x, 
                   VilCretas`Private`y < -VilCretas`Private`x, 
                   VilCretas`Private`y > -5, VilCretas`Private`y < -5, 
                   VilCretas`Private`y > 2 VilCretas`Private`x - 5, 
                   VilCretas`Private`y < 2 VilCretas`Private`x - 5, 
                   VilCretas`Private`y > (-2) VilCretas`Private`x + 5, 
                   VilCretas`Private`y < (-2) VilCretas`Private`x + 5}, {
                  VilCretas`Private`x, -100, 100}, {
                  VilCretas`Private`y, -100, 100}], 
                 If[VilCretas`Private`VNRegions$$ == 6, 
                  
                  RegionPlot[{
                   VilCretas`Private`y > VilCretas`Private`x, 
                    VilCretas`Private`y < VilCretas`Private`x, 
                    VilCretas`Private`y > -VilCretas`Private`x, 
                    VilCretas`Private`y < -VilCretas`Private`x, 
                    VilCretas`Private`y > -5, VilCretas`Private`y < -5, 
                    VilCretas`Private`y > 2 VilCretas`Private`x - 5, 
                    VilCretas`Private`y < 2 VilCretas`Private`x - 5, 
                    VilCretas`Private`y > (-2) VilCretas`Private`x + 5, 
                    VilCretas`Private`y < (-2) VilCretas`Private`x + 5, 
                    VilCretas`Private`y > (-6) VilCretas`Private`x + 6, 
                    VilCretas`Private`y < (-6) VilCretas`Private`x + 6}, {
                   VilCretas`Private`x, -100, 100}, {
                   VilCretas`Private`y, -100, 100}]]]]]]]], 
           Row[{
             If[VilCretas`Private`VNRegions$$ == 1, "Dos regiones", 
              If[VilCretas`Private`VNRegions$$ == 2, "Cuatro regiones", 
               If[VilCretas`Private`VNRegions$$ == 3, "Siete regiones", 
                If[VilCretas`Private`VNRegions$$ == 4, "Once regiones", 
                 If[VilCretas`Private`VNRegions$$ == 5, "Dieciseis regiones", 
                  If[
                  VilCretas`Private`VNRegions$$ == 6, 
                   "Veintidos regiones"]]]]]]}]}, Center], "NaD"], "NaD"], 
      "Specifications" :> {{{VilCretas`Private`VNRegions$$, 1, "n"}, 1, 6, 1, 
         Appearance -> "Open"}}, "Options" :> {Alignment -> Center}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{545., {244.75, 258.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.8064308300599284`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"b73ebc9b-cc85-4127-9385-00b40b2fde82"]
}, Open  ]],

Cell["Forma 1:", "Text",
 CellChangeTimes->{{3.806230639528782*^9, 
  3.806230643820573*^9}},ExpressionUUID->"1b351008-d0f9-44ed-837f-\
ed7d2cea0b63"],

Cell[BoxData[
 RowBox[{"Clear", "[", "a", "]"}]], "Input",
 CellChangeTimes->{{3.8062299619323297`*^9, 3.8062299652547393`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"60607edd-79b5-420a-9205-c9991866ff5c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"n", "-", "1"}], "]"}], "+", "n"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"a", "[", "7", "]"}]}], "Input",
 CellChangeTimes->{{3.8062296666769915`*^9, 3.8062296987657423`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"56281e91-ee24-46fe-a564-6c2973b42714"],

Cell[BoxData["29"], "Output",
 CellChangeTimes->{3.806229699426101*^9, 3.8062297631071863`*^9, 
  3.806229969502469*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"93c55851-dfa8-4905-a2ae-e880f3482dab"]
}, Open  ]],

Cell["Forma 2:", "Text",
 CellChangeTimes->{{3.806230639528782*^9, 
  3.8062306504533525`*^9}},ExpressionUUID->"ded1faf2-b650-43b4-9cee-\
26b7a343f4e7"],

Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.806230654264642*^9, 3.806230662582991*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e21e188c-5a04-4ad5-b971-8fad64fb64f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"RT", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", "2", "}"}], ",", "7"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.806230673165305*^9, 3.8062306768046875`*^9}, {
  3.8062307191987796`*^9, 3.8062307472236166`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"94487839-35ab-4050-ac3d-db5f237e0683"],

Cell[BoxData["29"], "Output",
 CellChangeTimes->{3.806230750437403*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"06ed5ead-3d7d-4bb0-8e82-8b029263b01e"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e14f5f21-f5be-460d-b83f-050005af5ff4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"afe23ceb-80d0-4f4f-9797-3a7c933f30f2"],
Cell[CellGroupData[{
Cell[783, 27, 251, 4, 63, "Input",ExpressionUUID->"4a81f7b8-efbf-4318-95e3-425441aac4a8"],
Cell[1037, 33, 32630, 697, 402, "Output",ExpressionUUID->"fa94b3ee-edb2-4bdc-8692-1b2cc0a57f24"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33704, 735, 205, 3, 63, "Input",ExpressionUUID->"bfb70af5-a8b6-44fe-a53f-9ae44d7bf5cd"],
Cell[33912, 740, 7457, 142, 578, "Output",ExpressionUUID->"b73ebc9b-cc85-4127-9385-00b40b2fde82"]
}, Open  ]],
Cell[41384, 885, 150, 3, 77, "Text",ExpressionUUID->"1b351008-d0f9-44ed-837f-ed7d2cea0b63"],
Cell[41537, 890, 207, 3, 97, "Input",ExpressionUUID->"60607edd-79b5-420a-9205-c9991866ff5c"],
Cell[CellGroupData[{
Cell[41769, 897, 459, 11, 151, "Input",ExpressionUUID->"56281e91-ee24-46fe-a564-6c2973b42714"],
Cell[42231, 910, 199, 3, 100, "Output",ExpressionUUID->"93c55851-dfa8-4905-a2ae-e880f3482dab"]
}, Open  ]],
Cell[42445, 916, 152, 3, 77, "Text",ExpressionUUID->"ded1faf2-b650-43b4-9cee-26b7a343f4e7"],
Cell[42600, 921, 198, 3, 63, "Input",ExpressionUUID->"e21e188c-5a04-4ad5-b971-8fad64fb64f9"],
Cell[CellGroupData[{
Cell[42823, 928, 395, 9, 97, "Input",ExpressionUUID->"94487839-35ab-4050-ac3d-db5f237e0683"],
Cell[43221, 939, 149, 2, 100, "Output",ExpressionUUID->"06ed5ead-3d7d-4bb0-8e82-8b029263b01e"]
}, Open  ]]
}
]
*)

