(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    335098,       8717]
NotebookOptionsPosition[    307465,       8292]
NotebookOutlinePosition[    307942,       8310]
CellTagsIndexPosition[    307899,       8307]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8068623540125313`*^9, 3.806862362882429*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"b5d3498b-8524-4438-a21b-5002439b597c"],

Cell["2.3.1", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 
  3.8068512095520086`*^9}},ExpressionUUID->"19102db1-053b-43ee-8a42-\
f917be26372f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GraficaRRL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"-", "4"}], "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"npuntos", "\[Rule]", "20"}], ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"RT", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"-", "4"}], "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", "20", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8068623782665157`*^9, 3.8068624067295704`*^9}, {
  3.80686690483893*^9, 3.806866905198451*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"550414d1-8555-4fb3-a60c-3014991a3732"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
     AbsoluteThickness[1.6], 
     TagBox[{
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgAmImKIaAD/YQ2uQAKh8GOBwgdMkBVD4MiED5Ww6g8mFA
Bsr/cgCVDwNKUL7JQVQ+DKjB7D+IyocBLZj9B1H5MKAHs/8gKh8GDGH2H0Ll
w4AxzP5DqHwGBgDFPhfh
         "],
         VertexColors->None]}, 
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgAmImKEYFIg4YQhAAFQ9xQOXDgACUP8UBlQ8DElD+FQdU
PgwoQPkijqh8GFCB2e+IyocBDZj9jqh8GNCB2e+IyocBA5j9Tqh8GDCC2e+E
ymdgAADZjw8P
         "],
         VertexColors->None]}},
      Annotation[#, "Charting`Private`Tag$5822#1"]& ]}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
      AbsoluteThickness[1.6], {}, PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQjQpEHCD0B3sIbXIAKgEVD4HSHFC6BCovAOVPcUA1
ZwtUXgLKvwKlZaD0F6i8AkyfI4RWgvJNDkJoFZj9UHk1mP1QeQ2Y/VB5LZj9
UHkdmP1QeT2Y/VB5A5j9ThDaEGb/IQhtBLMfKm8Ms/8QAIBhHS8=
       "]], {}},
     Annotation[#, "Charting`Private`Tag$5822#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05]},
  PlotRange->{{0, 19.}, {-1.37438953472*^12, 3.4359738368*^11}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.806862445434648*^9, 3.8068657293223395`*^9, 
  3.8068669062473464`*^9, 3.8068674759907312`*^9, 3.8068676125618563`*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"98f100d0-d7b8-4257-b5db-838b539adb59"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   RowBox[{"-", "20"}], ",", "80", ",", 
   RowBox[{"-", "320"}], ",", "1280", ",", 
   RowBox[{"-", "5120"}], ",", "20480", ",", 
   RowBox[{"-", "81920"}], ",", "327680", ",", 
   RowBox[{"-", "1310720"}], ",", "5242880", ",", 
   RowBox[{"-", "20971520"}], ",", "83886080", ",", 
   RowBox[{"-", "335544320"}], ",", "1342177280", ",", 
   RowBox[{"-", "5368709120"}], ",", "21474836480", ",", 
   RowBox[{"-", "85899345920"}], ",", "343597383680", ",", 
   RowBox[{"-", "1374389534720"}]}], "}"}]], "Output",
 CellChangeTimes->{3.806862445434648*^9, 3.8068657293223395`*^9, 
  3.8068669062473464`*^9, 3.8068674759907312`*^9, 3.8068676125658503`*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"bb59af72-a97b-4da7-b5bf-5de0ed61f3d4"]
}, Open  ]],

Cell["2.3.2", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862153863971*^9, 
  3.806862154531187*^9}},ExpressionUUID->"ce7a4564-c893-438b-a474-\
3d698ab4ea48"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GraficaRRL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "n"}], ",", 
     SuperscriptBox["3", "n"]}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"npuntos", "\[Rule]", "20"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"RT", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "n"}], ",", 
     SuperscriptBox["3", "n"]}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", "20"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8068623782665157`*^9, 3.8068624067295704`*^9}, {
   3.806862547841481*^9, 3.806862553945888*^9}, 3.8068626189148474`*^9, {
   3.8068626584477987`*^9, 3.8068626695001135`*^9}, {3.8068669161131506`*^9, 
   3.8068669164287424`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"bd9d83af-8248-46b7-a366-c962e802a5d3"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
     AbsoluteThickness[1.6], 
     TagBox[{
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[{},
         VertexColors->None]}, 
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQAWImKIaAD/bYaThwgFB6Dqh8GOCA8B1SHFD4cCAA4S+Z
74DChwMRML/h2V0HZD4CSID5UdcVHJH5CCAD4jdsl05zROIjAQUQ3/HxlA2O
SHwkoATkP/B2+f3bEcFHBioODA1lVROsvZzgfBSg5sCgIMWZyzvbCc5HARoO
Co8cVkvlv3OC8VHltRy2bk532NLt5Azjo8rrOJy275wSEz7DGcZHlddz6Oor
kMiV/egM46PKGzhIXF+xRHmNpwuMjypv6FDWbZauU7rEBcZHlTdyWMsqVn7X
idEVxkeVN3aQtpKvkdof5wrjo8qbOFS5xV7RuLzHFcaHyQAA0ntF0A==
         "],
         VertexColors->None]}},
      Annotation[#, "Charting`Private`Tag$5852#1"]& ]}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
      AbsoluteThickness[1.6], {}, PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7FFpBgcIpQelOSC0QwqULwChl8yH8kXAdMOz
u1C+BJiOuq7gCOHLgPgN26XToHwFEN/x8ZQNUL4SkP/A2+X3byhfxYGhoaxq
grWXE4Sv5sCgIMWZyzsbytdwUHjksFoq/x2Ur+WwdXO6w5ZuJ2cIX8fhtH3n
lJjwGc4wf3T1FUjkyn6E8g0cJK6vWKK8xtMFwjd0KOs2S9cpXQLlGzmsZRUr
v+vE6ArhGztIW8nXSO2Pg/JNHKrcYq9oXN7jCgBNvj1M
       "]], {}},
     Annotation[#, "Charting`Private`Tag$5852#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05]},
  PlotRange->{{0, 20.}, {0, 8.920856435026601*^27}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.806862692006458*^9, 3.8068657504918118`*^9, 
  3.8068669177746086`*^9, 3.806867488766883*^9, 3.8068676166468315`*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"79ef3ea4-a058-44c8-a133-61a67172bc1c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "15", ",", "162", ",", "2025", ",", "30618", ",", "551853", ",", 
   "11591100", ",", "278192961", ",", "7511229630", ",", "225336947949", ",", 
   "7436119459464", ",", "267700301072145", ",", "10440311743407978", ",", 
   "438493093227918045", ",", "19732189195270660932", ",", 
   "947145081373034771457", ",", "48304399150024902484470", ",", 
   "2608437554101345121581869", ",", "148680940583776673092428000", ",", 
   "8920856435026600389032464401"}], "}"}]], "Output",
 CellChangeTimes->{3.806862692006458*^9, 3.8068657504918118`*^9, 
  3.8068669177746086`*^9, 3.806867488766883*^9, 3.8068676166508255`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"cb8996d4-c08b-4cb1-9f61-2fc9e61d2e5f"]
}, Open  ]],

Cell["2.3.3", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
   3.8073687473775463`*^9, 3.8073687479133277`*^9}, 3.807369810048415*^9, 
   3.807370306601328*^9},ExpressionUUID->"b790515f-6fef-45ed-8c7c-\
76baf2e83d2d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GraficaRRL", "[", 
  RowBox[{
   RowBox[{"{", 
    FractionBox[
     RowBox[{"4", "n"}], "3"], "}"}], ",", 
   RowBox[{"{", 
    FractionBox["5", "2"], "}"}], ",", 
   RowBox[{"npuntos", "\[Rule]", "20"}], ",", 
   RowBox[{"inicio", "\[Rule]", "2"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"RT", "[", 
  RowBox[{
   RowBox[{"{", 
    FractionBox[
     RowBox[{"4", "n"}], "3"], "}"}], ",", 
   RowBox[{"{", 
    FractionBox["5", "2"], "}"}], ",", "20", ",", 
   RowBox[{"inicio", "\[Rule]", "2"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8068623782665157`*^9, 3.8068624067295704`*^9}, {
   3.806862547841481*^9, 3.806862553945888*^9}, 3.8068626189148474`*^9, {
   3.8068626584477987`*^9, 3.8068626695001135`*^9}, {3.8068669161131506`*^9, 
   3.8068669164287424`*^9}, 3.8073698346393676`*^9, {3.8073698770061007`*^9, 
   3.807369981226448*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"bee3c35d-c0ea-444f-a37c-746dfa1805dd"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
     AbsoluteThickness[1.6], 
     TagBox[{
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[{},
         VertexColors->None]}, 
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQAWImKIYCBwjF4oDKhwEOKF/FAZUPAwIOq1eBgJcDjI8q
L+LQ99gCiMocYHxUeQmo/DIHGB9VXsbhYpxTNefbmw4wPqq8gsODl9f+bPAQ
dITxUeWVoPo9HWF8VHkVh4glPDZ3Z7U6wvio8moOy6Zxl389e9gRxkeV14DK
MzvB+KjyWg73e32mlZS4OsH4qPI6Djd/MUfdZe90gvFR5fUcJvxs2XDF87wT
jI8qb+CQsCxC4fFtEWcYH1Xe0CF2Wq3E9Z5YZxgfVd7I4ZhBXNBCzWXOMD6q
vLGD+8SubfO7PzrD+KjyJg7l7jYGXHa2LjA+qrypQ8c+k1ce0zpdYHyYDACN
QVhO
         "],
         VertexColors->None]}},
      Annotation[#, "Charting`Private`Tag$4059#1"]& ]}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
      AbsoluteThickness[1.6], {}, PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQUOEIoFSnNAaRUoLeCwehUIeEH5Ig59jy2AqAzK
l4Dyl0H5Mg4X45yqOd/ehPIVHB68vPZng4egI4SvBJX3dITZE7GEx+burFYo
X81h2TTu8q9nD0P5GlA+sxOEr+Vwv9dnWkmJK5Sv43DzF3PUXfZOKF/PYcLP
lg1XPM9D+QYOCcsiFB7fFnGG8A0dYqfVSlzviYXyjRyOGcQFLdRcBuUbO7hP
7No2v/sjlG/iUO5uY8BlZ+sC4Zs6dOwzeeUxrdMFAMiXUIQ=
       "]], {}},
     Annotation[#, "Charting`Private`Tag$4059#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05]},
  PlotRange->{{0, 21.}, {0, 1.5103928469088222`*^22}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8073699848552527`*^9, 3.807369998170603*^9}, 
   3.8073703152274*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"c6e16159-2ae6-4eaa-8973-ae7513fc3489"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "2"], ",", "10", ",", 
   FractionBox["160", "3"], ",", 
   FractionBox["3200", "9"], ",", 
   FractionBox["25600", "9"], ",", 
   FractionBox["716800", "27"], ",", 
   FractionBox["22937600", "81"], ",", 
   FractionBox["91750400", "27"], ",", 
   FractionBox["3670016000", "81"], ",", 
   FractionBox["161480704000", "243"], ",", 
   FractionBox["2583691264000", "243"], ",", 
   FractionBox["134351945728000", "729"], ",", 
   FractionBox["7523708960768000", "2187"], ",", 
   FractionBox["150474179215360000", "2187"], ",", 
   FractionBox["9630347469783040000", "6561"], ",", 
   FractionBox["654863627945246720000", "19683"], ",", 
   FractionBox["5238909023561973760000", "6561"], ",", 
   FractionBox["398157085790710005760000", "19683"], ",", 
   FractionBox["31852566863256800460800000", "59049"], ",", 
   FractionBox["891871872171190412902400000", "59049"]}], "}"}]], "Output",
 CellChangeTimes->{{3.8073699848552527`*^9, 3.807369998170603*^9}, 
   3.8073703152313943`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"e5943b4b-13ec-4d78-bd36-5677fb3dabdd"]
}, Open  ]],

Cell["2.3.4", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.8068621564766645`*^9, 3.8068621571756783`*^9}, {3.807370230483327*^9, 
  3.8073702311570363`*^9}},ExpressionUUID->"886dcfec-0dd1-4cd8-9c1a-\
0ddd78c47be2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GraficaRRL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"npuntos", "\[Rule]", "20"}], ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"RT", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", "20", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8068623782665157`*^9, 3.8068624067295704`*^9}, {
  3.806862792492244*^9, 3.806862804820577*^9}, {3.80686692802481*^9, 
  3.8068669283153744`*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"fef779e5-f831-4c33-906c-e29ba478143d"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
     AbsoluteThickness[1.6], 
     TagBox[{
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[{{{6., -69.}, {6., 0.}}, {{8., -1005.}, {8., 0.}}, {{
         10., -10581.}, {10., 0.}}, {{12., -101373.}, {12., 0.}}, {{
         14., -936933.}, {14., 0.}}, {{16., -8.530701*^6}, {16., 0.}}, {{
         18., -7.7169525*^7}, {18., 0.}}},
         VertexColors->None]}, 
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgBWImKEYFH+wxhFDEORxwqHNAlYfxYQAmroeuDgoE0MQF
0ORFIPwDoQ4ofDiQgfArmhxQ+HCgBOEf3+iAwocDNTD/Qf0jB2Q+AmiB+Xf4
RRyR+QgA9lfDdUM3RyQ+EjAE8QuETlQ4IvGRgDGIv0/k5GpHJD4YAACbqR1K

         "],
         VertexColors->None]}},
      Annotation[#, "Charting`Private`Tag$5882#1"]& ]}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
      AbsoluteThickness[1.6], {}, PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQjQo+2KPSHA5QCQdUPozWg9ICaOIiEPpAKJQvAaEd
Ag9A+DIQfkUTVF4BQmf0Q+WVIPzjG6HyKmC6YdURqLwamP+g/hFUXgNMX9j/
AyqvBebf4RdxhPB1wPxT03UOIrm74bqhG1TeAMRfkOiaAJU3BPELhE5UQOWN
QPwrvGmToPLGIP4+kZOrHQF55Ssx
       "]], {}},
     Annotation[#, "Charting`Private`Tag$5882#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05]},
  PlotRange->{{0, 19.}, {-7.7169525*^7, 2.33081439*^8}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8068628221359715`*^9, 3.8068657682892256`*^9, 
  3.8068669292612863`*^9, 3.8068674721401176`*^9, 3.806867504594614*^9, 
  3.8068676217522364`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"52d0c422-045d-44b2-acdf-9e444cc961b3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "3", ",", "15", ",", "3", ",", "87", ",", 
   RowBox[{"-", "69"}], ",", "591", ",", 
   RowBox[{"-", "1005"}], ",", "4551", ",", 
   RowBox[{"-", "10581"}], ",", "37887", ",", 
   RowBox[{"-", "101373"}], ",", "328695", ",", 
   RowBox[{"-", "936933"}], ",", "2909103", ",", 
   RowBox[{"-", "8530701"}], ",", "25985319", ",", 
   RowBox[{"-", "77169525"}], ",", "233081439"}], "}"}]], "Output",
 CellChangeTimes->{3.8068628221359715`*^9, 3.8068657682892256`*^9, 
  3.8068669292612863`*^9, 3.8068674721401176`*^9, 3.806867504594614*^9, 
  3.8068676217562304`*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"64caad0d-ef3c-40e0-8f6e-722306ac94d7"]
}, Open  ]],

Cell["2.3.5", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.8068621598655643`*^9, 3.8068621603123665`*^9}, {3.8073702357451577`*^9, 
  3.807370236308346*^9}},ExpressionUUID->"f0164ad2-39dd-411c-b107-\
537dc76bde50"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GraficaRRL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"npuntos", "\[Rule]", "20"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"RT", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", "20"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8068623782665157`*^9, 3.8068624067295704`*^9}, {
  3.8068628360153227`*^9, 3.8068628498391457`*^9}, {3.8068669390327888`*^9, 
  3.806866939340379*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"e5fd1038-b116-4165-95be-dfed84d83e0c"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
     AbsoluteThickness[1.6], 
     TagBox[{
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[{},
         VertexColors->None]}, 
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[CompressedData["
1:eJxt0L0OAUEUhuEJjVKxhUKxRERExF+LLxpKoVEpJBKdxgVsTSdxAWq9WvTu
QaV2CX7OnGO/jTeZTJ6ZyexmCov1ZJl2zgXvkfJDevb/zxZkyoCt6Xo2ec7x
ej5xTgu8y2BrOe8W2Jre2018RwvF0RBkq+g9BVsriS9zkC3/3/cVyFZFHG5A
tqriUQSyVRPPtiBbdfH4ALLVEPeOIFtN8eMEsuXffX8G2Wp/HQ2uiPtXR/Z3
N8T96QXeiyc2
         "],
         VertexColors->None]}},
      Annotation[#, "Charting`Private`Tag$5733#1"]& ]}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
      AbsoluteThickness[1.6], {}, PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7FFpBgcIxYFGC6DRMlBaBEqrQWkJKG2Eps4W
SitA6AZ3KF8JSgdDaRUIfSAO1dwHGVC+BoRWKIHytSC0RwOUrwOhI7qgfD0I
HTAVyjeA0HYLoXxDCP1sNaq7J22D8o3BdIPTISjfBMLvPusAAPiNHrI=
       "]], {}},
     Annotation[#, "Charting`Private`Tag$5733#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05]},
  PlotRange->{{0, 20.}, {0, 15127.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.80686286362679*^9, 3.8068657834177065`*^9, 
  3.806866940208388*^9, 
  3.806867523383579*^9},ExpressionUUID->"94d8f14b-3723-4932-8d07-\
3df1006dfc35"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "4", ",", "7", ",", "11", ",", "18", ",", "29", ",", 
   "47", ",", "76", ",", "123", ",", "199", ",", "322", ",", "521", ",", 
   "843", ",", "1364", ",", "2207", ",", "3571", ",", "5778", ",", "9349", 
   ",", "15127"}], "}"}]], "Output",
 CellChangeTimes->{3.80686286362679*^9, 3.8068657834177065`*^9, 
  3.806866940208388*^9, 3.8068675233875723`*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"2697d378-9fc8-483d-b721-2a5e11d12dee"]
}, Open  ]],

Cell["2.3.6", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862161794345*^9, 3.8068621622161922`*^9}, {3.807370239142979*^9, 
  3.8073702397058535`*^9}},ExpressionUUID->"cb507cf2-e4f6-4571-b356-\
d5653c2756ea"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"GraficaRRL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     SqrtBox["2"], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"-", "8"}], ",", 
     FractionBox["3", "2"]}], "}"}], ",", 
   RowBox[{"npuntos", "\[Rule]", "20"}], ",", 
   RowBox[{"inicio", "\[Rule]", "5"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RT", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      SqrtBox["2"], ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", 
      RowBox[{"-", "8"}], ",", 
      FractionBox["3", "2"]}], "}"}], ",", "20", ",", 
    RowBox[{"inicio", "\[Rule]", "5"}]}], "]"}], "//", "N"}]}], "Input",
 CellChangeTimes->{{3.8068623782665157`*^9, 3.8068624067295704`*^9}, {
  3.8068628824795065`*^9, 3.806862942514984*^9}, {3.8068669511771517`*^9, 
  3.8068669514623938`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"cac4de04-fcf3-486e-8708-433ec35ba267"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
     AbsoluteThickness[1.6], 
     TagBox[{
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgAmImKIYACQcIrXAAlQ8DSg72VpN+BnD4HYDxUeXVHCqj
TANEbIMOwPio8hoOmf/m2U+9E3oAxkeV13E4F2TWEGXddwDGR5U3cMjxC9U+
NzPtAIyPKm/osPbU3+OCnMsPwPio8sYOp32W1rl9O3UAxkeVN3PwuWWaNZ/l
wwEYH1XewsFDnHXCz10sB2F8mAwAXVAutg==
         "],
         VertexColors->None]}, 
       {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
        0.2], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgAmImKIYAEQcILeOAyocBmPgPe1Q+DCg4SCUdOLNB38wB
xkeVV3HI2ZafZr0nwgHGR5XXcmg5NmPvqve1DjA+qryew+Xf9/qd7k1ygPFR
5Y0c3rgcnxbCe9ABxkeVN3FYsmfvpiKPYw4wPqq8qcPRwITFL2+ccIDxUeXN
HVZOuTlJT5vREcaHyQAAJrUtMg==
         "],
         VertexColors->None]}},
      Annotation[#, "Charting`Private`Tag$5764#1"]& ]}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
      AbsoluteThickness[1.6], {}, PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEiDhBaBkpLQGmFA6jiP+yh4g5SSQfObNA3g4or
OdhbTfoZwOEHVa/ikLMtP816TwRUXs2hMso0QMQ2CCqv4ZD5b5791DuhUL6W
Q8uxGXtXva+FqtdxOBdk1hBl3QeV13O4/Ptev9O9SVB5A4ccv1DtczPToPKG
DmtP/T0uyLkcyjdyeONyfFoI70GoemOH0z5L69y+nYLKmzgs2bN3U5HHMai8
qcPRwITFL2+cgPLNHHxumWbNZ/kAVW/usHLKzUl62oyOEL6Fg4c464Sfu1gO
AgAZ9lHg
       "]], {}},
     Annotation[#, "Charting`Private`Tag$5764#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05]},
  PlotRange->{{0, 24.}, {-169823.1953222102, 140645.82170406476`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.806862968786372*^9, 3.8068630593545203`*^9, 
  3.806865813182367*^9, 3.8068669531186466`*^9, 
  3.806867543311193*^9},ExpressionUUID->"bd1662d0-4116-4c73-a16a-\
9f76d6a05a79"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.`", ",", 
   RowBox[{"-", "8.`"}], ",", "1.5`", ",", "22.18629150101524`", ",", 
   RowBox[{"-", "60.064971157455595`"}], ",", "98.94112549695427`", ",", 
   RowBox[{"-", "72.95436482630056`"}], ",", 
   RowBox[{"-", "87.44660940672624`"}], ",", "478.9791847198287`", ",", 
   RowBox[{"-", "967.4191898578663`"}], ",", "1207.5650019494249`", ",", 
   RowBox[{"-", "180.80641714726823`"}], ",", 
   RowBox[{"-", "2948.534728938094`"}], ",", "8730.660851391462`", ",", 
   RowBox[{"-", "13804.550739920136`"}], ",", "11408.896079747305`", ",", 
   "12721.825298347403`", ",", 
   RowBox[{"-", "65609.96343026421`"}], ",", "140645.82170406476`", ",", 
   RowBox[{"-", "169823.1953222102`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.806862968786372*^9, 3.8068630593545203`*^9, 
  3.806865813182367*^9, 3.8068669531186466`*^9, 3.806867543359129*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"3307ea05-d67c-431e-bf05-dcaf40f24df2"]
}, Open  ]],

Cell["2.3.7", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862173961006*^9, 3.8068621743610134`*^9}, {3.807370244186467*^9, 
  3.807370244836584*^9}},ExpressionUUID->"1ab4562a-46bf-40fa-ae6b-\
d45aceec51b8"],

Cell[TextData[{
 "Sea ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "n"], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      SubscriptBox["a", "n"], ")"}], "3"]}], TraditionalForm]],ExpressionUUID->
  "aab8f0b0-5553-4bd7-b376-c8a700bd7c2f"],
 ":"
}], "Text",
 CellChangeTimes->{{3.8068662263920116`*^9, 3.8068662733445144`*^9}, 
   3.806866974780843*^9, 
   3.806927515756071*^9},ExpressionUUID->"123618db-7c24-4ee3-bfc5-\
fa5399a41eaa"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RadicalBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["7", "2"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "1"}], "]"}], ")"}], "3"]}], "+", 
    RowBox[{"5", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "2"}], "]"}], ")"}], "3"]}]}], 
   "3"]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "2", "]"}], "=", 
   SqrtBox["2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "3", "]"}], "=", 
   RowBox[{"-", 
    FractionBox["2", "3"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"DiscretePlot", "[", 
  RowBox[{
   RowBox[{"a", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "20"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Surd", "[", 
   RowBox[{
    RowBox[{"RT", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["7", "2"]}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          SqrtBox["2"], ")"}], "3"], ",", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "/", "3"}], ")"}], "3"]}], "}"}], ",", "20", 
      ",", 
      RowBox[{"inicio", "\[Rule]", "3"}]}], "]"}], ",", "3"}], "]"}], "//", 
  "N"}]}], "Input",
 CellChangeTimes->{{3.806865850785774*^9, 3.806865852877527*^9}, {
  3.8068659430386925`*^9, 3.8068659539089084`*^9}, {3.806866033727209*^9, 
  3.8068661552827997`*^9}, {3.8068669622084475`*^9, 3.806866970742491*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"3b802063-413a-40db-a988-2c58755468f3"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     TagBox[{
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.012833333333333334`], AbsoluteThickness[1.6], Opacity[0.2], 
        LineBox[{{{3., -0.6666666666666666}, {3., 0}}},
         VertexColors->None]}, 
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.012833333333333334`], AbsoluteThickness[1.6], Opacity[0.2], 
        LineBox[{{{2., 1.4142135623730951`}, {2., 0}}, {{4., 
           2.475992740452475}, {4., 0}}, {{6., 6.4394850094165115`}, {
           6., 0}}, {{8., 17.7176595650741}, {8., 0}}, {{10., 
           48.92024422518308}, {10., 0}}, {{12., 135.1006595142388}, {
           12., 0}}, {{14., 373.10511481250524`}, {14., 0}}, {{16., 
           1030.3984848357795`}, {16., 0}}, {{18., 2845.6352735249784`}, {
           18., 0}}, {{20., 7858.7461505292595`}, {20., 0}}},
         VertexColors->None]}},
      Annotation[#, "Charting`Private`Tag$5791#1"]& ]}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6], {}, 
      PointBox[{{2., 1.4142135623730951`}, {3., -0.6666666666666666}, {4., 
       2.475992740452475}, {6., 6.4394850094165115`}, {8., 
       17.7176595650741}, {10., 48.92024422518308}, {12., 
       135.1006595142388}, {14., 373.10511481250524`}, {16., 
       1030.3984848357795`}, {18., 2845.6352735249784`}, {20., 
       7858.7461505292595`}}], {}},
     Annotation[#, "Charting`Private`Tag$5791#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2, 0},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05]},
  PlotRange->{{2, 20}, {-0.6666666666666666, 7858.7461505292595`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8068669906830187`*^9, 
  3.80686756505381*^9},ExpressionUUID->"56b699e6-0ed7-4639-b1f2-1abbe8948203"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.4142135623730951`", ",", 
   RowBox[{"-", "0.6666666666666666`"}], ",", "2.475992740452475`", ",", 
   RowBox[{"-", "3.7939095835159433`"}], ",", "6.4394850094165115`", ",", 
   RowBox[{"-", "10.649071242342826`"}], ",", "17.7176595650741`", ",", 
   RowBox[{"-", "29.435609260258538`"}], ",", "48.92024422518308`", ",", 
   RowBox[{"-", "81.29593801880208`"}], ",", "135.1006595142388`", ",", 
   RowBox[{"-", "224.51434739830376`"}], ",", "373.10511481250524`", ",", 
   RowBox[{"-", "620.0378386808987`"}], ",", "1030.3984848357795`", ",", 
   RowBox[{"-", "1712.3487565611194`"}], ",", "2845.6352735249784`", ",", 
   RowBox[{"-", "4728.966615156761`"}], ",", "7858.7461505292595`", ",", 
   RowBox[{"-", "13059.912678946774`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8068669906830187`*^9, 3.8068675651017447`*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"773499a1-7c1b-4ee6-8ccb-14bcd2fdcc55"]
}, Open  ]],

Cell["2.3.8", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
   3.806862265183646*^9, 3.806862273361394*^9}, {3.806867951320154*^9, 
   3.8068679515844584`*^9}, 3.8069291374120426`*^9, {3.8073702593054647`*^9, 
   3.8073702621141586`*^9}, 
   3.8073708973663797`*^9},ExpressionUUID->"00cd0483-8ece-4840-bbec-\
a7b2ca500dde"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "10", ",", "41", ",", "206", ",", "1237"}], 
    "}"}], ",", "a", ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{{3.8073782308025227`*^9, 3.8073782525674305`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"c83a17f9-2e65-4e86-8e08-e187dad3e435"],

Cell[BoxData["\<\"NaD\"\>"], "Output",
 CellChangeTimes->{{3.807378258484128*^9, 3.8073782607566366`*^9}},
 CellLabel->"Out[11]=",ExpressionUUID->"66e524dd-cf57-4fb4-aa4f-e3395caca46a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  SubscriptBox["a", "1"], "=", "1"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "2"], "=", 
  RowBox[{"3", "=", 
   RowBox[{
    RowBox[{"2", 
     SubscriptBox["a", "1"]}], "+", "1"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "3"], "=", 
  RowBox[{"10", "=", 
   RowBox[{
    RowBox[{"3", 
     SubscriptBox["a", "2"]}], "+", "1"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "4"], "=", 
  RowBox[{"41", "=", 
   RowBox[{
    RowBox[{"4", 
     SubscriptBox["a", "3"]}], "+", "1"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "5"], "=", 
  RowBox[{"206", "=", 
   RowBox[{
    RowBox[{"5", 
     SubscriptBox["a", "4"]}], "+", "1"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "6"], "=", 
  RowBox[{"1237", "=", 
   RowBox[{
    RowBox[{"6", 
     SubscriptBox["a", "5"]}], "+", 
    "1"}]}]}], "\[IndentingNewLine]", "\[VerticalEllipsis]", "\
\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "n"], "=", 
  RowBox[{
   RowBox[{"n", " ", 
    SubscriptBox["a", 
     RowBox[{"n", "-", "1"}]]}], "+", "1"}]}]}], "Text",
 CellChangeTimes->{{3.807346668121708*^9, 3.807346911378791*^9}, {
  3.807370857206031*^9, 3.807370864922664*^9}, {3.8073709412896585`*^9, 
  3.807371087470918*^9}, {3.80737112545376*^9, 
  3.8073711436094837`*^9}},ExpressionUUID->"2cc3ef38-1126-4af2-9be9-\
8b3d845e64af"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"n", " ", 
    RowBox[{"a", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}], "+", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"a", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8073706703024626`*^9, 3.807370701701445*^9}, {
  3.8073712041308517`*^9, 3.8073712366929345`*^9}, {3.807378414860527*^9, 
  3.8073784177870274`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"d9fd8211-a872-48f6-b7a1-65f4400d7939"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "10", ",", "41", ",", "206", ",", "1237"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.807371223730424*^9, 3.807371238493718*^9}, 
   3.8073782849420624`*^9, {3.807378426981642*^9, 3.8073784297907257`*^9}},
 CellLabel->"Out[33]=",ExpressionUUID->"5471c453-d90a-46bc-a4b5-fdad4ae8e0df"]
}, Open  ]],

Cell["2.3.9", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
   3.806862265183646*^9, 3.806862273361394*^9}, {3.806867951320154*^9, 
   3.8068679515844584`*^9}, 3.8069291374120426`*^9, {3.8073702593054647`*^9, 
   3.8073702699909573`*^9}, 
   3.807371605744196*^9},ExpressionUUID->"fc38376f-857f-427f-8c58-\
396e30b3e054"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "8"}], ",", "29", ",", 
     RowBox[{"-", 
      FractionBox["109", "2"]}], ",", 
     FractionBox["689", "4"], ",", 
     RowBox[{"-", 
      FractionBox["2869", "8"]}]}], "}"}], ",", "a", ",", "n"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8073716205362062`*^9, 3.8073716394063263`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"268caf60-d5db-4af6-ae59-6a209282152f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"5", " ", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}], "]"}]}], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], "\[Equal]", "5"}], ",", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], "\[Equal]", 
    RowBox[{"-", "8"}]}], ",", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    SuperscriptBox["2", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "n"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "16"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "5"}], ")"}], "n"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["2", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.807371640526665*^9, {3.8073782941363845`*^9, 3.807378296378551*^9}, 
   3.8073784328754597`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"f3056976-d8e9-4702-a02e-7b14d1bb35b9"]
}, Open  ]],

Cell["2.3.10", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
   3.806862265183646*^9, 3.806862273361394*^9}, {3.806867951320154*^9, 
   3.8068679515844584`*^9}, 3.8069291374120426`*^9, {3.8073702593054647`*^9, 
   3.807370280115019*^9}, 3.8073717644778357`*^9, {3.8073723292436953`*^9, 
   3.807372330054595*^9}},ExpressionUUID->"63ee84e4-187f-41e5-ac34-\
64d6a733baac"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], 
    SuperscriptBox["n", "2"]}], "-", 
   RowBox[{
    FractionBox["1", "2"], "n"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"a", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.807372356291378*^9, 3.807372368599186*^9}, {
  3.807377313910705*^9, 3.8073773145530663`*^9}, {3.8073777792578993`*^9, 
  3.8073777929388123`*^9}, {3.807378398591941*^9, 3.8073784019903097`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"7ff8deff-ca50-47eb-9fc2-f0b497d7e72c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "3", ",", "6", ",", "10", ",", "15"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8073723716265774`*^9, 3.8073767789053993`*^9, {3.8073773150325017`*^9, 
   3.807377325009112*^9}, 3.807377797928475*^9, 3.807378352643533*^9, 
   3.807378394361983*^9, 3.8073784416517515`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"2576ad7a-00a3-426d-8978-ae69aa3b899c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3", ",", "6", ",", "10", ",", "15"}], "}"}], 
   ",", "a", ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{{3.8073767614455585`*^9, 3.8073767881479936`*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"0cda9823-2d52-44bc-acf0-68309438ea04"],

Cell[BoxData["\<\"NaD\"\>"], "Output",
 CellChangeTimes->{{3.8073767888454504`*^9, 3.807376791509925*^9}, 
   3.807377806207309*^9, 3.80737844723182*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"a9b46d7c-258b-4903-93eb-becae798e99a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  SubscriptBox["a", "1"], "=", "0"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "2"], "=", 
  RowBox[{"1", "=", 
   RowBox[{
    SubscriptBox["a", "1"], "+", 
    RowBox[{"(", 
     RowBox[{"2", "-", "1"}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "3"], "=", 
  RowBox[{"3", "=", 
   RowBox[{
    SubscriptBox["a", "2"], "+", 
    RowBox[{"(", 
     RowBox[{"3", "-", "1"}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "4"], "=", 
  RowBox[{"6", "=", 
   RowBox[{
    SubscriptBox["a", "3"], "+", 
    RowBox[{"(", 
     RowBox[{"4", "-", "1"}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "5"], "=", 
  RowBox[{"10", "=", 
   RowBox[{
    SubscriptBox["a", "4"], "+", 
    RowBox[{"(", 
     RowBox[{"5", "-", "1"}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "6"], "=", 
  RowBox[{"15", "=", 
   RowBox[{
    SubscriptBox["a", "5"], "+", 
    RowBox[{"(", 
     RowBox[{"6", "-", "1"}], 
     ")"}]}]}]}], "\[IndentingNewLine]", "\[VerticalEllipsis]", "\
\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["a", "n"], "=", 
  RowBox[{
   SubscriptBox["a", 
    RowBox[{"n", "-", "1"}]], "+", "n", "-", "1"}]}]}], "Text",
 CellChangeTimes->{{3.807346668121708*^9, 3.807346911378791*^9}, {
  3.807370857206031*^9, 3.807370864922664*^9}, {3.8073709412896585`*^9, 
  3.807371087470918*^9}, {3.80737112545376*^9, 3.8073711436094837`*^9}, {
  3.807376812517707*^9, 3.807376815893588*^9}, {3.807376874324165*^9, 
  3.8073768889480195`*^9}, {3.8073769195553913`*^9, 3.807376930535542*^9}, {
  3.8073771567777*^9, 3.807377157225143*^9}, {3.8073771952986183`*^9, 
  3.8073772900497303`*^9}, {3.807377814602648*^9, 
  3.8073778898859625`*^9}},ExpressionUUID->"f8384a4a-3d23-47a6-89d7-\
3dd5e9cc3fc9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"n", "-", "1"}], "]"}], "+", "n", "-", 
   "1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"a", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.807372356291378*^9, 3.807372368599186*^9}, {
  3.807376960912202*^9, 3.807377009263955*^9}, {3.807377082188801*^9, 
  3.8073771037529173`*^9}, {3.807377161330449*^9, 3.8073771617780285`*^9}, {
  3.8073779278785334`*^9, 3.8073779289710293`*^9}, {3.80737849539116*^9, 
  3.807378500543595*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"0437ad7b-28b3-4699-bf49-a10a17332296"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "3", ",", "6", ",", "10", ",", "15"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8073769802071934`*^9, 3.8073770101473045`*^9}, {
   3.8073770880876303`*^9, 3.807377104108156*^9}, 3.8073771621992197`*^9, 
   3.8073779338294263`*^9, 3.807378563791875*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"ab5bb6a1-e2db-4aab-8b03-23ecc7de95f9"]
}, Open  ]],

Cell["2.3.11", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
   3.806862265183646*^9, 3.806862273361394*^9}, {3.806867951320154*^9, 
   3.8068679515844584`*^9}, 3.8069291374120426`*^9, {3.8073702593054647`*^9, 
   3.807370280115019*^9}, 3.8073717644778357`*^9, {3.8073723328884697`*^9, 
   3.8073723335196085`*^9}},ExpressionUUID->"3d899587-90a6-4a11-beb6-\
83ba730ed8eb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["3", 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"(", 
    RowBox[{"12", "-", "n"}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"a", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.807371781796749*^9, 3.8073718332687025`*^9}, {
   3.8073721925380297`*^9, 3.8073721926636057`*^9}, 3.8073722548324547`*^9, {
   3.8073786055060606`*^9, 3.8073786082078886`*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"b9907e57-8f21-4b7a-a429-f996489516af"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "99", ",", "270", ",", "729", ",", "1944", ",", "5103", ",", "13122"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.807371837181881*^9, 3.807372193779744*^9, 3.8073722557855997`*^9, {
   3.807378608909421*^9, 3.807378611407634*^9}},
 CellLabel->"Out[53]=",ExpressionUUID->"8cb4d9ac-6810-4c81-b254-4192f259f14c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "99", ",", "270", ",", "729", ",", "1944", ",", "5103", ",", "13122"}], 
    "}"}], ",", "a", ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{{3.8073721020172234`*^9, 3.807372121096219*^9}, {
   3.807372174601161*^9, 3.8073722009289207`*^9}, 3.8073722647840395`*^9, 
   3.807378619367595*^9},
 CellLabel->"In[55]:=",ExpressionUUID->"4367577f-9239-4ba7-a53c-5af9f1381d2a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9"}], " ", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}], "]"}]}], "+", 
     RowBox[{"6", " ", 
      RowBox[{"a", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], "\[Equal]", "99"}], ",", 
   RowBox[{
    RowBox[{"a", "[", "2", "]"}], "\[Equal]", "270"}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["3", 
      RowBox[{"1", "+", "n"}]]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "12"}], "+", "n"}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.807372121946967*^9, {3.807372175886035*^9, 3.8073722657268085`*^9}, {
   3.8073786207784257`*^9, 3.8073786225247817`*^9}},
 CellLabel->"Out[55]=",ExpressionUUID->"71a3db34-4b79-42e4-a4ac-2d31cd774416"]
}, Open  ]],

Cell["2.3.12", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
   3.806862265183646*^9, 3.806862273361394*^9}, {3.806867951320154*^9, 
   3.8068679515844584`*^9}, 3.8069291374120426`*^9, {3.8073702732318373`*^9, 
   3.8073702885099154`*^9}, {3.8073779800873795`*^9, 
   3.8073779806088376`*^9}},ExpressionUUID->"c0f99cd6-fd50-4fa4-bd75-\
10dd544d384e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.806868040864442*^9, 3.806868090850708*^9}, {
  3.8069291621845655`*^9, 3.8069291634208984`*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"9cebd866-4b74-4572-b907-0f95740dcb54"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Por el m\[EAcute]todo iterativo:\"\>"], "Print",
 CellChangeTimes->{3.806929166286606*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"d8011719-29c4-4688-9f17-5ae78ecaf8f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "1"}], "+", 
   TemplateBox[{"2", "1"},
    "Superscript"], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2", "2"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -1 + $CellContext`n, ": ", 1 + 
   Superscript[2, 1] + $CellContext`a[-2 + $CellContext`n] Superscript[2, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069291662895966`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"060fc5e9-e1bd-40c8-83d9-c075fd5b73e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "1"}], "+", 
   TemplateBox[{"2", "1"},
    "Superscript"], "+", 
   TemplateBox[{"2", "2"},
    "Superscript"], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2", "3"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -2 + $CellContext`n, ": ", 1 + Superscript[2, 1] + 
   Superscript[2, 2] + $CellContext`a[-3 + $CellContext`n] Superscript[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.806929166292589*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"8e3c4181-030a-4c8f-8380-c5a12f0ca7a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "1"}], "+", 
   TemplateBox[{"2", "1"},
    "Superscript"], "+", 
   TemplateBox[{"2", "2"},
    "Superscript"], "+", 
   TemplateBox[{"2", "3"},
    "Superscript"], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "4"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2", "4"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -3 + $CellContext`n, ": ", 1 + Superscript[2, 1] + 
   Superscript[2, 2] + 
   Superscript[2, 3] + $CellContext`a[-4 + $CellContext`n] Superscript[2, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069291662936096`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[58]:=",ExpressionUUID->"108d1ef2-5215-4ba9-9dcf-460eeea6f524"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    SuperscriptBox["2", "j"], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", 
      RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8069294800489893`*^9, 3.8069295102921877`*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"c4aa43a7-a8de-4332-867f-c718a9357ecd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["2", "n"]}]], "Output",
 CellChangeTimes->{3.8069295116953716`*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"b089738a-12a9-4b9b-9132-f39a65ffafaf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{{3.806868028636693*^9, 3.8068680319528856`*^9}, {
  3.806868104216199*^9, 3.806868115443244*^9}, {3.80692917361726*^9, 
  3.806929181643859*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"6a460126-5614-4dbf-b592-d7ee0d485701"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["2", "n"]}]], "Output",
 CellChangeTimes->{3.806929182510042*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"d5f14fa4-efdb-46bc-b237-19298bd7e972"]
}, Open  ]],

Cell["2.3.13", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862265744477*^9}, {3.8069291394200525`*^9, 
  3.8069291398987694`*^9}, {3.8073703401235075`*^9, 3.8073703415195017`*^9}, {
  3.8073779855584307`*^9, 
  3.807377986027817*^9}},ExpressionUUID->"696cf0db-5e5c-4479-91ed-\
4a194c5bd34c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoI", "[", 
  RowBox[{
   RowBox[{"{", 
    SuperscriptBox["3", "n"], "}"}], ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.806868040864442*^9, 3.806868090850708*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"018471a3-94be-4144-a81b-b2199c6295b6"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Por el m\[EAcute]todo iterativo:\"\>"], "Print",
 CellChangeTimes->{3.806868091604062*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"b8dc7a97-9723-4cb2-aafc-94bf800bd1ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a", "[", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     TemplateBox[{"3", "1"},
      "Superscript"], ")"}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "n"}]}]]}],
  SequenceForm[
  "n \[Rule] ", -1 + $CellContext`n, 
   ": ", $CellContext`a[-2 + $CellContext`n] 
   Superscript[3, 1]^(-1 + 2 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806868091628621*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"d422f715-295b-4b44-a4c1-e05e45b68edc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a", "[", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "n"}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     TemplateBox[{"3", "1"},
      "Superscript"], ")"}], 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     RowBox[{"3", " ", "n"}]}]]}],
  SequenceForm[
  "n \[Rule] ", -2 + $CellContext`n, 
   ": ", $CellContext`a[-3 + $CellContext`n] 
   Superscript[3, 1]^(-3 + 3 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806868091632927*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"f5b89c8d-5b32-4ff5-a69d-6d08ccaa90c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a", "[", 
    RowBox[{
     RowBox[{"-", "4"}], "+", "n"}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     TemplateBox[{"3", "1"},
      "Superscript"], ")"}], 
    RowBox[{
     RowBox[{"-", "6"}], "+", 
     RowBox[{"4", " ", "n"}]}]]}],
  SequenceForm[
  "n \[Rule] ", -3 + $CellContext`n, 
   ": ", $CellContext`a[-4 + $CellContext`n] 
   Superscript[3, 1]^(-6 + 4 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.80686809163602*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[63]:=",ExpressionUUID->"cfc80370-9e56-4c66-9e32-3fcb95715027"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{"j", ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8069299945737524`*^9, 3.8069300103969326`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"d946565a-067f-4711-a6c6-8f3478ba2ecc"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}]}]], "Output",
 CellChangeTimes->{3.8069300123094497`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"1f1ea4e0-deb0-44c6-9a63-aa3246993635"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    SuperscriptBox["3", "n"], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", "n", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806868028636693*^9, 3.8068680319528856`*^9}, {
  3.806868104216199*^9, 3.806868115443244*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"301b58f2-2eab-47a3-8e4f-e8cbe1c24bef"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["3", 
   RowBox[{
    FractionBox["n", "2"], "+", 
    FractionBox[
     SuperscriptBox["n", "2"], "2"]}]]}]], "Output",
 CellChangeTimes->{3.806868116408676*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"a3e00d20-606c-4144-a30b-5528129012f0"]
}, Open  ]],

Cell["2.3.14", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.8069296266615353`*^9, 
  3.80692962718867*^9}, {3.807370346693234*^9, 3.8073703476381807`*^9}, {
  3.807377988907711*^9, 
  3.8073779895388746`*^9}},ExpressionUUID->"1f76612d-56e6-465a-bfbf-\
0cdb899afd30"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", "n"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.806868040864442*^9, 3.806868090850708*^9}, {
  3.806868228187187*^9, 3.8068682287985477`*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"9f5723c7-2c3d-4947-bd5b-5066c1bc3a42"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Por el m\[EAcute]todo iterativo:\"\>"], "Print",
 CellChangeTimes->{3.8068682353236427`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"c338901c-e221-4e65-8828-9dda7d200d68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
   RowBox[{"a", "[", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], "]"}], " ", 
   TemplateBox[{"2", "2"},
    "Superscript"]}],
  SequenceForm[
  "n \[Rule] ", -1 + $CellContext`n, 
   ": ", (-1 + $CellContext`n) $CellContext`n $CellContext`a[-2 + \
$CellContext`n] Superscript[2, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8068682353276377`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"a21018ef-9251-4b2f-832e-386dbca49322"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
   RowBox[{"a", "[", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "n"}], "]"}], " ", 
   TemplateBox[{"2", "3"},
    "Superscript"]}],
  SequenceForm[
  "n \[Rule] ", -2 + $CellContext`n, 
   ": ", (-2 + $CellContext`n) (-1 + $CellContext`n) $CellContext`n \
$CellContext`a[-3 + $CellContext`n] Superscript[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.806868235331645*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"7a4b3e14-b086-411e-9cf8-e1e7bcd97595"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
   RowBox[{"a", "[", 
    RowBox[{
     RowBox[{"-", "4"}], "+", "n"}], "]"}], " ", 
   TemplateBox[{"2", "4"},
    "Superscript"]}],
  SequenceForm[
  "n \[Rule] ", -3 + $CellContext`n, 
   ": ", (-3 + $CellContext`n) (-2 + $CellContext`n) (-1 + $CellContext`n) \
$CellContext`n $CellContext`a[-4 + $CellContext`n] Superscript[2, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.806868235331645*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[65]:=",ExpressionUUID->"f1fcb0c9-2738-4eb1-a9e9-acb06d0e62a6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", "n"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{{3.806868028636693*^9, 3.8068680319528856`*^9}, {
   3.806868104216199*^9, 3.806868115443244*^9}, {3.8068682401949806`*^9, 
   3.806868246073699*^9}, 3.8068683889919243`*^9},
 CellLabel->"In[66]:=",ExpressionUUID->"b2b57d3b-82dc-4cdb-974e-2279832a8433"],

Cell[BoxData[
 RowBox[{"3", " ", 
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]], " ", 
  RowBox[{"Pochhammer", "[", 
   RowBox[{"1", ",", "n"}], "]"}]}]], "Output",
 CellChangeTimes->{3.80686824797708*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"70cece4c-cae9-4f45-9088-c769d9128e04"]
}, Open  ]],

Cell["2.3.15", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.8068679325941286`*^9, 
  3.8068679331451216`*^9}, {3.806929630579893*^9, 3.806929631315961*^9}, {
  3.807370351553686*^9, 3.8073703526540985`*^9}, {3.8073779923517723`*^9, 
  3.8073779927994413`*^9}},ExpressionUUID->"c5fa14bc-cb31-4af4-93e5-\
e8c4befcb806"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MetodoI", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", "+", 
      RowBox[{"2", "n"}], "-", 
      SqrtBox["2"]}], "}"}], ",", "3"}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "No", " ", "corre", " ", "pues", " ", "involucra", " ", "valores", " ", 
    "no", " ", "enteros"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.806868040864442*^9, 3.806868090850708*^9}, {
  3.806868228187187*^9, 3.8068682287985477`*^9}, {3.80686844215336*^9, 
  3.8068684678142595`*^9}},ExpressionUUID->"c8770fde-5eec-4fd6-a1d0-\
97f3b331fc6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["5", 
     RowBox[{"n", "-", "5"}]]}], "+", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["5", 
       RowBox[{"n", "-", "j"}]], "2", "j"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "6", ",", "n"}], "}"}]}], "]"}], "-", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      SuperscriptBox["5", 
       RowBox[{"n", "-", "j"}]], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "6", ",", "n"}], "}"}]}], "]"}], 
    SqrtBox["2"]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806868836945591*^9, 3.806868963973426*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"acf5b4ad-8e94-43d8-b190-1078709820cd"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "5"}], "+", 
    RowBox[{"2", " ", 
     SqrtBox["2"]}], "+", 
    RowBox[{"41", " ", 
     SuperscriptBox["5", 
      RowBox[{
       RowBox[{"-", "5"}], "+", "n"}]]}], "-", 
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["5", 
      RowBox[{
       RowBox[{"-", "5"}], "+", "n"}]]}], "-", 
    RowBox[{"4", " ", "n"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.8068689683946095`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"3a2320b3-10b4-4d1c-8f00-f0ef79f2f184"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{
      RowBox[{"2", "n"}], "-", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", "n", ",", 
   RowBox[{"inicio", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806868028636693*^9, 3.8068680319528856`*^9}, {
   3.806868104216199*^9, 3.806868115443244*^9}, {3.8068682401949806`*^9, 
   3.806868246073699*^9}, 3.8068683889919243`*^9, {3.80686847909908*^9, 
   3.8068684938304863`*^9}, {3.8068691206984615`*^9, 3.8068691210631504`*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"f509f8f4-ee1f-4f69-8929-d347f9cc839e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "15625"}], "+", 
   RowBox[{"6250", " ", 
    SqrtBox["2"]}], "+", 
   RowBox[{"41", " ", 
    SuperscriptBox["5", "n"]}], "-", 
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    SuperscriptBox["5", "n"]}], "-", 
   RowBox[{"12500", " ", "n"}]}], "25000"]], "Output",
 CellChangeTimes->{
  3.8068684950986905`*^9, {3.8068691219292545`*^9, 3.8068691462710705`*^9}},
 CellLabel->"Out[73]=",ExpressionUUID->"46a50f20-50ba-447e-8ff8-c67c0f983e0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      FractionBox["1", "8"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}], "+", 
        RowBox[{"41", " ", 
         SuperscriptBox["5", 
          RowBox[{
           RowBox[{"-", "5"}], "+", "n"}]]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["2"], " ", 
         SuperscriptBox["5", 
          RowBox[{
           RowBox[{"-", "5"}], "+", "n"}]]}], "-", 
        RowBox[{"4", " ", "n"}]}], ")"}]}], "]"}], "\[Equal]", 
    RowBox[{"Simplify", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "15625"}], "+", 
       RowBox[{"6250", " ", 
        SqrtBox["2"]}], "+", 
       RowBox[{"41", " ", 
        SuperscriptBox["5", "n"]}], "-", 
       RowBox[{"2", " ", 
        SqrtBox["2"], " ", 
        SuperscriptBox["5", "n"]}], "-", 
       RowBox[{"12500", " ", "n"}]}], "25000"], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8068689836553144`*^9, 3.806869038879002*^9}, {
  3.8068691570436697`*^9, 3.806869164672792*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"f7552302-af79-487e-ac8a-9d47c5424038"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8068690169600925`*^9, 3.806869039753516*^9}, {
  3.806869158166173*^9, 3.806869165232744*^9}},
 CellLabel->"Out[75]=",ExpressionUUID->"d0c73a9f-315d-42b0-9282-9f30a822737a"]
}, Open  ]],

Cell["2.3.16", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867935170189*^9, 
  3.8068679353858957`*^9}, {3.8069296371551557`*^9, 3.8069296376349554`*^9}, {
  3.8073703583954225`*^9, 3.8073703594322495`*^9}, {3.807377997368264*^9, 
  3.8073779979308405`*^9}},ExpressionUUID->"d4148d52-45cc-48c5-aa8e-\
371407654588"],

Cell["No se puede corroborar la respuesta con el comando RR.", "Text",
 CellChangeTimes->{{3.8068694773869658`*^9, 
  3.8068694968636417`*^9}},ExpressionUUID->"b26a7c18-96b5-467d-b26a-\
be674e08ef2b"],

Cell["2.3.17", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.8068679372571287`*^9, 
  3.8068679373968945`*^9}, {3.80692964191702*^9, 3.8069296424376116`*^9}, {
  3.807370363658476*^9, 3.8073703642924504`*^9}, {3.8073780017796683`*^9, 
  3.807378002318946*^9}},ExpressionUUID->"cbee5024-e08f-4e78-889d-\
31f61925d50d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "2"], "-", 
     RowBox[{"7", "t"}], "+", "1"}], "\[Equal]", "0"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.806921402285298*^9, 3.8069214182650003`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"b6ac4107-0711-483f-8ffb-385989019ac3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"7", "-", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"7", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8069214189988136`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"4f8d35ea-afc6-4585-9e13-bbd0a66e6df0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"b1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"7", "-", 
             RowBox[{"3", " ", 
              SqrtBox["5"]}]}], ")"}]}], ")"}], "0"]}], "+", 
       RowBox[{"b2", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"7", "+", 
             RowBox[{"3", " ", 
              SqrtBox["5"]}]}], ")"}]}], ")"}], "0"]}]}], "\[Equal]", "1"}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"7", "-", 
             RowBox[{"3", " ", 
              SqrtBox["5"]}]}], ")"}]}], ")"}], "1"]}], "+", 
       RowBox[{"b2", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"7", "+", 
             RowBox[{"3", " ", 
              SqrtBox["5"]}]}], ")"}]}], ")"}], "1"]}]}], "\[Equal]", "5"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
  3.806921525064637*^9, 3.8069215544313593`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"24eaeda8-54dd-415d-bb67-8fe9e0c26fad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", 
     RowBox[{
      FractionBox["1", "10"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "-", 
        SqrtBox["5"]}], ")"}]}]}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{
      FractionBox["1", "10"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        SqrtBox["5"]}], ")"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.806921555302946*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"2ed87b03-a377-4210-a509-d7d696f6fe3d"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "="}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5c1464cc-81fc-4031-902e-b2ad9364d665"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["1", "10"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "-", 
      SqrtBox["5"]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"7", "-", 
         RowBox[{"3", " ", 
          SqrtBox["5"]}]}], ")"}]}], ")"}], "n"]}], "+", 
   RowBox[{
    FractionBox["1", "10"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      SqrtBox["5"]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", 
         RowBox[{"3", " ", 
          SqrtBox["5"]}]}], ")"}]}], ")"}], "n"]}]}]],
  CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
   3.806921525064637*^9, 3.8069215544313593`*^9}},ExpressionUUID->
  "44bc7d2f-f0f5-4f87-8ec9-71e638c5094a"]
}], "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867935170189*^9, 
  3.8068679353858957`*^9}, {3.806921576295984*^9, 
  3.806921612315504*^9}},ExpressionUUID->"8813a517-db81-400e-9fa8-\
f9f8799b573a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", "n", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", "n", ",", "b", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.806921321194724*^9, 3.806921390841611*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"1b4b637f-de0d-449f-af69-b126953362dc"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "10"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["7", "2"], "-", 
        FractionBox[
         RowBox[{"3", " ", 
          SqrtBox["5"]}], "2"]}], ")"}], "n"]}], "-", 
    RowBox[{
     SqrtBox["5"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["7", "2"], "-", 
        FractionBox[
         RowBox[{"3", " ", 
          SqrtBox["5"]}], "2"]}], ")"}], "n"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["7", "2"], "+", 
        FractionBox[
         RowBox[{"3", " ", 
          SqrtBox["5"]}], "2"]}], ")"}], "n"]}], "+", 
    RowBox[{
     SqrtBox["5"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["7", "2"], "+", 
        FractionBox[
         RowBox[{"3", " ", 
          SqrtBox["5"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.8069213480412393`*^9, 3.8069213917072725`*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"94a63a26-2a75-461d-b8b6-1dba812976b6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "-", 
    RowBox[{"7", " ", "n"}], "+", 
    SuperscriptBox["n", "2"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", 1 - 
   7 $CellContext`n + $CellContext`n^2, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069213917112637`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"2ea7e9be-158a-459f-8438-515a6d562788"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"7", "-", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"7", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}], ")"}]}]}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {
   Rational[1, 2] (7 - 3 5^Rational[1, 2]), 
    Rational[1, 2] (7 + 3 5^Rational[1, 2])}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069213917511573`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"e96f86fb-2e12-4335-ae35-8ea60cbe6e68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"7", "-", 
          RowBox[{"3", " ", 
           SqrtBox["5"]}]}], ")"}]}], ")"}], "n"], " ", 
     SubscriptBox["b", "1"]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", 
          RowBox[{"3", " ", 
           SqrtBox["5"]}]}], ")"}]}], ")"}], "n"], " ", 
     SubscriptBox["b", "2"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", (Rational[1, 2] (7 - 3 5^Rational[1, 2]))^$CellContext`n 
    Subscript[$CellContext`b, 1] + (
      Rational[1, 2] (7 + 3 5^Rational[1, 2]))^$CellContext`n 
    Subscript[$CellContext`b, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.806921391765143*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"afefdfda-db94-4dfb-8ca1-8373ca3055ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       SubscriptBox["b", "2"]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SubscriptBox["b", "1"]}], "-", 
         RowBox[{"3", " ", 
          SqrtBox["5"], " ", 
          SubscriptBox["b", "1"]}], "+", 
         RowBox[{"7", " ", 
          SubscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["5"], " ", 
          SubscriptBox["b", "2"]}]}], ")"}]}], "\[Equal]", "5"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {
   Subscript[$CellContext`b, 1] + Subscript[$CellContext`b, 2] == 1, 
    Rational[1, 2] (7 Subscript[$CellContext`b, 1] - 3 5^Rational[1, 2] 
      Subscript[$CellContext`b, 1] + 7 Subscript[$CellContext`b, 2] + 
      3 5^Rational[1, 2] Subscript[$CellContext`b, 2]) == 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069213917671137`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"4fbfef66-464d-4afe-9321-4d599f24b67e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "10"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}], ")"}]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "10"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}]}]}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> Rational[1, 10] (5 - 5^Rational[1, 2]), 
    Subscript[$CellContext`b, 2] -> Rational[1, 10] (5 + 5^Rational[1, 2])}],
  Editable->False]], "Print",
 CellChangeTimes->{3.806921391769109*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"b98f16cc-569d-4f20-8650-e9c7b1c00dec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "5"]}], " ", 
    SuperscriptBox["2", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "n"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"7", "-", 
          RowBox[{"3", " ", 
           SqrtBox["5"]}]}], ")"}], "n"]}], "+", 
      RowBox[{
       SqrtBox["5"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"7", "-", 
          RowBox[{"3", " ", 
           SqrtBox["5"]}]}], ")"}], "n"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"7", "+", 
          RowBox[{"3", " ", 
           SqrtBox["5"]}]}], ")"}], "n"]}], "-", 
      RowBox[{
       SqrtBox["5"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"7", "+", 
          RowBox[{"3", " ", 
           SqrtBox["5"]}]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[-1, 5] 
   2^(-1 - $CellContext`n) ((-5) (7 - 3 5^Rational[1, 2])^$CellContext`n + 
    5^Rational[1, 2] (7 - 3 5^Rational[1, 2])^$CellContext`n - 
    5 (7 + 3 5^Rational[1, 2])^$CellContext`n - 
    5^Rational[1, 2] (7 + 3 5^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.80692139180202*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"4b10e360-5c99-40da-adc3-df289acf8f52"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "10"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"3", " ", 
             SqrtBox["5"]}]}], ")"}]}], ")"}], "n"]}], "+", 
      RowBox[{
       FractionBox["1", "10"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"7", "+", 
            RowBox[{"3", " ", 
             SqrtBox["5"]}]}], ")"}]}], ")"}], "n"]}]}], "]"}], "\[Equal]", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      FractionBox["1", "10"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["7", "2"], "-", 
            FractionBox[
             RowBox[{"3", " ", 
              SqrtBox["5"]}], "2"]}], ")"}], "n"]}], "-", 
        RowBox[{
         SqrtBox["5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["7", "2"], "-", 
            FractionBox[
             RowBox[{"3", " ", 
              SqrtBox["5"]}], "2"]}], ")"}], "n"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["7", "2"], "+", 
            FractionBox[
             RowBox[{"3", " ", 
              SqrtBox["5"]}], "2"]}], ")"}], "n"]}], "+", 
        RowBox[{
         SqrtBox["5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["7", "2"], "+", 
            FractionBox[
             RowBox[{"3", " ", 
              SqrtBox["5"]}], "2"]}], ")"}], "n"]}]}], ")"}]}], "]"}], 
    "\[Equal]", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "5"]}], " ", 
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "n"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"3", " ", 
             SqrtBox["5"]}]}], ")"}], "n"]}], "+", 
        RowBox[{
         SqrtBox["5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"3", " ", 
             SqrtBox["5"]}]}], ")"}], "n"]}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"7", "+", 
            RowBox[{"3", " ", 
             SqrtBox["5"]}]}], ")"}], "n"]}], "-", 
        RowBox[{
         SqrtBox["5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"7", "+", 
            RowBox[{"3", " ", 
             SqrtBox["5"]}]}], ")"}], "n"]}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069216364160323`*^9, 3.8069217091358523`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"1f8c62fd-437f-4cc7-9a62-4422247e49bb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.806921672784947*^9, 3.8069217104146757`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"278a4ada-fc61-4598-a9a1-33033c39968c"]
}, Open  ]],

Cell["2.3.18", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867939640376*^9, 
  3.806867939819955*^9}, {3.8069220260517664`*^9, 3.8069220262083373`*^9}, {
  3.806925925222068*^9, 3.8069259253976054`*^9}, {3.8069296539789248`*^9, 
  3.806929654427262*^9}, {3.807370374819584*^9, 3.8073703753166866`*^9}, {
  3.8073780105742702`*^9, 
  3.807378011073023*^9}},ExpressionUUID->"9a08500c-2376-4575-8490-\
a3283bc13068"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "2"], "-", 
     RowBox[{
      RowBox[{"4", "/", "5"}], "t"}], "+", "1"}], "\[Equal]", "0"}], ",", 
   "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.806921402285298*^9, 3.8069214182650003`*^9}, {
  3.8069220381717467`*^9, 3.806922038777123*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"be1870b3-3169-4c80-98a0-b56dbf922d3c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{
      FractionBox["1", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["21"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{
      FractionBox["1", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["21"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8069220520857477`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"967f2d9a-a74c-4dd4-809d-20e20ab7821d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"b1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "5"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["21"]}]}], ")"}]}], ")"}], "2"]}], "+", 
       RowBox[{"b2", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "5"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["21"]}]}], ")"}]}], ")"}], "2"]}]}], "\[Equal]", "2"}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "5"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["21"]}]}], ")"}]}], ")"}], "3"]}], "+", 
       RowBox[{"b2", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "5"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["21"]}]}], ")"}]}], ")"}], "3"]}]}], "\[Equal]", 
      "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
  3.806921525064637*^9, 3.8069215544313593`*^9}, {3.8069220857102385`*^9, 
  3.8069221182406273`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"930ed21e-b24d-41c3-817a-58844fa5b623"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "798"}], "+", 
       RowBox[{"151", " ", "\[ImaginaryI]", " ", 
        SqrtBox["21"]}]}], "1050"]}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"25", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"42", " ", "\[ImaginaryI]"}], "+", 
          SqrtBox["21"]}], ")"}]}], 
       RowBox[{"42", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"17", " ", "\[ImaginaryI]"}], "+", 
          RowBox[{"4", " ", 
           SqrtBox["21"]}]}], ")"}]}]]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8069221339889784`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"bd20e891-2660-46c8-b10a-b29162dbeb04"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "="}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e464e6ca-2d40-4f75-8674-9ab366b4a70a"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"-", "798"}], "+", 
      RowBox[{"151", " ", "\[ImaginaryI]", " ", 
       SqrtBox["21"]}]}], "1050"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "5"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["21"]}]}], ")"}]}], ")"}], "n"]}], "-", 
   RowBox[{
    FractionBox[
     RowBox[{"25", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"42", " ", "\[ImaginaryI]"}], "+", 
        SqrtBox["21"]}], ")"}]}], 
     RowBox[{"42", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"17", " ", "\[ImaginaryI]"}], "+", 
        RowBox[{"4", " ", 
         SqrtBox["21"]}]}], ")"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "5"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["21"]}]}], ")"}]}], ")"}], "n"]}]}]],
  CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
   3.806921525064637*^9, 3.8069215544313593`*^9}},ExpressionUUID->
  "60e2269f-8307-4130-ab4b-3d0ca8d1e1bd"]
}], "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867935170189*^9, 
  3.8068679353858957`*^9}, {3.806921576295984*^9, 3.806921612315504*^9}, {
  3.8069221727299576`*^9, 
  3.8069221959813805`*^9}},ExpressionUUID->"80b40283-c236-47ad-8e72-\
6ace00bb4fdb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "/", "5"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", "n", ",", 
   RowBox[{"inicio", "\[Rule]", "2"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "/", "5"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", "n", ",", "b", ",", 
   RowBox[{"inicio", "\[Rule]", "2"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.806921321194724*^9, 3.806921390841611*^9}, {
  3.8069222112949038`*^9, 3.80692223812086*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"8075c53c-3f09-4881-9486-b976e4732f39"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"882", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["2", "5"], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["21"]}], "5"]}], ")"}], "n"]}], "+", 
      RowBox[{"5759", " ", 
       SqrtBox["21"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["2", "5"], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["21"]}], "5"]}], ")"}], "n"]}], "+", 
      RowBox[{"26250", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["2", "5"], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["21"]}], "5"]}], ")"}], "n"]}], "+", 
      RowBox[{"625", " ", 
       SqrtBox["21"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["2", "5"], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["21"]}], "5"]}], ")"}], "n"]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1050", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"17", " ", "\[ImaginaryI]"}], "+", 
        RowBox[{"4", " ", 
         SqrtBox["21"]}]}], ")"}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.806922248866331*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"65886708-188d-47df-9e21-4f525b347a2f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "-", 
    FractionBox[
     RowBox[{"4", " ", "n"}], "5"], "+", 
    SuperscriptBox["n", "2"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", 1 + 
   Rational[-4, 5] $CellContext`n + $CellContext`n^2, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069222488782997`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"28987c78-4893-4503-8af4-6facbf9189ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["21"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["21"]}]}], ")"}]}]}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {
   Rational[1, 5] (2 + Complex[0, -1] 21^Rational[1, 2]), 
    Rational[1, 5] (2 + Complex[0, 1] 21^Rational[1, 2])}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069222488802953`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"d3f56613-ac14-4f9c-b4e9-c947a8ae736e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "5"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["21"]}]}], ")"}]}], ")"}], "n"], " ", 
     SubscriptBox["b", "1"]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "5"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["21"]}]}], ")"}]}], ")"}], "n"], " ", 
     SubscriptBox["b", "2"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", (
      Rational[1, 5] (2 + Complex[0, -1] 21^Rational[1, 2]))^$CellContext`n 
    Subscript[$CellContext`b, 1] + (
      Rational[1, 5] (2 + Complex[0, 1] 21^Rational[1, 2]))^$CellContext`n 
    Subscript[$CellContext`b, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.806922248884283*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"d0a01179-bce9-4f76-a9b2-62deab537f79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "25"]}], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "17"}], " ", "\[ImaginaryI]", " ", 
          SubscriptBox["b", "1"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["21"], " ", 
          SubscriptBox["b", "1"]}], "-", 
         RowBox[{"17", " ", "\[ImaginaryI]", " ", 
          SubscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", 
          SqrtBox["21"], " ", 
          SubscriptBox["b", "2"]}]}], ")"}]}], "\[Equal]", "2"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "125"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"118", " ", "\[ImaginaryI]", " ", 
          SubscriptBox["b", "1"]}], "+", 
         RowBox[{"9", " ", 
          SqrtBox["21"], " ", 
          SubscriptBox["b", "1"]}], "+", 
         RowBox[{"118", " ", "\[ImaginaryI]", " ", 
          SubscriptBox["b", "2"]}], "-", 
         RowBox[{"9", " ", 
          SqrtBox["21"], " ", 
          SubscriptBox["b", "2"]}]}], ")"}]}], "\[Equal]", "1"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {Complex[0, 
       Rational[-1, 25]] (Complex[0, -17] Subscript[$CellContext`b, 1] + 
      4 21^Rational[1, 2] Subscript[$CellContext`b, 1] + 
      Complex[0, -17] Subscript[$CellContext`b, 2] - 4 21^Rational[1, 2] 
      Subscript[$CellContext`b, 2]) == 2, Complex[0, 
       Rational[1, 125]] (Complex[0, 118] Subscript[$CellContext`b, 1] + 
      9 21^Rational[1, 2] Subscript[$CellContext`b, 1] + 
      Complex[0, 118] Subscript[$CellContext`b, 2] - 9 21^Rational[1, 2] 
      Subscript[$CellContext`b, 2]) == 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069222489152007`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"7c386536-ec4d-4a08-afd9-ecf7a1dd1f65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"798", " ", "\[ImaginaryI]"}], "+", 
          RowBox[{"151", " ", 
           SqrtBox["21"]}]}], ")"}]}], "1050"]}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"25", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"42", " ", "\[ImaginaryI]"}], "+", 
           SqrtBox["21"]}], ")"}]}], 
        RowBox[{"42", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"17", " ", "\[ImaginaryI]"}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["21"]}]}], ")"}]}]]}]}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> Complex[0, 
       Rational[1, 1050]] (Complex[0, 798] + 151 21^Rational[1, 2]), 
    Subscript[$CellContext`b, 2] -> 
    Rational[-25, 42] (Complex[0, 42] + 21^Rational[1, 2])/(Complex[0, 17] + 
     4 21^Rational[1, 2])}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069222489181924`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"18306db5-88c1-403a-85da-e196c985589d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["5", 
         RowBox[{
          RowBox[{"-", "2"}], "-", "n"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"882", " ", "\[ImaginaryI]", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["21"]}]}], ")"}], "n"]}], "+", 
          RowBox[{"5759", " ", 
           SqrtBox["21"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["21"]}]}], ")"}], "n"]}], "+", 
          RowBox[{"26250", " ", "\[ImaginaryI]", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["21"]}]}], ")"}], "n"]}], "+", 
          RowBox[{"625", " ", 
           SqrtBox["21"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["21"]}]}], ")"}], "n"]}]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"42", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"17", " ", "\[ImaginaryI]"}], "+", 
          RowBox[{"4", " ", 
           SqrtBox["21"]}]}], ")"}]}], ")"}]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[-1, 42] 
   5^(-2 - $CellContext`n) (Complex[0, 17] + 4 21^Rational[1, 2])^(-1) (
    Complex[0, 882] (2 + Complex[0, -1] 21^Rational[1, 2])^$CellContext`n + 
    5759 21^
      Rational[1, 2] (2 + Complex[0, -1] 21^Rational[1, 2])^$CellContext`n + 
    Complex[0, 26250] (2 + Complex[0, 1] 21^Rational[1, 2])^$CellContext`n + 
    625 21^Rational[1, 2] (2 + 
       Complex[0, 1] 21^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069222489570885`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"bdf1fd92-7964-4633-b9b0-3267e65f30f3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"-", "798"}], "+", 
         RowBox[{"151", " ", "\[ImaginaryI]", " ", 
          SqrtBox["21"]}]}], "1050"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["21"]}]}], ")"}]}], ")"}], "n"]}], "-", 
      RowBox[{
       FractionBox[
        RowBox[{"25", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"42", " ", "\[ImaginaryI]"}], "+", 
           SqrtBox["21"]}], ")"}]}], 
        RowBox[{"42", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"17", " ", "\[ImaginaryI]"}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["21"]}]}], ")"}]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["21"]}]}], ")"}]}], ")"}], "n"]}]}], "]"}], "\[Equal]", 
    RowBox[{"Simplify", "[", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"882", " ", "\[ImaginaryI]", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["2", "5"], "-", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SqrtBox["21"]}], "5"]}], ")"}], "n"]}], "+", 
          RowBox[{"5759", " ", 
           SqrtBox["21"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["2", "5"], "-", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SqrtBox["21"]}], "5"]}], ")"}], "n"]}], "+", 
          RowBox[{"26250", " ", "\[ImaginaryI]", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["2", "5"], "+", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SqrtBox["21"]}], "5"]}], ")"}], "n"]}], "+", 
          RowBox[{"625", " ", 
           SqrtBox["21"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["2", "5"], "+", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SqrtBox["21"]}], "5"]}], ")"}], "n"]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1050", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"17", " ", "\[ImaginaryI]"}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["21"]}]}], ")"}]}], ")"}]}], ")"}]}], "]"}], "\[Equal]", 
    RowBox[{"Simplify", "[", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "2"}], "-", "n"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"882", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"\[ImaginaryI]", " ", 
                 SqrtBox["21"]}]}], ")"}], "n"]}], "+", 
            RowBox[{"5759", " ", 
             SqrtBox["21"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "-", 
                RowBox[{"\[ImaginaryI]", " ", 
                 SqrtBox["21"]}]}], ")"}], "n"]}], "+", 
            RowBox[{"26250", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{"\[ImaginaryI]", " ", 
                 SqrtBox["21"]}]}], ")"}], "n"]}], "+", 
            RowBox[{"625", " ", 
             SqrtBox["21"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{"\[ImaginaryI]", " ", 
                 SqrtBox["21"]}]}], ")"}], "n"]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"42", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"17", " ", "\[ImaginaryI]"}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["21"]}]}], ")"}]}], ")"}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069216364160323`*^9, 3.8069217091358523`*^9}, {
  3.806922284424903*^9, 3.806922330474687*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"f4f5e8f8-91c0-46b9-bf93-32dde80a81dd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.806922336608741*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"26b976dd-bc33-40f6-92e1-afaa02e04439"]
}, Open  ]],

Cell["2.3.19", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867941762295*^9, 
  3.8068679419939938`*^9}, {3.806925915757785*^9, 3.80692591590938*^9}, {
  3.8069259465100403`*^9, 3.806925946677594*^9}, {3.8069296705402975`*^9, 
  3.806929671059784*^9}, {3.807370389669958*^9, 3.807370390185278*^9}, {
  3.8073780205651655`*^9, 
  3.807378021039033*^9}},ExpressionUUID->"fbd9e143-455b-4b0c-8fbc-\
ed6e1909743d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "3"], "-", 
     RowBox[{"5", 
      SuperscriptBox["t", "2"]}], "+", 
     RowBox[{"8", "t"}], "-", "4"}], "\[Equal]", "0"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.806921402285298*^9, 3.8069214182650003`*^9}, {
  3.8069259551508303`*^9, 3.8069259754380827`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"42d1db56-9e27-4cf5-a97c-b64b472bad70"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.806925990361428*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"6c294aad-e8e8-490e-9e78-12a4c2b24762"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"b1", " ", 
        SuperscriptBox["1", "0"]}], "+", 
       RowBox[{"b2", " ", 
        SuperscriptBox["2", "0"]}], "+", 
       RowBox[{"b3", " ", "0", " ", 
        SuperscriptBox["2", "0"]}]}], "\[Equal]", "5"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b1", " ", 
        SuperscriptBox["1", "1"]}], "+", 
       RowBox[{"b2", " ", 
        SuperscriptBox["2", "1"]}], "+", 
       RowBox[{"b3", " ", "1", " ", 
        SuperscriptBox["2", "1"]}]}], "\[Equal]", "2"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b1", " ", 
        SuperscriptBox["1", "2"]}], "+", 
       RowBox[{"b2", " ", 
        SuperscriptBox["2", "2"]}], "+", 
       RowBox[{"b3", " ", "2", " ", 
        SuperscriptBox["2", "2"]}]}], "\[Equal]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2", ",", "b3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
  3.806921525064637*^9, 3.8069215544313593`*^9}, {3.806926000182604*^9, 
  3.8069262373828177`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"7e06a926-6335-45f5-914b-41dcad503604"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", "15"}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{"-", "10"}]}], ",", 
    RowBox[{"b3", "\[Rule]", 
     FractionBox["7", "2"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.8069261811628857`*^9, 3.8069262420040016`*^9}},
 CellLabel->"Out[30]=",ExpressionUUID->"0d8f5586-2e68-4ffb-99af-e2555fb4967a"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "="}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7be72eb8-eaf9-47d2-b9a6-b69b82e0a8db"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"15", " ", 
     SuperscriptBox["1", "n"]}], "-", 
    RowBox[{"10", " ", 
     SuperscriptBox["2", "n"]}], "+", 
    RowBox[{
     FractionBox["7", "2"], "n", " ", 
     SuperscriptBox["2", "n"]}]}], "=", 
   RowBox[{"15", "-", 
    RowBox[{"10", " ", 
     SuperscriptBox["2", "n"]}], "+", 
    RowBox[{
     FractionBox["7", "2"], "n", " ", 
     SuperscriptBox["2", "n"]}]}]}]],
  CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
   3.806921525064637*^9, 3.8069215544313593`*^9}},ExpressionUUID->
  "704caf4c-0d34-4cff-be65-18cea55d2e5d"]
}], "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867935170189*^9, 
  3.8068679353858957`*^9}, {3.806921576295984*^9, 3.806921612315504*^9}, {
  3.8069221727299576`*^9, 3.8069221959813805`*^9}, {3.806926277545978*^9, 
  3.8069263537673683`*^9}, {3.806926503906173*^9, 
  3.8069265074426804`*^9}},ExpressionUUID->"0dbf3729-f698-4a38-82b1-\
a905461d760b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "8"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", "3"}], "}"}], ",", "n", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "8"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", "3"}], "}"}], ",", "n", ",", "b", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.806921321194724*^9, 3.806921390841611*^9}, {
  3.806926367554344*^9, 3.8069263939583917`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"34d97162-663f-4fc3-ad1c-0fb702659150"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"30", "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["2", 
      RowBox[{"2", "+", "n"}]]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["2", "n"], " ", "n"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.8069264048001356`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"847c9279-6c10-43ab-8c5e-99864d83f9ad"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    RowBox[{"8", " ", "n"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["n", "2"]}], "+", 
    SuperscriptBox["n", "3"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", -4 + 
   8 $CellContext`n - 5 $CellContext`n^2 + $CellContext`n^3, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069264048031273`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"8532448a-8d22-4fb4-a02a-cf023763d676"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {1, 2, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069264048051214`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"da27695a-79ca-46c0-9a46-7e257b046a95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SubscriptBox["b", "1"], "+", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     SubscriptBox["b", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", "n", " ", 
     SubscriptBox["b", "3"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", Subscript[$CellContext`b, 1] + 
   2^$CellContext`n Subscript[$CellContext`b, 2] + 
   2^$CellContext`n $CellContext`n Subscript[$CellContext`b, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069264048071165`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"b8143a5a-0cc3-4044-a10e-a869d404a5e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       SubscriptBox["b", "2"]}], "\[Equal]", "5"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["b", "3"]}]}], "\[Equal]", "2"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"4", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"8", " ", 
        SubscriptBox["b", "3"]}]}], "\[Equal]", "3"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {
   Subscript[$CellContext`b, 1] + Subscript[$CellContext`b, 2] == 5, 
    Subscript[$CellContext`b, 1] + 2 Subscript[$CellContext`b, 2] + 
     2 Subscript[$CellContext`b, 3] == 2, 
    Subscript[$CellContext`b, 1] + 4 Subscript[$CellContext`b, 2] + 
     8 Subscript[$CellContext`b, 3] == 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.806926404809111*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"84a5908d-f278-429b-92df-ef71c240c7b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", "15"}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      RowBox[{"-", "10"}]}], ",", 
     RowBox[{
      SubscriptBox["b", "3"], "\[Rule]", 
      FractionBox["7", "2"]}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> 15, Subscript[$CellContext`b, 2] -> -10, 
    Subscript[$CellContext`b, 3] -> Rational[7, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.806926404810108*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"5671413d-b732-405c-8dc9-19271c487ee0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"30", "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["2", 
        RowBox[{"2", "+", "n"}]]}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["2", "n"], " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[1, 2] (30 - 5 2^(2 + $CellContext`n) + 
    7 2^$CellContext`n $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806926404812103*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"5de3bee4-18bf-436c-9193-d00dd8b8e652"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"15", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["2", "n"]}], "+", 
      RowBox[{
       FractionBox["7", "2"], "n", " ", 
       SuperscriptBox["2", "n"]}]}], "]"}], "\[Equal]", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"30", "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["2", 
          RowBox[{"2", "+", "n"}]]}], "+", 
        RowBox[{"7", " ", 
         SuperscriptBox["2", "n"], " ", "n"}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069216364160323`*^9, 3.8069217091358523`*^9}, {
   3.8069264197122955`*^9, 3.8069264573147936`*^9}, 3.806926519734887*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"ac488fd1-1643-4e27-8200-f652a4538165"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.8069264640439157`*^9, 3.8069265210514965`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"353afba4-87b3-4fa0-90d2-d889f5be8248"]
}, Open  ]],

Cell["2.3.20", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867944222495*^9, 
  3.806867944394597*^9}, {3.8069296778614764`*^9, 3.806929678315403*^9}, {
  3.807370399435318*^9, 3.807370399905774*^9}, {3.807378026300892*^9, 
  3.8073780272738895`*^9}},ExpressionUUID->"f588dd6a-8308-46ba-b72a-\
1b5bdd000e7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "4"], "-", 
     RowBox[{"20", 
      SuperscriptBox["t", "3"]}], "+", 
     RowBox[{"150", 
      SuperscriptBox["t", "2"]}], "-", 
     RowBox[{"500", "t"}], "+", "625"}], "\[Equal]", "0"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.806921402285298*^9, 3.8069214182650003`*^9}, {
  3.806926670325373*^9, 3.806926704312126*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"38ec8c4d-f38c-42ef-aebd-524232cfdae7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "5"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8069267079838676`*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"1749d697-1e70-472c-9ec4-50d8538ee5a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"b1", " ", 
        SuperscriptBox["5", "0"]}], "+", 
       RowBox[{"b2", " ", "0", " ", 
        SuperscriptBox["5", "0"]}], "+", 
       RowBox[{"b3", " ", 
        SuperscriptBox["0", "2"], 
        SuperscriptBox["5", "0"]}], "+", 
       RowBox[{"b4", " ", 
        SuperscriptBox["0", "3"], 
        SuperscriptBox["5", "0"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b1", " ", 
        SuperscriptBox["5", "1"]}], "+", 
       RowBox[{"b2", " ", "1", " ", 
        SuperscriptBox["5", "1"]}], "+", 
       RowBox[{"b3", " ", 
        SuperscriptBox["1", "2"], 
        SuperscriptBox["5", "1"]}], "+", 
       RowBox[{"b4", " ", 
        SuperscriptBox["1", "3"], 
        SuperscriptBox["5", "1"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b1", " ", 
        SuperscriptBox["5", "2"]}], "+", 
       RowBox[{"b2", " ", "2", " ", 
        SuperscriptBox["5", "2"]}], "+", 
       RowBox[{"b3", " ", 
        SuperscriptBox["2", "2"], 
        SuperscriptBox["5", "2"]}], "+", 
       RowBox[{"b4", " ", 
        SuperscriptBox["2", "3"], 
        SuperscriptBox["5", "2"]}]}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b1", " ", 
        SuperscriptBox["5", "3"]}], "+", 
       RowBox[{"b2", " ", "3", " ", 
        SuperscriptBox["5", "3"]}], "+", 
       RowBox[{"b3", " ", 
        SuperscriptBox["3", "2"], 
        SuperscriptBox["5", "3"]}], "+", 
       RowBox[{"b4", " ", 
        SuperscriptBox["3", "3"], 
        SuperscriptBox["5", "3"]}]}], "\[Equal]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2", ",", "b3", ",", "b4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
  3.806921525064637*^9, 3.8069215544313593`*^9}, {3.806926738582588*^9, 
  3.8069270038584075`*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"56300ecb-0d95-4329-b277-1967b8472a09"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", "1"}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["527", "375"]}]}], ",", 
    RowBox[{"b3", "\[Rule]", 
     FractionBox["91", "125"]}], ",", 
    RowBox[{"b4", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["46", "375"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8069268267098455`*^9, 3.8069270073359003`*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"ed92f10a-fa3a-43ca-8032-5cb12ff65c0b"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "="}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "fe92193f-f0ce-4481-a32b-ac445497dbce"],
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    SuperscriptBox["5", "n"], "-", 
    RowBox[{
     FractionBox["527", "375"], "n", " ", 
     SuperscriptBox["5", "n"]}], "+", 
    RowBox[{
     FractionBox["91", "125"], 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["5", "n"]}], "-", 
    RowBox[{
     FractionBox["46", "375"], 
     SuperscriptBox["n", "3"], 
     SuperscriptBox["5", "n"]}]}]}]],
  CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
   3.806921525064637*^9, 3.8069215544313593`*^9}},ExpressionUUID->
  "e395f126-0618-4821-874a-bf6b11efa1b6"]
}], "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867935170189*^9, 
  3.8068679353858957`*^9}, {3.806921576295984*^9, 3.806921612315504*^9}, {
  3.8069221727299576`*^9, 3.8069221959813805`*^9}, {3.806926277545978*^9, 
  3.8069263537673683`*^9}, {3.806926503906173*^9, 3.8069265074426804`*^9}, {
  3.8069270592676926`*^9, 
  3.806927109580974*^9}},ExpressionUUID->"4f9b5569-e226-4202-9a4d-\
39ba03cc081c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{"-", "150"}], ",", "500", ",", 
     RowBox[{"-", "625"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "3", ",", "3"}], "}"}], ",", "n", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{"-", "150"}], ",", "500", ",", 
     RowBox[{"-", "625"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "3", ",", "3"}], "}"}], ",", "n", ",", "b", 
   ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.806921321194724*^9, 3.806921390841611*^9}, {
  3.806927138712333*^9, 3.8069271694425054`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"6d405305-8c06-41b7-b0ad-8d54830e783d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "3"]}], " ", 
  SuperscriptBox["5", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "n"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "375"}], "+", 
    RowBox[{"527", " ", "n"}], "-", 
    RowBox[{"273", " ", 
     SuperscriptBox["n", "2"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["n", "3"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.8069271703732276`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"485fec83-07fe-4705-9580-9e8a4fde84e7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"625", "-", 
    RowBox[{"500", " ", "n"}], "+", 
    RowBox[{"150", " ", 
     SuperscriptBox["n", "2"]}], "-", 
    RowBox[{"20", " ", 
     SuperscriptBox["n", "3"]}], "+", 
    SuperscriptBox["n", "4"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", 625 - 
   500 $CellContext`n + 150 $CellContext`n^2 - 
   20 $CellContext`n^3 + $CellContext`n^4, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069271703772182`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"a51b59ae-5437-42a4-9edf-593f7eab2b7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "5", ",", "5"}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {5, 5, 5, 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069271703782253`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"0a024c30-8b66-4691-a1ce-fd68286533ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["5", "n"], " ", 
     SubscriptBox["b", "1"]}], "+", 
    RowBox[{
     SuperscriptBox["5", "n"], " ", "n", " ", 
     SubscriptBox["b", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["5", "n"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SubscriptBox["b", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["5", "n"], " ", 
     SuperscriptBox["n", "3"], " ", 
     SubscriptBox["b", "4"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", 5^$CellContext`n Subscript[$CellContext`b, 1] + 
   5^$CellContext`n $CellContext`n Subscript[$CellContext`b, 2] + 
   5^$CellContext`n $CellContext`n^2 Subscript[$CellContext`b, 3] + 
   5^$CellContext`n $CellContext`n^3 Subscript[$CellContext`b, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.806927170382204*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"9bcf6109-a57d-4810-b8b3-ab3bb9ab5e5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["b", "1"], "+", 
         SubscriptBox["b", "2"], "+", 
         SubscriptBox["b", "3"], "+", 
         SubscriptBox["b", "4"]}], ")"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"25", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["b", "1"], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["b", "3"]}], "+", 
         RowBox[{"8", " ", 
          SubscriptBox["b", "4"]}]}], ")"}]}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{"125", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["b", "1"], "+", 
         RowBox[{"3", " ", 
          SubscriptBox["b", "2"]}], "+", 
         RowBox[{"9", " ", 
          SubscriptBox["b", "3"]}], "+", 
         RowBox[{"27", " ", 
          SubscriptBox["b", "4"]}]}], ")"}]}], "\[Equal]", "3"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {
   Subscript[$CellContext`b, 1] == 1, 
    5 (Subscript[$CellContext`b, 1] + Subscript[$CellContext`b, 2] + 
      Subscript[$CellContext`b, 3] + Subscript[$CellContext`b, 4]) == 1, 
    25 (Subscript[$CellContext`b, 1] + 2 Subscript[$CellContext`b, 2] + 
      4 Subscript[$CellContext`b, 3] + 8 Subscript[$CellContext`b, 4]) == 3, 
    125 (Subscript[$CellContext`b, 1] + 3 Subscript[$CellContext`b, 2] + 
      9 Subscript[$CellContext`b, 3] + 27 Subscript[$CellContext`b, 4]) == 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069271703842*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"b6dfc766-401e-4736-8c67-8f115c1fc26c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", "1"}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["527", "375"]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "3"], "\[Rule]", 
      FractionBox["91", "125"]}], ",", 
     RowBox[{
      SubscriptBox["b", "4"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["46", "375"]}]}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> 1, Subscript[$CellContext`b, 2] -> 
    Rational[-527, 375], Subscript[$CellContext`b, 3] -> Rational[91, 125], 
    Subscript[$CellContext`b, 4] -> Rational[-46, 375]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069271703851967`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"9615ddaa-9efd-4118-b2e5-a027b0202a50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "3"]}], " ", 
    SuperscriptBox["5", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "n"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "375"}], "+", 
      RowBox[{"527", " ", "n"}], "-", 
      RowBox[{"273", " ", 
       SuperscriptBox["n", "2"]}], "+", 
      RowBox[{"46", " ", 
       SuperscriptBox["n", "3"]}]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[-1, 3] 
   5^(-3 + $CellContext`n) (-375 + 527 $CellContext`n - 273 $CellContext`n^2 + 
    46 $CellContext`n^3)],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069271703871913`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"76ed8a1b-cfff-4c21-9ca3-9c84e9757494"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      SuperscriptBox["5", "n"], "-", 
      RowBox[{
       FractionBox["527", "375"], "n", " ", 
       SuperscriptBox["5", "n"]}], "+", 
      RowBox[{
       FractionBox["91", "125"], 
       SuperscriptBox["n", "2"], " ", 
       SuperscriptBox["5", "n"]}], "-", 
      RowBox[{
       FractionBox["46", "375"], 
       SuperscriptBox["n", "3"], 
       SuperscriptBox["5", "n"]}]}], "]"}], "\[Equal]", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", 
      SuperscriptBox["5", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "n"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "375"}], "+", 
        RowBox[{"527", " ", "n"}], "-", 
        RowBox[{"273", " ", 
         SuperscriptBox["n", "2"]}], "+", 
        RowBox[{"46", " ", 
         SuperscriptBox["n", "3"]}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069216364160323`*^9, 3.8069217091358523`*^9}, {
  3.806927187013996*^9, 3.806927206697689*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"36bd82ef-77ab-4c35-80eb-db45d47d8638"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.806927210383038*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"6ab6eafb-0892-4ec8-a614-49f38471236c"]
}, Open  ]],

Cell["2.3.21", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.8068679464970818`*^9, 
  3.806867946673252*^9}, {3.8069296867701874`*^9, 3.8069296872668343`*^9}, {
  3.8073704076913633`*^9, 3.8073704086610584`*^9}, {3.8073780346291695`*^9, 
  3.8073780351484623`*^9}},ExpressionUUID->"25206bf2-efec-4f81-b719-\
d09f266eac9a"],

Cell[TextData[{
 "Sea ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "n"], "=", 
    SqrtBox[
     SubscriptBox["a", "n"]]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "89e20866-f87d-4b3b-ad70-57773818e4b8"],
 ":"
}], "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
   3.806862265183646*^9, 3.806862273361394*^9}, {3.8068679464970818`*^9, 
   3.806867946673252*^9}, {3.8069274740582504`*^9, 3.8069274979559927`*^9}, 
   3.806927539832656*^9},ExpressionUUID->"c00aad57-ded4-4c0b-8f79-\
7e514498fba9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "2"], "-", "t", "-", "2"}], "\[Equal]", "0"}], ",", 
   "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.806921402285298*^9, 3.8069214182650003`*^9}, {
  3.8069275470260086`*^9, 3.806927567681736*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"d99fc7c5-c0fb-4b8e-991d-3f589df236cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8069275697692113`*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"602f8515-8a3b-4e33-bca2-b7a405d584fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"b1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "1"]}], "+", 
       RowBox[{"b2", " ", 
        SuperscriptBox["2", "1"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "2"]}], "+", 
       RowBox[{"b2", " ", 
        SuperscriptBox["2", "2"]}]}], "\[Equal]", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
  3.806921525064637*^9, 3.8069215544313593`*^9}, {3.8069275775661097`*^9, 
  3.806927615371773*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"313c0c1c-3993-4389-bd72-e785cc76b3b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SqrtBox["2"]}], ")"}]}]}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["2"]}], ")"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.806927621596983*^9, 3.806927974115127*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"164ef80b-b9bc-430f-947c-11b55e1dc891"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "="}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a5974308-1c3e-435b-aadc-6e792b442407"],
 Cell[BoxData[
  RowBox[{" ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SqrtBox["2"]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["2"]}], ")"}], " ", 
       SuperscriptBox["2", "n"]}]}], ")"}], "2"]}]],
  CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
   3.806921525064637*^9, 3.8069215544313593`*^9}},ExpressionUUID->
  "610e1c44-3095-4feb-869c-9eb9ac7e1a48"]
}], "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867935170189*^9, 
  3.8068679353858957`*^9}, {3.806921576295984*^9, 3.806921612315504*^9}, {
  3.8069221727299576`*^9, 3.8069221959813805`*^9}, {3.806926277545978*^9, 
  3.8069263537673683`*^9}, {3.806926503906173*^9, 3.8069265074426804`*^9}, {
  3.8069270592676926`*^9, 3.806927109580974*^9}, {3.8069276448116617`*^9, 
  3.806927710444867*^9}},ExpressionUUID->"23d49582-483b-4eca-aff8-\
ec73a6c5a7a6"],

Cell[CellGroupData[{

Cell[BoxData[{
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"RR", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       SqrtBox["2"]}], "}"}], ",", " ", "n"}], "]"}], ")"}], "2"], "\n", 
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", 
     SqrtBox["2"]}], "}"}], ",", " ", "n", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.806921321194724*^9, 3.806921390841611*^9}, {
  3.806927750033945*^9, 3.806927786323786*^9}, {3.806927816986714*^9, 
  3.806927832394643*^9}, {3.8069280173821*^9, 3.8069280229237022`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"6567c152-2bcd-4bbe-8e4e-c5c92975771f"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "36"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], " ", 
      SqrtBox["2"]}], "+", 
     SuperscriptBox["2", "n"], "+", 
     SuperscriptBox["2", 
      RowBox[{
       FractionBox["1", "2"], "+", "n"}]]}], ")"}], "2"]}]], "Output",
 CellChangeTimes->{3.806927835749853*^9, 3.8069280237133856`*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"96d5082a-ae90-46a0-b8b5-5b58df4ffeb0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], "-", "n", "+", 
    SuperscriptBox["n", "2"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", -2 - \
$CellContext`n + $CellContext`n^2, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069278357528205`*^9, 3.806928023716378*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"cc3d2120-b38d-43f4-80dd-d4410f95bfcc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {-1, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069278357528205`*^9, 3.806928023719372*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"09bea845-739d-49d9-8fb0-cd68aaaa4771"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "n"], " ", 
     SubscriptBox["b", "1"]}], "+", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     SubscriptBox["b", "2"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", (-1)^$CellContext`n Subscript[$CellContext`b, 1] + 
   2^$CellContext`n Subscript[$CellContext`b, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069278357528205`*^9, 3.8069280237223625`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"f02597ca-a02d-4301-b746-4eaefb7c9353"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["b", "1"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["b", "2"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"4", " ", 
        SubscriptBox["b", "2"]}]}], "\[Equal]", 
      SqrtBox["2"]}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {-
      Subscript[$CellContext`b, 1] + 2 Subscript[$CellContext`b, 2] == 1, 
    Subscript[$CellContext`b, 1] + 4 Subscript[$CellContext`b, 2] == 
    2^Rational[1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069278357528205`*^9, 3.8069280237243567`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"fd02a5f5-f3f9-4614-a553-cdca2139b23a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SqrtBox["2"]}], ")"}]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["2"]}], ")"}]}]}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> Rational[1, 3] (-2 + 2^Rational[1, 2]), 
    Subscript[$CellContext`b, 2] -> Rational[1, 6] (1 + 2^Rational[1, 2])}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069278357528205`*^9, 3.806928023725354*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"ae50f481-cd86-4ed8-9a55-e5db41dbe1da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], " ", 
       SqrtBox["2"]}], "+", 
      SuperscriptBox["2", "n"], "+", 
      SuperscriptBox["2", 
       RowBox[{
        FractionBox["1", "2"], "+", "n"}]]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[1, 6] ((-4) (-1)^$CellContext`n + 
    2 (-1)^$CellContext`n 2^Rational[1, 2] + 2^$CellContext`n + 
    2^(Rational[1, 2] + $CellContext`n))],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069278357528205`*^9, 3.8069280237273483`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"07558781-4008-4e91-9cc4-448cc029e23a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           SqrtBox["2"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
        RowBox[{
         FractionBox["1", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["2"]}], ")"}], " ", 
         SuperscriptBox["2", "n"]}]}], ")"}], "2"], "]"}], "\[Equal]", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      FractionBox["1", "36"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "n"], " ", 
          SqrtBox["2"]}], "+", 
         SuperscriptBox["2", "n"], "+", 
         SuperscriptBox["2", 
          RowBox[{
           FractionBox["1", "2"], "+", "n"}]]}], ")"}], "2"]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069216364160323`*^9, 3.8069217091358523`*^9}, {
   3.8069278542149744`*^9, 3.806927884437708*^9}, 3.806928043258627*^9},
 CellLabel->"In[49]:=",ExpressionUUID->"b4aa2a81-f105-4827-9381-b38beafd1c52"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.8069278870505495`*^9, 3.8069280458121567`*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"296b8fb5-79c3-48d2-afbe-fcbf6e9dc6d9"]
}, Open  ]],

Cell["2.3.22", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.8068679487884502`*^9, 
  3.8068679490049334`*^9}, {3.8069296956927905`*^9, 3.8069296961167545`*^9}, {
  3.807370415411174*^9, 3.8073704164669666`*^9}, {3.807378042123271*^9, 
  3.8073780427738447`*^9}},ExpressionUUID->"ec9bb055-b676-4196-be43-\
68c1c1144a12"],

Cell[TextData[{
 "Sea ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "n"], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      SubscriptBox["a", "n"], ")"}], "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f1da8877-97f1-4d8c-9290-64f3f8d2803d"],
 ":"
}], "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
   3.806862265183646*^9, 3.806862273361394*^9}, {3.8068679464970818`*^9, 
   3.806867946673252*^9}, {3.8069274740582504`*^9, 3.8069274979559927`*^9}, 
   3.806927539832656*^9, {3.8069282362520037`*^9, 
   3.8069282459193597`*^9}},ExpressionUUID->"ec04b5d3-ac4a-4463-bfb2-\
17b1888be173"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "2"], "-", "t", "+", "2"}], "\[Equal]", "0"}], ",", 
   "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.806921402285298*^9, 3.8069214182650003`*^9}, {
  3.8069282578142204`*^9, 3.806928261676305*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"2e22d14e-6e73-4676-ae94-fc2143c0894a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["7"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["7"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8069282743064547`*^9, 3.8254379532702985`*^9, 
  3.8254385485839915`*^9, 3.8254387403301897`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"a4032f82-482c-4a16-af11-fc2d641ddeb0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"b1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["7"]}]}], ")"}]}], ")"}], "0"]}], "+", 
       RowBox[{"b2", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["7"]}]}], ")"}]}], ")"}], "0"]}]}], "\[Equal]", "4"}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["7"]}]}], ")"}]}], ")"}], "1"]}], "+", 
       RowBox[{"b2", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["7"]}]}], ")"}]}], ")"}], "1"]}]}], "\[Equal]", "5"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
  3.806921525064637*^9, 3.8069215544313593`*^9}, {3.8069282934977255`*^9, 
  3.806928343171261*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"d5195231-e3f5-4560-832d-b7f931ccbded"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", 
     RowBox[{
      FractionBox["1", "7"], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "14"}], " ", "\[ImaginaryI]"}], "+", 
        RowBox[{"3", " ", 
         SqrtBox["7"]}]}], ")"}]}]}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "7"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"14", " ", "\[ImaginaryI]"}], "+", 
        RowBox[{"3", " ", 
         SqrtBox["7"]}]}], ")"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.806928345115923*^9, 3.825437989526492*^9, 
  3.825438554505953*^9, 3.8254387438568296`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"59dff610-b2b7-4bd9-9b32-24d523bda375"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "="}], TraditionalForm]],ExpressionUUID->
  "1653a8dc-7ae6-4024-ae4f-5669b90d423e"],
 Cell[BoxData[
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "7"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "14"}], " ", "\[ImaginaryI]"}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["7"]}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["7"]}]}], ")"}]}], ")"}], "n"]}], "-", 
      RowBox[{
       FractionBox["1", "7"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"14", " ", "\[ImaginaryI]"}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["7"]}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["7"]}]}], ")"}]}], ")"}], "n"]}]}], ")"}], 
    RowBox[{"1", "/", "2"}]]}]],
  CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
   3.806921525064637*^9, 3.8069215544313593`*^9}},ExpressionUUID->
  "00159400-a36d-4965-a169-e92a82363a05"]
}], "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867935170189*^9, 
  3.8068679353858957`*^9}, {3.806921576295984*^9, 3.806921612315504*^9}, {
  3.8069221727299576`*^9, 3.8069221959813805`*^9}, {3.806926277545978*^9, 
  3.8069263537673683`*^9}, {3.806926503906173*^9, 3.8069265074426804`*^9}, {
  3.8069270592676926`*^9, 3.806927109580974*^9}, {3.8069276448116617`*^9, 
  3.806927710444867*^9}, {3.8069283773512735`*^9, 3.8069285009282217`*^9}, {
  3.8254379973203807`*^9, 
  3.825437997321344*^9}},ExpressionUUID->"ed964275-22ca-4db6-85ad-\
0a38cde2cf8e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"-", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"RR", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], ",", "n", ",", 
      RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}], ")"}], 
   RowBox[{"1", "/", "2"}]]}], "\[IndentingNewLine]", 
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", "n", ",", "b", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.806921321194724*^9, 3.806921390841611*^9}, {
   3.8069285239392123`*^9, 3.806928599668285*^9}, 3.825438024277933*^9, {
   3.8254381351621003`*^9, 3.825438143640553*^9}, {3.8254382078780575`*^9, 
   3.8254382109825974`*^9}, 3.825438266450715*^9},
 CellLabel->"In[52]:=",ExpressionUUID->"c7410aa2-f20b-4bcd-ae88-b952fd3ae052"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SqrtBox[
    RowBox[{
     RowBox[{"14", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}], "2"]}], ")"}], "n"]}], "+", 
     RowBox[{"3", " ", "\[ImaginaryI]", " ", 
      SqrtBox["7"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}], "2"]}], ")"}], "n"]}], "+", 
     RowBox[{"14", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "+", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}], "2"]}], ")"}], "n"]}], "-", 
     RowBox[{"3", " ", "\[ImaginaryI]", " ", 
      SqrtBox["7"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "+", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}], "2"]}], ")"}], "n"]}]}]], 
   SqrtBox["7"]]}]], "Output",
 CellChangeTimes->{{3.8069285785833893`*^9, 3.806928601529833*^9}, {
   3.825438083958336*^9, 3.825438093336176*^9}, {3.8254381359995985`*^9, 
   3.825438144465661*^9}, 3.825438178966565*^9, 3.825438211788368*^9, 
   3.8254382673816776`*^9, 3.825438677477785*^9, 3.825438747174076*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"5e5dfc73-b5cb-4d6e-8e4e-4a53abcdf7d3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"2", "-", "n", "+", 
    SuperscriptBox["n", "2"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", 
   2 - $CellContext`n + $CellContext`n^2, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069285785903716`*^9, 3.8069286015328255`*^9}, {
   3.825438083969305*^9, 3.825438093338187*^9}, {3.8254381360035896`*^9, 
   3.8254381444676557`*^9}, 3.825438178970555*^9, 3.8254382117896786`*^9, 
   3.825438267385669*^9, 3.8254386774807777`*^9, 3.825438747177715*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[52]:=",ExpressionUUID->"00f49a94-0ea8-4151-b786-4d25a457c04f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["7"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["7"]}]}], ")"}]}]}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {
   Rational[1, 2] (1 + Complex[0, -1] 7^Rational[1, 2]), 
    Rational[1, 2] (1 + Complex[0, 1] 7^Rational[1, 2])}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069285785903716`*^9, 3.8069286015328255`*^9}, {
   3.825438083969305*^9, 3.825438093338187*^9}, {3.8254381360035896`*^9, 
   3.8254381444676557`*^9}, 3.825438178970555*^9, 3.8254382117896786`*^9, 
   3.825438267385669*^9, 3.8254386774807777`*^9, 3.8254387471801233`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[52]:=",ExpressionUUID->"92c993e9-a899-4842-8857-dbc6178616b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}]}], ")"}]}], ")"}], "n"], " ", 
     SubscriptBox["b", "1"]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}]}], ")"}]}], ")"}], "n"], " ", 
     SubscriptBox["b", "2"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", (
      Rational[1, 2] (1 + Complex[0, -1] 7^Rational[1, 2]))^$CellContext`n 
    Subscript[$CellContext`b, 1] + (
      Rational[1, 2] (1 + Complex[0, 1] 7^Rational[1, 2]))^$CellContext`n 
    Subscript[$CellContext`b, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069285785903716`*^9, 3.8069286015328255`*^9}, {
   3.825438083969305*^9, 3.825438093338187*^9}, {3.8254381360035896`*^9, 
   3.8254381444676557`*^9}, 3.825438178970555*^9, 3.8254382117896786`*^9, 
   3.825438267385669*^9, 3.8254386774807777`*^9, 3.8254387471831093`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[52]:=",ExpressionUUID->"6ecdb7af-a17c-4a48-a651-ec83e8f03d51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       SubscriptBox["b", "2"]}], "\[Equal]", "4"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["b", "1"], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["7"], " ", 
          SubscriptBox["b", "1"]}], "+", 
         SubscriptBox["b", "2"], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["7"], " ", 
          SubscriptBox["b", "2"]}]}], ")"}]}], "\[Equal]", "5"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {
   Subscript[$CellContext`b, 1] + Subscript[$CellContext`b, 2] == 4, 
    Rational[1, 2] (Subscript[$CellContext`b, 1] + 
      Complex[0, -1] 7^Rational[1, 2] Subscript[$CellContext`b, 1] + 
      Subscript[$CellContext`b, 2] + 
      Complex[0, 1] 7^Rational[1, 2] Subscript[$CellContext`b, 2]) == 5}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069285785903716`*^9, 3.8069286015328255`*^9}, {
   3.825438083969305*^9, 3.825438093338187*^9}, {3.8254381360035896`*^9, 
   3.8254381444676557`*^9}, 3.825438178970555*^9, 3.8254382117896786`*^9, 
   3.825438267385669*^9, 3.8254386774807777`*^9, 3.825438747184102*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[52]:=",ExpressionUUID->"fc81df4d-a3dc-462e-b12a-24ffa3490535"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "7"], " ", 
       RowBox[{"(", 
        RowBox[{"14", "+", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["7"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "7"], " ", 
       RowBox[{"(", 
        RowBox[{"14", "-", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", 
          SqrtBox["7"]}]}], ")"}]}]}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> 
    Rational[1, 7] (14 + Complex[0, 3] 7^Rational[1, 2]), 
    Subscript[$CellContext`b, 2] -> 
    Rational[1, 7] (14 + Complex[0, -3] 7^Rational[1, 2])}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069285785903716`*^9, 3.8069286015328255`*^9}, {
   3.825438083969305*^9, 3.825438093338187*^9}, {3.8254381360035896`*^9, 
   3.8254381444676557`*^9}, 3.825438178970555*^9, 3.8254382117896786`*^9, 
   3.825438267385669*^9, 3.8254386774807777`*^9, 3.825438747186097*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[52]:=",ExpressionUUID->"f7edbb18-d229-422a-8bd5-ca6bcc2bcf01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "7"], " ", 
    SuperscriptBox["2", 
     RowBox[{"-", "n"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"14", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}]}], ")"}], "n"]}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SqrtBox["7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}]}], ")"}], "n"]}], "+", 
      RowBox[{"14", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}]}], ")"}], "n"]}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SqrtBox["7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[1, 7] 
   2^(-$CellContext`n) (
    14 (1 + Complex[0, -1] 7^Rational[1, 2])^$CellContext`n + 
    Complex[0, 3] 
     7^Rational[1, 2] (1 + Complex[0, -1] 7^Rational[1, 2])^$CellContext`n + 
    14 (1 + Complex[0, 1] 7^Rational[1, 2])^$CellContext`n + 
    Complex[0, -3] 
     7^Rational[1, 2] (1 + Complex[0, 1] 7^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069285785903716`*^9, 3.8069286015328255`*^9}, {
   3.825438083969305*^9, 3.825438093338187*^9}, {3.8254381360035896`*^9, 
   3.8254381444676557`*^9}, 3.825438178970555*^9, 3.8254382117896786`*^9, 
   3.825438267385669*^9, 3.8254386774807777`*^9, 3.825438747188091*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[52]:=",ExpressionUUID->"41159431-dc23-44f4-ae31-f22d2922027c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "7"], " ", "\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "14"}], " ", "\[ImaginaryI]"}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["7"]}]}], ")"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"\[ImaginaryI]", " ", 
                SqrtBox["7"]}]}], ")"}]}], ")"}], "n"]}], "-", 
         RowBox[{
          FractionBox["1", "7"], " ", "\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"14", " ", "\[ImaginaryI]"}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["7"]}]}], ")"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"\[ImaginaryI]", " ", 
                SqrtBox["7"]}]}], ")"}]}], ")"}], "n"]}]}], ")"}], 
       RowBox[{"1", "/", "2"}]]}], "]"}], "\[Equal]", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["7"]]}], 
      RowBox[{"(", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"14", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "2"], "-", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SqrtBox["7"]}], "2"]}], ")"}], "n"]}], "+", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           SqrtBox["7"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "2"], "-", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SqrtBox["7"]}], "2"]}], ")"}], "n"]}], "+", 
          RowBox[{"14", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "2"], "+", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SqrtBox["7"]}], "2"]}], ")"}], "n"]}], "-", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           SqrtBox["7"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "2"], "+", 
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SqrtBox["7"]}], "2"]}], ")"}], "n"]}]}], ")"}]}], ")"}]}], 
     "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069216364160323`*^9, 3.8069217091358523`*^9}, {
  3.806928623145379*^9, 3.8069286744083033`*^9}, {3.8254383155694427`*^9, 
  3.8254383547919064`*^9}, {3.825438388650114*^9, 3.8254384840975*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"7484d534-72e7-4c65-ac16-1792a0c50685"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8069286589654474`*^9, 3.8069286756885138`*^9}, {
   3.825438326108514*^9, 3.8254383280888767`*^9}, 3.825438361346834*^9, {
   3.8254384082680264`*^9, 3.8254384844843826`*^9}, 3.82543875194779*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"4bc3af18-9432-4192-8ba2-936ddc32f7ee"]
}, Open  ]],

Cell["2.3.23", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867951320154*^9, 
  3.8068679730579786`*^9}, {3.8069291018440585`*^9, 3.8069291034367557`*^9}, {
  3.8073704262968583`*^9, 3.8073704273311214`*^9}, {3.807378052002387*^9, 
  3.8073780525616336`*^9}},ExpressionUUID->"7328b555-72f7-4950-8b7a-\
d5392dc35039"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "2"], "-", "t", "-", "2"}], "\[Equal]", "0"}], ",", 
   "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.8069303037180147`*^9, 3.806930321526229*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"d08457d4-17e2-4fe7-bbbc-2b491cb8d8ee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8069303258700247`*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"19b0d32f-8344-4148-b8ef-22c1f48e29c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"b1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "1"]}], "+", 
       RowBox[{"b2", " ", 
        SuperscriptBox["2", "1"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"b1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "2"]}], "+", 
       RowBox[{"b2", " ", 
        SuperscriptBox["2", "2"]}]}], "\[Equal]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069303300171633`*^9, 3.8069303861185675`*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"7d28a27c-fcb1-4856-b394-eafc694cc628"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", 
     FractionBox["1", "3"]}], ",", 
    RowBox[{"b2", "\[Rule]", 
     FractionBox["2", "3"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8069303893250027`*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"bf1da639-c8ce-4067-a0c1-4d6eae190218"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "="}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7dcd8f2b-6f44-479a-8478-c29134c49267"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
   RowBox[{
    FractionBox["2", "3"], 
    SuperscriptBox["2", "n"]}]}]],
  CellChangeTimes->{{3.8069214298117714`*^9, 3.8069214314468737`*^9}, {
   3.806921525064637*^9, 3.8069215544313593`*^9}},ExpressionUUID->
  "28635af5-4191-4023-ba4a-0042d61ab43c"]
}], "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867935170189*^9, 
  3.8068679353858957`*^9}, {3.806921576295984*^9, 3.806921612315504*^9}, {
  3.8069221727299576`*^9, 3.8069221959813805`*^9}, {3.806926277545978*^9, 
  3.8069263537673683`*^9}, {3.806926503906173*^9, 3.8069265074426804`*^9}, {
  3.8069270592676926`*^9, 3.806927109580974*^9}, {3.8069276448116617`*^9, 
  3.806927710444867*^9}, {3.8069283773512735`*^9, 3.8069285009282217`*^9}, {
  3.8069304136785183`*^9, 
  3.806930460616352*^9}},ExpressionUUID->"888ca18a-cf42-47bb-9f4f-\
f31082412708"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", "n"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", "n", ",", "b"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8069304706274333`*^9, 3.806930488052831*^9}, {
  3.8069307184926004`*^9, 3.8069307197894382`*^9}, {3.8069308670401993`*^9, 
  3.8069308973829503`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"a9749433-97fb-4e64-a9ac-21d4b51089cb"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "n"], "+", 
    SuperscriptBox["2", 
     RowBox[{"1", "+", "n"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{3.806930898086377*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"c79317fe-2316-45c1-9106-e71ea78f1975"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "2"}], "-", "n", "+", 
    SuperscriptBox["n", "2"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", -2 - \
$CellContext`n + $CellContext`n^2, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.80693089808937*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[64]:=",ExpressionUUID->"61bc86ab-bfac-40b5-ab27-0e010eb4c727"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {-1, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.806930898091364*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[64]:=",ExpressionUUID->"79a83800-6cc0-4b3b-9cea-2e115afeec02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "n"], " ", 
     SubscriptBox["b", "1"]}], "+", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     SubscriptBox["b", "2"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", (-1)^$CellContext`n Subscript[$CellContext`b, 1] + 
   2^$CellContext`n Subscript[$CellContext`b, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069308980943546`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[64]:=",ExpressionUUID->"b58e2945-a0c1-4bd4-b8b5-111781908a8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["b", "1"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["b", "2"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"4", " ", 
        SubscriptBox["b", "2"]}]}], "\[Equal]", "3"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {-
      Subscript[$CellContext`b, 1] + 2 Subscript[$CellContext`b, 2] == 1, 
    Subscript[$CellContext`b, 1] + 4 Subscript[$CellContext`b, 2] == 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069308980963492`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[64]:=",ExpressionUUID->"c454cdd5-bedd-4fb3-9a44-9fc76d657410"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", 
      FractionBox["1", "3"]}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      FractionBox["2", "3"]}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> Rational[1, 3], 
    Subscript[$CellContext`b, 2] -> Rational[2, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069308980973473`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[64]:=",ExpressionUUID->"0048aca7-bdd3-4f8c-beb8-dc6c1376da10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], "+", 
      SuperscriptBox["2", 
       RowBox[{"1", "+", "n"}]]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[1, 3] ((-1)^$CellContext`n + 2^(1 + $CellContext`n))],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069308980993595`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[64]:=",ExpressionUUID->"52835e8b-10b3-44c7-bf59-940f267d55b9"]
}, Open  ]]
}, Open  ]],

Cell["2.3.24", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867951320154*^9, 
  3.8068679750484467`*^9}, {3.807370434782498*^9, 3.8073704350739346`*^9}, {
  3.807378057986605*^9, 
  3.8073780586155176`*^9}},ExpressionUUID->"0b7b1f49-11d8-4191-bc8b-\
3a359986865c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", "1.012", "}"}], ",", 
   RowBox[{"{", "7.1", "}"}], ",", "n", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069313904572897`*^9, 3.8069314354396706`*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"bb7cfbed-5982-4bf4-aac5-fe42a4dfaa95"],

Cell[BoxData[
 RowBox[{"7.1`", " ", 
  SuperscriptBox["0.9881422924901185`", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "n"}]]}]], "Output",
 CellChangeTimes->{3.8069314361934443`*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"f43d1745-51f2-4e4a-9e1c-627f8d219315"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"2003", "+", "i"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "47"}], "}"}]}], "]"}], "//", 
  "Last"}]], "Input",
 CellChangeTimes->{{3.806931127665175*^9, 3.806931194248232*^9}, {
  3.8069312280544376`*^9, 3.8069312307012634`*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"8212cc49-4696-4f61-8595-67912eaa1ced"],

Cell[BoxData[
 RowBox[{"47", "\[Rule]", "2050"}]], "Output",
 CellChangeTimes->{{3.8069311810271473`*^9, 3.806931194696781*^9}, 
   3.8069312314203415`*^9, {3.8069316569554715`*^9, 3.8069316760058413`*^9}},
 CellLabel->"Out[74]=",ExpressionUUID->"9d9380d1-fa7d-4adb-a40c-a6ca7f05b899"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", "1.012", ")"}], "n"], "7.1"}]}], "\[IndentingNewLine]", 
 RowBox[{"a", "[", "47", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{"7.1`", " ", 
   SuperscriptBox["0.9881422924901185`", 
    RowBox[{
     RowBox[{"-", "1.`"}], " ", "n"}]]}]}], "\[IndentingNewLine]", 
 RowBox[{"a", "[", "47", "]"}]}], "Input",
 CellChangeTimes->{{3.806931448373682*^9, 3.8069314702008905`*^9}, {
  3.806931773576885*^9, 3.8069317748709764`*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"7686d8c7-5b19-4345-b822-8a8202fa1ec4"],

Cell[BoxData["12.437767561243842`"], "Output",
 CellChangeTimes->{3.8069314707495604`*^9, 3.8069317758852854`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"4984746c-aad3-4bd1-8897-154a46874217"],

Cell[BoxData["12.437767561243874`"], "Output",
 CellChangeTimes->{3.8069314707495604`*^9, 3.806931775888277*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"794f2f43-0e7b-4d9f-9993-91034ad498c3"]
}, Open  ]],

Cell["2.3.25", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867951320154*^9, 
  3.806867999618937*^9}, {3.807370440497746*^9, 3.8073704407896495`*^9}, {
  3.807378063094877*^9, 
  3.807378063652528*^9}},ExpressionUUID->"4088d070-967b-48ed-abe8-\
f33ca69373f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "RRCP"}]], "Input",
 CellChangeTimes->{{3.8069319968308034`*^9, 3.8069320027998247`*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"61476a05-d6ee-4b47-9cfb-456ed8fa0f48"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Resuelve distintos casos de una relaci\[OAcute]n de \
recurrencia lineal no homog\[EAcute]nea, donde la parte no homog\[EAcute]nea \
depende de un par\[AAcute]metro \[OpenCurlyDoubleQuote]j\
\[CloseCurlyDoubleQuote]. Sintaxis: RRCP[Coeficientes, Condiciones, n, m] con \
\[OpenCurlyDoubleQuote]Coeficientes\[CloseCurlyDoubleQuote] un vector de \
coeficientes en orden descendente, que contiene la parte no homog\[EAcute]nea \
(en funci\[OAcute]n de \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]) de \
la relaci\[OAcute]n de recurrencia como su \[UAcute]ltima componente, \
\[OpenCurlyDoubleQuote]Condiciones\[CloseCurlyDoubleQuote] la lista de \
condiciones iniciales en orden ascendente y \[OpenCurlyDoubleQuote]m\
\[CloseCurlyDoubleQuote] la cantidad de casos a evaluar. El tercer argumento \
indica la variable mediante la cual se visualizar\[AAcute]n las soluciones. \
Por defecto, se admite el dominio como el conjunto de los n\[UAcute]meros \
naturales (no incluye el cero) y el par\[AAcute]metro involucrado con el \
identificador \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote]. El comando \
posee la opci\[OAcute]n \[OpenCurlyDoubleQuote]decimal->True\
\[CloseCurlyDoubleQuote] que muestra el resultado con un formato decimal, en \
principio \[OpenCurlyDoubleQuote]decimal\[CloseCurlyDoubleQuote] tiene el \
valor l\[OAcute]gico \[OpenCurlyDoubleQuote]False\[CloseCurlyDoubleQuote]. \
Adem\[AAcute]s, \[OpenCurlyDoubleQuote]inicio->Valor\[CloseCurlyDoubleQuote] \
comienza las condiciones iniciales con \[IAcute]ndice en \
\[OpenCurlyDoubleQuote]Valor\[CloseCurlyDoubleQuote]. En arranque \
\[OpenCurlyDoubleQuote]Valor=1\[CloseCurlyDoubleQuote].\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"RRCP", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenci_List", ",", 
                    "VilCretas`Private`RcCondicione_List", ",", 
                    "VilCretas`Private`Rcso_", ",", 
                    "VilCretas`Private`Rccaso_", ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{
                    "{", "VilCretas`Private`VerificandoParametroQ", "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`VerificandoParametroQ", "[", 
                    "VilCretas`Private`RcParametro_", "]"}], ":=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    RowBox[{"Solve", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcParametro", "\[Equal]", 
                    "VilCretas`Private`RcParametro"}], ",", 
                    "VilCretas`Private`RcParametro"}], "]"}], "]"}], ",", 
                    "True", ",", "False"}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`VerificandoParametroQ", "[", 
                    "VilCretas`Private`Rcso", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilCretas`Private`Rcso", "]"}], 
                    "\[Equal]", "False"}], "&&", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilCretas`Private`Rcso", "]"}], 
                    "\[Equal]", "False"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`Rccaso", "]"}], "&&", 
                    RowBox[{
                    "VilCretas`Private`Rccaso", "\[GreaterEqual]", "1"}]}], 
                    ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RRC", ",", "VilCretas`Private`RRCD"}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    RowBox[{"n", ",", "j"}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RRC", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrencia_List", ",", 
                    "VilCretas`Private`RcCondiciones_List", ",", 
                    "VilCretas`Private`Rcsol_", ",", 
                    "VilCretas`Private`Rccasos_", ",", 
                    "VilCretas`Private`Rcinicio_"}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilCretas`Private`Rcsol", "]"}], 
                    "\[Equal]", "False"}], "&&", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilCretas`Private`Rcsol", "]"}],
                     "\[Equal]", "False"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrencia", ",", 
                    "VilCretas`Private`RcCondiciones", ",", 
                    "VilCretas`Private`Rcsol"}], "}"}], ",", "Null"}], "]"}], 
                    "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VectorQ", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "&&", 
                    RowBox[{
                    "VectorQ", "[", "VilCretas`Private`RcCondiciones", 
                    "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcRecurrencia", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], "&&", 
                    RowBox[{"VilCretas`Private`RcCondiciones", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`RcRecurrencia", ",", "Null"}], 
                    "]"}], "\[Equal]", "False"}], "&&", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`RcCondiciones", ",", "Null"}], 
                    "]"}], "\[Equal]", "False"}]}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", "VilCretas`Private`Rcsol", "]"}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilCretas`Private`RcVl22", "=", 
                    RowBox[{"Variables", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"VilCretas`Private`RcVl23", "=", 
                    RowBox[{
                    RowBox[{
                    "Variables", "[", "VilCretas`Private`Rcsol", "]"}], 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ",", "VilCretas`Private`RcLastSuma5"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", "VilCretas`Private`Rca4", "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcVl22", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilCretas`Private`RcVl22", "=", 
                    RowBox[{"Reverse", "[", 
                    RowBox[{"Variables", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], ",", "\<\"n\"\>"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], ",", "\<\"j\"\>"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "-", "1"}], "\[Equal]", 
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcCondiciones", "]"}]}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcVl24", "=", 
                    RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], 
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "-", "1"}]], 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcRecurrencia", "\[LeftDoubleBracket]",
                     "VilCretas`Private`Rci15", "\[RightDoubleBracket]"}], 
                    " ", 
                    RowBox[{"VilCretas`Private`Rca4", "[", 
                    RowBox[{
                    "VilCretas`Private`RcVl23", "-", 
                    "VilCretas`Private`Rci15"}], "]"}]}]}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcLastSuma5", "[", 
                    "VilCretas`Private`Rci_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"Together", "[", 
                    RowBox[{"Expand", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], "]"}], "/.", "\[VeryThinSpace]", 
                    RowBox[{"n", "\[Rule]", "VilCretas`Private`Rci"}]}]}], 
                    ";", 
                    RowBox[{"VilCretas`Private`RcVl24", "=", 
                    RowBox[{"VilCretas`Private`RcVl24", "+", 
                    RowBox[{
                    "VilCretas`Private`RcLastSuma5", "[", 
                    "VilCretas`Private`RcVl23", "]"}]}]}], ";", 
                    RowBox[{"VilCretas`Private`RcVl24", "=", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rca4", "[", "VilCretas`Private`RcVl23",
                     "]"}], "\[Equal]", "VilCretas`Private`RcVl24"}]}], ";", 
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{
                    "VilCretas`Private`RcList5", ",", 
                    "VilCretas`Private`RcVl24"}], "]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], ",", 
                    RowBox[{"VilCretas`Private`Rci15", "\[LessEqual]", 
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcCondiciones", "]"}]}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilCretas`Private`RcList5", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilCretas`Private`Rca4", "]"}], 
                    "<>", "\<\"[\"\>", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`Rci15", "+", 
                    "VilCretas`Private`Rcinicio", "-", "1"}], "]"}], 
                    "<>", "\<\"]==\"\>", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`RcCondiciones", 
                    "\[LeftDoubleBracket]", "VilCretas`Private`Rci15", 
                    "\[RightDoubleBracket]"}], "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`Rci15", "++"}]}]}], "]"}], ";", 
                    RowBox[{"Clear", "[", "VilCretas`Private`Rci15", "]"}], 
                    ";", 
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{
                    "VilCretas`Private`RcList5", "/.", "\[VeryThinSpace]", 
                    RowBox[{"j", "\[Rule]", "VilCretas`Private`Rci15"}]}]}], 
                    ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], ",", 
                    RowBox[{
                    "VilCretas`Private`Rci15", "\[LessEqual]", 
                    "VilCretas`Private`Rccasos"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcSolucion3", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"RSolve", "[", 
                    RowBox[{"VilCretas`Private`RcList5", ",", 
                    RowBox[{
                    "VilCretas`Private`Rca4", "[", "VilCretas`Private`RcVl23",
                     "]"}], ",", "VilCretas`Private`RcVl23"}], "]"}], "]"}]}],
                     ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"Caso \"\>", ",", "VilCretas`Private`Rci15", 
                    ",", "\<\": \"\>", ",", 
                    RowBox[{
                    RowBox[{
                    "Flatten", "[", "VilCretas`Private`RcSolucion3", "]"}], 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilCretas`Private`Rci15", "++"}]}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], ",", "\<\"j\"\>"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "-", "1"}], "\[Equal]", 
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcCondiciones", "]"}]}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcVl24", "=", 
                    RowBox[{
                    RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], 
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "-", "1"}]], 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcRecurrencia", "\[LeftDoubleBracket]",
                     "VilCretas`Private`Rci15", "\[RightDoubleBracket]"}], 
                    " ", 
                    RowBox[{"VilCretas`Private`Rca4", "[", 
                    RowBox[{
                    "VilCretas`Private`RcVl23", "-", 
                    "VilCretas`Private`Rci15"}], "]"}]}]}], "+", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}]}]}],
                     ";", 
                    RowBox[{"VilCretas`Private`RcVl24", "=", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rca4", "[", "VilCretas`Private`RcVl23",
                     "]"}], "\[Equal]", "VilCretas`Private`RcVl24"}]}], ";", 
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{
                    "VilCretas`Private`RcList5", ",", 
                    "VilCretas`Private`RcVl24"}], "]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], ",", 
                    RowBox[{"VilCretas`Private`Rci15", "\[LessEqual]", 
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcCondiciones", "]"}]}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilCretas`Private`RcList5", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilCretas`Private`Rca4", "]"}], 
                    "<>", "\<\"[\"\>", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`Rci15", "+", 
                    "VilCretas`Private`Rcinicio", "-", "1"}], "]"}], 
                    "<>", "\<\"]==\"\>", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RcCondiciones", "\[LeftDoubleBracket]",
                     "VilCretas`Private`Rci15", "\[RightDoubleBracket]"}], 
                    "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`Rci15", "++"}]}]}], "]"}], ";", 
                    RowBox[{"Clear", "[", "VilCretas`Private`Rci15", "]"}], 
                    ";", 
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{
                    "VilCretas`Private`RcList5", "/.", "\[VeryThinSpace]", 
                    RowBox[{"j", "\[Rule]", "VilCretas`Private`Rci15"}]}]}], 
                    ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], ",", 
                    RowBox[{
                    "VilCretas`Private`Rci15", "\[LessEqual]", 
                    "VilCretas`Private`Rccasos"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcSolucion3", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"RSolve", "[", 
                    RowBox[{"VilCretas`Private`RcList5", ",", 
                    RowBox[{
                    "VilCretas`Private`Rca4", "[", "VilCretas`Private`RcVl23",
                     "]"}], ",", "VilCretas`Private`RcVl23"}], "]"}], "]"}]}],
                     ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"Caso \"\>", ",", "VilCretas`Private`Rci15", 
                    ",", "\<\": \"\>", ",", 
                    RowBox[{
                    RowBox[{
                    "Flatten", "[", "VilCretas`Private`RcSolucion3", "]"}], 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilCretas`Private`Rci15", "++"}]}]}], "]"}]}]}], 
                    "]"}]}], "]"}]}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RRCD", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrencia_List", ",", 
                    "VilCretas`Private`RcCondiciones_List", ",", 
                    "VilCretas`Private`Rcsol_", ",", 
                    "VilCretas`Private`Rccasos_", ",", 
                    "VilCretas`Private`Rcinicio_"}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilCretas`Private`Rcsol", "]"}], 
                    "\[Equal]", "False"}], "&&", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilCretas`Private`Rcsol", "]"}],
                     "\[Equal]", "False"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrencia", ",", 
                    "VilCretas`Private`RcCondiciones", ",", 
                    "VilCretas`Private`Rcsol"}], "}"}], ",", "Null"}], "]"}], 
                    "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VectorQ", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "&&", 
                    RowBox[{
                    "VectorQ", "[", "VilCretas`Private`RcCondiciones", 
                    "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcRecurrencia", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], "&&", 
                    RowBox[{"VilCretas`Private`RcCondiciones", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`RcRecurrencia", ",", "Null"}], 
                    "]"}], "\[Equal]", "False"}], "&&", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`RcCondiciones", ",", "Null"}], 
                    "]"}], "\[Equal]", "False"}]}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", "VilCretas`Private`Rcsol", "]"}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilCretas`Private`RcVl22", "=", 
                    RowBox[{"Variables", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"VilCretas`Private`RcVl23", "=", 
                    RowBox[{
                    RowBox[{"Variables", "[", "VilCretas`Private`Rcsol", 
                    "]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    "VilCretas`Private`RcLastSuma5"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", "VilCretas`Private`Rca4", "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcVl22", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilCretas`Private`RcVl22", "=", 
                    RowBox[{"Reverse", "[", 
                    RowBox[{"Variables", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], ",", "\<\"n\"\>"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], ",", "\<\"j\"\>"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "-", "1"}], "\[Equal]", 
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcCondiciones", "]"}]}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcVl24", "=", 
                    RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], 
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "-", "1"}]], 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcRecurrencia", "\[LeftDoubleBracket]",
                     "VilCretas`Private`Rci15", "\[RightDoubleBracket]"}], 
                    " ", 
                    RowBox[{"VilCretas`Private`Rca4", "[", 
                    RowBox[{
                    "VilCretas`Private`RcVl23", "-", 
                    "VilCretas`Private`Rci15"}], "]"}]}]}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcLastSuma5", "[", 
                    "VilCretas`Private`Rci_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"Together", "[", 
                    RowBox[{"Expand", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], "]"}], "/.", "\[VeryThinSpace]", 
                    RowBox[{"n", "\[Rule]", "VilCretas`Private`Rci"}]}]}], 
                    ";", 
                    RowBox[{"VilCretas`Private`RcVl24", "=", 
                    RowBox[{"VilCretas`Private`RcVl24", "+", 
                    RowBox[{
                    "VilCretas`Private`RcLastSuma5", "[", 
                    "VilCretas`Private`RcVl23", "]"}]}]}], ";", 
                    RowBox[{"VilCretas`Private`RcVl24", "=", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rca4", "[", "VilCretas`Private`RcVl23",
                     "]"}], "\[Equal]", "VilCretas`Private`RcVl24"}]}], ";", 
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{
                    "VilCretas`Private`RcList5", ",", 
                    "VilCretas`Private`RcVl24"}], "]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], ",", 
                    RowBox[{"VilCretas`Private`Rci15", "\[LessEqual]", 
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcCondiciones", "]"}]}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilCretas`Private`RcList5", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilCretas`Private`Rca4", "]"}], 
                    "<>", "\<\"[\"\>", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`Rci15", "+", 
                    "VilCretas`Private`Rcinicio", "-", "1"}], "]"}], 
                    "<>", "\<\"]==\"\>", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RcCondiciones", "\[LeftDoubleBracket]",
                     "VilCretas`Private`Rci15", "\[RightDoubleBracket]"}], 
                    "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`Rci15", "++"}]}]}], "]"}], ";", 
                    RowBox[{"Clear", "[", "VilCretas`Private`Rci15", "]"}], 
                    ";", 
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{
                    "VilCretas`Private`RcList5", "/.", "\[VeryThinSpace]", 
                    RowBox[{"j", "\[Rule]", "VilCretas`Private`Rci15"}]}]}], 
                    ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], ",", 
                    RowBox[{
                    "VilCretas`Private`Rci15", "\[LessEqual]", 
                    "VilCretas`Private`Rccasos"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcSolucion3", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"RSolve", "[", 
                    RowBox[{"VilCretas`Private`RcList5", ",", 
                    RowBox[{
                    "VilCretas`Private`Rca4", "[", "VilCretas`Private`RcVl23",
                     "]"}], ",", "VilCretas`Private`RcVl23"}], "]"}], "]"}]}],
                     ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"Caso \"\>", ",", "VilCretas`Private`Rci15", 
                    ",", "\<\": \"\>", ",", 
                    RowBox[{"N", "[", 
                    RowBox[{
                    RowBox[{
                    "Flatten", "[", "VilCretas`Private`RcSolucion3", "]"}], 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"VilCretas`Private`Rci15", "++"}]}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "]"}], ",", "\<\"j\"\>"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "-", "1"}], "\[Equal]", 
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcCondiciones", "]"}]}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcVl24", "=", 
                    RowBox[{
                    RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], 
                    RowBox[{
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcRecurrencia", "]"}], 
                    "-", "1"}]], 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RcRecurrencia", "\[LeftDoubleBracket]",
                     "VilCretas`Private`Rci15", "\[RightDoubleBracket]"}], 
                    " ", 
                    RowBox[{"VilCretas`Private`Rca4", "[", 
                    RowBox[{
                    "VilCretas`Private`RcVl23", "-", 
                    "VilCretas`Private`Rci15"}], "]"}]}]}], "+", 
                    RowBox[{
                    "Last", "[", "VilCretas`Private`RcRecurrencia", "]"}]}]}],
                     ";", 
                    RowBox[{"VilCretas`Private`RcVl24", "=", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rca4", "[", "VilCretas`Private`RcVl23",
                     "]"}], "\[Equal]", "VilCretas`Private`RcVl24"}]}], ";", 
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{
                    "VilCretas`Private`RcList5", ",", 
                    "VilCretas`Private`RcVl24"}], "]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], ",", 
                    RowBox[{"VilCretas`Private`Rci15", "\[LessEqual]", 
                    RowBox[{
                    "Length", "[", "VilCretas`Private`RcCondiciones", "]"}]}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilCretas`Private`RcList5", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VilCretas`Private`Rca4", "]"}], 
                    "<>", "\<\"[\"\>", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`Rci15", "+", 
                    "VilCretas`Private`Rcinicio", "-", "1"}], "]"}], 
                    "<>", "\<\"]==\"\>", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RcCondiciones", "\[LeftDoubleBracket]",
                     "VilCretas`Private`Rci15", "\[RightDoubleBracket]"}], 
                    "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`Rci15", "++"}]}]}], "]"}], ";", 
                    RowBox[{"Clear", "[", "VilCretas`Private`Rci15", "]"}], 
                    ";", 
                    RowBox[{"VilCretas`Private`RcList5", "=", 
                    RowBox[{
                    "VilCretas`Private`RcList5", "/.", "\[VeryThinSpace]", 
                    RowBox[{"j", "\[Rule]", "VilCretas`Private`Rci15"}]}]}], 
                    ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rci15", "=", "1"}], ",", 
                    RowBox[{
                    "VilCretas`Private`Rci15", "\[LessEqual]", 
                    "VilCretas`Private`Rccasos"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RcSolucion3", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"RSolve", "[", 
                    RowBox[{"VilCretas`Private`RcList5", ",", 
                    RowBox[{
                    "VilCretas`Private`Rca4", "[", "VilCretas`Private`RcVl23",
                     "]"}], ",", "VilCretas`Private`RcVl23"}], "]"}], "]"}]}],
                     ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"Caso \"\>", ",", "VilCretas`Private`Rci15", 
                    ",", "\<\": \"\>", ",", 
                    RowBox[{"N", "[", 
                    RowBox[{
                    RowBox[{
                    "Flatten", "[", "VilCretas`Private`RcSolucion3", "]"}], 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"VilCretas`Private`Rci15", "++"}]}]}], "]"}]}]}], 
                    "]"}]}], "]"}]}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"IntegerQ", "[", 
                    RowBox[{"OptionValue", "[", "inicio", "]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "inicio", "]"}], 
                    "\[GreaterEqual]", "0"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "decimal", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "decimal", "]"}], ",", 
                    RowBox[{"VilCretas`Private`RRCD", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenci", ",", 
                    "VilCretas`Private`RcCondicione", ",", 
                    "VilCretas`Private`Rcso", ",", "VilCretas`Private`Rccaso",
                     ",", 
                    RowBox[{"OptionValue", "[", "inicio", "]"}]}], "]"}], ",", 
                    RowBox[{"VilCretas`Private`RRC", "[", 
                    RowBox[{
                    "VilCretas`Private`RcRecurrenci", ",", 
                    "VilCretas`Private`RcCondicione", ",", 
                    "VilCretas`Private`Rcso", ",", "VilCretas`Private`Rccaso",
                     ",", 
                    RowBox[{"OptionValue", "[", "inicio", "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"decimal", "\[Rule]", "False"}], ",", 
                    RowBox[{"inicio", "\[Rule]", "1"}]}], "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`RRCP\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Resuelve distintos casos de una relaci\[OAcute]n de \
recurrencia lineal no homog\[EAcute]nea, donde la parte no homog\[EAcute]nea \
depende de un par\[AAcute]metro \[OpenCurlyDoubleQuote]j\
\[CloseCurlyDoubleQuote]. Sintaxis: RRCP[Coeficientes, Condiciones, n, m] con \
\[OpenCurlyDoubleQuote]Coeficientes\[CloseCurlyDoubleQuote] un vector de \
coeficientes en orden descendente, que contiene la parte no homog\[EAcute]nea \
(en funci\[OAcute]n de \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]) de \
la relaci\[OAcute]n de recurrencia como su \[UAcute]ltima componente, \
\[OpenCurlyDoubleQuote]Condiciones\[CloseCurlyDoubleQuote] la lista de \
condiciones iniciales en orden ascendente y \[OpenCurlyDoubleQuote]m\
\[CloseCurlyDoubleQuote] la cantidad de casos a evaluar. El tercer argumento \
indica la variable mediante la cual se visualizar\[AAcute]n las soluciones. \
Por defecto, se admite el dominio como el conjunto de los n\[UAcute]meros \
naturales (no incluye el cero) y el par\[AAcute]metro involucrado con el \
identificador \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote]. El comando \
posee la opci\[OAcute]n \[OpenCurlyDoubleQuote]decimal->True\
\[CloseCurlyDoubleQuote] que muestra el resultado con un formato decimal, en \
principio \[OpenCurlyDoubleQuote]decimal\[CloseCurlyDoubleQuote] tiene el \
valor l\[OAcute]gico \[OpenCurlyDoubleQuote]False\[CloseCurlyDoubleQuote]. \
Adem\[AAcute]s, \[OpenCurlyDoubleQuote]inicio->Valor\[CloseCurlyDoubleQuote] \
comienza las condiciones iniciales con \[IAcute]ndice en \
\[OpenCurlyDoubleQuote]Valor\[CloseCurlyDoubleQuote]. En arranque \
\[OpenCurlyDoubleQuote]Valor=1\[CloseCurlyDoubleQuote].\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{15., {5., 10.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{15., {5., 10.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Resuelve distintos casos de una relaci\[OAcute]n de recurrencia lineal \
no homog\[EAcute]nea, donde la parte no homog\[EAcute]nea depende de un par\
\[AAcute]metro \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote]. Sintaxis: \
RRCP[Coeficientes, Condiciones, n, m] con \[OpenCurlyDoubleQuote]Coeficientes\
\[CloseCurlyDoubleQuote] un vector de coeficientes en orden descendente, que \
contiene la parte no homog\[EAcute]nea (en funci\[OAcute]n de \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]) de la relaci\[OAcute]n de \
recurrencia como su \[UAcute]ltima componente, \
\[OpenCurlyDoubleQuote]Condiciones\[CloseCurlyDoubleQuote] la lista de \
condiciones iniciales en orden ascendente y \[OpenCurlyDoubleQuote]m\
\[CloseCurlyDoubleQuote] la cantidad de casos a evaluar. El tercer argumento \
indica la variable mediante la cual se visualizar\[AAcute]n las soluciones. \
Por defecto, se admite el dominio como el conjunto de los n\[UAcute]meros \
naturales (no incluye el cero) y el par\[AAcute]metro involucrado con el \
identificador \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote]. El comando \
posee la opci\[OAcute]n \[OpenCurlyDoubleQuote]decimal->True\
\[CloseCurlyDoubleQuote] que muestra el resultado con un formato decimal, en \
principio \[OpenCurlyDoubleQuote]decimal\[CloseCurlyDoubleQuote] tiene el \
valor l\[OAcute]gico \[OpenCurlyDoubleQuote]False\[CloseCurlyDoubleQuote]. \
Adem\[AAcute]s, \[OpenCurlyDoubleQuote]inicio->Valor\[CloseCurlyDoubleQuote] \
comienza las condiciones iniciales con \[IAcute]ndice en \
\[OpenCurlyDoubleQuote]Valor\[CloseCurlyDoubleQuote]. En arranque \
\[OpenCurlyDoubleQuote]Valor=1\[CloseCurlyDoubleQuote].", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`RRCP, {VilCretas`RRCP[
         Pattern[VilCretas`Private`RcRecurrenci, 
          Blank[List]], 
         Pattern[VilCretas`Private`RcCondicione, 
          Blank[List]], 
         Pattern[VilCretas`Private`Rcso, 
          Blank[]], 
         Pattern[VilCretas`Private`Rccaso, 
          Blank[]], 
         OptionsPattern[]] :> 
       Module[{VilCretas`Private`VerificandoParametroQ}, 
         VilCretas`Private`VerificandoParametroQ[
            Pattern[VilCretas`Private`RcParametro, 
             Blank[]]] := Quiet[
            If[
             ListQ[
              Solve[
              VilCretas`Private`RcParametro == VilCretas`Private`RcParametro, 
               VilCretas`Private`RcParametro]], True, False]]; If[
           VilCretas`Private`VerificandoParametroQ[VilCretas`Private`Rcso], 
           If[
            And[
            StringQ[VilCretas`Private`Rcso] == False, 
             NumericQ[VilCretas`Private`Rcso] == False], 
            If[
             And[
              IntegerQ[VilCretas`Private`Rccaso], VilCretas`Private`Rccaso >= 
              1], 
             
             Module[{VilCretas`Private`RRC, VilCretas`Private`RRCD}, 
              Clear[$CellContext`n, $CellContext`j]; VilCretas`Private`RRC[
                 Pattern[VilCretas`Private`RcRecurrencia, 
                  Blank[List]], 
                 Pattern[VilCretas`Private`RcCondiciones, 
                  Blank[List]], 
                 Pattern[VilCretas`Private`Rcsol, 
                  Blank[]], 
                 Pattern[VilCretas`Private`Rccasos, 
                  Blank[]], 
                 Pattern[VilCretas`Private`Rcinicio, 
                  Blank[]]] := If[
                 And[
                 StringQ[VilCretas`Private`Rcsol] == False, 
                  NumericQ[VilCretas`Private`Rcsol] == False], 
                 If[
                 MemberQ[{
                    VilCretas`Private`RcRecurrencia, 
                    VilCretas`Private`RcCondiciones, VilCretas`Private`Rcsol},
                     Null] == False, 
                  If[
                   And[
                    VectorQ[VilCretas`Private`RcRecurrencia], 
                    VectorQ[VilCretas`Private`RcCondiciones]], 
                   If[
                    And[
                    VilCretas`Private`RcRecurrencia != {}, 
                    VilCretas`Private`RcCondiciones != {}], 
                    If[
                    And[
                    MemberQ[VilCretas`Private`RcRecurrencia, Null] == False, 
                    MemberQ[VilCretas`Private`RcCondiciones, Null] == False], 
                    Clear[VilCretas`Private`Rcsol]; 
                    Module[{
                    VilCretas`Private`RcList5 = {}, VilCretas`Private`RcVl22 = 
                    Variables[
                    Last[VilCretas`Private`RcRecurrencia]], 
                    VilCretas`Private`RcVl23 = Part[
                    Variables[VilCretas`Private`Rcsol], 1], 
                    VilCretas`Private`RcLastSuma5}, 
                    Clear[VilCretas`Private`Rca4]; 
                    If[VilCretas`Private`RcVl22 != {}, 
                    VilCretas`Private`RcVl22 = Reverse[
                    Variables[
                    Last[VilCretas`Private`RcRecurrencia]]]]; If[
                    StringContainsQ[
                    ToString[
                    Last[VilCretas`Private`RcRecurrencia]], "n"], 
                    If[
                    StringContainsQ[
                    ToString[
                    Last[VilCretas`Private`RcRecurrencia]], "j"], 
                    If[
                    Length[VilCretas`Private`RcRecurrencia] - 1 == 
                    Length[VilCretas`Private`RcCondiciones], 
                    VilCretas`Private`RcVl24 = 
                    Sum[Part[VilCretas`Private`RcRecurrencia, 
                    VilCretas`Private`Rci15] 
                    VilCretas`Private`Rca4[
                    VilCretas`Private`RcVl23 - VilCretas`Private`Rci15], {
                    VilCretas`Private`Rci15, 1, 
                    Length[VilCretas`Private`RcRecurrencia] - 1}]; 
                    VilCretas`Private`RcLastSuma5[
                    Pattern[VilCretas`Private`Rci, 
                    Blank[]]] := ReplaceAll[
                    Together[
                    Expand[
                    Last[VilCretas`Private`RcRecurrencia]]], $CellContext`n -> 
                    VilCretas`Private`Rci]; 
                    VilCretas`Private`RcVl24 = 
                    VilCretas`Private`RcVl24 + 
                    VilCretas`Private`RcLastSuma5[VilCretas`Private`RcVl23]; 
                    VilCretas`Private`RcVl24 = 
                    VilCretas`Private`Rca4[VilCretas`Private`RcVl23] == 
                    VilCretas`Private`RcVl24; 
                    VilCretas`Private`RcList5 = 
                    Append[VilCretas`Private`RcList5, 
                    VilCretas`Private`RcVl24]; 
                    For[VilCretas`Private`Rci15 = 1, VilCretas`Private`Rci15 <= 
                    Length[VilCretas`Private`RcCondiciones], 
                    VilCretas`Private`RcList5 = 
                    Append[VilCretas`Private`RcList5, 
                    ToExpression[
                    StringJoin[
                    ToString[VilCretas`Private`Rca4], "[", 
                    ToString[
                    VilCretas`Private`Rci15 + VilCretas`Private`Rcinicio - 1],
                     "]==", 
                    ToString[
                    Part[
                    VilCretas`Private`RcCondiciones, 
                    VilCretas`Private`Rci15]]]]]; 
                    Increment[VilCretas`Private`Rci15]]; 
                    Clear[VilCretas`Private`Rci15]; 
                    VilCretas`Private`RcList5 = 
                    ReplaceAll[
                    VilCretas`Private`RcList5, $CellContext`j -> 
                    VilCretas`Private`Rci15]; 
                    For[VilCretas`Private`Rci15 = 1, VilCretas`Private`Rci15 <= 
                    VilCretas`Private`Rccasos, 
                    VilCretas`Private`RcSolucion3 = Quiet[
                    RSolve[VilCretas`Private`RcList5, 
                    VilCretas`Private`Rca4[VilCretas`Private`RcVl23], 
                    VilCretas`Private`RcVl23]]; 
                    Print["Caso ", VilCretas`Private`Rci15, ": ", 
                    Part[
                    Flatten[VilCretas`Private`RcSolucion3], 1, 2]]; 
                    Increment[VilCretas`Private`Rci15]]]], 
                    If[
                    StringContainsQ[
                    ToString[
                    Last[VilCretas`Private`RcRecurrencia]], "j"], 
                    If[
                    Length[VilCretas`Private`RcRecurrencia] - 1 == 
                    Length[VilCretas`Private`RcCondiciones], 
                    VilCretas`Private`RcVl24 = 
                    Sum[Part[VilCretas`Private`RcRecurrencia, 
                    VilCretas`Private`Rci15] 
                    VilCretas`Private`Rca4[
                    VilCretas`Private`RcVl23 - VilCretas`Private`Rci15], {
                    VilCretas`Private`Rci15, 1, 
                    Length[VilCretas`Private`RcRecurrencia] - 1}] + 
                    Last[VilCretas`Private`RcRecurrencia]; 
                    VilCretas`Private`RcVl24 = 
                    VilCretas`Private`Rca4[VilCretas`Private`RcVl23] == 
                    VilCretas`Private`RcVl24; 
                    VilCretas`Private`RcList5 = 
                    Append[VilCretas`Private`RcList5, 
                    VilCretas`Private`RcVl24]; 
                    For[VilCretas`Private`Rci15 = 1, VilCretas`Private`Rci15 <= 
                    Length[VilCretas`Private`RcCondiciones], 
                    VilCretas`Private`RcList5 = 
                    Append[VilCretas`Private`RcList5, 
                    ToExpression[
                    StringJoin[
                    ToString[VilCretas`Private`Rca4], "[", 
                    ToString[
                    VilCretas`Private`Rci15 + VilCretas`Private`Rcinicio - 1],
                     "]==", 
                    ToString[
                    Part[
                    VilCretas`Private`RcCondiciones, 
                    VilCretas`Private`Rci15]]]]]; 
                    Increment[VilCretas`Private`Rci15]]; 
                    Clear[VilCretas`Private`Rci15]; 
                    VilCretas`Private`RcList5 = 
                    ReplaceAll[
                    VilCretas`Private`RcList5, $CellContext`j -> 
                    VilCretas`Private`Rci15]; 
                    For[VilCretas`Private`Rci15 = 1, VilCretas`Private`Rci15 <= 
                    VilCretas`Private`Rccasos, 
                    VilCretas`Private`RcSolucion3 = Quiet[
                    RSolve[VilCretas`Private`RcList5, 
                    VilCretas`Private`Rca4[VilCretas`Private`RcVl23], 
                    VilCretas`Private`RcVl23]]; 
                    Print["Caso ", VilCretas`Private`Rci15, ": ", 
                    Part[
                    Flatten[VilCretas`Private`RcSolucion3], 1, 2]]; 
                    Increment[VilCretas`Private`Rci15]]]]]]]]]]]; 
              VilCretas`Private`RRCD[
                 Pattern[VilCretas`Private`RcRecurrencia, 
                  Blank[List]], 
                 Pattern[VilCretas`Private`RcCondiciones, 
                  Blank[List]], 
                 Pattern[VilCretas`Private`Rcsol, 
                  Blank[]], 
                 Pattern[VilCretas`Private`Rccasos, 
                  Blank[]], 
                 Pattern[VilCretas`Private`Rcinicio, 
                  Blank[]]] := If[
                 And[
                 StringQ[VilCretas`Private`Rcsol] == False, 
                  NumericQ[VilCretas`Private`Rcsol] == False], 
                 If[
                 MemberQ[{
                    VilCretas`Private`RcRecurrencia, 
                    VilCretas`Private`RcCondiciones, VilCretas`Private`Rcsol},
                     Null] == False, 
                  If[
                   And[
                    VectorQ[VilCretas`Private`RcRecurrencia], 
                    VectorQ[VilCretas`Private`RcCondiciones]], 
                   If[
                    And[
                    VilCretas`Private`RcRecurrencia != {}, 
                    VilCretas`Private`RcCondiciones != {}], 
                    If[
                    And[
                    MemberQ[VilCretas`Private`RcRecurrencia, Null] == False, 
                    MemberQ[VilCretas`Private`RcCondiciones, Null] == False], 
                    Clear[VilCretas`Private`Rcsol]; 
                    Module[{
                    VilCretas`Private`RcList5 = {}, VilCretas`Private`RcVl22 = 
                    Variables[
                    Last[VilCretas`Private`RcRecurrencia]], 
                    VilCretas`Private`RcVl23 = Part[
                    Variables[VilCretas`Private`Rcsol], 1], 
                    VilCretas`Private`RcLastSuma5}, 
                    Clear[VilCretas`Private`Rca4]; 
                    If[VilCretas`Private`RcVl22 != {}, 
                    VilCretas`Private`RcVl22 = Reverse[
                    Variables[
                    Last[VilCretas`Private`RcRecurrencia]]]]; If[
                    StringContainsQ[
                    ToString[
                    Last[VilCretas`Private`RcRecurrencia]], "n"], 
                    If[
                    StringContainsQ[
                    ToString[
                    Last[VilCretas`Private`RcRecurrencia]], "j"], 
                    If[
                    Length[VilCretas`Private`RcRecurrencia] - 1 == 
                    Length[VilCretas`Private`RcCondiciones], 
                    VilCretas`Private`RcVl24 = 
                    Sum[Part[VilCretas`Private`RcRecurrencia, 
                    VilCretas`Private`Rci15] 
                    VilCretas`Private`Rca4[
                    VilCretas`Private`RcVl23 - VilCretas`Private`Rci15], {
                    VilCretas`Private`Rci15, 1, 
                    Length[VilCretas`Private`RcRecurrencia] - 1}]; 
                    VilCretas`Private`RcLastSuma5[
                    Pattern[VilCretas`Private`Rci, 
                    Blank[]]] := ReplaceAll[
                    Together[
                    Expand[
                    Last[VilCretas`Private`RcRecurrencia]]], $CellContext`n -> 
                    VilCretas`Private`Rci]; 
                    VilCretas`Private`RcVl24 = 
                    VilCretas`Private`RcVl24 + 
                    VilCretas`Private`RcLastSuma5[VilCretas`Private`RcVl23]; 
                    VilCretas`Private`RcVl24 = 
                    VilCretas`Private`Rca4[VilCretas`Private`RcVl23] == 
                    VilCretas`Private`RcVl24; 
                    VilCretas`Private`RcList5 = 
                    Append[VilCretas`Private`RcList5, 
                    VilCretas`Private`RcVl24]; 
                    For[VilCretas`Private`Rci15 = 1, VilCretas`Private`Rci15 <= 
                    Length[VilCretas`Private`RcCondiciones], 
                    VilCretas`Private`RcList5 = 
                    Append[VilCretas`Private`RcList5, 
                    ToExpression[
                    StringJoin[
                    ToString[VilCretas`Private`Rca4], "[", 
                    ToString[
                    VilCretas`Private`Rci15 + VilCretas`Private`Rcinicio - 1],
                     "]==", 
                    ToString[
                    Part[
                    VilCretas`Private`RcCondiciones, 
                    VilCretas`Private`Rci15]]]]]; 
                    Increment[VilCretas`Private`Rci15]]; 
                    Clear[VilCretas`Private`Rci15]; 
                    VilCretas`Private`RcList5 = 
                    ReplaceAll[
                    VilCretas`Private`RcList5, $CellContext`j -> 
                    VilCretas`Private`Rci15]; 
                    For[VilCretas`Private`Rci15 = 1, VilCretas`Private`Rci15 <= 
                    VilCretas`Private`Rccasos, 
                    VilCretas`Private`RcSolucion3 = Quiet[
                    RSolve[VilCretas`Private`RcList5, 
                    VilCretas`Private`Rca4[VilCretas`Private`RcVl23], 
                    VilCretas`Private`RcVl23]]; 
                    Print["Caso ", VilCretas`Private`Rci15, ": ", 
                    N[
                    Part[
                    Flatten[VilCretas`Private`RcSolucion3], 1, 2]]]; 
                    Increment[VilCretas`Private`Rci15]]]], 
                    If[
                    StringContainsQ[
                    ToString[
                    Last[VilCretas`Private`RcRecurrencia]], "j"], 
                    If[
                    Length[VilCretas`Private`RcRecurrencia] - 1 == 
                    Length[VilCretas`Private`RcCondiciones], 
                    VilCretas`Private`RcVl24 = 
                    Sum[Part[VilCretas`Private`RcRecurrencia, 
                    VilCretas`Private`Rci15] 
                    VilCretas`Private`Rca4[
                    VilCretas`Private`RcVl23 - VilCretas`Private`Rci15], {
                    VilCretas`Private`Rci15, 1, 
                    Length[VilCretas`Private`RcRecurrencia] - 1}] + 
                    Last[VilCretas`Private`RcRecurrencia]; 
                    VilCretas`Private`RcVl24 = 
                    VilCretas`Private`Rca4[VilCretas`Private`RcVl23] == 
                    VilCretas`Private`RcVl24; 
                    VilCretas`Private`RcList5 = 
                    Append[VilCretas`Private`RcList5, 
                    VilCretas`Private`RcVl24]; 
                    For[VilCretas`Private`Rci15 = 1, VilCretas`Private`Rci15 <= 
                    Length[VilCretas`Private`RcCondiciones], 
                    VilCretas`Private`RcList5 = 
                    Append[VilCretas`Private`RcList5, 
                    ToExpression[
                    StringJoin[
                    ToString[VilCretas`Private`Rca4], "[", 
                    ToString[
                    VilCretas`Private`Rci15 + VilCretas`Private`Rcinicio - 1],
                     "]==", 
                    ToString[
                    Part[
                    VilCretas`Private`RcCondiciones, 
                    VilCretas`Private`Rci15]]]]]; 
                    Increment[VilCretas`Private`Rci15]]; 
                    Clear[VilCretas`Private`Rci15]; 
                    VilCretas`Private`RcList5 = 
                    ReplaceAll[
                    VilCretas`Private`RcList5, $CellContext`j -> 
                    VilCretas`Private`Rci15]; 
                    For[VilCretas`Private`Rci15 = 1, VilCretas`Private`Rci15 <= 
                    VilCretas`Private`Rccasos, 
                    VilCretas`Private`RcSolucion3 = Quiet[
                    RSolve[VilCretas`Private`RcList5, 
                    VilCretas`Private`Rca4[VilCretas`Private`RcVl23], 
                    VilCretas`Private`RcVl23]]; 
                    Print["Caso ", VilCretas`Private`Rci15, ": ", 
                    N[
                    Part[
                    Flatten[VilCretas`Private`RcSolucion3], 1, 2]]]; 
                    Increment[VilCretas`Private`Rci15]]]]]]]]]]]; If[
                And[
                 IntegerQ[
                  OptionValue[VilCretas`inicio]], 
                 OptionValue[VilCretas`inicio] >= 0], 
                If[
                 BooleanQ[
                  OptionValue[VilCretas`decimal]], 
                 If[
                  OptionValue[VilCretas`decimal], 
                  VilCretas`Private`RRCD[
                  VilCretas`Private`RcRecurrenci, 
                   VilCretas`Private`RcCondicione, VilCretas`Private`Rcso, 
                   VilCretas`Private`Rccaso, 
                   OptionValue[VilCretas`inicio]], 
                  VilCretas`Private`RRC[
                  VilCretas`Private`RcRecurrenci, 
                   VilCretas`Private`RcCondicione, VilCretas`Private`Rcso, 
                   VilCretas`Private`Rccaso, 
                   OptionValue[VilCretas`inicio]]]]]]]]]]}], "SubValues" -> 
    None, "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {VilCretas`decimal -> False, VilCretas`inicio -> 1}, 
    "Attributes" -> {Protected}, "FullName" -> "VilCretas`RRCP"], 
   False]]], "Output",
 CellChangeTimes->{3.806932003785226*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"cd3136b1-13f1-44fb-a1f7-878e672dccf7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RRCP", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"2", "j"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "n", ",", "10", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8069318033581095`*^9, 3.8069318037041883`*^9}, {
  3.80693194260739*^9, 3.806931992191168*^9}, {3.8069320245363064`*^9, 
  3.806932077352642*^9}, {3.8069324038695335`*^9, 3.8069324159218645`*^9}, {
  3.806933385575813*^9, 3.8069333987727504`*^9}, {3.806934557929126*^9, 
  3.8069345581315784`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"760a1fdf-0c81-4bc4-b031-514c7b88f149"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    RowBox[{"(", 
     RowBox[{"10", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "2"}], ")"}], "n"], "+", 
      RowBox[{"6", " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 1, ": ", 
   Rational[1, 9] (10 - (-2)^$CellContext`n + 6 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069320269695034`*^9, 3.8069320778657794`*^9}, 
   3.8069322424244566`*^9, 3.8069322792532578`*^9, {3.806932404572656*^9, 
   3.8069324164832287`*^9}, {3.8069333861422977`*^9, 3.806933399221528*^9}, 
   3.8069345588704295`*^9, 3.8069370062735233`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"d0d600ea-02c9-48a1-a4c6-b6e7e716159d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    RowBox[{"(", 
     RowBox[{"12", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "2"}], ")"}], "n"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"2", " ", "n"}]]}], "+", 
      RowBox[{"12", " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 2, ": ", 
   Rational[1, 9] (12 + (-2)^$CellContext`n - 4 (-1)^(2 $CellContext`n) + 
    12 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069320269695034`*^9, 3.8069320778657794`*^9}, 
   3.8069322424244566`*^9, 3.8069322792532578`*^9, {3.806932404572656*^9, 
   3.8069324164832287`*^9}, {3.8069333861422977`*^9, 3.806933399221528*^9}, 
   3.8069345588704295`*^9, 3.8069370063114223`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"47b84ada-731e-4ab1-bf44-97e3be1065f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "2"}], ")"}], "n"], "+", 
      RowBox[{"6", " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 3, ": ", 
   Rational[1, 3] (2 + (-2)^$CellContext`n + 6 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069320269695034`*^9, 3.8069320778657794`*^9}, 
   3.8069322424244566`*^9, 3.8069322792532578`*^9, {3.806932404572656*^9, 
   3.8069324164832287`*^9}, {3.8069333861422977`*^9, 3.806933399221528*^9}, 
   3.8069345588704295`*^9, 3.8069370063403454`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"9962141a-20de-4fa0-a0f3-53ee10c7ce25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    RowBox[{"(", 
     RowBox[{"12", "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}], "n"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"2", " ", "n"}]]}], "+", 
      RowBox[{"24", " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 4, ": ", 
   Rational[1, 9] (12 + 5 (-2)^$CellContext`n - 8 (-1)^(2 $CellContext`n) + 
    24 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069320269695034`*^9, 3.8069320778657794`*^9}, 
   3.8069322424244566`*^9, 3.8069322792532578`*^9, {3.806932404572656*^9, 
   3.8069324164832287`*^9}, {3.8069333861422977`*^9, 3.806933399221528*^9}, 
   3.8069345588704295`*^9, 3.806937006377248*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"df8161e1-c984-4615-8d1c-831434ceea04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"7", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}], "n"]}], "+", 
      RowBox[{"30", " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 5, ": ", 
   Rational[1, 9] (2 + 7 (-2)^$CellContext`n + 30 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069320269695034`*^9, 3.8069320778657794`*^9}, 
   3.8069322424244566`*^9, 3.8069322792532578`*^9, {3.806932404572656*^9, 
   3.8069324164832287`*^9}, {3.8069333861422977`*^9, 3.806933399221528*^9}, 
   3.8069345588704295`*^9, 3.8069370064132333`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"70fa409e-cc97-493f-ae86-b389f808f57c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}], "n"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"2", " ", "n"}]]}], "+", 
      RowBox[{"12", " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 6, ": ", 
   Rational[1, 3] (4 + 3 (-2)^$CellContext`n - 4 (-1)^(2 $CellContext`n) + 
    12 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069320269695034`*^9, 3.8069320778657794`*^9}, 
   3.8069322424244566`*^9, 3.8069322792532578`*^9, {3.806932404572656*^9, 
   3.8069324164832287`*^9}, {3.8069333861422977`*^9, 3.806933399221528*^9}, 
   3.8069345588704295`*^9, 3.806937006451133*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"bbea5fbf-a5ea-4ae0-81f5-d3956d34afdb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}], "n"]}], "+", 
      RowBox[{"42", " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 7, ": ", 
   Rational[1, 9] (-2 + 11 (-2)^$CellContext`n + 42 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069320269695034`*^9, 3.8069320778657794`*^9}, 
   3.8069322424244566`*^9, 3.8069322792532578`*^9, {3.806932404572656*^9, 
   3.8069324164832287`*^9}, {3.8069333861422977`*^9, 3.806933399221528*^9}, 
   3.8069345588704295`*^9, 3.806937006453128*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"58438275-e24c-4ce1-ac30-d277cec9ec00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    RowBox[{"(", 
     RowBox[{"12", "+", 
      RowBox[{"13", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}], "n"]}], "-", 
      RowBox[{"16", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"2", " ", "n"}]]}], "+", 
      RowBox[{"48", " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 8, ": ", 
   Rational[1, 9] (12 + 13 (-2)^$CellContext`n - 16 (-1)^(2 $CellContext`n) + 
    48 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069320269695034`*^9, 3.8069320778657794`*^9}, 
   3.8069322424244566`*^9, 3.8069322792532578`*^9, {3.806932404572656*^9, 
   3.8069324164832287`*^9}, {3.8069333861422977`*^9, 3.806933399221528*^9}, 
   3.8069345588704295`*^9, 3.8069370064870367`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"3f12329d-2c83-4bf1-8053-791442558be2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}], "n"]}], "+", 
      RowBox[{"18", " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 9, ": ", 
   Rational[1, 3] (-2 + 5 (-2)^$CellContext`n + 18 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069320269695034`*^9, 3.8069320778657794`*^9}, 
   3.8069322424244566`*^9, 3.8069322792532578`*^9, {3.806932404572656*^9, 
   3.8069324164832287`*^9}, {3.8069333861422977`*^9, 3.806933399221528*^9}, 
   3.8069345588704295`*^9, 3.80693700651995*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"10c224c2-eda9-4530-9a8c-a52b229fb9cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    RowBox[{"(", 
     RowBox[{"12", "+", 
      RowBox[{"17", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}], "n"]}], "-", 
      RowBox[{"20", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"2", " ", "n"}]]}], "+", 
      RowBox[{"60", " ", "n"}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 10, ": ", 
   Rational[1, 9] (12 + 17 (-2)^$CellContext`n - 20 (-1)^(2 $CellContext`n) + 
    60 $CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8069320269695034`*^9, 3.8069320778657794`*^9}, 
   3.8069322424244566`*^9, 3.8069322792532578`*^9, {3.806932404572656*^9, 
   3.8069324164832287`*^9}, {3.8069333861422977`*^9, 3.806933399221528*^9}, 
   3.8069345588704295`*^9, 3.806937006555852*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"2e63f856-b665-47be-98eb-32b6fff0a07d"]
}, Open  ]]
}, Open  ]],

Cell["2.3.26", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867951320154*^9, 
  3.80686800235871*^9}, {3.8073704476289334`*^9, 3.8073704478770533`*^9}, {
  3.8073780688512807`*^9, 
  3.807378069347226*^9}},ExpressionUUID->"4759a754-64ae-4a38-a73b-\
a7df0dbc1b5a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RRCP", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "j"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", "n", ",", "10", ",", 
   RowBox[{"inicio", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806934615004424*^9, 3.8069346295655184`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"7a908749-f2f6-45d6-b6d6-ef9c8faea96b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"Fibonacci", "[", "n", "]"}], "+", 
    RowBox[{"LucasL", "[", "n", "]"}]}]}],
  SequenceForm[
  "Caso ", 1, ": ", -1 - Fibonacci[$CellContext`n] + LucasL[$CellContext`n]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069346322715025`*^9, 3.80693708438594*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"566bc895-bb46-4d7f-80cd-af7c32c3ecc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "4"}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"LucasL", "[", "n", "]"}]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 2, ": ", 
   Rational[1, 2] (-4 - 3 Fibonacci[$CellContext`n] + 
    3 LucasL[$CellContext`n])],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069346322715025`*^9, 3.8069370843889313`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"aff3451d-767b-49d2-b3f9-038add476f58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "3"}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"LucasL", "[", "n", "]"}]}]}]}],
  SequenceForm[
  "Caso ", 3, ": ", -3 - 2 Fibonacci[$CellContext`n] + 
   2 LucasL[$CellContext`n]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069346322715025`*^9, 3.806937084390939*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"55d60d63-351c-423a-8d98-5fdc14d69844"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "8"}], "-", 
      RowBox[{"5", " ", 
       RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
      RowBox[{"5", " ", 
       RowBox[{"LucasL", "[", "n", "]"}]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 4, ": ", 
   Rational[1, 2] (-8 - 5 Fibonacci[$CellContext`n] + 
    5 LucasL[$CellContext`n])],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069346322715025`*^9, 3.8069370843929214`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"e90ca768-4f3a-4d8d-8c3d-c82976eff20d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "5"}], "-", 
    RowBox[{"3", " ", 
     RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"LucasL", "[", "n", "]"}]}]}]}],
  SequenceForm[
  "Caso ", 5, ": ", -5 - 3 Fibonacci[$CellContext`n] + 
   3 LucasL[$CellContext`n]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069346322715025`*^9, 3.806937084393918*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"2eacd388-b674-47c4-83b6-30d62b1de2a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "12"}], "-", 
      RowBox[{"7", " ", 
       RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
      RowBox[{"7", " ", 
       RowBox[{"LucasL", "[", "n", "]"}]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 6, ": ", 
   Rational[1, 2] (-12 - 7 Fibonacci[$CellContext`n] + 
    7 LucasL[$CellContext`n])],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069346322715025`*^9, 3.806937084425833*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"5925505b-53fc-4192-8474-614f0e909054"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "7"}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"LucasL", "[", "n", "]"}]}]}]}],
  SequenceForm[
  "Caso ", 7, ": ", -7 - 4 Fibonacci[$CellContext`n] + 
   4 LucasL[$CellContext`n]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069346322715025`*^9, 3.8069370844278283`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"11f3431a-6ffb-4cd3-8417-623ea83eaca3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "16"}], "-", 
      RowBox[{"9", " ", 
       RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"LucasL", "[", "n", "]"}]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 8, ": ", 
   Rational[1, 2] (-16 - 9 Fibonacci[$CellContext`n] + 
    9 LucasL[$CellContext`n])],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069346322715025`*^9, 3.8069370844288244`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"931caa1d-f8f8-4f4d-bb8c-8508cd17d8ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "9"}], "-", 
    RowBox[{"5", " ", 
     RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
    RowBox[{"5", " ", 
     RowBox[{"LucasL", "[", "n", "]"}]}]}]}],
  SequenceForm[
  "Caso ", 9, ": ", -9 - 5 Fibonacci[$CellContext`n] + 
   5 LucasL[$CellContext`n]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069346322715025`*^9, 3.806937084429823*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"acfb469c-79d8-4ab0-aa1e-9a7e476277be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "20"}], "-", 
      RowBox[{"11", " ", 
       RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
      RowBox[{"11", " ", 
       RowBox[{"LucasL", "[", "n", "]"}]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 10, ": ", 
   Rational[1, 2] (-20 - 11 Fibonacci[$CellContext`n] + 
    11 LucasL[$CellContext`n])],
  Editable->False]], "Print",
 CellChangeTimes->{3.8069346322715025`*^9, 3.806937084431816*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"01909a58-30d2-4fdc-9cc0-4a082eb711c7"]
}, Open  ]]
}, Open  ]],

Cell["2.3.27", "Text",
 CellChangeTimes->{{3.8068512075111666`*^9, 3.8068512095520086`*^9}, {
  3.806862265183646*^9, 3.806862273361394*^9}, {3.806867951320154*^9, 
  3.8068680050179853`*^9}, {3.807370451724191*^9, 3.8073704519690247`*^9}, {
  3.807378072093602*^9, 
  3.8073780726089087`*^9}},ExpressionUUID->"e80aa3a6-4ebe-4cd0-9e1e-\
da34d4448a01"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RRCP", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "j"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "n", ",", "10", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806934769606457*^9, 3.80693478901233*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"61a47f33-724d-4633-89af-cfc46fdebef9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 1, ": ", Rational[1, 3] (-1 + 2 (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, 3] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    2 (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, -3] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806936984191409*^9, 3.8069370896855536`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"c014b459-954f-4116-94a2-f759fad2aaaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "4"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"7", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "-", 
      RowBox[{"7", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 2, ": ", Rational[1, 6] (-4 + 5 (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, 7] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    5 (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, -7] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806936984191409*^9, 3.8069370896895437`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"74dd0e08-7f81-432a-a643-91087ac1c1be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 3, ": ", Rational[1, 3] (-3 + 3 (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, 4] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    3 (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, -4] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806936984191409*^9, 3.806937089693532*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"d703cecf-13f6-4ec1-a1c2-34a2f9594c64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "8"}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"9", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "-", 
      RowBox[{"9", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 4, ": ", Rational[1, 6] (-8 + 7 (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, 9] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    7 (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, -9] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806936984191409*^9, 3.806937089697521*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"0b263111-e024-45ee-95d7-a2bb0f665533"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"5", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "-", 
      RowBox[{"5", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 5, ": ", Rational[1, 3] (-5 + 4 (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, 5] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    4 (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, -5] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806936984191409*^9, 3.806937089700514*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"2a2eb02a-478c-4280-911a-8a59342691fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "12"}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"11", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "-", 
      RowBox[{"11", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 6, ": ", Rational[1, 6] (-12 + 9 (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, 11] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    9 (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, -11] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806936984191409*^9, 3.8069370897035055`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"5736395b-2235-4338-9179-22742116b3a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "7"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 7, ": ", Rational[1, 3] (-7 + 5 (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, 6] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    5 (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, -6] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806936984191409*^9, 3.806937089706497*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"762c12b1-997f-429d-a931-4d5bcc7783b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "16"}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"13", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "-", 
      RowBox[{"13", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 8, ": ", Rational[1, 6] (-16 + 11 (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, 13] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    11 (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, -13] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806936984191409*^9, 3.806937089709489*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"71767970-d02a-4744-ab70-6e399dc7164d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "9"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"7", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "-", 
      RowBox[{"7", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 9, ": ", Rational[1, 3] (-9 + 6 (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, 7] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    6 (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, -7] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806936984191409*^9, 3.8069370897114844`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"0b2513ae-f2b2-48c4-b050-073fcb8b12be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Caso \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "20"}], "+", 
      RowBox[{"13", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"15", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "+", 
      RowBox[{"13", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}], "-", 
      RowBox[{"15", " ", "\[ImaginaryI]", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}], "2"]}], ")"}], "n"]}]}], ")"}]}]}],
  SequenceForm[
  "Caso ", 10, ": ", Rational[1, 6] (-20 + 13 (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, 15] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[-1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    13 (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n + 
    Complex[0, -15] 3^Rational[1, 2] (Rational[-1, 2] + Complex[0, 
          Rational[1, 2]] 3^Rational[1, 2])^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.806936984191409*^9, 3.806937089714476*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"6b7f152c-8687-4cf6-b723-842446cd72ac"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSequenceFunction", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "6"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "6"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "6"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "6"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "6"}]}], "}"}], ",", "j"}], "]"}]], "Input",
 CellChangeTimes->{{3.8069354932570086`*^9, 3.806935526382347*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"f474c17d-9f9a-4551-a8aa-cdd585dd3e59"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"1", "+", "j"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{3.806935526885891*^9, 3.806937097774546*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"cb59fa6e-7906-4e5f-b41d-181582050e6a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSequenceFunction", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "4"}], ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "12"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "16"}], ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "20"}]}], "}"}], ",", "j"}], "]"}]], "Input",
 CellChangeTimes->{{3.806935276569045*^9, 3.806935309680195*^9}, 
   3.806935363444745*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"a3b792fd-034e-41f5-a329-a2399e734a14"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "j"]}], ")"}], " ", "j"}]], "Output",
 CellChangeTimes->{{3.8069353059612064`*^9, 3.8069353106473713`*^9}, 
   3.8069353642839146`*^9, 3.8069371005810804`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"d4505159-0fae-48e0-8685-c903d35531c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSequenceFunction", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2", ",", "5", ",", "3", ",", "7", ",", "4", ",", "9", ",", "5", ",", 
     "11", ",", "6", ",", "13"}], "}"}], ",", "j"}], "]"}]], "Input",
 CellChangeTimes->{{3.8069353695201216`*^9, 3.8069353870697823`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"1affe30e-36ea-4f37-a475-4a84f757758c"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "j"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", "j"}], ")"}]}]], "Output",
 CellChangeTimes->{3.806935388061617*^9, 3.806937104017432*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"af01eb2d-7831-4c50-a9ec-443073154973"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindSequenceFunction", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "3", ",", "7", ",", "4", ",", "9", ",", "5", ",", "11", ",", "6", ",", 
     "13", ",", "7", ",", "15"}], "}"}], ",", "j"}], "]"}]], "Input",
 CellChangeTimes->{{3.806935440390174*^9, 3.806935459119792*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"9d8e09e6-31b3-47e2-a791-fc4cb11c6756"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "j"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"5", "+", "j"}], ")"}]}]], "Output",
 CellChangeTimes->{3.8069354613543215`*^9, 3.806937107021494*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"8005b078-2c7d-492d-bace-3611a77ee192"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
TaggingRules->{"TryRealOnly" -> False},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"390e1f0f-5b29-4e19-bdf5-38c626b37353"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 201, 3, 42, "Input",ExpressionUUID->"b5d3498b-8524-4438-a21b-5002439b597c"],
Cell[762, 25, 151, 3, 50, "Text",ExpressionUUID->"19102db1-053b-43ee-8a42-f917be26372f"],
Cell[CellGroupData[{
Cell[938, 32, 648, 16, 72, "Input",ExpressionUUID->"550414d1-8555-4fb3-a60c-3014991a3732"],
Cell[1589, 50, 4076, 103, 323, "Output",ExpressionUUID->"98f100d0-d7b8-4257-b5db-838b539adb59"],
Cell[5668, 155, 781, 15, 107, "Output",ExpressionUUID->"bb59af72-a97b-4da7-b5bf-5de0ed61f3d4"]
}, Open  ]],
Cell[6464, 173, 200, 4, 50, "Text",ExpressionUUID->"ce7a4564-c893-438b-a474-3d698ab4ea48"],
Cell[CellGroupData[{
Cell[6689, 181, 798, 20, 72, "Input",ExpressionUUID->"bd9d83af-8248-46b7-a366-c962e802a5d3"],
Cell[7490, 203, 4232, 104, 328, "Output",ExpressionUUID->"79ef3ea4-a058-44c8-a133-61a67172bc1c"],
Cell[11725, 309, 745, 12, 164, "Output",ExpressionUUID->"cb8996d4-c08b-4cb1-9f61-2fc9e61d2e5f"]
}, Open  ]],
Cell[12485, 324, 250, 4, 50, "Text",ExpressionUUID->"b790515f-6fef-45ed-8c7c-76baf2e83d2d"],
Cell[CellGroupData[{
Cell[12760, 332, 951, 23, 119, "Input",ExpressionUUID->"bee3c35d-c0ea-444f-a37c-746dfa1805dd"],
Cell[13714, 357, 4199, 105, 328, "Output",ExpressionUUID->"c6e16159-2ae6-4eaa-8973-ae7513fc3489"],
Cell[17916, 464, 1123, 24, 267, "Output",ExpressionUUID->"e5943b4b-13ec-4d78-bd36-5677fb3dabdd"]
}, Open  ]],
Cell[19054, 491, 252, 4, 50, "Text",ExpressionUUID->"886dcfec-0dd1-4cd8-9c1a-0ddd78c47be2"],
Cell[CellGroupData[{
Cell[19331, 499, 801, 21, 72, "Input",ExpressionUUID->"fef779e5-f831-4c33-906c-e29ba478143d"],
Cell[20135, 522, 4246, 105, 329, "Output",ExpressionUUID->"52d0c422-045d-44b2-acdf-9e444cc961b3"],
Cell[24384, 629, 701, 13, 78, "Output",ExpressionUUID->"64caad0d-ef3c-40e0-8f6e-722306ac94d7"]
}, Open  ]],
Cell[25100, 645, 252, 4, 50, "Text",ExpressionUUID->"f0164ad2-39dd-411c-b107-537dc76bde50"],
Cell[CellGroupData[{
Cell[25377, 653, 674, 17, 72, "Input",ExpressionUUID->"e5fd1038-b116-4165-95be-dfed84d83e0c"],
Cell[26054, 672, 3956, 102, 341, "Output",ExpressionUUID->"94d8f14b-3723-4932-8d07-3df1006dfc35"],
Cell[30013, 776, 495, 9, 78, "Output",ExpressionUUID->"2697d378-9fc8-483d-b721-2a5e11d12dee"]
}, Open  ]],
Cell[30523, 788, 250, 4, 50, "Text",ExpressionUUID->"cb507cf2-e4f6-4571-b356-d5653c2756ea"],
Cell[CellGroupData[{
Cell[30798, 796, 1000, 28, 141, "Input",ExpressionUUID->"cac4de04-fcf3-486e-8708-433ec35ba267"],
Cell[31801, 826, 4349, 109, 325, "Output",ExpressionUUID->"bd1662d0-4116-4c73-a16a-9f76d6a05a79"],
Cell[36153, 937, 966, 16, 107, "Output",ExpressionUUID->"3307ea05-d67c-431e-bf05-dcaf40f24df2"]
}, Open  ]],
Cell[37134, 956, 248, 4, 50, "Text",ExpressionUUID->"1ab4562a-46bf-40fa-ae6b-d45aceec51b8"],
Cell[37385, 962, 454, 15, 50, "Text",ExpressionUUID->"123618db-7c24-4ee3-bfc5-fa5399a41eaa"],
Cell[CellGroupData[{
Cell[37864, 981, 1763, 56, 292, "Input",ExpressionUUID->"3b802063-413a-40db-a988-2c58755468f3"],
Cell[39630, 1039, 4401, 104, 348, "Output",ExpressionUUID->"56b699e6-0ed7-4639-b1f2-1abbe8948203"],
Cell[44034, 1145, 942, 14, 107, "Output",ExpressionUUID->"773499a1-7c1b-4ee6-8ccb-14bcd2fdcc55"]
}, Open  ]],
Cell[44991, 1162, 356, 6, 50, "Text",ExpressionUUID->"00cd0483-8ece-4840-bbec-a7b2ca500dde"],
Cell[CellGroupData[{
Cell[45372, 1172, 344, 7, 42, "Input",ExpressionUUID->"c83a17f9-2e65-4e86-8e08-e187dad3e435"],
Cell[45719, 1181, 185, 2, 48, "Output",ExpressionUUID->"66e524dd-cf57-4fb4-aa4f-e3395caca46a"]
}, Open  ]],
Cell[45919, 1186, 1394, 45, 277, "Text",ExpressionUUID->"2cc3ef38-1126-4af2-9be9-8b3d845e64af"],
Cell[CellGroupData[{
Cell[47338, 1235, 761, 19, 176, "Input",ExpressionUUID->"d9fd8211-a872-48f6-b7a1-65f4400d7939"],
Cell[48102, 1256, 344, 6, 48, "Output",ExpressionUUID->"5471c453-d90a-46bc-a4b5-fdad4ae8e0df"]
}, Open  ]],
Cell[48461, 1265, 354, 6, 50, "Text",ExpressionUUID->"fc38376f-857f-427f-8c58-396e30b3e054"],
Cell[CellGroupData[{
Cell[48840, 1275, 480, 13, 65, "Input",ExpressionUUID->"268caf60-d5db-4af6-ae59-6a209282152f"],
Cell[49323, 1290, 1167, 38, 117, "Output",ExpressionUUID->"f3056976-d8e9-4702-a02e-7b14d1bb35b9"]
}, Open  ]],
Cell[50505, 1331, 403, 6, 50, "Text",ExpressionUUID->"63ee84e4-187f-41e5-ac34-64d6a733baac"],
Cell[CellGroupData[{
Cell[50933, 1341, 740, 18, 173, "Input",ExpressionUUID->"7ff8deff-ca50-47eb-9fc2-f0b497d7e72c"],
Cell[51676, 1361, 414, 8, 48, "Output",ExpressionUUID->"2576ad7a-00a3-426d-8978-ae69aa3b899c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52127, 1374, 338, 7, 42, "Input",ExpressionUUID->"0cda9823-2d52-44bc-acf0-68309438ea04"],
Cell[52468, 1383, 232, 3, 48, "Output",ExpressionUUID->"a9b46d7c-258b-4903-93eb-becae798e99a"]
}, Open  ]],
Cell[52715, 1389, 1820, 53, 277, "Text",ExpressionUUID->"f8384a4a-3d23-47a6-89d7-3dd5e9cc3fc9"],
Cell[CellGroupData[{
Cell[54560, 1446, 892, 21, 176, "Input",ExpressionUUID->"0437ad7b-28b3-4699-bf49-a10a17332296"],
Cell[55455, 1469, 393, 7, 48, "Output",ExpressionUUID->"ab5bb6a1-e2db-4aab-8b03-23ecc7de95f9"]
}, Open  ]],
Cell[55863, 1479, 405, 6, 50, "Text",ExpressionUUID->"3d899587-90a6-4a11-beb6-83ba730ed8eb"],
Cell[CellGroupData[{
Cell[56293, 1489, 707, 17, 148, "Input",ExpressionUUID->"b9907e57-8f21-4b7a-a429-f996489516af"],
Cell[57003, 1508, 354, 8, 48, "Output",ExpressionUUID->"8cb4d9ac-6810-4c81-b254-4192f259f14c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57394, 1521, 457, 10, 42, "Input",ExpressionUUID->"4367577f-9239-4ba7-a53c-5af9f1381d2a"],
Cell[57854, 1533, 944, 29, 53, "Output",ExpressionUUID->"71a3db34-4b79-42e4-a4ac-2d31cd774416"]
}, Open  ]],
Cell[58813, 1565, 383, 6, 50, "Text",ExpressionUUID->"c0f99cd6-fd50-4fa4-bd75-10dd544d384e"],
Cell[CellGroupData[{
Cell[59221, 1575, 330, 7, 42, "Input",ExpressionUUID->"9cebd866-4b74-4572-b907-0f95740dcb54"],
Cell[CellGroupData[{
Cell[59576, 1586, 225, 4, 33, "Print",ExpressionUUID->"d8011719-29c4-4688-9f17-5ae78ecaf8f3"],
Cell[59804, 1592, 763, 22, 34, "Print",ExpressionUUID->"060fc5e9-e1bd-40c8-83d9-c075fd5b73e8"],
Cell[60570, 1616, 834, 24, 34, "Print",ExpressionUUID->"8e3c4181-030a-4c8f-8380-c5a12f0ca7a4"],
Cell[61407, 1642, 913, 27, 34, "Print",ExpressionUUID->"108d1ef2-5215-4ba9-9dcf-460eeea6f524"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62369, 1675, 378, 9, 70, "Input",ExpressionUUID->"c4aa43a7-a8de-4332-867f-c718a9357ecd"],
Cell[62750, 1686, 215, 5, 48, "Output",ExpressionUUID->"b089738a-12a9-4b9b-9132-f39a65ffafaf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63002, 1696, 405, 9, 42, "Input",ExpressionUUID->"6a460126-5614-4dbf-b592-d7ee0d485701"],
Cell[63410, 1707, 213, 5, 48, "Output",ExpressionUUID->"d5f14fa4-efdb-46bc-b237-19298bd7e972"]
}, Open  ]],
Cell[63638, 1715, 355, 6, 50, "Text",ExpressionUUID->"696cf0db-5e5c-4479-91ed-4a194c5bd34c"],
Cell[CellGroupData[{
Cell[64018, 1725, 278, 6, 42, "Input",ExpressionUUID->"018471a3-94be-4144-a81b-b2199c6295b6"],
Cell[CellGroupData[{
Cell[64321, 1735, 225, 4, 33, "Print",ExpressionUUID->"b8dc7a97-9723-4cb2-aafc-94bf800bd1ad"],
Cell[64549, 1741, 792, 24, 38, "Print",ExpressionUUID->"d422f715-295b-4b44-a4c1-e05e45b68edc"],
Cell[65344, 1767, 792, 24, 38, "Print",ExpressionUUID->"f5b89c8d-5b32-4ff5-a69d-6d08ccaa90c3"],
Cell[66139, 1793, 791, 24, 38, "Print",ExpressionUUID->"cfc80370-9e56-4c66-9e32-3fcb95715027"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66979, 1823, 325, 7, 65, "Input",ExpressionUUID->"d946565a-067f-4711-a6c6-8f3478ba2ecc"],
Cell[67307, 1832, 251, 6, 67, "Output",ExpressionUUID->"1f1ea4e0-deb0-44c6-9a63-aa3246993635"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67595, 1843, 403, 9, 42, "Input",ExpressionUUID->"301b58f2-2eab-47a3-8e4f-e8cbe1c24bef"],
Cell[68001, 1854, 292, 8, 62, "Output",ExpressionUUID->"a3e00d20-606c-4144-a30b-5528129012f0"]
}, Open  ]],
Cell[68308, 1865, 350, 6, 50, "Text",ExpressionUUID->"1f76612d-56e6-465a-bfbf-0cdb899afd30"],
Cell[CellGroupData[{
Cell[68683, 1875, 323, 7, 42, "Input",ExpressionUUID->"9f5723c7-2c3d-4947-bd5b-5066c1bc3a42"],
Cell[CellGroupData[{
Cell[69031, 1886, 227, 4, 33, "Print",ExpressionUUID->"c338901c-e221-4e65-8828-9dda7d200d68"],
Cell[69261, 1892, 769, 22, 34, "Print",ExpressionUUID->"a21018ef-9251-4b2f-832e-386dbca49322"],
Cell[70033, 1916, 869, 25, 34, "Print",ExpressionUUID->"7a4b3e14-b086-411e-9cf8-e1e7bcd97595"],
Cell[70905, 1943, 971, 28, 34, "Print",ExpressionUUID->"f1fcb0c9-2738-4eb1-a9e9-acb06d0e62a6"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71925, 1977, 429, 9, 42, "Input",ExpressionUUID->"b2b57d3b-82dc-4cdb-974e-2279832a8433"],
Cell[72357, 1988, 309, 8, 48, "Output",ExpressionUUID->"70cece4c-cae9-4f45-9088-c769d9128e04"]
}, Open  ]],
Cell[72681, 1999, 401, 6, 50, "Text",ExpressionUUID->"c5fa14bc-cb31-4af4-93e5-e8c4befcb806"],
Cell[73085, 2007, 577, 15, 79, "Input",ExpressionUUID->"c8770fde-5eec-4fd6-a1d0-97f3b331fc6c"],
Cell[CellGroupData[{
Cell[73687, 2026, 728, 22, 72, "Input",ExpressionUUID->"acf5b4ad-8e94-43d8-b190-1078709820cd"],
Cell[74418, 2050, 586, 19, 67, "Output",ExpressionUUID->"3a2320b3-10b4-4d1c-8f00-f0ef79f2f184"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75041, 2074, 644, 14, 50, "Input",ExpressionUUID->"f509f8f4-ee1f-4f69-8929-d347f9cc839e"],
Cell[75688, 2090, 498, 14, 73, "Output",ExpressionUUID->"46a50f20-50ba-447e-8ff8-c67c0f983e0e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76223, 2109, 1285, 38, 174, "Input",ExpressionUUID->"f7552302-af79-487e-ac8a-9d47c5424038"],
Cell[77511, 2149, 471, 9, 78, "Output",ExpressionUUID->"d0c73a9f-315d-42b0-9282-9f30a822737a"]
}, Open  ]],
Cell[77997, 2161, 403, 6, 50, "Text",ExpressionUUID->"d4148d52-45cc-48c5-aa8e-371407654588"],
Cell[78403, 2169, 200, 3, 50, "Text",ExpressionUUID->"b26a7c18-96b5-467d-b26a-be674e08ef2b"],
Cell[78606, 2174, 400, 6, 50, "Text",ExpressionUUID->"cbee5024-e08f-4e78-889d-31f61925d50d"],
Cell[CellGroupData[{
Cell[79031, 2184, 344, 9, 69, "Input",ExpressionUUID->"b6ac4107-0711-483f-8ffb-385989019ac3"],
Cell[79378, 2195, 613, 20, 67, "Output",ExpressionUUID->"4f8d35ea-afc6-4585-9e13-bbd0a66e6df0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80028, 2220, 1583, 51, 145, "Input",ExpressionUUID->"24eaeda8-54dd-415d-bb67-8fe9e0c26fad"],
Cell[81614, 2273, 531, 17, 67, "Output",ExpressionUUID->"2ed87b03-a377-4210-a509-d7d696f6fe3d"]
}, Open  ]],
Cell[82160, 2293, 1375, 43, 55, "Text",ExpressionUUID->"8813a517-db81-400e-9fa8-f9f8799b573a"],
Cell[CellGroupData[{
Cell[83560, 2340, 669, 18, 72, "Input",ExpressionUUID->"1b4b637f-de0d-449f-af69-b126953362dc"],
Cell[84232, 2360, 1159, 40, 82, "Output",ExpressionUUID->"94a63a26-2a75-461d-b8b6-1dba812976b6"],
Cell[CellGroupData[{
Cell[85416, 2404, 585, 14, 34, "Print",ExpressionUUID->"2ea7e9be-158a-459f-8438-515a6d562788"],
Cell[86004, 2420, 904, 27, 52, "Print",ExpressionUUID->"e96f86fb-2e12-4335-ae35-8ea60cbe6e68"],
Cell[86911, 2449, 1214, 35, 80, "Print",ExpressionUUID->"afefdfda-db94-4dfb-8ca1-8373ca3055ab"],
Cell[88128, 2486, 1306, 35, 79, "Print",ExpressionUUID->"4fbfef66-464d-4afe-9321-4d599f24b67e"],
Cell[89437, 2523, 978, 28, 52, "Print",ExpressionUUID->"b98f16cc-569d-4f20-8650-e9c7b1c00dec"],
Cell[90418, 2553, 1662, 50, 79, "Print",ExpressionUUID->"4b10e360-5c99-40da-adc3-df289acf8f52"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92129, 2609, 3376, 111, 396, "Input",ExpressionUUID->"1f8c62fd-437f-4cc7-9a62-4422247e49bb"],
Cell[95508, 2722, 485, 8, 78, "Output",ExpressionUUID->"278a4ada-fc61-4598-a9a1-33033c39968c"]
}, Open  ]],
Cell[96008, 2733, 501, 8, 50, "Text",ExpressionUUID->"9a08500c-2376-4575-8490-a3283bc13068"],
Cell[CellGroupData[{
Cell[96534, 2745, 423, 11, 69, "Input",ExpressionUUID->"be1870b3-3169-4c80-98a0-b56dbf922d3c"],
Cell[96960, 2758, 639, 20, 67, "Output",ExpressionUUID->"967f2d9a-a74c-4dd4-809d-20e20ab7821d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97636, 2783, 1691, 52, 145, "Input",ExpressionUUID->"930ed21e-b24d-41c3-817a-58844fa5b623"],
Cell[99330, 2837, 818, 25, 89, "Output",ExpressionUUID->"bd20e891-2660-46c8-b10a-b29162dbeb04"]
}, Open  ]],
Cell[100163, 2865, 1736, 53, 61, "Text",ExpressionUUID->"80b40283-c236-47ad-8e72-6ace00bb4fdb"],
Cell[CellGroupData[{
Cell[101924, 2922, 772, 21, 72, "Input",ExpressionUUID->"8075c53c-3f09-4881-9486-b976e4732f39"],
Cell[102699, 2945, 1555, 48, 152, "Output",ExpressionUUID->"65886708-188d-47df-9e21-4f525b347a2f"],
Cell[CellGroupData[{
Cell[104279, 2997, 624, 15, 52, "Print",ExpressionUUID->"28987c78-4893-4503-8af4-6facbf9189ac"],
Cell[104906, 3014, 958, 27, 52, "Print",ExpressionUUID->"d3f56613-ac14-4f9c-b4e9-c947a8ae736e"],
Cell[105867, 3043, 1275, 36, 80, "Print",ExpressionUUID->"d0a01179-bce9-4f76-a9b2-62deab537f79"],
Cell[107145, 3081, 2095, 52, 126, "Print",ExpressionUUID->"7c386536-ec4d-4a08-afd9-ecf7a1dd1f65"],
Cell[109243, 3135, 1452, 41, 99, "Print",ExpressionUUID->"18306db5-88c1-403a-85da-e196c985589d"],
Cell[110698, 3178, 2312, 61, 94, "Print",ExpressionUUID->"bdf1fd92-7964-4633-b9b0-3267e65f30f3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[113059, 3245, 4714, 136, 602, "Input",ExpressionUUID->"f4f5e8f8-91c0-46b9-bf93-32dde80a81dd"],
Cell[117776, 3383, 436, 8, 78, "Output",ExpressionUUID->"26b976dd-bc33-40f6-92e1-afaa02e04439"]
}, Open  ]],
Cell[118227, 3394, 496, 8, 50, "Text",ExpressionUUID->"fbd9e143-455b-4b0c-8fbc-ed6e1909743d"],
Cell[CellGroupData[{
Cell[118748, 3406, 457, 12, 69, "Input",ExpressionUUID->"42d1db56-9e27-4cf5-a97c-b64b472bad70"],
Cell[119208, 3420, 369, 10, 48, "Output",ExpressionUUID->"6c294aad-e8e8-490e-9e78-12a4c2b24762"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119614, 3435, 1224, 34, 105, "Input",ExpressionUUID->"7e06a926-6335-45f5-914b-41dcad503604"],
Cell[120841, 3471, 399, 10, 67, "Output",ExpressionUUID->"0d8f5586-2e68-4ffb-99af-e2555fb4967a"]
}, Open  ]],
Cell[121255, 3484, 1253, 33, 55, "Text",ExpressionUUID->"0dbf3729-f698-4a38-82b1-a905461d760b"],
Cell[CellGroupData[{
Cell[122533, 3521, 761, 19, 72, "Input",ExpressionUUID->"34d97162-663f-4fc3-ad1c-0fb702659150"],
Cell[123297, 3542, 393, 11, 67, "Output",ExpressionUUID->"847c9279-6c10-43ab-8c5e-99864d83f9ad"],
Cell[CellGroupData[{
Cell[123715, 3557, 690, 17, 34, "Print",ExpressionUUID->"8532448a-8d22-4fb4-a02a-cf023763d676"],
Cell[124408, 3576, 525, 13, 33, "Print",ExpressionUUID->"da27695a-79ca-46c0-9a46-7e257b046a95"],
Cell[124936, 3591, 832, 21, 33, "Print",ExpressionUUID->"b8143a5a-0cc3-4044-a10e-a869d404a5e6"],
Cell[125771, 3614, 1288, 35, 60, "Print",ExpressionUUID->"84a5908d-f278-429b-92df-ef71c240c7b7"],
Cell[127062, 3651, 813, 22, 52, "Print",ExpressionUUID->"5671413d-b732-405c-8dc9-19271c487ee0"],
Cell[127878, 3675, 796, 21, 52, "Print",ExpressionUUID->"5de3bee4-18bf-436c-9193-d00dd8b8e652"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[128723, 3702, 930, 25, 133, "Input",ExpressionUUID->"ac488fd1-1643-4e27-8200-f652a4538165"],
Cell[129656, 3729, 488, 8, 78, "Output",ExpressionUUID->"353afba4-87b3-4fa0-90d2-d889f5be8248"]
}, Open  ]],
Cell[130159, 3740, 395, 6, 50, "Text",ExpressionUUID->"f588dd6a-8308-46ba-b72a-1b5bdd000e7f"],
Cell[CellGroupData[{
Cell[130579, 3750, 519, 14, 69, "Input",ExpressionUUID->"38ec8c4d-f38c-42ef-aebd-524232cfdae7"],
Cell[131101, 3766, 436, 12, 48, "Output",ExpressionUUID->"1749d697-1e70-472c-9ec4-50d8538ee5a6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[131574, 3783, 2058, 58, 133, "Input",ExpressionUUID->"56300ecb-0d95-4329-b277-1967b8472a09"],
Cell[133635, 3843, 518, 14, 67, "Output",ExpressionUUID->"ed92f10a-fa3a-43ca-8032-5cb12ff65c0b"]
}, Open  ]],
Cell[134168, 3860, 1281, 33, 55, "Text",ExpressionUUID->"4f9b5569-e226-4202-9a4d-39ba03cc081c"],
Cell[CellGroupData[{
Cell[135474, 3897, 861, 22, 72, "Input",ExpressionUUID->"6d405305-8c06-41b7-b0ad-8d54830e783d"],
Cell[136338, 3921, 514, 16, 67, "Output",ExpressionUUID->"485fec83-07fe-4705-9580-9e8a4fde84e7"],
Cell[CellGroupData[{
Cell[136877, 3941, 770, 19, 34, "Print",ExpressionUUID->"a51b59ae-5437-42a4-9edf-593f7eab2b7d"],
Cell[137650, 3962, 538, 13, 33, "Print",ExpressionUUID->"0a024c30-8b66-4691-a1ce-fd68286533ea"],
Cell[138191, 3977, 1147, 29, 60, "Print",ExpressionUUID->"9bcf6109-a57d-4810-b8b3-ab3bb9ab5e5d"],
Cell[139341, 4008, 1965, 51, 60, "Print",ExpressionUUID->"b6dfc766-401e-4736-8c67-8f115c1fc26c"],
Cell[141309, 4061, 1040, 28, 52, "Print",ExpressionUUID->"9615ddaa-9efd-4118-b2e5-a027b0202a50"],
Cell[142352, 4091, 963, 27, 79, "Print",ExpressionUUID->"76ed8a1b-cfff-4c21-9ca3-9c84e9757494"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[143364, 4124, 1261, 37, 166, "Input",ExpressionUUID->"36bd82ef-77ab-4c35-80eb-db45d47d8638"],
Cell[144628, 4163, 462, 8, 78, "Output",ExpressionUUID->"6ab6eafb-0892-4ec8-a614-49f38471236c"]
}, Open  ]],
Cell[145105, 4174, 405, 6, 50, "Text",ExpressionUUID->"25206bf2-efec-4f81-b719-d09f266eac9a"],
Cell[145513, 4182, 574, 16, 56, "Text",ExpressionUUID->"c00aad57-ded4-4c0b-8f79-7e514498fba9"],
Cell[CellGroupData[{
Cell[146112, 4202, 376, 9, 69, "Input",ExpressionUUID->"d99fc7c5-c0fb-4b8e-991d-3f589df236cd"],
Cell[146491, 4213, 327, 9, 48, "Output",ExpressionUUID->"602f8515-8a3b-4e33-bca2-b7a405d584fc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[146855, 4227, 906, 27, 72, "Input",ExpressionUUID->"313c0c1c-3993-4389-bd72-e785cc76b3b2"],
Cell[147764, 4256, 576, 18, 67, "Output",ExpressionUUID->"164ef80b-b9bc-430f-947c-11b55e1dc891"]
}, Open  ]],
Cell[148355, 4277, 1443, 38, 57, "Text",ExpressionUUID->"23d49582-483b-4eca-aff8-ec73a6c5a7a6"],
Cell[CellGroupData[{
Cell[149823, 4319, 785, 20, 85, "Input",ExpressionUUID->"6567c152-2bcd-4bbe-8e4e-c5c92975771f"],
Cell[150611, 4341, 677, 21, 67, "Output",ExpressionUUID->"96d5082a-ae90-46a0-b8b5-5b58df4ffeb0"],
Cell[CellGroupData[{
Cell[151313, 4366, 600, 14, 34, "Print",ExpressionUUID->"cc3d2120-b38d-43f4-80dd-d4410f95bfcc"],
Cell[151916, 4382, 556, 14, 33, "Print",ExpressionUUID->"09bea845-739d-49d9-8fb0-cd68aaaa4771"],
Cell[152475, 4398, 815, 21, 33, "Print",ExpressionUUID->"f02597ca-a02d-4301-b746-4eaefb7c9353"],
Cell[153293, 4421, 973, 27, 38, "Print",ExpressionUUID->"fd02a5f5-f3f9-4614-a553-cdca2139b23a"],
Cell[154269, 4450, 1025, 29, 52, "Print",ExpressionUUID->"ae50f481-cd86-4ed8-9a55-e5db41dbe1da"],
Cell[155297, 4481, 1123, 31, 81, "Print",ExpressionUUID->"07558781-4008-4e91-9cc4-448cc029e23a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[156469, 4518, 1571, 47, 166, "Input",ExpressionUUID->"b4aa2a81-f105-4827-9381-b38beafd1c52"],
Cell[158043, 4567, 475, 8, 78, "Output",ExpressionUUID->"296b8fb5-79c3-48d2-afbe-fcbf6e9dc6d9"]
}, Open  ]],
Cell[158533, 4578, 403, 6, 50, "Text",ExpressionUUID->"ec9bb055-b676-4196-be43-68c1c1144a12"],
Cell[158939, 4586, 667, 18, 50, "Text",ExpressionUUID->"ec04b5d3-ac4a-4463-bfb2-17b1888be173"],
Cell[CellGroupData[{
Cell[159631, 4608, 376, 9, 69, "Input",ExpressionUUID->"2e22d14e-6e73-4676-ae94-fc2143c0894a"],
Cell[160010, 4619, 713, 21, 67, "Output",ExpressionUUID->"a4032f82-482c-4a16-af11-fc2d641ddeb0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160760, 4645, 1683, 52, 145, "Input",ExpressionUUID->"d5195231-e3f5-4560-832d-b7f931ccbded"],
Cell[162446, 4699, 837, 24, 67, "Output",ExpressionUUID->"59dff610-b2b7-4bd9-9b32-24d523bda375"]
}, Open  ]],
Cell[163298, 4726, 2111, 56, 96, "Text",ExpressionUUID->"ed964275-22ca-4db6-85ad-0a38cde2cf8e"],
Cell[CellGroupData[{
Cell[165434, 4786, 985, 25, 73, "Input",ExpressionUUID->"c7410aa2-f20b-4bcd-ae88-b952fd3ae052"],
Cell[166422, 4813, 1524, 44, 91, "Output",ExpressionUUID->"5e5dfc73-b5cb-4d6e-8e4e-4a53abcdf7d3"],
Cell[CellGroupData[{
Cell[167971, 4861, 807, 16, 34, "Print",ExpressionUUID->"00f49a94-0ea8-4151-b786-4d25a457c04f"],
Cell[168781, 4879, 1204, 30, 52, "Print",ExpressionUUID->"92c993e9-a899-4842-8857-dbc6178616b8"],
Cell[169988, 4911, 1523, 39, 80, "Print",ExpressionUUID->"6ecdb7af-a17c-4a48-a651-ec83e8f03d51"],
Cell[171514, 4952, 1545, 37, 79, "Print",ExpressionUUID->"fc81df4d-a3dc-462e-b12a-24ffa3490535"],
Cell[173062, 4991, 1374, 35, 79, "Print",ExpressionUUID->"f7edbb18-d229-422a-8bd5-ca6bcc2bcf01"],
Cell[174439, 5028, 2047, 53, 79, "Print",ExpressionUUID->"41159431-dc23-44f4-ae31-f22d2922027c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[176535, 5087, 3172, 90, 533, "Input",ExpressionUUID->"7484d534-72e7-4c65-ac16-1792a0c50685"],
Cell[179710, 5179, 639, 10, 94, "Output",ExpressionUUID->"4bc3af18-9432-4192-8ba2-936ddc32f7ee"]
}, Open  ]],
Cell[180364, 5192, 403, 6, 50, "Text",ExpressionUUID->"7328b555-72f7-4950-8b7a-d5392dc35039"],
Cell[CellGroupData[{
Cell[180792, 5202, 325, 8, 69, "Input",ExpressionUUID->"d08457d4-17e2-4fe7-bbbc-2b491cb8d8ee"],
Cell[181120, 5212, 327, 9, 48, "Output",ExpressionUUID->"19b0d32f-8344-4148-b8ef-22c1f48e29c0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181484, 5226, 788, 24, 69, "Input",ExpressionUUID->"7d28a27c-fcb1-4856-b394-eafc694cc628"],
Cell[182275, 5252, 332, 9, 67, "Output",ExpressionUUID->"bf1da639-c8ce-4067-a0c1-4d6eae190218"]
}, Open  ]],
Cell[182622, 5264, 1250, 30, 55, "Text",ExpressionUUID->"888ca18a-cf42-47bb-9f4f-f31082412708"],
Cell[CellGroupData[{
Cell[183897, 5298, 646, 16, 72, "Input",ExpressionUUID->"a9749433-97fb-4e64-a9ac-21d4b51089cb"],
Cell[184546, 5316, 365, 11, 67, "Output",ExpressionUUID->"c79317fe-2316-45c1-9106-e71ea78f1975"],
Cell[CellGroupData[{
Cell[184936, 5331, 575, 14, 34, "Print",ExpressionUUID->"61bc86ab-bfac-40b5-ab27-0e010eb4c727"],
Cell[185514, 5347, 532, 14, 33, "Print",ExpressionUUID->"79a83800-6cc0-4b3b-9cea-2e115afeec02"],
Cell[186049, 5363, 791, 21, 33, "Print",ExpressionUUID->"b58e2945-a0c1-4bd4-b8b5-111781908a8f"],
Cell[186843, 5386, 913, 25, 33, "Print",ExpressionUUID->"c454cdd5-bedd-4fb3-9a44-9fc76d657410"],
Cell[187759, 5413, 723, 20, 52, "Print",ExpressionUUID->"0048aca7-bdd3-4f8c-beb8-dc6c1376da10"],
Cell[188485, 5435, 746, 20, 52, "Print",ExpressionUUID->"52835e8b-10b3-44c7-bf59-940f267d55b9"]
}, Open  ]]
}, Open  ]],
Cell[189258, 5459, 351, 6, 50, "Text",ExpressionUUID->"0b7b1f49-11d8-4191-bc8b-3a359986865c"],
Cell[CellGroupData[{
Cell[189634, 5469, 336, 7, 42, "Input",ExpressionUUID->"bb7cfbed-5982-4bf4-aac5-fe42a4dfaa95"],
Cell[189973, 5478, 264, 6, 48, "Output",ExpressionUUID->"f43d1745-51f2-4e4a-9e1c-627f8d219315"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190274, 5489, 432, 11, 65, "Input",ExpressionUUID->"8212cc49-4696-4f61-8595-67912eaa1ced"],
Cell[190709, 5502, 285, 4, 48, "Output",ExpressionUUID->"9d9380d1-fa7d-4adb-a40c-a6ca7f05b899"]
}, Open  ]],
Cell[CellGroupData[{
Cell[191031, 5511, 662, 16, 130, "Input",ExpressionUUID->"7686d8c7-5b19-4345-b822-8a8202fa1ec4"],
Cell[191696, 5529, 193, 2, 48, "Output",ExpressionUUID->"4984746c-aad3-4bd1-8897-154a46874217"],
Cell[191892, 5533, 191, 2, 48, "Output",ExpressionUUID->"794f2f43-0e7b-4d9f-9993-91034ad498c3"]
}, Open  ]],
Cell[192098, 5538, 347, 6, 50, "Text",ExpressionUUID->"4088d070-967b-48ed-abe8-f33ca69373f3"],
Cell[CellGroupData[{
Cell[192470, 5548, 196, 3, 42, "Input",ExpressionUUID->"61476a05-d6ee-4b47-9cfb-456ed8fa0f48"],
Cell[192669, 5553, 69539, 1434, 556, "Output",ExpressionUUID->"cd3136b1-13f1-44fb-a1f7-878e672dccf7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[262245, 6992, 695, 15, 42, "Input",ExpressionUUID->"760a1fdf-0c81-4bc4-b031-514c7b88f149"],
Cell[CellGroupData[{
Cell[262965, 7011, 892, 22, 52, "Print",ExpressionUUID->"d0d600ea-02c9-48a1-a4c6-b6e7e716159d"],
Cell[263860, 7035, 1076, 28, 52, "Print",ExpressionUUID->"47b84ada-731e-4ab1-bf44-97e3be1065f5"],
Cell[264939, 7065, 890, 22, 52, "Print",ExpressionUUID->"9962141a-20de-4fa0-a0f3-53ee10c7ce25"],
Cell[265832, 7089, 1106, 29, 52, "Print",ExpressionUUID->"df8161e1-c984-4615-8d1c-831434ceea04"],
Cell[266941, 7120, 924, 23, 52, "Print",ExpressionUUID->"70fa409e-cc97-493f-ae86-b389f808f57c"],
Cell[267868, 7145, 1104, 29, 52, "Print",ExpressionUUID->"bbea5fbf-a5ea-4ae0-81f5-d3956d34afdb"],
Cell[268975, 7176, 947, 24, 52, "Print",ExpressionUUID->"58438275-e24c-4ce1-ac30-d277cec9ec00"],
Cell[269925, 7202, 1112, 29, 52, "Print",ExpressionUUID->"3f12329d-2c83-4bf1-8053-791442558be2"],
Cell[271040, 7233, 944, 24, 52, "Print",ExpressionUUID->"10c224c2-eda9-4530-9a8c-a52b229fb9cb"],
Cell[271987, 7259, 1112, 29, 52, "Print",ExpressionUUID->"2e63f856-b665-47be-98eb-32b6fff0a07d"]
}, Open  ]]
}, Open  ]],
Cell[273126, 7292, 350, 6, 50, "Text",ExpressionUUID->"4759a754-64ae-4a38-a73b-a7df0dbc1b5a"],
Cell[CellGroupData[{
Cell[273501, 7302, 400, 9, 42, "Input",ExpressionUUID->"7a908749-f2f6-45d6-b6d6-ef9c8faea96b"],
Cell[CellGroupData[{
Cell[273926, 7315, 585, 14, 33, "Print",ExpressionUUID->"566bc895-bb46-4d7f-80cd-af7c32c3ecc0"],
Cell[274514, 7331, 754, 21, 52, "Print",ExpressionUUID->"aff3451d-767b-49d2-b3f9-038add476f58"],
Cell[275271, 7354, 646, 17, 33, "Print",ExpressionUUID->"55d60d63-351c-423a-8d98-5fdc14d69844"],
Cell[275920, 7373, 754, 21, 52, "Print",ExpressionUUID->"e90ca768-4f3a-4d8d-8c3d-c82976eff20d"],
Cell[276677, 7396, 646, 17, 33, "Print",ExpressionUUID->"2eacd388-b674-47c4-83b6-30d62b1de2a3"],
Cell[277326, 7415, 754, 21, 52, "Print",ExpressionUUID->"5925505b-53fc-4192-8474-614f0e909054"],
Cell[278083, 7438, 648, 17, 33, "Print",ExpressionUUID->"11f3431a-6ffb-4cd3-8417-623ea83eaca3"],
Cell[278734, 7457, 756, 21, 52, "Print",ExpressionUUID->"931caa1d-f8f8-4f4d-bb8c-8508cd17d8ba"],
Cell[279493, 7480, 646, 17, 33, "Print",ExpressionUUID->"acfb469c-79d8-4ab0-aa1e-9a7e476277be"],
Cell[280142, 7499, 760, 21, 52, "Print",ExpressionUUID->"01909a58-30d2-4fdc-9cc0-4a082eb711c7"]
}, Open  ]]
}, Open  ]],
Cell[280929, 7524, 351, 6, 50, "Text",ExpressionUUID->"e80aa3a6-4ebe-4cd0-9e1e-da34d4448a01"],
Cell[CellGroupData[{
Cell[281305, 7534, 460, 12, 42, "Input",ExpressionUUID->"61a47f33-724d-4633-89af-cfc46fdebef9"],
Cell[CellGroupData[{
Cell[281790, 7550, 2187, 60, 125, "Print",ExpressionUUID->"c014b459-954f-4116-94a2-f759fad2aaaa"],
Cell[283980, 7612, 2187, 60, 125, "Print",ExpressionUUID->"74dd0e08-7f81-432a-a643-91087ac1c1be"],
Cell[286170, 7674, 2185, 60, 125, "Print",ExpressionUUID->"d703cecf-13f6-4ec1-a1c2-34a2f9594c64"],
Cell[288358, 7736, 2185, 60, 125, "Print",ExpressionUUID->"0b263111-e024-45ee-95d7-a2bb0f665533"],
Cell[290546, 7798, 2185, 60, 125, "Print",ExpressionUUID->"2a2eb02a-478c-4280-911a-8a59342691fb"],
Cell[292734, 7860, 2193, 60, 125, "Print",ExpressionUUID->"5736395b-2235-4338-9179-22742116b3a3"],
Cell[294930, 7922, 2185, 60, 112, "Print",ExpressionUUID->"762c12b1-997f-429d-a931-4d5bcc7783b7"],
Cell[297118, 7984, 2195, 60, 125, "Print",ExpressionUUID->"71767970-d02a-4744-ab70-6e399dc7164d"],
Cell[299316, 8046, 2187, 60, 112, "Print",ExpressionUUID->"0b2513ae-f2b2-48c4-b050-073fcb8b12be"],
Cell[301506, 8108, 2197, 60, 125, "Print",ExpressionUUID->"6b7f152c-8687-4cf6-b723-842446cd72ac"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[303752, 8174, 631, 16, 97, "Input",ExpressionUUID->"f474c17d-9f9a-4551-a8aa-cdd585dd3e59"],
Cell[304386, 8192, 361, 10, 67, "Output",ExpressionUUID->"cb59fa6e-7906-4e5f-b41d-181582050e6a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[304784, 8207, 608, 17, 65, "Input",ExpressionUUID->"a3b792fd-034e-41f5-a329-a2399e734a14"],
Cell[305395, 8226, 421, 11, 67, "Output",ExpressionUUID->"d4505159-0fae-48e0-8685-c903d35531c8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[305853, 8242, 386, 8, 65, "Input",ExpressionUUID->"1affe30e-36ea-4f37-a475-4a84f757758c"],
Cell[306242, 8252, 391, 11, 67, "Output",ExpressionUUID->"af01eb2d-7831-4c50-a9ec-443073154973"]
}, Open  ]],
Cell[CellGroupData[{
Cell[306670, 8268, 383, 8, 65, "Input",ExpressionUUID->"9d8e09e6-31b3-47e2-a791-fc4cb11c6756"],
Cell[307056, 8278, 393, 11, 67, "Output",ExpressionUUID->"8005b078-2c7d-492d-bace-3611a77ee192"]
}, Open  ]]
}
]
*)

