(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    168547,       3658]
NotebookOptionsPosition[    167920,       3639]
NotebookOutlinePosition[    168351,       3656]
CellTagsIndexPosition[    168308,       3653]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "KArbol", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"combinatorica", "\[Rule]", "False"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"KArbol", "[", 
   RowBox[{"Ak_", ",", "An_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"Quiet", "[", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"BooleanQ", "[", 
        RowBox[{"OptionValue", "[", "combinatorica", "]"}], "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"IntegerQ", "[", "Ak", "]"}], "&&", 
          RowBox[{"IntegerQ", "[", "An", "]"}]}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Ak", "\[GreaterEqual]", "1"}], "&&", 
            RowBox[{"An", "\[GreaterEqual]", "1"}]}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"OptionValue", "[", "combinatorica", "]"}], ",", 
             RowBox[{
              RowBox[{"Clear", "[", "Global`G", "]"}], ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"GrafoCQ", "[", 
                 RowBox[{"CompleteKaryTree", "[", 
                  RowBox[{"An", ",", "Ak"}], "]"}], "]"}], ",", 
                RowBox[{"ShowGraph", "[", 
                 RowBox[{
                  RowBox[{"Global`G", "=", 
                   RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"CompleteKaryTree", "[", 
                    RowBox[{"An", ",", "Ak"}], "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ",", 
                  RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                  RowBox[{"PlotRange", "\[Rule]", "0.1"}]}], "]"}], ",", 
                "\"\<NaD\>\""}], "]"}]}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"GrafoQ", "[", 
                RowBox[{"KaryTree", "[", 
                 RowBox[{"An", ",", "Ak"}], "]"}], "]"}], ",", 
               RowBox[{"KaryTree", "[", 
                RowBox[{"An", ",", "Ak", ",", 
                 RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                 RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
               "\"\<NaD\>\""}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "Arbol", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
     RowBox[{"pesos", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
     RowBox[{"shape", "\[Rule]", "\"\<circulo\>\""}], ",", 
     RowBox[{"verticescoordenadas", "\[Rule]", 
      RowBox[{"{", "}"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Arbol", "[", 
   RowBox[{"AAristas_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "AAristasNoDirigidas", ",", "AAristasDirigidas", ",", "ALabelsPesos", 
      ",", "GrafoArbol"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"AAristasNoDirigidas", "[", "AOAritas_", "]"}], ":=", 
      RowBox[{"Quiet", "[", 
       RowBox[{"Cases", "[", 
        RowBox[{"AOAritas", ",", 
         RowBox[{"Aicontador1_", "\[Rule]", 
          RowBox[{"UndirectedEdge", "[", 
           RowBox[{
            RowBox[{"Aicontador1", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Aicontador1", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"AAristasDirigidas", "[", "AOAritas_", "]"}], ":=", 
      RowBox[{"Quiet", "[", 
       RowBox[{"Cases", "[", 
        RowBox[{"AOAritas", ",", 
         RowBox[{"Aicontador2_", "\[Rule]", 
          RowBox[{"DirectedEdge", "[", 
           RowBox[{
            RowBox[{"Aicontador2", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Aicontador2", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"ALabelsPesos", "[", 
       RowBox[{"GGrafoArbol_", ",", "APesos_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "APesos", "]"}], "\[Equal]", 
         RowBox[{"EdgeCount", "[", "GGrafoArbol", "]"}]}], ",", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AList1", "=", 
             RowBox[{"EdgeList", "[", "GGrafoArbol", "]"}]}], ",", 
            RowBox[{"AList2", "=", 
             RowBox[{"{", "}"}]}]}], "}"}], ",", 
          RowBox[{
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"Ai1", "=", "1"}], ",", 
             RowBox[{"Ai1", "\[LessEqual]", 
              RowBox[{"Length", "[", "AList1", "]"}]}], ",", 
             RowBox[{
              RowBox[{"AList2", "=", 
               RowBox[{"Append", "[", 
                RowBox[{"AList2", ",", 
                 RowBox[{
                  RowBox[{"AList1", "[", 
                   RowBox[{"[", "Ai1", "]"}], "]"}], "\[Rule]", 
                  RowBox[{"APesos", "[", 
                   RowBox[{"[", "Ai1", "]"}], "]"}]}]}], "]"}]}], ";", 
              RowBox[{"Ai1", "++"}]}]}], "]"}], ";", "AList2"}]}], "]"}]}], 
       "]"}]}], ";", 
     RowBox[{
      RowBox[{"GrafoArbol", "[", "AOAristas_", "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "AVl1", "}"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
               RowBox[{"{", "}"}]}], ",", 
              RowBox[{
               RowBox[{"AVl1", "=", 
                RowBox[{"ALabelsPesos", "[", 
                 RowBox[{
                  RowBox[{"TreeGraph", "[", 
                   RowBox[{
                    RowBox[{"AAristasDirigidas", "[", "AOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"VertexCoordinates", "\[Rule]", 
                    RowBox[{
                    "OptionValue", "[", "verticescoordenadas", "]"}]}]}], 
                   "]"}], ",", 
                  RowBox[{"ConstantArray", "[", 
                   RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "AOAristas", "]"}]}], "]"}]}], 
                 "]"}]}], ";", 
               RowBox[{"TreeGraph", "[", 
                RowBox[{
                 RowBox[{"AAristasDirigidas", "[", "AOAristas", "]"}], ",", 
                 RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                 RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                 RowBox[{"System`EdgeWeight", "\[Rule]", 
                  RowBox[{"ConstantArray", "[", 
                   RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "AOAristas", "]"}]}], "]"}]}], ",", 
                 RowBox[{"EdgeLabels", "\[Rule]", "AVl1"}], ",", 
                 RowBox[{"VertexShapeFunction", "\[Rule]", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<circulo\>\""}], ",", "\"\<Circle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<triangulo\>\""}], ",", "\"\<Triangle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<cuadrado\>\""}], ",", "\"\<Square\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<rectangulo\>\""}], ",", "\"\<Rectangle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<pentagono\>\""}], ",", "\"\<Pentagon\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<hexagono\>\""}], ",", "\"\<Hexagon\>\"", ",", 
                    "\"\<Octagon\>\""}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], ",", 
                 RowBox[{"VertexCoordinates", "\[Rule]", 
                  RowBox[{
                  "OptionValue", "[", "verticescoordenadas", "]"}]}]}], 
                "]"}]}], ",", 
              RowBox[{
               RowBox[{"AVl1", "=", 
                RowBox[{"ALabelsPesos", "[", 
                 RowBox[{
                  RowBox[{"TreeGraph", "[", 
                   RowBox[{
                    RowBox[{"AAristasDirigidas", "[", "AOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"VertexCoordinates", "\[Rule]", 
                    RowBox[{
                    "OptionValue", "[", "verticescoordenadas", "]"}]}]}], 
                   "]"}], ",", 
                  RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], ";", 
               RowBox[{"TreeGraph", "[", 
                RowBox[{
                 RowBox[{"AAristasDirigidas", "[", "AOAristas", "]"}], ",", 
                 RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                 RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                 RowBox[{"System`EdgeWeight", "\[Rule]", 
                  RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                 RowBox[{"EdgeLabels", "\[Rule]", "AVl1"}], ",", 
                 RowBox[{"VertexShapeFunction", "\[Rule]", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<circulo\>\""}], ",", "\"\<Circle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<triangulo\>\""}], ",", "\"\<Triangle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<cuadrado\>\""}], ",", "\"\<Square\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<rectangulo\>\""}], ",", "\"\<Rectangle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<pentagono\>\""}], ",", "\"\<Pentagon\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<hexagono\>\""}], ",", "\"\<Hexagon\>\"", ",", 
                    "\"\<Octagon\>\""}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], ",", 
                 RowBox[{"VertexCoordinates", "\[Rule]", 
                  RowBox[{
                  "OptionValue", "[", "verticescoordenadas", "]"}]}]}], 
                "]"}]}]}], "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
               RowBox[{"{", "}"}]}], ",", 
              RowBox[{
               RowBox[{"AVl1", "=", 
                RowBox[{"ALabelsPesos", "[", 
                 RowBox[{
                  RowBox[{"TreeGraph", "[", 
                   RowBox[{
                    RowBox[{"AAristasNoDirigidas", "[", "AOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"VertexCoordinates", "\[Rule]", 
                    RowBox[{
                    "OptionValue", "[", "verticescoordenadas", "]"}]}]}], 
                   "]"}], ",", 
                  RowBox[{"ConstantArray", "[", 
                   RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "AOAristas", "]"}]}], "]"}]}], 
                 "]"}]}], ";", 
               RowBox[{"TreeGraph", "[", 
                RowBox[{
                 RowBox[{"AAristasNoDirigidas", "[", "AOAristas", "]"}], ",", 
                 RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                 RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                 RowBox[{"System`EdgeWeight", "\[Rule]", 
                  RowBox[{"ConstantArray", "[", 
                   RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "AOAristas", "]"}]}], "]"}]}], ",", 
                 RowBox[{"EdgeLabels", "\[Rule]", "AVl1"}], ",", 
                 RowBox[{"VertexShapeFunction", "\[Rule]", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<circulo\>\""}], ",", "\"\<Circle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<triangulo\>\""}], ",", "\"\<Triangle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<cuadrado\>\""}], ",", "\"\<Square\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<rectangulo\>\""}], ",", "\"\<Rectangle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<pentagono\>\""}], ",", "\"\<Pentagon\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<hexagono\>\""}], ",", "\"\<Hexagon\>\"", ",", 
                    "\"\<Octagon\>\""}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], ",", 
                 RowBox[{"VertexCoordinates", "\[Rule]", 
                  RowBox[{
                  "OptionValue", "[", "verticescoordenadas", "]"}]}]}], 
                "]"}]}], ",", 
              RowBox[{
               RowBox[{"AVl1", "=", 
                RowBox[{"ALabelsPesos", "[", 
                 RowBox[{
                  RowBox[{"TreeGraph", "[", 
                   RowBox[{
                    RowBox[{"AAristasNoDirigidas", "[", "AOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"VertexCoordinates", "\[Rule]", 
                    RowBox[{
                    "OptionValue", "[", "verticescoordenadas", "]"}]}]}], 
                   "]"}], ",", 
                  RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], ";", 
               RowBox[{"TreeGraph", "[", 
                RowBox[{
                 RowBox[{"AAristasNoDirigidas", "[", "AOAristas", "]"}], ",", 
                 RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                 RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                 RowBox[{"System`EdgeWeight", "\[Rule]", 
                  RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                 RowBox[{"EdgeLabels", "\[Rule]", "AVl1"}], ",", 
                 RowBox[{"VertexShapeFunction", "\[Rule]", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<circulo\>\""}], ",", "\"\<Circle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<triangulo\>\""}], ",", "\"\<Triangle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<cuadrado\>\""}], ",", "\"\<Square\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<rectangulo\>\""}], ",", "\"\<Rectangle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<pentagono\>\""}], ",", "\"\<Pentagon\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<hexagono\>\""}], ",", "\"\<Hexagon\>\"", ",", 
                    "\"\<Octagon\>\""}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], ",", 
                 RowBox[{"VertexCoordinates", "\[Rule]", 
                  RowBox[{
                  "OptionValue", "[", "verticescoordenadas", "]"}]}]}], 
                "]"}]}]}], "]"}]}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
            RowBox[{"TreeGraph", "[", 
             RowBox[{
              RowBox[{"AAristasDirigidas", "[", "AOAristas", "]"}], ",", 
              RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
              RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
              RowBox[{"System`EdgeWeight", "\[Rule]", 
               RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
              RowBox[{"VertexShapeFunction", "\[Rule]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                  "\"\<circulo\>\""}], ",", "\"\<Circle\>\"", ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<triangulo\>\""}], ",", "\"\<Triangle\>\"", ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<cuadrado\>\""}], ",", "\"\<Square\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<rectangulo\>\""}], ",", "\"\<Rectangle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<pentagono\>\""}], ",", "\"\<Pentagon\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<hexagono\>\""}], ",", "\"\<Hexagon\>\"", ",", 
                    "\"\<Octagon\>\""}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                  "]"}]}], "]"}]}], ",", 
              RowBox[{"VertexCoordinates", "\[Rule]", 
               RowBox[{"OptionValue", "[", "verticescoordenadas", "]"}]}]}], 
             "]"}], ",", 
            RowBox[{"TreeGraph", "[", 
             RowBox[{
              RowBox[{"AAristasNoDirigidas", "[", "AOAristas", "]"}], ",", 
              RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
              RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
              RowBox[{"System`EdgeWeight", "\[Rule]", 
               RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
              RowBox[{"VertexShapeFunction", "\[Rule]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                  "\"\<circulo\>\""}], ",", "\"\<Circle\>\"", ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<triangulo\>\""}], ",", "\"\<Triangle\>\"", ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<cuadrado\>\""}], ",", "\"\<Square\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<rectangulo\>\""}], ",", "\"\<Rectangle\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<pentagono\>\""}], ",", "\"\<Pentagon\>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], "\[Equal]", 
                    "\"\<hexagono\>\""}], ",", "\"\<Hexagon\>\"", ",", 
                    "\"\<Octagon\>\""}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                  "]"}]}], "]"}]}], ",", 
              RowBox[{"VertexCoordinates", "\[Rule]", 
               RowBox[{"OptionValue", "[", "verticescoordenadas", "]"}]}]}], 
             "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], "&&", 
        RowBox[{"VectorQ", "[", 
         RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], "&&", 
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
        RowBox[{"StringQ", "[", 
         RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"OptionValue", "[", "pesos", "]"}], ",", "Null"}], "]"}], 
          "\[Equal]", "False"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MatrixQ", "[", "AAristas", "]"}], "&&", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{
               RowBox[{"Flatten", "[", "AAristas", "]"}], ",", "Null"}], 
              "]"}], "\[Equal]", "False"}]}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Dimensions", "[", "AAristas", "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&&", 
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"ToCharacterCode", "[", 
                  RowBox[{"ToString", "[", "AAristas", "]"}], "]"}], ",", 
                 "62760"}], "]"}], "\[Equal]", "False"}]}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", "AAristas", "]"}], "\[Equal]", 
                 RowBox[{"Length", "[", 
                  RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}]}], "||", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                 RowBox[{"{", "}"}]}]}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"MemberQ", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    "\"\<circulo\>\"", ",", "\"\<triangulo\>\"", ",", 
                    "\"\<cuadrado\>\"", ",", "\"\<rectangulo\>\"", ",", 
                    "\"\<pentagono\>\"", ",", "\"\<hexagono\>\"", ",", 
                    "\"\<octagono\>\""}], "}"}], ",", 
                   RowBox[{"OptionValue", "[", "shape", "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"TreeGraphQ", "[", 
                    RowBox[{"Grafo", "[", "AAristas", "]"}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoQ", "[", 
                    RowBox[{"TreeGraph", "[", 
                    RowBox[{"AAristasDirigidas", "[", "AAristas", "]"}], 
                    "]"}], "]"}], ",", 
                    RowBox[{"GrafoArbol", "[", "AAristas", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoQ", "[", 
                    RowBox[{"TreeGraph", "[", 
                    RowBox[{"AAristasNoDirigidas", "[", "AAristas", "]"}], 
                    "]"}], "]"}], ",", 
                    RowBox[{"GrafoArbol", "[", "AAristas", "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ArbolR", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"dirigido", "->", "False"}], ",", 
     RowBox[{"pesos", "->", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"mostrarpesos", "->", "False"}], ",", 
     RowBox[{"shape", "->", "\"\<circulo\>\""}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ArbolR", "[", 
   RowBox[{"AAristas_", ",", "ARaiz_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"AArbolAuxiliar1", ",", "AList3", ",", "AristasToTreePlot"}], 
     "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"AristasToTreePlot", "[", "AOAristas_", "]"}], ":=", 
      RowBox[{"Quiet", "[", 
       RowBox[{"Cases", "[", 
        RowBox[{"AOAristas", ",", 
         RowBox[{"Aicontador3_", "->", 
          RowBox[{"Rule", "[", 
           RowBox[{
            RowBox[{"Aicontador3", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Aicontador3", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], "&&", 
        RowBox[{"VectorQ", "[", 
         RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], "&&", 
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
        RowBox[{"StringQ", "[", 
         RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"OptionValue", "[", "pesos", "]"}], ",", "Null"}], "]"}], 
          "==", "False"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MatrixQ", "[", "AAristas", "]"}], "&&", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{
               RowBox[{"Flatten", "[", "AAristas", "]"}], ",", "Null"}], 
              "]"}], "==", "False"}]}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Dimensions", "[", "AAristas", "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}], "==", "2"}], "&&", 
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"ToCharacterCode", "[", 
                  RowBox[{"ToString", "[", "AAristas", "]"}], "]"}], ",", 
                 "62760"}], "]"}], "==", "False"}]}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", "AAristas", "]"}], "==", 
                 RowBox[{"Length", "[", 
                  RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}]}], "||", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "pesos", "]"}], "==", 
                 RowBox[{"{", "}"}]}]}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"MemberQ", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    "\"\<circulo\>\"", ",", "\"\<triangulo\>\"", ",", 
                    "\"\<cuadrado\>\"", ",", "\"\<rectangulo\>\"", ",", 
                    "\"\<pentagono\>\"", ",", "\"\<hexagono\>\"", ",", 
                    "\"\<octagono\>\""}], "}"}], ",", 
                   RowBox[{"OptionValue", "[", "shape", "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"TreeGraphQ", "[", 
                    RowBox[{"Grafo", "[", "AAristas", "]"}], "]"}], ",", 
                   RowBox[{
                    RowBox[{"AArbolAuxiliar1", "=", 
                    RowBox[{"Arbol", "[", "AAristas", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "AArbolAuxiliar1", "]"}], ",", 
                    "ARaiz"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"AArbolAuxiliar1", "=", 
                    RowBox[{"TreePlot", "[", 
                    RowBox[{
                    RowBox[{"AristasToTreePlot", "[", 
                    RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", "AArbolAuxiliar1", "]"}], "]"}], 
                    "]"}], ",", "Automatic", ",", "ARaiz", ",", 
                    RowBox[{"VertexLabeling", "->", "True"}], ",", 
                    RowBox[{"ImagePadding", "->", "10"}]}], "]"}]}], ";", 
                    RowBox[{"AList3", "=", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"Cases", "[", 
                    RowBox[{
                    RowBox[{"AArbolAuxiliar1", "//", "InputForm"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"VertexCoordinateRules", "->", "Aicontador4_"}], 
                    ")"}], ":>", "Aicontador4"}], ",", 
                    RowBox[{"-", "1"}]}], "]"}], ",", "1"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "AList3", "]"}], "==", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{"AList3", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{
                    RowBox[{"Cases", "[", 
                    RowBox[{
                    RowBox[{"AArbolAuxiliar1", "//", "InputForm"}], ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"_", ",", "_"}], "]"}], ",", 
                    RowBox[{"-", "1"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_"}], "}"}], ",", 
                    RowBox[{"-", "1"}]}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"Arbol", "[", 
                    RowBox[{"AAristas", ",", 
                    RowBox[{"dirigido", "->", 
                    RowBox[{"OptionValue", "[", "dirigido", "]"}]}], ",", 
                    RowBox[{"pesos", "->", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"mostrarpesos", "->", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "->", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}], ",", 
                    RowBox[{"verticescoordenadas", "->", "AList3"}]}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
          "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ArbolQ", "[", "AArbol_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"GrafoQ", "[", "AArbol", "]"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"TreeGraphQ", "[", "AArbol", "]"}], ",", "True", ",", "False"}],
      "]"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"GrafoCQ", "[", "AArbol", "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"TreeQ", "[", "AArbol", "]"}], ",", "True", ",", "False"}], 
       "]"}], ",", "False"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "Hojas", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"raiz", "\[Rule]", "\"\<\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hojas", "[", 
   RowBox[{"AArbol_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "AArbolAuxiliar7", "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"GrafoQ", "[", "AArbol", "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ArbolQ", "[", "AArbol", "]"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{"OptionValue", "[", "raiz", "]"}], "]"}], "\[Equal]", 
           RowBox[{"ToString", "[", "\"\<\>\"", "]"}]}], ",", 
          RowBox[{"Select", "[", 
           RowBox[{
            RowBox[{"VertexList", "[", "AArbol", "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"VertexDegree", "[", 
               RowBox[{"AArbol", ",", "#"}], "]"}], "\[Equal]", "1"}], 
             "&"}]}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"VertexList", "[", "AArbol", "]"}], ",", 
              RowBox[{"OptionValue", "[", "raiz", "]"}]}], "]"}], ",", 
            RowBox[{"Complement", "[", 
             RowBox[{
              RowBox[{"Select", "[", 
               RowBox[{
                RowBox[{"VertexList", "[", "AArbol", "]"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"VertexDegree", "[", 
                   RowBox[{"AArbol", ",", "#"}], "]"}], "\[Equal]", "1"}], 
                 "&"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"OptionValue", "[", "raiz", "]"}], "}"}]}], "]"}]}], 
           "]"}]}], "]"}]}], "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"GrafoCQ", "[", "AArbol", "]"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ArbolQ", "[", "AArbol", "]"}], ",", 
          RowBox[{
           RowBox[{"AArbolAuxiliar7", "=", 
            RowBox[{"CombinatoricaToGraph", "[", "AArbol", "]"}]}], ";", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"OptionValue", "[", "raiz", "]"}], "]"}], "\[Equal]", 
              RowBox[{"ToString", "[", "\"\<\>\"", "]"}]}], ",", 
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{"VertexList", "[", "AArbolAuxiliar7", "]"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"VertexDegree", "[", 
                  RowBox[{"AArbolAuxiliar7", ",", "#"}], "]"}], "\[Equal]", 
                 "1"}], "&"}]}], "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"VertexList", "[", "AArbolAuxiliar7", "]"}], ",", 
                 RowBox[{"OptionValue", "[", "raiz", "]"}]}], "]"}], ",", 
               RowBox[{"Complement", "[", 
                RowBox[{
                 RowBox[{"Select", "[", 
                  RowBox[{
                   RowBox[{"VertexList", "[", "AArbolAuxiliar7", "]"}], ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"VertexDegree", "[", 
                    RowBox[{"AArbolAuxiliar7", ",", "#"}], "]"}], "\[Equal]", 
                    "1"}], "&"}]}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"OptionValue", "[", "raiz", "]"}], "}"}]}], "]"}]}],
               "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Altura", "[", 
   RowBox[{"AArbol_", ",", "ARaiz_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"AArbolAuxiliar8", ",", "AArbolAuxiliar9"}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"GrafoQ", "[", "AArbol", "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ArbolQ", "[", "AArbol", "]"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"VertexList", "[", "AArbol", "]"}], ",", "ARaiz"}], "]"}],
           ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"GrafoDirigidoQ", "[", "AArbol", "]"}], ",", 
            RowBox[{
             RowBox[{"AArbolAuxiliar9", "=", 
              RowBox[{"Grafo", "[", 
               RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                RowBox[{"EdgeList", "[", "AArbol", "]"}], "]"}], "]"}]}], ";", 
             RowBox[{"VertexEccentricity", "[", 
              RowBox[{"AArbolAuxiliar9", ",", "ARaiz"}], "]"}]}], ",", 
            RowBox[{"VertexEccentricity", "[", 
             RowBox[{"AArbol", ",", "ARaiz"}], "]"}]}], "]"}]}], "]"}]}], 
       "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"GrafoCQ", "[", "AArbol", "]"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ArbolQ", "[", "AArbol", "]"}], ",", 
          RowBox[{
           RowBox[{"AArbolAuxiliar8", "=", 
            RowBox[{"CombinatoricaToGraph", "[", "AArbol", "]"}]}], ";", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{
               RowBox[{"VertexList", "[", "AArbolAuxiliar8", "]"}], ",", 
               "ARaiz"}], "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"GrafoDirigidoQ", "[", "AArbolAuxiliar8", "]"}], ",", 
               RowBox[{
                RowBox[{"AArbolAuxiliar9", "=", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                   RowBox[{"EdgeList", "[", "AArbolAuxiliar8", "]"}], "]"}], 
                  "]"}]}], ";", 
                RowBox[{"VertexEccentricity", "[", 
                 RowBox[{"AArbolAuxiliar9", ",", "ARaiz"}], "]"}]}], ",", 
               RowBox[{"VertexEccentricity", "[", 
                RowBox[{"AArbolAuxiliar8", ",", "ARaiz"}], "]"}]}], "]"}]}], 
            "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AristasWolframSystemToCombinatorica", "[", "GAristasGrafo_", "]"}],
   ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"GGrafoAuxiliar1", "=", 
      RowBox[{"System`Graph", "[", "GAristasGrafo", "]"}]}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"GraphQ", "[", "GGrafoAuxiliar1", "]"}], ",", 
      RowBox[{"Quiet", "[", 
       RowBox[{"Cases", "[", 
        RowBox[{"GAristasGrafo", ",", 
         RowBox[{"Gicontador1_", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Gicontador1", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Gicontador1", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "]"}], "]"}]}], 
     "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AristasMixtasQ", "[", "GGrafo_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Select", "[", 
         RowBox[{
          RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"DirectedEdge", "[", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", "#"}], 
           "&"}]}], "]"}], "\[NotEqual]", 
        RowBox[{"{", "}"}]}], "&&", 
       RowBox[{
        RowBox[{"Select", "[", 
         RowBox[{
          RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"UndirectedEdge", "[", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", "#"}], 
           "&"}]}], "]"}], "\[NotEqual]", 
        RowBox[{"{", "}"}]}]}], ",", "True", ",", "False"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "Grafo", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
     RowBox[{"vertices", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
     RowBox[{"pesos", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
     RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Grafo", "[", 
   RowBox[{"GAristas_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "GAristasNoDirigidas", ",", "GAristasDirigidas", ",", "GLabelsPesos", 
      ",", "Grafo3d", ",", "GrafoNo3d"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"GAristasNoDirigidas", "[", "GOAritas_", "]"}], ":=", 
      RowBox[{"Quiet", "[", 
       RowBox[{"Cases", "[", 
        RowBox[{"GOAritas", ",", 
         RowBox[{"Gicontador4_", "\[Rule]", 
          RowBox[{"UndirectedEdge", "[", 
           RowBox[{
            RowBox[{"Gicontador4", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Gicontador4", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"GAristasDirigidas", "[", "GOAritas_", "]"}], ":=", 
      RowBox[{"Quiet", "[", 
       RowBox[{"Cases", "[", 
        RowBox[{"GOAritas", ",", 
         RowBox[{"Gicontador5_", "\[Rule]", 
          RowBox[{"DirectedEdge", "[", 
           RowBox[{
            RowBox[{"Gicontador5", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Gicontador5", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"GLabelsPesos", "[", 
       RowBox[{"GGrafo_", ",", "GPesos_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "GPesos", "]"}], "\[Equal]", 
         RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GList1", "=", 
             RowBox[{"EdgeList", "[", "GGrafo", "]"}]}], ",", 
            RowBox[{"GList2", "=", 
             RowBox[{"{", "}"}]}]}], "}"}], ",", 
          RowBox[{
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"Gi1", "=", "1"}], ",", 
             RowBox[{"Gi1", "\[LessEqual]", 
              RowBox[{"Length", "[", "GList1", "]"}]}], ",", 
             RowBox[{
              RowBox[{"GList2", "=", 
               RowBox[{"Append", "[", 
                RowBox[{"GList2", ",", 
                 RowBox[{
                  RowBox[{"GList1", "[", 
                   RowBox[{"[", "Gi1", "]"}], "]"}], "\[Rule]", 
                  RowBox[{"GPesos", "[", 
                   RowBox[{"[", "Gi1", "]"}], "]"}]}]}], "]"}]}], ";", 
              RowBox[{"Gi1", "++"}]}]}], "]"}], ";", "GList2"}]}], "]"}]}], 
       "]"}]}], ";", 
     RowBox[{
      RowBox[{"Grafo3d", "[", "GOAristas_", "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "GVl1", "}"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                 RowBox[{"{", "}"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                   "]"}]}], ";", 
                 RowBox[{"Graph3D", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                   RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                 ";", 
                 RowBox[{"Graph3D", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                   RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                 RowBox[{"{", "}"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                   "]"}]}], ";", 
                 RowBox[{"Graph3D", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                   ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                   RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                 ";", 
                 RowBox[{"Graph3D", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                   ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                   RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
              RowBox[{"Graph3D", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                RowBox[{"System`EdgeWeight", "\[Rule]", 
                 RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                RowBox[{"VertexShapeFunction", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                  ")"}]}]}], "]"}], ",", 
              RowBox[{"Graph3D", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], ",", 
                RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                RowBox[{"System`EdgeWeight", "\[Rule]", 
                 RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                RowBox[{"VertexShapeFunction", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                  ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                 RowBox[{"{", "}"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                   "]"}]}], ";", 
                 RowBox[{"Graph3D", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                   RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                 ";", 
                 RowBox[{"Graph3D", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                   RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
               "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                 RowBox[{"{", "}"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                   "]"}]}], ";", 
                 RowBox[{"Graph3D", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                   ",", 
                   RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                 ";", 
                 RowBox[{"Graph3D", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                   ",", 
                   RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
               "]"}]}], "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
              RowBox[{"Graph3D", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                RowBox[{"System`EdgeWeight", "\[Rule]", 
                 RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], ",", 
              RowBox[{"Graph3D", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], ",", 
                RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                RowBox[{"System`EdgeWeight", "\[Rule]", 
                 RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
             "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"GrafoNo3d", "[", "GOAristas_", "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "GVl1", "}"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                 RowBox[{"{", "}"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                   "]"}]}], ";", 
                 RowBox[{"System`Graph", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                   RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                 ";", 
                 RowBox[{"System`Graph", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                   RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                 RowBox[{"{", "}"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                   "]"}]}], ";", 
                 RowBox[{"System`Graph", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                   ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                   RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                 ";", 
                 RowBox[{"System`Graph", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                   ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                   RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
              RowBox[{"System`Graph", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                RowBox[{"System`EdgeWeight", "\[Rule]", 
                 RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                RowBox[{"VertexShapeFunction", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                  ")"}]}]}], "]"}], ",", 
              RowBox[{"System`Graph", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], ",", 
                RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                RowBox[{"System`EdgeWeight", "\[Rule]", 
                 RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                RowBox[{"VertexShapeFunction", "\[Rule]", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                  ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                 RowBox[{"{", "}"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                   "]"}]}], ";", 
                 RowBox[{"System`Graph", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                   RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                 ";", 
                 RowBox[{"System`Graph", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                   RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
               "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                 RowBox[{"{", "}"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                   "]"}]}], ";", 
                 RowBox[{"System`Graph", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                   ",", 
                   RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl1", "=", 
                  RowBox[{"GLabelsPesos", "[", 
                   RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                 ";", 
                 RowBox[{"System`Graph", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                   RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                   ",", 
                   RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                   RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                   RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
               "]"}]}], "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
              RowBox[{"System`Graph", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                RowBox[{"System`EdgeWeight", "\[Rule]", 
                 RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], ",", 
              RowBox[{"System`Graph", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], ",", 
                RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                RowBox[{"System`EdgeWeight", "\[Rule]", 
                 RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
             "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], "&&", 
        RowBox[{"VectorQ", "[", 
         RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}], "&&", 
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
        RowBox[{"VectorQ", "[", 
         RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], "&&", 
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{
             RowBox[{"OptionValue", "[", "vertices", "]"}], ",", "Null"}], 
            "]"}], "\[Equal]", "False"}], "&&", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{
             RowBox[{"OptionValue", "[", "pesos", "]"}], ",", "Null"}], "]"}],
            "\[Equal]", "False"}]}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"MatrixQ", "[", "GAristas", "]"}], "||", 
              RowBox[{
               RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
               RowBox[{"ToString", "[", 
                RowBox[{"{", "}"}], "]"}]}]}], ")"}], "&&", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{
               RowBox[{"Flatten", "[", "GAristas", "]"}], ",", "Null"}], 
              "]"}], "\[Equal]", "False"}]}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"Length", "[", "GAristas", "]"}], "\[Equal]", 
               RowBox[{"Length", "[", 
                RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}]}], "||", 
              RowBox[{
               RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
               RowBox[{"{", "}"}]}]}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                   RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], "&&", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "vertices", "]"}], 
                   "\[NotEqual]", 
                   RowBox[{"{", "}"}]}]}], ")"}], "||", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"MatrixQ", "[", "GAristas", "]"}], "&&", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Dimensions", "[", "GAristas", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&&", 
                  RowBox[{
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", "GAristas", "]"}], "]"}], ",", 
                    "62760"}], "]"}], "\[Equal]", "False"}]}], ")"}]}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                 RowBox[{"Grafo3d", "[", "GAristas", "]"}], ",", 
                 RowBox[{"GrafoNo3d", "[", "GAristas", "]"}]}], "]"}]}], 
              "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PesosAristas", "[", "GGrafo_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"WeightedGraphQ", "[", "GGrafo", "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{"Quiet", "[", 
              RowBox[{"Cases", "[", 
               RowBox[{
                RowBox[{"System`EdgeList", "[", "GGrafo", "]"}], ",", 
                RowBox[{"Gicontador6_", "\[Rule]", " ", 
                 RowBox[{"NumericQ", "[", 
                  RowBox[{"PropertyValue", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", "Gicontador6"}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}], "]"}]}]}], "]"}], "]"}], 
             "]"}], "\[Equal]", 
            RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
           RowBox[{"GList3", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                 RowBox[{"[", "Gi2", "]"}], "]"}], ",", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"GGrafo", ",", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}]}], "}"}], ",", 
                  "System`EdgeWeight"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Gi2", ",", "1", ",", 
                RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], "}"}]}], 
             "]"}]}]}], "]"}], ";", 
         RowBox[{"GList4", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"GList3", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"DirectedEdge", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
         RowBox[{"GList5", "=", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{"GList3", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"UndirectedEdge", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}], "/.", 
           RowBox[{"UndirectedEdge", "\[Rule]", "DirectedEdge"}]}]}], ";", 
         RowBox[{"Join", "[", 
          RowBox[{"GList4", ",", "GList5", ",", 
           RowBox[{"Reverse", "[", 
            RowBox[{"GList5", ",", "3"}], "]"}]}], "]"}]}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"Quiet", "[", 
             RowBox[{"Cases", "[", 
              RowBox[{
               RowBox[{"System`EdgeList", "[", "GGrafo", "]"}], ",", 
               RowBox[{"Gicontador6_", "\[Rule]", " ", 
                RowBox[{"NumericQ", "[", 
                 RowBox[{"PropertyValue", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"GGrafo", ",", "Gicontador6"}], "}"}], ",", 
                   "System`EdgeWeight"}], "]"}], "]"}]}]}], "]"}], "]"}], 
            "]"}], "\[Equal]", 
           RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
               RowBox[{"[", "Gi2", "]"}], "]"}], ",", 
              RowBox[{"PropertyValue", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"GGrafo", ",", 
                  RowBox[{
                   RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                   RowBox[{"[", "Gi2", "]"}], "]"}]}], "}"}], ",", 
                "System`EdgeWeight"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Gi2", ",", "1", ",", 
              RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], "}"}]}], "]"}]}], 
         "]"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ListQ", "[", 
         RowBox[{"Edges", "[", 
          RowBox[{"GGrafo", ",", "EdgeWeight"}], "]"}], "]"}], ",", 
        RowBox[{"Edges", "[", 
         RowBox[{"GGrafo", ",", "EdgeWeight"}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GrafoQ", "[", "GGrafo_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"GraphQ", "[", "GGrafo", "]"}], ",", "True", ",", "False"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GrafoCQ", "[", "GGrafo_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"NumericQ", "[", 
     RowBox[{"V", "[", "GGrafo", "]"}], "]"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"V", "[", "GGrafo", "]"}], "\[Equal]", "0"}], ",", "False", 
      ",", "True"}], "]"}], ",", "False"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "CombinatoricaToGraph", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
     RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
     RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CombinatoricaToGraph", "[", 
   RowBox[{"GGrafo_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"GrafoO3d", ",", "GrafoONo3d"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"GrafoO3d", "[", "GOGrafo_", "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "GVl2", "}"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"UndirectedQ", "[", "GOGrafo", "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"ListQ", "[", 
             RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"GVl2", "=", 
              RowBox[{"Flatten", "[", 
               RowBox[{
                RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}], 
               "]"}]}], ";", 
             RowBox[{"GVl2", "=", 
              RowBox[{"Select", "[", 
               RowBox[{"GVl2", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}], 
                 "&"}]}], "]"}]}], ";", 
             RowBox[{"Grafo", "[", 
              RowBox[{
               RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
               RowBox[{"vertices", "\[Rule]", 
                RowBox[{"Table", "[", 
                 RowBox[{"Gi4", ",", 
                  RowBox[{"{", 
                   RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
               ",", 
               RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
               RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
               RowBox[{"mostrarpesos", "\[Rule]", 
                RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
               RowBox[{"shape", "\[Rule]", 
                RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], ",", 
            RowBox[{"Grafo", "[", 
             RowBox[{
              RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
              RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
              RowBox[{"vertices", "\[Rule]", 
               RowBox[{"Table", "[", 
                RowBox[{"Gi4", ",", 
                 RowBox[{"{", 
                  RowBox[{"Gi4", ",", "1", ",", 
                   RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
              ",", 
              RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
              RowBox[{"mostrarpesos", "\[Rule]", 
               RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
              RowBox[{"shape", "\[Rule]", 
               RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], "]"}],
           ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"ListQ", "[", 
             RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"GVl2", "=", 
              RowBox[{"Flatten", "[", 
               RowBox[{
                RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}], 
               "]"}]}], ";", 
             RowBox[{"GVl2", "=", 
              RowBox[{"Select", "[", 
               RowBox[{"GVl2", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}], 
                 "&"}]}], "]"}]}], ";", 
             RowBox[{"Grafo", "[", 
              RowBox[{
               RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
               RowBox[{"vertices", "\[Rule]", 
                RowBox[{"Table", "[", 
                 RowBox[{"Gi4", ",", 
                  RowBox[{"{", 
                   RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
               ",", 
               RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
               RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
               RowBox[{"mostrarpesos", "\[Rule]", 
                RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
               RowBox[{"shape", "\[Rule]", 
                RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], ",", 
            RowBox[{"Grafo", "[", 
             RowBox[{
              RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
              RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
              RowBox[{"vertices", "\[Rule]", 
               RowBox[{"Table", "[", 
                RowBox[{"Gi4", ",", 
                 RowBox[{"{", 
                  RowBox[{"Gi4", ",", "1", ",", 
                   RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
              ",", 
              RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
              RowBox[{"mostrarpesos", "\[Rule]", 
               RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
              RowBox[{"shape", "\[Rule]", 
               RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
           "]"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"GrafoONo3d", "[", "GOGrafo_", "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "GVl2", "}"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"UndirectedQ", "[", "GOGrafo", "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"ListQ", "[", 
             RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"GVl2", "=", 
              RowBox[{"Flatten", "[", 
               RowBox[{
                RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}], 
               "]"}]}], ";", 
             RowBox[{"GVl2", "=", 
              RowBox[{"Select", "[", 
               RowBox[{"GVl2", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}], 
                 "&"}]}], "]"}]}], ";", 
             RowBox[{"Grafo", "[", 
              RowBox[{
               RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
               RowBox[{"vertices", "\[Rule]", 
                RowBox[{"Table", "[", 
                 RowBox[{"Gi4", ",", 
                  RowBox[{"{", 
                   RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
               ",", 
               RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
               RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
               RowBox[{"mostrarpesos", "\[Rule]", 
                RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
               RowBox[{"shape", "\[Rule]", 
                RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], ",", 
            RowBox[{"Grafo", "[", 
             RowBox[{
              RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
              RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
              RowBox[{"vertices", "\[Rule]", 
               RowBox[{"Table", "[", 
                RowBox[{"Gi4", ",", 
                 RowBox[{"{", 
                  RowBox[{"Gi4", ",", "1", ",", 
                   RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
              ",", 
              RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
              RowBox[{"mostrarpesos", "\[Rule]", 
               RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
              RowBox[{"shape", "\[Rule]", 
               RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], "]"}],
           ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"ListQ", "[", 
             RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"GVl2", "=", 
              RowBox[{"Flatten", "[", 
               RowBox[{
                RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}], 
               "]"}]}], ";", 
             RowBox[{"GVl2", "=", 
              RowBox[{"Select", "[", 
               RowBox[{"GVl2", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}], 
                 "&"}]}], "]"}]}], ";", 
             RowBox[{"Grafo", "[", 
              RowBox[{
               RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
               RowBox[{"vertices", "\[Rule]", 
                RowBox[{"Table", "[", 
                 RowBox[{"Gi4", ",", 
                  RowBox[{"{", 
                   RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
               ",", 
               RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
               RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
               RowBox[{"mostrarpesos", "\[Rule]", 
                RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
               RowBox[{"shape", "\[Rule]", 
                RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], ",", 
            RowBox[{"Grafo", "[", 
             RowBox[{
              RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
              RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
              RowBox[{"vertices", "\[Rule]", 
               RowBox[{"Table", "[", 
                RowBox[{"Gi4", ",", 
                 RowBox[{"{", 
                  RowBox[{"Gi4", ",", "1", ",", 
                   RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
              ",", 
              RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
              RowBox[{"mostrarpesos", "\[Rule]", 
               RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
              RowBox[{"shape", "\[Rule]", 
               RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
           "]"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
        RowBox[{"BooleanQ", "[", 
         RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
           RowBox[{"GrafoO3d", "[", "GGrafo", "]"}], ",", 
           RowBox[{"GrafoONo3d", "[", "GGrafo", "]"}]}], "]"}]}], "]"}]}], 
      "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GrafoDirigidoQ", "[", "GGrafo_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UndirectedGraphQ", "[", "GGrafo", "]"}], ",", "False", ",", 
      "True"}], "]"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"UndirectedQ", "[", "GGrafo", "]"}], ",", "False", ",", 
        "True"}], "]"}]}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6756931078113437`*^9, 3.675693108912405*^9}, {
   3.67576868883158*^9, 3.6757687724447613`*^9}, {3.6757688483196373`*^9, 
   3.675768851055272*^9}, {3.6757688818723497`*^9, 3.675768981605667*^9}, {
   3.675769014492009*^9, 3.675769015740776*^9}, 3.6757690577998495`*^9, {
   3.6757691942483797`*^9, 3.675769195271412*^9}, {3.801154223650434*^9, 
   3.8011542253711414`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"90f86763-8595-4b65-850b-49a3c179ebaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"!", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"{", "Ai6", "}"}], ",", "Null"}], "]"}]}], "&&", 
      RowBox[{"!", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"{", "Ai7", "}"}], ",", "Null"}], "]"}]}]}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"IntegerQ", "[", "Ai6", "]"}], "&&", 
        RowBox[{"IntegerQ", "[", "Ai7", "]"}]}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Ai6", "\[GreaterEqual]", "1"}], "&&", 
          RowBox[{"Ai7", "\[GreaterEqual]", "2"}]}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{
             RowBox[{"VertexList", "[", 
              RowBox[{"KArbol", "[", 
               RowBox[{"Ai6", ",", "Ai7"}], "]"}], "]"}], ",", "Ai5"}], "]"}],
            ",", 
           RowBox[{"Column", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ArbolR", "[", 
                RowBox[{
                 RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                  RowBox[{"EdgeList", "[", 
                   RowBox[{"KArbol", "[", 
                    RowBox[{"Ai6", ",", "Ai7"}], "]"}], "]"}], "]"}], ",", 
                 "Ai5", ",", 
                 RowBox[{"shape", "\[Rule]", "\"\<rectangulo\>\""}]}], "]"}], 
               ",", 
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{"\"\<Las hojas del \[AAcute]rbol son: \>\"", ",", 
                  RowBox[{"Hojas", "[", 
                   RowBox[{
                    RowBox[{"ArbolR", "[", 
                    RowBox[{
                    RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", 
                    RowBox[{"KArbol", "[", 
                    RowBox[{"Ai6", ",", "Ai7"}], "]"}], "]"}], "]"}], ",", 
                    "Ai5"}], "]"}], ",", 
                    RowBox[{"raiz", "\[Rule]", "Ai5"}]}], "]"}]}], "}"}], 
                "]"}], ",", 
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{"\"\<La altura del \[AAcute]rbol es: \>\"", ",", 
                  RowBox[{"Altura", "[", 
                   RowBox[{
                    RowBox[{"ArbolR", "[", 
                    RowBox[{
                    RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", 
                    RowBox[{"KArbol", "[", 
                    RowBox[{"Ai6", ",", "Ai7"}], "]"}], "]"}], "]"}], ",", 
                    "Ai5"}], "]"}], ",", "Ai5"}], "]"}]}], "}"}], "]"}]}], 
              "}"}], ",", "Center"}], "]"}], ",", 
           RowBox[{"Ai5", "=", "1"}]}], "]"}], ",", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"Ai6", "<", "1"}], ",", 
            RowBox[{"Ai6", "=", "8"}]}], "]"}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"Ai7", "<", "2"}], ",", 
            RowBox[{"Ai7", "=", "12"}]}], "]"}]}]}], "]"}], ",", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"IntegerQ", "[", "Ai6", "]"}]}], ",", 
          RowBox[{"Ai6", "=", "8"}]}], "]"}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"IntegerQ", "[", "Ai7", "]"}]}], ",", 
          RowBox[{"Ai7", "=", "12"}]}], "]"}]}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"{", "Ai6", "}"}], ",", "Null"}], "]"}], ",", 
        RowBox[{"Ai6", "=", "8"}]}], "]"}], ";", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"{", "Ai7", "}"}], ",", "Null"}], "]"}], ",", 
        RowBox[{"Ai7", "=", "12"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<Orden y cantidad de v\[EAcute]rtices del \[AAcute]rbol\>\"", ",", 
     "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"Ai6", ",", "8", ",", "\"\<Orden del \[AAcute]rbol\>\""}], "}"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"Ai7", ",", "12", ",", "\"\<Cantidad de nodos\>\""}], "}"}], 
    "}"}], ",", "Delimiter", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Ai5", ",", "1", ",", "\"\<Ra\[IAcute]z\>\""}], "}"}], ",", 
     RowBox[{"VertexList", "[", 
      RowBox[{"KArbol", "[", 
       RowBox[{"Ai6", ",", "Ai7"}], "]"}], "]"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "PopupMenu"}]}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Spacer", "[", 
             RowBox[{"{", 
              RowBox[{"400", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Autor: Enrique V\[IAcute]lchez Quesada\>\"", ",", "Bold", 
                ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}], 
              "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica\>\"", ",", "Bold", ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.12", ",", "0", ",", "0.5"}], "]"}]}], "]"}], 
              "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[CapitalAAcute]rboles\>\"", ",", " ", "Bold", ",", " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6757725040960875`*^9, 3.6757726676833687`*^9}, {
  3.801155526098014*^9, 3.8011555635545297`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"2b091c1b-1b29-4f41-8183-e997d2b44e09"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`Ai5$$ = 1, $CellContext`Ai6$$ = 
    8, $CellContext`Ai7$$ = 12, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[
       Style[
       "Orden y cantidad de v\[EAcute]rtices del \[AAcute]rbol", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`Ai6$$], 8, "Orden del \[AAcute]rbol"}}, {{
       Hold[$CellContext`Ai7$$], 12, "Cantidad de nodos"}}, {{
       Hold[$CellContext`Ai5$$], 1, "Ra\[IAcute]z"}, 
      Dynamic[
       VertexList[
        $CellContext`KArbol[$CellContext`Ai6$$, $CellContext`Ai7$$]]]}}, 
    Typeset`size$$ = {604., {72., 81.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`Ai5$$ = 1, $CellContext`Ai6$$ = 
        8, $CellContext`Ai7$$ = 12}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[
        And[
         Not[
          MemberQ[{$CellContext`Ai6$$}, Null]], 
         Not[
          MemberQ[{$CellContext`Ai7$$}, Null]]], 
        If[
         And[
          IntegerQ[$CellContext`Ai6$$], 
          IntegerQ[$CellContext`Ai7$$]], 
         If[
          And[$CellContext`Ai6$$ >= 1, $CellContext`Ai7$$ >= 2], 
          If[
           MemberQ[
            VertexList[
             $CellContext`KArbol[$CellContext`Ai6$$, $CellContext`Ai7$$]], \
$CellContext`Ai5$$], 
           Column[{
             $CellContext`ArbolR[
              $CellContext`AristasWolframSystemToCombinatorica[
               EdgeList[
                $CellContext`KArbol[$CellContext`Ai6$$, \
$CellContext`Ai7$$]]], $CellContext`Ai5$$, $CellContext`shape -> 
              "rectangulo"], 
             Row[{"Las hojas del \[AAcute]rbol son: ", 
               $CellContext`Hojas[
                $CellContext`ArbolR[
                 $CellContext`AristasWolframSystemToCombinatorica[
                  EdgeList[
                   $CellContext`KArbol[$CellContext`Ai6$$, \
$CellContext`Ai7$$]]], $CellContext`Ai5$$], $CellContext`raiz -> \
$CellContext`Ai5$$]}], 
             Row[{"La altura del \[AAcute]rbol es: ", 
               $CellContext`Altura[
                $CellContext`ArbolR[
                 $CellContext`AristasWolframSystemToCombinatorica[
                  EdgeList[
                   $CellContext`KArbol[$CellContext`Ai6$$, \
$CellContext`Ai7$$]]], $CellContext`Ai5$$], $CellContext`Ai5$$]}]}, 
            Center], $CellContext`Ai5$$ = 1], 
          If[$CellContext`Ai6$$ < 1, $CellContext`Ai6$$ = 8]; 
          If[$CellContext`Ai7$$ < 2, $CellContext`Ai7$$ = 12]], If[
           Not[
            IntegerQ[$CellContext`Ai6$$]], $CellContext`Ai6$$ = 8]; If[
           Not[
            IntegerQ[$CellContext`Ai7$$]], $CellContext`Ai7$$ = 12]], If[
          MemberQ[{$CellContext`Ai6$$}, Null], $CellContext`Ai6$$ = 8]; If[
          MemberQ[{$CellContext`Ai7$$}, Null], $CellContext`Ai7$$ = 12]], 
      "Specifications" :> {
        Style[
        "Orden y cantidad de v\[EAcute]rtices del \[AAcute]rbol", 12, 
         Bold], {{$CellContext`Ai6$$, 8, 
          "Orden del \[AAcute]rbol"}}, {{$CellContext`Ai7$$, 12, 
          "Cantidad de nodos"}}, 
        Delimiter, {{$CellContext`Ai5$$, 1, "Ra\[IAcute]z"}, 
         Dynamic[
          VertexList[
           $CellContext`KArbol[$CellContext`Ai6$$, $CellContext`Ai7$$]]], 
         ControlType -> PopupMenu}}, 
      "Options" :> {Alignment -> Center, FrameLabel -> {{None, None}, {
           Column[{
             Spacer[{400, 2}], 
             Row[{
               Style["Autor: Enrique V\[IAcute]lchez Quesada", Bold, 10, 
                RGBColor[0, 0.333333, 0]]}], 
             Row[{
               Style[
               "Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica", Bold, 10, 
                RGBColor[0.12, 0, 0.5]]}]}, Center], 
           Style["\[CapitalAAcute]rboles", Bold, 
            RGBColor[0, 0.333333, 0]]}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{676., {255., 264.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`KArbol[
         Pattern[$CellContext`Ak, 
          Blank[]], 
         Pattern[$CellContext`An, 
          Blank[]], 
         OptionsPattern[]] := Quiet[
         Module[{}, 
          If[
           BooleanQ[
            OptionValue[$CellContext`combinatorica]], 
           If[
            And[
             IntegerQ[$CellContext`Ak], 
             IntegerQ[$CellContext`An]], 
            If[
             And[$CellContext`Ak >= 1, $CellContext`An >= 1], 
             If[
              OptionValue[$CellContext`combinatorica], Clear[$CellContext`G]; 
              If[
                $CellContext`GrafoCQ[
                 CompleteKaryTree[$CellContext`An, $CellContext`Ak]], 
                $CellContext`ShowGraph[$CellContext`G = \
$CellContext`SetGraphOptions[
                   
                   CompleteKaryTree[$CellContext`An, $CellContext`Ak], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                   Black], $CellContext`VertexLabel -> True, PlotRange -> 
                 0.1], "NaD"], 
              If[
               $CellContext`GrafoQ[
                KaryTree[$CellContext`An, $CellContext`Ak]], 
               
               KaryTree[$CellContext`An, $CellContext`Ak, VertexLabels -> 
                "Name", ImagePadding -> 10], "NaD"]]]]]]], 
       Options[$CellContext`KArbol] = {$CellContext`combinatorica -> 
         False}, $CellContext`GrafoCQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         NumericQ[
          $CellContext`V[$CellContext`GGrafo]], 
         If[$CellContext`V[$CellContext`GGrafo] == 0, False, True], 
         False], $CellContext`GrafoQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         GraphQ[$CellContext`GGrafo], True, False], $CellContext`ArbolR[
         Pattern[$CellContext`AAristas, 
          Blank[]], 
         Pattern[$CellContext`ARaiz, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`AArbolAuxiliar1, $CellContext`AList3, \
$CellContext`AristasToTreePlot}, $CellContext`AristasToTreePlot[
            Pattern[$CellContext`AOAristas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`AOAristas, Pattern[$CellContext`Aicontador3, 
               Blank[]] -> (Part[$CellContext`Aicontador3, 1] -> 
              Part[$CellContext`Aicontador3, 2])]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dirigido]], 
            VectorQ[
             OptionValue[$CellContext`pesos]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            StringQ[
             OptionValue[$CellContext`shape]]], 
           If[MemberQ[
              OptionValue[$CellContext`pesos], Null] == False, 
            If[
             And[
              MatrixQ[$CellContext`AAristas], MemberQ[
                Flatten[$CellContext`AAristas], Null] == False], 
             If[
              And[Part[
                 Dimensions[$CellContext`AAristas], 2] == 2, MemberQ[
                 ToCharacterCode[
                  ToString[$CellContext`AAristas]], 62760] == False], 
              If[
               Or[Length[$CellContext`AAristas] == Length[
                  OptionValue[$CellContext`pesos]], 
                OptionValue[$CellContext`pesos] == {}], 
               If[
                
                MemberQ[{
                 "circulo", "triangulo", "cuadrado", "rectangulo", 
                  "pentagono", "hexagono", "octagono"}, 
                 OptionValue[$CellContext`shape]], 
                If[
                 TreeGraphQ[
                  $CellContext`Grafo[$CellContext`AAristas]], \
$CellContext`AArbolAuxiliar1 = $CellContext`Arbol[$CellContext`AAristas]; If[
                   MemberQ[
                    
                    VertexList[$CellContext`AArbolAuxiliar1], \
$CellContext`ARaiz], $CellContext`AArbolAuxiliar1 = TreePlot[
                    $CellContext`AristasToTreePlot[
                    $CellContext`AristasWolframSystemToCombinatorica[
                    EdgeList[$CellContext`AArbolAuxiliar1]]], 
                    Automatic, $CellContext`ARaiz, VertexLabeling -> True, 
                    ImagePadding -> 10]; $CellContext`AList3 = Flatten[
                    Cases[
                    
                    InputForm[$CellContext`AArbolAuxiliar1], (
                    VertexCoordinateRules -> Pattern[$CellContext`Aicontador4, 
                    Blank[]]) :> $CellContext`Aicontador4, -1], 1]; 
                   If[ToString[$CellContext`AList3] == 
                    ToString[{}], $CellContext`AList3 = Cases[
                    Cases[
                    InputForm[$CellContext`AArbolAuxiliar1], 
                    Disk[
                    Blank[], 
                    Blank[]], -1], {
                    Blank[], 
                    
                    Blank[]}, -1]]; $CellContext`Arbol[$CellContext`AAristas, \
$CellContext`dirigido -> 
                    OptionValue[$CellContext`dirigido], $CellContext`pesos -> 
                    OptionValue[$CellContext`pesos], \
$CellContext`mostrarpesos -> 
                    OptionValue[$CellContext`mostrarpesos], \
$CellContext`shape -> 
                    OptionValue[$CellContext`shape], \
$CellContext`verticescoordenadas -> $CellContext`AList3]]]]]]]]]], 
       Options[$CellContext`ArbolR] = {$CellContext`dirigido -> 
         False, $CellContext`pesos -> {}, $CellContext`mostrarpesos -> 
         False, $CellContext`shape -> "circulo"}, $CellContext`Grafo[
         Pattern[$CellContext`GAristas, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GAristasNoDirigidas, \
$CellContext`GAristasDirigidas, $CellContext`GLabelsPesos, \
$CellContext`Grafo3d, $CellContext`GrafoNo3d}, \
$CellContext`GAristasNoDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador4, 
               Blank[]] -> UndirectedEdge[
               Part[$CellContext`Gicontador4, 1], 
               
               Part[$CellContext`Gicontador4, 
                2]]]]; $CellContext`GAristasDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador5, 
               Blank[]] -> DirectedEdge[
               Part[$CellContext`Gicontador5, 1], 
               Part[$CellContext`Gicontador5, 2]]]]; $CellContext`GLabelsPesos[
            Pattern[$CellContext`GGrafo, 
             Blank[]], 
            Pattern[$CellContext`GPesos, 
             Blank[]]] := 
          If[Length[$CellContext`GPesos] == EdgeCount[$CellContext`GGrafo], 
            
            Module[{$CellContext`GList1 = 
              EdgeList[$CellContext`GGrafo], $CellContext`GList2 = {}}, 
             For[$CellContext`Gi1 = 1, $CellContext`Gi1 <= 
               Length[$CellContext`GList1], $CellContext`GList2 = 
                Append[$CellContext`GList2, 
                  Part[$CellContext`GList1, $CellContext`Gi1] -> 
                  Part[$CellContext`GPesos, $CellContext`Gi1]]; 
               Increment[$CellContext`Gi1]]; $CellContext`GList2]]; \
$CellContext`Grafo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; $CellContext`GrafoNo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dirigido]], 
            VectorQ[
             OptionValue[$CellContext`vertices]], 
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            VectorQ[
             OptionValue[$CellContext`pesos]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            And[MemberQ[
               OptionValue[$CellContext`vertices], Null] == False, MemberQ[
               OptionValue[$CellContext`pesos], Null] == False], 
            If[
             And[
              Or[
               MatrixQ[$CellContext`GAristas], 
               ToString[$CellContext`GAristas] == ToString[{}]], MemberQ[
                Flatten[$CellContext`GAristas], Null] == False], 
             If[
              Or[Length[$CellContext`GAristas] == Length[
                 OptionValue[$CellContext`pesos]], 
               OptionValue[$CellContext`pesos] == {}], 
              If[
               Or[
                And[
                ToString[$CellContext`GAristas] == ToString[{}], 
                 OptionValue[$CellContext`vertices] != {}], 
                And[
                 MatrixQ[$CellContext`GAristas], Part[
                   Dimensions[$CellContext`GAristas], 2] == 2, MemberQ[
                   ToCharacterCode[
                    ToString[$CellContext`GAristas]], 62760] == False]], 
               If[
                OptionValue[$CellContext`dimensions3d], 
                $CellContext`Grafo3d[$CellContext`GAristas], 
                $CellContext`GrafoNo3d[$CellContext`GAristas]]]]]]]], 
       Options[$CellContext`Grafo] = {$CellContext`dirigido -> 
         False, $CellContext`vertices -> {}, $CellContext`dimensions3d -> 
         False, $CellContext`pesos -> {}, $CellContext`mostrarpesos -> 
         False, $CellContext`shape -> False}, $CellContext`Arbol[
         Pattern[$CellContext`AAristas, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`AAristasNoDirigidas, \
$CellContext`AAristasDirigidas, $CellContext`ALabelsPesos, \
$CellContext`GrafoArbol}, $CellContext`AAristasNoDirigidas[
            Pattern[$CellContext`AOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`AOAritas, Pattern[$CellContext`Aicontador1, 
               Blank[]] -> UndirectedEdge[
               Part[$CellContext`Aicontador1, 1], 
               
               Part[$CellContext`Aicontador1, 
                2]]]]; $CellContext`AAristasDirigidas[
            Pattern[$CellContext`AOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`AOAritas, Pattern[$CellContext`Aicontador2, 
               Blank[]] -> DirectedEdge[
               Part[$CellContext`Aicontador2, 1], 
               Part[$CellContext`Aicontador2, 2]]]]; $CellContext`ALabelsPesos[
            Pattern[$CellContext`GGrafoArbol, 
             Blank[]], 
            Pattern[$CellContext`APesos, 
             Blank[]]] := 
          If[Length[$CellContext`APesos] == 
            EdgeCount[$CellContext`GGrafoArbol], 
            
            Module[{$CellContext`AList1 = 
              EdgeList[$CellContext`GGrafoArbol], $CellContext`AList2 = {}}, 
             For[$CellContext`Ai1 = 1, $CellContext`Ai1 <= 
               Length[$CellContext`AList1], $CellContext`AList2 = 
                Append[$CellContext`AList2, 
                  Part[$CellContext`AList1, $CellContext`Ai1] -> 
                  Part[$CellContext`APesos, $CellContext`Ai1]]; 
               Increment[$CellContext`Ai1]]; $CellContext`AList2]]; \
$CellContext`GrafoArbol[
            Pattern[$CellContext`AOAristas, 
             Blank[]]] := Module[{$CellContext`AVl1}, 
            If[
             OptionValue[$CellContext`mostrarpesos], 
             If[
              OptionValue[$CellContext`dirigido], 
              If[
              OptionValue[$CellContext`pesos] == {}, $CellContext`AVl1 = \
$CellContext`ALabelsPesos[
                  TreeGraph[
                   $CellContext`AAristasDirigidas[$CellContext`AOAristas], 
                   VertexLabels -> "Name", ImagePadding -> 10, 
                   VertexCoordinates -> 
                   OptionValue[$CellContext`verticescoordenadas]], 
                  ConstantArray[1, 
                   Length[$CellContext`AOAristas]]]; TreeGraph[
                 $CellContext`AAristasDirigidas[$CellContext`AOAristas], 
                 VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                 ConstantArray[1, 
                   Length[$CellContext`AOAristas]], 
                 EdgeLabels -> $CellContext`AVl1, VertexShapeFunction -> 
                 If[OptionValue[$CellContext`shape] == "circulo", "Circle", 
                   If[
                   OptionValue[$CellContext`shape] == "triangulo", "Triangle", 
                    If[
                    OptionValue[$CellContext`shape] == "cuadrado", "Square", 
                    If[
                    OptionValue[$CellContext`shape] == "rectangulo", 
                    "Rectangle", 
                    If[
                    OptionValue[$CellContext`shape] == "pentagono", 
                    "Pentagon", 
                    If[
                    OptionValue[$CellContext`shape] == "hexagono", "Hexagon", 
                    "Octagon"]]]]]], VertexCoordinates -> 
                 OptionValue[$CellContext`verticescoordenadas]], \
$CellContext`AVl1 = $CellContext`ALabelsPesos[
                  TreeGraph[
                   $CellContext`AAristasDirigidas[$CellContext`AOAristas], 
                   VertexLabels -> "Name", ImagePadding -> 10, 
                   VertexCoordinates -> 
                   OptionValue[$CellContext`verticescoordenadas]], 
                  OptionValue[$CellContext`pesos]]; TreeGraph[
                 $CellContext`AAristasDirigidas[$CellContext`AOAristas], 
                 VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                 OptionValue[$CellContext`pesos], 
                 EdgeLabels -> $CellContext`AVl1, VertexShapeFunction -> 
                 If[OptionValue[$CellContext`shape] == "circulo", "Circle", 
                   If[
                   OptionValue[$CellContext`shape] == "triangulo", "Triangle", 
                    If[
                    OptionValue[$CellContext`shape] == "cuadrado", "Square", 
                    If[
                    OptionValue[$CellContext`shape] == "rectangulo", 
                    "Rectangle", 
                    If[
                    OptionValue[$CellContext`shape] == "pentagono", 
                    "Pentagon", 
                    If[
                    OptionValue[$CellContext`shape] == "hexagono", "Hexagon", 
                    "Octagon"]]]]]], VertexCoordinates -> 
                 OptionValue[$CellContext`verticescoordenadas]]], 
              If[
              OptionValue[$CellContext`pesos] == {}, $CellContext`AVl1 = \
$CellContext`ALabelsPesos[
                  TreeGraph[
                   $CellContext`AAristasNoDirigidas[$CellContext`AOAristas], 
                   VertexLabels -> "Name", ImagePadding -> 10, 
                   VertexCoordinates -> 
                   OptionValue[$CellContext`verticescoordenadas]], 
                  ConstantArray[1, 
                   Length[$CellContext`AOAristas]]]; TreeGraph[
                 $CellContext`AAristasNoDirigidas[$CellContext`AOAristas], 
                 VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                 ConstantArray[1, 
                   Length[$CellContext`AOAristas]], 
                 EdgeLabels -> $CellContext`AVl1, VertexShapeFunction -> 
                 If[OptionValue[$CellContext`shape] == "circulo", "Circle", 
                   If[
                   OptionValue[$CellContext`shape] == "triangulo", "Triangle", 
                    If[
                    OptionValue[$CellContext`shape] == "cuadrado", "Square", 
                    If[
                    OptionValue[$CellContext`shape] == "rectangulo", 
                    "Rectangle", 
                    If[
                    OptionValue[$CellContext`shape] == "pentagono", 
                    "Pentagon", 
                    If[
                    OptionValue[$CellContext`shape] == "hexagono", "Hexagon", 
                    "Octagon"]]]]]], VertexCoordinates -> 
                 OptionValue[$CellContext`verticescoordenadas]], \
$CellContext`AVl1 = $CellContext`ALabelsPesos[
                  TreeGraph[
                   $CellContext`AAristasNoDirigidas[$CellContext`AOAristas], 
                   VertexLabels -> "Name", ImagePadding -> 10, 
                   VertexCoordinates -> 
                   OptionValue[$CellContext`verticescoordenadas]], 
                  OptionValue[$CellContext`pesos]]; TreeGraph[
                 $CellContext`AAristasNoDirigidas[$CellContext`AOAristas], 
                 VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                 OptionValue[$CellContext`pesos], 
                 EdgeLabels -> $CellContext`AVl1, VertexShapeFunction -> 
                 If[OptionValue[$CellContext`shape] == "circulo", "Circle", 
                   If[
                   OptionValue[$CellContext`shape] == "triangulo", "Triangle", 
                    If[
                    OptionValue[$CellContext`shape] == "cuadrado", "Square", 
                    If[
                    OptionValue[$CellContext`shape] == "rectangulo", 
                    "Rectangle", 
                    If[
                    OptionValue[$CellContext`shape] == "pentagono", 
                    "Pentagon", 
                    If[
                    OptionValue[$CellContext`shape] == "hexagono", "Hexagon", 
                    "Octagon"]]]]]], VertexCoordinates -> 
                 OptionValue[$CellContext`verticescoordenadas]]]], 
             If[
              OptionValue[$CellContext`dirigido], 
              TreeGraph[
               $CellContext`AAristasDirigidas[$CellContext`AOAristas], 
               VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
               OptionValue[$CellContext`pesos], VertexShapeFunction -> 
               If[OptionValue[$CellContext`shape] == "circulo", "Circle", 
                 If[
                 OptionValue[$CellContext`shape] == "triangulo", "Triangle", 
                  If[OptionValue[$CellContext`shape] == "cuadrado", "Square", 
                   If[
                   OptionValue[$CellContext`shape] == "rectangulo", 
                    "Rectangle", 
                    If[
                    OptionValue[$CellContext`shape] == "pentagono", 
                    "Pentagon", 
                    If[
                    OptionValue[$CellContext`shape] == "hexagono", "Hexagon", 
                    "Octagon"]]]]]], VertexCoordinates -> 
               OptionValue[$CellContext`verticescoordenadas]], 
              TreeGraph[
               $CellContext`AAristasNoDirigidas[$CellContext`AOAristas], 
               VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
               OptionValue[$CellContext`pesos], VertexShapeFunction -> 
               If[OptionValue[$CellContext`shape] == "circulo", "Circle", 
                 If[
                 OptionValue[$CellContext`shape] == "triangulo", "Triangle", 
                  If[OptionValue[$CellContext`shape] == "cuadrado", "Square", 
                   If[
                   OptionValue[$CellContext`shape] == "rectangulo", 
                    "Rectangle", 
                    If[
                    OptionValue[$CellContext`shape] == "pentagono", 
                    "Pentagon", 
                    If[
                    OptionValue[$CellContext`shape] == "hexagono", "Hexagon", 
                    "Octagon"]]]]]], VertexCoordinates -> 
               OptionValue[$CellContext`verticescoordenadas]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dirigido]], 
            VectorQ[
             OptionValue[$CellContext`pesos]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            StringQ[
             OptionValue[$CellContext`shape]]], 
           If[MemberQ[
              OptionValue[$CellContext`pesos], Null] == False, 
            If[
             And[
              MatrixQ[$CellContext`AAristas], MemberQ[
                Flatten[$CellContext`AAristas], Null] == False], 
             If[
              And[Part[
                 Dimensions[$CellContext`AAristas], 2] == 2, MemberQ[
                 ToCharacterCode[
                  ToString[$CellContext`AAristas]], 62760] == False], 
              If[
               Or[Length[$CellContext`AAristas] == Length[
                  OptionValue[$CellContext`pesos]], 
                OptionValue[$CellContext`pesos] == {}], 
               If[
                
                MemberQ[{
                 "circulo", "triangulo", "cuadrado", "rectangulo", 
                  "pentagono", "hexagono", "octagono"}, 
                 OptionValue[$CellContext`shape]], 
                If[
                 TreeGraphQ[
                  $CellContext`Grafo[$CellContext`AAristas]], 
                 If[
                  OptionValue[$CellContext`dirigido], 
                  If[
                   $CellContext`GrafoQ[
                    TreeGraph[
                    $CellContext`AAristasDirigidas[$CellContext`AAristas]]], 
                   $CellContext`GrafoArbol[$CellContext`AAristas]], 
                  If[
                   $CellContext`GrafoQ[
                    TreeGraph[
                    $CellContext`AAristasNoDirigidas[$CellContext`AAristas]]], 
                   $CellContext`GrafoArbol[$CellContext`AAristas]]]]]]]]]]], 
       Options[$CellContext`Arbol] = {$CellContext`dirigido -> 
         False, $CellContext`pesos -> {}, $CellContext`mostrarpesos -> 
         False, $CellContext`shape -> 
         "circulo", $CellContext`verticescoordenadas -> {}}, \
$CellContext`AristasWolframSystemToCombinatorica[
         Pattern[$CellContext`GAristasGrafo, 
          Blank[]]] := 
       Module[{$CellContext`GGrafoAuxiliar1 = 
          Graph[$CellContext`GAristasGrafo]}, 
         If[
          GraphQ[$CellContext`GGrafoAuxiliar1], 
          Quiet[
           Cases[$CellContext`GAristasGrafo, Pattern[$CellContext`Gicontador1, 
              Blank[]] -> {
              Part[$CellContext`Gicontador1, 1], 
              Part[$CellContext`Gicontador1, 2]}]]]], $CellContext`Hojas[
         Pattern[$CellContext`AArbol, 
          Blank[]], 
         OptionsPattern[]] := Module[{$CellContext`AArbolAuxiliar7}, 
         If[
          $CellContext`GrafoQ[$CellContext`AArbol], 
          If[
           $CellContext`ArbolQ[$CellContext`AArbol], 
           If[ToString[
              OptionValue[$CellContext`raiz]] == ToString[""], 
            Select[
             VertexList[$CellContext`AArbol], 
             VertexDegree[$CellContext`AArbol, #] == 1& ], 
            If[
             MemberQ[
              VertexList[$CellContext`AArbol], 
              OptionValue[$CellContext`raiz]], 
             Complement[
              Select[
               VertexList[$CellContext`AArbol], 
               VertexDegree[$CellContext`AArbol, #] == 1& ], {
               OptionValue[$CellContext`raiz]}]]]], 
          If[
           $CellContext`GrafoCQ[$CellContext`AArbol], 
           If[
            $CellContext`ArbolQ[$CellContext`AArbol], \
$CellContext`AArbolAuxiliar7 = \
$CellContext`CombinatoricaToGraph[$CellContext`AArbol]; If[ToString[
                OptionValue[$CellContext`raiz]] == ToString[""], 
              Select[
               VertexList[$CellContext`AArbolAuxiliar7], 
               VertexDegree[$CellContext`AArbolAuxiliar7, #] == 1& ], 
              If[
               MemberQ[
                VertexList[$CellContext`AArbolAuxiliar7], 
                OptionValue[$CellContext`raiz]], 
               Complement[
                Select[
                 VertexList[$CellContext`AArbolAuxiliar7], 
                 VertexDegree[$CellContext`AArbolAuxiliar7, #] == 1& ], {
                 OptionValue[$CellContext`raiz]}]]]]]]], 
       Options[$CellContext`Hojas] = {$CellContext`raiz -> 
         ""}, $CellContext`ArbolQ[
         Pattern[$CellContext`AArbol, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`AArbol], 
         If[
          TreeGraphQ[$CellContext`AArbol], True, False], 
         If[
          $CellContext`GrafoCQ[$CellContext`AArbol], 
          If[
           $CellContext`TreeQ[$CellContext`AArbol], True, False], 
          False]], $CellContext`CombinatoricaToGraph[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GrafoO3d, $CellContext`GrafoONo3d}, \
$CellContext`GrafoO3d[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl2}, 
            If[
             $CellContext`UndirectedQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                True, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> True, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                True, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> True, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]]]]; $CellContext`GrafoONo3d[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl2}, 
            If[
             $CellContext`UndirectedQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                False, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                False, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            $CellContext`GrafoCQ[$CellContext`GGrafo], 
            If[
             OptionValue[$CellContext`dimensions3d], 
             $CellContext`GrafoO3d[$CellContext`GGrafo], 
             $CellContext`GrafoONo3d[$CellContext`GGrafo]]]]], 
       Options[$CellContext`CombinatoricaToGraph] = \
{$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
         False, $CellContext`shape -> False}, $CellContext`PesosAristas[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          WeightedGraphQ[$CellContext`GGrafo], 
          If[
           $CellContext`AristasMixtasQ[$CellContext`GGrafo], If[Length[
               Quiet[
                Cases[
                 EdgeList[$CellContext`GGrafo], 
                 Pattern[$CellContext`Gicontador6, 
                   Blank[]] -> NumericQ[
                   
                   PropertyValue[{$CellContext`GGrafo, \
$CellContext`Gicontador6}, EdgeWeight]]]]] == 
             EdgeCount[$CellContext`GGrafo], $CellContext`GList3 = Table[{
                Part[
                 EdgeList[$CellContext`GGrafo], $CellContext`Gi2], 
                PropertyValue[{$CellContext`GGrafo, 
                  Part[
                   EdgeList[$CellContext`GGrafo], $CellContext`Gi2]}, 
                 EdgeWeight]}, {$CellContext`Gi2, 1, 
                EdgeCount[$CellContext`GGrafo]}]]; $CellContext`GList4 = 
            Select[$CellContext`GList3, DirectedEdge[
                Part[
                 Part[#, 1], 1], 
                Part[
                 Part[#, 1], 2]] == Part[#, 1]& ]; $CellContext`GList5 = 
            ReplaceAll[
              Select[$CellContext`GList3, UndirectedEdge[
                 Part[
                  Part[#, 1], 1], 
                 Part[
                  Part[#, 1], 2]] == Part[#, 1]& ], UndirectedEdge -> 
              DirectedEdge]; Join[$CellContext`GList4, $CellContext`GList5, 
             Reverse[$CellContext`GList5, 3]], 
           If[Length[
              Quiet[
               Cases[
                EdgeList[$CellContext`GGrafo], 
                Pattern[$CellContext`Gicontador6, 
                  Blank[]] -> NumericQ[
                  
                  PropertyValue[{$CellContext`GGrafo, \
$CellContext`Gicontador6}, EdgeWeight]]]]] == EdgeCount[$CellContext`GGrafo], 
            Table[{
              Part[
               EdgeList[$CellContext`GGrafo], $CellContext`Gi2], 
              PropertyValue[{$CellContext`GGrafo, 
                Part[
                 EdgeList[$CellContext`GGrafo], $CellContext`Gi2]}, 
               EdgeWeight]}, {$CellContext`Gi2, 1, 
              EdgeCount[$CellContext`GGrafo]}]]]], 
         If[
          $CellContext`GrafoCQ[$CellContext`GGrafo], 
          If[
           ListQ[
            $CellContext`Edges[$CellContext`GGrafo, EdgeWeight]], 
           $CellContext`Edges[$CellContext`GGrafo, 
            EdgeWeight]]]], $CellContext`AristasMixtasQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          And[Select[
             EdgeList[$CellContext`GGrafo], DirectedEdge[
               Part[#, 1], 
               Part[#, 2]] == #& ] != {}, Select[
             EdgeList[$CellContext`GGrafo], UndirectedEdge[
               Part[#, 1], 
               Part[#, 2]] == #& ] != {}], True, False]], $CellContext`Altura[
         Pattern[$CellContext`AArbol, 
          Blank[]], 
         Pattern[$CellContext`ARaiz, 
          Blank[]]] := 
       Module[{$CellContext`AArbolAuxiliar8, $CellContext`AArbolAuxiliar9}, 
         If[
          $CellContext`GrafoQ[$CellContext`AArbol], 
          If[
           $CellContext`ArbolQ[$CellContext`AArbol], 
           If[
            MemberQ[
             VertexList[$CellContext`AArbol], $CellContext`ARaiz], 
            If[
             $CellContext`GrafoDirigidoQ[$CellContext`AArbol], \
$CellContext`AArbolAuxiliar9 = $CellContext`Grafo[
                $CellContext`AristasWolframSystemToCombinatorica[
                 EdgeList[$CellContext`AArbol]]]; 
             VertexEccentricity[$CellContext`AArbolAuxiliar9, \
$CellContext`ARaiz], 
             VertexEccentricity[$CellContext`AArbol, $CellContext`ARaiz]]]], 
          If[
           $CellContext`GrafoCQ[$CellContext`AArbol], 
           If[
            $CellContext`ArbolQ[$CellContext`AArbol], \
$CellContext`AArbolAuxiliar8 = \
$CellContext`CombinatoricaToGraph[$CellContext`AArbol]; If[
              MemberQ[
               VertexList[$CellContext`AArbolAuxiliar8], $CellContext`ARaiz], 
              If[
               $CellContext`GrafoDirigidoQ[$CellContext`AArbolAuxiliar8], \
$CellContext`AArbolAuxiliar9 = $CellContext`Grafo[
                  $CellContext`AristasWolframSystemToCombinatorica[
                   EdgeList[$CellContext`AArbolAuxiliar8]]]; 
               VertexEccentricity[$CellContext`AArbolAuxiliar9, \
$CellContext`ARaiz], 
               
               VertexEccentricity[$CellContext`AArbolAuxiliar8, \
$CellContext`ARaiz]]]]]]], $CellContext`GrafoDirigidoQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          UndirectedGraphQ[$CellContext`GGrafo], False, True], 
         If[
          $CellContext`GrafoCQ[$CellContext`GGrafo], 
          If[
           $CellContext`UndirectedQ[$CellContext`GGrafo], False, True]]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.675769068420942*^9, {3.675769285379912*^9, 3.6757693062492685`*^9}, 
   3.675769346279998*^9, 3.675770815930647*^9, 3.67577086715304*^9, {
   3.675772756487206*^9, 3.675772796477213*^9}, 3.6757728496195946`*^9, {
   3.675772887165208*^9, 3.6757729088057566`*^9}, {3.801154237169457*^9, 
   3.8011542707251472`*^9}, 3.8011560326970124`*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"3fd8d76c-1472-43fd-a852-95c61fc15bd4"]
}, Open  ]]
},
WindowSize->{1366, 685},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2a6be861-354d-4e24-915c-0412daaa46ff"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 103006, 2238, 17843, "Input",ExpressionUUID->"90f86763-8595-4b65-850b-49a3c179ebaa"],
Cell[CellGroupData[{
Cell[103589, 2262, 6588, 167, 1196, "Input",ExpressionUUID->"2b091c1b-1b29-4f41-8183-e997d2b44e09"],
Cell[110180, 2431, 57724, 1205, 588, "Output",ExpressionUUID->"3fd8d76c-1472-43fd-a852-95c61fc15bd4"]
}, Open  ]]
}
]
*)

