(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    133783,       2769]
NotebookOptionsPosition[    133260,       2751]
NotebookOutlinePosition[    133691,       2768]
CellTagsIndexPosition[    133648,       2765]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"MValidarConjunto", "[", "MVl13", "]"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"MValidarConjunto", "[", "MVl14", "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MValidarConjunto", "[", "MVl15", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MValidarInicial", "[", 
            RowBox[{"MVl13", ",", "MVl16"}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"MValidarFuncionES", "[", 
              RowBox[{"MVl13", ",", "MVl14", ",", "MVl17", ",", "MVl15"}], 
              "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"MValidarString", "[", 
                RowBox[{"MVl14", ",", "MVl18"}], "]"}], ",", 
               RowBox[{"Column", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"MaquinaToDiagrama", "[", 
                   RowBox[{
                   "MVl13", ",", "MVl14", ",", "MVl15", ",", "MVl16", ",", 
                    "MVl17", ",", 
                    RowBox[{"padding", "\[Rule]", "25"}]}], "]"}], ",", 
                  RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{"\"\<Hilera de salida: \>\"", ",", " ", 
                    RowBox[{
                    RowBox[{"StringOSalida", "[", 
                    RowBox[{
                    "MVl13", ",", "MVl14", ",", "MVl15", ",", "MVl16", ",", 
                    "MVl17", ",", "MVl18"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], ",", 
                  RowBox[{"Row", "[", 
                   RowBox[{"{", 
                    RowBox[{"\"\<Recorrido: \>\"", ",", "  ", 
                    RowBox[{
                    RowBox[{"StringOSalida", "[", 
                    RowBox[{
                    "MVl13", ",", "MVl14", ",", "MVl15", ",", "MVl16", ",", 
                    "MVl17", ",", "MVl18"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
                "]"}], ",", "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], 
           ",", "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
       "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<Componentes de la m\[AAcute]quina\>\"", ",", "Bold", ",", "Medium"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"MVl13", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Sigma]", "0"], ",", 
        SubscriptBox["\[Sigma]", "1"], ",", 
        SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", "\"\<Estados\>\""}], 
     "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"MVl14", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      "\"\<S\[IAcute]mbolos de entrada\>\""}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"MVl15", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
      "\"\<S\[IAcute]mbolos de salida\>\""}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"MVl16", ",", 
      SubscriptBox["\[Sigma]", "0"], ",", "\"\<Estado inicial\>\""}], "}"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"MVl17", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
          SubscriptBox["\[Sigma]", "1"], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
          SubscriptBox["\[Sigma]", "0"], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
          SubscriptBox["\[Sigma]", "1"], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
          SubscriptBox["\[Sigma]", "2"], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
          SubscriptBox["\[Sigma]", "0"], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
          SubscriptBox["\[Sigma]", "1"], ",", "2"}], "}"}]}], "}"}], ",", 
      "\"\<Funci\[OAcute]n estado siguiente/salida\>\""}], "}"}], "}"}], ",", 
   "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<Hilera de s\[IAcute]mbolos de entrada\>\"", ",", "Bold", ",", 
     "Medium"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"MVl18", ",", 
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "b", ",", "a", ",", "a", ",", "b", ",", "a", ",", 
        "a", ",", "b", ",", "b", ",", "a", ",", "a", ",", "b", ",", "b", ",", 
        "b", ",", "b", ",", "b", ",", "a", ",", "b", ",", "a"}], "}"}], ",", 
      "\"\<Vector de s\[IAcute]mbolos de entrada\>\""}], "}"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Clear", "[", "\[Sigma]", "]"}], ";", 
      RowBox[{
       RowBox[{"MValidarConjunto", "[", "MMConjunto_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ListQ", "[", "MMConjunto", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{"MMConjunto", ",", "Null"}], "]"}], "\[Equal]", 
              "False"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"ToString", "[", "MMConjunto", "]"}], "\[NotEqual]", 
                RowBox[{"ToString", "[", 
                 RowBox[{"{", "}"}], "]"}]}], ",", "True", ",", "False"}], 
              "]"}], ",", "False"}], "]"}], ",", "False"}], "]"}]}], "]"}]}], 
      ";", 
      RowBox[{
       RowBox[{"MValidarMatriz", "[", "MMatriz_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"VectorQ", "[", 
            RowBox[{"MMatriz", ",", "ListQ"}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{
                RowBox[{"ToCharacterCode", "[", 
                 RowBox[{"ToString", "[", "MMatriz", "]"}], "]"}], ",", 
                "62760"}], "]"}], "\[Equal]", "False"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Dimensions", "[", "MMatriz", "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "4"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{
                    RowBox[{"Flatten", "[", "MMatriz", "]"}], ",", "Null"}], 
                   "]"}], "\[Equal]", "False"}], ",", "True"}], "]"}], ",", 
               "False"}], "]"}], ",", "False"}], "]"}], ",", "False"}], 
          "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"MValidarInicial", "[", 
        RowBox[{"MMEstados_", ",", "MMInicial_"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MValidarConjunto", "[", "MMEstados", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{"MMEstados", ",", "MMInicial"}], "]"}], ",", "True", 
             ",", "False"}], "]"}], ",", "False"}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"MValidarFuncionES", "[", 
        RowBox[{
        "MMEstados_", ",", "MMEntradas_", ",", "MMFEstadoSalida_", ",", 
         "MMSalidas_"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"MList23", ",", "MList24", ",", "MList25", ",", "Mi31"}], 
          "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MValidarConjunto", "[", "MMEstados", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"MValidarConjunto", "[", "MMEntradas", "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"MValidarMatriz", "[", "MMFEstadoSalida", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"MValidarConjunto", "[", "MMSalidas", "]"}], ",", 
                 RowBox[{
                  RowBox[{"MList23", "=", 
                   RowBox[{"Cases", "[", 
                    RowBox[{"MMFEstadoSalida", ",", 
                    RowBox[{"Mi31_", "\[RuleDelayed]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Mi31", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"Mi31", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "]"}]}], ";", 
                  RowBox[{"MList24", "=", 
                   RowBox[{"Cases", "[", 
                    RowBox[{"MMFEstadoSalida", ",", 
                    RowBox[{"Mi31_", "\[RuleDelayed]", 
                    RowBox[{"Mi31", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}], ";", 
                  RowBox[{"MList25", "=", 
                   RowBox[{"Cases", "[", 
                    RowBox[{"MMFEstadoSalida", ",", 
                    RowBox[{"Mi31_", "\[RuleDelayed]", 
                    RowBox[{"Mi31", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}]}], ";", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", "MList23", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"PC", "[", 
                    RowBox[{"MMEstados", ",", "MMEntradas"}], "]"}], "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SubsetQ", "[", 
                    RowBox[{"MMEstados", ",", "MList24"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SubsetQ", "[", 
                    RowBox[{"MMSalidas", ",", "MList25"}], "]"}], ",", "True",
                     ",", "False"}], "]"}], ",", "False"}], "]"}], ",", 
                    "False"}], "]"}]}], ",", "False"}], "]"}], ",", "False"}],
               "]"}], ",", "False"}], "]"}], ",", "False"}], "]"}]}], "]"}]}],
       ";", 
      RowBox[{
       RowBox[{"MValidarString", "[", 
        RowBox[{"MMEntradas_", ",", "MMstring\[Alpha]_"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MValidarConjunto", "[", "MMEntradas", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ListQ", "[", "MMstring\[Alpha]", "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"SubsetQ", "[", 
                RowBox[{"MMEntradas", ",", "MMstring\[Alpha]"}], "]"}], ",", 
               "True", ",", "False"}], "]"}], ",", "False"}], "]"}], ",", 
           "False"}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"StringOSalida", "[", 
        RowBox[{
        "MMEstados_", ",", "MMEntradas_", ",", "MMSalidas_", ",", 
         "MMInicial_", ",", "MMFEstadoSalida_", ",", "MMstring\[Alpha]_"}], 
        "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "MMList9", ",", "MMList10", ",", "MMList11", ",", 
           "MMStringSalidaTrace"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"MMStringSalidaTrace", "[", 
            RowBox[{
            "MLista_List", ",", "string\[Alpha]_", ",", "MEstadoInicial_"}], 
            "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"MMaquinaEA", "=", "MEstadoInicial"}], ",", 
               RowBox[{"MMaquinaDS", "=", 
                RowBox[{"{", "}"}]}], ",", 
               RowBox[{"MMdimensiones", "=", 
                RowBox[{"Dimensions", "[", "MLista", "]"}]}], ",", "MMfila", 
               ",", "MMi6", ",", "MMi7", ",", "MMaquinaDE", ",", 
               RowBox[{"MListaEstadosTrace", "=", 
                RowBox[{"{", "MEstadoInicial", "}"}]}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"MMi6", "=", "1"}], ",", 
                RowBox[{"MMi6", "\[LessEqual]", 
                 RowBox[{"Length", "[", "string\[Alpha]", "]"}]}], ",", 
                RowBox[{
                 RowBox[{"MMaquinaDE", "=", 
                  RowBox[{"string\[Alpha]", "[", 
                   RowBox[{"[", "MMi6", "]"}], "]"}]}], ";", 
                 RowBox[{"For", "[", 
                  RowBox[{
                   RowBox[{"MMi7", "=", "1"}], ",", 
                   RowBox[{"MMi7", "\[LessEqual]", 
                    RowBox[{"MMdimensiones", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                   RowBox[{
                    RowBox[{"MMfila", "=", 
                    RowBox[{"MLista", "[", 
                    RowBox[{"[", "MMi7", "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MMaquinaEA", "\[Equal]", 
                    RowBox[{"MMfila", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "&&", 
                    RowBox[{"MMaquinaDE", "\[Equal]", 
                    RowBox[{"MMfila", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"MMaquinaDS", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"MMaquinaDS", ",", 
                    RowBox[{"MMfila", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"MMaquinaEA", "=", 
                    RowBox[{"MMfila", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ";", 
                    RowBox[{"MListaEstadosTrace", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"MListaEstadosTrace", ",", 
                    RowBox[{"MMfila", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"MMi7", "++"}]}]}], "]"}], ";", 
                 RowBox[{"MMi6", "++"}]}]}], "]"}], ";", 
              RowBox[{"{", 
               RowBox[{"MMaquinaDS", ",", "MListaEstadosTrace"}], "}"}]}]}], 
            "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ListQ", "[", "MMEstados", "]"}], "&&", 
             RowBox[{"ListQ", "[", "MMEntradas", "]"}], "&&", 
             RowBox[{"ListQ", "[", "MMSalidas", "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"MMEstados", ",", "Null"}], "]"}], "\[Equal]", 
                "False"}], "&&", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"MMEntradas", ",", "Null"}], "]"}], "\[Equal]", 
                "False"}], "&&", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"MMSalidas", ",", "Null"}], "]"}], "\[Equal]", 
                "False"}]}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"ToString", "[", "MMEstados", "]"}], "\[NotEqual]", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"{", "}"}], "]"}]}], "&&", 
                 RowBox[{
                  RowBox[{"ToString", "[", "MMEntradas", "]"}], "\[NotEqual]", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"{", "}"}], "]"}]}], "&&", 
                 RowBox[{
                  RowBox[{"ToString", "[", "MMSalidas", "]"}], "\[NotEqual]", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"{", "}"}], "]"}]}]}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"MMEstados", ",", "MMInicial"}], "]"}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{"MMFEstadoSalida", ",", "ListQ"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", "MMFEstadoSalida", "]"}], "]"}], 
                    ",", "62760"}], "]"}], "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "MMFEstadoSalida", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "4"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", "MMFEstadoSalida", "]"}], ",", 
                    "Null"}], "]"}], "\[Equal]", "False"}], ",", 
                    RowBox[{
                    RowBox[{"MMList9", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"MMFEstadoSalida", ",", 
                    RowBox[{"MMi1_", "\[RuleDelayed]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"MMi1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"MMi1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "]"}]}], ";", 
                    RowBox[{"MMList10", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"MMFEstadoSalida", ",", 
                    RowBox[{"MMi1_", "\[RuleDelayed]", 
                    RowBox[{"MMi1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}], ";", 
                    RowBox[{"MMList11", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"MMFEstadoSalida", ",", 
                    RowBox[{"MMi1_", "\[RuleDelayed]", 
                    RowBox[{"MMi1", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", "MMList9", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"PC", "[", 
                    RowBox[{"MMEstados", ",", "MMEntradas"}], "]"}], "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SubsetQ", "[", 
                    RowBox[{"MMEstados", ",", "MMList10"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SubsetQ", "[", 
                    RowBox[{"MMSalidas", ",", "MMList11"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "MMstring\[Alpha]", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SubsetQ", "[", 
                    RowBox[{"MMEntradas", ",", "MMstring\[Alpha]"}], "]"}], 
                    ",", 
                    RowBox[{"MMStringSalidaTrace", "[", 
                    RowBox[{
                    "MMFEstadoSalida", ",", "MMstring\[Alpha]", ",", 
                    "MMInicial"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                 "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "MaquinaToDiagrama", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{"padding", "\[Rule]", "10"}], "}"}]}], ";", 
      RowBox[{
       RowBox[{"MaquinaToDiagrama", "[", 
        RowBox[{
        "MEstados_", ",", "MEntradas_", ",", "MSalidas_", ",", "MInicial_", 
         ",", "MFEstadoSalida_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "MFuncionEtiquetas", ",", "Mi1", ",", "Mi2", ",", "Mi3", ",", 
           "MList1", ",", "MList2", ",", "MList3", ",", "MList4", ",", 
           "MList5", ",", "MList6", ",", "MList7", ",", "MList8", ",", "MVl1",
            ",", "MVl2", ",", "MVl3"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"MFuncionEtiquetas", "[", 
            RowBox[{"MSEntrada_", ",", "MSSalida_"}], "]"}], ":=", 
           RowBox[{"StringJoin", "[", 
            RowBox[{
             RowBox[{"ToString", "[", "MSEntrada", "]"}], ",", "\"\</\>\"", 
             ",", 
             RowBox[{"ToString", "[", "MSSalida", "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"IntegerQ", "[", 
             RowBox[{"OptionValue", "[", "padding", "]"}], "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"OptionValue", "[", "padding", "]"}], 
               "\[GreaterEqual]", "10"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"ListQ", "[", "MEstados", "]"}], "&&", 
                 RowBox[{"ListQ", "[", "MEntradas", "]"}], "&&", 
                 RowBox[{"ListQ", "[", "MSalidas", "]"}]}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"MEstados", ",", "Null"}], "]"}], "\[Equal]", 
                    "False"}], "&&", 
                   RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"MEntradas", ",", "Null"}], "]"}], "\[Equal]", 
                    "False"}], "&&", 
                   RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"MSalidas", ",", "Null"}], "]"}], "\[Equal]", 
                    "False"}]}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "MEstados", "]"}], "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], "&&", 
                    RowBox[{
                    RowBox[{"ToString", "[", "MEntradas", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], "&&", 
                    RowBox[{
                    RowBox[{"ToString", "[", "MSalidas", "]"}], "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"MEstados", ",", "MInicial"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{"MFEstadoSalida", ",", "ListQ"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", "MFEstadoSalida", "]"}], "]"}], 
                    ",", "62760"}], "]"}], "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "MFEstadoSalida", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "4"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", "MFEstadoSalida", "]"}], ",", 
                    "Null"}], "]"}], "\[Equal]", "False"}], ",", 
                    RowBox[{
                    RowBox[{"MList1", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"MFEstadoSalida", ",", 
                    RowBox[{"Mi1_", "\[RuleDelayed]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Mi1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"Mi1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "]"}]}], ";", 
                    RowBox[{"MList2", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"MFEstadoSalida", ",", 
                    RowBox[{"Mi1_", "\[RuleDelayed]", 
                    RowBox[{"Mi1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], ";", 
                    RowBox[{"MList3", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"MFEstadoSalida", ",", 
                    RowBox[{"Mi1_", "\[RuleDelayed]", 
                    RowBox[{"Mi1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}], ";", 
                    RowBox[{"MList4", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"MFEstadoSalida", ",", 
                    RowBox[{"Mi1_", "\[RuleDelayed]", 
                    RowBox[{"Mi1", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}]}], ";", 
                    RowBox[{"MList5", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"MFEstadoSalida", ",", 
                    RowBox[{"Mi1_", "\[RuleDelayed]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Mi1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"Mi1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", "MList1", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"PC", "[", 
                    RowBox[{"MEstados", ",", "MEntradas"}], "]"}], "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SubsetQ", "[", 
                    RowBox[{"MEstados", ",", "MList3"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SubsetQ", "[", 
                    RowBox[{"MSalidas", ",", "MList4"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"MList6", "=", 
                    RowBox[{"Prepend", "[", 
                    RowBox[{"MList5", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<\>\"", ",", "MInicial"}], "}"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"MList7", "=", 
                    RowBox[{"Prepend", "[", 
                    RowBox[{
                    RowBox[{"MapThread", "[", 
                    RowBox[{"MFuncionEtiquetas", ",", 
                    RowBox[{"{", 
                    RowBox[{"MList2", ",", "MList4"}], "}"}]}], "]"}], ",", 
                    "\"\<\>\""}], "]"}]}], ";", 
                    RowBox[{"MList8", "=", 
                    RowBox[{"DeleteDuplicates", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"MList6", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Count", "[", 
                    RowBox[{"MList6", ",", "#"}], "]"}], "\[NotEqual]", "1"}],
                     "&"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "MList8", "]"}], "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"Mi2", "=", "1"}], ",", 
                    RowBox[{"Mi2", "\[LessEqual]", 
                    RowBox[{"Length", "[", "MList8", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"MVl1", "=", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{"Position", "[", 
                    RowBox[{"MList6", ",", 
                    RowBox[{"MList8", "[", 
                    RowBox[{"[", "Mi2", "]"}], "]"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"MVl2", "=", 
                    RowBox[{"Part", "[", 
                    RowBox[{"MList7", ",", "MVl1"}], "]"}]}], ";", 
                    RowBox[{"MVl3", "=", 
                    RowBox[{"MVl2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"Mi3", "=", "2"}], ",", 
                    RowBox[{"Mi3", "\[LessEqual]", 
                    RowBox[{"Length", "[", "MVl2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"MVl3", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"MVl3", ",", "\"\<,\>\"", ",", 
                    RowBox[{"MVl2", "[", 
                    RowBox[{"[", "Mi3", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"Mi3", "++"}]}]}], "]"}], ";", 
                    RowBox[{"MList7", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"MList7", ",", 
                    RowBox[{"Position", "[", 
                    RowBox[{"MList6", ",", 
                    RowBox[{"MList8", "[", 
                    RowBox[{"[", "Mi2", "]"}], "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"MList7", "=", 
                    RowBox[{"Insert", "[", 
                    RowBox[{"MList7", ",", "MVl3", ",", 
                    RowBox[{"MVl1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"MList6", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"MList6", ",", 
                    RowBox[{"Position", "[", 
                    RowBox[{"MList6", ",", 
                    RowBox[{"MList8", "[", 
                    RowBox[{"[", "Mi2", "]"}], "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"MList6", "=", 
                    RowBox[{"Insert", "[", 
                    RowBox[{"MList6", ",", 
                    RowBox[{"MList8", "[", 
                    RowBox[{"[", "Mi2", "]"}], "]"}], ",", 
                    RowBox[{"MVl1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"Mi2", "++"}]}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{"MList6", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "MList7"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", "True"}], ",", 
                    RowBox[{"padding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], 
                    "]"}]}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
             "]"}]}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "Grafo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
         RowBox[{"vertices", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
         RowBox[{"pesos", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
         RowBox[{"shape", "\[Rule]", "False"}], ",", 
         RowBox[{"padding", "\[Rule]", "10"}]}], "}"}]}], ";", 
      RowBox[{
       RowBox[{"Grafo", "[", 
        RowBox[{"GAristas_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "GAristasNoDirigidas", ",", "GAristasDirigidas", ",", 
           "GLabelsPesos", ",", "Grafo3d", ",", "GrafoNo3d"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GAristasNoDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador4_", "\[Rule]", 
               RowBox[{"UndirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador4", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador4", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GAristasDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador5_", "\[Rule]", 
               RowBox[{"DirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador5", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador5", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GLabelsPesos", "[", 
            RowBox[{"GGrafo_", ",", "GPesos_"}], "]"}], ":=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", "GPesos", "]"}], "\[Equal]", 
              RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"GList1", "=", 
                  RowBox[{"EdgeList", "[", "GGrafo", "]"}]}], ",", 
                 RowBox[{"GList2", "=", 
                  RowBox[{"{", "}"}]}]}], "}"}], ",", 
               RowBox[{
                RowBox[{"For", "[", 
                 RowBox[{
                  RowBox[{"Gi1", "=", "1"}], ",", 
                  RowBox[{"Gi1", "\[LessEqual]", 
                   RowBox[{"Length", "[", "GList1", "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"GList2", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"GList2", ",", 
                    RowBox[{
                    RowBox[{"GList1", "[", 
                    RowBox[{"[", "Gi1", "]"}], "]"}], "\[Rule]", 
                    RowBox[{"GPesos", "[", 
                    RowBox[{"[", "Gi1", "]"}], "]"}]}]}], "]"}]}], ";", 
                   RowBox[{"Gi1", "++"}]}]}], "]"}], ";", "GList2"}]}], 
              "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"Grafo3d", "[", "GOAristas_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl1", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
                  "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"GrafoNo3d", "[", "GOAristas_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl1", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}]}], "]"}], 
                    ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "padding", "]"}]}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
                  "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], "&&", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "shape", "]"}], "]"}], "&&", 
             RowBox[{"IntegerQ", "[", 
              RowBox[{"OptionValue", "[", "padding", "]"}], "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"OptionValue", "[", "padding", "]"}], 
               "\[GreaterEqual]", "10"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    "Null"}], "]"}], "\[Equal]", "False"}], "&&", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], ",", "Null"}],
                    "]"}], "\[Equal]", "False"}]}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{"GAristas", ",", "ListQ"}], "]"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ")"}], "&&", 
                   RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", "GAristas", "]"}], ",", "Null"}], 
                    "]"}], "\[Equal]", "False"}]}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], "&&", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{"GAristas", ",", "ListQ"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "GAristas", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&&", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", "GAristas", "]"}], "]"}], ",", 
                    "62760"}], "]"}], "\[Equal]", "False"}]}], ")"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                    RowBox[{"Grafo3d", "[", "GAristas", "]"}], ",", 
                    RowBox[{"GrafoNo3d", "[", "GAristas", "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"PC", "[", 
        RowBox[{"RBA_List", ",", "RBB_List"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"VectorQ", "[", "RBA", "]"}], "&&", 
            RowBox[{"VectorQ", "[", "RBB", "]"}]}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{"RBA", ",", "Null"}], "]"}], "\[Equal]", "False"}], "&&", 
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{"RBB", ",", "Null"}], "]"}], "\[Equal]", "False"}]}], 
             ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"ToString", "[", "RBA", "]"}], "\[NotEqual]", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"{", "}"}], "]"}]}], "&&", 
                RowBox[{
                 RowBox[{"ToString", "[", "RBB", "]"}], "\[NotEqual]", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"{", "}"}], "]"}]}]}], ",", 
               RowBox[{"DeleteDuplicates", "[", 
                RowBox[{"Flatten", "[", 
                 RowBox[{
                  RowBox[{"Outer", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"#1", ",", "#2"}], "}"}], "&"}], ",", "RBA", ",", 
                    "RBB"}], "]"}], ",", "1"}], "]"}], "]"}]}], "]"}]}], 
            "]"}]}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Spacer", "[", 
             RowBox[{"{", 
              RowBox[{"400", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Autor: Enrique V\[IAcute]lchez Quesada\>\"", ",", "Bold", 
                ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}], 
              "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica\>\"", ",", "Bold", ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.12", ",", "0", ",", "0.5"}], "]"}]}], "]"}], 
              "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<M\[AAcute]quinas de estado finito\>\"", ",", " ", "Bold", ",", 
          " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.6811248478160906`*^9, {3.6811256776480417`*^9, 3.6811256839407077`*^9}, {
   3.68112572237866*^9, 3.6811257498688517`*^9}, {3.681125787204833*^9, 
   3.681125827380516*^9}, {3.6811258740246196`*^9, 3.681125933955124*^9}, {
   3.6811265903900623`*^9, 3.6811265946420307`*^9}, {3.8011556720558863`*^9, 
   3.801155682416173*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"56aaf573-1b5f-4fee-9f36-07a86037685d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`MVl13$$ = {
     Subscript[$CellContext`\[Sigma], 0], 
     Subscript[$CellContext`\[Sigma], 1], 
     Subscript[$CellContext`\[Sigma], 
      2]}, $CellContext`MVl14$$ = {$CellContext`a, $CellContext`b}, \
$CellContext`MVl15$$ = {0, 1, 2, 3}, $CellContext`MVl16$$ = 
    Subscript[$CellContext`\[Sigma], 0], $CellContext`MVl17$$ = {{
      Subscript[$CellContext`\[Sigma], 0], $CellContext`a, 
      Subscript[$CellContext`\[Sigma], 1], 0}, {
      Subscript[$CellContext`\[Sigma], 0], $CellContext`b, 
      Subscript[$CellContext`\[Sigma], 0], 2}, {
      Subscript[$CellContext`\[Sigma], 1], $CellContext`a, 
      Subscript[$CellContext`\[Sigma], 1], 1}, {
      Subscript[$CellContext`\[Sigma], 1], $CellContext`b, 
      Subscript[$CellContext`\[Sigma], 2], 0}, {
      Subscript[$CellContext`\[Sigma], 2], $CellContext`a, 
      Subscript[$CellContext`\[Sigma], 0], 3}, {
      Subscript[$CellContext`\[Sigma], 2], $CellContext`b, 
      Subscript[$CellContext`\[Sigma], 1], 
      2}}, $CellContext`MVl18$$ = {$CellContext`a, $CellContext`b, \
$CellContext`b, $CellContext`a, $CellContext`a, $CellContext`b, \
$CellContext`a, $CellContext`a, $CellContext`b, $CellContext`b, \
$CellContext`a, $CellContext`a, $CellContext`b, $CellContext`b, \
$CellContext`b, $CellContext`b, $CellContext`b, $CellContext`a, \
$CellContext`b, $CellContext`a}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[
       Style["Componentes de la m\[AAcute]quina", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`MVl13$$], {
        Subscript[$CellContext`\[Sigma], 0], 
        Subscript[$CellContext`\[Sigma], 1], 
        Subscript[$CellContext`\[Sigma], 2]}, "Estados"}}, {{
       Hold[$CellContext`MVl14$$], {$CellContext`a, $CellContext`b}, 
       "S\[IAcute]mbolos de entrada"}}, {{
       Hold[$CellContext`MVl15$$], {0, 1, 2, 3}, 
       "S\[IAcute]mbolos de salida"}}, {{
       Hold[$CellContext`MVl16$$], 
       Subscript[$CellContext`\[Sigma], 0], "Estado inicial"}}, {{
       Hold[$CellContext`MVl17$$], {{
         Subscript[$CellContext`\[Sigma], 0], $CellContext`a, 
         Subscript[$CellContext`\[Sigma], 1], 0}, {
         Subscript[$CellContext`\[Sigma], 0], $CellContext`b, 
         Subscript[$CellContext`\[Sigma], 0], 2}, {
         Subscript[$CellContext`\[Sigma], 1], $CellContext`a, 
         Subscript[$CellContext`\[Sigma], 1], 1}, {
         Subscript[$CellContext`\[Sigma], 1], $CellContext`b, 
         Subscript[$CellContext`\[Sigma], 2], 0}, {
         Subscript[$CellContext`\[Sigma], 2], $CellContext`a, 
         Subscript[$CellContext`\[Sigma], 0], 3}, {
         Subscript[$CellContext`\[Sigma], 2], $CellContext`b, 
         Subscript[$CellContext`\[Sigma], 1], 2}}, 
       "Funci\[OAcute]n estado siguiente/salida"}}, {
      Hold[
       Style["Hilera de s\[IAcute]mbolos de entrada", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`MVl18$$], {$CellContext`a, $CellContext`b, \
$CellContext`b, $CellContext`a, $CellContext`a, $CellContext`b, \
$CellContext`a, $CellContext`a, $CellContext`b, $CellContext`b, \
$CellContext`a, $CellContext`a, $CellContext`b, $CellContext`b, \
$CellContext`b, $CellContext`b, $CellContext`b, $CellContext`a, \
$CellContext`b, $CellContext`a}, "Vector de s\[IAcute]mbolos de entrada"}}}, 
    Typeset`size$$ = {485., {148.5, 157.5}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`MVl13$$ = {
          Subscript[$CellContext`\[Sigma], 0], 
          Subscript[$CellContext`\[Sigma], 1], 
          
          Subscript[$CellContext`\[Sigma], 
           2]}, $CellContext`MVl14$$ = {$CellContext`a, $CellContext`b}, \
$CellContext`MVl15$$ = {0, 1, 2, 3}, $CellContext`MVl16$$ = 
        Subscript[$CellContext`\[Sigma], 0], $CellContext`MVl17$$ = {{
           Subscript[$CellContext`\[Sigma], 0], $CellContext`a, 
           Subscript[$CellContext`\[Sigma], 1], 0}, {
           Subscript[$CellContext`\[Sigma], 0], $CellContext`b, 
           Subscript[$CellContext`\[Sigma], 0], 2}, {
           Subscript[$CellContext`\[Sigma], 1], $CellContext`a, 
           Subscript[$CellContext`\[Sigma], 1], 1}, {
           Subscript[$CellContext`\[Sigma], 1], $CellContext`b, 
           Subscript[$CellContext`\[Sigma], 2], 0}, {
           Subscript[$CellContext`\[Sigma], 2], $CellContext`a, 
           Subscript[$CellContext`\[Sigma], 0], 3}, {
           Subscript[$CellContext`\[Sigma], 2], $CellContext`b, 
           Subscript[$CellContext`\[Sigma], 1], 
           2}}, $CellContext`MVl18$$ = {$CellContext`a, $CellContext`b, \
$CellContext`b, $CellContext`a, $CellContext`a, $CellContext`b, \
$CellContext`a, $CellContext`a, $CellContext`b, $CellContext`b, \
$CellContext`a, $CellContext`a, $CellContext`b, $CellContext`b, \
$CellContext`b, $CellContext`b, $CellContext`b, $CellContext`a, \
$CellContext`b, $CellContext`a}}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[
        $CellContext`MValidarConjunto[$CellContext`MVl13$$], 
        If[
         $CellContext`MValidarConjunto[$CellContext`MVl14$$], 
         If[
          $CellContext`MValidarConjunto[$CellContext`MVl15$$], 
          If[
           $CellContext`MValidarInicial[$CellContext`MVl13$$, \
$CellContext`MVl16$$], 
           If[
            $CellContext`MValidarFuncionES[$CellContext`MVl13$$, \
$CellContext`MVl14$$, $CellContext`MVl17$$, $CellContext`MVl15$$], 
            If[
             $CellContext`MValidarString[$CellContext`MVl14$$, \
$CellContext`MVl18$$], 
             Column[{
               $CellContext`MaquinaToDiagrama[$CellContext`MVl13$$, \
$CellContext`MVl14$$, $CellContext`MVl15$$, $CellContext`MVl16$$, \
$CellContext`MVl17$$, $CellContext`padding -> 25], 
               Row[{"Hilera de salida: ", 
                 Part[
                  $CellContext`StringOSalida[$CellContext`MVl13$$, \
$CellContext`MVl14$$, $CellContext`MVl15$$, $CellContext`MVl16$$, \
$CellContext`MVl17$$, $CellContext`MVl18$$], 1]}], 
               Row[{"Recorrido: ", 
                 Part[
                  $CellContext`StringOSalida[$CellContext`MVl13$$, \
$CellContext`MVl14$$, $CellContext`MVl15$$, $CellContext`MVl16$$, \
$CellContext`MVl17$$, $CellContext`MVl18$$], 2]}]}], ""], ""], ""], ""], ""], 
        ""], "Specifications" :> {
        Style[
        "Componentes de la m\[AAcute]quina", Bold, 
         Medium], {{$CellContext`MVl13$$, {
           Subscript[$CellContext`\[Sigma], 0], 
           Subscript[$CellContext`\[Sigma], 1], 
           Subscript[$CellContext`\[Sigma], 2]}, 
          "Estados"}}, {{$CellContext`MVl14$$, {$CellContext`a, \
$CellContext`b}, "S\[IAcute]mbolos de entrada"}}, {{$CellContext`MVl15$$, {0, 
          1, 2, 3}, "S\[IAcute]mbolos de salida"}}, {{$CellContext`MVl16$$, 
          Subscript[$CellContext`\[Sigma], 0], 
          "Estado inicial"}}, {{$CellContext`MVl17$$, {{
            Subscript[$CellContext`\[Sigma], 0], $CellContext`a, 
            Subscript[$CellContext`\[Sigma], 1], 0}, {
            Subscript[$CellContext`\[Sigma], 0], $CellContext`b, 
            Subscript[$CellContext`\[Sigma], 0], 2}, {
            Subscript[$CellContext`\[Sigma], 1], $CellContext`a, 
            Subscript[$CellContext`\[Sigma], 1], 1}, {
            Subscript[$CellContext`\[Sigma], 1], $CellContext`b, 
            Subscript[$CellContext`\[Sigma], 2], 0}, {
            Subscript[$CellContext`\[Sigma], 2], $CellContext`a, 
            Subscript[$CellContext`\[Sigma], 0], 3}, {
            Subscript[$CellContext`\[Sigma], 2], $CellContext`b, 
            Subscript[$CellContext`\[Sigma], 1], 2}}, 
          "Funci\[OAcute]n estado siguiente/salida"}}, Delimiter, 
        Style[
        "Hilera de s\[IAcute]mbolos de entrada", Bold, 
         Medium], {{$CellContext`MVl18$$, {$CellContext`a, $CellContext`b, \
$CellContext`b, $CellContext`a, $CellContext`a, $CellContext`b, \
$CellContext`a, $CellContext`a, $CellContext`b, $CellContext`b, \
$CellContext`a, $CellContext`a, $CellContext`b, $CellContext`b, \
$CellContext`b, $CellContext`b, $CellContext`b, $CellContext`a, \
$CellContext`b, $CellContext`a}, "Vector de s\[IAcute]mbolos de entrada"}}}, 
      "Options" :> {Alignment -> Center, FrameLabel -> {{None, None}, {
           Column[{
             Spacer[{400, 2}], 
             Row[{
               Style["Autor: Enrique V\[IAcute]lchez Quesada", Bold, 10, 
                RGBColor[0, 0.333333, 0]]}], 
             Row[{
               Style[
               "Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica", Bold, 10, 
                RGBColor[0.12, 0, 0.5]]}]}, Center], 
           Style["M\[AAcute]quinas de estado finito", Bold, 
            RGBColor[0, 0.333333, 0]]}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{1202., {262., 271.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((
      Clear[$CellContext`\[Sigma]]; $CellContext`MValidarConjunto[
         Pattern[$CellContext`MMConjunto, 
          Blank[]]] := Module[{}, 
         If[
          ListQ[$CellContext`MMConjunto], 
          If[MemberQ[$CellContext`MMConjunto, Null] == False, 
           If[ToString[$CellContext`MMConjunto] != ToString[{}], True, False],
            False], False]]; $CellContext`MValidarMatriz[
         Pattern[$CellContext`MMatriz, 
          Blank[]]] := Module[{}, 
         If[
          VectorQ[$CellContext`MMatriz, ListQ], 
          If[MemberQ[
             ToCharacterCode[
              ToString[$CellContext`MMatriz]], 62760] == False, 
           If[Part[
              Dimensions[$CellContext`MMatriz], 2] == 4, 
            If[MemberQ[
               Flatten[$CellContext`MMatriz], Null] == False, True], False], 
           False], False]]; $CellContext`MValidarInicial[
         Pattern[$CellContext`MMEstados, 
          Blank[]], 
         Pattern[$CellContext`MMInicial, 
          Blank[]]] := Module[{}, 
         If[
          $CellContext`MValidarConjunto[$CellContext`MMEstados], 
          If[
           MemberQ[$CellContext`MMEstados, $CellContext`MMInicial], True, 
           False], False]]; $CellContext`MValidarFuncionES[
         Pattern[$CellContext`MMEstados, 
          Blank[]], 
         Pattern[$CellContext`MMEntradas, 
          Blank[]], 
         Pattern[$CellContext`MMFEstadoSalida, 
          Blank[]], 
         Pattern[$CellContext`MMSalidas, 
          Blank[]]] := 
       Module[{$CellContext`MList23, $CellContext`MList24, \
$CellContext`MList25, $CellContext`Mi31}, 
         If[
          $CellContext`MValidarConjunto[$CellContext`MMEstados], 
          If[
           $CellContext`MValidarConjunto[$CellContext`MMEntradas], 
           If[
            $CellContext`MValidarMatriz[$CellContext`MMFEstadoSalida], 
            If[
             $CellContext`MValidarConjunto[$CellContext`MMSalidas], \
$CellContext`MList23 = 
              Cases[$CellContext`MMFEstadoSalida, Pattern[$CellContext`Mi31, 
                  Blank[]] :> {
                  Part[$CellContext`Mi31, 1], 
                  Part[$CellContext`Mi31, 2]}]; $CellContext`MList24 = 
              Cases[$CellContext`MMFEstadoSalida, Pattern[$CellContext`Mi31, 
                  Blank[]] :> 
                Part[$CellContext`Mi31, 3]]; $CellContext`MList25 = 
              Cases[$CellContext`MMFEstadoSalida, Pattern[$CellContext`Mi31, 
                  Blank[]] :> Part[$CellContext`Mi31, 4]]; If[ToString[
                 Sort[$CellContext`MList23]] == ToString[
                 Sort[
                  $CellContext`PC[$CellContext`MMEstados, \
$CellContext`MMEntradas]]], 
               If[
                SubsetQ[$CellContext`MMEstados, $CellContext`MList24], 
                If[
                 SubsetQ[$CellContext`MMSalidas, $CellContext`MList25], True, 
                 False], False], False], False], False], False], 
          False]]; $CellContext`MValidarString[
         Pattern[$CellContext`MMEntradas, 
          Blank[]], 
         Pattern[$CellContext`MMstring\[Alpha], 
          Blank[]]] := Module[{}, 
         If[
          $CellContext`MValidarConjunto[$CellContext`MMEntradas], 
          If[
           ListQ[$CellContext`MMstring\[Alpha]], 
           If[
            SubsetQ[$CellContext`MMEntradas, $CellContext`MMstring\[Alpha]], 
            True, False], False], False]]; $CellContext`StringOSalida[
         Pattern[$CellContext`MMEstados, 
          Blank[]], 
         Pattern[$CellContext`MMEntradas, 
          Blank[]], 
         Pattern[$CellContext`MMSalidas, 
          Blank[]], 
         Pattern[$CellContext`MMInicial, 
          Blank[]], 
         Pattern[$CellContext`MMFEstadoSalida, 
          Blank[]], 
         Pattern[$CellContext`MMstring\[Alpha], 
          Blank[]]] := 
       Module[{$CellContext`MMList9, $CellContext`MMList10, \
$CellContext`MMList11, $CellContext`MMStringSalidaTrace}, \
$CellContext`MMStringSalidaTrace[
            Pattern[$CellContext`MLista, 
             Blank[List]], 
            Pattern[$CellContext`string\[Alpha], 
             Blank[]], 
            Pattern[$CellContext`MEstadoInicial, 
             Blank[]]] := 
          Module[{$CellContext`MMaquinaEA = $CellContext`MEstadoInicial, \
$CellContext`MMaquinaDS = {}, $CellContext`MMdimensiones = 
             Dimensions[$CellContext`MLista], $CellContext`MMfila, \
$CellContext`MMi6, $CellContext`MMi7, $CellContext`MMaquinaDE, \
$CellContext`MListaEstadosTrace = {$CellContext`MEstadoInicial}}, 
            For[$CellContext`MMi6 = 1, $CellContext`MMi6 <= 
              Length[$CellContext`string\[Alpha]], $CellContext`MMaquinaDE = 
               Part[$CellContext`string\[Alpha], $CellContext`MMi6]; 
              For[$CellContext`MMi7 = 1, $CellContext`MMi7 <= 
                Part[$CellContext`MMdimensiones, 1], $CellContext`MMfila = 
                 Part[$CellContext`MLista, $CellContext`MMi7]; If[
                  
                  And[$CellContext`MMaquinaEA == 
                   Part[$CellContext`MMfila, 1], $CellContext`MMaquinaDE == 
                   Part[$CellContext`MMfila, 2]], $CellContext`MMaquinaDS = 
                   Append[$CellContext`MMaquinaDS, 
                    Part[$CellContext`MMfila, 4]]; $CellContext`MMaquinaEA = 
                   Part[$CellContext`MMfila, 
                    3]; $CellContext`MListaEstadosTrace = 
                   Append[$CellContext`MListaEstadosTrace, 
                    Part[$CellContext`MMfila, 3]]; Break[]]; 
                Increment[$CellContext`MMi7]]; 
              Increment[$CellContext`MMi6]]; {$CellContext`MMaquinaDS, \
$CellContext`MListaEstadosTrace}]; If[
           And[
            ListQ[$CellContext`MMEstados], 
            ListQ[$CellContext`MMEntradas], 
            ListQ[$CellContext`MMSalidas]], 
           If[
            And[
            MemberQ[$CellContext`MMEstados, Null] == False, 
             MemberQ[$CellContext`MMEntradas, Null] == False, 
             MemberQ[$CellContext`MMSalidas, Null] == False], 
            If[
             And[
             ToString[$CellContext`MMEstados] != ToString[{}], 
              ToString[$CellContext`MMEntradas] != ToString[{}], 
              ToString[$CellContext`MMSalidas] != ToString[{}]], 
             If[
              MemberQ[$CellContext`MMEstados, $CellContext`MMInicial], 
              If[
               VectorQ[$CellContext`MMFEstadoSalida, ListQ], 
               If[MemberQ[
                  ToCharacterCode[
                   ToString[$CellContext`MMFEstadoSalida]], 62760] == False, 
                If[Part[
                   Dimensions[$CellContext`MMFEstadoSalida], 2] == 4, 
                 If[MemberQ[
                    Flatten[$CellContext`MMFEstadoSalida], Null] == 
                  False, $CellContext`MMList9 = 
                   Cases[$CellContext`MMFEstadoSalida, 
                    Pattern[$CellContext`MMi1, 
                    Blank[]] :> {
                    Part[$CellContext`MMi1, 1], 
                    Part[$CellContext`MMi1, 2]}]; $CellContext`MMList10 = 
                   Cases[$CellContext`MMFEstadoSalida, 
                    Pattern[$CellContext`MMi1, 
                    Blank[]] :> 
                    Part[$CellContext`MMi1, 3]]; $CellContext`MMList11 = 
                   Cases[$CellContext`MMFEstadoSalida, 
                    Pattern[$CellContext`MMi1, 
                    Blank[]] :> Part[$CellContext`MMi1, 4]]; If[ToString[
                    Sort[$CellContext`MMList9]] == ToString[
                    Sort[
                    $CellContext`PC[$CellContext`MMEstados, \
$CellContext`MMEntradas]]], 
                    If[
                    SubsetQ[$CellContext`MMEstados, $CellContext`MMList10], 
                    If[
                    SubsetQ[$CellContext`MMSalidas, $CellContext`MMList11], 
                    If[
                    ListQ[$CellContext`MMstring\[Alpha]], 
                    If[
                    
                    SubsetQ[$CellContext`MMEntradas, $CellContext`MMstring\
\[Alpha]], 
                    $CellContext`MMStringSalidaTrace[$CellContext`\
MMFEstadoSalida, $CellContext`MMstring\[Alpha], \
$CellContext`MMInicial]]]]]]]]]]]]]]]; 
      Options[$CellContext`MaquinaToDiagrama] = {$CellContext`padding -> 
         10}; $CellContext`MaquinaToDiagrama[
         Pattern[$CellContext`MEstados, 
          Blank[]], 
         Pattern[$CellContext`MEntradas, 
          Blank[]], 
         Pattern[$CellContext`MSalidas, 
          Blank[]], 
         Pattern[$CellContext`MInicial, 
          Blank[]], 
         Pattern[$CellContext`MFEstadoSalida, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`MFuncionEtiquetas, $CellContext`Mi1, \
$CellContext`Mi2, $CellContext`Mi3, $CellContext`MList1, $CellContext`MList2, \
$CellContext`MList3, $CellContext`MList4, $CellContext`MList5, \
$CellContext`MList6, $CellContext`MList7, $CellContext`MList8, \
$CellContext`MVl1, $CellContext`MVl2, $CellContext`MVl3}, \
$CellContext`MFuncionEtiquetas[
            Pattern[$CellContext`MSEntrada, 
             Blank[]], 
            Pattern[$CellContext`MSSalida, 
             Blank[]]] := StringJoin[
            ToString[$CellContext`MSEntrada], "/", 
            ToString[$CellContext`MSSalida]]; If[
           IntegerQ[
            OptionValue[$CellContext`padding]], 
           If[OptionValue[$CellContext`padding] >= 10, 
            If[
             And[
              ListQ[$CellContext`MEstados], 
              ListQ[$CellContext`MEntradas], 
              ListQ[$CellContext`MSalidas]], 
             If[
              And[
              MemberQ[$CellContext`MEstados, Null] == False, 
               MemberQ[$CellContext`MEntradas, Null] == False, 
               MemberQ[$CellContext`MSalidas, Null] == False], 
              If[
               And[
               ToString[$CellContext`MEstados] != ToString[{}], 
                ToString[$CellContext`MEntradas] != ToString[{}], 
                ToString[$CellContext`MSalidas] != ToString[{}]], 
               If[
                MemberQ[$CellContext`MEstados, $CellContext`MInicial], 
                If[
                 VectorQ[$CellContext`MFEstadoSalida, ListQ], 
                 If[MemberQ[
                    ToCharacterCode[
                    ToString[$CellContext`MFEstadoSalida]], 62760] == False, 
                  If[Part[
                    Dimensions[$CellContext`MFEstadoSalida], 2] == 4, 
                   If[MemberQ[
                    Flatten[$CellContext`MFEstadoSalida], Null] == 
                    False, $CellContext`MList1 = 
                    Cases[$CellContext`MFEstadoSalida, 
                    Pattern[$CellContext`Mi1, 
                    Blank[]] :> {
                    Part[$CellContext`Mi1, 1], 
                    Part[$CellContext`Mi1, 2]}]; $CellContext`MList2 = 
                    Cases[$CellContext`MFEstadoSalida, 
                    Pattern[$CellContext`Mi1, 
                    Blank[]] :> 
                    Part[$CellContext`Mi1, 2]]; $CellContext`MList3 = 
                    Cases[$CellContext`MFEstadoSalida, 
                    Pattern[$CellContext`Mi1, 
                    Blank[]] :> 
                    Part[$CellContext`Mi1, 3]]; $CellContext`MList4 = 
                    Cases[$CellContext`MFEstadoSalida, 
                    Pattern[$CellContext`Mi1, 
                    Blank[]] :> 
                    Part[$CellContext`Mi1, 4]]; $CellContext`MList5 = 
                    Cases[$CellContext`MFEstadoSalida, 
                    Pattern[$CellContext`Mi1, 
                    Blank[]] :> {
                    Part[$CellContext`Mi1, 1], 
                    Part[$CellContext`Mi1, 3]}]; If[ToString[
                    Sort[$CellContext`MList1]] == ToString[
                    Sort[
                    $CellContext`PC[$CellContext`MEstados, \
$CellContext`MEntradas]]], 
                    If[
                    SubsetQ[$CellContext`MEstados, $CellContext`MList3], 
                    If[
                    
                    SubsetQ[$CellContext`MSalidas, $CellContext`MList4], \
$CellContext`MList6 = Prepend[$CellContext`MList5, {
                    "", $CellContext`MInicial}]; $CellContext`MList7 = Prepend[
                    
                    MapThread[$CellContext`MFuncionEtiquetas, \
{$CellContext`MList2, $CellContext`MList4}], ""]; $CellContext`MList8 = 
                    DeleteDuplicates[
                    
                    Select[$CellContext`MList6, Count[$CellContext`MList6, #] != 
                    1& ]]; If[ToString[$CellContext`MList8] != ToString[{}], 
                    
                    For[$CellContext`Mi2 = 1, $CellContext`Mi2 <= 
                    Length[$CellContext`MList8], $CellContext`MVl1 = Flatten[
                    Position[$CellContext`MList6, 
                    
                    Part[$CellContext`MList8, $CellContext`Mi2]]]; \
$CellContext`MVl2 = 
                    Part[$CellContext`MList7, $CellContext`MVl1]; \
$CellContext`MVl3 = Part[$CellContext`MVl2, 1]; 
                    For[$CellContext`Mi3 = 2, $CellContext`Mi3 <= 
                    Length[$CellContext`MVl2], $CellContext`MVl3 = 
                    StringJoin[$CellContext`MVl3, ",", 
                    Part[$CellContext`MVl2, $CellContext`Mi3]]; 
                    Increment[$CellContext`Mi3]]; $CellContext`MList7 = 
                    Delete[$CellContext`MList7, 
                    Position[$CellContext`MList6, 
                    
                    Part[$CellContext`MList8, $CellContext`Mi2]]]; \
$CellContext`MList7 = Insert[$CellContext`MList7, $CellContext`MVl3, 
                    Part[$CellContext`MVl1, 1]]; $CellContext`MList6 = 
                    Delete[$CellContext`MList6, 
                    Position[$CellContext`MList6, 
                    
                    Part[$CellContext`MList8, $CellContext`Mi2]]]; \
$CellContext`MList6 = Insert[$CellContext`MList6, 
                    Part[$CellContext`MList8, $CellContext`Mi2], 
                    Part[$CellContext`MVl1, 1]]; 
                    Increment[$CellContext`Mi2]]]; \
$CellContext`Grafo[$CellContext`MList6, $CellContext`dirigido -> 
                    True, $CellContext`pesos -> $CellContext`MList7, \
$CellContext`mostrarpesos -> True, $CellContext`padding -> 
                    OptionValue[$CellContext`padding]]]]]]]]]]]]]]]]; 
      Options[$CellContext`Grafo] = {$CellContext`dirigido -> 
         False, $CellContext`vertices -> {}, $CellContext`dimensions3d -> 
         False, $CellContext`pesos -> {}, $CellContext`mostrarpesos -> 
         False, $CellContext`shape -> False, $CellContext`padding -> 
         10}; $CellContext`Grafo[
         Pattern[$CellContext`GAristas, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GAristasNoDirigidas, \
$CellContext`GAristasDirigidas, $CellContext`GLabelsPesos, \
$CellContext`Grafo3d, $CellContext`GrafoNo3d}, \
$CellContext`GAristasNoDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador4, 
               Blank[]] -> UndirectedEdge[
               Part[$CellContext`Gicontador4, 1], 
               
               Part[$CellContext`Gicontador4, 
                2]]]]; $CellContext`GAristasDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador5, 
               Blank[]] -> DirectedEdge[
               Part[$CellContext`Gicontador5, 1], 
               Part[$CellContext`Gicontador5, 2]]]]; $CellContext`GLabelsPesos[
            Pattern[$CellContext`GGrafo, 
             Blank[]], 
            Pattern[$CellContext`GPesos, 
             Blank[]]] := 
          If[Length[$CellContext`GPesos] == EdgeCount[$CellContext`GGrafo], 
            
            Module[{$CellContext`GList1 = 
              EdgeList[$CellContext`GGrafo], $CellContext`GList2 = {}}, 
             For[$CellContext`Gi1 = 1, $CellContext`Gi1 <= 
               Length[$CellContext`GList1], $CellContext`GList2 = 
                Append[$CellContext`GList2, 
                  Part[$CellContext`GList1, $CellContext`Gi1] -> 
                  Part[$CellContext`GPesos, $CellContext`Gi1]]; 
               Increment[$CellContext`Gi1]]; $CellContext`GList2]]; \
$CellContext`Grafo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> OptionValue[$CellContext`padding], 
                  EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> OptionValue[$CellContext`padding], 
                  EdgeWeight -> OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> OptionValue[$CellContext`padding], 
                  EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> OptionValue[$CellContext`padding], 
                  EdgeWeight -> OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> OptionValue[$CellContext`padding], EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> OptionValue[$CellContext`padding], EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 
                  OptionValue[$CellContext`padding], EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 
                  OptionValue[$CellContext`padding], EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 
                  OptionValue[$CellContext`padding], EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 
                  OptionValue[$CellContext`padding], EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 
                OptionValue[$CellContext`padding], EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 
                OptionValue[$CellContext`padding], EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; $CellContext`GrafoNo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> OptionValue[$CellContext`padding], 
                  EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> OptionValue[$CellContext`padding], 
                  EdgeWeight -> OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> OptionValue[$CellContext`padding], 
                  EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> OptionValue[$CellContext`padding], 
                  EdgeWeight -> OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> OptionValue[$CellContext`padding], EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> OptionValue[$CellContext`padding], EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 
                  OptionValue[$CellContext`padding], EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 
                  OptionValue[$CellContext`padding], EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 
                  OptionValue[$CellContext`padding], EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 
                    OptionValue[$CellContext`padding]], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 
                  OptionValue[$CellContext`padding], EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 
                OptionValue[$CellContext`padding], EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 
                OptionValue[$CellContext`padding], EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dirigido]], 
            VectorQ[
             OptionValue[$CellContext`vertices]], 
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            VectorQ[
             OptionValue[$CellContext`pesos]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]], 
            IntegerQ[
             OptionValue[$CellContext`padding]]], 
           If[OptionValue[$CellContext`padding] >= 10, 
            If[
             And[MemberQ[
                OptionValue[$CellContext`vertices], Null] == False, MemberQ[
                OptionValue[$CellContext`pesos], Null] == False], 
             If[
              And[
               Or[
                VectorQ[$CellContext`GAristas, ListQ], 
                ToString[$CellContext`GAristas] == ToString[{}]], MemberQ[
                 Flatten[$CellContext`GAristas], Null] == False], 
              If[
               Or[Length[$CellContext`GAristas] == Length[
                  OptionValue[$CellContext`pesos]], ToString[
                  OptionValue[$CellContext`pesos]] == ToString[{}]], 
               If[
                Or[
                 And[ToString[$CellContext`GAristas] == ToString[{}], ToString[
                    OptionValue[$CellContext`vertices]] != ToString[{}]], 
                 And[
                  VectorQ[$CellContext`GAristas, ListQ], Part[
                    Dimensions[$CellContext`GAristas], 2] == 2, MemberQ[
                    ToCharacterCode[
                    ToString[$CellContext`GAristas]], 62760] == False]], 
                If[
                 OptionValue[$CellContext`dimensions3d], 
                 $CellContext`Grafo3d[$CellContext`GAristas], 
                 $CellContext`GrafoNo3d[$CellContext`GAristas]]]]]]]]]; \
$CellContext`PC[
         Pattern[$CellContext`RBA, 
          Blank[List]], 
         Pattern[$CellContext`RBB, 
          Blank[List]]] := Module[{}, 
         If[
          And[
           VectorQ[$CellContext`RBA], 
           VectorQ[$CellContext`RBB]], 
          If[
           And[
           MemberQ[$CellContext`RBA, Null] == False, 
            MemberQ[$CellContext`RBB, Null] == False], 
           If[
            And[
            ToString[$CellContext`RBA] != ToString[{}], 
             ToString[$CellContext`RBB] != ToString[{}]], 
            DeleteDuplicates[
             Flatten[
              Outer[{#, #2}& , $CellContext`RBA, $CellContext`RBB], 1]]]]]]); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.681126008675482*^9, 3.6811265986307707`*^9, 3.6811267302679763`*^9, {
   3.681126768016113*^9, 3.6811268089861665`*^9}, {3.6811268788811345`*^9, 
   3.6811269627493505`*^9}, {3.8011562702595243`*^9, 3.801156309867161*^9}},
 CellLabel->"Out[2]=",ExpressionUUID->"5a87ae3f-ca6c-4b99-966c-dceae6d6d348"]
}, Open  ]]
},
WindowSize->{1366, 685},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f09f61fa-0390-4e1d-a375-c4d2d43c8808"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 84432, 1763, 13485, "Input",ExpressionUUID->"56aaf573-1b5f-4fee-9f36-07a86037685d"],
Cell[85015, 1787, 48229, 961, 602, "Output",ExpressionUUID->"5a87ae3f-ca6c-4b99-966c-dceae6d6d348"]
}, Open  ]]
}
]
*)

