(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    131501,       2956]
NotebookOptionsPosition[    130978,       2938]
NotebookOutlinePosition[    131407,       2955]
CellTagsIndexPosition[    131364,       2952]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"VectorQ", "[", "ccons", "]"}], "&&", 
      RowBox[{"VectorQ", "[", "condini", "]"}], "&&", 
      RowBox[{"VectorQ", "[", "coefpoli", "]"}], "&&", 
      RowBox[{"IntegerQ", "[", "ev", "]"}]}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"NumberQ", "[", 
         RowBox[{"Total", "[", "ccons", "]"}], "]"}], "&&", 
        RowBox[{"NumberQ", "[", 
         RowBox[{"Total", "[", "condini", "]"}], "]"}], "&&", 
        RowBox[{"NumberQ", "[", 
         RowBox[{"Total", "[", "coefpoli", "]"}], "]"}]}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "ccons", "]"}], "\[Equal]", 
           RowBox[{"Length", "[", "condini", "]"}]}], "&&", 
          RowBox[{
           RowBox[{"Length", "[", "ccons", "]"}], "\[GreaterEqual]", "2"}]}], 
         ",", 
         RowBox[{"Column", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"vl1", "==", "1"}], "&&", 
                RowBox[{"tipo", "\[Equal]", "0"}]}], ",", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"ElementoSucesionH", "[", 
                  RowBox[{"ccons", ",", "condini", ",", "valorsr"}], "]"}], 
                 ",", 
                 RowBox[{"{", 
                  RowBox[{"valorsr", ",", "0", ",", 
                   RowBox[{"ev", "-", "1"}]}], "}"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"vl1", "==", "1"}], "&&", 
                  RowBox[{"tipo", "\[Equal]", "1"}]}], ",", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{"ElementoSucesionNH", "[", 
                    RowBox[{"ccons", ",", "condini", ",", 
                    RowBox[{"{", 
                    RowBox[{"Dot", "[", 
                    RowBox[{"coefpoli", ",", 
                    RowBox[{"Polinomio", "[", "coefpoli", "]"}]}], "]"}], 
                    "}"}], ",", "valorsr"}], "]"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"valorsr", ",", "0", ",", 
                    RowBox[{"ev", "-", "1"}]}], "}"}]}], "]"}]}], "]"}]}], 
              "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{"grafica", ",", 
               RowBox[{
                RowBox[{"vl1", "=", "1"}], ";", 
                RowBox[{"DiscretePlot", "[", 
                 RowBox[{
                  RowBox[{"CrearRR", "[", 
                   RowBox[{
                   "ccons", ",", "condini", ",", "coefpoli", ",", "valorsr"}],
                    "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"valorsr", ",", "0", ",", 
                    RowBox[{"ev", "-", "1"}]}], "}"}]}], "]"}]}]}], "]"}], 
             ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"vl2", "\[Equal]", "1"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"tipo", "\[Equal]", "0"}], ",", 
                 RowBox[{"PruebaH", "[", 
                  RowBox[{
                   RowBox[{"nprof", "-", "1"}], ",", "ccons", ",", 
                   "condini"}], "]"}], ",", 
                 RowBox[{"PruebaNH", "[", 
                  RowBox[{
                   RowBox[{"nprof", "-", "1"}], ",", "ccons", ",", "condini", 
                   ",", 
                   RowBox[{"{", 
                    RowBox[{"Dot", "[", 
                    RowBox[{"coefpoli", ",", 
                    RowBox[{"Polinomio", "[", "coefpoli", "]"}]}], "]"}], 
                    "}"}], ",", "coefpoli"}], "]"}]}], "]"}]}], "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"vl3", "==", "1"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"tipo", "\[Equal]", "0"}], ",", 
                 RowBox[{"ResolRRH", "[", 
                  RowBox[{"ccons", ",", "condini"}], "]"}], ",", 
                 RowBox[{"ResolRRNH", "[", 
                  RowBox[{"ccons", ",", "condini", ",", 
                   RowBox[{"{", 
                    RowBox[{"Dot", "[", 
                    RowBox[{"coefpoli", ",", 
                    RowBox[{"Polinomio", "[", "coefpoli", "]"}]}], "]"}], 
                    "}"}]}], "]"}]}], "]"}]}], "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"vl4", "==", "1"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"tipo", "\[Equal]", "0"}], ",", 
                 RowBox[{"SolveRRHM", "[", 
                  RowBox[{
                   RowBox[{"solm", "-", "1"}], ",", "ccons", ",", "condini"}],
                   "]"}], ",", 
                 RowBox[{"SolveRRNHM", "[", 
                  RowBox[{
                   RowBox[{"solm", "-", "1"}], ",", "ccons", ",", "condini", 
                   ",", 
                   RowBox[{"{", 
                    RowBox[{"Dot", "[", 
                    RowBox[{"coefpoli", ",", 
                    RowBox[{"Polinomio", "[", "coefpoli", "]"}]}], "]"}], 
                    "}"}]}], "]"}]}], "]"}]}], "]"}]}], "}"}], ",", 
           "Center"}], "]"}], ",", 
         "\"\<Error en las longitudes de los vectores\>\""}], "]"}], ",", 
       "\"\<Error, valor nulo en las componentes de los vectores\>\""}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"ccons", "=", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], ";", 
      RowBox[{"condini", "=", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], ";", 
      RowBox[{"coefpoli", "=", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], ";", 
      RowBox[{"ev", "=", "1"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "tipo", ",", "0", ",", 
       "\"\<Tipo de relaci\[OAcute]n de recurrencia\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0", "\[Rule]", "\"\<Homog\[EAcute]nea\>\""}], ",", 
       RowBox[{"1", "\[Rule]", "\"\<No homog\[EAcute]nea\>\""}]}], "}"}], ",", 
     RowBox[{"ControlType", "->", "PopupMenu"}]}], "}"}], ",", "Delimiter", 
   ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"ccons", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      "\"\<Coeficientes constantes\>\""}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"condini", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "\"\<Condiciones iniciales\>\""}],
      "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"coefpoli", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      "\"\<Coeficientes del polinomio (orden decreciente)\>\""}], "}"}], 
    "}"}], ",", "Delimiter", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "ev", ",", "10", ",", 
      "\"\<Cantidad de elementos a evaluar en la sucesi\[OAcute]n\>\""}], 
     "}"}], "}"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Evaluar\>\"", ",", 
     RowBox[{"vl1", "=", "1"}]}], "]"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<No evaluar\>\"", ",", 
     RowBox[{
      RowBox[{"vl1", "=", "0"}], ";", 
      RowBox[{"grafica", "=", "False"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "grafica", ",", "False", ",", "\"\<Mostrar gr\[AAcute]fica\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", " ", "False"}], "}"}]}], "}"}], ",", "Delimiter", 
   ",", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<Velocidad de convergencia: {recursividad, m\[EAcute]todo matricial, \
iguales}\>\"", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"nprof", ",", "5", ",", "\"\<N\[UAcute]mero de pruebas\>\""}], 
      "}"}], ",", "5", ",", "50", ",", "1"}], "}"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Ejecutar\>\"", ",", 
     RowBox[{"vl2", "=", "1"}]}], "]"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Detener\>\"", ",", 
     RowBox[{"vl2", "=", "0"}]}], "]"}], ",", "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<Soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia\>\"", ",", 
     "Bold"}], "]"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Encontrar\>\"", ",", 
     RowBox[{"vl3", "=", "1"}]}], "]"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Detener\>\"", ",", 
     RowBox[{"vl3", "=", "0"}]}], "]"}], ",", "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<Soluci\[OAcute]n manual de la relaci\[OAcute]n de recurrencia\>\"", 
     ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "solm", ",", "5", ",", "\"\<Valor de la soluci\[OAcute]n manual\>\""}], 
     "}"}], "}"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Encontrar\>\"", ",", 
     RowBox[{"vl4", "=", "1"}]}], "]"}], ",", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Detener\>\"", ",", 
     RowBox[{"vl4", "=", "0"}]}], "]"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"vl1", "=", "0"}], ";", 
      RowBox[{"vl2", "=", "0"}], ";", 
      RowBox[{"vl3", "=", "0"}], ";", 
      RowBox[{"vl4", "=", "0"}], ";", 
      RowBox[{
       RowBox[{"Polinomio", "[", "h_List", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"longitud", "=", 
           RowBox[{"Length", "[", "h", "]"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"poly", "=", 
           RowBox[{"{", "1", "}"}]}], ";", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "1"}], ",", 
            RowBox[{"i", "\[LessEqual]", 
             RowBox[{"longitud", "-", "1"}]}], ",", 
            RowBox[{
             RowBox[{"poly", "=", 
              RowBox[{"Prepend", "[", 
               RowBox[{"poly", ",", 
                SuperscriptBox["n", "i"]}], "]"}]}], ";", 
             RowBox[{"i", "++"}]}]}], "]"}], ";", 
          RowBox[{"Return", "[", "poly", "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"CrearRR", "[", 
        RowBox[{
        "coefcons_List", ",", "condiniini_List", ",", "ccoefpoli_List", ",", 
         "vov_"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", 
           RowBox[{"vectrr", "=", 
            RowBox[{"{", "}"}]}], ",", "OPoli"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"OPoli", "[", "olh_List", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"longitud", "=", 
               RowBox[{"Length", "[", "olh", "]"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"opoly", "=", 
               RowBox[{"{", "1", "}"}]}], ";", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"i", "=", "1"}], ",", 
                RowBox[{"i", "\[LessEqual]", 
                 RowBox[{"longitud", "-", "1"}]}], ",", 
                RowBox[{
                 RowBox[{"opoly", "=", 
                  RowBox[{"Prepend", "[", 
                   RowBox[{"opoly", ",", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"k", "-", 
                    RowBox[{"Length", "[", "coefcons", "]"}]}], ")"}], "i"]}],
                    "]"}]}], ";", 
                 RowBox[{"i", "++"}]}]}], "]"}], ";", 
              RowBox[{"Return", "[", "opoly", "]"}]}]}], "]"}]}], ";", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "1"}], ",", 
            RowBox[{"i", "\[LessEqual]", 
             RowBox[{"Length", "[", "coefcons", "]"}]}], ",", 
            RowBox[{
             RowBox[{"vectrr", "=", 
              RowBox[{"Prepend", "[", 
               RowBox[{"vectrr", ",", 
                RowBox[{"a", "[", 
                 RowBox[{"k", "-", "i"}], "]"}]}], "]"}]}], ";", 
             RowBox[{"i", "++"}]}]}], "]"}], ";", 
          RowBox[{
           RowBox[{"a", "[", "p_", "]"}], ":=", 
           RowBox[{"Block", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"k", "=", "p"}], "}"}], ",", 
             RowBox[{
              RowBox[{"Dot", "[", 
               RowBox[{"vectrr", ",", "coefcons"}], "]"}], "+", 
              RowBox[{"Dot", "[", 
               RowBox[{"ccoefpoli", ",", 
                RowBox[{"OPoli", "[", "ccoefpoli", "]"}]}], "]"}]}]}], 
            "]"}]}], ";", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "1"}], ",", 
            RowBox[{"i", "\[LessEqual]", 
             RowBox[{"Length", "[", "condiniini", "]"}]}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"a", "[", 
               RowBox[{"i", "-", "1"}], "]"}], "=", 
              RowBox[{"condiniini", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], ";", 
             RowBox[{"i", "++"}]}]}], "]"}], ";", 
          RowBox[{"a", "[", "vov", "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"ElementoSucesionH", "[", 
        RowBox[{"Coeficient_List", ",", "ConditionInitial_List", ",", "m_"}], 
        "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CD", "=", 
            RowBox[{"Reverse", "[", "ConditionInitial", "]"}]}], ",", 
           RowBox[{"h", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"Dimensions", "[", "ConditionInitial", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", "Matriz"}], 
          "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Matriz", "[", 
            RowBox[{"Coeficientes_List", ",", "nn_"}], "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Identidad", "=", 
                RowBox[{"IdentityMatrix", "[", 
                 RowBox[{
                  RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
               RowBox[{"A", "=", 
                RowBox[{"{", "Coeficientes", "}"}]}], ",", "i", ",", "CF"}], 
              "}"}], ",", 
             RowBox[{
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"i", "=", "1"}], ",", 
                RowBox[{"i", "\[LessEqual]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                RowBox[{
                 RowBox[{"A", "=", 
                  RowBox[{"Append", "[", 
                   RowBox[{"A", ",", 
                    RowBox[{"Identidad", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
                 RowBox[{"i", "++"}]}]}], "]"}], ";", 
              RowBox[{
               RowBox[{"CF", "[", 
                RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
               RowBox[{"Block", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
              RowBox[{"Return", "[", 
               RowBox[{"CF", "[", 
                RowBox[{"A", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"A", "[", "n_", "]"}], ":=", 
           RowBox[{"Matriz", "[", 
            RowBox[{"Coeficient", ",", "n"}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"m", ">", "h"}], ",", 
            RowBox[{
             RowBox[{"Elemento", "=", 
              RowBox[{
               RowBox[{"A", "[", "0", "]"}], ".", 
               RowBox[{"Transpose", "[", 
                RowBox[{"{", "CD", "}"}], "]"}]}]}], ";", 
             RowBox[{"For", "[", 
              RowBox[{
               RowBox[{"i", "=", "1"}], ",", 
               RowBox[{"i", "\[LessEqual]", 
                RowBox[{"m", "-", "1"}]}], ",", 
               RowBox[{
                RowBox[{"Elemento", "=", 
                 RowBox[{"Dot", "[", 
                  RowBox[{
                   RowBox[{"A", "[", "i", "]"}], ",", "Elemento"}], "]"}]}], 
                ";", 
                RowBox[{"i", "++"}]}]}], "]"}], ";", 
             RowBox[{"Return", "[", 
              RowBox[{"Elemento", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"h", "+", "1"}], ",", "1"}], "]"}], "]"}], "]"}]}], 
            ",", 
            RowBox[{"Return", "[", 
             RowBox[{"ConditionInitial", "[", 
              RowBox[{"[", 
               RowBox[{"m", "+", "1"}], "]"}], "]"}], "]"}]}], "]"}]}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"ElementoSucesionNH", "[", 
        RowBox[{
        "Coefi_List", ",", "ConditInitial_List", ",", "F_List", ",", "w_"}], 
        "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"nc", "=", 
            RowBox[{
             RowBox[{"Dimensions", "[", "Coefi", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", "ElementoSucesionH", ",", 
           "Sumatoria"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"ElementoSucesionH", "[", 
            RowBox[{
            "Coeficient_List", ",", "ConditionInitial_List", ",", "m_"}], 
            "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"CD", "=", 
                RowBox[{"Reverse", "[", "ConditionInitial", "]"}]}], ",", 
               RowBox[{"h", "=", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Dimensions", "[", "ConditionInitial", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
               "Matriz"}], "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Matriz", "[", 
                RowBox[{"Coeficientes_List", ",", "nn_"}], "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Identidad", "=", 
                    RowBox[{"IdentityMatrix", "[", 
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
                   RowBox[{"A", "=", 
                    RowBox[{"{", "Coeficientes", "}"}]}], ",", "i", ",", 
                   "CF"}], "}"}], ",", 
                 RowBox[{
                  RowBox[{"For", "[", 
                   RowBox[{
                    RowBox[{"i", "=", "1"}], ",", 
                    RowBox[{"i", "\[LessEqual]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"A", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"Identidad", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                  RowBox[{
                   RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                   RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                  RowBox[{"Return", "[", 
                   RowBox[{"CF", "[", 
                    RowBox[{"A", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
              RowBox[{
               RowBox[{"A", "[", "n_", "]"}], ":=", 
               RowBox[{"Matriz", "[", 
                RowBox[{"Coeficient", ",", "n"}], "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"m", ">", "h"}], ",", 
                RowBox[{
                 RowBox[{"Elemento", "=", 
                  RowBox[{
                   RowBox[{"A", "[", "0", "]"}], ".", 
                   RowBox[{"Transpose", "[", 
                    RowBox[{"{", "CD", "}"}], "]"}]}]}], ";", 
                 RowBox[{"For", "[", 
                  RowBox[{
                   RowBox[{"i", "=", "1"}], ",", 
                   RowBox[{"i", "\[LessEqual]", 
                    RowBox[{"m", "-", "1"}]}], ",", 
                   RowBox[{
                    RowBox[{"Elemento", "=", 
                    RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "i", "]"}], ",", "Elemento"}], "]"}]}], 
                    ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                 RowBox[{"Return", "[", 
                  RowBox[{"Elemento", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"h", "+", "1"}], ",", "1"}], "]"}], "]"}], 
                  "]"}]}], ",", 
                RowBox[{"Return", "[", 
                 RowBox[{"ConditionInitial", "[", 
                  RowBox[{"[", 
                   RowBox[{"m", "+", "1"}], "]"}], "]"}], "]"}]}], "]"}]}]}], 
            "]"}]}], ";", 
          RowBox[{
           RowBox[{"Sumatoria", "[", 
            RowBox[{"Coeficient_List", ",", "Funct_List", ",", "ww_"}], "]"}],
            ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Matriz", ",", "MatrizB", ",", 
               RowBox[{"t", "=", 
                RowBox[{
                 RowBox[{"Dimensions", "[", "Coeficient", "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], ",", "Productoria", ",", 
               "s"}], "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Matriz", "[", 
                RowBox[{"Coeficientes_List", ",", "nn_"}], "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Identidad", "=", 
                    RowBox[{"IdentityMatrix", "[", 
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
                   RowBox[{"A", "=", 
                    RowBox[{"{", "Coeficientes", "}"}]}], ",", "i", ",", 
                   "CF"}], "}"}], ",", 
                 RowBox[{
                  RowBox[{"For", "[", 
                   RowBox[{
                    RowBox[{"i", "=", "1"}], ",", 
                    RowBox[{"i", "\[LessEqual]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"A", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"Identidad", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                  RowBox[{
                   RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                   RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                  RowBox[{"Return", "[", 
                   RowBox[{"CF", "[", 
                    RowBox[{"A", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
              RowBox[{
               RowBox[{"A", "[", "n_", "]"}], ":=", 
               RowBox[{"Matriz", "[", 
                RowBox[{"Coeficient", ",", "n"}], "]"}]}], ";", 
              RowBox[{
               RowBox[{"MatrizB", "[", 
                RowBox[{"Funcion_List", ",", "filas_", ",", "nn_"}], "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"MB", "=", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"0", ",", 
                    RowBox[{"{", 
                    RowBox[{"filas", ",", "1"}], "}"}]}], "]"}]}], ",", 
                   "CF"}], "}"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"MB", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
                   RowBox[{"Funcion", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                   RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                  RowBox[{"Return", "[", 
                   RowBox[{"CF", "[", 
                    RowBox[{"MB", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
              RowBox[{
               RowBox[{"B", "[", "n_", "]"}], ":=", 
               RowBox[{"MatrizB", "[", 
                RowBox[{"Funct", ",", "t", ",", "n"}], "]"}]}], ";", 
              RowBox[{
               RowBox[{"Productoria", "[", 
                RowBox[{"ini_", ",", "final_"}], "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", "i", "}"}], ",", 
                 RowBox[{
                  RowBox[{"p", "=", 
                   RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "ini", "]"}], ",", 
                    RowBox[{"B", "[", 
                    RowBox[{"ini", "-", "1"}], "]"}]}], "]"}]}], ";", 
                  RowBox[{"For", "[", 
                   RowBox[{
                    RowBox[{"i", "=", 
                    RowBox[{"ini", "+", "1"}]}], ",", 
                    RowBox[{"i", "\[LessEqual]", "final"}], ",", 
                    RowBox[{
                    RowBox[{"p", "=", 
                    RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "i", "]"}], ",", "p"}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                  RowBox[{"Return", "[", "p", "]"}]}]}], "]"}]}], ";", 
              RowBox[{"s", "=", 
               RowBox[{"Sum", "[", 
                RowBox[{
                 RowBox[{"Productoria", "[", 
                  RowBox[{"k", ",", 
                   RowBox[{"ww", "-", "1"}]}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"k", ",", "1", ",", 
                   RowBox[{"ww", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
              RowBox[{"Return", "[", 
               RowBox[{"s", "[", 
                RowBox[{"[", 
                 RowBox[{"t", ",", "1"}], "]"}], "]"}], "]"}]}]}], "]"}]}], 
          ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"w", "\[LessEqual]", 
             RowBox[{"nc", "-", "1"}]}], ",", 
            RowBox[{"ElementoSucesionH", "[", 
             RowBox[{"Coefi", ",", "ConditInitial", ",", "w"}], "]"}], ",", 
            RowBox[{"Return", "[", 
             RowBox[{
              RowBox[{"ElementoSucesionH", "[", 
               RowBox[{"Coefi", ",", "ConditInitial", ",", "w"}], "]"}], "+", 
              RowBox[{"Sumatoria", "[", 
               RowBox[{"Coefi", ",", "F", ",", "w"}], "]"}]}], "]"}]}], 
           "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"PruebaH", "[", 
        RowBox[{"m_", ",", "Con_List", ",", "Condici_List"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"alr", "=", "0"}], ",", 
           RowBox[{"mt", "=", "0"}], ",", 
           RowBox[{"alm", "=", "0"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"k", "=", "0"}], ",", 
            RowBox[{"k", "\[LessEqual]", "m"}], ",", 
            RowBox[{
             RowBox[{"ClearSystemCache", "[", "]"}], ";", 
             RowBox[{"L1", "=", 
              RowBox[{"First", "[", 
               RowBox[{"Timing", "[", 
                RowBox[{"ElementoSucesionH", "[", 
                 RowBox[{"Con", ",", "Condici", ",", "k"}], "]"}], "]"}], 
               "]"}]}], ";", 
             RowBox[{"ClearSystemCache", "[", "]"}], ";", 
             RowBox[{"L2", "=", 
              RowBox[{"First", "[", 
               RowBox[{"Timing", "[", 
                RowBox[{"CrearRR", "[", 
                 RowBox[{"Con", ",", "Condici", ",", 
                  RowBox[{"ConstantArray", "[", 
                   RowBox[{"0", ",", "1"}], "]"}], ",", "k"}], "]"}], "]"}], 
               "]"}]}], ";", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"L1", ">", "L2"}], "&&", 
                RowBox[{"L1", "\[NotEqual]", "L2"}]}], ",", 
               RowBox[{"alr", "++"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"L1", "\[Equal]", "L2"}], ",", 
                 RowBox[{"mt", "++"}], ",", 
                 RowBox[{"alm", "++"}]}], "]"}]}], "]"}], ";", 
             RowBox[{"k", "++"}]}]}], "]"}], ";", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"alr", ",", "alm", ",", "mt"}], "}"}], "]"}]}]}], "]"}]}],
       ";", 
      RowBox[{
       RowBox[{"PruebaNH", "[", 
        RowBox[{
        "m_", ",", "Con_List", ",", "Condici_List", ",", "Fun_List", ",", 
         "coefpoli_"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"alr", "=", "0"}], ",", 
           RowBox[{"mt", "=", "0"}], ",", 
           RowBox[{"alm", "=", "0"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"k", "=", "0"}], ",", 
            RowBox[{"k", "\[LessEqual]", "m"}], ",", 
            RowBox[{
             RowBox[{"ClearSystemCache", "[", "]"}], ";", 
             RowBox[{"L1", "=", 
              RowBox[{"First", "[", 
               RowBox[{"Timing", "[", 
                RowBox[{"ElementoSucesionNH", "[", 
                 RowBox[{"Con", ",", "Condici", ",", 
                  RowBox[{"{", 
                   RowBox[{"Dot", "[", 
                    RowBox[{"coefpoli", ",", 
                    RowBox[{"Polinomio", "[", "coefpoli", "]"}]}], "]"}], 
                   "}"}], ",", "k"}], "]"}], "]"}], "]"}]}], ";", 
             RowBox[{"ClearSystemCache", "[", "]"}], ";", 
             RowBox[{"L2", "=", 
              RowBox[{"First", "[", 
               RowBox[{"Timing", "[", 
                RowBox[{"CrearRR", "[", 
                 RowBox[{"Con", ",", "Condici", ",", "coefpoli", ",", "k"}], 
                 "]"}], "]"}], "]"}]}], ";", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"L1", ">", "L2"}], "&&", 
                RowBox[{"L1", "\[NotEqual]", "L2"}]}], ",", 
               RowBox[{"alr", "++"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"L1", "\[Equal]", "L2"}], ",", 
                 RowBox[{"mt", "++"}], ",", 
                 RowBox[{"alm", "++"}]}], "]"}]}], "]"}], ";", 
             RowBox[{"k", "++"}]}]}], "]"}], ";", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"alr", ",", "alm", ",", "mt"}], "}"}], "]"}]}]}], "]"}]}],
       ";", 
      RowBox[{
       RowBox[{"ResolRRH", "[", 
        RowBox[{"Co_List", ",", "Con_List"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ElementoSucesionH", ",", "SolveR", ",", "SolveRR"}], "}"}],
          ",", 
         RowBox[{
          RowBox[{
           RowBox[{"ElementoSucesionH", "[", 
            RowBox[{
            "Coeficient_List", ",", "ConditionInitial_List", ",", "m_"}], 
            "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"CD", "=", 
                RowBox[{"Reverse", "[", "ConditionInitial", "]"}]}], ",", 
               RowBox[{"h", "=", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Dimensions", "[", "ConditionInitial", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
               "Matriz"}], "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Matriz", "[", 
                RowBox[{"Coeficientes_List", ",", "nn_"}], "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Identidad", "=", 
                    RowBox[{"IdentityMatrix", "[", 
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
                   RowBox[{"A", "=", 
                    RowBox[{"{", "Coeficientes", "}"}]}], ",", "i", ",", 
                   "CF"}], "}"}], ",", 
                 RowBox[{
                  RowBox[{"For", "[", 
                   RowBox[{
                    RowBox[{"i", "=", "1"}], ",", 
                    RowBox[{"i", "\[LessEqual]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"A", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"Identidad", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                  RowBox[{
                   RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                   RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                  RowBox[{"Return", "[", 
                   RowBox[{"CF", "[", 
                    RowBox[{"A", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
              RowBox[{
               RowBox[{"A", "[", "n_", "]"}], ":=", 
               RowBox[{"Matriz", "[", 
                RowBox[{"Coeficient", ",", "n"}], "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"m", ">", "h"}], ",", 
                RowBox[{
                 RowBox[{"Elemento", "=", 
                  RowBox[{
                   RowBox[{"A", "[", "0", "]"}], ".", 
                   RowBox[{"Transpose", "[", 
                    RowBox[{"{", "CD", "}"}], "]"}]}]}], ";", 
                 RowBox[{"For", "[", 
                  RowBox[{
                   RowBox[{"i", "=", "1"}], ",", 
                   RowBox[{"i", "\[LessEqual]", 
                    RowBox[{"m", "-", "1"}]}], ",", 
                   RowBox[{
                    RowBox[{"Elemento", "=", 
                    RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "i", "]"}], ",", "Elemento"}], "]"}]}], 
                    ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                 RowBox[{"Return", "[", 
                  RowBox[{"Elemento", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"h", "+", "1"}], ",", "1"}], "]"}], "]"}], 
                  "]"}]}], ",", 
                RowBox[{"Return", "[", 
                 RowBox[{"ConditionInitial", "[", 
                  RowBox[{"[", 
                   RowBox[{"m", "+", "1"}], "]"}], "]"}], "]"}]}], "]"}]}]}], 
            "]"}]}], ";", 
          RowBox[{
           RowBox[{"SolveR", "[", 
            RowBox[{
            "mm_", ",", "Coeficien_List", ",", "ConditionInitia_List", ",", 
             "n_"}], "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"L", "=", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"i", "=", "0"}], ",", 
                RowBox[{"i", "\[LessEqual]", "mm"}], ",", 
                RowBox[{
                 RowBox[{"L", "=", 
                  RowBox[{"Append", "[", 
                   RowBox[{"L", ",", 
                    RowBox[{"ElementoSucesionH", "[", 
                    RowBox[{"Coeficien", ",", "ConditionInitia", ",", "i"}], 
                    "]"}]}], "]"}]}], ";", 
                 RowBox[{"i", "++"}]}]}], "]"}], ";", 
              RowBox[{"Return", "[", 
               RowBox[{"FunctionExpand", "[", 
                RowBox[{"FindSequenceFunction", "[", 
                 RowBox[{"L", ",", "n"}], "]"}], "]"}], "]"}]}]}], "]"}]}], 
          ";", 
          RowBox[{
           RowBox[{"SolveRR", "[", 
            RowBox[{
            "m_", ",", "Coeficient_List", ",", "ConditionInitial_List", ",", 
             "n_"}], "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"L", "=", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"i", "=", "0"}], ",", 
                RowBox[{"i", "\[LessEqual]", "m"}], ",", 
                RowBox[{
                 RowBox[{"L", "=", 
                  RowBox[{"Append", "[", 
                   RowBox[{"L", ",", 
                    RowBox[{"ElementoSucesionH", "[", 
                    RowBox[{"Coeficient", ",", "ConditionInitial", ",", "i"}],
                     "]"}]}], "]"}]}], ";", 
                 RowBox[{"i", "++"}]}]}], "]"}], ";", 
              RowBox[{"Return", "[", 
               RowBox[{"FunctionExpand", "[", 
                RowBox[{"FindSequenceFunction", "[", 
                 RowBox[{"L", ",", "n"}], "]"}], "]"}], "]"}]}]}], "]"}]}], 
          ";", 
          RowBox[{"j", "=", "1"}], ";", 
          RowBox[{
           RowBox[{"f", "[", "n_", "]"}], ":=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"SolveR", "[", 
             RowBox[{"j", ",", "Co", ",", "Con", ",", "n"}], "]"}]}]}], ";", 
          RowBox[{"While", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NumericQ", "[", 
              RowBox[{"f", "[", "1", "]"}], "]"}], "\[Equal]", "False"}], ",", 
            RowBox[{
             RowBox[{"j", "++"}], ";", 
             RowBox[{
              RowBox[{"f", "[", "n_", "]"}], ":=", 
              RowBox[{"Evaluate", "@", 
               RowBox[{"SolveR", "[", 
                RowBox[{"j", ",", "Co", ",", "Con", ",", "n"}], "]"}]}]}], 
             ";", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"j", ">", "1000"}], ",", " ", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<Las ejecuciones superaron 1000 pruebas\>\"", "]"}], ";", 
                RowBox[{"Break", "[", "]"}], ";", 
                RowBox[{"j", "=", "0"}]}]}], "]"}]}]}], "]"}], ";", 
          RowBox[{
           RowBox[{"f", "[", "n_", "]"}], ":=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"SolveRR", "[", 
             RowBox[{"j", ",", "Co", ",", "Con", ",", "n"}], "]"}]}]}], ";", 
          " ", 
          RowBox[{"FullSimplify", "[", 
           RowBox[{"f", "[", "n", "]"}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"ResolRRNH", "[", 
        RowBox[{"Co_List", ",", "Con_List", ",", "Func_List"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ElementoSucesionNH", ",", "SolveR", ",", "SolveRR"}], 
          "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"ElementoSucesionNH", "[", 
            RowBox[{
            "Coefi_List", ",", "ConditInitial_List", ",", "F_List", ",", 
             "w_"}], "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"nc", "=", 
                RowBox[{
                 RowBox[{"Dimensions", "[", "Coefi", "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], ",", "ElementoSucesionH", 
               ",", "Sumatoria"}], "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"ElementoSucesionH", "[", 
                RowBox[{
                "Coeficient_List", ",", "ConditionInitial_List", ",", "m_"}], 
                "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"CD", "=", 
                    RowBox[{"Reverse", "[", "ConditionInitial", "]"}]}], ",", 
                   RowBox[{"h", "=", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "ConditionInitial", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                   "Matriz"}], "}"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Matriz", "[", 
                    RowBox[{"Coeficientes_List", ",", "nn_"}], "]"}], ":=", 
                   RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Identidad", "=", 
                    RowBox[{"IdentityMatrix", "[", 
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
                    RowBox[{"A", "=", 
                    RowBox[{"{", "Coeficientes", "}"}]}], ",", "i", ",", 
                    "CF"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"i", "=", "1"}], ",", 
                    RowBox[{"i", "\[LessEqual]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"A", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"Identidad", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                    RowBox[{"Return", "[", 
                    RowBox[{"CF", "[", 
                    RowBox[{"A", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"A", "[", "n_", "]"}], ":=", 
                   RowBox[{"Matriz", "[", 
                    RowBox[{"Coeficient", ",", "n"}], "]"}]}], ";", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"m", ">", "h"}], ",", 
                    RowBox[{
                    RowBox[{"Elemento", "=", 
                    RowBox[{
                    RowBox[{"A", "[", "0", "]"}], ".", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{"{", "CD", "}"}], "]"}]}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"i", "=", "1"}], ",", 
                    RowBox[{"i", "\[LessEqual]", 
                    RowBox[{"m", "-", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"Elemento", "=", 
                    RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "i", "]"}], ",", "Elemento"}], "]"}]}], 
                    ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                    RowBox[{"Return", "[", 
                    RowBox[{"Elemento", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"h", "+", "1"}], ",", "1"}], "]"}], "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", 
                    RowBox[{"ConditionInitial", "[", 
                    RowBox[{"[", 
                    RowBox[{"m", "+", "1"}], "]"}], "]"}], "]"}]}], "]"}]}]}],
                 "]"}]}], ";", 
              RowBox[{
               RowBox[{"Sumatoria", "[", 
                RowBox[{"Coeficient_List", ",", "Funct_List", ",", "ww_"}], 
                "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Matriz", ",", "MatrizB", ",", 
                   RowBox[{"t", "=", 
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficient", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", "Productoria", ",",
                    "s"}], "}"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Matriz", "[", 
                    RowBox[{"Coeficientes_List", ",", "nn_"}], "]"}], ":=", 
                   RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Identidad", "=", 
                    RowBox[{"IdentityMatrix", "[", 
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
                    RowBox[{"A", "=", 
                    RowBox[{"{", "Coeficientes", "}"}]}], ",", "i", ",", 
                    "CF"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"i", "=", "1"}], ",", 
                    RowBox[{"i", "\[LessEqual]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"A", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"Identidad", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                    RowBox[{"Return", "[", 
                    RowBox[{"CF", "[", 
                    RowBox[{"A", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"A", "[", "n_", "]"}], ":=", 
                   RowBox[{"Matriz", "[", 
                    RowBox[{"Coeficient", ",", "n"}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"MatrizB", "[", 
                    RowBox[{"Funcion_List", ",", "filas_", ",", "nn_"}], 
                    "]"}], ":=", 
                   RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"MB", "=", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"0", ",", 
                    RowBox[{"{", 
                    RowBox[{"filas", ",", "1"}], "}"}]}], "]"}]}], ",", 
                    "CF"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MB", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
                    RowBox[{"Funcion", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                    RowBox[{"Return", "[", 
                    RowBox[{"CF", "[", 
                    RowBox[{"MB", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"B", "[", "n_", "]"}], ":=", 
                   RowBox[{"MatrizB", "[", 
                    RowBox[{"Funct", ",", "t", ",", "n"}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"Productoria", "[", 
                    RowBox[{"ini_", ",", "final_"}], "]"}], ":=", 
                   RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "i", "}"}], ",", 
                    RowBox[{
                    RowBox[{"p", "=", 
                    RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "ini", "]"}], ",", 
                    RowBox[{"B", "[", 
                    RowBox[{"ini", "-", "1"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"i", "=", 
                    RowBox[{"ini", "+", "1"}]}], ",", 
                    RowBox[{"i", "\[LessEqual]", "final"}], ",", 
                    RowBox[{
                    RowBox[{"p", "=", 
                    RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "i", "]"}], ",", "p"}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                    RowBox[{"Return", "[", "p", "]"}]}]}], "]"}]}], ";", 
                  RowBox[{"s", "=", 
                   RowBox[{"Sum", "[", 
                    RowBox[{
                    RowBox[{"Productoria", "[", 
                    RowBox[{"k", ",", 
                    RowBox[{"ww", "-", "1"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"k", ",", "1", ",", 
                    RowBox[{"ww", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
                  RowBox[{"Return", "[", 
                   RowBox[{"s", "[", 
                    RowBox[{"[", 
                    RowBox[{"t", ",", "1"}], "]"}], "]"}], "]"}]}]}], "]"}]}],
               ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"w", "\[LessEqual]", 
                 RowBox[{"nc", "-", "1"}]}], ",", 
                RowBox[{"ElementoSucesionH", "[", 
                 RowBox[{"Coefi", ",", "ConditInitial", ",", "w"}], "]"}], 
                ",", 
                RowBox[{"Return", "[", 
                 RowBox[{
                  RowBox[{"ElementoSucesionH", "[", 
                   RowBox[{"Coefi", ",", "ConditInitial", ",", "w"}], "]"}], 
                  "+", 
                  RowBox[{"Sumatoria", "[", 
                   RowBox[{"Coefi", ",", "F", ",", "w"}], "]"}]}], "]"}]}], 
               "]"}]}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"SolveR", "[", 
            RowBox[{
            "mm_", ",", "Coeficien_List", ",", "ConditionInitia_List", ",", 
             "Fun_List", ",", "n_"}], "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"L", "=", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"i", "=", "0"}], ",", 
                RowBox[{"i", "\[LessEqual]", "mm"}], ",", 
                RowBox[{
                 RowBox[{"L", "=", 
                  RowBox[{"Append", "[", 
                   RowBox[{"L", ",", 
                    RowBox[{"ElementoSucesionNH", "[", 
                    RowBox[{
                    "Coeficien", ",", "ConditionInitia", ",", "Fun", ",", 
                    "i"}], "]"}]}], "]"}]}], ";", 
                 RowBox[{"i", "++"}]}]}], "]"}], ";", 
              RowBox[{"Return", "[", 
               RowBox[{"FunctionExpand", "[", 
                RowBox[{"FindSequenceFunction", "[", 
                 RowBox[{"L", ",", "n"}], "]"}], "]"}], "]"}]}]}], "]"}]}], 
          ";", 
          RowBox[{
           RowBox[{"SolveRR", "[", 
            RowBox[{
            "m_", ",", "Coeficient_List", ",", "ConditionInitial_List", ",", 
             "Fun_List", ",", "n_"}], "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"L", "=", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"i", "=", "0"}], ",", 
                RowBox[{"i", "\[LessEqual]", "m"}], ",", 
                RowBox[{
                 RowBox[{"L", "=", 
                  RowBox[{"Append", "[", 
                   RowBox[{"L", ",", 
                    RowBox[{"ElementoSucesionNH", "[", 
                    RowBox[{
                    "Coeficient", ",", "ConditionInitial", ",", "Fun", ",", 
                    "i"}], "]"}]}], "]"}]}], ";", 
                 RowBox[{"i", "++"}]}]}], "]"}], ";", 
              RowBox[{"Return", "[", 
               RowBox[{"FunctionExpand", "[", 
                RowBox[{"FindSequenceFunction", "[", 
                 RowBox[{"L", ",", "n"}], "]"}], "]"}], "]"}]}]}], "]"}]}], 
          ";", 
          RowBox[{"j", "=", "1"}], ";", 
          RowBox[{
           RowBox[{"f", "[", "n_", "]"}], ":=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"SolveR", "[", 
             RowBox[{"j", ",", "Co", ",", "Con", ",", "Func", ",", "n"}], 
             "]"}]}]}], ";", 
          RowBox[{"While", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NumericQ", "[", 
              RowBox[{"f", "[", "1", "]"}], "]"}], "\[Equal]", "False"}], ",", 
            RowBox[{
             RowBox[{"j", "++"}], ";", 
             RowBox[{
              RowBox[{"f", "[", "n_", "]"}], ":=", 
              RowBox[{"Evaluate", "@", 
               RowBox[{"SolveR", "[", 
                RowBox[{"j", ",", "Co", ",", "Con", ",", "Func", ",", "n"}], 
                "]"}]}]}], ";", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"j", ">", "1000"}], ",", " ", 
               RowBox[{
                RowBox[{
                "Print", "[", 
                 "\"\<Las ejecuciones superaron 1000 pruebas\>\"", "]"}], ";", 
                RowBox[{"Break", "[", "]"}], ";", 
                RowBox[{"j", "=", "0"}]}]}], "]"}]}]}], "]"}], ";", 
          RowBox[{
           RowBox[{"f", "[", "n_", "]"}], ":=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"SolveRR", "[", 
             RowBox[{"j", ",", "Co", ",", "Con", ",", "Func", ",", "n"}], 
             "]"}]}]}], ";", " ", 
          RowBox[{"FullSimplify", "[", 
           RowBox[{"f", "[", "n", "]"}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"SolveRRHM", "[", 
        RowBox[{"mm_", ",", "Coeficien_List", ",", "ConditionInitia_List"}], 
        "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"L", "=", 
            RowBox[{"{", "}"}]}], ",", "ElementoSucesionH"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"ElementoSucesionH", "[", 
            RowBox[{
            "Coeficient_List", ",", "ConditionInitial_List", ",", "m_"}], 
            "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"CD", "=", 
                RowBox[{"Reverse", "[", "ConditionInitial", "]"}]}], ",", 
               RowBox[{"h", "=", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Dimensions", "[", "ConditionInitial", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
               "Matriz"}], "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Matriz", "[", 
                RowBox[{"Coeficientes_List", ",", "nn_"}], "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Identidad", "=", 
                    RowBox[{"IdentityMatrix", "[", 
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
                   RowBox[{"A", "=", 
                    RowBox[{"{", "Coeficientes", "}"}]}], ",", "i", ",", 
                   "CF"}], "}"}], ",", 
                 RowBox[{
                  RowBox[{"For", "[", 
                   RowBox[{
                    RowBox[{"i", "=", "1"}], ",", 
                    RowBox[{"i", "\[LessEqual]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"A", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"Identidad", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                  RowBox[{
                   RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                   RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                  RowBox[{"Return", "[", 
                   RowBox[{"CF", "[", 
                    RowBox[{"A", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
              RowBox[{
               RowBox[{"A", "[", "n_", "]"}], ":=", 
               RowBox[{"Matriz", "[", 
                RowBox[{"Coeficient", ",", "n"}], "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"m", ">", "h"}], ",", 
                RowBox[{
                 RowBox[{"Elemento", "=", 
                  RowBox[{
                   RowBox[{"A", "[", "0", "]"}], ".", 
                   RowBox[{"Transpose", "[", 
                    RowBox[{"{", "CD", "}"}], "]"}]}]}], ";", 
                 RowBox[{"For", "[", 
                  RowBox[{
                   RowBox[{"i", "=", "1"}], ",", 
                   RowBox[{"i", "\[LessEqual]", 
                    RowBox[{"m", "-", "1"}]}], ",", 
                   RowBox[{
                    RowBox[{"Elemento", "=", 
                    RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "i", "]"}], ",", "Elemento"}], "]"}]}], 
                    ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                 RowBox[{"Return", "[", 
                  RowBox[{"Elemento", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"h", "+", "1"}], ",", "1"}], "]"}], "]"}], 
                  "]"}]}], ",", 
                RowBox[{"Return", "[", 
                 RowBox[{"ConditionInitial", "[", 
                  RowBox[{"[", 
                   RowBox[{"m", "+", "1"}], "]"}], "]"}], "]"}]}], "]"}]}]}], 
            "]"}]}], ";", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "0"}], ",", 
            RowBox[{"i", "\[LessEqual]", "mm"}], ",", 
            RowBox[{
             RowBox[{"L", "=", 
              RowBox[{"Append", "[", 
               RowBox[{"L", ",", 
                RowBox[{"ElementoSucesionH", "[", 
                 RowBox[{"Coeficien", ",", "ConditionInitia", ",", "i"}], 
                 "]"}]}], "]"}]}], ";", 
             RowBox[{"i", "++"}]}]}], "]"}], ";", 
          RowBox[{"Return", "[", 
           RowBox[{"FullSimplify", "[", 
            RowBox[{"FunctionExpand", "[", 
             RowBox[{"FindSequenceFunction", "[", 
              RowBox[{"L", ",", "n"}], "]"}], "]"}], "]"}], "]"}]}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"SolveRRNHM", "[", 
        RowBox[{"mm_", ",", "Coef_List", ",", "ConIn_List", ",", "Fun_List"}],
         "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"L", "=", 
            RowBox[{"{", "}"}]}], ",", "ElementoSucesionNH"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"ElementoSucesionNH", "[", 
            RowBox[{
            "Coefi_List", ",", "ConditInitial_List", ",", "F_List", ",", 
             "w_"}], "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"nc", "=", 
                RowBox[{
                 RowBox[{"Dimensions", "[", "Coefi", "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], ",", "ElementoSucesionH", 
               ",", "Sumatoria"}], "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"ElementoSucesionH", "[", 
                RowBox[{
                "Coeficient_List", ",", "ConditionInitial_List", ",", "m_"}], 
                "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"CD", "=", 
                    RowBox[{"Reverse", "[", "ConditionInitial", "]"}]}], ",", 
                   RowBox[{"h", "=", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "ConditionInitial", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                   "Matriz"}], "}"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Matriz", "[", 
                    RowBox[{"Coeficientes_List", ",", "nn_"}], "]"}], ":=", 
                   RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Identidad", "=", 
                    RowBox[{"IdentityMatrix", "[", 
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
                    RowBox[{"A", "=", 
                    RowBox[{"{", "Coeficientes", "}"}]}], ",", "i", ",", 
                    "CF"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"i", "=", "1"}], ",", 
                    RowBox[{"i", "\[LessEqual]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"A", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"Identidad", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                    RowBox[{"Return", "[", 
                    RowBox[{"CF", "[", 
                    RowBox[{"A", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"A", "[", "n_", "]"}], ":=", 
                   RowBox[{"Matriz", "[", 
                    RowBox[{"Coeficient", ",", "n"}], "]"}]}], ";", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"m", ">", "h"}], ",", 
                    RowBox[{
                    RowBox[{"Elemento", "=", 
                    RowBox[{
                    RowBox[{"A", "[", "0", "]"}], ".", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{"{", "CD", "}"}], "]"}]}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"i", "=", "1"}], ",", 
                    RowBox[{"i", "\[LessEqual]", 
                    RowBox[{"m", "-", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"Elemento", "=", 
                    RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "i", "]"}], ",", "Elemento"}], "]"}]}], 
                    ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                    RowBox[{"Return", "[", 
                    RowBox[{"Elemento", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"h", "+", "1"}], ",", "1"}], "]"}], "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", 
                    RowBox[{"ConditionInitial", "[", 
                    RowBox[{"[", 
                    RowBox[{"m", "+", "1"}], "]"}], "]"}], "]"}]}], "]"}]}]}],
                 "]"}]}], ";", 
              RowBox[{
               RowBox[{"Sumatoria", "[", 
                RowBox[{"Coeficient_List", ",", "Funct_List", ",", "ww_"}], 
                "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Matriz", ",", "MatrizB", ",", 
                   RowBox[{"t", "=", 
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficient", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", "Productoria", ",",
                    "s"}], "}"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Matriz", "[", 
                    RowBox[{"Coeficientes_List", ",", "nn_"}], "]"}], ":=", 
                   RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Identidad", "=", 
                    RowBox[{"IdentityMatrix", "[", 
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
                    RowBox[{"A", "=", 
                    RowBox[{"{", "Coeficientes", "}"}]}], ",", "i", ",", 
                    "CF"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"i", "=", "1"}], ",", 
                    RowBox[{"i", "\[LessEqual]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "Coeficientes", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"A", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"Identidad", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                    RowBox[{"Return", "[", 
                    RowBox[{"CF", "[", 
                    RowBox[{"A", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"A", "[", "n_", "]"}], ":=", 
                   RowBox[{"Matriz", "[", 
                    RowBox[{"Coeficient", ",", "n"}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"MatrizB", "[", 
                    RowBox[{"Funcion_List", ",", "filas_", ",", "nn_"}], 
                    "]"}], ":=", 
                   RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"MB", "=", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"0", ",", 
                    RowBox[{"{", 
                    RowBox[{"filas", ",", "1"}], "}"}]}], "]"}]}], ",", 
                    "CF"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MB", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
                    RowBox[{"Funcion", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"CF", "[", 
                    RowBox[{"L_List", ",", "a_"}], "]"}], ":=", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"n", "=", "a"}], "}"}], ",", "L"}], "]"}]}], ";", 
                    RowBox[{"Return", "[", 
                    RowBox[{"CF", "[", 
                    RowBox[{"MB", ",", "nn"}], "]"}], "]"}]}]}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"B", "[", "n_", "]"}], ":=", 
                   RowBox[{"MatrizB", "[", 
                    RowBox[{"Funct", ",", "t", ",", "n"}], "]"}]}], ";", 
                  RowBox[{
                   RowBox[{"Productoria", "[", 
                    RowBox[{"ini_", ",", "final_"}], "]"}], ":=", 
                   RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "i", "}"}], ",", 
                    RowBox[{
                    RowBox[{"p", "=", 
                    RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "ini", "]"}], ",", 
                    RowBox[{"B", "[", 
                    RowBox[{"ini", "-", "1"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"i", "=", 
                    RowBox[{"ini", "+", "1"}]}], ",", 
                    RowBox[{"i", "\[LessEqual]", "final"}], ",", 
                    RowBox[{
                    RowBox[{"p", "=", 
                    RowBox[{"Dot", "[", 
                    RowBox[{
                    RowBox[{"A", "[", "i", "]"}], ",", "p"}], "]"}]}], ";", 
                    RowBox[{"i", "++"}]}]}], "]"}], ";", 
                    RowBox[{"Return", "[", "p", "]"}]}]}], "]"}]}], ";", 
                  RowBox[{"s", "=", 
                   RowBox[{"Sum", "[", 
                    RowBox[{
                    RowBox[{"Productoria", "[", 
                    RowBox[{"k", ",", 
                    RowBox[{"ww", "-", "1"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"k", ",", "1", ",", 
                    RowBox[{"ww", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
                  RowBox[{"Return", "[", 
                   RowBox[{"s", "[", 
                    RowBox[{"[", 
                    RowBox[{"t", ",", "1"}], "]"}], "]"}], "]"}]}]}], "]"}]}],
               ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"w", "\[LessEqual]", 
                 RowBox[{"nc", "-", "1"}]}], ",", 
                RowBox[{"ElementoSucesionH", "[", 
                 RowBox[{"Coefi", ",", "ConditInitial", ",", "w"}], "]"}], 
                ",", 
                RowBox[{"Return", "[", 
                 RowBox[{
                  RowBox[{"ElementoSucesionH", "[", 
                   RowBox[{"Coefi", ",", "ConditInitial", ",", "w"}], "]"}], 
                  "+", 
                  RowBox[{"Sumatoria", "[", 
                   RowBox[{"Coefi", ",", "F", ",", "w"}], "]"}]}], "]"}]}], 
               "]"}]}]}], "]"}]}], ";", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "0"}], ",", 
            RowBox[{"i", "\[LessEqual]", "mm"}], ",", 
            RowBox[{
             RowBox[{"L", "=", 
              RowBox[{"Append", "[", 
               RowBox[{"L", ",", 
                RowBox[{"ElementoSucesionNH", "[", 
                 RowBox[{"Coef", ",", "ConIn", ",", "Fun", ",", "i"}], 
                 "]"}]}], "]"}]}], ";", 
             RowBox[{"i", "++"}]}]}], "]"}], ";", 
          RowBox[{"Return", "[", 
           RowBox[{"FullSimplify", "[", 
            RowBox[{"FunctionExpand", "[", 
             RowBox[{"FindSequenceFunction", "[", 
              RowBox[{"L", ",", "n"}], "]"}], "]"}], "]"}], "]"}]}]}], 
        "]"}]}]}], ")"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Spacer", "[", 
             RowBox[{"{", 
              RowBox[{"400", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Autor: Enrique V\[IAcute]lchez Quesada\>\"", ",", "Bold", 
                ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}], 
              "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica\>\"", ",", "Bold", ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.12", ",", "0", ",", "0.5"}], "]"}]}], "]"}], 
              "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Relaciones de recurrencia\>\"", ",", " ", "Bold", ",", " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6530067680607367`*^9, 3.653006873171339*^9}, {
   3.6530069110311594`*^9, 3.6530069585004296`*^9}, {3.653007357277887*^9, 
   3.6530073772937155`*^9}, {3.653007419533888*^9, 3.6530075273615646`*^9}, {
   3.6530076013483024`*^9, 3.6530077978615875`*^9}, {3.6530078727845416`*^9, 
   3.653008070139493*^9}, {3.653008104610523*^9, 3.65300812124953*^9}, {
   3.6530081725349116`*^9, 3.653008229351909*^9}, {3.653008292375101*^9, 
   3.6530084945099783`*^9}, {3.653008610893338*^9, 3.6530086233673744`*^9}, {
   3.6530086641129203`*^9, 3.6530087040273266`*^9}, {3.6530087600383654`*^9, 
   3.653008822747102*^9}, {3.6530090180455556`*^9, 3.6530091622652655`*^9}, {
   3.6530092313475213`*^9, 3.653009231831929*^9}, {3.6530092806803436`*^9, 
   3.6530093155042787`*^9}, {3.653009348794943*^9, 3.653009414098275*^9}, {
   3.6530101218714013`*^9, 3.6530101922569327`*^9}, {3.6530102675265317`*^9, 
   3.6530102797922955`*^9}, {3.65301034256022*^9, 3.6530103615578794`*^9}, {
   3.653010507681945*^9, 3.6530105100726147`*^9}, {3.6530105646043596`*^9, 
   3.6530105840108595`*^9}, {3.6530106553701706`*^9, 3.653010682600992*^9}, {
   3.653010745912591*^9, 3.6530107476470137`*^9}, {3.6530108357505035`*^9, 
   3.653010873302717*^9}, {3.653010987242549*^9, 3.6530111892463665`*^9}, {
   3.6530132225774117`*^9, 3.653013255956993*^9}, {3.6530133185424376`*^9, 
   3.653013322073714*^9}, {3.6530199889607162`*^9, 3.6530200070185666`*^9}, {
   3.6530201997824287`*^9, 3.653020205104549*^9}, {3.65302025668925*^9, 
   3.6530203466152163`*^9}, 3.65302041786905*^9, {3.6530204799970827`*^9, 
   3.6530205004954696`*^9}, {3.653020539802915*^9, 3.6530206206100025`*^9}, {
   3.653020697201188*^9, 3.6530207038874607`*^9}, {3.653020790370464*^9, 
   3.653020794854063*^9}, {3.6530208287548075`*^9, 3.6530208357915573`*^9}, {
   3.653038825901623*^9, 3.6530388277974143`*^9}, {3.653038859415079*^9, 
   3.653038934238783*^9}, {3.653050223277091*^9, 3.653050409006753*^9}, {
   3.6530504470663137`*^9, 3.6530504563476815`*^9}, {3.653050509802569*^9, 
   3.65305051066195*^9}, 3.6530505424040527`*^9, {3.653050589156724*^9, 
   3.6530506195913296`*^9}, {3.653050701500808*^9, 3.653050797907935*^9}, {
   3.6530509121982746`*^9, 3.6530509147761164`*^9}, {3.65305095010341*^9, 
   3.6530509535253243`*^9}, {3.653051094236454*^9, 3.653051161618484*^9}, {
   3.6530512022627163`*^9, 3.65305124262151*^9}, {3.6530513247485127`*^9, 
   3.653051437239303*^9}, {3.653051484128507*^9, 3.6530515916952*^9}, {
   3.653051676879485*^9, 3.653051744152123*^9}, {3.653051800841516*^9, 
   3.653051807216589*^9}, {3.653051858879728*^9, 3.653051960136917*^9}, {
   3.653052718803815*^9, 3.653052721991378*^9}, {3.6530527638435946`*^9, 
   3.6530528288816385`*^9}, {3.6530528760931554`*^9, 3.653052888499549*^9}, {
   3.6530534722675514`*^9, 3.6530535111086674`*^9}, {3.6531128098226285`*^9, 
   3.653112837127239*^9}, {3.6531328158575215`*^9, 3.653132824996996*^9}, {
   3.653133160212723*^9, 3.6531331612924585`*^9}, {3.6531332044984827`*^9, 
   3.653133252224022*^9}, {3.6531336732035894`*^9, 3.6531337145084696`*^9}, {
   3.6531337587911234`*^9, 3.6531337957439404`*^9}, {3.6531338472204227`*^9, 
   3.6531339031207457`*^9}, {3.6531339366326485`*^9, 3.653133986331341*^9}, {
   3.6531340268730593`*^9, 3.653134035814417*^9}, {3.6531340691385117`*^9, 
   3.653134070132216*^9}, {3.653134152899105*^9, 3.6531342153320684`*^9}, {
   3.6531344284861317`*^9, 3.653134430098245*^9}, {3.6531344641357846`*^9, 
   3.653134471805939*^9}, {3.653134832699628*^9, 3.6531348704184847`*^9}, {
   3.6531349248327456`*^9, 3.6531349300514145`*^9}, {3.6531350435348067`*^9, 
   3.653135044011175*^9}, {3.653135177250613*^9, 3.653135180842004*^9}, {
   3.653135235691881*^9, 3.653135236855686*^9}, {3.6531353154463854`*^9, 
   3.6531353489383383`*^9}, {3.653135732804883*^9, 3.6531358808586864`*^9}, {
   3.653135932084834*^9, 3.6531359502372885`*^9}, {3.653136014963888*^9, 
   3.653136015412397*^9}, {3.6531360789998274`*^9, 3.6531360802577085`*^9}, {
   3.6531361806679487`*^9, 3.6531361816916842`*^9}, {3.6531365441458535`*^9, 
   3.653136545119524*^9}, {3.6531366726289716`*^9, 3.6531367020630007`*^9}, {
   3.6531370330198674`*^9, 3.653137084832715*^9}, {3.6531371477578526`*^9, 
   3.6531371814334555`*^9}, {3.6531372771029396`*^9, 
   3.6531372781837053`*^9}, {3.653137331348402*^9, 3.6531373946987886`*^9}, {
   3.65313745395331*^9, 3.653137455042102*^9}, 3.653137518910732*^9, {
   3.6531376349759245`*^9, 3.6531376625139065`*^9}, {3.6531377650594783`*^9, 
   3.6531377687170906`*^9}, {3.6686400305962515`*^9, 
   3.6686400385162663`*^9}, {3.801155786861391*^9, 3.801155797776368*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"8b027606-23c0-42cc-bc5c-30b83d274691"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`ccons$$ = {1, 
    1}, $CellContext`coefpoli$$ = {1, 1}, $CellContext`condini$$ = {1, 
    1}, $CellContext`ev$$ = 10, $CellContext`grafica$$ = 
    True, $CellContext`nprof$$ = 8, $CellContext`solm$$ = 
    5, $CellContext`tipo$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[$CellContext`tipo$$], 0, 
       "Tipo de relaci\[OAcute]n de recurrencia"}, {
      0 -> "Homog\[EAcute]nea", 1 -> "No homog\[EAcute]nea"}}, {{
       Hold[$CellContext`ccons$$], {1, 1}, "Coeficientes constantes"}}, {{
       Hold[$CellContext`condini$$], {1, 1}, "Condiciones iniciales"}}, {{
       Hold[$CellContext`coefpoli$$], {1, 1}, 
       "Coeficientes del polinomio (orden decreciente)"}}, {{
       Hold[$CellContext`ev$$], 10, 
       "Cantidad de elementos a evaluar en la sucesi\[OAcute]n"}}, {
      Hold[
       Button["Evaluar", $CellContext`vl1 = 1]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Button[
       "No evaluar", $CellContext`vl1 = 0; $CellContext`grafica$$ = False]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`grafica$$], False, "Mostrar gr\[AAcute]fica"}, {
      True, False}}, {
      Hold[
       Style[
       "Velocidad de convergencia: {recursividad, m\[EAcute]todo matricial, \
iguales}", Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`nprof$$], 5, "N\[UAcute]mero de pruebas"}, 5, 50, 
      1}, {
      Hold[
       Button["Ejecutar", $CellContext`vl2 = 1]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Button["Detener", $CellContext`vl2 = 0]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Style["Soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia", Bold]],
       Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Button["Encontrar", $CellContext`vl3 = 1]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Button["Detener", $CellContext`vl3 = 0]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Style[
       "Soluci\[OAcute]n manual de la relaci\[OAcute]n de recurrencia", 
        Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`solm$$], 5, "Valor de la soluci\[OAcute]n manual"}}, {
      Hold[
       Button["Encontrar", $CellContext`vl4 = 1]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Button["Detener", $CellContext`vl4 = 0]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    340., {142., 151.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`ccons$$ = {1, 
         1}, $CellContext`coefpoli$$ = {1, 1}, $CellContext`condini$$ = {1, 
         1}, $CellContext`ev$$ = 10, $CellContext`grafica$$ = 
        False, $CellContext`nprof$$ = 5, $CellContext`solm$$ = 
        5, $CellContext`tipo$$ = 0}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[
        And[
         VectorQ[$CellContext`ccons$$], 
         VectorQ[$CellContext`condini$$], 
         VectorQ[$CellContext`coefpoli$$], 
         IntegerQ[$CellContext`ev$$]], 
        If[
         And[
          NumberQ[
           Total[$CellContext`ccons$$]], 
          NumberQ[
           Total[$CellContext`condini$$]], 
          NumberQ[
           Total[$CellContext`coefpoli$$]]], 
         If[
          And[
          Length[$CellContext`ccons$$] == Length[$CellContext`condini$$], 
           Length[$CellContext`ccons$$] >= 2], 
          Column[{
            If[
             And[$CellContext`vl1 == 1, $CellContext`tipo$$ == 0], 
             Table[
              $CellContext`ElementoSucesionH[$CellContext`ccons$$, \
$CellContext`condini$$, $CellContext`valorsr], {$CellContext`valorsr, 
               0, $CellContext`ev$$ - 1}], 
             If[
              And[$CellContext`vl1 == 1, $CellContext`tipo$$ == 1], 
              Table[
               $CellContext`ElementoSucesionNH[$CellContext`ccons$$, \
$CellContext`condini$$, {
                 Dot[$CellContext`coefpoli$$, 
                  $CellContext`Polinomio[$CellContext`coefpoli$$]]}, \
$CellContext`valorsr], {$CellContext`valorsr, 0, $CellContext`ev$$ - 1}]]], 
            If[$CellContext`grafica$$, $CellContext`vl1 = 1; DiscretePlot[
               $CellContext`CrearRR[$CellContext`ccons$$, \
$CellContext`condini$$, $CellContext`coefpoli$$, $CellContext`valorsr], \
{$CellContext`valorsr, 0, $CellContext`ev$$ - 1}]], 
            If[$CellContext`vl2 == 1, 
             If[$CellContext`tipo$$ == 0, 
              $CellContext`PruebaH[$CellContext`nprof$$ - 
               1, $CellContext`ccons$$, $CellContext`condini$$], 
              $CellContext`PruebaNH[$CellContext`nprof$$ - 
               1, $CellContext`ccons$$, $CellContext`condini$$, {
                Dot[$CellContext`coefpoli$$, 
                 $CellContext`Polinomio[$CellContext`coefpoli$$]]}, \
$CellContext`coefpoli$$]]], 
            If[$CellContext`vl3 == 1, 
             If[$CellContext`tipo$$ == 0, 
              $CellContext`ResolRRH[$CellContext`ccons$$, \
$CellContext`condini$$], 
              $CellContext`ResolRRNH[$CellContext`ccons$$, \
$CellContext`condini$$, {
                Dot[$CellContext`coefpoli$$, 
                 $CellContext`Polinomio[$CellContext`coefpoli$$]]}]]], 
            If[$CellContext`vl4 == 1, 
             If[$CellContext`tipo$$ == 0, 
              $CellContext`SolveRRHM[$CellContext`solm$$ - 
               1, $CellContext`ccons$$, $CellContext`condini$$], 
              $CellContext`SolveRRNHM[$CellContext`solm$$ - 
               1, $CellContext`ccons$$, $CellContext`condini$$, {
                Dot[$CellContext`coefpoli$$, 
                 $CellContext`Polinomio[$CellContext`coefpoli$$]]}]]]}, 
           Center], "Error en las longitudes de los vectores"], 
         "Error, valor nulo en las componentes de los vectores"], \
$CellContext`ccons$$ = {1, 1}; $CellContext`condini$$ = {1, 
          1}; $CellContext`coefpoli$$ = {1, 1}; $CellContext`ev$$ = 1], 
      "Specifications" :> {{{$CellContext`tipo$$, 0, 
          "Tipo de relaci\[OAcute]n de recurrencia"}, {
         0 -> "Homog\[EAcute]nea", 1 -> "No homog\[EAcute]nea"}, ControlType -> 
         PopupMenu}, 
        Delimiter, {{$CellContext`ccons$$, {1, 1}, 
          "Coeficientes constantes"}}, {{$CellContext`condini$$, {1, 1}, 
          "Condiciones iniciales"}}, {{$CellContext`coefpoli$$, {1, 1}, 
          "Coeficientes del polinomio (orden decreciente)"}}, 
        Delimiter, {{$CellContext`ev$$, 10, 
          "Cantidad de elementos a evaluar en la sucesi\[OAcute]n"}}, 
        Button["Evaluar", $CellContext`vl1 = 1], 
        Button[
        "No evaluar", $CellContext`vl1 = 0; $CellContext`grafica$$ = 
          False], {{$CellContext`grafica$$, False, 
          "Mostrar gr\[AAcute]fica"}, {True, False}}, Delimiter, 
        Style[
        "Velocidad de convergencia: {recursividad, m\[EAcute]todo matricial, \
iguales}", Bold], {{$CellContext`nprof$$, 5, "N\[UAcute]mero de pruebas"}, 5, 
         50, 1}, 
        Button["Ejecutar", $CellContext`vl2 = 1], 
        Button["Detener", $CellContext`vl2 = 0], Delimiter, 
        Style["Soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia", Bold], 
        Button["Encontrar", $CellContext`vl3 = 1], 
        Button["Detener", $CellContext`vl3 = 0], Delimiter, 
        Style[
        "Soluci\[OAcute]n manual de la relaci\[OAcute]n de recurrencia", 
         Bold], {{$CellContext`solm$$, 5, 
          "Valor de la soluci\[OAcute]n manual"}}, 
        Button["Encontrar", $CellContext`vl4 = 1], 
        Button["Detener", $CellContext`vl4 = 0]}, 
      "Options" :> {Alignment -> Center, FrameLabel -> {{None, None}, {
           Column[{
             Spacer[{400, 2}], 
             Row[{
               Style["Autor: Enrique V\[IAcute]lchez Quesada", Bold, 10, 
                RGBColor[0, 0.333333, 0]]}], 
             Row[{
               Style[
               "Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica", Bold, 10, 
                RGBColor[0.12, 0, 0.5]]}]}, Center], 
           Style["Relaciones de recurrencia", Bold, 
            RGBColor[0, 0.333333, 0]]}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{1110., {492., 501.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`vl1 = 0; $CellContext`vl2 = 
       0; $CellContext`vl3 = 0; $CellContext`vl4 = 0; $CellContext`Polinomio[
         Pattern[$CellContext`h, 
          Blank[List]]] := 
       Module[{$CellContext`longitud = 
          Length[$CellContext`h]}, $CellContext`poly = {1}; 
         For[$CellContext`i = 
           1, $CellContext`i <= $CellContext`longitud - 1, $CellContext`poly = 
            Prepend[$CellContext`poly, $CellContext`n^$CellContext`i]; 
           Increment[$CellContext`i]]; 
         Return[$CellContext`poly]]; $CellContext`CrearRR[
         Pattern[$CellContext`coefcons, 
          Blank[List]], 
         Pattern[$CellContext`condiniini, 
          Blank[List]], 
         Pattern[$CellContext`ccoefpoli, 
          Blank[List]], 
         Pattern[$CellContext`vov, 
          Blank[]]] := 
       Module[{$CellContext`a, $CellContext`vectrr = {}, $CellContext`OPoli}, \
$CellContext`OPoli[
            Pattern[$CellContext`olh, 
             Blank[List]]] := 
          Module[{$CellContext`longitud = 
             Length[$CellContext`olh]}, $CellContext`opoly = {1}; 
            For[$CellContext`i = 
              1, $CellContext`i <= $CellContext`longitud - 
               1, $CellContext`opoly = 
               Prepend[$CellContext`opoly, ($CellContext`k - 
                  Length[$CellContext`coefcons])^$CellContext`i]; 
              Increment[$CellContext`i]]; Return[$CellContext`opoly]]; 
         For[$CellContext`i = 1, $CellContext`i <= 
           Length[$CellContext`coefcons], $CellContext`vectrr = 
            Prepend[$CellContext`vectrr, 
              $CellContext`a[$CellContext`k - $CellContext`i]]; 
           Increment[$CellContext`i]]; $CellContext`a[
            Pattern[$CellContext`p, 
             Blank[]]] := 
          Block[{$CellContext`k = $CellContext`p}, 
            Dot[$CellContext`vectrr, $CellContext`coefcons] + 
            Dot[$CellContext`ccoefpoli, 
              $CellContext`OPoli[$CellContext`ccoefpoli]]]; 
         For[$CellContext`i = 1, $CellContext`i <= 
           Length[$CellContext`condiniini], $CellContext`a[$CellContext`i - 
              1] = Part[$CellContext`condiniini, $CellContext`i]; 
           Increment[$CellContext`i]]; $CellContext`a[$CellContext`vov]]; \
$CellContext`ElementoSucesionH[
         Pattern[$CellContext`Coeficient, 
          Blank[List]], 
         Pattern[$CellContext`ConditionInitial, 
          Blank[List]], 
         Pattern[$CellContext`m, 
          Blank[]]] := 
       Module[{$CellContext`CD = 
          Reverse[$CellContext`ConditionInitial], $CellContext`h = Part[
             Dimensions[$CellContext`ConditionInitial], 1] - 
           1, $CellContext`Matriz}, $CellContext`Matriz[
            Pattern[$CellContext`Coeficientes, 
             Blank[List]], 
            Pattern[$CellContext`nn, 
             Blank[]]] := Module[{$CellContext`Identidad = IdentityMatrix[
               Part[
                Dimensions[$CellContext`Coeficientes], 
                1]], $CellContext`A = {$CellContext`Coeficientes}, \
$CellContext`i, $CellContext`CF}, 
            For[$CellContext`i = 1, $CellContext`i <= Part[
                 Dimensions[$CellContext`Coeficientes], 1] - 
               1, $CellContext`A = Append[$CellContext`A, 
                 Part[$CellContext`Identidad, $CellContext`i]]; 
              Increment[$CellContext`i]]; $CellContext`CF[
               Pattern[$CellContext`L, 
                Blank[List]], 
               Pattern[$CellContext`a, 
                Blank[]]] := 
             Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; Return[
              $CellContext`CF[$CellContext`A, $CellContext`nn]]]; \
$CellContext`A[
            Pattern[$CellContext`n, 
             
             Blank[]]] := $CellContext`Matriz[$CellContext`Coeficient, \
$CellContext`n]; 
         If[$CellContext`m > $CellContext`h, $CellContext`Elemento = Dot[
              $CellContext`A[0], 
              Transpose[{$CellContext`CD}]]; 
           For[$CellContext`i = 
             1, $CellContext`i <= $CellContext`m - 1, $CellContext`Elemento = 
              Dot[
                $CellContext`A[$CellContext`i], $CellContext`Elemento]; 
             Increment[$CellContext`i]]; Return[
             Part[$CellContext`Elemento, $CellContext`h + 1, 1]], 
           Return[
            
            Part[$CellContext`ConditionInitial, $CellContext`m + 
             1]]]]; $CellContext`ElementoSucesionNH[
         Pattern[$CellContext`Coefi, 
          Blank[List]], 
         Pattern[$CellContext`ConditInitial, 
          Blank[List]], 
         Pattern[$CellContext`F, 
          Blank[List]], 
         Pattern[$CellContext`w, 
          Blank[]]] := Module[{$CellContext`nc = Part[
            Dimensions[$CellContext`Coefi], 
            1], $CellContext`ElementoSucesionH, $CellContext`Sumatoria}, \
$CellContext`ElementoSucesionH[
            Pattern[$CellContext`Coeficient, 
             Blank[List]], 
            Pattern[$CellContext`ConditionInitial, 
             Blank[List]], 
            Pattern[$CellContext`m, 
             Blank[]]] := 
          Module[{$CellContext`CD = 
             Reverse[$CellContext`ConditionInitial], $CellContext`h = Part[
                Dimensions[$CellContext`ConditionInitial], 1] - 
              1, $CellContext`Matriz}, $CellContext`Matriz[
               Pattern[$CellContext`Coeficientes, 
                Blank[List]], 
               Pattern[$CellContext`nn, 
                Blank[]]] := Module[{$CellContext`Identidad = IdentityMatrix[
                  Part[
                   Dimensions[$CellContext`Coeficientes], 
                   1]], $CellContext`A = {$CellContext`Coeficientes}, \
$CellContext`i, $CellContext`CF}, 
               For[$CellContext`i = 1, $CellContext`i <= Part[
                    Dimensions[$CellContext`Coeficientes], 1] - 
                  1, $CellContext`A = Append[$CellContext`A, 
                    Part[$CellContext`Identidad, $CellContext`i]]; 
                 Increment[$CellContext`i]]; $CellContext`CF[
                  Pattern[$CellContext`L, 
                   Blank[List]], 
                  Pattern[$CellContext`a, 
                   Blank[]]] := 
                Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
               Return[
                 $CellContext`CF[$CellContext`A, $CellContext`nn]]]; \
$CellContext`A[
               Pattern[$CellContext`n, 
                
                Blank[]]] := $CellContext`Matriz[$CellContext`Coeficient, \
$CellContext`n]; 
            If[$CellContext`m > $CellContext`h, $CellContext`Elemento = Dot[
                 $CellContext`A[0], 
                 Transpose[{$CellContext`CD}]]; 
              For[$CellContext`i = 
                1, $CellContext`i <= $CellContext`m - 
                 1, $CellContext`Elemento = Dot[
                   $CellContext`A[$CellContext`i], $CellContext`Elemento]; 
                Increment[$CellContext`i]]; Return[
                Part[$CellContext`Elemento, $CellContext`h + 1, 1]], 
              Return[
               
               Part[$CellContext`ConditionInitial, $CellContext`m + 
                1]]]]; $CellContext`Sumatoria[
            Pattern[$CellContext`Coeficient, 
             Blank[List]], 
            Pattern[$CellContext`Funct, 
             Blank[List]], 
            Pattern[$CellContext`ww, 
             Blank[]]] := 
          Module[{$CellContext`Matriz, $CellContext`MatrizB, $CellContext`t = 
             Part[
               Dimensions[$CellContext`Coeficient], 
               1], $CellContext`Productoria, $CellContext`s}, \
$CellContext`Matriz[
               Pattern[$CellContext`Coeficientes, 
                Blank[List]], 
               Pattern[$CellContext`nn, 
                Blank[]]] := Module[{$CellContext`Identidad = IdentityMatrix[
                  Part[
                   Dimensions[$CellContext`Coeficientes], 
                   1]], $CellContext`A = {$CellContext`Coeficientes}, \
$CellContext`i, $CellContext`CF}, 
               For[$CellContext`i = 1, $CellContext`i <= Part[
                    Dimensions[$CellContext`Coeficientes], 1] - 
                  1, $CellContext`A = Append[$CellContext`A, 
                    Part[$CellContext`Identidad, $CellContext`i]]; 
                 Increment[$CellContext`i]]; $CellContext`CF[
                  Pattern[$CellContext`L, 
                   Blank[List]], 
                  Pattern[$CellContext`a, 
                   Blank[]]] := 
                Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
               Return[
                 $CellContext`CF[$CellContext`A, $CellContext`nn]]]; \
$CellContext`A[
               Pattern[$CellContext`n, 
                
                Blank[]]] := $CellContext`Matriz[$CellContext`Coeficient, \
$CellContext`n]; $CellContext`MatrizB[
               Pattern[$CellContext`Funcion, 
                Blank[List]], 
               Pattern[$CellContext`filas, 
                Blank[]], 
               Pattern[$CellContext`nn, 
                Blank[]]] := 
             Module[{$CellContext`MB = 
                ConstantArray[0, {$CellContext`filas, 1}], $CellContext`CF}, 
               Part[$CellContext`MB, 1, 1] = 
                Part[$CellContext`Funcion, 1]; $CellContext`CF[
                  Pattern[$CellContext`L, 
                   Blank[List]], 
                  Pattern[$CellContext`a, 
                   Blank[]]] := 
                Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
               Return[
                 $CellContext`CF[$CellContext`MB, $CellContext`nn]]]; \
$CellContext`B[
               Pattern[$CellContext`n, 
                
                Blank[]]] := $CellContext`MatrizB[$CellContext`Funct, \
$CellContext`t, $CellContext`n]; $CellContext`Productoria[
               Pattern[$CellContext`ini, 
                Blank[]], 
               Pattern[$CellContext`final, 
                Blank[]]] := Module[{$CellContext`i}, $CellContext`p = Dot[
                  $CellContext`A[$CellContext`ini], 
                  $CellContext`B[$CellContext`ini - 1]]; 
               For[$CellContext`i = $CellContext`ini + 
                  1, $CellContext`i <= $CellContext`final, $CellContext`p = 
                  Dot[
                    $CellContext`A[$CellContext`i], $CellContext`p]; 
                 Increment[$CellContext`i]]; 
               Return[$CellContext`p]]; $CellContext`s = Sum[
               $CellContext`Productoria[$CellContext`k, $CellContext`ww - 
                1], {$CellContext`k, 1, $CellContext`ww - 1}]; Return[
              Part[$CellContext`s, $CellContext`t, 1]]]; 
         If[$CellContext`w <= $CellContext`nc - 1, 
           $CellContext`ElementoSucesionH[$CellContext`Coefi, \
$CellContext`ConditInitial, $CellContext`w], 
           
           Return[$CellContext`ElementoSucesionH[$CellContext`Coefi, \
$CellContext`ConditInitial, $CellContext`w] + \
$CellContext`Sumatoria[$CellContext`Coefi, $CellContext`F, $CellContext`w]]]]; \
$CellContext`PruebaH[
         Pattern[$CellContext`m, 
          Blank[]], 
         Pattern[$CellContext`Con, 
          Blank[List]], 
         Pattern[$CellContext`Condici, 
          Blank[List]]] := 
       Module[{$CellContext`k, $CellContext`alr = 0, $CellContext`mt = 
          0, $CellContext`alm = 0}, 
         For[$CellContext`k = 0, $CellContext`k <= $CellContext`m, 
           ClearSystemCache[]; $CellContext`L1 = First[
              Timing[
               $CellContext`ElementoSucesionH[$CellContext`Con, \
$CellContext`Condici, $CellContext`k]]]; 
           ClearSystemCache[]; $CellContext`L2 = First[
              Timing[
               $CellContext`CrearRR[$CellContext`Con, $CellContext`Condici, 
                ConstantArray[0, 1], $CellContext`k]]]; If[
             
             And[$CellContext`L1 > $CellContext`L2, $CellContext`L1 != \
$CellContext`L2], 
             Increment[$CellContext`alr], 
             If[$CellContext`L1 == $CellContext`L2, 
              Increment[$CellContext`mt], 
              Increment[$CellContext`alm]]]; Increment[$CellContext`k]]; 
         Return[{$CellContext`alr, $CellContext`alm, $CellContext`mt}]]; \
$CellContext`PruebaNH[
         Pattern[$CellContext`m, 
          Blank[]], 
         Pattern[$CellContext`Con, 
          Blank[List]], 
         Pattern[$CellContext`Condici, 
          Blank[List]], 
         Pattern[$CellContext`Fun, 
          Blank[List]], 
         Pattern[$CellContext`coefpoli, 
          Blank[]]] := 
       Module[{$CellContext`k, $CellContext`alr = 0, $CellContext`mt = 
          0, $CellContext`alm = 0}, 
         For[$CellContext`k = 0, $CellContext`k <= $CellContext`m, 
           ClearSystemCache[]; $CellContext`L1 = First[
              Timing[
               $CellContext`ElementoSucesionNH[$CellContext`Con, \
$CellContext`Condici, {
                 Dot[$CellContext`coefpoli, 
                  $CellContext`Polinomio[$CellContext`coefpoli]]}, \
$CellContext`k]]]; ClearSystemCache[]; $CellContext`L2 = First[
              Timing[
               $CellContext`CrearRR[$CellContext`Con, $CellContext`Condici, \
$CellContext`coefpoli, $CellContext`k]]]; If[
             
             And[$CellContext`L1 > $CellContext`L2, $CellContext`L1 != \
$CellContext`L2], 
             Increment[$CellContext`alr], 
             If[$CellContext`L1 == $CellContext`L2, 
              Increment[$CellContext`mt], 
              Increment[$CellContext`alm]]]; Increment[$CellContext`k]]; 
         Return[{$CellContext`alr, $CellContext`alm, $CellContext`mt}]]; \
$CellContext`ResolRRH[
         Pattern[$CellContext`Co, 
          Blank[List]], 
         Pattern[$CellContext`Con, 
          Blank[List]]] := 
       Module[{$CellContext`ElementoSucesionH, $CellContext`SolveR, \
$CellContext`SolveRR}, $CellContext`ElementoSucesionH[
            Pattern[$CellContext`Coeficient, 
             Blank[List]], 
            Pattern[$CellContext`ConditionInitial, 
             Blank[List]], 
            Pattern[$CellContext`m, 
             Blank[]]] := 
          Module[{$CellContext`CD = 
             Reverse[$CellContext`ConditionInitial], $CellContext`h = Part[
                Dimensions[$CellContext`ConditionInitial], 1] - 
              1, $CellContext`Matriz}, $CellContext`Matriz[
               Pattern[$CellContext`Coeficientes, 
                Blank[List]], 
               Pattern[$CellContext`nn, 
                Blank[]]] := Module[{$CellContext`Identidad = IdentityMatrix[
                  Part[
                   Dimensions[$CellContext`Coeficientes], 
                   1]], $CellContext`A = {$CellContext`Coeficientes}, \
$CellContext`i, $CellContext`CF}, 
               For[$CellContext`i = 1, $CellContext`i <= Part[
                    Dimensions[$CellContext`Coeficientes], 1] - 
                  1, $CellContext`A = Append[$CellContext`A, 
                    Part[$CellContext`Identidad, $CellContext`i]]; 
                 Increment[$CellContext`i]]; $CellContext`CF[
                  Pattern[$CellContext`L, 
                   Blank[List]], 
                  Pattern[$CellContext`a, 
                   Blank[]]] := 
                Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
               Return[
                 $CellContext`CF[$CellContext`A, $CellContext`nn]]]; \
$CellContext`A[
               Pattern[$CellContext`n, 
                
                Blank[]]] := $CellContext`Matriz[$CellContext`Coeficient, \
$CellContext`n]; 
            If[$CellContext`m > $CellContext`h, $CellContext`Elemento = Dot[
                 $CellContext`A[0], 
                 Transpose[{$CellContext`CD}]]; 
              For[$CellContext`i = 
                1, $CellContext`i <= $CellContext`m - 
                 1, $CellContext`Elemento = Dot[
                   $CellContext`A[$CellContext`i], $CellContext`Elemento]; 
                Increment[$CellContext`i]]; Return[
                Part[$CellContext`Elemento, $CellContext`h + 1, 1]], 
              Return[
               
               Part[$CellContext`ConditionInitial, $CellContext`m + 
                1]]]]; $CellContext`SolveR[
            Pattern[$CellContext`mm, 
             Blank[]], 
            Pattern[$CellContext`Coeficien, 
             Blank[List]], 
            Pattern[$CellContext`ConditionInitia, 
             Blank[List]], 
            Pattern[$CellContext`n, 
             Blank[]]] := 
          Module[{$CellContext`L = {}}, 
            For[$CellContext`i = 
              0, $CellContext`i <= $CellContext`mm, $CellContext`L = 
               Append[$CellContext`L, 
                 $CellContext`ElementoSucesionH[$CellContext`Coeficien, \
$CellContext`ConditionInitia, $CellContext`i]]; Increment[$CellContext`i]]; 
            Return[
              FunctionExpand[
               
               FindSequenceFunction[$CellContext`L, $CellContext`n]]]]; \
$CellContext`SolveRR[
            Pattern[$CellContext`m, 
             Blank[]], 
            Pattern[$CellContext`Coeficient, 
             Blank[List]], 
            Pattern[$CellContext`ConditionInitial, 
             Blank[List]], 
            Pattern[$CellContext`n, 
             Blank[]]] := 
          Module[{$CellContext`L = {}}, 
            For[$CellContext`i = 
              0, $CellContext`i <= $CellContext`m, $CellContext`L = 
               Append[$CellContext`L, 
                 $CellContext`ElementoSucesionH[$CellContext`Coeficient, \
$CellContext`ConditionInitial, $CellContext`i]]; Increment[$CellContext`i]]; 
            Return[
              FunctionExpand[
               
               FindSequenceFunction[$CellContext`L, $CellContext`n]]]]; \
$CellContext`j = 1; $CellContext`f[
            Pattern[$CellContext`n, 
             Blank[]]] := Evaluate[
            $CellContext`SolveR[$CellContext`j, $CellContext`Co, \
$CellContext`Con, $CellContext`n]]; While[NumericQ[
             $CellContext`f[1]] == False, 
           Increment[$CellContext`j]; $CellContext`f[
              Pattern[$CellContext`n, 
               Blank[]]] := Evaluate[
              $CellContext`SolveR[$CellContext`j, $CellContext`Co, \
$CellContext`Con, $CellContext`n]]; 
           If[$CellContext`j > 1000, 
             Print["Las ejecuciones superaron 1000 pruebas"]; 
             Break[]; $CellContext`j = 0]]; $CellContext`f[
            Pattern[$CellContext`n, 
             Blank[]]] := Evaluate[
            $CellContext`SolveRR[$CellContext`j, $CellContext`Co, \
$CellContext`Con, $CellContext`n]]; FullSimplify[
           $CellContext`f[$CellContext`n]]]; $CellContext`ResolRRNH[
         Pattern[$CellContext`Co, 
          Blank[List]], 
         Pattern[$CellContext`Con, 
          Blank[List]], 
         Pattern[$CellContext`Func, 
          Blank[List]]] := 
       Module[{$CellContext`ElementoSucesionNH, $CellContext`SolveR, \
$CellContext`SolveRR}, $CellContext`ElementoSucesionNH[
            Pattern[$CellContext`Coefi, 
             Blank[List]], 
            Pattern[$CellContext`ConditInitial, 
             Blank[List]], 
            Pattern[$CellContext`F, 
             Blank[List]], 
            Pattern[$CellContext`w, 
             Blank[]]] := Module[{$CellContext`nc = Part[
               Dimensions[$CellContext`Coefi], 
               1], $CellContext`ElementoSucesionH, $CellContext`Sumatoria}, \
$CellContext`ElementoSucesionH[
               Pattern[$CellContext`Coeficient, 
                Blank[List]], 
               Pattern[$CellContext`ConditionInitial, 
                Blank[List]], 
               Pattern[$CellContext`m, 
                Blank[]]] := 
             Module[{$CellContext`CD = 
                Reverse[$CellContext`ConditionInitial], $CellContext`h = Part[
                   Dimensions[$CellContext`ConditionInitial], 1] - 
                 1, $CellContext`Matriz}, $CellContext`Matriz[
                  Pattern[$CellContext`Coeficientes, 
                   Blank[List]], 
                  Pattern[$CellContext`nn, 
                   Blank[]]] := 
                Module[{$CellContext`Identidad = IdentityMatrix[
                    Part[
                    Dimensions[$CellContext`Coeficientes], 
                    1]], $CellContext`A = {$CellContext`Coeficientes}, \
$CellContext`i, $CellContext`CF}, 
                  For[$CellContext`i = 1, $CellContext`i <= Part[
                    Dimensions[$CellContext`Coeficientes], 1] - 
                    1, $CellContext`A = Append[$CellContext`A, 
                    Part[$CellContext`Identidad, $CellContext`i]]; 
                    Increment[$CellContext`i]]; $CellContext`CF[
                    Pattern[$CellContext`L, 
                    Blank[List]], 
                    Pattern[$CellContext`a, 
                    Blank[]]] := 
                   Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
                  Return[
                    $CellContext`CF[$CellContext`A, $CellContext`nn]]]; \
$CellContext`A[
                  Pattern[$CellContext`n, 
                   
                   Blank[]]] := $CellContext`Matriz[$CellContext`Coeficient, \
$CellContext`n]; 
               If[$CellContext`m > $CellContext`h, $CellContext`Elemento = Dot[
                    $CellContext`A[0], 
                    Transpose[{$CellContext`CD}]]; 
                 For[$CellContext`i = 
                   1, $CellContext`i <= $CellContext`m - 
                    1, $CellContext`Elemento = Dot[
                    $CellContext`A[$CellContext`i], $CellContext`Elemento]; 
                   Increment[$CellContext`i]]; Return[
                   Part[$CellContext`Elemento, $CellContext`h + 1, 1]], 
                 Return[
                  
                  Part[$CellContext`ConditionInitial, $CellContext`m + 
                   1]]]]; $CellContext`Sumatoria[
               Pattern[$CellContext`Coeficient, 
                Blank[List]], 
               Pattern[$CellContext`Funct, 
                Blank[List]], 
               Pattern[$CellContext`ww, 
                Blank[]]] := 
             Module[{$CellContext`Matriz, $CellContext`MatrizB, \
$CellContext`t = Part[
                  Dimensions[$CellContext`Coeficient], 
                  1], $CellContext`Productoria, $CellContext`s}, \
$CellContext`Matriz[
                  Pattern[$CellContext`Coeficientes, 
                   Blank[List]], 
                  Pattern[$CellContext`nn, 
                   Blank[]]] := 
                Module[{$CellContext`Identidad = IdentityMatrix[
                    Part[
                    Dimensions[$CellContext`Coeficientes], 
                    1]], $CellContext`A = {$CellContext`Coeficientes}, \
$CellContext`i, $CellContext`CF}, 
                  For[$CellContext`i = 1, $CellContext`i <= Part[
                    Dimensions[$CellContext`Coeficientes], 1] - 
                    1, $CellContext`A = Append[$CellContext`A, 
                    Part[$CellContext`Identidad, $CellContext`i]]; 
                    Increment[$CellContext`i]]; $CellContext`CF[
                    Pattern[$CellContext`L, 
                    Blank[List]], 
                    Pattern[$CellContext`a, 
                    Blank[]]] := 
                   Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
                  Return[
                    $CellContext`CF[$CellContext`A, $CellContext`nn]]]; \
$CellContext`A[
                  Pattern[$CellContext`n, 
                   
                   Blank[]]] := $CellContext`Matriz[$CellContext`Coeficient, \
$CellContext`n]; $CellContext`MatrizB[
                  Pattern[$CellContext`Funcion, 
                   Blank[List]], 
                  Pattern[$CellContext`filas, 
                   Blank[]], 
                  Pattern[$CellContext`nn, 
                   Blank[]]] := 
                Module[{$CellContext`MB = 
                   ConstantArray[
                    0, {$CellContext`filas, 1}], $CellContext`CF}, 
                  Part[$CellContext`MB, 1, 1] = 
                   Part[$CellContext`Funcion, 1]; $CellContext`CF[
                    Pattern[$CellContext`L, 
                    Blank[List]], 
                    Pattern[$CellContext`a, 
                    Blank[]]] := 
                   Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
                  Return[
                    $CellContext`CF[$CellContext`MB, $CellContext`nn]]]; \
$CellContext`B[
                  Pattern[$CellContext`n, 
                   
                   Blank[]]] := $CellContext`MatrizB[$CellContext`Funct, \
$CellContext`t, $CellContext`n]; $CellContext`Productoria[
                  Pattern[$CellContext`ini, 
                   Blank[]], 
                  Pattern[$CellContext`final, 
                   Blank[]]] := Module[{$CellContext`i}, $CellContext`p = Dot[
                    $CellContext`A[$CellContext`ini], 
                    $CellContext`B[$CellContext`ini - 1]]; 
                  For[$CellContext`i = $CellContext`ini + 
                    1, $CellContext`i <= $CellContext`final, $CellContext`p = 
                    Dot[
                    $CellContext`A[$CellContext`i], $CellContext`p]; 
                    Increment[$CellContext`i]]; 
                  Return[$CellContext`p]]; $CellContext`s = Sum[
                  $CellContext`Productoria[$CellContext`k, $CellContext`ww - 
                   1], {$CellContext`k, 1, $CellContext`ww - 1}]; Return[
                 Part[$CellContext`s, $CellContext`t, 1]]]; 
            If[$CellContext`w <= $CellContext`nc - 1, 
              $CellContext`ElementoSucesionH[$CellContext`Coefi, \
$CellContext`ConditInitial, $CellContext`w], 
              
              Return[$CellContext`ElementoSucesionH[$CellContext`Coefi, \
$CellContext`ConditInitial, $CellContext`w] + \
$CellContext`Sumatoria[$CellContext`Coefi, $CellContext`F, $CellContext`w]]]]; \
$CellContext`SolveR[
            Pattern[$CellContext`mm, 
             Blank[]], 
            Pattern[$CellContext`Coeficien, 
             Blank[List]], 
            Pattern[$CellContext`ConditionInitia, 
             Blank[List]], 
            Pattern[$CellContext`Fun, 
             Blank[List]], 
            Pattern[$CellContext`n, 
             Blank[]]] := 
          Module[{$CellContext`L = {}}, 
            For[$CellContext`i = 
              0, $CellContext`i <= $CellContext`mm, $CellContext`L = 
               Append[$CellContext`L, 
                 $CellContext`ElementoSucesionNH[$CellContext`Coeficien, \
$CellContext`ConditionInitia, $CellContext`Fun, $CellContext`i]]; 
              Increment[$CellContext`i]]; Return[
              FunctionExpand[
               
               FindSequenceFunction[$CellContext`L, $CellContext`n]]]]; \
$CellContext`SolveRR[
            Pattern[$CellContext`m, 
             Blank[]], 
            Pattern[$CellContext`Coeficient, 
             Blank[List]], 
            Pattern[$CellContext`ConditionInitial, 
             Blank[List]], 
            Pattern[$CellContext`Fun, 
             Blank[List]], 
            Pattern[$CellContext`n, 
             Blank[]]] := 
          Module[{$CellContext`L = {}}, 
            For[$CellContext`i = 
              0, $CellContext`i <= $CellContext`m, $CellContext`L = 
               Append[$CellContext`L, 
                 $CellContext`ElementoSucesionNH[$CellContext`Coeficient, \
$CellContext`ConditionInitial, $CellContext`Fun, $CellContext`i]]; 
              Increment[$CellContext`i]]; Return[
              FunctionExpand[
               
               FindSequenceFunction[$CellContext`L, $CellContext`n]]]]; \
$CellContext`j = 1; $CellContext`f[
            Pattern[$CellContext`n, 
             Blank[]]] := Evaluate[
            $CellContext`SolveR[$CellContext`j, $CellContext`Co, \
$CellContext`Con, $CellContext`Func, $CellContext`n]]; While[NumericQ[
             $CellContext`f[1]] == False, 
           Increment[$CellContext`j]; $CellContext`f[
              Pattern[$CellContext`n, 
               Blank[]]] := Evaluate[
              $CellContext`SolveR[$CellContext`j, $CellContext`Co, \
$CellContext`Con, $CellContext`Func, $CellContext`n]]; 
           If[$CellContext`j > 1000, 
             Print["Las ejecuciones superaron 1000 pruebas"]; 
             Break[]; $CellContext`j = 0]]; $CellContext`f[
            Pattern[$CellContext`n, 
             Blank[]]] := Evaluate[
            $CellContext`SolveRR[$CellContext`j, $CellContext`Co, \
$CellContext`Con, $CellContext`Func, $CellContext`n]]; FullSimplify[
           $CellContext`f[$CellContext`n]]]; $CellContext`SolveRRHM[
         Pattern[$CellContext`mm, 
          Blank[]], 
         Pattern[$CellContext`Coeficien, 
          Blank[List]], 
         Pattern[$CellContext`ConditionInitia, 
          Blank[List]]] := 
       Module[{$CellContext`L = {}, $CellContext`ElementoSucesionH}, \
$CellContext`ElementoSucesionH[
            Pattern[$CellContext`Coeficient, 
             Blank[List]], 
            Pattern[$CellContext`ConditionInitial, 
             Blank[List]], 
            Pattern[$CellContext`m, 
             Blank[]]] := 
          Module[{$CellContext`CD = 
             Reverse[$CellContext`ConditionInitial], $CellContext`h = Part[
                Dimensions[$CellContext`ConditionInitial], 1] - 
              1, $CellContext`Matriz}, $CellContext`Matriz[
               Pattern[$CellContext`Coeficientes, 
                Blank[List]], 
               Pattern[$CellContext`nn, 
                Blank[]]] := Module[{$CellContext`Identidad = IdentityMatrix[
                  Part[
                   Dimensions[$CellContext`Coeficientes], 
                   1]], $CellContext`A = {$CellContext`Coeficientes}, \
$CellContext`i, $CellContext`CF}, 
               For[$CellContext`i = 1, $CellContext`i <= Part[
                    Dimensions[$CellContext`Coeficientes], 1] - 
                  1, $CellContext`A = Append[$CellContext`A, 
                    Part[$CellContext`Identidad, $CellContext`i]]; 
                 Increment[$CellContext`i]]; $CellContext`CF[
                  Pattern[$CellContext`L, 
                   Blank[List]], 
                  Pattern[$CellContext`a, 
                   Blank[]]] := 
                Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
               Return[
                 $CellContext`CF[$CellContext`A, $CellContext`nn]]]; \
$CellContext`A[
               Pattern[$CellContext`n, 
                
                Blank[]]] := $CellContext`Matriz[$CellContext`Coeficient, \
$CellContext`n]; 
            If[$CellContext`m > $CellContext`h, $CellContext`Elemento = Dot[
                 $CellContext`A[0], 
                 Transpose[{$CellContext`CD}]]; 
              For[$CellContext`i = 
                1, $CellContext`i <= $CellContext`m - 
                 1, $CellContext`Elemento = Dot[
                   $CellContext`A[$CellContext`i], $CellContext`Elemento]; 
                Increment[$CellContext`i]]; Return[
                Part[$CellContext`Elemento, $CellContext`h + 1, 1]], 
              Return[
               Part[$CellContext`ConditionInitial, $CellContext`m + 1]]]]; 
         For[$CellContext`i = 
           0, $CellContext`i <= $CellContext`mm, $CellContext`L = 
            Append[$CellContext`L, 
              $CellContext`ElementoSucesionH[$CellContext`Coeficien, \
$CellContext`ConditionInitia, $CellContext`i]]; Increment[$CellContext`i]]; 
         Return[
           FullSimplify[
            FunctionExpand[
             
             FindSequenceFunction[$CellContext`L, $CellContext`n]]]]]; \
$CellContext`SolveRRNHM[
         Pattern[$CellContext`mm, 
          Blank[]], 
         Pattern[$CellContext`Coef, 
          Blank[List]], 
         Pattern[$CellContext`ConIn, 
          Blank[List]], 
         Pattern[$CellContext`Fun, 
          Blank[List]]] := 
       Module[{$CellContext`L = {}, $CellContext`ElementoSucesionNH}, \
$CellContext`ElementoSucesionNH[
            Pattern[$CellContext`Coefi, 
             Blank[List]], 
            Pattern[$CellContext`ConditInitial, 
             Blank[List]], 
            Pattern[$CellContext`F, 
             Blank[List]], 
            Pattern[$CellContext`w, 
             Blank[]]] := Module[{$CellContext`nc = Part[
               Dimensions[$CellContext`Coefi], 
               1], $CellContext`ElementoSucesionH, $CellContext`Sumatoria}, \
$CellContext`ElementoSucesionH[
               Pattern[$CellContext`Coeficient, 
                Blank[List]], 
               Pattern[$CellContext`ConditionInitial, 
                Blank[List]], 
               Pattern[$CellContext`m, 
                Blank[]]] := 
             Module[{$CellContext`CD = 
                Reverse[$CellContext`ConditionInitial], $CellContext`h = Part[
                   Dimensions[$CellContext`ConditionInitial], 1] - 
                 1, $CellContext`Matriz}, $CellContext`Matriz[
                  Pattern[$CellContext`Coeficientes, 
                   Blank[List]], 
                  Pattern[$CellContext`nn, 
                   Blank[]]] := 
                Module[{$CellContext`Identidad = IdentityMatrix[
                    Part[
                    Dimensions[$CellContext`Coeficientes], 
                    1]], $CellContext`A = {$CellContext`Coeficientes}, \
$CellContext`i, $CellContext`CF}, 
                  For[$CellContext`i = 1, $CellContext`i <= Part[
                    Dimensions[$CellContext`Coeficientes], 1] - 
                    1, $CellContext`A = Append[$CellContext`A, 
                    Part[$CellContext`Identidad, $CellContext`i]]; 
                    Increment[$CellContext`i]]; $CellContext`CF[
                    Pattern[$CellContext`L, 
                    Blank[List]], 
                    Pattern[$CellContext`a, 
                    Blank[]]] := 
                   Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
                  Return[
                    $CellContext`CF[$CellContext`A, $CellContext`nn]]]; \
$CellContext`A[
                  Pattern[$CellContext`n, 
                   
                   Blank[]]] := $CellContext`Matriz[$CellContext`Coeficient, \
$CellContext`n]; 
               If[$CellContext`m > $CellContext`h, $CellContext`Elemento = Dot[
                    $CellContext`A[0], 
                    Transpose[{$CellContext`CD}]]; 
                 For[$CellContext`i = 
                   1, $CellContext`i <= $CellContext`m - 
                    1, $CellContext`Elemento = Dot[
                    $CellContext`A[$CellContext`i], $CellContext`Elemento]; 
                   Increment[$CellContext`i]]; Return[
                   Part[$CellContext`Elemento, $CellContext`h + 1, 1]], 
                 Return[
                  
                  Part[$CellContext`ConditionInitial, $CellContext`m + 
                   1]]]]; $CellContext`Sumatoria[
               Pattern[$CellContext`Coeficient, 
                Blank[List]], 
               Pattern[$CellContext`Funct, 
                Blank[List]], 
               Pattern[$CellContext`ww, 
                Blank[]]] := 
             Module[{$CellContext`Matriz, $CellContext`MatrizB, \
$CellContext`t = Part[
                  Dimensions[$CellContext`Coeficient], 
                  1], $CellContext`Productoria, $CellContext`s}, \
$CellContext`Matriz[
                  Pattern[$CellContext`Coeficientes, 
                   Blank[List]], 
                  Pattern[$CellContext`nn, 
                   Blank[]]] := 
                Module[{$CellContext`Identidad = IdentityMatrix[
                    Part[
                    Dimensions[$CellContext`Coeficientes], 
                    1]], $CellContext`A = {$CellContext`Coeficientes}, \
$CellContext`i, $CellContext`CF}, 
                  For[$CellContext`i = 1, $CellContext`i <= Part[
                    Dimensions[$CellContext`Coeficientes], 1] - 
                    1, $CellContext`A = Append[$CellContext`A, 
                    Part[$CellContext`Identidad, $CellContext`i]]; 
                    Increment[$CellContext`i]]; $CellContext`CF[
                    Pattern[$CellContext`L, 
                    Blank[List]], 
                    Pattern[$CellContext`a, 
                    Blank[]]] := 
                   Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
                  Return[
                    $CellContext`CF[$CellContext`A, $CellContext`nn]]]; \
$CellContext`A[
                  Pattern[$CellContext`n, 
                   
                   Blank[]]] := $CellContext`Matriz[$CellContext`Coeficient, \
$CellContext`n]; $CellContext`MatrizB[
                  Pattern[$CellContext`Funcion, 
                   Blank[List]], 
                  Pattern[$CellContext`filas, 
                   Blank[]], 
                  Pattern[$CellContext`nn, 
                   Blank[]]] := 
                Module[{$CellContext`MB = 
                   ConstantArray[
                    0, {$CellContext`filas, 1}], $CellContext`CF}, 
                  Part[$CellContext`MB, 1, 1] = 
                   Part[$CellContext`Funcion, 1]; $CellContext`CF[
                    Pattern[$CellContext`L, 
                    Blank[List]], 
                    Pattern[$CellContext`a, 
                    Blank[]]] := 
                   Block[{$CellContext`n = $CellContext`a}, $CellContext`L]; 
                  Return[
                    $CellContext`CF[$CellContext`MB, $CellContext`nn]]]; \
$CellContext`B[
                  Pattern[$CellContext`n, 
                   
                   Blank[]]] := $CellContext`MatrizB[$CellContext`Funct, \
$CellContext`t, $CellContext`n]; $CellContext`Productoria[
                  Pattern[$CellContext`ini, 
                   Blank[]], 
                  Pattern[$CellContext`final, 
                   Blank[]]] := Module[{$CellContext`i}, $CellContext`p = Dot[
                    $CellContext`A[$CellContext`ini], 
                    $CellContext`B[$CellContext`ini - 1]]; 
                  For[$CellContext`i = $CellContext`ini + 
                    1, $CellContext`i <= $CellContext`final, $CellContext`p = 
                    Dot[
                    $CellContext`A[$CellContext`i], $CellContext`p]; 
                    Increment[$CellContext`i]]; 
                  Return[$CellContext`p]]; $CellContext`s = Sum[
                  $CellContext`Productoria[$CellContext`k, $CellContext`ww - 
                   1], {$CellContext`k, 1, $CellContext`ww - 1}]; Return[
                 Part[$CellContext`s, $CellContext`t, 1]]]; 
            If[$CellContext`w <= $CellContext`nc - 1, 
              $CellContext`ElementoSucesionH[$CellContext`Coefi, \
$CellContext`ConditInitial, $CellContext`w], 
              
              Return[$CellContext`ElementoSucesionH[$CellContext`Coefi, \
$CellContext`ConditInitial, $CellContext`w] + \
$CellContext`Sumatoria[$CellContext`Coefi, $CellContext`F, $CellContext`w]]]]; 
         For[$CellContext`i = 
           0, $CellContext`i <= $CellContext`mm, $CellContext`L = 
            Append[$CellContext`L, 
              $CellContext`ElementoSucesionNH[$CellContext`Coef, \
$CellContext`ConIn, $CellContext`Fun, $CellContext`i]]; 
           Increment[$CellContext`i]]; Return[
           FullSimplify[
            FunctionExpand[
             FindSequenceFunction[$CellContext`L, $CellContext`n]]]]]); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.6531314740016575`*^9, 3.65313254309381*^9, 3.653132837694275*^9, 
   3.6531332586485662`*^9, 3.6531336755997972`*^9, 3.65313371566431*^9, 
   3.653133798961234*^9, 3.653134096391549*^9, 3.65313423647348*^9, 
   3.653134381143277*^9, 3.6531344374634666`*^9, 3.653134472794626*^9, 
   3.653134873659783*^9, {3.6531349329694376`*^9, 3.6531349534685297`*^9}, 
   3.6531350449248176`*^9, 3.6531351828537006`*^9, 3.6531352399872975`*^9, {
   3.6531353315108747`*^9, 3.6531353501762357`*^9}, 3.6531354155491276`*^9, 
   3.6531356831534224`*^9, 3.6531357665889044`*^9, 3.653136083592054*^9, 
   3.6531361826883717`*^9, 3.6531365481556973`*^9, 3.6531367033939285`*^9, 
   3.653137129682522*^9, 3.6531371831386824`*^9, 3.6531374068545284`*^9, 
   3.6531375747244186`*^9, 3.653137663138836*^9, 3.6531377708545876`*^9, 
   3.653137982149247*^9, {3.668640058983637*^9, 3.668640075989786*^9}, {
   3.801156638068327*^9, 3.8011566485285597`*^9}},
 CellLabel->"Out[1]=",ExpressionUUID->"088e3c1b-491f-4d36-b56b-8d397e32cc5a"]
}, Open  ]]
},
WindowSize->{1350, 669},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"37480c6f-be3c-42c5-b2af-3d3d81419b7c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 80681, 1863, 12290, "Input",ExpressionUUID->"8b027606-23c0-42cc-bc5c-30b83d274691"],
Cell[81264, 1887, 49698, 1048, 1062, "Output",ExpressionUUID->"088e3c1b-491f-4d36-b56b-8d397e32cc5a"]
}, Open  ]]
}
]
*)

