(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    147557,       3531]
NotebookOptionsPosition[    128490,       3259]
NotebookOutlinePosition[    128954,       3277]
CellTagsIndexPosition[    128911,       3274]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.804847582602474*^9, 3.804847623835461*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"ca079fa1-ed74-435c-ac7c-22e524f4d475"],

Cell["1.5.2", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 
  3.806850738079356*^9}},ExpressionUUID->"a8902d91-6a29-47e4-9bc7-\
f47ba858c878"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Suma", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "\[InvisibleSpace]", "6"}], "\[InvisibleSpace]", 
    ",", "\[InvisibleSpace]", 
    FractionBox["1", "2"], "\[InvisibleSpace]", ",", 
    RowBox[{
     RowBox[{"Suma", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "+", "\[InvisibleSpace]", 
     FractionBox[
      RowBox[{"n", "-", "5"}], 
      RowBox[{"n", "-", "4"}]]}]}], "\[InvisibleSpace]", "]"}]}]], "Input",
 CellChangeTimes->{{3.8048494062829065`*^9, 3.804849425237215*^9}, {
   3.804849720401948*^9, 3.8048497205385804`*^9}, 3.804850042602749*^9, {
   3.805628364172349*^9, 3.8056283722606974`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"7223d560-39e2-4754-a2bf-d33040ab879e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Suma", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Sum", "[", 
     RowBox[{
      FractionBox["i", 
       RowBox[{"i", "+", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"n", "-", "5"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
  3.8056284986683397`*^9, 3.8056284988604727`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"a45cd562-5462-4cd0-a09d-f738e3980edd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8056283366719313`*^9, 3.805628343322137*^9}, 
   3.8056284030454073`*^9, {3.8056284997553153`*^9, 3.805628505497192*^9}, 
   3.8056568804521265`*^9, 3.8250062290051255`*^9, 3.825006493836776*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"8942bada-8d55-4cc2-b8ef-d905a6e3e26b"]
}, Open  ]],

Cell["1.5.3", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494974905844`*^9}, {
  3.8068507472301846`*^9, 
  3.806850748150823*^9}},ExpressionUUID->"cfe8e32b-9972-4a43-90af-\
52a4e7662e6a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Suma", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "\[InvisibleSpace]", "9"}], "\[InvisibleSpace]", 
    ",", "\[InvisibleSpace]", 
    FractionBox["49", "262144"], "\[InvisibleSpace]", ",", 
    RowBox[{
     RowBox[{"Suma", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"n", "+", "5"}], 
        SuperscriptBox["2", 
         RowBox[{"n", "+", "1"}]]], ")"}], "2"]}]}], "\[InvisibleSpace]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.804849579215516*^9, 3.804849596931238*^9}, 
   3.8048497235045004`*^9, 3.804849791275591*^9, 3.8048500392595277`*^9, {
   3.8250057361111507`*^9, 3.8250057805020533`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"d08d50be-93e9-4310-a7fe-159beb0236f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Suma", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Sum", "[", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["i", 
         SuperscriptBox["2", 
          RowBox[{"i", "-", "4"}]]], ")"}], "2"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "14", ",", 
        RowBox[{"n", "+", "5"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "9", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
  3.8056284325018735`*^9, 3.805628483496705*^9}, {3.805628518986335*^9, 
  3.8056285196590095`*^9}, {3.8250057937789106`*^9, 3.8250058138033857`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"a9fc79e2-4d6b-458f-8901-dc1dca9e73b3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8056284841868267`*^9, {3.80562852683875*^9, 3.805628532018344*^9}, 
   3.8056569159845905`*^9, {3.8250058193975344`*^9, 3.8250058277254333`*^9}, 
   3.8250062346149826`*^9, 3.825006498633315*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"f225d2b6-6b8f-4e2b-8464-a46f15e8bbd4"]
}, Open  ]],

Cell["1.5.4", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494974905844`*^9}, {
  3.8048496834723682`*^9, 3.8048496839371257`*^9}, {3.8068507567527876`*^9, 
  3.8068507588721876`*^9}},ExpressionUUID->"eea7a011-35a7-459e-a8be-\
73ce00e051af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Producto", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "\[InvisibleSpace]", "11"}], "\[InvisibleSpace]",
     ",", "\[InvisibleSpace]", "2", "\[InvisibleSpace]", ",", 
    RowBox[{
     RowBox[{"Producto", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", "n"}], "-", "31"}], ")"}]}]}], "\[InvisibleSpace]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.804849697137065*^9, 3.804849786619733*^9}, {
  3.804849849803158*^9, 3.804849870085438*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"c8a82858-268d-4e44-b3da-604a3b7a4bfb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Producto", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Product", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "i"}], "-", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"n", "-", "10"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "11", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
  3.8056284325018735`*^9, 3.805628483496705*^9}, {3.805628518986335*^9, 
  3.8056285196590095`*^9}, {3.805628556947528*^9, 3.8056286289696045`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"de251635-2a0a-43cf-9cbf-f894f8b9fb20"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.805628629704153*^9, 3.805657345689859*^9, 
  3.825006239022024*^9, 3.825006503290509*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"a072bdde-7bcb-414d-82d2-538464429d09"]
}, Open  ]],

Cell["1.5.5", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494974905844`*^9}, {
  3.8048496834723682`*^9, 3.8048496839371257`*^9}, {3.8048499825611305`*^9, 
  3.8048499828503895`*^9}, {3.8068507647918816`*^9, 
  3.806850766623473*^9}},ExpressionUUID->"d353c80f-b7b8-476b-8ac1-\
ea589adaab0a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Producto", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "\[InvisibleSpace]", "5"}], "\[InvisibleSpace]", 
    ",", "\[InvisibleSpace]", "2187", "\[InvisibleSpace]", ",", 
    RowBox[{
     RowBox[{"Producto", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "*", 
     RowBox[{"(", 
      FractionBox[
       SuperscriptBox["3", 
        RowBox[{"n", "+", "4"}]], 
       RowBox[{"n", "+", "4"}]], ")"}]}]}], "\[InvisibleSpace]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.804849697137065*^9, 3.804849786619733*^9}, {
  3.804849849803158*^9, 3.804849870085438*^9}, {3.804850088120983*^9, 
  3.804850136643094*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"6d54b132-f192-4bea-9fa0-c99f7b255d25"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Producto", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Product", "[", 
     RowBox[{
      FractionBox[
       SuperscriptBox["3", 
        RowBox[{"i", "+", "1"}]], 
       RowBox[{"i", "+", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "8", ",", 
        RowBox[{"n", "+", "3"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5", ",", "24"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
  3.8056284325018735`*^9, 3.805628483496705*^9}, {3.805628518986335*^9, 
  3.8056285196590095`*^9}, {3.805628556947528*^9, 3.8056286289696045`*^9}, {
  3.8056287289730453`*^9, 3.805628780777239*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"1e9cc2a0-7f81-40c9-877c-ddc655879408"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.8056287889554963`*^9, 3.805657381750692*^9, 
  3.8250062440665674`*^9, 3.825006508036825*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"75e860a7-15b8-40b6-97e6-803e88a6025e"]
}, Open  ]],

Cell["1.5.6", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494974905844`*^9}, {
  3.8048496834723682`*^9, 3.8048496839371257`*^9}, {3.8048499825611305`*^9, 
  3.8048499828503895`*^9}, {3.8056288215023527`*^9, 3.8056288229462366`*^9}, {
  3.8068507749532056`*^9, 
  3.8068507767591753`*^9}},ExpressionUUID->"71256f76-f307-4ff6-b27e-\
0e42cdf551ea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SumaProducto", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "Producto", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Producto", "[", "i_", "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"i", "\[Equal]", "1"}], "||", 
         RowBox[{"i", "\[Equal]", "2"}]}], ",", "1", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"i", "\[Equal]", "3"}], ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{
           RowBox[{"Producto", "[", 
            RowBox[{"i", "-", "1"}], "]"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "i"}], "-", "7"}], ")"}]}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"n", "\[Equal]", "0"}], ",", "1", ",", 
       RowBox[{
        RowBox[{"SumaProducto", "[", 
         RowBox[{"n", "-", "1"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Producto", "[", 
          RowBox[{"n", "+", "1"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8056289587231874`*^9, 3.805629037982701*^9}, {
  3.8056290770714436`*^9, 3.805629196715017*^9}, {3.805629327310229*^9, 
  3.8056294252457795`*^9}, {3.805629455499717*^9, 3.805629556213519*^9}, {
  3.805640055281762*^9, 3.8056400556630945`*^9}, {3.8056409617232924`*^9, 
  3.8056409791542845`*^9}, {3.8056412071180105`*^9, 3.8056412138460894`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"46789441-abac-4c89-b1af-9c9ea7caed77"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SumaProducto", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "j"}], "-", "5"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "2", ",", 
           RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}], "i"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "19"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
   3.8056284325018735`*^9, 3.805628483496705*^9}, {3.805628518986335*^9, 
   3.8056285196590095`*^9}, {3.805628556947528*^9, 3.8056286289696045`*^9}, {
   3.8056287289730453`*^9, 3.805628780777239*^9}, {3.805628860386781*^9, 
   3.80562894824238*^9}, {3.805629563045785*^9, 3.805629564640498*^9}, {
   3.8056297317645855`*^9, 3.80562974732858*^9}, 3.8056411923931427`*^9, {
   3.8056412479520097`*^9, 3.8056412714447308`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"6444fe46-97ae-42da-a946-71bfbd01141d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.805629565794572*^9, 3.8056297481438828`*^9, 
  3.8056408671537256`*^9, 3.805640985766097*^9, 3.8056411942537313`*^9, 
  3.8056412722600737`*^9, 3.8056574268210588`*^9, 3.82500629037286*^9, 
  3.8250065132356453`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"baf48c5a-b8f3-4dc1-bd64-261b46450bf3"]
}, Open  ]],

Cell["1.5.7", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.806850798681062*^9, 
  3.806850801567577*^9}},ExpressionUUID->"4770676e-5161-414b-b3ba-\
aa7084017004"],

Cell["Parte 1.5.2", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.806850806513198*^9, 
  3.806850812422988*^9}},ExpressionUUID->"1ec1888f-6cba-4c15-9c4c-\
01f6c87bd8fc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SumaCola", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "SC", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"SC", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"Cont_", ":", "6"}], ",", "Suma_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "\[InvisibleSpace]", "6"}], 
        "\[InvisibleSpace]", ",", "\[InvisibleSpace]", 
        FractionBox["1", "2"], "\[InvisibleSpace]", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Cont", "\[Equal]", "m"}], ",", "Suma", ",", 
          RowBox[{"SC", "[", 
           RowBox[{"m", ",", 
            RowBox[{"Cont", "+", "1"}], ",", 
            RowBox[{"Suma", "+", "\[InvisibleSpace]", 
             FractionBox[
              RowBox[{"Cont", "-", "4"}], 
              RowBox[{"Cont", "-", "3"}]]}]}], "\[InvisibleSpace]", "]"}]}], 
         "]"}]}], "]"}]}], ";", 
     RowBox[{"SC", "[", 
      RowBox[{"n", ",", 
       RowBox[{"1", "/", "2"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8048494062829065`*^9, 3.804849425237215*^9}, {
   3.804849720401948*^9, 3.8048497205385804`*^9}, 3.804850042602749*^9, {
   3.805628364172349*^9, 3.8056283722606974`*^9}, {3.8056413432355585`*^9, 
   3.805641343787655*^9}, {3.8056413947071447`*^9, 3.8056414180468693`*^9}, {
   3.8056414609518275`*^9, 3.8056415945274734`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"5e7015d0-0a85-498d-a9ba-411ac604a591"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SumaCola", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Sum", "[", 
     RowBox[{
      FractionBox["i", 
       RowBox[{"i", "+", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"n", "-", "5"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
  3.8056284986683397`*^9, 3.8056284988604727`*^9}, {3.8056416122845974`*^9, 
  3.805641612819413*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"fc1a09c2-8d64-43d3-8896-6dd0374005ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8056283366719313`*^9, 3.805628343322137*^9}, 
   3.8056284030454073`*^9, {3.8056284997553153`*^9, 3.805628505497192*^9}, 
   3.805641615855567*^9, 3.8056574952968674`*^9, 3.825006295971539*^9, 
   3.825006518117053*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"e686fe96-92b3-4731-bb35-b6186994a230"]
}, Open  ]],

Cell["O bien:", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.805641380808816*^9, 
  3.8056413853368196`*^9}},ExpressionUUID->"fdfc945b-fb16-4ff9-b649-\
ce0c41c83c66"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SumaCola", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Suma_", ":", "0"}]}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "\[InvisibleSpace]", "6"}], "\[InvisibleSpace]", 
    ",", 
    RowBox[{"Suma", "+", 
     FractionBox["1", "2"]}], "\[InvisibleSpace]", ",", 
    RowBox[{"SumaCola", "[", 
     RowBox[{
      RowBox[{"n", "-", "1"}], ",", 
      RowBox[{"Suma", "+", "\[InvisibleSpace]", 
       FractionBox[
        RowBox[{"n", "-", "5"}], 
        RowBox[{"n", "-", "4"}]]}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8048494062829065`*^9, 3.804849425237215*^9}, {
   3.804849720401948*^9, 3.8048497205385804`*^9}, 3.804850042602749*^9, {
   3.805628364172349*^9, 3.8056283722606974`*^9}, {3.8056413432355585`*^9, 
   3.805641343787655*^9}, {3.8056413947071447`*^9, 3.8056414180468693`*^9}, {
   3.8056414609518275`*^9, 3.8056415945274734`*^9}, {3.80564162847894*^9, 
   3.805641726040655*^9}, {3.8056419170919456`*^9, 3.805641949874304*^9}, {
   3.805642100128742*^9, 3.805642104192935*^9}, 3.8056421392580996`*^9, {
   3.805642184695599*^9, 3.8056422082287254`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"936ccd3e-7c57-451f-a771-b728435ee786"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SumaCola", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Sum", "[", 
     RowBox[{
      FractionBox["i", 
       RowBox[{"i", "+", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"n", "-", "5"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
   3.8056284986683397`*^9, 3.8056284988604727`*^9}, {3.8056416122845974`*^9, 
   3.805641612819413*^9}, 3.805641951773473*^9, 3.805642214326934*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"a634cec1-7807-4447-a39c-0f8794dc044a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.80564194575523*^9, 3.8056419573708916`*^9}, 
   3.8056421069764276`*^9, 3.805642144005604*^9, {3.805642197037713*^9, 
   3.8056422151553845`*^9}, 3.8056575097282696`*^9, 3.8250063005643115`*^9, 
   3.8250065223486214`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"47060df6-7fc7-4808-adff-06c03819bc5d"]
}, Open  ]],

Cell["Parte 1.5.3", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494974905844`*^9}, {
  3.8068508224589715`*^9, 
  3.806850824015993*^9}},ExpressionUUID->"12d96fec-1ed6-4ae6-bb8b-\
51cb9a14a8f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SumaCola", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "SC", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"SC", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"Cont_", ":", "9"}], ",", "Suma_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "\[InvisibleSpace]", "9"}], ",", 
        "\[InvisibleSpace]", 
        FractionBox["49", "262144"], "\[InvisibleSpace]", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Cont", "\[Equal]", "m"}], ",", "Suma", ",", 
          RowBox[{"SC", "[", 
           RowBox[{"m", ",", 
            RowBox[{"Cont", "+", "1"}], ",", 
            RowBox[{"Suma", "+", 
             RowBox[{
              SuperscriptBox["2", 
               RowBox[{"8", "-", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"6", "+", "Cont"}], ")"}]}]}]], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"6", "+", "Cont"}], ")"}], "2"]}]}]}], 
           "\[InvisibleSpace]", "]"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"SC", "[", 
      RowBox[{"n", ",", 
       FractionBox["49", "262144"]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8048494062829065`*^9, 3.804849425237215*^9}, {
   3.804849720401948*^9, 3.8048497205385804`*^9}, 3.804850042602749*^9, {
   3.805628364172349*^9, 3.8056283722606974`*^9}, {3.8056413432355585`*^9, 
   3.805641343787655*^9}, {3.8056413947071447`*^9, 3.8056414180468693`*^9}, {
   3.8056414609518275`*^9, 3.8056415945274734`*^9}, {3.8056495271712437`*^9, 
   3.8056495879636745`*^9}, {3.805649844657662*^9, 3.8056498494176674`*^9}, {
   3.805657666995701*^9, 3.8056576685786953`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"29a0ee51-252d-4e44-82df-a63f411fe31b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SumaCola", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Sum", "[", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["i", 
         SuperscriptBox["2", 
          RowBox[{"i", "-", "4"}]]], ")"}], "2"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "14", ",", 
        RowBox[{"n", "+", "5"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "14", ",", "33"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
  3.8056284986683397`*^9, 3.8056284988604727`*^9}, {3.8056416122845974`*^9, 
  3.805641612819413*^9}, {3.805649638716805*^9, 3.8056496572658677`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"78e75334-b778-4f52-9631-f086eb1e8d34"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8056283366719313`*^9, 3.805628343322137*^9}, 
   3.8056284030454073`*^9, {3.8056284997553153`*^9, 3.805628505497192*^9}, 
   3.805641615855567*^9, 3.805649662644958*^9, {3.8056498548176193`*^9, 
   3.8056498639657354`*^9}, 3.8056576329148717`*^9, 3.8056577100116453`*^9, 
   3.825006306064849*^9, 3.8250065281814947`*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"0203e228-1616-46ab-be80-71367b38f0ff"]
}, Open  ]],

Cell["O bien:", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.805641380808816*^9, 
  3.8056413853368196`*^9}},ExpressionUUID->"e29aecf8-180f-4290-b3cd-\
b0c1a71caa6d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SumaCola", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Suma_", ":", "0"}]}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "\[InvisibleSpace]", "9"}], ",", 
    RowBox[{"Suma", "+", 
     FractionBox["49", "262144"]}], "\[InvisibleSpace]", ",", 
    RowBox[{"SumaCola", "[", 
     RowBox[{
      RowBox[{"n", "-", "1"}], ",", 
      RowBox[{"Suma", "+", "\[InvisibleSpace]", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"8", "-", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"5", "+", "n"}], ")"}]}]}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"5", "+", "n"}], ")"}], "2"]}]}]}], "\[InvisibleSpace]", 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8048494062829065`*^9, 3.804849425237215*^9}, {
   3.804849720401948*^9, 3.8048497205385804`*^9}, 3.804850042602749*^9, {
   3.805628364172349*^9, 3.8056283722606974`*^9}, {3.8056413432355585`*^9, 
   3.805641343787655*^9}, {3.8056413947071447`*^9, 3.8056414180468693`*^9}, {
   3.8056414609518275`*^9, 3.8056415945274734`*^9}, {3.80564162847894*^9, 
   3.805641726040655*^9}, {3.8056419170919456`*^9, 3.805641949874304*^9}, {
   3.805642100128742*^9, 3.805642104192935*^9}, 3.8056421392580996`*^9, {
   3.805642184695599*^9, 3.8056422082287254`*^9}, {3.8056496702979994`*^9, 
   3.8056496975071716`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"8c380d5b-a9f7-482d-82b6-29a29ffb2caa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SumaCola", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Sum", "[", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["i", 
         SuperscriptBox["2", 
          RowBox[{"i", "-", "4"}]]], ")"}], "2"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "14", ",", 
        RowBox[{"n", "+", "5"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "14", ",", "33"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
   3.8056284986683397`*^9, 3.8056284988604727`*^9}, {3.8056416122845974`*^9, 
   3.805641612819413*^9}, 3.805641951773473*^9, 3.805642214326934*^9, 
   3.805649719959201*^9},
 CellLabel->"In[18]:=",ExpressionUUID->"93421630-9b16-423c-a83e-2456fa8548bf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.80564194575523*^9, 3.8056419573708916`*^9}, 
   3.8056421069764276`*^9, 3.805642144005604*^9, {3.805642197037713*^9, 
   3.8056422151553845`*^9}, {3.805649716997225*^9, 3.8056497211254525`*^9}, 
   3.8056577552417164`*^9, 3.825006310831444*^9, 3.8250065334414916`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"a9cbb113-8873-4501-b368-c9e2daa9d442"]
}, Open  ]],

Cell["Parte 1.5.4", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494974905844`*^9}, {
  3.8048496834723682`*^9, 3.8048496839371257`*^9}, {3.8068508333625593`*^9, 
  3.8068508357204585`*^9}},ExpressionUUID->"85d879be-c38d-423c-89ec-\
6ef4baeed3dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ProductoCola", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "PC", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"PC", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"Cont_", ":", "11"}], ",", "Producto_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "\[InvisibleSpace]", "11"}], ",", 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Cont", "\[Equal]", "m"}], ",", "Producto", ",", 
          RowBox[{"PC", "[", 
           RowBox[{"m", ",", 
            RowBox[{"Cont", "+", "1"}], ",", 
            RowBox[{"Producto", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", "Cont"}], "-", "28"}], ")"}]}]}], "]"}]}], 
         "]"}]}], "]"}]}], ";", 
     RowBox[{"PC", "[", 
      RowBox[{"n", ",", "2"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8048494062829065`*^9, 3.804849425237215*^9}, {
   3.804849720401948*^9, 3.8048497205385804`*^9}, 3.804850042602749*^9, {
   3.805628364172349*^9, 3.8056283722606974`*^9}, {3.8056413432355585`*^9, 
   3.805641343787655*^9}, {3.8056413947071447`*^9, 3.8056414180468693`*^9}, {
   3.8056414609518275`*^9, 3.8056415945274734`*^9}, {3.8056495271712437`*^9, 
   3.8056495879636745`*^9}, {3.8056497827927465`*^9, 
   3.8056498201838036`*^9}, {3.8056498994837084`*^9, 3.805649955887336*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"4995a752-d854-4ecb-9eb0-a984ddcb6793"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ProductoCola", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Product", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "i"}], "-", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"n", "-", "10"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "11", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
   3.8056284986683397`*^9, 3.8056284988604727`*^9}, {3.8056416122845974`*^9, 
   3.805641612819413*^9}, 3.805641951773473*^9, 3.805642214326934*^9, 
   3.805649719959201*^9, {3.805649758148385*^9, 3.8056497604001317`*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"790395e4-16f0-4f7c-9b53-97d8c6c95a89"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8056283366719313`*^9, 3.805628343322137*^9}, 
   3.8056284030454073`*^9, {3.8056284997553153`*^9, 3.805628505497192*^9}, 
   3.805641615855567*^9, 3.805649662644958*^9, 3.8056499678110313`*^9, 
   3.8056577642470264`*^9, 3.8250063155476637`*^9, 3.8250065387511215`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"5cfef97a-bdb6-45d2-8bda-0a3c725f071e"]
}, Open  ]],

Cell["O bien:", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.805641380808816*^9, 
  3.8056413853368196`*^9}},ExpressionUUID->"9c9ee224-7c54-4349-80b5-\
6ce7bd0c355a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ProductoCola", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Producto_", ":", "1"}]}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "\[InvisibleSpace]", "11"}], ",", 
    RowBox[{"Producto", "*", "2"}], "\[InvisibleSpace]", ",", 
    RowBox[{"ProductoCola", "[", 
     RowBox[{
      RowBox[{"n", "-", "1"}], ",", 
      RowBox[{"Producto", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "n"}], "-", "31"}], ")"}]}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8048494062829065`*^9, 3.804849425237215*^9}, {
   3.804849720401948*^9, 3.8048497205385804`*^9}, 3.804850042602749*^9, {
   3.805628364172349*^9, 3.8056283722606974`*^9}, {3.8056413432355585`*^9, 
   3.805641343787655*^9}, {3.8056413947071447`*^9, 3.8056414180468693`*^9}, {
   3.8056414609518275`*^9, 3.8056415945274734`*^9}, {3.80564162847894*^9, 
   3.805641726040655*^9}, {3.8056419170919456`*^9, 3.805641949874304*^9}, {
   3.805642100128742*^9, 3.805642104192935*^9}, 3.8056421392580996`*^9, {
   3.805642184695599*^9, 3.8056422082287254`*^9}, {3.8056496702979994`*^9, 
   3.8056496975071716`*^9}, {3.8056499782965636`*^9, 3.805650030916727*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"05e9ce42-5eec-4686-8002-b61a42c56a21"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ProductoCola", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Product", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "i"}], "-", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"n", "-", "10"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "11", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
   3.8056284986683397`*^9, 3.8056284988604727`*^9}, {3.8056416122845974`*^9, 
   3.805641612819413*^9}, 3.805641951773473*^9, 3.805642214326934*^9, 
   3.805649719959201*^9, {3.805649758148385*^9, 3.8056497604001317`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"63f24f95-b673-4882-b762-ee8c94ddf6d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.80564194575523*^9, 3.8056419573708916`*^9}, 
   3.8056421069764276`*^9, 3.805642144005604*^9, {3.805642197037713*^9, 
   3.8056422151553845`*^9}, {3.805649716997225*^9, 3.8056497211254525`*^9}, 
   3.805650037780265*^9, 3.805657837876343*^9, 3.8250063202711625`*^9, 
   3.8250065433612456`*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"d43da97f-1688-4ef1-80d0-4f6782da0723"]
}, Open  ]],

Cell["Parte 1.5.5", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494974905844`*^9}, {
  3.8048496834723682`*^9, 3.8048496839371257`*^9}, {3.8048499825611305`*^9, 
  3.8048499828503895`*^9}, {3.806850841791685*^9, 
  3.8068508448549547`*^9}},ExpressionUUID->"a0890de3-24f1-4fd7-ae1a-\
6d1ee16e0e1c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ProductoCola", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "PC", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"PC", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"Cont_", ":", "5"}], ",", "Producto_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "\[InvisibleSpace]", "5"}], ",", 
        "\[InvisibleSpace]", "2187", "\[InvisibleSpace]\[InvisibleSpace]", 
        ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Cont", "\[Equal]", "m"}], ",", "Producto", ",", 
          RowBox[{"PC", "[", 
           RowBox[{"m", ",", 
            RowBox[{"Cont", "+", "1"}], ",", 
            RowBox[{"Producto", "*", 
             RowBox[{"(", 
              FractionBox[
               SuperscriptBox["3", 
                RowBox[{"Cont", "+", "5"}]], 
               RowBox[{"Cont", "+", "5"}]], ")"}]}]}], "\[InvisibleSpace]", 
           "]"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"PC", "[", 
      RowBox[{"n", ",", "2187"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8048494062829065`*^9, 3.804849425237215*^9}, {
   3.804849720401948*^9, 3.8048497205385804`*^9}, 3.804850042602749*^9, {
   3.805628364172349*^9, 3.8056283722606974`*^9}, {3.8056413432355585`*^9, 
   3.805641343787655*^9}, {3.8056413947071447`*^9, 3.8056414180468693`*^9}, {
   3.8056414609518275`*^9, 3.8056415945274734`*^9}, {3.8056495271712437`*^9, 
   3.8056495879636745`*^9}, {3.8056497827927465`*^9, 
   3.8056498201838036`*^9}, {3.8056498994837084`*^9, 3.805649955887336*^9}, {
   3.8056500961384277`*^9, 3.8056501652474594`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"85827c86-cd98-409e-b089-0884a828d775"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ProductoCola", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Product", "[", 
     RowBox[{
      FractionBox[
       SuperscriptBox["3", 
        RowBox[{"i", "+", "1"}]], 
       RowBox[{"i", "+", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "8", ",", 
        RowBox[{"n", "+", "3"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5", ",", "24"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
   3.8056284986683397`*^9, 3.8056284988604727`*^9}, {3.8056416122845974`*^9, 
   3.805641612819413*^9}, 3.805641951773473*^9, 3.805642214326934*^9, 
   3.805649719959201*^9, {3.805649758148385*^9, 3.8056497604001317`*^9}, {
   3.805650075277715*^9, 3.805650077689042*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"95c54913-b5bf-40bf-8ba1-1bc3487cf1a8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8056283366719313`*^9, 3.805628343322137*^9}, 
   3.8056284030454073`*^9, {3.8056284997553153`*^9, 3.805628505497192*^9}, 
   3.805641615855567*^9, 3.805649662644958*^9, 3.8056499678110313`*^9, 
   3.8056501725277734`*^9, 3.805657874941166*^9, 3.825006325502922*^9, 
   3.825006550952938*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"cc96a84c-dc54-498f-9d8b-a361a246990b"]
}, Open  ]],

Cell["O bien:", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.805641380808816*^9, 
  3.8056413853368196`*^9}},ExpressionUUID->"ce60c7dd-03c0-4399-9ac5-\
2d1e7e524111"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ProductoCola", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Producto_", ":", "1"}]}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "\[InvisibleSpace]", "5"}], ",", 
    RowBox[{"Producto", "*", "2187"}], "\[InvisibleSpace]", ",", 
    RowBox[{"ProductoCola", "[", 
     RowBox[{
      RowBox[{"n", "-", "1"}], ",", 
      RowBox[{"Producto", "*", 
       RowBox[{"(", 
        FractionBox[
         SuperscriptBox["3", 
          RowBox[{"n", "+", "4"}]], 
         RowBox[{"n", "+", "4"}]], ")"}]}]}], "\[InvisibleSpace]", "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8048494062829065`*^9, 3.804849425237215*^9}, {
   3.804849720401948*^9, 3.8048497205385804`*^9}, 3.804850042602749*^9, {
   3.805628364172349*^9, 3.8056283722606974`*^9}, {3.8056413432355585`*^9, 
   3.805641343787655*^9}, {3.8056413947071447`*^9, 3.8056414180468693`*^9}, {
   3.8056414609518275`*^9, 3.8056415945274734`*^9}, {3.80564162847894*^9, 
   3.805641726040655*^9}, {3.8056419170919456`*^9, 3.805641949874304*^9}, {
   3.805642100128742*^9, 3.805642104192935*^9}, 3.8056421392580996`*^9, {
   3.805642184695599*^9, 3.8056422082287254`*^9}, {3.8056496702979994`*^9, 
   3.8056496975071716`*^9}, {3.8056499782965636`*^9, 3.805650030916727*^9}, {
   3.805650185203005*^9, 3.8056501985618606`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"e5c25e62-448c-4a2e-8994-677bc6e2cee4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ProductoCola", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Product", "[", 
     RowBox[{
      FractionBox[
       SuperscriptBox["3", 
        RowBox[{"i", "+", "1"}]], 
       RowBox[{"i", "+", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "8", ",", 
        RowBox[{"n", "+", "3"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5", ",", "24"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
   3.8056284986683397`*^9, 3.8056284988604727`*^9}, {3.8056416122845974`*^9, 
   3.805641612819413*^9}, 3.805641951773473*^9, 3.805642214326934*^9, 
   3.805649719959201*^9, {3.805649758148385*^9, 3.8056497604001317`*^9}, {
   3.805650075277715*^9, 3.805650077689042*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"ce37ef35-f474-457f-aad2-449d6003363d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.80564194575523*^9, 3.8056419573708916`*^9}, 
   3.8056421069764276`*^9, 3.805642144005604*^9, {3.805642197037713*^9, 
   3.8056422151553845`*^9}, {3.805649716997225*^9, 3.8056497211254525`*^9}, 
   3.805650037780265*^9, 3.805650208143386*^9, 3.805657978199604*^9, 
   3.8250063303162937`*^9, 3.8250065562365313`*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"54928bc7-ac3d-4716-b32d-0ecbbd9cac27"]
}, Open  ]],

Cell["Parte 1.5.6", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494974905844`*^9}, {
  3.8048496834723682`*^9, 3.8048496839371257`*^9}, {3.8048499825611305`*^9, 
  3.8048499828503895`*^9}, {3.8056288215023527`*^9, 3.8056288229462366`*^9}, {
  3.8068508648319135`*^9, 
  3.806850867926925*^9}},ExpressionUUID->"ce9e988b-bcb3-49c9-a39d-\
4bead5e46821"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SumaProductoCola", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Suma_", ":", "0"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "ProductoCola", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"ProductoCola", "[", 
       RowBox[{"i_", ",", 
        RowBox[{"Producto_", ":", "1"}]}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"i", "\[Equal]", "1"}], "||", 
         RowBox[{"i", "\[Equal]", "2"}]}], ",", "1", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"i", "\[Equal]", "3"}], ",", 
          RowBox[{"-", "Producto"}], ",", 
          RowBox[{"ProductoCola", "[", 
           RowBox[{
            RowBox[{"i", "-", "1"}], ",", 
            RowBox[{"Producto", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "i"}], "-", "7"}], ")"}]}]}], "]"}]}], "]"}]}], 
       "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"n", "\[Equal]", "0"}], ",", 
       RowBox[{"1", "+", "Suma"}], ",", 
       RowBox[{"SumaProductoCola", "[", 
        RowBox[{
         RowBox[{"n", "-", "1"}], ",", 
         RowBox[{"Suma", "+", 
          RowBox[{
           RowBox[{"ProductoCola", "[", 
            RowBox[{"n", "+", "1"}], "]"}], 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}]}], "]"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8056289587231874`*^9, 3.805629037982701*^9}, {
  3.8056290770714436`*^9, 3.805629196715017*^9}, {3.805629327310229*^9, 
  3.8056294252457795`*^9}, {3.805629455499717*^9, 3.805629556213519*^9}, {
  3.805640055281762*^9, 3.8056400556630945`*^9}, {3.8056409617232924`*^9, 
  3.8056409791542845`*^9}, {3.8056412071180105`*^9, 3.8056412138460894`*^9}, {
  3.805650237204792*^9, 3.8056504432983007`*^9}, {3.805650498801405*^9, 
  3.805650690574441*^9}, {3.8056507226821747`*^9, 3.805650749521866*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"a47de252-3bb3-40e6-9566-42cf1be40893"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SumaProductoCola", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "j"}], "-", "5"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "2", ",", 
           RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}], "i"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "19"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8056282869327545`*^9, 3.805628335676668*^9}, {
   3.8056284325018735`*^9, 3.805628483496705*^9}, {3.805628518986335*^9, 
   3.8056285196590095`*^9}, {3.805628556947528*^9, 3.8056286289696045`*^9}, {
   3.8056287289730453`*^9, 3.805628780777239*^9}, {3.805628860386781*^9, 
   3.80562894824238*^9}, {3.805629563045785*^9, 3.805629564640498*^9}, {
   3.8056297317645855`*^9, 3.80562974732858*^9}, 3.8056411923931427`*^9, {
   3.8056412479520097`*^9, 3.8056412714447308`*^9}, 3.805650271531521*^9},
 CellLabel->"In[28]:=",ExpressionUUID->"b35be171-40b1-49d1-ab8f-b6af391ef7f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.805629565794572*^9, 3.8056297481438828`*^9, 
  3.8056408671537256`*^9, 3.805640985766097*^9, 3.8056411942537313`*^9, 
  3.8056412722600737`*^9, 3.8056507020811443`*^9, 3.8056507552701797`*^9, 
  3.8056580258348274`*^9, 3.8250063362063403`*^9, 3.8250065637849045`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"11dcf024-3bb5-4f44-b6e4-f8d476255dd0"]
}, Open  ]],

Cell["1.5.8", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.806850883919862*^9, 
  3.8068509119689207`*^9}},ExpressionUUID->"175c736d-749e-4762-9d67-\
fce6e1a06fea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RecurrenciaPila", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "5"}], ",", "2", ",", 
    RowBox[{
     RowBox[{"5", 
      RowBox[{"RecurrenciaPila", "[", 
       RowBox[{"n", "-", "1"}], "]"}]}], "+", 
     RowBox[{"2", "n"}], "-", 
     SqrtBox["2"]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8054851403968897`*^9, 3.8054852018162518`*^9}, 
   3.805485247497637*^9, {3.8056511672417917`*^9, 3.8056511880704613`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"26d05328-da51-4244-a0ba-c982b2a00e6e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RecurrenciaCola", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "RecurrenciaAuxiliar", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"RecurrenciaAuxiliar", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"Cont_", ":", "5"}], ",", "a_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "5"}], ",", "2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Cont", "\[Equal]", "m"}], ",", "a", ",", 
          RowBox[{"RecurrenciaAuxiliar", "[", 
           RowBox[{"m", ",", 
            RowBox[{"Cont", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"5", "a"}], "+", 
             RowBox[{"2", 
              RowBox[{"(", 
               RowBox[{"Cont", "+", "1"}], ")"}]}], "-", 
             SqrtBox["2"]}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"RecurrenciaAuxiliar", "[", 
      RowBox[{"n", ",", "2"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.805481124333808*^9, 3.8054813168029213`*^9}, {
   3.8054814008667803`*^9, 3.8054814562562175`*^9}, {3.8054818484514065`*^9, 
   3.8054818776800747`*^9}, 3.8054820638799915`*^9, {3.8054846337662997`*^9, 
   3.8054846460208745`*^9}, {3.8054848287335787`*^9, 
   3.8054848422336917`*^9}, {3.8056512003088193`*^9, 3.8056512394229994`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"717061cc-71fe-49d2-890b-8be15af9eeb7"],

Cell["Verificaci\[OAcute]n:", "Text",
 CellChangeTimes->{{3.8054847162938175`*^9, 
  3.805484732703754*^9}},ExpressionUUID->"bcf5a59c-4267-4561-9560-\
5ba64d24da94"],

Cell[BoxData[
 RowBox[{"Clear", "[", "a", "]"}]], "Input",ExpressionUUID->"db5b7d58-6a2c-43cb-83d7-ee7b963afc4e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"5", 
    RowBox[{"a", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}], "+", 
   RowBox[{"2", "n"}], "-", 
   SqrtBox["2"]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "5", "]"}], "=", "2"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8054846584442606`*^9, 3.805484690397395*^9}, {
  3.805651255828519*^9, 3.80565127109052*^9}, {3.8250063925298567`*^9, 
  3.8250064266193075`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"5b921f29-3fb0-4ec1-baf5-7932de567004"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "i", "]"}], "\[Equal]", 
    RowBox[{"RecurrenciaCola", "[", "i", "]"}], "\[Equal]", 
    RowBox[{"RecurrenciaPila", "[", "i", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5", ",", "34"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8054810705630627`*^9, 3.805481097161087*^9}, {
   3.8054813313838053`*^9, 3.805481347372099*^9}, 3.8054846972474923`*^9, {
   3.805484786296163*^9, 3.8054848167505274`*^9}, {3.8054852119730434`*^9, 
   3.805485228199815*^9}, {3.8055749815512333`*^9, 3.805575021973198*^9}, {
   3.8056512993669767`*^9, 3.805651300195948*^9}, {3.8056513747304783`*^9, 
   3.8056513822160015`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"aeddba22-9dfd-45ee-8a96-16f7e2efb6ad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.805481097720769*^9, {3.805481334571675*^9, 3.8054813486148224`*^9}, {
   3.8054814395052204`*^9, 3.8054814623957825`*^9}, 3.805481775213706*^9, {
   3.805481854284994*^9, 3.8054818683943033`*^9}, 3.8054819026648455`*^9, 
   3.8054820674228487`*^9, 3.8054846983522267`*^9, {3.805484807629317*^9, 
   3.8054848184026055`*^9}, 3.8054848517463384`*^9, {3.805485229121478*^9, 
   3.8054852526795883`*^9}, {3.8056512867220554`*^9, 3.8056513006389146`*^9}, 
   3.805651385688917*^9, 3.805658220443654*^9, {3.8250063457315054`*^9, 
   3.8250063503586144`*^9}, 3.8250065766460857`*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"d81f2180-e74a-4ca9-9abe-c85a818037bb"]
}, Open  ]],

Cell["1.5.9", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8056510515940638`*^9, 3.805651051860174*^9}, {3.806850922547078*^9, 
  3.806850924183403*^9}},ExpressionUUID->"d5605970-67ac-4b2a-915c-\
f724b60c5f9a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RecurrenciaPila", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "1"}], ",", 
    RowBox[{"-", "10"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"n", "\[Equal]", "2"}], ",", 
      RowBox[{"-", "19"}], ",", 
      RowBox[{
       RowBox[{"RecurrenciaPila", "[", 
        RowBox[{"n", "-", "1"}], "]"}], "+", 
       RowBox[{"6", 
        RowBox[{"RecurrenciaPila", "[", 
         RowBox[{"n", "-", "2"}], "]"}]}]}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8054851403968897`*^9, 3.8054852018162518`*^9}, 
   3.805485247497637*^9, {3.805572020323053*^9, 3.805572138340126*^9}, {
   3.805651475481463*^9, 3.80565152300298*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"ac1e4dd6-8f40-4ffd-97e4-a83bf3afb5a2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RecurrenciaCola", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "RecurrenciaAuxiliar", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"RecurrenciaAuxiliar", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"Cont_", ":", "2"}], ",", "a1_", ",", "a2_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "1"}], ",", 
        RowBox[{"-", "10"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"m", "\[Equal]", "2"}], ",", 
          RowBox[{"-", "19"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"Cont", "\[Equal]", "m"}], ",", "a2", ",", 
            RowBox[{"RecurrenciaAuxiliar", "[", 
             RowBox[{"m", ",", 
              RowBox[{"Cont", "+", "1"}], ",", "a2", ",", 
              RowBox[{"a2", "+", 
               RowBox[{"6", "a1"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
     ";", 
     RowBox[{"RecurrenciaAuxiliar", "[", 
      RowBox[{"n", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "19"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.805481124333808*^9, 3.8054813168029213`*^9}, {
   3.8054814008667803`*^9, 3.8054814562562175`*^9}, {3.8054818484514065`*^9, 
   3.8054818776800747`*^9}, 3.8054820638799915`*^9, {3.8054846337662997`*^9, 
   3.8054846460208745`*^9}, {3.8054848287335787`*^9, 
   3.8054848422336917`*^9}, {3.8055723278013606`*^9, 
   3.8055724736956377`*^9}, {3.805572518040049*^9, 3.80557259150042*^9}, {
   3.8055732106049447`*^9, 3.805573220244421*^9}, {3.805651532838579*^9, 
   3.805651629445111*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"88c718e1-dcc1-49b6-b10a-fca36c745dea"],

Cell["Verificaci\[OAcute]n:", "Text",
 CellChangeTimes->{{3.8054847162938175`*^9, 
  3.805484732703754*^9}},ExpressionUUID->"8c8157ff-4329-4d0a-8bf6-\
a6cd3254cc7c"],

Cell[BoxData[
 RowBox[{"Clear", "[", "a", "]"}]], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"3fb089af-c9fd-4552-90e3-382c80d1835c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"n", "-", "1"}], "]"}], "+", 
   RowBox[{"6", 
    RowBox[{"a", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", 
   RowBox[{"-", "10"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "2", "]"}], "=", 
   RowBox[{"-", "19"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8054846584442606`*^9, 3.805484690397395*^9}, {
  3.805572194698176*^9, 3.805572262437648*^9}, {3.805573131027955*^9, 
  3.805573132104418*^9}, {3.805651633118766*^9, 3.8056516579947643`*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"f49f69b3-f1d1-4e1b-b570-680df191cf8d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "i", "]"}], "\[Equal]", 
    RowBox[{"RecurrenciaCola", "[", "i", "]"}], "\[Equal]", 
    RowBox[{"RecurrenciaPila", "[", "i", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8054810705630627`*^9, 3.805481097161087*^9}, {
   3.8054813313838053`*^9, 3.805481347372099*^9}, 3.8054846972474923`*^9, {
   3.805484786296163*^9, 3.8054848167505274`*^9}, {3.8054852119730434`*^9, 
   3.805485228199815*^9}, {3.8055722678525844`*^9, 3.805572268366393*^9}, {
   3.805572308949625*^9, 3.805572314526447*^9}, {3.8055726014032664`*^9, 
   3.805572601929884*^9}, {3.8055728998223963`*^9, 3.8055729003504057`*^9}, {
   3.8055749600296893`*^9, 3.8055749658555536`*^9}, {3.805575040825985*^9, 
   3.8055750438242188`*^9}, {3.8056516882470374`*^9, 3.805651711780283*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"65b983a6-c4bc-41ab-b8de-e901092d149e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.805481097720769*^9, {3.805481334571675*^9, 3.8054813486148224`*^9}, {
   3.8054814395052204`*^9, 3.8054814623957825`*^9}, 3.805481775213706*^9, {
   3.805481854284994*^9, 3.8054818683943033`*^9}, 3.8054819026648455`*^9, 
   3.8054820674228487`*^9, 3.8054846983522267`*^9, {3.805484807629317*^9, 
   3.8054848184026055`*^9}, 3.8054848517463384`*^9, {3.805485229121478*^9, 
   3.8054852526795883`*^9}, {3.8055723118833156`*^9, 3.8055723149744387`*^9}, 
   3.805572603161338*^9, 3.8055727105761814`*^9, 3.8055729008512125`*^9, 
   3.8055732481246758`*^9, 3.8055749579837527`*^9, {3.805575032849887*^9, 
   3.8055750483097296`*^9}, {3.805651673381379*^9, 3.805651689208031*^9}, 
   3.8056517350058975`*^9, 3.8056583102938576`*^9, 3.8250063633637757`*^9, 
   3.825006593403676*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"7377e1d7-be38-486f-b53f-354e85957cb0"]
}, Open  ]],

Cell["1.5.10", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.805651053661484*^9, 3.805651053925456*^9}, {3.806850932624346*^9, 
  3.806850934815551*^9}},ExpressionUUID->"593ad8d6-1614-4d07-96c9-\
ef1c4f85ef58"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RecurrenciaPila", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "1"}], ",", "1", ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"n", "\[Equal]", "2"}], ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"n", "\[Equal]", "3"}], ",", 
        RadicalBox["2", "5"], ",", 
        RowBox[{
         RowBox[{"12", 
          RowBox[{"RecurrenciaPila", "[", 
           RowBox[{"n", "-", "1"}], "]"}]}], "-", 
         RowBox[{"36", 
          RowBox[{"RecurrenciaPila", "[", 
           RowBox[{"n", "-", "2"}], "]"}]}], "+", 
         RowBox[{"RecurrenciaPila", "[", 
          RowBox[{"n", "-", "3"}], "]"}]}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8054851403968897`*^9, 3.8054852018162518`*^9}, 
   3.805485247497637*^9, {3.805572020323053*^9, 3.805572138340126*^9}, {
   3.8056517921495895`*^9, 3.805651831571162*^9}, {3.8056520701990895`*^9, 
   3.805652074594321*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"53107b9c-d210-4ff4-bb2c-13cb55a7b0bd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RecurrenciaCola", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "RecurrenciaAuxiliar", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"RecurrenciaAuxiliar", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"Cont_", ":", "3"}], ",", "a1_", ",", "a2_", ",", "a3_"}], 
       "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "1"}], ",", "1", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"m", "\[Equal]", "2"}], ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"m", "\[Equal]", "3"}], ",", 
            RadicalBox["2", "5"], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"Cont", "\[Equal]", "m"}], ",", "a3", ",", 
              RowBox[{"RecurrenciaAuxiliar", "[", 
               RowBox[{"m", ",", 
                RowBox[{"Cont", "+", "1"}], ",", "a2", ",", "a3", ",", 
                RowBox[{
                 RowBox[{"12", "a3"}], "-", 
                 RowBox[{"36", "a2"}], "+", "a1"}]}], "]"}]}], "]"}]}], 
           "]"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"RecurrenciaAuxiliar", "[", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", 
       RadicalBox["2", "5"]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.805481124333808*^9, 3.8054813168029213`*^9}, {
   3.8054814008667803`*^9, 3.8054814562562175`*^9}, {3.8054818484514065`*^9, 
   3.8054818776800747`*^9}, 3.8054820638799915`*^9, {3.8054846337662997`*^9, 
   3.8054846460208745`*^9}, {3.8054848287335787`*^9, 
   3.8054848422336917`*^9}, {3.8055723278013606`*^9, 
   3.8055724736956377`*^9}, {3.805572518040049*^9, 3.80557259150042*^9}, {
   3.8055732106049447`*^9, 3.805573220244421*^9}, {3.8056518410525928`*^9, 
   3.805651948733863*^9}, {3.805652231789789*^9, 3.8056522377502794`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"008cbe44-b727-4a3b-8a33-3abe8ac59c54"],

Cell["Verificaci\[OAcute]n:", "Text",
 CellChangeTimes->{{3.8054847162938175`*^9, 
  3.805484732703754*^9}},ExpressionUUID->"74becf0f-6045-4643-bd2e-\
cacf74020ef8"],

Cell[BoxData[
 RowBox[{"Clear", "[", "a", "]"}]], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"3dd72969-e66e-4595-bed7-edeb7aa65f26"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"12", 
    RowBox[{"a", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}], "-", 
   RowBox[{"36", 
    RowBox[{"a", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}], "+", 
   RowBox[{"a", "[", 
    RowBox[{"n", "-", "3"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "2", "]"}], "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "3", "]"}], "=", 
   RadicalBox["2", "5"]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8054846584442606`*^9, 3.805484690397395*^9}, {
  3.805572194698176*^9, 3.805572262437648*^9}, {3.805573131027955*^9, 
  3.805573132104418*^9}, {3.8056519536277294`*^9, 3.8056520019633923`*^9}, {
  3.805652321582279*^9, 3.805652322972437*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"9b307b6b-a438-4850-abb9-3ebea572c976"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "i", "]"}], "\[Equal]", 
    RowBox[{"RecurrenciaCola", "[", "i", "]"}], "\[Equal]", 
    RowBox[{"RecurrenciaPila", "[", "i", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8054810705630627`*^9, 3.805481097161087*^9}, {
   3.8054813313838053`*^9, 3.805481347372099*^9}, 3.8054846972474923`*^9, {
   3.805484786296163*^9, 3.8054848167505274`*^9}, {3.8054852119730434`*^9, 
   3.805485228199815*^9}, {3.8055722678525844`*^9, 3.805572268366393*^9}, {
   3.805572308949625*^9, 3.805572314526447*^9}, {3.8055726014032664`*^9, 
   3.805572601929884*^9}, {3.8055728998223963`*^9, 3.8055729003504057`*^9}, {
   3.8055749600296893`*^9, 3.8055749658555536`*^9}, {3.805575040825985*^9, 
   3.8055750438242188`*^9}, {3.805652057651429*^9, 3.8056520604421215`*^9}, 
   3.8056521523752894`*^9, {3.805652329362796*^9, 3.805652354026595*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"f0dfea6f-f09e-4394-91c2-0be5e9349295"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8056522623052697`*^9, {3.8056523258699684`*^9, 3.805652355385919*^9}, 
   3.8056584546982536`*^9, 3.825006607220685*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"8cd82c16-6db0-4b63-810d-49ad47478e8e"]
}, Open  ]],

Cell["1.5.11", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.805651055703265*^9, 3.805651055928522*^9}, {3.8068509438574047`*^9, 
  3.806850945590702*^9}},ExpressionUUID->"04774032-e63c-4edd-8a26-\
9892a1dc68d5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RecurrenciaPila", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "2"}], ",", "1", ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"n", "\[Equal]", "3"}], ",", "2", ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"n", "\[Equal]", "4"}], ",", "3", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"n", "\[Equal]", "5"}], ",", "4", ",", 
          RowBox[{
           RowBox[{"1", "/", "9"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"6", 
              RowBox[{"RecurrenciaPila", "[", 
               RowBox[{"n", "-", "1"}], "]"}]}], "-", 
             RowBox[{"RecurrenciaPila", "[", 
              RowBox[{"n", "-", "2"}], "]"}], "+", 
             RowBox[{"RecurrenciaPila", "[", 
              RowBox[{"n", "-", "3"}], "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"RecurrenciaPila", "[", 
               RowBox[{"n", "-", "4"}], "]"}]}]}], ")"}]}]}], "]"}]}], 
       "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8054851403968897`*^9, 3.8054852018162518`*^9}, 
   3.805485247497637*^9, {3.805572020323053*^9, 3.805572138340126*^9}, {
   3.8056523806518345`*^9, 3.8056524323168817`*^9}, {3.805652593846014*^9, 
   3.805652602602332*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"d8cd259f-1a25-45e5-9028-fa810623feda"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RecurrenciaCola", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "RecurrenciaAuxiliar", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"RecurrenciaAuxiliar", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"Cont_", ":", "5"}], ",", "a2_", ",", "a3_", ",", "a4_", ",", 
        "a5_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "2"}], ",", "1", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"m", "\[Equal]", "3"}], ",", "2", ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"m", "\[Equal]", "4"}], ",", "3", ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "5"}], ",", "4", ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Cont", "\[Equal]", "m"}], ",", "a5", ",", 
                RowBox[{"RecurrenciaAuxiliar", "[", 
                 RowBox[{"m", ",", 
                  RowBox[{"Cont", "+", "1"}], ",", "a3", ",", "a4", ",", "a5",
                   ",", 
                  RowBox[{
                   RowBox[{"1", "/", "9"}], 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"6", "a5"}], "-", "a4", "+", "a3", "-", 
                    RowBox[{"2", "a2"}]}], ")"}]}]}], "]"}]}], "]"}]}], 
             "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"RecurrenciaAuxiliar", "[", 
      RowBox[{"n", ",", "1", ",", "2", ",", "3", ",", "4"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.805481124333808*^9, 3.8054813168029213`*^9}, {
   3.8054814008667803`*^9, 3.8054814562562175`*^9}, {3.8054818484514065`*^9, 
   3.8054818776800747`*^9}, 3.8054820638799915`*^9, {3.8054846337662997`*^9, 
   3.8054846460208745`*^9}, {3.8054848287335787`*^9, 
   3.8054848422336917`*^9}, {3.8055723278013606`*^9, 
   3.8055724736956377`*^9}, {3.805572518040049*^9, 3.80557259150042*^9}, {
   3.8055732106049447`*^9, 3.805573220244421*^9}, {3.805652438265125*^9, 
   3.805652572876988*^9}, {3.8056526118460937`*^9, 3.8056526187777348`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"7aed81f4-043c-4c72-a4e4-e46af824dfe7"],

Cell["Verificaci\[OAcute]n:", "Text",
 CellChangeTimes->{{3.8054847162938175`*^9, 
  3.805484732703754*^9}},ExpressionUUID->"d7360ac2-7f2a-45f0-98e1-\
c4e4cb4c1d7b"],

Cell[BoxData[
 RowBox[{"Clear", "[", "a", "]"}]], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"791610d1-1512-4975-b5a4-70f2a2562482"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"1", "/", "9"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"6", 
      RowBox[{"a", "[", 
       RowBox[{"n", "-", "1"}], "]"}]}], "-", 
     RowBox[{"a", "[", 
      RowBox[{"n", "-", "2"}], "]"}], "+", 
     RowBox[{"a", "[", 
      RowBox[{"n", "-", "3"}], "]"}], "-", 
     RowBox[{"2", 
      RowBox[{"a", "[", 
       RowBox[{"n", "-", "4"}], "]"}]}]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "2", "]"}], "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "3", "]"}], "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "4", "]"}], "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "5", "]"}], "=", "4"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8054846584442606`*^9, 3.805484690397395*^9}, {
  3.805572194698176*^9, 3.805572262437648*^9}, {3.805573131027955*^9, 
  3.805573132104418*^9}, {3.805652626022825*^9, 3.805652666276313*^9}, {
  3.8056527180284557`*^9, 3.80565272715676*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"556dc072-ccd6-46ed-bba3-0fa727d7dec7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "i", "]"}], "\[Equal]", 
    RowBox[{"RecurrenciaCola", "[", "i", "]"}], "\[Equal]", 
    RowBox[{"RecurrenciaPila", "[", "i", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8054810705630627`*^9, 3.805481097161087*^9}, {
   3.8054813313838053`*^9, 3.805481347372099*^9}, 3.8054846972474923`*^9, {
   3.805484786296163*^9, 3.8054848167505274`*^9}, {3.8054852119730434`*^9, 
   3.805485228199815*^9}, {3.8055722678525844`*^9, 3.805572268366393*^9}, {
   3.805572308949625*^9, 3.805572314526447*^9}, {3.8055726014032664`*^9, 
   3.805572601929884*^9}, {3.8055728998223963`*^9, 3.8055729003504057`*^9}, {
   3.8055749600296893`*^9, 3.8055749658555536`*^9}, {3.805575040825985*^9, 
   3.8055750438242188`*^9}, {3.8056527650514812`*^9, 3.8056527652589283`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"64cdf56d-8368-4f4b-99d6-99cc242fac45"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.805481097720769*^9, {3.805481334571675*^9, 3.8054813486148224`*^9}, {
   3.8054814395052204`*^9, 3.8054814623957825`*^9}, 3.805481775213706*^9, {
   3.805481854284994*^9, 3.8054818683943033`*^9}, 3.8054819026648455`*^9, 
   3.8054820674228487`*^9, 3.8054846983522267`*^9, {3.805484807629317*^9, 
   3.8054848184026055`*^9}, 3.8054848517463384`*^9, {3.805485229121478*^9, 
   3.8054852526795883`*^9}, {3.8055723118833156`*^9, 3.8055723149744387`*^9}, 
   3.805572603161338*^9, 3.8055727105761814`*^9, 3.8055729008512125`*^9, 
   3.8055732481246758`*^9, 3.8055749579837527`*^9, {3.805575032849887*^9, 
   3.8055750483097296`*^9}, {3.805652762586971*^9, 3.8056527661894393`*^9}, 
   3.8056585793453026`*^9, 3.8250066249951572`*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"e0215f66-f239-49af-8b17-921f1c1b833b"]
}, Open  ]],

Cell["1.5.12", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8068509585533347`*^9, 
  3.8068509601590652`*^9}},ExpressionUUID->"06f9979d-1c1a-45d9-be64-\
36b032ff4338"],

Cell["\<\
Sea a[n] la cantidad de dinero ahorrado despu\[EAcute]s de n meses, entonces:\
\>", "Text",
 CellChangeTimes->{{3.8056529461826425`*^9, 
  3.8056529810030727`*^9}},ExpressionUUID->"983b7773-0ab4-477e-bc3d-\
acefed6af1a8"],

Cell[BoxData[
 RowBox[{"Clear", "[", "a", "]"}]], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"9ddccdea-5d43-4788-b276-a83f2ceb8ec1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{"1.05", 
   RowBox[{"a", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "0", "]"}], "=", "200"}], ";"}]}], "Input",
 CellChangeTimes->{{3.805652988390483*^9, 3.8056530256502447`*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"5d356d0c-a6d7-4b40-b16e-d9712d8c8458"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ahorro", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "0"}], ",", "200", ",", 
    RowBox[{"1.05", 
     RowBox[{"Ahorro", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.805653224555461*^9, 3.8056532264753118`*^9}, {
  3.805653264733179*^9, 3.8056532834834704`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"dd327f81-b058-402b-91d3-1813ff4dc46a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ahorro", "[", "12", "]"}]], "Input",
 CellLabel->"In[62]:=",ExpressionUUID->"f4ed35f6-1011-421e-a410-5bc6d012aaf8"],

Cell[BoxData["359.17126520442605`"], "Output",
 CellChangeTimes->{{3.8056532879105253`*^9, 3.8056532983123226`*^9}, 
   3.82500663381273*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"f344d514-8810-425a-bcf0-6c05926e16df"]
}, Open  ]],

Cell["O bien:", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.805641380808816*^9, 
  3.8056413853368196`*^9}},ExpressionUUID->"3372efcb-fe2d-4223-98b9-\
a4a59375f3b0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ahorro", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"ahorro_", ":", "1"}]}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "0"}], ",", 
    RowBox[{"ahorro", "*", "200"}], ",", 
    RowBox[{"Ahorro", "[", 
     RowBox[{
      RowBox[{"n", "-", "1"}], ",", 
      RowBox[{"1.05", "ahorro"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.805653031099614*^9, 3.8056531440664377`*^9}, {
  3.805653182051788*^9, 3.8056531833313427`*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"172ef5a5-f599-44c4-8d34-2328c91b3aa6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ahorro", "[", "12", "]"}]], "Input",
 CellChangeTimes->{{3.805653132178507*^9, 3.805653135601661*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"4d4a3af1-bac4-42d1-8580-03341adab95c"],

Cell[BoxData["359.17126520442605`"], "Output",
 CellChangeTimes->{{3.8056531360977135`*^9, 3.8056531469690747`*^9}, 
   3.80565320063754*^9, 3.8250066385346527`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"faa776c1-0f6c-41ef-81be-dfa3cbda8de1"]
}, Open  ]],

Cell["1.5.13", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8056533338981194`*^9, 
  3.80565333432498*^9}, {3.8068509709294453`*^9, 
  3.8068509727608414`*^9}},ExpressionUUID->"e41ecd74-10d4-4119-abed-\
d96b94013cde"],

Cell[BoxData[
 RowBox[{
  RowBox[{"catalan", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "CatalanCola", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CatalanCola", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"Cont_", ":", "0"}], ",", "Cn_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "0"}], ",", "1", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"m", "\[Equal]", "Cont"}], ",", "Cn", ",", 
          RowBox[{"CatalanCola", "[", 
           RowBox[{"m", ",", 
            RowBox[{"Cont", "+", "1"}], ",", 
            RowBox[{
             FractionBox[
              RowBox[{"2", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", "Cont"}], "+", "1"}], ")"}]}], 
              RowBox[{"Cont", "+", "2"}]], "Cn"}]}], "]"}]}], "]"}]}], 
       "]"}]}], ";", 
     RowBox[{"CatalanCola", "[", 
      RowBox[{"n", ",", "1"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.80565333670302*^9, 3.8056533381237373`*^9}, {
  3.8056533946038723`*^9, 3.805653493012898*^9}, {3.805653525370594*^9, 
  3.805653725973756*^9}, {3.8056539220329585`*^9, 3.805653937052103*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"cc698a2e-ec5e-4209-8a6f-f964c59693a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"catalan", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "29"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.805653733067066*^9, 3.8056537548027134`*^9}, {
   3.805653798597577*^9, 3.8056538034292*^9}, 3.8056539559233418`*^9},
 CellLabel->"In[66]:=",ExpressionUUID->"44b35dc7-2d3d-443f-8946-d09039f2ef35"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "5", ",", "14", ",", "42", ",", "132", ",", 
   "429", ",", "1430", ",", "4862", ",", "16796", ",", "58786", ",", "208012",
    ",", "742900", ",", "2674440", ",", "9694845", ",", "35357670", ",", 
   "129644790", ",", "477638700", ",", "1767263190", ",", "6564120420", ",", 
   "24466267020", ",", "91482563640", ",", "343059613650", ",", 
   "1289904147324", ",", "4861946401452", ",", "18367353072152", ",", 
   "69533550916004", ",", "263747951750360", ",", "1002242216651368"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8056537491566772`*^9, 3.805653755666456*^9}, {
   3.805653807600586*^9, 3.8056538175000525`*^9}, {3.8056539439110675`*^9, 
   3.805653957893735*^9}, 3.8250066454788322`*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"1a994061-9142-4e0d-85fe-354d32c7a21f"]
}, Open  ]],

Cell["1.5.14", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8056533338981194`*^9, 
  3.80565333432498*^9}, {3.8056540131951227`*^9, 3.805654013612009*^9}, {
  3.8068509856014843`*^9, 
  3.806850987199752*^9}},ExpressionUUID->"fd308a6a-11b3-4917-b2e7-\
1b27201b73dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mcd", "[", 
   RowBox[{"n_", ",", "m_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"m", "\[Equal]", "0"}], ",", "n", ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"n", "\[Equal]", "0"}], ",", "m", ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"n", "\[GreaterEqual]", "m"}], ",", 
        RowBox[{"mcd", "[", 
         RowBox[{
          RowBox[{"n", "-", "m"}], ",", "m"}], "]"}], ",", 
        RowBox[{"mcd", "[", 
         RowBox[{"n", ",", 
          RowBox[{"m", "-", "n"}]}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8056540537240863`*^9, 3.805654080339023*^9}, {
  3.8056541262989593`*^9, 3.80565419769913*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"d5d2afe4-635d-48f3-924a-40e441dbab45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mcd", "[", 
  RowBox[{"120", ",", "144"}], "]"}]], "Input",
 CellChangeTimes->{{3.8056542207757225`*^9, 3.8056542254331274`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"937bcb4e-a832-4f88-bd94-3c3cce547df4"],

Cell[BoxData["24"], "Output",
 CellChangeTimes->{3.8056542260555024`*^9, 3.8250066598135924`*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"82638258-3af9-4ee3-bfe8-ace398fbaab5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"mcdPasos", "[", 
   RowBox[{"n_", ",", "m_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"m", "\[Equal]", "0"}], ",", "n", ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"n", "\[Equal]", "0"}], ",", "m", ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"n", "\[GreaterEqual]", "m"}], ",", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<mcd[\>\"", ",", 
           RowBox[{"n", "-", "m"}], ",", "\"\<,\>\"", ",", "m", ",", 
           "\"\<]\>\""}], "]"}], ";", 
         RowBox[{"mcdPasos", "[", 
          RowBox[{
           RowBox[{"n", "-", "m"}], ",", "m"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<mcd[\>\"", ",", "n", ",", "\"\<,\>\"", ",", 
           RowBox[{"m", "-", "n"}], ",", "\"\<]\>\""}], "]"}], ";", 
         RowBox[{"mcdPasos", "[", 
          RowBox[{"n", ",", 
           RowBox[{"m", "-", "n"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8056542344954824`*^9, 3.805654363814508*^9}, {
   3.8056544336045923`*^9, 3.8056544479762125`*^9}, 3.805654520892661*^9},
 CellLabel->"In[69]:=",ExpressionUUID->"909514d5-7af8-4eb2-82e2-edec040d9976"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mcdPasos", "[", 
  RowBox[{"120", ",", "144"}], "]"}]], "Input",
 CellChangeTimes->{{3.805654388723801*^9, 3.8056543893376913`*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"9ff9dec2-4cdb-4ca5-b588-b1f998a2376d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"mcd[\"\>", "\[InvisibleSpace]", "120", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm["mcd[", 120, ",", 24, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056543901095376`*^9, 3.805654451037841*^9, 
  3.805654525776318*^9, 3.8250066639394712`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"52e44d3b-419c-4e22-8104-96ff9617cc35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"mcd[\"\>", "\[InvisibleSpace]", "96", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm["mcd[", 96, ",", 24, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056543901095376`*^9, 3.805654451037841*^9, 
  3.805654525776318*^9, 3.825006663942463*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"617bfea7-20f6-42e9-a1b2-a4d25b07db3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"mcd[\"\>", "\[InvisibleSpace]", "72", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm["mcd[", 72, ",", 24, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056543901095376`*^9, 3.805654451037841*^9, 
  3.805654525776318*^9, 3.8250066639449787`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"f76c9970-92d0-42b9-8781-30e309857fda"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"mcd[\"\>", "\[InvisibleSpace]", "48", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm["mcd[", 48, ",", 24, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056543901095376`*^9, 3.805654451037841*^9, 
  3.805654525776318*^9, 3.8250066639469767`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"e5a1af79-b769-40d6-a964-dc3eb445b78b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"mcd[\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm["mcd[", 24, ",", 24, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056543901095376`*^9, 3.805654451037841*^9, 
  3.805654525776318*^9, 3.8250066639479723`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"15c83711-772d-44e1-a646-53de1fefdadb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"mcd[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm["mcd[", 0, ",", 24, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8056543901095376`*^9, 3.805654451037841*^9, 
  3.805654525776318*^9, 3.8250066639489884`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[70]:=",ExpressionUUID->"e1ba2563-3d2e-44fd-b547-8e6b7b1706dc"]
}, Open  ]],

Cell[BoxData["24"], "Output",
 CellChangeTimes->{3.8056544510554943`*^9, 3.8056545257889013`*^9, 
  3.8250066639509783`*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"07ef1afb-a7bc-4b23-81b3-2845f0db7aaf"]
}, Open  ]],

Cell["1.5.15", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8056533338981194`*^9, 
  3.80565333432498*^9}, {3.8056540131951227`*^9, 3.805654013612009*^9}, {
  3.8056545743756924`*^9, 3.8056545748802624`*^9}, {3.806850998984293*^9, 
  3.806851000407874*^9}},ExpressionUUID->"25203ce2-a82e-4b4f-8c70-\
3ec74ec52543"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ackermann", "[", 
   RowBox[{"m_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"m", "\[Equal]", "0"}], ",", 
    RowBox[{"n", "+", "1"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"m", ">", "0"}], "&&", 
       RowBox[{"n", "\[Equal]", "0"}]}], ",", 
      RowBox[{"Ackermann", "[", 
       RowBox[{
        RowBox[{"m", "-", "1"}], ",", "1"}], "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"m", ">", "0"}], "&&", 
         RowBox[{"n", ">", "0"}]}], ",", 
        RowBox[{"Ackermann", "[", 
         RowBox[{
          RowBox[{"m", "-", "1"}], ",", 
          RowBox[{"Ackermann", "[", 
           RowBox[{"m", ",", 
            RowBox[{"n", "-", "1"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8050464170991135`*^9, 3.805046533531024*^9}, 
   3.8050470133388844`*^9, {3.8056546110463*^9, 3.8056546159966297`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"6f391006-e275-4a8f-bf70-9f0d53a8c498"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Ackermann", "[", 
    RowBox[{"1", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Ackermann", "[", 
    RowBox[{"2", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Ackermann", "[", 
    RowBox[{"3", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.805046603984808*^9, 3.8050466148618164`*^9}, {
  3.805046649136255*^9, 3.805046704630101*^9}, {3.8050473479399347`*^9, 
  3.8050473742477036`*^9}, {3.805047725306707*^9, 3.805047754002327*^9}, {
  3.805047893333746*^9, 3.8050479371994085`*^9}, {3.8050479936245356`*^9, 
  3.8050479944912243`*^9}, {3.805048043736391*^9, 3.805048047448288*^9}, {
  3.8050480876322103`*^9, 3.805048130828596*^9}, {3.805048166612282*^9, 
  3.8050482601932926`*^9}, {3.805048470332264*^9, 3.8050484837348948`*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"d9e86937-34b2-484a-874e-eec338690b98"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8050477329098454`*^9, 3.8050477544301834`*^9}, 
   3.8050479150055943`*^9, 3.805047994987939*^9, 3.8050480511193743`*^9, 
   3.8050480950907593`*^9, 3.8050481354611526`*^9, {3.805048174168851*^9, 
   3.8050482341010933`*^9}, 3.8050482761262183`*^9, 3.8050484862338505`*^9, 
   3.8056546720546637`*^9, 3.8250066722098103`*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"1d4e8e91-48fb-4fc5-aa26-21b951b9148f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "5", ",", "7", ",", "9", ",", "11", ",", "13"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8050477329098454`*^9, 3.8050477544301834`*^9}, 
   3.8050479150055943`*^9, 3.805047994987939*^9, 3.8050480511193743`*^9, 
   3.8050480950907593`*^9, 3.8050481354611526`*^9, {3.805048174168851*^9, 
   3.8050482341010933`*^9}, 3.8050482761262183`*^9, 3.8050484862338505`*^9, 
   3.8056546720546637`*^9, 3.825006672213797*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"79145069-3d67-4c39-9fca-30609b2989f9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "13", ",", "29", ",", "61", ",", "125", ",", "253"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8050477329098454`*^9, 3.8050477544301834`*^9}, 
   3.8050479150055943`*^9, 3.805047994987939*^9, 3.8050480511193743`*^9, 
   3.8050480950907593`*^9, 3.8050481354611526`*^9, {3.805048174168851*^9, 
   3.8050482341010933`*^9}, 3.8050482761262183`*^9, 3.8050484862338505`*^9, 
   3.8056546720546637`*^9, 3.825006672325498*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"5365eaeb-8d49-4896-82a4-acafe457f456"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Ackermann", "[", 
     RowBox[{"1", ",", "n"}], "]"}], "\[Equal]", 
    RowBox[{"n", "+", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Ackermann", "[", 
     RowBox[{"2", ",", "n"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"2", "n"}], "+", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Ackermann", "[", 
     RowBox[{"3", ",", "n"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"8", "*", 
      SuperscriptBox["2", "n"]}], "-", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.805048575984186*^9, 3.805048691626481*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"bca4df4e-53f3-4e57-8479-3636992d1d0c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.805048680689763*^9, 3.8050486921743617`*^9}, 
   3.805654674705268*^9, 3.8250066759770546`*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"ab1f9c47-0bfb-4ac6-9e97-ef1630e69ee5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.805048680689763*^9, 3.8050486921743617`*^9}, 
   3.805654674705268*^9, 3.825006675980027*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"c82dc4c5-2ed0-4402-aa0a-4aa2e52fe2c1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.805048680689763*^9, 3.8050486921743617`*^9}, 
   3.805654674705268*^9, 3.825006676086234*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"f0794a25-4fc6-455c-918f-3c9b5be24bab"]
}, Open  ]],

Cell[TextData[{
 "Las f\[OAcute]rmulas ser\[IAcute]an \[OpenCurlyDoubleQuote]n + 2\
\[CloseCurlyDoubleQuote],  \[OpenCurlyDoubleQuote]2n + 3\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"8", "*", 
     SuperscriptBox["2", "n"]}], "-", "3"}], TraditionalForm]],ExpressionUUID->
  "7bb67f2a-653b-4303-953b-a72d1ec5af4e"],
 "\[CloseCurlyDoubleQuote], respectivamente."
}], "Text",
 CellChangeTimes->{{3.805048434156358*^9, 3.8050484608515477`*^9}, {
  3.8050484909812984`*^9, 
  3.805048541404149*^9}},ExpressionUUID->"98d2057e-95c6-4c70-b302-\
84817bd07e1a"],

Cell["1.5.16", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8056533338981194`*^9, 
  3.80565333432498*^9}, {3.8056540131951227`*^9, 3.805654013612009*^9}, {
  3.8056545743756924`*^9, 3.8056545748802624`*^9}, {3.805654700719967*^9, 
  3.8056547012835608`*^9}, {3.8068510088750086`*^9, 
  3.8068510104714932`*^9}},ExpressionUUID->"05fd0ce1-3976-46e6-997b-\
a901d2baa2e1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SumaDigiCola", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "SDCAux", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"SDCAux", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"digito_", ":", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "10"}], "]"}]}], ",", 
        RowBox[{"Suma_", ":", "0"}]}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "0"}], ",", "Suma", ",", 
        RowBox[{"SDCAux", "[", 
         RowBox[{
          FractionBox[
           RowBox[{"m", "-", "digito"}], "10"], ",", 
          RowBox[{"Mod", "[", 
           RowBox[{
            FractionBox[
             RowBox[{"m", "-", "digito"}], "10"], ",", "10"}], "]"}], ",", 
          RowBox[{"Suma", "+", "digito"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"SDCAux", "[", "n", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.805566386160008*^9, 3.8055666289954243`*^9}, {
  3.8055667730339947`*^9, 3.805566871900916*^9}, {3.8055669083586617`*^9, 
  3.8055669422717123`*^9}, {3.8055669855660686`*^9, 3.8055669976422606`*^9}, {
  3.8055670517011814`*^9, 3.8055670524903708`*^9}, {3.805567084766774*^9, 
  3.805567202400519*^9}, {3.8055672453503265`*^9, 3.805567268360354*^9}, {
  3.8055673035507107`*^9, 3.8055673941666584`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"c4876fad-14d4-4209-bbe7-1852328d663f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumaDigiCola", "[", "12345", "]"}]], "Input",
 CellChangeTimes->{
  3.8055669240858526`*^9, {3.8055670579987693`*^9, 3.8055670628986964`*^9}, 
   3.805567399867613*^9, {3.8055677256336102`*^9, 3.805567725817768*^9}, {
   3.8056549035415*^9, 3.8056549220207567`*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"817f7d7e-d7d1-4f8b-b54b-5a7e9869aad5"],

Cell[BoxData["15"], "Output",
 CellChangeTimes->{
  3.805566924733825*^9, 3.8055670150523643`*^9, {3.8055670560162945`*^9, 
   3.8055670633004723`*^9}, {3.8055673977522745`*^9, 3.805567400267356*^9}, 
   3.8055674425406704`*^9, 3.805567726367279*^9, {3.805654905439678*^9, 
   3.8056549224236574`*^9}, 3.8250066832194424`*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"92933dbe-281c-48fe-977a-8fab9cdd3ac6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"BToDCola", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "BToDAux", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"BToDAux", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"Cont_", ":", "0"}], ",", 
        RowBox[{"digito_", ":", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "10"}], "]"}]}], ",", 
        RowBox[{"Decimal_", ":", "0"}]}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"m", "\[Equal]", "0"}], ",", "Decimal", ",", 
        RowBox[{"BToDAux", "[", 
         RowBox[{
          FractionBox[
           RowBox[{"m", "-", "digito"}], "10"], ",", 
          RowBox[{"Cont", "+", "1"}], ",", 
          RowBox[{"Mod", "[", 
           RowBox[{
            FractionBox[
             RowBox[{"m", "-", "digito"}], "10"], ",", "10"}], "]"}], ",", 
          RowBox[{"Decimal", "+", 
           RowBox[{
            SuperscriptBox["2", "Cont"], "digito"}]}]}], "]"}]}], "]"}]}], 
     ";", 
     RowBox[{"BToDAux", "[", "n", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8056270214809523`*^9, 3.805627047839363*^9}, {
  3.8056272989753857`*^9, 3.8056273726257343`*^9}, {3.8056274824800916`*^9, 
  3.8056275341694813`*^9}, {3.8056275659934764`*^9, 3.805627649024788*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"e3aee6d1-8a40-4e58-a27d-5cf67072f3d8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BToDCola", "[", "1111", "]"}]], "Input",
 CellChangeTimes->{{3.8056276705215325`*^9, 3.8056276987998667`*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"1eeffd6a-39ed-4de9-8a26-df030a6a4182"],

Cell[BoxData["15"], "Output",
 CellChangeTimes->{{3.8056276732555575`*^9, 3.8056276994822545`*^9}, 
   3.8056549298142533`*^9, 3.8250066878795533`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"3becd172-d2b0-43d5-a2bc-de9865299f75"]
}, Open  ]],

Cell["1.5.17", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8056533338981194`*^9, 
  3.80565333432498*^9}, {3.8056540131951227`*^9, 3.805654013612009*^9}, {
  3.8056545743756924`*^9, 3.8056545748802624`*^9}, {3.805654700719967*^9, 
  3.8056547012835608`*^9}, {3.8056549505901437`*^9, 3.8056549507636766`*^9}, {
  3.806851020569401*^9, 
  3.806851022687358*^9}},ExpressionUUID->"5495d175-cc9d-499b-9e42-\
091446fd74cb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DToB", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Lista_", ":", 
     RowBox[{"{", "}"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "=", "Lista"}], ",", 
      RowBox[{"digito", "=", 
       RowBox[{"Mod", "[", 
        RowBox[{"n", ",", "2"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"n", "\[Equal]", "0"}], ",", "L", ",", 
      RowBox[{
       RowBox[{"L", "=", 
        RowBox[{"Prepend", "[", 
         RowBox[{"L", ",", "digito"}], "]"}]}], ";", 
       RowBox[{"DToB", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "-", "digito"}], ")"}], "/", "2"}], ",", "L"}], 
        "]"}]}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8054658064472017`*^9, 3.80546595289563*^9}, {
  3.8054663685591397`*^9, 3.8054663868727417`*^9}, {3.805655020409371*^9, 
  3.8056551600362115`*^9}, {3.805655623759595*^9, 3.8056556311726894`*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"3946ecee-de7c-4b80-8170-c67a64eeb7fb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DToB", "[", "2369", "]"}]], "Input",
 CellChangeTimes->{{3.8056551675931945`*^9, 3.805655172435253*^9}, 
   3.8056553666568937`*^9},
 CellLabel->"In[83]:=",ExpressionUUID->"d156d953-985e-4389-8045-36df270a72a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.805655172999742*^9, {3.805655367548888*^9, 3.8056553724417963`*^9}, 
   3.805655634235939*^9, 3.8250066942296658`*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"752a68f0-42e2-40a4-84cd-e1d18702894d"]
}, Open  ]],

Cell["O bien:", "Text",
 CellChangeTimes->{{3.8056552897492514`*^9, 
  3.805655294994845*^9}},ExpressionUUID->"87d515ad-0bb0-4fb6-a379-\
820002693e12"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DToB", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Lista_", ":", 
     RowBox[{"{", "}"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "=", "Lista"}], ",", 
      RowBox[{"digito", "=", 
       RowBox[{"Mod", "[", 
        RowBox[{"n", ",", "2"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"n", "\[Equal]", "0"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"ToString", "/@", "L"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"L", "=", 
        RowBox[{"Prepend", "[", 
         RowBox[{"L", ",", "digito"}], "]"}]}], ";", 
       RowBox[{"DToB", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "-", "digito"}], ")"}], "/", "2"}], ",", "L"}], 
        "]"}]}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8054658064472017`*^9, 3.80546595289563*^9}, {
  3.8054663685591397`*^9, 3.8054663868727417`*^9}, {3.805655020409371*^9, 
  3.8056551600362115`*^9}, {3.805655302525013*^9, 3.8056553346209106`*^9}, {
  3.805655607064049*^9, 3.805655615012521*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"0434e259-851c-42e4-b0c5-81964ee5ac24"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DToB", "[", "2369", "]"}]], "Input",
 CellChangeTimes->{3.80565536367156*^9},
 CellLabel->"In[85]:=",ExpressionUUID->"70889d4d-099f-418b-8876-88185337c561"],

Cell[BoxData["100101000001"], "Output",
 CellChangeTimes->{3.8056553437846613`*^9, 3.8056553788306084`*^9, 
  3.805655619065941*^9, 3.825006699915096*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"92d17493-4a84-4091-a34c-ec46c6fb9b6c"]
}, Open  ]],

Cell["1.5.18", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8056533338981194`*^9, 
  3.80565333432498*^9}, {3.8056540131951227`*^9, 3.805654013612009*^9}, {
  3.8056545743756924`*^9, 3.8056545748802624`*^9}, {3.805654700719967*^9, 
  3.8056547012835608`*^9}, {3.8056549505901437`*^9, 3.8056549507636766`*^9}, {
  3.8056557565083523`*^9, 3.805655756972063*^9}, {3.8068510312663307`*^9, 
  3.8068510328875346`*^9}},ExpressionUUID->"eb975070-0b44-4e0b-ae1d-\
a82d43ec29d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NumPerfect", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Cont_", ":", "1"}], ",", 
    RowBox[{"Lista_", ":", 
     RowBox[{"{", "}"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"L", "=", "Lista"}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"Cont", "\[LessEqual]", 
       RowBox[{"n", "/", "2"}]}], ",", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Mod", "[", 
           RowBox[{"n", ",", "Cont"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"L", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"L", ",", "Cont"}], "]"}]}]}], "]"}], ";", 
       RowBox[{"NumPerfect", "[", 
        RowBox[{"n", ",", 
         RowBox[{"Cont", "+", "1"}], ",", "L"}], "]"}]}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", "Lista", "]"}], "\[Equal]", "n"}], ",", "True",
         ",", "False"}], "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.805462534644561*^9, 3.805462564404257*^9}, {
  3.805655815420822*^9, 3.8056558361900053`*^9}, {3.805655900103117*^9, 
  3.8056559181014347`*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"3e81f24f-d331-44ed-ba76-4adb35ac4e02"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumPerfect", "/@", 
  RowBox[{"{", 
   RowBox[{"6", ",", "28", ",", "496", ",", "500"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8056559318678894`*^9, 3.805656035684396*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"ec148a35-4213-4956-879f-8b8b86dbdfc3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{
  3.80565593386137*^9, {3.8056560261834135`*^9, 3.805656036509649*^9}, 
   3.825006707124915*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"f2f943aa-aa28-4ad2-aac3-916d182a9478"]
}, Open  ]],

Cell["1.5.19", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8056533338981194`*^9, 
  3.80565333432498*^9}, {3.8056540131951227`*^9, 3.805654013612009*^9}, {
  3.8056545743756924`*^9, 3.8056545748802624`*^9}, {3.805654700719967*^9, 
  3.8056547012835608`*^9}, {3.8056549505901437`*^9, 3.8056549507636766`*^9}, {
  3.8056557565083523`*^9, 3.805655756972063*^9}, {3.805656078444648*^9, 
  3.8056560789562793`*^9}, {3.8068510400416746`*^9, 
  3.8068510416234617`*^9}},ExpressionUUID->"41f4a64c-bda5-4cb1-9aeb-\
0ceddf377071"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DesComp", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Cont_", ":", "1"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", "=", "Cont"}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"Cont", "\[LessEqual]", "n"}], ",", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"n", ",", "\"\<=\>\"", ",", 
         RowBox[{"n", "-", "i"}], ",", "\"\<+\>\"", ",", "i"}], "]"}], ";", 
       RowBox[{"i", "++"}], ";", 
       RowBox[{"DesComp", "[", 
        RowBox[{"n", ",", "i"}], "]"}]}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.804854434720431*^9, 3.804854435083747*^9}, {
   3.805656099593957*^9, 3.80565612854235*^9}, 3.8056561690186424`*^9, {
   3.805656219332962*^9, 3.8056562256128817`*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"89a83fe0-e6bc-4fb0-b4d6-124d269c6b2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesComp", "[", "5", "]"}]], "Input",
 CellChangeTimes->{{3.805656139543589*^9, 3.8056561396762333`*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"608d21fc-feb9-4105-8d0d-01649973f50f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5", "\[InvisibleSpace]", "\<\"=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"+\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm[5, "=", 4, "+", 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80565610347479*^9, 3.805656140422239*^9, {3.8056561722514563`*^9, 
   3.805656189299631*^9}, 3.8056562335334673`*^9, 3.825006714110832*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"dca1b84b-70d5-4a6d-adba-4dc5eec1e709"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5", "\[InvisibleSpace]", "\<\"=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"+\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm[5, "=", 3, "+", 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80565610347479*^9, 3.805656140422239*^9, {3.8056561722514563`*^9, 
   3.805656189299631*^9}, 3.8056562335334673`*^9, 3.8250067141149445`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"c989595b-0dbd-465c-92db-78bc6c6d7530"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5", "\[InvisibleSpace]", "\<\"=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"+\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm[5, "=", 2, "+", 3],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80565610347479*^9, 3.805656140422239*^9, {3.8056561722514563`*^9, 
   3.805656189299631*^9}, 3.8056562335334673`*^9, 3.8250067141183243`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"13ba69f0-6429-4964-96bc-7e3dfe72e8b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5", "\[InvisibleSpace]", "\<\"=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"+\"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm[5, "=", 1, "+", 4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80565610347479*^9, 3.805656140422239*^9, {3.8056561722514563`*^9, 
   3.805656189299631*^9}, 3.8056562335334673`*^9, 3.825006714119322*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"584002e4-8a7a-49c9-ac65-b049b14c8f59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5", "\[InvisibleSpace]", "\<\"=\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"+\"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm[5, "=", 0, "+", 5],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80565610347479*^9, 3.805656140422239*^9, {3.8056561722514563`*^9, 
   3.805656189299631*^9}, 3.8056562335334673`*^9, 3.8250067141213164`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"cd8848bd-994e-48dd-87d4-79d7f3b7d09a"]
}, Open  ]]
}, Open  ]],

Cell["1.5.20", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8056533338981194`*^9, 
  3.80565333432498*^9}, {3.8056540131951227`*^9, 3.805654013612009*^9}, {
  3.8056545743756924`*^9, 3.8056545748802624`*^9}, {3.805654700719967*^9, 
  3.8056547012835608`*^9}, {3.8056549505901437`*^9, 3.8056549507636766`*^9}, {
  3.8056557565083523`*^9, 3.805655756972063*^9}, {3.805656078444648*^9, 
  3.8056560789562793`*^9}, {3.8056562595801845`*^9, 3.805656260012066*^9}, {
  3.8068510540068483`*^9, 
  3.8068510561346693`*^9}},ExpressionUUID->"3f73d67f-5fbd-45df-9601-\
44220fe38a5b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mcm", "[", 
   RowBox[{"n_", ",", "m_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "MCD", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"MCD", "[", 
       RowBox[{"nn_", ",", "mm_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"nn", "\[Equal]", "0"}], ",", 
        RowBox[{"Return", "[", "mm", "]"}], ",", 
        RowBox[{"MCD", "[", 
         RowBox[{
          RowBox[{"Mod", "[", 
           RowBox[{"mm", ",", "nn"}], "]"}], ",", "nn"}], "]"}]}], "]"}]}], 
     ";", 
     RowBox[{"n", "*", 
      RowBox[{"m", "/", 
       RowBox[{"MCD", "[", 
        RowBox[{"n", ",", "m"}], "]"}]}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.805656278228857*^9, 3.8056562811979966`*^9}, {
  3.8056593676332607`*^9, 3.8056593688545084`*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"a7d473f9-b3e4-4fc8-b617-44c5df46e36d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mcm", "[", 
  RowBox[{"120", ",", "144"}], "]"}]], "Input",
 CellChangeTimes->{{3.805656283749733*^9, 3.8056562883887825`*^9}, {
  3.8056593721441517`*^9, 3.8056593726069155`*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"8ef2e2a2-c32c-4841-b4a8-48bbd2e62f4e"],

Cell[BoxData["720"], "Output",
 CellChangeTimes->{3.805656289047017*^9, 3.805659376729249*^9, 
  3.825006719210932*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"efdbd30f-8a24-45d0-bfba-e87f2cf0808b"]
}, Open  ]],

Cell["1.5.21", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8056533338981194`*^9, 
  3.80565333432498*^9}, {3.8056540131951227`*^9, 3.805654013612009*^9}, {
  3.8056545743756924`*^9, 3.8056545748802624`*^9}, {3.805654700719967*^9, 
  3.8056547012835608`*^9}, {3.8056549505901437`*^9, 3.8056549507636766`*^9}, {
  3.8056557565083523`*^9, 3.805655756972063*^9}, {3.805656078444648*^9, 
  3.8056560789562793`*^9}, {3.8056562595801845`*^9, 3.805656260012066*^9}, {
  3.8056563248372746`*^9, 3.805656325468581*^9}, {3.806851064294937*^9, 
  3.8068510661762547`*^9}},ExpressionUUID->"bf7d4ed3-e304-4bea-a828-\
1ebe8fc5e22b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"quicksortDes", "[", 
   RowBox[{
    RowBox[{"begin_", ":", "1"}], ",", "end_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"piv", ",", "aux"}], "}"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"begin", "<", "end"}], ",", " ", 
       RowBox[{
        RowBox[{"i", "=", "begin"}], ";", " ", 
        RowBox[{"j", "=", "end"}], ";", 
        RowBox[{"piv", "=", 
         RowBox[{"L", "[", 
          RowBox[{"[", 
           RowBox[{"Floor", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"begin", "+", "end"}], ")"}], "/", "2"}], "]"}], "]"}], 
          "]"}]}], ";", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"i", "\[LessEqual]", "j"}], ",", " ", 
          RowBox[{
           RowBox[{"While", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ">", "piv"}], ",", " ", 
             RowBox[{"i", "++"}]}], "]"}], ";", " ", 
           RowBox[{"While", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "j", "]"}], "]"}], "<", "piv"}], ",", 
             RowBox[{"j", "--"}]}], "]"}], ";", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"i", "\[LessEqual]", "j"}], ",", " ", 
             RowBox[{
              RowBox[{"aux", "=", 
               RowBox[{"L", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], ";", " ", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "=", 
               RowBox[{"L", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], ";", " ", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "j", "]"}], "]"}], "=", "aux"}], ";", " ", 
              RowBox[{"i", "++"}], ";", " ", 
              RowBox[{"j", "--"}]}]}], "]"}]}]}], "]"}], ";", 
        RowBox[{"Print", "[", 
         RowBox[{"ReplacePart", "[", 
          RowBox[{"L", ",", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"L", "[", 
              RowBox[{"[", 
               RowBox[{"Floor", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"begin", "+", "end"}], ")"}], "/", "2"}], "]"}], 
               "]"}], "]"}], ",", "Blue"}], "]"}], ",", 
           RowBox[{"Floor", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"begin", "+", "end"}], ")"}], "/", "2"}], "]"}]}], 
          "]"}], "]"}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"begin", "<", "j"}], ",", 
          RowBox[{"quicksortDes", "[", 
           RowBox[{"begin", ",", "j"}], "]"}]}], "]"}], ";", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"i", "<", "end"}], ",", 
          RowBox[{"quicksortDes", "[", 
           RowBox[{"i", ",", " ", "end"}], "]"}]}], "]"}]}]}], "]"}], ";", 
     "L"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8054734737244053`*^9, 3.8054735110231752`*^9}, {
   3.8054735805680723`*^9, 3.805473606481574*^9}, {3.805473646612162*^9, 
   3.805473694757557*^9}, 3.805473771509617*^9, {3.805475243604766*^9, 
   3.8054753243722944`*^9}, {3.805656379998667*^9, 3.8056564085222025`*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"c295394f-e27b-4c00-9a32-83f2f101c44e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "9"}], ",", "5", ",", 
     RowBox[{"-", "7"}], ",", "0", ",", "10", ",", "21.3", ",", 
     RowBox[{"-", "28.7"}], ",", "100", ",", 
     RowBox[{"-", "100"}], ",", "14"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"quicksortDes", "[", 
  RowBox[{"Length", "[", "L", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8054733975028653`*^9, 3.80547345778061*^9}, {
   3.805473559398141*^9, 3.805473574746146*^9}, {3.805473615252617*^9, 
   3.8054736158997407`*^9}, {3.8054736796986003`*^9, 3.80547368252283*^9}, 
   3.805473720260029*^9, {3.805473777107374*^9, 3.805473779986494*^9}, {
   3.805475225233859*^9, 3.8054752265670495`*^9}, {3.8056564176853075`*^9, 
   3.8056564181436286`*^9}, 3.805656754069289*^9},
 CellLabel->"In[93]:=",ExpressionUUID->"374d98b6-4466-4beb-91ba-d8d323b0f9ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "100", ",", "21.3`", ",", "10", ",", 
   StyleBox["0",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.825006725236346*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"d2e95d40-3643-40d7-8388-035928edcd9f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", 
   StyleBox["14",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "21.3`", ",", "10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.825006725239995*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"a57ebfcb-77e3-4a0a-a05d-28598f5db11f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", 
   StyleBox["14",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.8250067252431707`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"420c08f8-d0d5-4302-bb74-0e092870660d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", 
   StyleBox["14",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.8250067252441673`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"2a976f5f-4bdf-4097-ab95-327b8d68c478"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   StyleBox[
    RowBox[{"-", "9"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.825006725246162*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"a1a5546c-03cc-42b0-962e-019dbb60bc55"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "0", ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.825006725248157*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"f83d0e2b-3777-499c-a9f7-0f575f310328"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "0", ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.825006725249154*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"f37f0883-e5f4-4a70-a1c9-0e5b0ede06e3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "5", ",", "0", ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.8250067252511487`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"dfdfad90-24f4-48c2-a774-e52fbe92e82a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "0", ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.825006725252146*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"df635467-88c8-4624-a324-281f68cbc953"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.825006725254141*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"c6d3fe88-de14-4d2a-b92b-8cb2034d43b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", 
   StyleBox["0",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.8250067252561374`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"49009516-3999-41b7-8e52-70c05cccd130"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.825006725258131*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"fc0a9471-f1ca-4741-aeac-39d4d27ca5c8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}], ",", 
   StyleBox[
    RowBox[{"-", "28.7`"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.8250067252601256`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"840876e0-89e9-4f69-80f8-d243840e3823"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   StyleBox[
    RowBox[{"-", "9"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "28.7`"}], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.8250067252621193`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"4e4fc6bd-1765-4f02-82d5-e379d7bdd964"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}], ",", 
   StyleBox[
    RowBox[{"-", "28.7`"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8056564266299047`*^9, 3.8056567578024454`*^9, 
  3.8250067252641144`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[93]:=",ExpressionUUID->"5cf57b1b-5e5c-439c-a79d-01a132398363"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "28.7`"}], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Output",
 CellChangeTimes->{3.805656426662775*^9, 3.8056567578313675`*^9, 
  3.825006725266109*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"fd89abbb-ba42-42f7-ab78-c8d82274ab4f"]
}, Open  ]],

Cell["1.5.22", "Text",
 CellChangeTimes->{{3.8048494500114098`*^9, 3.804849461315151*^9}, {
  3.805628262161262*^9, 3.805628262867632*^9}, {3.805641336050844*^9, 
  3.8056413369426327`*^9}, {3.805651037480418*^9, 3.805651037955494*^9}, {
  3.805652881547242*^9, 3.8056528819322186`*^9}, {3.8056533338981194`*^9, 
  3.80565333432498*^9}, {3.8056540131951227`*^9, 3.805654013612009*^9}, {
  3.8056545743756924`*^9, 3.8056545748802624`*^9}, {3.805654700719967*^9, 
  3.8056547012835608`*^9}, {3.8056549505901437`*^9, 3.8056549507636766`*^9}, {
  3.8056557565083523`*^9, 3.805655756972063*^9}, {3.805656078444648*^9, 
  3.8056560789562793`*^9}, {3.8056562595801845`*^9, 3.805656260012066*^9}, {
  3.8056563248372746`*^9, 3.805656325468581*^9}, {3.8056565110053368`*^9, 
  3.805656511173886*^9}, {3.806851078392782*^9, 
  3.806851080543997*^9}},ExpressionUUID->"b7df28de-a7b5-4607-b009-\
303e5b64519a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximo", "[", 
   RowBox[{
    RowBox[{"begin_", ":", "1"}], ",", "end_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"piv", ",", "aux"}], "}"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"begin", "<", "end"}], ",", " ", 
       RowBox[{
        RowBox[{"i", "=", "begin"}], ";", " ", 
        RowBox[{"j", "=", "end"}], ";", 
        RowBox[{"piv", "=", 
         RowBox[{"L", "[", 
          RowBox[{"[", 
           RowBox[{"Floor", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"begin", "+", "end"}], ")"}], "/", "2"}], "]"}], "]"}], 
          "]"}]}], ";", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"i", "\[LessEqual]", "j"}], ",", " ", 
          RowBox[{
           RowBox[{"While", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ">", "piv"}], ",", " ", 
             RowBox[{"i", "++"}]}], "]"}], ";", " ", 
           RowBox[{"While", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "j", "]"}], "]"}], "<", "piv"}], ",", 
             RowBox[{"j", "--"}]}], "]"}], ";", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"i", "\[LessEqual]", "j"}], ",", " ", 
             RowBox[{
              RowBox[{"aux", "=", 
               RowBox[{"L", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], ";", " ", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "=", 
               RowBox[{"L", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], ";", " ", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "j", "]"}], "]"}], "=", "aux"}], ";", " ", 
              RowBox[{"i", "++"}], ";", " ", 
              RowBox[{"j", "--"}]}]}], "]"}]}]}], "]"}], ";", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"begin", "<", "j"}], ",", 
          RowBox[{"Maximo", "[", 
           RowBox[{"begin", ",", "j"}], "]"}]}], "]"}], ";", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"i", "<", "end"}], ",", 
          RowBox[{"Maximo", "[", 
           RowBox[{"i", ",", " ", "end"}], "]"}]}], "]"}]}]}], "]"}], ";", 
     RowBox[{"First", "[", "L", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8056565519537888`*^9, 3.8056566125003138`*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"1c360ceb-8b7a-4163-8d1f-09e5a23d09c0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "9"}], ",", "5", ",", 
     RowBox[{"-", "7"}], ",", "0", ",", "10", ",", "21.3", ",", 
     RowBox[{"-", "28.7"}], ",", "100", ",", 
     RowBox[{"-", "100"}], ",", "14"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Maximo", "[", 
  RowBox[{"Length", "[", "L", "]"}], "]"}]}], "Input",
 CellChangeTimes->{3.805656617774064*^9, 3.8056567648885574`*^9},
 CellLabel->"In[96]:=",ExpressionUUID->"f990d089-dc70-4f48-9298-080adeaa31e9"],

Cell[BoxData["100"], "Output",
 CellChangeTimes->{3.8056566218596115`*^9, 3.805656770911253*^9, 
  3.825006731549674*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"e5fc7c29-d650-4e13-bbb2-d3162b25bfdf"]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c79951d0-6dae-4e12-b3a8-0339e8726013"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 198, 3, 42, "Input",ExpressionUUID->"ca079fa1-ed74-435c-ac7c-22e524f4d475"],
Cell[759, 25, 200, 4, 50, "Text",ExpressionUUID->"a8902d91-6a29-47e4-9bc7-f47ba858c878"],
Cell[962, 31, 767, 17, 87, "Input",ExpressionUUID->"7223d560-39e2-4754-a2bf-d33040ab879e"],
Cell[CellGroupData[{
Cell[1754, 52, 609, 16, 88, "Input",ExpressionUUID->"a45cd562-5462-4cd0-a09d-f738e3980edd"],
Cell[2366, 70, 624, 10, 78, "Output",ExpressionUUID->"8942bada-8d55-4cc2-b8ef-d905a6e3e26b"]
}, Open  ]],
Cell[3005, 83, 200, 4, 50, "Text",ExpressionUUID->"cfe8e32b-9972-4a43-90af-52a4e7662e6a"],
Cell[3208, 89, 847, 21, 88, "Input",ExpressionUUID->"d08d50be-93e9-4310-a7fe-159beb0236f8"],
Cell[CellGroupData[{
Cell[4080, 114, 801, 20, 90, "Input",ExpressionUUID->"a9fc79e2-4d6b-458f-8901-dc1dca9e73b3"],
Cell[4884, 136, 655, 12, 78, "Output",ExpressionUUID->"f225d2b6-6b8f-4e2b-8464-a46f15e8bbd4"]
}, Open  ]],
Cell[5554, 151, 252, 4, 50, "Text",ExpressionUUID->"eea7a011-35a7-459e-a8be-73ce00e051af"],
Cell[5809, 157, 656, 16, 65, "Input",ExpressionUUID->"c8a82858-268d-4e44-b3da-604a3b7a4bfb"],
Cell[CellGroupData[{
Cell[6490, 177, 713, 17, 65, "Input",ExpressionUUID->"de251635-2a0a-43cf-9cbf-f894f8b9fb20"],
Cell[7206, 196, 517, 9, 78, "Output",ExpressionUUID->"a072bdde-7bcb-414d-82d2-538464429d09"]
}, Open  ]],
Cell[7738, 208, 303, 5, 50, "Text",ExpressionUUID->"d353c80f-b7b8-476b-8ac1-ea589adaab0a"],
Cell[8044, 215, 767, 19, 91, "Input",ExpressionUUID->"6d54b132-f192-4bea-9fa0-c99f7b255d25"],
Cell[CellGroupData[{
Cell[8836, 238, 823, 20, 91, "Input",ExpressionUUID->"1e9cc2a0-7f81-40c9-877c-ddc655879408"],
Cell[9662, 260, 521, 9, 78, "Output",ExpressionUUID->"75e860a7-15b8-40b6-97e6-803e88a6025e"]
}, Open  ]],
Cell[10198, 272, 358, 6, 50, "Text",ExpressionUUID->"71256f76-f307-4ff6-b27e-0e42cdf551ea"],
Cell[10559, 280, 1595, 40, 201, "Input",ExpressionUUID->"46789441-abac-4c89-b1af-9c9ea7caed77"],
Cell[CellGroupData[{
Cell[12179, 324, 1189, 27, 97, "Input",ExpressionUUID->"6444fe46-97ae-42da-a946-71bfbd01141d"],
Cell[13371, 353, 645, 11, 94, "Output",ExpressionUUID->"baf48c5a-b8f3-4dc1-bd64-261b46450bf3"]
}, Open  ]],
Cell[14031, 367, 295, 5, 50, "Text",ExpressionUUID->"4770676e-5161-414b-b3ba-aa7084017004"],
Cell[14329, 374, 204, 4, 50, "Text",ExpressionUUID->"1ec1888f-6cba-4c15-9c4c-01f6c87bd8fc"],
Cell[14536, 380, 1503, 35, 231, "Input",ExpressionUUID->"5e7015d0-0a85-498d-a9ba-411ac604a591"],
Cell[CellGroupData[{
Cell[16064, 419, 665, 17, 88, "Input",ExpressionUUID->"fc1a09c2-8d64-43d3-8896-6dd0374005ff"],
Cell[16732, 438, 649, 11, 78, "Output",ExpressionUUID->"e686fe96-92b3-4731-bb35-b6186994a230"]
}, Open  ]],
Cell[17396, 452, 202, 4, 50, "Text",ExpressionUUID->"fdfc945b-fb16-4ff9-b649-ce0c41c83c66"],
Cell[17601, 458, 1231, 26, 87, "Input",ExpressionUUID->"936ccd3e-7c57-451f-a771-b728435ee786"],
Cell[CellGroupData[{
Cell[18857, 488, 711, 17, 88, "Input",ExpressionUUID->"a634cec1-7807-4447-a39c-0f8794dc044a"],
Cell[19571, 507, 652, 11, 94, "Output",ExpressionUUID->"47060df6-7fc7-4808-adff-06c03819bc5d"]
}, Open  ]],
Cell[20238, 521, 206, 4, 50, "Text",ExpressionUUID->"12d96fec-1ed6-4ae6-bb8b-51cb9a14a8f7"],
Cell[20447, 527, 1849, 43, 309, "Input",ExpressionUUID->"29a0ee51-252d-4e44-82df-a63f411fe31b"],
Cell[CellGroupData[{
Cell[22321, 574, 807, 20, 90, "Input",ExpressionUUID->"78e75334-b778-4f52-9631-f086eb1e8d34"],
Cell[23131, 596, 751, 12, 78, "Output",ExpressionUUID->"0203e228-1616-46ab-be80-71367b38f0ff"]
}, Open  ]],
Cell[23897, 611, 202, 4, 50, "Text",ExpressionUUID->"e29aecf8-180f-4290-b3cd-b0c1a71caa6d"],
Cell[24102, 617, 1478, 33, 117, "Input",ExpressionUUID->"8c380d5b-a9f7-482d-82b6-29a29ffb2caa"],
Cell[CellGroupData[{
Cell[25605, 654, 831, 21, 90, "Input",ExpressionUUID->"93421630-9b16-423c-a83e-2456fa8548bf"],
Cell[26439, 677, 698, 11, 78, "Output",ExpressionUUID->"a9cbb113-8873-4501-b368-c9e2daa9d442"]
}, Open  ]],
Cell[27152, 691, 258, 4, 50, "Text",ExpressionUUID->"85d879be-c38d-423c-89ec-6ef4baeed3dd"],
Cell[27413, 697, 1555, 35, 179, "Input",ExpressionUUID->"4995a752-d854-4ecb-9eb0-a984ddcb6793"],
Cell[CellGroupData[{
Cell[28993, 736, 792, 18, 65, "Input",ExpressionUUID->"790395e4-16f0-4f7c-9b53-97d8c6c95a89"],
Cell[29788, 756, 699, 11, 78, "Output",ExpressionUUID->"5cfef97a-bdb6-45d2-8bda-0a3c725f071e"]
}, Open  ]],
Cell[30502, 770, 202, 4, 50, "Text",ExpressionUUID->"9c9ee224-7c54-4349-80b5-6ce7bd0c355a"],
Cell[30707, 776, 1286, 26, 94, "Input",ExpressionUUID->"05e9ce42-5eec-4686-8002-b61a42c56a21"],
Cell[CellGroupData[{
Cell[32018, 806, 792, 18, 65, "Input",ExpressionUUID->"63f24f95-b673-4882-b762-ee8c94ddf6d0"],
Cell[32813, 826, 724, 12, 94, "Output",ExpressionUUID->"d43da97f-1688-4ef1-80d0-4f6782da0723"]
}, Open  ]],
Cell[33552, 841, 309, 5, 50, "Text",ExpressionUUID->"a0890de3-24f1-4fd7-ae1a-6d1ee16e0e1c"],
Cell[33864, 848, 1741, 39, 237, "Input",ExpressionUUID->"85827c86-cd98-409e-b089-0884a828d775"],
Cell[CellGroupData[{
Cell[35630, 891, 901, 21, 91, "Input",ExpressionUUID->"95c54913-b5bf-40bf-8ba1-1bc3487cf1a8"],
Cell[36534, 914, 721, 12, 78, "Output",ExpressionUUID->"cc96a84c-dc54-498f-9d8b-a361a246990b"]
}, Open  ]],
Cell[37270, 929, 202, 4, 50, "Text",ExpressionUUID->"ce60c7dd-03c0-4399-9ac5-2d1e7e524111"],
Cell[37475, 935, 1425, 29, 122, "Input",ExpressionUUID->"e5c25e62-448c-4a2e-8994-677bc6e2cee4"],
Cell[CellGroupData[{
Cell[38925, 968, 901, 21, 91, "Input",ExpressionUUID->"ce37ef35-f474-457f-aad2-449d6003363d"],
Cell[39829, 991, 746, 12, 94, "Output",ExpressionUUID->"54928bc7-ac3d-4716-b32d-0ecbbd9cac27"]
}, Open  ]],
Cell[40590, 1006, 362, 6, 50, "Text",ExpressionUUID->"ce9e988b-bcb3-49c9-a39d-4bead5e46821"],
Cell[40955, 1014, 2030, 51, 230, "Input",ExpressionUUID->"a47de252-3bb3-40e6-9566-42cf1be40893"],
Cell[CellGroupData[{
Cell[43010, 1069, 1215, 27, 97, "Input",ExpressionUUID->"b35be171-40b1-49d1-ab8f-b6af391ef7f3"],
Cell[44228, 1098, 696, 11, 78, "Output",ExpressionUUID->"11dcf024-3bb5-4f44-b6e4-f8d476255dd0"]
}, Open  ]],
Cell[44939, 1112, 200, 4, 50, "Text",ExpressionUUID->"175c736d-749e-4762-9d67-fce6e1a06fea"],
Cell[45142, 1118, 579, 14, 72, "Input",ExpressionUUID->"26d05328-da51-4244-a0ba-c982b2a00e6e"],
Cell[45724, 1134, 1434, 33, 256, "Input",ExpressionUUID->"717061cc-71fe-49d2-890b-8be15af9eeb7"],
Cell[47161, 1169, 165, 3, 50, "Text",ExpressionUUID->"bcf5a59c-4267-4561-9560-5ba64d24da94"],
Cell[47329, 1174, 113, 1, 65, "Input",ExpressionUUID->"db5b7d58-6a2c-43cb-83d7-ee7b963afc4e"],
Cell[47445, 1177, 566, 15, 75, "Input",ExpressionUUID->"5b921f29-3fb0-4ec1-baf5-7932de567004"],
Cell[CellGroupData[{
Cell[48036, 1196, 788, 15, 65, "Input",ExpressionUUID->"aeddba22-9dfd-45ee-8a96-16f7e2efb6ad"],
Cell[48827, 1213, 1146, 18, 107, "Output",ExpressionUUID->"d81f2180-e74a-4ca9-9abe-c85a818037bb"]
}, Open  ]],
Cell[49988, 1234, 246, 4, 50, "Text",ExpressionUUID->"d5605970-67ac-4b2a-915c-f724b60c5f9a"],
Cell[50237, 1240, 807, 20, 120, "Input",ExpressionUUID->"ac1e4dd6-8f40-4ffd-97e4-a83bf3afb5a2"],
Cell[51047, 1262, 1721, 40, 291, "Input",ExpressionUUID->"88c718e1-dcc1-49b6-b10a-fca36c745dea"],
Cell[52771, 1304, 165, 3, 50, "Text",ExpressionUUID->"8c8157ff-4329-4d0a-8bf6-a6cd3254cc7c"],
Cell[52939, 1309, 137, 2, 65, "Input",ExpressionUUID->"3fb089af-c9fd-4552-90e3-382c80d1835c"],
Cell[53079, 1313, 760, 20, 101, "Input",ExpressionUUID->"f49f69b3-f1d1-4e1b-b570-680df191cf8d"],
Cell[CellGroupData[{
Cell[53864, 1337, 988, 17, 65, "Input",ExpressionUUID->"65b983a6-c4bc-41ab-b8de-e901092d149e"],
Cell[54855, 1356, 1139, 18, 78, "Output",ExpressionUUID->"7377e1d7-be38-486f-b53f-354e85957cb0"]
}, Open  ]],
Cell[56009, 1377, 245, 4, 50, "Text",ExpressionUUID->"593ad8d6-1614-4d07-96c9-ef1c4f85ef58"],
Cell[56257, 1383, 1108, 28, 317, "Input",ExpressionUUID->"53107b9c-d210-4ff4-bb2c-13cb55a7b0bd"],
Cell[57368, 1413, 2003, 45, 432, "Input",ExpressionUUID->"008cbe44-b727-4a3b-8a33-3abe8ac59c54"],
Cell[59374, 1460, 165, 3, 50, "Text",ExpressionUUID->"74becf0f-6045-4643-bd2e-cacf74020ef8"],
Cell[59542, 1465, 137, 2, 65, "Input",ExpressionUUID->"3dd72969-e66e-4595-bed7-edeb7aa65f26"],
Cell[59682, 1469, 995, 27, 136, "Input",ExpressionUUID->"9b307b6b-a438-4850-abb9-3ebea572c976"],
Cell[CellGroupData[{
Cell[60702, 1500, 1062, 18, 65, "Input",ExpressionUUID->"f0dfea6f-f09e-4394-91c2-0be5e9349295"],
Cell[61767, 1520, 552, 10, 94, "Output",ExpressionUUID->"8cd82c16-6db0-4b63-810d-49ad47478e8e"]
}, Open  ]],
Cell[62334, 1533, 247, 4, 50, "Text",ExpressionUUID->"04774032-e63c-4edd-8a26-9892a1dc68d5"],
Cell[62584, 1539, 1399, 34, 342, "Input",ExpressionUUID->"d8cd259f-1a25-45e5-9028-fa810623feda"],
Cell[63986, 1575, 2228, 49, 398, "Input",ExpressionUUID->"7aed81f4-043c-4c72-a4e4-e46af824dfe7"],
Cell[66217, 1626, 165, 3, 50, "Text",ExpressionUUID->"d7360ac2-7f2a-45f0-98e1-c4e4cb4c1d7b"],
Cell[66385, 1631, 137, 2, 65, "Input",ExpressionUUID->"791610d1-1512-4975-b5a4-70f2a2562482"],
Cell[66525, 1635, 1199, 33, 158, "Input",ExpressionUUID->"556dc072-ccd6-46ed-bba3-0fa727d7dec7"],
Cell[CellGroupData[{
Cell[67749, 1672, 990, 17, 65, "Input",ExpressionUUID->"64cdf56d-8368-4f4b-99d6-99cc242fac45"],
Cell[68742, 1691, 1147, 18, 78, "Output",ExpressionUUID->"e0215f66-f239-49af-8b17-921f1c1b833b"]
}, Open  ]],
Cell[69904, 1712, 397, 6, 50, "Text",ExpressionUUID->"06f9979d-1c1a-45d9-be64-36b032ff4338"],
Cell[70304, 1720, 231, 5, 50, "Text",ExpressionUUID->"983b7773-0ab4-477e-bc3d-acefed6af1a8"],
Cell[70538, 1727, 137, 2, 65, "Input",ExpressionUUID->"9ddccdea-5d43-4788-b276-a83f2ceb8ec1"],
Cell[70678, 1731, 402, 10, 72, "Input",ExpressionUUID->"5d356d0c-a6d7-4b40-b16e-d9712d8c8458"],
Cell[71083, 1743, 465, 11, 65, "Input",ExpressionUUID->"dd327f81-b058-402b-91d3-1813ff4dc46a"],
Cell[CellGroupData[{
Cell[71573, 1758, 139, 2, 42, "Input",ExpressionUUID->"f4ed35f6-1011-421e-a410-5bc6d012aaf8"],
Cell[71715, 1762, 220, 3, 48, "Output",ExpressionUUID->"f344d514-8810-425a-bcf0-6c05926e16df"]
}, Open  ]],
Cell[71950, 1768, 202, 4, 50, "Text",ExpressionUUID->"3372efcb-fe2d-4223-98b9-a4a59375f3b0"],
Cell[72155, 1774, 582, 15, 65, "Input",ExpressionUUID->"172ef5a5-f599-44c4-8d34-2328c91b3aa6"],
Cell[CellGroupData[{
Cell[72762, 1793, 205, 3, 42, "Input",ExpressionUUID->"4d4a3af1-bac4-42d1-8580-03341adab95c"],
Cell[72970, 1798, 244, 3, 48, "Output",ExpressionUUID->"faa776c1-0f6c-41ef-81be-dfa3cbda8de1"]
}, Open  ]],
Cell[73229, 1804, 447, 7, 50, "Text",ExpressionUUID->"e41ecd74-10d4-4119-abed-d96b94013cde"],
Cell[73679, 1813, 1301, 33, 231, "Input",ExpressionUUID->"cc698a2e-ec5e-4209-8a6f-f964c59693a5"],
Cell[CellGroupData[{
Cell[75005, 1850, 395, 8, 65, "Input",ExpressionUUID->"44b35dc7-2d3d-443f-8946-d09039f2ef35"],
Cell[75403, 1860, 851, 14, 135, "Output",ExpressionUUID->"1a994061-9142-4e0d-85fe-354d32c7a21f"]
}, Open  ]],
Cell[76269, 1877, 496, 8, 50, "Text",ExpressionUUID->"fd308a6a-11b3-4917-b2e7-1b27201b73dd"],
Cell[76768, 1887, 811, 22, 65, "Input",ExpressionUUID->"d5d2afe4-635d-48f3-924a-40e441dbab45"],
Cell[CellGroupData[{
Cell[77604, 1913, 232, 4, 42, "Input",ExpressionUUID->"937bcb4e-a832-4f88-bd94-3c3cce547df4"],
Cell[77839, 1919, 176, 2, 48, "Output",ExpressionUUID->"82638258-3af9-4ee3-bfe8-ace398fbaab5"]
}, Open  ]],
Cell[78030, 1924, 1246, 31, 179, "Input",ExpressionUUID->"909514d5-7af8-4eb2-82e2-edec040d9976"],
Cell[CellGroupData[{
Cell[79301, 1959, 235, 4, 42, "Input",ExpressionUUID->"9ff9dec2-4cdb-4ca5-b588-b1f998a2376d"],
Cell[CellGroupData[{
Cell[79561, 1967, 497, 11, 33, "Print",ExpressionUUID->"52e44d3b-419c-4e22-8104-96ff9617cc35"],
Cell[80061, 1980, 493, 11, 33, "Print",ExpressionUUID->"617bfea7-20f6-42e9-a1b2-a4d25b07db3b"],
Cell[80557, 1993, 495, 11, 33, "Print",ExpressionUUID->"f76c9970-92d0-42b9-8781-30e309857fda"],
Cell[81055, 2006, 495, 11, 33, "Print",ExpressionUUID->"e5a1af79-b769-40d6-a964-dc3eb445b78b"],
Cell[81553, 2019, 495, 11, 33, "Print",ExpressionUUID->"15c83711-772d-44e1-a646-53de1fefdadb"],
Cell[82051, 2032, 493, 11, 33, "Print",ExpressionUUID->"e1ba2563-3d2e-44fd-b547-8e6b7b1706dc"]
}, Open  ]],
Cell[82559, 2046, 203, 3, 48, "Output",ExpressionUUID->"07ef1afb-a7bc-4b23-81b3-2845f0db7aaf"]
}, Open  ]],
Cell[82777, 2052, 544, 8, 50, "Text",ExpressionUUID->"25203ce2-a82e-4b4f-8c70-3ec74ec52543"],
Cell[83324, 2062, 1075, 30, 148, "Input",ExpressionUUID->"6f391006-e275-4a8f-bf70-9f0d53a8c498"],
Cell[CellGroupData[{
Cell[84424, 2096, 1205, 26, 173, "Input",ExpressionUUID->"d9e86937-34b2-484a-874e-eec338690b98"],
Cell[85632, 2124, 543, 9, 48, "Output",ExpressionUUID->"1d4e8e91-48fb-4fc5-aa26-21b951b9148f"],
Cell[86178, 2135, 543, 9, 48, "Output",ExpressionUUID->"79145069-3d67-4c39-9fca-30609b2989f9"],
Cell[86724, 2146, 548, 9, 48, "Output",ExpressionUUID->"5365eaeb-8d49-4896-82a4-acafe457f456"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87309, 2160, 1004, 29, 173, "Input",ExpressionUUID->"bca4df4e-53f3-4e57-8479-3636992d1d0c"],
Cell[88316, 2191, 334, 7, 48, "Output",ExpressionUUID->"ab1f9c47-0bfb-4ac6-9e97-ef1630e69ee5"],
Cell[88653, 2200, 332, 7, 48, "Output",ExpressionUUID->"c82dc4c5-2ed0-4402-aa0a-4aa2e52fe2c1"],
Cell[88988, 2209, 332, 7, 64, "Output",ExpressionUUID->"f0794a25-4fc6-455c-918f-3c9b5be24bab"]
}, Open  ]],
Cell[89335, 2219, 615, 15, 50, "Text",ExpressionUUID->"98d2057e-95c6-4c70-b302-84817bd07e1a"],
Cell[89953, 2236, 599, 9, 50, "Text",ExpressionUUID->"05fd0ce1-3976-46e6-997b-a901d2baa2e1"],
Cell[90555, 2247, 1419, 33, 232, "Input",ExpressionUUID->"c4876fad-14d4-4209-bbe7-1852328d663f"],
Cell[CellGroupData[{
Cell[91999, 2284, 369, 6, 42, "Input",ExpressionUUID->"817f7d7e-d7d1-4f8b-b54b-5a7e9869aad5"],
Cell[92371, 2292, 405, 6, 48, "Output",ExpressionUUID->"92933dbe-281c-48fe-977a-8fab9cdd3ac6"]
}, Open  ]],
Cell[92791, 2301, 1382, 35, 300, "Input",ExpressionUUID->"e3aee6d1-8a40-4e58-a27d-5cf67072f3d8"],
Cell[CellGroupData[{
Cell[94198, 2340, 213, 3, 42, "Input",ExpressionUUID->"1eeffd6a-39ed-4de9-8a26-df030a6a4182"],
Cell[94414, 2345, 230, 3, 48, "Output",ExpressionUUID->"3becd172-d2b0-43d5-a2bc-de9865299f75"]
}, Open  ]],
Cell[94659, 2351, 648, 10, 50, "Text",ExpressionUUID->"5495d175-cc9d-499b-9e42-091446fd74cb"],
Cell[95310, 2363, 1093, 30, 151, "Input",ExpressionUUID->"3946ecee-de7c-4b80-8170-c67a64eeb7fb"],
Cell[CellGroupData[{
Cell[96428, 2397, 235, 4, 42, "Input",ExpressionUUID->"d156d953-985e-4389-8045-36df270a72a4"],
Cell[96666, 2403, 402, 8, 48, "Output",ExpressionUUID->"752a68f0-42e2-40a4-84cd-e1d18702894d"]
}, Open  ]],
Cell[97083, 2414, 151, 3, 50, "Text",ExpressionUUID->"87d515ad-0bb0-4fb6-a379-820002693e12"],
Cell[97237, 2419, 1264, 34, 151, "Input",ExpressionUUID->"0434e259-851c-42e4-b0c5-81964ee5ac24"],
Cell[CellGroupData[{
Cell[98526, 2457, 180, 3, 42, "Input",ExpressionUUID->"70889d4d-099f-418b-8876-88185337c561"],
Cell[98709, 2462, 233, 3, 48, "Output",ExpressionUUID->"92d17493-4a84-4091-a34c-ec46c6fb9b6c"]
}, Open  ]],
Cell[98957, 2468, 700, 10, 50, "Text",ExpressionUUID->"eb975070-0b44-4e0b-ae1d-a82d43ec29d9"],
Cell[99660, 2480, 1283, 35, 148, "Input",ExpressionUUID->"3e81f24f-d331-44ed-ba76-4adb35ac4e02"],
Cell[CellGroupData[{
Cell[100968, 2519, 278, 5, 42, "Input",ExpressionUUID->"ec148a35-4213-4956-879f-8b8b86dbdfc3"],
Cell[101249, 2526, 303, 6, 48, "Output",ExpressionUUID->"f2f943aa-aa28-4ad2-aac3-916d182a9478"]
}, Open  ]],
Cell[101567, 2535, 751, 11, 50, "Text",ExpressionUUID->"41f4a64c-bda5-4cb1-9aeb-0ceddf377071"],
Cell[102321, 2548, 888, 22, 154, "Input",ExpressionUUID->"89a83fe0-e6bc-4fb0-b4d6-124d269c6b2c"],
Cell[CellGroupData[{
Cell[103234, 2574, 207, 3, 42, "Input",ExpressionUUID->"608d21fc-feb9-4105-8d0d-01649973f50f"],
Cell[CellGroupData[{
Cell[103466, 2581, 523, 12, 33, "Print",ExpressionUUID->"dca1b84b-70d5-4a6d-adba-4dc5eec1e709"],
Cell[103992, 2595, 525, 12, 33, "Print",ExpressionUUID->"c989595b-0dbd-465c-92db-78bc6c6d7530"],
Cell[104520, 2609, 525, 12, 33, "Print",ExpressionUUID->"13ba69f0-6429-4964-96bc-7e3dfe72e8b5"],
Cell[105048, 2623, 523, 12, 33, "Print",ExpressionUUID->"584002e4-8a7a-49c9-ac65-b049b14c8f59"],
Cell[105574, 2637, 525, 12, 33, "Print",ExpressionUUID->"cd8848bd-994e-48dd-87d4-79d7f3b7d09a"]
}, Open  ]]
}, Open  ]],
Cell[106126, 2653, 802, 12, 50, "Text",ExpressionUUID->"3f73d67f-5fbd-45df-9601-44220fe38a5b"],
Cell[106931, 2667, 918, 26, 126, "Input",ExpressionUUID->"a7d473f9-b3e4-4fc8-b617-44c5df46e36d"],
Cell[CellGroupData[{
Cell[107874, 2697, 283, 5, 42, "Input",ExpressionUUID->"8ef2e2a2-c32c-4841-b4a8-48bbd2e62f4e"],
Cell[108160, 2704, 198, 3, 64, "Output",ExpressionUUID->"efdbd30f-8a24-45d0-bfba-e87f2cf0808b"]
}, Open  ]],
Cell[108373, 2710, 848, 12, 50, "Text",ExpressionUUID->"bf7d4ed3-e304-4bea-a828-1ebe8fc5e22b"],
Cell[109224, 2724, 3438, 89, 448, "Input",ExpressionUUID->"c295394f-e27b-4c00-9a32-83f2f101c44e"],
Cell[CellGroupData[{
Cell[112687, 2817, 888, 17, 94, "Input",ExpressionUUID->"374d98b6-4466-4beb-91ba-d8d323b0f9ea"],
Cell[CellGroupData[{
Cell[113600, 2838, 674, 18, 33, "Print",ExpressionUUID->"d2e95d40-3643-40d7-8388-035928edcd9f"],
Cell[114277, 2858, 674, 18, 33, "Print",ExpressionUUID->"a57ebfcb-77e3-4a0a-a05d-28598f5db11f"],
Cell[114954, 2878, 676, 18, 33, "Print",ExpressionUUID->"420c08f8-d0d5-4302-bb74-0e092870660d"],
Cell[115633, 2898, 676, 18, 33, "Print",ExpressionUUID->"2a976f5f-4bdf-4097-ab95-327b8d68c478"],
Cell[116312, 2918, 675, 18, 33, "Print",ExpressionUUID->"a1a5546c-03cc-42b0-962e-019dbb60bc55"],
Cell[116990, 2938, 674, 18, 33, "Print",ExpressionUUID->"f83d0e2b-3777-499c-a9f7-0f575f310328"],
Cell[117667, 2958, 674, 18, 33, "Print",ExpressionUUID->"f37f0883-e5f4-4a70-a1c9-0e5b0ede06e3"],
Cell[118344, 2978, 676, 18, 33, "Print",ExpressionUUID->"dfdfad90-24f4-48c2-a774-e52fbe92e82a"],
Cell[119023, 2998, 674, 18, 33, "Print",ExpressionUUID->"df635467-88c8-4624-a324-281f68cbc953"],
Cell[119700, 3018, 675, 18, 33, "Print",ExpressionUUID->"c6d3fe88-de14-4d2a-b92b-8cb2034d43b4"],
Cell[120378, 3038, 676, 18, 33, "Print",ExpressionUUID->"49009516-3999-41b7-8e52-70c05cccd130"],
Cell[121057, 3058, 675, 18, 33, "Print",ExpressionUUID->"fc0a9471-f1ca-4741-aeac-39d4d27ca5c8"],
Cell[121735, 3078, 677, 18, 33, "Print",ExpressionUUID->"840876e0-89e9-4f69-80f8-d243840e3823"],
Cell[122415, 3098, 677, 18, 33, "Print",ExpressionUUID->"4e4fc6bd-1765-4f02-82d5-e379d7bdd964"],
Cell[123095, 3118, 677, 18, 33, "Print",ExpressionUUID->"5cf57b1b-5e5c-439c-a79d-01a132398363"]
}, Open  ]],
Cell[123787, 3139, 413, 9, 64, "Output",ExpressionUUID->"fd89abbb-ba42-42f7-ab78-c8d82274ab4f"]
}, Open  ]],
Cell[124215, 3151, 897, 13, 50, "Text",ExpressionUUID->"b7df28de-a7b5-4607-b009-303e5b64519a"],
Cell[125115, 3166, 2599, 69, 334, "Input",ExpressionUUID->"1c360ceb-8b7a-4163-8d1f-09e5a23d09c0"],
Cell[CellGroupData[{
Cell[127739, 3239, 532, 12, 94, "Input",ExpressionUUID->"f990d089-dc70-4f48-9298-080adeaa31e9"],
Cell[128274, 3253, 200, 3, 64, "Output",ExpressionUUID->"e5fc7c29-d650-4e13-bbb2-d3162b25bfdf"]
}, Open  ]]
}
]
*)

