(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13761,        307]
NotebookOptionsPosition[     11866,        271]
NotebookOutlinePosition[     12300,        288]
CellTagsIndexPosition[     12257,        285]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8051380973223143`*^9, 3.8051381062557983`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"0eef719d-196d-490a-bf8d-3df344aacf29"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SD", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"digito", "=", 
      RowBox[{"Mod", "[", 
       RowBox[{"n", ",", "10"}], "]"}]}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"n", "\[Equal]", "0"}], ",", "0", ",", 
      RowBox[{"digito", "+", 
       RowBox[{"SD", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "digito"}], ")"}], "/", "10"}], "]"}]}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8051378262496777`*^9, 3.805137841024522*^9}, {
  3.805137886123187*^9, 3.805137931755773*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"fc3e4ba4-7a9f-4cc1-a9d0-2f07b76ef577"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SD", "[", "123456789", "]"}]], "Input",
 CellChangeTimes->{{3.805137935821481*^9, 3.805137952126527*^9}, {
  3.8051385081314864`*^9, 3.805138511882924*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"5bfbee8f-cfff-4d74-8e9f-edd821c70e44"],

Cell[BoxData["45"], "Output",
 CellChangeTimes->{{3.8051379423287935`*^9, 3.805137949720343*^9}, 
   3.8051380913512316`*^9, {3.805138509338296*^9, 3.8051385127379847`*^9}},
 CellLabel->"Out[6]=",ExpressionUUID->"168f2a55-7268-4da2-b85e-a4064f3e353c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumaDigi", "[", 
  RowBox[{"123456789", ",", 
   RowBox[{"steps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8051380932820168`*^9, 3.8051381407842855`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"84a2385d-f39c-4ab8-9a69-faee9d240eb3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "123456789", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "123456789", "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", 
   "123456789", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "123456789", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "45"}],
  SequenceForm[
  "SumaDigi[", 123456789, "] = ", 9, "+SumaDigi[(", 123456789, "-Mod[", 
   123456789, ",", "10])/10] = ", 9, "+SumaDigi[(", 123456789, "-", 9, 
   ")/10] = ", 45],
  Editable->False]], "Print",
 CellChangeTimes->{3.805138141468459*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"d5214647-d36a-4dc8-8aec-557cc8b3609b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "12345678", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "12345678", "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", 
   "12345678", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "12345678", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "36"}],
  SequenceForm[
  "SumaDigi[", 12345678, "] = ", 8, "+SumaDigi[(", 12345678, "-Mod[", 
   12345678, ",", "10])/10] = ", 8, "+SumaDigi[(", 12345678, "-", 8, 
   ")/10] = ", 36],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051381414744415`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"849256e1-624b-4be4-9529-eab30fac9c0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1234567", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1234567",
    "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "1234567", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1234567",
    "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "28"}],
  SequenceForm[
  "SumaDigi[", 1234567, "] = ", 7, "+SumaDigi[(", 1234567, "-Mod[", 1234567, 
   ",", "10])/10] = ", 7, "+SumaDigi[(", 1234567, "-", 7, ")/10] = ", 28],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051381414784307`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"70329fdd-c357-4a96-8937-0aca50757d41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "123456", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "123456", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "123456", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "123456", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "21"}],
  SequenceForm[
  "SumaDigi[", 123456, "] = ", 6, "+SumaDigi[(", 123456, "-Mod[", 123456, ",",
    "10])/10] = ", 6, "+SumaDigi[(", 123456, "-", 6, ")/10] = ", 21],
  Editable->False]], "Print",
 CellChangeTimes->{3.805138141480426*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"8d35996a-062d-426d-b963-c8dcd9a2c406"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "12345", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "12345", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "12345", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "12345", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "15"}],
  SequenceForm[
  "SumaDigi[", 12345, "] = ", 5, "+SumaDigi[(", 12345, "-Mod[", 12345, ",", 
   "10])/10] = ", 5, "+SumaDigi[(", 12345, "-", 5, ")/10] = ", 15],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051381414814224`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"4e01af6a-40e7-42f4-bca8-590e1417f4de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1234", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1234", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "1234", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1234", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "10"}],
  SequenceForm[
  "SumaDigi[", 1234, "] = ", 4, "+SumaDigi[(", 1234, "-Mod[", 1234, ",", 
   "10])/10] = ", 4, "+SumaDigi[(", 1234, "-", 4, ")/10] = ", 10],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051381414834175`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"eaeb6b5b-1d13-4183-a1c3-9760865b0a7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "123", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "123", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "123", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "123", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm[
  "SumaDigi[", 123, "] = ", 3, "+SumaDigi[(", 123, "-Mod[", 123, ",", 
   "10])/10] = ", 3, "+SumaDigi[(", 123, "-", 3, ")/10] = ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051381414854116`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"55b2eac8-e013-4fc5-8742-c122d6f29a91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm[
  "SumaDigi[", 12, "] = ", 2, "+SumaDigi[(", 12, "-Mod[", 12, ",", 
   "10])/10] = ", 2, "+SumaDigi[(", 12, "-", 2, ")/10] = ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051381414874067`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"3a3eb24e-4d5e-44ea-9d2a-aedbc7cbe239"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm[
  "SumaDigi[", 1, "] = ", 1, "+SumaDigi[(", 1, "-Mod[", 1, ",", "10])/10] = ",
    1, "+SumaDigi[(", 1, "-", 1, ")/10] = ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051381414884033`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"a21ff7e4-5771-4a30-8f22-3ac70ba6fe61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["SumaDigi[", 0, "] = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051381414903984`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"fe8865b5-a65a-49e5-b680-2d847ac68b93"]
}, Open  ]],

Cell[BoxData["45"], "Output",
 CellChangeTimes->{3.805138141491396*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"0377f0b4-6d2f-463e-ad6d-30260b09d77f"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{Automatic, -5.5}, {-5.5, Automatic}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2bca99ba-9811-45b4-8fd1-2c4fb11a9627"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 63, "Input",ExpressionUUID->"0eef719d-196d-490a-bf8d-3df344aacf29"],
Cell[763, 25, 720, 20, 178, "Input",ExpressionUUID->"fc3e4ba4-7a9f-4cc1-a9d0-2f07b76ef577"],
Cell[CellGroupData[{
Cell[1508, 49, 258, 4, 63, "Input",ExpressionUUID->"5bfbee8f-cfff-4d74-8e9f-edd821c70e44"],
Cell[1769, 55, 251, 3, 107, "Output",ExpressionUUID->"168f2a55-7268-4da2-b85e-a4064f3e353c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2057, 63, 277, 5, 97, "Input",ExpressionUUID->"84a2385d-f39c-4ab8-9a69-faee9d240eb3"],
Cell[CellGroupData[{
Cell[2359, 72, 1024, 19, 131, "Print",ExpressionUUID->"d5214647-d36a-4dc8-8aec-557cc8b3609b"],
Cell[3386, 93, 1018, 19, 131, "Print",ExpressionUUID->"849256e1-624b-4be4-9529-eab30fac9c0d"],
Cell[4407, 114, 1006, 18, 131, "Print",ExpressionUUID->"70329fdd-c357-4a96-8937-0aca50757d41"],
Cell[5416, 134, 996, 18, 91, "Print",ExpressionUUID->"8d35996a-062d-426d-b963-c8dcd9a2c406"],
Cell[6415, 154, 990, 18, 91, "Print",ExpressionUUID->"4e01af6a-40e7-42f4-bca8-590e1417f4de"],
Cell[7408, 174, 982, 18, 91, "Print",ExpressionUUID->"eaeb6b5b-1d13-4183-a1c3-9760865b0a7f"],
Cell[8393, 194, 972, 18, 91, "Print",ExpressionUUID->"55b2eac8-e013-4fc5-8742-c122d6f29a91"],
Cell[9368, 214, 964, 18, 91, "Print",ExpressionUUID->"3a3eb24e-4d5e-44ea-9d2a-aedbc7cbe239"],
Cell[10335, 234, 956, 18, 91, "Print",ExpressionUUID->"a21ff7e4-5771-4a30-8f22-3ac70ba6fe61"],
Cell[11294, 254, 392, 9, 50, "Print",ExpressionUUID->"fe8865b5-a65a-49e5-b680-2d847ac68b93"]
}, Open  ]],
Cell[11701, 266, 149, 2, 100, "Output",ExpressionUUID->"0377f0b4-6d2f-463e-ad6d-30260b09d77f"]
}, Open  ]]
}
]
*)

