(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      9788,        276]
NotebookOptionsPosition[      8113,        239]
NotebookOutlinePosition[      8547,        256]
CellTagsIndexPosition[      8504,        253]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"S1", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"suma_", ":", "0"}]}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "5"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "3"}], "+", "suma"}], ",", 
    RowBox[{"S1", "[", 
     RowBox[{
      RowBox[{"n", "-", "1"}], ",", 
      RowBox[{"suma", "+", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"n", "-", "2"}]], 
        RowBox[{"3", 
         RowBox[{"(", 
          RowBox[{"n", "-", "4"}], ")"}]}]]}]}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S2", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"suma", "=", "0"}], ",", "i"}], "}"}], ",", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "2"}], ",", 
       RowBox[{"i", "\[LessEqual]", 
        RowBox[{"n", "-", "3"}]}], ",", 
       RowBox[{
        RowBox[{"suma", "=", 
         RowBox[{"suma", "+", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"i", "+", "1"}]], 
           RowBox[{"3", 
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}]}]]}]}], ";", 
        RowBox[{"i", "++"}]}]}], "]"}], ";", "suma"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S3", "[", "n_", "]"}], ":=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"i", "+", "1"}]], 
     RowBox[{"3", 
      RowBox[{"(", 
       RowBox[{"i", "-", "1"}], ")"}]}]], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", 
      RowBox[{"n", "-", "3"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8075382200718555`*^9, 3.807538223333776*^9}, {
  3.8075383201501617`*^9, 3.807538357278014*^9}, {3.807538808977714*^9, 
  3.80753888408517*^9}, {3.807538938938431*^9, 3.807538968188307*^9}, {
  3.8075391530984015`*^9, 3.80753922809311*^9}, {3.8075394111362543`*^9, 
  3.807539417116212*^9}, {3.807539511688096*^9, 3.807539547576932*^9}, {
  3.807539581459076*^9, 3.8075395939497375`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"7dee7599-65e3-42be-bb27-f0e4345703c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"S1", "[", "i", "]"}], "\[Equal]", 
    RowBox[{"S2", "[", "i", "]"}], "\[Equal]", 
    RowBox[{"S3", "[", "i", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8075392306391554`*^9, 3.807539261214164*^9}, {
   3.8075392998245125`*^9, 3.8075393003870316`*^9}, {3.8075394251950903`*^9, 
   3.8075394320118475`*^9}, {3.807539555698161*^9, 3.807539564965327*^9}, 
   3.8075526075430536`*^9},
 CellLabel->"In[10]:=",ExpressionUUID->"929638c7-46c0-411a-8636-9ab786b0c96f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8075392619127874`*^9, 3.8075393011729107`*^9, 3.807539335612645*^9, {
   3.8075394030633316`*^9, 3.807539432794915*^9}, {3.8075395329796095`*^9, 
   3.8075395653512897`*^9}, {3.807539597120682*^9, 3.807539607086795*^9}, 
   3.8075396576108847`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"86b40eec-2436-44e0-b510-095900ca9197"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8075396197088385`*^9, 3.8075396231303215`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"6b4a4595-6bb6-4955-b979-c31f8c918cb4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PruebaADA3", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "1500", ",", "5"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8075396133068824`*^9, 3.807539650379304*^9}, {
  3.807539700375532*^9, 3.8075397008672166`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"ce0e0a39-4ed9-4837-a4f8-04cf29db23c8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer y segundo algoritmo fueron mejores: \"\>", 
   "\[InvisibleSpace]", "130"}],
  SequenceForm["El primer y segundo algoritmo fueron mejores: ", 130],
  Editable->False]], "Print",
 CellChangeTimes->{{3.80753966344339*^9, 3.80753967544022*^9}, {
  3.807539709688979*^9, 3.8075397595953274`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[17]:=",ExpressionUUID->"a644a4c5-4e8e-4c07-8acb-8fda09711c74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer y tercer algoritmo fueron mejores: \"\>", 
   "\[InvisibleSpace]", "174"}],
  SequenceForm["El primer y tercer algoritmo fueron mejores: ", 174],
  Editable->False]], "Print",
 CellChangeTimes->{{3.80753966344339*^9, 3.80753967544022*^9}, {
  3.807539709688979*^9, 3.80753975959731*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[17]:=",ExpressionUUID->"cd17015c-9afb-48f8-8658-348347d1beb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El segundo y tercer algoritmo fueron mejores: \"\>", 
   "\[InvisibleSpace]", "243"}],
  SequenceForm["El segundo y tercer algoritmo fueron mejores: ", 243],
  Editable->False]], "Print",
 CellChangeTimes->{{3.80753966344339*^9, 3.80753967544022*^9}, {
  3.807539709688979*^9, 3.8075397596003027`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[17]:=",ExpressionUUID->"0db5b374-f6f1-434f-838c-762a16642382"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se comportaron igual: \"\>", "\[InvisibleSpace]", "953"}],
  SequenceForm["Se comportaron igual: ", 953],
  Editable->False]], "Print",
 CellChangeTimes->{{3.80753966344339*^9, 3.80753967544022*^9}, {
  3.807539709688979*^9, 3.8075397596012993`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[17]:=",ExpressionUUID->"61819bb8-4ffd-4311-b451-6d7827f2e2b7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PruebaADA2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"S2", ",", "S3"}], "}"}], ",", "1500", ",", "5"}], "]"}]], "Input",
 CellChangeTimes->{{3.807539685440534*^9, 3.807539710204838*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"e2c08df7-69ba-4626-94dc-54b4f9f7da20"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "110"}],
  SequenceForm["El primer algoritmo fue mejor: ", 110],
  Editable->False]], "Print",
 CellChangeTimes->{3.807539771066502*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"42e80edc-4528-4266-93aa-56044be84c91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El segundo algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "193"}],
  SequenceForm["El segundo algoritmo fue mejor: ", 193],
  Editable->False]], "Print",
 CellChangeTimes->{3.8075397710684967`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"f9dcf7b3-aa05-411f-9c0e-e60232bb1848"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se comportaron igual: \"\>", "\[InvisibleSpace]", "1197"}],
  SequenceForm["Se comportaron igual: ", 1197],
  Editable->False]], "Print",
 CellChangeTimes->{3.8075397710714893`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"8373d57c-ede0-46ae-b14d-0f712bd99838"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"eb7f3eea-419d-4ad1-90f8-b3597431ab7d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 2352, 71, 628, "Input",ExpressionUUID->"7dee7599-65e3-42be-bb27-f0e4345703c5"],
Cell[CellGroupData[{
Cell[2935, 95, 611, 13, 125, "Input",ExpressionUUID->"929638c7-46c0-411a-8636-9ab786b0c96f"],
Cell[3549, 110, 627, 12, 144, "Output",ExpressionUUID->"86b40eec-2436-44e0-b510-095900ca9197"]
}, Open  ]],
Cell[4191, 125, 202, 3, 63, "Input",ExpressionUUID->"6b4a4595-6bb6-4955-b979-c31f8c918cb4"],
Cell[CellGroupData[{
Cell[4418, 132, 362, 8, 91, "Input",ExpressionUUID->"ce0e0a39-4ed9-4837-a4f8-04cf29db23c8"],
Cell[CellGroupData[{
Cell[4805, 144, 468, 10, 50, "Print",ExpressionUUID->"a644a4c5-4e8e-4c07-8acb-8fda09711c74"],
Cell[5276, 156, 463, 10, 50, "Print",ExpressionUUID->"cd17015c-9afb-48f8-8658-348347d1beb6"],
Cell[5742, 168, 468, 10, 50, "Print",ExpressionUUID->"0db5b374-f6f1-434f-838c-762a16642382"],
Cell[6213, 180, 416, 9, 50, "Print",ExpressionUUID->"61819bb8-4ffd-4311-b451-6d7827f2e2b7"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6678, 195, 295, 6, 91, "Input",ExpressionUUID->"e2c08df7-69ba-4626-94dc-54b4f9f7da20"],
Cell[CellGroupData[{
Cell[6998, 205, 365, 9, 50, "Print",ExpressionUUID->"42e80edc-4528-4266-93aa-56044be84c91"],
Cell[7366, 216, 369, 9, 49, "Print",ExpressionUUID->"f9dcf7b3-aa05-411f-9c0e-e60232bb1848"],
Cell[7738, 227, 347, 8, 49, "Print",ExpressionUUID->"8373d57c-ede0-46ae-b14d-0f712bd99838"]
}, Open  ]]
}, Open  ]]
}
]
*)

