(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     21951,        609]
NotebookOptionsPosition[     19494,        564]
NotebookOutlinePosition[     19928,        581]
CellTagsIndexPosition[     19885,        578]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.810290894291892*^9, 3.8102908968592615`*^9}, {
  3.810324963370403*^9, 
  3.810324968544794*^9}},ExpressionUUID->"29e6303d-19f1-4882-bdcc-\
0903ea7b3e47"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClasificacionRelBin", "[", 
   RowBox[{"R_", ",", "A_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"MR", "=", 
       RowBox[{
        RowBox[{"MatrizRelBin", "[", 
         RowBox[{"R", ",", "A", ",", "A"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", "list"}], "}"}], ",", 
    RowBox[{
     RowBox[{"list", "=", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{"MR", ",", "1"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"Diagonal", "[", "MR", "]"}], ",", "0"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Transpose", "[", "MR", "]"}], "\[Equal]", "MR"}], ",", 
       RowBox[{
        RowBox[{"Select", "[", 
         RowBox[{"list", ",", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"list", ",", 
             RowBox[{"Reverse", "[", "#", "]"}]}], "]"}], "&"}]}], "]"}], 
        "\[Equal]", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"UnionBooleana", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"ProductoBooleano", "[", 
             RowBox[{"MR", ",", "MR"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "MR"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "MR"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8102933689945087`*^9, 3.8102934888328147`*^9}, {
  3.8102944401889234`*^9, 3.8102945259599285`*^9}, {3.8102946568029785`*^9, 
  3.810294657163607*^9}, {3.810296044217739*^9, 3.8102960624260683`*^9}, {
  3.8102961272975473`*^9, 3.8102961377760096`*^9}, {3.810320570213023*^9, 
  3.810320571069398*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"cf36e7fe-c28a-4787-bf09-4e0a8d20d5cd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Range", "[", "4", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["R", "1"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["R", "2"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["R", "3"], "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["R", "4"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ClasificacionRelBin", "[", 
    RowBox[{
     SubscriptBox["R", "i"], ",", "A"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8103198961575713`*^9, 3.8103201075172772`*^9}, {
  3.810320141177359*^9, 3.810320250125137*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"2fa06dd8-f0b7-402b-8f81-d0ec6c13157e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "False", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False", ",", "False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "True", ",", "True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False", ",", "False", ",", "True"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.810320253400996*^9, 3.810320585269659*^9, 
  3.8103249873444*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"93d4d166-8c7d-4128-b0d4-ea8e3bb57604"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TipoRelacion", "[", 
  RowBox[{
   SubscriptBox["R", "4"], ",", "A"}], "]"}]], "Input",
 CellChangeTimes->{{3.8103215338367214`*^9, 3.8103215469707713`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"0b9d187d-dc81-4d91-930f-352d03f13f42"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es reflexiva, un contraejemplo es: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" no pertenece\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es reflexiva, un contraejemplo es: ", {2, 2}, 
   " no pertenece"],
  Editable->False]], "Print",
 CellChangeTimes->{3.810321547733227*^9, 3.810324990487395*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[29]:=",ExpressionUUID->"c5647593-5837-4a24-b3f8-8a60b174e3be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es sim\[EAcute]trica, un contraejemplo \
es: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" est\[AAcute] en la relaci\[OAcute]n pero \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" no pertenece\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es sim\[EAcute]trica, un contraejemplo es: ", {1, 
   2}, " est\[AAcute] en la relaci\[OAcute]n pero ", {2, 1}, " no pertenece"],
  Editable->False]], "Print",
 CellChangeTimes->{3.810321547733227*^9, 3.8103249904904175`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[29]:=",ExpressionUUID->"4029b7ab-45c4-4357-acaa-dd1efe3514ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es antisim\[EAcute]trica, un \
contraejemplo es: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], "\[InvisibleSpace]", "\<\" y \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" est\[AAcute]n en la relaci\[OAcute]n\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es antisim\[EAcute]trica, un contraejemplo es: ", {
   1, 3}, " y ", {3, 1}, " est\[AAcute]n en la relaci\[OAcute]n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.810321547733227*^9, 3.810324990493379*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[29]:=",ExpressionUUID->"06a64cc1-0202-43d4-a5aa-447b89816005"],

Cell[BoxData["\<\"La relaci\[OAcute]n es transitiva\"\>"], "Print",
 CellChangeTimes->{3.810321547733227*^9, 3.810324990494376*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[29]:=",ExpressionUUID->"16604017-60e0-43f2-b49b-80c736b6b72d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TipoMRelacion", "[", 
  RowBox[{
   SubscriptBox["R", "4"], ",", "A"}], "]"}]], "Input",
 CellChangeTimes->{{3.8103216365926657`*^9, 3.810321676841071*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"f9a3d051-7d2a-4c0a-8585-e804cec41af0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Una matriz que representa la relaci\[OAcute]n binaria es M = \
\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "1", "1"},
       {"0", "0", "0", "0"},
       {"1", "1", "1", "1"},
       {"0", "1", "0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Una matriz que representa la relaci\[OAcute]n binaria es M = ", 
   MatrixForm[{{1, 1, 1, 1}, {0, 0, 0, 0}, {1, 1, 1, 1}, {0, 1, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.810324992954999*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"734fb7b1-d270-4f9e-a4ac-3b2c6b795f0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es reflexiva, pues la matriz M tiene al \
menos un cero en la diagonal principal, por ejemplo en la entrada \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], "\[InvisibleSpace]", "\<\":\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es reflexiva, pues la matriz M tiene al menos un \
cero en la diagonal principal, por ejemplo en la entrada ", {2, 2}, ":"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.8103249929579916`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"a034da6c-911d-4b06-a4d5-07fd5c2c0c8e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "1", "1"},
     {"0", 
      StyleBox["0",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0"},
     {"1", "1", "1", "1"},
     {"0", "1", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.8103249929609847`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"9cb0e044-39b4-48b8-ab48-6722a0f64590"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es sim\[EAcute]trica, M \[NotEqual] \\!\
\\(\\*SuperscriptBox[\\(M\\), \\(t\\)]\\), por ejemplo las entradas \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], "\[InvisibleSpace]", "\<\" y \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" son distintas en la matriz M:\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es sim\[EAcute]trica, M \[NotEqual] \
\!\(\*SuperscriptBox[\(M\), \(t\)]\), por ejemplo las entradas ", {1, 2}, 
   " y ", {2, 1}, " son distintas en la matriz M:"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.8103249929629784`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"b63f224e-6a50-481c-aa8b-1efe94a19af9"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "1", "1"},
     {
      StyleBox["0",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0"},
     {"1", "1", "1", "1"},
     {"0", "1", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.81032499296597*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"60e9ad05-6e95-40fa-92a4-fff435c91f3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\!\\(\\*SuperscriptBox[\\(M\\), \\(t\\)]\\) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "1", "0"},
       {"1", "0", "1", "1"},
       {"1", "0", "1", "0"},
       {"1", "0", "1", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["\!\(\*SuperscriptBox[\(M\), \(t\)]\) = ", 
   MatrixForm[{{1, 0, 1, 0}, {1, 0, 1, 1}, {1, 0, 1, 0}, {1, 0, 1, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.810324992967964*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"b5de1eda-7c76-4d12-b41a-e06a2be4120a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es antisim\[EAcute]trica, por ejemplo \
en las entradas \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], "\[InvisibleSpace]", "\<\" y \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" de la matriz M, hay un uno:\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es antisim\[EAcute]trica, por ejemplo en las \
entradas ", {1, 3}, " y ", {3, 1}, " de la matriz M, hay un uno:"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.8103249929699593`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"68b2865f-bb49-4840-8486-604331e18390"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "1"},
     {"0", "0", "0", "0"},
     {
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "1", "1", "1"},
     {"0", "1", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.810324992971955*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"c4928a5d-ad36-45d4-bac7-7daa9553f155"],

Cell[BoxData["\<\"La relaci\[OAcute]n es transitiva\"\>"], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.810324992973948*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"d1babdcc-a378-4a0d-9647-f628335d3882"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"M\[CircleDot]M = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "1", "1"},
       {"0", "0", "0", "0"},
       {"1", "1", "1", "1"},
       {"0", "0", "0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["M\[CircleDot]M = ", 
   MatrixForm[{{1, 1, 1, 1}, {0, 0, 0, 0}, {1, 1, 1, 1}, {0, 0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.810324992975942*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"f36964dc-89c8-4357-84b6-3440eefe85ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(M\[CircleDot]M)\[Or]M = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "1", "1"},
       {"0", "0", "0", "0"},
       {"1", "1", "1", "1"},
       {"0", "1", "0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["(M\[CircleDot]M)\[Or]M = ", 
   MatrixForm[{{1, 1, 1, 1}, {0, 0, 0, 0}, {1, 1, 1, 1}, {0, 1, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.810321647359687*^9, 3.8103216772466288`*^9}, 
   3.8103249929779673`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[30]:=",ExpressionUUID->"df9e2082-e896-4eeb-8029-f79fb0997ec2"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e5035d9c-e699-47fb-94d4-0ab0ebf8d6f5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 231, 5, 63, "Input",ExpressionUUID->"29e6303d-19f1-4882-bdcc-0903ea7b3e47"],
Cell[792, 27, 2123, 57, 691, "Input",ExpressionUUID->"cf36e7fe-c28a-4787-bf09-4e0a8d20d5cd"],
Cell[CellGroupData[{
Cell[2940, 88, 2447, 78, 508, "Input",ExpressionUUID->"2fa06dd8-f0b7-402b-8f81-d0ec6c13157e"],
Cell[5390, 168, 595, 14, 231, "Output",ExpressionUUID->"93d4d166-8c7d-4128-b0d4-ea8e3bb57604"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6022, 187, 260, 5, 91, "Input",ExpressionUUID->"0b9d187d-dc81-4d91-930f-352d03f13f42"],
Cell[CellGroupData[{
Cell[6307, 196, 563, 14, 91, "Print",ExpressionUUID->"c5647593-5837-4a24-b3f8-8a60b174e3be"],
Cell[6873, 212, 793, 18, 131, "Print",ExpressionUUID->"4029b7ab-45c4-4357-acaa-dd1efe3514ca"],
Cell[7669, 232, 765, 17, 131, "Print",ExpressionUUID->"06a64cc1-0202-43d4-a5aa-447b89816005"],
Cell[8437, 251, 248, 4, 50, "Print",ExpressionUUID->"16604017-60e0-43f2-b49b-80c736b6b72d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8734, 261, 259, 5, 91, "Input",ExpressionUUID->"f9a3d051-7d2a-4c0a-8585-e804cec41af0"],
Cell[CellGroupData[{
Cell[9018, 270, 1107, 29, 203, "Print",ExpressionUUID->"734fb7b1-d270-4f9e-a4ac-3b2c6b795f0a"],
Cell[10128, 301, 711, 15, 131, "Print",ExpressionUUID->"a034da6c-911d-4b06-a4d5-07fd5c2c0c8e"],
Cell[10842, 318, 1011, 29, 152, "Print",ExpressionUUID->"9cb0e044-39b4-48b8-ab48-6722a0f64590"],
Cell[11856, 349, 901, 20, 131, "Print",ExpressionUUID->"b63f224e-6a50-481c-aa8b-1efe94a19af9"],
Cell[12760, 371, 1251, 36, 152, "Print",ExpressionUUID->"60e9ad05-6e95-40fa-92a4-fff435c91f3f"],
Cell[14014, 409, 1070, 28, 152, "Print",ExpressionUUID->"b5de1eda-7c76-4d12-b41a-e06a2be4120a"],
Cell[15087, 439, 791, 18, 131, "Print",ExpressionUUID->"68b2865f-bb49-4840-8486-604331e18390"],
Cell[15881, 459, 1252, 36, 152, "Print",ExpressionUUID->"c4928a5d-ad36-45d4-bac7-7daa9553f155"],
Cell[17136, 497, 278, 5, 50, "Print",ExpressionUUID->"d1babdcc-a378-4a0d-9647-f628335d3882"],
Cell[17417, 504, 1014, 27, 152, "Print",ExpressionUUID->"f36964dc-89c8-4357-84b6-3440eefe85ac"],
Cell[18434, 533, 1032, 27, 152, "Print",ExpressionUUID->"df9e2082-e896-4eeb-8029-f79fb0997ec2"]
}, Open  ]]
}, Open  ]]
}
]
*)

