(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    378138,       5823]
NotebookOptionsPosition[    376190,       5787]
NotebookOutlinePosition[    376624,       5804]
CellTagsIndexPosition[    376581,       5801]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8104073630075984`*^9, 3.810407365824215*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"3fa0caf8-d005-4cd2-ae7d-efa09e267e52"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClasificacionRelBin", "[", 
   RowBox[{"R_", ",", "A_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"MR", "=", 
       RowBox[{
        RowBox[{"MatrizRelBin", "[", 
         RowBox[{"R", ",", "A", ",", "A"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", "list"}], "}"}], ",", 
    RowBox[{
     RowBox[{"list", "=", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{"MR", ",", "1"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"Diagonal", "[", "MR", "]"}], ",", "0"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Transpose", "[", "MR", "]"}], "\[Equal]", "MR"}], ",", 
       RowBox[{
        RowBox[{"Select", "[", 
         RowBox[{"list", ",", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"list", ",", 
             RowBox[{"Reverse", "[", "#", "]"}]}], "]"}], "&"}]}], "]"}], 
        "\[Equal]", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"UnionBooleana", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"ProductoBooleano", "[", 
             RowBox[{"MR", ",", "MR"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "MR"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "MR"}]}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Range", "[", "100", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", 
   RowBox[{"RelBin", "[", 
    RowBox[{"\"\<Mod[a,3]==Mod[b,3]\>\"", ",", "A", ",", "A"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ClasificacionRelBin", "[", 
  RowBox[{"R", ",", "A"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "R", "]"}]}], "Input",
 CellChangeTimes->{{3.810408196291046*^9, 3.81040821842457*^9}, {
  3.810408441364467*^9, 3.8104085004728184`*^9}, {3.8104090066013904`*^9, 
  3.810409077246225*^9}, {3.810409934804635*^9, 3.810409942883334*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"4e2e8763-ba51-473c-8fb1-3c64262abad2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "False", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.8104085095640163`*^9, 3.810409089442187*^9, 
  3.8104098252790065`*^9, 3.8104099532168636`*^9, 3.8104100949283404`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"b5bf85c3-cd2a-4179-9c29-46f33b5b20e9"],

Cell[BoxData["3334"], "Output",
 CellChangeTimes->{3.8104085095640163`*^9, 3.810409089442187*^9, 
  3.8104098252790065`*^9, 3.8104099532168636`*^9, 3.810410094932332*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"561fdbd8-cba5-491f-bfe4-fc18d3f3f073"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TipoMRelacion", "[", 
  RowBox[{"R", ",", "A"}], "]"}]], "Input",
 CellChangeTimes->{{3.810409705274954*^9, 3.8104097071424475`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"f590c350-d63b-4498-8e05-9f5828dbdc84"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Una matriz que representa la relaci\[OAcute]n binaria es M = \
\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Una matriz que representa la relaci\[OAcute]n binaria es M = ", 
   MatrixForm[CompressedData["
1:eJztkLEJwDAAw5J+0pd6Quie/7cuvSEIIbBnId1rP+saY7z/54kdgEg0agWD
SDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWD
SDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWDSDTmB/NXD3c=
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.8104101077621202`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"39972a6f-489a-406b-a025-6e888bc28a6f"],

Cell[BoxData["\<\"La relaci\[OAcute]n es reflexiva, en la matriz M todos los \
elementos de la diagonal principal son iguales a uno:\"\>"], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.8104101078259497`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"0c08c888-56f3-415d-997a-2e83d9b7c6c2"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1"},
     {"0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0"},
     {"0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0"},
     {"1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1"},
     {"0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0"},
     {"0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1"},
     {"0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.810410107927678*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"80e9d4c4-9aed-4bb7-b570-6bd316948904"],

Cell[BoxData["\<\"La relaci\[OAcute]n es sim\[EAcute]trica, M = \
\\!\\(\\*SuperscriptBox[\\(M\\), \\(t\\)]\\)\"\>"], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.8104101079775457`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"5149e90e-d86c-4594-aab2-72005ebf5904"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\!\\(\\*SuperscriptBox[\\(M\\), \\(t\\)]\\) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["\!\(\*SuperscriptBox[\(M\), \(t\)]\) = ", 
   MatrixForm[CompressedData["
1:eJztkLEJwDAAw5J+0pd6Quie/7cuvSEIIbBnId1rP+saY7z/54kdgEg0agWD
SDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWD
SDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWDSDTmB/NXD3c=
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.81041010803938*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"c454652a-fa6c-4fd2-a486-18c04ab9380a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es antisim\[EAcute]trica, por ejemplo \
en las entradas \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], "\[InvisibleSpace]", "\<\" y \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" de la matriz M, hay un uno:\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es antisim\[EAcute]trica, por ejemplo en las \
entradas ", {1, 4}, " y ", {4, 1}, " de la matriz M, hay un uno:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.810410108082266*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"f21f0089-5109-421b-b967-91a64dd258ee"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"},
     {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0"},
     {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0"},
     {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
      "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
      "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
      "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.8104101081500854`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"6622e336-0f50-40d9-a62b-ebdffcc368b3"],

Cell[BoxData["\<\"La relaci\[OAcute]n es transitiva\"\>"], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.8104101114429655`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"3deaed1b-6e47-4ebb-925e-44cc732e2ca1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"M\[CircleDot]M = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["M\[CircleDot]M = ", 
   MatrixForm[CompressedData["
1:eJztkLEJwDAAw5J+0pd6Quie/7cuvSEIIbBnId1rP+saY7z/54kdgEg0agWD
SDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWD
SDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWDSDTmB/NXD3c=
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.810410114825898*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"e1c18c41-228f-4691-903b-4c394ace6b34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(M\[CircleDot]M)\[Or]M = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"},
       {"0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0"},
       {"0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0"},
       {"1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", 
        "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", 
        "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", "0", "1", "0", 
        "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["(M\[CircleDot]M)\[Or]M = ", 
   MatrixForm[CompressedData["
1:eJztkLEJwDAAw5J+0pd6Quie/7cuvSEIIbBnId1rP+saY7z/54kdgEg0agWD
SDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWD
SDRqBYNINGoFg0g0agWDSDRqBYNINGoFg0g0agWDSDTmB/NXD3c=
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.8104101149316177`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"32edc40c-1d54-41ce-b323-939f290bb9a5"],

Cell[BoxData["\<\"La relaci\[OAcute]n es de equivalencia\"\>"], "Print",
 CellChangeTimes->{3.810409836810848*^9, 3.810410061149537*^9, 
  3.8104101149655266`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"5d443fea-1e04-4ae7-8f46-22cfb500326c"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"99ae0190-25ef-4fac-9563-fb8491fb0d93"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"3fa0caf8-d005-4cd2-ae7d-efa09e267e52"],
Cell[CellGroupData[{
Cell[783, 27, 2437, 66, 926, "Input",ExpressionUUID->"4e2e8763-ba51-473c-8fb1-3c64262abad2"],
Cell[3223, 95, 325, 5, 100, "Output",ExpressionUUID->"b5bf85c3-cd2a-4179-9c29-46f33b5b20e9"],
Cell[3551, 102, 248, 3, 100, "Output",ExpressionUUID->"561fdbd8-cba5-491f-bfe4-fc18d3f3f073"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3836, 110, 235, 4, 63, "Input",ExpressionUUID->"f590c350-d63b-4498-8e05-9f5828dbdc84"],
Cell[CellGroupData[{
Cell[4096, 118, 58331, 829, 3656, "Print",ExpressionUUID->"39972a6f-489a-406b-a025-6e888bc28a6f"],
Cell[62430, 949, 355, 6, 131, "Print",ExpressionUUID->"0c08c888-56f3-415d-997a-2e83d9b7c6c2"],
Cell[62788, 957, 80160, 1462, 3589, "Print",ExpressionUUID->"80e9d4c4-9aed-4bb7-b570-6bd316948904"],
Cell[142951, 2421, 333, 6, 50, "Print",ExpressionUUID->"5149e90e-d86c-4594-aab2-72005ebf5904"],
Cell[143287, 2429, 58291, 828, 3589, "Print",ExpressionUUID->"c454652a-fa6c-4fd2-a486-18c04ab9380a"],
Cell[201581, 3259, 783, 18, 131, "Print",ExpressionUUID->"f21f0089-5109-421b-b967-91a64dd258ee"],
Cell[202367, 3279, 56740, 832, 3589, "Print",ExpressionUUID->"6622e336-0f50-40d9-a62b-ebdffcc368b3"],
Cell[259110, 4113, 274, 5, 50, "Print",ExpressionUUID->"3deaed1b-6e47-4ebb-925e-44cc732e2ca1"],
Cell[259387, 4120, 58236, 827, 3589, "Print",ExpressionUUID->"e1c18c41-228f-4691-903b-4c394ace6b34"],
Cell[317626, 4949, 58254, 827, 3589, "Print",ExpressionUUID->"32edc40c-1d54-41ce-b323-939f290bb9a5"],
Cell[375883, 5778, 279, 5, 50, "Print",ExpressionUUID->"5d443fea-1e04-4ae7-8f46-22cfb500326c"]
}, Open  ]]
}, Open  ]]
}
]
*)

