(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    114197,       2000]
NotebookOptionsPosition[    111632,       1954]
NotebookOutlinePosition[    112066,       1971]
CellTagsIndexPosition[    112023,       1968]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8104073630075984`*^9, 3.810407365824215*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"26eb7848-2b76-40ef-909e-68141915affd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClasificacionRelBin", "[", 
   RowBox[{"R_", ",", "A_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"MR", "=", 
       RowBox[{
        RowBox[{"MatrizRelBin", "[", 
         RowBox[{"R", ",", "A", ",", "A"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", "list"}], "}"}], ",", 
    RowBox[{
     RowBox[{"list", "=", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{"MR", ",", "1"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"Diagonal", "[", "MR", "]"}], ",", "0"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Transpose", "[", "MR", "]"}], "\[Equal]", "MR"}], ",", 
       RowBox[{
        RowBox[{"Select", "[", 
         RowBox[{"list", ",", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"list", ",", 
             RowBox[{"Reverse", "[", "#", "]"}]}], "]"}], "&"}]}], "]"}], 
        "\[Equal]", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"UnionBooleana", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"ProductoBooleano", "[", 
             RowBox[{"MR", ",", "MR"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "MR"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "MR"}]}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"2", ",", "100", ",", "2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", 
   RowBox[{"RelBin", "[", 
    RowBox[{"\"\<IntegerQ[Log[b,a]]\>\"", ",", "A", ",", "A"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ClasificacionRelBin", "[", 
  RowBox[{"R", ",", "A"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "R", "]"}]}], "Input",
 CellChangeTimes->{{3.810408196291046*^9, 3.81040821842457*^9}, {
  3.810408441364467*^9, 3.8104085004728184`*^9}, {3.8104090066013904`*^9, 
  3.810409077246225*^9}, {3.810409934804635*^9, 3.810409942883334*^9}, {
  3.8104104996762075`*^9, 3.8104105281578774`*^9}, {3.81041103473306*^9, 
  3.81041104343685*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"217a9f30-9cee-4d3c-85c7-2a95c7fe7d1b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.810410529974351*^9, 3.8104110005567656`*^9, 
  3.810411044605133*^9, 3.8104120842240405`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"24e350ee-b7d4-4d84-81d3-2f4676223dd4"],

Cell[BoxData["60"], "Output",
 CellChangeTimes->{3.810410529974351*^9, 3.8104110005567656`*^9, 
  3.810411044605133*^9, 3.810412084241869*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"b32d7db8-afbd-4e11-aa5b-9391451a5c01"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TipoRelacion", "[", 
  RowBox[{"R", ",", "A"}], "]"}]], "Input",
 CellChangeTimes->{{3.810410533580861*^9, 3.8104105428050137`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"af46a985-d5e6-4f23-a8e4-5e9c31467a3a"],

Cell[CellGroupData[{

Cell[BoxData["\<\"La relaci\[OAcute]n es reflexiva\"\>"], "Print",
 CellChangeTimes->{
  3.810410543382961*^9, {3.810411003298173*^9, 3.8104110057271547`*^9}, 
   3.810412086607669*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"6e4f428d-c7cb-4b6b-8eec-11dc58ef4e90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es sim\[EAcute]trica, un contraejemplo \
es: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" est\[AAcute] en la relaci\[OAcute]n pero \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" no pertenece\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es sim\[EAcute]trica, un contraejemplo es: ", {4, 
   2}, " est\[AAcute] en la relaci\[OAcute]n pero ", {2, 4}, " no pertenece"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.810410543382961*^9, {3.810411003298173*^9, 3.8104110057271547`*^9}, 
   3.810412086607669*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"8baf0039-3415-4b2f-80cf-fd16826bebb6"],

Cell[BoxData["\<\"La relaci\[OAcute]n es antisim\[EAcute]trica\"\>"], "Print",
 CellChangeTimes->{
  3.810410543382961*^9, {3.810411003298173*^9, 3.8104110057271547`*^9}, 
   3.810412086607669*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"6c88467b-c7fa-4a4a-a4bd-300dda0e32dc"],

Cell[BoxData["\<\"La relaci\[OAcute]n es transitiva\"\>"], "Print",
 CellChangeTimes->{
  3.810410543382961*^9, {3.810411003298173*^9, 3.8104110057271547`*^9}, 
   3.810412086607669*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"3cd0cd9f-93e8-4cea-99f5-5a367599c148"],

Cell[BoxData["\<\"La relaci\[OAcute]n es de orden parcial\"\>"], "Print",
 CellChangeTimes->{
  3.810410543382961*^9, {3.810411003298173*^9, 3.8104110057271547`*^9}, 
   3.810412086607669*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"79c03fee-5d9b-42d0-86a5-2f713a8d905e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TipoMRelacion", "[", 
  RowBox[{"R", ",", "A"}], "]"}]], "Input",
 CellChangeTimes->{{3.8104105469244757`*^9, 3.8104105535144396`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"a5bb2474-c85c-4e5f-87f4-c3563bb85194"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Una matriz que representa la relaci\[OAcute]n binaria es M = \
\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Una matriz que representa la relaci\[OAcute]n binaria es M = ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmJiYGAwgmJGBlIBI+laSLaFkRyHDUIt0LAafA4boVoY8XKHli2j
Wka1UFsLsLzCZ9KQ8suollEtQ1ULSRoZAVNSAkk=
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.810412089424059*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"4d67ad04-ae6c-46ab-93dd-1b15e9c5d5c8"],

Cell[BoxData["\<\"La relaci\[OAcute]n es reflexiva, en la matriz M todos los \
elementos de la diagonal principal son iguales a uno:\"\>"], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.81041208945385*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"197a94f8-8642-4fa0-803c-ebd9db465052"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0"},
     {"1", "1", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0"},
     {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", 
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.810412089476225*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"cbdab4e0-4e74-4f0a-b07c-728edc357a86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es sim\[EAcute]trica, M \[NotEqual] \\!\
\\(\\*SuperscriptBox[\\(M\\), \\(t\\)]\\), por ejemplo las entradas \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], "\[InvisibleSpace]", "\<\" y \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" son distintas en la matriz M:\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es sim\[EAcute]trica, M \[NotEqual] \
\!\(\*SuperscriptBox[\(M\), \(t\)]\), por ejemplo las entradas ", {1, 2}, 
   " y ", {2, 1}, " son distintas en la matriz M:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.8104120894852014`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"c05686c9-b9f4-4344-9219-3985cd5135c7"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      StyleBox["0",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontColor->RGBColor[1, 0, 0]], "1", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "1", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "1", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "1", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "1", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "1", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "1", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "1", "0"},
     {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.8104120894991636`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"e103ebd6-b2fc-4212-83c0-4b046a8b80e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\!\\(\\*SuperscriptBox[\\(M\\), \\(t\\)]\\) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "0", "1", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1"},
       {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["\!\(\*SuperscriptBox[\(M\), \(t\)]\) = ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmJiYGAwgmJGRgZGEMUAATCaAQcfIYZNBqc4IxFqiDEHvxwxxqIp
JkkLGbaMahnVMqplVMuollEto1pGtdBECwB19wJJ
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.8104120895077515`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"88bfa724-37f0-451d-a5c4-d94f0f08a0df"],

Cell[BoxData["\<\"La relaci\[OAcute]n es antisim\[EAcute]trica\"\>"], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.810412089531073*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"229fc472-9977-4b0a-b569-f3db60a7c0ec"],

Cell[BoxData["\<\"La relaci\[OAcute]n es transitiva\"\>"], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.810412089757739*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"fba942e6-8ab3-4568-9eb2-db5681d6ac99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"M\[CircleDot]M = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["M\[CircleDot]M = ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmJiYGAwgmJGBlIBI+laSLaFkRyHDUIt0LAafA4boVoY8XKHli2j
Wka1UFsLsLzCZ9KQ8suollEtQ1ULSRoZAVNSAkk=
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.8104120899912653`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"b95ce378-c91a-4146-8be8-453a7b3ec6e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(M\[CircleDot]M)\[Or]M = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"1", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", 
        "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "1", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "1", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "1", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "1", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "1", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "1", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "1", "0"},
       {"0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
        "0", "0", "0", "0", "0", "0", "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["(M\[CircleDot]M)\[Or]M = ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmJiYGAwgmJGBlIBI+laSLaFkRyHDUIt0LAafA4boVoY8XKHli2j
Wka1UFsLsLzCZ9KQ8suollEtQ1ULSRoZAVNSAkk=
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.8104120900095787`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"e304ee45-37ee-4e70-a5bc-2e224386ce3e"],

Cell[BoxData["\<\"La relaci\[OAcute]n es de orden parcial\"\>"], "Print",
 CellChangeTimes->{3.810410554299582*^9, 3.810411008438281*^9, 
  3.810412090017557*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"bc6cff74-b884-4fd9-add4-fe24baf4dea3"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"80ada2ea-8914-4b23-865f-e585afe59c41"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"26eb7848-2b76-40ef-909e-68141915affd"],
Cell[CellGroupData[{
Cell[783, 27, 2575, 70, 926, "Input",ExpressionUUID->"217a9f30-9cee-4d3c-85c7-2a95c7fe7d1b"],
Cell[3361, 99, 299, 5, 100, "Output",ExpressionUUID->"24e350ee-b7d4-4d84-81d3-2f4676223dd4"],
Cell[3663, 106, 220, 3, 100, "Output",ExpressionUUID->"b32d7db8-afbd-4e11-aa5b-9391451a5c01"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3920, 114, 234, 4, 63, "Input",ExpressionUUID->"af46a985-d5e6-4f23-a8e4-5e9c31467a3a"],
Cell[CellGroupData[{
Cell[4179, 122, 301, 6, 50, "Print",ExpressionUUID->"6e4f428d-c7cb-4b6b-8eec-11dc58ef4e90"],
Cell[4483, 130, 845, 20, 131, "Print",ExpressionUUID->"8baf0039-3415-4b2f-80cf-fd16826bebb6"],
Cell[5331, 152, 313, 6, 50, "Print",ExpressionUUID->"6c88467b-c7fa-4a4a-a4bd-300dda0e32dc"],
Cell[5647, 160, 302, 6, 50, "Print",ExpressionUUID->"3cd0cd9f-93e8-4cea-99f5-5a367599c148"],
Cell[5952, 168, 308, 6, 50, "Print",ExpressionUUID->"79c03fee-5d9b-42d0-86a5-2f713a8d905e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6309, 180, 237, 4, 63, "Input",ExpressionUUID->"a5bb2474-c85c-4e5f-87f4-c3563bb85194"],
Cell[CellGroupData[{
Cell[6571, 188, 15356, 228, 1866, "Print",ExpressionUUID->"4d67ad04-ae6c-46ab-93dd-1b15e9c5d5c8"],
Cell[21930, 418, 352, 6, 131, "Print",ExpressionUUID->"197a94f8-8642-4fa0-803c-ebd9db465052"],
Cell[22285, 426, 26660, 562, 1799, "Print",ExpressionUUID->"cbdab4e0-4e74-4f0a-b07c-728edc357a86"],
Cell[48948, 990, 895, 20, 131, "Print",ExpressionUUID->"c05686c9-b9f4-4344-9219-3985cd5135c7"],
Cell[49846, 1012, 15040, 232, 1799, "Print",ExpressionUUID->"e103ebd6-b2fc-4212-83c0-4b046a8b80e8"],
Cell[64889, 1246, 15321, 227, 1799, "Print",ExpressionUUID->"88bfa724-37f0-451d-a5c4-d94f0f08a0df"],
Cell[80213, 1475, 283, 5, 50, "Print",ExpressionUUID->"229fc472-9977-4b0a-b569-f3db60a7c0ec"],
Cell[80499, 1482, 272, 5, 50, "Print",ExpressionUUID->"fba942e6-8ab3-4568-9eb2-db5681d6ac99"],
Cell[80774, 1489, 15265, 226, 1799, "Print",ExpressionUUID->"b95ce378-c91a-4146-8be8-453a7b3ec6e5"],
Cell[96042, 1717, 15281, 226, 1799, "Print",ExpressionUUID->"e304ee45-37ee-4e70-a5bc-2e224386ce3e"],
Cell[111326, 1945, 278, 5, 50, "Print",ExpressionUUID->"bc6cff74-b884-4fd9-add4-fe24baf4dea3"]
}, Open  ]]
}, Open  ]]
}
]
*)

