(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     44870,        921]
NotebookOptionsPosition[     44124,        901]
NotebookOutlinePosition[     44558,        918]
CellTagsIndexPosition[     44515,        915]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8121354703310013`*^9, 3.812135473481112*^9}, {
  3.8121375604981356`*^9, 
  3.8121375644119005`*^9}},ExpressionUUID->"19985859-8bb0-4383-8b56-\
b66714de05a1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "a"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "g"}], "}"}]}], "}"}], ",", 
    RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MIGrafo", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{"table", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8121374939203043`*^9, 3.8121375441393704`*^9}, {
  3.8123088657717223`*^9, 3.8123088680907593`*^9}, {3.8123089265441017`*^9, 
  3.81230892696976*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"4b2fcb8a-ffe3-4c1d-be5f-b40009d2d22d"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`g, \
$CellContext`d, $CellContext`f, $CellContext`e}, {{{1, 2}, {1, 3}, {1, 4}, {2,
        3}, {2, 5}, {2, 6}, {3, 5}, {5, 1}, {7, 6}, {7, 4}}, Null}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[CompressedData["
1:eJxTTMoPSmVmYGDgAmImKP4lLWT26cs/+wmLBctZ1D/Zm6S8+PL26z/7+8c3
tV3yvmKPLu/UdohpOyubw6nrjA22Cz9gyJ/YIZ5iue+5/awsBqdDFt8xzEPX
jy6/bfX7J29Y2Bw2vFvxWDn8Fob8Q6PKE0cPPrdngAJ089D1o/PR3QszZ22x
33Yl0+cY7keXR7cfAEgTmqQ=
         "], 0.028440073527296286`]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.9348013031137712, 1.1345257426384912}, 
          0.028440073527296286], 
         InsetBox["a", 
          Offset[{2, 2}, {1.9632413766410675, 1.1629658161657874}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.9350413862905613, 0.3171278300679869}, 
          0.028440073527296286], 
         InsetBox["b", 
          Offset[{2, 2}, {1.9634814598178576, 0.34556790359528317}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.7527904716123723, 1.039365291622277}, 
          0.028440073527296286], 
         InsetBox["c", 
          Offset[{2, 2}, {2.781230545139669, 1.0678053651495734}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7419707255301313, 1.451357133692602}, 
          0.028440073527296286], 
         InsetBox["g", 
          Offset[{2, 2}, {0.7704107990574276, 1.4797972072198984}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.7524049649850566, 0.4115686152688154}, 
          0.028440073527296286], 
         InsetBox["d", 
          Offset[{2, 2}, {2.780845038512353, 0.44000868879611166}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7424038806435328, 0.}, 0.028440073527296286], 
         InsetBox["f", 
          Offset[{2, 2}, {0.7708439541708291, 0.028440073527296286}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.7252362804607536}, 0.028440073527296286], 
         InsetBox["e", 
          Offset[{2, 2}, {0.028440073527296286, 0.7536763539880499}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.812308868913428*^9, 3.8123089282557683`*^9, 
  3.812309538209047*^9},
 CellLabel->"Out[19]=",ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>", "ImageResolution" -> \
144.],ExpressionUUID->"057b5028-217b-4ef4-87a6-276fe26d16c5"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox[
        RowBox[{"a", "\[DirectedEdge]", "b"}],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        RowBox[{"a", "\[DirectedEdge]", "c"}],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        RowBox[{"a", "\[DirectedEdge]", "g"}],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        RowBox[{"b", "\[DirectedEdge]", "c"}],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        RowBox[{"b", "\[DirectedEdge]", "d"}],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        RowBox[{"b", "\[DirectedEdge]", "f"}],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        RowBox[{"c", "\[DirectedEdge]", "d"}],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        RowBox[{"d", "\[DirectedEdge]", "a"}],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        RowBox[{"e", "\[DirectedEdge]", "f"}],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        RowBox[{"e", "\[DirectedEdge]", "g"}],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}], "0", "0", "0", "0", "1", "0", "0"},
     {
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "1", "0", "0", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}], "0", "0", "0", "0"},
     {
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "1", "0", "1", "0", "0", 
      RowBox[{"-", "1"}], "0", "0", "0"},
     {
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "0", "0", "0", "1", "0", "1", 
      RowBox[{"-", "1"}], "0", "0"},
     {
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "0", "0", "0", "0", "0", "0", "0", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}]},
     {
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "0", "0", "0", "0", "1", "0", "0", "1", "0"},
     {
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "0", "1", "0", "0", "0", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]]}, {
       Style[
        DirectedEdge[$CellContext`a, $CellContext`b], 
        GrayLevel[0]], 
       Style[
        DirectedEdge[$CellContext`a, $CellContext`c], 
        GrayLevel[0]], 
       Style[
        DirectedEdge[$CellContext`a, $CellContext`g], 
        GrayLevel[0]], 
       Style[
        DirectedEdge[$CellContext`b, $CellContext`c], 
        GrayLevel[0]], 
       Style[
        DirectedEdge[$CellContext`b, $CellContext`d], 
        GrayLevel[0]], 
       Style[
        DirectedEdge[$CellContext`b, $CellContext`f], 
        GrayLevel[0]], 
       Style[
        DirectedEdge[$CellContext`c, $CellContext`d], 
        GrayLevel[0]], 
       Style[
        DirectedEdge[$CellContext`d, $CellContext`a], 
        GrayLevel[0]], 
       Style[
        DirectedEdge[$CellContext`e, $CellContext`f], 
        GrayLevel[0]], 
       Style[
        DirectedEdge[$CellContext`e, $CellContext`g], 
        GrayLevel[0]]}}, TableAlignments -> Center]]]], "Output",
 CellChangeTimes->{3.812308868913428*^9, 3.8123089282557683`*^9, 
  3.8123095382170267`*^9},
 CellLabel->
  "Out[20]//TableForm=",ExpressionUUID->"b261004c-1f39-4d0f-9eef-\
51c746185dd5"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"1ef1df8f-0522-4469-ab19-0e01046328ae"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 235, 5, 63, "Input",ExpressionUUID->"19985859-8bb0-4383-8b56-b66714de05a1"],
Cell[CellGroupData[{
Cell[818, 29, 1324, 36, 378, "Input",ExpressionUUID->"4b2fcb8a-ffe3-4c1d-be5f-b40009d2d22d"],
Cell[2145, 67, 34234, 580, 462, 2852, 64, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"057b5028-217b-4ef4-87a6-276fe26d16c5"],
Cell[36382, 649, 7726, 249, 340, "Output",ExpressionUUID->"b261004c-1f39-4d0f-9eef-51c746185dd5"]
}, Open  ]]
}
]
*)

