(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     70671,       1601]
NotebookOptionsPosition[     67357,       1539]
NotebookOutlinePosition[     67791,       1556]
CellTagsIndexPosition[     67748,       1553]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8123632969520254`*^9, 3.812363304035056*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e978fc16-17d9-4815-9d96-53137b19d1a2"],

Cell["Algoritmo de Fleury", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.81271394371772*^9}},
 TextAlignment->Center,ExpressionUUID->"454695b5-2eaa-4a56-be60-be3d9c5272a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"a", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"g", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"g", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
      RowBox[{"f", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"h", "\[UndirectedEdge]", "b"}], ",", 
      RowBox[{"f", "\[UndirectedEdge]", "c"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8127158975087757`*^9, 3.8127159029536953`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"5bc7e845-c4e8-4306-903c-9b982debb845"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQBGImKN7yLNnfKJXBQcVOzdHhwlP7oqaFodYcv+wZoABd
/mKcbLd48gf78vfd837sf2SPLq8Rb7Jivuw/+1ulnMfOCH3GkBdWvup4LeGD
fdO7DrXk3u8Y9qGbjy6Pbj66/KajUuWvn94C8Zd9/xKI4V50/ejyMHOc4w5e
5r6I6d8jpRmW7oFH7dtzc48sFsTUj24/un3o/kfno9uPLo9uP7p6QvLo7kNX
jy4PAMlU6mA=
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.8127159032992783`*^9, {3.8127173998210735`*^9, 3.8127174047829304`*^9}, 
   3.812734962471692*^9, 3.812735947653854*^9, 3.8128858487968607`*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"7cb28f39-be93-4bca-85ae-027cc2464d07"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Valencias", "[", "grafo", "]"}]], "Input",
 CellChangeTimes->{{3.8127173901319685`*^9, 3.8127174118178945`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"a5a92aae-2525-4608-9c7b-b6761f659027"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox["\<\"Grado o valencia\"\>",
       HoldForm], "4", "4", "6", "4", "4", "4", "4", "4"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{"Grado o valencia"}, {
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]]}}, TableAlignments -> Center]]]], "Output",
 CellChangeTimes->{3.812717412590275*^9, 3.8127349650053926`*^9, 
  3.812885852519337*^9},
 CellLabel->
  "Out[41]//TableForm=",ExpressionUUID->"75519afc-4552-4194-8161-\
bed01f99744a"]
}, Open  ]],

Cell["Se toma h\[Rule]g\[Rule]a\[Rule]d\[Rule]c\[Rule]b\[Rule]f\[Rule]h:", \
"Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 
  3.8127140108792477`*^9}},ExpressionUUID->"957fe482-7988-4ba1-90f5-\
5747a23377e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "h", ",", "g", ",", "a", ",", "d", ",", "c", ",", "b", ",", "f", ",", 
       "h"}], "}"}], ",", "2", ",", "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
  3.812884897029952*^9, 3.812884938995252*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"2ab78289-fda7-419b-86ec-5c467cde53a9"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`g, $CellContext`a], 
         UndirectedEdge[$CellContext`d, $CellContext`c], 
         UndirectedEdge[$CellContext`f, $CellContext`h], 
         UndirectedEdge[$CellContext`a, $CellContext`d], 
         UndirectedEdge[$CellContext`b, $CellContext`f], 
         UndirectedEdge[$CellContext`h, $CellContext`g], 
         UndirectedEdge[$CellContext`c, $CellContext`b]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.6270097107846166`, 0.}}]}, 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024, 
         0.5859339806188321}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.8822323389521873`, 1.1920898185556923`}}]}, 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132, 
         1.4720183854359736`}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
         0.5859339806188321}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
         1.1920898185556923`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0.4202831900721221,
          0.0010960024301311933`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
          1.023641831549132, 1.4720183854359736`}}]}, 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
         0.6817683349463056}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.023641831549132, 1.4720183854359736`}, {
          0.16654291442038816`, 1.1918065712878574`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
          1.1918065712878574`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
         0.4202831900721221, 0.0010960024301311933`}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8127140899690084`*^9, 3.812715532131604*^9, 
  3.8127158215615683`*^9, 3.812734968421445*^9, 3.812884940839179*^9, 
  3.812885855840585*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"c3edcb71-4992-4d3a-bc22-4f2891266f7f"]
}, Open  ]],

Cell["\<\
Se eliminan las aristas {{h,g},{g,a},{a,d},{d,c},{c,b},{b,f},{f,h}}:\
\>", "Text",
 CellChangeTimes->{{3.8127141102713957`*^9, 
  3.812714131076416*^9}},ExpressionUUID->"4fc16894-dd73-48c7-a6c9-\
548a89737e2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"a", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
      RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"g", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"g", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"f", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"h", "\[UndirectedEdge]", "b"}], ",", 
      RowBox[{"f", "\[UndirectedEdge]", "c"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8127137131151752`*^9, 3.812713814524122*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"3f7659e4-09c8-4c4d-9b40-88864b67266e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`f, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`f] -> {
           GrayLevel[0, 0]}}, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.6270097107846166`, 0.}}]}, 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024, 
         0.5859339806188321}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.8822323389521873`, 1.1920898185556923`}}]}, 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132, 
         1.4720183854359736`}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
         0.5859339806188321}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
         1.1920898185556923`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0.4202831900721221,
          0.0010960024301311933`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
          1.023641831549132, 1.4720183854359736`}}]}, 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
         0.6817683349463056}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.023641831549132, 1.4720183854359736`}, {
          0.16654291442038816`, 1.1918065712878574`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
          1.1918065712878574`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
         0.4202831900721221, 0.0010960024301311933`}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{3.8127138153838215`*^9, 3.8127141669101925`*^9, 
  3.812715535652377*^9, 3.812715824186742*^9, 3.812734972099332*^9, 
  3.812884946345051*^9, 3.812885861489313*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"ffc250cb-ad5f-49dd-a1fe-e0f267dc7604"]
}, Open  ]],

Cell["Se toma d\[Rule]e\[Rule]f\[Rule]c\[Rule]e\[Rule]g\[Rule]d:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.8127141765942564`*^9, 
  3.8127141902733755`*^9}},ExpressionUUID->"86c97fcf-3a4f-404e-9850-\
d76973c88bfc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "d", ",", "e", ",", "f", ",", "c", ",", "e", ",", "g", ",", "d"}], 
      "}"}], ",", "2", ",", "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
  3.812714192752296*^9, 3.8127142146441393`*^9}, {3.8128849502920895`*^9, 
  3.8128849713444386`*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"e09276a5-6d1c-4777-9dd3-20ea4984cf34"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`f, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`c] -> {
           GrayLevel[0, 0]}}, GraphHighlight -> {
         UndirectedEdge[$CellContext`g, $CellContext`d], 
         UndirectedEdge[$CellContext`e, $CellContext`g], 
         UndirectedEdge[$CellContext`d, $CellContext`e], 
         UndirectedEdge[$CellContext`e, $CellContext`f], 
         UndirectedEdge[$CellContext`c, $CellContext`e], 
         UndirectedEdge[$CellContext`f, $CellContext`c]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.6270097107846166`, 0.}}]}, 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024, 
         0.5859339806188321}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.8822323389521873`, 1.1920898185556923`}}]}, 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132, 
         1.4720183854359736`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
          0.5859339806188321}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
          1.1920898185556923`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {
          1.8822323389521873`, 1.1920898185556923`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
         0.6817683349463056}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {
          0.16654291442038816`, 1.1918065712878574`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {
          0.4202831900721221, 0.0010960024301311933`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
          1.023641831549132, 1.4720183854359736`}}]}, 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
         0.6817683349463056}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.023641831549132, 1.4720183854359736`}, {
          0.16654291442038816`, 1.1918065712878574`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
          1.1918065712878574`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
          0.4202831900721221, 0.0010960024301311933`}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8127142228731165`*^9, 3.812715539215757*^9, 
  3.8127158267724566`*^9, 3.812734974812092*^9, 3.812884973060816*^9, 
  3.8128858664765253`*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"9cfc2a2a-e46f-4455-8fa6-637cf8db3c00"]
}, Open  ]],

Cell["\<\
Se eliminan las aristas {{d,e},{e,f},{f,c},{c,e},{e,g},{g,d}}:\
\>", "Text",
 CellChangeTimes->{{3.8127141102713957`*^9, 3.812714131076416*^9}, 
   3.812714240878522*^9},ExpressionUUID->"cb6984fb-a9a1-419b-90ee-\
89c23c54ba93"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", 
      RowBox[{"Style", "[", 
       RowBox[{"c", ",", "Transparent"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"d", ",", "Transparent"}], "]"}], ",", "e", ",", 
      RowBox[{"Style", "[", 
       RowBox[{"f", ",", "Transparent"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"g", ",", "Transparent"}], "]"}], ",", "h"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"a", "\[UndirectedEdge]", "h"}], ",", 
      RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"g", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"g", "\[UndirectedEdge]", "e"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"f", "\[UndirectedEdge]", "h"}], ",", "Transparent"}], "]"}], 
      ",", 
      RowBox[{"h", "\[UndirectedEdge]", "b"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"f", "\[UndirectedEdge]", "c"}], ",", "Transparent"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.812714252897423*^9, 3.8127143877413654`*^9}, 
   3.8127144392663517`*^9, {3.8127146815519857`*^9, 3.8127147248383636`*^9}, {
   3.812714757600453*^9, 3.8127147706960335`*^9}, {3.812715065268671*^9, 
   3.8127151362301545`*^9}, {3.812715168649596*^9, 3.8127151758365564`*^9}, {
   3.812715295421069*^9, 3.8127153491715436`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"6d13e9d7-b744-4a8a-9811-9b3df3fc7991"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d, \
$CellContext`e, $CellContext`f, $CellContext`g, $CellContext`h}, {
      Null, {{1, 4}, {1, 5}, {1, 7}, {1, 8}, {2, 5}, {2, 6}, {3, 4}, {3, 5}, {
       4, 5}, {4, 7}, {5, 6}, {7, 8}, {7, 5}, {2, 3}, {6, 8}, {8, 2}, {6, 
       3}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`g, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`f, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`f, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`e] -> {
           GrayLevel[0, 0]}}, VertexLabels -> {"Name"}, 
       VertexStyle -> {$CellContext`g -> {
           GrayLevel[0, 0]}, $CellContext`d -> {
           GrayLevel[0, 0]}, $CellContext`f -> {
           GrayLevel[0, 0]}, $CellContext`c -> {
           GrayLevel[0, 0]}}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.0482549599353392`, 0.6812771977932243}, {
          1.628480147762006, 0.}}]}, 
        LineBox[{{2.0482549599353392`, 0.6812771977932243}, {
         1.0237309117210103`, 0.5852401826663068}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.0482549599353392`, 0.6812771977932243}, {
          1.8815717692630238`, 1.192373257752082}}]}, 
        LineBox[{{2.0482549599353392`, 0.6812771977932243}, {
         1.023266314588013, 1.4712236704556583`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.6802318693403216}, {0.42075207612590526`, 
          0.000022122115237332984`}}]}, 
        LineBox[{{0., 0.6802318693403216}, {1.0237309117210103`, 
         0.5852401826663068}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.6802318693403216}, {0.16656282005147705`, 
          1.1920296682024385`}}]}, 
        LineBox[{{0., 0.6802318693403216}, {1.023266314588013, 
         1.4712236704556583`}}], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.42075207612590526`, 0.000022122115237332984`}, {
          1.628480147762006, 0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.42075207612590526`, 0.000022122115237332984`}, {
          1.0237309117210103`, 0.5852401826663068}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.42075207612590526`, 0.000022122115237332984`}, {
          0.16656282005147705`, 1.1920296682024385`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.628480147762006, 0.}, {1.0237309117210103`, 
          0.5852401826663068}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.628480147762006, 0.}, {1.8815717692630238`, 
          1.192373257752082}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.0237309117210103`, 0.5852401826663068}, {
          0.16656282005147705`, 1.1920296682024385`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.0237309117210103`, 0.5852401826663068}, {
          1.8815717692630238`, 1.192373257752082}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.16656282005147705`, 1.1920296682024385`}, {
          1.023266314588013, 1.4712236704556583`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.8815717692630238`, 1.192373257752082}, {
          1.023266314588013, 1.4712236704556583`}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.0482549599353392, 0.6812771977932243}, 
          0.023001802098826823], 
         InsetBox["a", 
          Offset[{2, 2}, {2.071256762034166, 0.7042789998920511}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6802318693403216}, 0.023001802098826823], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023001802098826823, 0.7032336714391485}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.42075207612590526, 0.000022122115237332984}, 
           0.023001802098826823]}, 
         InsetBox["c", 
          Offset[{2, 2}, {0.4437538782247321, 0.023023924214064156}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.628480147762006, 0.}, 0.023001802098826823]}, 
         InsetBox["d", 
          Offset[{2, 2}, {1.6514819498608326, 0.023001802098826823}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0237309117210103, 0.5852401826663068}, 
          0.023001802098826823], 
         InsetBox["e", 
          Offset[{2, 2}, {1.046732713819837, 0.6082419847651337}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.16656282005147705, 1.1920296682024385}, 
           0.023001802098826823]}, 
         InsetBox["f", 
          Offset[{2, 2}, {0.18956462215030387, 1.2150314703012652}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.8815717692630238, 1.192373257752082}, 
           0.023001802098826823]}, 
         InsetBox["g", 
          Offset[{2, 2}, {1.9045735713618506, 1.2153750598509088}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023266314588013, 1.4712236704556583}, 
          0.023001802098826823], 
         InsetBox["h", 
          Offset[{2, 2}, {1.0462681166868397, 1.494225472554485}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.812714341738451*^9, 3.812714388896782*^9}, 
   3.812714440442693*^9, {3.812714704857611*^9, 3.812714725198392*^9}, {
   3.8127147584551673`*^9, 3.8127147715263176`*^9}, 3.8127148834376993`*^9, 
   3.8127151050422554`*^9, 3.8127151373351755`*^9, {3.8127151695867014`*^9, 
   3.8127151766892667`*^9}, 3.812715350204957*^9, 3.812715543816053*^9, 
   3.812715830559408*^9, 3.8127349786308613`*^9, 3.8128849797693586`*^9, 
   3.8128858729411526`*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"cd94e853-523d-4d82-8477-db8e69333847"]
}, Open  ]],

Cell["Se toma e\[Rule]b\[Rule]h\[Rule]a\[Rule]e:", "Text",
 CellChangeTimes->{{3.81271390099531*^9, 3.812713975328966*^9}, {
  3.8127140097083263`*^9, 3.8127140108792477`*^9}, {3.8127141765942564`*^9, 
  3.8127141902733755`*^9}, {3.8127154197989492`*^9, 
  3.812715432217738*^9}},ExpressionUUID->"09c80b22-b893-4cef-a8bc-\
c5d8ff28061a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "b", ",", "h", ",", "a", ",", "e"}], "}"}], ",", "2", 
     ",", "1"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.81271399630188*^9, 3.812714089181098*^9}, {
  3.812714192752296*^9, 3.8127142146441393`*^9}, {3.812715439692197*^9, 
  3.8127154535930314`*^9}, {3.8128849848500905`*^9, 3.8128850074131804`*^9}, {
  3.812885722712742*^9, 3.812885726781531*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"ac193b0f-aa30-4cc3-9bf8-131e029bb1de"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d, \
$CellContext`e, $CellContext`f, $CellContext`g, $CellContext`h}, {
      Null, {{1, 4}, {1, 5}, {1, 7}, {1, 8}, {2, 5}, {2, 6}, {3, 4}, {3, 5}, {
       4, 5}, {4, 7}, {5, 6}, {7, 8}, {7, 5}, {2, 3}, {6, 8}, {8, 2}, {6, 
       3}}}, {EdgeStyle -> {UndirectedEdge[$CellContext`c, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`e, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`d] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`f] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`g, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`c, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`f, $CellContext`h] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`d, $CellContext`e] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`a, $CellContext`g] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`b, $CellContext`c] -> {
           GrayLevel[0, 0]}, UndirectedEdge[$CellContext`f, $CellContext`c] -> {
           GrayLevel[0, 0]}}, GraphHighlight -> {
         UndirectedEdge[$CellContext`b, $CellContext`h], 
         UndirectedEdge[$CellContext`e, $CellContext`b], 
         UndirectedEdge[$CellContext`a, $CellContext`e], 
         UndirectedEdge[$CellContext`h, $CellContext`a]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}, VertexStyle -> {$CellContext`f -> {
           GrayLevel[0, 0]}, $CellContext`d -> {
           GrayLevel[0, 0]}, $CellContext`c -> {
           GrayLevel[0, 0]}, $CellContext`g -> {
           GrayLevel[0, 0]}}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.0482549599353392`, 0.6812771977932243}, {
          1.628480147762006, 0.}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.0482549599353392`, 0.6812771977932243}, {
          1.0237309117210103`, 0.5852401826663068}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{2.0482549599353392`, 0.6812771977932243}, {
          1.8815717692630238`, 1.192373257752082}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.0482549599353392`, 0.6812771977932243}, {
          1.023266314588013, 1.4712236704556583`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.6802318693403216}, {0.42075207612590526`, 
          0.000022122115237332984`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0., 0.6802318693403216}, {1.0237309117210103`, 
          0.5852401826663068}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0., 0.6802318693403216}, {0.16656282005147705`, 
          1.1920296682024385`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0., 0.6802318693403216}, {1.023266314588013, 
          1.4712236704556583`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.42075207612590526`, 0.000022122115237332984`}, {
          1.628480147762006, 0.}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.42075207612590526`, 0.000022122115237332984`}, {
          1.0237309117210103`, 0.5852401826663068}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.42075207612590526`, 0.000022122115237332984`}, {
          0.16656282005147705`, 1.1920296682024385`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.628480147762006, 0.}, {1.0237309117210103`, 
          0.5852401826663068}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.628480147762006, 0.}, {1.8815717692630238`, 
          1.192373257752082}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.0237309117210103`, 0.5852401826663068}, {
          0.16656282005147705`, 1.1920296682024385`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.0237309117210103`, 0.5852401826663068}, {
          1.8815717692630238`, 1.192373257752082}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{0.16656282005147705`, 1.1920296682024385`}, {
          1.023266314588013, 1.4712236704556583`}}]}, 
        {GrayLevel[0], Opacity[0], 
         LineBox[{{1.8815717692630238`, 1.192373257752082}, {
          1.023266314588013, 1.4712236704556583`}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.0482549599353392, 0.6812771977932243}, 
          0.023001802098826823], 
         InsetBox["a", 
          Offset[{2, 2}, {2.071256762034166, 0.7042789998920511}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6802318693403216}, 0.023001802098826823], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023001802098826823, 0.7032336714391485}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.42075207612590526, 0.000022122115237332984}, 
           0.023001802098826823]}, 
         InsetBox["c", 
          Offset[{2, 2}, {0.4437538782247321, 0.023023924214064156}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.628480147762006, 0.}, 0.023001802098826823]}, 
         InsetBox["d", 
          Offset[{2, 2}, {1.6514819498608326, 0.023001802098826823}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0237309117210103, 0.5852401826663068}, 
          0.023001802098826823], 
         InsetBox["e", 
          Offset[{2, 2}, {1.046732713819837, 0.6082419847651337}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{0.16656282005147705, 1.1920296682024385}, 
           0.023001802098826823]}, 
         InsetBox["f", 
          Offset[{2, 2}, {0.18956462215030387, 1.2150314703012652}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {GrayLevel[0], Opacity[0], 
          DiskBox[{1.8815717692630238, 1.192373257752082}, 
           0.023001802098826823]}, 
         InsetBox["g", 
          Offset[{2, 2}, {1.9045735713618506, 1.2153750598509088}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023266314588013, 1.4712236704556583}, 
          0.023001802098826823], 
         InsetBox["h", 
          Offset[{2, 2}, {1.0462681166868397, 1.494225472554485}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.812715454510084*^9, 3.8127158331979804`*^9, 
  3.8127349811954355`*^9, 3.812885728799311*^9, 3.8128858768951077`*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"0462384e-3efe-4f6d-bdb3-f93680ea6e40"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"grafo", "=", 
   RowBox[{"Grafo", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"h", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "c"}], "}"}]}], "}"}], "]"}]}], ";", 
  RowBox[{"AnimarGrafo", "[", 
   RowBox[{"grafo", ",", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "h", ",", "g", ",", "a", ",", "d", ",", "e", ",", "f", ",", "c", ",", 
        "e", ",", "b", ",", "h", ",", "a", ",", "e", ",", "g", ",", "d", ",", 
        "c", ",", "b", ",", "f", ",", "h"}], "}"}], ",", "2", ",", "1"}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.812715892843811*^9, 3.8127159148912573`*^9}, {
  3.8127159505813856`*^9, 3.812715967767354*^9}, {3.812716015446836*^9, 
  3.8127160904179473`*^9}, {3.8127162466821785`*^9, 3.8127162841899023`*^9}, {
  3.8127187863887033`*^9, 3.812718815765614*^9}, {3.812885744587351*^9, 
  3.812885817641898*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"f5fab622-977c-461f-b889-a16850bd67ef"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 8, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 17, 1}}, 
    Typeset`size$$ = {658., {242., 252.8643880657777}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 17, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{754., {344.75, 357.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.8127162618752055`*^9, 3.8127162920518627`*^9}, {
  3.8127188099018774`*^9, 3.8127188188230624`*^9}, {3.812734985433897*^9, 
  3.8127349866067705`*^9}, {3.8128858187307673`*^9, 3.8128858270237403`*^9}, {
  3.8128858845596046`*^9, 3.8128858863612027`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"d204bcb2-c56d-4818-8cc6-67f972bc4cdc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grafo", "=", 
   RowBox[{"Grafo", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"h", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "c"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CircuitosEuler", "[", 
  RowBox[{"grafo", ",", "3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"CircuitosEuler", "[", 
  RowBox[{"grafo", ",", "3", ",", 
   RowBox[{"ruta", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8127350024865093`*^9, 3.8127350478468237`*^9}, {
  3.8127357580840263`*^9, 3.81273577176303*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"903e5d6c-3bff-46d4-b052-89e0e8e24a00"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "a"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "a"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "a"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "a"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.812735024425764*^9, 3.81273504828465*^9}, 
   3.812735772428252*^9, 3.8128858385355244`*^9, 3.812885902441645*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"11d1f611-fd77-4094-90b3-41627474d843"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "a"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "a"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "a"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "a"}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8127357724342685`*^9, 3.8128858385395184`*^9, 
  3.8128859024448223`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[48]:=",ExpressionUUID->"899286ab-1fb4-40a5-8b8c-14a315c04e1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ruta de la animaci\[OAcute]n: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "a"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "a"}]}], "}"}]}],
  SequenceForm["Ruta de la animaci\[OAcute]n: ", {
    UndirectedEdge[$CellContext`a, $CellContext`d], 
    UndirectedEdge[$CellContext`d, $CellContext`g], 
    UndirectedEdge[$CellContext`g, $CellContext`e], 
    UndirectedEdge[$CellContext`e, $CellContext`f], 
    UndirectedEdge[$CellContext`f, $CellContext`c], 
    UndirectedEdge[$CellContext`c, $CellContext`b], 
    UndirectedEdge[$CellContext`b, $CellContext`h], 
    UndirectedEdge[$CellContext`h, $CellContext`f], 
    UndirectedEdge[$CellContext`f, $CellContext`b], 
    UndirectedEdge[$CellContext`b, $CellContext`e], 
    UndirectedEdge[$CellContext`e, $CellContext`d], 
    UndirectedEdge[$CellContext`d, $CellContext`c], 
    UndirectedEdge[$CellContext`c, $CellContext`e], 
    UndirectedEdge[$CellContext`e, $CellContext`a], 
    UndirectedEdge[$CellContext`a, $CellContext`g], 
    UndirectedEdge[$CellContext`g, $CellContext`h], 
    UndirectedEdge[$CellContext`h, $CellContext`a]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8127357724342685`*^9, 3.8128858385395184`*^9, 
  3.812885902447348*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[48]:=",ExpressionUUID->"ced63c09-14ce-4a56-9f51-fa66e5f4b9ee"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 17, 1}}, 
    Typeset`size$$ = {651., {239., 250.72727433582583`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 17, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{747., {320.75, 333.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.8127357724342685`*^9, 3.8128858385395184`*^9, 
  3.8128859024893456`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[48]:=",ExpressionUUID->"d1d7adee-1498-4c97-a680-02b6e5c44c96"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"64561b53-ef2f-4a68-8e6a-98e112ef5f42"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"e978fc16-17d9-4815-9d96-53137b19d1a2"],
Cell[761, 25, 178, 2, 77, "Text",ExpressionUUID->"454695b5-2eaa-4a56-be60-be3d9c5272a8"],
Cell[CellGroupData[{
Cell[964, 31, 1243, 25, 335, "Input",ExpressionUUID->"5bc7e845-c4e8-4306-903c-9b982debb845"],
Cell[2210, 58, 3382, 73, 579, "Output",ExpressionUUID->"7cb28f39-be93-4bca-85ae-027cc2464d07"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5629, 136, 215, 3, 91, "Input",ExpressionUUID->"a5a92aae-2525-4608-9c7b-b6761f659027"],
Cell[5847, 141, 3568, 116, 136, "Output",ExpressionUUID->"75519afc-4552-4194-8161-bed01f99744a"]
}, Open  ]],
Cell[9430, 260, 262, 5, 77, "Text",ExpressionUUID->"957fe482-7988-4ba1-90f5-5747a23377e7"],
Cell[CellGroupData[{
Cell[9717, 269, 485, 11, 168, "Input",ExpressionUUID->"2ab78289-fda7-419b-86ec-5c467cde53a9"],
Cell[10205, 282, 5846, 118, 576, "Output",ExpressionUUID->"c3edcb71-4992-4d3a-bc22-4f2891266f7f"]
}, Open  ]],
Cell[16066, 403, 220, 5, 128, "Text",ExpressionUUID->"4fc16894-dd73-48c7-a6c9-548a89737e2c"],
Cell[CellGroupData[{
Cell[16311, 412, 1822, 46, 733, "Input",ExpressionUUID->"3f7659e4-09c8-4c4d-9b40-88864b67266e"],
Cell[18136, 460, 5794, 115, 579, "Output",ExpressionUUID->"ffc250cb-ad5f-49dd-a1fe-e0f267dc7604"]
}, Open  ]],
Cell[23945, 578, 302, 4, 77, "Text",ExpressionUUID->"86c97fcf-3a4f-404e-9850-d76973c88bfc"],
Cell[CellGroupData[{
Cell[24272, 586, 529, 12, 168, "Input",ExpressionUUID->"e09276a5-6d1c-4777-9dd3-20ea4984cf34"],
Cell[24804, 600, 6586, 130, 576, "Output",ExpressionUUID->"9cfc2a2a-e46f-4455-8fa6-637cf8db3c00"]
}, Open  ]],
Cell[31405, 733, 237, 5, 77, "Text",ExpressionUUID->"cb6984fb-a9a1-419b-90ee-89c23c54ba93"],
Cell[CellGroupData[{
Cell[31667, 742, 3020, 78, 1539, "Input",ExpressionUUID->"6d13e9d7-b744-4a8a-9811-9b3df3fc7991"],
Cell[34690, 822, 7213, 141, 586, "Output",ExpressionUUID->"cd94e853-523d-4d82-8477-db8e69333847"]
}, Open  ]],
Cell[41918, 966, 337, 5, 77, "Text",ExpressionUUID->"09c80b22-b893-4cef-a8bc-c5d8ff28061a"],
Cell[CellGroupData[{
Cell[42280, 975, 598, 12, 168, "Input",ExpressionUUID->"ac193b0f-aa30-4cc3-9bf8-131e029bb1de"],
Cell[42881, 989, 7454, 146, 576, "Output",ExpressionUUID->"0462384e-3efe-4f6d-bdb3-f93680ea6e40"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50372, 1140, 2031, 55, 432, "Input",ExpressionUUID->"f5fab622-977c-461f-b889-a16850bd67ef"],
Cell[52406, 1197, 2531, 53, 722, "Print",ExpressionUUID->"d204bcb2-c56d-4818-8cc6-67f972bc4cdc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54974, 1255, 1680, 48, 384, "Input",ExpressionUUID->"903e5d6c-3bff-46d4-b052-89e0e8e24a00"],
Cell[56657, 1305, 3038, 62, 446, "Output",ExpressionUUID->"11d1f611-fd77-4094-90b3-41627474d843"],
Cell[CellGroupData[{
Cell[59720, 1371, 3033, 64, 371, "Print",ExpressionUUID->"899286ab-1fb4-40a5-8b8c-14a315c04e1e"],
Cell[62756, 1437, 2219, 45, 171, "Print",ExpressionUUID->"ced63c09-14ce-4a56-9f51-fa66e5f4b9ee"],
Cell[64978, 1484, 2351, 51, 674, "Print",ExpressionUUID->"d1d7adee-1498-4c97-a680-02b6e5c44c96"]
}, Open  ]]
}, Open  ]]
}
]
*)

