(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     22720,        543]
NotebookOptionsPosition[     21631,        519]
NotebookOutlinePosition[     22059,        536]
CellTagsIndexPosition[     22016,        533]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8129932043593683`*^9, 3.8129932123022966`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"c0d8fca9-683b-4e66-b7d4-11d64f022e58"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Sort", "[", 
  RowBox[{"Sort", "/@", 
   RowBox[{"AristasWolframSystemToCombinatorica", "[", 
    RowBox[{"EdgeList", "[", 
     RowBox[{"GraphComplement", "[", "grafo", "]"}], "]"}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Valencias", "[", "grafo", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "h", ",", "g", ",", "b", ",", "e", ",", "d", ",", "a", ",", "f", ",", 
       "c", ",", "h"}], "}"}], ",", "2", ",", "1"}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CircuitoHamiltonQ", "[", "grafo", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CircuitosHamilton", "[", 
  RowBox[{"grafo", ",", "3"}], "]"}]}], "Input",
 CellChangeTimes->{{3.812993220355399*^9, 3.812993220716432*^9}, {
  3.8129932831343126`*^9, 3.812993297846098*^9}, {3.8129933322330046`*^9, 
  3.8129933583061733`*^9}, {3.8129934040048847`*^9, 3.812993422725404*^9}, {
  3.8129934796297846`*^9, 3.812993519945956*^9}, {3.812994641270113*^9, 
  3.8129946502016697`*^9}, {3.812995286305739*^9, 3.8129952937317934`*^9}, {
  3.8129953497349567`*^9, 3.812995367170333*^9}, {3.812996188560604*^9, 
  3.8129962144112887`*^9}, {3.812996640185512*^9, 3.8129966547871733`*^9}, {
  3.8129970365995674`*^9, 3.812997094961919*^9}, {3.8130841273109674`*^9, 
  3.813084135040222*^9}, {3.813085427009325*^9, 3.8130854274541674`*^9}, {
  3.813085574118825*^9, 3.813085584733056*^9}, {3.8130858481429358`*^9, 
  3.8130858627207556`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"02f0cac8-e880-46fc-ade9-44c388cee2ba"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`e, $CellContext`d, $CellContext`f, \
$CellContext`h, $CellContext`c, $CellContext`g, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {2, 4}, {1, 3}, {3, 2}, {5, 6}, {5, 7}, {1, 4}, {
       8, 3}, {8, 2}, {8, 7}, {6, 3}, {6, 2}, {6, 4}, {3, 7}, {2, 7}, {1, 
       8}}}, {ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQBGImKFae0xFvMYnVQfrV1bM7FF/ba9lebpwh8ce+iHXt
DJtdH+zR5e8lnPt95/Yfe6cVNW9dlj3BkH82o5dB5SaDAwMUoMtbL/BNZ3jG
4OCoGOmX/OsXhn3o5qPLo5uPLr/tpkNqMNsH+yUJblfeBZzG0K86+RpHIMsH
e9EJle+EZn/HkEd3H7p70O1Hl0e3H10e3X50eXT70e1DNx8m/iAmZ+nhP68w
7EeXR7cfnY9uPwCcB/gE
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.696396585804466, 0.8478664417482976}, 
          0.02802197943104502], 
         InsetBox["a", 
          Offset[{2, 2}, {2.724418565235511, 0.8758884211793426}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7560048171324731, 1.0454679454709006}, 
          0.02802197943104502], 
         InsetBox["e", 
          Offset[{2, 2}, {1.7840267965635181, 1.0734899249019456}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.803677543275675, 0.6452965391556591}, 
          0.02802197943104502], 
         InsetBox["d", Offset[{2, 2}, {1.83169952270672, 0.6733185185867041}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.106025699921804, 0.}, 0.02802197943104502], 
         InsetBox["f", 
          Offset[{2, 2}, {2.134047679352849, 0.02802197943104502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.8433550101207423}, 0.02802197943104502], 
         InsetBox["h", 
          Offset[{2, 2}, {0.02802197943104502, 0.8713769895517873}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0015443759162799, 0.21340737690912193}, 
          0.02802197943104502], 
         InsetBox["c", 
          Offset[{2, 2}, {1.0295663553473249, 0.24142935634016693}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0010538430444254, 1.4753598514007582}, 
          0.02802197943104502], 
         InsetBox["g", 
          Offset[{2, 2}, {1.0290758224754704, 1.5033818308318032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1123054571690125, 1.6861298618769782}, 
          0.02802197943104502], 
         InsetBox["b", 
          Offset[{2, 2}, {2.1403274366000575, 1.7141518413080232}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.8129933033783627`*^9, 3.8129933592356653`*^9, {3.8129934910745273`*^9, 
   3.812993520422681*^9}, 3.812994650943924*^9, 3.81299529416873*^9, {
   3.8129953512608624`*^9, 3.8129953682168846`*^9}, {3.8129961903748894`*^9, 
   3.812996214769841*^9}, {3.812996652820267*^9, 3.8129966552758665`*^9}, 
   3.8129970958102474`*^9, 3.813083371732126*^9, 3.813084135895444*^9, 
   3.8130854287731194`*^9, {3.813085594631634*^9, 3.813085617418677*^9}, 
   3.8130858632264*^9, 3.8130863181388493`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"e6fb4d72-1b3d-41af-bc8c-6ca14cd0ecfe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "h"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8129933033783627`*^9, 3.8129933592356653`*^9, {3.8129934910745273`*^9, 
   3.812993520422681*^9}, 3.812994650943924*^9, 3.81299529416873*^9, {
   3.8129953512608624`*^9, 3.8129953682168846`*^9}, {3.8129961903748894`*^9, 
   3.812996214769841*^9}, {3.812996652820267*^9, 3.8129966552758665`*^9}, 
   3.8129970958102474`*^9, 3.813083371732126*^9, 3.813084135895444*^9, 
   3.8130854287731194`*^9, {3.813085594631634*^9, 3.813085617418677*^9}, 
   3.8130858632264*^9, 3.813086318172758*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"1662979b-fd56-4d50-b3fa-ed8618119c5a"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox["\<\"Grado o valencia\"\>",
       HoldForm], "4", "6", "6", "4", "2", "4", "4", "4"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{"Grado o valencia"}, {
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]]}}, TableAlignments -> Center]]]], "Output",
 CellChangeTimes->{
  3.8129933033783627`*^9, 3.8129933592356653`*^9, {3.8129934910745273`*^9, 
   3.812993520422681*^9}, 3.812994650943924*^9, 3.81299529416873*^9, {
   3.8129953512608624`*^9, 3.8129953682168846`*^9}, {3.8129961903748894`*^9, 
   3.812996214769841*^9}, {3.812996652820267*^9, 3.8129966552758665`*^9}, 
   3.8129970958102474`*^9, 3.813083371732126*^9, 3.813084135895444*^9, 
   3.8130854287731194`*^9, {3.813085594631634*^9, 3.813085617418677*^9}, 
   3.8130858632264*^9, 3.813086318176747*^9},
 CellLabel->
  "Out[50]//TableForm=",ExpressionUUID->"1c827f5c-1dc3-4d0f-872e-\
7b1436f1677f"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`e, $CellContext`d, $CellContext`f, \
$CellContext`h, $CellContext`c, $CellContext`g, $CellContext`b}, {
      Null, {{1, 2}, {3, 4}, {2, 4}, {1, 3}, {3, 2}, {5, 6}, {5, 7}, {1, 4}, {
       8, 3}, {8, 2}, {8, 7}, {6, 3}, {6, 2}, {6, 4}, {3, 7}, {2, 7}, {1, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`c, $CellContext`h], 
         UndirectedEdge[$CellContext`g, $CellContext`b], 
         UndirectedEdge[$CellContext`d, $CellContext`a], 
         UndirectedEdge[$CellContext`a, $CellContext`f], 
         UndirectedEdge[$CellContext`e, $CellContext`d], 
         UndirectedEdge[$CellContext`f, $CellContext`c], 
         UndirectedEdge[$CellContext`b, $CellContext`e], 
         UndirectedEdge[$CellContext`h, $CellContext`g]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        LineBox[{{2.696396585804466, 0.8478664417482976}, {
         1.7560048171324731`, 1.0454679454709006`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {1.803677543275675,
           0.6452965391556591}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.696396585804466, 0.8478664417482976}, {2.106025699921804,
           0.}}]}, 
        LineBox[{{2.696396585804466, 0.8478664417482976}, {
         2.1123054571690125`, 1.6861298618769782`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          1.803677543275675, 0.6452965391556591}}]}, 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         2.106025699921804, 0.}}], 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         1.0015443759162799`, 0.21340737690912193`}}], 
        LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
         1.0010538430444254`, 1.4753598514007582`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.7560048171324731`, 1.0454679454709006`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}, 
        LineBox[{{1.803677543275675, 0.6452965391556591}, {2.106025699921804, 
         0.}}], LineBox[{{1.803677543275675, 0.6452965391556591}, {
         1.0015443759162799`, 0.21340737690912193`}}], 
        LineBox[{{1.803677543275675, 0.6452965391556591}, {
         1.0010538430444254`, 1.4753598514007582`}}], 
        LineBox[{{1.803677543275675, 0.6452965391556591}, {
         2.1123054571690125`, 1.6861298618769782`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.106025699921804, 0.}, {1.0015443759162799`, 
          0.21340737690912193`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0., 0.8433550101207423}, {1.0015443759162799`, 
          0.21340737690912193`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0., 0.8433550101207423}, {1.0010538430444254`, 
          1.4753598514007582`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.0010538430444254`, 1.4753598514007582`}, {
          2.1123054571690125`, 1.6861298618769782`}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.696396585804466, 0.8478664417482976}, 
          0.02802197943104502], 
         InsetBox["a", 
          Offset[{2, 2}, {2.724418565235511, 0.8758884211793426}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7560048171324731, 1.0454679454709006}, 
          0.02802197943104502], 
         InsetBox["e", 
          Offset[{2, 2}, {1.7840267965635181, 1.0734899249019456}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.803677543275675, 0.6452965391556591}, 
          0.02802197943104502], 
         InsetBox["d", Offset[{2, 2}, {1.83169952270672, 0.6733185185867041}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.106025699921804, 0.}, 0.02802197943104502], 
         InsetBox["f", 
          Offset[{2, 2}, {2.134047679352849, 0.02802197943104502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.8433550101207423}, 0.02802197943104502], 
         InsetBox["h", 
          Offset[{2, 2}, {0.02802197943104502, 0.8713769895517873}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0015443759162799, 0.21340737690912193}, 
          0.02802197943104502], 
         InsetBox["c", 
          Offset[{2, 2}, {1.0295663553473249, 0.24142935634016693}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0010538430444254, 1.4753598514007582}, 
          0.02802197943104502], 
         InsetBox["g", 
          Offset[{2, 2}, {1.0290758224754704, 1.5033818308318032}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1123054571690125, 1.6861298618769782}, 
          0.02802197943104502], 
         InsetBox["b", 
          Offset[{2, 2}, {2.1403274366000575, 1.7141518413080232}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.8129933033783627`*^9, 3.8129933592356653`*^9, {3.8129934910745273`*^9, 
   3.812993520422681*^9}, 3.812994650943924*^9, 3.81299529416873*^9, {
   3.8129953512608624`*^9, 3.8129953682168846`*^9}, {3.8129961903748894`*^9, 
   3.812996214769841*^9}, {3.812996652820267*^9, 3.8129966552758665`*^9}, 
   3.8129970958102474`*^9, 3.813083371732126*^9, 3.813084135895444*^9, 
   3.8130854287731194`*^9, {3.813085594631634*^9, 3.813085617418677*^9}, 
   3.8130858632264*^9, 3.8130863182495527`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"ff9aa846-d057-4fc4-822b-efdc33b2c78c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.8129933033783627`*^9, 3.8129933592356653`*^9, {3.8129934910745273`*^9, 
   3.812993520422681*^9}, 3.812994650943924*^9, 3.81299529416873*^9, {
   3.8129953512608624`*^9, 3.8129953682168846`*^9}, {3.8129961903748894`*^9, 
   3.812996214769841*^9}, {3.812996652820267*^9, 3.8129966552758665`*^9}, 
   3.8129970958102474`*^9, 3.813083371732126*^9, 3.813084135895444*^9, 
   3.8130854287731194`*^9, {3.813085594631634*^9, 3.813085617418677*^9}, 
   3.8130858632264*^9, 3.81308631825454*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"7275c52c-ac0c-492f-b202-ac01624987b0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "e"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"h", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"d", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "a"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8129933033783627`*^9, 3.8129933592356653`*^9, {3.8129934910745273`*^9, 
   3.812993520422681*^9}, 3.812994650943924*^9, 3.81299529416873*^9, {
   3.8129953512608624`*^9, 3.8129953682168846`*^9}, {3.8129961903748894`*^9, 
   3.812996214769841*^9}, {3.812996652820267*^9, 3.8129966552758665`*^9}, 
   3.8129970958102474`*^9, 3.813083371732126*^9, 3.813084135895444*^9, 
   3.8130854287731194`*^9, {3.813085594631634*^9, 3.813085617418677*^9}, 
   3.8130858632264*^9, 3.8130863182575307`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"278da3ac-8b84-4d89-ae42-ea892651aef8"]
}, Open  ]]
},
WindowSize->{949, 478},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"bfa78427-8f72-48f5-90b1-0f097516429a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 63, "Input",ExpressionUUID->"c0d8fca9-683b-4e66-b7d4-11d64f022e58"],
Cell[CellGroupData[{
Cell[785, 27, 2819, 69, 760, "Input",ExpressionUUID->"02f0cac8-e880-46fc-ade9-44c388cee2ba"],
Cell[3607, 98, 3760, 79, 514, "Output",ExpressionUUID->"e6fb4d72-1b3d-41af-bc8c-6ca14cd0ecfe"],
Cell[7370, 179, 1293, 33, 144, "Output",ExpressionUUID->"1662979b-fd56-4d50-b3fa-ed8618119c5a"],
Cell[8666, 214, 3989, 122, 136, "Output",ExpressionUUID->"1c827f5c-1dc3-4d0f-872e-7b1436f1677f"],
Cell[12658, 338, 6319, 124, 514, "Output",ExpressionUUID->"ff9aa846-d057-4fc4-822b-efdc33b2c78c"],
Cell[18980, 464, 621, 9, 100, "Output",ExpressionUUID->"7275c52c-ac0c-492f-b202-ac01624987b0"],
Cell[19604, 475, 2011, 41, 306, "Output",ExpressionUUID->"278da3ac-8b84-4d89-ae42-ea892651aef8"]
}, Open  ]]
}
]
*)

