(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     57599,       1506]
NotebookOptionsPosition[     53569,       1443]
NotebookOutlinePosition[     54008,       1460]
CellTagsIndexPosition[     53965,       1457]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8133180405205746`*^9, 3.81331804481916*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"3dbe346f-5738-4edd-9429-1c3129f1727b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "g"}], "}"}]}], "}"}], ",", 
    RowBox[{"pesos", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "5", ",", "6", ",", "7", ",", "5", ",", "5", ",", "4", ",", "3", ",", 
       "3", ",", "2", ",", "2", ",", "3", ",", "1", ",", "2"}], "}"}]}], ",", 
    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"AlDijkstra", "[", 
  RowBox[{"grafo", ",", "a", ",", "g"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"LongitudCaminoMC", "[", 
  RowBox[{"grafo", ",", "a", ",", "g"}], "]"}]}], "Input",
 CellChangeTimes->{{3.813318066917431*^9, 3.8133181030709376`*^9}, {
   3.8133185314789124`*^9, 3.813318542524365*^9}, {3.8133235979287376`*^9, 
   3.813323618376316*^9}, {3.8133466719791436`*^9, 3.8133466724442005`*^9}, {
   3.8133467541434236`*^9, 3.813346757652173*^9}, 3.813346822010618*^9, 
   3.8133479463875256`*^9, 3.8133481042480035`*^9, {3.813418628932014*^9, 
   3.813418739693269*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"d0cc1d56-0e87-4799-9f08-2e03d2d80484"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`d, $CellContext`f, \
$CellContext`c, $CellContext`e, $CellContext`g}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 3}, {2, 6}, {5, 6}, {5, 7}, {
       3, 6}, {3, 4}, {3, 7}, {6, 7}, {4, 7}}}, {
      EdgeLabels -> {
        UndirectedEdge[$CellContext`b, $CellContext`e] -> 4, 
         UndirectedEdge[$CellContext`e, $CellContext`g] -> 1, 
         UndirectedEdge[$CellContext`b, $CellContext`d] -> 5, 
         UndirectedEdge[$CellContext`c, $CellContext`g] -> 3, 
         UndirectedEdge[$CellContext`f, $CellContext`g] -> 2, 
         UndirectedEdge[$CellContext`a, $CellContext`f] -> 7, 
         UndirectedEdge[$CellContext`c, $CellContext`e] -> 3, 
         UndirectedEdge[$CellContext`b, $CellContext`c] -> 5, 
         UndirectedEdge[$CellContext`d, $CellContext`e] -> 2, 
         UndirectedEdge[$CellContext`d, $CellContext`f] -> 2, 
         UndirectedEdge[$CellContext`d, $CellContext`g] -> 3, 
         UndirectedEdge[$CellContext`a, $CellContext`d] -> 6, 
         UndirectedEdge[$CellContext`a, $CellContext`b] -> 5}, 
       EdgeWeight -> {5, 6, 7, 5, 5, 4, 3, 3, 2, 2, 3, 1, 2}, ImagePadding -> 
       10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[
        0.7], {LineBox[{{2.2092424357692217`, 0.17407811536960238`}, {
          1.0043508210892744`, 0.}}], 
         InsetBox["5", {1.606796628429248, 0.08703905768480119}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{2.2092424357692217`, 0.17407811536960238`}, {
          1.563333774314068, 0.7264272943699022}}], 
         InsetBox["6", {1.886288105041645, 0.4502527048697523}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{2.2092424357692217`, 0.17407811536960238`}, {
          2.2076810602499024`, 1.2794568700234383`}}], 
         InsetBox["7", {2.208461748009562, 0.7267674926965204}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.0043508210892744`, 0.}, {1.563333774314068, 
          0.7264272943699022}}], 
         InsetBox["5", {1.2838422977016712, 0.3632136471849511}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.0043508210892744`, 0.}, {0., 0.7255548226978403}}], 
         InsetBox["5", {0.5021754105446372, 0.36277741134892016}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.0043508210892744`, 0.}, {0.6221553129785029, 
          0.7254579510881765}}], 
         InsetBox["4", {0.8132530670338887, 0.36272897554408823}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.563333774314068, 0.7264272943699022}, {
          2.2076810602499024`, 1.2794568700234383`}}], 
         InsetBox["2", {1.8855074172819852, 1.0029420821966704}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.563333774314068, 0.7264272943699022}, {
          0.6221553129785029, 0.7254579510881765}}], 
         InsetBox["2", {1.0927445436462855, 0.7259426227290393}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.563333774314068, 0.7264272943699022}, {
          1.0023035097000652`, 1.452756853547055}}], 
         InsetBox["3", {1.2828186420070666, 1.0895920739584786}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{2.2076810602499024`, 1.2794568700234383`}, {
          1.0023035097000652`, 1.452756853547055}}], 
         InsetBox["2", {1.6049922849749838, 1.3661068617852465}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0., 0.7255548226978403}, {0.6221553129785029, 
          0.7254579510881765}}], 
         InsetBox["3", {0.31107765648925145, 0.7255063868930084}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0., 0.7255548226978403}, {1.0023035097000652`, 
          1.452756853547055}}], 
         InsetBox["3", {0.5011517548500326, 1.0891558381224478}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.6221553129785029, 0.7254579510881765}, {
          1.0023035097000652`, 1.452756853547055}}], 
         InsetBox["1", {0.8122294113392841, 1.0891074023176157}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.2092424357692217, 0.17407811536960238}, 
          0.02428691164430677], 
         InsetBox["a", 
          Offset[{2, 2}, {2.2335293474135285, 0.19836502701390915}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0043508210892744, 0.}, 0.02428691164430677], 
         InsetBox["b", 
          Offset[{2, 2}, {1.0286377327335812, 0.02428691164430677}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.563333774314068, 0.7264272943699022}, 
          0.02428691164430677], 
         InsetBox["d", 
          Offset[{2, 2}, {1.5876206859583748, 0.7507142060142089}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.2076810602499024, 1.2794568700234383}, 
          0.02428691164430677], 
         InsetBox["f", Offset[{2, 2}, {2.231967971894209, 1.303743781667745}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.7255548226978403}, 0.02428691164430677], 
         InsetBox["c", 
          Offset[{2, 2}, {0.02428691164430677, 0.7498417343421471}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.6221553129785029, 0.7254579510881765}, 
          0.02428691164430677], 
         InsetBox["e", 
          Offset[{2, 2}, {0.6464422246228096, 0.7497448627324832}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0023035097000652, 1.452756853547055}, 
          0.02428691164430677], 
         InsetBox["g", 
          Offset[{2, 2}, {1.026590421344372, 1.4770437651913617}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.8133180951993113`*^9, 3.813318103850173*^9}, 
   3.8133185450372105`*^9, 3.8133236193748198`*^9, 3.813340490412181*^9, 
   3.8133466739040956`*^9, 3.813346758680972*^9, {3.8133468257899914`*^9, 
   3.8133468406113424`*^9}, {3.813346955885067*^9, 3.8133469801692066`*^9}, 
   3.813347948371088*^9, {3.813348092379881*^9, 3.8133481056947074`*^9}, 
   3.813348141301208*^9, 3.8133531250239267`*^9, 3.8134177588458796`*^9, 
   3.8134186305982075`*^9, {3.813418690144023*^9, 3.8134187406264005`*^9}, 
   3.8134272986682835`*^9, 3.8134295367386923`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"b7b9e996-4307-4f9c-a7a1-ad0f72b526ae"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La longitud de un camino m\[AAcute]s corto es: \"\>", 
   "\[InvisibleSpace]", "9"}],
  SequenceForm["La longitud de un camino m\[AAcute]s corto es: ", 9],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8134186904616966`*^9, 3.8134187406313868`*^9}, 
   3.8134272986682835`*^9, 3.8134295367446737`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"a3702e36-2ffd-4b52-ac62-4d13d2460ee4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Iteraciones: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"a", "b", "d", "f", "c", "e", "g"},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"9", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"8", ",", 
          RowBox[{"{", "d", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"9", ",", 
          RowBox[{"{", "d", "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"8", ",", 
          RowBox[{"{", "d", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"9", ",", 
          RowBox[{"{", 
           RowBox[{"d", ",", "f"}], "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"8", ",", 
          RowBox[{"{", "d", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"9", ",", 
          RowBox[{"{", 
           RowBox[{"d", ",", "f", ",", "e"}], "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"8", ",", 
          RowBox[{"{", "d", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"9", ",", 
          RowBox[{"{", 
           RowBox[{"d", ",", "f", ",", "e"}], "}"}]}], "}"}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Iteraciones: ", 
   MatrixForm[{{$CellContext`a, $CellContext`b, $CellContext`d, \
$CellContext`f, $CellContext`c, $CellContext`e, $CellContext`g}, {{0, {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}}, {{0, {}}, {5, {$CellContext`a}}, {
      6, {$CellContext`a}}, {7, {$CellContext`a}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}}, {{0, {}}, {5, {$CellContext`a}}, {
      6, {$CellContext`a}}, {7, {$CellContext`a}}, {10, {$CellContext`b}}, {
      9, {$CellContext`b}}, {
       DirectedInfinity[1], {}}}, {{0, {}}, {5, {$CellContext`a}}, {
      6, {$CellContext`a}}, {7, {$CellContext`a}}, {10, {$CellContext`b}}, {
      8, {$CellContext`d}}, {9, {$CellContext`d}}}, {{0, {}}, {
      5, {$CellContext`a}}, {6, {$CellContext`a}}, {7, {$CellContext`a}}, {
      10, {$CellContext`b}}, {8, {$CellContext`d}}, {
      9, {$CellContext`d, $CellContext`f}}}, {{0, {}}, {
      5, {$CellContext`a}}, {6, {$CellContext`a}}, {7, {$CellContext`a}}, {
      10, {$CellContext`b}}, {8, {$CellContext`d}}, {
      9, {$CellContext`d, $CellContext`f, $CellContext`e}}}, {{0, {}}, {
      5, {$CellContext`a}}, {6, {$CellContext`a}}, {7, {$CellContext`a}}, {
      10, {$CellContext`b}}, {8, {$CellContext`d}}, {
      9, {$CellContext`d, $CellContext`f, $CellContext`e}}}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8134186904616966`*^9, 3.8134187406313868`*^9}, 
   3.8134272986682835`*^9, 3.813429536751272*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"9bb2d680-4565-4c67-a4a9-53c5b06ccc94"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "g"}], "}"}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.8134186904616966`*^9, 3.8134187406313868`*^9}, 
   3.8134272986682835`*^9, 3.813429536751272*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"e877090c-93dc-4962-8ad3-7ba3a2416dca"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 2, 1}}, 
    Typeset`size$$ = {810., {276., 286.7138993506803}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 2, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{909., {357., 369.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.8134186904616966`*^9, 3.8134187406313868`*^9}, 
   3.8134272986682835`*^9, 3.8134295367694125`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"7d390b2e-4274-41f0-b943-6ffe63b1f7e7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "g"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8133180951993113`*^9, 3.813318103850173*^9}, 
   3.8133185450372105`*^9, 3.8133236193748198`*^9, 3.813340490412181*^9, 
   3.8133466739040956`*^9, 3.813346758680972*^9, {3.8133468257899914`*^9, 
   3.8133468406113424`*^9}, {3.813346955885067*^9, 3.8133469801692066`*^9}, 
   3.813347948371088*^9, {3.813348092379881*^9, 3.8133481056947074`*^9}, 
   3.813348141301208*^9, 3.8133531250239267`*^9, 3.8134177588458796`*^9, 
   3.8134186305982075`*^9, {3.813418690144023*^9, 3.8134187406264005`*^9}, 
   3.8134272986682835`*^9, 3.813429536839713*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"b0fcdc4c-a03b-46f9-b251-4dbbae86f7e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlDijkstra", "[", 
  RowBox[{"grafo", ",", "a", ",", "g", ",", 
   RowBox[{"all", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8134280128834515`*^9, 3.813428021181452*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"d884f95c-8625-4cac-b144-6d1eadc5c43f"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Tabla de pesos del grafo\"\>"], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542318013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"642cf323-6c0d-4ce8-bd01-13eceafc9fc4"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "5", "6", "7", "0", "0", "0"},
     {
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "5", "0", "5", "0", "5", "4", "0"},
     {
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "6", "5", "0", "2", "0", "2", "3"},
     {
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "7", "0", "2", "0", "0", "0", "2"},
     {
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "5", "0", "0", "0", "3", "3"},
     {
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "4", "2", "0", "3", "0", "1"},
     {
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "0", "3", "2", "3", "1", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]]}, {
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]]}}]]]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542318013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"6a93d656-4b2a-4a2b-885f-53f42188aa0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Inicializaci\[OAcute]n: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "\[Infinity]", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "\[Infinity]", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "\[Infinity]", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "\[Infinity]", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "\[Infinity]", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "\[Infinity]", ",", 
       RowBox[{"{", "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Inicializaci\[OAcute]n: ", {{$CellContext`a, 0, {}}, {$CellContext`b, 
     DirectedInfinity[1], {}}, {$CellContext`d, 
     DirectedInfinity[1], {}}, {$CellContext`f, 
     DirectedInfinity[1], {}}, {$CellContext`c, 
     DirectedInfinity[1], {}}, {$CellContext`e, 
     DirectedInfinity[1], {}}, {$CellContext`g, 
     DirectedInfinity[1], {}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542318013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"fb2e02fc-43da-4832-bb08-01ab3a75b5ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "a"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`a],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542318013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"4ff2fe0f-5dc2-4697-8cdf-3ebb29c34294"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d", ",", "f", ",", "c", ",", "e", ",", "g"}], "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`b, $CellContext`d, \
$CellContext`f, $CellContext`c, $CellContext`e, $CellContext`g}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542318013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"8df2eed6-857f-4ce4-9fc6-d79364e508de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "5", ",", 
       RowBox[{"{", "a", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "6", ",", 
       RowBox[{"{", "a", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "7", ",", 
       RowBox[{"{", "a", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "\[Infinity]", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "\[Infinity]", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "\[Infinity]", ",", 
       RowBox[{"{", "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`b, 
     5, {$CellContext`a}}, {$CellContext`d, 
     6, {$CellContext`a}}, {$CellContext`f, 
     7, {$CellContext`a}}, {$CellContext`c, 
     DirectedInfinity[1], {}}, {$CellContext`e, 
     DirectedInfinity[1], {}}, {$CellContext`g, 
     DirectedInfinity[1], {}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542318013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"8d1597ea-697a-4c38-a68a-b7c0b5e1f584"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "b"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`b],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542318013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"dbf2083d-f553-4478-a96d-834f5098b491"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"d", ",", "f", ",", "c", ",", "e", ",", "g"}], "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`d, $CellContext`f, \
$CellContext`c, $CellContext`e, $CellContext`g}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542318013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"789df54c-7896-45d2-aab7-f690e262c811"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", "6", ",", 
       RowBox[{"{", "a", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "7", ",", 
       RowBox[{"{", "a", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "10", ",", 
       RowBox[{"{", "b", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "9", ",", 
       RowBox[{"{", "b", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "\[Infinity]", ",", 
       RowBox[{"{", "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`d, 
     6, {$CellContext`a}}, {$CellContext`f, 
     7, {$CellContext`a}}, {$CellContext`c, 
     10, {$CellContext`b}}, {$CellContext`e, 
     9, {$CellContext`b}}, {$CellContext`g, 
     DirectedInfinity[1], {}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542318013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"3d4a8d0b-7a7a-44cb-92d7-79b9187f67e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "d"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`d],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542335888*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"d7351c5a-dcc8-4104-bb79-3898399f8e19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"f", ",", "c", ",", "e", ",", "g"}], "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`f, $CellContext`c, \
$CellContext`e, $CellContext`g}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.8134295423369093`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"4b3380ed-678f-4e19-8bc9-8e8e24fc4359"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "7", ",", 
       RowBox[{"{", "a", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "10", ",", 
       RowBox[{"{", "b", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "8", ",", 
       RowBox[{"{", "d", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "9", ",", 
       RowBox[{"{", "d", "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`f, 
     7, {$CellContext`a}}, {$CellContext`c, 
     10, {$CellContext`b}}, {$CellContext`e, 
     8, {$CellContext`d}}, {$CellContext`g, 9, {$CellContext`d}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.8134295423388815`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"4f91f48e-48d4-42cf-8c54-a7975ce9f23a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "f"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`f],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542340906*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"2adb791b-ec27-419d-b7d8-c209c9c3f404"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"c", ",", "e", ",", "g"}], "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`c, $CellContext`e, \
$CellContext`g}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.8134295423419094`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"0e9e547b-d413-48f6-8984-b3149a09d042"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "10", ",", 
       RowBox[{"{", "b", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "8", ",", 
       RowBox[{"{", "d", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "9", ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f"}], "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`c, 
     10, {$CellContext`b}}, {$CellContext`e, 
     8, {$CellContext`d}}, {$CellContext`g, 
     9, {$CellContext`d, $CellContext`f}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.81342954234287*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"ea4bfc7a-a3e9-4bb8-8f60-5697443840cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "e"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`e],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542343891*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"1f5e5770-3205-4a9d-9379-d350851aae4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"c", ",", "g"}], "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`c, $CellContext`g}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542345862*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"0652d0d7-3c2d-450d-bd62-3c600e7fe830"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "10", ",", 
       RowBox[{"{", "b", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "9", ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "f", ",", "e"}], "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`c, 
     10, {$CellContext`b}}, {$CellContext`g, 
     9, {$CellContext`d, $CellContext`f, $CellContext`e}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542347856*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"ca24aa7c-6b33-477f-9f85-038fcf2dd5fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "g"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`g],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542348854*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"079276be-9fdc-40ea-82bb-9737adcbb056"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La longitud de un camino m\[AAcute]s corto es: \"\>", 
   "\[InvisibleSpace]", "9"}],
  SequenceForm["La longitud de un camino m\[AAcute]s corto es: ", 9],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542349921*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"67311b4c-a86f-4aae-b6f7-5393b9204b9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "c", "}"}]}],
  SequenceForm["Lista actual de v\[EAcute]rtices: ", {$CellContext`c}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.813429542349921*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"ae37e056-4119-41ea-a965-8487a656bd87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"c", ",", "10", ",", 
      RowBox[{"{", "b", "}"}]}], "}"}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`c, 10, {$CellContext`b}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.8134295423514347`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"3e7641d8-3675-4dea-8799-fd4f94a113dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Iteraciones: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"a", "b", "d", "f", "c", "e", "g"},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"9", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"8", ",", 
          RowBox[{"{", "d", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"9", ",", 
          RowBox[{"{", "d", "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"8", ",", 
          RowBox[{"{", "d", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"9", ",", 
          RowBox[{"{", 
           RowBox[{"d", ",", "f"}], "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"8", ",", 
          RowBox[{"{", "d", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"9", ",", 
          RowBox[{"{", 
           RowBox[{"d", ",", "f", ",", "e"}], "}"}]}], "}"}]},
       {
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"{", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"6", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"7", ",", 
          RowBox[{"{", "a", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{"{", "b", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"8", ",", 
          RowBox[{"{", "d", "}"}]}], "}"}], 
        RowBox[{"{", 
         RowBox[{"9", ",", 
          RowBox[{"{", 
           RowBox[{"d", ",", "f", ",", "e"}], "}"}]}], "}"}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Iteraciones: ", 
   MatrixForm[{{$CellContext`a, $CellContext`b, $CellContext`d, \
$CellContext`f, $CellContext`c, $CellContext`e, $CellContext`g}, {{0, {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}}, {{0, {}}, {5, {$CellContext`a}}, {
      6, {$CellContext`a}}, {7, {$CellContext`a}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}, {
       DirectedInfinity[1], {}}}, {{0, {}}, {5, {$CellContext`a}}, {
      6, {$CellContext`a}}, {7, {$CellContext`a}}, {10, {$CellContext`b}}, {
      9, {$CellContext`b}}, {
       DirectedInfinity[1], {}}}, {{0, {}}, {5, {$CellContext`a}}, {
      6, {$CellContext`a}}, {7, {$CellContext`a}}, {10, {$CellContext`b}}, {
      8, {$CellContext`d}}, {9, {$CellContext`d}}}, {{0, {}}, {
      5, {$CellContext`a}}, {6, {$CellContext`a}}, {7, {$CellContext`a}}, {
      10, {$CellContext`b}}, {8, {$CellContext`d}}, {
      9, {$CellContext`d, $CellContext`f}}}, {{0, {}}, {
      5, {$CellContext`a}}, {6, {$CellContext`a}}, {7, {$CellContext`a}}, {
      10, {$CellContext`b}}, {8, {$CellContext`d}}, {
      9, {$CellContext`d, $CellContext`f, $CellContext`e}}}, {{0, {}}, {
      5, {$CellContext`a}}, {6, {$CellContext`a}}, {7, {$CellContext`a}}, {
      10, {$CellContext`b}}, {8, {$CellContext`d}}, {
      9, {$CellContext`d, $CellContext`f, $CellContext`e}}}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.8134295423514347`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"b89e4bfb-c764-438b-81c3-766f23e3f081"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "g"}], "}"}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.8134295423514347`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"e5da0d56-97fd-43ea-9b27-69ab4e71db0d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 2, 1}}, 
    Typeset`size$$ = {810., {276., 286.7138993506803}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 2, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{909., {357., 369.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.8134280220602875`*^9, 3.8134295423691387`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"1b175b8b-0bb3-43e2-abd6-887ff6fcef2e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LongitudCaminoMC", "[", 
  RowBox[{"grafo", ",", "a", ",", "g", ",", 
   RowBox[{"ruta", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8134187235622673`*^9, 3.813418727137255*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"f2cb7635-7091-42fd-82c1-9f766681daab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "g"}], "}"}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8134187278852577`*^9, 3.813429547966853*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"e491cf05-de0a-4ca6-af16-ec8eef72f2df"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 2, 1}}, 
    Typeset`size$$ = {810., {276., 286.7138993506803}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 2, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{909., {357., 369.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.8134187278852577`*^9, 3.8134295479872155`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"3f5197f1-a3bc-4185-a99e-843b0bf46564"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1440., 747.75},
WindowMargins->{{Automatic, 956}, {-18.5, Automatic}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"7b48d8cb-6e0b-46c4-92d6-30dce2e80710"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 199, 3, 63, "Input",ExpressionUUID->"3dbe346f-5738-4edd-9429-1c3129f1727b"],
Cell[CellGroupData[{
Cell[782, 27, 1944, 49, 303, "Input",ExpressionUUID->"d0cc1d56-0e87-4799-9f08-2e03d2d80484"],
Cell[2729, 78, 7197, 136, 629, "Output",ExpressionUUID->"b7b9e996-4307-4f9c-a7a1-ad0f72b526ae"],
Cell[CellGroupData[{
Cell[9951, 218, 473, 10, 49, "Print",ExpressionUUID->"a3702e36-2ffd-4b52-ac62-4d13d2460ee4"],
Cell[10427, 230, 7220, 206, 359, "Print",ExpressionUUID->"9bb2d680-4565-4c67-a4a9-53c5b06ccc94"],
Cell[17650, 438, 466, 13, 49, "Print",ExpressionUUID->"e877090c-93dc-4962-8ad3-7ba3a2416dca"],
Cell[18119, 453, 2370, 51, 746, "Print",ExpressionUUID->"7d390b2e-4274-41f0-b943-6ffe63b1f7e7"]
}, Open  ]],
Cell[20504, 507, 877, 17, 101, "Output",ExpressionUUID->"b0fcdc4c-a03b-46f9-b251-4dbbae86f7e4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21418, 529, 292, 5, 126, "Input",ExpressionUUID->"d884f95c-8625-4cac-b144-6d1eadc5c43f"],
Cell[CellGroupData[{
Cell[21735, 538, 241, 4, 49, "Print",ExpressionUUID->"642cf323-6c0d-4ce8-bd01-13eceafc9fc4"],
Cell[21979, 544, 5600, 185, 294, "Print",ExpressionUUID->"6a93d656-4b2a-4a2b-885f-53f42188aa0a"],
Cell[27582, 731, 1449, 38, 89, "Print",ExpressionUUID->"fb2e02fc-43da-4832-bb08-01ab3a75b5ba"],
Cell[29034, 771, 398, 9, 49, "Print",ExpressionUUID->"4ff2fe0f-5dc2-4697-8cdf-3ebb29c34294"],
Cell[29435, 782, 576, 12, 49, "Print",ExpressionUUID->"8df2eed6-857f-4ce4-9fc6-d79364e508de"],
Cell[30014, 796, 1301, 35, 89, "Print",ExpressionUUID->"8d1597ea-697a-4c38-a68a-b7c0b5e1f584"],
Cell[31318, 833, 398, 9, 49, "Print",ExpressionUUID->"dbf2083d-f553-4478-a96d-834f5098b491"],
Cell[31719, 844, 550, 12, 49, "Print",ExpressionUUID->"789df54c-7896-45d2-aab7-f690e262c811"],
Cell[32272, 858, 1139, 31, 89, "Print",ExpressionUUID->"3d4a8d0b-7a7a-44cb-92d7-79b9187f67e4"],
Cell[33414, 891, 398, 9, 49, "Print",ExpressionUUID->"d7351c5a-dcc8-4104-bb79-3898399f8e19"],
Cell[33815, 902, 526, 12, 49, "Print",ExpressionUUID->"4b3380ed-678f-4e19-8bc9-8e8e24fc4359"],
Cell[34344, 916, 980, 26, 49, "Print",ExpressionUUID->"4f91f48e-48d4-42cf-8c54-a7975ce9f23a"],
Cell[35327, 944, 398, 9, 49, "Print",ExpressionUUID->"2adb791b-ec27-419d-b7d8-c209c9c3f404"],
Cell[35728, 955, 500, 12, 49, "Print",ExpressionUUID->"0e9e547b-d413-48f6-8984-b3149a09d042"],
Cell[36231, 969, 882, 24, 49, "Print",ExpressionUUID->"ea4bfc7a-a3e9-4bb8-8f60-5697443840cb"],
Cell[37116, 995, 398, 9, 49, "Print",ExpressionUUID->"1f5e5770-3205-4a9d-9379-d350851aae4e"],
Cell[37517, 1006, 470, 11, 49, "Print",ExpressionUUID->"0652d0d7-3c2d-450d-bd62-3c600e7fe830"],
Cell[37990, 1019, 763, 20, 49, "Print",ExpressionUUID->"ca24aa7c-6b33-477f-9f85-038fcf2dd5fb"],
Cell[38756, 1041, 398, 9, 49, "Print",ExpressionUUID->"079276be-9fdc-40ea-82bb-9737adcbb056"],
Cell[39157, 1052, 417, 9, 49, "Print",ExpressionUUID->"67311b4c-a86f-4aae-b6f7-5393b9204b9c"],
Cell[39577, 1063, 426, 9, 49, "Print",ExpressionUUID->"ae37e056-4119-41ea-a965-8487a656bd87"],
Cell[40006, 1074, 524, 13, 49, "Print",ExpressionUUID->"3e7641d8-3675-4dea-8799-fd4f94a113dd"],
Cell[40533, 1089, 7168, 205, 359, "Print",ExpressionUUID->"b89e4bfb-c764-438b-81c3-766f23e3f081"],
Cell[47704, 1296, 414, 12, 49, "Print",ExpressionUUID->"e5da0d56-97fd-43ea-9b27-69ab4e71db0d"],
Cell[48121, 1310, 2316, 50, 746, "Print",ExpressionUUID->"1b175b8b-0bb3-43e2-abd6-887ff6fcef2e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50486, 1366, 299, 5, 126, "Input",ExpressionUUID->"f2cb7635-7091-42fd-82c1-9f766681daab"],
Cell[CellGroupData[{
Cell[50810, 1375, 412, 12, 49, "Print",ExpressionUUID->"e491cf05-de0a-4ca6-af16-ec8eef72f2df"],
Cell[51225, 1389, 2316, 50, 746, "Print",ExpressionUUID->"3f5197f1-a3bc-4185-a99e-843b0bf46564"]
}, Open  ]]
}, Open  ]]
}
]
*)

