(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     49939,       1172]
NotebookOptionsPosition[     47744,       1125]
NotebookOutlinePosition[     48178,       1142]
CellTagsIndexPosition[     48135,       1139]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.814783656107747*^9, 3.8147836587350225`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"25431506-cbc8-40ee-a6e1-cf70cb73bf9d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "]"}], ",", "Automatic", ",", 
   "1", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"2", "\[Rule]", " ", "\"\<(3-2a)+(((f-4)c)/g)\>\""}], ",", " ", 
      RowBox[{"3", "\[Rule]", "\"\<(b\[Divide]2c-(3d-e))+a\>\""}]}], "}"}]}], 
   ",", 
   RowBox[{"ImagePadding", "\[Rule]", "77"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8148097169276934`*^9, 3.814809724472198*^9}, {
  3.814809815612646*^9, 3.8148098753578997`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"0fa37d26-064f-4623-a1a7-95300e3b268b"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
    LineBox[{{{0.4472135954999579, 0.8944271909999159}, {0., 0.}}, {{
     0.4472135954999579, 0.8944271909999159}, {0.8944271909999159, 0.}}}]}, 
   {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
    0.7]}], {DiskBox[{0.4472135954999579, 0.8944271909999159}, 
      0.011386058141428929], 
     InsetBox["\<\"+\"\>", 
      Offset[{2, 2}, {0.4585996536413869, 0.9058132491413448}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.011386058141428929], 
     InsetBox["\<\"(3-2a)+(((f-4)c)/g)\"\>", 
      Offset[{2, 2}, {0.011386058141428929, 0.011386058141428929}], 
      ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{0.8944271909999159, 0.}, 0.011386058141428929], 
     InsetBox["\<\"(b\[Divide]2c-(3d-e))+a\"\>", 
      Offset[{2, 2}, {0.9058132491413448, 0.011386058141428929}], 
      ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}}},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->77]], "Output",
 CellChangeTimes->{
  3.8148097270907865`*^9, {3.814809834630457*^9, 3.8148098757332544`*^9}, 
   3.8148128470685406`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"9004576a-266a-422f-9c9a-4eb3a8cccdfd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7"}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"2", "\[Rule]", " ", "\"\<+\>\""}], ",", " ", 
      RowBox[{"3", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"4", "\[Rule]", "\"\<3-2a\>\""}], ",", 
      RowBox[{"5", "\[Rule]", "\"\<(f-4)*c)/g\>\""}], ",", 
      RowBox[{"6", "\[Rule]", "\"\<b\[Divide]2c-(3d-e)\>\""}], ",", 
      RowBox[{"7", "\[Rule]", "\"\<a\>\""}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8148106326059904`*^9, 3.814810737602734*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"fb6f7d1f-cd5f-4990-90e4-60894367f210"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7}, {
      Null, {{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}}}, {
      VertexLabels -> {
        6 -> "b\[Divide]2c-(3d-e)", 3 -> "+", 5 -> "(f-4)*c)/g", 7 -> "a", 4 -> 
         "3-2a", 2 -> "+", 1 -> "+"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        LineBox[{{{1.2247448713915892`, 1.6329931618554523`}, {
         0.4082482904638631, 0.8164965809277261}}, {{1.2247448713915892`, 
         1.6329931618554523`}, {2.041241452319315, 0.8164965809277261}}, {{
         0.4082482904638631, 0.8164965809277261}, {0., 0.}}, {{
         0.4082482904638631, 0.8164965809277261}, {0.8164965809277261, 
         0.}}, {{2.041241452319315, 0.8164965809277261}, {1.6329931618554523`,
          0.}}, {{2.041241452319315, 0.8164965809277261}, {
         2.4494897427831783`, 0.}}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.2247448713915892, 1.6329931618554523}, 
          0.02615707791054188], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {1.250901949302131, 1.659150239765994}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4082482904638631, 0.8164965809277261}, 
          0.02615707791054188], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {0.43440536837440497, 0.842653658838268}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.041241452319315, 0.8164965809277261}, 
          0.02615707791054188], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {2.067398530229857, 0.842653658838268}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.02615707791054188], 
         InsetBox["\<\"3-2a\"\>", 
          Offset[{2, 2}, {0.02615707791054188, 0.02615707791054188}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8164965809277261, 0.}, 0.02615707791054188], 
         InsetBox["\<\"(f-4)*c)/g\"\>", 
          Offset[{2, 2}, {0.842653658838268, 0.02615707791054188}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6329931618554523, 0.}, 0.02615707791054188], 
         InsetBox["\<\"b\[Divide]2c-(3d-e)\"\>", 
          Offset[{2, 2}, {1.659150239765994, 0.02615707791054188}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.4494897427831783, 0.}, 0.02615707791054188], 
         InsetBox["\<\"a\"\>", 
          Offset[{2, 2}, {2.4756468206937203, 0.02615707791054188}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.8148106417597876`*^9, 3.814810666482225*^9}, 
   3.8148107386817617`*^9, 3.814812850123564*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"99851f86-baa9-4d70-b424-3a74f259888f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "15"}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"2", "\[Rule]", " ", "\"\<+\>\""}], ",", " ", 
      RowBox[{"3", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"4", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"5", "\[Rule]", "\"\<\[Divide]\>\""}], ",", 
      RowBox[{"6", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"7", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"8", "\[Rule]", "\"\<3\>\""}], ",", 
      RowBox[{"9", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"10", "\[Rule]", "\"\<(f-4)*c\>\""}], ",", 
      RowBox[{"11", "\[Rule]", "\"\<g\>\""}], ",", 
      RowBox[{"12", "\[Rule]", "\"\<b\[Divide]2c\>\""}], ",", 
      RowBox[{"13", "\[Rule]", "\"\<3d-e\>\""}], ",", 
      RowBox[{"14", "\[Rule]", "\"\<2\>\""}], ",", 
      RowBox[{"15", "\[Rule]", "\"\<a\>\""}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.814811126578216*^9, 3.81481113900152*^9}, {
  3.8148111836542397`*^9, 3.8148112553879704`*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"8a7da933-a987-4eb4-ac26-a00537fa9a33"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {
      Null, {{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {4, 8}, {4, 9}, {
       5, 10}, {5, 11}, {7, 12}, {7, 13}, {9, 14}, {9, 15}}}, {
      VertexLabels -> {
        6 -> "a", 3 -> "+", 11 -> "g", 5 -> "\[Divide]", 8 -> "3", 7 -> "-", 
         14 -> "2", 10 -> "(f-4)*c", 9 -> "*", 4 -> "-", 12 -> "b\[Divide]2c",
          13 -> "3d-e", 2 -> "+", 15 -> "a", 1 -> "+"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgA2ImKF725sv6iZsZHaacmdQdv5/TIV9y3Yp2/8/2EJrZ
AV0eVR0zhnqI/E17CP3THl3+7n7r7bPFGRxg8ujmMRUrzCpuZ8Mpr67GWuv9
nQdNHmEfAxRA+C8x5FHFX9pjd89PnPKo/nxpj909nDjlIeYJOKC7A9292P3x
Eh6eMHkAE+/auA==
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.2126802202816007, 3.2184439567732372}, 
          0.037152637843896955], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {2.249832858125498, 3.2555965946171344}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.206916483789964, 2.413832967579928}, 
          0.037152637843896955], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {1.2440691216338609, 2.450985605423825}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.2184439567732372, 2.413832967579928}, 
          0.037152637843896955], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {3.2555965946171344, 2.450985605423825}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.40230549459665466, 1.6092219783866186}, 
          0.037152637843896955], 
         InsetBox["\<\"-\"\>", 
          Offset[{2, 2}, {0.4394581324405516, 1.6463746162305155}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.0115274729832735, 1.6092219783866186}, 
          0.037152637843896955], 
         InsetBox["\<\"\[Divide]\"\>", 
          Offset[{2, 2}, {2.0486801108271706, 1.6463746162305155}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.816138462176583, 1.6092219783866186}, 
          0.037152637843896955], 
         InsetBox["\<\"a\"\>", 
          Offset[{2, 2}, {2.85329110002048, 1.6463746162305155}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.620749451369892, 1.6092219783866186}, 
          0.037152637843896955], 
         InsetBox["\<\"-\"\>", 
          Offset[{2, 2}, {3.6579020892137892, 1.6463746162305155}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.8046109891933093}, 0.037152637843896955], 
         InsetBox["\<\"3\"\>", 
          Offset[{2, 2}, {0.037152637843896955, 0.8417636270372063}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8046109891933093, 0.8046109891933093}, 
          0.037152637843896955], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {0.8417636270372063, 0.8417636270372063}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6092219783866186, 0.8046109891933093}, 
          0.037152637843896955], 
         InsetBox["\<\"(f-4)*c\"\>", 
          Offset[{2, 2}, {1.6463746162305155, 0.8417636270372063}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.413832967579928, 0.8046109891933093}, 
          0.037152637843896955], 
         InsetBox["\<\"g\"\>", 
          Offset[{2, 2}, {2.450985605423825, 0.8417636270372063}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.2184439567732372, 0.8046109891933093}, 
          0.037152637843896955], 
         InsetBox["\<\"b\[Divide]2c\"\>", 
          Offset[{2, 2}, {3.2555965946171344, 0.8417636270372063}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.023054945966547, 0.8046109891933093}, 
          0.037152637843896955], 
         InsetBox["\<\"3d-e\"\>", 
          Offset[{2, 2}, {4.060207583810444, 0.8417636270372063}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.40230549459665466, 0.}, 0.037152637843896955], 
         InsetBox["\<\"2\"\>", 
          Offset[{2, 2}, {0.4394581324405516, 0.037152637843896955}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.206916483789964, 0.}, 0.037152637843896955], 
         InsetBox["\<\"a\"\>", 
          Offset[{2, 2}, {1.2440691216338609, 0.037152637843896955}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{3.8148111397875204`*^9, 3.814811189351075*^9, 
  3.8148112557719193`*^9, 3.814812853035104*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"55e717cf-f130-467e-a032-eeaafc8be7c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "11"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "13"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "14"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "16"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "17"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "18"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "19"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "21"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", "24"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", "25"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "26"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "27"}], "}"}]}], "}"}], "]"}], ",", "Automatic", 
   ",", "1", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"2", "\[Rule]", " ", "\"\<+\>\""}], ",", " ", 
      RowBox[{"3", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"4", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"5", "\[Rule]", "\"\<\[Divide]\>\""}], ",", 
      RowBox[{"6", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"7", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"8", "\[Rule]", "\"\<3\>\""}], ",", 
      RowBox[{"9", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"10", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"11", "\[Rule]", "\"\<g\>\""}], ",", 
      RowBox[{"12", "\[Rule]", "\"\<\[Divide]\>\""}], ",", 
      RowBox[{"13", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"14", "\[Rule]", "\"\<2\>\""}], ",", 
      RowBox[{"15", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"16", "\[Rule]", "\"\<c\>\""}], ",", 
      RowBox[{"17", "\[Rule]", "\"\<f-4\>\""}], ",", 
      RowBox[{"18", "\[Rule]", "\"\<b\>\""}], ",", 
      RowBox[{"19", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"20", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"21", "\[Rule]", "\"\<e\>\""}], ",", 
      RowBox[{"24", "\[Rule]", "\"\<2\>\""}], ",", 
      RowBox[{"25", "\[Rule]", "\"\<c\>\""}], ",", 
      RowBox[{"26", "\[Rule]", "\"\<3\>\""}], ",", 
      RowBox[{"27", "\[Rule]", "\"\<d\>\""}]}], "}"}]}], ",", 
   RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8148118901224966`*^9, 3.814811938904045*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"0ac5fc8b-e64e-4770-868e-722ca67d5bb0"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGCQAGImKL7x9tWXBbbsDn4rVY04eXkdIPzv9jBxdPkkow3b
LfIEHVDl0dVft4eoY8SQl53ge+1NKIsDTB7dPE72wwF7v/DjlLd/+O+Y0CMh
B1TzEfYxQAGqvejueW4Pk8fuHoS70eXR/Y3uHvRwxO5ecbRwQbgH5l5UcYQ8
xJyPcHF090Ls/4tTHuYfmDy6eyd7dwiHqnLhlIfFD6q7EP75ZTfn6bGTojjl
t86xZKneKAGXRzcPZh8sHtHlYekBJo9uH8R/IjjlYe6ByQMAYaiLHQ==
     "]]}, 
   {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
    0.7]}], {DiskBox[{2.9050921568102517, 3.6313651960128146}, 
      0.049362566690080045], 
     InsetBox["\<\"+\"\>", 
      Offset[{2, 2}, {2.954454723500332, 3.6807277627028947}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{1.4525460784051258, 2.9050921568102517}, 0.049362566690080045], 
     InsetBox["\<\"+\"\>", 
      Offset[{2, 2}, {1.501908645095206, 2.954454723500332}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{4.3576382352153775, 2.9050921568102517}, 0.049362566690080045], 
     InsetBox["\<\"+\"\>", 
      Offset[{2, 2}, {4.407000801905458, 2.954454723500332}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{0.36313651960128146, 2.1788191176076888}, 0.049362566690080045],
      InsetBox["\<\"-\"\>", 
      Offset[{2, 2}, {0.4124990862913615, 2.228181684297769}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{2.54195563720897, 2.1788191176076888}, 0.049362566690080045], 
     InsetBox["\<\"\[Divide]\"\>", 
      Offset[{2, 2}, {2.5913182038990503, 2.228181684297769}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{3.994501715614096, 2.1788191176076888}, 0.049362566690080045], 
     InsetBox["\<\"a\"\>", 
      Offset[{2, 2}, {4.043864282304176, 2.228181684297769}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{4.7207747548166585, 2.1788191176076888}, 0.049362566690080045], 
     InsetBox["\<\"-\"\>", 
      Offset[{2, 2}, {4.770137321506739, 2.228181684297769}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{0., 1.4525460784051258}, 0.049362566690080045], 
     InsetBox["\<\"3\"\>", 
      Offset[{2, 2}, {0.049362566690080045, 1.501908645095206}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{0.7262730392025629, 1.4525460784051258}, 0.049362566690080045], 
     InsetBox["\<\"*\"\>", 
      Offset[{2, 2}, {0.775635605892643, 1.501908645095206}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{2.1788191176076888, 1.4525460784051258}, 0.049362566690080045], 
     InsetBox["\<\"*\"\>", 
      Offset[{2, 2}, {2.228181684297769, 1.501908645095206}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{2.9050921568102517, 1.4525460784051258}, 0.049362566690080045], 
     InsetBox["\<\"g\"\>", 
      Offset[{2, 2}, {2.954454723500332, 1.501908645095206}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{3.6313651960128146, 1.4525460784051258}, 0.049362566690080045], 
     InsetBox["\<\"\[Divide]\"\>", 
      Offset[{2, 2}, {3.6807277627028947, 1.501908645095206}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{5.810184313620503, 1.4525460784051258}, 0.049362566690080045], 
     InsetBox["\<\"-\"\>", 
      Offset[{2, 2}, {5.8595468803105835, 1.501908645095206}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{0.36313651960128146, 0.7262730392025629}, 0.049362566690080045],
      InsetBox["\<\"2\"\>", 
      Offset[{2, 2}, {0.4124990862913615, 0.775635605892643}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{1.0894095588038444, 0.7262730392025629}, 0.049362566690080045], 
     InsetBox["\<\"a\"\>", 
      Offset[{2, 2}, {1.1387721254939245, 0.775635605892643}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{1.8156825980064073, 0.7262730392025629}, 0.049362566690080045], 
     InsetBox["\<\"c\"\>", 
      Offset[{2, 2}, {1.8650451646964874, 0.775635605892643}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{2.54195563720897, 0.7262730392025629}, 0.049362566690080045], 
     InsetBox["\<\"f-4\"\>", 
      Offset[{2, 2}, {2.5913182038990503, 0.775635605892643}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{3.268228676411533, 0.7262730392025629}, 0.049362566690080045], 
     InsetBox["\<\"b\"\>", 
      Offset[{2, 2}, {3.3175912431016132, 0.775635605892643}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{3.994501715614096, 0.7262730392025629}, 0.049362566690080045], 
     InsetBox["\<\"*\"\>", 
      Offset[{2, 2}, {4.043864282304176, 0.775635605892643}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{5.4470477940192215, 0.7262730392025629}, 0.049362566690080045], 
     InsetBox["\<\"*\"\>", 
      Offset[{2, 2}, {5.496410360709302, 0.775635605892643}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{6.173320833221784, 0.7262730392025629}, 0.049362566690080045], 
     InsetBox["\<\"e\"\>", 
      Offset[{2, 2}, {6.2226833999118645, 0.775635605892643}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{3.6313651960128146, 0.}, 0.049362566690080045], 
     InsetBox["\<\"2\"\>", 
      Offset[{2, 2}, {3.6807277627028947, 0.049362566690080045}], 
      ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{4.3576382352153775, 0.}, 0.049362566690080045], 
     InsetBox["\<\"c\"\>", 
      Offset[{2, 2}, {4.407000801905458, 0.049362566690080045}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{5.08391127441794, 0.}, 0.049362566690080045], 
     InsetBox["\<\"3\"\>", 
      Offset[{2, 2}, {5.1332738411080205, 0.049362566690080045}], 
      ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{5.810184313620503, 0.}, 0.049362566690080045], 
     InsetBox["\<\"d\"\>", 
      Offset[{2, 2}, {5.8595468803105835, 0.049362566690080045}], 
      ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}}},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.814811917401568*^9, 3.814811939810681*^9}, 
   3.8148128570313296`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"5c158b33-a3df-4ece-a7e5-3511b5978cf1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"17", ",", "22"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"17", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"19", ",", "24"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"19", ",", "25"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "26"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "27"}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"2", "\[Rule]", " ", "\"\<+\>\""}], ",", " ", 
      RowBox[{"3", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"4", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"5", "\[Rule]", "\"\<\[Divide]\>\""}], ",", 
      RowBox[{"6", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"7", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"8", "\[Rule]", "\"\<3\>\""}], ",", 
      RowBox[{"9", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"10", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"11", "\[Rule]", "\"\<g\>\""}], ",", 
      RowBox[{"12", "\[Rule]", "\"\<\[Divide]\>\""}], ",", 
      RowBox[{"13", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"14", "\[Rule]", "\"\<2\>\""}], ",", 
      RowBox[{"15", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"16", "\[Rule]", "\"\<c\>\""}], ",", 
      RowBox[{"17", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"18", "\[Rule]", "\"\<b\>\""}], ",", 
      RowBox[{"19", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"20", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"21", "\[Rule]", "\"\<e\>\""}], ",", 
      RowBox[{"22", "\[Rule]", "\"\<f\>\""}], ",", 
      RowBox[{"23", "\[Rule]", "\"\<4\>\""}], ",", 
      RowBox[{"24", "\[Rule]", "\"\<2\>\""}], ",", 
      RowBox[{"25", "\[Rule]", "\"\<c\>\""}], ",", 
      RowBox[{"26", "\[Rule]", "\"\<3\>\""}], ",", 
      RowBox[{"27", "\[Rule]", "\"\<d\>\""}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.814783824327525*^9, 3.814784016651951*^9}, {
   3.8147894417269135`*^9, 3.8147897516555157`*^9}, {3.814789784921399*^9, 
   3.814789794769807*^9}, {3.8147898636501617`*^9, 3.814789934696084*^9}, 
   3.8148097002342415`*^9},
 CellLabel->"In[65]:=",ExpressionUUID->"62477882-6c65-4b53-9b87-efa67126e72a"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
       20, 21, 22, 23, 24, 25, 26, 27}, {
      Null, {{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {4, 8}, {4, 9}, {
       5, 10}, {5, 11}, {7, 12}, {7, 13}, {9, 14}, {9, 15}, {10, 16}, {10, 
       17}, {12, 18}, {12, 19}, {13, 20}, {13, 21}, {17, 22}, {17, 23}, {19, 
       24}, {19, 25}, {20, 26}, {20, 27}}}, {
      VertexLabels -> {
        6 -> "a", 21 -> "e", 18 -> "b", 23 -> "4", 24 -> "2", 22 -> "f", 3 -> 
         "+", 20 -> "*", 11 -> "g", 27 -> "d", 5 -> "\[Divide]", 8 -> "3", 7 -> 
         "-", 14 -> "2", 10 -> "*", 25 -> "c", 9 -> "*", 4 -> "-", 26 -> "3", 
         17 -> "-", 16 -> "c", 12 -> "\[Divide]", 13 -> "-", 2 -> "+", 15 -> 
         "a", 1 -> "+", 19 -> "*"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGCQAmImKN4wbZKIWi+7Q7TN9pn5BbwOEP53+/VQcXR5lo+5
/XdWCjqgyqOrv27PDFbHiCF/y5khqHE2iwNMHt28mcdV9LgMBXDK50tt/7BO
SdgB1XyEfQxQsA5qL3b3PLeHyWN3D6MDLnlYeMDk0d0DCydc8hD94g6o7kO4
B+beNVBxdHmI+z7C5dHdC7H/L055mH9g8ujubX2pcv1UHRdOeVj8oLoP4R/X
XM/NwSJiOOWlDtwu/cEqCZdHdw8LWjyiy8PCHyaP7h6Ye3HJw9ITTB7dvRD7
RHDKw/wDkwcATAxN8g==
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.9439202887759492, 3.679900360969936}, 
          0.049778664255042834], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {2.993698953030992, 3.729679025224979}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.4719601443879746, 2.943920288775949}, 
          0.049778664255042834], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {1.5217388086430175, 2.9936989530309916}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.415880433163924, 2.943920288775949}, 
          0.049778664255042834], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {4.465659097418967, 2.9936989530309916}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.36799003609699366, 2.2079402165819615}, 
          0.049778664255042834], 
         InsetBox["\<\"-\"\>", 
          Offset[{2, 2}, {0.4177687003520365, 2.2577188808370043}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.5759302526789556, 2.2079402165819615}, 
          0.049778664255042834], 
         InsetBox["\<\"\[Divide]\"\>", 
          Offset[{2, 2}, {2.6257089169339984, 2.2577188808370043}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.04789039706693, 2.2079402165819615}, 
          0.049778664255042834], 
         InsetBox["\<\"a\"\>", 
          Offset[{2, 2}, {4.097669061321973, 2.2577188808370043}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.7838704692609175, 2.2079402165819615}, 
          0.049778664255042834], 
         InsetBox["\<\"-\"\>", 
          Offset[{2, 2}, {4.83364913351596, 2.2577188808370043}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.4719601443879742}, 0.049778664255042834], 
         InsetBox["\<\"3\"\>", 
          Offset[{2, 2}, {0.049778664255042834, 1.521738808643017}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7359800721939873, 1.4719601443879742}, 
          0.049778664255042834], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {0.7857587364490302, 1.521738808643017}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.207940216581962, 1.4719601443879742}, 
          0.049778664255042834], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {2.257718880837005, 1.521738808643017}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.9439202887759492, 1.4719601443879742}, 
          0.049778664255042834], 
         InsetBox["\<\"g\"\>", 
          Offset[{2, 2}, {2.993698953030992, 1.521738808643017}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.679900360969936, 1.4719601443879742}, 
          0.049778664255042834], 
         InsetBox["\<\"\[Divide]\"\>", 
          Offset[{2, 2}, {3.729679025224979, 1.521738808643017}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.8878405775518985, 1.4719601443879742}, 
          0.049778664255042834], 
         InsetBox["\<\"-\"\>", 
          Offset[{2, 2}, {5.937619241806941, 1.521738808643017}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.36799003609699366, 0.7359800721939869}, 
          0.049778664255042834], 
         InsetBox["\<\"2\"\>", 
          Offset[{2, 2}, {0.4177687003520365, 0.7857587364490297}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.103970108290981, 0.7359800721939869}, 
          0.049778664255042834], 
         InsetBox["\<\"a\"\>", 
          Offset[{2, 2}, {1.1537487725460238, 0.7857587364490297}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.839950180484968, 0.7359800721939869}, 
          0.049778664255042834], 
         InsetBox["\<\"c\"\>", 
          Offset[{2, 2}, {1.889728844740011, 0.7857587364490297}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.5759302526789556, 0.7359800721939869}, 
          0.049778664255042834], 
         InsetBox["\<\"-\"\>", 
          Offset[{2, 2}, {2.6257089169339984, 0.7857587364490297}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.3119103248729425, 0.7359800721939869}, 
          0.049778664255042834], 
         InsetBox["\<\"b\"\>", 
          Offset[{2, 2}, {3.3616889891279853, 0.7857587364490297}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.04789039706693, 0.7359800721939869}, 
          0.049778664255042834], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {4.097669061321973, 0.7857587364490297}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.519850541454905, 0.7359800721939869}, 
          0.049778664255042834], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {5.569629205709948, 0.7857587364490297}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.255830613648891, 0.7359800721939869}, 
          0.049778664255042834], 
         InsetBox["\<\"e\"\>", 
          Offset[{2, 2}, {6.305609277903934, 0.7857587364490297}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.207940216581962, 0.}, 0.049778664255042834], 
         InsetBox["\<\"f\"\>", 
          Offset[{2, 2}, {2.257718880837005, 0.049778664255042834}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.9439202887759492, 0.}, 0.049778664255042834], 
         InsetBox["\<\"4\"\>", 
          Offset[{2, 2}, {2.993698953030992, 0.049778664255042834}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.679900360969936, 0.}, 0.049778664255042834], 
         InsetBox["\<\"2\"\>", 
          Offset[{2, 2}, {3.729679025224979, 0.049778664255042834}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.415880433163924, 0.}, 0.049778664255042834], 
         InsetBox["\<\"c\"\>", 
          Offset[{2, 2}, {4.465659097418967, 0.049778664255042834}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.151860505357911, 0.}, 0.049778664255042834], 
         InsetBox["\<\"3\"\>", 
          Offset[{2, 2}, {5.201639169612954, 0.049778664255042834}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.8878405775518985, 0.}, 0.049778664255042834], 
         InsetBox["\<\"d\"\>", 
          Offset[{2, 2}, {5.937619241806941, 0.049778664255042834}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{3.8147839382217903`*^9, 3.814784017371573*^9, 
  3.8147840681049995`*^9, 3.8147844031382685`*^9, 3.8147897526011033`*^9, 
  3.814789944871461*^9, 3.814790336904997*^9, 3.814790421100769*^9, 
  3.814791481370821*^9, 3.814812860581624*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"b5a9f531-410d-4a4f-bd5a-cd0516e4d786"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArbolExpAlgebraica", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"2", "a"}]}], ")"}], "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"f", "-", "4"}], ")"}], "c"}], ")"}], "/", "g"}], ")"}]}], 
    ")"}], "+", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"b", "\[Divide]", "2"}], "c"}], "-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "d"}], "-", "e"}], ")"}]}], ")"}], "+", "a"}], ")"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8147836626497755`*^9, 3.8147836849959073`*^9}, {
   3.814790035455206*^9, 3.814790061087655*^9}, 3.8147901688584223`*^9},
 CellLabel->"In[66]:=",ExpressionUUID->"a84d184a-90eb-44ed-bb15-1c403ded0f5c"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Plus[3, Times[-1, a], Times[Rational[1, 2], b, c], \
Times[-3, d], e, Times[c, Plus[-4, f], Power[g, -1]]]\"\>"], "Print",
 CellChangeTimes->{3.8147901700651736`*^9, 3.8147903396274967`*^9, 
  3.8147904246005883`*^9, 3.8147914857981977`*^9, 3.8148128638501887`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[66]:=",ExpressionUUID->"5f4cff02-eee6-4a5d-ac6a-c3ad56e6968e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "Plus"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"3", "\[Rule]", "Times"}], ",", 
   RowBox[{"4", "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{"5", "\[Rule]", "a"}], ",", 
   RowBox[{"6", "\[Rule]", "Times"}], ",", 
   RowBox[{"7", "\[Rule]", 
    FractionBox["1", "2"]}], ",", 
   RowBox[{"8", "\[Rule]", "b"}], ",", 
   RowBox[{"9", "\[Rule]", "c"}], ",", 
   RowBox[{"10", "\[Rule]", "Times"}], ",", 
   RowBox[{"11", "\[Rule]", 
    RowBox[{"-", "3"}]}], ",", 
   RowBox[{"12", "\[Rule]", "d"}], ",", 
   RowBox[{"13", "\[Rule]", "e"}], ",", 
   RowBox[{"14", "\[Rule]", "Times"}], ",", 
   RowBox[{"15", "\[Rule]", "c"}], ",", 
   RowBox[{"16", "\[Rule]", "Plus"}], ",", 
   RowBox[{"17", "\[Rule]", 
    RowBox[{"-", "4"}]}], ",", 
   RowBox[{"18", "\[Rule]", "f"}], ",", 
   RowBox[{"19", "\[Rule]", "Power"}], ",", 
   RowBox[{"20", "\[Rule]", "g"}], ",", 
   RowBox[{"21", "\[Rule]", 
    RowBox[{"-", "1"}]}]}], "}"}]], "Print",
 CellChangeTimes->{3.8147901700651736`*^9, 3.8147903396274967`*^9, 
  3.8147904246005883`*^9, 3.8147914857981977`*^9, 3.814812863918564*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[66]:=",ExpressionUUID->"2b31773a-0955-490c-a89f-c182043585c1"]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 6, 10, 13, 14, 4, 5, 7, 8, 9, 11, 12, 15, 16, 19, 17, 18,
       20, 21}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {3, 8}, {3, 9}, {
       4, 10}, {4, 11}, {4, 12}, {5, 13}, {5, 14}, {7, 15}, {7, 16}, {7, 
       17}, {16, 18}, {16, 19}, {17, 20}, {17, 21}}}, {
      ImagePadding -> 10, VertexCoordinates -> CompressedData["
1:eJxTTMoPSmViYGAQBWIQnRISwtb+gMGhraCAY0vDN3sGKOCY5sD9geGdPYS+
Zw/juzff4Lzk8AvOh+hjc0CV54LzIeYLOKCadw5uLkT/Mzj/aCwH+7QDn+B8
VPvu2cPcC+Orpu9hX7qABc5/VqnCeTiBA85f3tPD9VCBB87PmP+F+/8Dfji/
NCmpfe4GYQdUf/I5wMIB5n4YH+I+ITgfYr8InA8AZypz9Q==
        "], VertexLabels -> {"Name"}, VertexShapeFunction -> {"Circle"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQAWImKE4JCWFrf8Dg0FZQwLGl4Zs9AxRwTHPg/sDwzh5d
HiJ+zx6XvHvzDc5LDr9wykNoNgf8+rlwykP4AnB5dPdA6HNo4gh5iDnP4OLo
7j0ay8E+7cAnnPKofEx5mHth8uj+VU3fw750AQtO+WeVKpyHEzjg8uj+Xd7T
w/VQgQenfMb8L9z/H/DjlC9NSmqfu0EYLo+uHkLzOcDSAS7zYPLo5kHCTwin
PMT/InB5AKQ27fw=
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.109632539223229, 1.4064216928154862}, 0.0439379129127271],
          InsetBox["1", 
          Offset[{2, 2}, {2.1535704521359564, 1.4503596057282133}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.9376144618769908}, 0.0439379129127271], 
         InsetBox["2", 
          Offset[{2, 2}, {0.0439379129127271, 0.9815523747897179}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4688072309384954, 0.9376144618769908}, 
          0.0439379129127271], 
         InsetBox["3", 
          Offset[{2, 2}, {0.5127451438512225, 0.9815523747897179}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.640825308284734, 0.9376144618769908}, 0.0439379129127271],
          InsetBox["6", 
          Offset[{2, 2}, {1.684763221197461, 0.9815523747897179}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.8128433856309725, 0.9376144618769908}, 
          0.0439379129127271], 
         InsetBox["10", 
          Offset[{2, 2}, {2.8567812985436998, 0.9815523747897179}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.281650616569468, 0.9376144618769908}, 0.0439379129127271],
          InsetBox["13", 
          Offset[{2, 2}, {3.325588529482195, 0.9815523747897179}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.219265078446458, 0.9376144618769908}, 0.0439379129127271],
          InsetBox["14", 
          Offset[{2, 2}, {4.263202991359186, 0.9815523747897179}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.2344036154692477, 0.4688072309384954}, 
          0.0439379129127271], 
         InsetBox["4", 
          Offset[{2, 2}, {0.2783415283819748, 0.5127451438512225}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7032108464077431, 0.4688072309384954}, 
          0.0439379129127271], 
         InsetBox["5", 
          Offset[{2, 2}, {0.7471487593204702, 0.5127451438512225}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.1720180773462385, 0.4688072309384954}, 
          0.0439379129127271], 
         InsetBox["7", 
          Offset[{2, 2}, {1.2159559902589656, 0.5127451438512225}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.640825308284734, 0.4688072309384954}, 0.0439379129127271],
          InsetBox["8", 
          Offset[{2, 2}, {1.684763221197461, 0.5127451438512225}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.109632539223229, 0.4688072309384954}, 0.0439379129127271],
          InsetBox["9", 
          Offset[{2, 2}, {2.1535704521359564, 0.5127451438512225}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.5784397701617245, 0.4688072309384954}, 
          0.0439379129127271], 
         InsetBox["11", 
          Offset[{2, 2}, {2.622377683074452, 0.5127451438512225}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.04724700110022, 0.4688072309384954}, 0.0439379129127271], 
         InsetBox["12", 
          Offset[{2, 2}, {3.0911849140129473, 0.5127451438512225}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.5160542320387154, 0.4688072309384954}, 
          0.0439379129127271], 
         InsetBox["15", 
          Offset[{2, 2}, {3.5599921449514427, 0.5127451438512225}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.9848614629772108, 0.4688072309384954}, 
          0.0439379129127271], 
         InsetBox["16", 
          Offset[{2, 2}, {4.028799375889938, 0.5127451438512225}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.922475924854202, 0.4688072309384954}, 0.0439379129127271],
          InsetBox["19", 
          Offset[{2, 2}, {4.966413837766929, 0.5127451438512225}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.7504578475079633, 0.}, 0.0439379129127271], 
         InsetBox["17", 
          Offset[{2, 2}, {3.7943957604206906, 0.0439379129127271}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.219265078446458, 0.}, 0.0439379129127271], 
         InsetBox["18", 
          Offset[{2, 2}, {4.263202991359186, 0.0439379129127271}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.688072309384954, 0.}, 0.0439379129127271], 
         InsetBox["20", 
          Offset[{2, 2}, {4.732010222297681, 0.0439379129127271}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.156879540323449, 0.}, 0.0439379129127271], 
         InsetBox["21", 
          Offset[{2, 2}, {5.200817453236176, 0.0439379129127271}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8147901702052245`*^9, 3.8147903397385206`*^9, 
  3.8147904247382936`*^9, 3.8147914859343076`*^9, 3.8148128639852285`*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"8589dde3-9411-4085-adbf-7fe31d3a843a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "[", 
  RowBox[{"3", ",", " ", 
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", " ", "a"}], "]"}], ",", " ", 
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"Rational", "[", 
      RowBox[{"1", ",", " ", "2"}], "]"}], ",", " ", "b", ",", " ", "c"}], 
    "]"}], ",", " ", 
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"-", "3"}], ",", " ", "d"}], "]"}], ",", " ", "e", ",", " ", 
   RowBox[{"Times", "[", 
    RowBox[{"c", ",", " ", 
     RowBox[{"Plus", "[", 
      RowBox[{
       RowBox[{"-", "4"}], ",", " ", "f"}], "]"}], ",", " ", 
     RowBox[{"Power", "[", 
      RowBox[{"g", ",", " ", 
       RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8147906488857102`*^9, 3.8147906509591517`*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"bba3a251-bcb4-4e33-95cf-f7a37a5b5d21"],

Cell[BoxData[
 RowBox[{"3", "-", "a", "+", 
  FractionBox[
   RowBox[{"b", " ", "c"}], "2"], "-", 
  RowBox[{"3", " ", "d"}], "+", "e", "+", 
  FractionBox[
   RowBox[{"c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "4"}], "+", "f"}], ")"}]}], "g"]}]], "Output",
 CellChangeTimes->{3.8147906517031536`*^9, 3.8147914900919013`*^9, 
  3.814812866839545*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"2df46d74-c8dd-44d5-a255-e559f979974c"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"05468591-e4df-4118-accf-3512367eddac"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"25431506-cbc8-40ee-a6e1-cf70cb73bf9d"],
Cell[CellGroupData[{
Cell[783, 27, 871, 21, 177, "Input",ExpressionUUID->"0fa37d26-064f-4623-a1a7-95300e3b268b"],
Cell[1657, 50, 1252, 26, 847, "Output",ExpressionUUID->"9004576a-266a-422f-9c9a-4eb3a8cccdfd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2946, 81, 1104, 28, 177, "Input",ExpressionUUID->"fb6f7d1f-cd5f-4990-90e4-60894367f210"],
Cell[4053, 111, 3216, 66, 607, "Output",ExpressionUUID->"99851f86-baa9-4d70-b424-3a74f259888f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7306, 182, 2076, 53, 266, "Input",ExpressionUUID->"8a7da933-a987-4eb4-ac26-a00537fa9a33"],
Cell[9385, 237, 5284, 115, 675, "Output",ExpressionUUID->"55e717cf-f130-467e-a032-eeaafc8be7c0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14706, 357, 3388, 85, 463, "Input",ExpressionUUID->"0ac5fc8b-e64e-4770-868e-722ca67d5bb0"],
Cell[18097, 444, 6287, 119, 549, "Output",ExpressionUUID->"5c158b33-a3df-4ece-a7e5-3511b5978cf1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24421, 568, 3596, 91, 351, "Input",ExpressionUUID->"62477882-6c65-4b53-9b87-efa67126e72a"],
Cell[28020, 661, 8898, 192, 545, "Output",ExpressionUUID->"b5a9f531-410d-4a4f-bd5a-cd0516e4d786"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36955, 858, 860, 27, 63, "Input",ExpressionUUID->"a84d184a-90eb-44ed-bb15-1c403ded0f5c"],
Cell[CellGroupData[{
Cell[37840, 889, 400, 6, 50, "Print",ExpressionUUID->"5f4cff02-eee6-4a5d-ac6a-c3ad56e6968e"],
Cell[38243, 897, 1291, 33, 231, "Print",ExpressionUUID->"2b31773a-0955-490c-a89f-c182043585c1"]
}, Open  ]],
Cell[39549, 933, 6819, 147, 308, "Output",ExpressionUUID->"8589dde3-9411-4085-adbf-7fe31d3a843a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46405, 1085, 872, 23, 287, "Input",ExpressionUUID->"bba3a251-bcb4-4e33-95cf-f7a37a5b5d21"],
Cell[47280, 1110, 448, 12, 153, "Output",ExpressionUUID->"2df46d74-c8dd-44d5-a255-e559f979974c"]
}, Open  ]]
}
]
*)

