(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    129292,       3288]
NotebookOptionsPosition[    120077,       3165]
NotebookOutlinePosition[    120512,       3182]
CellTagsIndexPosition[    120469,       3179]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.815307560872032*^9, 
  3.8153075642667866`*^9}},ExpressionUUID->"598afc19-aa3f-4a0c-85db-\
d3be449b5c22"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "a"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "d"}], "}"}]}], "}"}], ",", 
    RowBox[{"pesos", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "3", ",", "2", ",", "4", ",", "2", ",", "3", ",", "2", ",", "6", ",", 
       "6", ",", "5", ",", "4", ",", "5", ",", "5", ",", "4", ",", "2", ",", 
       "5", ",", "5", ",", "2"}], "}"}]}], ",", 
    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.815741256844083*^9},
 CellLabel->"In[87]:=",ExpressionUUID->"7ca8fd40-dec0-4e10-b5c5-947d8b3743e8"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`c, $CellContext`e, $CellContext`d, $CellContext`a, \
$CellContext`h, $CellContext`f, $CellContext`b, $CellContext`g}, {
      Null, {{1, 2}, {3, 2}, {3, 4}, {1, 3}, {2, 5}, {1, 5}, {1, 6}, {4, 7}, {
       4, 1}, {7, 1}, {7, 3}, {7, 5}, {3, 6}, {2, 6}, {6, 8}, {4, 8}, {8, 
       3}}}, {EdgeLabels -> {
        UndirectedEdge[$CellContext`g, $CellContext`d] -> 2, 
         UndirectedEdge[$CellContext`c, $CellContext`f] -> 6, 
         UndirectedEdge[$CellContext`e, $CellContext`h] -> 3, 
         UndirectedEdge[$CellContext`c, $CellContext`d] -> 2, 
         UndirectedEdge[$CellContext`b, $CellContext`d] -> 5, 
         UndirectedEdge[$CellContext`a, $CellContext`c] -> 5, 
         UndirectedEdge[$CellContext`f, $CellContext`g] -> 5, 
         UndirectedEdge[$CellContext`c, $CellContext`h] -> 2, 
         UndirectedEdge[$CellContext`d, $CellContext`a] -> 4, 
         UndirectedEdge[$CellContext`b, $CellContext`c] -> 4, 
         UndirectedEdge[$CellContext`c, $CellContext`e] -> 3, 
         UndirectedEdge[$CellContext`d, $CellContext`e] -> 2, 
         UndirectedEdge[$CellContext`e, $CellContext`f] -> 2, 
         UndirectedEdge[$CellContext`b, $CellContext`h] -> 5, 
         UndirectedEdge[$CellContext`d, $CellContext`f] -> 4, 
         UndirectedEdge[$CellContext`a, $CellContext`g] -> 5, 
         UndirectedEdge[$CellContext`a, $CellContext`b] -> 6}, 
       EdgeWeight -> {3, 2, 4, 2, 3, 2, 6, 6, 5, 4, 5, 5, 4, 2, 5, 5, 2}, 
       ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[
        0.7], {LineBox[{{0.9663293433584728, 0.7735613736782181}, {
          0.7866355527474103, 0.0008487629629994053}}], 
         InsetBox["3", {0.8764824480529415, 0.38720506832060875}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.9663293433584728, 0.7735613736782181}, {
          1.6272008191725649`, 0.7748741487869887}}], 
         InsetBox["2", {1.296765081265519, 0.7742177612326033}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.9663293433584728, 0.7735613736782181}, {
          1.8064198130634046`, 1.54824544050584}}], 
         InsetBox["5", {1.3863745782109387, 1.160903407092029}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.9663293433584728, 0.7735613736782181}, {0., 
          0.7744097560414617}}], 
         InsetBox["2", {0.4831646716792364, 0.7739855648598399}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.9663293433584728, 0.7735613736782181}, {
          1.8070386800567122`, 0.}}], 
         InsetBox["6", {1.3866840117075925, 0.38678068683910904}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.9663293433584728, 0.7735613736782181}, {
          0.7871831547784476, 1.5480072223490589`}}], 
         InsetBox["4", {0.8767562490684602, 1.1607842980136385}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.7866355527474103, 0.0008487629629994053}, {
          1.6272008191725649`, 0.7748741487869887}}], 
         InsetBox["2", {1.2069181859599876, 0.38786145587499404}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.7866355527474103, 0.0008487629629994053}, {0., 
          0.7744097560414617}}], 
         InsetBox["3", {0.39331777637370513, 0.38762925950223054}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.7866355527474103, 0.0008487629629994053}, {
          1.8070386800567122`, 0.}}], 
         InsetBox["2", {1.2968371164020613, 0.0004243814814997027}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.6272008191725649`, 0.7748741487869887}, {
          1.8064198130634046`, 1.54824544050584}}], 
         InsetBox["4", {1.7168103161179848, 1.1615597946464142}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.6272008191725649`, 0.7748741487869887}, {
          1.8070386800567122`, 0.}}], 
         InsetBox["4", {1.7171197496146386, 0.38743707439349434}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.6272008191725649`, 0.7748741487869887}, {
          0.7871831547784476, 1.5480072223490589`}}], 
         InsetBox["5", {1.2071919869755061, 1.1614406855680237}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.6272008191725649`, 0.7748741487869887}, {
          2.593395019790867, 0.7743580988240422}}], 
         InsetBox["2", {2.1102979194817157, 0.7746161238055154}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.8064198130634046`, 1.54824544050584}, {
          0.7871831547784476, 1.5480072223490589`}}], 
         InsetBox["6", {1.296801483920926, 1.5481263314274494}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.8064198130634046`, 1.54824544050584}, {2.593395019790867,
           0.7743580988240422}}], 
         InsetBox["5", {2.199907416427136, 1.161301769664941}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0., 0.7744097560414617}, {0.7871831547784476, 
          1.5480072223490589`}}], 
         InsetBox["5", {0.3935915773892238, 1.1612084891952603}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.8070386800567122`, 0.}, {2.593395019790867, 
          0.7743580988240422}}], 
         InsetBox["5", {2.2002168499237893, 0.3871790494120211}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.9663293433584728, 0.7735613736782181}, 
          0.027250873892722252], 
         InsetBox["c", 
          Offset[{2, 2}, {0.993580217251195, 0.8008122475709404}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7866355527474103, 0.0008487629629994053}, 
          0.027250873892722252], 
         InsetBox["e", 
          Offset[{2, 2}, {0.8138864266401326, 0.028099636855721657}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6272008191725649, 0.7748741487869887}, 
          0.027250873892722252], 
         InsetBox["d", Offset[{2, 2}, {1.654451693065287, 0.802125022679711}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8064198130634046, 1.54824544050584}, 
          0.027250873892722252], 
         InsetBox["a", 
          Offset[{2, 2}, {1.8336706869561268, 1.575496314398562}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.7744097560414617}, 0.027250873892722252], 
         InsetBox["h", 
          Offset[{2, 2}, {0.027250873892722252, 0.801660629934184}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8070386800567122, 0.}, 0.027250873892722252], 
         InsetBox["f", 
          Offset[{2, 2}, {1.8342895539494344, 0.027250873892722252}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7871831547784476, 1.5480072223490589}, 
          0.027250873892722252], 
         InsetBox["b", 
          Offset[{2, 2}, {0.8144340286711699, 1.575258096241781}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.593395019790867, 0.7743580988240422}, 
          0.027250873892722252], 
         InsetBox["g", 
          Offset[{2, 2}, {2.620645893683589, 0.8016089727167645}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8157412577069306`*^9, 3.815741667635705*^9, 
  3.815741872572667*^9, 3.8157646373873386`*^9, 3.815769691560918*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"1b883d32-b4d1-4fd3-86ca-3aa66cc13ce6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "a"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "d"}], "}"}]}], "}"}], ",", 
    RowBox[{"pesos", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], 
      RowBox[{"{", 
       RowBox[{
       "3", ",", "2", ",", "4", ",", "2", ",", "3", ",", "2", ",", "6", ",", 
        "6", ",", "5", ",", "4", ",", "5", ",", "5", ",", "4", ",", "2", ",", 
        "5", ",", "5", ",", "2"}], "}"}]}]}], ",", 
    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8153096229712152`*^9, 3.815309661261182*^9}, {
   3.815309700576728*^9, 3.815309751402519*^9}, 3.8153099312951546`*^9, {
   3.8153301908389463`*^9, 3.815330213815753*^9}, {3.815330492623451*^9, 
   3.8153304927890434`*^9}, {3.815741237720434*^9, 3.8157412380800056`*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"d7127bca-2b28-451a-918e-7a999f6419b9"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`c, $CellContext`e, $CellContext`d, $CellContext`a, \
$CellContext`h, $CellContext`f, $CellContext`b, $CellContext`g}, {
      Null, {{1, 2}, {3, 2}, {3, 4}, {1, 3}, {2, 5}, {1, 5}, {1, 6}, {4, 7}, {
       4, 1}, {7, 1}, {7, 3}, {7, 5}, {3, 6}, {2, 6}, {6, 8}, {4, 8}, {8, 
       3}}}, {EdgeLabels -> {
        UndirectedEdge[$CellContext`g, $CellContext`d] -> -2, 
         UndirectedEdge[$CellContext`c, $CellContext`f] -> -6, 
         UndirectedEdge[$CellContext`e, $CellContext`h] -> -3, 
         UndirectedEdge[$CellContext`c, $CellContext`d] -> -2, 
         UndirectedEdge[$CellContext`b, $CellContext`d] -> -5, 
         UndirectedEdge[$CellContext`a, $CellContext`c] -> -5, 
         UndirectedEdge[$CellContext`f, $CellContext`g] -> -5, 
         UndirectedEdge[$CellContext`c, $CellContext`h] -> -2, 
         UndirectedEdge[$CellContext`d, $CellContext`a] -> -4, 
         UndirectedEdge[$CellContext`b, $CellContext`c] -> -4, 
         UndirectedEdge[$CellContext`c, $CellContext`e] -> -3, 
         UndirectedEdge[$CellContext`d, $CellContext`e] -> -2, 
         UndirectedEdge[$CellContext`e, $CellContext`f] -> -2, 
         UndirectedEdge[$CellContext`b, $CellContext`h] -> -5, 
         UndirectedEdge[$CellContext`d, $CellContext`f] -> -4, 
         UndirectedEdge[$CellContext`a, $CellContext`g] -> -5, 
         UndirectedEdge[$CellContext`a, $CellContext`b] -> -6}, 
       EdgeWeight -> {-3, -2, -4, -2, -3, -2, -6, -6, -5, -4, -5, -5, -4, -2, \
-5, -5, -2}, ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[
        0.7], {LineBox[{{0.9663293433584728, 0.7735613736782181}, {
          0.7866355527474103, 0.0008487629629994053}}], InsetBox[
          RowBox[{"-", "3"}], {0.8764824480529415, 0.38720506832060875}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.9663293433584728, 0.7735613736782181}, {
          1.6272008191725649`, 0.7748741487869887}}], InsetBox[
          RowBox[{"-", "2"}], {1.296765081265519, 0.7742177612326033}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.9663293433584728, 0.7735613736782181}, {
          1.8064198130634046`, 1.54824544050584}}], InsetBox[
          RowBox[{"-", "5"}], {1.3863745782109387, 1.160903407092029}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.9663293433584728, 0.7735613736782181}, {0., 
          0.7744097560414617}}], InsetBox[
          RowBox[{"-", "2"}], {0.4831646716792364, 0.7739855648598399}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.9663293433584728, 0.7735613736782181}, {
          1.8070386800567122`, 0.}}], InsetBox[
          RowBox[{"-", "6"}], {1.3866840117075925, 0.38678068683910904}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.9663293433584728, 0.7735613736782181}, {
          0.7871831547784476, 1.5480072223490589`}}], InsetBox[
          RowBox[{"-", "4"}], {0.8767562490684602, 1.1607842980136385}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.7866355527474103, 0.0008487629629994053}, {
          1.6272008191725649`, 0.7748741487869887}}], InsetBox[
          RowBox[{"-", "2"}], {1.2069181859599876, 0.38786145587499404}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.7866355527474103, 0.0008487629629994053}, {0., 
          0.7744097560414617}}], InsetBox[
          RowBox[{"-", "3"}], {0.39331777637370513, 0.38762925950223054}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0.7866355527474103, 0.0008487629629994053}, {
          1.8070386800567122`, 0.}}], InsetBox[
          RowBox[{"-", "2"}], {1.2968371164020613, 0.0004243814814997027}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.6272008191725649`, 0.7748741487869887}, {
          1.8064198130634046`, 1.54824544050584}}], InsetBox[
          RowBox[{"-", "4"}], {1.7168103161179848, 1.1615597946464142}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.6272008191725649`, 0.7748741487869887}, {
          1.8070386800567122`, 0.}}], InsetBox[
          RowBox[{"-", "4"}], {1.7171197496146386, 0.38743707439349434}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.6272008191725649`, 0.7748741487869887}, {
          0.7871831547784476, 1.5480072223490589`}}], InsetBox[
          RowBox[{"-", "5"}], {1.2071919869755061, 1.1614406855680237}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.6272008191725649`, 0.7748741487869887}, {
          2.593395019790867, 0.7743580988240422}}], InsetBox[
          RowBox[{"-", "2"}], {2.1102979194817157, 0.7746161238055154}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.8064198130634046`, 1.54824544050584}, {
          0.7871831547784476, 1.5480072223490589`}}], InsetBox[
          RowBox[{"-", "6"}], {1.296801483920926, 1.5481263314274494}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.8064198130634046`, 1.54824544050584}, {2.593395019790867,
           0.7743580988240422}}], InsetBox[
          RowBox[{"-", "5"}], {2.199907416427136, 1.161301769664941}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{0., 0.7744097560414617}, {0.7871831547784476, 
          1.5480072223490589`}}], InsetBox[
          RowBox[{"-", "5"}], {0.3935915773892238, 1.1612084891952603}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         LineBox[{{1.8070386800567122`, 0.}, {2.593395019790867, 
          0.7743580988240422}}], InsetBox[
          RowBox[{"-", "5"}], {2.2002168499237893, 0.3871790494120211}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.9663293433584728, 0.7735613736782181}, 
          0.027250873892722252], 
         InsetBox["c", 
          Offset[{2, 2}, {0.993580217251195, 0.8008122475709404}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7866355527474103, 0.0008487629629994053}, 
          0.027250873892722252], 
         InsetBox["e", 
          Offset[{2, 2}, {0.8138864266401326, 0.028099636855721657}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6272008191725649, 0.7748741487869887}, 
          0.027250873892722252], 
         InsetBox["d", Offset[{2, 2}, {1.654451693065287, 0.802125022679711}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8064198130634046, 1.54824544050584}, 
          0.027250873892722252], 
         InsetBox["a", 
          Offset[{2, 2}, {1.8336706869561268, 1.575496314398562}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.7744097560414617}, 0.027250873892722252], 
         InsetBox["h", 
          Offset[{2, 2}, {0.027250873892722252, 0.801660629934184}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8070386800567122, 0.}, 0.027250873892722252], 
         InsetBox["f", 
          Offset[{2, 2}, {1.8342895539494344, 0.027250873892722252}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7871831547784476, 1.5480072223490589}, 
          0.027250873892722252], 
         InsetBox["b", 
          Offset[{2, 2}, {0.8144340286711699, 1.575258096241781}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.593395019790867, 0.7743580988240422}, 
          0.027250873892722252], 
         InsetBox["g", 
          Offset[{2, 2}, {2.620645893683589, 0.8016089727167645}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.815309932827396*^9, 3.8153302145218*^9, 3.815330493605297*^9, 
   3.815413424315968*^9, 3.8157411946019907`*^9, {3.8157412409388447`*^9, 
   3.8157412608547215`*^9}, 3.8157416706277657`*^9, 3.815741875010542*^9, 
   3.8157646398645697`*^9, 3.815769695165807*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"c20a729b-3fdc-40a9-b87a-29cc64200c50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prim", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"orden", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "b", ",", "a", ",", "g", ",", "e", ",", "c", ",", "f", ",", "h", ",", 
      "d"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8155528628174934`*^9, 3.815552862975233*^9}, {
  3.8157412114349055`*^9, 3.81574123222716*^9}, {3.8157413874326987`*^9, 
  3.815741388131737*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"a2aaa785-e74a-4446-93fe-ca2a7da9f4f8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El orden de los nodos es: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>", ",", "\<\"g\"\>", ",", "\<\"e\"\>",
      ",", "\<\"c\"\>", ",", "\<\"f\"\>", ",", "\<\"h\"\>", 
     ",", "\<\"d\"\>"}], "}"}]}],
  SequenceForm[
  "El orden de los nodos es: ", {"b", "a", "g", "e", "c", "f", "h", "d"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552863731206*^9, 3.8157412636436434`*^9, 
  3.8157413888698673`*^9, 3.815741694944078*^9, 3.8157418776108007`*^9, 
  3.8157646424111547`*^9, 3.8157696975813446`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"2f854cef-5978-42a0-9a63-5907ae7d6500"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"g\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"c\"\>", ",", "\<\"f\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"c\"\>", ",", "\<\"e\"\>"}], "}"}]}], "}"}]}],
  SequenceForm[
  "T=", {{"b", "a"}, {"b", "h"}, {"b", "d"}, {"a", "g"}, {"a", "c"}, {
    "c", "f"}, {"c", "e"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552863731206*^9, 3.8157412636436434`*^9, 
  3.8157413888698673`*^9, 3.815741694944078*^9, 3.8157418776108007`*^9, 
  3.8157646424111547`*^9, 3.8157696975843353`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"cbfc82c2-84bc-4473-8346-9fa2aa378d02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "35"}]}],
  SequenceForm["Peso: ", -35],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552863731206*^9, 3.8157412636436434`*^9, 
  3.8157413888698673`*^9, 3.815741694944078*^9, 3.8157418776108007`*^9, 
  3.8157646424111547`*^9, 3.8157696975883255`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"0a344ed1-f99a-42bc-91fc-bc88446fa442"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 7, 1}}, 
    Typeset`size$$ = {651., {204., 216.4042957310637}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 7, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{747., {285.75, 298.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.815552863731206*^9, 3.8157412636436434`*^9, 
  3.8157413888698673`*^9, 3.815741694944078*^9, 3.8157418776108007`*^9, 
  3.8157646424111547`*^9, 3.8157696976026497`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[89]:=",ExpressionUUID->"8a328da6-0a7f-44dc-a2ad-3e0201d52cb5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kruskal", "[", "grafo", "]"}]], "Input",
 CellLabel->"In[90]:=",ExpressionUUID->"62ceb789-9c93-49aa-ad08-cc415b7833f8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"c", "\[UndirectedEdge]", "e"}]}], "}"}]}],
  SequenceForm["T=", {
    UndirectedEdge[$CellContext`a, $CellContext`b], 
    UndirectedEdge[$CellContext`c, $CellContext`f], 
    UndirectedEdge[$CellContext`b, $CellContext`h], 
    UndirectedEdge[$CellContext`b, $CellContext`d], 
    UndirectedEdge[$CellContext`f, $CellContext`g], 
    UndirectedEdge[$CellContext`a, $CellContext`c], 
    UndirectedEdge[$CellContext`c, $CellContext`e]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157413924691377`*^9, 3.815741712603483*^9, 
  3.8157418802321987`*^9, 3.8157646466080065`*^9, 3.8157697004413104`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[90]:=",ExpressionUUID->"da0bcabf-37ce-4ec3-820e-59534cea49a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "35"}]}],
  SequenceForm["Peso: ", -35],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157413924691377`*^9, 3.815741712603483*^9, 
  3.8157418802321987`*^9, 3.8157646466080065`*^9, 3.8157697004433393`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[90]:=",ExpressionUUID->"a527764f-0695-4c3b-a6f9-058e6a34a4c0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 7, 1}}, 
    Typeset`size$$ = {651., {204., 216.4042957310637}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 7, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{747., {285.75, 298.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.8157413924691377`*^9, 3.815741712603483*^9, 
  3.8157418802321987`*^9, 3.8157646466080065`*^9, 3.8157697004552717`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[90]:=",ExpressionUUID->"21552e73-e4c3-437e-9041-182d60968dc0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prim", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"orden", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "b", ",", "a", ",", "g", ",", "e", ",", "c", ",", "f", ",", "h", ",", 
      "d"}], "}"}]}], ",", 
   RowBox[{"all", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.815552611855628*^9, 3.815552618690604*^9}, {
   3.8155526499969845`*^9, 3.8155526724886084`*^9}, 3.8155528137940397`*^9, {
   3.815741318469623*^9, 3.8157413321300435`*^9}, {3.8157413959673634`*^9, 
   3.815741396614503*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"899cb278-0ced-4c35-8824-b106c81545fa"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Tabla de pesos del grafo:\"\>"], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035335436`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"514b4344-b2c6-453e-a97e-404e12eb8d02"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", 
      RowBox[{"-", "6"}], "0", "0", 
      RowBox[{"-", "4"}], "0", 
      RowBox[{"-", "5"}], 
      RowBox[{"-", "5"}]},
     {
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      RowBox[{"-", "6"}], "0", 
      RowBox[{"-", "5"}], "0", 
      RowBox[{"-", "5"}], "0", "0", 
      RowBox[{"-", "4"}]},
     {
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", 
      RowBox[{"-", "5"}], "0", "0", "0", 
      RowBox[{"-", "5"}], "0", 
      RowBox[{"-", "2"}]},
     {
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "0", "0", "0", 
      RowBox[{"-", "3"}], 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "3"}], 
      RowBox[{"-", "2"}]},
     {
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      RowBox[{"-", "4"}], 
      RowBox[{"-", "5"}], "0", 
      RowBox[{"-", "3"}], "0", 
      RowBox[{"-", "6"}], 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "2"}]},
     {
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "0", 
      RowBox[{"-", "5"}], 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "6"}], "0", "0", 
      RowBox[{"-", "4"}]},
     {
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      RowBox[{"-", "5"}], "0", "0", 
      RowBox[{"-", "3"}], 
      RowBox[{"-", "2"}], "0", "0", "0"},
     {
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      RowBox[{"-", "5"}], 
      RowBox[{"-", "4"}], 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "4"}], "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]]}, {
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]]}}, TableAlignments -> Center]]]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035365376`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"1378135b-8553-4bf1-adc9-c586e6f4c31c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El orden de los nodos es: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>", ",", "\<\"g\"\>", ",", "\<\"e\"\>",
      ",", "\<\"c\"\>", ",", "\<\"f\"\>", ",", "\<\"h\"\>", 
     ",", "\<\"d\"\>"}], "}"}]}],
  SequenceForm[
  "El orden de los nodos es: ", {"b", "a", "g", "e", "c", "f", "h", "d"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703538532*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"ebc46d9e-3bac-40d2-b5be-465742fe108a"],

Cell[BoxData["\<\"*** Inicializaci\[OAcute]n ***\"\>"], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035405254`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"b5ae4f83-caa0-42ef-b9ba-c02ec479f9ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Aristas seleccionables (AS) del \[AAcute]rbol T a construir: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Aristas seleccionables (AS) del \[AAcute]rbol T a construir: ", {{{
     "b", "a"}, -6}, {{"b", "c"}, -4}, {{"b", "h"}, -5}, {{"b", "d"}, -5}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035415325`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"31c5c690-0cf2-43c5-bd5c-ffac15128224"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 1, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035425215`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"886a841c-efd7-4b41-9bec-6be24462cdb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], "}"}]}],
  SequenceForm[
  "Se agreg\[OAcute] la arista: ", {"b", "a"}, ", T=", {{"b", "a"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035445147`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"ee63f2fb-4d97-4807-b418-bb3d85188519"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "6"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -6],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703545512*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"71dcf536-67f7-4ec5-95ce-2be42dceff58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"g\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
       RowBox[{"-", "4"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "AS=", {{{"b", "c"}, -4}, {{"b", "h"}, -5}, {{"b", "d"}, -5}, {{
     "a", "g"}, -5}, {{"a", "c"}, -5}, {{"a", "d"}, -4}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035475073`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"be7d7b55-0544-4d7c-b9c4-ab7fd5f15d20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 2, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703549502*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"ec3c2295-77fc-4cb8-adc7-fa69f3047494"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Se agreg\[OAcute] la arista: ", {"b", "h"}, 
   ", T=", {{"b", "a"}, {"b", "h"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703550499*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"af63ccb8-a71c-4099-8a6b-cfc3b8eaee16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "11"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -11],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035514975`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"1aca90c0-82ba-438b-9b5b-0566180bca4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"g\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"h\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"h\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "AS=", {{{"b", "c"}, -4}, {{"b", "d"}, -5}, {{"a", "g"}, -5}, {{
     "a", "c"}, -5}, {{"a", "d"}, -4}, {{"h", "e"}, -3}, {{"h", "c"}, -2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035534906`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"116aad7e-32c6-4d9f-8b41-a4c7955a571b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 3, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703556483*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"0295605f-ad82-4ace-a709-4741a769d50f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Se agreg\[OAcute] la arista: ", {"b", "d"}, 
   ", T=", {{"b", "a"}, {"b", "h"}, {"b", "d"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.81576970355748*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"c494925c-ca9d-4e82-8f6e-b9b5cb6fbc47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "16"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -16],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035584817`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"98d6a603-ffc0-4aa3-95af-16a731ef5638"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"g\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"h\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"h\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"d\"\>", ",", "\<\"g\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"d\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"d\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"d\"\>", ",", "\<\"f\"\>"}], "}"}], ",", 
       RowBox[{"-", "4"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "AS=", {{{"b", "c"}, -4}, {{"a", "g"}, -5}, {{"a", "c"}, -5}, {{
     "h", "e"}, -3}, {{"h", "c"}, -2}, {{"d", "g"}, -2}, {{"d", "e"}, -2}, {{
     "d", "c"}, -2}, {{"d", "f"}, -4}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703559475*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"07b107f5-93ca-482f-8829-2d8df8e217ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 4, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703561469*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"97fe4fe6-7d0f-426f-8e57-3250a7f502bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"g\"\>"}], "}"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"g\"\>"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Se agreg\[OAcute] la arista: ", {"a", "g"}, 
   ", T=", {{"b", "a"}, {"b", "h"}, {"b", "d"}, {"a", "g"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035624676`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"506b718d-7a58-42fc-a709-cfe9ad24f0b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "21"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -21],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703563464*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"9066f16e-b64a-485c-b031-2f21f6fd806f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"h\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"h\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"d\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"d\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"d\"\>", ",", "\<\"f\"\>"}], "}"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"g\"\>", ",", "\<\"f\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "AS=", {{{"b", "c"}, -4}, {{"a", "c"}, -5}, {{"h", "e"}, -3}, {{
     "h", "c"}, -2}, {{"d", "e"}, -2}, {{"d", "c"}, -2}, {{"d", "f"}, -4}, {{
     "g", "f"}, -5}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703565467*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"25471f02-059f-4964-90c7-1a795c3cdc50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 5, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035664573`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"14615f27-87dd-4f9f-a52a-e6aae831b74d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"g\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Se agreg\[OAcute] la arista: ", {"a", "c"}, 
   ", T=", {{"b", "a"}, {"b", "h"}, {"b", "d"}, {"a", "g"}, {"a", "c"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035684743`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"7d3e9583-20eb-495b-ae93-01a056674451"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "26"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -26],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035694494`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"a7c65544-ff3f-4361-9f37-a63bdb1bb533"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"h\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"d\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"d\"\>", ",", "\<\"f\"\>"}], "}"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"g\"\>", ",", "\<\"f\"\>"}], "}"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"c\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"c\"\>", ",", "\<\"f\"\>"}], "}"}], ",", 
       RowBox[{"-", "6"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "AS=", {{{"h", "e"}, -3}, {{"d", "e"}, -2}, {{"d", "f"}, -4}, {{
     "g", "f"}, -5}, {{"c", "e"}, -3}, {{"c", "f"}, -6}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703572441*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"b0ce771d-d63d-4e9e-bed8-c6634b043bee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 6, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.81576970357347*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"58b3d596-170b-4436-a9be-18a6b9e00124"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"c\"\>", ",", "\<\"f\"\>"}], "}"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"g\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"c\"\>", ",", "\<\"f\"\>"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Se agreg\[OAcute] la arista: ", {"c", "f"}, 
   ", T=", {{"b", "a"}, {"b", "h"}, {"b", "d"}, {"a", "g"}, {"a", "c"}, {
    "c", "f"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035744343`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"b72a47ea-092e-457e-b706-84b95a366418"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "32"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -32],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035764294`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"87ab2e7c-4895-419b-befc-3276e0ec82a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"h\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"d\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"c\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"f\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "AS=", {{{"h", "e"}, -3}, {{"d", "e"}, -2}, {{"c", "e"}, -3}, {{
     "f", "e"}, -2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035784345`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"fa8794b6-3931-431d-a684-ec621c48bba4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 7, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703579421*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"342afdfe-b56a-47e8-863d-89fb5544488e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"c\"\>", ",", "\<\"e\"\>"}], "}"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"g\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"c\"\>", ",", "\<\"f\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"c\"\>", ",", "\<\"e\"\>"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Se agreg\[OAcute] la arista: ", {"c", "e"}, 
   ", T=", {{"b", "a"}, {"b", "h"}, {"b", "d"}, {"a", "g"}, {"a", "c"}, {
    "c", "f"}, {"c", "e"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035804424`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"e95af92c-cf7d-411b-b429-0fcc52c37baa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "35"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -35],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035824146`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"8adcfaf7-f73c-4913-8629-6acf27c1cb01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["AS=", {}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035834107`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"e61427da-4bd6-40cf-b5a1-085b4df1f5da"],

Cell[BoxData["\<\"*** Finalmente ***\"\>"], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035844107`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"e0e1394f-5d56-4b25-aac6-4e1242ff38a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"h\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"g\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"c\"\>", ",", "\<\"f\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"c\"\>", ",", "\<\"e\"\>"}], "}"}]}], "}"}]}],
  SequenceForm[
  "T=", {{"b", "a"}, {"b", "h"}, {"b", "d"}, {"a", "g"}, {"a", "c"}, {
    "c", "f"}, {"c", "e"}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.8157697035854053`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"89a5a7d8-5901-4da5-8b4a-63fe5734ef24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "35"}]}],
  SequenceForm["Peso: ", -35],
  Editable->False]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703586404*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"604a6ed4-0816-4d6f-ac2e-11a391fe0abb"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 7, 1}}, 
    Typeset`size$$ = {651., {204., 216.4042957310637}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 7, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{747., {285.75, 298.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.815552868060201*^9, 3.8157413328770323`*^9, 
  3.8157413975372677`*^9, 3.8157418830749245`*^9, 3.8157646497038503`*^9, 
  3.815769703599373*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"d4a22505-6b32-4089-8a52-84948c6e4287"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kruskal", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"all", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[92]:=",ExpressionUUID->"c0ebbcc3-abe7-44b0-a15f-a16c0a26f64a"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Tabla de pesos del grafo:\"\>"], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093120537`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"51b198bd-af01-4a7c-b056-22dae179bc39"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", 
      RowBox[{"-", "6"}], 
      RowBox[{"-", "5"}], 
      RowBox[{"-", "4"}], "0", "0", 
      RowBox[{"-", "5"}], "0"},
     {
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      RowBox[{"-", "6"}], "0", 
      RowBox[{"-", "4"}], 
      RowBox[{"-", "5"}], "0", "0", "0", 
      RowBox[{"-", "5"}]},
     {
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      RowBox[{"-", "5"}], 
      RowBox[{"-", "4"}], "0", 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "3"}], 
      RowBox[{"-", "6"}], "0", 
      RowBox[{"-", "2"}]},
     {
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      RowBox[{"-", "4"}], 
      RowBox[{"-", "5"}], 
      RowBox[{"-", "2"}], "0", 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "4"}], 
      RowBox[{"-", "2"}], "0"},
     {
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "0", 
      RowBox[{"-", "3"}], 
      RowBox[{"-", "2"}], "0", 
      RowBox[{"-", "2"}], "0", 
      RowBox[{"-", "3"}]},
     {
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "0", 
      RowBox[{"-", "6"}], 
      RowBox[{"-", "4"}], 
      RowBox[{"-", "2"}], "0", 
      RowBox[{"-", "5"}], "0"},
     {
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      RowBox[{"-", "5"}], "0", "0", 
      RowBox[{"-", "2"}], "0", 
      RowBox[{"-", "5"}], "0", "0"},
     {
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", 
      RowBox[{"-", "5"}], 
      RowBox[{"-", "2"}], "0", 
      RowBox[{"-", "3"}], "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, 
      "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]]}, {
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]]}}, TableAlignments -> Center]]]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093165307`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"6fc9fb1a-0a5f-423a-b450-88d62bb01b56"],

Cell[BoxData["\<\"*** Inicializaci\[OAcute]n ***\"\>"], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093185253`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"09e0a11c-a857-4f29-8f90-bdde0028c100"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Aristas seleccionables (AS) del \[AAcute]rbol T a construir: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Aristas seleccionables (AS) del \[AAcute]rbol T a construir: ", {{
     UndirectedEdge[$CellContext`c, $CellContext`e], -3}, {
     UndirectedEdge[$CellContext`d, $CellContext`e], -2}, {
     UndirectedEdge[$CellContext`d, $CellContext`a], -4}, {
     UndirectedEdge[$CellContext`c, $CellContext`d], -2}, {
     UndirectedEdge[$CellContext`e, $CellContext`h], -3}, {
     UndirectedEdge[$CellContext`c, $CellContext`h], -2}, {
     UndirectedEdge[$CellContext`c, $CellContext`f], -6}, {
     UndirectedEdge[$CellContext`a, $CellContext`b], -6}, {
     UndirectedEdge[$CellContext`a, $CellContext`c], -5}, {
     UndirectedEdge[$CellContext`b, $CellContext`c], -4}, {
     UndirectedEdge[$CellContext`b, $CellContext`d], -5}, {
     UndirectedEdge[$CellContext`b, $CellContext`h], -5}, {
     UndirectedEdge[$CellContext`d, $CellContext`f], -4}, {
     UndirectedEdge[$CellContext`e, $CellContext`f], -2}, {
     UndirectedEdge[$CellContext`f, $CellContext`g], -5}, {
     UndirectedEdge[$CellContext`a, $CellContext`g], -5}, {
     UndirectedEdge[$CellContext`g, $CellContext`d], -2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709322516*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"40b975ab-8cc7-40f9-9afd-888a442047f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 1, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709324018*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"af8fd525-0b18-46da-883b-20b883ce9ed2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"c", "\[UndirectedEdge]", "f"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"c", "\[UndirectedEdge]", "f"}], "}"}]}],
  SequenceForm["Se agreg\[OAcute] la arista: ", 
   UndirectedEdge[$CellContext`c, $CellContext`f], ", T=", {
    UndirectedEdge[$CellContext`c, $CellContext`f]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709325015*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"e3500215-b7a5-43d2-8b02-ee119738096c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "6"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -6],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709326516*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"9b7ea997-4c5c-4698-8c0b-211c90f6d5db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
       RowBox[{"-", "6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}],
  SequenceForm["AS=", {{
     UndirectedEdge[$CellContext`c, $CellContext`e], -3}, {
     UndirectedEdge[$CellContext`d, $CellContext`e], -2}, {
     UndirectedEdge[$CellContext`d, $CellContext`a], -4}, {
     UndirectedEdge[$CellContext`c, $CellContext`d], -2}, {
     UndirectedEdge[$CellContext`e, $CellContext`h], -3}, {
     UndirectedEdge[$CellContext`c, $CellContext`h], -2}, {
     UndirectedEdge[$CellContext`a, $CellContext`b], -6}, {
     UndirectedEdge[$CellContext`a, $CellContext`c], -5}, {
     UndirectedEdge[$CellContext`b, $CellContext`c], -4}, {
     UndirectedEdge[$CellContext`b, $CellContext`d], -5}, {
     UndirectedEdge[$CellContext`b, $CellContext`h], -5}, {
     UndirectedEdge[$CellContext`d, $CellContext`f], -4}, {
     UndirectedEdge[$CellContext`e, $CellContext`f], -2}, {
     UndirectedEdge[$CellContext`f, $CellContext`g], -5}, {
     UndirectedEdge[$CellContext`a, $CellContext`g], -5}, {
     UndirectedEdge[$CellContext`g, $CellContext`d], -2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709328497*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"ab4bae00-5a5c-4cb0-82ca-a1b4ce3fcd9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 2, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093294954`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"52070608-46d6-43ef-870a-a7797af3e88d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", "\[UndirectedEdge]", "b"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "b"}]}], "}"}]}],
  SequenceForm["Se agreg\[OAcute] la arista: ", 
   UndirectedEdge[$CellContext`a, $CellContext`b], ", T=", {
    UndirectedEdge[$CellContext`c, $CellContext`f], 
    UndirectedEdge[$CellContext`a, $CellContext`b]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093314896`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"a4d91c7b-8a85-4f9a-9ee0-d86e32d19d62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "12"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -12],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709332487*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"9be91527-0892-436c-ba85-43fc0e390d54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}],
  SequenceForm["AS=", {{
     UndirectedEdge[$CellContext`c, $CellContext`e], -3}, {
     UndirectedEdge[$CellContext`d, $CellContext`e], -2}, {
     UndirectedEdge[$CellContext`d, $CellContext`a], -4}, {
     UndirectedEdge[$CellContext`c, $CellContext`d], -2}, {
     UndirectedEdge[$CellContext`e, $CellContext`h], -3}, {
     UndirectedEdge[$CellContext`c, $CellContext`h], -2}, {
     UndirectedEdge[$CellContext`a, $CellContext`c], -5}, {
     UndirectedEdge[$CellContext`b, $CellContext`c], -4}, {
     UndirectedEdge[$CellContext`b, $CellContext`d], -5}, {
     UndirectedEdge[$CellContext`b, $CellContext`h], -5}, {
     UndirectedEdge[$CellContext`d, $CellContext`f], -4}, {
     UndirectedEdge[$CellContext`e, $CellContext`f], -2}, {
     UndirectedEdge[$CellContext`f, $CellContext`g], -5}, {
     UndirectedEdge[$CellContext`a, $CellContext`g], -5}, {
     UndirectedEdge[$CellContext`g, $CellContext`d], -2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093344817`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"e00fd014-4f71-4570-a54d-3f668f60322f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 3, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709335478*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"09f3c164-ede4-4ec2-94dd-eb61f900c1a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"f", "\[UndirectedEdge]", "g"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "g"}]}], "}"}]}],
  SequenceForm["Se agreg\[OAcute] la arista: ", 
   UndirectedEdge[$CellContext`f, $CellContext`g], ", T=", {
    UndirectedEdge[$CellContext`c, $CellContext`f], 
    UndirectedEdge[$CellContext`a, $CellContext`b], 
    UndirectedEdge[$CellContext`f, $CellContext`g]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093364763`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"07107fac-01ad-4c05-a381-1c26d121a48e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "17"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -17],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709339468*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"9a52fce6-e9ba-4ee3-a87d-9fed19c5f931"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}],
  SequenceForm["AS=", {{
     UndirectedEdge[$CellContext`c, $CellContext`e], -3}, {
     UndirectedEdge[$CellContext`d, $CellContext`e], -2}, {
     UndirectedEdge[$CellContext`d, $CellContext`a], -4}, {
     UndirectedEdge[$CellContext`c, $CellContext`d], -2}, {
     UndirectedEdge[$CellContext`e, $CellContext`h], -3}, {
     UndirectedEdge[$CellContext`c, $CellContext`h], -2}, {
     UndirectedEdge[$CellContext`a, $CellContext`c], -5}, {
     UndirectedEdge[$CellContext`b, $CellContext`c], -4}, {
     UndirectedEdge[$CellContext`b, $CellContext`d], -5}, {
     UndirectedEdge[$CellContext`b, $CellContext`h], -5}, {
     UndirectedEdge[$CellContext`d, $CellContext`f], -4}, {
     UndirectedEdge[$CellContext`e, $CellContext`f], -2}, {
     UndirectedEdge[$CellContext`a, $CellContext`g], -5}, {
     UndirectedEdge[$CellContext`g, $CellContext`d], -2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709341463*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"babf7f06-b9e0-4a0d-8f8e-b6b0dcee80fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 4, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093424606`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"ebd16373-d68b-4cb9-99b8-0eebf6689dc3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"b", "\[UndirectedEdge]", "d"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "d"}]}], "}"}]}],
  SequenceForm["Se agreg\[OAcute] la arista: ", 
   UndirectedEdge[$CellContext`b, $CellContext`d], ", T=", {
    UndirectedEdge[$CellContext`c, $CellContext`f], 
    UndirectedEdge[$CellContext`a, $CellContext`b], 
    UndirectedEdge[$CellContext`f, $CellContext`g], 
    UndirectedEdge[$CellContext`b, $CellContext`d]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709344455*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"d6fa552d-b06d-4492-b1ff-6f57559439f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "22"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -22],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709346448*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"8babe464-855d-4a32-917b-d35c46ecc8d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}],
  SequenceForm["AS=", {{
     UndirectedEdge[$CellContext`c, $CellContext`e], -3}, {
     UndirectedEdge[$CellContext`d, $CellContext`e], -2}, {
     UndirectedEdge[$CellContext`d, $CellContext`a], -4}, {
     UndirectedEdge[$CellContext`c, $CellContext`d], -2}, {
     UndirectedEdge[$CellContext`e, $CellContext`h], -3}, {
     UndirectedEdge[$CellContext`c, $CellContext`h], -2}, {
     UndirectedEdge[$CellContext`a, $CellContext`c], -5}, {
     UndirectedEdge[$CellContext`b, $CellContext`c], -4}, {
     UndirectedEdge[$CellContext`b, $CellContext`h], -5}, {
     UndirectedEdge[$CellContext`d, $CellContext`f], -4}, {
     UndirectedEdge[$CellContext`e, $CellContext`f], -2}, {
     UndirectedEdge[$CellContext`a, $CellContext`g], -5}, {
     UndirectedEdge[$CellContext`g, $CellContext`d], -2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093484755`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"d51495f1-1ebf-4664-a23f-ec3b42c52f1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 5, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709349472*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"a7f26b8f-af66-4e0c-8110-e265fb0773fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"a", "\[UndirectedEdge]", "c"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "c"}]}], "}"}]}],
  SequenceForm["Se agreg\[OAcute] la arista: ", 
   UndirectedEdge[$CellContext`a, $CellContext`c], ", T=", {
    UndirectedEdge[$CellContext`c, $CellContext`f], 
    UndirectedEdge[$CellContext`a, $CellContext`b], 
    UndirectedEdge[$CellContext`f, $CellContext`g], 
    UndirectedEdge[$CellContext`b, $CellContext`d], 
    UndirectedEdge[$CellContext`a, $CellContext`c]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709351435*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"3ae1fe2d-3449-4217-b400-528099bb2f8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "27"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -27],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093524494`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"90b82b94-1a8e-4257-9311-cd21056b2a8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}],
  SequenceForm["AS=", {{
     UndirectedEdge[$CellContext`c, $CellContext`e], -3}, {
     UndirectedEdge[$CellContext`d, $CellContext`e], -2}, {
     UndirectedEdge[$CellContext`d, $CellContext`a], -4}, {
     UndirectedEdge[$CellContext`c, $CellContext`d], -2}, {
     UndirectedEdge[$CellContext`e, $CellContext`h], -3}, {
     UndirectedEdge[$CellContext`c, $CellContext`h], -2}, {
     UndirectedEdge[$CellContext`b, $CellContext`c], -4}, {
     UndirectedEdge[$CellContext`b, $CellContext`h], -5}, {
     UndirectedEdge[$CellContext`d, $CellContext`f], -4}, {
     UndirectedEdge[$CellContext`e, $CellContext`f], -2}, {
     UndirectedEdge[$CellContext`a, $CellContext`g], -5}, {
     UndirectedEdge[$CellContext`g, $CellContext`d], -2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709354464*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"ec6182e5-c0e1-4b93-a5cd-1fdac063dc3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 6, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093554673`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"60318e3d-1d07-4f55-9000-e79f9b709698"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"b", "\[UndirectedEdge]", "h"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}]}], "}"}]}],
  SequenceForm["Se agreg\[OAcute] la arista: ", 
   UndirectedEdge[$CellContext`b, $CellContext`h], ", T=", {
    UndirectedEdge[$CellContext`c, $CellContext`f], 
    UndirectedEdge[$CellContext`a, $CellContext`b], 
    UndirectedEdge[$CellContext`f, $CellContext`g], 
    UndirectedEdge[$CellContext`b, $CellContext`d], 
    UndirectedEdge[$CellContext`a, $CellContext`c], 
    UndirectedEdge[$CellContext`b, $CellContext`h]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709356423*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"54a5486c-7d76-4e39-bc45-7c3de0897246"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "32"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -32],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093574224`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"8efbe392-8e55-402a-8f58-15c6ad852285"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "a"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}],
  SequenceForm["AS=", {{
     UndirectedEdge[$CellContext`c, $CellContext`e], -3}, {
     UndirectedEdge[$CellContext`d, $CellContext`e], -2}, {
     UndirectedEdge[$CellContext`d, $CellContext`a], -4}, {
     UndirectedEdge[$CellContext`c, $CellContext`d], -2}, {
     UndirectedEdge[$CellContext`e, $CellContext`h], -3}, {
     UndirectedEdge[$CellContext`c, $CellContext`h], -2}, {
     UndirectedEdge[$CellContext`b, $CellContext`c], -4}, {
     UndirectedEdge[$CellContext`d, $CellContext`f], -4}, {
     UndirectedEdge[$CellContext`e, $CellContext`f], -2}, {
     UndirectedEdge[$CellContext`a, $CellContext`g], -5}, {
     UndirectedEdge[$CellContext`g, $CellContext`d], -2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.81576970935945*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"0a98ea55-3db7-40ed-a7bf-e3d11704f185"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"*** Iteraci\[OAcute]n \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" ***\"\>"}],
  SequenceForm["*** Iteraci\[OAcute]n ", 7, " ***"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093614087`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"280b5613-a352-43e7-9dcb-beb1678b0d11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se agreg\[OAcute] la arista: \"\>", "\[InvisibleSpace]", 
   RowBox[{"e", "\[UndirectedEdge]", "h"}], 
   "\[InvisibleSpace]", "\<\", T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "h"}]}], "}"}]}],
  SequenceForm["Se agreg\[OAcute] la arista: ", 
   UndirectedEdge[$CellContext`e, $CellContext`h], ", T=", {
    UndirectedEdge[$CellContext`c, $CellContext`f], 
    UndirectedEdge[$CellContext`a, $CellContext`b], 
    UndirectedEdge[$CellContext`f, $CellContext`g], 
    UndirectedEdge[$CellContext`b, $CellContext`d], 
    UndirectedEdge[$CellContext`a, $CellContext`c], 
    UndirectedEdge[$CellContext`b, $CellContext`h], 
    UndirectedEdge[$CellContext`e, $CellContext`h]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093624067`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"b38b13a8-5848-4ff1-b5df-d57a49f27e0e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso m\[IAcute]nimo acumulado: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "35"}]}],
  SequenceForm["Peso m\[IAcute]nimo acumulado: ", -35],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.81576970936443*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"bebe343e-4b3a-425f-84a2-5d6cc5fa30ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AS=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}],
  SequenceForm["AS=", {{
     UndirectedEdge[$CellContext`c, $CellContext`e], -3}, {
     UndirectedEdge[$CellContext`d, $CellContext`e], -2}, {
     UndirectedEdge[$CellContext`c, $CellContext`d], -2}, {
     UndirectedEdge[$CellContext`c, $CellContext`h], -2}, {
     UndirectedEdge[$CellContext`e, $CellContext`f], -2}, {
     UndirectedEdge[$CellContext`g, $CellContext`d], -2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709366394*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"e73fa551-8e8b-4fa6-b568-ec073a5dff87"],

Cell[BoxData["\<\"*** Finalmente ***\"\>"], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093673916`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"0d3c9403-2a43-41d8-8dda-96749c96910b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
     RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
     RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
     RowBox[{"b", "\[UndirectedEdge]", "h"}], ",", 
     RowBox[{"e", "\[UndirectedEdge]", "h"}]}], "}"}]}],
  SequenceForm["T=", {
    UndirectedEdge[$CellContext`c, $CellContext`f], 
    UndirectedEdge[$CellContext`a, $CellContext`b], 
    UndirectedEdge[$CellContext`f, $CellContext`g], 
    UndirectedEdge[$CellContext`b, $CellContext`d], 
    UndirectedEdge[$CellContext`a, $CellContext`c], 
    UndirectedEdge[$CellContext`b, $CellContext`h], 
    UndirectedEdge[$CellContext`e, $CellContext`h]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.8157697093693886`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"b761474b-bec8-4522-80af-daa40d0e3305"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Peso: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "35"}]}],
  SequenceForm["Peso: ", -35],
  Editable->False]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709370384*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"f6e8eb14-7e39-45c7-acce-a34a8ea26f24"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 7, 1}}, 
    Typeset`size$$ = {651., {204., 216.4042957310637}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 
        OptionValue[VilCretas`AnimarGrafo, {}, VilCretas`padding], 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 7, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{747., {285.75, 298.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.8157414010770903`*^9, 3.8157418872859163`*^9, 
  3.8157646587907486`*^9, 3.815769709379362*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"676f1124-a282-47c2-9cc0-508d0e9a8f6a"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{Automatic, 954.5}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"0dccf075-9df6-4932-8ee3-7a69f67f9fa3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 182, 4, 63, "Input",ExpressionUUID->"598afc19-aa3f-4a0c-85db-d3be449b5c22"],
Cell[CellGroupData[{
Cell[765, 28, 1682, 48, 384, "Input",ExpressionUUID->"7ca8fd40-dec0-4e10-b5c5-947d8b3743e8"],
Cell[2450, 78, 8363, 160, 503, "Output",ExpressionUUID->"1b883d32-b4d1-4fd3-86ca-3aa66cc13ce6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10850, 243, 1982, 53, 427, "Input",ExpressionUUID->"d7127bca-2b28-451a-918e-7a999f6419b9"],
Cell[12835, 298, 8934, 174, 503, "Output",ExpressionUUID->"c20a729b-3fdc-40a9-b87a-29cc64200c50"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21806, 477, 490, 11, 91, "Input",ExpressionUUID->"a2aaa785-e74a-4446-93fe-ca2a7da9f4f8"],
Cell[CellGroupData[{
Cell[22321, 492, 722, 15, 50, "Print",ExpressionUUID->"2f854cef-5978-42a0-9a63-5907ae7d6500"],
Cell[23046, 509, 1120, 28, 91, "Print",ExpressionUUID->"cbfc82c2-84bc-4473-8346-9fa2aa378d02"],
Cell[24169, 539, 477, 11, 50, "Print",ExpressionUUID->"0a344ed1-f99a-42bc-91fc-bc88446fa442"],
Cell[24649, 552, 2442, 52, 604, "Print",ExpressionUUID->"8a328da6-0a7f-44dc-a2ad-3e0201d52cb5"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27140, 610, 143, 2, 91, "Input",ExpressionUUID->"62ceb789-9c93-49aa-ad08-cc415b7833f8"],
Cell[CellGroupData[{
Cell[27308, 616, 1161, 25, 50, "Print",ExpressionUUID->"da0bcabf-37ce-4ec3-820e-59534cea49a2"],
Cell[28472, 643, 428, 10, 50, "Print",ExpressionUUID->"a527764f-0695-4c3b-a6f9-058e6a34a4c0"],
Cell[28903, 655, 2393, 51, 604, "Print",ExpressionUUID->"21552e73-e4c3-437e-9041-182d60968dc0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31345, 712, 614, 13, 168, "Input",ExpressionUUID->"899cb278-0ced-4c35-8824-b106c81545fa"],
Cell[CellGroupData[{
Cell[31984, 729, 344, 6, 50, "Print",ExpressionUUID->"514b4344-b2c6-453e-a97e-404e12eb8d02"],
Cell[32331, 737, 7191, 244, 333, "Print",ExpressionUUID->"1378135b-8553-4bf1-adc9-c586e6f4c31c"],
Cell[39525, 983, 698, 15, 50, "Print",ExpressionUUID->"ebc46d9e-3bac-40d2-b5be-465742fe108a"],
Cell[40226, 1000, 349, 6, 50, "Print",ExpressionUUID->"b5ae4f83-caa0-42ef-b9ba-c02ec479f9ce"],
Cell[40578, 1008, 1290, 35, 131, "Print",ExpressionUUID->"31c5c690-0cf2-43c5-bd5c-ffac15128224"],
Cell[41871, 1045, 514, 11, 50, "Print",ExpressionUUID->"886a841c-efd7-4b41-9bec-6be24462cdb3"],
Cell[42388, 1058, 736, 17, 50, "Print",ExpressionUUID->"ee63f2fb-4d97-4807-b418-bb3d85188519"],
Cell[43127, 1077, 501, 11, 50, "Print",ExpressionUUID->"71dcf536-67f7-4ec5-95ce-2be42dceff58"],
Cell[43631, 1090, 1526, 44, 91, "Print",ExpressionUUID->"be7d7b55-0544-4d7c-b9c4-ab7fd5f15d20"],
Cell[45160, 1136, 512, 11, 50, "Print",ExpressionUUID->"ec3c2295-77fc-4cb8-adc7-fa69f3047494"],
Cell[45675, 1149, 846, 21, 50, "Print",ExpressionUUID->"af63ccb8-a71c-4099-8a6b-cfc3b8eaee16"],
Cell[46524, 1172, 505, 11, 50, "Print",ExpressionUUID->"1aca90c0-82ba-438b-9b5b-0566180bca4c"],
Cell[47032, 1185, 1703, 49, 131, "Print",ExpressionUUID->"116aad7e-32c6-4d9f-8b41-a4c7955a571b"],
Cell[48738, 1236, 512, 11, 50, "Print",ExpressionUUID->"0295605f-ad82-4ace-a709-4741a769d50f"],
Cell[49253, 1249, 936, 23, 91, "Print",ExpressionUUID->"c494925c-ca9d-4e82-8f6e-b9b5cb6fbc47"],
Cell[50192, 1274, 505, 11, 50, "Print",ExpressionUUID->"98d6a603-ffc0-4aa3-95af-16a731ef5638"],
Cell[50700, 1287, 2061, 60, 131, "Print",ExpressionUUID->"07b107f5-93ca-482f-8829-2d8df8e217ab"],
Cell[52764, 1349, 512, 11, 50, "Print",ExpressionUUID->"97fe4fe6-7d0f-426f-8e57-3250a7f502bb"],
Cell[53279, 1362, 1030, 25, 91, "Print",ExpressionUUID->"506b718d-7a58-42fc-a709-cfe9ad24f0b7"],
Cell[54312, 1389, 503, 11, 50, "Print",ExpressionUUID->"9066f16e-b64a-485c-b031-2f21f6fd806f"],
Cell[54818, 1402, 1884, 55, 131, "Print",ExpressionUUID->"25471f02-059f-4964-90c7-1a795c3cdc50"],
Cell[56705, 1459, 514, 11, 50, "Print",ExpressionUUID->"14615f27-87dd-4f9f-a52a-e6aae831b74d"],
Cell[57222, 1472, 1121, 27, 91, "Print",ExpressionUUID->"7d3e9583-20eb-495b-ae93-01a056674451"],
Cell[58346, 1501, 505, 11, 50, "Print",ExpressionUUID->"a7c65544-ff3f-4361-9f37-a63bdb1bb533"],
Cell[58854, 1514, 1524, 44, 91, "Print",ExpressionUUID->"b0ce771d-d63d-4e9e-bed8-c6634b043bee"],
Cell[60381, 1560, 511, 11, 50, "Print",ExpressionUUID->"58b3d596-170b-4436-a9be-18a6b9e00124"],
Cell[60895, 1573, 1217, 30, 91, "Print",ExpressionUUID->"b72a47ea-092e-457e-b706-84b95a366418"],
Cell[62115, 1605, 505, 11, 50, "Print",ExpressionUUID->"87ab2e7c-4895-419b-befc-3276e0ec82a6"],
Cell[62623, 1618, 1172, 34, 91, "Print",ExpressionUUID->"fa8794b6-3931-431d-a684-ec621c48bba4"],
Cell[63798, 1654, 512, 11, 50, "Print",ExpressionUUID->"342afdfe-b56a-47e8-863d-89fb5544488e"],
Cell[64313, 1667, 1308, 32, 91, "Print",ExpressionUUID->"e95af92c-cf7d-411b-b429-0fcc52c37baa"],
Cell[65624, 1701, 505, 11, 50, "Print",ExpressionUUID->"8adcfaf7-f73c-4913-8629-6acf27c1cb01"],
Cell[66132, 1714, 447, 11, 50, "Print",ExpressionUUID->"e61427da-4bd6-40cf-b5a1-085b4df1f5da"],
Cell[66582, 1727, 337, 6, 50, "Print",ExpressionUUID->"e0e1394f-5d56-4b25-aac6-4e1242ff38a6"],
Cell[66922, 1735, 1098, 28, 91, "Print",ExpressionUUID->"89a5a7d8-5901-4da5-8b4a-63fe5734ef24"],
Cell[68023, 1765, 453, 11, 50, "Print",ExpressionUUID->"604a6ed4-0816-4d6f-ac2e-11a391fe0abb"],
Cell[68479, 1778, 2418, 52, 604, "Print",ExpressionUUID->"d4a22505-6b32-4089-8a52-84948c6e4287"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70946, 1836, 201, 4, 125, "Input",ExpressionUUID->"c0ebbcc3-abe7-44b0-a15f-a16c0a26f64a"],
Cell[CellGroupData[{
Cell[71172, 1844, 295, 5, 50, "Print",ExpressionUUID->"51b198bd-af01-4a7c-b056-22dae179bc39"],
Cell[71470, 1851, 7142, 243, 333, "Print",ExpressionUUID->"6fc9fb1a-0a5f-423a-b450-88d62bb01b56"],
Cell[78615, 2096, 300, 5, 50, "Print",ExpressionUUID->"09e0a11c-a857-4f29-8f90-bdde0028c100"],
Cell[78918, 2103, 3755, 98, 331, "Print",ExpressionUUID->"40b975ab-8cc7-40f9-9afd-888a442047f7"],
Cell[82676, 2203, 463, 10, 50, "Print",ExpressionUUID->"af8fd525-0b18-46da-883b-20b883ce9ed2"],
Cell[83142, 2215, 712, 15, 50, "Print",ExpressionUUID->"e3500215-b7a5-43d2-8b02-ee119738096c"],
Cell[83857, 2232, 452, 10, 50, "Print",ExpressionUUID->"9b7ea997-4c5c-4698-8c0b-211c90f6d5db"],
Cell[84312, 2244, 3444, 91, 251, "Print",ExpressionUUID->"ab4bae00-5a5c-4cb0-82ca-a1b4ce3fcd9c"],
Cell[87759, 2337, 465, 10, 50, "Print",ExpressionUUID->"52070608-46d6-43ef-870a-a7797af3e88d"],
Cell[88227, 2349, 835, 18, 50, "Print",ExpressionUUID->"a4d91c7b-8a85-4f9a-9ee0-d86e32d19d62"],
Cell[89065, 2369, 454, 10, 50, "Print",ExpressionUUID->"9be91527-0892-436c-ba85-43fc0e390d54"],
Cell[89522, 2381, 3256, 86, 211, "Print",ExpressionUUID->"e00fd014-4f71-4570-a54d-3f668f60322f"],
Cell[92781, 2469, 463, 10, 50, "Print",ExpressionUUID->"09f3c164-ede4-4ec2-94dd-eb61f900c1a3"],
Cell[93247, 2481, 940, 20, 50, "Print",ExpressionUUID->"07107fac-01ad-4c05-a381-1c26d121a48e"],
Cell[94190, 2503, 454, 10, 50, "Print",ExpressionUUID->"9a52fce6-e9ba-4ee3-a87d-9fed19c5f931"],
Cell[94647, 2515, 3064, 81, 211, "Print",ExpressionUUID->"babf7f06-b9e0-4a0d-8f8e-b6b0dcee80fa"],
Cell[97714, 2598, 465, 10, 50, "Print",ExpressionUUID->"ebd16373-d68b-4cb9-99b8-0eebf6689dc3"],
Cell[98182, 2610, 1043, 22, 91, "Print",ExpressionUUID->"d6fa552d-b06d-4492-b1ff-6f57559439f6"],
Cell[99228, 2634, 454, 10, 50, "Print",ExpressionUUID->"8babe464-855d-4a32-917b-d35c46ecc8d5"],
Cell[99685, 2646, 2876, 76, 211, "Print",ExpressionUUID->"d51495f1-1ebf-4664-a23f-ec3b42c52f1c"],
Cell[102564, 2724, 463, 10, 50, "Print",ExpressionUUID->"a7f26b8f-af66-4e0c-8110-e265fb0773fd"],
Cell[103030, 2736, 1148, 24, 91, "Print",ExpressionUUID->"3ae1fe2d-3449-4217-b400-528099bb2f8c"],
Cell[104181, 2762, 456, 10, 50, "Print",ExpressionUUID->"90b82b94-1a8e-4257-9311-cd21056b2a8a"],
Cell[104640, 2774, 2684, 71, 171, "Print",ExpressionUUID->"ec6182e5-c0e1-4b93-a5cd-1fdac063dc3c"],
Cell[107327, 2847, 465, 10, 50, "Print",ExpressionUUID->"60318e3d-1d07-4f55-9000-e79f9b709698"],
Cell[107795, 2859, 1253, 26, 91, "Print",ExpressionUUID->"54a5486c-7d76-4e39-bc45-7c3de0897246"],
Cell[109051, 2887, 456, 10, 50, "Print",ExpressionUUID->"8efbe392-8e55-402a-8f58-15c6ad852285"],
Cell[109510, 2899, 2493, 66, 171, "Print",ExpressionUUID->"0a98ea55-3db7-40ed-a7bf-e3d11704f185"],
Cell[112006, 2967, 465, 10, 50, "Print",ExpressionUUID->"280b5613-a352-43e7-9dcb-beb1678b0d11"],
Cell[112474, 2979, 1360, 28, 91, "Print",ExpressionUUID->"b38b13a8-5848-4ff1-b5df-d57a49f27e0e"],
Cell[113837, 3009, 453, 10, 50, "Print",ExpressionUUID->"bebe343e-4b3a-425f-84a2-5d6cc5fa30ef"],
Cell[114293, 3021, 1544, 41, 91, "Print",ExpressionUUID->"e73fa551-8e8b-4fa6-b568-ec073a5dff87"],
Cell[115840, 3064, 288, 5, 50, "Print",ExpressionUUID->"0d3c9403-2a43-41d8-8dda-96749c96910b"],
Cell[116131, 3071, 1139, 25, 50, "Print",ExpressionUUID->"b761474b-bec8-4522-80af-daa40d0e3305"],
Cell[117273, 3098, 404, 10, 50, "Print",ExpressionUUID->"f6e8eb14-7e39-45c7-acce-a34a8ea26f24"],
Cell[117680, 3110, 2369, 51, 604, "Print",ExpressionUUID->"676f1124-a282-47c2-9cc0-508d0e9a8f6a"]
}, Open  ]]
}, Open  ]]
}
]
*)

