(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     10874,        258]
NotebookOptionsPosition[     10076,        237]
NotebookOutlinePosition[     10512,        254]
CellTagsIndexPosition[     10469,        251]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8199749238028493`*^9, 3.819974935536437*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"], ",", 
       SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     SubscriptBox["\[Sigma]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "0"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "0"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox["\[Sigma]", "3"], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToDiagrama", "[", 
  RowBox[{"A", ",", 
   RowBox[{"forma", "\[Rule]", "\"\<rectangular\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Prueba", "[", 
   RowBox[{"automata_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "=", 
       RowBox[{"LenguajeStrings", "[", 
        RowBox[{"automata", ",", "n", ",", 
         RowBox[{"limite", "\[Rule]", "True"}]}], "]"}]}], ",", 
      RowBox[{"valorLogico", "=", "True"}], ",", "i", ",", "m"}], "}"}], ",", 
    RowBox[{
     RowBox[{"m", "=", 
      RowBox[{"Length", "[", "L", "]"}]}], ";", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "\[LessEqual]", "m"}], ",", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{"Take", "[", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"-", "3"}]}], "]"}], "]"}], "\[NotEqual]", 
           RowBox[{"ToString", "[", 
            RowBox[{"{", 
             RowBox[{"a", ",", "b", ",", "b"}], "}"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"valorLogico", "=", "False"}], ";", 
           RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
        RowBox[{"i", "++"}]}]}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"valorLogico", "\[Equal]", "False"}], ",", "i", ",", 
         RowBox[{"i", "-", "1"}]}], "]"}], ",", "\"\< pruebas: \>\"", ",", 
       "valorLogico"}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Prueba", "[", 
  RowBox[{"A", ",", "20"}], "]"}]}], "Input",
 CellChangeTimes->{{3.819994370947709*^9, 3.819994400588317*^9}, {
  3.8199944674389706`*^9, 3.81999457376061*^9}, {3.8199948144508734`*^9, 
  3.819994825605114*^9}, {3.819994894484734*^9, 3.8199949861386485`*^9}, {
  3.8199957421308374`*^9, 3.8199957575249825`*^9}, {3.8199987939070854`*^9, 
  3.8199988433413563`*^9}, {3.8199992231048574`*^9, 3.8199992263384657`*^9}, {
  3.8200582607873783`*^9, 3.820058281151648*^9}, {3.8200586731650705`*^9, 
  3.820058692749812*^9}, {3.820059614269702*^9, 3.8200596556334515`*^9}, {
  3.8200596904152856`*^9, 3.820059717290697*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.499999750000125, 0.500000249999875}], 
   PolygonBox[{{0.9011790163371002, 0.5241796097001121}, {0.9295225886797625, 
    0.5256517479235512}, {0.914075893409051, 0.5494619324945791}}], 
   CircleBox[{0.7563874368639281, 0.2132927099103128}, 0.35713295762733327, {
    1.0646711465837366`, 2.1118686977839505`}], 
   InsetBox["\<\"a\"\>", {0.7501473576172318, 0.5703711478404706}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.39857623027832423, 0.4728293349941237}, 0.03749998125000937, {
    0.7853481633974488, 6.021335919380437}], 
   PolygonBox[{{0.39223601878859543`, 0.4950203300447029}, {
    0.42509404710597987`, 0.49934450017267684`}, {0.4049201917661764, 
    0.5256383023498132}}], 
   InsetBox["\<\"b\"\>", {0.38887233206198446, 0.5090520206090525}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "1"], {0.99999950000025, 0.500000249999875}], 
   PolygonBox[{{0.586048401446168, 0.0684379612930558}, {0.5616698355893153, 
    0.042682989599422606`}, {0.5961635782781771, 0.03444801810637277}}], 
   CircleBox[{0.4168529186728506, 0.5831470813271493}, 0.5595296005326859, {
    4.974088368183839, 6.021285919380437}], 
   InsetBox["\<\"b\"\>", {0.8124605267884618, 0.18746034377670778}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.0774135816582722, 0.5709371863310512}, 
    0.03749998125000937, {-1.8762289458939039`, 3.3597588100890845`}], 
   PolygonBox[{{1.093284916908832, 0.5541819107310003}, {1.0661371198150928`, 
    0.5351728185601765}, {1.0961733750847757`, 0.521166682705625}}], 
   InsetBox["\<\"a\"\>", {1.1027482017765493, 0.5432893000246146}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 0.07499996250001874],
    InsetBox[
    SubscriptBox["\[Sigma]", 
     "2"], {0.499999750000125, 4.999997500476638*^-7}], 
   PolygonBox[{{0.8975615841878651, 0.006488450713043882}, {
    0.9256411725763779, 0.009789959521524153}, {0.9087421878831595, 
    0.032456841989546625`}}], 
   CircleBox[{0.7743313639959277, -0.31068807302085055}, 
    0.35440207041562355, {1.1296858386180628`, 2.176883389814645}], 
   InsetBox["\<\"b\"\>", {0.7451304857971739, 0.04250894880592271}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.8896778009037325, 0.5023001978284792}, {0.9252849350006516, 
    0.4934635725621394}, {0.8998286259878183, 0.46704520251141834`}}], 
   CircleBox[{1.0750420263610447, -0.08407575653266641}, 0.5966396425515188, {
    1.824510452293573, 2.871708003490171}], 
   InsetBox["\<\"a\"\>", {0.6565789162986739, 0.3412094284678603}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.99999950000025, 4.999997500476638*^-7}, 0.07499996250001874], 
   CircleBox[{0.99999950000025, 4.999997500476638*^-7}, 0.04999997500001249], 
   InsetBox[
    SubscriptBox["\[Sigma]", "3"], {0.99999950000025, 4.999997500476638*^-7}],
    PolygonBox[{{0.9938404100849356, 0.4152316389347187}, {
    1.0194109186772295`, 0.42755584925039525`}, {1.0172987435960408`, 
    0.3992490340639422}}], 
   CircleBox[{1.3075346025642474, 0.2163788116042923}, 0.3572268165264325, {
    2.509100403788449, 3.5562979549850446`}], 
   InsetBox["\<\"a\"\>", {0.9524236540630817, 0.2552016489582516}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5298334040348289, 0.40032456574777747`}, {
    0.5374932358753645, 0.43504462751861916`}, {0.5637317754696105, 
    0.41105098767057763`}}], 
   CircleBox[{1.076214703843503, 0.5893634948240105}, 0.560388376803236, {
    3.4205759763358126`, 4.46777352753241}], 
   InsetBox["\<\"b\"\>", {0.6868276606717456, 0.18635870147023215}, 
    ImageScaled[{1, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.8200596444053893`*^9, 3.820059656895215*^9}, {
   3.8200597063954697`*^9, 3.8200597180995245`*^9}, 3.82006819074152*^9, 
   3.8200692108709593`*^9, 3.8200778656178923`*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"28476cfb-10c4-4e4a-93cf-119cb664ad3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "262143", "\[InvisibleSpace]", "\<\" pruebas: \"\>", "\[InvisibleSpace]", 
   "True"}],
  SequenceForm[262143, " pruebas: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8200596393965836`*^9, 3.8200596574317894`*^9}, {
   3.8200597080212*^9, 3.82005971965667*^9}, 3.8200681922940955`*^9, 
   3.8200692123874826`*^9, 3.8200778671847625`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[44]:=",ExpressionUUID->"dd31afea-8eb9-4945-87b5-4692e7d233d7"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8200585299214935`*^9, 
  3.8200586702568684`*^9}},ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-\
044bcbd8951b"]
},
WindowSize->{949., 471.5},
WindowMargins->{{0, Automatic}, {Automatic, 0.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5ba469ff-2b55-4c5e-872e-231d8c1374f3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 42, "Input",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],
Cell[CellGroupData[{
Cell[783, 27, 4189, 108, 538, "Input",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],
Cell[4975, 137, 4405, 78, 544, "Output",ExpressionUUID->"28476cfb-10c4-4e4a-93cf-119cb664ad3d"],
Cell[9383, 217, 518, 12, 33, "Print",ExpressionUUID->"dd31afea-8eb9-4945-87b5-4692e7d233d7"]
}, Open  ]],
Cell[9916, 232, 156, 3, 42, "Input",ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-044bcbd8951b"]
}
]
*)

