(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      9557,        231]
NotebookOptionsPosition[      8667,        208]
NotebookOutlinePosition[      9196,        227]
CellTagsIndexPosition[      9153,        224]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8199749238028493`*^9, 3.819974935536437*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     SubscriptBox["\[Sigma]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "0"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox["\[Sigma]", "2"], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToDiagrama", "[", 
  RowBox[{"A", ",", 
   RowBox[{"forma", "\[Rule]", "\"\<rectangular\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Prueba", "[", 
   RowBox[{"automata_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "=", 
       RowBox[{"LenguajeStrings", "[", 
        RowBox[{"automata", ",", "n", ",", 
         RowBox[{"limite", "\[Rule]", "True"}]}], "]"}]}], ",", 
      RowBox[{"valorLogico", "=", "True"}], ",", "i", ",", "m"}], "}"}], ",", 
    RowBox[{
     RowBox[{"m", "=", 
      RowBox[{"Length", "[", "L", "]"}]}], ";", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "\[LessEqual]", "m"}], ",", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Count", "[", 
            RowBox[{
             RowBox[{"L", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "a"}], "]"}], "<", "2"}], 
          ",", 
          RowBox[{
           RowBox[{"valorLogico", "=", "False"}], ";", 
           RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
        RowBox[{"i", "++"}]}]}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"valorLogico", "\[Equal]", "False"}], ",", "i", ",", 
         RowBox[{"i", "-", "1"}]}], "]"}], ",", "\"\< pruebas: \>\"", ",", 
       "valorLogico"}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Prueba", "[", 
  RowBox[{"A", ",", "20"}], "]"}]}], "Input",
 CellChangeTimes->{{3.819994370947709*^9, 3.819994400588317*^9}, {
  3.8199944674389706`*^9, 3.81999457376061*^9}, {3.8199948144508734`*^9, 
  3.819994825605114*^9}, {3.819994894484734*^9, 3.8199949861386485`*^9}, {
  3.8199957421308374`*^9, 3.8199957575249825`*^9}, {3.8199987939070854`*^9, 
  3.8199988433413563`*^9}, {3.8199992231048574`*^9, 3.8199992263384657`*^9}, {
  3.8200582607873783`*^9, 3.820058281151648*^9}, {3.8200586731650705`*^9, 
  3.820058692749812*^9}, {3.820059614269702*^9, 3.8200596556334515`*^9}, {
  3.8200596904152856`*^9, 3.820059717290697*^9}, {3.8200599559211893`*^9, 
  3.82005997201208*^9}, {3.820060039400489*^9, 3.8200600475164194`*^9}, {
  3.8200601235348463`*^9, 3.8200601260264997`*^9}, {3.820060260318836*^9, 
  3.8200602608734307`*^9}, {3.8200602965137577`*^9, 3.820060310010372*^9}, {
  3.8200603559596977`*^9, 3.820060356769534*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.499999750000125, 0.500000249999875}], 
   PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702, 
    0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
   CircleBox[{0.7499996250001875, 0.21187656611285788}, 0.35511094850116554, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"a\"\>", {0.7499996250001875, 0.5669875146140234}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.4360798319141684, 0.4166981909203249}, 
    0.03749998125000937, {-4.843288674284264, 0.3926990816987246}], 
   PolygonBox[{{0.4089624846467197, 0.4624549648200464}, {
    0.44097456167505544`, 0.4538773546322609}, {0.41754009483450516`, 
    0.43044288779171064`}}], 
   InsetBox["\<\"b\"\>", {0.40632909652861476, 0.43952673309388085}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "1"], {0.99999950000025, 0.500000249999875}], 
   PolygonBox[{{0.5893902837518628, 0.06331553765522902}, {0.5649516228080215,
     0.03750048124975942}, {0.599527447927207, 0.029243508240653027`}}], 
   CircleBox[{0.41943899367211673, 0.5805610063278832}, 0.5622176261343743, {
    4.974088368183839, 6.021285919380437}], 
   InsetBox["\<\"a\"\>", {0.8169471328370685, 0.18297335758387556}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.097006802410284, 0.5401819903073393}, 
    0.03749998125000937, {-2.2252947962927703`, 3.010692959690218}], 
   PolygonBox[{{1.0976127270772782`, 0.48699678808123537`}, {
    1.074178260236728, 0.5104312549217856}, {1.1061903372650637`, 
    0.519008865109571}}], 
   InsetBox["\<\"b\"\>", {1.111357423948664, 0.5055365251608985}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 0.07499996250001874],
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
    0.04999997500001249], InsetBox[
    SubscriptBox["\[Sigma]", 
     "2"], {0.499999750000125, 4.999997500476638*^-7}], 
   CircleBox[{0.4090671280690699, -0.05249947375026308}, 
    0.03749998125000937, {1.0471975511965983`, 6.283185307179586}], 
   PolygonBox[{{0.39719851221858815`, -0.032706179409425995`}, {
    0.42781711869407457`, -0.020023537346314825`}, {0.401524325242572, 
    0.00015163265837957185`}}], 
   InsetBox["\<\"b,a\"\>", {0.3903171374440652, -0.02002353734631484}, 
    ImageScaled[{1, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.8200596444053893`*^9, 3.820059656895215*^9}, {
   3.8200597063954697`*^9, 3.8200597180995245`*^9}, 3.820060407501458*^9, 
   3.820077893593916*^9, 3.820078026191169*^9, 3.820078722265976*^9, 
   3.8200829843209715`*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"70884583-9976-4d38-b5e5-0920be3c36ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2096920", "\[InvisibleSpace]", "\<\" pruebas: \"\>", "\[InvisibleSpace]", 
   "True"}],
  SequenceForm[2096920, " pruebas: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8200596393965836`*^9, 3.8200596574317894`*^9}, {
   3.8200597080212*^9, 3.82005971965667*^9}, 3.820060416639596*^9, 
   3.820077902042843*^9, 3.8200780348545284`*^9, 3.820078730555527*^9, 
   3.820082993404247*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"0f327f50-9d15-44a6-86e8-e450fc4089e4"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8200585299214935`*^9, 
  3.8200586702568684`*^9}},ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-\
044bcbd8951b"]
},
WindowSize->{949.5, 471.5},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
TaggingRules->{
 "WelcomeScreenSettings" -> {"FEStarting" -> False}, "TryRealOnly" -> False},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5ba469ff-2b55-4c5e-872e-231d8c1374f3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 69, "Input",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],
Cell[CellGroupData[{
Cell[783, 27, 3950, 99, 484, "Input",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],
Cell[4736, 128, 3190, 57, 549, "Output",ExpressionUUID->"70884583-9976-4d38-b5e5-0920be3c36ee"],
Cell[7929, 187, 563, 13, 33, "Print",ExpressionUUID->"0f327f50-9d15-44a6-86e8-e450fc4089e4"]
}, Open  ]],
Cell[8507, 203, 156, 3, 42, "Input",ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-044bcbd8951b"]
}
]
*)

