(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13466,        318]
NotebookOptionsPosition[     12670,        297]
NotebookOutlinePosition[     13101,        314]
CellTagsIndexPosition[     13058,        311]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8199749238028493`*^9, 3.819974935536437*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"], ",", 
       SubscriptBox["\[Sigma]", "3"], ",", 
       SubscriptBox["\[Sigma]", "4"], ",", 
       SubscriptBox["\[Sigma]", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     SubscriptBox["\[Sigma]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "5"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "4"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "4"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "5"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "5"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "5"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox["\[Sigma]", "3"], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToDiagrama", "[", 
  RowBox[{"A", ",", 
   RowBox[{"forma", "\[Rule]", "\"\<rectangular\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Prueba", "[", 
   RowBox[{"automata_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "=", 
       RowBox[{"LenguajeStrings", "[", 
        RowBox[{"automata", ",", "n", ",", 
         RowBox[{"limite", "\[Rule]", "True"}]}], "]"}]}], ",", 
      RowBox[{"valorLogico", "=", "True"}], ",", "i", ",", "m"}], "}"}], ",", 
    RowBox[{
     RowBox[{"m", "=", 
      RowBox[{"Length", "[", "L", "]"}]}], ";", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "\[LessEqual]", "m"}], ",", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"Take", "[", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", "2"}], "]"}], "]"}], 
            "\[NotEqual]", 
            RowBox[{"ToString", "[", 
             RowBox[{"{", 
              RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "||", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"Take", "[", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", 
               RowBox[{"-", "2"}]}], "]"}], "]"}], "\[NotEqual]", 
            RowBox[{"ToString", "[", 
             RowBox[{"{", 
              RowBox[{"b", ",", "a"}], "}"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"valorLogico", "=", "False"}], ";", 
           RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
        RowBox[{"i", "++"}]}]}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"valorLogico", "\[Equal]", "False"}], ",", "i", ",", 
         RowBox[{"i", "-", "1"}]}], "]"}], ",", "\"\< pruebas: \>\"", ",", 
       "valorLogico"}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Prueba", "[", 
  RowBox[{"A", ",", "20"}], "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAGIQvSg4bgF/2RvHustCS0A0D0/eGhD9OmzHThDdl3vu
OoiWiDW+CaI/Np1/CKLP57u8BdGX9I94CwDpFWc2+ILoG2y2JwWBdMqbrPMg
+l/U438getsVr/8g2sRo5iU9IO17S+UqiHbyUGXTB9Jl/6ZzgOi0hSeqQbSN
65cGEM3q5dsKolN8V3aA6KSq2mUg+ltSwwoQfe7Cmw0guqntw0awObKFu0G0
2M0DYPqFcdcZEK36eTaY3lIgcBFE/wg5cAlE39hadwNEsy2YAaZ9lLe+A9HL
3m/4DqJ37MiSNADSE1ltFED0QbOVqiB62bZ3YPrYvX3WEUDa/p6bDYje9TE9
CEQXXZSNB9G8b9NLQfS9UosKEM3gvLYFRDtGsrWBaACz8L/Q
  "],
 CellLabel->"In[38]:=",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.33333322222225925, 0.6666667777777407}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.33333322222225925, 0.6666667777777407}],
    PolygonBox[{{0.34562493940113553`, 0.400458848016453}, {
    0.34627417016373596`, 0.3816298307711765}, {0.3622559620451405, 
    0.39160658972714507`}}], 
   CircleBox[{0.14125073428384913, 0.5000001666666112}, 0.23674067179086933, {
    5.759486531581287, 6.8067840827778845`}], 
   InsetBox["\<\"b\"\>", {0.37799140577879264, 0.49998832963302653}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   PolygonBox[{{0.5995138805426964, 0.678956610691319}, {0.6183701692288235, 
    0.6796077257192175}, {0.608378142730814, 0.6956121932285473}}], 
   CircleBox[{0.4999998333333889, 0.47458428983933065}, 0.23674067179086933, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"a\"\>", {0.4999998333333889, 0.7113249616302}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Sigma]", "1"], {0.6666664444445185, 0.6666667777777407}], 
   PolygonBox[{{0.6789581616233947, 0.400458848016453}, {0.6796073923859952, 
    0.3816298307711765}, {0.6955891842673997, 0.39160658972714507`}}], 
   CircleBox[{0.4745839565061084, 0.5000001666666112}, 0.23674067179086933, {
    5.759486531581287, 6.8067840827778845`}], 
   InsetBox["\<\"b\"\>", {0.7113246280010519, 0.49998832963302653}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   PolygonBox[{{0.39292692132236284`, 0.3755435876941361}, {
    0.37663447797772925`, 0.35833354722215094`}, {0.39968503189894355`, 
    0.3528288976319721}}], 
   CircleBox[{0.27962604238572847, 0.7203739576142715}, 0.37481181322485385, {
    4.974088368183839, 6.021285919380437}], 
   InsetBox["\<\"a\"\>", {0.5446315126632526, 0.4553154809418757}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Sigma]", "2"], {0.6666664444445185, 0.3333335555554815}], 
   PolygonBox[{{0.3906989994139127, 0.04562531513291916}, {
    0.37444661946728225`, 0.02845533114216789}, {0.3974424517591602, 
    0.02296534923180478}}], 
   CircleBox[{0.27790199209887595, 0.38876478567886474}, 0.3730197958583921, {
    4.974088368183839, 6.021285919380437}], 
   InsetBox["\<\"a\"\>", {0.5416404414656697, 0.12497358334672531}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.736666421111193, 0.3333335555554815}, 
    0.024999991666669445, {-2.617993877991494, 2.6179938779914944`}], 
   PolygonBox[{{0.7234708893513808, 0.3004211520030895}, {0.715015793233458, 
    0.3208335597221468}, {0.7369210049295285, 0.3179496838921785}}], 
   InsetBox["\<\"b\"\>", {0.736666421111193, 0.30833356388881206}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Sigma]", 
     "3"], {0.33333322222225925, 3.333332222466012*^-7}], 
   PolygonBox[{{0.5996404805656622, 0.01023864437633143}, {0.6183701692288235,
     0.012941281274698983`}, {0.6066647726860513, 0.027810349012786284`}}], 
   CircleBox[{0.5224142126661314, -0.2050231025466731}, 0.23815125070947696, {
    1.1560910253996628`, 2.2032885765962242`}], 
   InsetBox["\<\"a\"\>", {0.49653231678317794, 0.03171756924419619}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5927944934502389, 0.33905583658088073`}, {
    0.6166664611111796, 0.3333335555554815}, {0.5997748365451199, 
    0.3155209656354859}}], 
   CircleBox[{0.7203736242810497, -0.053706846503308925}, 
    0.40069370910780744, {1.8325957145940461`, 2.8797932657906435`}], 
   InsetBox["\<\"b\"\>", {0.4370403853921292, 0.2296263923856116}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Sigma]", "4"], {0.33333322222225925, 0.3333335555554815}],
    CircleBox[{0.2907199363960774, 0.2777988402466668}, 
    0.024999991666669445, {-4.843288674284264, 0.3926990816987246}], 
   PolygonBox[{{0.27264170187140735`, 0.3083033612638987}, {
    0.29398309011386076`, 0.3025849535189743}, {0.27836010961633184`, 
    0.2869619730214453}}], 
   InsetBox["\<\"b,a\"\>", {0.27088610950007214, 0.2930178708988746}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
    0.04999998333333889], InsetBox[
    SubscriptBox["\[Sigma]", 
     "5"], {0.6666664444445185, 3.333332222466012*^-7}], 
   PolygonBox[{{0.6625603838166326, 0.2768211387599792}, {0.6796073923859952, 
    0.2850372803397865}, {0.6781992754305167, 0.26616606707028384`}}], 
   CircleBox[{0.8716898803244055, 0.14425256511161028}, 0.23815125070947696, {
    2.509100403788448, 3.5562979549850446`}], 
   InsetBox["\<\"b\"\>", {0.6349492085335362, 0.17013446099456375}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7161639026284241, -0.049497124850683354}, 
    0.024999991666669445, {-3.4033920413889422`, 1.8325957145940457`}], 
   PolygonBox[{{0.6835606689026539, -0.06343905859900226}, {
    0.6920157650205766, -0.043026650879945005`}, {
    0.7054658805987244, -0.060555182769033905`}}], 
   InsetBox["\<\"a\"\>", {0.698486238991315, -0.06717478848779249}, 
    ImageScaled[{1, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.33333322222225925`, 0.7666667444444185}, {
     0.33333322222225925`, 0.7166667611110796}}], 
    PolygonBox[{{0.33333322222225925`, 0.7166667611110796}, {
     0.31666656111114627`, 0.7416667527777491}, {0.34999988333337223`, 
     0.7416667527777491}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.820143664698126*^9, 3.8201436923241463`*^9}, 
   3.8201437492479315`*^9, 3.820144155838827*^9, 3.8201458628629365`*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"0b1b5c44-2cf6-42de-b519-18141a7e4c13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "131072", "\[InvisibleSpace]", "\<\" pruebas: \"\>", "\[InvisibleSpace]", 
   "True"}],
  SequenceForm[131072, " pruebas: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8200609488135033`*^9, {3.820060984603219*^9, 3.820061003573601*^9}, 
   3.8200830172042418`*^9, 3.8201436289167757`*^9, {3.8201436659978275`*^9, 
   3.8201436936227827`*^9}, 3.820143750598894*^9, 3.8201441571690054`*^9, 
   3.8201458642816353`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"1f13095d-7e25-404b-a7ea-cb78acbea6a5"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8200585299214935`*^9, 
  3.8200586702568684`*^9}},ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-\
044bcbd8951b"]
},
WindowSize->{949, 467},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5ba469ff-2b55-4c5e-872e-231d8c1374f3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 42, "Input",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],
Cell[CellGroupData[{
Cell[783, 27, 5160, 138, 621, "Input",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],
Cell[5946, 167, 5948, 106, 673, "Output",ExpressionUUID->"0b1b5c44-2cf6-42de-b519-18141a7e4c13"],
Cell[11897, 275, 598, 14, 33, "Print",ExpressionUUID->"1f13095d-7e25-404b-a7ea-cb78acbea6a5"]
}, Open  ]],
Cell[12510, 292, 156, 3, 42, "Input",ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-044bcbd8951b"]
}
]
*)

