(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16311,        371]
NotebookOptionsPosition[     15478,        349]
NotebookOutlinePosition[     15946,        367]
CellTagsIndexPosition[     15903,        364]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8199749238028493`*^9, 3.819974935536437*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"], ",", 
       SubscriptBox["\[Sigma]", "3"], ",", 
       SubscriptBox["\[Sigma]", "4"], ",", 
       SubscriptBox["\[Sigma]", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     SubscriptBox["\[Sigma]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "3"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "5"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "5"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "3"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "4"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "5"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "4"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "5"], ",", "a", ",", 
         SubscriptBox["\[Sigma]", "5"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "5"], ",", "b", ",", 
         SubscriptBox["\[Sigma]", "3"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "3"], ",", 
       SubscriptBox["\[Sigma]", "5"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToDiagrama", "[", 
  RowBox[{"A", ",", 
   RowBox[{"forma", "\[Rule]", "\"\<rectangular\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Prueba", "[", 
   RowBox[{"automata_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "=", 
       RowBox[{"LenguajeStrings", "[", 
        RowBox[{"automata", ",", "n", ",", 
         RowBox[{"limite", "\[Rule]", "True"}]}], "]"}]}], ",", 
      RowBox[{"valorLogico", "=", "True"}], ",", "i", ",", "m"}], "}"}], ",", 
    RowBox[{
     RowBox[{"m", "=", 
      RowBox[{"Length", "[", "L", "]"}]}], ";", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "\[LessEqual]", "m"}], ",", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"L", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[Equal]", "2"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"L", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[Equal]", 
              RowBox[{"ToString", "[", 
               RowBox[{"{", 
                RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "||", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"L", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[Equal]", 
              RowBox[{"ToString", "[", 
               RowBox[{"{", 
                RowBox[{"b", ",", "b"}], "}"}], "]"}]}]}], ",", 
            RowBox[{
             RowBox[{"valorLogico", "=", "False"}], ";", 
             RowBox[{"Break", "[", "]"}]}]}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", 
              RowBox[{"L", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[GreaterEqual]", 
             "3"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"ToString", "[", 
                 RowBox[{"Take", "[", 
                  RowBox[{
                   RowBox[{"L", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", "2"}], "]"}], "]"}], 
                "\[Equal]", 
                RowBox[{"ToString", "[", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "||", 
               RowBox[{
                RowBox[{"ToString", "[", 
                 RowBox[{"Take", "[", 
                  RowBox[{
                   RowBox[{"L", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", 
                   RowBox[{"-", "2"}]}], "]"}], "]"}], "\[Equal]", 
                RowBox[{"ToString", "[", 
                 RowBox[{"{", 
                  RowBox[{"b", ",", "b"}], "}"}], "]"}]}]}], ",", 
              RowBox[{
               RowBox[{"valorLogico", "=", "False"}], ";", 
               RowBox[{"Break", "[", "]"}]}]}], "]"}]}], "]"}]}], "]"}], ";", 
        RowBox[{"i", "++"}]}]}], "]"}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"valorLogico", "\[Equal]", "False"}], ",", "i", ",", 
         RowBox[{"i", "-", "1"}]}], "]"}], ",", "\"\< pruebas: \>\"", ",", 
       "valorLogico"}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Prueba", "[", 
  RowBox[{"A", ",", "20"}], "]"}]}], "Input",
 CellChangeTimes->{{3.819994370947709*^9, 3.819994400588317*^9}, {
   3.8199944674389706`*^9, 3.81999457376061*^9}, {3.8199948144508734`*^9, 
   3.819994825605114*^9}, {3.819994894484734*^9, 3.8199949861386485`*^9}, {
   3.8199957421308374`*^9, 3.8199957575249825`*^9}, {3.8199987939070854`*^9, 
   3.8199988433413563`*^9}, {3.8199992231048574`*^9, 
   3.8199992263384657`*^9}, {3.8200582607873783`*^9, 3.820058281151648*^9}, {
   3.8200586731650705`*^9, 3.820058692749812*^9}, {3.820059614269702*^9, 
   3.8200596556334515`*^9}, {3.8200596904152856`*^9, 3.820059717290697*^9}, {
   3.8200599559211893`*^9, 3.82005997201208*^9}, {3.820060039400489*^9, 
   3.8200600475164194`*^9}, {3.8200601235348463`*^9, 
   3.8200601260264997`*^9}, {3.820060260318836*^9, 3.8200602608734307`*^9}, {
   3.8200602965137577`*^9, 3.820060310010372*^9}, {3.8200603559596977`*^9, 
   3.820060356769534*^9}, {3.8200605336605587`*^9, 3.820060605529254*^9}, {
   3.8200608753350487`*^9, 3.8200609298756795`*^9}, {3.820060973287934*^9, 
   3.820060975459796*^9}, {3.8200610917967234`*^9, 3.8200611029204917`*^9}, 
   3.8200612160328636`*^9, {3.8200628843479366`*^9, 3.820063004275433*^9}, {
   3.820063186623036*^9, 3.820063212468465*^9}, {3.8200635004405675`*^9, 
   3.8200635088910437`*^9}, 3.820064202506435*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.33333322222225925, 0.6666667777777407}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.33333322222225925, 0.6666667777777407}],
    PolygonBox[{{0.34562493940113553`, 0.400458848016453}, {
    0.34627417016373596`, 0.3816298307711765}, {0.3622559620451405, 
    0.39160658972714507`}}], 
   CircleBox[{0.14125073428384913, 0.5000001666666112}, 0.23674067179086933, {
    5.759486531581287, 6.8067840827778845`}], 
   InsetBox["\<\"b\"\>", {0.37799140577879264, 0.49998832963302653}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   PolygonBox[{{0.5995138805426964, 0.678956610691319}, {0.6183701692288235, 
    0.6796077257192175}, {0.608378142730814, 0.6956121932285473}}], 
   CircleBox[{0.4999998333333889, 0.47458428983933065}, 0.23674067179086933, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"a\"\>", {0.4999998333333889, 0.7113249616302}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.04999998333333889], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Sigma]", "1"], {0.6666664444445185, 0.6666667777777407}], 
   PolygonBox[{{0.6790328931862236, 0.07751725122340411}, {0.6796073923859952,
     0.04829660854891726}, {0.7046259616571228, 0.06340446078761666}}], 
   CircleBox[{0.18627507617318856, 0.33478686129880425}, 0.5704852663659131, {
    5.75695941943463, 6.8042569706312275`}], 
   InsetBox["\<\"b\"\>", {0.7567584480992005, 0.3333166584167588}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.37942170855197366`, 0.06591984151800892}, {
    0.3661146571154462, 0.03775448356439431}, {0.3971600983282223, 
    0.040312917947702614`}}], 
   CircleBox[{0.00813560954648915, 0.578216307051387}, 0.6482653632157613, {
    5.297302513962886, 6.344600065159483}], 
   InsetBox["\<\"a\"\>", {0.5883710165746976, 0.28912314978876313}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
    0.04999998333333889], InsetBox[
    SubscriptBox["\[Sigma]", 
     "2"], {0.6666664444445185, 3.333332222466012*^-7}], 
   CircleBox[{0.648549117326451, -0.06761445196875077}, 
    0.024999991666669445, {1.8325957145940466`, 7.068583470577035}], 
   PolygonBox[{{0.6201734316596422, -0.04635019019087164}, {
    0.6420786433557126, -0.043466314360903265`}, {
    0.6336235472377899, -0.06387872207996047}}], 
   InsetBox["\<\"b,a\"\>", {0.6244009797186035, -0.06114397799801241}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.04999998333333889], 
   CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.033333322222225924],
    InsetBox[
    SubscriptBox["\[Sigma]", "3"], {0.33333322222225925, 0.3333335555554815}],
    PolygonBox[{{0.34246966093914866`, 0.06789309550246954}, {
    0.3428457024966788, 0.04908710397830488}, {0.35894414812119513`, 
    0.05881576128208697}}], 
   CircleBox[{0.14022108957374563, 0.1700313322547708}, 0.23597508367528633, {
    5.744957081080129, 6.792254632276725}], 
   InsetBox["\<\"a\"\>", {0.3761710942169063, 0.16659106708318602}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5995138805426964, 0.34562338846905966`}, {
    0.6183701692288235, 0.3462745034969582}, {0.608378142730814, 
    0.3622789710062881}}], 
   CircleBox[{0.4999998333333889, 0.14125106761707137}, 0.23674067179086933, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"b\"\>", {0.4999998333333889, 0.37799173940794073}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Sigma]", "4"], {0.6666664444445185, 0.3333335555554815}], 
   PolygonBox[{{0.39888816921538905`, 0.0184394293061746}, {
    0.38333320555559813`, 3.333332222466012*^-7}, {
    0.40707941292088967`, -0.0042511123646242835`}}], 
   CircleBox[{0.26132477829692746, 0.36873947130321205}, 
    0.38840006204039873, {5.031829964125448, 6.079027515322045}], 
   InsetBox["\<\"a\"\>", {0.5513309099888778, 0.1103772221760288}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.7313379901631267, 0.36012138689176065}, 
    0.024999991666669445, {-2.2252947962927703`, 3.010692959690218}], 
   PolygonBox[{{0.7317419400084479, 0.32466457949822647`}, {0.716118959510919,
     0.3402875599957554}, {0.7374603477533723, 0.3460059677406798}}], 
   InsetBox["\<\"b\"\>", {0.7409050727832264, 0.33702440627797203}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Sigma]", 
     "5"], {0.33333322222225925, 3.333332222466012*^-7}], 
   PolygonBox[{{0.3030610815280366, 0.276285675557491}, {0.32039227428078254`,
     0.2850372803397865}, {0.31930578996975884`, 0.26565222474687605`}}], 
   CircleBox[{0.5254157101606695, 0.1407850485613984}, 0.25068569092199877, {
    2.5284620315250947`, 3.5756595827216917`}], 
   InsetBox["\<\"b\"\>", {0.2757340904283234, 0.16319942789414005}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.3065453908859801, -0.06467121238538592}, 
    0.024999991666669445, {-4.581489286485114, 0.6544984694978737}], 
   PolygonBox[{{0.2811880062639009, -0.039885099113078436`}, {
    0.3032822371681967, -0.03988509911307843}, {
    0.29223512171604876`, -0.059019264353277846`}}], 
   InsetBox["\<\"a\"\>", {0.2834484102721915, -0.05510412976528622}, 
    ImageScaled[{1, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.33333322222225925`, 0.7666667444444185}, {
     0.33333322222225925`, 0.7166667611110796}}], 
    PolygonBox[{{0.33333322222225925`, 0.7166667611110796}, {
     0.31666656111114627`, 0.7416667527777491}, {0.34999988333337223`, 
     0.7416667527777491}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.8200596444053893`*^9, 3.820059656895215*^9}, {
   3.8200597063954697`*^9, 3.8200597180995245`*^9}, 3.820060407501458*^9, 
   3.8200606130581503`*^9, 3.8200609483598185`*^9, {3.8200609832402887`*^9, 
   3.8200610022544036`*^9}, 3.8200611618409023`*^9, 3.82006121968056*^9, {
   3.8200632057568803`*^9, 3.8200632129345894`*^9}, 3.8200634316417947`*^9, 
   3.8200635093841243`*^9, 3.820083038979744*^9, 3.820166051823162*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"073dda1e-bf5a-418d-b3e7-72355e40a02d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1179648", "\[InvisibleSpace]", "\<\" pruebas: \"\>", "\[InvisibleSpace]", 
   "True"}],
  SequenceForm[1179648, " pruebas: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8200609488135033`*^9, {3.820060984603219*^9, 3.820061003573601*^9}, 
   3.8200611856873736`*^9, 3.820061244242515*^9, {3.820063205954303*^9, 
   3.8200632259669733`*^9}, 3.820063444597276*^9, 3.8200635229926243`*^9, 
   3.8200830543668823`*^9, 3.8201660654099274`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"0ba08a5a-19d7-4a64-bef3-d7963577a7a6"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8200585299214935`*^9, 
  3.8200586702568684`*^9}},ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-\
044bcbd8951b"]
},
WindowSize->{960, 478},
WindowMargins->{{-4.714285714285779, Automatic}, {
  Automatic, -4.714285714285714}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5ba469ff-2b55-4c5e-872e-231d8c1374f3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 42, "Input",ExpressionUUID->"e2974e42-ab85-417b-ae68-d3ca546e1c16"],
Cell[CellGroupData[{
Cell[783, 27, 7468, 183, 782, "Input",ExpressionUUID->"2f17184b-81da-488d-85b1-6098be3fdca5"],
Cell[8254, 212, 6427, 113, 673, "Output",ExpressionUUID->"073dda1e-bf5a-418d-b3e7-72355e40a02d"],
Cell[14684, 327, 619, 14, 33, "Print",ExpressionUUID->"0ba08a5a-19d7-4a64-bef3-d7963577a7a6"]
}, Open  ]],
Cell[15318, 344, 156, 3, 42, "Input",ExpressionUUID->"f0ae6463-c001-4ea4-b6dc-044bcbd8951b"]
}
]
*)

