(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     65499,       1449]
NotebookOptionsPosition[     61085,       1385]
NotebookOutlinePosition[     61516,       1402]
CellTagsIndexPosition[     61473,       1399]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8202311176947727`*^9, 3.8202311208363905`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegularToAutomata", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<S->aS|bA|b\>\"", ",", "\"\<A->aA|a|bB\>\"", ",", 
    "\"\<B->aS|bA|b\>\""}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.820823429587946*^9, 3.8208234917398224`*^9}, {
   3.820823572517356*^9, 3.8208235845986457`*^9}, {3.8208236772089405`*^9, 
   3.820823699395233*^9}, {3.8208237316601486`*^9, 3.8208237557800984`*^9}, {
   3.8208238086285315`*^9, 3.82082383725289*^9}, {3.820823959792466*^9, 
   3.8208239644928865`*^9}, {3.8208240045015917`*^9, 3.820824011158896*^9}, {
   3.8208241161432004`*^9, 3.8208241340992985`*^9}, {3.8208241652902756`*^9, 
   3.8208241803417063`*^9}, {3.8208242621176414`*^9, 3.820824287015196*^9}, {
   3.82082451843407*^9, 3.820824567479201*^9}, {3.820824682207261*^9, 
   3.820824693303362*^9}, {3.820825561183046*^9, 3.820825637074468*^9}, 
   3.8208256725816145`*^9, {3.8208336505358047`*^9, 3.8208336628884068`*^9}, {
   3.8208372859237485`*^9, 3.8208373251384196`*^9}, 3.820839182628265*^9, {
   3.8208634758711815`*^9, 3.82086357473053*^9}, {3.8208639469427447`*^9, 
   3.82086396034756*^9}, 3.8208643455162973`*^9, 3.8208644296414437`*^9},
 CellLabel->"In[24]:=",ExpressionUUID->"e2de7402-a111-4019-bb3c-af00c70bdc59"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"EA\"\>", 
     ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm["Estados: ", {"A", "B", "EA", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8208636059016924`*^9, 3.8208639793895106`*^9, 3.8208644434440985`*^9, 
   3.820866530427471*^9, 3.8208665980857067`*^9, {3.8208688387015505`*^9, 
   3.820868841695792*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[24]:=",ExpressionUUID->"e4b1f304-8abf-44d9-86c5-540f1db2c1e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos de entrada: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}]}],
  SequenceForm["S\[IAcute]mbolos de entrada: ", {"a", "b"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8208636059016924`*^9, 3.8208639793895106`*^9, 3.8208644434440985`*^9, 
   3.820866530427471*^9, 3.8208665980857067`*^9, {3.8208688387015505`*^9, 
   3.820868841697787*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[24]:=",ExpressionUUID->"ee7b119e-cdfc-4cf7-a639-695d2a86e941"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", "\<\"S\"\>"}],
  SequenceForm["Estado inicial: ", "S"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8208636059016924`*^9, 3.8208639793895106`*^9, 3.8208644434440985`*^9, 
   3.820866530427471*^9, 3.8208665980857067`*^9, {3.8208688387015505`*^9, 
   3.8208688416997814`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[24]:=",ExpressionUUID->"44b034e1-92cf-4c34-9639-a8b1db00ff09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"EA\"\>", "}"}]}],
  SequenceForm["Estados aceptados: ", {"EA"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8208636059016924`*^9, 3.8208639793895106`*^9, 3.8208644434440985`*^9, 
   3.820866530427471*^9, 3.8208665980857067`*^9, {3.8208688387015505`*^9, 
   3.820868841700783*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[24]:=",ExpressionUUID->"20600d26-177d-4a99-af16-81253b55755a"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "\<\"a\"\>", "\<\"b\"\>"},
     {"\<\"A\"\>", 
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}], 
      RowBox[{"{", "\<\"B\"\>", "}"}]},
     {"\<\"B\"\>", 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]},
     {"\<\"EA\"\>", 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {"\<\"S\"\>", 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.8208636059016924`*^9, 3.8208639793895106`*^9, 3.8208644434440985`*^9, 
   3.820866530427471*^9, 3.8208665980857067`*^9, {3.8208688387015505`*^9, 
   3.82086884170377*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[24]:=",ExpressionUUID->"19d5ce5c-6241-4954-af1c-84ed7f9907a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Funci\[OAcute]n de transici\[OAcute]n de estados con otro \
formato: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"A\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"A\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", "\<\"B\"\>", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"B\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "\<\"S\"\>", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"B\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"EA\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"EA\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "\<\"S\"\>", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Funci\[OAcute]n de transici\[OAcute]n de estados con otro formato: ", {{
    "A", "a", {"A", "EA"}}, {"A", "b", {"B"}}, {"B", "a", {"S"}}, {
    "B", "b", {"A", "EA"}}, {"EA", "a", {}}, {"EA", "b", {}}, {
    "S", "a", {"S"}}, {"S", "b", {"A", "EA"}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8208636059016924`*^9, 3.8208639793895106`*^9, 3.8208644434440985`*^9, 
   3.820866530427471*^9, 3.8208665980857067`*^9, {3.8208688387015505`*^9, 
   3.820868841707759*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[24]:=",ExpressionUUID->"353037a4-5284-4603-b798-db971bc22371"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
   InsetBox["\<\"A\"\>", {0.99999950000025, 0.500000249999875}], 
   PolygonBox[{{1.0210396681758105`, 0.10147907025061173`}, {
    1.0194109186772298`, 0.07244490074922978}, {1.0453696217925004`, 
    0.08555144705774861}}], 
   CircleBox[{0.7118758161132328, 0.28882321235377184}, 0.3760284737116068, {
    5.669954685114888, 6.717252236311485}], 
   InsetBox["\<\"b\"\>", {1.0863965017450563, 0.25518292288192723}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5875816011177202, 0.06496962421841512}, {0.5649516228080215,
     0.03750048124975942}, {0.6000555875939133, 0.031636916630797374`}}], 
   CircleBox[{0.38193901242210704, 0.5705129166357614}, 0.5635564495561942, {
    5.043031967407529, 6.090229518604127}], 
   InsetBox["\<\"a\"\>", {0.8069017881968377, 0.20037441412322987}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.052499473750263, 0.5909328719309301}, 
    0.03749998125000937, {-1.5707963267948966`, 3.665191429188092}], 
   PolygonBox[{{1.0726746437549575`, 0.5797256841324234}, {1.052499473750263, 
    0.5534328906809207}, {1.085357285818069, 0.5491070776569369}}], 
   InsetBox["\<\"a\"\>", {1.0849754101542113, 0.5721828813059254}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.99999950000025, 4.999997500476638*^-7}, 0.07499996250001874], 
   InsetBox["\<\"B\"\>", {0.99999950000025, 4.999997500476638*^-7}], 
   PolygonBox[{{0.9776308219968979, 0.4115997072543385}, {1.0024534299849182`,
     0.4250404434190509}, {1.0016821449551132`, 0.3968230662308866}}], 
   CircleBox[{1.296877452867319, 0.2298067246805492}, 0.35327285514559587, {
    2.5560606361640397`, 3.6032581873606384`}], 
   InsetBox["\<\"b\"\>", {0.9442819101974977, 0.2516720733421971}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5030114434675953, 0.39024431145082994`}, {
    0.5097854915932926, 0.42564143319597497`}, {0.5370532741825901, 
    0.40207637456009027`}}], 
   CircleBox[{1.058556484027321, 0.5998587699192768}, 0.5757614806080629, {
    3.4489972834896934`, 4.496194834686291}], 
   InsetBox["\<\"a\"\>", {0.670415532081105, 0.17459663432021588}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5874321879986137, -0.043417615940109656`}, {
    0.5724441507496048, -0.019410918677229667`}, {
    0.6007285790647257, -0.01843424629816045}}], 
   CircleBox[{0.7499996250001875, 0.2881241838867672}, 0.35511094850116554, {
    4.188790204786391, 5.235887755982988}], 
   InsetBox["\<\"b\"\>", {0.7499818694527698, -0.06698676417050964}, 
    ImageScaled[{Rational[1, 2], 0}]], 
   CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 0.07499996250001874],
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
    0.04999997500001249], 
   InsetBox["\<\"EA\"\>", {0.499999750000125, 4.999997500476638*^-7}], 
   CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
   InsetBox["\<\"S\"\>", {0.499999750000125, 0.500000249999875}], 
   PolygonBox[{{0.520487409389604, 0.10123130943829815`}, {0.5194111686771047,
     0.07244490074922978}, {0.5448790502418087, 0.08590605329615243}}], 
   CircleBox[{0.2137904821675281, 0.27919753526995994}, 0.3689859833433345, {
    5.688305332978345, 6.735602884174942}], 
   InsetBox["\<\"b\"\>", {0.5818407652726356, 0.2529364421834621}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702, 
    0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
   CircleBox[{0.7499996250001875, 0.21187656611285788}, 0.35511094850116554, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"b\"\>", {0.7499996250001875, 0.5669875146140234}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.39522444379725274, 0.49313554424488215}, 
    0.03749998125000937, {0.5890236225480865, 5.825011378531075}], 
   PolygonBox[{{0.39333473102646943`, 0.5161370122135414}, {
    0.42640505950563995`, 0.5139686380572983}, {0.4117477623702709, 
    0.5436925697098776}}], 
   InsetBox["\<\"a\"\>", {0.39277276317046955, 0.5305552964601936}, 
    ImageScaled[{1, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{
  3.8208636059016924`*^9, 3.8208639793895106`*^9, 3.8208644434440985`*^9, 
   3.820866530427471*^9, 3.8208665980857067`*^9, {3.8208688387015505`*^9, 
   3.820868841711748*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[24]:=",ExpressionUUID->"fbceabf6-0005-4806-8821-bf29076c0bde"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegularToAutomata", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<S->aS|bA|b\>\"", ",", "\"\<A->aA|a|bB\>\"", ",", 
     "\"\<B->aS|bA|b\>\""}], "}"}], ",", 
   RowBox[{"dfa", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"colores", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.8208635835498953`*^9, {3.8208636543467383`*^9, 3.820863654723714*^9}, {
   3.820863932389079*^9, 3.8208639349885187`*^9}, 3.820863985464383*^9, {
   3.820864449114592*^9, 3.8208644574301014`*^9}, {3.820866521873576*^9, 
   3.8208665277670035`*^9}, {3.8208665821147585`*^9, 
   3.8208665897983727`*^9}, {3.8208680486138086`*^9, 3.8208680984595757`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"75628cb3-3ec0-49d7-b5d9-25f781011f8a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"EA\"\>", 
     ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm["Estados: ", {"A", "B", "EA", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447335577`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"7f8aff67-f325-4337-8c81-a763dc0e95c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos de entrada: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}]}],
  SequenceForm["S\[IAcute]mbolos de entrada: ", {"a", "b"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447365503`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"c0022ac7-70a6-4579-8ac3-479b893c9325"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", "\<\"S\"\>"}],
  SequenceForm["Estado inicial: ", "S"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844739541*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"0b2ec10d-72bd-433c-abde-071bff2930b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"EA\"\>", "}"}]}],
  SequenceForm["Estados aceptados: ", {"EA"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844741536*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"522fd95b-5d74-4944-9230-123c57458a91"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "\<\"a\"\>", "\<\"b\"\>"},
     {"\<\"A\"\>", 
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}], 
      RowBox[{"{", "\<\"B\"\>", "}"}]},
     {"\<\"B\"\>", 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]},
     {"\<\"EA\"\>", 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {"\<\"S\"\>", 
      RowBox[{"{", "\<\"S\"\>", "}"}], 
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447435303`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"887050ff-9c7f-4bf8-baf7-f63483646493"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Funci\[OAcute]n de transici\[OAcute]n de estados con otro \
formato: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"A\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"A\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", "\<\"B\"\>", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"B\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "\<\"S\"\>", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"B\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"EA\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"EA\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "\<\"S\"\>", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Funci\[OAcute]n de transici\[OAcute]n de estados con otro formato: ", {{
    "A", "a", {"A", "EA"}}, {"A", "b", {"B"}}, {"B", "a", {"S"}}, {
    "B", "b", {"A", "EA"}}, {"EA", "a", {}}, {"EA", "b", {}}, {
    "S", "a", {"S"}}, {"S", "b", {"A", "EA"}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844746522*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"d765b1f4-f207-46c4-8a59-681b7a6f4df9"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del aut\[OAcute]mata no \
determin\[IAcute]stico: \"\>"], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447475257`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"3663a701-57e9-40e1-9f92-c6ec5a6cb346"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0., 0.8, 0.8], 
    CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
    InsetBox["\<\"A\"\>", {0.99999950000025, 0.500000249999875}], 
    PolygonBox[{{1.0210396681758105`, 0.10147907025061173`}, {
     1.0194109186772298`, 0.07244490074922978}, {1.0453696217925004`, 
     0.08555144705774861}}], 
    CircleBox[{0.7118758161132328, 0.28882321235377184}, 0.3760284737116068, {
     5.669954685114888, 6.717252236311485}], 
    InsetBox["\<\"b\"\>", {1.0863965017450563, 0.25518292288192723}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.5875816011177202, 0.06496962421841512}, {
     0.5649516228080215, 0.03750048124975942}, {0.6000555875939133, 
     0.031636916630797374`}}], 
    CircleBox[{0.38193901242210704, 0.5705129166357614}, 0.5635564495561942, {
     5.043031967407529, 6.090229518604127}], 
    InsetBox["\<\"a\"\>", {0.8069017881968377, 0.20037441412322987}, 
     ImageScaled[{1, 1}]], 
    CircleBox[{1.052499473750263, 0.5909328719309301}, 
     0.03749998125000937, {-1.5707963267948966`, 3.665191429188092}], 
    PolygonBox[{{1.0726746437549575`, 0.5797256841324234}, {1.052499473750263,
      0.5534328906809207}, {1.085357285818069, 0.5491070776569369}}], 
    InsetBox["\<\"a\"\>", {1.0849754101542113, 0.5721828813059254}, 
     ImageScaled[{0, 1}]]}, 
   {Hue[0.25, 0.8, 0.8], 
    CircleBox[{0.99999950000025, 4.999997500476638*^-7}, 0.07499996250001874],
     InsetBox["\<\"B\"\>", {0.99999950000025, 4.999997500476638*^-7}], 
    PolygonBox[{{0.9776308219968979, 0.4115997072543385}, {
     1.0024534299849182`, 0.4250404434190509}, {1.0016821449551132`, 
     0.3968230662308866}}], 
    CircleBox[{1.296877452867319, 0.2298067246805492}, 0.35327285514559587, {
     2.5560606361640397`, 3.6032581873606384`}], 
    InsetBox["\<\"b\"\>", {0.9442819101974977, 0.2516720733421971}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.5030114434675953, 0.39024431145082994`}, {
     0.5097854915932926, 0.42564143319597497`}, {0.5370532741825901, 
     0.40207637456009027`}}], 
    CircleBox[{1.058556484027321, 0.5998587699192768}, 0.5757614806080629, {
     3.4489972834896934`, 4.496194834686291}], 
    InsetBox["\<\"a\"\>", {0.670415532081105, 0.17459663432021588}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.5874321879986137, -0.043417615940109656`}, {
     0.5724441507496048, -0.019410918677229667`}, {
     0.6007285790647257, -0.01843424629816045}}], 
    CircleBox[{0.7499996250001875, 0.2881241838867672}, 0.35511094850116554, {
     4.188790204786391, 5.235887755982988}], 
    InsetBox["\<\"b\"\>", {0.7499818694527698, -0.06698676417050964}, 
     ImageScaled[{Rational[1, 2], 0}]]}, 
   {Hue[0.5, 0.8, 0.8], 
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
     0.07499996250001874], 
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
     0.04999997500001249], 
    InsetBox["\<\"EA\"\>", {0.499999750000125, 4.999997500476638*^-7}]}, 
   {Hue[0.75, 0.8, 0.8], 
    CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
    InsetBox["\<\"S\"\>", {0.499999750000125, 0.500000249999875}], 
    PolygonBox[{{0.520487409389604, 0.10123130943829815`}, {
     0.5194111686771047, 0.07244490074922978}, {0.5448790502418087, 
     0.08590605329615243}}], 
    CircleBox[{0.2137904821675281, 0.27919753526995994}, 0.3689859833433345, {
     5.688305332978345, 6.735602884174942}], 
    InsetBox["\<\"b\"\>", {0.5818407652726356, 0.2529364421834621}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702,
      0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
    CircleBox[{0.7499996250001875, 0.21187656611285788}, 
     0.35511094850116554, {1.0471975511965979`, 2.0943951023931953`}], 
    InsetBox["\<\"b\"\>", {0.7499996250001875, 0.5669875146140234}, 
     ImageScaled[{Rational[1, 2], 1}]], 
    CircleBox[{0.39522444379725274, 0.49313554424488215}, 
     0.03749998125000937, {0.5890236225480865, 5.825011378531075}], 
    PolygonBox[{{0.39333473102646943`, 0.5161370122135414}, {
     0.42640505950563995`, 0.5139686380572983}, {0.4117477623702709, 
     0.5436925697098776}}], 
    InsetBox["\<\"a\"\>", {0.39277276317046955, 0.5305552964601936}, 
     ImageScaled[{1, 0}]]}, 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844750513*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"139bd199-1d62-458a-9778-bd0cc2a3baa8"],

Cell[BoxData["\<\"Estados del nuevo aut\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844752508*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"7a55336c-8a85-434b-8be1-96861d0aef21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "0"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 0], "=", {}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844753505*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"15fe3257-69c2-43c8-b993-0c074865f9b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "1"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"A\"\>", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 1], "=", {"A"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844754503*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"15ab3e83-4924-490b-bac6-074be045db51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "2"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"B\"\>", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 2], "=", {"B"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447555*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"c9155daf-019b-4a42-b04b-b2bfc78a291f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "3"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"EA\"\>", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 3], "=", {"EA"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447564974`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"ebb2dc6e-b1e8-4cfb-8e29-6e7801e03351"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "4"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"S\"\>", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 4], "=", {"S"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844757495*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"7ad37f4b-f874-4bce-9fe0-53ccfde950bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "5"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 5], "=", {"A", "B"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447584925`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"a9e72c77-aec7-4252-8815-ba1cfb3e928f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "6"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 6], "=", {"A", "EA"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844759489*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"aaf4d8c2-fb44-4603-b66d-025c826e206c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "7"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 7], "=", {"A", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447604866`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"c3d49857-58f9-4715-8928-8f3fc67a98f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "8"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"B\"\>", ",", "\<\"EA\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 8], "=", {"B", "EA"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844761485*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"95354f9b-bd68-4262-ac71-c5cda1abdcf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "9"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"B\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 9], "=", {"B", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447624817`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"a6c73adf-7044-46d2-a443-09de9f79e7f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "10"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"EA\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 10], "=", {"EA", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844763479*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"41ca35f3-7536-4d7b-9499-af28b638b015"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "11"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"EA\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 11], "=", {"A", "B", "EA"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844764477*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"0a5e14ee-9fa1-4689-8ce1-4b07426867f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "12"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 12], "=", {"A", "B", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447664757`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"ccf49cd9-292c-4629-91fb-7bb55edd81a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "13"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 13], "=", {"A", "EA", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844767473*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"64585b5f-ad7d-40f5-b87e-f53937581458"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "14"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"B\"\>", ",", "\<\"EA\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 14], "=", {"B", "EA", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844768474*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"6368b724-34a8-4de2-8f70-324c9d21511e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "15"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"EA\"\>", 
     ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 15], "=", {"A", "B", "EA", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844770466*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"ac2094cf-e3fc-493e-b8dd-1c4e1c998fd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", 
   SubscriptBox["\[Mu]", "4"]}],
  SequenceForm["Estado inicial: ", 
   Subscript[$CellContext`\[Mu], 4]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447714624`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"16ec2843-fdfd-4e61-b0eb-6ede5a79456a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Mu]", "3"], ",", 
     SubscriptBox["\[Mu]", "6"], ",", 
     SubscriptBox["\[Mu]", "8"], ",", 
     SubscriptBox["\[Mu]", "10"], ",", 
     SubscriptBox["\[Mu]", "11"], ",", 
     SubscriptBox["\[Mu]", "13"], ",", 
     SubscriptBox["\[Mu]", "14"], ",", 
     SubscriptBox["\[Mu]", "15"]}], "}"}]}],
  SequenceForm["Estados aceptados: ", {
    Subscript[$CellContext`\[Mu], 3], 
    Subscript[$CellContext`\[Mu], 6], 
    Subscript[$CellContext`\[Mu], 8], 
    Subscript[$CellContext`\[Mu], 10], 
    Subscript[$CellContext`\[Mu], 11], 
    Subscript[$CellContext`\[Mu], 13], 
    Subscript[$CellContext`\[Mu], 14], 
    Subscript[$CellContext`\[Mu], 15]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844773457*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"918ab65f-4f5e-4a23-9114-bdbedcb279b6"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "\<\"a\"\>", "\<\"b\"\>"},
     {
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "6"], 
      SubscriptBox["\[Mu]", "2"]},
     {
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "6"]},
     {
      SubscriptBox["\[Mu]", "3"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "6"]},
     {
      SubscriptBox["\[Mu]", "5"], 
      SubscriptBox["\[Mu]", "13"], 
      SubscriptBox["\[Mu]", "11"]},
     {
      SubscriptBox["\[Mu]", "6"], 
      SubscriptBox["\[Mu]", "6"], 
      SubscriptBox["\[Mu]", "2"]},
     {
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "13"], 
      SubscriptBox["\[Mu]", "11"]},
     {
      SubscriptBox["\[Mu]", "8"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "6"]},
     {
      SubscriptBox["\[Mu]", "9"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "6"]},
     {
      SubscriptBox["\[Mu]", "10"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "6"]},
     {
      SubscriptBox["\[Mu]", "11"], 
      SubscriptBox["\[Mu]", "13"], 
      SubscriptBox["\[Mu]", "11"]},
     {
      SubscriptBox["\[Mu]", "12"], 
      SubscriptBox["\[Mu]", "13"], 
      SubscriptBox["\[Mu]", "11"]},
     {
      SubscriptBox["\[Mu]", "13"], 
      SubscriptBox["\[Mu]", "13"], 
      SubscriptBox["\[Mu]", "11"]},
     {
      SubscriptBox["\[Mu]", "14"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "6"]},
     {
      SubscriptBox["\[Mu]", "15"], 
      SubscriptBox["\[Mu]", "13"], 
      SubscriptBox["\[Mu]", "11"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447754507`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"7b6c995e-63eb-488f-92f6-8801b48cd8eb"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del nuevo aut\[OAcute]mata: \
\"\>"], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688447764482`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"d80a6303-67e4-4a46-9836-474e6ad9dc7b"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0., 0.8, 0.8], 
    CircleBox[{0.7499998125000469, 0.7500000624999844}, 0.03749999062500234], 
    InsetBox[
     SubscriptBox["\[Mu]", "0"], {0.7499998125000469, 0.7500000624999844}], 
    CircleBox[{0.7954661348321493, 0.7762500559374861}, 
     0.01874999531250117, {-2.094395102393195, 3.1415926535897936`}], 
    PolygonBox[{{0.7992375371882484, 0.749924496151778}, {0.7860911371758987, 
     0.7600120836760209}, {0.8014004442409669, 0.7663534062929064}}], 
    InsetBox["\<\"b,a\"\>", {0.8048411324884, 0.7600120836760209}, 
     ImageScaled[{0, 1}]]}, 
   {Hue[0.0625, 0.8, 0.8], 
    CircleBox[{0.49999987500003124, 0.5000001249999688}, 0.03749999062500234],
     InsetBox[
     SubscriptBox["\[Mu]", "1"], {0.49999987500003124, 0.5000001249999688}], 
    PolygonBox[{{0.4695024697007585, 0.7093558814714138}, {0.4812498796875301,
      0.7175241179770541}, {0.4824500750121482, 0.7032664442470187}}], 
    CircleBox[{0.6427839717642766, 0.6347058055148933}, 0.18152723151675876, {
     2.667837802340456, 3.7150353535370533`}], 
    InsetBox["\<\"a\"\>", {0.4614821882174791, 0.6256615219673086}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.2937161674283121, 0.4782910616027759}, {
     0.28622214693030334`, 0.49029441323505224`}, {0.3003643646234164, 
     0.4907827495466709}}], 
    CircleBox[{0.37499990625002344, 0.6440620029589289}, 
     0.17755551863944025, {4.188790204786391, 5.235887755982988}], 
    InsetBox["\<\"b\"\>", {0.37499102847409516, 0.46650648454143306}, 
     ImageScaled[{Rational[1, 2], 0}]]}, 
   {Hue[0.125, 0.8, 0.8], 
    CircleBox[{0.24999993750001562, 0.5000001249999688}, 0.03749999062500234],
     InsetBox[
     SubscriptBox["\[Mu]", "2"], {0.24999993750001562, 0.5000001249999688}], 
    PolygonBox[{{0.44958010554006633`, 0.7363887125866737}, {
     0.4669273939309825, 0.7323235160948556}, {0.45473318630223447`, 
     0.7193329219074565}}], 
    CircleBox[{0.5409116289845176, 0.4607730770227828}, 0.2814485885498309, {
     1.8367913707502308`, 2.8839889219468264`}], 
    InsetBox["\<\"b\"\>", {0.3410641824125612, 0.6589505381412486}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.22829087410282267`, 0.7062838325716881}, {
     0.24029422573509904`, 0.7137778530696968}, {0.24078256204671766`, 
     0.6996356353765837}}], 
    CircleBox[{0.3940618154589757, 0.6250000937499767}, 0.17755551863944025, {
     2.6179938779914944`, 3.665191429188092}], 
    InsetBox["\<\"a\"\>", {0.21650629681953543, 0.6250000937499767}, 
     ImageScaled[{0, Rational[1, 2]}]]}, 
   {Hue[0.1875, 0.8, 0.8], 
    CircleBox[{0.24999993750001562, 0.2500001874999531}, 0.03749999062500234],
     CircleBox[{0.24999993750001562, 0.2500001874999531}, 
     0.02499999375000156], InsetBox[
     SubscriptBox["\[Mu]", "3"], {0.24999993750001562, 0.2500001874999531}], 
    PolygonBox[{{0.6915561615988126, 0.7377023855551673}, {0.7175238679771165,
      0.7312500671874832}, {0.6989521431682453, 0.7119875329696989}}], 
    CircleBox[{0.8817865288036708, 0.11821347119632919}, 0.6346621855493212, {
     1.8325957145940461`, 2.8797932657906435`}], 
    InsetBox["\<\"b,a\"\>", {0.43301259363907096, 0.566987406360929}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.25, 0.8, 0.8], 
    CircleBox[{0.24999993750001562, 0.7500000624999844}, 0.03749999062500234],
     InsetBox[
     SubscriptBox["\[Mu]", "4"], {0.24999993750001562, 0.7500000624999844}], 
    PolygonBox[{{0.44963544787663046`, 0.7592174379532824}, {
     0.46377766556974354`, 0.759705774264901}, {0.4562836450717349, 
     0.7717091258971774}}], 
    CircleBox[{0.37499990625002344, 0.6059381845410244}, 
     0.17755551863944025, {1.0471975511965976`, 2.0943951023931957`}], 
    InsetBox["\<\"b\"\>", {0.37499990625002344, 0.7834937031804647}, 
     ImageScaled[{Rational[1, 2], 1}]], 
    CircleBox[{0.19890498149198446, 0.7620646425760946}, 
     0.01874999531250117, {0.29172497109789575`, 5.527712727080884}], 
    PolygonBox[{{0.20137058235048413`, 0.7733376419442178}, {
     0.2168627743299339, 0.7674572301375634}, {0.2142092643494857, 
     0.7838140678553996}}], 
    InsetBox["\<\"a\"\>", {0.20321376009059525, 0.7803128411503915}, 
     ImageScaled[{0, 0}]]}, 
   {Hue[0.3125, 0.8, 0.8], 
    CircleBox[{0.9999997500000625, 0.7500000624999844}, 0.03749999062500234], 
    InsetBox[
     SubscriptBox["\[Mu]", "5"], {0.9999997500000625, 0.7500000624999844}], 
    PolygonBox[{{0.553043626245265, 0.2831895466621689}, {0.5349733983487135, 
     0.26353170483743016`}, {0.5610327027007892, 0.2577113493392117}}], 
    CircleBox[{0.35589833006623833, 0.8732683081976833}, 0.6354892647068652, {
     4.997949080671571, 6.045146631868168}], 
    InsetBox["\<\"a\"\>", {0.8158063367783366, 0.43471246121833146}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.7951878111561382, 0.531347129615243}, {0.7824757570229772, 
     0.51875012031247}, {0.7997411141574681, 0.5140396631502562}}], 
    CircleBox[{0.7174859266188206, 0.7962398975916398}, 0.2849986921906911, {
     4.942348565399166, 5.989546116595763}], 
    InsetBox["\<\"b\"\>", {0.9124928765728222, 0.5884021146453193}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.375, 0.8, 0.8], 
    CircleBox[{0.49999987500003124, 0.7500000624999844}, 0.03749999062500234],
     CircleBox[{0.49999987500003124, 0.7500000624999844}, 
     0.02499999375000156], InsetBox[
     SubscriptBox["\[Mu]", "6"], {0.49999987500003124, 0.7500000624999844}], 
    PolygonBox[{{0.29455611614010524`, 0.5317617454926418}, {
     0.28247588202294593`, 0.51875012031247}, {0.2997843970320756, 
     0.5147941432734324}}], 
    CircleBox[{0.20725476442128285, 0.7889770936524395}, 0.2805010403790398, {
     4.983778797533246, 6.030976348729843}], 
    InsetBox["\<\"b\"\>", {0.4074920075476226, 0.5925442040466334}, 
     ImageScaled[{1, 1}]], 
    CircleBox[{0.5120644550761414, 0.8010950185080156}, 
     0.01874999531250117, {-1.279071355697, 3.9569164002859885`}], 
    PolygonBox[{{0.5233374544442646, 0.7986294176495159}, {0.5174570426376102,
      0.7831372256700662}, {0.5338138803554464, 0.7857907356505143}}], 
    InsetBox["\<\"a\"\>", {0.5303126536504382, 0.7967862399094048}, 
     ImageScaled[{0, 1}]]}, 
   {Hue[0.4375, 0.8, 0.8], 
    CircleBox[{0.24999993750001562, 2.499999375293882*^-7}, 
     0.03749999062500234], InsetBox[
     SubscriptBox["\[Mu]", 
      "7"], {0.24999993750001562, 2.499999375293882*^-7}], 
    PolygonBox[{{0.45010561010853345`, 0.23477458221005396`}, {
     0.4675239304771009, 0.23125019218745196`}, {0.4557625590003994, 
     0.2179276792683176}}], 
    CircleBox[{0.5493245467817119, -0.03653387332680125}, 
     0.27999936887635324, {1.86726599438774, 2.9144635455843377`}], 
    InsetBox["\<\"a\"\>", {0.34459110225956857, 0.15447362198491305}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.6861823253537799, 0.5062108213017695}, {0.7124998218750446,
      0.5000001249999688}, {0.6939624528418628, 0.48031385259944526`}}], 
    CircleBox[{0.8877459756612301, -0.12401996395081649}, 
     0.6481606944508418, {1.844578373030742, 2.891775924227339}], 
    InsetBox["\<\"b\"\>", {0.4239683100914865, 0.3287742086592962}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.5, 0.8, 0.8], 
    CircleBox[{0.9999997500000625, 0.5000001249999688}, 0.03749999062500234], 
    CircleBox[{0.9999997500000625, 0.5000001249999688}, 0.02499999375000156], 
    InsetBox[
     SubscriptBox["\[Mu]", "8"], {0.9999997500000625, 0.5000001249999688}], 
    PolygonBox[{{0.5380328323202487, 0.7191108437063016}, {0.5367377783029561,
      0.7424783766663295}, {0.5576221824787567, 0.731916159864564}}], 
    CircleBox[{0.9486103471365783, 0.9996073390494205}, 0.48554538022085264, {
     3.6996830548184456`, 4.746780606015045}], 
    InsetBox["\<\"b\"\>", {0.7204612900565261, 0.5710022480772116}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.2926161923946676, 0.7197031677132062}, {0.2874323332847054,
      0.7477494975278942}, {0.3143130969421232, 0.7382156862994169}}], 
    CircleBox[{0.8439226668971876, 1.2063308222406788}, 0.7210952244880446, {
     3.8308330178458547`, 4.8779305690424515`}], 
    InsetBox["\<\"a\"\>", {0.5912447942883267, 0.5309552115814519}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.5625, 0.8, 0.8], 
    CircleBox[{0.7499998125000469, 0.2500001874999531}, 0.03749999062500234], 
    InsetBox[
     SubscriptBox["\[Mu]", "9"], {0.7499998125000469, 0.2500001874999531}], 
    PolygonBox[{{0.5025039131900605, 0.696028988350102}, {0.5151469200977014, 
     0.7156953059539249}, {0.5258569472876847, 0.6949129819897742}}], 
    CircleBox[{0.9985679980013781, 0.6824580861022416}, 0.48456232968011653, {
     3.072946504071147, 4.120144055267744}], 
    InsetBox["\<\"b\"\>", {0.563294453886096, 0.46953182389312953}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.2673948606664533, 0.695547816102603}, {0.2742661249347249, 
     0.7214098291280999}, {0.29322765307367354`, 0.7025281332029119}}], 
    CircleBox[{0.8899641196175895, 0.875775836988411}, 0.6347541926125659, {
     3.3872461084179517`, 4.43444365961455}], 
    InsetBox["\<\"a\"\>", {0.4339370190932479, 0.43424195535916105}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.625, 0.8, 0.8], 
    CircleBox[{0.49999987500003124, 2.499999375293882*^-7}, 
     0.03749999062500234], 
    CircleBox[{0.49999987500003124, 2.499999375293882*^-7}, 
     0.02499999375000156], InsetBox[
     SubscriptBox["\[Mu]", 
      "10"], {0.49999987500003124, 2.499999375293882*^-7}], 
    PolygonBox[{{0.4762156201548383, 0.6984876033275674}, {
     0.49999987500003124`, 0.7125000718749821}, {0.5002429013092263, 
     0.6848960686952547}}], 
    CircleBox[{1.0819828071166653, 0.3695559765037388}, 0.6755107592222904, {
     2.609101478137609, 3.6562990293342064`}], 
    InsetBox["\<\"b\"\>", {0.406498755649084, 0.37556280911479184}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.21496405128861812`, 0.6943470332239503}, {
     0.23322607784412397`, 0.7164607284410065}, {0.24324608639588813`, 
     0.6895885019108243}}], 
    CircleBox[{0.950070181152133, 0.5832565420104715}, 0.7291150963531645, {
     2.95786784945651, 4.005065400653107}], 
    InsetBox["\<\"a\"\>", {0.262662883919053, 0.34019269969574895}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.6875, 0.8, 0.8], 
    CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.03749999062500234], 
    CircleBox[{0.7499998125000469, 0.5000001249999688}, 0.02499999375000156], 
    InsetBox[
     SubscriptBox["\[Mu]", "11"], {0.7499998125000469, 0.5000001249999688}], 
    PolygonBox[{{0.5378487841688878, 0.2903122783290639}, {0.5246196989580314,
      0.2782864662434066}, {0.5416489003307768, 0.27284264842480455`}}], 
    CircleBox[{0.4717519522317722, 0.5577472186715754}, 0.2844174938213723, {
     4.899257173107203, 5.946454724303802}], 
    InsetBox["\<\"a\"\>", {0.657245580600339, 0.342142430630367}, 
     ImageScaled[{1, 1}]], 
    CircleBox[{0.7364118160291636, 0.5507112182023716}, 
     0.01874999531250117, {-0.7853981633974478, 4.4505895925855405`}], 
    PolygonBox[{{0.7475071578091308, 0.5538818795108144}, {0.7496700648618492,
      0.537452969369686}, {0.7628164648741989, 0.5475405568939288}}], 
    InsetBox["\<\"b\"\>", {0.7545229207443075, 0.5555640740848299}, 
     ImageScaled[{0, 0}]]}, 
   {Hue[0.75, 0.8, 0.8], 
    CircleBox[{0.9999997500000625, 0.2500001874999531}, 0.03749999062500234], 
    InsetBox[
     SubscriptBox["\[Mu]", "12"], {0.9999997500000625, 0.2500001874999531}], 
    PolygonBox[{{0.777148753318, 0.4642331275021467}, {0.7824738818610694, 
     0.48124688218677075`}, {0.7945456613601757, 0.46812830824774304`}}], 
    CircleBox[{1.059026383547604, 0.5352564673194931}, 0.281777077625717, {
     3.3344610294735864`, 4.381658580670183}], 
    InsetBox["\<\"b\"\>", {0.8465296841732874, 0.3502065437034302}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.5484840125007943, 0.2285493621184872}, {0.5374153178869288,
      0.24748345738876215`}, {0.5593470726955944, 0.24760218047596416`}}], 
    CircleBox[{0.7568222699678233, 0.6131294826195273}, 0.4264228258293341, {
     4.17193059548987, 5.219028146685799}], 
    InsetBox["\<\"a\"\>", {0.7496119702119585, 0.18676761991871632}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.8125, 0.8, 0.8], 
    CircleBox[{0.49999987500003124, 0.2500001874999531}, 0.03749999062500234],
     CircleBox[{0.49999987500003124, 0.2500001874999531}, 
     0.02499999375000156], InsetBox[
     SubscriptBox["\[Mu]", "13"], {0.49999987500003124, 0.2500001874999531}], 
    PolygonBox[{{0.7037891710117078, 0.4817937581809877}, {0.7210119277459154,
      0.4762103827912677}, {0.7075652044524493, 0.4640867256311044}}], 
    CircleBox[{0.7739337325673604, 0.19045322823762967}, 0.2906163601797927, {
     1.7539200459041704`, 2.8011175971007685`}], 
    InsetBox["\<\"b\"\>", {0.585223527901048, 0.41146528098351387}, 
     ImageScaled[{1, 1}]], 
    CircleBox[{0.45453355266792883, 0.2762501809374548}, 
     0.01874999531250117, {0., 5.235987755982988}], 
    PolygonBox[{{0.46013714796808036`, 0.2863377684616976}, {0.47328354798043,
      0.2762501809374548}, {0.4754464550331484, 0.2926790910785831}}], 
    InsetBox["\<\"a\"\>", {0.46390855032417944, 0.29248815319891996}, 
     ImageScaled[{0, 0}]]}, 
   {Hue[0.875, 0.8, 0.8], 
    CircleBox[{0.7499998125000469, 2.499999375293882*^-7}, 
     0.03749999062500234], 
    CircleBox[{0.7499998125000469, 2.499999375293882*^-7}, 
     0.02499999375000156], InsetBox[
     SubscriptBox["\[Mu]", 
      "14"], {0.7499998125000469, 2.499999375293882*^-7}], 
    PolygonBox[{{0.4777548619445659, 0.690810582626917}, {0.4959652225738524, 
     0.7127177493116214}, {0.5058322051331032, 0.685993531052231}}], 
    CircleBox[{1.2028025035513052, 0.57893446169869}, 0.7193864815411277, {
     2.9545350995469706`, 4.001732650743568}], 
    InsetBox["\<\"b\"\>", {0.5237718180764459, 0.34137554688456223}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.24359828387807328`, 0.6854170725858236}, {
     0.2567199555855263, 0.7131071003824522}, {0.2741393872351774, 
     0.6878983854453641}}], 
    CircleBox[{1.0872417182499283, 0.7672708873422561}, 0.8322860770654601, {
     3.2067170066379047`, 4.253914557834502}], 
    InsetBox["\<\"a\"\>", {0.3950706668666274, 0.3051027905376965}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.9375, 0.8, 0.8], 
    CircleBox[{0.9999997500000625, 2.499999375293882*^-7}, 
     0.03749999062500234], 
    CircleBox[{0.9999997500000625, 2.499999375293882*^-7}, 
     0.02499999375000156], InsetBox[
     SubscriptBox["\[Mu]", 
      "15"], {0.9999997500000625, 2.499999375293882*^-7}], 
    PolygonBox[{{0.7470402381923367, 0.4440024760084053}, {0.7596173025514237,
      0.46375439170642196`}, {0.7704344311397713, 0.4429863766174124}}], 
    CircleBox[{1.244692738815989, 0.43253661496185625}, 0.48607893232697574, {
     3.0773247432591413`, 4.1245222944557405`}], 
    InsetBox["\<\"b\"\>", {0.8089961998867726, 0.21703428454003798}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.5145578590505829, 0.19091071809377808`}, {
     0.511854855640263, 0.2144233870410165}, {0.533568925964505, 
     0.20500792218725034`}}], 
    CircleBox[{0.9167430696300689, 0.5019000949864669}, 0.49656552783999025, {
     3.75900852242814, 4.806106073624736}], 
    InsetBox["\<\"a\"\>", {0.7098153745413991, 0.050504201734990095}, 
     ImageScaled[{1, 1}]]}, 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.24999993750001562`, 0.8250000437499891}, {
     0.24999993750001562`, 0.7875000531249867}}], 
    PolygonBox[{{0.24999993750001562`, 0.7875000531249867}, {
     0.23749994062501484`, 0.8062500484374879}, {0.2624999343750164, 
     0.8062500484374879}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.820868844804373*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"d044878d-bc61-4420-a73c-b1842b1f5f93"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n reducido del nuevo aut\
\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.8208688448073654`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"0dd81fdf-07fc-4c12-976b-93669b82767e"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0., 0.8, 0.8], 
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
     0.07499996250001874], InsetBox[
     SubscriptBox["\[Mu]", "2"], {0.499999750000125, 4.999997500476638*^-7}], 
    PolygonBox[{{0.9004082684806661, 0.4707705833509121}, {0.9350476271923535,
      0.46250026874986566`}, {0.9105656452947143, 0.43663686143526587`}}], 
    CircleBox[{1.0805602563282581, -0.08056025632825814}, 
     0.5622176261343743, {1.832595714594046, 2.879793265790644}], 
    InsetBox["\<\"b\"\>", {0.683012360386039, 0.3169876396139611}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.45658163406026536`, 0.4125678120013864}, {
     0.48058833132314527`, 0.4275558492503953}, {0.4815650037022145, 
     0.3992714209352745}}], 
    CircleBox[{0.7881234338871422, 0.25000037499981254}, 
     0.35511094850116565, {2.6179938779914944`, 3.665191429188092}], 
    InsetBox["\<\"a\"\>", {0.4330124853859766, 0.2500003749998126}, 
     ImageScaled[{0, Rational[1, 2]}]]}, 
   {Hue[0.3333333333333333, 0.8, 0.8], 
    CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
    InsetBox[
     SubscriptBox["\[Mu]", "4"], {0.499999750000125, 0.500000249999875}], 
    PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702,
      0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
    CircleBox[{0.7499996250001875, 0.21187656611285788}, 
     0.35511094850116554, {1.0471975511965979`, 2.0943951023931953`}], 
    InsetBox["\<\"b\"\>", {0.7499996250001875, 0.5669875146140234}, 
     ImageScaled[{Rational[1, 2], 1}]], 
    CircleBox[{0.3958980916067041, 0.5137054933303588}, 0.03749998125000937, {
     0.3926990816987246, 5.6286868376817125`}], 
    PolygonBox[{{0.398531479724809, 0.5366337250565242}, {
     0.43054355675314476`, 0.5280561148687388}, {0.4219659465653593, 
     0.5600681918970746}}], 
    InsetBox["\<\"a\"\>", {0.40079282136759115, 0.5508846570422947}, 
     ImageScaled[{0, 0}]]}, 
   {Hue[0.6666666666666666, 0.8, 0.8], 
    CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
    CircleBox[{0.99999950000025, 0.500000249999875}, 0.04999997500001249], 
    InsetBox[
     SubscriptBox["\[Mu]", "6"], {0.99999950000025, 0.500000249999875}], 
    PolygonBox[{{0.5893902837518628, 0.06331553765522902}, {
     0.5649516228080215, 0.03750048124975942}, {0.599527447927207, 
     0.029243508240653027`}}], 
    CircleBox[{0.41943899367211673, 0.5805610063278832}, 0.5622176261343743, {
     4.974088368183839, 6.021285919380437}], 
    InsetBox["\<\"b\"\>", {0.8169471328370685, 0.18297335758387556}, 
     ImageScaled[{1, 1}]], 
    CircleBox[{1.097006802410284, 0.5401819903073393}, 
     0.03749998125000937, {-2.2252947962927703`, 3.010692959690218}], 
    PolygonBox[{{1.0976127270772782`, 0.48699678808123537`}, {
     1.074178260236728, 0.5104312549217856}, {1.1061903372650637`, 
     0.519008865109571}}], 
    InsetBox["\<\"a\"\>", {1.111357423948664, 0.5055365251608985}, 
     ImageScaled[{0, 1}]]}, 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{
  3.820863616082121*^9, 3.820863655441786*^9, 3.820863937489653*^9, 
   3.8208639864475703`*^9, 3.820864459386325*^9, 3.820866534125414*^9, {
   3.820866590474106*^9, 3.820866601428533*^9}, 3.8208680991347723`*^9, 
   3.82086884480936*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"532ea30d-c01d-4319-9a3e-eef737e73eab"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{949, 467},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a8572f35-c064-47f4-a398-4a1b85c180ca"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 42, "Input",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],
Cell[CellGroupData[{
Cell[785, 27, 1244, 19, 42, "Input",ExpressionUUID->"e2de7402-a111-4019-bb3c-af00c70bdc59"],
Cell[CellGroupData[{
Cell[2054, 50, 596, 14, 33, "Print",ExpressionUUID->"e4b1f304-8abf-44d9-86c5-540f1db2c1e9"],
Cell[2653, 66, 582, 13, 33, "Print",ExpressionUUID->"ee7b119e-cdfc-4cf7-a639-695d2a86e941"],
Cell[3238, 81, 494, 11, 33, "Print",ExpressionUUID->"44b034e1-92cf-4c34-9639-a8b1db00ff09"],
Cell[3735, 94, 526, 12, 33, "Print",ExpressionUUID->"20600d26-177d-4a99-af16-81253b55755a"],
Cell[4264, 108, 1292, 36, 123, "Print",ExpressionUUID->"19d5ce5c-6241-4954-af1c-84ed7f9907a9"],
Cell[5559, 146, 1888, 45, 86, "Print",ExpressionUUID->"353037a4-5284-4603-b798-db971bc22371"],
Cell[7450, 193, 4755, 83, 545, "Print",ExpressionUUID->"fbceabf6-0005-4806-8821-bf29076c0bde"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12254, 282, 759, 15, 94, "Input",ExpressionUUID->"75628cb3-3ec0-49d7-b5d9-25f781011f8a"],
Cell[CellGroupData[{
Cell[13038, 301, 662, 15, 33, "Print",ExpressionUUID->"7f8aff67-f325-4337-8c81-a763dc0e95c8"],
Cell[13703, 318, 648, 14, 33, "Print",ExpressionUUID->"c0022ac7-70a6-4579-8ac3-479b893c9325"],
Cell[14354, 334, 556, 12, 33, "Print",ExpressionUUID->"0b2ec10d-72bd-433c-abde-071bff2930b8"],
Cell[14913, 348, 590, 13, 33, "Print",ExpressionUUID->"522fd95b-5d74-4944-9230-123c57458a91"],
Cell[15506, 363, 1359, 37, 123, "Print",ExpressionUUID->"887050ff-9c7f-4bf8-baf7-f63483646493"],
Cell[16868, 402, 1952, 46, 86, "Print",ExpressionUUID->"d765b1f4-f207-46c4-8a59-681b7a6f4df9"],
Cell[18823, 450, 495, 9, 33, "Print",ExpressionUUID->"3663a701-57e9-40e1-9f92-c6ec5a6cb346"],
Cell[19321, 461, 5016, 92, 545, "Print",ExpressionUUID->"139bd199-1d62-458a-9778-bd0cc2a3baa8"],
Cell[24340, 555, 448, 8, 33, "Print",ExpressionUUID->"7a55336c-8a85-434b-8be1-96861d0aef21"],
Cell[24791, 565, 631, 16, 33, "Print",ExpressionUUID->"15fe3257-69c2-43c8-b993-0c074865f9b3"],
Cell[25425, 583, 647, 16, 33, "Print",ExpressionUUID->"15ab3e83-4924-490b-bac6-074be045db51"],
Cell[26075, 601, 645, 16, 33, "Print",ExpressionUUID->"c9155daf-019b-4a42-b04b-b2bfc78a291f"],
Cell[26723, 619, 651, 16, 33, "Print",ExpressionUUID->"ebb2dc6e-b1e8-4cfb-8e29-6e7801e03351"],
Cell[27377, 637, 647, 16, 33, "Print",ExpressionUUID->"7ad37f4b-f874-4bce-9fe0-53ccfde950bb"],
Cell[28027, 655, 687, 17, 33, "Print",ExpressionUUID->"a9e72c77-aec7-4252-8815-ba1cfb3e928f"],
Cell[28717, 674, 687, 17, 33, "Print",ExpressionUUID->"aaf4d8c2-fb44-4603-b66d-025c826e206c"],
Cell[29407, 693, 687, 17, 33, "Print",ExpressionUUID->"c3d49857-58f9-4715-8928-8f3fc67a98f8"],
Cell[30097, 712, 687, 17, 33, "Print",ExpressionUUID->"95354f9b-bd68-4262-ac71-c5cda1abdcf7"],
Cell[30787, 731, 687, 17, 33, "Print",ExpressionUUID->"a6c73adf-7044-46d2-a443-09de9f79e7f3"],
Cell[31477, 750, 689, 17, 33, "Print",ExpressionUUID->"41ca35f3-7536-4d7b-9499-af28b638b015"],
Cell[32169, 769, 712, 17, 33, "Print",ExpressionUUID->"0a5e14ee-9fa1-4689-8ce1-4b07426867f3"],
Cell[32884, 788, 712, 17, 33, "Print",ExpressionUUID->"ccf49cd9-292c-4629-91fb-7bb55edd81a3"],
Cell[33599, 807, 712, 17, 33, "Print",ExpressionUUID->"64585b5f-ad7d-40f5-b87e-f53937581458"],
Cell[34314, 826, 712, 17, 33, "Print",ExpressionUUID->"6368b724-34a8-4de2-8f70-324c9d21511e"],
Cell[35029, 845, 741, 18, 33, "Print",ExpressionUUID->"ac2094cf-e3fc-493e-b8dd-1c4e1c998fd0"],
Cell[35773, 865, 610, 14, 33, "Print",ExpressionUUID->"16ec2843-fdfd-4e61-b0eb-6ede5a79456a"],
Cell[36386, 881, 1214, 30, 33, "Print",ExpressionUUID->"918ab65f-4f5e-4a23-9114-bdbedcb279b6"],
Cell[37603, 913, 2683, 86, 418, "Print",ExpressionUUID->"7b6c995e-63eb-488f-92f6-8801b48cd8eb"],
Cell[40289, 1001, 475, 9, 33, "Print",ExpressionUUID->"d80a6303-67e4-4a46-9836-474e6ad9dc7b"],
Cell[40767, 1012, 16050, 287, 554, "Print",ExpressionUUID->"d044878d-bc61-4420-a73c-b1842b1f5f93"],
Cell[56820, 1301, 484, 9, 33, "Print",ExpressionUUID->"0dd81fdf-07fc-4c12-976b-93669b82767e"],
Cell[57307, 1312, 3750, 69, 516, "Print",ExpressionUUID->"532ea30d-c01d-4319-9a3e-eef737e73eab"]
}, Open  ]]
}, Open  ]]
}
]
*)

