(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     29557,        641]
NotebookOptionsPosition[     26988,        593]
NotebookOutlinePosition[     27419,        610]
CellTagsIndexPosition[     27376,        607]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8202311176947727`*^9, 3.8202311208363905`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],

Cell["Lenguaje hileras que finalicen en \[OpenCurlyDoubleQuote]abb\
\[CloseCurlyDoubleQuote]:", "Text",
 CellChangeTimes->{{3.820917222109982*^9, 3.8209172290483522`*^9}, {
  3.8209173340057497`*^9, 
  3.820917341399419*^9}},ExpressionUUID->"40f8bc66-0ca6-4d18-a42b-\
353f9d36110f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"aut", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"S", ",", "A", ",", "B", ",", "C"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "S", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"S", ",", "a", ",", "A"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"S", ",", "b", ",", "S"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "a", ",", "A"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "b", ",", "B"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"B", ",", "a", ",", "A"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"B", ",", "b", ",", "C"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"C", ",", "a", ",", "A"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"C", ",", "b", ",", "S"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", "C", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToDiagrama", "[", "aut", "]"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToRegular", "[", "aut", "]"}]}], "Input",
 CellChangeTimes->{{3.8209164828575983`*^9, 3.8209164857367463`*^9}, {
  3.8209168209526863`*^9, 3.820916898868357*^9}, {3.8209169467247477`*^9, 
  3.82091698150873*^9}, {3.820917216711384*^9, 3.820917216977685*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"9b864a9a-78e9-4e22-b4be-62fc6bf8ce36"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{-1., 0}, 0.21213203435596426], 
   InsetBox["S", {-1., 0}], 
   PolygonBox[{{-0.18601350635647804`, -0.7756629247352513}, \
{-0.12913780037306374`, -0.8317043419609207}, {-0.1090423623832584, \
-0.7544278271082747}}], 
   CircleBox[{-1.1011236523706294, -1.0639933135783708}, 0.9993571247649794, {
    0.23458400112907557`, 1.281781552325673}], 
   InsetBox["\<\"a\"\>", {-0.37550369823040075, -0.37683223713991376}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-1.2572038472919376, -0.14847956404241516}, 
    0.10606601717798213, {1.047147551196598, 6.283135307179586}], 
   PolygonBox[{{-1.2907705798434999`, -0.09249396704215221}, \
{-1.2041662459759719`, -0.05662635045329416}, {-1.2785306800488871`, 
    0.00044139445938515265`}}], 
   InsetBox["\<\"b\"\>", {-1.3102322630213716, -0.05662104715243747}, 
    ImageScaled[{1, 0}]], CircleBox[{0, -1.}, 0.21213203435596426], 
   InsetBox["A", {0, -1.}], 
   PolygonBox[{{0.7381464992843186, -0.08938594153165816}, {
    0.8162882692912616, -0.10606601717798207`}, {
    0.7627720150410274, -0.16539873727751372`}}], 
   CircleBox[{1.0916155413070803, -1.0681942988201705}, 1.0007476890062867, {
    1.8495124731761456`, 2.8967100243727435`}], 
   InsetBox["\<\"b\"\>", {0.37211098856561864, -0.37263040122647495}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-0.13135303948030821, -1.266357614907636}, 
    0.10606601717798213, {-4.646939133434902, 0.589048622548086}], 
   PolygonBox[{{-0.23182730307003918`, -1.1543879402959847`}, \
{-0.1382900889087264, -1.1605186932142075`}, {-0.19036808376088932`, \
-1.2384589204180185`}}], 
   InsetBox["\<\"a\"\>", {-0.22648075909017826, -1.2194458150932403}, 
    ImageScaled[{1, 0}]], CircleBox[{1., 0}, 0.21213203435596426], 
   InsetBox["B", {1., 0}], 
   PolygonBox[{{0.014940737868318114`, 0.7090835241888918}, {
    0.02767827079700078, 0.789681400428569}, {0.09110931264729422, 
    0.7383514352109504}}], 
   CircleBox[{1.0140115583569744, 1.1308300011777135}, 1.0436645639006652, {
    3.474588444595299, 4.521785995791896}], 
   InsetBox["\<\"b\"\>", {0.3303961751063871, 0.34222000268345254}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.2627150855926063, -0.9351428625269946}, {
    0.21213203435596426`, -1.}, {
    0.29359148864264756`, -1.0113776386353592`}}], 
   CircleBox[{-0.15389336942847465, -0.0013980576330380468}, 
    1.0635696665073855, {5.063620214650239, 6.110817765846837}], 
   InsetBox["\<\"a\"\>", {0.6623267155866125, -0.6832816315168757}, 
    ImageScaled[{1, 1}]], CircleBox[{0, 1.}, 0.21213203435596426], 
   CircleBox[{0, 1.}, 0.1414213562373095], InsetBox["C", {0, 1.}], 
   PolygonBox[{{-0.020635770654290467`, -0.6881664626462829}, \
{-0.027688786692377135`, -0.7896827846050066}, {
    0.06375343504168098, -0.745032714687927}}], 
   CircleBox[{-1.3534365499583674, 0.15681607117006466}, 1.6289466583618684, {
    5.663067526664985, 6.710365077861583}], 
   InsetBox["\<\"a\"\>", {0.26793627699258593, -0.00008316978849365331}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.7617488916634465, 
    0.1645007806798614}, {-0.8162882692912616, 
    0.10606601717798213`}, {-0.738412590820591, 0.0880509123966412}}], 
   CircleBox[{-1.0762476558977185, 1.0762476558977183}, 1.0044059412377637, {
    4.97408836818384, 6.021285919380437}], 
   InsetBox["\<\"b\"\>", {-0.36609642956064237, 0.3659543851104575}, 
    ImageScaled[{1, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{-1., 0.4242640687119285}, {-1., 0.21213203435596426`}}], 
    PolygonBox[{{-1., 0.21213203435596426`}, {-1.0707106781186548`, 
     0.31819805153394637`}, {-0.9292893218813453, 0.31819805153394637`}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{3.8209168120217366`*^9, 3.8209169992384524`*^9, 
  3.8209172175860605`*^9, 3.82091744633565*^9, 3.8209178003230886`*^9, 
  3.8209180633387756`*^9, 3.8209181855848017`*^9, 3.820919774303112*^9, 
  3.8209223465053205`*^9, 3.8209331287019567`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"85027b72-1266-4145-8f4f-21927a5f1c0c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos no terminales: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"S\"\>", ",", "\<\"A\"\>", ",", "\<\"B\"\>", 
     ",", "\<\"C\"\>"}], "}"}]}],
  SequenceForm["S\[IAcute]mbolos no terminales: ", {"S", "A", "B", "C"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.82091699926728*^9, 3.8209172175890527`*^9, 
  3.8209174463396673`*^9, 3.8209178003280773`*^9, 3.8209180633437614`*^9, 
  3.8209181855917697`*^9, 3.820919774308099*^9, 3.8209223465103083`*^9, 
  3.8209331287109327`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"f701a8b1-ebea-45d4-8b35-8a150c0cb7b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos terminales: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}]}],
  SequenceForm["S\[IAcute]mbolos terminales: ", {"a", "b"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.82091699926728*^9, 3.8209172175890527`*^9, 
  3.8209174463396673`*^9, 3.8209178003280773`*^9, 3.8209180633437614`*^9, 
  3.8209181855917697`*^9, 3.820919774308099*^9, 3.8209223465103083`*^9, 
  3.8209331287159195`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"c3674031-c0d0-4f9f-8080-a2f61aceb933"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Producciones o reglas de composici\[OAcute]n: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\[Rule]aA\"\>", ",", "\<\"A\[Rule]bB\"\>", 
     ",", "\<\"B\[Rule]aA\"\>", ",", "\<\"B\[Rule]b\"\>", 
     ",", "\<\"B\[Rule]bC\"\>", ",", "\<\"C\[Rule]aA\"\>", 
     ",", "\<\"C\[Rule]bS\"\>", ",", "\<\"S\[Rule]aA\"\>", 
     ",", "\<\"S\[Rule]bS\"\>"}], "}"}]}],
  SequenceForm[
  "Producciones o reglas de composici\[OAcute]n: ", {
   "A\[Rule]aA", "A\[Rule]bB", "B\[Rule]aA", "B\[Rule]b", "B\[Rule]bC", 
    "C\[Rule]aA", "C\[Rule]bS", "S\[Rule]aA", "S\[Rule]bS"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.82091699926728*^9, 3.8209172175890527`*^9, 
  3.8209174463396673`*^9, 3.8209178003280773`*^9, 3.8209180633437614`*^9, 
  3.8209181855917697`*^9, 3.820919774308099*^9, 3.8209223465103083`*^9, 
  3.8209331287239413`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"09db9ad8-0564-4cce-940c-ae5ab1c3e06d"],

Cell[BoxData["\<\"\\!\\(\\*SuperscriptBox[\\(\[Sigma]\\), \
\\(*\\)]\\)=S\"\>"], "Print",
 CellChangeTimes->{3.82091699926728*^9, 3.8209172175890527`*^9, 
  3.8209174463396673`*^9, 3.8209178003280773`*^9, 3.8209180633437614`*^9, 
  3.8209181855917697`*^9, 3.820919774308099*^9, 3.8209223465103083`*^9, 
  3.8209331287288847`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"b212037a-0674-40f8-b78a-faa45ffafb1a"]
}, Open  ]]
}, Open  ]],

Cell["Lenguaje hileras con al menos dos letras \[OpenCurlyDoubleQuote]a\
\[CloseCurlyDoubleQuote]:", "Text",
 CellChangeTimes->{{3.820917222109982*^9, 3.8209172290483522`*^9}, {
  3.8209173340057497`*^9, 
  3.820917356659424*^9}},ExpressionUUID->"36f48906-afbf-4253-9e4c-\
d788099cd3e5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"aut", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"S", ",", "A", ",", "B"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "S", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"S", ",", "a", ",", "A"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"S", ",", "b", ",", "S"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "a", ",", "B"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "b", ",", "A"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"B", ",", "a", ",", "B"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"B", ",", "b", ",", "B"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", "B", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToDiagrama", "[", "aut", "]"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToRegular", "[", "aut", "]"}]}], "Input",
 CellChangeTimes->{{3.8209165887445807`*^9, 3.820916589107612*^9}, {
  3.8209169120767436`*^9, 3.8209169175858927`*^9}, {3.820917024173003*^9, 
  3.820917042916112*^9}, {3.820917210928842*^9, 3.820917211284851*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"5d33545a-a158-4bd2-8746-dd93ff495b2b"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{-0.5000000000000002, 0.8660254037844386}, 0.2598076211353315], 
   InsetBox["S", {-0.5000000000000002, 0.8660254037844386}], 
   PolygonBox[{{-0.43613034271187856`, -0.5172320364740529}, \
{-0.43275683958739564`, -0.6150705126630965}, {-0.3497129853023664, \
-0.5632297351630263}}], 
   CircleBox[{-1.4980902177573159, -1.1102230246251565*^-16}, 
    1.2301410253261933, {5.759486531581288, 6.8067840827778845`}], 
   InsetBox["\<\"a\"\>", {-0.2679491939687988, -0.0000615070512409507}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   CircleBox[{-0.8606189032885297, 0.8185490244892762}, 0.12990381056766576, {
    0.6544984694978737, 5.890486225480862}], 
   PolygonBox[{{-0.8723643109676392, 
    0.8976294538441265}, {-0.7575592812581122, 
    0.8976294538441266}, {-0.8149617961128758, 0.9970535260548041}}], 
   InsetBox["\<\"b\"\>", {-0.877574753036802, 0.9473414899494653}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{-0.4999999999999996, -0.8660254037844388}, 0.2598076211353315], 
   InsetBox["A", {-0.4999999999999996, -0.8660254037844388}], 
   PolygonBox[{{0.662500134477933, -0.02118308761495776}, {
    0.7490451088786577, -0.0672431604126041}, {
    0.6658834285353731, -0.11916327041468247`}}], 
   CircleBox[{0.749045108878658, -1.2973841857387969}, 1.2301410253261928, {
    1.5707963267948966`, 2.617993877991494}], 
   InsetBox["\<\"a\"\>", {0.13397459621556185, -0.2320508075688772}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-0.6818653347947315, -1.1810254037844388}, 
    0.12990381056766576, {-4.71238898038469, 0.5235987755982991}], 
   PolygonBox[{{-0.7956881915601097, -1.0361365298410785`}, \
{-0.6818653347947315, -1.051121593216773}, {-0.7517542087380917, \
-1.1422025470190609`}}], 
   InsetBox["\<\"b\"\>", {-0.7943653347947315, -1.116073498500606}, 
    ImageScaled[{1, 0}]], CircleBox[{1., 0}, 0.2598076211353315], 
   CircleBox[{1., 0}, 0.17320508075688767], InsetBox["B", {1., 0}], 
   CircleBox[{1.351336847569879, 0.09414042457764579}, 
    0.12990381056766576, {-2.356194490192344, 2.8797932657906444`}], 
   PolygonBox[{{1.3293698561588703`, -0.08879639457901112}, {1.25948098221551,
     0.0022845592232765555`}, {1.3733038389808883`, 0.01726962259897119}}], 
   InsetBox["\<\"b,a\"\>", {1.384958427776181, -0.03133702098302535}, 
    ImageScaled[{0, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{-0.5000000000000002, 1.3856406460551016`}, {-0.5000000000000002,
      1.12583302491977}}], 
    PolygonBox[{{-0.5000000000000002, 1.12583302491977}, {-0.5866025403784441,
      1.2557368354874359`}, {-0.4133974596215564, 1.2557368354874359`}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{
  3.820917049900313*^9, 3.8209172118547215`*^9, 3.8209174506915307`*^9, {
   3.82091977728117*^9, 3.820919791129052*^9}, 3.820922349971425*^9, 
   3.8209331318696637`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"dd3d43de-23e8-4da2-b0cd-646e82fded2f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos no terminales: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"S\"\>", ",", "\<\"A\"\>", ",", "\<\"B\"\>"}], "}"}]}],
  SequenceForm["S\[IAcute]mbolos no terminales: ", {"S", "A", "B"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8209170499062986`*^9, 3.8209172118576994`*^9, 3.820917450696516*^9, {
   3.8209197772861757`*^9, 3.8209197911330395`*^9}, 3.820922349974433*^9, 
   3.820933131876643*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[80]:=",ExpressionUUID->"9f690254-23ea-4dc3-aa59-c260e4fb1e6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos terminales: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}]}],
  SequenceForm["S\[IAcute]mbolos terminales: ", {"a", "b"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8209170499062986`*^9, 3.8209172118576994`*^9, 3.820917450696516*^9, {
   3.8209197772861757`*^9, 3.8209197911330395`*^9}, 3.820922349974433*^9, 
   3.82093313188163*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[80]:=",ExpressionUUID->"c18cac5b-9476-40f4-89c9-957e2323754d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Producciones o reglas de composici\[OAcute]n: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\[Rule]a\"\>", ",", "\<\"A\[Rule]aB\"\>", 
     ",", "\<\"A\[Rule]bA\"\>", ",", "\<\"B\[Rule]a\"\>", 
     ",", "\<\"B\[Rule]aB\"\>", ",", "\<\"B\[Rule]b\"\>", 
     ",", "\<\"B\[Rule]bB\"\>", ",", "\<\"S\[Rule]aA\"\>", 
     ",", "\<\"S\[Rule]bS\"\>"}], "}"}]}],
  SequenceForm[
  "Producciones o reglas de composici\[OAcute]n: ", {
   "A\[Rule]a", "A\[Rule]aB", "A\[Rule]bA", "B\[Rule]a", "B\[Rule]aB", 
    "B\[Rule]b", "B\[Rule]bB", "S\[Rule]aA", "S\[Rule]bS"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8209170499062986`*^9, 3.8209172118576994`*^9, 3.820917450696516*^9, {
   3.8209197772861757`*^9, 3.8209197911330395`*^9}, 3.820922349974433*^9, 
   3.820933131890607*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[80]:=",ExpressionUUID->"1d2eaf8e-e9dd-4aec-83e3-61cd972e2c59"],

Cell[BoxData["\<\"\\!\\(\\*SuperscriptBox[\\(\[Sigma]\\), \
\\(*\\)]\\)=S\"\>"], "Print",
 CellChangeTimes->{
  3.8209170499062986`*^9, 3.8209172118576994`*^9, 3.820917450696516*^9, {
   3.8209197772861757`*^9, 3.8209197911330395`*^9}, 3.820922349974433*^9, 
   3.820933131894595*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[80]:=",ExpressionUUID->"04a024bf-37f0-4aff-b5d7-1a83e8f0171b"]
}, Open  ]]
}, Open  ]],

Cell["Lenguaje hileras que inicien con \[OpenCurlyDoubleQuote]ab\
\[CloseCurlyDoubleQuote] y terminen con \[OpenCurlyDoubleQuote]ba\
\[CloseCurlyDoubleQuote]:", "Text",
 CellChangeTimes->{{3.820917222109982*^9, 3.8209172290483522`*^9}, {
  3.8209173340057497`*^9, 
  3.820917379763345*^9}},ExpressionUUID->"34d58254-529c-4a73-a84e-\
ab5a555507db"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"aut", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"S", ",", "A", ",", "B", ",", "C", ",", "D", ",", "F"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "S", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"S", ",", "a", ",", "A"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"S", ",", "b", ",", "D"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "a", ",", "D"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "b", ",", "B"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"B", ",", "a", ",", "C"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"B", ",", "b", ",", "B"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"C", ",", "a", ",", "F"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"C", ",", "b", ",", "B"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"D", ",", "a", ",", "D"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"D", ",", "b", ",", "D"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"F", ",", "a", ",", "F"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"F", ",", "b", ",", "B"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", "C", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToDiagrama", "[", "aut", "]"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataToRegular", "[", "aut", "]"}]}], "Input",
 CellChangeTimes->{{3.82091664749266*^9, 3.8209166478975787`*^9}, 
   3.8209168052690988`*^9, {3.820916921122885*^9, 3.820916926429187*^9}, 
   3.8209171143560314`*^9, {3.8209171543843484`*^9, 3.820917203271454*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"103ae79e-f4c9-4ec1-86a1-ff78deb3b69b"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{-1., 0}, 0.14999999999999986], 
   InsetBox["S", {-1., 0}], 
   PolygonBox[{{0.2842933312943284, 0.8658332357922798}, {
    0.35511112605663975`, 0.8272025470190607}, {0.2862470708321861, 
    0.7851878821015159}}], 
   CircleBox[{0.35511112605664014, -0.6150705126630966}, 1.4422730596821576, {
    1.5707963267948966`, 2.617993877991494}], 
   InsetBox["\<\"b\"\>", {-0.3660254037844383, 0.6339745962155616}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{-0.5687998483437635, -0.6731238569336035}, \
{-0.5388228567653778, -0.7211365298410788}, {-0.5122311581131043, \
-0.671169357151427}}], 
   CircleBox[{-1.2490412273174323, -0.7211510189225634}, 0.7102183706998497, {
    0.000020400882437511105`, 1.047217952079035}], 
   InsetBox["\<\"a\"\>", {-0.6339813207257053, -0.366029285733893}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-0.4999999999999996, -0.8660254037844388}, 0.14999999999999986],
    InsetBox["A", {-0.4999999999999996, -0.8660254037844388}], 
   PolygonBox[{{0.29854224114197075`, -0.8291558927538709}, {
    0.35511112605664075`, -0.8272025470190602}, {
    0.3251350365705857, -0.779189128486603}}], 
   CircleBox[{6.106226635438361*^-16, -1.4422730596821578}, 
    0.7102222521132805, {1.0471975511965983`, 2.0943951023931953`}], 
   InsetBox["\<\"b\"\>", {4.964102145510645*^-16, -0.7320508075688773}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   PolygonBox[{{0.30611093622698093`, 0.758005587203685}, {
    0.39393398282201786`, 0.7599593866064567}, {0.3517144994411985, 
    0.6829254975160244}}], 
   CircleBox[{1.2490451088786585, -0.7211365298410783}, 1.7102222521132806, {
    2.0943951023931957`, 3.141592653589793}], 
   InsetBox["\<\"a\"\>", {-0.23205080756887742, 0.13397459621556185}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.5000000000000009, -0.8660254037844382}, 0.14999999999999986], 
   InsetBox["B", {0.5000000000000009, -0.8660254037844382}], 
   PolygonBox[{{0.8373650979073481, -0.1080193629127928}, {
    0.893933982822018, -0.10606601717798204`}, {
    0.8673411873934032, -0.1560327814452498}}], 
   CircleBox[{1.249045108878658, -0.7211365298410778}, 0.7102222521132792, {
    2.094395102393196, 3.1415926535897936`}], 
   InsetBox["\<\"a\"\>", {0.6339745962155618, -0.36602540378443854}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.5543519994715304, -1.0688698273051422}, 
    0.07499999999999993, {-3.9269908169872405`, 1.3089969389957474`}], 
   PolygonBox[{{0.4487333776867407, -1.05618717890071}, {
    0.5013189908825393, -1.0158368187161513`}, {
    0.5099706212563201, -1.0815524757095745`}}], 
   InsetBox["\<\"b\"\>", {0.48190756249985034, -1.0882812556878314}, 
    ImageScaled[{1, 1}]], CircleBox[{1., 0}, 0.14999999999999986], 
   CircleBox[{1., 0}, 0.0999999999999999], InsetBox["C", {1., 0}], 
   PolygonBox[{{-0.37032407902335807`, 
    0.7104721132693569}, {-0.3701036900818411, 
    0.7910124137784036}, {-0.3004639382833324, 0.7505514011018134}}], 
   CircleBox[{0.893918982822043, 1.4759847911408956}, 1.437685805509919, {
    3.638194869181247, 4.685392420377845}], 
   InsetBox["\<\"a\"\>", {0.14172942580901682, 0.2507699750024144}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.632622800898165, -0.7100663020434179}, {
    0.6060660171779828, -0.759959386606456}, {
    0.6625530877428302, -0.7580116936694239}}], 
   CircleBox[{0.25095489112134284, -0.1448888739433604}, 0.710222252113279, {
    5.23588775598299, 6.283185307179586}], 
   InsetBox["\<\"b\"\>", {0.8660076474593054, -0.5000307530817311}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.4999999999999999, 0.8660254037844387}, 0.14999999999999986], 
   InsetBox["D", {0.4999999999999999, 0.8660254037844387}], 
   CircleBox[{0.6818653347947318, 0.9710254037844387}, 
    0.07499999999999993, {-2.094395102393195, 3.1415926535897936`}], 
   PolygonBox[{{0.6969509479905305, 0.8657231383160471}, {0.6443653347947319, 
    0.9060734985006058}, {0.7056025783643112, 0.9314387953094703}}], 
   InsetBox["\<\"b,a\"\>", {0.7193653347947317, 0.9060734985006058}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{-0.5000000000000002, 0.8660254037844386}, 0.14999999999999986], 
   InsetBox["F", {-0.5000000000000002, 0.8660254037844386}], 
   PolygonBox[{{0.4139380973246038, -0.647216928469638}, {
    0.4611771432346228, -0.7211365298410781}, {
    0.5015738729048995, -0.6432665153467422}}], 
   CircleBox[{-1.2439339835720178, -0.7599743866064328}, 1.7055533805419105, {
    0.022773379285889284`, 1.0699709304824867`}], 
   InsetBox["\<\"b\"\>", {0.21331664013536544, 0.12621574738422592}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{-0.6484775740643329, 1.0145326763335314}, 
    0.07499999999999993, {-0.261899387799148, 4.974088368183841}], 
   PolygonBox[{{-0.6163801800192064, 
    1.0477036515730966`}, {-0.5760350785977101, 
    0.9951140036042145}, {-0.5506636581913256, 1.056348710337931}}], 
   InsetBox["\<\"a\"\>", {-0.595439262439657, 1.0675603813565073}, 
    ImageScaled[{0, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{-1., 0.2999999999999997}, {-1., 0.14999999999999986`}}], 
    PolygonBox[{{-1., 0.14999999999999986`}, {-1.05, 
     0.22499999999999978`}, {-0.9500000000000001, 0.22499999999999978`}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Output",
 CellChangeTimes->{{3.820917191580886*^9, 3.820917203929694*^9}, 
   3.8209174570534873`*^9, {3.820921403600416*^9, 3.820921417035526*^9}, 
   3.8209223532726727`*^9, 3.8209331347870226`*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"27fd48e4-fcad-4987-8ee6-a19522738404"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos no terminales: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"S\"\>", ",", "\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"C\"\>",
      ",", "\<\"D\"\>", ",", "\<\"F\"\>"}], "}"}]}],
  SequenceForm[
  "S\[IAcute]mbolos no terminales: ", {"S", "A", "B", "C", "D", "F"}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.820917191587867*^9, 3.8209172039336834`*^9}, 
   3.820917457058473*^9, {3.820921403605402*^9, 3.820921417040492*^9}, 
   3.820922353277629*^9, 3.8209331347959986`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"02cf5e75-9e2b-4d95-ac28-23e3fab59b73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos terminales: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}]}],
  SequenceForm["S\[IAcute]mbolos terminales: ", {"a", "b"}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.820917191587867*^9, 3.8209172039336834`*^9}, 
   3.820917457058473*^9, {3.820921403605402*^9, 3.820921417040492*^9}, 
   3.820922353277629*^9, 3.8209331348029795`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"12ca18ec-b0ba-4fa2-a0b3-9fcd7839f38c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Producciones o reglas de composici\[OAcute]n: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\[Rule]aD\"\>", ",", "\<\"A\[Rule]bB\"\>", 
     ",", "\<\"B\[Rule]a\"\>", ",", "\<\"B\[Rule]aC\"\>", 
     ",", "\<\"B\[Rule]bB\"\>", ",", "\<\"C\[Rule]aF\"\>", 
     ",", "\<\"C\[Rule]bB\"\>", ",", "\<\"D\[Rule]aD\"\>", 
     ",", "\<\"D\[Rule]bD\"\>", ",", "\<\"F\[Rule]aF\"\>", 
     ",", "\<\"F\[Rule]bB\"\>", ",", "\<\"S\[Rule]aA\"\>", 
     ",", "\<\"S\[Rule]bD\"\>"}], "}"}]}],
  SequenceForm[
  "Producciones o reglas de composici\[OAcute]n: ", {
   "A\[Rule]aD", "A\[Rule]bB", "B\[Rule]a", "B\[Rule]aC", "B\[Rule]bB", 
    "C\[Rule]aF", "C\[Rule]bB", "D\[Rule]aD", "D\[Rule]bD", "F\[Rule]aF", 
    "F\[Rule]bB", "S\[Rule]aA", "S\[Rule]bD"}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.820917191587867*^9, 3.8209172039336834`*^9}, 
   3.820917457058473*^9, {3.820921403605402*^9, 3.820921417040492*^9}, 
   3.820922353277629*^9, 3.82093313481395*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"6617813d-4915-4f52-9309-6023bf1669d6"],

Cell[BoxData["\<\"\\!\\(\\*SuperscriptBox[\\(\[Sigma]\\), \
\\(*\\)]\\)=S\"\>"], "Print",
 CellChangeTimes->{{3.820917191587867*^9, 3.8209172039336834`*^9}, 
   3.820917457058473*^9, {3.820921403605402*^9, 3.820921417040492*^9}, 
   3.820922353277629*^9, 3.820933134821929*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"997c5726-a399-4a34-bacd-3a464306eea9"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{949, 467},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a8572f35-c064-47f4-a398-4a1b85c180ca"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 42, "Input",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],
Cell[763, 25, 282, 5, 50, "Text",ExpressionUUID->"40f8bc66-0ca6-4d18-a42b-353f9d36110f"],
Cell[CellGroupData[{
Cell[1070, 34, 1406, 33, 233, "Input",ExpressionUUID->"9b864a9a-78e9-4e22-b4be-62fc6bf8ce36"],
Cell[2479, 69, 4051, 72, 566, "Output",ExpressionUUID->"85027b72-1266-4145-8f4f-21927a5f1c0c"],
Cell[CellGroupData[{
Cell[6555, 145, 683, 14, 33, "Print",ExpressionUUID->"f701a8b1-ebea-45d4-8b35-8a150c0cb7b5"],
Cell[7241, 161, 625, 13, 33, "Print",ExpressionUUID->"c3674031-c0d0-4f9f-8080-a2f61aceb933"],
Cell[7869, 176, 1020, 21, 60, "Print",ExpressionUUID->"09db9ad8-0564-4cce-940c-ae5ab1c3e06d"],
Cell[8892, 199, 446, 8, 33, "Print",ExpressionUUID->"b212037a-0674-40f8-b78a-faa45ffafb1a"]
}, Open  ]]
}, Open  ]],
Cell[9365, 211, 287, 5, 50, "Text",ExpressionUUID->"36f48906-afbf-4253-9e4c-d788099cd3e5"],
Cell[CellGroupData[{
Cell[9677, 220, 1241, 29, 129, "Input",ExpressionUUID->"5d33545a-a158-4bd2-8746-dd93ff495b2b"],
Cell[10921, 251, 2954, 52, 611, "Output",ExpressionUUID->"dd3d43de-23e8-4da2-b0cd-646e82fded2f"],
Cell[CellGroupData[{
Cell[13900, 307, 609, 13, 33, "Print",ExpressionUUID->"9f690254-23ea-4dc3-aa59-c260e4fb1e6f"],
Cell[14512, 322, 579, 13, 33, "Print",ExpressionUUID->"c18cac5b-9476-40f4-89c9-957e2323754d"],
Cell[15094, 337, 971, 21, 60, "Print",ExpressionUUID->"1d2eaf8e-e9dd-4aec-83e3-61cd972e2c59"],
Cell[16068, 360, 401, 8, 33, "Print",ExpressionUUID->"04a024bf-37f0-4aff-b5d7-1a83e8f0171b"]
}, Open  ]]
}, Open  ]],
Cell[16496, 372, 347, 6, 50, "Text",ExpressionUUID->"34d58254-529c-4a73-a84e-ab5a555507db"],
Cell[CellGroupData[{
Cell[16868, 382, 1740, 42, 233, "Input",ExpressionUUID->"103ae79e-f4c9-4ec1-86a1-ff78deb3b69b"],
Cell[18611, 426, 5516, 97, 551, "Output",ExpressionUUID->"27fd48e4-fcad-4987-8ee6-a19522738404"],
Cell[CellGroupData[{
Cell[24152, 527, 682, 14, 33, "Print",ExpressionUUID->"02cf5e75-9e2b-4d95-ac28-23e3fab59b73"],
Cell[24837, 543, 575, 12, 33, "Print",ExpressionUUID->"12ca18ec-b0ba-4fa2-a0b3-9fcd7839f38c"],
Cell[25415, 557, 1148, 23, 60, "Print",ExpressionUUID->"6617813d-4915-4f52-9309-6023bf1669d6"],
Cell[26566, 582, 394, 7, 33, "Print",ExpressionUUID->"997c5726-a399-4a34-bacd-3a464306eea9"]
}, Open  ]]
}, Open  ]]
}
]
*)

