(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     40397,        977]
NotebookOptionsPosition[     38205,        930]
NotebookOutlinePosition[     38639,        947]
CellTagsIndexPosition[     38596,        944]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.814783656107747*^9, 3.8147836587350225`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"9055b7e6-6f57-4733-9449-ca68bdd5ff7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "]"}], ",", "Automatic", ",", 
   "1", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"2", "\[Rule]", " ", "\"\<((a+b)*c+d)*e)\>\""}], ",", " ", 
      RowBox[{"3", "\[Rule]", "\"\<((a+b)*c+f)\>\""}]}], "}"}]}], ",", 
   RowBox[{"ImagePadding", "\[Rule]", "48"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.814807325361909*^9, 3.8148073318499193`*^9}, {
  3.8148073642439713`*^9, 3.814807482097684*^9}, {3.8148076878539257`*^9, 
  3.814807697995068*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"e74c3999-7112-4367-8f98-60b3e56d1e57"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
    LineBox[{{{0.4472135954999579, 0.8944271909999159}, {0., 0.}}, {{
     0.4472135954999579, 0.8944271909999159}, {0.8944271909999159, 0.}}}]}, 
   {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
    0.7]}], {DiskBox[{0.4472135954999579, 0.8944271909999159}, 
      0.011386058141428929], 
     InsetBox["\<\"-\"\>", 
      Offset[{2, 2}, {0.4585996536413869, 0.9058132491413448}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.011386058141428929], 
     InsetBox["\<\"((a+b)*c+d)*e)\"\>", 
      Offset[{2, 2}, {0.011386058141428929, 0.011386058141428929}], 
      ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{0.8944271909999159, 0.}, 0.011386058141428929], 
     InsetBox["\<\"((a+b)*c+f)\"\>", 
      Offset[{2, 2}, {0.9058132491413448, 0.011386058141428929}], 
      ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}}},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->48]], "Output",
 CellChangeTimes->{{3.814807453504669*^9, 3.814807483055814*^9}, {
   3.8148076801840897`*^9, 3.81480769846832*^9}, 3.814809098652*^9, 
   3.8148096479850273`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"ef7fbeaa-a28d-460e-8cb9-10abe94d7216"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7"}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"2", "\[Rule]", " ", "\"\<*\>\""}], ",", " ", 
      RowBox[{"3", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"4", "\[Rule]", "\"\<((a+b)*c+d)\>\""}], ",", 
      RowBox[{"5", "\[Rule]", "\"\<e\>\""}], ",", 
      RowBox[{"6", "\[Rule]", "\"\<(a+b)*c\>\""}], ",", 
      RowBox[{"7", "\[Rule]", "\"\<f\>\""}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8148078866050673`*^9, 3.814807896492587*^9}, {
  3.814807948476738*^9, 3.8148079729519825`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"00a15508-e4f2-4588-ace9-3d080b9d25f4"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7}, {
      Null, {{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}}}, {
      VertexLabels -> {
        6 -> "(a+b)*c", 3 -> "+", 5 -> "e", 7 -> "f", 4 -> "((a+b)*c+d)", 2 -> 
         "*", 1 -> "-"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        LineBox[{{{1.2247448713915892`, 1.6329931618554523`}, {
         0.4082482904638631, 0.8164965809277261}}, {{1.2247448713915892`, 
         1.6329931618554523`}, {2.041241452319315, 0.8164965809277261}}, {{
         0.4082482904638631, 0.8164965809277261}, {0., 0.}}, {{
         0.4082482904638631, 0.8164965809277261}, {0.8164965809277261, 
         0.}}, {{2.041241452319315, 0.8164965809277261}, {1.6329931618554523`,
          0.}}, {{2.041241452319315, 0.8164965809277261}, {
         2.4494897427831783`, 0.}}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.2247448713915892, 1.6329931618554523}, 
          0.02615707791054188], 
         InsetBox["\<\"-\"\>", 
          Offset[{2, 2}, {1.250901949302131, 1.659150239765994}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4082482904638631, 0.8164965809277261}, 
          0.02615707791054188], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {0.43440536837440497, 0.842653658838268}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.041241452319315, 0.8164965809277261}, 
          0.02615707791054188], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {2.067398530229857, 0.842653658838268}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.02615707791054188], 
         InsetBox["\<\"((a+b)*c+d)\"\>", 
          Offset[{2, 2}, {0.02615707791054188, 0.02615707791054188}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8164965809277261, 0.}, 0.02615707791054188], 
         InsetBox["\<\"e\"\>", 
          Offset[{2, 2}, {0.842653658838268, 0.02615707791054188}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6329931618554523, 0.}, 0.02615707791054188], 
         InsetBox["\<\"(a+b)*c\"\>", 
          Offset[{2, 2}, {1.659150239765994, 0.02615707791054188}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.4494897427831783, 0.}, 0.02615707791054188], 
         InsetBox["\<\"f\"\>", 
          Offset[{2, 2}, {2.4756468206937203, 0.02615707791054188}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.814807869019249*^9, 3.8148078972826595`*^9}, {
   3.814807960976339*^9, 3.8148079738017387`*^9}, 3.8148091046127205`*^9, 
   3.8148096641051817`*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"5e9183c2-47a9-4320-8d30-3c23b403bf2c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "11"}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"2", "\[Rule]", " ", "\"\<*\>\""}], ",", " ", 
      RowBox[{"3", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"4", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"5", "\[Rule]", "\"\<e\>\""}], ",", 
      RowBox[{"6", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"7", "\[Rule]", "\"\<f\>\""}], ",", 
      RowBox[{"8", "\[Rule]", "\"\<(a+b)*c\>\""}], ",", 
      RowBox[{"9", "\[Rule]", "\"\<d\>\""}], ",", 
      RowBox[{"10", "\[Rule]", "\"\<a+b\>\""}], ",", 
      RowBox[{"11", "\[Rule]", "\"\<c\>\""}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.8148082481724463`*^9, {3.8148082846286864`*^9, 3.8148082913337903`*^9}, {
   3.814808491058404*^9, 3.814808534712104*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"1cabad2f-3ef8-477e-ae3e-ca2461f4a911"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {
      Null, {{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {4, 8}, {4, 9}, {
       6, 10}, {6, 11}}}, {
      VertexLabels -> {
        6 -> "*", 3 -> "+", 11 -> "c", 5 -> "e", 8 -> "(a+b)*c", 7 -> "f", 10 -> 
         "a+b", 9 -> "d", 4 -> "+", 2 -> "*", 1 -> "-"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgAmImKF7o3fK+gfu3/U6LxZsXeLA4QPiv7RdBxdHlYTSq
PLr621D+awx5iP4vcHl081zXb5pq8JzBAZe87qHJFwVWsTugmo+wjwEN4HIP
TB7dPph/ccnD3AOTBwBpCIsn
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.6903085094570331, 2.53546276418555}, 
          0.029937855052529425], 
         InsetBox["\<\"-\"\>", 
          Offset[{2, 2}, {1.7202463645095625, 2.5654006192380794}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8451542547285166, 1.6903085094570334}, 
          0.029937855052529425], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {0.875092109781046, 1.7202463645095627}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.53546276418555, 1.6903085094570334}, 
          0.029937855052529425], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {2.5654006192380794, 1.7202463645095627}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4225771273642583, 0.8451542547285167}, 
          0.029937855052529425], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {0.4525149824167877, 0.8750921097810461}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.267731382092775, 0.8451542547285167}, 
          0.029937855052529425], 
         InsetBox["\<\"e\"\>", 
          Offset[{2, 2}, {1.2976692371453042, 0.8750921097810461}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1128856368212916, 0.8451542547285167}, 
          0.029937855052529425], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {2.142823491873821, 0.8750921097810461}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.958039891549808, 0.8451542547285167}, 
          0.029937855052529425], 
         InsetBox["\<\"f\"\>", 
          Offset[{2, 2}, {2.9879777466023376, 0.8750921097810461}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.029937855052529425], 
         InsetBox["\<\"(a+b)*c\"\>", 
          Offset[{2, 2}, {0.029937855052529425, 0.029937855052529425}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8451542547285166, 0.}, 0.029937855052529425], 
         InsetBox["\<\"d\"\>", 
          Offset[{2, 2}, {0.875092109781046, 0.029937855052529425}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6903085094570331, 0.}, 0.029937855052529425], 
         InsetBox["\<\"a+b\"\>", 
          Offset[{2, 2}, {1.7202463645095625, 0.029937855052529425}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.53546276418555, 0.}, 0.029937855052529425], 
         InsetBox["\<\"c\"\>", 
          Offset[{2, 2}, {2.5654006192380794, 0.029937855052529425}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.8148083185135937`*^9, {3.8148084927046614`*^9, 3.814808499955383*^9}, 
   3.81480853937624*^9, 3.8148091074211965`*^9, 3.814809666535331*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"5546d6e1-5807-421e-98ab-d1c1fe5f8996"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "15"}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"2", "\[Rule]", " ", "\"\<*\>\""}], ",", " ", 
      RowBox[{"3", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"4", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"5", "\[Rule]", "\"\<e\>\""}], ",", 
      RowBox[{"6", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"7", "\[Rule]", "\"\<f\>\""}], ",", 
      RowBox[{"8", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"9", "\[Rule]", "\"\<d\>\""}], ",", 
      RowBox[{"10", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"11", "\[Rule]", "\"\<c\>\""}], ",", 
      RowBox[{"12", "\[Rule]", "\"\<a+b\>\""}], ",", 
      RowBox[{"13", "\[Rule]", "\"\<c\>\""}], ",", 
      RowBox[{"14", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"15", "\[Rule]", "\"\<b\>\""}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8148087838895826`*^9, 3.8148088200941496`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"d053c215-b816-4181-acaf-7db888278af6"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {
      Null, {{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {4, 8}, {4, 9}, {
       6, 10}, {6, 11}, {8, 12}, {8, 13}, {10, 14}, {10, 15}}}, {
      VertexLabels -> {
        6 -> "*", 3 -> "+", 11 -> "c", 5 -> "e", 8 -> "*", 7 -> "f", 14 -> 
         "a", 10 -> "+", 9 -> "d", 4 -> "+", 12 -> "a+b", 13 -> "c", 2 -> "*",
          15 -> "b", 1 -> "-"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgA2ImKHbMvDz9txajw+zbrz/9KOd22PLEYNuvmV/sITSL
A7q8RkLflZ8cHA4weXT1EHWv7SH0b3vs8r/h8tjNQ6hDl4e5A9UchH0Q+rb9
HBRxTPfA5NHtg/kXlzzMPajmI+xjQAO43AOTR7cPZg8ueZh7YPIAWgEECQ==

         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.1459876881973803, 3.4335803011158084}, 
          0.03327016508804338], 
         InsetBox["\<\"-\"\>", 
          Offset[{2, 2}, {2.179257853285424, 3.466850466203852}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.287592612918428, 2.575185225836856}, 0.03327016508804338],
          InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {1.3208627780064714, 2.6084553909248998}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.0043827634763325, 2.575185225836856}, 
          0.03327016508804338], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {3.037652928564376, 2.6084553909248998}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8583950752789521, 1.7167901505579042}, 
          0.03327016508804338], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {0.8916652403669955, 1.7500603156459476}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7167901505579042, 1.7167901505579042}, 
          0.03327016508804338], 
         InsetBox["\<\"e\"\>", 
          Offset[{2, 2}, {1.7500603156459476, 1.7500603156459476}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.575185225836856, 1.7167901505579042}, 
          0.03327016508804338], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {2.6084553909248998, 1.7500603156459476}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.4335803011158084, 1.7167901505579042}, 
          0.03327016508804338], 
         InsetBox["\<\"f\"\>", 
          Offset[{2, 2}, {3.466850466203852, 1.7500603156459476}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.42919753763947605, 0.8583950752789522}, 
          0.03327016508804338], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {0.4624677027275194, 0.8916652403669956}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.287592612918428, 0.8583950752789522}, 
          0.03327016508804338], 
         InsetBox["\<\"d\"\>", 
          Offset[{2, 2}, {1.3208627780064714, 0.8916652403669956}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1459876881973803, 0.8583950752789522}, 
          0.03327016508804338], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {2.179257853285424, 0.8916652403669956}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.0043827634763325, 0.8583950752789522}, 
          0.03327016508804338], 
         InsetBox["\<\"c\"\>", 
          Offset[{2, 2}, {3.037652928564376, 0.8916652403669956}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.03327016508804338], 
         InsetBox["\<\"a+b\"\>", 
          Offset[{2, 2}, {0.03327016508804338, 0.03327016508804338}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8583950752789521, 0.}, 0.03327016508804338], 
         InsetBox["\<\"c\"\>", 
          Offset[{2, 2}, {0.8916652403669955, 0.03327016508804338}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7167901505579042, 0.}, 0.03327016508804338], 
         InsetBox["\<\"a\"\>", 
          Offset[{2, 2}, {1.7500603156459476, 0.03327016508804338}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.575185225836856, 0.}, 0.03327016508804338], 
         InsetBox["\<\"b\"\>", 
          Offset[{2, 2}, {2.6084553909248998, 0.03327016508804338}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.814808792035365*^9, 3.814808820494692*^9}, 
   3.8148091108358088`*^9, 3.814809669368229*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"4cbfbeee-6852-4f3f-b4ba-c4c3ee6301f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "17"}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "\"\<-\>\""}], ",", 
      RowBox[{"2", "\[Rule]", " ", "\"\<*\>\""}], ",", " ", 
      RowBox[{"3", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"4", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"5", "\[Rule]", "\"\<e\>\""}], ",", 
      RowBox[{"6", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"7", "\[Rule]", "\"\<f\>\""}], ",", 
      RowBox[{"8", "\[Rule]", "\"\<*\>\""}], ",", 
      RowBox[{"9", "\[Rule]", "\"\<d\>\""}], ",", 
      RowBox[{"10", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"11", "\[Rule]", "\"\<c\>\""}], ",", 
      RowBox[{"12", "\[Rule]", "\"\<+\>\""}], ",", 
      RowBox[{"13", "\[Rule]", "\"\<c\>\""}], ",", 
      RowBox[{"14", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"15", "\[Rule]", "\"\<b\>\""}], ",", 
      RowBox[{"16", "\[Rule]", "\"\<a\>\""}], ",", 
      RowBox[{"17", "\[Rule]", "\"\<b\>\""}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.814783824327525*^9, 3.814784016651951*^9}, 
   3.8148072321720715`*^9},
 CellLabel->"In[32]:=",ExpressionUUID->"81e6eaca-a1ce-45c9-b22b-aea1e68e2cee"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}, {
      Null, {{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {4, 8}, {4, 9}, {
       6, 10}, {6, 11}, {8, 12}, {8, 13}, {10, 14}, {10, 15}, {12, 16}, {12, 
       17}}}, {VertexLabels -> {
        6 -> "*", 3 -> "+", 11 -> "c", 5 -> "e", 8 -> "*", 7 -> "f", 14 -> 
         "a", 10 -> "+", 9 -> "d", 4 -> "+", 17 -> "b", 16 -> "a", 12 -> "+", 
         13 -> "c", 2 -> "*", 15 -> "b", 1 -> "-"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQAGImKC5NOuRttIXFgSeofMoVB0EH9+aIXW9n/bZ3A9Pc
DtjluR1g8tjVf7EvgepDl4eYw+iAKo8w714RL/MEdQ6c8hsmLy705uOHy2O3
7zXUvt/2+N3z2x7dPph/ccmjuue3Pbp9EP5texeoOC73wOTR7YOFDy55mHtQ
zUfYx4AGcLkHJg8Anirn9w==
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.5879865568825218, 4.313310928137536}, 
          0.03897099439526591], 
         InsetBox["\<\"-\"\>", 
          Offset[{2, 2}, {2.626957551277788, 4.352281922532802}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7253243712550146, 3.4506487425100287}, 
          0.03897099439526591], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {1.7642953656502804, 3.489619736905295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.450648742510029, 3.4506487425100287}, 
          0.03897099439526591], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {3.4896197369052953, 3.489619736905295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.2939932784412609, 2.5879865568825213}, 
          0.03897099439526591], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {1.3329642728365267, 2.6269575512777874}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.156655464068768, 2.5879865568825213}, 
          0.03897099439526591], 
         InsetBox["\<\"e\"\>", 
          Offset[{2, 2}, {2.195626458464034, 2.6269575512777874}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.0193176496962755, 2.5879865568825213}, 
          0.03897099439526591], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {3.0582886440915416, 2.6269575512777874}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.881979835323783, 2.5879865568825213}, 
          0.03897099439526591], 
         InsetBox["\<\"f\"\>", 
          Offset[{2, 2}, {3.920950829719049, 2.6269575512777874}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8626621856275073, 1.7253243712550144}, 
          0.03897099439526591], 
         InsetBox["\<\"*\"\>", 
          Offset[{2, 2}, {0.9016331800227733, 1.7642953656502802}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7253243712550146, 1.7253243712550144}, 
          0.03897099439526591], 
         InsetBox["\<\"d\"\>", 
          Offset[{2, 2}, {1.7642953656502804, 1.7642953656502802}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.5879865568825218, 1.7253243712550144}, 
          0.03897099439526591], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {2.626957551277788, 1.7642953656502802}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.450648742510029, 1.7253243712550144}, 
          0.03897099439526591], 
         InsetBox["\<\"c\"\>", 
          Offset[{2, 2}, {3.4896197369052953, 1.7642953656502802}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.43133109281375365, 0.862662185627507}, 
          0.03897099439526591], 
         InsetBox["\<\"+\"\>", 
          Offset[{2, 2}, {0.47030208720901956, 0.9016331800227728}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.2939932784412609, 0.862662185627507}, 
          0.03897099439526591], 
         InsetBox["\<\"c\"\>", 
          Offset[{2, 2}, {1.3329642728365267, 0.9016331800227728}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.156655464068768, 0.862662185627507}, 0.03897099439526591],
          InsetBox["\<\"a\"\>", 
          Offset[{2, 2}, {2.195626458464034, 0.9016331800227728}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.0193176496962755, 0.862662185627507}, 
          0.03897099439526591], 
         InsetBox["\<\"b\"\>", 
          Offset[{2, 2}, {3.0582886440915416, 0.9016331800227728}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.03897099439526591], 
         InsetBox["\<\"a\"\>", 
          Offset[{2, 2}, {0.03897099439526591, 0.03897099439526591}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8626621856275073, 0.}, 0.03897099439526591], 
         InsetBox["\<\"b\"\>", 
          Offset[{2, 2}, {0.9016331800227733, 0.03897099439526591}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{3.8147839382217903`*^9, 3.814784017371573*^9, 
  3.8147840681049995`*^9, 3.8147844031382685`*^9, 3.814791796089941*^9, 
  3.8148091135353413`*^9, 3.814809672468279*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"60fc9dae-f7b7-4c1f-8cbc-3f694a3ae347"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArbolExpAlgebraica", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], "c"}], "+", "d"}], ")"}], "e"}], 
    ")"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], "c"}], "+", "f"}], ")"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8147836626497755`*^9, 3.8147836849959073`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"97db7ab2-d302-4a7e-a516-64e508c4db30"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Plus[Times[-1, Plus[a, b], c], Times[Plus[Times[Plus[a, b], \
c], d], e], Times[-1, f]]\"\>"], "Print",
 CellChangeTimes->{3.8147836868520784`*^9, 3.814784400309225*^9, 
  3.8147918003413944`*^9, 3.81480911733142*^9, 3.814809675719812*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"c158421c-e8fd-46d1-89e5-eec0f0329eae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "Plus"}], ",", 
   RowBox[{"2", "\[Rule]", "Times"}], ",", 
   RowBox[{"3", "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{"4", "\[Rule]", "Plus"}], ",", 
   RowBox[{"5", "\[Rule]", "a"}], ",", 
   RowBox[{"6", "\[Rule]", "b"}], ",", 
   RowBox[{"7", "\[Rule]", "c"}], ",", 
   RowBox[{"8", "\[Rule]", "Times"}], ",", 
   RowBox[{"9", "\[Rule]", "Plus"}], ",", 
   RowBox[{"10", "\[Rule]", "Times"}], ",", 
   RowBox[{"11", "\[Rule]", "Plus"}], ",", 
   RowBox[{"12", "\[Rule]", "a"}], ",", 
   RowBox[{"13", "\[Rule]", "b"}], ",", 
   RowBox[{"14", "\[Rule]", "c"}], ",", 
   RowBox[{"15", "\[Rule]", "d"}], ",", 
   RowBox[{"16", "\[Rule]", "e"}], ",", 
   RowBox[{"17", "\[Rule]", "Times"}], ",", 
   RowBox[{"18", "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{"19", "\[Rule]", "f"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8147836868520784`*^9, 3.814784400309225*^9, 
  3.8147918003413944`*^9, 3.81480911733142*^9, 3.8148096757883067`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[33]:=",ExpressionUUID->"84c7e777-9cff-4aeb-bcb2-fdf15dbba190"]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 8, 17, 3, 4, 7, 5, 6, 9, 16, 10, 15, 11, 14, 12, 13, 18, 
      19}, {Null, {{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {2, 7}, {6, 8}, {6,
        9}, {3, 10}, {3, 11}, {10, 12}, {10, 13}, {12, 14}, {12, 15}, {14, 
       16}, {14, 17}, {4, 18}, {4, 19}}}, {
      ImagePadding -> 10, VertexCoordinates -> CompressedData["
1:eJxTTMoPSmViYGAQBmIQfelDp/4DVWaHL1fWPIso5XXQKt/7Wnjic3sIze7g
csI17+M8FgcY/62j0Ka9xgJwPgMUxEue+3BuDSNcPyr/Oxr/uj2q+Ed7dHWo
6tnhfIg7/8LVo7rvO1xcA80dqPyP9jB3w8xD5fM6oLpDEM4HANtVjq4=
        "], VertexLabels -> {"Name"}, VertexShapeFunction -> {"Circle"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQAmImKL70oVP/gSqzw5cra55FlPI6aJXvfS088bk9hGZ3
QJd3OeGa93EeiwMu+beOQpv2GgvA5dHNY4CCeMlzH86tYcSQh/Hxy3+Hy6O7
ByaOSx5dHbp7Yf7AJQ8RF3RAdx8q/7o9zJ3o8hD6oz26P2A0xP6/OOVR/fPd
Hl09jNaA2ovLPA2UcEWoh7kPFk+4zIPJAwAFbhKY
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.393494006535641, 3.6822984715932936}, 
          0.03961715909632617], 
         InsetBox["1", 
          Offset[{2, 2}, {2.433111165631967, 3.7219156306896197}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7364596943186588, 2.945838777274635}, 
          0.03961715909632617], 
         InsetBox["2", 
          Offset[{2, 2}, {0.7760768534149849, 2.985455936370961}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.5776089301153053, 2.945838777274635}, 
          0.03961715909632617], 
         InsetBox["8", 
          Offset[{2, 2}, {2.6172260892116315, 2.985455936370961}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.050528318752623, 2.945838777274635}, 0.03961715909632617],
          InsetBox["17", 
          Offset[{2, 2}, {4.090145477848949, 2.985455936370961}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 2.209379082955976}, 0.03961715909632617], 
         InsetBox["3", 
          Offset[{2, 2}, {0.03961715909632617, 2.248996242052302}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7364596943186588, 2.209379082955976}, 
          0.03961715909632617], 
         InsetBox["4", 
          Offset[{2, 2}, {0.7760768534149849, 2.248996242052302}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.4729193886373175, 2.209379082955976}, 
          0.03961715909632617], 
         InsetBox["7", 
          Offset[{2, 2}, {1.5125365477336437, 2.248996242052302}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.3682298471593294, 1.4729193886373175}, 
          0.03961715909632617], 
         InsetBox["5", 
          Offset[{2, 2}, {0.40784700625565556, 1.5125365477336437}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.104689541477988, 1.4729193886373175}, 
          0.03961715909632617], 
         InsetBox["6", 
          Offset[{2, 2}, {1.1443067005743142, 1.5125365477336437}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.209379082955976, 2.209379082955976}, 0.03961715909632617],
          InsetBox["9", 
          Offset[{2, 2}, {2.248996242052302, 2.248996242052302}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.945838777274635, 2.209379082955976}, 0.03961715909632617],
          InsetBox["16", 
          Offset[{2, 2}, {2.985455936370961, 2.248996242052302}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8411492357966468, 1.4729193886373175}, 
          0.03961715909632617], 
         InsetBox["10", 
          Offset[{2, 2}, {1.880766394892973, 1.5125365477336437}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.5776089301153053, 1.4729193886373175}, 
          0.03961715909632617], 
         InsetBox["15", 
          Offset[{2, 2}, {2.6172260892116315, 1.5125365477336437}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.4729193886373175, 0.7364596943186585}, 
          0.03961715909632617], 
         InsetBox["11", 
          Offset[{2, 2}, {1.5125365477336437, 0.7760768534149847}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.209379082955976, 0.7364596943186585}, 
          0.03961715909632617], 
         InsetBox["14", 
          Offset[{2, 2}, {2.248996242052302, 0.7760768534149847}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.104689541477988, 0.}, 0.03961715909632617], 
         InsetBox["12", 
          Offset[{2, 2}, {1.1443067005743142, 0.03961715909632617}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8411492357966468, 0.}, 0.03961715909632617], 
         InsetBox["13", 
          Offset[{2, 2}, {1.880766394892973, 0.03961715909632617}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.6822984715932936, 2.209379082955976}, 
          0.03961715909632617], 
         InsetBox["18", 
          Offset[{2, 2}, {3.7219156306896197, 2.248996242052302}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.418758165911952, 2.209379082955976}, 0.03961715909632617],
          InsetBox["19", 
          Offset[{2, 2}, {4.458375325008278, 2.248996242052302}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.814783688021937*^9, 3.8147844004216385`*^9, 
  3.8147918004552555`*^9, 3.814809118502003*^9, 3.814809675851619*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"cd401b2c-05af-4704-8f46-6697865f7219"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "[", 
  RowBox[{
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", " ", 
     RowBox[{"Plus", "[", 
      RowBox[{"a", ",", " ", "b"}], "]"}], ",", " ", "c"}], "]"}], ",", " ", 
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"Plus", "[", 
      RowBox[{
       RowBox[{"Times", "[", 
        RowBox[{
         RowBox[{"Plus", "[", 
          RowBox[{"a", ",", " ", "b"}], "]"}], ",", " ", "c"}], "]"}], ",", 
       " ", "d"}], "]"}], ",", " ", "e"}], "]"}], ",", " ", 
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", " ", "f"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8147910885666094`*^9, 3.814791091040253*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"dc235ef7-4ad7-48ad-a155-d2ef9e66fd18"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}]}], " ", "c"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", "c"}], "+", "d"}], ")"}], " ", 
   "e"}], "-", "f"}]], "Output",
 CellChangeTimes->{3.8147910918881474`*^9, 3.814791804527443*^9, 
  3.814809122420663*^9, 3.814809682485381*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"a858b895-628f-464a-b896-a160c629a0d2"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"d933d951-f399-4de5-ac00-f2366d78a47f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"9055b7e6-6f57-4733-9449-ca68bdd5ff7f"],
Cell[CellGroupData[{
Cell[783, 27, 901, 21, 177, "Input",ExpressionUUID->"e74c3999-7112-4367-8f98-60b3e56d1e57"],
Cell[1687, 50, 1276, 26, 847, "Output",ExpressionUUID->"ef7fbeaa-a28d-460e-8cb9-10abe94d7216"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3000, 81, 1141, 29, 177, "Input",ExpressionUUID->"00a15508-e4f2-4588-ace9-3d080b9d25f4"],
Cell[4144, 112, 3242, 67, 608, "Output",ExpressionUUID->"5e9183c2-47a9-4320-8d30-3c23b403bf2c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7423, 184, 1621, 42, 224, "Input",ExpressionUUID->"1cabad2f-3ef8-477e-ae3e-ca2461f4a911"],
Cell[9047, 228, 4037, 88, 753, "Output",ExpressionUUID->"5546d6e1-5807-421e-98ab-d1c1fe5f8996"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13121, 321, 2004, 52, 266, "Input",ExpressionUUID->"d053c215-b816-4181-acaf-7db888278af6"],
Cell[15128, 375, 5141, 112, 861, "Output",ExpressionUUID->"4cbfbeee-6852-4f3f-b4ba-c4c3ee6301f7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20306, 492, 2260, 59, 266, "Input",ExpressionUUID->"81e6eaca-a1ce-45c9-b22b-aea1e68e2cee"],
Cell[22569, 553, 5855, 127, 946, "Output",ExpressionUUID->"60fc9dae-f7b7-4c1f-8cbc-3f694a3ae347"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28461, 685, 555, 18, 63, "Input",ExpressionUUID->"97db7ab2-d302-4a7e-a516-64e508c4db30"],
Cell[CellGroupData[{
Cell[29041, 707, 374, 6, 50, "Print",ExpressionUUID->"c158421c-e8fd-46d1-89e5-eec0f0329eae"],
Cell[29418, 715, 1145, 28, 171, "Print",ExpressionUUID->"84c7e777-9cff-4aeb-bcb2-fdf15dbba190"]
}, Open  ]],
Cell[30578, 746, 6291, 138, 644, "Output",ExpressionUUID->"cd401b2c-05af-4704-8f46-6697865f7219"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36906, 889, 778, 21, 287, "Input",ExpressionUUID->"dc235ef7-4ad7-48ad-a155-d2ef9e66fd18"],
Cell[37687, 912, 502, 15, 107, "Output",ExpressionUUID->"a858b895-628f-464a-b896-a160c629a0d2"]
}, Open  ]]
}
]
*)

