(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    158654,       3857]
NotebookOptionsPosition[    143620,       3617]
NotebookOutlinePosition[    144084,       3635]
CellTagsIndexPosition[    144041,       3632]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8068623540125313`*^9, 3.806862362882429*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"7e4ff91b-a7cc-4c8c-bb06-658b785815fa"],

Cell["3.5.1", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}},ExpressionUUID->"dc012f09-9819-4927-93de-\
4f85e023b46b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PruebaADA2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"NFibonacci", ",", "NFibonacciCola"}], "}"}], ",", "30", ",", 
   "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.8087629680381756`*^9, 3.8087630005632505`*^9}, {
  3.808763046149976*^9, 3.8087630463953185`*^9}, {3.8087632509765186`*^9, 
  3.8087632511721363`*^9}, {3.8087634444841485`*^9, 3.8087634447295027`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"98956550-5117-4a83-a286-18ec726d8cef"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "1"}],
  SequenceForm["El primer algoritmo fue mejor: ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.808763465980109*^9, 3.82689636662831*^9, 3.8270021067393446`*^9, {
   3.827002427002369*^9, 3.8270024550147667`*^9}, 3.8270507406244936`*^9, 
   3.82758649025562*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"912bc2f2-81f3-4e98-9094-0353b0d1059a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El segundo algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "14"}],
  SequenceForm["El segundo algoritmo fue mejor: ", 14],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.808763465980109*^9, 3.82689636662831*^9, 3.8270021067393446`*^9, {
   3.827002427002369*^9, 3.8270024550147667`*^9}, 3.8270507406244936`*^9, 
   3.827586490259871*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"d0d74c2f-5bfb-48ca-af41-85acc0a891d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se comportaron igual: \"\>", "\[InvisibleSpace]", "15"}],
  SequenceForm["Se comportaron igual: ", 15],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.808763465980109*^9, 3.82689636662831*^9, 3.8270021067393446`*^9, {
   3.827002427002369*^9, 3.8270024550147667`*^9}, 3.8270507406244936`*^9, 
   3.8275864902638597`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"85a28458-beae-4001-8bde-7b52a7e57cdd"]
}, Open  ]]
}, Open  ]],

Cell["3.5.2", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 
  3.8087631320099087`*^9}},ExpressionUUID->"44bb5b99-f4e4-4679-a310-\
68ffc308894d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"a", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}], "-", 
   RowBox[{"3", 
    RowBox[{"a", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", 
   SqrtBox["2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "2", "]"}], "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Recurrencia", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "1"}], ",", 
    SqrtBox["2"], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"n", "\[Equal]", "2"}], ",", "1", ",", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"Recurrencia", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}], "-", 
       RowBox[{"3", 
        RowBox[{"Recurrencia", "[", 
         RowBox[{"n", "-", "2"}], "]"}]}]}]}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8087399874760914`*^9, 3.808740098331442*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"fb08fe43-f64b-47db-bc82-c7eb6a9b8b10"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PruebaADA2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "Recurrencia"}], "}"}], ",", "30", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8087631578904295`*^9, 3.8087631858301907`*^9}, {
   3.808763217626605*^9, 3.8087632467631273`*^9}, 3.8087635092372203`*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"f6a8e7ae-da65-43ef-b382-9afcbbb4715d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "13"}],
  SequenceForm["El primer algoritmo fue mejor: ", 13],
  Editable->False]], "Print",
 CellChangeTimes->{3.8087635368392925`*^9, 3.826896509118019*^9, 
  3.827002156237796*^9, 3.827002489747697*^9, 3.827050766946292*^9, 
  3.827586534244585*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"54081480-0e5f-4416-ba9d-148809ff3eb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El segundo algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "2"}],
  SequenceForm["El segundo algoritmo fue mejor: ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.8087635368392925`*^9, 3.826896509118019*^9, 
  3.827002156237796*^9, 3.827002489747697*^9, 3.827050766946292*^9, 
  3.8275865342465796`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"e5870015-3e4f-4f92-92b0-acf3399d48ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se comportaron igual: \"\>", "\[InvisibleSpace]", "15"}],
  SequenceForm["Se comportaron igual: ", 15],
  Editable->False]], "Print",
 CellChangeTimes->{3.8087635368392925`*^9, 3.826896509118019*^9, 
  3.827002156237796*^9, 3.827002489747697*^9, 3.827050766946292*^9, 
  3.827586534249572*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"f5e67fb5-2283-441f-b786-58df5ab4da0c"]
}, Open  ]]
}, Open  ]],

Cell["3.5.3", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 
  3.808763729558936*^9}},ExpressionUUID->"698c98ea-ced3-495c-b475-\
31bf38652083"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"MCD1", "[", 
   RowBox[{
    RowBox[{"n_", ":", "1000"}], ",", "m_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "0"}], ",", "m", ",", 
    RowBox[{"MCD1", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"m", ",", "n"}], "]"}], ",", "n"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MCD2", "[", 
   RowBox[{
    RowBox[{"n_", ":", "1000"}], ",", "m_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "0"}], ",", "m", ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"m", "\[Equal]", "0"}], ",", "n", ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"n", "\[GreaterEqual]", "m"}], ",", 
        RowBox[{"MCD2", "[", 
         RowBox[{
          RowBox[{"n", "-", "m"}], ",", "m"}], "]"}], ",", 
        RowBox[{"MCD2", "[", 
         RowBox[{"n", ",", 
          RowBox[{"m", "-", "n"}]}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.8087407959113264`*^9, 3.8087409813378515`*^9}, {
  3.8087637919444256`*^9, 3.8087638066956615`*^9}, {3.8087638481194267`*^9, 
  3.808763868682952*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"c8d38012-216f-40dd-9f15-8ad38fbaa72e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PruebaADA2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"MCD1", ",", "MCD2"}], "}"}], ",", "2000", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8087631578904295`*^9, 3.8087631858301907`*^9}, {
   3.808763217626605*^9, 3.8087632467631273`*^9}, 3.8087635092372203`*^9, {
   3.8087637606182117`*^9, 3.8087637674957457`*^9}, {3.8087638313583536`*^9, 
   3.8087638437264605`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"6ed0897f-d60e-495c-99d1-753c7b638e33"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "10"}],
  SequenceForm["El primer algoritmo fue mejor: ", 10],
  Editable->False]], "Print",
 CellChangeTimes->{3.8087638739797564`*^9, 3.826896523030246*^9, 
  3.8270021666089025`*^9, 3.8270024950757933`*^9, 3.8270507727174473`*^9, 
  3.827586540963217*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"bf57fc7f-9609-483b-85ff-2629a6a41357"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El segundo algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "0"}],
  SequenceForm["El segundo algoritmo fue mejor: ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.8087638739797564`*^9, 3.826896523030246*^9, 
  3.8270021666089025`*^9, 3.8270024950757933`*^9, 3.8270507727174473`*^9, 
  3.827586540965617*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"8fe462db-3114-4a94-99cb-e449e29f6608"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se comportaron igual: \"\>", "\[InvisibleSpace]", "1990"}],
  SequenceForm["Se comportaron igual: ", 1990],
  Editable->False]], "Print",
 CellChangeTimes->{3.8087638739797564`*^9, 3.826896523030246*^9, 
  3.8270021666089025`*^9, 3.8270024950757933`*^9, 3.8270507727174473`*^9, 
  3.827586540968681*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"9716d69c-de2a-4a4d-91c6-9570284c8d9f"]
}, Open  ]]
}, Open  ]],

Cell["3.5.4", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}},ExpressionUUID->"91984062-9c9b-42fb-a458-\
846333882087"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PruebaADA2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Seleccion", ",", "Insercion"}], "}"}], ",", "200", ",", "1", ",", 
   RowBox[{"lista", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8087631578904295`*^9, 3.8087631858301907`*^9}, {
   3.808763217626605*^9, 3.8087632467631273`*^9}, 3.8087635092372203`*^9, {
   3.8087637606182117`*^9, 3.8087637674957457`*^9}, {3.8087638313583536`*^9, 
   3.8087638437264605`*^9}, {3.8087640067014503`*^9, 3.8087640411884775`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"3b642d6d-ad88-4bb0-83ca-7585ebc243b3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "58"}],
  SequenceForm["El primer algoritmo fue mejor: ", 58],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8087640297157755`*^9, 3.8087640524315476`*^9}, 
   3.8268965335301113`*^9, 3.8270021746013994`*^9, 3.8270025042578473`*^9, 
   3.8270507792208376`*^9, 3.8275865479328537`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"4ecd1e27-c8a1-4fac-994e-65e553b4ad48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El segundo algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "31"}],
  SequenceForm["El segundo algoritmo fue mejor: ", 31],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8087640297157755`*^9, 3.8087640524315476`*^9}, 
   3.8268965335301113`*^9, 3.8270021746013994`*^9, 3.8270025042578473`*^9, 
   3.8270507792208376`*^9, 3.8275865479358325`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"c9f5408c-a8f6-4978-a860-2260d99d7e0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se comportaron igual: \"\>", "\[InvisibleSpace]", "111"}],
  SequenceForm["Se comportaron igual: ", 111],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8087640297157755`*^9, 3.8087640524315476`*^9}, 
   3.8268965335301113`*^9, 3.8270021746013994`*^9, 3.8270025042578473`*^9, 
   3.8270507792208376`*^9, 3.827586547937828*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"0c5afca5-f94d-4231-b4bc-b5e1acb9936d"]
}, Open  ]]
}, Open  ]],

Cell["3.5.5", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 
  3.8087651165055065`*^9}},ExpressionUUID->"0042b054-4e97-4367-a662-\
e65afa084b88"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QS", "[", "L_List", "]"}], " ", ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Rbegin", "=", "1"}], ",", 
      RowBox[{"Rend", "=", 
       RowBox[{"Length", "[", "L", "]"}]}], ",", "Quicksort"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Quicksort", "[", 
       RowBox[{"RRbegin_", ",", "RRend_"}], "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"RList7", "=", "L"}], "}"}], ",", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"RRbegin", "<", "RRend"}], ",", " ", 
           RowBox[{
            RowBox[{"Ri2", "=", "RRbegin"}], ";", " ", 
            RowBox[{"Ri3", "=", "RRend"}], ";", 
            RowBox[{"RVl20", "=", 
             RowBox[{"RList7", "[", 
              RowBox[{"[", 
               RowBox[{"Floor", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"RRbegin", "+", "RRend"}], ")"}], "/", "2"}], "]"}],
                "]"}], "]"}]}], ";", 
            RowBox[{"While", "[", 
             RowBox[{
              RowBox[{"Ri2", "<=", "Ri3"}], ",", " ", 
              RowBox[{
               RowBox[{"While", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"RList7", "[", 
                   RowBox[{"[", "Ri2", "]"}], "]"}], "<", "RVl20"}], ",", " ", 
                 RowBox[{"Ri2", "++"}]}], "]"}], ";", 
               RowBox[{"While", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"RList7", "[", 
                   RowBox[{"[", "Ri3", "]"}], "]"}], ">", "RVl20"}], ",", 
                 RowBox[{"Ri3", "--"}]}], "]"}], ";", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"Ri2", "<=", "Ri3"}], ",", 
                 RowBox[{
                  RowBox[{"RVl21", "=", 
                   RowBox[{"RList7", "[", 
                    RowBox[{"[", "Ri2", "]"}], "]"}]}], ";", " ", 
                  RowBox[{
                   RowBox[{"RList7", "[", 
                    RowBox[{"[", "Ri2", "]"}], "]"}], "=", 
                   RowBox[{"RList7", "[", 
                    RowBox[{"[", "Ri3", "]"}], "]"}]}], ";", " ", 
                  RowBox[{
                   RowBox[{"RList7", "[", 
                    RowBox[{"[", "Ri3", "]"}], "]"}], "=", "RVl21"}], ";", 
                  RowBox[{"Ri2", "++"}], ";", " ", 
                  RowBox[{"Ri3", "--"}]}]}], "]"}]}]}], "]"}], ";", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"RRbegin", "<", "Ri3"}], ",", 
              RowBox[{"Quicksort", "[", 
               RowBox[{"RRbegin", ",", "Ri3"}], "]"}]}], "]"}], ";", " ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"Ri2", "<", "RRend"}], ",", 
              RowBox[{"Quicksort", "[", 
               RowBox[{"Ri2", ",", " ", "RRend"}], "]"}]}], "]"}]}]}], "]"}], 
         ";", "RList7"}]}], "]"}]}], ";", 
     RowBox[{"Quicksort", "[", 
      RowBox[{"Rbegin", ",", "Rend"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8087644245838723`*^9, 3.808764447354187*^9}, {
   3.808764479011816*^9, 3.808764551393484*^9}, {3.8087645816323247`*^9, 
   3.8087645820620575`*^9}, {3.808764651207777*^9, 3.8087647171041937`*^9}, 
   3.80876486933996*^9, {3.8087649042678947`*^9, 3.8087649164769692`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"f40c7ae8-621c-4c1e-98b0-9baba43adaf5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PruebaADA2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Burbuja", ",", "QS"}], "}"}], ",", "200", ",", "1", ",", 
   RowBox[{"lista", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8087631578904295`*^9, 3.8087631858301907`*^9}, {
   3.808763217626605*^9, 3.8087632467631273`*^9}, 3.8087635092372203`*^9, {
   3.8087637606182117`*^9, 3.8087637674957457`*^9}, {3.8087638313583536`*^9, 
   3.8087638437264605`*^9}, {3.8087640067014503`*^9, 
   3.8087640411884775`*^9}, {3.8087641962014284`*^9, 
   3.8087642143094387`*^9}, {3.8087649360009403`*^9, 3.808764952476012*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"79e5646b-1661-4d90-b169-5fd84c1d4765"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "15"}],
  SequenceForm["El primer algoritmo fue mejor: ", 15],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8087642151267633`*^9, {3.8087649411556315`*^9, 3.8087649572435417`*^9}, 
   3.8268965492303486`*^9, 3.82700251546027*^9, 3.8270507900946665`*^9, 
   3.827586557978244*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[13]:=",ExpressionUUID->"48d66b39-1692-46da-aca0-8dbc0a7bbc46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El segundo algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "113"}],
  SequenceForm["El segundo algoritmo fue mejor: ", 113],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8087642151267633`*^9, {3.8087649411556315`*^9, 3.8087649572435417`*^9}, 
   3.8268965492303486`*^9, 3.82700251546027*^9, 3.8270507900946665`*^9, 
   3.827586557980691*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[13]:=",ExpressionUUID->"1cfa842f-762a-408f-8d7d-ab2e679a2506"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se comportaron igual: \"\>", "\[InvisibleSpace]", "72"}],
  SequenceForm["Se comportaron igual: ", 72],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8087642151267633`*^9, {3.8087649411556315`*^9, 3.8087649572435417`*^9}, 
   3.8268965492303486`*^9, 3.82700251546027*^9, 3.8270507900946665`*^9, 
   3.8275865579836845`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[13]:=",ExpressionUUID->"daa28d19-a0a3-4d85-9685-af570f5b52e7"]
}, Open  ]]
}, Open  ]],

Cell["3.5.6", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 
  3.808765139453682*^9}},ExpressionUUID->"fcfaf35f-bfd7-4933-84b2-\
3bb38b6db2a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNAP", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       SuperscriptBox["n", "i"], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "j"}], "}"}]}], "]"}], ",", 
     SuperscriptBox["n", "j"]}], "}"}], ",", "0.01", ",", "10", ",", "1000", 
   ",", "10"}], "]"}]], "Input",
 CellChangeTimes->{{3.8087651614437075`*^9, 3.808765259365206*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"707cb223-ce67-4505-98f0-47fb04d37a5b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala3$$ = 3, VilCretas`Private`Alb3$$ = 
    3, VilCretas`Private`Alc2$$ = 0.01, VilCretas`Private`Alj1$$ = 1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc2$$], 0.01, "c"}, 0.01, 10, 0.01}, {{
       Hold[VilCretas`Private`Alj1$$], 1, "j"}, 1, 10, 1}, {{
       Hold[VilCretas`Private`Ala3$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb3$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {270., {105.19999999999999`, 113.19999999999999`}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala3$$ = 3, VilCretas`Private`Alb3$$ = 3, 
        VilCretas`Private`Alc2$$ = 0.01, VilCretas`Private`Alj1$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         Show[
          Plot[{
            Evaluate[
             And[
              Abs[
               Together[
                Expand[
                 Evaluate[
                  ReplaceAll[
                   Normal[
                    Series[
                    VilCretas`Private`Alf3[
                    VilCretas`Private`n, VilCretas`Private`Alj1$$], {
                    VilCretas`Private`n, Infinity, 2}]], VilCretas`Private`n -> 
                   VilCretas`Private`x]]]]], 
              Normal[
               FunctionDomain[
                Abs[
                 Together[
                  Expand[
                   Evaluate[
                    ReplaceAll[
                    Normal[
                    Series[
                    VilCretas`Private`Alf3[
                    VilCretas`Private`n, VilCretas`Private`Alj1$$], {
                    VilCretas`Private`n, Infinity, 2}]], VilCretas`Private`n -> 
                    VilCretas`Private`x]]]]], VilCretas`Private`x, 
                Method -> {"Reduced" -> False}]]]], 
            Evaluate[
             And[
              Abs[VilCretas`Private`Alc2$$ Together[
                 Expand[
                  Evaluate[
                   ReplaceAll[
                    Normal[
                    Series[
                    VilCretas`Private`Alf4[
                    VilCretas`Private`n, VilCretas`Private`Alj1$$], {
                    VilCretas`Private`n, Infinity, 2}]], VilCretas`Private`n -> 
                    VilCretas`Private`x]]]]], 
              Normal[
               FunctionDomain[
                Abs[VilCretas`Private`Alc2$$ Together[
                   Expand[
                    Evaluate[
                    ReplaceAll[
                    Normal[
                    Series[
                    VilCretas`Private`Alf4[
                    VilCretas`Private`n, VilCretas`Private`Alj1$$], {
                    VilCretas`Private`n, Infinity, 2}]], VilCretas`Private`n -> 
                    VilCretas`Private`x]]]]], VilCretas`Private`x, 
                Method -> {"Reduced" -> False}]]]]}, {
           VilCretas`Private`x, 0.0001, VilCretas`Private`Ala3$$}, PlotRange -> 
           VilCretas`Private`Alb3$$, PlotStyle -> {Thick}], 
          Graphics[{
            Text[
             Style["|f|", 10, Bold], {1.0001, 
              ReplaceAll[
               Abs[
                Together[
                 Expand[
                  Evaluate[
                   ReplaceAll[
                    Normal[
                    Series[
                    VilCretas`Private`Alf3[
                    VilCretas`Private`n, VilCretas`Private`Alj1$$], {
                    VilCretas`Private`n, Infinity, 2}]], VilCretas`Private`n -> 
                    VilCretas`Private`x]]]]], VilCretas`Private`x -> 
               1.0001]}], 
            Text[
             Style["c*|g|", 10, Bold], {1.5001, 
              ReplaceAll[
               Abs[VilCretas`Private`Alc2$$ Together[
                  Expand[
                   Evaluate[
                    ReplaceAll[
                    Normal[
                    Series[
                    VilCretas`Private`Alf4[
                    VilCretas`Private`n, VilCretas`Private`Alj1$$], {
                    VilCretas`Private`n, Infinity, 2}]], VilCretas`Private`n -> 
                    VilCretas`Private`x]]]]], VilCretas`Private`x -> 
               1.5001]}]}]], 
         Row[{"f(n)=", 
           Together[
            Expand[
             Evaluate[
              ReplaceAll[
               Normal[
                Series[
                 VilCretas`Private`Alf3[
                 VilCretas`Private`n, VilCretas`Private`Alj1$$], {
                 VilCretas`Private`n, Infinity, 2}]], 
               VilCretas`Private`n -> $CellContext`n]]]]}], 
         Row[{"g(n)=", 
           Together[
            Expand[
             Evaluate[
              ReplaceAll[
               Normal[
                Series[
                 VilCretas`Private`Alf4[
                 VilCretas`Private`n, VilCretas`Private`Alj1$$], {
                 VilCretas`Private`n, Infinity, 2}]], 
               VilCretas`Private`n -> $CellContext`n]]]]}]}, Center], 
      "Specifications" :> {{{VilCretas`Private`Alc2$$, 0.01, "c"}, 0.01, 10, 
         0.01, Appearance -> "Open"}, {{VilCretas`Private`Alj1$$, 1, "j"}, 1, 
         10, 1}, Delimiter, {{
         VilCretas`Private`Ala3$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb3$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{515., {224., 232.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((Clear[$CellContext`n, $CellContext`j, $CellContext`x]; 
      VilCretas`Private`Alf3[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            First[{(-1 + $CellContext`n)^(-1) (-1 + $CellContext`n^(
                 1 + $CellContext`j)), $CellContext`n^$CellContext`j}]]]], \
{$CellContext`n -> VilCretas`Private`Aln$, $CellContext`j -> 
          VilCretas`Private`Alj$}]; VilCretas`Private`Alf4[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            Last[{(-1 + $CellContext`n)^(-1) (-1 + $CellContext`n^(
                 1 + $CellContext`j)), $CellContext`n^$CellContext`j}]]]], \
{$CellContext`n -> VilCretas`Private`Aln$, $CellContext`j -> 
          VilCretas`Private`Alj$}]); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.808850974870865*^9, 3.8088510059475904`*^9}, 
   3.826896553213581*^9, 3.8270025219140954`*^9, 3.82705079246704*^9, 
   3.8275865609531374`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"e6f01d88-b64b-4c9a-bbd0-e30a61b72165"]
}, Open  ]],

Cell["3.5.7", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.8087653372790513`*^9, 
  3.808765337820572*^9}},ExpressionUUID->"fc898be7-5ebd-492c-ace1-\
584ab8bee358"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sum", "[", 
     RowBox[{
      FractionBox["1", "i"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], 
    RowBox[{"Log", "[", "n", "]"}]], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8087659584007144`*^9, 3.8087659983803415`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"748cae56-b45e-4ffd-a3d9-d12fd831bdee"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.808765999346841*^9, 3.8268965577420607`*^9, 
  3.8270025321153736`*^9, 3.827050795525713*^9, 3.8275865647255993`*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"2c85b094-2fec-4163-aa41-d319d8c870fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       FractionBox["1", "i"], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
     RowBox[{"Log", "[", "n", "]"}]}], "}"}], ",", "0.01", ",", "10", ",", 
   "1000"}], "]"}]], "Input",
 CellChangeTimes->{{3.808766008978196*^9, 3.808766033776822*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"26af1378-6161-4c5f-ba15-0b95b5e35922"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.01, "c"}, 0.01, 10, 0.01}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {540., {168., 175.06084530388466`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.01, "c"}, 0.01, 10, 
         0.01, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{606., {274., 282.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{
  3.808766034960718*^9, 3.8088462992660317`*^9, 3.808849521203737*^9, {
   3.8088509842446923`*^9, 3.808851010187759*^9}, 3.8268965596636906`*^9, 
   3.827002533700039*^9, 3.82705079770842*^9, 3.827586566660947*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"36965766-a9c5-44b4-8d5e-44608420074e"]
}, Open  ]],

Cell["3.5.8", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.8087653439608307`*^9, 
  3.80876534458994*^9}},ExpressionUUID->"6a57d7b7-914e-4524-8e41-\
4f5319e9c9cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    FractionBox[
     RowBox[{
      SuperscriptBox["n", "3"], "+", "5"}], 
     RowBox[{
      RowBox[{"5", "n"}], "+", "2"}]], 
    SuperscriptBox["n", "2"]], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8087661151195035`*^9, 3.8087661377510138`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"e91e06b6-3f36-4037-b29a-5eceac19fb2a"],

Cell[BoxData[
 FractionBox["1", "5"]], "Output",
 CellChangeTimes->{3.8087661395166593`*^9, 3.8268965632638054`*^9, 
  3.8270025378917265`*^9, 3.827050800633148*^9, 3.8275865699351187`*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"119d8afb-c3c5-4f9b-84e6-297433bbb9de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["n", "3"], "+", "5"}], 
      RowBox[{
       RowBox[{"5", "n"}], "+", "2"}]], ",", 
     SuperscriptBox["n", "2"]}], "}"}], ",", "0.01", ",", "10", ",", "1000"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.808766157906784*^9, 3.8087661632844167`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"11aacdfa-5033-41e2-a2cc-ddd0400735f4"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.01, "c"}, 0.01, 10, 0.01}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {540., {168., 175.06084530388466`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.01, "c"}, 0.01, 10, 
         0.01, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{606., {274., 282.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.808766166331606*^9, 3.8088463026828356`*^9, 
  3.8088495243187137`*^9, 3.808851014775696*^9, 3.826896564896866*^9, 
  3.8270025399334*^9, 3.827050803033887*^9, 3.8275865719321585`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"5aa14178-38f8-4a5f-a180-ffcfd46a4448"]
}, Open  ]],

Cell["3.5.9", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765346211464*^9, 
  3.8087653467966156`*^9}},ExpressionUUID->"8da46b7c-5d90-4488-af83-\
add2f480df2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"Log", "[", "n", "]"}]}], 
    SuperscriptBox["n", "2"]], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8087661151195035`*^9, 3.8087661377510138`*^9}, {
  3.8087665100186996`*^9, 3.808766513567294*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"c8c4a3e8-1e82-4377-8e76-95736f4282a4"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.8087665174766073`*^9, 3.8268965684303336`*^9, 
  3.827002543536434*^9, 3.827050805929902*^9, 3.8275865748581915`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"b532e924-468b-4c40-841d-42ee97e1a67d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"n", " ", 
       RowBox[{"Log", "[", "n", "]"}]}], 
      SuperscriptBox["n", "2"]], ",", 
     SuperscriptBox["n", "2"]}], "}"}], ",", "0.01", ",", "10", ",", "1000"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.808766157906784*^9, 3.8087661632844167`*^9}, 
   3.808766527300975*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"67ca2ae2-6df6-4892-a74c-a96d1b3448a4"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.01, "c"}, 0.01, 10, 0.01}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {540., {168., 175.06084530388466`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.01, "c"}, 0.01, 10, 
         0.01, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{606., {274., 282.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.808766530089575*^9, 3.8088463062897005`*^9, 
  3.808849530148815*^9, 3.80885101910287*^9, 3.8268965703304653`*^9, 
  3.8270025457245293`*^9, 3.8270508079731836`*^9, 3.827586576822095*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"9d7da3a9-a6b0-4e6a-be7d-1dd46237e908"]
}, Open  ]],

Cell["3.5.10", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765346211464*^9, 3.8087653467966156`*^9}, {3.8087664894939384`*^9, 
  3.8087664897173367`*^9}},ExpressionUUID->"4355d957-1f17-4904-824a-\
565c17a2cf08"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["n", 
      SuperscriptBox["2", "n"]], "+", 
     SuperscriptBox["n", 
      SuperscriptBox["n", "2"]]}], 
    SuperscriptBox["n", 
     SuperscriptBox["2", "n"]]], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8087661151195035`*^9, 3.8087661377510138`*^9}, {
  3.808766307313426*^9, 3.8087663328249836`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"63304652-a467-474c-a57f-48dea1574c59"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.808766345711532*^9, 3.8268965736968784`*^9, 
  3.8270025490401325`*^9, 3.827050810940387*^9, 3.8275865799161463`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"796defd9-bf9d-4d8f-bfee-9d10f56835db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["n", 
       SuperscriptBox["2", "n"]], "+", 
      SuperscriptBox["n", 
       SuperscriptBox["n", "2"]]}], ",", 
     SuperscriptBox["n", 
      SuperscriptBox["2", "n"]]}], "}"}], ",", "0.01", ",", "10", ",", 
   "1000"}], "]"}]], "Input",
 CellChangeTimes->{{3.808766157906784*^9, 3.8087661632844167`*^9}, {
  3.8087663645506544`*^9, 3.80876637013391*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"c3fe80df-4676-49b8-ba46-30274ffd0e60"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.01, "c"}, 0.01, 10, 0.01}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {540., {168., 175.06084530388466`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.01, "c"}, 0.01, 10, 
         0.01, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{606., {274., 282.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.8087663727671323`*^9, 3.8088463105481844`*^9, 
  3.80884953424551*^9, 3.808851023880815*^9, 3.8268965755543594`*^9, 
  3.8270025507488523`*^9, 3.827050812669448*^9, 3.8275865825102262`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"a14923ab-9fa2-4f53-9858-5493d1f9896d"]
}, Open  ]],

Cell["3.5.11", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.8087653512507763`*^9}},ExpressionUUID->"7a21cd77-c9d7-401c-98b9-\
81134b06e937"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sum", "[", 
     RowBox[{
      SuperscriptBox["i", "2"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], 
    SuperscriptBox["n", "3"]], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8087661151195035`*^9, 3.8087661377510138`*^9}, {
  3.8087666789729156`*^9, 3.808766696070645*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"89e76a5d-b9c5-4f53-9f49-a110edbb016c"],

Cell[BoxData[
 FractionBox["1", "3"]], "Output",
 CellChangeTimes->{3.80876671823393*^9, 3.8268965789135723`*^9, 
  3.8270025541042795`*^9, 3.827050815777881*^9, 3.827586585471141*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"7c44aa99-857a-47de-9582-cccb4661d33a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       SuperscriptBox["i", "2"], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
     SuperscriptBox["n", "3"]}], "}"}], ",", "0.01", ",", "10", ",", "1000"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.808766157906784*^9, 3.8087661632844167`*^9}, {
  3.808766708895194*^9, 3.80876671161505*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"9938fc7b-bbb2-44b7-9829-8eb2af5e0bb1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.01, "c"}, 0.01, 10, 0.01}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {540., {168., 175.06084530388466`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.01, "c"}, 0.01, 10, 
         0.01, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{606., {274., 282.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.8087667218765926`*^9, 3.808846315411998*^9, 
  3.8088495378128424`*^9, 3.80885102781866*^9, 3.8268965814971886`*^9, 
  3.82700255689244*^9, 3.8270508178448277`*^9, 3.827586587845676*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[24]:=",ExpressionUUID->"e5bbfcd4-737e-4ecf-baac-ce5cf54b1d15"]
}, Open  ]],

Cell["3.5.12", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.808765371388026*^9}},ExpressionUUID->"6d7f2e52-b7b9-4bcd-940b-\
6887efb4fd06"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["7", "n"], " ", "=", 
    RowBox[{"O", "(", 
     SuperscriptBox["7", "n"], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d4740b53-1638-4dda-aaa1-57a75136168b"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"10", 
     SuperscriptBox["n", "2"]}], "=", 
    RowBox[{"O", "(", 
     SuperscriptBox["n", "2"], ")"}]}], TraditionalForm]],ExpressionUUID->
  "f269e13c-a74a-4955-b100-a67c716c78ca"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"8", 
     SuperscriptBox["n", "3"]}], "=", 
    RowBox[{"O", "(", 
     SuperscriptBox["n", "3"], ")"}]}], TraditionalForm]],ExpressionUUID->
  "1201da54-9fcb-458b-a5b4-239f1526a7cc"],
 " y ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["3", "n"], " ", "=", 
    RowBox[{"O", "(", 
     SuperscriptBox["3", "n"], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "a537a3ae-89a5-4a96-ba84-e2392a4ffbac"],
 "\n",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["7", "n"], TraditionalForm]],ExpressionUUID->
  "f781bd56-9d5a-40f4-aeef-a286842e115d"],
 "+",
 Cell[BoxData[
  FormBox[
   RowBox[{"10", 
    SuperscriptBox["n", "2"]}], TraditionalForm]],ExpressionUUID->
  "da24ee64-0dd2-4cfe-95ac-aa946d96a975"],
 "+",
 Cell[BoxData[
  FormBox[
   RowBox[{"8", 
    SuperscriptBox["n", "3"]}], TraditionalForm]],ExpressionUUID->
  "85a0e173-ccfb-420f-8f74-205245191b7f"],
 "+",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["3", "n"], TraditionalForm]],ExpressionUUID->
  "615fd776-89b4-4dcf-ad92-ebed08a9243d"],
 "=O(Max(|",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["7", "n"], TraditionalForm]],ExpressionUUID->
  "1db4e514-4049-4751-ace4-01b0fbb7f3b5"],
 "|,|",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["n", "2"], TraditionalForm]],ExpressionUUID->
  "608387ce-933f-43e0-88eb-5dba14073e63"],
 "|,|",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["n", "3"], TraditionalForm]],ExpressionUUID->
  "f283064d-df86-426c-9228-6aaf50290531"],
 "|,|",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["3", "n"], TraditionalForm]],ExpressionUUID->
  "9fb20827-fefa-413a-be92-174a8d4b3c8b"],
 "|))=O(|",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["7", "n"], TraditionalForm]],ExpressionUUID->
  "eecdfca2-1ca5-47fe-9c39-e900a5e8d4d3"],
 "|)=O(",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["7", "n"], TraditionalForm]],ExpressionUUID->
  "cf2d1859-64d5-48a0-947f-1add7a4f004b"],
 ")"
}], "Text",
 CellChangeTimes->{{3.8087668259443617`*^9, 3.8087668350220723`*^9}, {
  3.808766943525419*^9, 3.8087671099169126`*^9}, {3.8087671490683603`*^9, 
  3.808767233333604*^9}},ExpressionUUID->"8ac14d23-26b5-4b5d-b863-\
8c320094e1c1"],

Cell["3.5.13", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.808765373501971*^9}},ExpressionUUID->"15866bae-531a-4e59-9cd9-\
efb60ca9df9c"],

Cell[TextData[{
 "2\:207f=O(2\:207f), ",
 Cell[BoxData[
  FormBox["n\.b2", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e3b128ff-1610-4bcb-bf8d-0fa0d3915c7c"],
 "=O(n\.b2), 5n\.b3=O(n\.b3) y 5\:207f=O(5\:207f)\n2\:207f+n\.b2=O(Max(|2\
\:207f|,|n\.b2|))=O(|2\:207f|)=O(2\:207f)\n5n\.b3+5\:207f=O(Max(|n\.b3|,|5\
\:207f|))=O(|5\:207f|)=O(5\:207f)\n\
(2\:207f+n\.b2)(5n\.b3+5\:207f)=O(2\:207f)*O(5\:207f)=O(2\:207f 5\:207f)"
}], "Text",
 CellChangeTimes->{{3.8087668259443617`*^9, 3.8087668350220723`*^9}, {
  3.8087672914032373`*^9, 
  3.808767546674264*^9}},ExpressionUUID->"2a959fdc-eaea-4108-9e36-\
06488ff5c8d9"],

Cell["3.5.14", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.8087653755046825`*^9}},ExpressionUUID->"ee35b877-28de-4efd-a6a8-\
f3b84938b120"],

Cell["\<\
n\:207f=O(n\:207f), n2\:207f=O(n2\:207f), 3\:207f=O(3\:207f) y n!=O(n!)
n\:207f+n2\:207f+3\:207f=O(Max(|n\:207f|,|n2\:207f|,|3\:207f|))=O(|n\:207f|)=\
O(n\:207f)
n!+3\:207f=O(Max(|n!|,|3\:207f|))=O(|n!|)=O(n!)
(n\:207f+n2\:207f+3\:207f)(n!+3\:207f)=O(n\:207f)*O(n!)=O(n\:207f n!)\
\>", "Text",
 CellChangeTimes->{{3.8087668259443617`*^9, 3.8087668350220723`*^9}, {
  3.808767714123207*^9, 
  3.8087679303689947`*^9}},ExpressionUUID->"4672a2eb-2c32-48d7-be1e-\
cd1e669934be"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", 
     SuperscriptBox["2", "n"]}], 
    SuperscriptBox["n", "n"]], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8087679362448697`*^9, 3.808767966864393*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"c8ca1046-9b07-4203-a020-9e4e500a405e"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.808767967654053*^9, 3.8268965906634316`*^9, 
  3.827002562732396*^9, 3.827050826627886*^9, 3.8275865930660057`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"024e7198-1f88-44d8-9345-918333768b81"]
}, Open  ]],

Cell["3.5.15", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.8087653776422677`*^9}},ExpressionUUID->"e9498f59-c5a7-4e24-9548-\
d784aa0d6912"],

Cell["\<\
n\.b3=O(n\.b3), n\.b2ln n=O(n\.b2ln n), ln n=O(ln n), 1=O(1), 6ln n=O(ln n), \
n\:2074=O(n\:2074) y 2=O(1)
n\.b3+n\.b2ln n=O(Max(|n\.b3|,|n\.b2ln n|))=O(|n\.b3|)=O(n\.b3)
ln n+1=O(Max(|ln n|,|1|))=O(|ln n|)=O(ln n)
6ln n+1=O(Max(|ln n|,|1|))=O(|ln n|)=O(ln n)
n\:2074+2=O(Max(|n\:2074|,|1|))=O(|n\:2074|)=O(n\:2074)
(n\.b3+n\.b2ln n)(ln n+1)=O(n\.b3)*O(ln n)=O(n\.b3ln n)
(6ln n+1)(n\:2074+2)=O(ln n)*O(n\:2074)=O(n\:2074ln n)
(n\.b3+n\.b2ln n)(ln n+1)+(6ln n+1)(n\:2074+2)=O(Max(|n\.b3ln n|,|n\:2074ln \
n|))=O(|n\:2074ln n|)=O(n\:2074ln n)\
\>", "Text",
 CellChangeTimes->{{3.8087668259443617`*^9, 3.8087668350220723`*^9}, {
  3.8087680660976515`*^9, 3.808768231105583*^9}, {3.8087682633046427`*^9, 
  3.808768299510244*^9}, {3.8087683504052505`*^9, 3.8087683777855897`*^9}, {
  3.808768425399355*^9, 3.808768518884474*^9}, {3.8087694370156994`*^9, 
  3.8087694983767233`*^9}},ExpressionUUID->"9b35fad7-6ddc-4bea-a2f2-\
0413340966bf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["n", "2"], 
     RowBox[{"Log", "[", "n", "]"}]}], 
    SuperscriptBox["n", "3"]], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.808768314993303*^9, 3.8087683395571184`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"1f3695bd-d1e6-4106-9602-d2157d4f4ec0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.808768340359718*^9, 3.826896593163416*^9, 
  3.827002566306585*^9, 3.827050823891984*^9, 3.8275865960453453`*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"c21e1399-0a3a-4f84-946f-ac413520be85"]
}, Open  ]],

Cell["3.5.16", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.8087653796443167`*^9}},ExpressionUUID->"198f4756-5cf8-41ad-8079-\
ba959e201f06"],

Cell["\<\
n=O(n), ln(n+1)=O(ln n), 1=O(1), ln n=O(ln n) y n\.b3=O(n\.b3)
n+ln(n+1)+1=O(Max(|n|,|ln n|,|1|))=O(|n|)=O(n)
ln n+1=O(Max(|ln n|,|1|))=O(|ln n|)=O(ln n)
n\.b3+1=O(Max(|n\.b3|,|1|))=O(|n\.b3|)=O(n\.b3)
(n+ln(n+1)+1)(n+ln(n+1)+1)=O(n)*O(n)=O(n\.b2)
(ln n+1)(n\.b3+1)=O(ln n)*O(n\.b3)=O(n\.b3ln n)
(n+ln(n+1)+1)\.b2+(ln n+1)(n\.b3+1)=O(Max(|n\.b2|,|n\.b3ln n|))=O(|n\.b3ln \
n|)=O(n\.b3ln n)\
\>", "Text",
 CellChangeTimes->{{3.8087668259443617`*^9, 3.8087668350220723`*^9}, 
   3.808768592981335*^9, {3.8087686335487614`*^9, 3.808768640995271*^9}, {
   3.808768672746592*^9, 3.8087687386493654`*^9}, {3.808768791071833*^9, 
   3.8087688746397324`*^9}, {3.80876890677069*^9, 3.8087690484788322`*^9}, {
   3.808769251370417*^9, 3.8087693152244387`*^9}, 
   3.808769395570443*^9},ExpressionUUID->"f1caa5f7-714a-4717-ab5d-\
cd8cb5415c44"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"n", "+", "1"}], "]"}], 
      RowBox[{"Log", "[", "n", "]"}]], ",", 
     RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}], ",", 
   RowBox[{"Limit", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", "n", "]"}], "n"], ",", 
     RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}], ",", 
   RowBox[{"Limit", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"Log", "[", "n", "]"}], "+", "1"}], 
      RowBox[{"Log", "[", "n", "]"}]], ",", 
     RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}], ",", 
   RowBox[{"Limit", "[", 
    RowBox[{
     FractionBox[
      SuperscriptBox["n", "2"], 
      RowBox[{
       SuperscriptBox["n", "3"], 
       RowBox[{"Log", "[", "n", "]"}]}]], ",", 
     RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.808768760743303*^9, 3.808768783872976*^9}, {
  3.808769134975663*^9, 3.8087691529503655`*^9}, {3.8087692154589157`*^9, 
  3.8087692212188663`*^9}, {3.808769321662883*^9, 3.808769354265829*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"8a633410-90c7-464c-b121-ef7e122a7d41"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.808768784646654*^9, 3.808769153762453*^9, 
  3.8087692224263067`*^9, 3.808769355377139*^9, 3.808846326026654*^9, 
  3.826896597197006*^9, 3.8270025701321697`*^9, 3.827050833242798*^9, 
  3.827586599559819*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"64aca936-54a7-4412-aa45-f10bcc67e6b0"]
}, Open  ]],

Cell["3.5.17", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.8087653994278536`*^9}},ExpressionUUID->"1ed984d8-a50e-4e3a-b70e-\
cb853db471b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Seleccion", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"code", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8088464827035728`*^9, 3.808846507287907*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"afe69cfd-63fc-430c-915d-ec646b4188ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", "\<\"Seleccion[L_List]:=Module[{Datos=L},For[i=Length[Datos],i\
\[GreaterEqual]1,max=Datos[[1]];pos=1; \
For[j=1,j\[LessEqual]i,If[max<Datos[[j]],max=Datos[[j]];pos=j];j++];aux=Datos[\
[i]];Datos[[i]]=Datos[[pos]];Datos[[pos]]=aux;i-=1];Datos]\"\>"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.808846507943857*^9, 3.826896599600091*^9, 
  3.8270025728690605`*^9, 3.8270508359236217`*^9, 3.8275866022684546`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"4f574d13-a671-43af-9126-39a4c8a4ee32"]
}, Open  ]],

Cell[TextData[{
 "De acuerdo con esta implementaci\[OAcute]n el n\[UAcute]mero de veces que \
se resuelven las asignaciones simples en la peor situaci\[OAcute]n es: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"n", "*", "n"}], "=", 
    SuperscriptBox["n", "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "146e5618-7b46-41e9-b11d-ad4cb5fe066d"],
 " con n la longitud de la lista, pues el primer \[OpenCurlyDoubleQuote]for\
\[CloseCurlyDoubleQuote] corre n veces y el segundo \
\[OpenCurlyDoubleQuote]for\[CloseCurlyDoubleQuote] en la peor \
situaci\[OAcute]n (cuando i=n) se ejecuta n veces tambi\[EAcute]n."
}], "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 3.8087653994278536`*^9}, {3.808846546644387*^9, 
  3.80884681696196*^9}},ExpressionUUID->"4c21a459-8690-4d1f-bdd9-\
058e1e0416f4"],

Cell["3.5.18", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.8087654186386337`*^9}},ExpressionUUID->"fa6bd18c-adb3-4d1b-9930-\
822cb75c2808"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Programa", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", "=", "1"}], "}"}], ",", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "0"}], ",", 
       RowBox[{"i", "\[LessEqual]", 
        RowBox[{"n", "-", "2"}]}], ",", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"j", "=", "1"}], ",", 
          RowBox[{"j", "\[LessEqual]", 
           RowBox[{"Floor", "[", 
            RowBox[{"i", "/", "2"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"p", "=", 
            RowBox[{"p", "+", "1"}]}], ";", 
           RowBox[{"j", "++"}]}]}], "]"}], ";", 
        RowBox[{"i", "++"}]}]}], "]"}], ";", 
     RowBox[{"Return", "[", "p", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8088494614530582`*^9, 3.8088494745894933`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"2f77adec-7a0a-49f4-8c2a-ad6a28bd6f17"],

Cell[TextData[{
 "(n-1)",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"(", 
     RowBox[{"n", "-", "2"}], ")"}], "2"], TraditionalForm]],ExpressionUUID->
  "52c35c6f-a141-4411-86e1-080e447a501e"],
 "=",
 Cell[BoxData[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"3", " ", "n"}], "2"], "+", 
   FractionBox[
    SuperscriptBox["n", "2"], "2"]}]],
  CellChangeTimes->{3.8088471237985415`*^9},ExpressionUUID->
  "b9840860-83e5-4717-b261-13d5c6c629a4"],
 "=O(",
 Cell[BoxData[
  SuperscriptBox["n", "2"]],
  CellChangeTimes->{3.8088471237985415`*^9},ExpressionUUID->
  "028546cf-a589-43e8-8cc1-0d37d0dffab6"],
 ")"
}], "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
   3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
   3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
   3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
   3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
   3.808765350442689*^9, 3.8087654186386337`*^9}, {3.808847046880682*^9, 
   3.808847074349476*^9}, {3.8088471296533775`*^9, 3.808847141777672*^9}, 
   3.8088477925290623`*^9, 
   3.827584791764679*^9},ExpressionUUID->"9191c7f6-bfe8-4616-8280-\
677acb16a458"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"n", "-", "2"}], ")"}], " "}], "2"], "]"}]], "Input",
 CellChangeTimes->{{3.8088470772219353`*^9, 3.8088471205039883`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"df5b9abd-636a-431a-b6e0-6b55bdf76b4f"],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{"3", " ", "n"}], "2"], "+", 
  FractionBox[
   SuperscriptBox["n", "2"], "2"]}]], "Output",
 CellChangeTimes->{3.8088471237985415`*^9, 3.826896606213481*^9, 
  3.8270025775514193`*^9, 3.8270508414399304`*^9, 3.8275866075768833`*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"6122f9de-201f-428c-8a99-bd7bd75ce784"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], " "}], "2"], ",", 
     SuperscriptBox["n", "2"]}], "}"}], ",", "0.01", ",", "10", ",", "1000"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.8088472786317616`*^9, 3.8088473049797525`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"1dd6f5af-b752-424a-8d09-a10525539e19"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.01, "c"}, 0.01, 10, 0.01}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {540., {168., 175.06084530388466`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.01, "c"}, 0.01, 10, 
         0.01, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{606., {274., 282.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{
  3.808847307011314*^9, 3.8088495612008305`*^9, 3.8088510392568836`*^9, 
   3.826896608347191*^9, 3.827002586126001*^9, 3.827050843592021*^9, {
   3.827586610926162*^9, 3.8275866216217747`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"ffbdf883-5781-4003-a7da-d59e020a64e6"]
}, Open  ]],

Cell["3.5.19", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.808765422643941*^9}},ExpressionUUID->"4dfea418-3c45-46aa-b64d-\
82faeecb1c3e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Programa", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "1"}], ",", 
      RowBox[{"i", "=", "1"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"i", "\[LessEqual]", 
        RowBox[{"2", "n"}]}], ",", 
       RowBox[{
        RowBox[{"p", "=", 
         RowBox[{"p", "+", "1"}]}], ";", 
        RowBox[{"i", "=", 
         RowBox[{"i", "+", "2"}]}]}]}], "]"}], ";", 
     RowBox[{"Return", "[", "p", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8088495723201933`*^9, 3.808849583578521*^9}, {
  3.8268963341489525`*^9, 3.8268963376490903`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"d24b475c-33c0-4fc0-a684-4b993436f09a"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["i", "k"], "=", 
    RowBox[{
     SubscriptBox["i", 
      RowBox[{"k", "-", "1"}]], "+", "2"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "4cdd83f4-4bbb-4f22-ab50-d27d77d743db"],
 " con ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["i", "0"], "=", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c90453e9-c12c-4d68-98c1-deaa232e0286"]
}], "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 3.808765422643941*^9}, {3.8088474211908007`*^9, 
  3.808847453956442*^9}},ExpressionUUID->"40b359e0-b1d8-4514-aedc-\
5b6d6da2e5c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", "k", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.808847467422785*^9, 3.8088474856820707`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"df9254a0-ec48-4918-b86b-837c6ffd8fdf"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "k"}]}]], "Output",
 CellChangeTimes->{3.8088474874206276`*^9, 3.826896614746924*^9, 
  3.8270025928047357`*^9, 3.8270508505178437`*^9, 3.827586628119313*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"967bebe5-db3e-4938-81d3-f4f452ff1f06"]
}, Open  ]],

Cell[TextData[{
 "Supongamos:\n1+2k>2n \[DoubleRightArrow] 2k>2n-1 \[DoubleRightArrow] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", ">", 
    FractionBox[
     RowBox[{
      RowBox[{"2", "n"}], "-", "1"}], "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "627a8cc8-eaea-4178-9ca6-9c27353ef66a"],
 " \[DoubleRightArrow] k=",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     RowBox[{"2", "n"}], "-", "1"}], "2"], TraditionalForm]],ExpressionUUID->
  "a23059a3-1440-4cc8-a25c-83766368e633"],
 "+a=\[CapitalTheta](n), pues:"
}], "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
   3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
   3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
   3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
   3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
   3.808765350442689*^9, 3.808765425503838*^9}, {3.8088474986359487`*^9, 
   3.808847651910301*^9}, 
   3.8088476877765923`*^9},ExpressionUUID->"a41da24d-bd48-4caa-a3fd-\
e047aaa61520"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", "n"}], "-", "1"}], "2"], "+", "a"}], "n"], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.808847654572353*^9, 3.8088476780324697`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"a5b1aea2-4edf-40c3-830d-1731df7dcaed"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.8088476790199504`*^9, 3.8268966168203087`*^9, 
  3.8270025949697723`*^9, 3.827050852632744*^9, 3.827586630543142*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"b11aed99-e959-4cb0-8e9e-66e2ee0c33bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"2", "n"}], "-", "1"}], "2"], "+", "a"}], "/.", 
      RowBox[{"a", "\[Rule]", "0.5"}]}], ",", "n"}], "}"}], ",", "0.01", ",", 
   "10", ",", "1000"}], "]"}]], "Input",
 CellChangeTimes->{{3.8088478485540485`*^9, 3.808847977177194*^9}, {
  3.8088480086583223`*^9, 3.8088480859853673`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"5bce838e-93de-4f36-927d-cf35eb2369fc"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.01, "c"}, 0.01, 10, 0.01}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {540., {168., 175.06084530388466`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.01, "c"}, 0.01, 10, 
         0.01, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{606., {274., 282.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.8088480597086163`*^9, 3.808848090155821*^9, 
  3.808849606183155*^9, 3.808851044853199*^9, 3.826896618997141*^9, 
  3.827002597205677*^9, 3.827050854951294*^9, 3.827586633084223*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[36]:=",ExpressionUUID->"6770d7a9-bc16-48f2-8b27-c987ff1c277d"]
}, Open  ]],

Cell["3.5.20", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.808765425503838*^9}},ExpressionUUID->"eec82e06-72b1-4762-960b-\
5a8594dd4784"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Programa", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "1"}], ",", 
      RowBox[{"i", "=", "n"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"i", "\[GreaterEqual]", "1"}], ",", 
       RowBox[{
        RowBox[{"p", "*=", "2"}], ";", 
        RowBox[{"i", "=", 
         RowBox[{"Floor", "[", 
          RowBox[{"i", "/", "5"}], "]"}]}]}]}], "]"}], ";", 
     RowBox[{"Return", "[", "p", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8088496184889803`*^9, 3.808849618492961*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"d194ee4d-a5f9-4fcd-aec7-bb93b65f58ae"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["i", "k"], "=", 
    FractionBox[
     SubscriptBox["i", 
      RowBox[{"k", "-", "1"}]], "5"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "7272a118-e158-449d-a707-c8abc3228742"],
 " con ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["i", "0"], "=", "n"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "81e83c4d-0408-458d-b79e-fee637e71a6a"]
}], "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 3.808765422643941*^9}, {3.8088474211908007`*^9, 
  3.808847453956442*^9}, {3.8088482041560106`*^9, 
  3.808848225939847*^9}},ExpressionUUID->"bc6d285a-7c2b-4f98-b531-\
b59da5f6e463"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", "/", "5"}], "}"}], ",", 
   RowBox[{"{", "n", "}"}], ",", "k", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.808847467422785*^9, 3.8088474856820707`*^9}, {
  3.808848230314505*^9, 3.808848239665929*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"572b5222-9184-451b-a3ac-20b1f5210267"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["5", 
   RowBox[{"-", "k"}]], " ", "n"}]], "Output",
 CellChangeTimes->{
  3.8088474874206276`*^9, 3.8088482428574843`*^9, {3.826896624680111*^9, 
   3.826896639680259*^9}, 3.82700260384594*^9, 3.8270508605269055`*^9, 
   3.8275866404387445`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"a99e5b63-481f-45cf-8bfd-a6207779a5ee"]
}, Open  ]],

Cell[TextData[{
 "Supongamos:\n",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["5", 
    RowBox[{"-", "k"}]], " ", "n"}]],
  CellChangeTimes->{3.8088474874206276`*^9, 3.8088482428574843`*^9},
  ExpressionUUID->"29099325-243c-453b-8c90-2109c045a1d7"],
 "<1 \[DoubleRightArrow] n<",
 Cell[BoxData[
  SuperscriptBox["5", "k"]],
  CellChangeTimes->{3.8088474874206276`*^9, 3.8088482428574843`*^9},
  ExpressionUUID->"f2e0c44f-6e89-47a9-9a54-3fbc63f6f3a1"],
 " \[DoubleRightArrow] ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ln", " ", "n"}], "<", 
    RowBox[{"ln", " ", 
     SuperscriptBox["5", "k"]}]}], TraditionalForm]],ExpressionUUID->
  "991df3a0-592d-4676-beaf-48dd0bece4cd"],
 " \[DoubleRightArrow] ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ln", " ", "n"}], "<", 
    RowBox[{"k", " ", "ln", " ", "5"}]}], TraditionalForm]],ExpressionUUID->
  "2993b4de-7689-4daa-8344-210c1e399ec7"],
 " \[DoubleRightArrow] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", ">", 
    FractionBox[
     RowBox[{"ln", " ", "n"}], 
     RowBox[{"ln", " ", "5"}]], " "}], TraditionalForm]],ExpressionUUID->
  "8aefa310-abc5-4707-beee-f91312f36941"],
 " \[DoubleRightArrow] k=",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"ln", " ", "n"}], 
    RowBox[{"ln", " ", "5"}]], TraditionalForm]],ExpressionUUID->
  "9ff7396c-5332-43f0-9002-c6f34832d88d"],
 "+a=O(ln n), pues:"
}], "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
   3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
   3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
   3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
   3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
   3.808765350442689*^9, 3.808765425503838*^9}, {3.8088474986359487`*^9, 
   3.808847651910301*^9}, 3.8088476877765923`*^9, {3.8088482710307837`*^9, 
   3.808848356574836*^9}, {3.8088484045483713`*^9, 3.808848439767112*^9}, 
   3.827585025781831*^9},ExpressionUUID->"bd9a11ee-2ebd-43bc-b019-\
7495205f024c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", "n", "]"}], 
      RowBox[{"Log", "[", "5", "]"}]], "+", "a"}], 
    RowBox[{"Log", "[", "n", "]"}]], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.808847654572353*^9, 3.8088476780324697`*^9}, {
  3.808848445664274*^9, 3.8088484627618284`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"0cfc2565-1ad8-4ff7-8fa2-bed97ec721c2"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"Log", "[", "5", "]"}]]], "Output",
 CellChangeTimes->{
  3.8088476790199504`*^9, 3.8088484646124024`*^9, {3.8268966354638786`*^9, 
   3.8268966439304485`*^9}, 3.827002606210904*^9, 3.827050862976794*^9, 
   3.827586643215109*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"66c5ba3b-ad90-4a15-baad-172a3f984c13"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"Log", "[", "n", "]"}], 
        RowBox[{"Log", "[", "5", "]"}]], "+", "a"}], "/.", 
      RowBox[{"a", "\[Rule]", "0.5"}]}], ",", 
     RowBox[{"Log", "[", "n", "]"}]}], "}"}], ",", "0.01", ",", "10", ",", 
   "1000"}], "]"}]], "Input",
 CellChangeTimes->{{3.8088478485540485`*^9, 3.808847977177194*^9}, {
  3.8088480086583223`*^9, 3.8088480859853673`*^9}, {3.8088486058825607`*^9, 
  3.808848632388258*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"7920028c-1364-4a1e-8e36-92510eac6d71"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.01, "c"}, 0.01, 10, 0.01}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {540., {168., 175.06084530388466`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.01, "c"}, 0.01, 10, 
         0.01, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{606., {274., 282.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.808848647107246*^9, 3.80884964382909*^9, 
  3.808851050949974*^9, 3.8268966462204676`*^9, 3.827002608848678*^9, 
  3.827050865868556*^9, 3.8275866454421453`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"8b1a481c-4b01-4dcb-a410-0f89152fc3eb"]
}, Open  ]],

Cell["3.5.21", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.808765428247223*^9}},ExpressionUUID->"c38e1f6d-5193-4275-a703-\
c083a81704cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Programa", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "1"}], ",", 
      RowBox[{"i", "=", 
       RowBox[{"n", "/", "2"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"i", "\[GreaterEqual]", "1"}], ",", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"j", "=", "1"}], ",", 
          RowBox[{"j", "\[LessEqual]", "i"}], ",", 
          RowBox[{
           RowBox[{"p", "=", 
            RowBox[{"p", "*", "2"}]}], ";", 
           RowBox[{"j", "++"}]}]}], "]"}], ";", 
        RowBox[{"i", "=", 
         RowBox[{"i", "/", 
          RowBox[{"Sqrt", "[", "5", "]"}]}]}]}]}], "]"}], ";", 
     RowBox[{"Return", "[", "p", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8088496671341515`*^9, 3.8088496730847692`*^9}, {
  3.827585110600612*^9, 3.8275851124612465`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"09e8de72-b259-44af-946a-3c9a0b7a14a8"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["i", "k"], "=", 
    FractionBox[
     SubscriptBox["i", 
      RowBox[{"k", "-", "1"}]], 
     SqrtBox["5"]]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "e6509597-b572-470b-acd8-79eefda054de"],
 " con ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["i", "0"], "=", 
    FractionBox["n", "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "fbd65bbd-9ed7-4058-9d89-07bf47000e52"]
}], "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 3.808765422643941*^9}, {3.8088474211908007`*^9, 
  3.808847453956442*^9}, {3.8088482041560106`*^9, 3.808848225939847*^9}, {
  3.808849735519168*^9, 
  3.8088497452369437`*^9}},ExpressionUUID->"732eb036-7164-4bbd-8d8e-\
c543ba3ba227"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    FractionBox["1", 
     SqrtBox["5"]], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", "/", "2"}], "}"}], ",", "k", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.808847467422785*^9, 3.8088474856820707`*^9}, {
  3.808848230314505*^9, 3.808848239665929*^9}, {3.80884978801588*^9, 
  3.8088498048200665`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"1c7a99fe-f8e8-40af-8dc4-8bf3a9da0158"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["5", 
   RowBox[{
    RowBox[{"-", "k"}], "/", "2"}]], " ", "n"}]], "Output",
 CellChangeTimes->{3.8088474874206276`*^9, 3.8088482428574843`*^9, 
  3.808849817437311*^9, 3.8268966531137085`*^9, 3.827002614557604*^9, 
  3.827050872320177*^9, 3.827586651757871*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"68c9be98-c147-451f-aed0-3393a868dab0"]
}, Open  ]],

Cell[TextData[{
 "Supongamos:\n",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["5", 
    RowBox[{
     RowBox[{"-", "k"}], "/", "2"}]], " ", "n"}]],
  CellChangeTimes->{3.8088474874206276`*^9, 3.8088482428574843`*^9},
  ExpressionUUID->"f145d1d9-026a-4a5b-82eb-6ee68b3562c3"],
 "<1 \[DoubleRightArrow] n<",
 Cell[BoxData[
  RowBox[{"2", "*", 
   SuperscriptBox["5", 
    RowBox[{"k", "/", "2"}]]}]],
  CellChangeTimes->{3.8088474874206276`*^9, 3.8088482428574843`*^9},
  ExpressionUUID->"98bae7b9-7048-470a-80b9-b70c24964eb0"],
 " \[DoubleRightArrow] ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ln", " ", "n"}], "<", 
    RowBox[{"ln", " ", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       SuperscriptBox["5", 
        RowBox[{"k", "/", "2"}]]}], ")"}]}]}], TraditionalForm]],
  ExpressionUUID->"1c139e0d-108d-4640-a460-efeee97c4f5d"],
 " \[DoubleRightArrow] ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ln", " ", "n"}], "<", " ", 
    RowBox[{
     RowBox[{"ln", " ", "2"}], "+", 
     SuperscriptBox["ln5", 
      RowBox[{"k", "/", "2"}]]}]}], TraditionalForm]],ExpressionUUID->
  "affc437f-3bd8-4961-9e2e-341a9f7aa124"],
 " \[DoubleRightArrow] ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"ln", " ", "n"}], "-", 
     RowBox[{"ln", " ", "2"}]}], "<", 
    RowBox[{
     FractionBox["k", "2"], " ", "ln", " ", "5"}]}], TraditionalForm]],
  ExpressionUUID->"a3413331-45ff-4bd0-a76e-1a3e9755ff9e"],
 " \[DoubleRightArrow] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", ">", 
    RowBox[{"2", 
     FractionBox[
      RowBox[{
       RowBox[{"ln", " ", "n"}], "-", 
       RowBox[{"ln", " ", "2"}]}], 
      RowBox[{"ln", " ", "5"}]], " "}]}], TraditionalForm]],ExpressionUUID->
  "ed3de1ea-b1cd-4671-a4d4-e65b95d2092b"],
 " \[DoubleRightArrow] k=",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    FractionBox[
     RowBox[{
      RowBox[{"ln", " ", "n"}], "-", 
      RowBox[{"ln", " ", "2"}]}], 
     RowBox[{"ln", " ", "5"}]]}], TraditionalForm]],ExpressionUUID->
  "5342bd14-f85e-4e5f-949c-bdf3aa111604"],
 "+a"
}], "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
   3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
   3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
   3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
   3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
   3.808765350442689*^9, 3.808765425503838*^9}, {3.8088474986359487`*^9, 
   3.808847651910301*^9}, 3.8088476877765923`*^9, {3.8088482710307837`*^9, 
   3.808848356574836*^9}, {3.8088484045483713`*^9, 3.808848439767112*^9}, {
   3.808849848842645*^9, 3.808849882231597*^9}, {3.808849917356201*^9, 
   3.80885001048131*^9}, 3.8270020527497873`*^9, {3.827585156336199*^9, 
   3.8275851569344645`*^9}, {3.8275855992222233`*^9, 
   3.82758560243396*^9}},ExpressionUUID->"b6a78feb-2154-41e3-8a21-\
67cb4f21d7be"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{"i", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{
      RowBox[{"2", 
       FractionBox[
        RowBox[{
         RowBox[{"Log", "[", "n", "]"}], "-", 
         RowBox[{"Log", "[", "2", "]"}]}], 
        RowBox[{"Log", "[", "5", "]"}]]}], "+", "a"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"52f999e4-e5cc-4536-b824-638f0ce6d010"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Log", "[", "2", "]"}]}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"Log", "[", "5", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", "n", "]"}]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Log", "[", "2", "]"}]}], "+", 
     RowBox[{"Log", "[", "5", "]"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"Log", "[", "5", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", "n", "]"}]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", "5", "]"}], "2"]}]]], "Output",
 CellChangeTimes->{3.8275853186011934`*^9, 3.8275866549098687`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"f33748ca-e817-41c9-9aa5-0acfee418297"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sum", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{
         RowBox[{"2", 
          FractionBox[
           RowBox[{
            RowBox[{"Log", "[", "n", "]"}], "-", 
            RowBox[{"Log", "[", "2", "]"}]}], 
           RowBox[{"Log", "[", "5", "]"}]]}], "+", "a"}]}], "}"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"Log", "[", "n", "]"}], ")"}], "2"]], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8270498222574434`*^9, 3.827049855104684*^9}, {
  3.8275853045455203`*^9, 3.8275853118779583`*^9}, {3.8275853781032763`*^9, 
  3.8275853896042995`*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"d104995c-2b94-4967-989e-312ec31a4f5b"],

Cell[BoxData[
 FractionBox["2", 
  SuperscriptBox[
   RowBox[{"Log", "[", "5", "]"}], "2"]]], "Output",
 CellChangeTimes->{3.827050253933273*^9, 3.827050879155808*^9, 
  3.8275853305376773`*^9, 3.827585390582707*^9, 3.827586657635911*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"7e603824-05e1-4a15-9b88-8cc9af656ddc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Sum", "[", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{
           RowBox[{"2", 
            FractionBox[
             RowBox[{
              RowBox[{"Log", "[", "n", "]"}], "-", 
              RowBox[{"Log", "[", "2", "]"}]}], 
             RowBox[{"Log", "[", "5", "]"}]]}], "+", "a"}]}], "}"}]}], "]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"Log", "[", "n", "]"}], ")"}], "2"]], ",", 
     RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}], ",", 
   RowBox[{"Limit", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Sum", "[", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{
           RowBox[{"2", 
            FractionBox[
             RowBox[{
              RowBox[{"Log", "[", "n", "]"}], "-", 
              RowBox[{"Log", "[", "2", "]"}]}], 
             RowBox[{"Log", "[", "5", "]"}]]}], "+", "a"}]}], "}"}]}], "]"}], 
      RowBox[{"Log", "[", "n", "]"}]], ",", 
     RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}], ",", 
   RowBox[{"Limit", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Sum", "[", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{
           RowBox[{"2", 
            FractionBox[
             RowBox[{
              RowBox[{"Log", "[", "n", "]"}], "-", 
              RowBox[{"Log", "[", "2", "]"}]}], 
             RowBox[{"Log", "[", "5", "]"}]]}], "+", "a"}]}], "}"}]}], "]"}], 
      RowBox[{"n", " ", 
       RowBox[{"Log", "[", "n", "]"}]}]], ",", 
     RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.8275854609165325`*^9, 3.827585480741938*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"5eb3e1a5-9dbb-4148-8f98-0eb17845e88c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", 
    SuperscriptBox[
     RowBox[{"Log", "[", "5", "]"}], "2"]], ",", "\[Infinity]", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8275854838760843`*^9, 3.827586660990243*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"253c73ee-56ac-46e0-9c4c-f29ff71f3fc6"]
}, Open  ]],

Cell["\<\
No se interpreta \[CapitalTheta](ln(n)) ni \[CapitalTheta](n ln(n)). Es \
importante destacar que si no se hubiera efectuado un conteo preciso sobre la \
cantidad de asignaciones p=p*2 (o sea, si se resuelve el ejercicio como un O \
grande), err\[OAcute]neamente se obtendr\[IAcute]a \[CapitalTheta](n ln(n)).\
\>", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
   3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
   3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
   3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
   3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
   3.808765350442689*^9, 3.808765425503838*^9}, {3.8088474986359487`*^9, 
   3.808847651910301*^9}, 3.8088476877765923`*^9, {3.8088482710307837`*^9, 
   3.808848356574836*^9}, {3.8088484045483713`*^9, 3.808848439767112*^9}, {
   3.808849848842645*^9, 3.808849882231597*^9}, {3.808849917356201*^9, 
   3.80885001048131*^9}, 3.8270020527497873`*^9, {3.8270500250745335`*^9, 
   3.8270500738087177`*^9}, {3.8270501155749493`*^9, 
   3.8270501820813427`*^9}, {3.8270502146151257`*^9, 3.827050216911129*^9}, 
   3.8270506422895565`*^9, {3.827585631236924*^9, 3.827585824435355*^9}, {
   3.8275858819904394`*^9, 
   3.8275858832931395`*^9}},ExpressionUUID->"4fd1068e-4e95-4dbe-8ebe-\
248af949308b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{"i", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"2", 
            FractionBox[
             RowBox[{
              RowBox[{"Log", "[", "n", "]"}], "-", 
              RowBox[{"Log", "[", "2", "]"}]}], 
             RowBox[{"Log", "[", "5", "]"}]]}], "+", "a"}], "/.", 
          RowBox[{"a", "\[Rule]", "0.5"}]}]}], "}"}]}], "]"}], ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"Log", "[", "n", "]"}], ")"}], "2"]}], "}"}], ",", "0.01", ",",
    "10", ",", "1000"}], "]"}]], "Input",
 CellChangeTimes->{{3.8088478485540485`*^9, 3.808847977177194*^9}, {
   3.8088480086583223`*^9, 3.8088480859853673`*^9}, {3.8088486058825607`*^9, 
   3.808848632388258*^9}, 3.808850059883494*^9, {3.8088501416780405`*^9, 
   3.8088501602336187`*^9}, {3.827585344374261*^9, 3.8275853548420906`*^9}, 
   3.8275854005256596`*^9},
 CellLabel->"In[46]:=",ExpressionUUID->"ffda7ce6-636a-4929-b80a-f680cace8306"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.01, "c"}, 0.01, 10, 0.01}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {540., {168., 175.06084530388466`}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.01, "c"}, 0.01, 10, 
         0.01, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{606., {274., 282.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.808850372365488*^9, 3.808851057422603*^9, 
  3.826896658747201*^9, 3.8270026193707294`*^9, 3.8270508810795074`*^9, 
  3.8275854095643034`*^9, 3.8275866640480022`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"824ed428-a3c9-4974-96a7-5c932859effd"]
}, Open  ]],

Cell["3.5.22", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.80876544404381*^9}},ExpressionUUID->"5c251466-8c40-4f9f-a050-\
b99cb713acda"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CompLimit", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox["2", "3"], 
       SuperscriptBox["n", "3"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"Log", "[", "n", "]"}], ")"}], "5"]}], ",", 
     SuperscriptBox["n", "j"]}], "}"}], ",", 
   RowBox[{"jvalor", "\[Rule]", "15"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.808851081719105*^9, 3.8088511423876743`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"65029b5f-bc70-4b92-912d-9f0bad7e7b29"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Alj2$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alj2$$], 1, "j"}, 1, 15, 1}}, Typeset`size$$ = {
    396.64, {15.7, 28.335}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Alj2$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       VilCretas`Private`AlVl36 = 
        Limit[VilCretas`Private`Alf7[
           VilCretas`Private`n, VilCretas`Private`Alj2$$]/
          VilCretas`Private`Alf8[
          VilCretas`Private`n, VilCretas`Private`Alj2$$], VilCretas`Private`n -> 
          Infinity]; If[
         Or[
          NumericQ[VilCretas`Private`AlVl36], 
          ToString[VilCretas`Private`AlVl36] == ToString[Infinity]], 
         If[
          NumericQ[VilCretas`Private`AlVl36], 
          If[VilCretas`Private`AlVl36 < 0, "NaD", 
           If[VilCretas`Private`AlVl36 > 0, 
            Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
              
              VilCretas`Private`Alf7[$CellContext`n, 
               VilCretas`Private`Alj2$$], "=\[CapitalTheta](", 
              
              VilCretas`Private`Alf8[$CellContext`n, 
               VilCretas`Private`Alj2$$], ")", ", Notaci\[OAcute]n theta"}], 
            If[VilCretas`Private`AlVl36 == 0, 
             Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
               
               VilCretas`Private`Alf7[$CellContext`n, 
                VilCretas`Private`Alj2$$], "=\[CapitalOmicron](", 
               
               VilCretas`Private`Alf8[$CellContext`n, 
                VilCretas`Private`Alj2$$], ")", 
               ", Notaci\[OAcute]n O grande"}]]]], 
          Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
            VilCretas`Private`Alf7[$CellContext`n, VilCretas`Private`Alj2$$], 
            "=\[CapitalOmega](", 
            VilCretas`Private`Alf8[$CellContext`n, VilCretas`Private`Alj2$$], 
            ")", ", Notaci\[OAcute]n omega"}]], "NaD"]), 
      "Specifications" :> {{{VilCretas`Private`Alj2$$, 1, "j"}, 1, 15, 1, 
         Appearance -> "Open"}}, "Options" :> {Alignment -> Center}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{463., {90., 98.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((VilCretas`Private`Alf7[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            First[{Rational[2, 3] $CellContext`n^3 + 
              Log[$CellContext`n]^5, $CellContext`n^$CellContext`j}]]]], \
{$CellContext`n -> VilCretas`Private`Aln$, $CellContext`j -> 
          VilCretas`Private`Alj$}]; VilCretas`Private`Alf8[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            Last[{Rational[2, 3] $CellContext`n^3 + 
              Log[$CellContext`n]^5, $CellContext`n^$CellContext`j}]]]], \
{$CellContext`n -> VilCretas`Private`Aln$, $CellContext`j -> 
          VilCretas`Private`Alj$}]); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.808851127405156*^9, 3.8088511428344717`*^9}, 
   3.8088536193807564`*^9, 3.8268966623135633`*^9, 3.82700262317935*^9, 
   3.827050884753505*^9, 3.8275866675267744`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"82df3268-693c-456b-a2e4-6b00983925f9"]
}, Open  ]],

Cell["\<\
j<=2 \[DoubleRightArrow] \[CapitalOmega]
j=3 \[DoubleRightArrow] \[CapitalTheta]
j>=4 \[DoubleRightArrow] O\
\>", "Text",
 CellChangeTimes->{{3.808851198095765*^9, 
  3.8088512919254436`*^9}},ExpressionUUID->"e9dc1a32-8c9b-4811-9f64-\
158e63bc43f7"],

Cell["3.5.23", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.808765446155149*^9}},ExpressionUUID->"1adff09d-ddae-4766-9615-\
ff0c55e83b41"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CompLimit", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["n", "2"], "+", 
       RowBox[{"3", 
        RowBox[{"Log", "[", "n", "]"}]}]}], 
      RowBox[{
       SuperscriptBox["n", "5"], "+", "1"}]], ",", 
     SuperscriptBox["n", "j"]}], "}"}], ",", 
   RowBox[{"jvalor", "\[Rule]", "15"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.808851081719105*^9, 3.8088511423876743`*^9}, {
  3.808851701798973*^9, 3.8088517312231417`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"1322767b-7010-4f28-b5e9-315cbbeed85a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Alj2$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alj2$$], 1, "j"}, 1, 15, 1}}, Typeset`size$$ = {
    389.39, {4., 17.1}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Alj2$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       VilCretas`Private`AlVl36 = 
        Limit[VilCretas`Private`Alf7[
           VilCretas`Private`n, VilCretas`Private`Alj2$$]/
          VilCretas`Private`Alf8[
          VilCretas`Private`n, VilCretas`Private`Alj2$$], VilCretas`Private`n -> 
          Infinity]; If[
         Or[
          NumericQ[VilCretas`Private`AlVl36], 
          ToString[VilCretas`Private`AlVl36] == ToString[Infinity]], 
         If[
          NumericQ[VilCretas`Private`AlVl36], 
          If[VilCretas`Private`AlVl36 < 0, "NaD", 
           If[VilCretas`Private`AlVl36 > 0, 
            Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
              
              VilCretas`Private`Alf7[$CellContext`n, 
               VilCretas`Private`Alj2$$], "=\[CapitalTheta](", 
              
              VilCretas`Private`Alf8[$CellContext`n, 
               VilCretas`Private`Alj2$$], ")", ", Notaci\[OAcute]n theta"}], 
            If[VilCretas`Private`AlVl36 == 0, 
             Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
               
               VilCretas`Private`Alf7[$CellContext`n, 
                VilCretas`Private`Alj2$$], "=\[CapitalOmicron](", 
               
               VilCretas`Private`Alf8[$CellContext`n, 
                VilCretas`Private`Alj2$$], ")", 
               ", Notaci\[OAcute]n O grande"}]]]], 
          Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
            VilCretas`Private`Alf7[$CellContext`n, VilCretas`Private`Alj2$$], 
            "=\[CapitalOmega](", 
            VilCretas`Private`Alf8[$CellContext`n, VilCretas`Private`Alj2$$], 
            ")", ", Notaci\[OAcute]n omega"}]], "NaD"]), 
      "Specifications" :> {{{VilCretas`Private`Alj2$$, 1, "j"}, 1, 15, 1, 
         Appearance -> "Open"}}, "Options" :> {Alignment -> Center}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{456., {79., 87.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((VilCretas`Private`Alf7[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            First[{(1 + $CellContext`n^5)^(-1) ($CellContext`n^2 + 
               3 Log[$CellContext`n]), $CellContext`n^$CellContext`j}]]]], \
{$CellContext`n -> VilCretas`Private`Aln$, $CellContext`j -> 
          VilCretas`Private`Alj$}]; VilCretas`Private`Alf8[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            Last[{(1 + $CellContext`n^5)^(-1) ($CellContext`n^2 + 
               3 Log[$CellContext`n]), $CellContext`n^$CellContext`j}]]]], \
{$CellContext`n -> VilCretas`Private`Aln$, $CellContext`j -> 
          VilCretas`Private`Alj$}]); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.8088517397001305`*^9, 3.8088529007734284`*^9, 
  3.808853629979747*^9, 3.826896684213537*^9, 3.827002626511327*^9, 
  3.827050887746105*^9, 3.827586670189784*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[48]:=",ExpressionUUID->"d915faa2-d3c9-4b8c-bee2-f8ae16a81cd8"]
}, Open  ]],

Cell["j>=1 \[DoubleRightArrow] O, nunca ocurre \[CapitalOmega] ni \
\[CapitalTheta]", "Text",
 CellChangeTimes->{{3.808851198095765*^9, 3.8088512919254436`*^9}, {
  3.808851754891677*^9, 
  3.8088518094096375`*^9}},ExpressionUUID->"bd4b5f44-33d5-4085-a438-\
03500112e2ca"],

Cell["3.5.24", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.808765448181574*^9}},ExpressionUUID->"3125782c-ba0f-42bb-972b-\
ed5c484da3c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CompLimit", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["n", 
      RowBox[{"6", "j"}]], "-", 
     SuperscriptBox["n", "5"], "+", 
     RowBox[{"2", "n"}], "-", "4"}], ",", 
    SuperscriptBox["n", "j"]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.808851081719105*^9, 3.8088511423876743`*^9}, {
  3.808851903244215*^9, 3.808851959686948*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"0b5156ae-c3d2-458a-90e2-6dff52297e7d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Alj2$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alj2$$], 1, "j"}, 1, 1000, 1}}, 
    Typeset`size$$ = {346.5, {13.9, 28.335}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Alj2$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       VilCretas`Private`AlVl36 = 
        Limit[VilCretas`Private`Alf7[
           VilCretas`Private`n, VilCretas`Private`Alj2$$]/
          VilCretas`Private`Alf8[
          VilCretas`Private`n, VilCretas`Private`Alj2$$], VilCretas`Private`n -> 
          Infinity]; If[
         Or[
          NumericQ[VilCretas`Private`AlVl36], 
          ToString[VilCretas`Private`AlVl36] == ToString[Infinity]], 
         If[
          NumericQ[VilCretas`Private`AlVl36], 
          If[VilCretas`Private`AlVl36 < 0, "NaD", 
           If[VilCretas`Private`AlVl36 > 0, 
            Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
              
              VilCretas`Private`Alf7[$CellContext`n, 
               VilCretas`Private`Alj2$$], "=\[CapitalTheta](", 
              
              VilCretas`Private`Alf8[$CellContext`n, 
               VilCretas`Private`Alj2$$], ")", ", Notaci\[OAcute]n theta"}], 
            If[VilCretas`Private`AlVl36 == 0, 
             Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
               
               VilCretas`Private`Alf7[$CellContext`n, 
                VilCretas`Private`Alj2$$], "=\[CapitalOmicron](", 
               
               VilCretas`Private`Alf8[$CellContext`n, 
                VilCretas`Private`Alj2$$], ")", 
               ", Notaci\[OAcute]n O grande"}]]]], 
          Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
            VilCretas`Private`Alf7[$CellContext`n, VilCretas`Private`Alj2$$], 
            "=\[CapitalOmega](", 
            VilCretas`Private`Alf8[$CellContext`n, VilCretas`Private`Alj2$$], 
            ")", ", Notaci\[OAcute]n omega"}]], "NaD"]), 
      "Specifications" :> {{{VilCretas`Private`Alj2$$, 1, "j"}, 1, 1000, 1, 
         Appearance -> "Open"}}, "Options" :> {Alignment -> Center}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{413., {89., 97.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((VilCretas`Private`Alf7[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            First[{-4 + 
              2 $CellContext`n - $CellContext`n^5 + $CellContext`n^(
                6 $CellContext`j), $CellContext`n^$CellContext`j}]]]], \
{$CellContext`n -> VilCretas`Private`Aln$, $CellContext`j -> 
          VilCretas`Private`Alj$}]; VilCretas`Private`Alf8[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            Last[{-4 + 
              2 $CellContext`n - $CellContext`n^5 + $CellContext`n^(
                6 $CellContext`j), $CellContext`n^$CellContext`j}]]]], \
{$CellContext`n -> VilCretas`Private`Aln$, $CellContext`j -> 
          VilCretas`Private`Alj$}]); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.808851928102751*^9, 3.8088519604495077`*^9}, 
   3.808853644547659*^9, 3.826896668797104*^9, 3.8270026300442185`*^9, 
   3.82705089127696*^9, 3.827586672793145*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"79f445bb-0745-4594-be6e-2247d9cb2d50"]
}, Open  ]],

Cell["j>=1 \[DoubleRightArrow] \[CapitalOmega], nunca ocurre O ni \
\[CapitalTheta]", "Text",
 CellChangeTimes->{{3.808851198095765*^9, 3.8088512919254436`*^9}, {
   3.80885197964752*^9, 3.808851988221944*^9}, 
   3.8088528483093834`*^9},ExpressionUUID->"09ce141f-23ec-4626-b071-\
a7cd42664d2c"],

Cell["3.5.25", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 
  3.808765450363846*^9}},ExpressionUUID->"42b397b3-ed38-4889-8594-\
5f8fadac0030"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CompLimit", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SuperscriptBox["n", "8"], 
      RowBox[{
       SuperscriptBox["n", "j"], "+", "1"}]], ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"Log", "[", "n", "]"}], ")"}], "j"]}], "}"}], ",", 
   RowBox[{"jvalor", "\[Rule]", "15"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.808851081719105*^9, 3.8088511423876743`*^9}, {
  3.808852380720644*^9, 3.808852516931529*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"e6f300ee-8fb5-4290-ac0d-266dace62375"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Alj2$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alj2$$], 1, "j"}, 1, 15, 1}}, Typeset`size$$ = {
    454.89, {19.7, 24.134999999999998`}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Alj2$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       VilCretas`Private`AlVl36 = 
        Limit[VilCretas`Private`Alf7[
           VilCretas`Private`n, VilCretas`Private`Alj2$$]/
          VilCretas`Private`Alf8[
          VilCretas`Private`n, VilCretas`Private`Alj2$$], VilCretas`Private`n -> 
          Infinity]; If[
         Or[
          NumericQ[VilCretas`Private`AlVl36], 
          ToString[VilCretas`Private`AlVl36] == ToString[Infinity]], 
         If[
          NumericQ[VilCretas`Private`AlVl36], 
          If[VilCretas`Private`AlVl36 < 0, "NaD", 
           If[VilCretas`Private`AlVl36 > 0, 
            Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
              
              VilCretas`Private`Alf7[$CellContext`n, 
               VilCretas`Private`Alj2$$], "=\[CapitalTheta](", 
              
              VilCretas`Private`Alf8[$CellContext`n, 
               VilCretas`Private`Alj2$$], ")", ", Notaci\[OAcute]n theta"}], 
            If[VilCretas`Private`AlVl36 == 0, 
             Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
               
               VilCretas`Private`Alf7[$CellContext`n, 
                VilCretas`Private`Alj2$$], "=\[CapitalOmicron](", 
               VilCretas`Private`Alf8[$CellContext`n, 
                VilCretas`Private`Alj2$$], ")", 
               ", Notaci\[OAcute]n O grande"}]]]], 
          Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
            VilCretas`Private`Alf7[$CellContext`n, VilCretas`Private`Alj2$$], 
            "=\[CapitalOmega](", 
            VilCretas`Private`Alf8[$CellContext`n, VilCretas`Private`Alj2$$], 
            ")", ", Notaci\[OAcute]n omega"}]], "NaD"]), 
      "Specifications" :> {{{VilCretas`Private`Alj2$$, 1, "j"}, 1, 15, 1, 
         Appearance -> "Open"}}, "Options" :> {Alignment -> Center}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{521., {90., 98.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((VilCretas`Private`Alf7[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            First[{$CellContext`n^8/(1 + $CellContext`n^$CellContext`j), 
              Log[$CellContext`n]^$CellContext`j}]]]], {$CellContext`n -> 
          VilCretas`Private`Aln$, $CellContext`j -> VilCretas`Private`Alj$}]; 
      VilCretas`Private`Alf8[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            Last[{$CellContext`n^8/(1 + $CellContext`n^$CellContext`j), 
              Log[$CellContext`n]^$CellContext`j}]]]], {$CellContext`n -> 
          VilCretas`Private`Aln$, $CellContext`j -> VilCretas`Private`Alj$}]); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.8088524087292585`*^9, 3.808852518570859*^9}, 
   3.808853659423336*^9, 3.826896672530388*^9, 3.8270026328230677`*^9, 
   3.8270508945994935`*^9, 3.8275866759401865`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[50]:=",ExpressionUUID->"cfb5ad6b-b133-4a74-8bed-d793762a2e7e"]
}, Open  ]],

Cell["\<\
j<=7 \[DoubleRightArrow] \[CapitalOmega]
j>=8 \[DoubleRightArrow] O
Nunca ocurre \[CapitalTheta]\
\>", "Text",
 CellChangeTimes->{{3.808851198095765*^9, 3.8088512919254436`*^9}, {
  3.808852781441559*^9, 
  3.808852802034669*^9}},ExpressionUUID->"72accebb-e5cd-4de8-986e-\
e1024f34ce96"],

Cell["3.5.26", "Text",
 CellChangeTimes->{{3.804849466946885*^9, 3.8048494709032283`*^9}, {
  3.8068507349448433`*^9, 3.806850738079356*^9}, {3.8087629092678003`*^9, 
  3.8087629124759164`*^9}, {3.808763131560937*^9, 3.8087631320099087`*^9}, {
  3.8087637289744997`*^9, 3.808763729558936*^9}, {3.8087639960326138`*^9, 
  3.8087639965491896`*^9}, {3.8087651158313007`*^9, 3.808765139453682*^9}, {
  3.808765350442689*^9, 3.808765452659859*^9}, {3.80885371722843*^9, 
  3.8088537180340614`*^9}},ExpressionUUID->"7c26215e-3a9a-4e65-9260-\
d365c5b12e99"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CompLimit", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["n", 
       RowBox[{"1", "/", "j"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"Log", "[", "n", "]"}], ")"}], 
       RowBox[{
        RowBox[{"-", "5"}], "j"}]]}], 
     RowBox[{
      SuperscriptBox["n", 
       RowBox[{"1", "/", "j"}]], "+", "1"}]], ",", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"Log", "[", "n", "]"}], ")"}], 
     RowBox[{
      RowBox[{"-", "5"}], "j"}]]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.808851081719105*^9, 3.8088511423876743`*^9}, {
  3.8088529337566457`*^9, 3.808853091610128*^9}, {3.8088531345432887`*^9, 
  3.80885318089056*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"3de70fce-eece-4cb8-ae50-5f253e28c668"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Alj2$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alj2$$], 1, "j"}, 1, 1000, 1}}, 
    Typeset`size$$ = {454.89, {19.7, 24.134999999999998`}}, Typeset`update$$ =
     0, Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Alj2$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       VilCretas`Private`AlVl36 = 
        Limit[VilCretas`Private`Alf7[
           VilCretas`Private`n, VilCretas`Private`Alj2$$]/
          VilCretas`Private`Alf8[
          VilCretas`Private`n, VilCretas`Private`Alj2$$], VilCretas`Private`n -> 
          Infinity]; If[
         Or[
          NumericQ[VilCretas`Private`AlVl36], 
          ToString[VilCretas`Private`AlVl36] == ToString[Infinity]], 
         If[
          NumericQ[VilCretas`Private`AlVl36], 
          If[VilCretas`Private`AlVl36 < 0, "NaD", 
           If[VilCretas`Private`AlVl36 > 0, 
            Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
              
              VilCretas`Private`Alf7[$CellContext`n, 
               VilCretas`Private`Alj2$$], "=\[CapitalTheta](", 
              
              VilCretas`Private`Alf8[$CellContext`n, 
               VilCretas`Private`Alj2$$], ")", ", Notaci\[OAcute]n theta"}], 
            If[VilCretas`Private`AlVl36 == 0, 
             Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
               
               VilCretas`Private`Alf7[$CellContext`n, 
                VilCretas`Private`Alj2$$], "=\[CapitalOmicron](", 
               VilCretas`Private`Alf8[$CellContext`n, 
                VilCretas`Private`Alj2$$], ")", 
               ", Notaci\[OAcute]n O grande"}]]]], 
          Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
            VilCretas`Private`Alf7[$CellContext`n, VilCretas`Private`Alj2$$], 
            "=\[CapitalOmega](", 
            VilCretas`Private`Alf8[$CellContext`n, VilCretas`Private`Alj2$$], 
            ")", ", Notaci\[OAcute]n omega"}]], "NaD"]), 
      "Specifications" :> {{{VilCretas`Private`Alj2$$, 1, "j"}, 1, 1000, 1, 
         Appearance -> "Open"}}, "Options" :> {Alignment -> Center}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{521., {90., 98.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((VilCretas`Private`Alf7[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            First[{$CellContext`n^($CellContext`j^(-1)) (
                1 + $CellContext`n^($CellContext`j^(-1)))^(-1) 
              Log[$CellContext`n]^((-5) $CellContext`j), 
              Log[$CellContext`n]^((-5) $CellContext`j)}]]]], {$CellContext`n -> 
          VilCretas`Private`Aln$, $CellContext`j -> VilCretas`Private`Alj$}]; 
      VilCretas`Private`Alf8[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            Last[{$CellContext`n^($CellContext`j^(-1)) (
                1 + $CellContext`n^($CellContext`j^(-1)))^(-1) 
              Log[$CellContext`n]^((-5) $CellContext`j), 
              Log[$CellContext`n]^((-5) $CellContext`j)}]]]], {$CellContext`n -> 
          VilCretas`Private`Aln$, $CellContext`j -> VilCretas`Private`Alj$}]); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.80885295089237*^9, 3.808853094564066*^9}, {
   3.808853135808486*^9, 3.8088531895107646`*^9}, 3.8088536765042443`*^9, 
   3.826896676631174*^9, 3.827002636451758*^9, 3.827050897559055*^9, 
   3.8275866791977024`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[51]:=",ExpressionUUID->"c20319c4-01e5-4a63-8aeb-3796c6013ccb"]
}, Open  ]],

Cell["j>=1 \[DoubleRightArrow] \[CapitalTheta], nunca ocurre \[CapitalOmega] \
ni O", "Text",
 CellChangeTimes->{{3.808851198095765*^9, 3.8088512919254436`*^9}, {
  3.8088532526948633`*^9, 
  3.808853269697955*^9}},ExpressionUUID->"0350bbba-788f-415d-bfe9-\
7f2df5756dbd"]
},
WindowToolbars->"EditBar",
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"faff48bc-af3d-49f8-bd43-4a920a19caf4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 42, "Input",ExpressionUUID->"7e4ff91b-a7cc-4c8c-bb06-658b785815fa"],
Cell[761, 25, 250, 4, 50, "Text",ExpressionUUID->"dc012f09-9819-4927-93de-4f85e023b46b"],
Cell[CellGroupData[{
Cell[1036, 33, 474, 9, 42, "Input",ExpressionUUID->"98956550-5117-4a83-a286-18ec726d8cef"],
Cell[CellGroupData[{
Cell[1535, 46, 509, 12, 33, "Print",ExpressionUUID->"912bc2f2-81f3-4e98-9094-0353b0d1059a"],
Cell[2047, 60, 514, 12, 33, "Print",ExpressionUUID->"d0d74c2f-5bfb-48ca-af41-85acc0a891d9"],
Cell[2564, 74, 492, 11, 33, "Print",ExpressionUUID->"85a28458-beae-4001-8bde-7b52a7e57cdd"]
}, Open  ]]
}, Open  ]],
Cell[3083, 89, 301, 5, 50, "Text",ExpressionUUID->"44bb5b99-f4e4-4679-a310-68ffc308894d"],
Cell[3387, 96, 1128, 34, 189, "Input",ExpressionUUID->"fb08fe43-f64b-47db-bc82-c7eb6a9b8b10"],
Cell[CellGroupData[{
Cell[4540, 134, 383, 8, 42, "Input",ExpressionUUID->"f6a8e7ae-da65-43ef-b382-9afcbbb4715d"],
Cell[CellGroupData[{
Cell[4948, 146, 480, 11, 33, "Print",ExpressionUUID->"54081480-0e5f-4416-ba9d-148809ff3eb3"],
Cell[5431, 159, 482, 11, 33, "Print",ExpressionUUID->"e5870015-3e4f-4f92-92b0-acf3399d48ed"],
Cell[5916, 172, 458, 10, 33, "Print",ExpressionUUID->"f5e67fb5-2283-441f-b786-58df5ab4da0c"]
}, Open  ]]
}, Open  ]],
Cell[6401, 186, 352, 6, 50, "Text",ExpressionUUID->"698c98ea-ced3-495c-b475-31bf38652083"],
Cell[6756, 194, 1255, 36, 148, "Input",ExpressionUUID->"c8d38012-216f-40dd-9f15-8ad38fbaa72e"],
Cell[CellGroupData[{
Cell[8036, 234, 490, 10, 42, "Input",ExpressionUUID->"6ed0897f-d60e-495c-99d1-753c7b638e33"],
Cell[CellGroupData[{
Cell[8551, 248, 487, 11, 33, "Print",ExpressionUUID->"bf57fc7f-9609-483b-85ff-2629a6a41357"],
Cell[9041, 261, 487, 11, 33, "Print",ExpressionUUID->"8fe462db-3114-4a94-99cb-e449e29f6608"],
Cell[9531, 274, 469, 10, 33, "Print",ExpressionUUID->"9716d69c-de2a-4a4d-91c6-9570284c8d9f"]
}, Open  ]]
}, Open  ]],
Cell[10027, 288, 402, 6, 50, "Text",ExpressionUUID->"91984062-9c9b-42fb-a458-846333882087"],
Cell[CellGroupData[{
Cell[10454, 298, 593, 10, 65, "Input",ExpressionUUID->"3b642d6d-ad88-4bb0-83ca-7585ebc243b3"],
Cell[CellGroupData[{
Cell[11072, 312, 519, 11, 33, "Print",ExpressionUUID->"4ecd1e27-c8a1-4fac-994e-65e553b4ad48"],
Cell[11594, 325, 521, 11, 33, "Print",ExpressionUUID->"c9f5408c-a8f6-4978-a860-2260d99d7e0c"],
Cell[12118, 338, 497, 10, 33, "Print",ExpressionUUID->"0c5afca5-f94d-4231-b4bc-b5e1acb9936d"]
}, Open  ]]
}, Open  ]],
Cell[12642, 352, 455, 7, 50, "Text",ExpressionUUID->"0042b054-4e97-4367-a662-e65afa084b88"],
Cell[13100, 361, 3511, 83, 588, "Input",ExpressionUUID->"f40c7ae8-621c-4c1e-98b0-9baba43adaf5"],
Cell[CellGroupData[{
Cell[16636, 448, 690, 12, 65, "Input",ExpressionUUID->"79e5646b-1661-4d90-b169-5fd84c1d4765"],
Cell[CellGroupData[{
Cell[17351, 464, 517, 12, 33, "Print",ExpressionUUID->"48d66b39-1692-46da-aca0-8dbc0a7bbc46"],
Cell[17871, 478, 521, 12, 33, "Print",ExpressionUUID->"1cfa842f-762a-408f-8d7d-ab2e679a2506"],
Cell[18395, 492, 497, 11, 33, "Print",ExpressionUUID->"daa28d19-a0a3-4d85-9685-af570f5b52e7"]
}, Open  ]]
}, Open  ]],
Cell[18919, 507, 453, 7, 50, "Text",ExpressionUUID->"fcfaf35f-bfd7-4933-84b2-3bb38b6db2a0"],
Cell[CellGroupData[{
Cell[19397, 518, 510, 13, 70, "Input",ExpressionUUID->"707cb223-ce67-4505-98f0-47fb04d37a5b"],
Cell[19910, 533, 7909, 185, 470, "Print",ExpressionUUID->"e6f01d88-b64b-4c9a-bbd0-e30a61b72165"]
}, Open  ]],
Cell[27834, 721, 504, 8, 50, "Text",ExpressionUUID->"fc898be7-5ebd-492c-ace1-584ab8bee358"],
Cell[CellGroupData[{
Cell[28363, 733, 469, 12, 101, "Input",ExpressionUUID->"748cae56-b45e-4ffd-a3d9-d12fd831bdee"],
Cell[28835, 747, 246, 3, 48, "Output",ExpressionUUID->"2c85b094-2fec-4163-aa41-d319d8c870fc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29118, 755, 499, 13, 87, "Input",ExpressionUUID->"26af1378-6161-4c5f-ba15-0b95b5e35922"],
Cell[29620, 770, 3659, 81, 570, "Print",ExpressionUUID->"36965766-a9c5-44b4-8d5e-44608420074e"]
}, Open  ]],
Cell[33294, 854, 503, 8, 50, "Text",ExpressionUUID->"6a57d7b7-914e-4524-8e41-4f5319e9c9cc"],
Cell[CellGroupData[{
Cell[33822, 866, 440, 12, 105, "Input",ExpressionUUID->"e91e06b6-3f36-4037-b29a-5eceac19fb2a"],
Cell[34265, 880, 268, 4, 67, "Output",ExpressionUUID->"119d8afb-c3c5-4f9b-84e6-297433bbb9de"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34570, 889, 471, 13, 69, "Input",ExpressionUUID->"11aacdfa-5033-41e2-a2cc-ddd0400735f4"],
Cell[35044, 904, 3629, 80, 570, "Print",ExpressionUUID->"5aa14178-38f8-4a5f-a180-ffcfd46a4448"]
}, Open  ]],
Cell[38688, 987, 504, 8, 50, "Text",ExpressionUUID->"8da46b7c-5d90-4488-af83-add2f480df2c"],
Cell[CellGroupData[{
Cell[39217, 999, 424, 10, 88, "Input",ExpressionUUID->"c8c4a3e8-1e82-4377-8e76-95736f4282a4"],
Cell[39644, 1011, 246, 3, 48, "Output",ExpressionUUID->"b532e924-468b-4c40-841d-42ee97e1a67d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39927, 1019, 481, 13, 66, "Input",ExpressionUUID->"67ca2ae2-6df6-4892-a74c-a96d1b3448a4"],
Cell[40411, 1034, 3632, 80, 570, "Print",ExpressionUUID->"9d7da3a9-a6b0-4e6a-be7d-1dd46237e908"]
}, Open  ]],
Cell[44058, 1117, 555, 8, 50, "Text",ExpressionUUID->"4355d957-1f17-4904-824a-565c17a2cf08"],
Cell[CellGroupData[{
Cell[44638, 1129, 528, 14, 101, "Input",ExpressionUUID->"63304652-a467-474c-a57f-48dea1574c59"],
Cell[45169, 1145, 246, 3, 48, "Output",ExpressionUUID->"796defd9-bf9d-4d8f-bfee-9d10f56835db"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45452, 1153, 560, 15, 57, "Input",ExpressionUUID->"c3fe80df-4676-49b8-ba46-30274ffd0e60"],
Cell[46015, 1170, 3634, 80, 570, "Print",ExpressionUUID->"a14923ab-9fa2-4f53-9858-5493d1f9896d"]
}, Open  ]],
Cell[49664, 1253, 505, 8, 50, "Text",ExpressionUUID->"7a21cd77-c9d7-401c-98b9-81134b06e937"],
Cell[CellGroupData[{
Cell[50194, 1265, 517, 13, 96, "Input",ExpressionUUID->"89e76a5d-b9c5-4f53-9f49-a110edbb016c"],
Cell[50714, 1280, 263, 4, 67, "Output",ExpressionUUID->"7c44aa99-857a-47de-9582-cccb4661d33a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51014, 1289, 545, 14, 69, "Input",ExpressionUUID->"9938fc7b-bbb2-44b7-9829-8eb2af5e0bb1"],
Cell[51562, 1305, 3631, 80, 570, "Print",ExpressionUUID->"e5bbfcd4-737e-4ecf-baac-ce5cf54b1d15"]
}, Open  ]],
Cell[55208, 1388, 503, 8, 50, "Text",ExpressionUUID->"6d7f2e52-b7b9-4bcd-940b-6887efb4fd06"],
Cell[55714, 1398, 2717, 93, 85, "Text",ExpressionUUID->"8ac14d23-26b5-4b5d-b863-8c320094e1c1"],
Cell[58434, 1493, 503, 8, 50, "Text",ExpressionUUID->"15866bae-531a-4e59-9cd9-efb60ca9df9c"],
Cell[58940, 1503, 640, 14, 148, "Text",ExpressionUUID->"2a959fdc-eaea-4108-9e36-06488ff5c8d9"],
Cell[59583, 1519, 505, 8, 50, "Text",ExpressionUUID->"ee35b877-28de-4efd-a6a8-f3b84938b120"],
Cell[60091, 1529, 484, 10, 148, "Text",ExpressionUUID->"4672a2eb-2c32-48d7-be1e-cd1e669934be"],
Cell[CellGroupData[{
Cell[60600, 1543, 365, 9, 88, "Input",ExpressionUUID->"c8ca1046-9b07-4203-a020-9e4e500a405e"],
Cell[60968, 1554, 244, 3, 48, "Output",ExpressionUUID->"024e7198-1f88-44d8-9345-918333768b81"]
}, Open  ]],
Cell[61227, 1560, 505, 8, 50, "Text",ExpressionUUID->"e9498f59-c5a7-4e24-9548-d784aa0d6912"],
Cell[61735, 1570, 946, 17, 278, "Text",ExpressionUUID->"9b35fad7-6ddc-4bea-a2f2-0413340966bf"],
Cell[CellGroupData[{
Cell[62706, 1591, 393, 10, 92, "Input",ExpressionUUID->"1f3695bd-d1e6-4106-9602-d2157d4f4ec0"],
Cell[63102, 1603, 242, 3, 48, "Output",ExpressionUUID->"c21e1399-0a3a-4f84-946f-ac413520be85"]
}, Open  ]],
Cell[63359, 1609, 505, 8, 50, "Text",ExpressionUUID->"198f4756-5cf8-41ad-8079-ba959e201f06"],
Cell[63867, 1619, 843, 16, 245, "Text",ExpressionUUID->"f1caa5f7-714a-4717-ab5d-cd8cb5415c44"],
Cell[CellGroupData[{
Cell[64735, 1639, 1211, 33, 181, "Input",ExpressionUUID->"8a633410-90c7-464c-b121-ef7e122a7d41"],
Cell[65949, 1674, 403, 7, 48, "Output",ExpressionUUID->"64aca936-54a7-4412-aa45-f10bcc67e6b0"]
}, Open  ]],
Cell[66367, 1684, 505, 8, 50, "Text",ExpressionUUID->"1ed984d8-a50e-4e3a-b70e-cb853db471b7"],
Cell[CellGroupData[{
Cell[66897, 1696, 361, 8, 65, "Input",ExpressionUUID->"afe69cfd-63fc-430c-915d-ec646b4188ed"],
Cell[67261, 1706, 669, 14, 139, "Print",ExpressionUUID->"4f574d13-a671-43af-9126-39a4c8a4ee32"]
}, Open  ]],
Cell[67945, 1723, 1186, 22, 148, "Text",ExpressionUUID->"4c21a459-8690-4d1f-bdd9-058e1e0416f4"],
Cell[69134, 1747, 505, 8, 50, "Text",ExpressionUUID->"fa6bd18c-adb3-4d1b-9930-822cb75c2808"],
Cell[69642, 1757, 970, 27, 205, "Input",ExpressionUUID->"2f77adec-7a0a-49f4-8c2a-ad6a28bd6f17"],
Cell[70615, 1786, 1274, 33, 58, "Text",ExpressionUUID->"9191c7f6-bfe8-4616-8280-677acb16a458"],
Cell[CellGroupData[{
Cell[71914, 1823, 355, 9, 87, "Input",ExpressionUUID->"df5b9abd-636a-431a-b6e0-6b55bdf76b4f"],
Cell[72272, 1834, 371, 8, 71, "Output",ExpressionUUID->"6122f9de-201f-428c-8a99-bd7bd75ce784"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72680, 1847, 508, 14, 65, "Input",ExpressionUUID->"1dd6f5af-b752-424a-8d09-a10525539e19"],
Cell[73191, 1863, 3638, 81, 570, "Print",ExpressionUUID->"ffbdf883-5781-4003-a7da-d59e020a64e6"]
}, Open  ]],
Cell[76844, 1947, 503, 8, 50, "Text",ExpressionUUID->"4dfea418-3c45-46aa-b64d-82faeecb1c3e"],
Cell[77350, 1957, 780, 22, 148, "Input",ExpressionUUID->"d24b475c-33c0-4fc0-a684-4b993436f09a"],
Cell[78133, 1981, 1020, 25, 50, "Text",ExpressionUUID->"40b359e0-b1d8-4514-aedc-5b6d6da2e5c6"],
Cell[CellGroupData[{
Cell[79178, 2010, 353, 8, 42, "Input",ExpressionUUID->"df9254a0-ec48-4918-b86b-837c6ffd8fdf"],
Cell[79534, 2020, 291, 5, 48, "Output",ExpressionUUID->"967bebe5-db3e-4938-81d3-f4f452ff1f06"]
}, Open  ]],
Cell[79840, 2028, 1136, 27, 88, "Text",ExpressionUUID->"a41da24d-bd48-4caa-a3fd-e047aaa61520"],
Cell[CellGroupData[{
Cell[81001, 2059, 386, 10, 97, "Input",ExpressionUUID->"a5b1aea2-4edf-40c3-830d-1731df7dcaed"],
Cell[81390, 2071, 246, 3, 48, "Output",ExpressionUUID->"b11aed99-e959-4cb0-8e9e-66e2ee0c33bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81673, 2079, 537, 14, 65, "Input",ExpressionUUID->"5bce838e-93de-4f36-927d-cf35eb2369fc"],
Cell[82213, 2095, 3627, 80, 570, "Print",ExpressionUUID->"6770d7a9-bc16-48f2-8b27-c987ff1c277d"]
}, Open  ]],
Cell[85855, 2178, 503, 8, 50, "Text",ExpressionUUID->"eec82e06-72b1-4762-960b-5a8594dd4784"],
Cell[86361, 2188, 717, 20, 173, "Input",ExpressionUUID->"d194ee4d-a5f9-4fcd-aec7-bb93b65f58ae"],
Cell[87081, 2210, 1069, 26, 58, "Text",ExpressionUUID->"bc6d285a-7c2b-4f98-b531-b59da5f6e463"],
Cell[CellGroupData[{
Cell[88175, 2240, 402, 9, 42, "Input",ExpressionUUID->"572b5222-9184-451b-a3ac-20b1f5210267"],
Cell[88580, 2251, 366, 8, 50, "Output",ExpressionUUID->"a99e5b63-481f-45cf-8bfd-a6207779a5ee"]
}, Open  ]],
Cell[88961, 2262, 2076, 54, 89, "Text",ExpressionUUID->"bd9a11ee-2ebd-43bc-b019-7495205f024c"],
Cell[CellGroupData[{
Cell[91062, 2320, 487, 12, 105, "Input",ExpressionUUID->"0cfc2565-1ad8-4ff7-8fa2-bed97ec721c2"],
Cell[91552, 2334, 352, 7, 71, "Output",ExpressionUUID->"66c5ba3b-ad90-4a15-baad-172a3f984c13"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91941, 2346, 639, 16, 91, "Input",ExpressionUUID->"7920028c-1364-4a1e-8e36-92510eac6d71"],
Cell[92583, 2364, 3606, 80, 570, "Print",ExpressionUUID->"8b1a481c-4b01-4dcb-a410-0f89152fc3eb"]
}, Open  ]],
Cell[96204, 2447, 503, 8, 50, "Text",ExpressionUUID->"c38e1f6d-5193-4275-a703-c083a81704cc"],
Cell[96710, 2457, 1040, 29, 201, "Input",ExpressionUUID->"09e8de72-b259-44af-946a-3c9a0b7a14a8"],
Cell[97753, 2488, 1158, 29, 63, "Text",ExpressionUUID->"732eb036-7164-4bbd-8d8e-c543ba3ba227"],
Cell[CellGroupData[{
Cell[98936, 2521, 490, 12, 74, "Input",ExpressionUUID->"1c7a99fe-f8e8-40af-8dc4-8bf3a9da0158"],
Cell[99429, 2535, 414, 9, 67, "Output",ExpressionUUID->"68c9be98-c147-451f-aed0-3393a868dab0"]
}, Open  ]],
Cell[99858, 2547, 2983, 83, 127, "Text",ExpressionUUID->"b6a78feb-2154-41e3-8a21-67cb4f21d7be"],
Cell[CellGroupData[{
Cell[102866, 2634, 433, 13, 91, "Input",ExpressionUUID->"52f999e4-e5cc-4536-b824-638f0ce6d010"],
Cell[103302, 2649, 863, 26, 72, "Output",ExpressionUUID->"f33748ca-e817-41c9-9aa5-0acfee418297"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104202, 2680, 836, 22, 110, "Input",ExpressionUUID->"d104995c-2b94-4967-989e-312ec31a4f5b"],
Cell[105041, 2704, 317, 6, 72, "Output",ExpressionUUID->"7e603824-05e1-4a15-9b88-8cc9af656ddc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105395, 2715, 1917, 55, 323, "Input",ExpressionUUID->"5eb3e1a5-9dbb-4148-8f98-0eb17845e88c"],
Cell[107315, 2772, 322, 8, 72, "Output",ExpressionUUID->"253c73ee-56ac-46e0-9c4c-f29ff71f3fc6"]
}, Open  ]],
Cell[107652, 2783, 1403, 21, 115, "Text",ExpressionUUID->"4fd1068e-4e95-4dbe-8ebe-248af949308b"],
Cell[CellGroupData[{
Cell[109080, 2808, 1107, 27, 138, "Input",ExpressionUUID->"ffda7ce6-636a-4929-b80a-f680cace8306"],
Cell[110190, 2837, 3611, 80, 570, "Print",ExpressionUUID->"824ed428-a3c9-4974-96a7-5c932859effd"]
}, Open  ]],
Cell[113816, 2920, 502, 8, 50, "Text",ExpressionUUID->"5c251466-8c40-4f9f-a050-b99cb713acda"],
Cell[CellGroupData[{
Cell[114343, 2932, 539, 15, 65, "Input",ExpressionUUID->"65029b5f-bc70-4b92-912d-9f0bad7e7b29"],
Cell[114885, 2949, 4450, 97, 202, "Print",ExpressionUUID->"82df3268-693c-456b-a2e4-6b00983925f9"]
}, Open  ]],
Cell[119350, 3049, 259, 7, 115, "Text",ExpressionUUID->"e9dc1a32-8c9b-4811-9f64-158e63bc43f7"],
Cell[119612, 3058, 503, 8, 50, "Text",ExpressionUUID->"1adff09d-ddae-4766-9615-ff0c55e83b41"],
Cell[CellGroupData[{
Cell[120140, 3070, 590, 16, 70, "Input",ExpressionUUID->"1322767b-7010-4f28-b5e9-315cbbeed85a"],
Cell[120733, 3088, 4471, 97, 180, "Print",ExpressionUUID->"d915faa2-d3c9-4b8c-bee2-f8ae16a81cd8"]
}, Open  ]],
Cell[125219, 3188, 272, 5, 50, "Text",ExpressionUUID->"bd4b5f44-33d5-4085-a438-03500112e2ca"],
Cell[125494, 3195, 503, 8, 50, "Text",ExpressionUUID->"3125782c-ba0f-42bb-972b-ed5c484da3c6"],
Cell[CellGroupData[{
Cell[126022, 3207, 473, 12, 48, "Input",ExpressionUUID->"0b5156ae-c3d2-458a-90e2-6dff52297e7d"],
Cell[126498, 3221, 4525, 99, 200, "Print",ExpressionUUID->"79f445bb-0745-4594-be6e-2247d9cb2d50"]
}, Open  ]],
Cell[131038, 3323, 295, 5, 50, "Text",ExpressionUUID->"09ce141f-23ec-4626-b071-a7cd42664d2c"],
Cell[131336, 3330, 503, 8, 50, "Text",ExpressionUUID->"42b397b3-ed38-4889-8594-5f8fadac0030"],
Cell[CellGroupData[{
Cell[131864, 3342, 563, 15, 71, "Input",ExpressionUUID->"e6f300ee-8fb5-4290-ac0d-266dace62375"],
Cell[132430, 3359, 4461, 96, 202, "Print",ExpressionUUID->"cfb5ad6b-b133-4a74-8bed-d793762a2e7e"]
}, Open  ]],
Cell[136906, 3458, 297, 8, 115, "Text",ExpressionUUID->"72accebb-e5cd-4de8-986e-e1024f34ce96"],
Cell[137206, 3468, 550, 8, 50, "Text",ExpressionUUID->"7c26215e-3a9a-4e65-9260-d365c5b12e99"],
Cell[CellGroupData[{
Cell[137781, 3480, 807, 24, 72, "Input",ExpressionUUID->"3de70fce-eece-4cb8-ae50-5f253e28c668"],
Cell[138591, 3506, 4738, 101, 202, "Print",ExpressionUUID->"c20319c4-01e5-4a63-8aeb-3796c6013ccb"]
}, Open  ]],
Cell[143344, 3610, 272, 5, 50, "Text",ExpressionUUID->"0350bbba-788f-415d-bfe9-7f2df5756dbd"]
}
]
*)

