(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13044,        325]
NotebookOptionsPosition[     10929,        285]
NotebookOutlinePosition[     11363,        302]
CellTagsIndexPosition[     11320,        299]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8054644717107096`*^9, 
  3.8054644792552147`*^9}},ExpressionUUID->"521c3dcf-d57a-4b87-89b2-\
f9600aa8dee3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"divisores", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Cont_", ":", "1"}], ",", 
    RowBox[{"Lista_", ":", 
     RowBox[{"{", "}"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"L", "=", "Lista"}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"Cont", "\[LessEqual]", "n"}], ",", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Mod", "[", 
           RowBox[{"n", ",", "Cont"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"L", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"L", ",", "Cont"}], "]"}]}]}], "]"}], ";", 
       RowBox[{"divisores", "[", 
        RowBox[{"n", ",", 
         RowBox[{"Cont", "+", "1"}], ",", "L"}], "]"}]}], ",", "Lista"}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8054566935394125`*^9, 3.8054567985975027`*^9}, {
  3.8054568327037697`*^9, 3.805456840550306*^9}, {3.8054584779307117`*^9, 
  3.805458486863541*^9}, {3.805459891838873*^9, 3.8054599360892315`*^9}, {
  3.8054600896320577`*^9, 3.805460091090658*^9}, {3.8054601258194327`*^9, 
  3.8054601512417192`*^9}, {3.8054601884305525`*^9, 3.805460214233794*^9}, {
  3.805460316465517*^9, 3.8054603202548647`*^9}, {3.805460359378515*^9, 
  3.8054603622891626`*^9}, {3.8054604504141045`*^9, 3.8054606531152744`*^9}, {
  3.8054607279896793`*^9, 3.805460739839119*^9}, {3.805460823637156*^9, 
  3.80546086051805*^9}, {3.8054608932464023`*^9, 3.805460921144067*^9}, {
  3.805460960500742*^9, 3.8054610287610207`*^9}, {3.8054610896393948`*^9, 
  3.805461117289094*^9}, {3.805461166385903*^9, 3.805461176457569*^9}, {
  3.805461290369897*^9, 3.805461293960186*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"1a85e539-2c22-4071-8986-48794810393d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"divisores", "[", "36", "]"}]], "Input",
 CellChangeTimes->{{3.805456842998784*^9, 3.8054568490492673`*^9}, {
   3.8054599325244455`*^9, 3.8054599432348557`*^9}, {3.8054599742473345`*^9, 
   3.805459991933117*^9}, {3.8054601342950077`*^9, 3.8054601386095867`*^9}, 
   3.805460240180313*^9, {3.8054604439474564`*^9, 3.8054604448481665`*^9}, {
   3.805460532407349*^9, 3.8054605416177716`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"6f349cd2-41aa-4898-a215-3fdcd8963682"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "9", ",", "12", ",", "18",
    ",", "36"}], "}"}]], "Output",
 CellChangeTimes->{{3.8054599390571227`*^9, 3.8054599436551437`*^9}, 
   3.8054600652872257`*^9, 3.805460095348693*^9, {3.805460131506851*^9, 
   3.8054601551400504`*^9}, {3.805460240906771*^9, 3.805460258806752*^9}, {
   3.8054603234901123`*^9, 3.805460339591893*^9}, {3.8054603813904295`*^9, 
   3.8054604017071576`*^9}, {3.8054604464070435`*^9, 3.805460462683119*^9}, {
   3.8054604958902817`*^9, 3.8054605152071266`*^9}, {3.8054605456660633`*^9, 
   3.8054605609236975`*^9}, 3.805460597206859*^9, {3.805460631640402*^9, 
   3.805460656323526*^9}, 3.8054607429236765`*^9, {3.805460835253647*^9, 
   3.8054609551132517`*^9}, {3.8054609872066793`*^9, 3.8054610085732784`*^9}, 
   3.8054611223069067`*^9, 3.8054611791566763`*^9, 3.8054613072382135`*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"e6a52c42-b79f-4407-86e9-46386f516369"]
}, Open  ]],

Cell["Mejorado:", "Text",
 CellChangeTimes->{{3.8054624102954755`*^9, 
  3.805462413116367*^9}},ExpressionUUID->"79b05366-b1a7-4f05-a338-\
29cceefeb5c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Otrodivisores", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"Cont_", ":", "1"}], ",", 
    RowBox[{"Lista_", ":", 
     RowBox[{"{", "}"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"L", "=", "Lista"}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"Cont", "\[LessEqual]", 
       RowBox[{"n", "/", "2"}]}], ",", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Mod", "[", 
           RowBox[{"n", ",", "Cont"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"L", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"L", ",", "Cont"}], "]"}]}]}], "]"}], ";", 
       RowBox[{"Otrodivisores", "[", 
        RowBox[{"n", ",", 
         RowBox[{"Cont", "+", "1"}], ",", "L"}], "]"}]}], ",", 
      RowBox[{"Append", "[", 
       RowBox[{"Lista", ",", "n"}], "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.805462534644561*^9, 3.805462564404257*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"caa2d817-eac0-4c79-864c-e5f043b1d543"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Otrodivisores", "[", "36", "]"}]], "Input",
 CellChangeTimes->{{3.805462572348583*^9, 3.805462575083432*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"0662686d-07b7-4ac7-8a95-f9dd736c976d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "9", ",", "12", ",", "18",
    ",", "36"}], "}"}]], "Output",
 CellChangeTimes->{3.8054625758933926`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"d3c62744-a97b-4d91-835c-a22896992e06"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisores", "[", 
  RowBox[{"36", ",", 
   RowBox[{"steps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.805464464712696*^9, 3.805464492806911*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"a026939b-6603-4eed-a670-e35f7d2510be"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Divisores[\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "1", "}"}]}],
  SequenceForm["Divisores[", 36, ",", 1, "] = ", {1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054644935214376`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"1985194b-f8ba-4875-af47-bc4429a2cdb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Divisores[\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}],
  SequenceForm["Divisores[", 36, ",", 2, "] = ", {1, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805464493525629*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"ab516d8f-7f9f-4e22-a4ba-dfeeb1cbc4cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Divisores[\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Divisores[", 36, ",", 3, "] = ", {1, 2, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805464493529461*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"9a6f3bdb-110c-4b50-b7aa-128cf21661ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Divisores[\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Divisores[", 36, ",", 4, "] = ", {1, 2, 3, 4}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805464493529461*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"96f1c3f0-a770-472e-84b0-e073716954f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Divisores[\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "6"}], "}"}]}],
  SequenceForm["Divisores[", 36, ",", 6, "] = ", {1, 2, 3, 4, 6}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805464493529461*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"9b532fd4-05c7-42fa-9678-8e6529d66c39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Divisores[\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "9"}], "}"}]}],
  SequenceForm["Divisores[", 36, ",", 9, "] = ", {1, 2, 3, 4, 6, 9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805464493533424*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"382debfa-c9e3-432b-a41c-206b72ed6713"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Divisores[\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "9", ",", "12"}], 
    "}"}]}],
  SequenceForm["Divisores[", 36, ",", 12, "] = ", {1, 2, 3, 4, 6, 9, 12}],
  Editable->False]], "Print",
 CellChangeTimes->{3.805464493533424*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"1ecaf808-7a53-438e-b395-9d03edacc01e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Divisores[\"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "9", ",", "12", ",", 
     "18"}], "}"}]}],
  SequenceForm["Divisores[", 36, ",", 18, "] = ", {1, 2, 3, 4, 6, 9, 12, 18}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054644935374174`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"2f5a54dd-bc8e-4060-9b54-0833877a7c53"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "9", ",", "12", ",", "18",
    ",", "36"}], "}"}]], "Output",
 CellChangeTimes->{3.8054644935374174`*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"d256bf2e-c81c-41bf-aa3e-fea97bc844f8"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a2168a52-8000-4e87-a160-526428a5d948"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 184, 4, 63, "Input",ExpressionUUID->"521c3dcf-d57a-4b87-89b2-f9600aa8dee3"],
Cell[745, 26, 1797, 39, 377, "Input",ExpressionUUID->"1a85e539-2c22-4071-8986-48794810393d"],
Cell[CellGroupData[{
Cell[2567, 69, 493, 7, 63, "Input",ExpressionUUID->"6f349cd2-41aa-4898-a215-3fdcd8963682"],
Cell[3063, 78, 985, 15, 100, "Output",ExpressionUUID->"e6a52c42-b79f-4407-86e9-46386f516369"]
}, Open  ]],
Cell[4063, 96, 153, 3, 77, "Text",ExpressionUUID->"79b05366-b1a7-4f05-a338-29cceefeb5c0"],
Cell[4219, 101, 1090, 30, 453, "Input",ExpressionUUID->"caa2d817-eac0-4c79-864c-e5f043b1d543"],
Cell[CellGroupData[{
Cell[5334, 135, 211, 3, 63, "Input",ExpressionUUID->"0662686d-07b7-4ac7-8a95-f9dd736c976d"],
Cell[5548, 140, 275, 6, 100, "Output",ExpressionUUID->"d3c62744-a97b-4d91-835c-a22896992e06"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5860, 151, 268, 5, 125, "Input",ExpressionUUID->"a026939b-6603-4eed-a670-e35f7d2510be"],
Cell[CellGroupData[{
Cell[6153, 160, 495, 11, 50, "Print",ExpressionUUID->"1985194b-f8ba-4875-af47-bc4429a2cdb2"],
Cell[6651, 173, 521, 12, 50, "Print",ExpressionUUID->"ab516d8f-7f9f-4e22-a4ba-dfeeb1cbc4cc"],
Cell[7175, 187, 534, 12, 50, "Print",ExpressionUUID->"9a6f3bdb-110c-4b50-b7aa-128cf21661ca"],
Cell[7712, 201, 547, 12, 50, "Print",ExpressionUUID->"96f1c3f0-a770-472e-84b0-e073716954f4"],
Cell[8262, 215, 560, 12, 50, "Print",ExpressionUUID->"9b532fd4-05c7-42fa-9678-8e6529d66c39"],
Cell[8825, 229, 573, 12, 50, "Print",ExpressionUUID->"382debfa-c9e3-432b-a41c-206b72ed6713"],
Cell[9401, 243, 600, 14, 50, "Print",ExpressionUUID->"1ecaf808-7a53-438e-b395-9d03edacc01e"],
Cell[10004, 259, 618, 14, 50, "Print",ExpressionUUID->"2f5a54dd-bc8e-4060-9b54-0833877a7c53"]
}, Open  ]],
Cell[10637, 276, 276, 6, 107, "Output",ExpressionUUID->"d256bf2e-c81c-41bf-aa3e-fea97bc844f8"]
}, Open  ]]
}
]
*)

