(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     60550,       1333]
NotebookOptionsPosition[     58228,       1288]
NotebookOutlinePosition[     58659,       1305]
CellTagsIndexPosition[     58616,       1302]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8153009695895443`*^9, 3.815300972178948*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e9e316bb-a390-4f5d-b21a-7cdf71c37052"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "c"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"2bc9779a-55b8-4bc1-8055-3a0d1e9e2b6f"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQBGImKN7yLNnfKJXBQcVOzdHhwlP7oqaFodYcv+wZoABd
/mKcbLd48gf78vfd837sf2SPLq8Rb7Jivuw/+1ulnMfOCH3GkBdWvup4LeGD
fdO7DrXk3u8Y9qGbjy6Pbj66/KajUuWvn94C8Zd9/xKI4V50/ejyMHOc4w5e
5r6I6d8jpRmW7oFH7dtzc48sFsTUj24/un3o/kfno9uPLo9uP7p6QvLo7kNX
jy4PAMlU6mA=
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.815326683354455*^9, 3.815326792588498*^9, 
  3.8153274971552477`*^9, 3.815332718221923*^9, 3.8153400251873236`*^9, 
  3.815389085951014*^9, 3.8154136602269173`*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"091a5644-9390-43a5-97ac-a0d395476a1f"]
}, Open  ]],

Cell["Ejemplos de \[AAcute]rboles generadores:", "Text",
 CellChangeTimes->{{3.8153268020916414`*^9, 
  3.815326817562863*^9}},ExpressionUUID->"0a4cfe63-83ba-483b-8ad8-\
0be04e19602c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h"}], "}"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ResaltarRuta", "[", 
   RowBox[{"grafo", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"h", ",", "b"}], "}"}]}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8153265037555785`*^9, 3.815326560028741*^9}, {
  3.815326607588854*^9, 3.8153266232876806`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"3ff8001c-f17f-4691-bd56-1b19b950078c"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`e, $CellContext`f], 
         UndirectedEdge[$CellContext`d, $CellContext`c], 
         UndirectedEdge[$CellContext`e, $CellContext`b], 
         UndirectedEdge[$CellContext`a, $CellContext`e], 
         UndirectedEdge[$CellContext`a, $CellContext`h], 
         UndirectedEdge[$CellContext`a, $CellContext`g], 
         UndirectedEdge[$CellContext`a, $CellContext`d]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.6270097107846166`, 0.}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024,
           0.5859339806188321}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.8822323389521873`, 1.1920898185556923`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132,
           1.4720183854359736`}}]}, 
        LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
         0.5859339806188321}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
         1.1920898185556923`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
          0.6817683349463056}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {
          0.16654291442038816`, 1.1918065712878574`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0.4202831900721221,
          0.0010960024301311933`}}], 
        LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
         1.023641831549132, 1.4720183854359736`}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
         1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
         0.0010960024301311933`}}], 
        LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
         0.4202831900721221, 0.0010960024301311933`}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8153265151153917`*^9, 3.8153265612708044`*^9, 
  3.8153266236367016`*^9, 3.8153266863513136`*^9, 3.8153267979154124`*^9, 
  3.815327499815337*^9, 3.815332721254898*^9, 3.815340029846551*^9, 
  3.815389088639615*^9, 3.815413664913335*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"b6d75f8f-ecf1-4789-8a86-32b6f7a13071"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`d, $CellContext`g], 
         UndirectedEdge[$CellContext`e, $CellContext`f], 
         UndirectedEdge[$CellContext`d, $CellContext`e], 
         UndirectedEdge[$CellContext`d, $CellContext`c], 
         UndirectedEdge[$CellContext`e, $CellContext`b], 
         UndirectedEdge[$CellContext`a, $CellContext`h], 
         UndirectedEdge[$CellContext`a, $CellContext`d]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.6270097107846166`, 0.}}]}, 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024, 
         0.5859339806188321}}], 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132,
           1.4720183854359736`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
          0.5859339806188321}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
          1.1920898185556923`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
          0.6817683349463056}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {
          0.16654291442038816`, 1.1918065712878574`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0.4202831900721221,
          0.0010960024301311933`}}], 
        LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
         1.023641831549132, 1.4720183854359736`}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
         1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
         0.0010960024301311933`}}], 
        LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
         0.4202831900721221, 0.0010960024301311933`}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8153265151153917`*^9, 3.8153265612708044`*^9, 
  3.8153266236367016`*^9, 3.8153266863513136`*^9, 3.8153267979154124`*^9, 
  3.815327499815337*^9, 3.815332721254898*^9, 3.815340029846551*^9, 
  3.815389088639615*^9, 3.8154136649761677`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"d2216c5c-d1c1-4c71-9a1a-dd1429192a2e"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`d, $CellContext`g], 
         UndirectedEdge[$CellContext`e, $CellContext`f], 
         UndirectedEdge[$CellContext`d, $CellContext`c], 
         UndirectedEdge[$CellContext`e, $CellContext`g], 
         UndirectedEdge[$CellContext`e, $CellContext`b], 
         UndirectedEdge[$CellContext`a, $CellContext`g], 
         UndirectedEdge[$CellContext`g, $CellContext`h]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {
         1.6270097107846166`, 0.}}], 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024, 
         0.5859339806188321}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.8822323389521873`, 1.1920898185556923`}}]}, 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132, 
         1.4720183854359736`}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
         0.5859339806188321}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
          1.1920898185556923`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {
          1.8822323389521873`, 1.1920898185556923`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
          0.6817683349463056}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {
          0.16654291442038816`, 1.1918065712878574`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0.4202831900721221,
          0.0010960024301311933`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
          1.023641831549132, 1.4720183854359736`}}]}, 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
         1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
         0.0010960024301311933`}}], 
        LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
         0.4202831900721221, 0.0010960024301311933`}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8153265151153917`*^9, 3.8153265612708044`*^9, 
  3.8153266236367016`*^9, 3.8153266863513136`*^9, 3.8153267979154124`*^9, 
  3.815327499815337*^9, 3.815332721254898*^9, 3.815340029846551*^9, 
  3.815389088639615*^9, 3.8154136650130663`*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"74c2b737-6600-49ba-b74d-235c5b5d5e99"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`h, $CellContext`b], 
         UndirectedEdge[$CellContext`d, $CellContext`g], 
         UndirectedEdge[$CellContext`b, $CellContext`c], 
         UndirectedEdge[$CellContext`e, $CellContext`c], 
         UndirectedEdge[$CellContext`d, $CellContext`c], 
         UndirectedEdge[$CellContext`a, $CellContext`d], 
         UndirectedEdge[$CellContext`f, $CellContext`c]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.6270097107846166`, 0.}}]}, 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024, 
         0.5859339806188321}}], 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132, 
         1.4720183854359736`}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
         0.5859339806188321}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
          1.1920898185556923`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {
          0.4202831900721221, 0.0010960024301311933`}}]}, 
        LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
         1.023641831549132, 1.4720183854359736`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
          0.6817683349463056}}]}, 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
         1.1918065712878574`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
          0.4202831900721221, 0.0010960024301311933`}}]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8153265151153917`*^9, 3.8153265612708044`*^9, 
  3.8153266236367016`*^9, 3.8153266863513136`*^9, 3.8153267979154124`*^9, 
  3.815327499815337*^9, 3.815332721254898*^9, 3.815340029846551*^9, 
  3.815389088639615*^9, 3.8154136650529604`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"cad9fa9e-4954-4f94-a128-2fb199b4bfc8"]
}, Open  ]],

Cell["Buscar primero a lo ancho:", "Text",
 CellChangeTimes->{{3.8153268020916414`*^9, 3.815326817562863*^9}, {
  3.8153368030168133`*^9, 3.8153368075241904`*^9}, {3.815413602038128*^9, 
  3.8154136032523637`*^9}},ExpressionUUID->"7bddbd1d-d0ab-4c04-b28d-\
b71e3512243f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "h"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.815334589524667*^9, 3.8153346215237055`*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"aacaafc3-210d-4408-bc8a-94edb3376d09"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`a, $CellContext`e], 
         UndirectedEdge[$CellContext`a, $CellContext`h], 
         UndirectedEdge[$CellContext`a, $CellContext`g], 
         UndirectedEdge[$CellContext`a, $CellContext`d]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.6270097107846166`, 0.}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024,
           0.5859339806188321}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.8822323389521873`, 1.1920898185556923`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132,
           1.4720183854359736`}}]}, 
        LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
         0.5859339806188321}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
         1.1920898185556923`}}], 
        LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
         0.0010960024301311933`}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0.4202831900721221,
          0.0010960024301311933`}}], 
        LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
         1.023641831549132, 1.4720183854359736`}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
         1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
         0.0010960024301311933`}}], 
        LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
         0.4202831900721221, 0.0010960024301311933`}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.815334617436367*^9, 3.8153346223737946`*^9}, 
   3.8153400349862165`*^9, 3.8153890939135027`*^9, 3.8154136699395533`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"8d62aa65-82b4-4fb9-9528-3f6a886c7ad9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "c"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8153350448070307`*^9, 3.8153350536368694`*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"daa9a461-f3dc-43a8-b0f2-5a06e5c73c1f"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`d, $CellContext`c], 
         UndirectedEdge[$CellContext`a, $CellContext`e], 
         UndirectedEdge[$CellContext`a, $CellContext`h], 
         UndirectedEdge[$CellContext`a, $CellContext`g], 
         UndirectedEdge[$CellContext`a, $CellContext`d]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.6270097107846166`, 0.}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024,
           0.5859339806188321}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.8822323389521873`, 1.1920898185556923`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132,
           1.4720183854359736`}}]}, 
        LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
         0.5859339806188321}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
         1.1920898185556923`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0.4202831900721221,
          0.0010960024301311933`}}], 
        LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
         1.023641831549132, 1.4720183854359736`}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
         1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
         0.0010960024301311933`}}], 
        LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
         0.4202831900721221, 0.0010960024301311933`}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.81533505657487*^9, 3.8153400376765723`*^9, 
  3.815389166163192*^9, 3.8154136726640124`*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"7f3612de-8a06-4da3-8e50-2ff55557562b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8153360772906733`*^9, 3.8153360935739202`*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"7b65fd7d-fa6d-4b58-b36f-d613ad7e8fef"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`e, $CellContext`f], 
         UndirectedEdge[$CellContext`d, $CellContext`c], 
         UndirectedEdge[$CellContext`e, $CellContext`b], 
         UndirectedEdge[$CellContext`a, $CellContext`e], 
         UndirectedEdge[$CellContext`a, $CellContext`h], 
         UndirectedEdge[$CellContext`a, $CellContext`g], 
         UndirectedEdge[$CellContext`a, $CellContext`d]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.6270097107846166`, 0.}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024,
           0.5859339806188321}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.8822323389521873`, 1.1920898185556923`}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132,
           1.4720183854359736`}}]}, 
        LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
         0.5859339806188321}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
         1.1920898185556923`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
          0.6817683349463056}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {
          0.16654291442038816`, 1.1918065712878574`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0.4202831900721221,
          0.0010960024301311933`}}], 
        LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
         1.023641831549132, 1.4720183854359736`}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
         0.6817683349463056}}], 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {
         0.16654291442038816`, 1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
         1.1918065712878574`}}], 
        LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
         0.0010960024301311933`}}], 
        LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
         0.4202831900721221, 0.0010960024301311933`}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.8153360978034267`*^9, 3.815340040620144*^9, 
  3.815389610472225*^9, 3.8154136759950824`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"29f65466-dba4-4495-8eef-6f02b82a3579"]
}, Open  ]],

Cell["Buscar primero a lo largo o a profundidad:", "Text",
 CellChangeTimes->{{3.8153268020916414`*^9, 3.815326817562863*^9}, {
  3.8153368030168133`*^9, 3.815336823573577*^9}, {3.8154136088108845`*^9, 
  3.81541360995965*^9}},ExpressionUUID->"41f4a8d0-e4f1-4075-813b-\
5f25b003ef34"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResaltarRuta", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "g"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.815336840889886*^9, 3.8153368445239563`*^9}, {
  3.8153374823885098`*^9, 3.8153374957162924`*^9}, {3.8153379257558393`*^9, 
  3.815337934290251*^9}, {3.8153382819902706`*^9, 3.815338290707385*^9}, {
  3.8153384323583155`*^9, 3.815338435611721*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"8d1a684d-2e50-440a-98e0-c2b4eb532237"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h, $CellContext`b, $CellContext`f, $CellContext`c}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {6, 3}, {6, 7}, {8, 2}, {8, 3}, {
       2, 3}, {2, 4}, {3, 7}, {4, 5}, {4, 3}, {6, 8}, {7, 5}, {5, 6}, {7, 
       8}}}, {GraphHighlight -> {
         UndirectedEdge[$CellContext`c, $CellContext`d], 
         UndirectedEdge[$CellContext`e, $CellContext`f], 
         UndirectedEdge[$CellContext`b, $CellContext`c], 
         UndirectedEdge[$CellContext`f, $CellContext`h], 
         UndirectedEdge[$CellContext`a, $CellContext`d], 
         UndirectedEdge[$CellContext`b, $CellContext`e], 
         UndirectedEdge[$CellContext`h, $CellContext`g]}, 
       GraphHighlightStyle -> {"Thick"}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{2.049412365185015, 0.6816712639283122}, {
          1.6270097107846166`, 0.}}]}, 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.024192374627024, 
         0.5859339806188321}}], 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        LineBox[{{2.049412365185015, 0.6816712639283122}, {1.023641831549132, 
         1.4720183854359736`}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.024192374627024, 
         0.5859339806188321}}], 
        LineBox[{{1.6270097107846166`, 0.}, {1.8822323389521873`, 
         1.1920898185556923`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.6270097107846166`, 0.}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {
         1.8822323389521873`, 1.1920898185556923`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {0., 
          0.6817683349463056}}]}, 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.024192374627024, 0.5859339806188321}, {
          0.16654291442038816`, 1.1918065712878574`}}]}, 
        LineBox[{{1.024192374627024, 0.5859339806188321}, {0.4202831900721221,
          0.0010960024301311933`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.8822323389521873`, 1.1920898185556923`}, {
          1.023641831549132, 1.4720183854359736`}}]}, 
        LineBox[{{1.023641831549132, 1.4720183854359736`}, {0., 
         0.6817683349463056}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{1.023641831549132, 1.4720183854359736`}, {
          0.16654291442038816`, 1.1918065712878574`}}]}, 
        LineBox[{{0., 0.6817683349463056}, {0.16654291442038816`, 
         1.1918065712878574`}}], 
        {Hue[1, 1, 0.7], Thickness[Large], Opacity[1], 
         LineBox[{{0., 0.6817683349463056}, {0.4202831900721221, 
          0.0010960024301311933`}}]}, 
        LineBox[{{0.16654291442038816`, 1.1918065712878574`}, {
         0.4202831900721221, 0.0010960024301311933`}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.049412365185015, 0.6816712639283122}, 
          0.023011135042656228], 
         InsetBox["a", 
          Offset[{2, 2}, {2.072423500227671, 0.7046823989709685}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6270097107846166, 0.}, 0.023011135042656228], 
         InsetBox["d", 
          Offset[{2, 2}, {1.650020845827273, 0.023011135042656228}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.024192374627024, 0.5859339806188321}, 
          0.023011135042656228], 
         InsetBox["e", 
          Offset[{2, 2}, {1.0472035096696803, 0.6089451156614882}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8822323389521873, 1.1920898185556923}, 
          0.023011135042656228], 
         InsetBox["g", 
          Offset[{2, 2}, {1.9052434739948436, 1.2151009535983486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.023641831549132, 1.4720183854359736}, 
          0.023011135042656228], 
         InsetBox["h", Offset[{2, 2}, {1.0466529665917883, 1.49502952047863}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6817683349463056}, 0.023011135042656228], 
         InsetBox["b", 
          Offset[{2, 2}, {0.023011135042656228, 0.7047794699889618}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.16654291442038816, 1.1918065712878574}, 
          0.023011135042656228], 
         InsetBox["f", 
          Offset[{2, 2}, {0.18955404946304438, 1.2148177063305137}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4202831900721221, 0.0010960024301311933}, 
          0.023011135042656228], 
         InsetBox["c", 
          Offset[{2, 2}, {0.44329432511477834, 0.02410713747278742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.815337496825825*^9, 3.815337934757846*^9, 
  3.8153382916815557`*^9, 3.8153384365167627`*^9, 3.815339201540661*^9, 
  3.815340044072506*^9, 3.815389616841828*^9, 3.815413679385147*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"0bf0a379-5a99-4c59-89b7-315b533169d2"]
}, Open  ]]
},
WindowSize->{949, 478},
WindowMargins->{{-960, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"35736efe-4774-4e95-b2c1-72499fdb71a9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"e9e316bb-a390-4f5d-b21a-7cdf71c37052"],
Cell[CellGroupData[{
Cell[783, 27, 1264, 39, 265, "Input",ExpressionUUID->"2bc9779a-55b8-4bc1-8055-3a0d1e9e2b6f"],
Cell[2050, 68, 3439, 74, 575, "Output",ExpressionUUID->"091a5644-9390-43a5-97ac-a0d395476a1f"]
}, Open  ]],
Cell[5504, 145, 184, 3, 77, "Text",ExpressionUUID->"0a4cfe63-83ba-483b-8ad8-0be04e19602c"],
Cell[CellGroupData[{
Cell[5713, 152, 2530, 77, 653, "Input",ExpressionUUID->"3ff8001c-f17f-4691-bd56-1b19b950078c"],
Cell[8246, 231, 5943, 119, 568, "Output",ExpressionUUID->"b6d75f8f-ecf1-4789-8a86-32b6f7a13071"],
Cell[14192, 352, 5945, 119, 568, "Output",ExpressionUUID->"d2216c5c-d1c1-4c71-9a1a-dd1429192a2e"],
Cell[20140, 473, 5945, 119, 568, "Output",ExpressionUUID->"74c2b737-6600-49ba-b74d-235c5b5d5e99"],
Cell[26088, 594, 5945, 119, 568, "Output",ExpressionUUID->"cad9fa9e-4954-4f94-a128-2fb199b4bfc8"]
}, Open  ]],
Cell[32048, 716, 271, 4, 77, "Text",ExpressionUUID->"7bddbd1d-d0ab-4c04-b28d-b71e3512243f"],
Cell[CellGroupData[{
Cell[32344, 724, 520, 14, 135, "Input",ExpressionUUID->"aacaafc3-210d-4408-bc8a-94edb3376d09"],
Cell[32867, 740, 5477, 111, 568, "Output",ExpressionUUID->"8d62aa65-82b4-4fb9-9528-3f6a886c7ad9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38381, 856, 585, 16, 135, "Input",ExpressionUUID->"daa9a461-f3dc-43a8-b0f2-5a06e5c73c1f"],
Cell[38969, 874, 5564, 113, 568, "Output",ExpressionUUID->"7f3612de-8a06-4da3-8e50-2ff55557562b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44570, 992, 711, 20, 179, "Input",ExpressionUUID->"7b65fd7d-fa6d-4b58-b36f-d613ad7e8fef"],
Cell[45284, 1014, 5799, 117, 575, "Output",ExpressionUUID->"29f65466-dba4-4495-8eef-6f02b82a3579"]
}, Open  ]],
Cell[51098, 1134, 284, 4, 77, "Text",ExpressionUUID->"41f4a8d0-e4f1-4075-813b-5f25b003ef34"],
Cell[CellGroupData[{
Cell[51407, 1142, 912, 23, 179, "Input",ExpressionUUID->"8d1a684d-2e50-440a-98e0-c2b4eb532237"],
Cell[52322, 1167, 5890, 118, 575, "Output",ExpressionUUID->"0bf0a379-5a99-4c59-89b7-315b533169d2"]
}, Open  ]]
}
]
*)

