(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     39214,        900]
NotebookOptionsPosition[     35574,        844]
NotebookOutlinePosition[     36006,        861]
CellTagsIndexPosition[     35963,        858]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8202311176947727`*^9, 3.8202311208363905`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegularToAutomata", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<S->bS|aA\>\"", ",", "\"\<A->bA\>\"", ",", "\"\<A->b\>\""}], 
   "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.820823429587946*^9, 3.8208234917398224`*^9}, {
   3.820823572517356*^9, 3.8208235845986457`*^9}, {3.8208236772089405`*^9, 
   3.820823699395233*^9}, {3.8208237316601486`*^9, 3.8208237557800984`*^9}, {
   3.8208238086285315`*^9, 3.82082383725289*^9}, {3.820823959792466*^9, 
   3.8208239644928865`*^9}, {3.8208240045015917`*^9, 3.820824011158896*^9}, {
   3.8208241161432004`*^9, 3.8208241340992985`*^9}, {3.8208241652902756`*^9, 
   3.8208241803417063`*^9}, {3.8208242621176414`*^9, 3.820824287015196*^9}, {
   3.82082451843407*^9, 3.820824567479201*^9}, {3.820824682207261*^9, 
   3.820824693303362*^9}, {3.820825561183046*^9, 3.820825637074468*^9}, 
   3.8208256725816145`*^9, {3.8208336505358047`*^9, 3.8208336628884068`*^9}, {
   3.8208372859237485`*^9, 3.8208373251384196`*^9}, 3.820839182628265*^9, {
   3.8208581258563538`*^9, 3.820858142193227*^9}, {3.8208599063330097`*^9, 
   3.820859907224715*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"e2de7402-a111-4019-bb3c-af00c70bdc59"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm["Estados: ", {"A", "EA", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208581451255426`*^9, 3.820859908018611*^9, 
  3.820863458072468*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"f07d7aa3-a072-4b06-8e99-14f5bcde81c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos de entrada: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}]}],
  SequenceForm["S\[IAcute]mbolos de entrada: ", {"a", "b"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208581451255426`*^9, 3.820859908018611*^9, 
  3.820863458074463*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"2c1c5c04-76d4-4c4a-bf04-bda13c9f7792"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", "\<\"S\"\>"}],
  SequenceForm["Estado inicial: ", "S"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208581451255426`*^9, 3.820859908018611*^9, 
  3.8208634580764575`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"dff242fa-2186-4d81-8a00-c079373be7c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"EA\"\>", "}"}]}],
  SequenceForm["Estados aceptados: ", {"EA"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208581451255426`*^9, 3.820859908018611*^9, 
  3.8208634580764575`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"8f1ffdcf-6def-4ee7-93b7-721539d71413"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "\<\"a\"\>", "\<\"b\"\>"},
     {"\<\"A\"\>", 
      RowBox[{"{", "}"}], 
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]},
     {"\<\"EA\"\>", 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {"\<\"S\"\>", 
      RowBox[{"{", "\<\"A\"\>", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.8208581451255426`*^9, 3.820859908018611*^9, 
  3.820863458078452*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"7df939cf-0fc6-4ef1-b1d8-286bbe5d9466"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Funci\[OAcute]n de transici\[OAcute]n de estados con otro \
formato: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"A\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"A\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"EA\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"EA\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "\<\"A\"\>", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", "\<\"S\"\>", "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Funci\[OAcute]n de transici\[OAcute]n de estados con otro formato: ", {{
    "A", "a", {}}, {"A", "b", {"A", "EA"}}, {"EA", "a", {}}, {
    "EA", "b", {}}, {"S", "a", {"A"}}, {"S", "b", {"S"}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208581451255426`*^9, 3.820859908018611*^9, 
  3.8208634580794506`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"8bb7bbf9-abe7-4f1c-a052-f57829cd4658"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
   InsetBox["\<\"A\"\>", {0.99999950000025, 0.500000249999875}], 
   PolygonBox[{{0.5893902837518628, 0.06331553765522902}, {0.5649516228080215,
     0.03750048124975942}, {0.599527447927207, 0.029243508240653027`}}], 
   CircleBox[{0.41943899367211673, 0.5805610063278832}, 0.5622176261343743, {
    4.974088368183839, 6.021285919380437}], 
   InsetBox["\<\"b\"\>", {0.8169471328370685, 0.18297335758387556}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.097006802410284, 0.5401819903073393}, 
    0.03749998125000937, {-2.2252947962927703`, 3.010692959690218}], 
   PolygonBox[{{1.0976127270772782`, 0.48699678808123537`}, {
    1.074178260236728, 0.5104312549217856}, {1.1061903372650637`, 
    0.519008865109571}}], 
   InsetBox["\<\"b\"\>", {1.111357423948664, 0.5055365251608985}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 0.07499996250001874],
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
    0.04999997500001249], 
   InsetBox["\<\"EA\"\>", {0.499999750000125, 4.999997500476638*^-7}], 
   CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
   InsetBox["\<\"S\"\>", {0.499999750000125, 0.500000249999875}], 
   PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702, 
    0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
   CircleBox[{0.7499996250001875, 0.21187656611285788}, 0.35511094850116554, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"a\"\>", {0.7499996250001875, 0.5669875146140234}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.4360798319141684, 0.4166981909203249}, 
    0.03749998125000937, {-4.843288674284264, 0.3926990816987246}], 
   PolygonBox[{{0.4089624846467197, 0.4624549648200464}, {
    0.44097456167505544`, 0.4538773546322609}, {0.41754009483450516`, 
    0.43044288779171064`}}], 
   InsetBox["\<\"b\"\>", {0.40632909652861476, 0.43952673309388085}, 
    ImageScaled[{1, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8208581451255426`*^9, 3.820859908018611*^9, 
  3.820863458081444*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"de1162bf-907e-40a0-86ce-478f0f75e7cc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegularToAutomata", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<S->bS|aA\>\"", ",", "\"\<A->bA\>\"", ",", "\"\<A->b\>\""}], 
    "}"}], ",", 
   RowBox[{"dfa", "\[Rule]", "True"}], ",", 
   RowBox[{"colores", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"027416e5-6352-4285-886c-34085a697b72"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm["Estados: ", {"A", "EA", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.820863461468274*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"8c310cf0-fb94-4991-900f-1d30e49a40ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"S\[IAcute]mbolos de entrada: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}]}],
  SequenceForm["S\[IAcute]mbolos de entrada: ", {"a", "b"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614702682`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"5b847f2b-40d6-4082-b8e2-ffbd815baff0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", "\<\"S\"\>"}],
  SequenceForm["Estado inicial: ", "S"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.820863461472263*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"2e0e0ca3-0efe-4ddf-871e-ab8f224e2954"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"EA\"\>", "}"}]}],
  SequenceForm["Estados aceptados: ", {"EA"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.820863461473262*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"0063f26f-d147-47b2-91c3-7f879abc3dbc"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "\<\"a\"\>", "\<\"b\"\>"},
     {"\<\"A\"\>", 
      RowBox[{"{", "}"}], 
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]},
     {"\<\"EA\"\>", 
      RowBox[{"{", "}"}], 
      RowBox[{"{", "}"}]},
     {"\<\"S\"\>", 
      RowBox[{"{", "\<\"A\"\>", "}"}], 
      RowBox[{"{", "\<\"S\"\>", "}"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614742594`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"15c84b0b-2827-45f6-88ea-805fc88dbdf8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Funci\[OAcute]n de transici\[OAcute]n de estados con otro \
formato: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"A\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"A\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"EA\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"EA\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"a\"\>", ",", 
       RowBox[{"{", "\<\"A\"\>", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"S\"\>", ",", "\<\"b\"\>", ",", 
       RowBox[{"{", "\<\"S\"\>", "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "Funci\[OAcute]n de transici\[OAcute]n de estados con otro formato: ", {{
    "A", "a", {}}, {"A", "b", {"A", "EA"}}, {"EA", "a", {}}, {
    "EA", "b", {}}, {"S", "a", {"A"}}, {"S", "b", {"S"}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614752564`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"27246644-0988-4b91-84e3-fd6ca2079214"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del aut\[OAcute]mata no \
determin\[IAcute]stico: \"\>"], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614762535`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"d6a5e222-479e-4cc7-84e3-d2dd47108643"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0., 0.8, 0.8], 
    CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
    InsetBox["\<\"A\"\>", {0.99999950000025, 0.500000249999875}], 
    PolygonBox[{{0.5893902837518628, 0.06331553765522902}, {
     0.5649516228080215, 0.03750048124975942}, {0.599527447927207, 
     0.029243508240653027`}}], 
    CircleBox[{0.41943899367211673, 0.5805610063278832}, 0.5622176261343743, {
     4.974088368183839, 6.021285919380437}], 
    InsetBox["\<\"b\"\>", {0.8169471328370685, 0.18297335758387556}, 
     ImageScaled[{1, 1}]], 
    CircleBox[{1.097006802410284, 0.5401819903073393}, 
     0.03749998125000937, {-2.2252947962927703`, 3.010692959690218}], 
    PolygonBox[{{1.0976127270772782`, 0.48699678808123537`}, {
     1.074178260236728, 0.5104312549217856}, {1.1061903372650637`, 
     0.519008865109571}}], 
    InsetBox["\<\"b\"\>", {1.111357423948664, 0.5055365251608985}, 
     ImageScaled[{0, 1}]]}, 
   {Hue[0.3333333333333333, 0.8, 0.8], 
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
     0.07499996250001874], 
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
     0.04999997500001249], 
    InsetBox["\<\"EA\"\>", {0.499999750000125, 4.999997500476638*^-7}]}, 
   {Hue[0.6666666666666666, 0.8, 0.8], 
    CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
    InsetBox["\<\"S\"\>", {0.499999750000125, 0.500000249999875}], 
    PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702,
      0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
    CircleBox[{0.7499996250001875, 0.21187656611285788}, 
     0.35511094850116554, {1.0471975511965979`, 2.0943951023931953`}], 
    InsetBox["\<\"a\"\>", {0.7499996250001875, 0.5669875146140234}, 
     ImageScaled[{Rational[1, 2], 1}]], 
    CircleBox[{0.4360798319141684, 0.4166981909203249}, 
     0.03749998125000937, {-4.843288674284264, 0.3926990816987246}], 
    PolygonBox[{{0.4089624846467197, 0.4624549648200464}, {
     0.44097456167505544`, 0.4538773546322609}, {0.41754009483450516`, 
     0.43044288779171064`}}], 
    InsetBox["\<\"b\"\>", {0.40632909652861476, 0.43952673309388085}, 
     ImageScaled[{1, 0}]]}, 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614782467`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"c3b122d2-d726-4e8c-ae54-4e5e5b9de347"],

Cell[BoxData["\<\"Estados del nuevo aut\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.820863461479244*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"c6826383-03e9-45a5-983d-d7f1ac065e45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "0"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 0], "=", {}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614802413`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"413ec1ed-1937-4e3f-886a-be4a20db9bf6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "1"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"A\"\>", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 1], "=", {"A"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614822397`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"b8c59c51-4a8f-4283-a4fd-46f24c555e1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "2"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"EA\"\>", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 2], "=", {"EA"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614832363`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"d613ef2a-5492-4b51-9c90-bb0167dd18e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "3"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"S\"\>", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 3], "=", {"S"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614852467`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"ca6df448-e737-4a15-9280-37ea4571735c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "4"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 4], "=", {"A", "EA"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.820863461487224*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"25629927-e262-46a0-b952-f9db5843e6e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "5"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 5], "=", {"A", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614892187`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"863edcc1-b80d-4c95-ba42-a9fe0775a853"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "6"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"EA\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 6], "=", {"EA", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.820863461491213*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"604413c2-62ee-4d11-9404-95a761137c41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "7"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"EA\"\>", ",", "\<\"S\"\>"}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 7], "=", {"A", "EA", "S"}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.820863461493208*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"c232dcfd-dcc3-4bec-ae12-4f9f1676eeee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", 
   SubscriptBox["\[Mu]", "3"]}],
  SequenceForm["Estado inicial: ", 
   Subscript[$CellContext`\[Mu], 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634614942055`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"5fefb7e8-d791-478f-9617-4b92f4ba621b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Mu]", "2"], ",", 
     SubscriptBox["\[Mu]", "4"], ",", 
     SubscriptBox["\[Mu]", "6"], ",", 
     SubscriptBox["\[Mu]", "7"]}], "}"}]}],
  SequenceForm["Estados aceptados: ", {
    Subscript[$CellContext`\[Mu], 2], 
    Subscript[$CellContext`\[Mu], 4], 
    Subscript[$CellContext`\[Mu], 6], 
    Subscript[$CellContext`\[Mu], 7]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.820863461495202*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"1446bbe3-a4ab-410c-bc13-b193c77b5291"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "\<\"a\"\>", "\<\"b\"\>"},
     {
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "4"]},
     {
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "3"], 
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "3"]},
     {
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "4"]},
     {
      SubscriptBox["\[Mu]", "5"], 
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "7"]},
     {
      SubscriptBox["\[Mu]", "6"], 
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "3"]},
     {
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "7"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.820863461496199*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"3a07fd15-186a-4443-b74c-d9cf83b44b12"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del nuevo aut\[OAcute]mata: \
\"\>"], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.820863461497197*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"c8d28b1d-6f85-4c78-a2f9-623d130947b7"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0., 0.8, 0.8], 
    CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.04999998333333889],
     InsetBox[
     SubscriptBox["\[Mu]", "0"], {0.33333322222225925, 0.3333335555554815}], 
    CircleBox[{0.2673752459194204, 0.3098912413487075}, 
     0.024999991666669445, {0.8650875961944626, 6.1010753521774514`}], 
    PolygonBox[{{0.2619834528835181, 0.32430154627717905`}, {
     0.2835895766183788, 0.32892003698370126`}, {0.2687867844719579, 
     0.3453222436621394}}], 
    InsetBox["\<\"b,a\"\>", {0.25900299084557254, 0.3334476614568642}, 
     ImageScaled[{1, 0}]]}, 
   {Hue[0.125, 0.8, 0.8], 
    CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.04999998333333889], 
    InsetBox[
     SubscriptBox["\[Mu]", "1"], {0.6666664444445185, 0.6666667777777407}], 
    PolygonBox[{{0.9328471027649555, 0.6789566106913189}, {0.9517033914510827,
      0.6796077257192175}, {0.9417113649530732, 0.6956121932285474}}], 
    CircleBox[{0.8333330555556482, 0.47458428983933065}, 
     0.23674067179086933, {1.047197551196598, 2.0943951023931957`}], 
    InsetBox["\<\"b\"\>", {0.8333330555556481, 0.7113249616302}, 
     ImageScaled[{Rational[1, 2], 1}]], 
    PolygonBox[{{0.3761819238643474, 0.3924240409933943}, {0.3583332138889287,
      0.37663481131095156`}, {0.3809314428878207, 0.36907198988867956`}}], 
    CircleBox[{0.2929380487840684, 0.7499376333205561}, 0.37898749918622177, {
     4.885709232361319, 5.932906783557916}], 
    InsetBox["\<\"a\"\>", {0.5361942736235182, 0.4593211616327223}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.25, 0.8, 0.8], 
    CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.04999998333333889], 
    CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.033333322222225924],
     InsetBox[
     SubscriptBox["\[Mu]", "2"], {0.6666664444445185, 0.3333335555554815}], 
    PolygonBox[{{0.3904037440889282, 0.2996701609341659}, {0.3800533031231002,
      0.3155225372254409}, {0.3989570841846085, 0.3165600938965816}}], 
    CircleBox[{0.49499413150124794, 0.5243460326175367}, 
     0.23836662152248342, {4.209222634615871, 5.2563201858126245`}], 
    InsetBox["\<\"b,a\"\>", {0.4998522860404239, 0.28602892330619}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.375, 0.8, 0.8], 
    CircleBox[{0.33333322222225925, 0.6666667777777407}, 0.04999998333333889],
     InsetBox[
     SubscriptBox["\[Mu]", "3"], {0.33333322222225925, 0.6666667777777407}], 
    PolygonBox[{{0.5995138805426964, 0.678956610691319}, {0.6183701692288235, 
     0.6796077257192175}, {0.608378142730814, 0.6956121932285473}}], 
    CircleBox[{0.4999998333333889, 0.47458428983933065}, 
     0.23674067179086933, {1.0471975511965979`, 2.0943951023931953`}], 
    InsetBox["\<\"a\"\>", {0.4999998333333889, 0.7113249616302}, 
     ImageScaled[{Rational[1, 2], 1}]], 
    CircleBox[{0.2636890890569017, 0.6596175615815305}, 
     0.024999991666669445, {0.6244728861991278, 5.860460642182116}], 
    PolygonBox[{{0.2618865955041381, 0.6748975922511915}, {0.283970867788202, 
     0.6742342997548754}, {0.2735031597981195, 0.6936914868251254}}], 
    InsetBox["\<\"b\"\>", {0.2611715118439695, 0.6844904662834439}, 
     ImageScaled[{1, 0}]]}, 
   {Hue[0.5, 0.8, 0.8], 
    CircleBox[{0.9999996666667778, 0.6666667777777407}, 0.04999998333333889], 
    CircleBox[{0.9999996666667778, 0.6666667777777407}, 0.033333322222225924],
     InsetBox[
     SubscriptBox["\[Mu]", "4"], {0.9999996666667778, 0.6666667777777407}], 
    PolygonBox[{{0.4091849608079152, 0.3246796581568}, {0.38269950831427196`, 
     0.34126880166481655`}, {0.41030885426606156`, 0.35591130460102927`}}], 
    CircleBox[{0.41957068900898586, 0.9895805389796867}, 0.6493593710004099, {
     4.655577569539737, 5.702675120736336}], 
    InsetBox["\<\"a\"\>", {0.7117661836507825, 0.4096759040464213}, 
     ImageScaled[{1, 1}]], 
    CircleBox[{1.0681270732203834, 0.6827494768551563}, 
     0.024999991666669445, {-2.386170073491091, 2.8498176824918975`}], 
    PolygonBox[{{1.0628462561080523`, 0.6476858013968444}, {
     1.0499275320665744`, 0.6656095735554187}, {1.071909336108283, 
     0.6678356306805321}}], 
    InsetBox["\<\"b\"\>", {1.0738708943194604, 0.6584182602288686}, 
     ImageScaled[{0, 1}]]}, 
   {Hue[0.625, 0.8, 0.8], 
    CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
     0.04999998333333889], InsetBox[
     SubscriptBox["\[Mu]", 
      "5"], {0.33333322222225925, 3.333332222466012*^-7}], 
    PolygonBox[{{0.9233724525282158, 0.30876021576166235`}, {
     0.9510147970317592, 0.3233095403831862}, {0.9245935400498414, 
     0.33997385063265406`}}], 
    CircleBox[{0.9121439810373855, -0.32428812874138213}, 
     0.6487631936166255, {1.5108451601974036`, 2.558042711394002}], 
    InsetBox["\<\"b\"\>", {0.622008260592059, 0.2559833121492707}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.5967589123226277, 0.6321659262446591}, {0.6279288727286632,
      0.6350535072905998}, {0.6148446110669167, 0.6066157392210476}}], 
    CircleBox[{0.9931930949576415, 0.09557308973360079}, 0.6515037014231113, {
     2.165964430825126, 3.213161982021723}], 
    InsetBox["\<\"a\"\>", {0.4071247906352822, 0.3801447250677094}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.75, 0.8, 0.8], 
    CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
     0.04999998333333889], 
    CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
     0.033333322222225924], InsetBox[
     SubscriptBox["\[Mu]", "6"], {0.6666664444445185, 3.333332222466012*^-7}],
     PolygonBox[{{0.6287457626142631, 0.6031102287822871}, {
     0.6537254965030418, 0.6183705025620457}, {0.6544514143206289, 
     0.5891072815447089}}], 
    CircleBox[{1.1478335214626518, 0.33477523426710504}, 0.5697095896408679, {
     2.6205448396497815`, 3.667742390846379}], 
    InsetBox["\<\"a\"\>", {0.5781257854864036, 0.3333219285237823}, 
     ImageScaled[{1, 1}]], 
    PolygonBox[{{0.32662409978759793`, 0.5912883219245798}, {
     0.3433523388574792, 0.617680905986131}, {0.3578448675913582, 
     0.5899975339602589}}], 
    CircleBox[{0.9912740257399619, 0.577351206301743}, 0.6491756287856741, {
     3.079428140929592, 4.12662569212619}], 
    InsetBox["\<\"b\"\>", {0.40999253539467073, 0.28831690731417886}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.875, 0.8, 0.8], 
    CircleBox[{0.9999996666667778, 0.3333335555554815}, 0.04999998333333889], 
    CircleBox[{0.9999996666667778, 0.3333335555554815}, 0.033333322222225924],
     InsetBox[
     SubscriptBox["\[Mu]", "7"], {0.9999996666667778, 0.3333335555554815}], 
    PolygonBox[{{0.6861488488169574, 0.6002700019182626}, {0.6916621058606197,
      0.6233630222396145}, {0.7089046195871895, 0.6070418914215335}}], 
    CircleBox[{1.05370251650274, 0.7203764578299402}, 0.37481310759224223, {
     3.40340492664485, 4.450602477841448}], 
    InsetBox["\<\"a\"\>", {0.7886730414852764, 0.4553401527792522}, 
     ImageScaled[{1, 1}]], 
    CircleBox[{1.0690957656693696, 0.3221208022825782}, 
     0.024999991666669445, {-2.778869155189815, 2.4571186007931733`}], 
    PolygonBox[{{1.050798639148629, 0.29174707141026474`}, {
     1.0457224250711192`, 0.3132502593109373}, {1.0668828390942067`, 
     0.30689479570677264`}}], 
    InsetBox["\<\"b\"\>", {1.065091210929047, 0.29744362406736685}, 
     ImageScaled[{1, 1}]]}, 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.33333322222225925`, 0.7666667444444185}, {
     0.33333322222225925`, 0.7166667611110796}}], 
    PolygonBox[{{0.33333322222225925`, 0.7166667611110796}, {
     0.31666656111114627`, 0.7416667527777491}, {0.34999988333337223`, 
     0.7416667527777491}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634615011864`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"ce62e4bc-f3b0-4d60-866c-a428b2695dbb"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n reducido del nuevo aut\
\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634615031815`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"4fffc3f0-52d4-4597-80ce-8319230b8192"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0., 0.8, 0.8], 
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
     0.07499996250001874], InsetBox[
     SubscriptBox["\[Mu]", "0"], {0.499999750000125, 4.999997500476638*^-7}], 
    CircleBox[{0.3958980916067041, -0.01370474333073372}, 
     0.03749998125000937, {0.6544984694978742, 5.8904862254808625`}], 
    PolygonBox[{{0.3925074861593689, 0.009123798842822186}, {
     0.4256488269922577, 0.009123798842822231}, {0.40907815657581326`, 
     0.03782504191958244}}], 
    InsetBox["\<\"b,a\"\>", {0.391003361845817, 0.023474420381202305}, 
     ImageScaled[{1, 0}]]}, 
   {Hue[0.25, 0.8, 0.8], 
    CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
    InsetBox[
     SubscriptBox["\[Mu]", "1"], {0.99999950000025, 0.500000249999875}], 
    PolygonBox[{{1.0184370726956367`, 0.1006884219098928}, {
     1.0194109186772298`, 0.07244490074922978}, {1.0433836025038907`, 
     0.08741003668899433}}], 
    CircleBox[{0.7118758161132328, 0.25000037499981254}, 
     0.35511094850116565, {5.759486531581288, 6.8067840827778845`}], 
    InsetBox["\<\"b\"\>", {1.0669867641705097, 0.24998261945239483}, 
     ImageScaled[{1, Rational[1, 2]}]], 
    PolygonBox[{{0.5893902837518628, 0.06331553765522902}, {
     0.5649516228080215, 0.03750048124975942}, {0.599527447927207, 
     0.029243508240653027`}}], 
    CircleBox[{0.41943899367211673, 0.5805610063278832}, 0.5622176261343743, {
     4.974088368183839, 6.021285919380437}], 
    InsetBox["\<\"a\"\>", {0.8169471328370685, 0.18297335758387556}, 
     ImageScaled[{1, 1}]]}, 
   {Hue[0.5, 0.8, 0.8], 
    CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
    InsetBox[
     SubscriptBox["\[Mu]", "3"], {0.499999750000125, 0.500000249999875}], 
    PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702,
      0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
    CircleBox[{0.7499996250001875, 0.21187656611285788}, 
     0.35511094850116554, {1.0471975511965979`, 2.0943951023931953`}], 
    InsetBox["\<\"a\"\>", {0.7499996250001875, 0.5669875146140234}, 
     ImageScaled[{Rational[1, 2], 1}]], 
    CircleBox[{0.4360798319141684, 0.4166981909203249}, 
     0.03749998125000937, {-4.843288674284264, 0.3926990816987246}], 
    PolygonBox[{{0.4089624846467197, 0.4624549648200464}, {
     0.44097456167505544`, 0.4538773546322609}, {0.41754009483450516`, 
     0.43044288779171064`}}], 
    InsetBox["\<\"b\"\>", {0.40632909652861476, 0.43952673309388085}, 
     ImageScaled[{1, 0}]]}, 
   {Hue[0.75, 0.8, 0.8], 
    CircleBox[{0.99999950000025, 4.999997500476638*^-7}, 0.07499996250001874],
     CircleBox[{0.99999950000025, 4.999997500476638*^-7}, 
     0.04999997500001249], InsetBox[
     SubscriptBox["\[Mu]", "4"], {0.99999950000025, 4.999997500476638*^-7}], 
    PolygonBox[{{0.5874321879986137, -0.043417615940109656`}, {
     0.5724441507496048, -0.019410918677229667`}, {
     0.6007285790647257, -0.01843424629816045}}], 
    CircleBox[{0.7499996250001875, 0.2881241838867672}, 0.35511094850116554, {
     4.188790204786391, 5.235887755982988}], 
    InsetBox["\<\"a\"\>", {0.7499818694527698, -0.06698676417050964}, 
     ImageScaled[{Rational[1, 2], 0}]], 
    CircleBox[{1.07424567490175, -0.07424567490174998}, 
     0.03749998125000937, {-3.4033920413889422`, 1.8325957145940457`}], 
    PolygonBox[{{1.0253408324638988`, -0.09515857203874666}, {
     1.03802347452701, -0.06453996556326014}, {
     1.0581986445317046`, -0.09083275901476269}}], 
    InsetBox["\<\"b\"\>", {1.0477291838654998, -0.10076216593799998}, 
     ImageScaled[{1, 1}]]}, 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8208599123043013`*^9, 3.8208634615051765`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"50f35d2e-6e4d-48e2-b56e-822d0dcfa8d4"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{949, 467},
WindowMargins->{{0, Automatic}, {Automatic, 27}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a8572f35-c064-47f4-a398-4a1b85c180ca"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 42, "Input",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],
Cell[CellGroupData[{
Cell[785, 27, 1179, 18, 42, "Input",ExpressionUUID->"e2de7402-a111-4019-bb3c-af00c70bdc59"],
Cell[CellGroupData[{
Cell[1989, 49, 460, 11, 33, "Print",ExpressionUUID->"f07d7aa3-a072-4b06-8e99-14f5bcde81c9"],
Cell[2452, 62, 475, 11, 33, "Print",ExpressionUUID->"2c1c5c04-76d4-4c4a-bf04-bda13c9f7792"],
Cell[2930, 75, 387, 9, 33, "Print",ExpressionUUID->"dff242fa-2186-4d81-8a00-c079373be7c7"],
Cell[3320, 86, 421, 10, 33, "Print",ExpressionUUID->"8f1ffdcf-6def-4ee7-93b7-721539d71413"],
Cell[3744, 98, 999, 29, 100, "Print",ExpressionUUID->"7df939cf-0fc6-4ef1-b1d8-286bbe5d9466"],
Cell[4746, 129, 1386, 34, 60, "Print",ExpressionUUID->"8bb7bbf9-abe7-4f1c-a052-f57829cd4658"],
Cell[6135, 165, 2610, 47, 543, "Print",ExpressionUUID->"de1162bf-907e-40a0-86ce-478f0f75e7cc"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8794, 218, 357, 8, 119, "Input",ExpressionUUID->"027416e5-6352-4285-886c-34085a697b72"],
Cell[CellGroupData[{
Cell[9176, 230, 435, 10, 33, "Print",ExpressionUUID->"8c310cf0-fb94-4991-900f-1d30e49a40ea"],
Cell[9614, 242, 452, 10, 33, "Print",ExpressionUUID->"5b847f2b-40d6-4082-b8e2-ffbd815baff0"],
Cell[10069, 254, 360, 8, 33, "Print",ExpressionUUID->"2e0e0ca3-0efe-4ddf-871e-ab8f224e2954"],
Cell[10432, 264, 394, 9, 33, "Print",ExpressionUUID->"0063f26f-d147-47b2-91c3-7f879abc3dbc"],
Cell[10829, 275, 976, 28, 100, "Print",ExpressionUUID->"15c84b0b-2827-45f6-88ea-805fc88dbdf8"],
Cell[11808, 305, 1361, 33, 60, "Print",ExpressionUUID->"27246644-0988-4b91-84e3-fd6ca2079214"],
Cell[13172, 340, 299, 5, 33, "Print",ExpressionUUID->"d6a5e222-479e-4cc7-84e3-d2dd47108643"],
Cell[13474, 347, 2740, 51, 543, "Print",ExpressionUUID->"c3b122d2-d726-4e8c-ae54-4e5e5b9de347"],
Cell[16217, 400, 252, 4, 33, "Print",ExpressionUUID->"c6826383-03e9-45a5-983d-d7f1ac065e45"],
Cell[16472, 406, 437, 12, 33, "Print",ExpressionUUID->"413ec1ed-1937-4e3f-886a-be4a20db9bf6"],
Cell[16912, 420, 453, 12, 33, "Print",ExpressionUUID->"b8c59c51-4a8f-4283-a4fd-46f24c555e1f"],
Cell[17368, 434, 455, 12, 33, "Print",ExpressionUUID->"d613ef2a-5492-4b51-9c90-bb0167dd18e5"],
Cell[17826, 448, 453, 12, 33, "Print",ExpressionUUID->"ca6df448-e737-4a15-9280-37ea4571735c"],
Cell[18282, 462, 491, 13, 33, "Print",ExpressionUUID->"25629927-e262-46a0-b952-f9db5843e6e4"],
Cell[18776, 477, 491, 13, 33, "Print",ExpressionUUID->"863edcc1-b80d-4c95-ba42-a9fe0775a853"],
Cell[19270, 492, 491, 13, 33, "Print",ExpressionUUID->"604413c2-62ee-4d11-9404-95a761137c41"],
Cell[19764, 507, 514, 13, 33, "Print",ExpressionUUID->"c232dcfd-dcc3-4bec-ae12-4f9f1676eeee"],
Cell[20281, 522, 414, 10, 33, "Print",ExpressionUUID->"5fefb7e8-d791-478f-9617-4b92f4ba621b"],
Cell[20698, 534, 696, 18, 33, "Print",ExpressionUUID->"1446bbe3-a4ab-410c-bc13-b193c77b5291"],
Cell[21397, 554, 1571, 50, 224, "Print",ExpressionUUID->"3a07fd15-186a-4443-b74c-d9cf83b44b12"],
Cell[22971, 606, 277, 5, 33, "Print",ExpressionUUID->"c8d28b1d-6f85-4c78-a2f9-623d130947b7"],
Cell[23251, 613, 7831, 141, 527, "Print",ExpressionUUID->"ce62e4bc-f3b0-4d60-866c-a428b2695dbb"],
Cell[31085, 756, 288, 5, 33, "Print",ExpressionUUID->"4fffc3f0-52d4-4597-80ce-8319230b8192"],
Cell[31376, 763, 4170, 77, 556, "Print",ExpressionUUID->"50f35d2e-6e4d-48e2-b56e-822d0dcfa8d4"]
}, Open  ]]
}, Open  ]]
}
]
*)

