(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    142581,       3364]
NotebookOptionsPosition[    133793,       3257]
NotebookOutlinePosition[    134227,       3274]
CellTagsIndexPosition[    134184,       3271]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.805475080234145*^9, 3.805475093277871*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"7b0e6480-0d7d-459d-b235-4c5869c1b309"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Quicksort"}]], "Input",
 CellChangeTimes->{{3.805475740709396*^9, 3.805475741543423*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"d7de0fa9-d401-4666-b010-60824e5f634e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Implementaci\[OAcute]n del algoritmo \
\[OpenCurlyDoubleQuote]quicksort\[CloseCurlyDoubleQuote] desarrollado por el \
cient\[IAcute]fico brit\[AAcute]nico C.A.R Hoare en 1960 (ganador del premio \
Turing en 1980), para ordenar de forma recursiva una lista \
\[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] datos. La instrucci\[OAcute]n permite visualizar el \
c\[OAcute]digo de programaci\[OAcute]n del comando y las ejecuciones paso a \
paso, mediante el uso de \[OpenCurlyDoubleQuote]code->True\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]steps->True\
\[CloseCurlyDoubleQuote], respectivamente. En adici\[OAcute]n, la opci\
\[OAcute]n \[OpenCurlyDoubleQuote]ascendente->True\[CloseCurlyDoubleQuote] \
ordena la lista de forma ascendente y \
\[OpenCurlyDoubleQuote]ascendente->False\[CloseCurlyDoubleQuote] de manera \
descendente. Sintaxis: Quicksort[L], o bien, Quicksort[L, code->Valor, \
steps->Valor, ascendente->Valor].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"Quicksort", "[", 
                    RowBox[{"VilCretas`Private`L_List", ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rbegin", "=", "1"}], ",", 
                    RowBox[{"VilCretas`Private`Rend", "=", 
                    RowBox[{"Length", "[", "VilCretas`Private`L", "]"}]}]}], 
                    "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{"VilCretas`Private`L", ",", "NumericQ"}], "]"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`L", ",", "Null"}], "]"}], 
                    "\[Equal]", "False"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RAQuicksort", ",", 
                    "VilCretas`Private`RAQuicksortSteps", ",", 
                    "VilCretas`Private`RDQuicksort", ",", 
                    "VilCretas`Private`RDQuicksortSteps", ",", 
                    RowBox[{
                    "VilCretas`Private`RList7", "=", "VilCretas`Private`L"}], 
                    ",", 
                    RowBox[{
                    "VilCretas`Private`RList8", "=", "VilCretas`Private`L"}], 
                    ",", 
                    RowBox[{
                    "VilCretas`Private`RList9", "=", "VilCretas`Private`L"}], 
                    ",", 
                    RowBox[{
                    "VilCretas`Private`RList10", "=", 
                    "VilCretas`Private`L"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`RAQuicksort", "[", 
                    RowBox[{
                    "VilCretas`Private`RRbegin_", ",", 
                    "VilCretas`Private`RRend_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RRbegin", "<", 
                    "VilCretas`Private`RRend"}], ",", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri2", "=", 
                    "VilCretas`Private`RRbegin"}], ";", 
                    RowBox[{
                    "VilCretas`Private`Ri3", "=", "VilCretas`Private`RRend"}],
                     ";", 
                    RowBox[{"VilCretas`Private`RVl20", "=", 
                    RowBox[{
                    "VilCretas`Private`RList7", "\[LeftDoubleBracket]", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}], 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri2", "\[LessEqual]", 
                    "VilCretas`Private`Ri3"}], ",", 
                    RowBox[{
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList7", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri2", "\[RightDoubleBracket]"}], "<", 
                    "VilCretas`Private`RVl20"}], ",", 
                    RowBox[{"VilCretas`Private`Ri2", "++"}]}], "]"}], ";", 
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList7", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri3", "\[RightDoubleBracket]"}], ">", 
                    "VilCretas`Private`RVl20"}], ",", 
                    RowBox[{"VilCretas`Private`Ri3", "--"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri2", "\[LessEqual]", 
                    "VilCretas`Private`Ri3"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RVl21", "=", 
                    RowBox[{
                    "VilCretas`Private`RList7", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList7", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri2", "\[RightDoubleBracket]"}], "=", 
                    RowBox[{
                    "VilCretas`Private`RList7", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri3", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList7", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri3", "\[RightDoubleBracket]"}], "=", 
                    "VilCretas`Private`RVl21"}], ";", 
                    RowBox[{"VilCretas`Private`Ri2", "++"}], ";", 
                    RowBox[{"VilCretas`Private`Ri3", "--"}]}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList7", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList7", "\[LeftDoubleBracket]", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}], 
                    "\[RightDoubleBracket]"}], ",", "Blue"}], "]"}], ",", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}]}], "]"}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RRbegin", "<", 
                    "VilCretas`Private`Ri3"}], ",", 
                    RowBox[{"VilCretas`Private`RAQuicksort", "[", 
                    RowBox[{
                    "VilCretas`Private`RRbegin", ",", 
                    "VilCretas`Private`Ri3"}], "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri2", "<", "VilCretas`Private`RRend"}],
                     ",", 
                    RowBox[{"VilCretas`Private`RAQuicksort", "[", 
                    RowBox[{
                    "VilCretas`Private`Ri2", ",", "VilCretas`Private`RRend"}],
                     "]"}]}], "]"}]}]}], "]"}], ";", 
                    "VilCretas`Private`RList7"}]}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RDQuicksort", "[", 
                    RowBox[{
                    "VilCretas`Private`RRbegin_", ",", 
                    "VilCretas`Private`RRend_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RRbegin", "<", 
                    "VilCretas`Private`RRend"}], ",", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri4", "=", 
                    "VilCretas`Private`RRbegin"}], ";", 
                    RowBox[{
                    "VilCretas`Private`Ri5", "=", "VilCretas`Private`RRend"}],
                     ";", 
                    RowBox[{"VilCretas`Private`RVl22", "=", 
                    RowBox[{
                    "VilCretas`Private`RList8", "\[LeftDoubleBracket]", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}], 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri4", "\[LessEqual]", 
                    "VilCretas`Private`Ri5"}], ",", 
                    RowBox[{
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList8", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri4", "\[RightDoubleBracket]"}], ">", 
                    "VilCretas`Private`RVl22"}], ",", 
                    RowBox[{"VilCretas`Private`Ri4", "++"}]}], "]"}], ";", 
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList8", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri5", "\[RightDoubleBracket]"}], "<", 
                    "VilCretas`Private`RVl22"}], ",", 
                    RowBox[{"VilCretas`Private`Ri5", "--"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri4", "\[LessEqual]", 
                    "VilCretas`Private`Ri5"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RVl23", "=", 
                    RowBox[{
                    "VilCretas`Private`RList8", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri4", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList8", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri4", "\[RightDoubleBracket]"}], "=", 
                    RowBox[{
                    "VilCretas`Private`RList8", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri5", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList8", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri5", "\[RightDoubleBracket]"}], "=", 
                    "VilCretas`Private`RVl23"}], ";", 
                    RowBox[{"VilCretas`Private`Ri4", "++"}], ";", 
                    RowBox[{"VilCretas`Private`Ri5", "--"}]}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList8", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList8", "\[LeftDoubleBracket]", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}], 
                    "\[RightDoubleBracket]"}], ",", "Blue"}], "]"}], ",", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}]}], "]"}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RRbegin", "<", 
                    "VilCretas`Private`Ri5"}], ",", 
                    RowBox[{"VilCretas`Private`RDQuicksort", "[", 
                    RowBox[{
                    "VilCretas`Private`RRbegin", ",", 
                    "VilCretas`Private`Ri5"}], "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri4", "<", "VilCretas`Private`RRend"}],
                     ",", 
                    RowBox[{"VilCretas`Private`RDQuicksort", "[", 
                    RowBox[{
                    "VilCretas`Private`Ri4", ",", "VilCretas`Private`RRend"}],
                     "]"}]}], "]"}]}]}], "]"}], ";", 
                    "VilCretas`Private`RList8"}]}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RAQuicksortSteps", "[", 
                    RowBox[{
                    "VilCretas`Private`RRbegin_", ",", 
                    "VilCretas`Private`RRend_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RRbegin", "<", 
                    "VilCretas`Private`RRend"}], ",", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri6", "=", 
                    "VilCretas`Private`RRbegin"}], ";", 
                    RowBox[{
                    "VilCretas`Private`Ri7", "=", "VilCretas`Private`RRend"}],
                     ";", 
                    RowBox[{"VilCretas`Private`RVl24", "=", 
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}], 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilCretas`Private`RList9", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList9", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}], 
                    "\[RightDoubleBracket]"}], ",", "Blue"}], "]"}], ",", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}]}], "]"}]}], ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"Quicksort[\"\>", ",", 
                    "VilCretas`Private`RRbegin", ",", "\<\",\"\>", ",", 
                    "VilCretas`Private`RRend", ",", "\<\"] = \"\>", ",", 
                    RowBox[{"Take", "[", 
                    RowBox[{"VilCretas`Private`RList9", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RRbegin", ",", 
                    "VilCretas`Private`RRend"}], "}"}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri6", "\[LessEqual]", 
                    "VilCretas`Private`Ri7"}], ",", 
                    RowBox[{
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri6", "\[RightDoubleBracket]"}], "<", 
                    "VilCretas`Private`RVl24"}], ",", 
                    RowBox[{"VilCretas`Private`Ri6", "++"}]}], "]"}], ";", 
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri7", "\[RightDoubleBracket]"}], ">", 
                    "VilCretas`Private`RVl24"}], ",", 
                    RowBox[{"VilCretas`Private`Ri7", "--"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri6", "\[LessEqual]", 
                    "VilCretas`Private`Ri7"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RList9", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList9", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri6", "\[RightDoubleBracket]"}], ",", 
                    "Red"}], "]"}], ",", "VilCretas`Private`Ri6"}], "]"}]}], 
                    ";", 
                    RowBox[{"VilCretas`Private`RList9", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList9", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri7", "\[RightDoubleBracket]"}], ",", 
                    "Red"}], "]"}], ",", "VilCretas`Private`Ri7"}], "]"}]}], 
                    ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Take", "[", 
                    RowBox[{"VilCretas`Private`RList9", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RRbegin", ",", 
                    "VilCretas`Private`RRend"}], "}"}]}], "]"}], "]"}], ";", 
                    RowBox[{"VilCretas`Private`RList9", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList9", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri6", "\[RightDoubleBracket]"}], "]"}],
                     "]"}], ",", "VilCretas`Private`Ri6"}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`RList9", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList9", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri7", "\[RightDoubleBracket]"}], "]"}],
                     "]"}], ",", "VilCretas`Private`Ri7"}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`RVl25", "=", 
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri6", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri6", "\[RightDoubleBracket]"}], "=", 
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri7", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri7", "\[RightDoubleBracket]"}], "=", 
                    "VilCretas`Private`RVl25"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Take", "[", 
                    RowBox[{"VilCretas`Private`RList9", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RRbegin", ",", 
                    "VilCretas`Private`RRend"}], "}"}]}], "]"}], "]"}], ";", 
                    RowBox[{"VilCretas`Private`Ri6", "++"}], ";", 
                    RowBox[{"VilCretas`Private`Ri7", "--"}]}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"VilCretas`Private`RList9", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList9", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RList9", "\[LeftDoubleBracket]", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}], 
                    "\[RightDoubleBracket]"}], "]"}], "]"}], ",", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}]}], "]"}]}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"\<\"L = \"\>", ",", "VilCretas`Private`RList9"}],
                     "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RRbegin", "<", 
                    "VilCretas`Private`Ri7"}], ",", 
                    RowBox[{"VilCretas`Private`RAQuicksortSteps", "[", 
                    RowBox[{
                    "VilCretas`Private`RRbegin", ",", 
                    "VilCretas`Private`Ri7"}], "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri6", "<", "VilCretas`Private`RRend"}],
                     ",", 
                    RowBox[{"VilCretas`Private`RAQuicksortSteps", "[", 
                    RowBox[{
                    "VilCretas`Private`Ri6", ",", "VilCretas`Private`RRend"}],
                     "]"}]}], "]"}]}]}], "]"}], ";", 
                    "VilCretas`Private`RList9"}]}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RDQuicksortSteps", "[", 
                    RowBox[{
                    "VilCretas`Private`RRbegin_", ",", 
                    "VilCretas`Private`RRend_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RRbegin", "<", 
                    "VilCretas`Private`RRend"}], ",", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri8", "=", 
                    "VilCretas`Private`RRbegin"}], ";", 
                    RowBox[{
                    "VilCretas`Private`Ri9", "=", "VilCretas`Private`RRend"}],
                     ";", 
                    RowBox[{"VilCretas`Private`RVl26", "=", 
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}], 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilCretas`Private`RList10", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList10", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}], 
                    "\[RightDoubleBracket]"}], ",", "Blue"}], "]"}], ",", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}]}], "]"}]}], ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"Quicksort[\"\>", ",", 
                    "VilCretas`Private`RRbegin", ",", "\<\",\"\>", ",", 
                    "VilCretas`Private`RRend", ",", "\<\"] = \"\>", ",", 
                    RowBox[{"Take", "[", 
                    RowBox[{"VilCretas`Private`RList10", ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`RRbegin", ",", 
                    "VilCretas`Private`RRend"}], "}"}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri8", "\[LessEqual]", 
                    "VilCretas`Private`Ri9"}], ",", 
                    RowBox[{
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri8", "\[RightDoubleBracket]"}], ">", 
                    "VilCretas`Private`RVl26"}], ",", 
                    RowBox[{"VilCretas`Private`Ri8", "++"}]}], "]"}], ";", 
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri9", "\[RightDoubleBracket]"}], "<", 
                    "VilCretas`Private`RVl26"}], ",", 
                    RowBox[{"VilCretas`Private`Ri9", "--"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri8", "\[LessEqual]", 
                    "VilCretas`Private`Ri9"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RList10", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList10", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri8", "\[RightDoubleBracket]"}], ",", 
                    "Red"}], "]"}], ",", "VilCretas`Private`Ri8"}], "]"}]}], 
                    ";", 
                    RowBox[{"VilCretas`Private`RList10", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList10", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri9", "\[RightDoubleBracket]"}], ",", 
                    "Red"}], "]"}], ",", "VilCretas`Private`Ri9"}], "]"}]}], 
                    ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Take", "[", 
                    RowBox[{"VilCretas`Private`RList10", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RRbegin", ",", 
                    "VilCretas`Private`RRend"}], "}"}]}], "]"}], "]"}], ";", 
                    RowBox[{"VilCretas`Private`RList10", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList10", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri8", "\[RightDoubleBracket]"}], "]"}],
                     "]"}], ",", "VilCretas`Private`Ri8"}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`RList10", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList10", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri9", "\[RightDoubleBracket]"}], "]"}],
                     "]"}], ",", "VilCretas`Private`Ri9"}], "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`RVl27", "=", 
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri8", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri8", "\[RightDoubleBracket]"}], "=", 
                    RowBox[{"VilCretas`Private`RList10", 
                    "\[LeftDoubleBracket]", "VilCretas`Private`Ri9", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    "VilCretas`Private`Ri9", "\[RightDoubleBracket]"}], "=", 
                    "VilCretas`Private`RVl27"}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Take", "[", 
                    RowBox[{"VilCretas`Private`RList10", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RRbegin", ",", 
                    "VilCretas`Private`RRend"}], "}"}]}], "]"}], "]"}], ";", 
                    RowBox[{"VilCretas`Private`Ri8", "++"}], ";", 
                    RowBox[{"VilCretas`Private`Ri9", "--"}]}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"VilCretas`Private`RList10", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"VilCretas`Private`RList10", ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RList10", "\[LeftDoubleBracket]", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}], 
                    "\[RightDoubleBracket]"}], "]"}], "]"}], ",", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`RRbegin", "+", 
                    "VilCretas`Private`RRend"}], "2"], "]"}]}], "]"}]}], ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"L = \"\>", ",", 
                    "VilCretas`Private`RList10"}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RRbegin", "<", 
                    "VilCretas`Private`Ri9"}], ",", 
                    RowBox[{"VilCretas`Private`RDQuicksortSteps", "[", 
                    RowBox[{
                    "VilCretas`Private`RRbegin", ",", 
                    "VilCretas`Private`Ri9"}], "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Ri8", "<", "VilCretas`Private`RRend"}],
                     ",", 
                    RowBox[{"VilCretas`Private`RDQuicksortSteps", "[", 
                    RowBox[{
                    "VilCretas`Private`Ri8", ",", "VilCretas`Private`RRend"}],
                     "]"}]}], "]"}]}]}], "]"}], ";", 
                    "VilCretas`Private`RList10"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "steps", "]"}], "]"}], "&&", 
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "code", "]"}], "]"}], "&&", 
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "ascendente", "]"}], "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "code", "]"}], "&&", 
                    RowBox[{"OptionValue", "[", "ascendente", "]"}]}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RAQuicksort", "[", 
                    RowBox[{
                    "VilCretas`Private`Rbegin", ",", 
                    "VilCretas`Private`Rend"}], "]"}], 
                    ",", "\<\"Quicksort[begin_,end_]:=Module[{},If[begin<end, \
i=begin; j=end;piv=L[[Floor[(begin+end)/2]]];While[i\[LessEqual]j, \
While[L[[i]]<piv, i++]; While[L[[j]]>piv,j--];If[i\[LessEqual]j, aux=L[[i]]; \
L[[i]]=L[[j]]; L[[j]]=aux; i++; \
j--]];Print[ReplacePart[L,Style[L[[Floor[(begin+end)/2]]],Blue],Floor[(begin+\
end)/2]]];If[begin<j,Quicksort[begin,j]]; If[i<end,Quicksort[i, \
end]]];L]\"\>"}], "}"}], "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "code", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "ascendente", "]"}], 
                    "\[Equal]", "False"}]}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RDQuicksort", "[", 
                    RowBox[{
                    "VilCretas`Private`Rbegin", ",", 
                    "VilCretas`Private`Rend"}], "]"}], 
                    ",", "\<\"Quicksort[begin_,end_]:=Module[{},If[begin<end, \
i=begin; j=end;piv=L[[Floor[(begin+end)/2]]];While[i\[LessEqual]j, \
While[L[[i]]>piv, i++]; While[L[[j]]<piv,j--];If[i\[LessEqual]j, aux=L[[i]]; \
L[[i]]=L[[j]]; L[[j]]=aux; i++; \
j--]];Print[ReplacePart[L,Style[L[[Floor[(begin+end)/2]]],Blue],Floor[(begin+\
end)/2]]];If[begin<j,Quicksort[begin,j]]; If[i<end,Quicksort[i, \
end]]];L]\"\>"}], "}"}], "]"}]}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "steps", "]"}], "]"}], "&&", 
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "code", "]"}], "]"}], "&&", 
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "ascendente", "]"}], "]"}]}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "steps", "]"}], "&&", 
                    RowBox[{"OptionValue", "[", "ascendente", "]"}]}], ",", 
                    RowBox[{"VilCretas`Private`RAQuicksortSteps", "[", 
                    RowBox[{
                    "VilCretas`Private`Rbegin", ",", 
                    "VilCretas`Private`Rend"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "steps", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "ascendente", "]"}], 
                    "\[Equal]", "False"}]}], ",", 
                    RowBox[{"VilCretas`Private`RDQuicksortSteps", "[", 
                    RowBox[{
                    "VilCretas`Private`Rbegin", ",", 
                    "VilCretas`Private`Rend"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "steps", "]"}], "\[Equal]", 
                    "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "code", "]"}], "\[Equal]", 
                    "False"}], "&&", 
                    RowBox[{"OptionValue", "[", "ascendente", "]"}]}], ",", 
                    RowBox[{"VilCretas`Private`RAQuicksort", "[", 
                    RowBox[{
                    "VilCretas`Private`Rbegin", ",", 
                    "VilCretas`Private`Rend"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "code", "]"}], "\[Equal]", 
                    "False"}], "&&", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "ascendente", "]"}], 
                    "\[Equal]", "False"}]}], ",", 
                    RowBox[{"VilCretas`Private`RDQuicksort", "[", 
                    RowBox[{
                    "VilCretas`Private`Rbegin", ",", 
                    "VilCretas`Private`Rend"}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"code", "\[Rule]", "False"}], ",", 
                    RowBox[{"steps", "\[Rule]", "False"}], ",", 
                    RowBox[{"ascendente", "\[Rule]", "True"}]}], "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`Quicksort\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Implementaci\[OAcute]n del algoritmo \
\[OpenCurlyDoubleQuote]quicksort\[CloseCurlyDoubleQuote] desarrollado por el \
cient\[IAcute]fico brit\[AAcute]nico C.A.R Hoare en 1960 (ganador del premio \
Turing en 1980), para ordenar de forma recursiva una lista \
\[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] datos. La instrucci\[OAcute]n permite visualizar el \
c\[OAcute]digo de programaci\[OAcute]n del comando y las ejecuciones paso a \
paso, mediante el uso de \[OpenCurlyDoubleQuote]code->True\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]steps->True\
\[CloseCurlyDoubleQuote], respectivamente. En adici\[OAcute]n, la opci\
\[OAcute]n \[OpenCurlyDoubleQuote]ascendente->True\[CloseCurlyDoubleQuote] \
ordena la lista de forma ascendente y \
\[OpenCurlyDoubleQuote]ascendente->False\[CloseCurlyDoubleQuote] de manera \
descendente. Sintaxis: Quicksort[L], o bien, Quicksort[L, code->Valor, \
steps->Valor, ascendente->Valor].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Implementaci\[OAcute]n del algoritmo \[OpenCurlyDoubleQuote]quicksort\
\[CloseCurlyDoubleQuote] desarrollado por el cient\[IAcute]fico \
brit\[AAcute]nico C.A.R Hoare en 1960 (ganador del premio Turing en 1980), \
para ordenar de forma recursiva una lista \[OpenCurlyDoubleQuote]L\
\[CloseCurlyDoubleQuote] con \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] \
datos. La instrucci\[OAcute]n permite visualizar el c\[OAcute]digo de \
programaci\[OAcute]n del comando y las ejecuciones paso a paso, mediante el \
uso de \[OpenCurlyDoubleQuote]code->True\[CloseCurlyDoubleQuote] y \
\[OpenCurlyDoubleQuote]steps->True\[CloseCurlyDoubleQuote], respectivamente. \
En adici\[OAcute]n, la opci\[OAcute]n \[OpenCurlyDoubleQuote]ascendente->True\
\[CloseCurlyDoubleQuote] ordena la lista de forma ascendente y \
\[OpenCurlyDoubleQuote]ascendente->False\[CloseCurlyDoubleQuote] de manera \
descendente. Sintaxis: Quicksort[L], o bien, Quicksort[L, code->Valor, \
steps->Valor, ascendente->Valor].", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`Quicksort, {VilCretas`Quicksort[
         Pattern[VilCretas`Private`L, 
          Blank[List]], 
         OptionsPattern[]] :> 
       Module[{VilCretas`Private`Rbegin = 1, VilCretas`Private`Rend = 
          Length[VilCretas`Private`L]}, 
         If[
          VectorQ[VilCretas`Private`L, NumericQ], 
          If[MemberQ[VilCretas`Private`L, Null] == False, 
           
           Module[{VilCretas`Private`RAQuicksort, 
             VilCretas`Private`RAQuicksortSteps, 
             VilCretas`Private`RDQuicksort, 
             VilCretas`Private`RDQuicksortSteps, VilCretas`Private`RList7 = 
             VilCretas`Private`L, VilCretas`Private`RList8 = 
             VilCretas`Private`L, VilCretas`Private`RList9 = 
             VilCretas`Private`L, VilCretas`Private`RList10 = 
             VilCretas`Private`L}, VilCretas`Private`RAQuicksort[
               Pattern[VilCretas`Private`RRbegin, 
                Blank[]], 
               Pattern[VilCretas`Private`RRend, 
                Blank[]]] := 
             Module[{}, 
               If[VilCretas`Private`RRbegin < VilCretas`Private`RRend, 
                 VilCretas`Private`Ri2 = VilCretas`Private`RRbegin; 
                 VilCretas`Private`Ri3 = VilCretas`Private`RRend; 
                 VilCretas`Private`RVl20 = Part[VilCretas`Private`RList7, 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]; 
                 While[VilCretas`Private`Ri2 <= VilCretas`Private`Ri3, 
                   While[Part[
                    VilCretas`Private`RList7, VilCretas`Private`Ri2] < 
                    VilCretas`Private`RVl20, 
                    Increment[VilCretas`Private`Ri2]]; 
                   While[Part[
                    VilCretas`Private`RList7, VilCretas`Private`Ri3] > 
                    VilCretas`Private`RVl20, 
                    Decrement[VilCretas`Private`Ri3]]; 
                   If[VilCretas`Private`Ri2 <= VilCretas`Private`Ri3, 
                    VilCretas`Private`RVl21 = 
                    Part[VilCretas`Private`RList7, VilCretas`Private`Ri2]; 
                    Part[VilCretas`Private`RList7, VilCretas`Private`Ri2] = 
                    Part[VilCretas`Private`RList7, VilCretas`Private`Ri3]; 
                    Part[VilCretas`Private`RList7, VilCretas`Private`Ri3] = 
                    VilCretas`Private`RVl21; Increment[VilCretas`Private`Ri2]; 
                    Decrement[VilCretas`Private`Ri3]]]; Print[
                   ReplacePart[VilCretas`Private`RList7, 
                    Style[
                    Part[VilCretas`Private`RList7, 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]], Blue], 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]]; 
                 If[VilCretas`Private`RRbegin < VilCretas`Private`Ri3, 
                   VilCretas`Private`RAQuicksort[
                   VilCretas`Private`RRbegin, VilCretas`Private`Ri3]]; 
                 If[VilCretas`Private`Ri2 < VilCretas`Private`RRend, 
                   VilCretas`Private`RAQuicksort[
                   VilCretas`Private`Ri2, VilCretas`Private`RRend]]]; 
               VilCretas`Private`RList7]; VilCretas`Private`RDQuicksort[
               Pattern[VilCretas`Private`RRbegin, 
                Blank[]], 
               Pattern[VilCretas`Private`RRend, 
                Blank[]]] := 
             Module[{}, 
               If[VilCretas`Private`RRbegin < VilCretas`Private`RRend, 
                 VilCretas`Private`Ri4 = VilCretas`Private`RRbegin; 
                 VilCretas`Private`Ri5 = VilCretas`Private`RRend; 
                 VilCretas`Private`RVl22 = Part[VilCretas`Private`RList8, 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]; 
                 While[VilCretas`Private`Ri4 <= VilCretas`Private`Ri5, 
                   While[Part[
                    VilCretas`Private`RList8, VilCretas`Private`Ri4] > 
                    VilCretas`Private`RVl22, 
                    Increment[VilCretas`Private`Ri4]]; 
                   While[Part[
                    VilCretas`Private`RList8, VilCretas`Private`Ri5] < 
                    VilCretas`Private`RVl22, 
                    Decrement[VilCretas`Private`Ri5]]; 
                   If[VilCretas`Private`Ri4 <= VilCretas`Private`Ri5, 
                    VilCretas`Private`RVl23 = 
                    Part[VilCretas`Private`RList8, VilCretas`Private`Ri4]; 
                    Part[VilCretas`Private`RList8, VilCretas`Private`Ri4] = 
                    Part[VilCretas`Private`RList8, VilCretas`Private`Ri5]; 
                    Part[VilCretas`Private`RList8, VilCretas`Private`Ri5] = 
                    VilCretas`Private`RVl23; Increment[VilCretas`Private`Ri4]; 
                    Decrement[VilCretas`Private`Ri5]]]; Print[
                   ReplacePart[VilCretas`Private`RList8, 
                    Style[
                    Part[VilCretas`Private`RList8, 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]], Blue], 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]]; 
                 If[VilCretas`Private`RRbegin < VilCretas`Private`Ri5, 
                   VilCretas`Private`RDQuicksort[
                   VilCretas`Private`RRbegin, VilCretas`Private`Ri5]]; 
                 If[VilCretas`Private`Ri4 < VilCretas`Private`RRend, 
                   VilCretas`Private`RDQuicksort[
                   VilCretas`Private`Ri4, VilCretas`Private`RRend]]]; 
               VilCretas`Private`RList8]; VilCretas`Private`RAQuicksortSteps[
               Pattern[VilCretas`Private`RRbegin, 
                Blank[]], 
               Pattern[VilCretas`Private`RRend, 
                Blank[]]] := 
             Module[{}, 
               If[VilCretas`Private`RRbegin < VilCretas`Private`RRend, 
                 VilCretas`Private`Ri6 = VilCretas`Private`RRbegin; 
                 VilCretas`Private`Ri7 = VilCretas`Private`RRend; 
                 VilCretas`Private`RVl24 = Part[VilCretas`Private`RList9, 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]; 
                 VilCretas`Private`RList9 = 
                  ReplacePart[VilCretas`Private`RList9, 
                    Style[
                    Part[VilCretas`Private`RList9, 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]], Blue], 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]; 
                 Print["Quicksort[", VilCretas`Private`RRbegin, ",", 
                   VilCretas`Private`RRend, "] = ", 
                   Take[
                   VilCretas`Private`RList9, {
                    VilCretas`Private`RRbegin, VilCretas`Private`RRend}]]; 
                 While[VilCretas`Private`Ri6 <= VilCretas`Private`Ri7, 
                   While[
                    Part[VilCretas`Private`RList9, VilCretas`Private`Ri6] < 
                    VilCretas`Private`RVl24, 
                    Increment[VilCretas`Private`Ri6]]; 
                   While[Part[
                    VilCretas`Private`RList9, VilCretas`Private`Ri7] > 
                    VilCretas`Private`RVl24, 
                    Decrement[VilCretas`Private`Ri7]]; 
                   If[VilCretas`Private`Ri6 <= VilCretas`Private`Ri7, 
                    VilCretas`Private`RList9 = 
                    ReplacePart[VilCretas`Private`RList9, 
                    Style[
                    Part[VilCretas`Private`RList9, VilCretas`Private`Ri6], 
                    Red], VilCretas`Private`Ri6]; 
                    VilCretas`Private`RList9 = 
                    ReplacePart[VilCretas`Private`RList9, 
                    Style[
                    Part[VilCretas`Private`RList9, VilCretas`Private`Ri7], 
                    Red], VilCretas`Private`Ri7]; Print[
                    Take[
                    VilCretas`Private`RList9, {
                    VilCretas`Private`RRbegin, VilCretas`Private`RRend}]]; 
                    VilCretas`Private`RList9 = 
                    ReplacePart[VilCretas`Private`RList9, 
                    ToExpression[
                    ToString[
                    Part[VilCretas`Private`RList9, VilCretas`Private`Ri6]]], 
                    VilCretas`Private`Ri6]; 
                    VilCretas`Private`RList9 = 
                    ReplacePart[VilCretas`Private`RList9, 
                    ToExpression[
                    ToString[
                    Part[VilCretas`Private`RList9, VilCretas`Private`Ri7]]], 
                    VilCretas`Private`Ri7]; 
                    VilCretas`Private`RVl25 = 
                    Part[VilCretas`Private`RList9, VilCretas`Private`Ri6]; 
                    Part[VilCretas`Private`RList9, VilCretas`Private`Ri6] = 
                    Part[VilCretas`Private`RList9, VilCretas`Private`Ri7]; 
                    Part[VilCretas`Private`RList9, VilCretas`Private`Ri7] = 
                    VilCretas`Private`RVl25; Print[
                    Take[
                    VilCretas`Private`RList9, {
                    VilCretas`Private`RRbegin, VilCretas`Private`RRend}]]; 
                    Increment[VilCretas`Private`Ri6]; 
                    Decrement[VilCretas`Private`Ri7]]]; 
                 VilCretas`Private`RList9 = 
                  ReplacePart[VilCretas`Private`RList9, 
                    ToExpression[
                    ToString[
                    Part[VilCretas`Private`RList9, 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]]], 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]; 
                 Print["L = ", VilCretas`Private`RList9]; 
                 If[VilCretas`Private`RRbegin < VilCretas`Private`Ri7, 
                   VilCretas`Private`RAQuicksortSteps[
                   VilCretas`Private`RRbegin, VilCretas`Private`Ri7]]; 
                 If[VilCretas`Private`Ri6 < VilCretas`Private`RRend, 
                   VilCretas`Private`RAQuicksortSteps[
                   VilCretas`Private`Ri6, VilCretas`Private`RRend]]]; 
               VilCretas`Private`RList9]; VilCretas`Private`RDQuicksortSteps[
               Pattern[VilCretas`Private`RRbegin, 
                Blank[]], 
               Pattern[VilCretas`Private`RRend, 
                Blank[]]] := 
             Module[{}, 
               If[VilCretas`Private`RRbegin < VilCretas`Private`RRend, 
                 VilCretas`Private`Ri8 = VilCretas`Private`RRbegin; 
                 VilCretas`Private`Ri9 = VilCretas`Private`RRend; 
                 VilCretas`Private`RVl26 = Part[VilCretas`Private`RList10, 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]; 
                 VilCretas`Private`RList10 = 
                  ReplacePart[VilCretas`Private`RList10, 
                    Style[
                    Part[VilCretas`Private`RList10, 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]], Blue], 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]; 
                 Print["Quicksort[", VilCretas`Private`RRbegin, ",", 
                   VilCretas`Private`RRend, "] = ", 
                   Take[
                   VilCretas`Private`RList10, {
                    VilCretas`Private`RRbegin, VilCretas`Private`RRend}]]; 
                 While[VilCretas`Private`Ri8 <= VilCretas`Private`Ri9, 
                   While[Part[
                    VilCretas`Private`RList10, VilCretas`Private`Ri8] > 
                    VilCretas`Private`RVl26, 
                    Increment[VilCretas`Private`Ri8]]; 
                   While[Part[
                    VilCretas`Private`RList10, VilCretas`Private`Ri9] < 
                    VilCretas`Private`RVl26, 
                    Decrement[VilCretas`Private`Ri9]]; 
                   If[VilCretas`Private`Ri8 <= VilCretas`Private`Ri9, 
                    VilCretas`Private`RList10 = 
                    ReplacePart[VilCretas`Private`RList10, 
                    Style[
                    Part[VilCretas`Private`RList10, VilCretas`Private`Ri8], 
                    Red], VilCretas`Private`Ri8]; 
                    VilCretas`Private`RList10 = 
                    ReplacePart[VilCretas`Private`RList10, 
                    Style[
                    Part[VilCretas`Private`RList10, VilCretas`Private`Ri9], 
                    Red], VilCretas`Private`Ri9]; Print[
                    Take[
                    VilCretas`Private`RList10, {
                    VilCretas`Private`RRbegin, VilCretas`Private`RRend}]]; 
                    VilCretas`Private`RList10 = 
                    ReplacePart[VilCretas`Private`RList10, 
                    ToExpression[
                    ToString[
                    Part[VilCretas`Private`RList10, VilCretas`Private`Ri8]]], 
                    VilCretas`Private`Ri8]; 
                    VilCretas`Private`RList10 = 
                    ReplacePart[VilCretas`Private`RList10, 
                    ToExpression[
                    ToString[
                    Part[VilCretas`Private`RList10, VilCretas`Private`Ri9]]], 
                    VilCretas`Private`Ri9]; 
                    VilCretas`Private`RVl27 = 
                    Part[VilCretas`Private`RList10, VilCretas`Private`Ri8]; 
                    Part[VilCretas`Private`RList10, VilCretas`Private`Ri8] = 
                    Part[VilCretas`Private`RList10, VilCretas`Private`Ri9]; 
                    Part[VilCretas`Private`RList10, VilCretas`Private`Ri9] = 
                    VilCretas`Private`RVl27; Print[
                    Take[
                    VilCretas`Private`RList10, {
                    VilCretas`Private`RRbegin, VilCretas`Private`RRend}]]; 
                    Increment[VilCretas`Private`Ri8]; 
                    Decrement[VilCretas`Private`Ri9]]]; 
                 VilCretas`Private`RList10 = 
                  ReplacePart[VilCretas`Private`RList10, 
                    ToExpression[
                    ToString[
                    Part[VilCretas`Private`RList10, 
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]]], 
                    
                    Floor[(VilCretas`Private`RRbegin + 
                    VilCretas`Private`RRend)/2]]; 
                 Print["L = ", VilCretas`Private`RList10]; 
                 If[VilCretas`Private`RRbegin < VilCretas`Private`Ri9, 
                   VilCretas`Private`RDQuicksortSteps[
                   VilCretas`Private`RRbegin, VilCretas`Private`Ri9]]; 
                 If[VilCretas`Private`Ri8 < VilCretas`Private`RRend, 
                   VilCretas`Private`RDQuicksortSteps[
                   VilCretas`Private`Ri8, VilCretas`Private`RRend]]]; 
               VilCretas`Private`RList10]; If[
              And[
               BooleanQ[
                OptionValue[VilCretas`steps]], 
               BooleanQ[
                OptionValue[VilCretas`code]], 
               BooleanQ[
                OptionValue[VilCretas`ascendente]]], If[
                And[
                 OptionValue[VilCretas`code], 
                 OptionValue[VilCretas`ascendente]], 
                Print[{
                  VilCretas`Private`RAQuicksort[
                  VilCretas`Private`Rbegin, VilCretas`Private`Rend], 
                  "Quicksort[begin_,end_]:=Module[{},If[begin<end, i=begin; \
j=end;piv=L[[Floor[(begin+end)/2]]];While[i\[LessEqual]j, While[L[[i]]<piv, \
i++]; While[L[[j]]>piv,j--];If[i\[LessEqual]j, aux=L[[i]]; L[[i]]=L[[j]]; \
L[[j]]=aux; i++; \
j--]];Print[ReplacePart[L,Style[L[[Floor[(begin+end)/2]]],Blue],Floor[(begin+\
end)/2]]];If[begin<j,Quicksort[begin,j]]; If[i<end,Quicksort[i, end]]];L]"}]]; 
              If[
                And[
                 OptionValue[VilCretas`code], 
                 OptionValue[VilCretas`ascendente] == False], 
                Print[{
                  VilCretas`Private`RDQuicksort[
                  VilCretas`Private`Rbegin, VilCretas`Private`Rend], 
                  "Quicksort[begin_,end_]:=Module[{},If[begin<end, i=begin; \
j=end;piv=L[[Floor[(begin+end)/2]]];While[i\[LessEqual]j, While[L[[i]]>piv, \
i++]; While[L[[j]]<piv,j--];If[i\[LessEqual]j, aux=L[[i]]; L[[i]]=L[[j]]; \
L[[j]]=aux; i++; \
j--]];Print[ReplacePart[L,Style[L[[Floor[(begin+end)/2]]],Blue],Floor[(begin+\
end)/2]]];If[begin<j,Quicksort[begin,j]]; If[i<end,Quicksort[i, \
end]]];L]"}]]]; If[
              And[
               BooleanQ[
                OptionValue[VilCretas`steps]], 
               BooleanQ[
                OptionValue[VilCretas`code]], 
               BooleanQ[
                OptionValue[VilCretas`ascendente]]], 
              If[
               And[
                OptionValue[VilCretas`steps], 
                OptionValue[VilCretas`ascendente]], 
               VilCretas`Private`RAQuicksortSteps[
               VilCretas`Private`Rbegin, VilCretas`Private`Rend], 
               If[
                And[
                 OptionValue[VilCretas`steps], 
                 OptionValue[VilCretas`ascendente] == False], 
                VilCretas`Private`RDQuicksortSteps[
                VilCretas`Private`Rbegin, VilCretas`Private`Rend], 
                If[OptionValue[VilCretas`steps] == False, 
                 If[
                  And[OptionValue[VilCretas`code] == False, 
                   OptionValue[VilCretas`ascendente]], 
                  VilCretas`Private`RAQuicksort[
                  VilCretas`Private`Rbegin, VilCretas`Private`Rend], 
                  If[
                   And[
                   OptionValue[VilCretas`code] == False, 
                    OptionValue[VilCretas`ascendente] == False], 
                   VilCretas`Private`RDQuicksort[
                   VilCretas`Private`Rbegin, 
                    VilCretas`Private`Rend]]]]]]]]]]]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {
     VilCretas`code -> False, VilCretas`steps -> False, VilCretas`ascendente -> 
      True}, "Attributes" -> {Protected}, "FullName" -> 
    "VilCretas`Quicksort"], False]]], "Output",
 CellChangeTimes->{3.8054757421877337`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"7995d632-632a-4b05-bcf6-9fcfcd5c61f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quicksort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "9"}], ",", "5", ",", 
     RowBox[{"-", "7"}], ",", "0", ",", "10", ",", "21.3", ",", 
     RowBox[{"-", "28.7"}], ",", "100", ",", 
     RowBox[{"-", "100"}], ",", "14"}], "}"}], ",", 
   RowBox[{"code", "\[Rule]", "True"}], ",", 
   RowBox[{"steps", "\[Rule]", "True"}], ",", 
   RowBox[{"ascendente", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.805475097451459*^9, 3.8054751152565765`*^9}, {
  3.8054757524907513`*^9, 3.805475779694893*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"d4a4d232-e4a1-4198-b1f1-257f3ed36ee5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "100", ",", "21.3`", ",", "10", ",", 
   StyleBox["0",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941414418*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"6f1155d3-b283-42b9-9049-c15b9669ac9d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", 
   StyleBox["14",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "21.3`", ",", "10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941414418*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"ee9f699a-9179-4e3c-81ab-df09fa570a7b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", 
   StyleBox["14",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941418412*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"0c6cf766-90d4-4ba6-a802-a58189c20e11"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", 
   StyleBox["14",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941418412*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"4a634793-d763-4222-8c37-89ceb88750be"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   StyleBox[
    RowBox[{"-", "9"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941422406*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"add87305-783e-47f9-a064-45d56d7cc905"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "0", ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941422406*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"fdea6155-4845-4e3b-9351-7b1a6fdc876c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "0", ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414264135`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"a46dd9d2-93ee-4d28-8a9b-e219e692ed31"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "5", ",", "0", ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414264135`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"11a6eb22-368d-4dcd-b446-f6532e59d5df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "0", ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941430396*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"9e741e20-0dc2-4d7b-8607-52e3e8ab6caf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941430396*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"fedea99f-2217-4ce8-9869-3a60280e62c2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", 
   StyleBox["0",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941434391*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"22099cb6-f161-4492-83a6-482c32a80a97"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941434391*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"107f56ab-d8fc-4d81-a520-ed7fc4614896"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}], ",", 
   StyleBox[
    RowBox[{"-", "28.7`"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941434391*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"ae232404-01ed-438d-92b8-f218ee73980a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   StyleBox[
    RowBox[{"-", "9"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "28.7`"}], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941438386*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"173a5a2c-0ed3-4ec7-be8e-48ea3b4dd19a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}], ",", 
   StyleBox[
    RowBox[{"-", "28.7`"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941438386*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"f6393b0a-11b0-47c5-98f1-89f8d6648a64"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "28.7`"}], ",", 
     RowBox[{"-", "100"}]}], "}"}], 
   ",", "\<\"Quicksort[begin_,end_]:=Module[{},If[begin<end, i=begin; \
j=end;piv=L[[Floor[(begin+end)/2]]];While[i\[LessEqual]j, While[L[[i]]>piv, \
i++]; While[L[[j]]<piv,j--];If[i\[LessEqual]j, aux=L[[i]]; L[[i]]=L[[j]]; \
L[[j]]=aux; i++; \
j--]];Print[ReplacePart[L,Style[L[[Floor[(begin+end)/2]]],Blue],Floor[(begin+\
end)/2]]];If[begin<j,Quicksort[begin,j]]; If[i<end,Quicksort[i, \
end]]];L]\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941438386*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"7b90846f-207a-4bd2-b501-a3a682beda9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "9"}], ",", "5", ",", 
     RowBox[{"-", "7"}], ",", "0", ",", 
     StyleBox["10",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "21.3`", ",", 
     RowBox[{"-", "28.7`"}], ",", "100", ",", 
     RowBox[{"-", "100"}], ",", "14"}], "}"}]}],
  SequenceForm["Quicksort[", 1, ",", 10, "] = ", {-9, 5, -7, 0, 
    Style[10, 
     RGBColor[0, 0, 1]], 21.3, -28.7, 100, -100, 14}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.80547594144238*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"62617b46-fe0a-4794-865b-d2c5033ef464"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    RowBox[{"-", "9"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "5", ",", 
   RowBox[{"-", "7"}], ",", "0", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "21.3`", ",", 
   RowBox[{"-", "28.7`"}], ",", "100", ",", 
   RowBox[{"-", "100"}], ",", 
   StyleBox["14",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.80547594144238*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"fc6701e8-6e87-46c9-9b39-ea2e252af458"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "5", ",", 
   RowBox[{"-", "7"}], ",", "0", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "21.3`", ",", 
   RowBox[{"-", "28.7`"}], ",", "100", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.80547594144238*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"df34fe34-cbcd-440f-bde8-9de2462d9f31"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "7"}], ",", "0", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "21.3`", ",", 
   RowBox[{"-", "28.7`"}], ",", 
   StyleBox["100",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941446375*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"ea7693d8-576e-42e6-b855-8257b7d7c754"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "100", ",", 
   RowBox[{"-", "7"}], ",", "0", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "21.3`", ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941446375*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"068af8c4-5af3-49be-9100-62be91090a62"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "100", ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "0", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   StyleBox["21.3`",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.80547594145037*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"fe95c16f-bf0d-4cbb-bd84-dfc7631b22b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "100", ",", "21.3`", ",", "0", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.80547594145037*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"c8bfe764-bc2f-4b75-bc09-ecf15ca6a66f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "100", ",", "21.3`", ",", 
   StyleBox["0",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox[
    StyleBox["10",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.80547594145037*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"7a5984c1-2c63-4fb9-92c9-d896da51b822"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "100", ",", "21.3`", ",", "10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "28.7`"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941454364*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"5db8ec21-0dff-43ea-a2d0-efd4f081880e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"14", ",", "100", ",", "21.3`", ",", "10", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "28.7`"}], ",", "5", ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "9"}]}], "}"}]}],
  SequenceForm["L = ", {14, 100, 21.3, 10, 0, -7, -28.7, 5, -100, -9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941454364*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"80b8cb99-f793-47bc-9d9b-b1ade6fdc72c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"14", ",", 
     StyleBox["100",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "21.3`", ",", "10"}], "}"}]}],
  SequenceForm["Quicksort[", 1, ",", 4, "] = ", {14, 
    Style[100, 
     RGBColor[0, 0, 1]], 21.3, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414583626`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"b53ab507-9d21-453f-b268-01f682def32c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["14",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox[
    StyleBox["100",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "21.3`", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414583626`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"c594f22a-42c4-46fe-9048-2baf9d230d91"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "14", ",", "21.3`", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414623547`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"1b246fa4-f6b2-4ab4-b2df-afcaf801656d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"100", ",", "14", ",", "21.3`", ",", "10", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "28.7`"}], ",", "5", ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "9"}]}], "}"}]}],
  SequenceForm["L = ", {100, 14, 21.3, 10, 0, -7, -28.7, 5, -100, -9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414623547`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"a1f9fbe8-dd0f-4125-9bf3-e2a5f4207108"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"14", ",", 
     StyleBox["21.3`",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]}],
  SequenceForm["Quicksort[", 2, ",", 4, "] = ", {14, 
    Style[21.3, 
     RGBColor[0, 0, 1]], 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414623547`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"ad24329a-0db8-4aaf-8842-978bbabeb6de"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["14",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox[
    StyleBox["21.3`",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.80547594146636*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"1edf2aad-d971-45cc-b902-a3dc568721af"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21.3`", ",", "14", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.80547594146636*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"50955fd1-aa39-4885-ad65-86abadea196c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "28.7`"}], ",", "5", ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "9"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 0, -7, -28.7, 5, -100, -9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941470342*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"570662d9-bcf8-4be0-94fb-5d127e839939"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["14",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]}],
  SequenceForm["Quicksort[", 3, ",", 4, "] = ", {
    Style[14, 
     RGBColor[0, 0, 1]], 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941470342*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"b5f7eff5-0591-404d-a4ba-6da572c5dd27"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox[
     StyleBox["14",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941470342*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"16bf639c-8076-4a2c-aa59-d7a5dc0a0289"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414743385`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"08a3a58c-1f74-425b-982e-635f30020b58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "28.7`"}], ",", "5", ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "9"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 0, -7, -28.7, 5, -100, -9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414743385`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"4f64b8b0-5bb8-4940-8903-4fdd528c4607"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     StyleBox[
      RowBox[{"-", "28.7`"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "5", ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "9"}]}], "}"}]}],
  SequenceForm["Quicksort[", 4, ",", 10, "] = ", {10, 0, -7, 
    Style[-28.7, 
     RGBColor[0, 0, 1]], 5, -100, -9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941478348*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"340bc905-5b11-4432-b680-5afe4aa20d5b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   StyleBox[
    StyleBox[
     RowBox[{"-", "28.7`"}],
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   StyleBox[
    RowBox[{"-", "9"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414823275`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"7fb060e8-592f-46ab-a7d1-b5af2266b667"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}], ",", "5", ",", 
   RowBox[{"-", "100"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414823275`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"7d22520c-2178-4f0d-ad37-cd054b9a0b19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}], ",", "5", ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "28.7`"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 0, -7, -9, 5, -100, -28.7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414823275`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"81c54f16-2a54-47e9-9993-fccfef73aba7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0", ",", 
     StyleBox[
      RowBox[{"-", "7"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", 
     RowBox[{"-", "9"}], ",", "5"}], "}"}]}],
  SequenceForm["Quicksort[", 4, ",", 8, "] = ", {10, 0, 
    Style[-7, 
     RGBColor[0, 0, 1]], -9, 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941486322*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"42347170-f81d-4a32-b651-b7dc1732f8bc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "0", ",", 
   StyleBox[
    StyleBox[
     RowBox[{"-", "7"}],
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "9"}], ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941486322*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"53240511-fd07-4d59-bff9-1efdab788289"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "0", ",", "5", ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "7"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941486322*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"b4fed74c-e2c9-4051-9036-a564bb0ffa51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "0", ",", "5", ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "28.7`"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 0, 5, -9, -7, -100, -28.7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414903164`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"28b6021d-977b-4150-8ee6-95322cca451d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     StyleBox["0",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "5"}], "}"}]}],
  SequenceForm["Quicksort[", 4, ",", 6, "] = ", {10, 
    Style[0, 
     RGBColor[0, 0, 1]], 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414903164`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"0b725cc1-869a-4023-84b3-992c55c7c5b5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", 
   StyleBox[
    StyleBox["0",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759414903164`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"26158d5b-bb07-472a-b41a-4711e9bc32c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941494313*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"d66e229f-c8e5-44ae-a88a-f9a4d526d384"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "28.7`"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 5, 0, -9, -7, -100, -28.7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941494313*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"9c0fc402-15a6-4ddb-a6ab-d0921b95abe2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["10",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "5"}], "}"}]}],
  SequenceForm["Quicksort[", 4, ",", 5, "] = ", {
    Style[10, 
     RGBColor[0, 0, 1]], 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941498305*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"98d74f77-26bf-4f87-997f-6e76b36615d3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox[
     StyleBox["10",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "5"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941498305*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"9eb5bfb5-5ce8-47d9-91c5-bc46f2cb8023"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941498305*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"1d4b6925-c260-49ed-a750-3dd1803fce96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "28.7`"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 5, 0, -9, -7, -100, -28.7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941498305*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"057b34d6-840c-465e-81ba-6ec15ce8fd4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["5",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "0"}], "}"}]}],
  SequenceForm["Quicksort[", 5, ",", 6, "] = ", {
    Style[5, 
     RGBColor[0, 0, 1]], 0}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415022993`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"d1240679-8031-4d1f-9598-8e45d041c973"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox[
     StyleBox["5",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415022993`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"db929d11-a98e-4153-8aac-586d480ac6d7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415022993`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"d0d73241-f003-4913-b771-894fbc0ebd4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "28.7`"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 5, 0, -9, -7, -100, -28.7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941506295*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"bc04c2c6-2cba-4eb1-91dd-0a4533d155ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     StyleBox[
      RowBox[{"-", "9"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", 
     RowBox[{"-", "7"}]}], "}"}]}],
  SequenceForm["Quicksort[", 6, ",", 8, "] = ", {0, 
    Style[-9, 
     RGBColor[0, 0, 1]], -7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941506295*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"faec6ede-6235-4042-a9d6-e9db81bbc90b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   StyleBox[
    StyleBox[
     RowBox[{"-", "9"}],
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415102983`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"afc32028-9662-497b-84a8-99af41f479c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415102983`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"5ecd80f0-4f93-4d05-910a-ba1eb4fc5f02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "28.7`"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 5, 0, -7, -9, -100, -28.7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941514284*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"c1d91a4f-0a07-4d8b-8d04-ce9eda16f86d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["0",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", 
     RowBox[{"-", "7"}]}], "}"}]}],
  SequenceForm["Quicksort[", 6, ",", 7, "] = ", {
    Style[0, 
     RGBColor[0, 0, 1]], -7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941514284*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"f0eb65a4-d2df-40fa-8615-00e093958ea3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox[
     StyleBox["0",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "7"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941514284*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"dbdf9512-e517-40d1-a387-bb6f9c23b9bc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "7"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941518278*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"f19dba31-1da0-48e3-b354-6ea5c29fd5f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "28.7`"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 5, 0, -7, -9, -100, -28.7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941518278*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"4d5d8b47-1ccd-45c4-94ab-5820f4f2d483"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox[
      RowBox[{"-", "7"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", 
     RowBox[{"-", "9"}]}], "}"}]}],
  SequenceForm["Quicksort[", 7, ",", 8, "] = ", {
    Style[-7, 
     RGBColor[0, 0, 1]], -9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415222735`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"4500af6a-1bbd-49ea-aab2-5d956a002b6f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox[
     StyleBox[
      RowBox[{"-", "7"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415222735`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"4e34cff0-d125-422a-b68c-4c8f6503a654"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415222735`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"0436379a-6172-4e57-a1d1-449f1308da2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "28.7`"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 5, 0, -7, -9, -100, -28.7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941526268*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"d2dbc101-be2f-4701-9bd7-2908c5848913"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "9"}], ",", 
     StyleBox[
      RowBox[{"-", "100"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", 
     RowBox[{"-", "28.7`"}]}], "}"}]}],
  SequenceForm["Quicksort[", 8, ",", 10, "] = ", {-9, 
    Style[-100, 
     RGBColor[0, 0, 1]], -28.7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941526268*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"0c01bcbc-25c3-452f-be59-ff8b06aec234"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "9"}], ",", 
   StyleBox[
    StyleBox[
     RowBox[{"-", "100"}],
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox[
    RowBox[{"-", "28.7`"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941526268*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"cd986c89-8bcf-40b6-b7ce-95f33929becf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "28.7`"}], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941530262*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"c50d7a19-db2e-4156-b2f9-45763037bc2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "28.7`"}], ",", 
     RowBox[{"-", "100"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 5, 0, -7, -9, -28.7, -100}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941530262*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"a0c29efd-7e1c-4b23-9ddd-eb355b7e69b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox[
      RowBox[{"-", "9"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", 
     RowBox[{"-", "28.7`"}]}], "}"}]}],
  SequenceForm["Quicksort[", 8, ",", 9, "] = ", {
    Style[-9, 
     RGBColor[0, 0, 1]], -28.7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941530262*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"8f13ecb9-4019-4a73-8532-d1dbbba0d5d8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox[
     StyleBox[
      RowBox[{"-", "9"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941534258*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"ab9b102a-be2a-403a-a964-20e426439966"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "28.7`"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941534258*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"c79a061e-0ec5-43ea-bde4-25b18e9d8187"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "28.7`"}], ",", 
     RowBox[{"-", "100"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 5, 0, -7, -9, -28.7, -100}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941534258*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"12dd377f-b935-49d7-aabb-e4ff69ef8f8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox[
      RowBox[{"-", "28.7`"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", 
     RowBox[{"-", "100"}]}], "}"}]}],
  SequenceForm["Quicksort[", 9, ",", 10, "] = ", {
    Style[-28.7, 
     RGBColor[0, 0, 1]], -100}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.805475941534258*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"791161c7-3a1f-4f9e-81c9-5cb98f6922b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox[
     StyleBox[
      RowBox[{"-", "28.7`"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415382586`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"8eeee2d6-2fee-4388-a475-507ae651f34f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "28.7`"}], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415382586`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"acbe78a4-45e2-4cf8-92ba-bb720a38e881"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "28.7`"}], ",", 
     RowBox[{"-", "100"}]}], "}"}]}],
  SequenceForm["L = ", {100, 21.3, 14, 10, 5, 0, -7, -9, -28.7, -100}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8054751163714623`*^9, 3.8054757339004984`*^9, 
  3.805475780445885*^9, 3.8054759415422487`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[10]:=",ExpressionUUID->"f1bb8ae3-9b5c-4ddd-ab5e-8a46d7017b9b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "21.3`", ",", "14", ",", "10", ",", "5", ",", "0", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "28.7`"}], ",", 
   RowBox[{"-", "100"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8054751163940506`*^9, 3.805475733924467*^9, 
  3.8054757805896935`*^9, 3.8054759415422487`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"90d0c93c-3caf-48d9-a9e2-73ada62b7740"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c1d9d1d9-8494-401e-86f3-de86de951fd4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 198, 3, 63, "Input",ExpressionUUID->"7b0e6480-0d7d-459d-b235-4c5869c1b309"],
Cell[CellGroupData[{
Cell[781, 27, 196, 3, 63, "Input",ExpressionUUID->"d7de0fa9-d401-4666-b010-60824e5f634e"],
Cell[980, 32, 70106, 1428, 918, "Output",ExpressionUUID->"7995d632-632a-4b05-bcf6-9fcfcd5c61f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71123, 1465, 644, 14, 249, "Input",ExpressionUUID->"d4a4d232-e4a1-4198-b1f1-257f3ed36ee5"],
Cell[CellGroupData[{
Cell[71792, 1483, 696, 18, 50, "Print",ExpressionUUID->"6f1155d3-b283-42b9-9049-c15b9669ac9d"],
Cell[72491, 1503, 696, 18, 50, "Print",ExpressionUUID->"ee9f699a-9179-4e3c-81ab-df09fa570a7b"],
Cell[73190, 1523, 696, 18, 50, "Print",ExpressionUUID->"0c6cf766-90d4-4ba6-a802-a58189c20e11"],
Cell[73889, 1543, 696, 18, 50, "Print",ExpressionUUID->"4a634793-d763-4222-8c37-89ceb88750be"],
Cell[74588, 1563, 697, 18, 50, "Print",ExpressionUUID->"add87305-783e-47f9-a064-45d56d7cc905"],
Cell[75288, 1583, 696, 18, 50, "Print",ExpressionUUID->"fdea6155-4845-4e3b-9351-7b1a6fdc876c"],
Cell[75987, 1603, 698, 18, 50, "Print",ExpressionUUID->"a46dd9d2-93ee-4d28-8a9b-e219e692ed31"],
Cell[76688, 1623, 698, 18, 50, "Print",ExpressionUUID->"11a6eb22-368d-4dcd-b446-f6532e59d5df"],
Cell[77389, 1643, 696, 18, 50, "Print",ExpressionUUID->"9e741e20-0dc2-4d7b-8607-52e3e8ab6caf"],
Cell[78088, 1663, 697, 18, 50, "Print",ExpressionUUID->"fedea99f-2217-4ce8-9869-3a60280e62c2"],
Cell[78788, 1683, 696, 18, 50, "Print",ExpressionUUID->"22099cb6-f161-4492-83a6-482c32a80a97"],
Cell[79487, 1703, 697, 18, 50, "Print",ExpressionUUID->"107f56ab-d8fc-4d81-a520-ed7fc4614896"],
Cell[80187, 1723, 697, 18, 50, "Print",ExpressionUUID->"ae232404-01ed-438d-92b8-f218ee73980a"],
Cell[80887, 1743, 697, 18, 50, "Print",ExpressionUUID->"173a5a2c-0ed3-4ec7-be8e-48ea3b4dd19a"],
Cell[81587, 1763, 697, 18, 50, "Print",ExpressionUUID->"f6393b0a-11b0-47c5-98f1-89f8d6648a64"],
Cell[82287, 1783, 933, 21, 451, "Print",ExpressionUUID->"7b90846f-207a-4bd2-b501-a3a682beda9b"],
Cell[83223, 1806, 1084, 26, 91, "Print",ExpressionUUID->"62617b46-fe0a-4794-865b-d2c5033ef464"],
Cell[84310, 1834, 1140, 32, 50, "Print",ExpressionUUID->"fc6701e8-6e87-46c9-9b39-ea2e252af458"],
Cell[85453, 1868, 695, 18, 50, "Print",ExpressionUUID->"df34fe34-cbcd-440f-bde8-9de2462d9f31"],
Cell[86151, 1888, 1140, 32, 50, "Print",ExpressionUUID->"ea7693d8-576e-42e6-b855-8257b7d7c754"],
Cell[87294, 1922, 696, 18, 50, "Print",ExpressionUUID->"068af8c4-5af3-49be-9100-62be91090a62"],
Cell[87993, 1942, 1140, 32, 50, "Print",ExpressionUUID->"fe95c16f-bf0d-4cbb-bd84-dfc7631b22b2"],
Cell[89136, 1976, 695, 18, 50, "Print",ExpressionUUID->"c8bfe764-bc2f-4b75-bc09-ecf15ca6a66f"],
Cell[89834, 1996, 1146, 32, 50, "Print",ExpressionUUID->"7a5984c1-2c63-4fb9-92c9-d896da51b822"],
Cell[90983, 2030, 474, 11, 50, "Print",ExpressionUUID->"5db8ec21-0dff-43ea-a2d0-efd4f081880e"],
Cell[91460, 2043, 648, 15, 50, "Print",ExpressionUUID->"80b8cb99-f793-47bc-9d9b-b1ade6fdc72c"],
Cell[92111, 2060, 908, 22, 50, "Print",ExpressionUUID->"b53ab507-9d21-453f-b268-01f682def32c"],
Cell[93022, 2084, 1007, 28, 50, "Print",ExpressionUUID->"c594f22a-42c4-46fe-9048-2baf9d230d91"],
Cell[94032, 2114, 334, 7, 50, "Print",ExpressionUUID->"1b246fa4-f6b2-4ab4-b2df-afcaf801656d"],
Cell[94369, 2123, 650, 15, 50, "Print",ExpressionUUID->"a1f9fbe8-dd0f-4125-9bf3-e2a5f4207108"],
Cell[95022, 2140, 891, 22, 50, "Print",ExpressionUUID->"ad24329a-0db8-4aaf-8842-978bbabeb6de"],
Cell[95916, 2164, 992, 28, 50, "Print",ExpressionUUID->"1edf2aad-d971-45cc-b902-a3dc568721af"],
Cell[96911, 2194, 319, 7, 50, "Print",ExpressionUUID->"50955fd1-aa39-4885-ad65-86abadea196c"],
Cell[97233, 2203, 648, 15, 50, "Print",ExpressionUUID->"570662d9-bcf8-4be0-94fb-5d127e839939"],
Cell[97884, 2220, 869, 22, 50, "Print",ExpressionUUID->"b5f7eff5-0591-404d-a4ba-6da572c5dd27"],
Cell[98756, 2244, 993, 28, 50, "Print",ExpressionUUID->"16bf639c-8076-4a2c-aa59-d7a5dc0a0289"],
Cell[99752, 2274, 308, 7, 50, "Print",ExpressionUUID->"08a3a58c-1f74-425b-982e-635f30020b58"],
Cell[100063, 2283, 650, 15, 50, "Print",ExpressionUUID->"4f64b8b0-5bb8-4940-8903-4fdd528c4607"],
Cell[100716, 2300, 1034, 26, 50, "Print",ExpressionUUID->"340bc905-5b11-4432-b680-5afe4aa20d5b"],
Cell[101753, 2328, 1115, 32, 50, "Print",ExpressionUUID->"7fb060e8-592f-46ab-a7d1-b5af2266b667"],
Cell[102871, 2362, 439, 11, 50, "Print",ExpressionUUID->"7d22520c-2178-4f0d-ad37-cd054b9a0b19"],
Cell[103313, 2375, 650, 15, 50, "Print",ExpressionUUID->"81c54f16-2a54-47e9-9993-fccfef73aba7"],
Cell[103966, 2392, 951, 24, 50, "Print",ExpressionUUID->"42347170-f81d-4a32-b651-b7dc1732f8bc"],
Cell[104920, 2418, 1048, 30, 50, "Print",ExpressionUUID->"53240511-fd07-4d59-bff9-1efdab788289"],
Cell[105971, 2450, 373, 9, 50, "Print",ExpressionUUID->"b4fed74c-e2c9-4051-9036-a564bb0ffa51"],
Cell[106347, 2461, 655, 16, 50, "Print",ExpressionUUID->"28b6021d-977b-4150-8ee6-95322cca451d"],
Cell[107005, 2479, 882, 22, 50, "Print",ExpressionUUID->"0b725cc1-869a-4023-84b3-992c55c7c5b5"],
Cell[107890, 2503, 990, 28, 50, "Print",ExpressionUUID->"26158d5b-bb07-472a-b41a-4711e9bc32c0"],
Cell[108883, 2533, 315, 7, 50, "Print",ExpressionUUID->"d66e229f-c8e5-44ae-a88a-f9a4d526d384"],
Cell[109201, 2542, 653, 16, 50, "Print",ExpressionUUID->"9c0fc402-15a6-4ddb-a6ab-d0921b95abe2"],
Cell[109857, 2560, 867, 22, 50, "Print",ExpressionUUID->"98d74f77-26bf-4f87-997f-6e76b36615d3"],
Cell[110727, 2584, 992, 28, 50, "Print",ExpressionUUID->"9eb5bfb5-5ce8-47d9-91c5-bc46f2cb8023"],
Cell[111722, 2614, 305, 7, 50, "Print",ExpressionUUID->"1d4b6925-c260-49ed-a750-3dd1803fce96"],
Cell[112030, 2623, 653, 16, 50, "Print",ExpressionUUID->"057b34d6-840c-465e-81ba-6ec15ce8fd4f"],
Cell[112686, 2641, 867, 22, 50, "Print",ExpressionUUID->"d1240679-8031-4d1f-9598-8e45d041c973"],
Cell[113556, 2665, 993, 28, 50, "Print",ExpressionUUID->"db929d11-a98e-4153-8aac-586d480ac6d7"],
Cell[114552, 2695, 306, 7, 50, "Print",ExpressionUUID->"d0d73241-f003-4913-b771-894fbc0ebd4d"],
Cell[114861, 2704, 653, 16, 50, "Print",ExpressionUUID->"bc04c2c6-2cba-4eb1-91dd-0a4533d155ba"],
Cell[115517, 2722, 923, 24, 50, "Print",ExpressionUUID->"faec6ede-6235-4042-a9d6-e9db81bbc90b"],
Cell[116443, 2748, 1030, 30, 50, "Print",ExpressionUUID->"afc32028-9662-497b-84a8-99af41f479c0"],
Cell[117476, 2780, 354, 9, 50, "Print",ExpressionUUID->"5ecd80f0-4f93-4d05-910a-ba1eb4fc5f02"],
Cell[117833, 2791, 653, 16, 50, "Print",ExpressionUUID->"c1d91a4f-0a07-4d8b-8d04-ce9eda16f86d"],
Cell[118489, 2809, 887, 23, 50, "Print",ExpressionUUID->"f0eb65a4-d2df-40fa-8615-00e093958ea3"],
Cell[119379, 2834, 1010, 29, 50, "Print",ExpressionUUID->"dbdf9512-e517-40d1-a387-bb6f9c23b9bc"],
Cell[120392, 2865, 323, 8, 50, "Print",ExpressionUUID->"f19dba31-1da0-48e3-b354-6ea5c29fd5f6"],
Cell[120718, 2875, 653, 16, 50, "Print",ExpressionUUID->"4d5d8b47-1ccd-45c4-94ab-5820f4f2d483"],
Cell[121374, 2893, 912, 24, 50, "Print",ExpressionUUID->"4500af6a-1bbd-49ea-aab2-5d956a002b6f"],
Cell[122289, 2919, 1034, 30, 50, "Print",ExpressionUUID->"4e34cff0-d125-422a-b68c-4c8f6503a654"],
Cell[123326, 2951, 344, 9, 50, "Print",ExpressionUUID->"0436379a-6172-4e57-a1d1-449f1308da2d"],
Cell[123673, 2962, 653, 16, 50, "Print",ExpressionUUID->"d2dbc101-be2f-4701-9bd7-2908c5848913"],
Cell[124329, 2980, 958, 25, 50, "Print",ExpressionUUID->"0c01bcbc-25c3-452f-be59-ff8b06aec234"],
Cell[125290, 3007, 1053, 31, 50, "Print",ExpressionUUID->"cd986c89-8bcf-40b6-b7ce-95f33929becf"],
Cell[126346, 3040, 377, 10, 50, "Print",ExpressionUUID->"c50d7a19-db2e-4156-b2f9-45763037bc2d"],
Cell[126726, 3052, 653, 16, 50, "Print",ExpressionUUID->"a0c29efd-7e1c-4b23-9ddd-eb355b7e69b5"],
Cell[127382, 3070, 917, 24, 50, "Print",ExpressionUUID->"8f13ecb9-4019-4a73-8532-d1dbbba0d5d8"],
Cell[128302, 3096, 1036, 30, 50, "Print",ExpressionUUID->"ab9b102a-be2a-403a-a964-20e426439966"],
Cell[129341, 3128, 346, 9, 50, "Print",ExpressionUUID->"c79a061e-0ec5-43ea-bde4-25b18e9d8187"],
Cell[129690, 3139, 653, 16, 50, "Print",ExpressionUUID->"12dd377f-b935-49d7-aabb-e4ff69ef8f8c"],
Cell[130346, 3157, 923, 24, 50, "Print",ExpressionUUID->"791161c7-3a1f-4f9e-81c9-5cb98f6922b6"],
Cell[131272, 3183, 1040, 30, 50, "Print",ExpressionUUID->"8eeee2d6-2fee-4388-a475-507ae651f34f"],
Cell[132315, 3215, 350, 9, 50, "Print",ExpressionUUID->"acbe78a4-45e2-4cf8-92ba-bb720a38e881"],
Cell[132668, 3226, 655, 16, 50, "Print",ExpressionUUID->"f1bb8ae3-9b5c-4ddd-ab5e-8a46d7017b9b"]
}, Open  ]],
Cell[133338, 3245, 439, 9, 107, "Output",ExpressionUUID->"90d0c93c-3caf-48d9-a9e2-73ada62b7740"]
}, Open  ]]
}
]
*)

