(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     56250,       1221]
NotebookOptionsPosition[     54979,       1190]
NotebookOutlinePosition[     55414,       1207]
CellTagsIndexPosition[     55371,       1204]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8086764596062355`*^9, 
  3.8086764677464905`*^9}},ExpressionUUID->"9f11d3b1-e593-408c-89a0-\
5c5f218de884"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    FractionBox["1", "7"], "}"}], ",", 
   RowBox[{"{", "n", "}"}], ",", "k", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.808672816129183*^9, 3.808672821279326*^9}, {
   3.808673035839797*^9, 3.808673067611309*^9}, 3.826826684461356*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"55b2a764-3d82-4041-acc5-8ce86f51284e"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["7", 
   RowBox[{"-", "k"}]], " ", "n"}]], "Output",
 CellChangeTimes->{3.8086730960028696`*^9, 3.8268266877704096`*^9, 
  3.826826723900911*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"4527758f-5e94-4f31-abb8-345828a6dae7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", "n", "]"}], 
      RowBox[{"Log", "[", "7", "]"}]], "+", "a"}], 
    RowBox[{"Log", "[", "n", "]"}]], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8086734411634736`*^9, 3.8086734804252396`*^9}, 
   3.8268266905810237`*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"2477a298-f597-4296-886c-9c113c20e3a1"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"Log", "[", "7", "]"}]]], "Output",
 CellChangeTimes->{3.8086734855776825`*^9, 3.8268266910067735`*^9, 
  3.8268267261015425`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"7f5c2f6e-0ad0-47e7-b8e1-e0786df13eba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "CompLimit"}]], "Input",
 CellChangeTimes->{{3.8086759451165175`*^9, 3.8086759481060596`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"5a919ec9-d3c4-4538-ada4-757f03aec21e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Compara en el l\[IAcute]mite dos funciones para \
determinar si la primera es \[OpenCurlyDoubleQuote]theta\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]O grande\
\[CloseCurlyDoubleQuote] u \[OpenCurlyDoubleQuote]Omega\
\[CloseCurlyDoubleQuote] de la segunda. Sintaxis: CompLimit[L] con \
\[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] un vector que contiene las \
funciones (en t\[EAcute]rminos de \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote]). \
Si alguna incluye el par\[AAcute]metro \[OpenCurlyDoubleQuote]j\
\[CloseCurlyDoubleQuote] el comando genera una animaci\[OAcute]n haciendo \
variar \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote] de uno a mil y \
mostrando el comportamiento asint\[OAcute]tico en cada caso. La \
opci\[OAcute]n \[OpenCurlyDoubleQuote]jvalor->Valor\[CloseCurlyDoubleQuote] \
permite cambiar la variaci\[OAcute]n por defecto mil, a cualquier otra, mayor \
o igual a diez.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"CompLimit", "[", 
                    RowBox[{"VilCretas`Private`AlList_List", ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlCompLimitSP", ",", 
                    "VilCretas`Private`AlCompLimitCP", ",", 
                    "VilCretas`Private`FuncionVariable"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    RowBox[{"n", ",", "j"}], "]"}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`FuncionVariable", "[", 
                    "VilCretas`Private`FuncionVariable_List", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`FuncionVariableAuxiliar", ",", 
                    "VilCretas`Private`Simbolos", ",", 
                    "VilCretas`Private`VariableAuxiliarSimbolos", ",", 
                    RowBox[{"VilCretas`Private`VariableAuxiliarVariables", 
                    "=", 
                    RowBox[{"{", "}"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`FuncionVariableAuxiliar", "[", "]"}], ":=", 
                    RowBox[{
                    "VilCretas`Private`FuncionVariable", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Simbolos", "[", 
                    "VilCretas`Private`VariableFuncion_", "]"}], ":=", 
                    RowBox[{"DeleteDuplicates", "[", 
                    RowBox[{"Cases", "[", 
                    RowBox[{
                    RowBox[{
                    "DownValues", "[", "VilCretas`Private`VariableFuncion", 
                    "]"}], ",", "_Symbol", ",", "\[Infinity]"}], "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`VariableAuxiliarSimbolos", "=", 
                    RowBox[{"Sort", "[", 
                    RowBox[{
                    "VilCretas`Private`Simbolos", "[", 
                    "VilCretas`Private`FuncionVariableAuxiliar", "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VariableFuncioni", "=", "1"}], 
                    ",", 
                    RowBox[{
                    "VilCretas`Private`VariableFuncioni", "\[LessEqual]", 
                    RowBox[{
                    "Length", "[", 
                    "VilCretas`Private`VariableAuxiliarSimbolos", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", 
                    RowBox[{
                    "VilCretas`Private`VariableAuxiliarSimbolos", 
                    "\[LeftDoubleBracket]", 
                    "VilCretas`Private`VariableFuncioni", 
                    "\[RightDoubleBracket]"}], "]"}], "\[Equal]", "False"}], 
                    ",", 
                    RowBox[{
                    "VilCretas`Private`VariableAuxiliarVariables", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{
                    "VilCretas`Private`VariableAuxiliarVariables", ",", 
                    RowBox[{
                    "VilCretas`Private`VariableAuxiliarSimbolos", 
                    "\[LeftDoubleBracket]", 
                    "VilCretas`Private`VariableFuncioni", 
                    "\[RightDoubleBracket]"}]}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"VilCretas`Private`VariableFuncioni", "++"}]}]}], 
                    "]"}], ";", 
                    "VilCretas`Private`VariableAuxiliarVariables"}]}], 
                    "]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`AlCompLimitSP", "[", 
                    "VilCretas`Private`AlLista_List", "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VectorQ", "[", "VilCretas`Private`AlLista", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`AlLista", ",", "Null"}], "]"}],
                     "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilCretas`Private`AlLista", "]"}],
                     "\[Equal]", "2"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{}\"\>"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{n}\"\>"}]}], ")"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{}\"\>"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{n}\"\>"}]}], ")"}]}], ")"}], "||", 
                    RowBox[{"NumericQ", "[", 
                    RowBox[{
                    UnderscriptBox["\[Limit]", 
                    RowBox[{"n", "\[Rule]", "\[Infinity]"}]], 
                    FractionBox[
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"First", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}], 
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"Last", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}]]}], "]"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    UnderscriptBox["\[Limit]", 
                    RowBox[{"n", "\[Rule]", "\[Infinity]"}]], 
                    FractionBox[
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"First", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}], 
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"Last", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}]]}], "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", "\[Infinity]", "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Alf5", "[", "VilCretas`Private`Aln_", 
                    "]"}], ":=", 
                    RowBox[{
                    RowBox[{"Together", "[", 
                    RowBox[{"Expand", "[", 
                    RowBox[{"First", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}], "]"}], "/.", "\[VeryThinSpace]", 
                    RowBox[{"n", "\[Rule]", "VilCretas`Private`Aln"}]}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Alf6", "[", "VilCretas`Private`Aln_", 
                    "]"}], ":=", 
                    RowBox[{
                    RowBox[{"Together", "[", 
                    RowBox[{"Expand", "[", 
                    RowBox[{"Last", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}], "]"}], "/.", "\[VeryThinSpace]", 
                    RowBox[{"n", "\[Rule]", "VilCretas`Private`Aln"}]}]}], 
                    ";", 
                    RowBox[{"VilCretas`Private`AlVl35", "=", 
                    RowBox[{
                    UnderscriptBox["\[Limit]", 
                    RowBox[{
                    "VilCretas`Private`n", "\[Rule]", "\[Infinity]"}]], 
                    FractionBox[
                    RowBox[{
                    "VilCretas`Private`Alf5", "[", "VilCretas`Private`n", 
                    "]"}], 
                    RowBox[{
                    "VilCretas`Private`Alf6", "[", "VilCretas`Private`n", 
                    "]"}]]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "NumericQ", "[", "VilCretas`Private`AlVl35", "]"}], "||", 
                    RowBox[{
                    RowBox[{
                    "ToString", "[", "VilCretas`Private`AlVl35", "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", "\[Infinity]", "]"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "NumericQ", "[", "VilCretas`Private`AlVl35", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`AlVl35", ">", "0"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "VilCretas`Private`AlVl35", ",", "\<\"\[RightArrow] \"\>",
                     ",", 
                    RowBox[{"VilCretas`Private`Alf5", "[", "n", "]"}], 
                    ",", "\<\"=\[CapitalTheta](\"\>", ",", 
                    RowBox[{"VilCretas`Private`Alf6", "[", "n", "]"}], 
                    ",", "\<\")\"\>", 
                    ",", "\<\", Notaci\[OAcute]n theta\"\>"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`AlVl35", "\[Equal]", "0"}], 
                    ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "VilCretas`Private`AlVl35", ",", "\<\"\[RightArrow] \"\>",
                     ",", 
                    RowBox[{"VilCretas`Private`Alf5", "[", "n", "]"}], 
                    ",", "\<\"=\[CapitalOmicron](\"\>", ",", 
                    RowBox[{"VilCretas`Private`Alf6", "[", "n", "]"}], 
                    ",", "\<\")\"\>", 
                    ",", "\<\", Notaci\[OAcute]n O grande\"\>"}], "]"}]}], 
                    "]"}]}], "]"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "VilCretas`Private`AlVl35", ",", "\<\"\[RightArrow] \"\>",
                     ",", 
                    RowBox[{"VilCretas`Private`Alf5", "[", "n", "]"}], 
                    ",", "\<\"=\[CapitalOmega](\"\>", ",", 
                    RowBox[{"VilCretas`Private`Alf6", "[", "n", "]"}], 
                    ",", "\<\")\"\>", 
                    ",", "\<\", Notaci\[OAcute]n omega\"\>"}], "]"}]}], "]"}],
                     ",", "\<\"NaD\"\>"}], "]"}]}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`AlCompLimitCP", "[", 
                    "VilCretas`Private`AlLista_List", "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VectorQ", "[", "VilCretas`Private`AlLista", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`AlLista", ",", "Null"}], "]"}],
                     "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilCretas`Private`AlLista", "]"}],
                     "\[Equal]", "2"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{}\"\>"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{j}\"\>"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{n}\"\>"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{j, n}\"\>"}]}], ")"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{}\"\>"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{j}\"\>"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{n}\"\>"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{j, n}\"\>"}]}], ")"}]}], ")"}], "||", 
                    RowBox[{"NumericQ", "[", 
                    RowBox[{
                    UnderscriptBox["\[Limit]", 
                    RowBox[{"n", "\[Rule]", "\[Infinity]"}]], 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"First", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}], 
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"Last", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}]], "/.", "\[VeryThinSpace]", 
                    RowBox[{"j", "\[Rule]", "1"}]}], ")"}]}], "]"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    UnderscriptBox["\[Limit]", 
                    RowBox[{"n", "\[Rule]", "\[Infinity]"}]], 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"First", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}], 
                    RowBox[{"Evaluate", "[", 
                    RowBox[{"Last", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}]], "/.", "\[VeryThinSpace]", 
                    RowBox[{"j", "\[Rule]", "1"}]}], ")"}]}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", "\[Infinity]", "]"}]}]}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`AlVl36", "=", 
                    RowBox[{
                    UnderscriptBox["\[Limit]", 
                    RowBox[{
                    "VilCretas`Private`n", "\[Rule]", "\[Infinity]"}]], 
                    FractionBox[
                    RowBox[{"VilCretas`Private`Alf7", "[", 
                    RowBox[{
                    "VilCretas`Private`n", ",", "VilCretas`Private`Alj2"}], 
                    "]"}], 
                    RowBox[{"VilCretas`Private`Alf8", "[", 
                    RowBox[{
                    "VilCretas`Private`n", ",", "VilCretas`Private`Alj2"}], 
                    "]"}]]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "NumericQ", "[", "VilCretas`Private`AlVl36", "]"}], "||", 
                    RowBox[{
                    RowBox[{
                    "ToString", "[", "VilCretas`Private`AlVl36", "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", "\[Infinity]", "]"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "NumericQ", "[", "VilCretas`Private`AlVl36", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`AlVl36", ">", "0"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlVl36", ",", "\<\"\[RightArrow] \"\>",
                     ",", 
                    RowBox[{"VilCretas`Private`Alf7", "[", 
                    RowBox[{"n", ",", "VilCretas`Private`Alj2"}], "]"}], 
                    ",", "\<\"=\[CapitalTheta](\"\>", ",", 
                    RowBox[{"VilCretas`Private`Alf8", "[", 
                    RowBox[{"n", ",", "VilCretas`Private`Alj2"}], "]"}], 
                    ",", "\<\")\"\>", 
                    ",", "\<\", Notaci\[OAcute]n theta\"\>"}], "}"}], "]"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`AlVl36", "\[Equal]", "0"}], 
                    ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlVl36", ",", "\<\"\[RightArrow] \"\>",
                     ",", 
                    RowBox[{"VilCretas`Private`Alf7", "[", 
                    RowBox[{"n", ",", "VilCretas`Private`Alj2"}], "]"}], 
                    ",", "\<\"=\[CapitalOmicron](\"\>", ",", 
                    RowBox[{"VilCretas`Private`Alf8", "[", 
                    RowBox[{"n", ",", "VilCretas`Private`Alj2"}], "]"}], 
                    ",", "\<\")\"\>", 
                    ",", "\<\", Notaci\[OAcute]n O grande\"\>"}], "}"}], 
                    "]"}]}], "]"}]}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`AlVl36", ",", "\<\"\[RightArrow] \"\>",
                     ",", 
                    RowBox[{"VilCretas`Private`Alf7", "[", 
                    RowBox[{"n", ",", "VilCretas`Private`Alj2"}], "]"}], 
                    ",", "\<\"=\[CapitalOmega](\"\>", ",", 
                    RowBox[{"VilCretas`Private`Alf8", "[", 
                    RowBox[{"n", ",", "VilCretas`Private`Alj2"}], "]"}], 
                    ",", "\<\")\"\>", 
                    ",", "\<\", Notaci\[OAcute]n omega\"\>"}], "}"}], "]"}]}],
                     "]"}], ",", "\<\"NaD\"\>"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Alj2", ",", "1", ",", "\<\"j\"\>"}], 
                    "}"}], ",", "1", ",", 
                    RowBox[{"OptionValue", "[", "jvalor", "]"}], ",", "1", 
                    ",", 
                    RowBox[{"Appearance", "\[Rule]", "\<\"Open\"\>"}]}], 
                    "}"}], ",", 
                    RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
                    RowBox[{"Initialization", "\[RuleDelayed]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`Alf7", "[", 
                    RowBox[{
                    "VilCretas`Private`Aln_", ",", "VilCretas`Private`Alj_"}],
                     "]"}], ":=", 
                    RowBox[{
                    RowBox[{"FullSimplify", "[", 
                    RowBox[{"Together", "[", 
                    RowBox[{"Expand", "[", 
                    RowBox[{"First", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}], "]"}], "]"}], "/.", "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"n", "\[Rule]", "VilCretas`Private`Aln"}], ",", 
                    RowBox[{"j", "\[Rule]", "VilCretas`Private`Alj"}]}], 
                    "}"}]}]}], ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Alf8", "[", 
                    RowBox[{
                    "VilCretas`Private`Aln_", ",", "VilCretas`Private`Alj_"}],
                     "]"}], ":=", 
                    RowBox[{
                    RowBox[{"FullSimplify", "[", 
                    RowBox[{"Together", "[", 
                    RowBox[{"Expand", "[", 
                    RowBox[{"Last", "[", "VilCretas`Private`AlLista", "]"}], 
                    "]"}], "]"}], "]"}], "/.", "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"n", "\[Rule]", "VilCretas`Private`Aln"}], ",", 
                    RowBox[{"j", "\[Rule]", "VilCretas`Private`Alj"}]}], 
                    "}"}]}]}]}], ")"}]}]}], "]"}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"IntegerQ", "[", 
                    RowBox[{"OptionValue", "[", "jvalor", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "jvalor", "]"}], 
                    "\[GreaterEqual]", "10"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "ToString", "[", "VilCretas`Private`AlList", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], "&&", 
                    RowBox[{"VectorQ", "[", "VilCretas`Private`AlList", "]"}],
                     "&&", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`AlList", ",", "Null"}], "]"}], 
                    "\[Equal]", "False"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilCretas`Private`AlList", "]"}], 
                    "\[Equal]", "2"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], ",", "\<\"j\"\>"}], 
                    "]"}], "||", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`AlList", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], ",", "\<\"j\"\>"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    "VilCretas`Private`AlCompLimitCP", "[", 
                    "VilCretas`Private`AlList", "]"}], ",", 
                    RowBox[{
                    "VilCretas`Private`AlCompLimitSP", "[", 
                    "VilCretas`Private`AlList", "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"jvalor", "\[Rule]", "1000"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`CompLimit\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Compara en el l\[IAcute]mite dos funciones para \
determinar si la primera es \[OpenCurlyDoubleQuote]theta\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]O grande\
\[CloseCurlyDoubleQuote] u \[OpenCurlyDoubleQuote]Omega\
\[CloseCurlyDoubleQuote] de la segunda. Sintaxis: CompLimit[L] con \
\[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] un vector que contiene las \
funciones (en t\[EAcute]rminos de \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote]). \
Si alguna incluye el par\[AAcute]metro \[OpenCurlyDoubleQuote]j\
\[CloseCurlyDoubleQuote] el comando genera una animaci\[OAcute]n haciendo \
variar \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote] de uno a mil y \
mostrando el comportamiento asint\[OAcute]tico en cada caso. La \
opci\[OAcute]n \[OpenCurlyDoubleQuote]jvalor->Valor\[CloseCurlyDoubleQuote] \
permite cambiar la variaci\[OAcute]n por defecto mil, a cualquier otra, mayor \
o igual a diez.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{15., {5., 10.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{15., {5., 10.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Compara en el l\[IAcute]mite dos funciones para determinar si la primera \
es \[OpenCurlyDoubleQuote]theta\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]O grande\[CloseCurlyDoubleQuote] u \
\[OpenCurlyDoubleQuote]Omega\[CloseCurlyDoubleQuote] de la segunda. Sintaxis: \
CompLimit[L] con \[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] un vector \
que contiene las funciones (en t\[EAcute]rminos de \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote]). \
Si alguna incluye el par\[AAcute]metro \[OpenCurlyDoubleQuote]j\
\[CloseCurlyDoubleQuote] el comando genera una animaci\[OAcute]n haciendo \
variar \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote] de uno a mil y \
mostrando el comportamiento asint\[OAcute]tico en cada caso. La \
opci\[OAcute]n \[OpenCurlyDoubleQuote]jvalor->Valor\[CloseCurlyDoubleQuote] \
permite cambiar la variaci\[OAcute]n por defecto mil, a cualquier otra, mayor \
o igual a diez.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`CompLimit, {VilCretas`CompLimit[
         Pattern[VilCretas`Private`AlList, 
          Blank[List]], 
         OptionsPattern[]] :> 
       Module[{VilCretas`Private`AlCompLimitSP, 
          VilCretas`Private`AlCompLimitCP, VilCretas`Private`FuncionVariable},
          Clear[$CellContext`n, $CellContext`j]; 
         VilCretas`Private`FuncionVariable[
            Pattern[VilCretas`Private`FuncionVariable, 
             Blank[List]]] := 
          Module[{VilCretas`Private`FuncionVariableAuxiliar, 
             VilCretas`Private`Simbolos, 
             VilCretas`Private`VariableAuxiliarSimbolos, 
             VilCretas`Private`VariableAuxiliarVariables = {}}, 
            VilCretas`Private`FuncionVariableAuxiliar[] := 
             Part[VilCretas`Private`FuncionVariable, 1]; 
            VilCretas`Private`Simbolos[
               Pattern[VilCretas`Private`VariableFuncion, 
                Blank[]]] := DeleteDuplicates[
               Cases[
                DownValues[VilCretas`Private`VariableFuncion], 
                Blank[Symbol], Infinity]]; 
            VilCretas`Private`VariableAuxiliarSimbolos = Sort[
               VilCretas`Private`Simbolos[
               VilCretas`Private`FuncionVariableAuxiliar]]; 
            For[VilCretas`Private`VariableFuncioni = 1, 
              VilCretas`Private`VariableFuncioni <= 
              Length[VilCretas`Private`VariableAuxiliarSimbolos], If[NumericQ[
                  Part[
                  VilCretas`Private`VariableAuxiliarSimbolos, 
                   VilCretas`Private`VariableFuncioni]] == False, 
                VilCretas`Private`VariableAuxiliarVariables = 
                Append[VilCretas`Private`VariableAuxiliarVariables, 
                  Part[
                  VilCretas`Private`VariableAuxiliarSimbolos, 
                   VilCretas`Private`VariableFuncioni]]]; 
              Increment[VilCretas`Private`VariableFuncioni]]; 
            VilCretas`Private`VariableAuxiliarVariables]; 
         VilCretas`Private`AlCompLimitSP[
            Pattern[VilCretas`Private`AlLista, 
             Blank[List]]] := If[
            VectorQ[VilCretas`Private`AlLista], 
            If[MemberQ[VilCretas`Private`AlLista, Null] == False, 
             If[Length[VilCretas`Private`AlLista] == 2, 
              If[
               Or[
                And[
                 Or[ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 1]}]] == "{}", ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 1]}]] == "{n}"], 
                 Or[ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 2]}]] == "{}", ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 2]}]] == "{n}"]], 
                NumericQ[
                 Limit[Evaluate[
                    First[VilCretas`Private`AlLista]]/Evaluate[
                   Last[VilCretas`Private`AlLista]], $CellContext`n -> 
                  Infinity]], ToString[
                  Limit[Evaluate[
                    First[VilCretas`Private`AlLista]]/Evaluate[
                    Last[VilCretas`Private`AlLista]], $CellContext`n -> 
                   Infinity]] == ToString[Infinity]], VilCretas`Private`Alf5[
                  Pattern[VilCretas`Private`Aln, 
                   Blank[]]] := ReplaceAll[
                  Together[
                   Expand[
                    First[VilCretas`Private`AlLista]]], $CellContext`n -> 
                  VilCretas`Private`Aln]; VilCretas`Private`Alf6[
                  Pattern[VilCretas`Private`Aln, 
                   Blank[]]] := ReplaceAll[
                  Together[
                   Expand[
                    Last[VilCretas`Private`AlLista]]], $CellContext`n -> 
                  VilCretas`Private`Aln]; 
               VilCretas`Private`AlVl35 = 
                Limit[VilCretas`Private`Alf5[VilCretas`Private`n]/
                  VilCretas`Private`Alf6[VilCretas`Private`n], 
                  VilCretas`Private`n -> Infinity]; If[
                 Or[
                  NumericQ[VilCretas`Private`AlVl35], 
                  ToString[VilCretas`Private`AlVl35] == ToString[Infinity]], 
                 If[
                  NumericQ[VilCretas`Private`AlVl35], 
                  If[VilCretas`Private`AlVl35 > 0, 
                   Print[VilCretas`Private`AlVl35, "\[RightArrow] ", 
                    VilCretas`Private`Alf5[$CellContext`n], 
                    "=\[CapitalTheta](", 
                    VilCretas`Private`Alf6[$CellContext`n], ")", 
                    ", Notaci\[OAcute]n theta"], 
                   If[VilCretas`Private`AlVl35 == 0, 
                    Print[VilCretas`Private`AlVl35, "\[RightArrow] ", 
                    VilCretas`Private`Alf5[$CellContext`n], 
                    "=\[CapitalOmicron](", 
                    VilCretas`Private`Alf6[$CellContext`n], ")", 
                    ", Notaci\[OAcute]n O grande"]]], 
                  Print[VilCretas`Private`AlVl35, "\[RightArrow] ", 
                   VilCretas`Private`Alf5[$CellContext`n], 
                   "=\[CapitalOmega](", 
                   VilCretas`Private`Alf6[$CellContext`n], ")", 
                   ", Notaci\[OAcute]n omega"]], "NaD"]]]]]; 
         VilCretas`Private`AlCompLimitCP[
            Pattern[VilCretas`Private`AlLista, 
             Blank[List]]] := If[
            VectorQ[VilCretas`Private`AlLista], 
            If[MemberQ[VilCretas`Private`AlLista, Null] == False, 
             If[Length[VilCretas`Private`AlLista] == 2, 
              If[
               Or[
                And[
                 Or[ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 1]}]] == "{}", ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 1]}]] == "{j}", ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 1]}]] == "{n}", ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 1]}]] == "{j, n}"], 
                 Or[ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 2]}]] == "{}", ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 2]}]] == "{j}", ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 2]}]] == "{n}", ToString[
                    VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`AlList, 2]}]] == "{j, n}"]], 
                NumericQ[
                 Limit[
                  ReplaceAll[Evaluate[
                    First[VilCretas`Private`AlLista]]/Evaluate[
                    Last[VilCretas`Private`AlLista]], $CellContext`j -> 
                   1], $CellContext`n -> Infinity]], ToString[
                  Limit[
                   ReplaceAll[Evaluate[
                    First[VilCretas`Private`AlLista]]/Evaluate[
                    Last[VilCretas`Private`AlLista]], $CellContext`j -> 
                    1], $CellContext`n -> Infinity]] == ToString[Infinity]], 
               Print[
                Manipulate[
                VilCretas`Private`AlVl36 = 
                  Limit[VilCretas`Private`Alf7[
                    VilCretas`Private`n, VilCretas`Private`Alj2]/
                    VilCretas`Private`Alf8[
                    VilCretas`Private`n, VilCretas`Private`Alj2], 
                    VilCretas`Private`n -> Infinity]; If[
                   Or[
                    NumericQ[VilCretas`Private`AlVl36], 
                    ToString[VilCretas`Private`AlVl36] == ToString[Infinity]], 
                   If[
                    NumericQ[VilCretas`Private`AlVl36], 
                    If[VilCretas`Private`AlVl36 > 0, 
                    Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
                    
                    VilCretas`Private`Alf7[$CellContext`n, 
                    VilCretas`Private`Alj2], "=\[CapitalTheta](", 
                    
                    VilCretas`Private`Alf8[$CellContext`n, 
                    VilCretas`Private`Alj2], ")", 
                    ", Notaci\[OAcute]n theta"}], 
                    If[VilCretas`Private`AlVl36 == 0, 
                    Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
                    
                    VilCretas`Private`Alf7[$CellContext`n, 
                    VilCretas`Private`Alj2], "=\[CapitalOmicron](", 
                    
                    VilCretas`Private`Alf8[$CellContext`n, 
                    VilCretas`Private`Alj2], ")", 
                    ", Notaci\[OAcute]n O grande"}]]], 
                    Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
                    
                    VilCretas`Private`Alf7[$CellContext`n, 
                    VilCretas`Private`Alj2], "=\[CapitalOmega](", 
                    
                    VilCretas`Private`Alf8[$CellContext`n, 
                    VilCretas`Private`Alj2], ")", 
                    ", Notaci\[OAcute]n omega"}]], "NaD"], {{
                  VilCretas`Private`Alj2, 1, "j"}, 1, 
                  OptionValue[VilCretas`jvalor], 1, Appearance -> "Open"}, 
                 Alignment -> Center, 
                 Initialization :> (VilCretas`Private`Alf7[
                    Pattern[VilCretas`Private`Aln, 
                    Blank[]], 
                    Pattern[VilCretas`Private`Alj, 
                    Blank[]]] := ReplaceAll[
                    FullSimplify[
                    Together[
                    Expand[
                    First[VilCretas`Private`AlLista]]]], {$CellContext`n -> 
                    VilCretas`Private`Aln, $CellContext`j -> 
                    VilCretas`Private`Alj}]; VilCretas`Private`Alf8[
                    Pattern[VilCretas`Private`Aln, 
                    Blank[]], 
                    Pattern[VilCretas`Private`Alj, 
                    Blank[]]] := ReplaceAll[
                    FullSimplify[
                    Together[
                    Expand[
                    Last[VilCretas`Private`AlLista]]]], {$CellContext`n -> 
                    VilCretas`Private`Aln, $CellContext`j -> 
                    VilCretas`Private`Alj}])]]]]]]; If[
           IntegerQ[
            OptionValue[VilCretas`jvalor]], 
           If[OptionValue[VilCretas`jvalor] >= 10, 
            If[
             And[ToString[VilCretas`Private`AlList] != ToString[{}], 
              VectorQ[VilCretas`Private`AlList], 
              MemberQ[VilCretas`Private`AlList, Null] == False, 
              Length[VilCretas`Private`AlList] == 2], 
             If[
              Or[
               StringContainsQ[
                ToString[
                 Part[VilCretas`Private`AlList, 1]], "j"], 
               StringContainsQ[
                ToString[
                 Part[VilCretas`Private`AlList, 2]], "j"]], 
              VilCretas`Private`AlCompLimitCP[VilCretas`Private`AlList], 
              VilCretas`Private`AlCompLimitSP[
              VilCretas`Private`AlList]]]]]]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {VilCretas`jvalor -> 1000}, "Attributes" -> {Protected}, 
    "FullName" -> "VilCretas`CompLimit"], False]]], "Output",
 CellChangeTimes->{3.8086759489770293`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"d7a32b76-9619-4e65-a658-7fc76c7a146d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CompLimit", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", "n", "]"}], 
      RowBox[{"Log", "[", "7", "]"}]], "+", "a"}], ",", 
    RowBox[{"Log", "[", "n", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.80867593378366*^9, 3.8086759423915195`*^9}, {
   3.808675978799236*^9, 3.8086760095345087`*^9}, 3.8268266962515106`*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"f92a39a8-ca56-4d1d-a68d-d7cdc967c9d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"Log", "[", "7", "]"}]], 
   "\[InvisibleSpace]", "\<\"\[RightArrow] \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Log", "[", "7", "]"}]}], "+", 
     RowBox[{"Log", "[", "n", "]"}]}], 
    RowBox[{"Log", "[", "7", "]"}]], 
   "\[InvisibleSpace]", "\<\"=\[CapitalTheta](\"\>", "\[InvisibleSpace]", 
   RowBox[{"Log", "[", "n", "]"}], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", "\<\", Notaci\[OAcute]n theta\"\>"}],
  SequenceForm[
  Log[7]^(-1), "\[RightArrow] ", 
   Log[7]^(-1) ($CellContext`a Log[7] + Log[$CellContext`n]), 
   "=\[CapitalTheta](", 
   Log[$CellContext`n], ")", ", Notaci\[OAcute]n theta"],
  Editable->False]], "Print",
 CellChangeTimes->{3.808676017991246*^9, 3.8268266974715433`*^9, 
  3.826826729224659*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"0ec5ba6d-141b-49d6-8fef-de9fd71b0beb"]
}, Open  ]]
},
WindowSize->{946.5, 381.5},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"8b5315b7-4db2-42b7-b6bd-e7b488746d47"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 184, 4, 42, "Input",ExpressionUUID->"9f11d3b1-e593-408c-89a0-5c5f218de884"],
Cell[CellGroupData[{
Cell[767, 28, 420, 9, 65, "Input",ExpressionUUID->"55b2a764-3d82-4041-acc5-8ce86f51284e"],
Cell[1190, 39, 264, 6, 50, "Output",ExpressionUUID->"4527758f-5e94-4f31-abb8-345828a6dae7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1491, 50, 465, 12, 105, "Input",ExpressionUUID->"2477a298-f597-4296-886c-9c113c20e3a1"],
Cell[1959, 64, 251, 5, 71, "Output",ExpressionUUID->"7f5c2f6e-0ad0-47e7-b8e1-e0786df13eba"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2247, 74, 201, 3, 42, "Input",ExpressionUUID->"5a919ec9-d3c4-4538-ada4-757f03aec21e"],
Cell[2451, 79, 51001, 1065, 326, "Output",ExpressionUUID->"d7a32b76-9619-4e65-a658-7fc76c7a146d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53489, 1149, 479, 11, 91, "Input",ExpressionUUID->"f92a39a8-ca56-4d1d-a68d-d7cdc967c9d5"],
Cell[53971, 1162, 992, 25, 56, "Print",ExpressionUUID->"0ec5ba6d-141b-49d6-8fef-de9fd71b0beb"]
}, Open  ]]
}
]
*)

