(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      8303,        257]
NotebookOptionsPosition[      6933,        225]
NotebookOutlinePosition[      7367,        242]
CellTagsIndexPosition[      7324,        239]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "2"], "-", "t", "-", "1"}], "\[Equal]", "0"}], ",", 
   "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.8066654188768425`*^9, 3.806665445152872*^9}, {
  3.8066760883424764`*^9, 3.8066760937549706`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"38bbeb13-daad-4673-882c-9cae440f1e7b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8066654472108765`*^9, 3.8066760945284157`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"bf735e8c-4516-490c-9f99-d73c210761e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "2"], "-", "t", "-", "1"}], "=", "0"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.806665602633943*^9, 3.8066656039141064`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"146ef7ab-2857-4751-88d6-88c8cfa2b6b3"],

Cell[BoxData[
 TemplateBox[{
  "Set", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"Plus\\\"}]\\) in \
\\!\\(\\*RowBox[{RowBox[{\\\"-\\\", \\\"1\\\"}], \\\"-\\\", \\\"t\\\", \
\\\"+\\\", SuperscriptBox[\\\"t\\\", \\\"2\\\"]}]\\) is Protected.\"", 2, 13, 
   3, 30146023661821484382, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.806665604729717*^9, 3.8066760971868315`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[13]:=",ExpressionUUID->"ce6c2b88-23ee-4c69-8c86-18a21169f3c9"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "naqs", 
   "\"\\!\\(\\*RowBox[{\\\"0\\\"}]\\) is not a quantified system of equations \
and inequalities.\"", 2, 13, 4, 30146023661821484382, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.806665604729717*^9, 3.806676097194929*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[13]:=",ExpressionUUID->"0d0ba9c0-e81c-437c-b173-b3604ee8652c"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"0", ",", "t"}], "]"}]], "Output",
 CellChangeTimes->{3.8066656048255873`*^9, 3.806676097201915*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"12f247f0-4304-4243-a0b2-651b2cf49bf7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"1", "+", 
          SqrtBox["5"]}], "2"], "b1"}], "+", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "-", 
          SqrtBox["5"]}], "2"], "b2"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{"1", "+", 
            SqrtBox["5"]}], "2"], ")"}], "2"], "b1"}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{"1", "-", 
            SqrtBox["5"]}], "2"], ")"}], "2"], "b2"}]}], "\[Equal]", "1"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806668475470456*^9, 3.806668482284413*^9}, {
  3.806668523605818*^9, 3.8066686157092896`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"fbbbe517-0c99-44cb-9023-bf1e74ceaa9e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", 
     FractionBox["1", 
      SqrtBox["5"]]}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"5", "-", 
        SqrtBox["5"]}], 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["5"]}], ")"}]}]]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8066686197479615`*^9, 3.8066761006888175`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"691e68db-645f-45e4-b4c3-b364f4004cdc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        SqrtBox["5"]], 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"1", "+", 
           SqrtBox["5"]}], "2"], ")"}], "n"]}], "-", 
      RowBox[{
       FractionBox[
        RowBox[{"5", "-", 
         SqrtBox["5"]}], 
        RowBox[{"5", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SqrtBox["5"]}], ")"}]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"1", "-", 
           SqrtBox["5"]}], "2"], ")"}], "n"]}]}], "]"}], "\[Equal]", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        SqrtBox["5"]], 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"1", "+", 
           SqrtBox["5"]}], "2"], ")"}], "n"]}], "-", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["5"]], 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"1", "-", 
           SqrtBox["5"]}], "2"], ")"}], "n"]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806674608648055*^9, 3.806674765482299*^9}, {
  3.806674807191019*^9, 3.806674812101946*^9}, {3.806674845459338*^9, 
  3.806674951810669*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"2a109e45-4e35-4879-b3cd-67899d09f419"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.806674694607936*^9, 3.8066747335332136`*^9, 3.8066747663090415`*^9, 
   3.80667481616587*^9, 3.8066748492431116`*^9, 3.806674882752736*^9, {
   3.8066749260526285`*^9, 3.806674953072631*^9}, 3.8066761049497905`*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"3ff34e8d-4aac-457f-924f-c48eef7b5bd3"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"815521ca-7f10-4625-87e5-6d75197d4a2c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 378, 9, 131, "Input",ExpressionUUID->"38bbeb13-daad-4673-882c-9cae440f1e7b"],
Cell[961, 33, 578, 18, 124, "Output",ExpressionUUID->"bf735e8c-4516-490c-9f99-d73c210761e2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1576, 56, 317, 8, 131, "Input",ExpressionUUID->"146ef7ab-2857-4751-88d6-88c8cfa2b6b3"],
Cell[1896, 66, 511, 11, 53, "Message",ExpressionUUID->"ce6c2b88-23ee-4c69-8c86-18a21169f3c9"],
Cell[2410, 79, 414, 9, 53, "Message",ExpressionUUID->"0d0ba9c0-e81c-437c-b173-b3604ee8652c"],
Cell[2827, 90, 227, 4, 107, "Output",ExpressionUUID->"12f247f0-4304-4243-a0b2-651b2cf49bf7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3091, 99, 1038, 34, 285, "Input",ExpressionUUID->"fbbbe517-0c99-44cb-9023-bf1e74ceaa9e"],
Cell[4132, 135, 573, 18, 183, "Output",ExpressionUUID->"691e68db-645f-45e4-b4c3-b364f4004cdc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4742, 158, 1525, 51, 643, "Input",ExpressionUUID->"2a109e45-4e35-4879-b3cd-67899d09f419"],
Cell[6270, 211, 647, 11, 195, "Output",ExpressionUUID->"3ff34e8d-4aac-457f-924f-c48eef7b5bd3"]
}, Open  ]]
}
]
*)

