(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15915,        390]
NotebookOptionsPosition[     14308,        352]
NotebookOutlinePosition[     14739,        369]
CellTagsIndexPosition[     14696,        366]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8077036838781447`*^9, 3.8077036942041407`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"bdcdcb09-b6fc-45a9-b5ee-89c58c2f9478"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"CalculaProducto", "[", 
  RowBox[{"5", ",", 
   RowBox[{"code", "\[Rule]", "True"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"CalculaOtroProducto", "[", 
  RowBox[{"5", ",", 
   RowBox[{"code", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8077036966592855`*^9, 3.807703698815462*^9}, {
  3.807705785751545*^9, 3.807705814750388*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"81ae0f38-254b-4bc5-82b7-c5e1d5fefcac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9", ",", \
"\<\"CalculaProducto[n_]:=Module[{p=1},While[p\[LessEqual]n,p=p*3];Return[p]]\
\"\>"}], "}"}]], "Print",
 CellChangeTimes->{{3.807705800722777*^9, 3.807705815457093*^9}, 
   3.828376918428027*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"2ed92e2d-eddf-4e9d-bba4-182dca60c1ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9", ",", \
"\<\"CalculaOtroProducto[n_]:=Module[{p=1},For[i=1,i\[LessEqual]n,While[p\
\[LessEqual]i,p=p*3];i++];Return[p]]\"\>"}], "}"}]], "Print",
 CellChangeTimes->{{3.807705800722777*^9, 3.807705815457093*^9}, 
   3.828376918431019*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"bcf0e79a-9c1a-4f4c-ac21-b4e5a6c11e44"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CalculaProducto", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"CalculaOtroProducto", "[", "n", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8077064478545384`*^9, 3.807706480000455*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"30802f90-9103-4b1f-a192-811281a09da7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.8077064807311506`*^9, 3.828376920945194*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"bda22b3e-a752-4249-9973-868b5b638ba7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PruebaADA2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"CalculaProducto", ",", "CalculaOtroProducto"}], "}"}], ",", 
   "5000", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.8077072785002747`*^9, 3.8077073099993153`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"8489be9b-5c05-485d-bbce-94073bdb7a44"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "575"}],
  SequenceForm["El primer algoritmo fue mejor: ", 575],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8077073067469273`*^9, 3.807707319571969*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"2e2fac87-06bc-4800-8034-f82688a3376c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El segundo algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "7"}],
  SequenceForm["El segundo algoritmo fue mejor: ", 7],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8077073067469273`*^9, 3.8077073195759935`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"fe80749f-4481-477d-8367-b016f8ce39b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se comportaron igual: \"\>", "\[InvisibleSpace]", "4418"}],
  SequenceForm["Se comportaron igual: ", 4418],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8077073067469273`*^9, 3.8077073195759935`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"291d7f9f-6e52-413d-905d-0c971f86d9ad"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"T1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RepeatedTiming", "[", 
       RowBox[{"CalculaProducto", "[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5", ",", "30"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RepeatedTiming", "[", 
       RowBox[{"CalculaOtroProducto", "[", "i", "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5", ",", "30"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"T1", ",", "T2"}], "}"}], ",", 
   RowBox[{"PlotLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<CalculaProducto\>\"", ",", "\"\<CalculaOtroProducto\>\""}], 
     "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.828376874680068*^9, 3.82837690326309*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"e7a78c38-fc51-407b-8da2-53d494b5d8b2"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 60], 0.016666666666666666`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAmIQDQEf7LckzGDqKPxlBxVwSJO0Feo68RvK53A4uCjn
tuM3mLyAw4ZEG8ufi/9B+SIOT9bX994qhslLOPB4bJzkOgGmX8YhUsznT+CU
v1C+gkNejbm6w70/UL6SQ9QivrapS1nsIXwVh/fx/HfM1zJD+WoOniWtujp5
MHkNh1TNxbdjjsHs13LI7XEyX3CKASqv43D+2wve7xNh8noOzVP6NBY7wOw3
cChcFVU+4zbMfYYOfQpTk9yTYXwjB+EVW7ZwpsHUGzscir62+RobjG/isFF1
1rfmApj7TR0aVh2oX3kVpt/M4az+lNiqVph6c4dHj3yVL82G8S0c2J5dP6q8
HKbf0iH6q8iUv30weSsHjeDdohWxf+wAWUB3rw==
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
      NCache[
       Rational[1, 60], 0.016666666666666666`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAmIQDQEf7H8y/rt/3J3RHirgwH+mTKtVlQnK53Cwsgru
Zb7CDOULOLyXjq9O82SB8kUcJD7+CMz4wgrlSzg097rNzNCG8WUclJfNP60/
jw3KV3CI1dl4PcENxldySN6VnbJpMjuUr+LAvFPeu6qYA8pXc0i22sf+8xUn
lK/hEP67NWOfCBeUr+XQdifsyC8BGF/H4ZZagZuGIC+Ur+fQolv2e80mbijf
wIGj36wv4jSMb+hQKW4ZymEKU2/kEHO9MlWjgg/KN3bY8pLjQZohTN7EoePW
RNevH2Hypg6vrUKCJ5UKQPlmDj7qJ/ZJXeOH8s0dutf+VvqTBpO3cJiTprZX
5DCMb+lQurVgi52DIJRv5bDuy62cNS2C9gBR4mCX
      "]]}}, {{{{}, {GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{0, 0}, {26.52, 0.000027051080322265626`}], 
            Offset[{0, 0}, {26.52, 0.000027051080322265626`}], 
            Offset[{0., 0.}, {26.79083333333333, 0.000027051080322265626`}], 
            Offset[{0., 0.}, {26.79083333333333, 0.000027051080322265626`}], 
            Offset[{0., 0.}, {27.061666666666667`, 0.000027051080322265626`}],
             Offset[{0, 0}, {28.62166666666667, 0.000018361994169900093`}], 
            Offset[{5., 1.1102230246251565`*^-15}, {28.62166666666667, 
             0.000018361994169900093`}], 
            Offset[{10., 2.220446049250313*^-15}, {28.62166666666667, 
             0.000018361994169900093`}], 
            Offset[{10., 2.220446049250313*^-15}, {28.62166666666667, 
             0.000018361994169900093`}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], 
          BSplineCurveBox[{
           Offset[{0, 0}, {26.52, 0.000027051080322265626`}], 
            Offset[{0, 0}, {26.52, 0.000027051080322265626`}], 
            Offset[{0., 0.}, {26.79083333333333, 0.000027051080322265626`}], 
            Offset[{0., 0.}, {26.79083333333333, 0.000027051080322265626`}], 
            Offset[{0., 0.}, {27.061666666666667`, 0.000027051080322265626`}],
             Offset[{0, 0}, {28.62166666666667, 0.000018361994169900093`}], 
            Offset[{5., 1.1102230246251565`*^-15}, {28.62166666666667, 
             0.000018361994169900093`}], 
            Offset[{10., 2.220446049250313*^-15}, {28.62166666666667, 
             0.000018361994169900093`}], 
            Offset[{10., 2.220446049250313*^-15}, {28.62166666666667, 
             0.000018361994169900093`}]}]}, 
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{87., 6.5000000000000195`}, {28.62166666666667, 
             0.000018361994169900093`}], 
            Offset[{87., -6.4999999999999805`}, {28.62166666666667, 
             0.000018361994169900093`}], 
            Offset[{10., -6.499999999999998}, {28.62166666666667, 
             0.000018361994169900093`}], 
            Offset[{10., 6.500000000000002}, {28.62166666666667, 
             0.000018361994169900093`}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"CalculaProducto\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], Offset[{48.5, 1.0769163338864018*^-14}, 
          {28.62166666666667, 0.000018361994169900093}], 
          ImageScaled[{Rational[1, 2], Rational[1, 2]}]]}], GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{0, 0}, {26.52, 0.00006682684326171875}], 
            Offset[{0, 0}, {26.52, 0.00006682684326171875}], 
            Offset[{0., 0.}, {26.79083333333333, 0.00006682684326171875}], 
            Offset[{0., 0.}, {26.79083333333333, 0.00006682684326171875}], 
            Offset[{0., 0.}, {27.061666666666667`, 0.00006682684326171875}], 
            Offset[{0, 0}, {28.62166666666667, 0.00005299150613226634}], 
            Offset[{5., 1.1102230246251565`*^-15}, {28.62166666666667, 
             0.00005299150613226634}], 
            Offset[{10., 2.220446049250313*^-15}, {28.62166666666667, 
             0.00005299150613226634}], 
            Offset[{10., 2.220446049250313*^-15}, {28.62166666666667, 
             0.00005299150613226634}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], 
          BSplineCurveBox[{
           Offset[{0, 0}, {26.52, 0.00006682684326171875}], 
            Offset[{0, 0}, {26.52, 0.00006682684326171875}], 
            Offset[{0., 0.}, {26.79083333333333, 0.00006682684326171875}], 
            Offset[{0., 0.}, {26.79083333333333, 0.00006682684326171875}], 
            Offset[{0., 0.}, {27.061666666666667`, 0.00006682684326171875}], 
            Offset[{0, 0}, {28.62166666666667, 0.00005299150613226634}], 
            Offset[{5., 1.1102230246251565`*^-15}, {28.62166666666667, 
             0.00005299150613226634}], 
            Offset[{10., 2.220446049250313*^-15}, {28.62166666666667, 
             0.00005299150613226634}], 
            Offset[{10., 2.220446049250313*^-15}, {28.62166666666667, 
             0.00005299150613226634}]}]}, 
         {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]]}], 
          PolygonBox[{
           Offset[{107., 6.500000000000024}, {28.62166666666667, 
             0.00005299150613226634}], 
            Offset[{107., -6.499999999999976}, {28.62166666666667, 
             0.00005299150613226634}], 
            Offset[{10., -6.499999999999997}, {28.62166666666667, 
             0.00005299150613226634}], 
            Offset[{10., 6.500000000000003}, {28.62166666666667, 
             0.00005299150613226634}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["\<\"CalculaOtroProducto\"\>",
            BoxRotation->0.],
           StripOnInput->False,
           LineOpacity->1,
           FrontFaceOpacity->1,
           BackFaceOpacity->1,
           Opacity->1,
           FontOpacity->1], 
          Offset[{58.5, 1.2989609388114332*^-14}, \
{28.62166666666667, 0.00005299150613226634}], 
          ImageScaled[{Rational[1, 2], Rational[1, 2]}]]}]}}, {}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{All, 139.8}, {All, All}},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 26.}, {0, 0.00006682684326171875}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.08090169943749476]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8283769965377192`*^9, 3.8283779465409627`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"65261a4e-637b-4b30-ac90-b01903187e83"]
}, Open  ]]
},
WindowSize->{949, 467},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"94b24e99-0cb7-4e9d-be5d-d5c22f88ad12"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 42, "Input",ExpressionUUID->"bdcdcb09-b6fc-45a9-b5ee-89c58c2f9478"],
Cell[CellGroupData[{
Cell[785, 27, 456, 9, 119, "Input",ExpressionUUID->"81ae0f38-254b-4bc5-82b7-c5e1d5fefcac"],
Cell[CellGroupData[{
Cell[1266, 40, 366, 10, 33, "Print",ExpressionUUID->"2ed92e2d-eddf-4e9d-bba4-182dca60c1ba"],
Cell[1635, 52, 398, 10, 60, "Print",ExpressionUUID->"bcf0e79a-9c1a-4f4c-ac21-b4e5a6c11e44"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2082, 68, 410, 9, 65, "Input",ExpressionUUID->"30802f90-9103-4b1f-a192-811281a09da7"],
Cell[2495, 79, 472, 8, 78, "Output",ExpressionUUID->"bda22b3e-a752-4249-9973-868b5b638ba7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3004, 92, 332, 7, 42, "Input",ExpressionUUID->"8489be9b-5c05-485d-bbce-94073bdb7a44"],
Cell[CellGroupData[{
Cell[3361, 103, 390, 9, 33, "Print",ExpressionUUID->"2e2fac87-06bc-4800-8034-f82688a3376c"],
Cell[3754, 114, 390, 9, 33, "Print",ExpressionUUID->"fe80749f-4481-477d-8367-b016f8ce39b2"],
Cell[4147, 125, 372, 8, 33, "Print",ExpressionUUID->"291d7f9f-6e52-413d-905d-0c971f86d9ad"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4568, 139, 1120, 32, 226, "Input",ExpressionUUID->"e7a78c38-fc51-407b-8da2-53d494b5d8b2"],
Cell[5691, 173, 8601, 176, 217, "Output",ExpressionUUID->"65261a4e-637b-4b30-ac90-b01903187e83"]
}, Open  ]]
}
]
*)

