(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     39628,        866]
NotebookOptionsPosition[     37101,        823]
NotebookOutlinePosition[     37585,        841]
CellTagsIndexPosition[     37542,        838]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8202311176947727`*^9, 3.8202311208363905`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Sigma]", "0"], ",", 
    SubscriptBox["\[Sigma]", "1"], ",", 
    SubscriptBox["\[Sigma]", "2"]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.8205743488207197`*^9, 3.820574362748187*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"603202cf-4fe8-46de-94bb-782e903e369c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "0"], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "1"], "}"}], ",", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "2"], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8205743629133587`*^9, 3.820575904082153*^9, 
  3.820595653088602*^9, 3.820599578732259*^9, 3.820604172586258*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"1ab5e522-21bd-4b96-841f-53570b0e2817"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Automata", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "0"], ",", 
       SubscriptBox["\[Sigma]", "1"], ",", 
       SubscriptBox["\[Sigma]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     SubscriptBox["\[Sigma]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "a", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "1"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "b", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "0"], ",", 
           SubscriptBox["\[Sigma]", "1"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "0"], ",", "c", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "0"], ",", 
           SubscriptBox["\[Sigma]", "1"], ",", 
           SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "a", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "0"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "b", ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], ",", "c", ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[Sigma]", "1"], ",", 
           SubscriptBox["\[Sigma]", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "a", ",", 
         RowBox[{"{", 
          SubscriptBox["\[Sigma]", "2"], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "b", ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["\[Sigma]", "2"], ",", "c", ",", 
         RowBox[{"{", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox["\[Sigma]", "2"], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AutomataDeterministicoEquivalente", "[", "A", "]"}]}], "Input",
 CellChangeTimes->{{3.8202311310330486`*^9, 3.820231265805186*^9}, {
   3.820231862894062*^9, 3.8202319081620555`*^9}, {3.8202320078918257`*^9, 
   3.820232010904651*^9}, 3.8202321800940557`*^9, {3.8202331332510276`*^9, 
   3.8202331336190195`*^9}, {3.820310676202611*^9, 3.820310730815018*^9}, {
   3.820313080338834*^9, 3.8203130857585125`*^9}, {3.8203135274070387`*^9, 
   3.820313622393606*^9}, {3.8203137203789926`*^9, 3.8203138713359356`*^9}, {
   3.8203139618671274`*^9, 3.820314028995368*^9}, {3.8203140618640323`*^9, 
   3.8203140912089596`*^9}, {3.8203141490563393`*^9, 
   3.8203141767049627`*^9}, {3.82031659456876*^9, 3.8203167006102066`*^9}, {
   3.820316854244767*^9, 3.8203169370201435`*^9}, {3.8203171727548833`*^9, 
   3.8203171921060047`*^9}, {3.8203179402214584`*^9, 
   3.8203179520553885`*^9}, {3.820574321153582*^9, 3.820574369996811*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"7e877a78-b0d2-431a-b2e6-ca4b1233d0fe"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del aut\[OAcute]mata no \
determin\[IAcute]stico: \"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.82060417471229*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"684bbbbd-1b42-43a9-84f4-110b9cc8cb70"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.499999750000125, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "0"], {0.499999750000125, 0.500000249999875}], 
   PolygonBox[{{0.5184373226955117, 0.10068842190989287`}, {
    0.5194111686771047, 0.07244490074922978}, {0.5433838525037658, 
    0.08741003668899426}}], 
   CircleBox[{0.21187606611310772, 0.25000037499981254}, 
    0.35511094850116565, {5.759486531581288, 6.8067840827778845`}], 
   InsetBox["\<\"c\"\>", {0.5669870141703847, 0.24998261945239483}, 
    ImageScaled[{1, Rational[1, 2]}]], 
   PolygonBox[{{0.8992706709356493, 0.5184349962977854}, {0.9275550992507702, 
    0.5194116686768547}, {0.9125670620017612, 0.5434183659397347}}], 
   CircleBox[{0.7499996250001875, 0.21187656611285788}, 0.35511094850116554, {
    1.0471975511965979`, 2.0943951023931953`}], 
   InsetBox["\<\"c,b,a\"\>", {0.7499996250001875, 0.5669875146140234}, 
    ImageScaled[{Rational[1, 2], 1}]], 
   CircleBox[{0.3958980916067041, 0.4862950066693913}, 0.03749998125000937, {
    0.6544984694978737, 5.890486225480862}], 
   PolygonBox[{{0.392507486159369, 0.5091235488429472}, {0.4256488269922577, 
    0.5091235488429472}, {0.4090781565758133, 0.5378247919197073}}], 
   InsetBox["\<\"c,b\"\>", {0.391003361845817, 0.5234741703813274}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.99999950000025, 0.500000249999875}, 0.07499996250001874], 
   InsetBox[
    SubscriptBox["\[Sigma]", "1"], {0.99999950000025, 0.500000249999875}], 
   PolygonBox[{{0.5874321879986137, 0.4565821340600153}, {0.5724441507496048, 
    0.4805888313228953}, {0.6007285790647257, 0.48156550370196455`}}], 
   CircleBox[{0.7499996250001875, 0.7881239338868922}, 0.35511094850116554, {
    4.188790204786391, 5.235887755982988}], 
   InsetBox["\<\"a\"\>", {0.7499818694527698, 0.43301298582961534}, 
    ImageScaled[{Rational[1, 2], 0}]], 
   PolygonBox[{{0.5893902837518628, 0.06331553765522902}, {0.5649516228080215,
     0.03750048124975942}, {0.599527447927207, 0.029243508240653027`}}], 
   CircleBox[{0.41943899367211673, 0.5805610063278832}, 0.5622176261343743, {
    4.974088368183839, 6.021285919380437}], 
   InsetBox["\<\"c\"\>", {0.8169471328370685, 0.18297335758387556}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.097006802410284, 0.5401819903073393}, 
    0.03749998125000937, {-2.2252947962927703`, 3.010692959690218}], 
   PolygonBox[{{1.0976127270772782`, 0.48699678808123537`}, {
    1.074178260236728, 0.5104312549217856}, {1.1061903372650637`, 
    0.519008865109571}}], 
   InsetBox["\<\"c\"\>", {1.111357423948664, 0.5055365251608985}, 
    ImageScaled[{0, 1}]], 
   CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 0.07499996250001874],
    CircleBox[{0.499999750000125, 4.999997500476638*^-7}, 
    0.04999997500001249], InsetBox[
    SubscriptBox["\[Sigma]", 
     "2"], {0.499999750000125, 4.999997500476638*^-7}], 
   CircleBox[{0.4360798319141684, -0.08330155907980008}, 
    0.03749998125000937, {-4.843288674284264, 0.3926990816987246}], 
   PolygonBox[{{0.4089624846467197, -0.03754478518007859}, {
    0.44097456167505544`, -0.04612239536786405}, {
    0.41754009483450516`, -0.06955686220841434}}], 
   InsetBox["\<\"a\"\>", {0.40632909652861476, -0.06047301690624414}, 
    ImageScaled[{1, 0}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.499999750000125, 0.6500001749999125}, {0.499999750000125, 
     0.5750002124998937}}], 
    PolygonBox[{{0.499999750000125, 0.5750002124998937}, {0.4749997625001187, 
     0.6125001937499032}, {0.5249997375001312, 0.6125001937499032}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747152815`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"0a22fbdf-a356-406a-90ad-2a118ac52cba"],

Cell[BoxData["\<\"Estados del nuevo aut\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.820604174717276*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"72b7b708-138b-47cd-a870-8e588421e170"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "0"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 0], "=", {}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747182736`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"12992c7b-5098-4514-8fba-a00262b50aca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "1"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "0"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 1], "=", {
    Subscript[$CellContext`\[Sigma], 0]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747192707`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"269f3b4b-a1f2-470b-a856-697087701f91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "2"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "1"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 2], "=", {
    Subscript[$CellContext`\[Sigma], 1]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747202682`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"231be659-64a8-4b5d-97d9-523ac563fa18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "3"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    SubscriptBox["\[Sigma]", "2"], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 3], "=", {
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747222633`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"d37adbde-c653-4de9-972b-ccb91c1ee23e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "4"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 4], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747232637`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"5455b2a9-e906-4825-83ce-0bbc25016925"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "5"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 5], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747252555`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"0e93cc99-245f-487e-a047-003bfd6608f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "6"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 6], "=", {
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747262535`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"22af0089-1460-494a-81f9-9ce420e9eb5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\[Mu]", "7"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "0"], ",", 
     SubscriptBox["\[Sigma]", "1"], ",", 
     SubscriptBox["\[Sigma]", "2"]}], "}"}]}],
  SequenceForm[
   Subscript[$CellContext`\[Mu], 7], "=", {
    Subscript[$CellContext`\[Sigma], 0], 
    Subscript[$CellContext`\[Sigma], 1], 
    Subscript[$CellContext`\[Sigma], 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747272515`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"1231e0d6-7d6a-44c3-b6b5-89170cdb3aff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estado inicial: \"\>", "\[InvisibleSpace]", 
   SubscriptBox["\[Mu]", "1"]}],
  SequenceForm["Estado inicial: ", 
   Subscript[$CellContext`\[Mu], 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.820604174729291*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"002efe33-5fc4-4e9b-aeaf-b597f9901d6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Estados aceptados: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Mu]", "3"], ",", 
     SubscriptBox["\[Mu]", "5"], ",", 
     SubscriptBox["\[Mu]", "6"], ",", 
     SubscriptBox["\[Mu]", "7"]}], "}"}]}],
  SequenceForm["Estados aceptados: ", {
    Subscript[$CellContext`\[Mu], 3], 
    Subscript[$CellContext`\[Mu], 5], 
    Subscript[$CellContext`\[Mu], 6], 
    Subscript[$CellContext`\[Mu], 7]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747302423`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"3445a07d-d941-4b4e-909a-c39d477bb771"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\" \"\>", "a", "b", "c"},
     {
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "7"]},
     {
      SubscriptBox["\[Mu]", "2"], 
      SubscriptBox["\[Mu]", "1"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "6"]},
     {
      SubscriptBox["\[Mu]", "3"], 
      SubscriptBox["\[Mu]", "3"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "0"]},
     {
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "7"]},
     {
      SubscriptBox["\[Mu]", "5"], 
      SubscriptBox["\[Mu]", "6"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "7"]},
     {
      SubscriptBox["\[Mu]", "6"], 
      SubscriptBox["\[Mu]", "5"], 
      SubscriptBox["\[Mu]", "0"], 
      SubscriptBox["\[Mu]", "6"]},
     {
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "7"], 
      SubscriptBox["\[Mu]", "4"], 
      SubscriptBox["\[Mu]", "7"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747327414`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"16135cc6-b4cd-406a-aefd-81ad7445b854"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n del nuevo aut\[OAcute]mata: \
\"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747337427`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"9f23841f-c90b-499a-b7de-3c99cb6b2ca3"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "0"], {0.6666664444445185, 0.3333335555554815}], 
   CircleBox[{0.7342812297464916, 0.3152162284374141}, 
    0.024999991666669445, {-2.879793265790643, 2.3561944901923453`}], 
   PolygonBox[{{0.7130169679686124, 0.28684054277060517`}, {
    0.7101330921386441, 0.30874575446667574`}, {0.7305454998577013, 
    0.30029065834875296`}}], 
   InsetBox["\<\"c,b,a\"\>", {0.7278107557757532, 0.2910680908295666}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 0.6666667777777407}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "1"], {0.33333322222225925, 0.6666667777777407}], 
   PolygonBox[{{0.33509608106414446`, 0.40209357717613275`}, {
    0.33483177644669093`, 0.38331107718841767`}, {0.35123005089135984`, 
    0.3924734326692229}}], 
   CircleBox[{0.13698553953267908, 0.5107501935142962}, 0.23533776116670302, {
    5.710846199498503, 6.758143750695101}], 
   InsetBox["\<\"b\"\>", {0.37204439249279736, 0.4992960468402902}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9351308505498775, 0.6998243938291806}, {0.9646443393925594, 
    0.7020221050519591}, {0.9479843212221103, 0.726482680532641}}], 
   CircleBox[{0.7002427369977656, 0.1831561523188583}, 0.5823487651352804, {
    1.0995173504358624`, 2.1467149016324987`}], 
   InsetBox["\<\"c\"\>", {0.669788265106407, 0.7647080497419554}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5989851136359128, 0.6806942100302409}, {0.6183701692288235, 
    0.6796077257192175}, {0.6096185644465277, 0.6969389184719634}}], 
   CircleBox[{0.4741179374504348, 0.4745842898393233}, 0.2506856909219987, {
    0.9576657047302127, 2.0048632559267805`}], 
   InsetBox["\<\"a\"\>", {0.4965323167831764, 0.7242659095716694}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "2"], {0.6666664444445185, 0.6666667777777407}], 
   PolygonBox[{{0.6790727377090183, 0.4004789024617207}, {0.6796073923859952, 
    0.3816298307711765}, {0.6956638399692722, 0.39151739114896267`}}], 
   CircleBox[{0.47495011454298863, 0.5014534724099338}, 0.2371546045719604, {
    5.753407427218437, 6.800704978415033}], 
   InsetBox["\<\"b\"\>", {0.7121002646634077, 0.4999999361889923}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.3894375476433131, 0.6302588930283262}, {
    0.37887639828725933`, 0.6460314331659692}, {0.3978163934066948, 
    0.647291386732652}}], 
   CircleBox[{0.4919597407747718, 0.8572863211846418}, 0.23961734089988207, {
    4.220906910420207, 5.268004461616808}], 
   InsetBox["\<\"a\"\>", {0.4996421627469065, 0.6177921658226113}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.37526335180919657`, 0.0691825935362291}, {0.361731675805639,
     0.041152807953915405`}, {0.3927720201843322, 0.0434489255702111}}], 
   CircleBox[{0.008887154143211104, 0.5837112424047529}, 0.6472008276114389, {
    5.28889938368336, 6.3361969348799585`}], 
   InsetBox["\<\"c\"\>", {0.5857240176370808, 0.2902352737540196}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.6666664444445185, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Mu]", "3"], {0.6666664444445185, 3.333332222466012*^-7}], 
   PolygonBox[{{0.637721028993712, 0.275045253841777}, {0.6537254965030418, 
    0.2850372803397865}, {0.6543766115309403, 0.2661809916536594}}], 
   CircleBox[{0.8587489323829286, 0.16666694444435187}, 0.23674067179086933, {
    2.6179938779914944`, 3.665191429188092}], 
   InsetBox["\<\"c,b\"\>", {0.6220082605920593, 0.1666669444443519}, 
    ImageScaled[{0, Rational[1, 2]}]], 
   CircleBox[{0.6847837715625859, -0.06761445196875078}, 
    0.024999991666669445, {2.356194490192345, 7.592182246175334}], 
   PolygonBox[{{0.6495775760363878, -0.06338690390978938}, {
    0.6671061079254768, -0.04993678833164164}, {
    0.669989983755445, -0.07184200002771218}}], 
   InsetBox["\<\"a\"\>", {0.6606356339547383, -0.07408492593948914}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "4"], {0.33333322222225925, 0.3333335555554815}], 
   PolygonBox[{{0.923135040789333, 0.6417245588677551}, {0.951211179719403, 
    0.6557268566299437}, {0.9250467646809587, 0.6730403573024715}}], 
   CircleBox[{0.897782014922079, 0.0034632789262682984}, 0.6544482030304134, {
    1.4890653433536625`, 2.5362628945502586`}], 
   InsetBox["\<\"c\"\>", {0.6179212400877101, 0.5950546895796379}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.27635520990657547, 0.2926702693394272}, 
    0.024999991666669445, {1.1434379769069971`, 6.3794257328899855`}], 
   PolygonBox[{{0.26721142890875754`, 0.30504441938448}, {
    0.28671691098318175`, 0.3154218568473924}, {0.2679770454769032, 
    0.32712538110544953`}}], 
   InsetBox["\<\"b,a\"\>", {0.2618326076865561, 0.3130195594521714}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.9999996666667778, 0.3333335555554815}, 0.04999998333333889], 
   CircleBox[{0.9999996666667778, 0.3333335555554815}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "5"], {0.9999996666667778, 0.3333335555554815}], 
   PolygonBox[{{0.9820795883671548, 0.6075128327511818}, {0.9985011124423461, 
    0.6166892561448045}, {0.9982373661795095, 0.5978795874300198}}], 
   CircleBox[{1.1963473493563572, 0.4892501398189261}, 0.23533776116670296, {
    2.569353545908709, 3.61655109710531}], 
   InsetBox["\<\"c\"\>", {0.9612879239827291, 0.5006925335359712}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.39614473403642464`, 0.29331725504945144`}, {
    0.3810831203584689, 0.31850299382250025`}, {0.4104254167879858, 
    0.31895386450307267`}}], 
   CircleBox[{0.6707507404747381, 0.8124007047752428}, 0.5725751295920252, {
    4.18196019698323, 5.229057748178317}], 
   InsetBox["\<\"b\"\>", {0.6668114501923822, 0.23983912641061333}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.4077037114307514, -0.03281544132759343}, {
    0.3807673713134019, -0.015811049697158647`}, {
    0.40896177649993265`, -0.0009856906857734424}}], 
   CircleBox[{0.4211889078516513, 0.6576220176300862}, 0.6746450894995789, {
    4.652437813787197, 5.699535364983795}], 
   InsetBox["\<\"a\"\>", {0.7228691925904072, 0.05418602053856536}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Mu]", "6"], {0.33333322222225925, 3.333332222466012*^-7}],
    PolygonBox[{{0.9250135942647546, 0.3644779234127388}, {0.9525655175756351,
     0.3491449385858624}, {0.9255108015442786, 0.33295076548895747`}}], 
   CircleBox[{0.9493350125630768, -0.3118599474184254}, 0.6610127801216689, {
    1.5659091022663756`, 2.6131066534629728`}], 
   InsetBox["\<\"a\"\>", {0.6216302689688615, 0.262202328393204}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6002237546029077, 0.31530466452297046`}, {
    0.6233651886890484, 0.30833356388881206`}, {0.6057573214044591, 
    0.29177804440729027`}}], 
   CircleBox[{0.7020723601922491, -0.07200811059210954}, 0.3884000620403987, {
    1.7748541186524378`, 2.822051669849035}], 
   InsetBox["\<\"b\"\>", {0.4437391129699981, 0.21802385587467993}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.276546288188948, -0.040929372950005864}, 
    0.024999991666669445, {1.1481216617974264`, 6.384109417780415}], 
   PolygonBox[{{0.2673446510763704, -0.02859818506229727}, {
    0.2868013147368996, -0.018129504225946315`}, {
    0.26800683935824376`, -0.006513879641213943}}], 
   InsetBox["\<\"c\"\>", {0.261928535944938, -0.02064832508096613}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.9999996666667778, 0.6666667777777407}, 0.04999998333333889], 
   CircleBox[{0.9999996666667778, 0.6666667777777407}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "7"], {0.9999996666667778, 0.6666667777777407}], 
   PolygonBox[{{0.40826272083435605`, 0.3270479856599157}, {
    0.3821011279028267, 0.3443648614104312}, {0.4101787786827165, 
    0.35836302761734534`}}], 
   CircleBox[{0.4356197248114666, 0.996600570660426}, 0.6544277352282023, {
    4.630518319553753, 5.677615870750351}], 
   InsetBox["\<\"b\"\>", {0.7153595339893877, 0.40497459101026356}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.0650654242142206, 0.6924823530785615}, 
    0.024999991666669445, {-2.2402825879421435`, 2.995705168040845}], 
   PolygonBox[{{1.064937929343783, 0.6570234739214629}, {1.0495508487491656`, 
    0.6728788449365821}, {1.070975543131995, 0.6782767621140398}}], 
   InsetBox["\<\"c,a\"\>", {1.0742852725359422, 0.6692445825259034}, 
    ImageScaled[{0, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.33333322222225925`, 0.7666667444444185}, {
     0.33333322222225925`, 0.7166667611110796}}], 
    PolygonBox[{{0.33333322222225925`, 0.7166667611110796}, {
     0.31666656111114627`, 0.7416667527777491}, {0.34999988333337223`, 
     0.7416667527777491}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747377586`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"4596868a-ce25-4947-9fc6-0b0898a6a18b"],

Cell[BoxData["\<\"Diagrama de transici\[OAcute]n reducido del nuevo aut\
\[OAcute]mata: \"\>"], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747397795`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"abc71ea5-5f2f-4d30-98ab-e8e635fbb94b"],

Cell[BoxData[
 GraphicsBox[{
   CircleBox[{0.6666664444445185, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "0"], {0.6666664444445185, 0.3333335555554815}], 
   CircleBox[{0.7222011597533332, 0.29072026972929965}, 
    0.024999991666669445, {-3.2724923474893677`, 1.9634954084936211`}], 
   PolygonBox[{{0.6916966387361013, 0.2726420352046296}, {0.6974150464810257, 
    0.293983423447083}, {0.7130380269785547, 0.2783604429495541}}], 
   InsetBox["\<\"c,b,a\"\>", {0.7069821291011255, 0.27088644283329444}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 0.6666667777777407}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "1"], {0.33333322222225925, 0.6666667777777407}], 
   PolygonBox[{{0.33509608106414446`, 0.40209357717613275`}, {
    0.33483177644669093`, 0.38331107718841767`}, {0.35123005089135984`, 
    0.3924734326692229}}], 
   CircleBox[{0.13698553953267908, 0.5107501935142962}, 0.23533776116670302, {
    5.710846199498503, 6.758143750695101}], 
   InsetBox["\<\"b\"\>", {0.37204439249279736, 0.4992960468402902}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.9351308505498775, 0.6998243938291806}, {0.9646443393925594, 
    0.7020221050519591}, {0.9479843212221103, 0.726482680532641}}], 
   CircleBox[{0.7002427369977656, 0.1831561523188583}, 0.5823487651352804, {
    1.0995173504358624`, 2.1467149016324987`}], 
   InsetBox["\<\"c\"\>", {0.669788265106407, 0.7647080497419554}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.5989851136359128, 0.6806942100302409}, {0.6183701692288235, 
    0.6796077257192175}, {0.6096185644465277, 0.6969389184719634}}], 
   CircleBox[{0.4741179374504348, 0.4745842898393233}, 0.2506856909219987, {
    0.9576657047302127, 2.0048632559267805`}], 
   InsetBox["\<\"a\"\>", {0.4965323167831764, 0.7242659095716694}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.6666664444445185, 0.6666667777777407}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "2"], {0.6666664444445185, 0.6666667777777407}], 
   PolygonBox[{{0.6790727377090183, 0.4004789024617207}, {0.6796073923859952, 
    0.3816298307711765}, {0.6956638399692722, 0.39151739114896267`}}], 
   CircleBox[{0.47495011454298863, 0.5014534724099338}, 0.2371546045719604, {
    5.753407427218437, 6.800704978415033}], 
   InsetBox["\<\"b\"\>", {0.7121002646634077, 0.4999999361889923}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.3894375476433131, 0.6302588930283262}, {
    0.37887639828725933`, 0.6460314331659692}, {0.3978163934066948, 
    0.647291386732652}}], 
   CircleBox[{0.4919597407747718, 0.8572863211846418}, 0.23961734089988207, {
    4.220906910420207, 5.268004461616808}], 
   InsetBox["\<\"a\"\>", {0.4996421627469065, 0.6177921658226113}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.37526335180919657`, 0.0691825935362291}, {0.361731675805639,
     0.041152807953915405`}, {0.3927720201843322, 0.0434489255702111}}], 
   CircleBox[{0.008887154143211104, 0.5837112424047529}, 0.6472008276114389, {
    5.28889938368336, 6.3361969348799585`}], 
   InsetBox["\<\"c\"\>", {0.5857240176370808, 0.2902352737540196}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 0.3333335555554815}, 0.04999998333333889], 
   InsetBox[
    SubscriptBox["\[Mu]", "4"], {0.33333322222225925, 0.3333335555554815}], 
   PolygonBox[{{0.923135040789333, 0.6417245588677551}, {0.951211179719403, 
    0.6557268566299437}, {0.9250467646809587, 0.6730403573024715}}], 
   CircleBox[{0.897782014922079, 0.0034632789262682984}, 0.6544482030304134, {
    1.4890653433536625`, 2.5362628945502586`}], 
   InsetBox["\<\"c\"\>", {0.6179212400877101, 0.5950546895796379}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.27635520990657547, 0.2926702693394272}, 
    0.024999991666669445, {1.1434379769069971`, 6.3794257328899855`}], 
   PolygonBox[{{0.26721142890875754`, 0.30504441938448}, {
    0.28671691098318175`, 0.3154218568473924}, {0.2679770454769032, 
    0.32712538110544953`}}], 
   InsetBox["\<\"b,a\"\>", {0.2618326076865561, 0.3130195594521714}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.9999996666667778, 0.3333335555554815}, 0.04999998333333889], 
   CircleBox[{0.9999996666667778, 0.3333335555554815}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "5"], {0.9999996666667778, 0.3333335555554815}], 
   PolygonBox[{{0.9820795883671548, 0.6075128327511818}, {0.9985011124423461, 
    0.6166892561448045}, {0.9982373661795095, 0.5978795874300198}}], 
   CircleBox[{1.1963473493563572, 0.4892501398189261}, 0.23533776116670296, {
    2.569353545908709, 3.61655109710531}], 
   InsetBox["\<\"c\"\>", {0.9612879239827291, 0.5006925335359712}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.39614473403642464`, 0.29331725504945144`}, {
    0.3810831203584689, 0.31850299382250025`}, {0.4104254167879858, 
    0.31895386450307267`}}], 
   CircleBox[{0.6707507404747381, 0.8124007047752428}, 0.5725751295920252, {
    4.18196019698323, 5.229057748178317}], 
   InsetBox["\<\"b\"\>", {0.6668114501923822, 0.23983912641061333}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.4077037114307514, -0.03281544132759343}, {
    0.3807673713134019, -0.015811049697158647`}, {
    0.40896177649993265`, -0.0009856906857734424}}], 
   CircleBox[{0.4211889078516513, 0.6576220176300862}, 0.6746450894995789, {
    4.652437813787197, 5.699535364983795}], 
   InsetBox["\<\"a\"\>", {0.7228691925904072, 0.05418602053856536}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.04999998333333889], 
   CircleBox[{0.33333322222225925, 3.333332222466012*^-7}, 
    0.033333322222225924], InsetBox[
    SubscriptBox["\[Mu]", "6"], {0.33333322222225925, 3.333332222466012*^-7}],
    PolygonBox[{{0.9250135942647546, 0.3644779234127388}, {0.9525655175756351,
     0.3491449385858624}, {0.9255108015442786, 0.33295076548895747`}}], 
   CircleBox[{0.9493350125630768, -0.3118599474184254}, 0.6610127801216689, {
    1.5659091022663756`, 2.6131066534629728`}], 
   InsetBox["\<\"a\"\>", {0.6216302689688615, 0.262202328393204}, 
    ImageScaled[{1, 1}]], 
   PolygonBox[{{0.6002237546029077, 0.31530466452297046`}, {
    0.6233651886890484, 0.30833356388881206`}, {0.6057573214044591, 
    0.29177804440729027`}}], 
   CircleBox[{0.7020723601922491, -0.07200811059210954}, 0.3884000620403987, {
    1.7748541186524378`, 2.822051669849035}], 
   InsetBox["\<\"b\"\>", {0.4437391129699981, 0.21802385587467993}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{0.276546288188948, -0.040929372950005864}, 
    0.024999991666669445, {1.1481216617974264`, 6.384109417780415}], 
   PolygonBox[{{0.2673446510763704, -0.02859818506229727}, {
    0.2868013147368996, -0.018129504225946315`}, {
    0.26800683935824376`, -0.006513879641213943}}], 
   InsetBox["\<\"c\"\>", {0.261928535944938, -0.02064832508096613}, 
    ImageScaled[{1, 0}]], 
   CircleBox[{0.9999996666667778, 0.6666667777777407}, 0.04999998333333889], 
   CircleBox[{0.9999996666667778, 0.6666667777777407}, 0.033333322222225924], 
   InsetBox[
    SubscriptBox["\[Mu]", "7"], {0.9999996666667778, 0.6666667777777407}], 
   PolygonBox[{{0.40826272083435605`, 0.3270479856599157}, {
    0.3821011279028267, 0.3443648614104312}, {0.4101787786827165, 
    0.35836302761734534`}}], 
   CircleBox[{0.4356197248114666, 0.996600570660426}, 0.6544277352282023, {
    4.630518319553753, 5.677615870750351}], 
   InsetBox["\<\"b\"\>", {0.7153595339893877, 0.40497459101026356}, 
    ImageScaled[{1, 1}]], 
   CircleBox[{1.0650654242142206, 0.6924823530785615}, 
    0.024999991666669445, {-2.2402825879421435`, 2.995705168040845}], 
   PolygonBox[{{1.064937929343783, 0.6570234739214629}, {1.0495508487491656`, 
    0.6728788449365821}, {1.070975543131995, 0.6782767621140398}}], 
   InsetBox["\<\"c,a\"\>", {1.0742852725359422, 0.6692445825259034}, 
    ImageScaled[{0, 1}]], 
   {RGBColor[0, 0, 0], 
    LineBox[{{0.33333322222225925`, 0.7666667444444185}, {
     0.33333322222225925`, 0.7166667611110796}}], 
    PolygonBox[{{0.33333322222225925`, 0.7166667611110796}, {
     0.31666656111114627`, 0.7416667527777491}, {0.34999988333337223`, 
     0.7416667527777491}}]}},
  AspectRatio->Automatic,
  PlotRange->Automatic]], "Print",
 CellChangeTimes->{3.8205743710112963`*^9, 3.820575906079496*^9, 
  3.820595655423023*^9, 3.8205995818836455`*^9, 3.8206041747437425`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"317d92b5-c12d-45d7-9206-350d314896ad"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{813., 401.1428571428571},
WindowMargins->{{-823.2857142857143, Automatic}, {
  Automatic, 19.285714285714285`}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a8572f35-c064-47f4-a398-4a1b85c180ca"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 42, "Input",ExpressionUUID->"798f5459-a36d-414a-8cae-973c8a8959aa"],
Cell[CellGroupData[{
Cell[785, 27, 357, 8, 65, "Input",ExpressionUUID->"603202cf-4fe8-46de-94bb-782e903e369c"],
Cell[1145, 37, 1025, 29, 48, "Output",ExpressionUUID->"1ab5e522-21bd-4b96-841f-53570b0e2817"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2207, 71, 3296, 80, 159, "Input",ExpressionUUID->"7e877a78-b0d2-431a-b2e6-ca4b1233d0fe"],
Cell[CellGroupData[{
Cell[5528, 155, 368, 6, 33, "Print",ExpressionUUID->"684bbbbd-1b42-43a9-84f4-110b9cc8cb70"],
Cell[5899, 163, 3885, 69, 547, "Print",ExpressionUUID->"0a22fbdf-a356-406a-90ad-2a118ac52cba"],
Cell[9787, 234, 324, 5, 33, "Print",ExpressionUUID->"72b7b708-138b-47cd-a870-8e588421e170"],
Cell[10114, 241, 509, 13, 33, "Print",ExpressionUUID->"12992c7b-5098-4514-8fba-a00262b50aca"],
Cell[10626, 256, 585, 15, 33, "Print",ExpressionUUID->"269f3b4b-a1f2-470b-a856-697087701f91"],
Cell[11214, 273, 585, 15, 33, "Print",ExpressionUUID->"231be659-64a8-4b5d-97d9-523ac563fa18"],
Cell[11802, 290, 585, 15, 33, "Print",ExpressionUUID->"d37adbde-c653-4de9-972b-ccb91c1ee23e"],
Cell[12390, 307, 685, 18, 33, "Print",ExpressionUUID->"5455b2a9-e906-4825-83ce-0bbc25016925"],
Cell[13078, 327, 685, 18, 33, "Print",ExpressionUUID->"0e93cc99-245f-487e-a047-003bfd6608f2"],
Cell[13766, 347, 685, 18, 33, "Print",ExpressionUUID->"22af0089-1460-494a-81f9-9ce420e9eb5b"],
Cell[14454, 367, 769, 20, 33, "Print",ExpressionUUID->"1231e0d6-7d6a-44c3-b6b5-89170cdb3aff"],
Cell[15226, 389, 484, 11, 33, "Print",ExpressionUUID->"002efe33-5fc4-4e9b-aeaf-b597f9901d6d"],
Cell[15713, 402, 770, 19, 33, "Print",ExpressionUUID->"3445a07d-d941-4b4e-909a-c39d477bb771"],
Cell[16486, 423, 1914, 59, 224, "Print",ExpressionUUID->"16135cc6-b4cd-406a-aefd-81ad7445b854"],
Cell[18403, 484, 351, 6, 33, "Print",ExpressionUUID->"9f23841f-c90b-499a-b7de-3c99cb6b2ca3"],
Cell[18757, 492, 9492, 168, 560, "Print",ExpressionUUID->"4596868a-ce25-4947-9fc6-0b0898a6a18b"],
Cell[28252, 662, 360, 6, 33, "Print",ExpressionUUID->"abc71ea5-5f2f-4d30-98ab-e8e635fbb94b"],
Cell[28615, 670, 8458, 149, 544, "Print",ExpressionUUID->"317d92b5-c12d-45d7-9206-350d314896ad"]
}, Open  ]]
}, Open  ]]
}
]
*)

