(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    226915,       4941]
NotebookOptionsPosition[    221776,       4848]
NotebookOutlinePosition[    222237,       4866]
CellTagsIndexPosition[    222194,       4863]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Tipos de grafos", "Text",
 CellChangeTimes->{{3.8111574097768064`*^9, 3.8111574135522747`*^9}},
 TextAlignment->Center,ExpressionUUID->"e6566561-2780-4cb6-83a3-a5b9653662a9"],

Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8111574377187448`*^9, 3.811157446385189*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"b56ec98c-1fee-4998-87ba-2ebb85cc6aac"],

Cell["1. Grafo mariposa:", "Text",
 CellChangeTimes->{{3.8111574259686646`*^9, 3.811157430185275*^9}, 
   3.8111574891351986`*^9, {3.811157612327256*^9, 
   3.8111576131019278`*^9}},ExpressionUUID->"36ace11b-5bb8-4a27-83bd-\
ccf0a503b32c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "GrafoMariposa"}]], "Input",
 CellChangeTimes->{{3.8111619526022463`*^9, 3.8111619559689045`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"5143e5d7-53e1-4a86-b1da-762033ca963b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Crea un grafo mariposa de orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]. Integra la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos mariposa hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoMariposa[n], \
o bien, GrafoMariposa[n, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"GrafoMariposa", "[", 
                    RowBox[{"VilCretas`Private`Grafon_", ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`Grafon", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Grafon", "\[GreaterEqual]", "1"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "analizar", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "analizar", "]"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{"Column", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ButterflyGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl39", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"Valencias", "[", 
                    RowBox[{"ButterflyGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl39", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Cantidad de aristas: \"\>", ",", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"ButterflyGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl39", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", "\<\" = \"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"ButterflyGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl39", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], "]"}], "\[Equal]", "1"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`GVl40", "=", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"ButterflyGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl39", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}], ";", 
                    RowBox[{
                    "VilCretas`Private`GVl40", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"CenterDot", "@@", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"ButterflyGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl39", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Euler: \"\>", ",", 
                    RowBox[{"EulerianGraphQ", "[", 
                    RowBox[{"ButterflyGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl39", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Hamilton: \"\>", ",", 
                    RowBox[{"HamiltonianGraphQ", "[", 
                    RowBox[{"ButterflyGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl39", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl39", ",", "1", 
                    ",", "\<\"Orden del grafo\"\>"}], "}"}], ",", "1", ",", 
                    "VilCretas`Private`Grafon", ",", "1"}], "}"}]}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"ButterflyGraph", "[", 
                    RowBox[{"VilCretas`Private`Grafon", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"analizar", "\[Rule]", "False"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`GrafoMariposa\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Crea un grafo mariposa de orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]. Integra la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos mariposa hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoMariposa[n], \
o bien, GrafoMariposa[n, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Crea un grafo mariposa de orden \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote]. Integra la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos mariposa hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoMariposa[n], \
o bien, GrafoMariposa[n, analizar->True].", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`GrafoMariposa, {VilCretas`GrafoMariposa[
         Pattern[VilCretas`Private`Grafon, 
          Blank[]], 
         OptionsPattern[]] :> If[
         IntegerQ[VilCretas`Private`Grafon], 
         If[VilCretas`Private`Grafon >= 1, 
          If[
           BooleanQ[
            OptionValue[VilCretas`analizar]], 
           If[
            OptionValue[VilCretas`analizar], 
            Print[
             Manipulate[
              Column[{
                ButterflyGraph[
                VilCretas`Private`GVl39, VertexLabels -> "Name", ImagePadding -> 
                 10], 
                VilCretas`Valencias[
                 ButterflyGraph[
                 VilCretas`Private`GVl39, VertexLabels -> "Name", 
                  ImagePadding -> 10]], 
                Row[{"Cantidad de aristas: ", 
                  EdgeCount[
                   ButterflyGraph[
                   VilCretas`Private`GVl39, VertexLabels -> "Name", 
                    ImagePadding -> 10]], " = ", 
                  If[Length[
                    FactorInteger[
                    EdgeCount[
                    ButterflyGraph[
                    VilCretas`Private`GVl39, VertexLabels -> "Name", 
                    ImagePadding -> 10]]]] == 1, 
                   VilCretas`Private`GVl40 = Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    ButterflyGraph[
                    VilCretas`Private`GVl39, VertexLabels -> "Name", 
                    ImagePadding -> 10]]], {1}]; 
                   Part[VilCretas`Private`GVl40, 1], 
                   Apply[CenterDot, 
                    Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    ButterflyGraph[
                    VilCretas`Private`GVl39, VertexLabels -> "Name", 
                    ImagePadding -> 10]]], {1}]]]}], 
                Row[{"Tiene circuitos de Euler: ", 
                  EulerianGraphQ[
                   ButterflyGraph[
                   VilCretas`Private`GVl39, VertexLabels -> "Name", 
                    ImagePadding -> 10]]}], 
                Row[{"Tiene circuitos de Hamilton: ", 
                  HamiltonianGraphQ[
                   ButterflyGraph[
                   VilCretas`Private`GVl39, VertexLabels -> "Name", 
                    ImagePadding -> 10]]}]}], {{
               VilCretas`Private`GVl39, 1, "Orden del grafo"}, 1, 
               VilCretas`Private`Grafon, 1}]], 
            ButterflyGraph[
            VilCretas`Private`Grafon, VertexLabels -> "Name", ImagePadding -> 
             10]]]]]}], "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {VilCretas`analizar -> False}, "Attributes" -> {Protected}, 
    "FullName" -> "VilCretas`GrafoMariposa"], False]]], "Output",
 CellChangeTimes->{
  3.8111619567520323`*^9, {3.811186319667327*^9, 3.811186333445404*^9}},
 CellLabel->"Out[23]=",ExpressionUUID->"83d57ad5-6591-48d6-aa97-2bbe8931ae50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoMariposa", "[", "3", "]"}]], "Input",
 CellChangeTimes->{{3.8111574496519403`*^9, 3.811157482835507*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"03f81cb6-78d2-4e39-b70a-f29870c95e5a"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
       20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}, {
      Null, {{1, 2}, {1, 18}, {2, 3}, {2, 11}, {3, 4}, {3, 8}, {5, 6}, {5, 
       22}, {6, 7}, {6, 15}, {7, 4}, {7, 8}, {9, 10}, {9, 26}, {10, 3}, {10, 
       11}, {11, 12}, {11, 16}, {13, 14}, {13, 30}, {14, 7}, {14, 15}, {15, 
       12}, {15, 16}, {17, 2}, {17, 18}, {18, 19}, {18, 27}, {19, 20}, {19, 
       24}, {21, 6}, {21, 22}, {22, 23}, {22, 31}, {23, 20}, {23, 24}, {25, 
       10}, {25, 26}, {26, 19}, {26, 27}, {27, 28}, {27, 32}, {29, 14}, {29, 
       30}, {30, 23}, {30, 31}, {31, 28}, {31, 32}}}, {
      GraphLayout -> {"GridEmbedding", "Dimension" -> {4, 8}}, ImagePadding -> 
       10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJyFkzsOwyAMQFGzMDJkYMiQ3qA3KGfoESJlztVzhERKvbzyGiSE7Ic/2Oa5
bJ91SCm9zv347mvt7/6ZWl8/tj6nnIXn9p+P0Ju/IvHCj3Heoz/mae/kGbwK
50n/zNt4+Le60g+56a2O5JNw6y952FtfmKfpye/01mfyWbj1hzzsGc/y5Lzz
f5mchU/CKTN+8HrD2X/6q7jPeeX/MJn2rC+55U/O/nIe+T6TWQ/KRfgsvIDz
vs2nybT/jX8A/jdUBQ==
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{1., 1.}, 0.05338164251207729], 
         InsetBox["1", 
          Offset[{2, 2}, {1.0533816425120772, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.05338164251207729], 
         InsetBox["2", 
          Offset[{2, 2}, {1.0533816425120772, 2.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.05338164251207729], 
         InsetBox["3", 
          Offset[{2, 2}, {1.0533816425120772, 3.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.05338164251207729], 
         InsetBox["4", 
          Offset[{2, 2}, {1.0533816425120772, 4.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.05338164251207729], 
         InsetBox["5", 
          Offset[{2, 2}, {2.053381642512077, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.05338164251207729], 
         InsetBox["6", Offset[{2, 2}, {2.053381642512077, 2.053381642512077}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.05338164251207729], 
         InsetBox["7", Offset[{2, 2}, {2.053381642512077, 3.053381642512077}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.05338164251207729], 
         InsetBox["8", Offset[{2, 2}, {2.053381642512077, 4.053381642512077}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.05338164251207729], 
         InsetBox["9", 
          Offset[{2, 2}, {3.053381642512077, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.05338164251207729], 
         InsetBox["10", 
          Offset[{2, 2}, {3.053381642512077, 2.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.05338164251207729], 
         InsetBox["11", 
          Offset[{2, 2}, {3.053381642512077, 3.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.05338164251207729], 
         InsetBox["12", 
          Offset[{2, 2}, {3.053381642512077, 4.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 1.}, 0.05338164251207729], 
         InsetBox["13", 
          Offset[{2, 2}, {4.053381642512077, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.05338164251207729], 
         InsetBox["14", 
          Offset[{2, 2}, {4.053381642512077, 2.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.05338164251207729], 
         InsetBox["15", 
          Offset[{2, 2}, {4.053381642512077, 3.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.05338164251207729], 
         InsetBox["16", 
          Offset[{2, 2}, {4.053381642512077, 4.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{5., 1.}, 0.05338164251207729], 
         InsetBox["17", 
          Offset[{2, 2}, {5.053381642512077, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.05338164251207729], 
         InsetBox["18", 
          Offset[{2, 2}, {5.053381642512077, 2.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{5., 3.}, 0.05338164251207729], 
         InsetBox["19", 
          Offset[{2, 2}, {5.053381642512077, 3.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{5., 4.}, 0.05338164251207729], 
         InsetBox["20", 
          Offset[{2, 2}, {5.053381642512077, 4.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{6., 1.}, 0.05338164251207729], 
         InsetBox["21", 
          Offset[{2, 2}, {6.053381642512077, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{6., 2.}, 0.05338164251207729], 
         InsetBox["22", 
          Offset[{2, 2}, {6.053381642512077, 2.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{6., 3.}, 0.05338164251207729], 
         InsetBox["23", 
          Offset[{2, 2}, {6.053381642512077, 3.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{6., 4.}, 0.05338164251207729], 
         InsetBox["24", 
          Offset[{2, 2}, {6.053381642512077, 4.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{7., 1.}, 0.05338164251207729], 
         InsetBox["25", 
          Offset[{2, 2}, {7.053381642512077, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{7., 2.}, 0.05338164251207729], 
         InsetBox["26", 
          Offset[{2, 2}, {7.053381642512077, 2.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{7., 3.}, 0.05338164251207729], 
         InsetBox["27", 
          Offset[{2, 2}, {7.053381642512077, 3.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{7., 4.}, 0.05338164251207729], 
         InsetBox["28", 
          Offset[{2, 2}, {7.053381642512077, 4.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{8., 1.}, 0.05338164251207729], 
         InsetBox["29", 
          Offset[{2, 2}, {8.053381642512077, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{8., 2.}, 0.05338164251207729], 
         InsetBox["30", 
          Offset[{2, 2}, {8.053381642512077, 2.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{8., 3.}, 0.05338164251207729], 
         InsetBox["31", 
          Offset[{2, 2}, {8.053381642512077, 3.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{8., 4.}, 0.05338164251207729], 
         InsetBox["32", 
          Offset[{2, 2}, {8.053381642512077, 4.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.8111574583995714`*^9, 3.81115748338535*^9}, 
   3.8111814794331446`*^9, {3.8111863227229176`*^9, 3.811186339386692*^9}},
 CellLabel->"Out[25]=",ExpressionUUID->"4e20de31-84e3-453e-b23f-f37c7e94a0db"]
}, Open  ]],

Cell["2. Grafo rueda:", "Text",
 CellChangeTimes->{{3.8111574259686646`*^9, 3.811157430185275*^9}, 
   3.8111574891351986`*^9, {3.8111576157437773`*^9, 
   3.8111576204191833`*^9}},ExpressionUUID->"b02b24ce-31c4-4a7e-8ef2-\
8e0aeb40b746"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "GrafoRueda"}]], "Input",
 CellChangeTimes->{{3.8111619616354356`*^9, 3.811161964769631*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"c087499c-02bb-4cbf-bc5f-f7cef954eb2f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Genera un grafo rueda con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] nodos. Brinda la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos rueda hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoRueda[n], o \
bien, GrafoRueda[n, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"GrafoRueda", "[", 
                    RowBox[{"VilCretas`Private`Grafon_", ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`Grafon", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Grafon", "\[GreaterEqual]", "1"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "analizar", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "analizar", "]"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{"Column", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"WheelGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl41", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"Valencias", "[", 
                    RowBox[{"WheelGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl41", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Cantidad de aristas: \"\>", ",", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"WheelGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl41", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", "\<\" = \"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"WheelGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl41", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], "]"}], "\[Equal]", "1"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`GVl42", "=", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"WheelGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl41", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}], ";", 
                    RowBox[{
                    "VilCretas`Private`GVl42", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"CenterDot", "@@", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"WheelGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl41", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Euler: \"\>", ",", 
                    RowBox[{"EulerianGraphQ", "[", 
                    RowBox[{"WheelGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl41", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Hamilton: \"\>", ",", 
                    RowBox[{"HamiltonianGraphQ", "[", 
                    RowBox[{"WheelGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl41", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl41", ",", "1", 
                    ",", "\<\"Orden del grafo\"\>"}], "}"}], ",", "1", ",", 
                    "VilCretas`Private`Grafon", ",", "1"}], "}"}]}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"WheelGraph", "[", 
                    RowBox[{"VilCretas`Private`Grafon", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"analizar", "\[Rule]", "False"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`GrafoRueda\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Genera un grafo rueda con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] nodos. Brinda la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos rueda hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoRueda[n], o \
bien, GrafoRueda[n, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Genera un grafo rueda con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] nodos. Brinda la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos rueda hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoRueda[n], o \
bien, GrafoRueda[n, analizar->True].", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`GrafoRueda, {VilCretas`GrafoRueda[
         Pattern[VilCretas`Private`Grafon, 
          Blank[]], 
         OptionsPattern[]] :> If[
         IntegerQ[VilCretas`Private`Grafon], 
         If[VilCretas`Private`Grafon >= 1, 
          If[
           BooleanQ[
            OptionValue[VilCretas`analizar]], 
           If[
            OptionValue[VilCretas`analizar], 
            Print[
             Manipulate[
              Column[{
                WheelGraph[
                VilCretas`Private`GVl41, VertexLabels -> "Name", ImagePadding -> 
                 10], 
                VilCretas`Valencias[
                 WheelGraph[
                 VilCretas`Private`GVl41, VertexLabels -> "Name", 
                  ImagePadding -> 10]], 
                Row[{"Cantidad de aristas: ", 
                  EdgeCount[
                   WheelGraph[
                   VilCretas`Private`GVl41, VertexLabels -> "Name", 
                    ImagePadding -> 10]], " = ", 
                  If[Length[
                    FactorInteger[
                    EdgeCount[
                    WheelGraph[
                    VilCretas`Private`GVl41, VertexLabels -> "Name", 
                    ImagePadding -> 10]]]] == 1, 
                   VilCretas`Private`GVl42 = Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    WheelGraph[
                    VilCretas`Private`GVl41, VertexLabels -> "Name", 
                    ImagePadding -> 10]]], {1}]; 
                   Part[VilCretas`Private`GVl42, 1], 
                   Apply[CenterDot, 
                    Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    WheelGraph[
                    VilCretas`Private`GVl41, VertexLabels -> "Name", 
                    ImagePadding -> 10]]], {1}]]]}], 
                Row[{"Tiene circuitos de Euler: ", 
                  EulerianGraphQ[
                   WheelGraph[
                   VilCretas`Private`GVl41, VertexLabels -> "Name", 
                    ImagePadding -> 10]]}], 
                Row[{"Tiene circuitos de Hamilton: ", 
                  HamiltonianGraphQ[
                   WheelGraph[
                   VilCretas`Private`GVl41, VertexLabels -> "Name", 
                    ImagePadding -> 10]]}]}], {{
               VilCretas`Private`GVl41, 1, "Orden del grafo"}, 1, 
               VilCretas`Private`Grafon, 1}]], 
            WheelGraph[
            VilCretas`Private`Grafon, VertexLabels -> "Name", ImagePadding -> 
             10]]]]]}], "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {VilCretas`analizar -> False}, "Attributes" -> {Protected}, 
    "FullName" -> "VilCretas`GrafoRueda"], False]]], "Output",
 CellChangeTimes->{
  3.8111619656019044`*^9, {3.811186325949003*^9, 3.8111863421813264`*^9}},
 CellLabel->"Out[26]=",ExpressionUUID->"07797ba9-8931-4fa9-9837-d04f3d089b4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoRueda", "[", "8", "]"}]], "Input",
 CellChangeTimes->{{3.8111574496519403`*^9, 3.811157482835507*^9}, {
   3.811157628169777*^9, 3.8111576324189105`*^9}, 3.8111578169219155`*^9, 
   3.811162133462352*^9},
 CellLabel->"In[27]:=",ExpressionUUID->"cc8e23bf-3175-4150-95a4-fd6b5a822942"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8}, {Null, 
       SparseArray[
       Automatic, {8, 8}, 0, {
        1, {{0, 7, 10, 13, 16, 19, 22, 25, 28}, {{2}, {3}, {4}, {5}, {6}, {
          7}, {8}, {1}, {3}, {8}, {1}, {2}, {4}, {1}, {3}, {5}, {1}, {4}, {
          6}, {1}, {5}, {7}, {1}, {6}, {8}, {1}, {2}, {7}}}, Pattern}]}, {
      GraphLayout -> "StarEmbedding", ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgA2ImKEYHGS8jWOcYvd8f78r0eEL1mf3o8ttXF/oeOHJ7
f27M6ZV7rrzBkD8HkbcvxSGfBTHffhUO893vsZYeZnlpf/Jt96MFnx/bo8vX
xt5YszHx5B4I7wOGvD9E//4HUP3o/kF3P7o8un509ej+Q+ej+w+dj+4/dD66
/9D56O4DAM0evqo=
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 0.}, 0.02220329551621769], 
         InsetBox["1", {0.013487108431032103, 0.028006269234929312}, 
          ImageScaled[{0.17458719566183128, -0.17572665092681428}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9749279121818235, -0.22252093395631342}, 
          0.02220329551621769], 
         InsetBox["2", {-1.0052331697394785, -0.22943791123356097}, 
          ImageScaled[{1.2311959341363679, 0.6668907004672356}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.43388373911755757, -0.9009688679024187}, 
          0.02220329551621769], 
         InsetBox["3", {-0.4473708475485897, -0.928975137137348}, 
          ImageScaled[{0.8254128043381688, 1.1757266509268143}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.43388373911755884, -0.9009688679024196}, 
          0.02220329551621769], 
         InsetBox["4", {0.4473708475485909, -0.9289751371373489}, 
          ImageScaled[{0.17458719566183162, 1.1757266509268145}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9749279121818237, -0.2225209339563155}, 
          0.02220329551621769], 
         InsetBox["5", {1.0052331697394787, -0.22943791123356305}, 
          ImageScaled[{-0.23119593413636763, 0.6668907004672361}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7818314824680294, 0.6234898018587326}, 
          0.02220329551621769], 
         InsetBox["6", {0.8061344120967977, 0.642870741509557}, ImageScaled[{-0.08637361185102255, 0.03238264860595008}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-7.044813998280222*^-16, 1.}, 0.02220329551621769], 
         InsetBox["7", {-6.418476861114186*^-16, 1.0310846137227048}, 
          ImageScaled[{0.49999999999999833, -0.25}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.7818314824680302, 0.6234898018587351}, 
          0.02220329551621769], 
         InsetBox["8", {-0.8061344120967986, 0.6428707415095596}, 
          ImageScaled[{1.0863736118510223, 0.03238264860594975}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.811157817326132*^9, 3.8111621338687735`*^9, 3.8111815002308774`*^9, {
   3.811186329071905*^9, 3.8111863444528313`*^9}},
 CellLabel->"Out[27]=",ExpressionUUID->"fb0a0d18-af69-4b50-8904-2f1e1a4590cb"]
}, Open  ]],

Cell["3. Grafo estrella:", "Text",
 CellChangeTimes->{{3.8111574259686646`*^9, 3.811157430185275*^9}, 
   3.8111574891351986`*^9, {3.8111576395210896`*^9, 
   3.811157644119377*^9}},ExpressionUUID->"73762aea-c6e3-4b00-8bc2-\
a51df3d74372"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "GrafoEstrella"}]], "Input",
 CellChangeTimes->{{3.811161971318875*^9, 3.8111619746688933`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"6489834e-0608-4ed9-a760-d6d7e5f56d27"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Construye un grafo estrella con \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] nodos. Proporciona la opci\
\[OAcute]n \[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que \
muestra una animaci\[OAcute]n con distintos grafos estrella hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoEstrella[n], \
o bien, GrafoEstrella[n, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"GrafoEstrella", "[", 
                    RowBox[{"VilCretas`Private`Grafon_", ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`Grafon", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Grafon", "\[GreaterEqual]", "1"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "analizar", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "analizar", "]"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{"Column", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StarGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl43", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"Valencias", "[", 
                    RowBox[{"StarGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl43", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Cantidad de aristas: \"\>", ",", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"StarGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl43", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", "\<\" = \"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"StarGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl43", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], "]"}], "\[Equal]", "1"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`GVl44", "=", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"StarGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl43", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}], ";", 
                    RowBox[{
                    "VilCretas`Private`GVl44", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"CenterDot", "@@", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"StarGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl43", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Euler: \"\>", ",", 
                    RowBox[{"EulerianGraphQ", "[", 
                    RowBox[{"StarGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl43", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Hamilton: \"\>", ",", 
                    RowBox[{"HamiltonianGraphQ", "[", 
                    RowBox[{"StarGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl43", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl43", ",", "1", 
                    ",", "\<\"Orden del grafo\"\>"}], "}"}], ",", "1", ",", 
                    "VilCretas`Private`Grafon", ",", "1"}], "}"}]}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"StarGraph", "[", 
                    RowBox[{"VilCretas`Private`Grafon", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"analizar", "\[Rule]", "False"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`GrafoEstrella\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Construye un grafo estrella con \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] nodos. Proporciona la opci\
\[OAcute]n \[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que \
muestra una animaci\[OAcute]n con distintos grafos estrella hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoEstrella[n], \
o bien, GrafoEstrella[n, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Construye un grafo estrella con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] nodos. Proporciona la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos estrella hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoEstrella[n], \
o bien, GrafoEstrella[n, analizar->True].", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`GrafoEstrella, {VilCretas`GrafoEstrella[
         Pattern[VilCretas`Private`Grafon, 
          Blank[]], 
         OptionsPattern[]] :> If[
         IntegerQ[VilCretas`Private`Grafon], 
         If[VilCretas`Private`Grafon >= 1, 
          If[
           BooleanQ[
            OptionValue[VilCretas`analizar]], 
           If[
            OptionValue[VilCretas`analizar], 
            Print[
             Manipulate[
              Column[{
                StarGraph[
                VilCretas`Private`GVl43, VertexLabels -> "Name", ImagePadding -> 
                 10], 
                VilCretas`Valencias[
                 StarGraph[
                 VilCretas`Private`GVl43, VertexLabels -> "Name", 
                  ImagePadding -> 10]], 
                Row[{"Cantidad de aristas: ", 
                  EdgeCount[
                   StarGraph[
                   VilCretas`Private`GVl43, VertexLabels -> "Name", 
                    ImagePadding -> 10]], " = ", 
                  If[Length[
                    FactorInteger[
                    EdgeCount[
                    StarGraph[
                    VilCretas`Private`GVl43, VertexLabels -> "Name", 
                    ImagePadding -> 10]]]] == 1, 
                   VilCretas`Private`GVl44 = Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    StarGraph[
                    VilCretas`Private`GVl43, VertexLabels -> "Name", 
                    ImagePadding -> 10]]], {1}]; 
                   Part[VilCretas`Private`GVl44, 1], 
                   Apply[CenterDot, 
                    Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    StarGraph[
                    VilCretas`Private`GVl43, VertexLabels -> "Name", 
                    ImagePadding -> 10]]], {1}]]]}], 
                Row[{"Tiene circuitos de Euler: ", 
                  EulerianGraphQ[
                   StarGraph[
                   VilCretas`Private`GVl43, VertexLabels -> "Name", 
                    ImagePadding -> 10]]}], 
                Row[{"Tiene circuitos de Hamilton: ", 
                  HamiltonianGraphQ[
                   StarGraph[
                   VilCretas`Private`GVl43, VertexLabels -> "Name", 
                    ImagePadding -> 10]]}]}], {{
               VilCretas`Private`GVl43, 1, "Orden del grafo"}, 1, 
               VilCretas`Private`Grafon, 1}]], 
            StarGraph[
            VilCretas`Private`Grafon, VertexLabels -> "Name", ImagePadding -> 
             10]]]]]}], "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {VilCretas`analizar -> False}, "Attributes" -> {Protected}, 
    "FullName" -> "VilCretas`GrafoEstrella"], False]]], "Output",
 CellChangeTimes->{3.811161975452195*^9, 3.8111863473550463`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"0de50dc3-4966-4527-99a9-57f90785dd22"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoEstrella", "[", "8", "]"}]], "Input",
 CellChangeTimes->{{3.8111574496519403`*^9, 3.811157482835507*^9}, {
   3.8111576479359055`*^9, 3.8111576514019837`*^9}, 3.8111578095189114`*^9, 
   3.811162247601892*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"70351fa6-2b70-4bd0-8364-b18160fcf41d"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8}, {Null, 
       SparseArray[
       Automatic, {8, 8}, 0, {
        1, {{0, 7, 8, 9, 10, 11, 12, 13, 14}, {{2}, {3}, {4}, {5}, {6}, {7}, {
          8}, {1}, {1}, {1}, {1}, {1}, {1}, {1}}}, Pattern}]}, {
      GraphLayout -> "StarEmbedding", ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        LineBox[{{{0., 0.}, {-0.9749279121818235, -0.22252093395631342`}}, {{
         0., 0.}, {-0.43388373911755757`, -0.9009688679024187}}, {{0., 0.}, {
         0.43388373911755884`, -0.9009688679024196}}, {{0., 0.}, {
         0.9749279121818237, -0.2225209339563155}}, {{0., 0.}, {
         0.7818314824680294, 0.6234898018587326}}, {{0., 
         0.}, {-7.044813998280222*^-16, 1.}}, {{0., 0.}, {-0.7818314824680302,
          0.6234898018587351}}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 0.}, 0.02220329551621769], 
         InsetBox["1", {0.013487108431032103, 0.028006269234929312}, 
          ImageScaled[{0.17458719566183128, -0.17572665092681428}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9749279121818235, -0.22252093395631342}, 
          0.02220329551621769], 
         InsetBox["2", {-1.0052331697394785, -0.22943791123356091}, 
          ImageScaled[{1.2311959341363679, 0.666890700467235}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.43388373911755757, -0.9009688679024187}, 
          0.02220329551621769], 
         InsetBox["3", {-0.4473708475485897, -0.928975137137348}, 
          ImageScaled[{0.8254128043381688, 1.1757266509268143}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.43388373911755884, -0.9009688679024196}, 
          0.02220329551621769], 
         InsetBox["4", {0.4473708475485909, -0.9289751371373489}, 
          ImageScaled[{0.17458719566183162, 1.1757266509268145}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9749279121818237, -0.2225209339563155}, 
          0.02220329551621769], 
         InsetBox["5", {1.0052331697394787, -0.22943791123356308}, 
          ImageScaled[{-0.2311959341363674, 0.6668907004672373}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7818314824680294, 0.6234898018587326}, 
          0.02220329551621769], 
         InsetBox["6", {0.8061344120967977, 0.642870741509557}, ImageScaled[{-0.08637361185102255, 0.03238264860595019}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-7.044813998280222*^-16, 1.}, 0.02220329551621769], 
         InsetBox["7", {-7.251144129583054*^-16, 1.0310846137227048}, 
          ImageScaled[{0.5000000000000006, -0.25}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.7818314824680302, 0.6234898018587351}, 
          0.02220329551621769], 
         InsetBox["8", {-0.8061344120967986, 0.6428707415095596}, 
          ImageScaled[{1.0863736118510219, 0.032382648605949194}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.811157806402002*^9, 3.81115780991858*^9}, 
   3.8111622482186637`*^9, 3.811181518521898*^9, 3.811186350194069*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"f68a95ab-2018-481e-b1fa-7814e363d6c3"]
}, Open  ]],

Cell["4. Grafo ciclo:", "Text",
 CellChangeTimes->{{3.8111574259686646`*^9, 3.811157430185275*^9}, 
   3.8111574891351986`*^9, {3.8111576617405033`*^9, 3.8111576659862957`*^9}, {
   3.81115949608875*^9, 3.811159502735647*^9}, {3.811161921574333*^9, 
   3.8111619221028104`*^9}},ExpressionUUID->"596ff703-3ed1-4a83-a774-\
3808f0514595"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "GrafoCiclo"}]], "Input",
 CellChangeTimes->{{3.8111595607390547`*^9, 3.811159573251749*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"1a1668b7-b62a-4a75-ac02-2309c4e1ca99"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Traza un grafo ciclo o circuito con \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] nodos. Proporciona la opci\
\[OAcute]n \[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que \
muestra una animaci\[OAcute]n con distintos grafos ciclo hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoCiclo[n], o \
bien, GrafoCiclo[n, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"GrafoCiclo", "[", 
                    RowBox[{"VilCretas`Private`Grafon_", ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`Grafon", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Grafon", "\[GreaterEqual]", "1"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "analizar", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "analizar", "]"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{"Column", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"CycleGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl47", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"Valencias", "[", 
                    RowBox[{"CycleGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl47", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Cantidad de aristas: \"\>", ",", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"CycleGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl47", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", "\<\" = \"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"CycleGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl47", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], "]"}], "\[Equal]", "1"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`GVl48", "=", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"CycleGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl47", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}], ";", 
                    RowBox[{
                    "VilCretas`Private`GVl48", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"CenterDot", "@@", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"CycleGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl47", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Euler: \"\>", ",", 
                    RowBox[{"EulerianGraphQ", "[", 
                    RowBox[{"CycleGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl47", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Hamilton: \"\>", ",", 
                    RowBox[{"HamiltonianGraphQ", "[", 
                    RowBox[{"CycleGraph", "[", 
                    RowBox[{"VilCretas`Private`GVl47", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl47", ",", "1", 
                    ",", "\<\"Orden del grafo\"\>"}], "}"}], ",", "1", ",", 
                    "VilCretas`Private`Grafon", ",", "1"}], "}"}]}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"CycleGraph", "[", 
                    RowBox[{"VilCretas`Private`Grafon", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"analizar", "\[Rule]", "False"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`GrafoCiclo\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Traza un grafo ciclo o circuito con \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] nodos. Proporciona la opci\
\[OAcute]n \[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que \
muestra una animaci\[OAcute]n con distintos grafos ciclo hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoCiclo[n], o \
bien, GrafoCiclo[n, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Traza un grafo ciclo o circuito con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] nodos. Proporciona la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos ciclo hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoCiclo[n], o \
bien, GrafoCiclo[n, analizar->True].", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`GrafoCiclo, {VilCretas`GrafoCiclo[
         Pattern[VilCretas`Private`Grafon, 
          Blank[]], 
         OptionsPattern[]] :> If[
         IntegerQ[VilCretas`Private`Grafon], 
         If[VilCretas`Private`Grafon >= 1, 
          If[
           BooleanQ[
            OptionValue[VilCretas`analizar]], 
           If[
            OptionValue[VilCretas`analizar], 
            Print[
             Manipulate[
              Column[{
                CycleGraph[
                VilCretas`Private`GVl47, VertexLabels -> "Name", ImagePadding -> 
                 10], 
                VilCretas`Valencias[
                 CycleGraph[
                 VilCretas`Private`GVl47, VertexLabels -> "Name", 
                  ImagePadding -> 10]], 
                Row[{"Cantidad de aristas: ", 
                  EdgeCount[
                   CycleGraph[
                   VilCretas`Private`GVl47, VertexLabels -> "Name", 
                    ImagePadding -> 10]], " = ", 
                  If[Length[
                    FactorInteger[
                    EdgeCount[
                    CycleGraph[
                    VilCretas`Private`GVl47, VertexLabels -> "Name", 
                    ImagePadding -> 10]]]] == 1, 
                   VilCretas`Private`GVl48 = Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    CycleGraph[
                    VilCretas`Private`GVl47, VertexLabels -> "Name", 
                    ImagePadding -> 10]]], {1}]; 
                   Part[VilCretas`Private`GVl48, 1], 
                   Apply[CenterDot, 
                    Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    CycleGraph[
                    VilCretas`Private`GVl47, VertexLabels -> "Name", 
                    ImagePadding -> 10]]], {1}]]]}], 
                Row[{"Tiene circuitos de Euler: ", 
                  EulerianGraphQ[
                   CycleGraph[
                   VilCretas`Private`GVl47, VertexLabels -> "Name", 
                    ImagePadding -> 10]]}], 
                Row[{"Tiene circuitos de Hamilton: ", 
                  HamiltonianGraphQ[
                   CycleGraph[
                   VilCretas`Private`GVl47, VertexLabels -> "Name", 
                    ImagePadding -> 10]]}]}], {{
               VilCretas`Private`GVl47, 1, "Orden del grafo"}, 1, 
               VilCretas`Private`Grafon, 1}]], 
            CycleGraph[
            VilCretas`Private`Grafon, VertexLabels -> "Name", ImagePadding -> 
             10]]]]]}], "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {VilCretas`analizar -> False}, "Attributes" -> {Protected}, 
    "FullName" -> "VilCretas`GrafoCiclo"], False]]], "Output",
 CellChangeTimes->{3.8111595741524143`*^9, 3.8111863534678297`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"c02880bf-edab-491c-abf9-7c9d32c82994"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoCiclo", "[", "8", "]"}]], "Input",
 CellChangeTimes->{{3.8111574496519403`*^9, 3.811157482835507*^9}, {
   3.8111576694354143`*^9, 3.8111576730020866`*^9}, 3.8111578131678443`*^9, 
   3.8111622546354275`*^9},
 CellLabel->"In[31]:=",ExpressionUUID->"b4b36f7c-b335-498a-8e1d-7bbb250360ee"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8}, {Null, 
       SparseArray[
       Automatic, {8, 8}, 0, {
        1, {{0, 2, 4, 6, 8, 10, 12, 14, 16}, {{2}, {8}, {1}, {3}, {2}, {4}, {
          3}, {5}, {4}, {6}, {5}, {7}, {6}, {8}, {1}, {7}}}, Pattern}]}, {
      GraphLayout -> "CircularEmbedding", ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        LineBox[{{{-0.707106781186548, 
         0.7071067811865482}, {-7.044813998280222*^-16, 
         1.}}, {{-0.707106781186548, 0.7071067811865482}, {-1., 
         1.0106430996148606`*^-15}}, {{-7.044813998280222*^-16, 1.}, {
         0.707106781186547, 0.7071067811865467}}, {{0.707106781186547, 
         0.7071067811865467}, {1., -1.133107779529596*^-15}}, {{
         1., -1.133107779529596*^-15}, {
         0.7071067811865481, -0.7071067811865483}}, {{
         0.7071067811865481, -0.7071067811865483}, {
         6.049014748177263*^-16, -1.}}, {{
         6.049014748177263*^-16, -1.}, {-0.7071067811865471, \
-0.7071067811865468}}, {{-0.7071067811865471, -0.7071067811865468}, {-1., 
         1.0106430996148606`*^-15}}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{-0.707106781186548, 0.7071067811865482}, 
          0.02261146496815286], 
         InsetBox["1", 
          Offset[{-1.9999999999999993, 2.}, \
{-0.726406873776396, 0.7264068737763962}], ImageScaled[{0.9999999999999998, 0.}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-7.044813998280222*^-16, 1.}, 0.02261146496815286], 
         InsetBox["2", 
          Offset[{-1.4089627996560444*^-15, 2.}, \
{-7.204107563209488*^-16, 1.0226114649681528}], ImageScaled[{0.5000000000000003, 0.}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.707106781186547, 0.7071067811865467}, 
          0.02261146496815286], 
         InsetBox["3", 
          Offset[{2., 1.9999999999999991}, \
{0.7264068737763949, 0.7264068737763945}], ImageScaled[{0., 2.220446049250313*^-16}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1., -1.133107779529596*^-15}, 0.02261146496815286], 
         InsetBox["4", 
          Offset[{2., -2.266215559059192*^-15}, \
{1.0226114649681528, -1.1587290063915707*^-15}], ImageScaled[{0., 0.5000000000000006}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7071067811865481, -0.7071067811865483}, 
          0.02261146496815286], 
         InsetBox["5", 
          Offset[{1.9999999999999993, -2.}, \
{0.726406873776396, -0.7264068737763962}], ImageScaled[{1.6653345369377348*^-16, 1.}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.049014748177263*^-16, -1.}, 0.02261146496815286], 
         InsetBox["6", 
          Offset[{1.2098029496354525*^-15, -2.}, \
{6.185791833247513*^-16, -1.0226114649681528}], ImageScaled[{0.4999999999999997, 1.}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.7071067811865471, -0.7071067811865468}, 
          0.02261146496815286], 
         InsetBox["7", 
          Offset[{-2., -1.9999999999999991}, \
{-0.726406873776395, -0.7264068737763947}], ImageScaled[{1., 0.9999999999999998}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1., 1.0106430996148606*^-15}, 0.02261146496815286], 
         InsetBox["8", 
          Offset[{-2., 2.021286199229721*^-15}, \
{-1.0226114649681528, 1.0334952206571073*^-15}], ImageScaled[{1., 0.4999999999999995}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.811157803873204*^9, 3.8111578135686264`*^9}, 
   3.811159515776517*^9, 3.811162255068902*^9, {3.8111815366805687`*^9, 
   3.811181551356722*^9}, 3.8111863560606155`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"a09b0a89-e165-47bb-8717-f0e6d74d2f4e"]
}, Open  ]],

Cell["5. Grafo camino:", "Text",
 CellChangeTimes->{{3.8111574259686646`*^9, 3.811157430185275*^9}, 
   3.8111574891351986`*^9, {3.8111576802187147`*^9, 
   3.8111576843852253`*^9}},ExpressionUUID->"bd4d1ece-767b-46c6-a5d3-\
52dbea2967c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "GrafoCamino"}]], "Input",
 CellChangeTimes->{{3.8111596335300894`*^9, 3.8111596390355*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"71909e8d-5c6e-4e9e-b965-60b1a781e2be"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Crea un grafo \[OpenCurlyDoubleQuote]path\
\[CloseCurlyDoubleQuote] o camino con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] nodos. Facilita la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos camino hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoCamino[n], o \
bien, GrafoCamino[n, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"GrafoCamino", "[", 
                    RowBox[{"VilCretas`Private`Grafon_", ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`Grafon", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Grafon", "\[GreaterEqual]", "1"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "analizar", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "analizar", "]"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{"Column", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"PathGraph", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"VilCretas`Private`Gi22", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Gi22", ",", 
                    "VilCretas`Private`GVl45"}], "}"}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"Valencias", "[", 
                    RowBox[{"PathGraph", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"VilCretas`Private`Gi22", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Gi22", ",", 
                    "VilCretas`Private`GVl45"}], "}"}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Cantidad de aristas: \"\>", ",", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"PathGraph", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"VilCretas`Private`Gi22", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Gi22", ",", 
                    "VilCretas`Private`GVl45"}], "}"}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", "\<\" = \"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"PathGraph", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"VilCretas`Private`Gi22", ",", 
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`Gi22", ",", 
                    "VilCretas`Private`GVl45"}], "}"}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], "]"}], "\[Equal]", "1"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`GVl46", "=", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"PathGraph", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"VilCretas`Private`Gi22", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Gi22", ",", 
                    "VilCretas`Private`GVl45"}], "}"}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}], ";", 
                    RowBox[{
                    "VilCretas`Private`GVl46", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"CenterDot", "@@", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"PathGraph", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"VilCretas`Private`Gi22", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Gi22", ",", 
                    "VilCretas`Private`GVl45"}], "}"}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Euler: \"\>", ",", 
                    RowBox[{"EulerianGraphQ", "[", 
                    RowBox[{"PathGraph", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"VilCretas`Private`Gi22", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Gi22", ",", 
                    "VilCretas`Private`GVl45"}], "}"}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Hamilton: \"\>", ",", 
                    RowBox[{"HamiltonianGraphQ", "[", 
                    RowBox[{"PathGraph", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"VilCretas`Private`Gi22", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Gi22", ",", 
                    "VilCretas`Private`GVl45"}], "}"}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl45", ",", "1", 
                    ",", "\<\"Orden del grafo\"\>"}], "}"}], ",", "1", ",", 
                    "VilCretas`Private`Grafon", ",", "1"}], "}"}]}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"PathGraph", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"VilCretas`Private`Gi22", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Gi22", ",", 
                    "VilCretas`Private`Grafon"}], "}"}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"analizar", "\[Rule]", "False"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`GrafoCamino\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Crea un grafo \[OpenCurlyDoubleQuote]path\
\[CloseCurlyDoubleQuote] o camino con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] nodos. Facilita la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos camino hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoCamino[n], o \
bien, GrafoCamino[n, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Crea un grafo \[OpenCurlyDoubleQuote]path\[CloseCurlyDoubleQuote] o \
camino con \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] nodos. Facilita \
la opci\[OAcute]n \[OpenCurlyDoubleQuote]analizar->True\
\[CloseCurlyDoubleQuote] que muestra una animaci\[OAcute]n con distintos \
grafos camino hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en \
cada caso: la valencia de los v\[EAcute]rtices, la cantidad de aristas y, si \
el grafo posee circuitos de Euler y de Hamilton. Sintaxis: GrafoCamino[n], o \
bien, GrafoCamino[n, analizar->True].", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`GrafoCamino, {VilCretas`GrafoCamino[
         Pattern[VilCretas`Private`Grafon, 
          Blank[]], 
         OptionsPattern[]] :> If[
         IntegerQ[VilCretas`Private`Grafon], 
         If[VilCretas`Private`Grafon >= 1, 
          If[
           BooleanQ[
            OptionValue[VilCretas`analizar]], 
           If[
            OptionValue[VilCretas`analizar], 
            Print[
             Manipulate[
              Column[{
                PathGraph[
                 Table[
                 VilCretas`Private`Gi22, {
                  VilCretas`Private`Gi22, VilCretas`Private`GVl45}], 
                 VertexLabels -> "Name", ImagePadding -> 10], 
                VilCretas`Valencias[
                 PathGraph[
                  Table[
                  VilCretas`Private`Gi22, {
                   VilCretas`Private`Gi22, VilCretas`Private`GVl45}], 
                  VertexLabels -> "Name", ImagePadding -> 10]], 
                Row[{"Cantidad de aristas: ", 
                  EdgeCount[
                   PathGraph[
                    Table[
                    VilCretas`Private`Gi22, {
                    VilCretas`Private`Gi22, VilCretas`Private`GVl45}], 
                    VertexLabels -> "Name", ImagePadding -> 10]], " = ", 
                  If[Length[
                    FactorInteger[
                    EdgeCount[
                    PathGraph[
                    Table[
                    VilCretas`Private`Gi22, {
                    VilCretas`Private`Gi22, VilCretas`Private`GVl45}], 
                    VertexLabels -> "Name", ImagePadding -> 10]]]] == 1, 
                   VilCretas`Private`GVl46 = Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    PathGraph[
                    Table[
                    VilCretas`Private`Gi22, {
                    VilCretas`Private`Gi22, VilCretas`Private`GVl45}], 
                    VertexLabels -> "Name", ImagePadding -> 10]]], {1}]; 
                   Part[VilCretas`Private`GVl46, 1], 
                   Apply[CenterDot, 
                    Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    PathGraph[
                    Table[
                    VilCretas`Private`Gi22, {
                    VilCretas`Private`Gi22, VilCretas`Private`GVl45}], 
                    VertexLabels -> "Name", ImagePadding -> 10]]], {1}]]]}], 
                Row[{"Tiene circuitos de Euler: ", 
                  EulerianGraphQ[
                   PathGraph[
                    Table[
                    VilCretas`Private`Gi22, {
                    VilCretas`Private`Gi22, VilCretas`Private`GVl45}], 
                    VertexLabels -> "Name", ImagePadding -> 10]]}], 
                Row[{"Tiene circuitos de Hamilton: ", 
                  HamiltonianGraphQ[
                   PathGraph[
                    Table[
                    VilCretas`Private`Gi22, {
                    VilCretas`Private`Gi22, VilCretas`Private`GVl45}], 
                    VertexLabels -> "Name", ImagePadding -> 10]]}]}], {{
               VilCretas`Private`GVl45, 1, "Orden del grafo"}, 1, 
               VilCretas`Private`Grafon, 1}]], 
            PathGraph[
             Table[
             VilCretas`Private`Gi22, {
              VilCretas`Private`Gi22, VilCretas`Private`Grafon}], 
             VertexLabels -> "Name", ImagePadding -> 10]]]]]}], "SubValues" -> 
    None, "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {VilCretas`analizar -> False}, "Attributes" -> {Protected}, 
    "FullName" -> "VilCretas`GrafoCamino"], False]]], "Output",
 CellChangeTimes->{3.8111596399572563`*^9, 3.8111863589638205`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"1f200dd0-ea2e-41bf-b35b-0ad1959ab9b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoCamino", "[", "25", "]"}]], "Input",
 CellChangeTimes->{{3.8111574496519403`*^9, 3.811157482835507*^9}, {
  3.811157688286379*^9, 3.8111576924021435`*^9}, {3.8111577992188883`*^9, 
  3.8111577993855085`*^9}, {3.8111623431354485`*^9, 3.8111623433356524`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"43fe77b6-5e5a-4011-932a-63a024db7a11"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
       20, 21, 22, 23, 24, 25}, {
      Null, {{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 8}, {8, 9}, {
       9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 14}, {14, 15}, {15, 16}, {
       16, 17}, {17, 18}, {18, 19}, {19, 20}, {20, 21}, {21, 22}, {22, 23}, {
       23, 24}, {24, 25}}}, {ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGCQAGImKIYCB1Sag0g+LpqQvg/2xPEZCPBx0YT0EbJXgEg+
zFxcfA4CfFw0IX2E7CXobgbi+BwE+AwE+PDwx8HHBQjqI2AvIXcj/AkAH4Ip
hQ==
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{2., 2.}, 0.03700564971751412], 
         InsetBox["1", Offset[{2, 2}, {2.037005649717514, 2.037005649717514}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.03700564971751412], 
         InsetBox["2", Offset[{2, 2}, {3.037005649717514, 2.037005649717514}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.03700564971751412], 
         InsetBox["3", Offset[{2, 2}, {3.037005649717514, 3.037005649717514}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.03700564971751412], 
         InsetBox["4", Offset[{2, 2}, {2.037005649717514, 3.037005649717514}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.03700564971751412], 
         InsetBox["5", 
          Offset[{2, 2}, {1.0370056497175142, 3.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.03700564971751412], 
         InsetBox["6", 
          Offset[{2, 2}, {1.0370056497175142, 2.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.03700564971751412], 
         InsetBox["7", 
          Offset[{2, 2}, {1.0370056497175142, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.03700564971751412], 
         InsetBox["8", 
          Offset[{2, 2}, {2.037005649717514, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.03700564971751412], 
         InsetBox["9", 
          Offset[{2, 2}, {3.037005649717514, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 1.}, 0.03700564971751412], 
         InsetBox["10", 
          Offset[{2, 2}, {4.037005649717514, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.03700564971751412], 
         InsetBox["11", 
          Offset[{2, 2}, {4.037005649717514, 2.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.03700564971751412], 
         InsetBox["12", 
          Offset[{2, 2}, {4.037005649717514, 3.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.03700564971751412], 
         InsetBox["13", 
          Offset[{2, 2}, {4.037005649717514, 4.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.03700564971751412], 
         InsetBox["14", 
          Offset[{2, 2}, {3.037005649717514, 4.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.03700564971751412], 
         InsetBox["15", 
          Offset[{2, 2}, {2.037005649717514, 4.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.03700564971751412], 
         InsetBox["16", 
          Offset[{2, 2}, {1.0370056497175142, 4.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 4.}, 0.03700564971751412], 
         InsetBox["17", 
          Offset[{2, 2}, {0.03700564971751412, 4.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.03700564971751412], 
         InsetBox["18", 
          Offset[{2, 2}, {0.03700564971751412, 3.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.03700564971751412], 
         InsetBox["19", 
          Offset[{2, 2}, {0.03700564971751412, 2.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.03700564971751412], 
         InsetBox["20", 
          Offset[{2, 2}, {0.03700564971751412, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.03700564971751412], 
         InsetBox["21", 
          Offset[{2, 2}, {0.03700564971751412, 0.03700564971751412}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.03700564971751412], 
         InsetBox["22", 
          Offset[{2, 2}, {1.0370056497175142, 0.03700564971751412}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.03700564971751412], 
         InsetBox["23", 
          Offset[{2, 2}, {2.037005649717514, 0.03700564971751412}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 0.}, 0.03700564971751412], 
         InsetBox["24", 
          Offset[{2, 2}, {3.037005649717514, 0.03700564971751412}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 0.}, 0.03700564971751412], 
         InsetBox["25", 
          Offset[{2, 2}, {4.037005649717514, 0.03700564971751412}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.811157796450143*^9, 3.8111577998290806`*^9}, 
   3.8111623440354853`*^9, 3.8111815565393877`*^9, 3.811186361637094*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"4de4727c-a5f7-47d3-bb42-e2112f546357"]
}, Open  ]],

Cell["6. Grafo red:", "Text",
 CellChangeTimes->{{3.8111574259686646`*^9, 3.811157430185275*^9}, 
   3.8111574891351986`*^9, {3.8111576956356735`*^9, 3.8111577138186083`*^9}, {
   3.8111577923692226`*^9, 
   3.81115779270207*^9}},ExpressionUUID->"a3151962-e6f1-4c5a-993f-\
1af0645061cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "GrafoRed"}]], "Input",
 CellChangeTimes->{{3.8111596495188494`*^9, 3.8111596545856266`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"b73e2ec5-bd60-4fb6-bef1-9a9c5f5b916e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Traza un grafo red o cuadr\[IAcute]cula con \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] filas y \
\[OpenCurlyDoubleQuote]m\[CloseCurlyDoubleQuote] columnas (\
\[OpenCurlyDoubleQuote]n*m\[CloseCurlyDoubleQuote] nodos). Posee la opci\
\[OAcute]n \[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que \
muestra una animaci\[OAcute]n con distintos grafos red hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] por \[OpenCurlyDoubleQuote]m\
\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en cada caso: la valencia \
de los v\[EAcute]rtices, la cantidad de aristas y, si el grafo posee \
circuitos de Euler y de Hamilton. Sintaxis: GrafoRed[n, m], o bien, \
GrafoRed[n, m, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"GrafoRed", "[", 
                    RowBox[{
                    "VilCretas`Private`Grafon_", ",", 
                    "VilCretas`Private`Grafom_", ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`Grafon", "]"}], "&&", 
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`Grafom", "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Grafon", "\[GreaterEqual]", "1"}], "&&", 
                    RowBox[{
                    "VilCretas`Private`Grafom", "\[GreaterEqual]", "1"}]}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "analizar", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "analizar", "]"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{"Column", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"GridGraph", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl49", ",", 
                    "VilCretas`Private`GVl50"}], "}"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"Valencias", "[", 
                    RowBox[{"GridGraph", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl49", ",", 
                    "VilCretas`Private`GVl50"}], "}"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Cantidad de aristas: \"\>", ",", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"GridGraph", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl49", ",", 
                    "VilCretas`Private`GVl50"}], "}"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", "\<\" = \"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"GridGraph", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilCretas`Private`GVl49", ",", 
                    "VilCretas`Private`GVl50"}], "}"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], "]"}], "\[Equal]", "1"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`GVl51", "=", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"GridGraph", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl49", ",", 
                    "VilCretas`Private`GVl50"}], "}"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}], ";", 
                    RowBox[{
                    "VilCretas`Private`GVl51", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"CenterDot", "@@", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"GridGraph", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl49", ",", 
                    "VilCretas`Private`GVl50"}], "}"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Euler: \"\>", ",", 
                    RowBox[{"EulerianGraphQ", "[", 
                    RowBox[{"GridGraph", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl49", ",", 
                    "VilCretas`Private`GVl50"}], "}"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Hamilton: \"\>", ",", 
                    RowBox[{"HamiltonianGraphQ", "[", 
                    RowBox[{"GridGraph", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl49", ",", 
                    "VilCretas`Private`GVl50"}], "}"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl49", ",", "1", 
                    ",", "\<\"Cantidad de nodos fila\"\>"}], "}"}], ",", "1", 
                    ",", "VilCretas`Private`Grafon", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl50", ",", "1", 
                    ",", "\<\"Cantidad de nodos columna\"\>"}], "}"}], ",", 
                    "1", ",", "VilCretas`Private`Grafom", ",", "1"}], "}"}]}],
                     "]"}], "]"}], ",", 
                    RowBox[{"GridGraph", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Grafon", ",", 
                    "VilCretas`Private`Grafom"}], "}"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"analizar", "\[Rule]", "False"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`GrafoRed\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Traza un grafo red o cuadr\[IAcute]cula con \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] filas y \
\[OpenCurlyDoubleQuote]m\[CloseCurlyDoubleQuote] columnas (\
\[OpenCurlyDoubleQuote]n*m\[CloseCurlyDoubleQuote] nodos). Posee la opci\
\[OAcute]n \[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que \
muestra una animaci\[OAcute]n con distintos grafos red hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] por \[OpenCurlyDoubleQuote]m\
\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en cada caso: la valencia \
de los v\[EAcute]rtices, la cantidad de aristas y, si el grafo posee \
circuitos de Euler y de Hamilton. Sintaxis: GrafoRed[n, m], o bien, \
GrafoRed[n, m, analizar->True].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Traza un grafo red o cuadr\[IAcute]cula con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] filas y \[OpenCurlyDoubleQuote]m\
\[CloseCurlyDoubleQuote] columnas (\[OpenCurlyDoubleQuote]n*m\
\[CloseCurlyDoubleQuote] nodos). Posee la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]analizar->True\[CloseCurlyDoubleQuote] que muestra una \
animaci\[OAcute]n con distintos grafos red hasta el orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] por \[OpenCurlyDoubleQuote]m\
\[CloseCurlyDoubleQuote], indicando adem\[AAcute]s en cada caso: la valencia \
de los v\[EAcute]rtices, la cantidad de aristas y, si el grafo posee \
circuitos de Euler y de Hamilton. Sintaxis: GrafoRed[n, m], o bien, \
GrafoRed[n, m, analizar->True].", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`GrafoRed, {VilCretas`GrafoRed[
         Pattern[VilCretas`Private`Grafon, 
          Blank[]], 
         Pattern[VilCretas`Private`Grafom, 
          Blank[]], 
         OptionsPattern[]] :> If[
         And[
          IntegerQ[VilCretas`Private`Grafon], 
          IntegerQ[VilCretas`Private`Grafom]], 
         If[
          And[VilCretas`Private`Grafon >= 1, VilCretas`Private`Grafom >= 1], 
          If[
           BooleanQ[
            OptionValue[VilCretas`analizar]], 
           If[
            OptionValue[VilCretas`analizar], 
            Print[
             Manipulate[
              Column[{
                
                GridGraph[{VilCretas`Private`GVl49, VilCretas`Private`GVl50}, 
                 VertexLabels -> "Name", ImagePadding -> 10], 
                VilCretas`Valencias[
                 
                 GridGraph[{VilCretas`Private`GVl49, VilCretas`Private`GVl50},
                   VertexLabels -> "Name", ImagePadding -> 10]], 
                Row[{"Cantidad de aristas: ", 
                  EdgeCount[
                   
                   GridGraph[{
                    VilCretas`Private`GVl49, VilCretas`Private`GVl50}, 
                    VertexLabels -> "Name", ImagePadding -> 10]], " = ", 
                  If[Length[
                    FactorInteger[
                    EdgeCount[
                    
                    GridGraph[{
                    VilCretas`Private`GVl49, VilCretas`Private`GVl50}, 
                    VertexLabels -> "Name", ImagePadding -> 10]]]] == 1, 
                   VilCretas`Private`GVl51 = Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    
                    GridGraph[{
                    VilCretas`Private`GVl49, VilCretas`Private`GVl50}, 
                    VertexLabels -> "Name", ImagePadding -> 10]]], {1}]; 
                   Part[VilCretas`Private`GVl51, 1], 
                   Apply[CenterDot, 
                    Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    
                    GridGraph[{
                    VilCretas`Private`GVl49, VilCretas`Private`GVl50}, 
                    VertexLabels -> "Name", ImagePadding -> 10]]], {1}]]]}], 
                Row[{"Tiene circuitos de Euler: ", 
                  EulerianGraphQ[
                   
                   GridGraph[{
                    VilCretas`Private`GVl49, VilCretas`Private`GVl50}, 
                    VertexLabels -> "Name", ImagePadding -> 10]]}], 
                Row[{"Tiene circuitos de Hamilton: ", 
                  HamiltonianGraphQ[
                   
                   GridGraph[{
                    VilCretas`Private`GVl49, VilCretas`Private`GVl50}, 
                    VertexLabels -> "Name", ImagePadding -> 10]]}]}], {{
               VilCretas`Private`GVl49, 1, "Cantidad de nodos fila"}, 1, 
               VilCretas`Private`Grafon, 1}, {{
               VilCretas`Private`GVl50, 1, "Cantidad de nodos columna"}, 1, 
               VilCretas`Private`Grafom, 1}]], 
            
            GridGraph[{VilCretas`Private`Grafon, VilCretas`Private`Grafom}, 
             VertexLabels -> "Name", ImagePadding -> 10]]]]]}], "SubValues" -> 
    None, "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {VilCretas`analizar -> False}, "Attributes" -> {Protected}, 
    "FullName" -> "VilCretas`GrafoRed"], False]]], "Output",
 CellChangeTimes->{3.8111596553521767`*^9, 3.811186364949891*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"9e33427a-8e5b-4d09-a58f-8d3c7fee32be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoRed", "[", 
  RowBox[{"5", ",", "5"}], "]"}]], "Input",
 CellChangeTimes->{{3.8111574496519403`*^9, 3.811157482835507*^9}, {
  3.811157718035286*^9, 3.811157754701852*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"9f660b0b-8dbb-43e2-854c-0528704460d9"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
       20, 21, 22, 23, 24, 25}, {Null, 
       SparseArray[
       Automatic, {25, 25}, 0, {
        1, {{0, 2, 5, 8, 11, 13, 16, 20, 24, 28, 31, 34, 38, 42, 46, 49, 52, 
          56, 60, 64, 67, 69, 72, 75, 78, 80}, {{2}, {6}, {1}, {3}, {7}, {
          2}, {4}, {8}, {3}, {5}, {9}, {4}, {10}, {1}, {7}, {11}, {2}, {6}, {
          8}, {12}, {3}, {7}, {9}, {13}, {4}, {8}, {10}, {14}, {5}, {9}, {
          15}, {6}, {12}, {16}, {7}, {11}, {13}, {17}, {8}, {12}, {14}, {
          18}, {9}, {13}, {15}, {19}, {10}, {14}, {20}, {11}, {17}, {21}, {
          12}, {16}, {18}, {22}, {13}, {17}, {19}, {23}, {14}, {18}, {20}, {
          24}, {15}, {19}, {25}, {16}, {22}, {17}, {21}, {23}, {18}, {22}, {
          24}, {19}, {23}, {25}, {20}, {24}}}, Pattern}]}, {
      GraphLayout -> {"GridEmbedding", "Dimension" -> {5, 5}}, ImagePadding -> 
       10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGDQAGImKIaAD/bYaQYHysQ5HLDLo9O41AvgkIfpI6ReBIc8
TD8u9TB5dD65/sClHt0/pIqj+4cDB41LPbr/YPIcBNRz4OCTG0+41BPrD1zq
0f1Dqji6/wRw0OjqBXDwSU2HhNQTiidC6gn5g5B6dP8RK46LJjYfEkqHhOIB
YS8Axo5Hhw==
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{1., 1.}, 0.03700564971751412], 
         InsetBox["1", 
          Offset[{2, 2}, {1.0370056497175142, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.03700564971751412], 
         InsetBox["2", 
          Offset[{2, 2}, {1.0370056497175142, 2.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.03700564971751412], 
         InsetBox["3", 
          Offset[{2, 2}, {1.0370056497175142, 3.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.03700564971751412], 
         InsetBox["4", 
          Offset[{2, 2}, {1.0370056497175142, 4.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 5.}, 0.03700564971751412], 
         InsetBox["5", 
          Offset[{2, 2}, {1.0370056497175142, 5.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.03700564971751412], 
         InsetBox["6", 
          Offset[{2, 2}, {2.037005649717514, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 2.}, 0.03700564971751412], 
         InsetBox["7", Offset[{2, 2}, {2.037005649717514, 2.037005649717514}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 3.}, 0.03700564971751412], 
         InsetBox["8", Offset[{2, 2}, {2.037005649717514, 3.037005649717514}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 4.}, 0.03700564971751412], 
         InsetBox["9", Offset[{2, 2}, {2.037005649717514, 4.037005649717514}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 5.}, 0.03700564971751412], 
         InsetBox["10", 
          Offset[{2, 2}, {2.037005649717514, 5.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.03700564971751412], 
         InsetBox["11", 
          Offset[{2, 2}, {3.037005649717514, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 2.}, 0.03700564971751412], 
         InsetBox["12", 
          Offset[{2, 2}, {3.037005649717514, 2.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 3.}, 0.03700564971751412], 
         InsetBox["13", 
          Offset[{2, 2}, {3.037005649717514, 3.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 4.}, 0.03700564971751412], 
         InsetBox["14", 
          Offset[{2, 2}, {3.037005649717514, 4.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 5.}, 0.03700564971751412], 
         InsetBox["15", 
          Offset[{2, 2}, {3.037005649717514, 5.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 1.}, 0.03700564971751412], 
         InsetBox["16", 
          Offset[{2, 2}, {4.037005649717514, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 2.}, 0.03700564971751412], 
         InsetBox["17", 
          Offset[{2, 2}, {4.037005649717514, 2.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 3.}, 0.03700564971751412], 
         InsetBox["18", 
          Offset[{2, 2}, {4.037005649717514, 3.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 4.}, 0.03700564971751412], 
         InsetBox["19", 
          Offset[{2, 2}, {4.037005649717514, 4.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{4., 5.}, 0.03700564971751412], 
         InsetBox["20", 
          Offset[{2, 2}, {4.037005649717514, 5.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{5., 1.}, 0.03700564971751412], 
         InsetBox["21", 
          Offset[{2, 2}, {5.037005649717514, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.03700564971751412], 
         InsetBox["22", 
          Offset[{2, 2}, {5.037005649717514, 2.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{5., 3.}, 0.03700564971751412], 
         InsetBox["23", 
          Offset[{2, 2}, {5.037005649717514, 3.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{5., 4.}, 0.03700564971751412], 
         InsetBox["24", 
          Offset[{2, 2}, {5.037005649717514, 4.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{5., 5.}, 0.03700564971751412], 
         InsetBox["25", 
          Offset[{2, 2}, {5.037005649717514, 5.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.8111577488356075`*^9, 3.8111577551854496`*^9}, 
   3.8111815753590484`*^9, 3.8111863676119556`*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"8084c9d3-ffb6-405f-8014-f604c133e1e0"]
}, Open  ]],

Cell["7. Grafo regular:", "Text",
 CellChangeTimes->{{3.8111574259686646`*^9, 3.811157430185275*^9}, 
   3.8111574891351986`*^9, {3.811157745052046*^9, 3.811157745618551*^9}, {
   3.8111591259686594`*^9, 
   3.811159127229601*^9}},ExpressionUUID->"8dc977b2-6fc2-4cb1-94e7-\
9edd16be5f9c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "GrafoRegular"}]], "Input",
 CellChangeTimes->{{3.811159662035533*^9, 3.811159667052144*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"b4a02fd7-d8bb-4056-a69d-5f7ee0f3aeeb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Crea si existe, un grafo seudoaleatorio regular de \
orden \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] con \
\[OpenCurlyDoubleQuote]m\[CloseCurlyDoubleQuote] nodos. Un grafo es regular \
si es no dirigido donde todos los v\[EAcute]rtices tienen la misma valencia \
(valor que corresponde a su grado u orden). Sintaxis: GrafoRegular[n, \
m].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"GrafoRegular", "[", 
                    RowBox[{
                    "VilCretas`Private`Grafon_", ",", 
                    "VilCretas`Private`Grafom_"}], "]"}], ":=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`Grafon", "]"}], "&&", 
                    RowBox[{
                    "IntegerQ", "[", "VilCretas`Private`Grafom", "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Grafon", "\[GreaterEqual]", "0"}], "&&", 
                    RowBox[{
                    "VilCretas`Private`Grafom", "\[GreaterEqual]", "1"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`GGrafoAuxiliar18", "=", 
                    RowBox[{"RandomGraph", "[", 
                    RowBox[{
                    RowBox[{"DegreeGraphDistribution", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{"VilCretas`Private`Grafon", ",", 
                    RowBox[{"{", "VilCretas`Private`Grafom", "}"}]}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "GrafoQ", "[", "VilCretas`Private`GGrafoAuxiliar18", 
                    "]"}], ",", "VilCretas`Private`GGrafoAuxiliar18", 
                    ",", "\<\"NaD\"\>"}], "]"}]}]}], "]"}]}], "]"}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`GrafoRegular\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Crea si existe, un grafo seudoaleatorio regular de \
orden \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] con \
\[OpenCurlyDoubleQuote]m\[CloseCurlyDoubleQuote] nodos. Un grafo es regular \
si es no dirigido donde todos los v\[EAcute]rtices tienen la misma valencia \
(valor que corresponde a su grado u orden). Sintaxis: GrafoRegular[n, \
m].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Crea si existe, un grafo seudoaleatorio regular de orden \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] con \[OpenCurlyDoubleQuote]m\
\[CloseCurlyDoubleQuote] nodos. Un grafo es regular si es no dirigido donde \
todos los v\[EAcute]rtices tienen la misma valencia (valor que corresponde a \
su grado u orden). Sintaxis: GrafoRegular[n, m].", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`GrafoRegular, {VilCretas`GrafoRegular[
         Pattern[VilCretas`Private`Grafon, 
          Blank[]], 
         Pattern[VilCretas`Private`Grafom, 
          Blank[]]] :> Quiet[
         If[
          And[
           IntegerQ[VilCretas`Private`Grafon], 
           IntegerQ[VilCretas`Private`Grafom]], 
          If[
           And[VilCretas`Private`Grafon >= 0, VilCretas`Private`Grafom >= 1], 
           VilCretas`Private`GGrafoAuxiliar18 = RandomGraph[
              DegreeGraphDistribution[
               Table[VilCretas`Private`Grafon, {VilCretas`Private`Grafom}]], 
              VertexLabels -> "Name", ImagePadding -> 10]; If[
             VilCretas`GrafoQ[VilCretas`Private`GGrafoAuxiliar18], 
             VilCretas`Private`GGrafoAuxiliar18, "NaD"]]]]}], "SubValues" -> 
    None, "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilCretas`GrafoRegular"], False]]], "Output",
 CellChangeTimes->{3.811159667885293*^9, 3.811186370977463*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"3f989e9c-7c8b-4e90-bc5e-4c5bc43dd2c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoRegular", "[", 
  RowBox[{"3", ",", "6"}], "]"}]], "Input",
 CellChangeTimes->{{3.8111574496519403`*^9, 3.811157482835507*^9}, {
  3.8111591334856277`*^9, 3.811159163852214*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"f9719b4b-3eaf-43aa-af41-7463ab213fb0"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6}, {
      Null, {{6, 5}, {6, 1}, {3, 4}, {2, 3}, {2, 1}, {3, 6}, {4, 5}, {1, 4}, {
       2, 5}}}, {ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        LineBox[{{{1.5339325752411526`, 0.39369236950510456`}, {
         0.8573285388728892, 0.}}, {{1.5339325752411526`, 
         0.39369236950510456`}, {0.8565847679438449, 1.4651064939674903`}}, {{
         1.5339325752411526`, 0.39369236950510456`}, {0.7521515840680372, 
         0.7323844577632311}}, {{0.8573285388728892, 0.}, {
         1.5340747585494838`, 1.0717069567173478`}}, {{0.8573285388728892, 
         0.}, {0., 0.7322401208110914}}, {{1.5340747585494838`, 
         1.0717069567173478`}, {0.8565847679438449, 1.4651064939674903`}}, {{
         1.5340747585494838`, 1.0717069567173478`}, {0.7521515840680372, 
         0.7323844577632311}}, {{0.8565847679438449, 1.4651064939674903`}, {
         0., 0.7322401208110914}}, {{0., 0.7322401208110914}, {
         0.7521515840680372, 0.7323844577632311}}}]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.5339325752411526, 0.39369236950510456}, 
          0.018715361339710884], 
         InsetBox["1", 
          Offset[{2, 2}, {1.5526479365808634, 0.4124077308448154}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8573285388728892, 0.}, 0.018715361339710884], 
         InsetBox["2", 
          Offset[{2, 2}, {0.8760439002126, 0.018715361339710884}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.5340747585494838, 1.0717069567173478}, 
          0.018715361339710884], 
         InsetBox["3", 
          Offset[{2, 2}, {1.5527901198891947, 1.0904223180570587}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8565847679438449, 1.4651064939674903}, 
          0.018715361339710884], 
         InsetBox["4", 
          Offset[{2, 2}, {0.8753001292835557, 1.4838218553072011}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.7322401208110914}, 0.018715361339710884], 
         InsetBox["5", 
          Offset[{2, 2}, {0.018715361339710884, 0.7509554821508022}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7521515840680372, 0.7323844577632311}, 
          0.018715361339710884], 
         InsetBox["6", Offset[{2, 2}, {0.770866945407748, 0.751099819102942}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.811159141918748*^9, 3.811159169802393*^9}, {
  3.8111816006294794`*^9, 3.811181607268943*^9}, {3.811186373816239*^9, 
  3.811186393570043*^9}},
 CellLabel->"Out[47]=",ExpressionUUID->"d696b0ea-6de5-49f6-a31f-07a968609722"]
}, Open  ]],

Cell["8. Grafo dodecaedro:", "Text",
 CellChangeTimes->{{3.8111574259686646`*^9, 3.811157430185275*^9}, 
   3.8111574891351986`*^9, {3.8111591914697895`*^9, 
   3.811159206435968*^9}},ExpressionUUID->"73bb8856-47b2-46e5-8a33-\
7b095c7651c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "GrafoDato"}]], "Input",
 CellChangeTimes->{{3.8111596773519077`*^9, 3.811159684785329*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"622ba4a4-7e07-4d84-b917-a4dd14dc3bf9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Genera una animaci\[OAcute]n para analizar un grafo \
de alguno de los siguientes tipos: \[OpenCurlyDoubleQuote]ChvatalGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]CubicalGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]DodecahedralGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]FranklinGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]FruchtGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]GroetzschGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]HeawoodGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]HerschelGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]IcosahedralGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]LeviGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]McGeeGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]NoPerfectMatchingGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]OctahedralGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]PetersenGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]RobertsonGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]SmallestCyclicGroupGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]TetrahedralGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]TutteGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]UniquelyThreeColorableGraph\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]WaltherGraph\
\[CloseCurlyDoubleQuote]. El usuario selecciona el tipo de grafo de un \
\[OpenCurlyDoubleQuote]combo\[CloseCurlyDoubleQuote] suministrado y se \
muestra en cada caso: el grafo, la valencia de los v\[EAcute]rtices, la \
cantidad de aristas y, si posee circuitos de Euler y de Hamilton. Tambi\
\[EAcute]n, se brinda la opci\[OAcute]n \[OpenCurlyDoubleQuote]tipo->G\
\[CloseCurlyDoubleQuote] la cual permite construir el grafo especificado en \
\[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote], siendo \
\[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote] un \
\[OpenCurlyDoubleQuote]string\[CloseCurlyDoubleQuote] que contiene el nombre \
correspondiente de alguno de los citados anteriormente. Sintaxis: \
GrafoDato[], o bien, GrafoDato[tipo->G].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"GrafoDato", "[", 
                    RowBox[{"OptionsPattern", "[", "]"}], "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", 
                    RowBox[{"OptionValue", "[", "tipo", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "tipo", "]"}], 
                    "\[Equal]", "\<\"\"\>"}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{"Column", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Graph", "[", 
                    RowBox[{
                    RowBox[{
                    "GraphData", "[", "VilCretas`Private`GVl54", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"Valencias", "[", 
                    RowBox[{"Graph", "[", 
                    RowBox[{
                    RowBox[{
                    "GraphData", "[", "VilCretas`Private`GVl54", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Cantidad de aristas: \"\>", ",", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"Graph", "[", 
                    RowBox[{
                    RowBox[{
                    "GraphData", "[", "VilCretas`Private`GVl54", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     ",", "\<\" = \"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"Graph", "[", 
                    RowBox[{
                    RowBox[{
                    "GraphData", "[", "VilCretas`Private`GVl54", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], "]"}], "\[Equal]", "1"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`GVl55", "=", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"Graph", "[", 
                    RowBox[{
                    RowBox[{
                    "GraphData", "[", "VilCretas`Private`GVl54", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}], ";", 
                    RowBox[{
                    "VilCretas`Private`GVl55", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"CenterDot", "@@", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Superscript", ",", 
                    RowBox[{"FactorInteger", "[", 
                    RowBox[{"EdgeCount", "[", 
                    RowBox[{"Graph", "[", 
                    RowBox[{
                    RowBox[{
                    "GraphData", "[", "VilCretas`Private`GVl54", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}],
                     "]"}], ",", 
                    RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Euler: \"\>", ",", 
                    RowBox[{"EulerianGraphQ", "[", 
                    RowBox[{"Graph", "[", 
                    RowBox[{
                    RowBox[{
                    "GraphData", "[", "VilCretas`Private`GVl54", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\<\"Tiene circuitos de Hamilton: \"\>", ",", 
                    RowBox[{"HamiltonianGraphQ", "[", 
                    RowBox[{"Graph", "[", 
                    RowBox[{
                    RowBox[{
                    "GraphData", "[", "VilCretas`Private`GVl54", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], 
                    "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`GVl54", ",", "\<\"ChvatalGraph\"\>", 
                    ",", "\<\"Tipo de grafo\"\>"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"\<\"ChvatalGraph\"\>", 
                    ",", "\<\"CubicalGraph\"\>", 
                    ",", "\<\"DodecahedralGraph\"\>", 
                    ",", "\<\"FranklinGraph\"\>", ",", "\<\"FruchtGraph\"\>", 
                    ",", "\<\"GroetzschGraph\"\>", 
                    ",", "\<\"HeawoodGraph\"\>", ",", "\<\"HerschelGraph\"\>",
                     ",", "\<\"IcosahedralGraph\"\>", 
                    ",", "\<\"LeviGraph\"\>", ",", "\<\"McGeeGraph\"\>", 
                    ",", "\<\"NoPerfectMatchingGraph\"\>", 
                    ",", "\<\"OctahedralGraph\"\>", 
                    ",", "\<\"PetersenGraph\"\>", 
                    ",", "\<\"RobertsonGraph\"\>", 
                    ",", "\<\"SmallestCyclicGroupGraph\"\>", 
                    ",", "\<\"TetrahedralGraph\"\>", 
                    ",", "\<\"TutteGraph\"\>", 
                    ",", "\<\"UniquelyThreeColorableGraph\"\>", 
                    ",", "\<\"WaltherGraph\"\>"}], "}"}]}], "}"}]}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"\<\"ChvatalGraph\"\>", 
                    ",", "\<\"CubicalGraph\"\>", 
                    ",", "\<\"DodecahedralGraph\"\>", 
                    ",", "\<\"FranklinGraph\"\>", ",", "\<\"FruchtGraph\"\>", 
                    ",", "\<\"GroetzschGraph\"\>", 
                    ",", "\<\"HeawoodGraph\"\>", ",", "\<\"HerschelGraph\"\>",
                     ",", "\<\"IcosahedralGraph\"\>", 
                    ",", "\<\"LeviGraph\"\>", ",", "\<\"McGeeGraph\"\>", 
                    ",", "\<\"NoPerfectMatchingGraph\"\>", 
                    ",", "\<\"OctahedralGraph\"\>", 
                    ",", "\<\"PetersenGraph\"\>", 
                    ",", "\<\"RobertsonGraph\"\>", 
                    ",", "\<\"SmallestCyclicGroupGraph\"\>", 
                    ",", "\<\"TetrahedralGraph\"\>", 
                    ",", "\<\"TutteGraph\"\>", 
                    ",", "\<\"UniquelyThreeColorableGraph\"\>", 
                    ",", "\<\"WaltherGraph\"\>"}], "}"}], ",", 
                    RowBox[{"OptionValue", "[", "tipo", "]"}]}], "]"}], ",", 
                    RowBox[{"Graph", "[", 
                    RowBox[{
                    RowBox[{"GraphData", "[", 
                    RowBox[{"OptionValue", "[", "tipo", "]"}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\<\"Name\"\>"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"tipo", "\[Rule]", "\<\"\"\>"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`GrafoDato\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Genera una animaci\[OAcute]n para analizar un grafo \
de alguno de los siguientes tipos: \[OpenCurlyDoubleQuote]ChvatalGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]CubicalGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]DodecahedralGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]FranklinGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]FruchtGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]GroetzschGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]HeawoodGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]HerschelGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]IcosahedralGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]LeviGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]McGeeGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]NoPerfectMatchingGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]OctahedralGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]PetersenGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]RobertsonGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]SmallestCyclicGroupGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]TetrahedralGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]TutteGraph\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]UniquelyThreeColorableGraph\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]WaltherGraph\
\[CloseCurlyDoubleQuote]. El usuario selecciona el tipo de grafo de un \
\[OpenCurlyDoubleQuote]combo\[CloseCurlyDoubleQuote] suministrado y se \
muestra en cada caso: el grafo, la valencia de los v\[EAcute]rtices, la \
cantidad de aristas y, si posee circuitos de Euler y de Hamilton. Tambi\
\[EAcute]n, se brinda la opci\[OAcute]n \[OpenCurlyDoubleQuote]tipo->G\
\[CloseCurlyDoubleQuote] la cual permite construir el grafo especificado en \
\[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote], siendo \
\[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote] un \
\[OpenCurlyDoubleQuote]string\[CloseCurlyDoubleQuote] que contiene el nombre \
correspondiente de alguno de los citados anteriormente. Sintaxis: \
GrafoDato[], o bien, GrafoDato[tipo->G].\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Genera una animaci\[OAcute]n para analizar un grafo de alguno de los \
siguientes tipos: \
\[OpenCurlyDoubleQuote]ChvatalGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]CubicalGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]DodecahedralGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]FranklinGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]FruchtGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]GroetzschGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]HeawoodGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]HerschelGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]IcosahedralGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]LeviGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]McGeeGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]NoPerfectMatchingGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]OctahedralGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]PetersenGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]RobertsonGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]SmallestCyclicGroupGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]TetrahedralGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]TutteGraph\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]UniquelyThreeColorableGraph\[CloseCurlyDoubleQuote] y \
\[OpenCurlyDoubleQuote]WaltherGraph\[CloseCurlyDoubleQuote]. El usuario \
selecciona el tipo de grafo de un \[OpenCurlyDoubleQuote]combo\
\[CloseCurlyDoubleQuote] suministrado y se muestra en cada caso: el grafo, la \
valencia de los v\[EAcute]rtices, la cantidad de aristas y, si posee \
circuitos de Euler y de Hamilton. Tambi\[EAcute]n, se brinda la \
opci\[OAcute]n \[OpenCurlyDoubleQuote]tipo->G\[CloseCurlyDoubleQuote] la cual \
permite construir el grafo especificado en \[OpenCurlyDoubleQuote]G\
\[CloseCurlyDoubleQuote], siendo \[OpenCurlyDoubleQuote]G\
\[CloseCurlyDoubleQuote] un \[OpenCurlyDoubleQuote]string\
\[CloseCurlyDoubleQuote] que contiene el nombre correspondiente de alguno de \
los citados anteriormente. Sintaxis: GrafoDato[], o bien, \
GrafoDato[tipo->G].", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`GrafoDato, {VilCretas`GrafoDato[
         OptionsPattern[]] :> If[
         StringQ[
          OptionValue[VilCretas`tipo]], 
         If[OptionValue[VilCretas`tipo] == "", 
          Print[
           Manipulate[
            Column[{
              Graph[
               GraphData[VilCretas`Private`GVl54], VertexLabels -> "Name", 
               ImagePadding -> 10], 
              VilCretas`Valencias[
               Graph[
                GraphData[VilCretas`Private`GVl54], VertexLabels -> "Name", 
                ImagePadding -> 10]], 
              Row[{"Cantidad de aristas: ", 
                EdgeCount[
                 Graph[
                  GraphData[VilCretas`Private`GVl54], VertexLabels -> "Name", 
                  ImagePadding -> 10]], " = ", 
                If[Length[
                   FactorInteger[
                    EdgeCount[
                    Graph[
                    GraphData[VilCretas`Private`GVl54], VertexLabels -> 
                    "Name", ImagePadding -> 10]]]] == 1, 
                 VilCretas`Private`GVl55 = Apply[Superscript, 
                    FactorInteger[
                    EdgeCount[
                    Graph[
                    GraphData[VilCretas`Private`GVl54], VertexLabels -> 
                    "Name", ImagePadding -> 10]]], {1}]; 
                 Part[VilCretas`Private`GVl55, 1], 
                 Apply[CenterDot, 
                  Apply[Superscript, 
                   FactorInteger[
                    EdgeCount[
                    Graph[
                    GraphData[VilCretas`Private`GVl54], VertexLabels -> 
                    "Name", ImagePadding -> 10]]], {1}]]]}], 
              Row[{"Tiene circuitos de Euler: ", 
                EulerianGraphQ[
                 Graph[
                  GraphData[VilCretas`Private`GVl54], VertexLabels -> "Name", 
                  ImagePadding -> 10]]}], 
              Row[{"Tiene circuitos de Hamilton: ", 
                HamiltonianGraphQ[
                 Graph[
                  GraphData[VilCretas`Private`GVl54], VertexLabels -> "Name", 
                  ImagePadding -> 10]]}]}], {{
             VilCretas`Private`GVl54, "ChvatalGraph", "Tipo de grafo"}, {
             "ChvatalGraph", "CubicalGraph", "DodecahedralGraph", 
              "FranklinGraph", "FruchtGraph", "GroetzschGraph", 
              "HeawoodGraph", "HerschelGraph", "IcosahedralGraph", 
              "LeviGraph", "McGeeGraph", "NoPerfectMatchingGraph", 
              "OctahedralGraph", "PetersenGraph", "RobertsonGraph", 
              "SmallestCyclicGroupGraph", "TetrahedralGraph", "TutteGraph", 
              "UniquelyThreeColorableGraph", "WaltherGraph"}}]], 
          If[
           
           MemberQ[{
            "ChvatalGraph", "CubicalGraph", "DodecahedralGraph", 
             "FranklinGraph", "FruchtGraph", "GroetzschGraph", "HeawoodGraph",
              "HerschelGraph", "IcosahedralGraph", "LeviGraph", "McGeeGraph", 
             "NoPerfectMatchingGraph", "OctahedralGraph", "PetersenGraph", 
             "RobertsonGraph", "SmallestCyclicGroupGraph", "TetrahedralGraph",
              "TutteGraph", "UniquelyThreeColorableGraph", "WaltherGraph"}, 
            OptionValue[VilCretas`tipo]], 
           Graph[
            GraphData[
             OptionValue[VilCretas`tipo]], VertexLabels -> "Name", 
            ImagePadding -> 10]]]]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {VilCretas`tipo -> ""}, "Attributes" -> {Protected}, 
    "FullName" -> "VilCretas`GrafoDato"], False]]], "Output",
 CellChangeTimes->{3.811159685918547*^9, 3.8111863973948793`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"64a332d4-e99f-4513-a6c5-df8e19ddb565"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoDato", "[", "]"}]], "Input",
 CellChangeTimes->{{3.811159324805702*^9, 3.8111593843360615`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"1b6a74f4-fc28-45f0-9644-5ba54f5fdd97"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`GVl54$$ = "ChvatalGraph", 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`GVl54$$], "ChvatalGraph", "Tipo de grafo"}, {
      "ChvatalGraph", "CubicalGraph", "DodecahedralGraph", "FranklinGraph", 
       "FruchtGraph", "GroetzschGraph", "HeawoodGraph", "HerschelGraph", 
       "IcosahedralGraph", "LeviGraph", "McGeeGraph", 
       "NoPerfectMatchingGraph", "OctahedralGraph", "PetersenGraph", 
       "RobertsonGraph", "SmallestCyclicGroupGraph", "TetrahedralGraph", 
       "TutteGraph", "UniquelyThreeColorableGraph", "WaltherGraph"}}}, 
    Typeset`size$$ = {1148., {281.34999999999997`, 293.84999999999997`}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {VilCretas`Private`GVl54$$ = "ChvatalGraph"}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         Graph[
          GraphData[VilCretas`Private`GVl54$$], VertexLabels -> "Name", 
          ImagePadding -> 10], 
         VilCretas`Valencias[
          Graph[
           GraphData[VilCretas`Private`GVl54$$], VertexLabels -> "Name", 
           ImagePadding -> 10]], 
         Row[{"Cantidad de aristas: ", 
           EdgeCount[
            Graph[
             GraphData[VilCretas`Private`GVl54$$], VertexLabels -> "Name", 
             ImagePadding -> 10]], " = ", 
           If[Length[
              FactorInteger[
               EdgeCount[
                Graph[
                 GraphData[VilCretas`Private`GVl54$$], VertexLabels -> "Name",
                  ImagePadding -> 10]]]] == 1, 
            VilCretas`Private`GVl55 = Apply[Superscript, 
               FactorInteger[
                EdgeCount[
                 Graph[
                  GraphData[VilCretas`Private`GVl54$$], VertexLabels -> 
                  "Name", ImagePadding -> 10]]], {1}]; 
            Part[VilCretas`Private`GVl55, 1], 
            Apply[CenterDot, 
             Apply[Superscript, 
              FactorInteger[
               EdgeCount[
                Graph[
                 GraphData[VilCretas`Private`GVl54$$], VertexLabels -> "Name",
                  ImagePadding -> 10]]], {1}]]]}], 
         Row[{"Tiene circuitos de Euler: ", 
           EulerianGraphQ[
            Graph[
             GraphData[VilCretas`Private`GVl54$$], VertexLabels -> "Name", 
             ImagePadding -> 10]]}], 
         Row[{"Tiene circuitos de Hamilton: ", 
           HamiltonianGraphQ[
            Graph[
             GraphData[VilCretas`Private`GVl54$$], VertexLabels -> "Name", 
             ImagePadding -> 10]]}]}], 
      "Specifications" :> {{{
         VilCretas`Private`GVl54$$, "ChvatalGraph", "Tipo de grafo"}, {
         "ChvatalGraph", "CubicalGraph", "DodecahedralGraph", "FranklinGraph",
           "FruchtGraph", "GroetzschGraph", "HeawoodGraph", "HerschelGraph", 
          "IcosahedralGraph", "LeviGraph", "McGeeGraph", 
          "NoPerfectMatchingGraph", "OctahedralGraph", "PetersenGraph", 
          "RobertsonGraph", "SmallestCyclicGroupGraph", "TetrahedralGraph", 
          "TutteGraph", "UniquelyThreeColorableGraph", "WaltherGraph"}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{1244., {369.75, 382.25}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.811159385147909*^9, 3.8111816304647136`*^9, 
  3.8111864017012835`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"107ac146-975e-4549-a4e5-2241270372ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoDato", "[", 
  RowBox[{"tipo", "\[Rule]", "\"\<DodecahedralGraph\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.811159324805702*^9, 3.8111593713354745`*^9}, {
  3.811161861702099*^9, 3.81116187323903*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"7821fbbd-81a1-4571-8dd7-b458a9b558d7"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
       20}, {Null, 
       SparseArray[
       Automatic, {20, 20}, 0, {
        1, {{0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 
          51, 54, 57, 60}, {{14}, {15}, {16}, {5}, {6}, {13}, {7}, {14}, {
          19}, {8}, {15}, {20}, {2}, {11}, {19}, {2}, {12}, {20}, {3}, {11}, {
          16}, {4}, {12}, {16}, {10}, {14}, {17}, {9}, {15}, {18}, {5}, {7}, {
          12}, {6}, {8}, {11}, {2}, {17}, {18}, {1}, {3}, {9}, {1}, {4}, {
          10}, {1}, {7}, {8}, {9}, {13}, {19}, {10}, {13}, {20}, {3}, {5}, {
          17}, {4}, {6}, {18}}}, Pattern}]}, {
      GraphLayout -> {"Dimension" -> 2}, ImagePadding -> 10, 
       VertexCoordinates -> CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/SP48dLZR37Y12ftKZks8cB+33wp/bsqn/ZHpVjf
9++9vp8BCuxN43Z58vyyt9xyomzf/Hf2QMnpeUJf90P174fph8rvh8nD9L+r
AZnA7HCyDGTDd/s3gTvkWl//398udvPc9+DLUH237DfNfb/8mPd9e3VDjjUy
UUf2H/6qEdN/iOnAn5UfL/kmvbA3BoPv+2H6oer3w9SngcEz+4dVIuvcH76z
DwE5T+GTPUsYn+6muddh5jnAzIPavx9mP8y9y4C6NhQ9gJm3H2YeTB7iv8/7
AVLKoH4=
        "], VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGCQA2ImKP4R/Hjp7CM/7Ouz9pRMlnhgnwYGz+wfVomsc3/4
zh5dPgTEVfhkzxLGp7tp7vX96PKHv2rE9B9icviz8uMl36QX9vvmS+nfVfm0
PyrF+r5/L1z9fph6dHnLLSfK9s1/tx/ImZ4n9HU/uvymue+XH/O+v1/dkGON
TNSR/QxQYG8at8uT55c9jP+uBiTC7IAuj+4/HPL7YfJQ99jD3HOyDOSi7/Zv
AnfItb7+vx9dHj180OVh9kH4nzHCAxp+B2Dhhy6Pw33w8DIGg+/70dy3H5f9
6OGFbj8OeXj8oocHuv3o8uj628VunvsefBnqj1v20Pi1h8Uvujx6/KHLQ/n7
cZmHHj/o8jD/LgOq2lD0YD96eKD7Dz094rAfI73CzEdXjx6/6OrR4w8AMJHe
Eg==
         "]]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{1.548, 0.503}, 0.0412452419793366], 
         InsetBox["1", 
          Offset[{2, 2}, {1.5892452419793366, 0.5442452419793367}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.134, -0.368}, 0.0412452419793366], 
         InsetBox["2", 
          Offset[{2, 2}, {-1.0927547580206634, -0.3267547580206634}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.628}, 0.0412452419793366], 
         InsetBox["3", 
          Offset[{2, 2}, {0.0412452419793366, 1.6692452419793364}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.957, -1.317}, 0.0412452419793366], 
         InsetBox["4", 
          Offset[{2, 2}, {0.9982452419793366, -1.2757547580206634}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.548, 0.503}, 0.0412452419793366], 
         InsetBox["5", 
          Offset[{2, 2}, {-1.5067547580206635, 0.5442452419793367}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.957, -1.317}, 0.0412452419793366], 
         InsetBox["6", 
          Offset[{2, 2}, {-0.9157547580206633, -1.2757547580206634}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.466}, 0.0412452419793366], 
         InsetBox["7", 
          Offset[{2, 2}, {0.0412452419793366, 2.5072452419793367}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.449, -1.995}, 0.0412452419793366], 
         InsetBox["8", 
          Offset[{2, 2}, {1.4902452419793366, -1.9537547580206636}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.302, 0.416}, 0.0412452419793366], 
         InsetBox["9", 
          Offset[{2, 2}, {0.3432452419793366, 0.4572452419793366}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.489, -0.159}, 0.0412452419793366], 
         InsetBox["10", 
          Offset[{2, 2}, {0.5302452419793366, -0.1177547580206634}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-2.345, 0.762}, 0.0412452419793366], 
         InsetBox["11", 
          Offset[{2, 2}, {-2.3037547580206637, 0.8032452419793366}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.45, -1.995}, 0.0412452419793366], 
         InsetBox["12", 
          Offset[{2, 2}, {-1.4087547580206634, -1.9537547580206636}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.489, -0.159}, 0.0412452419793366], 
         InsetBox["13", 
          Offset[{2, 2}, {-0.4477547580206634, -0.1177547580206634}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0.7, 0.965}, 0.0412452419793366],
          InsetBox["14", 
          Offset[{2, 2}, {0.7412452419793365, 1.0062452419793366}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.133, -0.369}, 0.0412452419793366], 
         InsetBox["15", 
          Offset[{2, 2}, {1.1742452419793366, -0.3277547580206634}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.345, 0.762}, 0.0412452419793366], 
         InsetBox["16", 
          Offset[{2, 2}, {2.3862452419793367, 0.8032452419793366}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.302, 0.416}, 0.0412452419793366], 
         InsetBox["17", 
          Offset[{2, 2}, {-0.2607547580206634, 0.4572452419793366}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., -0.514}, 0.0412452419793366],
          InsetBox["18", 
          Offset[{2, 2}, {0.0412452419793366, -0.4727547580206634}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.7, 0.965}, 0.0412452419793366], 
         InsetBox["19", 
          Offset[{2, 2}, {-0.6587547580206634, 1.0062452419793366}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., -1.192}, 0.0412452419793366],
          InsetBox["20", 
          Offset[{2, 2}, {0.0412452419793366, -1.1507547580206634}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.811159374378767*^9, 3.811159390371851*^9}, {
   3.811161870045508*^9, 3.8111618750686207`*^9}, 3.811181634603092*^9, 
   3.81118640548526*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"fae3d7c5-d5bf-4d85-be68-841a5a8a8f9f"]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"533f06c6-5a23-4fb0-af4a-abf7d1c6c7bd"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 180, 2, 77, "Text",ExpressionUUID->"e6566561-2780-4cb6-83a3-a5b9653662a9"],
Cell[741, 24, 200, 3, 63, "Input",ExpressionUUID->"b56ec98c-1fee-4998-87ba-2ebb85cc6aac"],
Cell[944, 29, 239, 4, 77, "Text",ExpressionUUID->"36ace11b-5bb8-4a27-83bd-ccf0a503b32c"],
Cell[CellGroupData[{
Cell[1208, 37, 205, 3, 91, "Input",ExpressionUUID->"5143e5d7-53e1-4a86-b1da-762033ca963b"],
Cell[1416, 42, 20000, 439, 631, "Output",ExpressionUUID->"83d57ad5-6591-48d6-aa97-2bbe8931ae50"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21453, 486, 213, 3, 91, "Input",ExpressionUUID->"03f81cb6-78d2-4e39-b70a-f29870c95e5a"],
Cell[21669, 491, 8213, 159, 408, "Output",ExpressionUUID->"4e20de31-84e3-453e-b23f-f37c7e94a0db"]
}, Open  ]],
Cell[29897, 653, 238, 4, 77, "Text",ExpressionUUID->"b02b24ce-31c4-4a7e-8ef2-8e0aeb40b746"],
Cell[CellGroupData[{
Cell[30160, 661, 200, 3, 91, "Input",ExpressionUUID->"c087499c-02bb-4cbf-bc5f-f7cef954eb2f"],
Cell[30363, 666, 19885, 439, 574, "Output",ExpressionUUID->"07797ba9-8931-4fa9-9837-d04f3d089b4c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50285, 1110, 312, 5, 91, "Input",ExpressionUUID->"cc8e23bf-3175-4150-95a4-fd6b5a822942"],
Cell[50600, 1117, 3444, 67, 728, "Output",ExpressionUUID->"fb0a0d18-af69-4b50-8904-2f1e1a4590cb"]
}, Open  ]],
Cell[54059, 1187, 239, 4, 77, "Text",ExpressionUUID->"73762aea-c6e3-4b00-8bc2-a51df3d74372"],
Cell[CellGroupData[{
Cell[54323, 1195, 203, 3, 91, "Input",ExpressionUUID->"6489834e-0608-4ed9-a760-d6d7e5f56d27"],
Cell[54529, 1200, 19913, 438, 631, "Output",ExpressionUUID->"0de50dc3-4966-4527-99a9-57f90785dd22"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74479, 1643, 317, 5, 91, "Input",ExpressionUUID->"70351fa6-2b70-4bd0-8364-b18160fcf41d"],
Cell[74799, 1650, 3570, 67, 728, "Output",ExpressionUUID->"f68a95ab-2018-481e-b1fa-7814e363d6c3"]
}, Open  ]],
Cell[78384, 1720, 335, 5, 77, "Text",ExpressionUUID->"596ff703-3ed1-4a83-a774-3808f0514595"],
Cell[CellGroupData[{
Cell[78744, 1729, 200, 3, 91, "Input",ExpressionUUID->"1a1668b7-b62a-4a75-ac02-2309c4e1ca99"],
Cell[78947, 1734, 19903, 438, 631, "Output",ExpressionUUID->"c02880bf-edab-491c-abf9-7c9d32c82994"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98887, 2177, 316, 5, 91, "Input",ExpressionUUID->"b4b36f7c-b335-498a-8e1d-7bbb250360ee"],
Cell[99206, 2184, 4115, 82, 743, "Output",ExpressionUUID->"a09b0a89-e165-47bb-8717-f0e6d74d2f4e"]
}, Open  ]],
Cell[103336, 2269, 239, 4, 77, "Text",ExpressionUUID->"bd4d1ece-767b-46c6-a5d3-52dbea2967c9"],
Cell[CellGroupData[{
Cell[103600, 2277, 199, 3, 91, "Input",ExpressionUUID->"71909e8d-5c6e-4e9e-b965-60b1a781e2be"],
Cell[103802, 2282, 23193, 512, 631, "Output",ExpressionUUID->"1f200dd0-ea2e-41bf-b35b-0ad1959ab9b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127032, 2799, 366, 5, 91, "Input",ExpressionUUID->"43fe77b6-5e5a-4011-932a-63a024db7a11"],
Cell[127401, 2806, 6326, 123, 743, "Output",ExpressionUUID->"4de4727c-a5f7-47d3-bb42-e2112f546357"]
}, Open  ]],
Cell[133742, 2932, 287, 5, 77, "Text",ExpressionUUID->"a3151962-e6f1-4c5a-993f-1af0645061cb"],
Cell[CellGroupData[{
Cell[134054, 2941, 200, 3, 91, "Input",ExpressionUUID->"b73e2ec5-bd60-4fb6-bef1-9a9c5f5b916e"],
Cell[134257, 2946, 23112, 511, 688, "Output",ExpressionUUID->"9e33427a-8e5b-4d09-a58f-8d3c7fee32be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157406, 3462, 280, 5, 91, "Input",ExpressionUUID->"9f660b0b-8dbb-43e2-854c-0528704460d9"],
Cell[157689, 3469, 6904, 134, 743, "Output",ExpressionUUID->"8084c9d3-ffb6-405f-8014-f604c133e1e0"]
}, Open  ]],
Cell[164608, 3606, 288, 5, 77, "Text",ExpressionUUID->"8dc977b2-6fc2-4cb1-94e7-9edd16be5f9c"],
Cell[CellGroupData[{
Cell[164921, 3615, 200, 3, 91, "Input",ExpressionUUID->"b4a02fd7-d8bb-4056-a69d-5f7ee0f3aeeb"],
Cell[165124, 3620, 12948, 302, 459, "Output",ExpressionUUID->"3f989e9c-7c8b-4e90-bc5e-4c5bc43dd2c4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178109, 3927, 286, 5, 91, "Input",ExpressionUUID->"f9719b4b-3eaf-43aa-af41-7463ab213fb0"],
Cell[178398, 3934, 3249, 66, 717, "Output",ExpressionUUID->"d696b0ea-6de5-49f6-a31f-07a968609722"]
}, Open  ]],
Cell[181662, 4003, 241, 4, 77, "Text",ExpressionUUID->"73bb8856-47b2-46e5-8a33-7b095c7651c2"],
Cell[CellGroupData[{
Cell[181928, 4011, 199, 3, 91, "Input",ExpressionUUID->"622ba4a4-7e07-4d84-b917-a4dd14dc3bf9"],
Cell[182130, 4016, 27999, 575, 1320, "Output",ExpressionUUID->"64a332d4-e99f-4513-a6c5-df8e19ddb565"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210166, 4596, 204, 3, 91, "Input",ExpressionUUID->"1b6a74f4-fc28-45f0-9644-5ba54f5fdd97"],
Cell[210373, 4601, 4366, 91, 772, "Print",ExpressionUUID->"107ac146-975e-4549-a4e5-2241270372ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[214776, 4697, 313, 5, 91, "Input",ExpressionUUID->"7821fbbd-81a1-4571-8dd7-b458a9b558d7"],
Cell[215092, 4704, 6668, 141, 721, "Output",ExpressionUUID->"fae3d7c5-d5bf-4d85-be68-841a5a8a8f9f"]
}, Open  ]]
}
]
*)

