(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1043526,      24223]
NotebookOptionsPosition[    957113,      22196]
NotebookOutlinePosition[   1013924,      23370]
CellTagsIndexPosition[   1013794,      23364]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["", "SlideShowNavigationBar", "FirstSlide",
 CellTags->"SlideShowHeader"],

Cell["\<\
Paquete VilCretas: recurso did\[AAcute]ctico a trav\[EAcute]s del uso del \
software Mathematica en el campo de la
matem\[AAcute]tica discreta

\
\>", "Title",
 CellChangeTimes->{{3.448190122176695*^9, 3.44819012385317*^9}, {
   3.485609127497636*^9, 3.485609133015955*^9}, {3.514308355088097*^9, 
   3.514308374696691*^9}, 3.5146594348020153`*^9, 3.5146601881617107`*^9, {
   3.672323549521452*^9, 3.6723235622065663`*^9}, 3.6733046895172105`*^9, {
   3.6733047637304516`*^9, 3.6733048041112504`*^9}, {3.6792404746959324`*^9, 
   3.679240496310723*^9}}],

Cell["\<\
Prof. Enrique V\[IAcute]lchez Quesada, Escuela de Inform\[AAcute]tica, \
Universidad Nacional Costa Rica\
\>", "Subtitle",
 CellChangeTimes->{{3.485609136120798*^9, 3.4856091511532907`*^9}, {
   3.4856091945334663`*^9, 3.485609199379443*^9}, {3.4951031489375*^9, 
   3.49510314984375*^9}, {3.495106455296875*^9, 3.495106455453125*^9}, {
   3.5143083846926413`*^9, 3.514308395249558*^9}, 3.5443793532699003`*^9, 
   3.621626517580729*^9, {3.621626691998458*^9, 3.6216267186543407`*^9}, {
   3.621695156698331*^9, 3.621695160632772*^9}, {3.622213306499199*^9, 
   3.622213328771823*^9}, {3.6723215620753393`*^9, 3.6723216060600157`*^9}, {
   3.672323571263554*^9, 3.672323591077321*^9}, {3.6790482538844204`*^9, 
   3.679048265405439*^9}, {3.679240502070879*^9, 3.6792405197120247`*^9}}],

Cell[TextData[{
 Cell[BoxData[
  GraphicsBox[{InsetBox[
     GraphicsBox[{},
      ContentSelectable->True,
      ImageSize->{480, 360},
      PlotRange->{{0, 480/360}, {0, 1}}], Scaled[{0, 0}], Center, 
     Scaled[{0.5, 0.5}]], InsetBox[
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJztW7uO20YUXSQpUuoTmD9QmZIG0qQTHKSfNWIbaRzBDhCkY+HCQGBrbe9m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        "], {{0, 68}, {65, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{65, 68},
      PlotRange->{{0, 65}, {0, 68}}], 
     Scaled[{0.49333580155497714`, 0.5717682253254397}], 
     Center, {1.1979558513699555`, 0.9210339753942228}, {{1., 0.}, {0., 1.}}]},
   AspectRatio->1.0295620437956206`,
   ContentSelectable->True,
   ImageMargins->0.,
   ImagePadding->{{0., 0.}, {0., 0.}},
   ImageSize->{74., 77.5},
   PlotRange->{{0., 1.3333333333333335`}, {0., 1.}},
   PlotRangePadding->Automatic]]],
 StyleBox[" ",
  FontColor->RGBColor[
   0.5019607843137255, 0.5019607843137255, 0.5019607843137255]],
 StyleBox["Join the Conversation ",
  FontColor->RGBColor[
   0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],
 "#WolframTechConf"
}], "Text",
 CellFrame->{{0, 0}, {0, 1}},
 ShowCellBracket->Automatic,
 CellMargins->{{80, 80}, {100, 165}},
 CellFrameMargins->{{0, 0}, {0, 50}},
 CellFrameColor->RGBColor[0.886275, 0.364706, 0.427451],
 CellChangeTimes->{{3.6216253798451433`*^9, 3.621625396205482*^9}, 
   3.6216255185076437`*^9, {3.621625573653562*^9, 3.6216256020928392`*^9}, {
   3.621625635821653*^9, 3.621625645324601*^9}, {3.621625678952072*^9, 
   3.62162572395792*^9}, {3.621625867660451*^9, 3.62162588677988*^9}, {
   3.621625982321312*^9, 3.621625984476396*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontColor->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Antecedentes", "Section",
 CellChangeTimes->{{3.6621146329845805`*^9, 3.6621146423631773`*^9}, {
   3.6621146904244285`*^9, 3.6621147363634095`*^9}, {3.662114780047743*^9, 
   3.662114793159992*^9}, {3.6621148255820665`*^9, 3.6621148303337464`*^9}, {
   3.6627220149594183`*^9, 3.662722015076816*^9}, {3.6627220664626417`*^9, 
   3.6627220678569183`*^9}, {3.6627222809771595`*^9, 3.662722281102083*^9}, 
   3.6733046618578644`*^9, 3.679048319659859*^9, {3.6792405801002693`*^9, 
   3.6792405847811933`*^9}}],

Cell[CellGroupData[{

Cell["Objetivo de la conferencia", "Subsection",
 CellChangeTimes->{{3.679048362285181*^9, 3.679048380784606*^9}, {
  3.6792406045000772`*^9, 3.679240613748973*^9}}],

Cell[CellGroupData[{

Cell["\<\
Mostrar el funcionamiento general de un paquete orientado al software \
comercial Mathematica. D\[OAcute]nde:\
\>", "ItemNumbered",
 CellChangeTimes->{{3.679048421363461*^9, 3.679048435691998*^9}, {
   3.679048518262925*^9, 3.6790485752077255`*^9}, {3.6790486111479654`*^9, 
   3.6790486171858196`*^9}, 3.679240670895687*^9, {3.679240971362283*^9, 
   3.6792409733744516`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Apoyo educativo para desarrollar cada uno de los temas principales de un \
curso de matem\[AAcute]tica discreta.\
\>", "SubitemNumbered",
 CellChangeTimes->{{3.679048421363461*^9, 3.679048435691998*^9}, {
   3.679048518262925*^9, 3.6790485752077255`*^9}, {3.6790486111479654`*^9, 
   3.6790486171667814`*^9}, {3.679048649208083*^9, 3.6790486554507303`*^9}, 
   3.6790661171649647`*^9, {3.679240690271815*^9, 3.6792407016413684`*^9}}],

Cell["\<\
Es un resultado de un proyecto de investigaci\[OAcute]n adscrito a la Escuela \
de Inform\[AAcute]tica.\
\>", "SubitemNumbered",
 CellChangeTimes->{{3.679048421363461*^9, 3.679048435691998*^9}, {
   3.679048518262925*^9, 3.6790485752077255`*^9}, {3.6790486111479654`*^9, 
   3.6790486171667814`*^9}, {3.679048649208083*^9, 3.6790486554387064`*^9}, 
   3.679066118982926*^9, {3.6792407241321535`*^9, 3.6792407422773685`*^9}}]
}, Open  ]],

Cell["El paquete VilCretas se concibe:", "ItemNumbered",
 CellChangeTimes->{{3.679048421363461*^9, 3.679048435691998*^9}, {
  3.679048518262925*^9, 3.679048575175138*^9}, {3.679048685431327*^9, 
  3.679048694731947*^9}, {3.6792407576093807`*^9, 3.6792407652728953`*^9}}],

Cell[CellGroupData[{

Cell["Como una necesidad latente en la c\[AAcute]tedra del curso EIF-203.", \
"SubitemNumbered",
 CellChangeTimes->{{3.679048421363461*^9, 3.679048435691998*^9}, {
   3.679048518262925*^9, 3.679048575175138*^9}, {3.679048685431327*^9, 
   3.679048753959589*^9}, 3.679066121038666*^9, {3.6792407787765737`*^9, 
   3.6792407914796543`*^9}}],

Cell["\<\
Es un medio para abordar con una metodolog\[IAcute]a asistida por \
computadora, la matem\[AAcute]tica discreta (que se ha convertido en un obst\
\[AAcute]culo m\[AAcute]s).\
\>", "SubitemNumbered",
 CellChangeTimes->{{3.679048421363461*^9, 3.679048435691998*^9}, {
   3.679048518262925*^9, 3.679048575175138*^9}, {3.679048685431327*^9, 
   3.6790487828665953`*^9}, 3.6790661229235325`*^9, {3.679240843917015*^9, 
   3.6792408908198266`*^9}, 3.6792410556784577`*^9, 3.679246590866889*^9}],

Cell["\<\
Es un recurso que transforma temas \[AAcute]ridos en posibilidades de \
visualizaci\[OAcute]n y construcci\[OAcute]n aut\[OAcute]noma de conceptos.\
\>", "SubitemNumbered",
 CellChangeTimes->{{3.679048421363461*^9, 3.679048435691998*^9}, {
   3.679048518262925*^9, 3.679048575175138*^9}, {3.679048685431327*^9, 
   3.6790488087004995`*^9}, {3.6790488941094065`*^9, 3.679048895985947*^9}, 
   3.6790661249436846`*^9, {3.6792409148005695`*^9, 3.679240966383497*^9}, {
   3.679241060477607*^9, 3.679241062286124*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Paquete VilCretas", "Section",
 CellChangeTimes->{{3.679048907753787*^9, 3.6790489147213335`*^9}, {
  3.679049412165539*^9, 3.679049416722002*^9}, {3.6792411077573776`*^9, 
  3.679241112470755*^9}}],

Cell[CellGroupData[{

Cell["Bondades del recurso", "Subsection",
 CellChangeTimes->{
  3.6790492170244036`*^9, {3.67924109432905*^9, 3.6792411021004457`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Servir de patrocinio did\[AAcute]ctico en cursos de matem\[AAcute]tica \
discreta.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6790492759837823`*^9, 3.679049277376142*^9}, 
   3.679066051788721*^9, {3.6792411373125863`*^9, 3.679241172490016*^9}, 
   3.6792466042246118`*^9}],

Cell["\<\
Incorpora comandos de uso f\[AAcute]cil sin necesidad de tener un \
conocimiento profundo sobre lenguaje de programaci\[OAcute]n Wolfram.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6790492759837823`*^9, 3.6790492773395896`*^9}, {
   3.6790493076760535`*^9, 3.6790493089141755`*^9}, 3.6790660537443743`*^9, {
   3.6792412046534677`*^9, 3.679241205991835*^9}}],

Cell["\<\
El paquete procura que su empleo sea pr\[AAcute]ctico, eficaz y \[AAcute]gil.\
\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6790492759837823`*^9, 3.6790492773395896`*^9}, {
   3.6790493076760535`*^9, 3.679049353559922*^9}, 3.679066058497177*^9, {
   3.6792412374041524`*^9, 3.6792412450139093`*^9}}],

Cell["\<\
Incorpora herramientas para el estudio de problemas reales, utilizando \
internamente las caracter\[IAcute]sticas de an\[AAcute]lisis de datos y \
elementos geogr\[AAcute]ficos facilitados por Mathematica.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6790492759837823`*^9, 3.6790492773395896`*^9}, {
   3.6790493076760535`*^9, 3.679049353559922*^9}, 3.679066058497177*^9, {
   3.6792412374041524`*^9, 3.6792412477008495`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Paquete VilCretas ", "Section",
 CellChangeTimes->{{3.6790494000912795`*^9, 3.6790494073160734`*^9}, {
  3.679241263866336*^9, 3.679241268757518*^9}}],

Cell[CellGroupData[{

Cell["\<\
A\[NTilde]ade al software Mathematica 195 funciones distribuidas en los \
siguientes temas:\
\>", "Subsection",
 CellChangeTimes->{{3.679049426988636*^9, 3.6790494425480385`*^9}, {
  3.6792412769191227`*^9, 3.6792413291045074`*^9}}],

Cell[CellGroupData[{

Cell["Recursividad", "ItemNumbered",
 CellChangeTimes->{{3.6790494704549513`*^9, 3.679049473918042*^9}, {
  3.6792413382200203`*^9, 3.6792413418826447`*^9}}],

Cell["Relaciones de recurrencia", "ItemNumbered",
 CellChangeTimes->{{3.6790494704549513`*^9, 3.679049487841731*^9}, {
  3.679241344514265*^9, 3.67924134981358*^9}}],

Cell["An\[AAcute]lisis de algoritmos", "ItemNumbered",
 CellChangeTimes->{{3.6790494704549513`*^9, 3.679049500746479*^9}, {
  3.679241354012726*^9, 3.6792413602939377`*^9}}],

Cell["Relaciones binarias", "ItemNumbered",
 CellChangeTimes->{{3.6790494704549513`*^9, 3.679049541580636*^9}, {
  3.6792413654259443`*^9, 3.679241371782618*^9}}],

Cell["Teor\[IAcute]a de grafos", "ItemNumbered",
 CellChangeTimes->{{3.6790494704549513`*^9, 3.6790495429530334`*^9}, {
  3.679241375917572*^9, 3.6792413884940033`*^9}}],

Cell["Teor\[IAcute]a de \[AAcute]rboles", "ItemNumbered",
 CellChangeTimes->{{3.6790494704549513`*^9, 3.679049556995379*^9}, {
  3.6790509636560507`*^9, 3.6790509726449213`*^9}, {3.679241391845224*^9, 
  3.6792413978125134`*^9}}],

Cell["M\[AAcute]quinas y aut\[OAcute]matas de estado finito", "ItemNumbered",
 CellChangeTimes->{{3.6790494704549513`*^9, 3.6790495957927012`*^9}, {
  3.679241400033272*^9, 3.679241413009966*^9}}],

Cell["Lenguajes y gram\[AAcute]ticas", "ItemNumbered",
 CellChangeTimes->{{3.6790494704549513`*^9, 3.6790496131865177`*^9}, {
  3.679241417045566*^9, 3.6792414251054506`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Recursividad", "Section",
 CellChangeTimes->{{3.6621146329845805`*^9, 3.6621146423631773`*^9}, {
   3.6621146904244285`*^9, 3.6621147363634095`*^9}, {3.662114780047743*^9, 
   3.662114793159992*^9}, {3.6621148255820665`*^9, 3.6621148303337464`*^9}, {
   3.6627220149594183`*^9, 3.662722015076816*^9}, {3.6627220664626417`*^9, 
   3.6627220678569183`*^9}, {3.6627222809771595`*^9, 3.662722281102083*^9}, 
   3.6733046618578644`*^9, {3.679241705734663*^9, 3.6792417072364335`*^9}, {
   3.679663405646758*^9, 3.679663406007244*^9}}],

Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.6686806231943417`*^9, 3.6686806289292426`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Factoriales: calcula de forma recursiva el factorial de un n\[UAcute]mero \
natural o cero. Presenta dos opciones: \[OpenCurlyDoubleQuote]code\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]steps\
\[CloseCurlyDoubleQuote], code con un valor l\[OAcute]gico \
\[OpenCurlyDoubleQuote]True\[CloseCurlyDoubleQuote] muestra el c\[OAcute]digo \
de la funci\[OAcute]n recursiva que realiza el c\[AAcute]lculo y steps arroja \
paso a paso las iteraciones que recorre la recursividad. Sintaxis: \
Factoriales[n], o bien, Factoriales[n, code->Valor, steps->Valor].\
\>", "ItemNumbered",
 CellChangeTimes->{{3.662121997736477*^9, 3.6621220020530095`*^9}, 
   3.6621220437212067`*^9, {3.662134477825127*^9, 3.662134478749708*^9}}],

Cell["Ejemplo de c\[AAcute]lculo directo.", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factoriales", "[", "20", "]"}]], "Input",
 CellChangeTimes->{{3.6621169960945272`*^9, 3.662117002124377*^9}, 
   3.662117484924795*^9, {3.662117909356442*^9, 3.6621179203199654`*^9}, {
   3.662118240641423*^9, 3.662118274771277*^9}, {3.662118405768794*^9, 
   3.662118406440677*^9}, {3.6621199070469027`*^9, 3.662119920016224*^9}, {
   3.6621199507738776`*^9, 3.6621199882252164`*^9}, {3.662120191352413*^9, 
   3.662120194430192*^9}, {3.6621203259159636`*^9, 3.6621203994601035`*^9}, {
   3.662120470617037*^9, 3.6621204773287525`*^9}, {3.6621205641384397`*^9, 
   3.662120569634644*^9}, {3.662120661664194*^9, 3.662120677044594*^9}, {
   3.6621207438211765`*^9, 3.66212074766485*^9}, {3.662120840507927*^9, 
   3.6621209126642013`*^9}, {3.6621220616894283`*^9, 
   3.6621220660823298`*^9}, {3.662214706828783*^9, 3.662214738061424*^9}}],

Cell[BoxData["2432902008176640000"], "Output",
 CellChangeTimes->{{3.662214721500639*^9, 3.6622147385457363`*^9}, 
   3.6792425862035522`*^9, 3.679246437753416*^9, 3.6792467766549425`*^9, 
   3.6796538610498066`*^9}]
}, Closed]],

Cell["Ejemplo donde se muestra el c\[OAcute]digo.", "SubitemNumbered",
 CellChangeTimes->{{3.6621226817922716`*^9, 3.662122699614063*^9}, 
   3.6621227615302906`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factoriales", "[", 
  RowBox[{"20", ",", " ", 
   RowBox[{"code", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.662122705973446*^9, 3.662122725116356*^9}, {
  3.662122864112853*^9, 3.6621228648861146`*^9}, {3.6622071721322694`*^9, 
  3.6622071759645357`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2432902008176640000", 
   ",", "\<\"Factoriales[n_]:=If[Or[n\[Equal]0, n\[Equal]1], Return[1], \
n*Factoriales[n-1]]\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.6622071772086153`*^9, 3.6792425908701124`*^9, 
  3.679246442653405*^9, 3.6792467814664316`*^9, 3.6796538716617336`*^9}]
}, Closed]],

Cell["Ejemplo donde se muestra paso a paso el resultado.", "SubitemNumbered",
 CellChangeTimes->{{3.6621227379144974`*^9, 3.662122764092825*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factoriales", "[", 
  RowBox[{"20", ",", " ", 
   RowBox[{"steps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.662122768805003*^9, 3.662122784498869*^9}, {
  3.6621228567797375`*^9, 3.662122858826643*^9}, {3.6621233424117374`*^9, 
  3.6621233475392237`*^9}, {3.6622071828970184`*^9, 3.662207185921054*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   "2432902008176640000"}],
  SequenceForm[
  "Factoriales[", 20, "] = ", 20, " * Factoriales[", 19, "] = ", 
   2432902008176640000],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538875648994`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   "121645100408832000"}],
  SequenceForm[
  "Factoriales[", 19, "] = ", 19, " * Factoriales[", 18, "] = ", 
   121645100408832000],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.679653887573905*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   "6402373705728000"}],
  SequenceForm[
  "Factoriales[", 18, "] = ", 18, " * Factoriales[", 17, "] = ", 
   6402373705728000],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538875789304`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   "355687428096000"}],
  SequenceForm[
  "Factoriales[", 17, "] = ", 17, " * Factoriales[", 16, "] = ", 
   355687428096000],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538875839324`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   "20922789888000"}],
  SequenceForm[
  "Factoriales[", 16, "] = ", 16, " * Factoriales[", 15, "] = ", 
   20922789888000],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.679653887589416*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "1307674368000"}],
  SequenceForm[
  "Factoriales[", 15, "] = ", 15, " * Factoriales[", 14, "] = ", 
   1307674368000],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538875939193`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "87178291200"}],
  SequenceForm[
  "Factoriales[", 14, "] = ", 14, " * Factoriales[", 13, "] = ", 87178291200],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.679653887598444*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "6227020800"}],
  SequenceForm[
  "Factoriales[", 13, "] = ", 13, " * Factoriales[", 12, "] = ", 6227020800],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538876034465`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "479001600"}],
  SequenceForm[
  "Factoriales[", 12, "] = ", 12, " * Factoriales[", 11, "] = ", 479001600],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538876109314`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "39916800"}],
  SequenceForm[
  "Factoriales[", 11, "] = ", 11, " * Factoriales[", 10, "] = ", 39916800],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.679653887616481*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "3628800"}],
  SequenceForm[
  "Factoriales[", 10, "] = ", 10, " * Factoriales[", 9, "] = ", 3628800],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.679653887621484*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "362880"}],
  SequenceForm[
  "Factoriales[", 9, "] = ", 9, " * Factoriales[", 8, "] = ", 362880],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538876264668`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "40320"}],
  SequenceForm[
  "Factoriales[", 8, "] = ", 8, " * Factoriales[", 7, "] = ", 40320],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.679653887634493*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5040"}],
  SequenceForm[
  "Factoriales[", 7, "] = ", 7, " * Factoriales[", 6, "] = ", 5040],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538876389995`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "720"}],
  SequenceForm[
  "Factoriales[", 6, "] = ", 6, " * Factoriales[", 5, "] = ", 720],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.679653887644003*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "120"}],
  SequenceForm[
  "Factoriales[", 5, "] = ", 5, " * Factoriales[", 4, "] = ", 120],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538876500053`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "24"}],
  SequenceForm["Factoriales[", 4, "] = ", 4, " * Factoriales[", 3, "] = ", 24],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.679653887655028*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm["Factoriales[", 3, "] = ", 3, " * Factoriales[", 2, "] = ", 6],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538876600533`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Factoriales[", 2, "] = ", 2, " * Factoriales[", 1, "] = ", 2],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.679653887664554*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] = 1\"\>"}],
  SequenceForm["Factoriales[", 1, "] = 1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6622071943500867`*^9, 3.679242595183981*^9, 
  3.679246450615463*^9, 3.6792467860985284`*^9, 3.6796538876725435`*^9}]
}, Open  ]],

Cell[BoxData["2432902008176640000"], "Output",
 CellChangeTimes->{3.6622071943926167`*^9, 3.679242595258169*^9, 
  3.679246450738124*^9, 3.679246786198657*^9, 3.6796538876768856`*^9}]
}, Closed]],

Cell["\<\
Ejemplo donde se muestra el c\[OAcute]digo y las iteraciones recursivas.\
\>", "SubitemNumbered",
 CellChangeTimes->{{3.6621227987253227`*^9, 3.6621228212222123`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factoriales", "[", 
  RowBox[{"20", ",", 
   RowBox[{"code", "\[Rule]", "True"}], ",", 
   RowBox[{"steps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.662122827684595*^9, 3.662122886889936*^9}, {
  3.662123352397783*^9, 3.6621233600532446`*^9}, {3.6622071886812363`*^9, 
  3.662207191514869*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2432902008176640000", 
   ",", "\<\"Factoriales[n_]:=If[Or[n\[Equal]0, n\[Equal]1], Return[1], \
n*Factoriales[n-1]]\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.679653911212922*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   "2432902008176640000"}],
  SequenceForm[
  "Factoriales[", 20, "] = ", 20, " * Factoriales[", 19, "] = ", 
   2432902008176640000],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.679653911217451*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   "121645100408832000"}],
  SequenceForm[
  "Factoriales[", 19, "] = ", 19, " * Factoriales[", 18, "] = ", 
   121645100408832000],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.679653911224437*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   "6402373705728000"}],
  SequenceForm[
  "Factoriales[", 18, "] = ", 18, " * Factoriales[", 17, "] = ", 
   6402373705728000],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.679653911232443*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   "355687428096000"}],
  SequenceForm[
  "Factoriales[", 17, "] = ", 17, " * Factoriales[", 16, "] = ", 
   355687428096000],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.679653911244464*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   "20922789888000"}],
  SequenceForm[
  "Factoriales[", 16, "] = ", 16, " * Factoriales[", 15, "] = ", 
   20922789888000],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.679653911249974*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "1307674368000"}],
  SequenceForm[
  "Factoriales[", 15, "] = ", 15, " * Factoriales[", 14, "] = ", 
   1307674368000],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539112549744`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "87178291200"}],
  SequenceForm[
  "Factoriales[", 14, "] = ", 14, " * Factoriales[", 13, "] = ", 87178291200],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539112599773`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "6227020800"}],
  SequenceForm[
  "Factoriales[", 13, "] = ", 13, " * Factoriales[", 12, "] = ", 6227020800],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539112689867`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "479001600"}],
  SequenceForm[
  "Factoriales[", 12, "] = ", 12, " * Factoriales[", 11, "] = ", 479001600],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.679653911274471*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "39916800"}],
  SequenceForm[
  "Factoriales[", 11, "] = ", 11, " * Factoriales[", 10, "] = ", 39916800],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539112804756`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "3628800"}],
  SequenceForm[
  "Factoriales[", 10, "] = ", 10, " * Factoriales[", 9, "] = ", 3628800],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539112869797`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "362880"}],
  SequenceForm[
  "Factoriales[", 9, "] = ", 9, " * Factoriales[", 8, "] = ", 362880],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539112924833`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "40320"}],
  SequenceForm[
  "Factoriales[", 8, "] = ", 8, " * Factoriales[", 7, "] = ", 40320],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539112984686`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5040"}],
  SequenceForm[
  "Factoriales[", 7, "] = ", 7, " * Factoriales[", 6, "] = ", 5040],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539113039665`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "720"}],
  SequenceForm[
  "Factoriales[", 6, "] = ", 6, " * Factoriales[", 5, "] = ", 720],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539113114786`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "120"}],
  SequenceForm[
  "Factoriales[", 5, "] = ", 5, " * Factoriales[", 4, "] = ", 120],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.679653911315978*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "24"}],
  SequenceForm["Factoriales[", 4, "] = ", 4, " * Factoriales[", 3, "] = ", 24],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.679653911321003*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm["Factoriales[", 3, "] = ", 3, " * Factoriales[", 2, "] = ", 6],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539113265247`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" * Factoriales[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Factoriales[", 2, "] = ", 2, " * Factoriales[", 1, "] = ", 2],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.6796539113320274`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factoriales[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] = 1\"\>"}],
  SequenceForm["Factoriales[", 1, "] = 1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.67924259926735*^9, 3.6792464548439007`*^9, 
  3.6792467920725803`*^9, 3.679653911336551*^9}]
}, Open  ]],

Cell[BoxData["2432902008176640000"], "Output",
 CellChangeTimes->{3.679242599338908*^9, 3.679246454947996*^9, 
  3.679246792173195*^9, 3.6796539113415546`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
SumaDigi: suma de manera recursiva los d\[IAcute]gitos de un n\[UAcute]mero \
natural. El comando facilita el c\[OAcute]digo con el que fue programado y \
permite observar los valores retornados en cada iteraci\[OAcute]n mediante el \
uso de las opciones \[OpenCurlyDoubleQuote]code->True\[CloseCurlyDoubleQuote] \
y \[OpenCurlyDoubleQuote]steps->True\[CloseCurlyDoubleQuote], \
respectivamente. Sintaxis: SumaDigi[n], o bien, SumaDigi[n, code->Valor, \
steps->Valor].\
\>", "ItemNumbered",
 CellChangeTimes->{{3.662299420361016*^9, 3.6622994281318502`*^9}, 
   3.6622995849189434`*^9, {3.6622997418267508`*^9, 3.662299742858015*^9}, {
   3.6733101825679836`*^9, 3.673310218846949*^9}, {3.6790496464314423`*^9, 
   3.679049654923522*^9}, {3.6790497044847927`*^9, 3.67904971884173*^9}, 
   3.6790508243901296`*^9, {3.6790512000731564`*^9, 3.6790512056477685`*^9}, {
   3.6790519107552443`*^9, 3.6790519116078053`*^9}, 3.679061421217995*^9, 
   3.6790820410564623`*^9, 3.679242699593156*^9}],

Cell["Ejemplo de c\[AAcute]lculo directo.", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, 3.673310232006645*^9, 3.679049721394754*^9, 
   3.679050827416977*^9, 3.679242712571123*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumaDigi", "[", "1980025487", "]"}]], "Input",
 CellChangeTimes->{3.662300734963088*^9}],

Cell[BoxData["44"], "Output",
 CellChangeTimes->{
  3.679051969653061*^9, {3.6790818087382865`*^9, 3.6790818178975058`*^9}, 
   3.679246798341512*^9, 3.6796541263764367`*^9}]
}, Closed]],

Cell["Ejemplo donde se muestra el c\[OAcute]digo.", "SubitemNumbered",
 CellChangeTimes->{{3.6621226817922716`*^9, 3.662122699614063*^9}, 
   3.6621227615302906`*^9, 3.673310238302805*^9, 3.679049723633961*^9, 
   3.679050829424892*^9, 3.6792427210959797`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumaDigi", "[", 
  RowBox[{"1980025487", ",", 
   RowBox[{"code", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6623012906419353`*^9, 3.662301304046043*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "44", ",", \
"\<\"SumaDigi[n_]:=Module[{suma=Mod[n,10]},If[n\[Equal]0,Return[suma],suma+\
SumaDigi[(n-Mod[n,10])/10]]]\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.679051974934539*^9, 3.6792468039247055`*^9, 
  3.679654133819384*^9}]
}, Closed]],

Cell["\<\
Ejemplo donde se muestra paso a paso el resultado.
\
\>", "SubitemNumbered",
 CellChangeTimes->{{3.6621227379144974`*^9, 3.662122764092825*^9}, 
   3.6733102469555283`*^9, 3.6790497260622463`*^9, 3.6790510227934833`*^9, 
   3.6792427293936167`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumaDigi", "[", 
  RowBox[{"1980025487", ",", 
   RowBox[{"steps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.662301330375952*^9, 3.6623013362738748`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1980025487", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "1980025487", "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", 
   "1980025487", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "1980025487", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "44"}],
  SequenceForm[
  "SumaDigi[", 1980025487, "] = ", 7, "+SumaDigi[(", 1980025487, "-Mod[", 
   1980025487, ",", "10])/10] = ", 7, "+SumaDigi[(", 1980025487, "-", 7, 
   ")/10] = ", 44],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.679654144224845*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "198002548", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "198002548", "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", 
   "198002548", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "198002548", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "37"}],
  SequenceForm[
  "SumaDigi[", 198002548, "] = ", 8, "+SumaDigi[(", 198002548, "-Mod[", 
   198002548, ",", "10])/10] = ", 8, "+SumaDigi[(", 198002548, "-", 8, 
   ")/10] = ", 37],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.679654144233388*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "19800254", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "19800254", "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", 
   "19800254", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "19800254", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "29"}],
  SequenceForm[
  "SumaDigi[", 19800254, "] = ", 4, "+SumaDigi[(", 19800254, "-Mod[", 
   19800254, ",", "10])/10] = ", 4, "+SumaDigi[(", 19800254, "-", 4, 
   ")/10] = ", 29],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.679654144240892*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1980025", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1980025",
    "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "1980025", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1980025",
    "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "25"}],
  SequenceForm[
  "SumaDigi[", 1980025, "] = ", 5, "+SumaDigi[(", 1980025, "-Mod[", 1980025, 
   ",", "10])/10] = ", 5, "+SumaDigi[(", 1980025, "-", 5, ")/10] = ", 25],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.679654144246397*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "198002", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "198002", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "198002", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "198002", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "20"}],
  SequenceForm[
  "SumaDigi[", 198002, "] = ", 2, "+SumaDigi[(", 198002, "-Mod[", 198002, ",",
    "10])/10] = ", 2, "+SumaDigi[(", 198002, "-", 2, ")/10] = ", 20],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.679654144255905*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "19800", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "19800", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "19800", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "19800", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "SumaDigi[", 19800, "] = ", 0, "+SumaDigi[(", 19800, "-Mod[", 19800, ",", 
   "10])/10] = ", 0, "+SumaDigi[(", 19800, "-", 0, ")/10] = ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.6796541442614117`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1980", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1980", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "1980", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1980", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "SumaDigi[", 1980, "] = ", 0, "+SumaDigi[(", 1980, "-Mod[", 1980, ",", 
   "10])/10] = ", 0, "+SumaDigi[(", 1980, "-", 0, ")/10] = ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.679654144266944*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "198", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "198", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "198", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "198", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "SumaDigi[", 198, "] = ", 8, "+SumaDigi[(", 198, "-Mod[", 198, ",", 
   "10])/10] = ", 8, "+SumaDigi[(", 198, "-", 8, ")/10] = ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.679654144272438*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "10"}],
  SequenceForm[
  "SumaDigi[", 19, "] = ", 9, "+SumaDigi[(", 19, "-Mod[", 19, ",", 
   "10])/10] = ", 9, "+SumaDigi[(", 19, "-", 9, ")/10] = ", 10],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.67965414427796*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm[
  "SumaDigi[", 1, "] = ", 1, "+SumaDigi[(", 1, "-Mod[", 1, ",", "10])/10] = ",
    1, "+SumaDigi[(", 1, "-", 1, ")/10] = ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.6796541442834635`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["SumaDigi[", 0, "] = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519789855576`*^9, 3.679246808351565*^9, 
  3.679654144292989*^9}]
}, Open  ]],

Cell[BoxData["44"], "Output",
 CellChangeTimes->{3.679051979185094*^9, 3.679246808411109*^9, 
  3.6796541442979765`*^9}]
}, Closed]],

Cell["\<\
Ejemplo donde se muestra el c\[OAcute]digo y las iteraciones recursivas.\
\>", "SubitemNumbered",
 CellChangeTimes->{{3.6621227987253227`*^9, 3.6621228212222123`*^9}, {
   3.67331025649783*^9, 3.67331025809188*^9}, 3.6790497284862847`*^9, 
   3.679051036736086*^9, 3.679242740385829*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumaDigi", "[", 
  RowBox[{"1980025487", ",", 
   RowBox[{"code", "\[Rule]", "True"}], ",", 
   RowBox[{"steps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.662302332805278*^9, 3.66230234165726*^9}, {
  3.662302400821245*^9, 3.66230241113624*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "44", ",", \
"\<\"SumaDigi[n_]:=Module[{suma=Mod[n,10]},If[n\[Equal]0,Return[suma],suma+\
SumaDigi[(n-Mod[n,10])/10]]]\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.6796541569531155`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1980025487", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "1980025487", "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", 
   "1980025487", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "1980025487", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "44"}],
  SequenceForm[
  "SumaDigi[", 1980025487, "] = ", 7, "+SumaDigi[(", 1980025487, "-Mod[", 
   1980025487, ",", "10])/10] = ", 7, "+SumaDigi[(", 1980025487, "-", 7, 
   ")/10] = ", 44],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.67965415696012*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "198002548", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "198002548", "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", 
   "198002548", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "198002548", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "37"}],
  SequenceForm[
  "SumaDigi[", 198002548, "] = ", 8, "+SumaDigi[(", 198002548, "-Mod[", 
   198002548, ",", "10])/10] = ", 8, "+SumaDigi[(", 198002548, "-", 8, 
   ")/10] = ", 37],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.67965415697213*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "19800254", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "19800254", "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", 
   "19800254", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", 
   "19800254", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "29"}],
  SequenceForm[
  "SumaDigi[", 19800254, "] = ", 4, "+SumaDigi[(", 19800254, "-Mod[", 
   19800254, ",", "10])/10] = ", 4, "+SumaDigi[(", 19800254, "-", 4, 
   ")/10] = ", 29],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.679654156981636*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1980025", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1980025",
    "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "1980025", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1980025",
    "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "25"}],
  SequenceForm[
  "SumaDigi[", 1980025, "] = ", 5, "+SumaDigi[(", 1980025, "-Mod[", 1980025, 
   ",", "10])/10] = ", 5, "+SumaDigi[(", 1980025, "-", 5, ")/10] = ", 25],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.679654156990644*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "198002", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "198002", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "198002", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "198002", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "20"}],
  SequenceForm[
  "SumaDigi[", 198002, "] = ", 2, "+SumaDigi[(", 198002, "-Mod[", 198002, ",",
    "10])/10] = ", 2, "+SumaDigi[(", 198002, "-", 2, ")/10] = ", 20],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.67965415699965*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "19800", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "19800", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "19800", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "19800", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "SumaDigi[", 19800, "] = ", 0, "+SumaDigi[(", 19800, "-Mod[", 19800, ",", 
   "10])/10] = ", 0, "+SumaDigi[(", 19800, "-", 0, ")/10] = ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.679654157011158*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1980", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1980", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "1980", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1980", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "SumaDigi[", 1980, "] = ", 0, "+SumaDigi[(", 1980, "-Mod[", 1980, ",", 
   "10])/10] = ", 0, "+SumaDigi[(", 1980, "-", 0, ")/10] = ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.679654157019971*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "198", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "198", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "198", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "198", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "18"}],
  SequenceForm[
  "SumaDigi[", 198, "] = ", 8, "+SumaDigi[(", 198, "-Mod[", 198, ",", 
   "10])/10] = ", 8, "+SumaDigi[(", 198, "-", 8, ")/10] = ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.6796541570284777`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "10"}],
  SequenceForm[
  "SumaDigi[", 19, "] = ", 9, "+SumaDigi[(", 19, "-Mod[", 19, ",", 
   "10])/10] = ", 9, "+SumaDigi[(", 19, "-", 9, ")/10] = ", 10],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.6796541570349827`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-Mod[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"10])/10] = \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"+SumaDigi[(\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\")/10] = \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm[
  "SumaDigi[", 1, "] = ", 1, "+SumaDigi[(", 1, "-Mod[", 1, ",", "10])/10] = ",
    1, "+SumaDigi[(", 1, "-", 1, ")/10] = ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.679654157045491*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SumaDigi[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["SumaDigi[", 0, "] = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051985563164*^9, 3.6792468124413867`*^9, 
  3.6796541570540032`*^9}]
}, Open  ]],

Cell[BoxData["44"], "Output",
 CellChangeTimes->{3.6790519857657127`*^9, 3.679246812506958*^9, 
  3.679654157058509*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Sumatoria: construye de manera autom\[AAcute]tica un programa recursivo para \
calcular una sumatoria ingresada por el usuario, la instrucci\[OAcute]n adem\
\[AAcute]s, facilita el c\[AAcute]lculo paso a paso para un valor de \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] (\[IAcute]ndice superior de \
la suma) especificado como par\[AAcute]metro. Sintaxis: Sumatoria[suma, n], \
suma es un vector con tres componentes en el siguiente orden: el \
\[IAcute]ndice inferior, el \[IAcute]ndice superior (en funci\[OAcute]n de \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]) y la expresi\[OAcute]n \
interna de la sumatoria (en funci\[OAcute]n de \[OpenCurlyDoubleQuote]i\
\[CloseCurlyDoubleQuote]).\
\>", "ItemNumbered",
 CellChangeTimes->{
  3.662809239136137*^9, {3.6628095458493567`*^9, 3.6628096059206896`*^9}, {
   3.6628096378372154`*^9, 3.6628096476454325`*^9}, {3.6628099324372654`*^9, 
   3.6628099371717076`*^9}, {3.664904141094591*^9, 3.6649041416926146`*^9}, {
   3.673312801622595*^9, 3.6733128065148244`*^9}, {3.673312853770051*^9, 
   3.6733128557803764`*^9}, {3.679049750113762*^9, 3.679049757751485*^9}, {
   3.679051068900899*^9, 3.679051085969076*^9}, 3.6792426390901365`*^9}],

Cell[TextData[{
 "Ejemplo 1: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], 
     RowBox[{"n", "-", "2"}]], "20"}], TraditionalForm]]]
}], "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662810189029336*^9, 3.662810197875327*^9}, {
   3.673312935442013*^9, 3.6733129399039617`*^9}, {3.6790529594705844`*^9, 
   3.679053022472784*^9}, {3.6792426415487075`*^9, 3.679242643821582*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sumatoria", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"n", "-", "2"}], ",", "20"}], "}"}], ",", "20"}], "]"}]], "Input",\

 CellChangeTimes->{{3.6676876009335275`*^9, 3.6676876057681365`*^9}, {
  3.6676876545023003`*^9, 3.6676876668409014`*^9}, {3.6790467660660243`*^9, 
  3.6790467959509945`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[n_]:=If[n\[Equal]\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"Sumatoria[n-1]+\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "Sumatoria[n_]:=If[n\[Equal]", 3, ",", 20, ",", "Sumatoria[n-1]+", 20, "]"],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.6796543192749186`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "360"}],
  SequenceForm["Sumatoria[", 20, "] = Sumatoria[", 19, "] + ", 20, " = ", 360],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.679654319281423*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "340"}],
  SequenceForm["Sumatoria[", 19, "] = Sumatoria[", 18, "] + ", 20, " = ", 340],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.679654319290429*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "320"}],
  SequenceForm["Sumatoria[", 18, "] = Sumatoria[", 17, "] + ", 20, " = ", 320],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.6796543192964334`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "300"}],
  SequenceForm["Sumatoria[", 17, "] = Sumatoria[", 16, "] + ", 20, " = ", 300],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.679654319304942*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "280"}],
  SequenceForm["Sumatoria[", 16, "] = Sumatoria[", 15, "] + ", 20, " = ", 280],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.679654319310898*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "260"}],
  SequenceForm["Sumatoria[", 15, "] = Sumatoria[", 14, "] + ", 20, " = ", 260],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.6796543193159027`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "240"}],
  SequenceForm["Sumatoria[", 14, "] = Sumatoria[", 13, "] + ", 20, " = ", 240],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.6796543193224096`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "220"}],
  SequenceForm["Sumatoria[", 13, "] = Sumatoria[", 12, "] + ", 20, " = ", 220],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.679654319327417*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "200"}],
  SequenceForm["Sumatoria[", 12, "] = Sumatoria[", 11, "] + ", 20, " = ", 200],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.679654319333421*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "180"}],
  SequenceForm["Sumatoria[", 11, "] = Sumatoria[", 10, "] + ", 20, " = ", 180],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.679654319338425*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "160"}],
  SequenceForm["Sumatoria[", 10, "] = Sumatoria[", 9, "] + ", 20, " = ", 160],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.679654319346933*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "140"}],
  SequenceForm["Sumatoria[", 9, "] = Sumatoria[", 8, "] + ", 20, " = ", 140],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.679654319351939*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "120"}],
  SequenceForm["Sumatoria[", 8, "] = Sumatoria[", 7, "] + ", 20, " = ", 120],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.6796543193574467`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "100"}],
  SequenceForm["Sumatoria[", 7, "] = Sumatoria[", 6, "] + ", 20, " = ", 100],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.6796543193664565`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "80"}],
  SequenceForm["Sumatoria[", 6, "] = Sumatoria[", 5, "] + ", 20, " = ", 80],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.67965431937246*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "60"}],
  SequenceForm["Sumatoria[", 5, "] = Sumatoria[", 4, "] + ", 20, " = ", 60],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.6796543193774633`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", "40"}],
  SequenceForm["Sumatoria[", 4, "] = Sumatoria[", 3, "] + ", 20, " = ", 40],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.6796543193834677`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "20"}],
  SequenceForm["Sumatoria[", 3, "] = ", 20],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790519922659826`*^9, 3.6792468169762964`*^9, 
  3.6796543193884745`*^9}]
}, Open  ]],

Cell[BoxData["360"], "Output",
 CellChangeTimes->{3.6790519925814285`*^9, 3.679246817074219*^9, 
  3.6796543193934755`*^9}]
}, Closed]],

Cell[TextData[{
 "Ejemplo 2: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "3"}], 
     RowBox[{"n", "-", "4"}]], 
    FractionBox["i", 
     RowBox[{"i", "+", "1"}]]}], TraditionalForm]]]
}], "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662810189029336*^9, 3.662810197875327*^9}, {
   3.6676876101551266`*^9, 3.66768761061767*^9}, 3.673312947837206*^9, {
   3.6790530093973794`*^9, 3.679053036597393*^9}, {3.679242648929839*^9, 
   3.679242651815795*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sumatoria", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"n", "-", "4"}], ",", 
     FractionBox["i", 
      RowBox[{"i", "+", "1"}]]}], "}"}], ",", "10"}], "]"}]], "Input",
 CellChangeTimes->{{3.6628101754429674`*^9, 3.66281018556054*^9}, {
  3.6628102216290517`*^9, 3.662810280626129*^9}, {3.662811242210107*^9, 
  3.6628112528777122`*^9}, {3.662811569326579*^9, 3.6628115721253767`*^9}, {
  3.662812162379831*^9, 3.6628121789133043`*^9}, {3.662812704306432*^9, 
  3.6628127045720615`*^9}, {3.662813186397311*^9, 3.6628131929903593`*^9}, {
  3.662817587852474*^9, 3.6628175935300694`*^9}, {3.664897019994054*^9, 
  3.6648970345487084`*^9}, {3.679046776487892*^9, 3.6790467920968337`*^9}, {
  3.679047071537759*^9, 3.6790470925819316`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[n_]:=If[n\[Equal]\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
   FractionBox["3", "4"], "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"Sumatoria[n-1]+\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "4"}], "+", "n"}], 
    RowBox[{
     RowBox[{"-", "3"}], "+", "n"}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm["Sumatoria[n_]:=If[n\[Equal]", 7, ",", 
   Rational[3, 4], ",", 
   "Sumatoria[n-1]+", (-4 + $CellContext`n)/(-3 + $CellContext`n), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051998032241*^9, 3.679246821569685*^9, 
  3.67965436921957*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", 
   FractionBox["6", "7"], "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1361", "420"]}],
  SequenceForm["Sumatoria[", 10, "] = Sumatoria[", 9, "] + ", 
   Rational[6, 7], " = ", 
   Rational[1361, 420]],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051998032241*^9, 3.679246821569685*^9, 
  3.679654369225059*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", 
   FractionBox["5", "6"], "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["143", "60"]}],
  SequenceForm["Sumatoria[", 9, "] = Sumatoria[", 8, "] + ", 
   Rational[5, 6], " = ", 
   Rational[143, 60]],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051998032241*^9, 3.679246821569685*^9, 
  3.679654369231565*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", 
   FractionBox["4", "5"], "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["31", "20"]}],
  SequenceForm["Sumatoria[", 8, "] = Sumatoria[", 7, "] + ", 
   Rational[4, 5], " = ", 
   Rational[31, 20]],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051998032241*^9, 3.679246821569685*^9, 
  3.6796543692410717`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   FractionBox["3", "4"]}],
  SequenceForm["Sumatoria[", 7, "] = ", 
   Rational[3, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.679051998032241*^9, 3.679246821569685*^9, 
  3.6796543692468977`*^9}]
}, Open  ]],

Cell[BoxData[
 FractionBox["1361", "420"]], "Output",
 CellChangeTimes->{3.679051998126025*^9, 3.679246821610734*^9, 
  3.679654369252904*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Quicksort: implementaci\[OAcute]n del algoritmo \
\[OpenCurlyDoubleQuote]quicksort\[CloseCurlyDoubleQuote] desarrollado por el \
cient\[IAcute]fico brit\[AAcute]nico C.A.R Hoare en 1960 (ganador del premio \
Turing en 1980), para ordenar de forma recursiva una lista \
\[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] con \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] datos. La instrucci\[OAcute]n permite visualizar el \
c\[OAcute]digo de programaci\[OAcute]n del comando y las ejecuciones paso a \
paso, mediante el uso de \[OpenCurlyDoubleQuote]code->True\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]steps->True\
\[CloseCurlyDoubleQuote], respectivamente. Sintaxis: Quicksort[n], o bien, \
Quicksort[n, code->Valor, steps->Valor].\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6628928911673083`*^9, 3.6628928939817834`*^9}, 
   3.6628945660421295`*^9}],

Cell["Ejemplo de c\[AAcute]lculo directo.", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quicksort", "[", 
  RowBox[{"1", ",", "8", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "7"}], ",", " ", "5", ",", " ", "4", ",", " ", "10", ",", 
     " ", 
     RowBox[{"-", "8"}], ",", " ", "10", ",", " ", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6628931927266183`*^9, 3.662893200714241*^9}, 
   3.6628939766647606`*^9, {3.662906799690736*^9, 3.662906801253257*^9}, {
   3.6629069776164427`*^9, 3.6629069894216547`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "8"}], ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "5", ",", "10", ",", "9"}],
   "}"}]], "Print",
 CellChangeTimes->{3.6792428471786165`*^9, 3.679246827123024*^9, 
  3.6796546460189734`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "1", ",", "4", ",", "10", ",", "5", 
   ",", "10", ",", "9"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428471786165`*^9, 3.679246827123024*^9, 
  3.679654646025977*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", 
   StyleBox["9",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "5", ",", "10", ",", "10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6792428471786165`*^9, 3.679246827123024*^9, 
  3.6796546460354843`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "9", ",", "5", ",", "10", ",", "10"}],
   "}"}]], "Print",
 CellChangeTimes->{3.6792428471786165`*^9, 3.679246827123024*^9, 
  3.679654646043982*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "9", ",", "10", ",", "10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6792428471786165`*^9, 3.679246827123024*^9, 
  3.679654646055496*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428471786165`*^9, 3.679246827123024*^9, 
  3.67965464606251*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", 
   StyleBox["9",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428471786165`*^9, 3.679246827123024*^9, 
  3.6796546460690155`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428471786165`*^9, 3.679246827123024*^9, 
  3.6796546460774837`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", ",",
    "10"}], "}"}]], "Output",
 CellChangeTimes->{3.6792428472106266`*^9, 3.67924682716854*^9, 
  3.6796546460824876`*^9}]
}, Closed]],

Cell["Ejemplo donde se muestra el c\[OAcute]digo.", "SubitemNumbered",
 CellChangeTimes->{{3.6621226817922716`*^9, 3.662122699614063*^9}, 
   3.6621227615302906`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quicksort", "[", 
  RowBox[{"1", ",", "8", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "7"}], ",", "5", ",", "4", ",", "10", ",", 
     RowBox[{"-", "8"}], ",", "10", ",", "1"}], "}"}], ",", 
   RowBox[{"code", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.662893218137394*^9, 3.6628933052305403`*^9, 3.6629070025682745`*^9, {
   3.6629070599882774`*^9, 3.662907073665094*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "8"}], ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "5", ",", "10", ",", "9"}],
   "}"}]], "Print",
 CellChangeTimes->{3.679242851429878*^9, 3.6792468305149107`*^9, 
  3.6796546780204983`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "1", ",", "4", ",", "10", ",", "5", 
   ",", "10", ",", "9"}], "}"}]], "Print",
 CellChangeTimes->{3.679242851429878*^9, 3.6792468305149107`*^9, 
  3.6796546780285087`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", 
   StyleBox["9",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "5", ",", "10", ",", "10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.679242851429878*^9, 3.6792468305149107`*^9, 
  3.6796546780360136`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "9", ",", "5", ",", "10", ",", "10"}],
   "}"}]], "Print",
 CellChangeTimes->{3.679242851429878*^9, 3.6792468305149107`*^9, 
  3.6796546780440197`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "9", ",", "10", ",", "10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.679242851429878*^9, 3.6792468305149107`*^9, 
  3.679654678054537*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.679242851429878*^9, 3.6792468305149107`*^9, 
  3.679654678060541*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", 
   StyleBox["9",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.679242851429878*^9, 3.6792468305149107`*^9, 
  3.679654678067045*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.679242851429878*^9, 3.6792468305149107`*^9, 
  3.6796546780730505`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", 
     ",", "10"}], "}"}], 
   ",", "\<\"Quicksort[begin_,end_]:=Module[{},If[begin<end, i=begin; \
j=end;piv=L[[Floor[(begin+end)/2]]];While[i\[LessEqual]j, While[L[[i]]<piv, \
i++]; While[L[[j]]>piv,j--];If[i\[LessEqual]j, aux=L[[i]]; L[[i]]=L[[j]]; \
L[[j]]=aux; i++; \
j--]];Print[ReplacePart[L,Style[L[[Floor[(begin+end)/2]]],Blue],Floor[(begin+\
end)/2]]];If[begin<j,Quicksort[begin,j]]; If[i<end,Quicksort[i, \
end]]];L]\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.679242851429878*^9, 3.6792468305149107`*^9, 
  3.6796546780784836`*^9}]
}, Open  ]]
}, Closed]],

Cell["Ejemplo donde se muestra paso a paso el resultado.", "SubitemNumbered",
 CellChangeTimes->{{3.6621227379144974`*^9, 3.662122764092825*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quicksort", "[", 
  RowBox[{"1", ",", "8", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "7"}], ",", "5", ",", "4", ",", "10", ",", 
     RowBox[{"-", "8"}], ",", "10", ",", "1"}], "}"}], ",", 
   RowBox[{"steps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{3.662893227375182*^9, 3.662893308185708*^9, 
  3.662907006038825*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "7"}], ",", "5", ",", 
     StyleBox["4",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "10", ",", 
     RowBox[{"-", "8"}], ",", "10", ",", "1"}], "}"}]}],
  SequenceForm["Quicksort[", 1, ",", 8, "] = ", {9, -7, 5, 
    Style[4, 
     RGBColor[0, 0, 1]], 10, -8, 10, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704712168*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["9",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "7"}], ",", "5", ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", 
   RowBox[{"-", "8"}], ",", "10", ",", 
   StyleBox["1",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547047166758`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", "5", ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", 
   RowBox[{"-", "8"}], ",", "10", ",", "9"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704724181*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", 
   StyleBox[
    RowBox[{"-", "8"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "10", ",", "9"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547047317047`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "8"}], ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "5", ",", "10", ",", "9"}],
   "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547047372065`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "8"}], ",", 
   StyleBox[
    StyleBox[
     StyleBox["4",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "10", ",", "5", ",", "10", ",", "9"}],
   "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704742694*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "8"}], ",", "4", ",", "10", ",", "5", ",", "10", ",", "9"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704748205*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "8"}], ",", "4", ",", "10", ",", "5", ",", "10", ",", "9"}],
     "}"}]}],
  SequenceForm["L = ", {1, -7, -8, 4, 10, 5, 10, 9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704756211*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     StyleBox[
      RowBox[{"-", "7"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", 
     RowBox[{"-", "8"}]}], "}"}]}],
  SequenceForm["Quicksort[", 1, ",", 3, "] = ", {1, 
    Style[-7, 
     RGBColor[0, 0, 1]], -8}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.67965470476422*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["1",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   StyleBox[
    RowBox[{"-", "8"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547047717223`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547047767277`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   StyleBox[
    StyleBox[
     StyleBox[
      RowBox[{"-", "7"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704784238*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704790759*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "10", ",", "5", ",", "10", 
     ",", "9"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 10, 5, 10, 9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704795258*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", 
     StyleBox["10",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "5", ",", "10", ",", "9"}], "}"}]}],
  
  SequenceForm["Quicksort[", 3, ",", 8, "] = ", {1, 4, 
    Style[10, 
     RGBColor[0, 0, 1]], 5, 10, 9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704801626*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", 
   StyleBox[
    StyleBox["10",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "5", ",", "10", ",", 
   StyleBox["9",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547048081307`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "5", ",", "10", ",", "10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704813656*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "5", ",", 
   StyleBox[
    StyleBox["10",
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547048180666`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "5", ",", "10", ",", "10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547048260713`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "9", ",", "5", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 9, 5, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704831576*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     StyleBox["4",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "9", ",", "5"}], "}"}]}],
  SequenceForm["Quicksort[", 3, ",", 6, "] = ", {1, 
    Style[4, 
     RGBColor[0, 0, 1]], 9, 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547048365793`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   StyleBox[
    StyleBox[
     StyleBox["4",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "9", ",", "5"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704842103*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "5"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.67965470484663*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "9", ",", "5", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 9, 5, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704851633*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["9",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "5"}], "}"}]}],
  SequenceForm["Quicksort[", 5, ",", 6, "] = ", {
    Style[9, 
     RGBColor[0, 0, 1]], 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704858125*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox["9",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704869632*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "9"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704875637*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 5, 9, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547048846407`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     StyleBox["10",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]}],
  SequenceForm["Quicksort[", 6, ",", 8, "] = ", {9, 
    Style[10, 
     RGBColor[0, 0, 1]], 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704892643*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", 
   StyleBox[
    StyleBox["10",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547049001465`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "10", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547049066577`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 5, 9, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704915162*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["9",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]}],
  SequenceForm["Quicksort[", 6, ",", 7, "] = ", {
    Style[9, 
     RGBColor[0, 0, 1]], 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704922668*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox[
     StyleBox["9",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704933176*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704941181*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 5, 9, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704951188*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["10",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]}],
  SequenceForm["Quicksort[", 7, ",", 8, "] = ", {
    Style[10, 
     RGBColor[0, 0, 1]], 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.6796547049585557`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox["10",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.67965470496756*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704976567*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 5, 9, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428565381083`*^9, 3.6792468352994103`*^9, 
  3.679654704988075*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", ",",
    "10"}], "}"}]], "Output",
 CellChangeTimes->{3.679242856733513*^9, 3.679246835499834*^9, 
  3.6796547049970846`*^9}]
}, Closed]],

Cell["\<\
Ejemplo donde se muestra el c\[OAcute]digo y las iteraciones recursivas.\
\>", "SubitemNumbered",
 CellChangeTimes->{{3.6621227987253227`*^9, 3.6621228212222123`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quicksort", "[", 
  RowBox[{"1", ",", "8", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "7"}], ",", "5", ",", "4", ",", "10", ",", 
     RowBox[{"-", "8"}], ",", "10", ",", "1"}], "}"}], ",", 
   RowBox[{"code", "\[Rule]", "True"}], ",", 
   RowBox[{"steps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{3.6628932380199633`*^9, 3.6628933113131075`*^9, 
  3.6629070084265146`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "8"}], ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "5", ",", "10", ",", "9"}],
   "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547303215866`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "1", ",", "4", ",", "10", ",", "5", 
   ",", "10", ",", "9"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730327111*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", 
   StyleBox["9",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "5", ",", "10", ",", "10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730332594*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "9", ",", "5", ",", "10", ",", "10"}],
   "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547303385997`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "9", ",", "10", ",", "10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730344123*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547303496532`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", 
   StyleBox["9",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730355153*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547303650618`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", 
     ",", "10"}], "}"}], 
   ",", "\<\"Quicksort[begin_,end_]:=Module[{},If[begin<end, i=begin; \
j=end;piv=L[[Floor[(begin+end)/2]]];While[i\[LessEqual]j, While[L[[i]]<piv, \
i++]; While[L[[j]]>piv,j--];If[i\[LessEqual]j, aux=L[[i]]; L[[i]]=L[[j]]; \
L[[j]]=aux; i++; \
j--]];Print[ReplacePart[L,Style[L[[Floor[(begin+end)/2]]],Blue],Floor[(begin+\
end)/2]]];If[begin<j,Quicksort[begin,j]]; If[i<end,Quicksort[i, \
end]]];L]\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730370575*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "7"}], ",", "5", ",", 
     StyleBox["4",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "10", ",", 
     RowBox[{"-", "8"}], ",", "10", ",", "1"}], "}"}]}],
  SequenceForm["Quicksort[", 1, ",", 8, "] = ", {9, -7, 5, 
    Style[4, 
     RGBColor[0, 0, 1]], 10, -8, 10, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730377022*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["9",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   RowBox[{"-", "7"}], ",", "5", ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", 
   RowBox[{"-", "8"}], ",", "10", ",", 
   StyleBox["1",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547303855505`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", "5", ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", 
   RowBox[{"-", "8"}], ",", "10", ",", "9"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730390579*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", 
   StyleBox[
    RowBox[{"-", "8"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "10", ",", "9"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547303955793`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "8"}], ",", 
   StyleBox["4",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "10", ",", "5", ",", "10", ",", "9"}],
   "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304015765`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "8"}], ",", 
   StyleBox[
    StyleBox[
     StyleBox["4",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "10", ",", "5", ",", "10", ",", "9"}],
   "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730406599*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "8"}], ",", "4", ",", "10", ",", "5", ",", "10", ",", "9"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304120855`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "8"}], ",", "4", ",", "10", ",", "5", ",", "10", ",", "9"}],
     "}"}]}],
  SequenceForm["L = ", {1, -7, -8, 4, 10, 5, 10, 9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730417591*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     StyleBox[
      RowBox[{"-", "7"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", 
     RowBox[{"-", "8"}]}], "}"}]}],
  SequenceForm["Quicksort[", 1, ",", 3, "] = ", {1, 
    Style[-7, 
     RGBColor[0, 0, 1]], -8}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730425596*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["1",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", 
   StyleBox[
    RowBox[{"-", "8"}],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304311*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   StyleBox[
    RowBox[{"-", "7"}],
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304356036`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   StyleBox[
    StyleBox[
     StyleBox[
      RowBox[{"-", "7"}],
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730445521*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304505453`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "10", ",", "5", ",", "10", 
     ",", "9"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 10, 5, 10, 9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304555483`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", 
     StyleBox["10",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "5", ",", "10", ",", "9"}], "}"}]}],
  
  SequenceForm["Quicksort[", 3, ",", 8, "] = ", {1, 4, 
    Style[10, 
     RGBColor[0, 0, 1]], 5, 10, 9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730461571*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", 
   StyleBox[
    StyleBox["10",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "5", ",", "10", ",", 
   StyleBox["9",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304670753`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "5", ",", "10", ",", "10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304725804`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "5", ",", 
   StyleBox[
    StyleBox["10",
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304790497`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "5", ",", "10", ",", "10"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730486596*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "9", ",", "5", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 9, 5, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304915967`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     StyleBox["4",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "9", ",", "5"}], "}"}]}],
  SequenceForm["Quicksort[", 3, ",", 6, "] = ", {1, 
    Style[4, 
     RGBColor[0, 0, 1]], 9, 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547304955835`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   StyleBox[
    StyleBox[
     StyleBox["4",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "9", ",", "5"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.67965473050204*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "5"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305070467`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "9", ",", "5", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 9, 5, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305120506`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["9",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "5"}], "}"}]}],
  SequenceForm["Quicksort[", 5, ",", 6, "] = ", {
    Style[9, 
     RGBColor[0, 0, 1]], 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730518555*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox["9",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox["5",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305265613`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "9"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305315647`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 5, 9, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730536997*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"9", ",", 
     StyleBox["10",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]}],
  SequenceForm["Quicksort[", 6, ",", 8, "] = ", {9, 
    Style[10, 
     RGBColor[0, 0, 1]], 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730542505*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", 
   StyleBox[
    StyleBox["10",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305480146`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "10", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730553018*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 5, 9, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305600395`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["9",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]}],
  SequenceForm["Quicksort[", 6, ",", 7, "] = ", {
    Style[9, 
     RGBColor[0, 0, 1]], 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305670443`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox[
     StyleBox["9",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]],
     StripOnInput->False,
     LineColor->RGBColor[1, 0, 0],
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730572551*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305785007`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 5, 9, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305860057`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quicksort[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["10",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontColor->RGBColor[0, 0, 1]], ",", "10"}], "}"}]}],
  SequenceForm["Quicksort[", 7, ",", 8, "] = ", {
    Style[10, 
     RGBColor[0, 0, 1]], 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305920124`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    StyleBox["10",
     StripOnInput->False,
     LineColor->RGBColor[0, 0, 1],
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]], ",", 
   StyleBox["10",
    StripOnInput->False,
    LineColor->RGBColor[1, 0, 0],
    FrontFaceColor->RGBColor[1, 0, 0],
    BackFaceColor->RGBColor[1, 0, 0],
    GraphicsColor->RGBColor[1, 0, 0],
    FontColor->RGBColor[1, 0, 0]]}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.6796547305980277`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "10"}], "}"}]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730603033*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", 
     ",", "10"}], "}"}]}],
  SequenceForm["L = ", {-8, -7, 1, 4, 5, 9, 10, 10}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792428621932907`*^9, 3.679246840801704*^9, 
  3.679654730608543*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "7"}], ",", "1", ",", "4", ",", "5", ",", "9", ",", "10", ",",
    "10"}], "}"}]], "Output",
 CellChangeTimes->{3.6792428624174566`*^9, 3.6792468410498114`*^9, 
  3.6796547306135445`*^9}]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Relaciones de recurrencia", "Section",
 CellChangeTimes->{{3.6621146329845805`*^9, 3.6621146423631773`*^9}, {
   3.6621146904244285`*^9, 3.6621147363634095`*^9}, {3.662114780047743*^9, 
   3.6621148132546997`*^9}, 3.673388436485571*^9, {3.679241710785407*^9, 
   3.6792417164615097`*^9}}],

Cell[CellGroupData[{

Cell["\<\
GraficaRRL: instrucci\[OAcute]n que grafica una relaci\[OAcute]n de \
recurrencia lineal permitiendo al usuario las opciones de especificar la \
cantidad de puntos a representar y un valor m\[AAcute]ximo de observaci\
\[OAcute]n sobre el eje de las ordenadas. Sintaxis: GraficaRRL[Coeficientes, \
Condiciones], siendo \[OpenCurlyDoubleQuote]Coeficientes\
\[CloseCurlyDoubleQuote] un vector de coeficientes en orden descendente y/o \
que contiene la parte no homog\[EAcute]nea (en funci\[OAcute]n de \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]) de la relaci\[OAcute]n de \
recurrencia como su \[UAcute]ltima componente y \
\[OpenCurlyDoubleQuote]Condiciones\[CloseCurlyDoubleQuote] la lista de \
condiciones iniciales en orden ascendente. Adem\[AAcute]s, \
GraficaRRL[Coeficientes, Condiciones, npuntos->Valor, ymax->Valor, \
inicio->Valor] da las opciones al usuario de escoger la cantidad de puntos a \
graficar, el valor m\[AAcute]ximo de visualizaci\[OAcute]n sobre el eje \
\[OpenCurlyDoubleQuote]y\[CloseCurlyDoubleQuote] y el inicio del dominio de \
la relaci\[OAcute]n de recurrencia, respectivamente. \
\[OpenCurlyDoubleQuote]ymax\[CloseCurlyDoubleQuote] acepta el atributo \
\[OpenCurlyDoubleQuote]All\[CloseCurlyDoubleQuote] que muestra todos los \
puntos involucrados en la graficaci\[OAcute]n. Por defecto, \
\[OpenCurlyDoubleQuote]npuntos->10\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ymax->All\[CloseCurlyDoubleQuote] e \
\[OpenCurlyDoubleQuote]inicio->1\[CloseCurlyDoubleQuote].\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6633253492232847`*^9, 3.663325383015751*^9}, {
   3.6633259146360636`*^9, 3.663325989355534*^9}, {3.6633261045165358`*^9, 
   3.663326220145146*^9}, {3.6633277130777864`*^9, 3.6633277183302035`*^9}, {
   3.6633441743760443`*^9, 3.6633442005829163`*^9}, 3.663440317494527*^9, 
   3.6634413438489466`*^9, {3.663441620491157*^9, 3.663441626147483*^9}, 
   3.663602950483899*^9}],

Cell[TextData[{
 "Ejemplo 1: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["a", "n"], "=", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "1"}]]}], "+", 
      RowBox[{"2", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "2"}]]}], "+", 
      RowBox[{"6", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "3"}]]}]}]}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "1"], "=", "9"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "2"], "=", "8"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "3"], "=", "3"}]}], TraditionalForm]]]
}], "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6633441494012117`*^9, 
   3.6633441531245947`*^9}, {3.6633441836503696`*^9, 3.663344185494075*^9}, {
   3.6792434437433405`*^9, 3.679243464046711*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraficaRRL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "3"}], "}"}], ",", 
   RowBox[{"inicio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.663440392487014*^9, 3.6634404285327024`*^9}, {
  3.663440468877666*^9, 3.6634404690182962`*^9}, {3.6636028301602645`*^9, 
  3.663602831504032*^9}, {3.663602992640293*^9, 3.6636030158638163`*^9}, {
  3.679655098054556*^9, 3.6796550987171445`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
    AbsoluteThickness[1.6], {
     {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
      0.2], LineBox[{{{3., 3.}, {3., 3.}}},
       VertexColors->None]}, 
     {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
      0.2], LineBox[{{{1., 9.}, {1., 3.}}, {{2., 8.}, {2., 3.}}, {{4., 76.}, {
       4., 3.}}, {{5., 206.}, {5., 3.}}, {{6., 582.}, {6., 3.}}, {{7., 
       2032.}, {7., 3.}}, {{8., 6464.}, {8., 3.}}, {{9., 20484.}, {9., 
       3.}}, {{10., 66088.}, {10., 3.}}},
       VertexColors->None]}}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
    AbsoluteThickness[1.6], {}, 
    PointBox[{{1., 9.}, {2., 8.}, {3., 3.}, {4., 76.}, {5., 206.}, {6., 
     582.}, {7., 2032.}, {8., 6464.}, {9., 20484.}, {10., 66088.}}], {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 3.},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05]},
  PlotRange->{{1., 10.}, {3., 66088.}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6792468500910673`*^9, {3.6796550747732234`*^9, 3.679655101789175*^9}}]
}, Closed]],

Cell[TextData[{
 "Ejemplo 2: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["a", "n"], "=", 
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "1"}]]}], "+", 
      RowBox[{"2", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "2"}]]}], "+", 
      RowBox[{"6", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "3"}]]}], "+", 
      SuperscriptBox["n", "2"], "-", 
      RowBox[{"6", "n"}], "+", "1"}]}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "1"], "=", "9"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "2"], "=", "8"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "3"], "=", "3"}]}], TraditionalForm]]]
}], "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6633441494012117`*^9, 
   3.6633441531245947`*^9}, {3.6633441880036726`*^9, 
   3.6633441883317833`*^9}, {3.679243471617836*^9, 3.679243508674485*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraficaRRL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "6", ",", 
     RowBox[{
      SuperscriptBox["n", "2"], "-", 
      RowBox[{"6", "n"}], "+", "1"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "3"}], "}"}], ",", 
   RowBox[{"npuntos", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.6634404017702465`*^9, {3.663440464852124*^9, 3.663440499704968*^9}, {
   3.6634407862384706`*^9, 3.6634408067636895`*^9}, {3.6636020644220467`*^9, 
   3.6636020661694255`*^9}, {3.6636028376278563`*^9, 3.6636028410758157`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
    AbsoluteThickness[1.6], {
     {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
      0.2], LineBox[{{{3., 3.}, {3., 3.}}},
       VertexColors->None]}, 
     {RGBColor[0, 1, 0], PointSize[0.02], AbsoluteThickness[1.6], Opacity[
      0.2], LineBox[CompressedData["
1:eJxTTMoPSmVmYGAQBmImKIaAD/YQWskBlc8B5TNAaQU0PkxeAEI7BKLy4fIi
ELohHZUPl5eA0CsaUPlweRkIrTAXlQ+Xh7rLeDuaO2HyShA65RIqHy6vAqYf
rH6LwkfIq4Fph1Psjsh8hLwGmH7Hq+yIzEfIa4FpkYl2jsh8hLwOiD7A2xTh
iMRHktcD0Q3nlhY7IvGR5A1A9I6uxn5HJD6SvCGI5pjrtNIRiY8kbwSkG/5P
czjiiOAjyxuDaMcjNg8ckfhI8iZA+kNzOucvRwQfIg8Arus3pw==
       "],
       VertexColors->None]}}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
    AbsoluteThickness[1.6], {}, PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7CG0kgNUAEorQGkONFoAQjsEQvkiELohHcqX
gNArGqB8GQitMBfVXOPtDij2plyC8lXA9IPVb6F8NTDtcIrdEcLXAPPf8SpD
+VpgvshEOyhfB8Q/wNsUAeXrgfgN55YWQ/kGIP6OrsZ+KN8QxOeY67QSyjcC
8hv+T3M4AuUbg+Qdj9g8gPJNgPwPzemcvxwB2qIqpA==
     "]], {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 3.},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05]},
  PlotRange->{{1., 20.}, {3., 6.989183039*^9}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.6792468558388042`*^9, 3.6796551516362343`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
MetodoRRHL: muestra paso a paso la aplicaci\[OAcute]n de uno de los \
m\[EAcute]todos cl\[AAcute]sicos para resolver una relaci\[OAcute]n de \
recurrencia homog\[EAcute]nea lineal con coeficientes constantes, a trav\
\[EAcute]s del uso de una ecuaci\[OAcute]n denominada \
\[OpenCurlyDoubleQuote]ecuaci\[OAcute]n caracter\[IAcute]stica\
\[CloseCurlyDoubleQuote]. Sintaxis: MetodoRRHL[Coeficientes, Condiciones, n, \
b] siendo \[OpenCurlyDoubleQuote]Coeficientes\[CloseCurlyDoubleQuote] un \
vector de coeficientes num\[EAcute]ricos en orden descendente, \
\[OpenCurlyDoubleQuote]Condiciones\[CloseCurlyDoubleQuote] las condiciones \
iniciales en orden ascendente, \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] el par\[AAcute]metro con el que se visualizar\
\[AAcute] la soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia y \
\[OpenCurlyDoubleQuote]b\[CloseCurlyDoubleQuote] el nombre de la variable del \
sistema de ecuaciones que emplea el procedimiento. Por defecto, el dominio \
corresponde al conjunto de los n\[UAcute]meros naturales (no incluye el \
cero). La instrucci\[OAcute]n integra las alternativas \
\[OpenCurlyDoubleQuote]decimal->True\[CloseCurlyDoubleQuote] que exhibe el \
resultado con un formato decimal e \[OpenCurlyDoubleQuote]inicio->Valor\
\[CloseCurlyDoubleQuote] que define el primer elemento (\
\[OpenCurlyDoubleQuote]Valor\[CloseCurlyDoubleQuote]) del dominio si se \
deseara cambiar. Originalmente, \[OpenCurlyDoubleQuote]decimal\
\[CloseCurlyDoubleQuote] tiene el valor l\[OAcute]gico \
\[OpenCurlyDoubleQuote]False\[CloseCurlyDoubleQuote] e \
\[OpenCurlyDoubleQuote]inicio->1\[CloseCurlyDoubleQuote].\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6633253492232847`*^9, 3.663325383015751*^9}, {
   3.6633259146360636`*^9, 3.663325989355534*^9}, {3.6633261045165358`*^9, 
   3.663326220145146*^9}, {3.6633277130777864`*^9, 3.6633277183302035`*^9}, {
   3.6633441743760443`*^9, 3.6633442005829163`*^9}, 3.663495591100851*^9, 
   3.6634968520957956`*^9, {3.663501181695487*^9, 3.663501213593603*^9}, 
   3.663509853183674*^9, {3.6635123901603394`*^9, 3.663512407552807*^9}, {
   3.663604740468565*^9, 3.6636047415989327`*^9}, {3.6733873551439695`*^9, 
   3.673387366180344*^9}, {3.6733874237007856`*^9, 3.6733874281597614`*^9}, 
   3.673387489042446*^9, {3.673387596043948*^9, 3.6733876216650715`*^9}, {
   3.6790507627273655`*^9, 3.679050788960275*^9}, {3.6790511295496683`*^9, 
   3.6790512465740857`*^9}, 3.6790512825260196`*^9, 3.679061407031685*^9, 
   3.6792429890070057`*^9}],

Cell[TextData[{
 "Ejemplo 1: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["a", "n"], "=", 
     RowBox[{
      RowBox[{"5", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "1"}]]}], "+", 
      RowBox[{"6", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "2"}]]}], "+", 
      RowBox[{"3", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "3"}]]}]}]}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "1"], "=", "9"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "2"], "=", "8"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "3"], "=", "1"}]}], TraditionalForm]]]
}], "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6633441494012117`*^9, 
   3.6633441531245947`*^9}, {3.6633441880036726`*^9, 3.6633441883317833`*^9}, 
   3.6733876572818713`*^9, {3.679051424161167*^9, 3.6790514244785166`*^9}, {
   3.679053062824997*^9, 3.6790531435328913`*^9}, {3.679243351149936*^9, 
   3.6792433536778193`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "1"}], "}"}], ",", " ", "n", ",", "b", ",", 
   RowBox[{"decimal", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.663362844599574*^9, 3.6634950822558417`*^9, {3.663496911670621*^9, 
   3.6634969398417587`*^9}, {3.663509904131674*^9, 3.6635099111127768`*^9}, {
   3.663510046770601*^9, 3.663510046973729*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "3.`"}], "-", 
    RowBox[{"6.`", " ", "n"}], "-", 
    RowBox[{"5.`", " ", 
     SuperscriptBox["n", "2"]}], "+", 
    SuperscriptBox["n", "3"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", -3. - 
   6. $CellContext`n - 5. $CellContext`n^2 + $CellContext`n^3, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520077887187`*^9, 3.679246861931447*^9, 
  3.6796555479493866`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.5349538822852485`"}], "-", 
      RowBox[{"0.45614229289626723`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.5349538822852485`"}], "+", 
      RowBox[{"0.45614229289626723`", " ", "\[ImaginaryI]"}]}], ",", 
     "6.069907764570497`"}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {
    Complex[-0.5349538822852485, -0.45614229289626723`], 
    Complex[-0.5349538822852485, 0.45614229289626723`], 6.069907764570497}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520077887187`*^9, 3.679246861931447*^9, 
  3.6796555480276957`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "0.5349538822852485`"}], "-", 
        RowBox[{"0.45614229289626723`", " ", "\[ImaginaryI]"}]}], ")"}], "n"],
      " ", 
     SubscriptBox["b", "1"]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "0.5349538822852485`"}], "+", 
        RowBox[{"0.45614229289626723`", " ", "\[ImaginaryI]"}]}], ")"}], "n"],
      " ", 
     SubscriptBox["b", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["6.069907764570497`", "n"], " ", 
     SubscriptBox["b", "3"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", 
   Complex[-0.5349538822852485, -0.45614229289626723`]^$CellContext`n 
    Subscript[$CellContext`b, 1] + 
   Complex[-0.5349538822852485, 0.45614229289626723`]^$CellContext`n 
    Subscript[$CellContext`b, 2] + 
   6.069907764570497^$CellContext`n Subscript[$CellContext`b, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520077887187`*^9, 3.679246861931447*^9, 
  3.679655548040204*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "0.5349538822852485`"}], "-", 
          RowBox[{"0.45614229289626723`", " ", "\[ImaginaryI]"}]}], ")"}], 
        " ", 
        SubscriptBox["b", "1"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.5349538822852485`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.45614229289626723`", " ", "\[ImaginaryI]"}]}], ")"}], 
        " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"6.069907764570497`", " ", 
        SubscriptBox["b", "3"]}]}], "\[Equal]", "9"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.0781098648033955`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.4880301809187062`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        SubscriptBox["b", "1"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.0781098648033955`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.4880301809187062`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"36.84378027039321`", " ", 
        SubscriptBox["b", "3"]}]}], "\[Equal]", "8"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.18082603030548644`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.2967028527840724`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        SubscriptBox["b", "1"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.18082603030548644`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.2967028527840724`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"223.63834793938904`", " ", 
        SubscriptBox["b", "3"]}]}], "\[Equal]", "1"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {
   Complex[-0.5349538822852485, -0.45614229289626723`] 
      Subscript[$CellContext`b, 1] + 
     Complex[-0.5349538822852485, 0.45614229289626723`] 
      Subscript[$CellContext`b, 2] + 
     6.069907764570497 Subscript[$CellContext`b, 3] == 9, 
    Complex[0.0781098648033955, 0.4880301809187062] 
      Subscript[$CellContext`b, 1] + 
     Complex[0.0781098648033955, -0.4880301809187062] 
      Subscript[$CellContext`b, 2] + 
     36.84378027039321 Subscript[$CellContext`b, 3] == 8, 
    Complex[0.18082603030548644`, -0.2967028527840724] 
      Subscript[$CellContext`b, 1] + 
     Complex[0.18082603030548644`, 0.2967028527840724] 
      Subscript[$CellContext`b, 2] + 
     223.63834793938904` Subscript[$CellContext`b, 3] == 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520077887187`*^9, 3.679246861931447*^9, 
  3.6796555480492153`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "15.526324045813697`"}], "-", 
       RowBox[{"8.693892054662337`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "15.526324045813697`"}], "+", 
       RowBox[{"8.69389205466234`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "3"], "\[Rule]", 
      RowBox[{"0.05264809162739596`", "\[VeryThinSpace]", "-", 
       RowBox[{"6.391006034951577`*^-18", " ", "\[ImaginaryI]"}]}]}]}], 
    "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> 
    Complex[-15.526324045813697`, -8.693892054662337], 
    Subscript[$CellContext`b, 2] -> 
    Complex[-15.526324045813697`, 8.69389205466234], 
    Subscript[$CellContext`b, 3] -> 
    Complex[0.05264809162739596, -6.391006034951577*^-18]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520077887187`*^9, 3.679246861931447*^9, 
  3.6796555481012287`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "15.526324045813697`"}], "-", 
     RowBox[{"8.693892054662337`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1.`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "0.5349538822852485`"}], "-", 
         RowBox[{"0.45614229289626723`", " ", "\[ImaginaryI]"}]}], ")"}], 
       "n"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.5226045139945589`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.8525752294973804`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "0.5349538822852485`"}], "+", 
         RowBox[{"0.45614229289626723`", " ", "\[ImaginaryI]"}]}], ")"}], 
       "n"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.00258149391087474`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.0014454953622434796`", " ", "\[ImaginaryI]"}]}], ")"}], 
      " ", 
      SuperscriptBox["6.069907764570497`", "n"]}]}], ")"}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Complex[-15.526324045813697`, -8.693892054662337] (
    Complex[1., 0.] 
     Complex[-0.5349538822852485, -0.45614229289626723`]^$CellContext`n + 
    Complex[0.5226045139945589, -0.8525752294973804] 
     Complex[-0.5349538822852485, 0.45614229289626723`]^$CellContext`n + 
    Complex[-0.00258149391087474, 0.0014454953622434796`] 
     6.069907764570497^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520077887187`*^9, 3.679246861931447*^9, 
  3.679655548106738*^9}]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Ejemplo 2: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["a", "n"], "=", 
     RowBox[{
      RowBox[{"11", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "1"}]]}], "-", 
      RowBox[{"49", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "2"}]]}], "+", 
      RowBox[{"113", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "3"}]]}], "-", 
      RowBox[{"142", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "4"}]]}], "+", 
      RowBox[{"92", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "5"}]]}], "-", 
      RowBox[{"24", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "6"}]]}]}]}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "0"], "=", "9"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "1"], "=", "8"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "2"], "=", "1"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "3"], "=", "1"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "4"], "=", "1"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "5"], "=", "1"}]}], TraditionalForm]]]
}], "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6633441494012117`*^9, 
   3.6633441531245947`*^9}, {3.6633441925671825`*^9, 3.6633441930046883`*^9}, 
   3.6733876610373807`*^9, {3.6790513784188266`*^9, 3.6790513787503757`*^9}, {
   3.679051430748541*^9, 3.6790514310867214`*^9}, {3.679053162580802*^9, 
   3.6790532763365545`*^9}, {3.6792433579267664`*^9, 3.6792433606455836`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{"-", "49"}], ",", "113", ",", 
     RowBox[{"-", "142"}], ",", "92", ",", 
     RowBox[{"-", "24"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
   ",", " ", "n", ",", "b", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6634950159442515`*^9, 3.663495046069586*^9}, {
  3.6634950849044447`*^9, 3.6634951270299735`*^9}, {3.6634969147643647`*^9, 
  3.6634969437827168`*^9}, {3.663509939972557*^9, 3.6635099408631477`*^9}, {
  3.6635100318484173`*^9, 3.6635100509737854`*^9}, {3.6636036797794633`*^9, 
  3.6636036877717304`*^9}, {3.6636037637360215`*^9, 3.663603770154603*^9}, {
  3.663604158166477*^9, 3.6636041731786084`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"24", "-", 
    RowBox[{"92", " ", "n"}], "+", 
    RowBox[{"142", " ", 
     SuperscriptBox["n", "2"]}], "-", 
    RowBox[{"113", " ", 
     SuperscriptBox["n", "3"]}], "+", 
    RowBox[{"49", " ", 
     SuperscriptBox["n", "4"]}], "-", 
    RowBox[{"11", " ", 
     SuperscriptBox["n", "5"]}], "+", 
    SuperscriptBox["n", "6"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", 24 - 
   92 $CellContext`n + 142 $CellContext`n^2 - 113 $CellContext`n^3 + 
   49 $CellContext`n^4 - 11 $CellContext`n^5 + $CellContext`n^6, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520117426662`*^9, 3.6792468681371956`*^9, 
  3.679655644346281*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {1, 1, 2, 2, 2, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520117426662`*^9, 3.6792468681371956`*^9, 
  3.6796556444394217`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SubscriptBox["b", "1"], "+", 
    RowBox[{"n", " ", 
     SubscriptBox["b", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     SubscriptBox["b", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", "n", " ", 
     SubscriptBox["b", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SubscriptBox["b", "5"]}], "+", 
    RowBox[{
     SuperscriptBox["3", "n"], " ", 
     SubscriptBox["b", "6"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", 
   Subscript[$CellContext`b, 1] + $CellContext`n Subscript[$CellContext`b, 2] + 
   2^$CellContext`n Subscript[$CellContext`b, 3] + 
   2^$CellContext`n $CellContext`n Subscript[$CellContext`b, 4] + 
   2^$CellContext`n $CellContext`n^2 Subscript[$CellContext`b, 5] + 
   3^$CellContext`n Subscript[$CellContext`b, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520117426662`*^9, 3.6792468681371956`*^9, 
  3.6796556444469323`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       SubscriptBox["b", "3"], "+", 
       SubscriptBox["b", "6"]}], "\[Equal]", "9"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       SubscriptBox["b", "2"], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"3", " ", 
        SubscriptBox["b", "6"]}]}], "\[Equal]", "8"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"4", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"8", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"16", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"9", " ", 
        SubscriptBox["b", "6"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"3", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"8", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"24", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"72", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"27", " ", 
        SubscriptBox["b", "6"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"4", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"16", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"64", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"256", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"81", " ", 
        SubscriptBox["b", "6"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"5", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"32", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"160", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"800", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"243", " ", 
        SubscriptBox["b", "6"]}]}], "\[Equal]", "1"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {
   Subscript[$CellContext`b, 1] + Subscript[$CellContext`b, 3] + 
     Subscript[$CellContext`b, 6] == 9, 
    Subscript[$CellContext`b, 1] + Subscript[$CellContext`b, 2] + 
     2 Subscript[$CellContext`b, 3] + 2 Subscript[$CellContext`b, 4] + 
     2 Subscript[$CellContext`b, 5] + 3 Subscript[$CellContext`b, 6] == 8, 
    Subscript[$CellContext`b, 1] + 2 Subscript[$CellContext`b, 2] + 
     4 Subscript[$CellContext`b, 3] + 8 Subscript[$CellContext`b, 4] + 
     16 Subscript[$CellContext`b, 5] + 9 Subscript[$CellContext`b, 6] == 1, 
    Subscript[$CellContext`b, 1] + 3 Subscript[$CellContext`b, 2] + 
     8 Subscript[$CellContext`b, 3] + 24 Subscript[$CellContext`b, 4] + 
     72 Subscript[$CellContext`b, 5] + 27 Subscript[$CellContext`b, 6] == 1, 
    Subscript[$CellContext`b, 1] + 4 Subscript[$CellContext`b, 2] + 
     16 Subscript[$CellContext`b, 3] + 64 Subscript[$CellContext`b, 4] + 
     256 Subscript[$CellContext`b, 5] + 81 Subscript[$CellContext`b, 6] == 1, 
    Subscript[$CellContext`b, 1] + 5 Subscript[$CellContext`b, 2] + 
     32 Subscript[$CellContext`b, 3] + 160 Subscript[$CellContext`b, 4] + 
     800 Subscript[$CellContext`b, 5] + 243 Subscript[$CellContext`b, 6] == 
    1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520117426662`*^9, 3.6792468681371956`*^9, 
  3.6796556444539356`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", "440"}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", "142"}], ",", 
     RowBox[{
      SubscriptBox["b", "3"], "\[Rule]", 
      RowBox[{"-", "464"}]}], ",", 
     RowBox[{
      SubscriptBox["b", "4"], "\[Rule]", 
      FractionBox["301", "2"]}], ",", 
     RowBox[{
      SubscriptBox["b", "5"], "\[Rule]", 
      RowBox[{"-", "23"}]}], ",", 
     RowBox[{
      SubscriptBox["b", "6"], "\[Rule]", "33"}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> 440, Subscript[$CellContext`b, 2] -> 142, 
    Subscript[$CellContext`b, 3] -> -464, Subscript[$CellContext`b, 4] -> 
    Rational[301, 2], Subscript[$CellContext`b, 5] -> -23, 
    Subscript[$CellContext`b, 6] -> 33}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520117426662`*^9, 3.6792468681371956`*^9, 
  3.6796556446047144`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"880", "-", 
      RowBox[{"29", " ", 
       SuperscriptBox["2", 
        RowBox[{"5", "+", "n"}]]}], "+", 
      RowBox[{"22", " ", 
       SuperscriptBox["3", 
        RowBox[{"1", "+", "n"}]]}], "+", 
      RowBox[{"284", " ", "n"}], "+", 
      RowBox[{"301", " ", 
       SuperscriptBox["2", "n"], " ", "n"}], "-", 
      RowBox[{"23", " ", 
       SuperscriptBox["2", 
        RowBox[{"1", "+", "n"}]], " ", 
       SuperscriptBox["n", "2"]}]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[1, 2] (880 - 29 2^(5 + $CellContext`n) + 
    22 3^(1 + $CellContext`n) + 284 $CellContext`n + 
    301 2^$CellContext`n $CellContext`n - 23 
    2^(1 + $CellContext`n) $CellContext`n^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520117426662`*^9, 3.6792468681371956`*^9, 
  3.6796556446348085`*^9}]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Ejemplo 3: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["a", "n"], "=", 
     RowBox[{
      RowBox[{"21", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "1"}]]}], "-", 
      RowBox[{"192", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "2"}]]}], "+", 
      RowBox[{"1002", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "3"}]]}], "-", 
      RowBox[{"3285", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "4"}]]}], "+", 
      RowBox[{"7005", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "5"}]]}], "-", 
      RowBox[{"9698", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "6"}]]}], "+", 
      RowBox[{"8388", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "7"}]]}], "-", 
      RowBox[{"4104", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "8"}]]}], "+", 
      RowBox[{"864", 
       SubscriptBox["a", 
        RowBox[{"n", "-", "9"}]]}]}]}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "5"], "=", "1"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "6"], "=", 
     RowBox[{"-", "2"}]}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "7"], "=", "3"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "8"], "=", 
     RowBox[{"-", "4"}]}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "9"], "=", "5"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "10"], "=", 
     RowBox[{"-", "6"}]}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "11"], "=", "7"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "12"], "=", "1"}], ",", " ", 
    RowBox[{
     SubscriptBox["a", "13"], "=", "2"}]}], TraditionalForm]]]
}], "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6633441494012117`*^9, 
   3.6633441531245947`*^9}, {3.663344195192218*^9, 3.6633441955515966`*^9}, 
   3.6733876667962294`*^9, {3.6790514019198694`*^9, 3.679051402305792*^9}, {
   3.679051458129936*^9, 3.6790514585678587`*^9}, {3.67905328910677*^9, 
   3.679053393183216*^9}, {3.679053453900078*^9, 3.6790535043513336`*^9}, {
   3.679053755507756*^9, 3.679053771975093*^9}, {3.6792433636979294`*^9, 
   3.6792433663305287`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"21", ",", " ", 
     RowBox[{"-", "192"}], ",", " ", "1002", ",", " ", 
     RowBox[{"-", "3285"}], ",", " ", "7005", ",", " ", 
     RowBox[{"-", "9698"}], ",", " ", "8388", ",", " ", 
     RowBox[{"-", "4104"}], ",", " ", "864"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", 
     RowBox[{"-", "2"}], ",", " ", "3", ",", " ", 
     RowBox[{"-", "4"}], ",", " ", "5", ",", " ", 
     RowBox[{"-", "6"}], ",", " ", "7", ",", " ", "1", ",", " ", "2"}], "}"}],
    ",", "n", " ", ",", "b", ",", 
   RowBox[{"inicio", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6635099653326216`*^9, 3.663509969749571*^9}, {
  3.663510034925415*^9, 3.6635100353005486`*^9}, {3.663510564061888*^9, 
  3.6635105662010202`*^9}, {3.6635121966002083`*^9, 3.6635122137756987`*^9}, {
  3.6636041980173864`*^9, 3.663604199876786*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "864"}], "+", 
    RowBox[{"4104", " ", "n"}], "-", 
    RowBox[{"8388", " ", 
     SuperscriptBox["n", "2"]}], "+", 
    RowBox[{"9698", " ", 
     SuperscriptBox["n", "3"]}], "-", 
    RowBox[{"7005", " ", 
     SuperscriptBox["n", "4"]}], "+", 
    RowBox[{"3285", " ", 
     SuperscriptBox["n", "5"]}], "-", 
    RowBox[{"1002", " ", 
     SuperscriptBox["n", "6"]}], "+", 
    RowBox[{"192", " ", 
     SuperscriptBox["n", "7"]}], "-", 
    RowBox[{"21", " ", 
     SuperscriptBox["n", "8"]}], "+", 
    SuperscriptBox["n", "9"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", -864 + 
   4104 $CellContext`n - 8388 $CellContext`n^2 + 9698 $CellContext`n^3 - 
   7005 $CellContext`n^4 + 3285 $CellContext`n^5 - 1002 $CellContext`n^6 + 
   192 $CellContext`n^7 - 21 $CellContext`n^8 + $CellContext`n^9, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520160081987`*^9, 3.679053408658347*^9, 
  3.6792468734328628`*^9, 3.67965568978465*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3",
      ",", "4"}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {1, 1, 2, 2, 2, 3, 3, 3, 4}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520160081987`*^9, 3.679053408658347*^9, 
  3.6792468734328628`*^9, 3.6796556897931814`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    SubscriptBox["b", "1"], "+", 
    RowBox[{"n", " ", 
     SubscriptBox["b", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     SubscriptBox["b", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", "n", " ", 
     SubscriptBox["b", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SubscriptBox["b", "5"]}], "+", 
    RowBox[{
     SuperscriptBox["3", "n"], " ", 
     SubscriptBox["b", "6"]}], "+", 
    RowBox[{
     SuperscriptBox["3", "n"], " ", "n", " ", 
     SubscriptBox["b", "7"]}], "+", 
    RowBox[{
     SuperscriptBox["3", "n"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SubscriptBox["b", "8"]}], "+", 
    RowBox[{
     SuperscriptBox["4", "n"], " ", 
     SubscriptBox["b", "9"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", 
   Subscript[$CellContext`b, 1] + $CellContext`n Subscript[$CellContext`b, 2] + 
   2^$CellContext`n Subscript[$CellContext`b, 3] + 
   2^$CellContext`n $CellContext`n Subscript[$CellContext`b, 4] + 
   2^$CellContext`n $CellContext`n^2 Subscript[$CellContext`b, 5] + 
   3^$CellContext`n Subscript[$CellContext`b, 6] + 
   3^$CellContext`n $CellContext`n Subscript[$CellContext`b, 7] + 
   3^$CellContext`n $CellContext`n^2 Subscript[$CellContext`b, 8] + 
   4^$CellContext`n Subscript[$CellContext`b, 9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520160081987`*^9, 3.679053408658347*^9, 
  3.6792468734328628`*^9, 3.679655689802664*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"5", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"32", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"160", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"800", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"243", " ", 
        SubscriptBox["b", "6"]}], "+", 
       RowBox[{"1215", " ", 
        SubscriptBox["b", "7"]}], "+", 
       RowBox[{"6075", " ", 
        SubscriptBox["b", "8"]}], "+", 
       RowBox[{"1024", " ", 
        SubscriptBox["b", "9"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"6", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"64", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"384", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"2304", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"729", " ", 
        SubscriptBox["b", "6"]}], "+", 
       RowBox[{"4374", " ", 
        SubscriptBox["b", "7"]}], "+", 
       RowBox[{"26244", " ", 
        SubscriptBox["b", "8"]}], "+", 
       RowBox[{"4096", " ", 
        SubscriptBox["b", "9"]}]}], "\[Equal]", 
      RowBox[{"-", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"7", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"128", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"896", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"6272", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"2187", " ", 
        SubscriptBox["b", "6"]}], "+", 
       RowBox[{"15309", " ", 
        SubscriptBox["b", "7"]}], "+", 
       RowBox[{"107163", " ", 
        SubscriptBox["b", "8"]}], "+", 
       RowBox[{"16384", " ", 
        SubscriptBox["b", "9"]}]}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"8", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"256", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"2048", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"16384", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"6561", " ", 
        SubscriptBox["b", "6"]}], "+", 
       RowBox[{"52488", " ", 
        SubscriptBox["b", "7"]}], "+", 
       RowBox[{"419904", " ", 
        SubscriptBox["b", "8"]}], "+", 
       RowBox[{"65536", " ", 
        SubscriptBox["b", "9"]}]}], "\[Equal]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"9", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"512", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"4608", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"41472", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"19683", " ", 
        SubscriptBox["b", "6"]}], "+", 
       RowBox[{"177147", " ", 
        SubscriptBox["b", "7"]}], "+", 
       RowBox[{"1594323", " ", 
        SubscriptBox["b", "8"]}], "+", 
       RowBox[{"262144", " ", 
        SubscriptBox["b", "9"]}]}], "\[Equal]", "5"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"10", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"1024", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"10240", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"102400", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"59049", " ", 
        SubscriptBox["b", "6"]}], "+", 
       RowBox[{"590490", " ", 
        SubscriptBox["b", "7"]}], "+", 
       RowBox[{"5904900", " ", 
        SubscriptBox["b", "8"]}], "+", 
       RowBox[{"1048576", " ", 
        SubscriptBox["b", "9"]}]}], "\[Equal]", 
      RowBox[{"-", "6"}]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"11", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"2048", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"22528", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"247808", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"177147", " ", 
        SubscriptBox["b", "6"]}], "+", 
       RowBox[{"1948617", " ", 
        SubscriptBox["b", "7"]}], "+", 
       RowBox[{"21434787", " ", 
        SubscriptBox["b", "8"]}], "+", 
       RowBox[{"4194304", " ", 
        SubscriptBox["b", "9"]}]}], "\[Equal]", "7"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"12", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"4096", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"49152", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"589824", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"531441", " ", 
        SubscriptBox["b", "6"]}], "+", 
       RowBox[{"6377292", " ", 
        SubscriptBox["b", "7"]}], "+", 
       RowBox[{"76527504", " ", 
        SubscriptBox["b", "8"]}], "+", 
       RowBox[{"16777216", " ", 
        SubscriptBox["b", "9"]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], "+", 
       RowBox[{"13", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"8192", " ", 
        SubscriptBox["b", "3"]}], "+", 
       RowBox[{"106496", " ", 
        SubscriptBox["b", "4"]}], "+", 
       RowBox[{"1384448", " ", 
        SubscriptBox["b", "5"]}], "+", 
       RowBox[{"1594323", " ", 
        SubscriptBox["b", "6"]}], "+", 
       RowBox[{"20726199", " ", 
        SubscriptBox["b", "7"]}], "+", 
       RowBox[{"269440587", " ", 
        SubscriptBox["b", "8"]}], "+", 
       RowBox[{"67108864", " ", 
        SubscriptBox["b", "9"]}]}], "\[Equal]", "2"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {
   Subscript[$CellContext`b, 1] + 5 Subscript[$CellContext`b, 2] + 
     32 Subscript[$CellContext`b, 3] + 160 Subscript[$CellContext`b, 4] + 
     800 Subscript[$CellContext`b, 5] + 243 Subscript[$CellContext`b, 6] + 
     1215 Subscript[$CellContext`b, 7] + 6075 Subscript[$CellContext`b, 8] + 
     1024 Subscript[$CellContext`b, 9] == 1, 
    Subscript[$CellContext`b, 1] + 6 Subscript[$CellContext`b, 2] + 
     64 Subscript[$CellContext`b, 3] + 384 Subscript[$CellContext`b, 4] + 
     2304 Subscript[$CellContext`b, 5] + 729 Subscript[$CellContext`b, 6] + 
     4374 Subscript[$CellContext`b, 7] + 26244 Subscript[$CellContext`b, 8] + 
     4096 Subscript[$CellContext`b, 9] == -2, 
    Subscript[$CellContext`b, 1] + 7 Subscript[$CellContext`b, 2] + 
     128 Subscript[$CellContext`b, 3] + 896 Subscript[$CellContext`b, 4] + 
     6272 Subscript[$CellContext`b, 5] + 2187 Subscript[$CellContext`b, 6] + 
     15309 Subscript[$CellContext`b, 7] + 107163 Subscript[$CellContext`b, 8] + 
     16384 Subscript[$CellContext`b, 9] == 3, 
    Subscript[$CellContext`b, 1] + 8 Subscript[$CellContext`b, 2] + 
     256 Subscript[$CellContext`b, 3] + 2048 Subscript[$CellContext`b, 4] + 
     16384 Subscript[$CellContext`b, 5] + 6561 Subscript[$CellContext`b, 6] + 
     52488 Subscript[$CellContext`b, 7] + 419904 Subscript[$CellContext`b, 8] + 
     65536 Subscript[$CellContext`b, 9] == -4, 
    Subscript[$CellContext`b, 1] + 9 Subscript[$CellContext`b, 2] + 
     512 Subscript[$CellContext`b, 3] + 4608 Subscript[$CellContext`b, 4] + 
     41472 Subscript[$CellContext`b, 5] + 19683 Subscript[$CellContext`b, 6] + 
     177147 Subscript[$CellContext`b, 7] + 
     1594323 Subscript[$CellContext`b, 8] + 
     262144 Subscript[$CellContext`b, 9] == 5, 
    Subscript[$CellContext`b, 1] + 10 Subscript[$CellContext`b, 2] + 
     1024 Subscript[$CellContext`b, 3] + 10240 Subscript[$CellContext`b, 4] + 
     102400 Subscript[$CellContext`b, 5] + 59049 Subscript[$CellContext`b, 6] + 
     590490 Subscript[$CellContext`b, 7] + 
     5904900 Subscript[$CellContext`b, 8] + 
     1048576 Subscript[$CellContext`b, 9] == -6, 
    Subscript[$CellContext`b, 1] + 11 Subscript[$CellContext`b, 2] + 
     2048 Subscript[$CellContext`b, 3] + 22528 Subscript[$CellContext`b, 4] + 
     247808 Subscript[$CellContext`b, 5] + 
     177147 Subscript[$CellContext`b, 6] + 
     1948617 Subscript[$CellContext`b, 7] + 
     21434787 Subscript[$CellContext`b, 8] + 
     4194304 Subscript[$CellContext`b, 9] == 7, 
    Subscript[$CellContext`b, 1] + 12 Subscript[$CellContext`b, 2] + 
     4096 Subscript[$CellContext`b, 3] + 49152 Subscript[$CellContext`b, 4] + 
     589824 Subscript[$CellContext`b, 5] + 
     531441 Subscript[$CellContext`b, 6] + 
     6377292 Subscript[$CellContext`b, 7] + 
     76527504 Subscript[$CellContext`b, 8] + 
     16777216 Subscript[$CellContext`b, 9] == 1, 
    Subscript[$CellContext`b, 1] + 13 Subscript[$CellContext`b, 2] + 
     8192 Subscript[$CellContext`b, 3] + 106496 Subscript[$CellContext`b, 4] + 
     1384448 Subscript[$CellContext`b, 5] + 
     1594323 Subscript[$CellContext`b, 6] + 
     20726199 Subscript[$CellContext`b, 7] + 
     269440587 Subscript[$CellContext`b, 8] + 
     67108864 Subscript[$CellContext`b, 9] == 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520160081987`*^9, 3.679053408658347*^9, 
  3.6792468734328628`*^9, 3.6796556898391933`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", 
      FractionBox["212303", "144"]}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["59429", "24"]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "3"], "\[Rule]", 
      FractionBox["343895", "128"]}], ",", 
     RowBox[{
      SubscriptBox["b", "4"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["128913", "256"]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "5"], "\[Rule]", 
      FractionBox["20743", "256"]}], ",", 
     RowBox[{
      SubscriptBox["b", "6"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["5557183", "11664"]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "7"], "\[Rule]", 
      FractionBox["966829", "17496"]}], ",", 
     RowBox[{
      SubscriptBox["b", "8"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["31799", "17496"]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "9"], "\[Rule]", 
      FractionBox["805", "2304"]}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> Rational[212303, 144], 
    Subscript[$CellContext`b, 2] -> Rational[-59429, 24], 
    Subscript[$CellContext`b, 3] -> Rational[343895, 128], 
    Subscript[$CellContext`b, 4] -> Rational[-128913, 256], 
    Subscript[$CellContext`b, 5] -> Rational[20743, 256], 
    Subscript[$CellContext`b, 6] -> Rational[-5557183, 11664], 
    Subscript[$CellContext`b, 7] -> Rational[966829, 17496], 
    Subscript[$CellContext`b, 8] -> Rational[-31799, 17496], 
    Subscript[$CellContext`b, 9] -> Rational[805, 2304]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520160081987`*^9, 3.679053408658347*^9, 
  3.6792468734328628`*^9, 3.679655689847705*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "559872"], 
    RowBox[{"(", 
     RowBox[{"825434064", "+", 
      RowBox[{"195615", " ", 
       SuperscriptBox["2", 
        RowBox[{"2", " ", "n"}]]}], "+", 
      RowBox[{"752098365", " ", 
       SuperscriptBox["2", 
        RowBox[{"1", "+", "n"}]]}], "-", 
      RowBox[{"88914928", " ", 
       SuperscriptBox["3", 
        RowBox[{"1", "+", "n"}]]}], "-", 
      RowBox[{"1386359712", " ", "n"}], "-", 
      RowBox[{"281932731", " ", 
       SuperscriptBox["2", "n"], " ", "n"}], "+", 
      RowBox[{"30938528", " ", 
       SuperscriptBox["3", "n"], " ", "n"}], "+", 
      RowBox[{"45364941", " ", 
       SuperscriptBox["2", "n"], " ", 
       SuperscriptBox["n", "2"]}], "-", 
      RowBox[{"1017568", " ", 
       SuperscriptBox["3", "n"], " ", 
       SuperscriptBox["n", "2"]}]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[1, 559872] (825434064 + 195615 2^(2 $CellContext`n) + 
    752098365 2^(1 + $CellContext`n) - 88914928 3^(1 + $CellContext`n) - 
    1386359712 $CellContext`n - 281932731 2^$CellContext`n $CellContext`n + 
    30938528 3^$CellContext`n $CellContext`n + 
    45364941 2^$CellContext`n $CellContext`n^2 - 1017568 
    3^$CellContext`n $CellContext`n^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520160081987`*^9, 3.679053408658347*^9, 
  3.6792468734328628`*^9, 3.67965568989176*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
MetodoI: muestra sobre una relaci\[OAcute]n de recurrencia lineal de orden \
uno, sus evaluaciones en \[OpenCurlyDoubleQuote]k\[CloseCurlyDoubleQuote] \
iteraciones de forma ascendente o descendente, seg\[UAcute]n lo escoja el \
usuario. El comando es una aplicaci\[OAcute]n directa del m\[EAcute]todo de \
resoluci\[OAcute]n de relaciones de recurrencia denominado: \
\[OpenCurlyDoubleQuote]iterativo\[CloseCurlyDoubleQuote]. Sintaxis: \
MetodoI[Coeficientes, k], o bien, MetodoI[Coeficientes, k, ascendente -> \
True, inicio -> Valor] siendo \[OpenCurlyDoubleQuote]Coeficientes\
\[CloseCurlyDoubleQuote] un vector de dimensi\[OAcute]n uno o dos que \
contiene un coeficiente y/o la parte no homog\[EAcute]nea (en funci\[OAcute]n \
de \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]) como su \[UAcute]ltima \
componente, \[OpenCurlyDoubleQuote]ascendente -> True\[CloseCurlyDoubleQuote] \
opci\[OAcute]n que exhibe los resultados de forma ascendente (por defecto es \
descendente) e \[OpenCurlyDoubleQuote]inicio -> \
Valor\[CloseCurlyDoubleQuote], el valor del \[IAcute]ndice con el que empieza \
la condici\[OAcute]n inicial. \[OpenCurlyDoubleQuote]MetodoI\
\[CloseCurlyDoubleQuote] solo acepta n\[UAcute]meros enteros.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6633253492232847`*^9, 3.663325383015751*^9}, {
   3.6633259146360636`*^9, 3.663325989355534*^9}, {3.6633261045165358`*^9, 
   3.663326220145146*^9}, {3.6633277130777864`*^9, 3.6633277183302035`*^9}, {
   3.6633441743760443`*^9, 3.6633442005829163`*^9}, 3.6639281855987024`*^9, 
   3.6639525308868303`*^9, {3.6640151822288265`*^9, 3.6640152033505993`*^9}, {
   3.6640155069085345`*^9, 3.6640155092003007`*^9}, {3.6733879808380857`*^9, 
   3.673388012484233*^9}, {3.673388139796308*^9, 3.67338816698848*^9}, 
   3.67338820975906*^9, {3.673388263553011*^9, 3.673388344820319*^9}, {
   3.6790515241205363`*^9, 3.6790516743844223`*^9}, {3.6790517389639688`*^9, 
   3.6790517402715597`*^9}, 3.6792435931767883`*^9}],

Cell[TextData[{
 "Ejemplo 1: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "=", 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["n", "2"], 
      SubscriptBox["a", 
       RowBox[{"n", "-", "1"}]]}], "+", 
     RowBox[{"2", "n"}], "+", 
     SuperscriptBox["3", 
      RowBox[{"n", "-", "1"}]]}]}], TraditionalForm]]]
}], "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6633441494012117`*^9, 
   3.6633441531245947`*^9}, {3.6633441836503696`*^9, 3.663344185494075*^9}, {
   3.6733883478383317`*^9, 3.673388348888036*^9}, {3.6790538325607624`*^9, 
   3.6790538721579275`*^9}, {3.6790539035384617`*^9, 
   3.6790539040887995`*^9}, {3.679670454262686*^9, 3.679670457630546*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["n", "2"]}], ",", 
     RowBox[{
      RowBox[{"2", "n"}], "+", 
      SuperscriptBox["3", 
       RowBox[{"n", "-", "1"}]]}]}], "}"}], ",", "5"}], "]"}]], "Input",
 CellChangeTimes->{
  3.663952922345718*^9, {3.663968828514571*^9, 3.6639688433684034`*^9}, {
   3.664014927564889*^9, 3.664014930574696*^9}, 3.6790518343536634`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Por el m\[EAcute]todo iterativo:\"\>"], "Print",
 CellChangeTimes->{3.6790520204549227`*^9, 3.6790539103497148`*^9, 
  3.67924687854405*^9, 3.679656207807412*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", 
    SuperscriptBox["3", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], "+", 
   RowBox[{"2", " ", "n"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","1"},
     "Superscript"]}], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2","2"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -1 + $CellContext`n, ": ", 3^(-1 + $CellContext`n) + 
   2 $CellContext`n + (3^(-2 + $CellContext`n) + 
     2 (-1 + $CellContext`n)) $CellContext`n^2 
    Superscript[
     2, 1] + (-1 + $CellContext`n)^2 $CellContext`n^2 $CellContext`a[-2 + \
$CellContext`n] Superscript[2, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520204549227`*^9, 3.6790539103497148`*^9, 
  3.67924687854405*^9, 3.6796562078204327`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", 
    SuperscriptBox["3", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], "+", 
   RowBox[{"2", " ", "n"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","2"},
     "Superscript"]}], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2","3"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -2 + $CellContext`n, ": ", 3^(-1 + $CellContext`n) + 
   2 $CellContext`n + (3^(-2 + $CellContext`n) + 
     2 (-1 + $CellContext`n)) $CellContext`n^2 
    Superscript[2, 1] + (3^(-3 + $CellContext`n) + 
     2 (-2 + $CellContext`n)) (-1 + $CellContext`n)^2 $CellContext`n^2 
    Superscript[
     2, 2] + (-2 + $CellContext`n)^2 (-1 + $CellContext`n)^2 $CellContext`n^2 \
$CellContext`a[-3 + $CellContext`n] Superscript[2, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520204549227`*^9, 3.6790539103497148`*^9, 
  3.67924687854405*^9, 3.679656207826936*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", 
    SuperscriptBox["3", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], "+", 
   RowBox[{"2", " ", "n"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","2"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "4"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","3"},
     "Superscript"]}], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "4"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2","4"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -3 + $CellContext`n, ": ", 3^(-1 + $CellContext`n) + 
   2 $CellContext`n + (3^(-2 + $CellContext`n) + 
     2 (-1 + $CellContext`n)) $CellContext`n^2 
    Superscript[2, 1] + (3^(-3 + $CellContext`n) + 
     2 (-2 + $CellContext`n)) (-1 + $CellContext`n)^2 $CellContext`n^2 
    Superscript[2, 2] + (3^(-4 + $CellContext`n) + 
     2 (-3 + $CellContext`n)) (-2 + $CellContext`n)^2 (-1 + $CellContext`n)^2 \
$CellContext`n^2 
    Superscript[
     2, 3] + (-3 + $CellContext`n)^2 (-2 + $CellContext`n)^2 (-1 + \
$CellContext`n)^2 $CellContext`n^2 $CellContext`a[-4 + $CellContext`n] 
    Superscript[2, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520204549227`*^9, 3.6790539103497148`*^9, 
  3.67924687854405*^9, 3.67965620783745*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "4"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", 
    SuperscriptBox["3", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], "+", 
   RowBox[{"2", " ", "n"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","2"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "4"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","3"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "5"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","4"},
     "Superscript"]}], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "5"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2","5"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -4 + $CellContext`n, ": ", 3^(-1 + $CellContext`n) + 
   2 $CellContext`n + (3^(-2 + $CellContext`n) + 
     2 (-1 + $CellContext`n)) $CellContext`n^2 
    Superscript[2, 1] + (3^(-3 + $CellContext`n) + 
     2 (-2 + $CellContext`n)) (-1 + $CellContext`n)^2 $CellContext`n^2 
    Superscript[2, 2] + (3^(-4 + $CellContext`n) + 
     2 (-3 + $CellContext`n)) (-2 + $CellContext`n)^2 (-1 + $CellContext`n)^2 \
$CellContext`n^2 
    Superscript[2, 3] + (3^(-5 + $CellContext`n) + 
     2 (-4 + $CellContext`n)) (-3 + $CellContext`n)^2 (-2 + $CellContext`n)^2 \
(-1 + $CellContext`n)^2 $CellContext`n^2 
    Superscript[
     2, 4] + (-4 + $CellContext`n)^2 (-3 + $CellContext`n)^2 (-2 + \
$CellContext`n)^2 (-1 + $CellContext`n)^2 $CellContext`n^2 $CellContext`a[-5 + $\
CellContext`n] Superscript[2, 5]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520204549227`*^9, 3.6790539103497148`*^9, 
  3.67924687854405*^9, 3.679656207845455*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "5"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", 
    SuperscriptBox["3", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], "+", 
   RowBox[{"2", " ", "n"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","2"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "4"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","3"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "5"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","4"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "6"}], "+", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "+", "n"}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    TemplateBox[{"2","5"},
     "Superscript"]}], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "6"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"2","6"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -5 + $CellContext`n, ": ", 3^(-1 + $CellContext`n) + 
   2 $CellContext`n + (3^(-2 + $CellContext`n) + 
     2 (-1 + $CellContext`n)) $CellContext`n^2 
    Superscript[2, 1] + (3^(-3 + $CellContext`n) + 
     2 (-2 + $CellContext`n)) (-1 + $CellContext`n)^2 $CellContext`n^2 
    Superscript[2, 2] + (3^(-4 + $CellContext`n) + 
     2 (-3 + $CellContext`n)) (-2 + $CellContext`n)^2 (-1 + $CellContext`n)^2 \
$CellContext`n^2 
    Superscript[2, 3] + (3^(-5 + $CellContext`n) + 
     2 (-4 + $CellContext`n)) (-3 + $CellContext`n)^2 (-2 + $CellContext`n)^2 \
(-1 + $CellContext`n)^2 $CellContext`n^2 
    Superscript[2, 4] + (3^(-6 + $CellContext`n) + 
     2 (-5 + $CellContext`n)) (-4 + $CellContext`n)^2 (-3 + $CellContext`n)^2 \
(-2 + $CellContext`n)^2 (-1 + $CellContext`n)^2 $CellContext`n^2 
    Superscript[
     2, 5] + (-5 + $CellContext`n)^2 (-4 + $CellContext`n)^2 (-3 + \
$CellContext`n)^2 (-2 + $CellContext`n)^2 (-1 + $CellContext`n)^2 \
$CellContext`n^2 $CellContext`a[-6 + $CellContext`n] Superscript[2, 6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520204549227`*^9, 3.6790539103497148`*^9, 
  3.67924687854405*^9, 3.6796562078564663`*^9}]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Ejemplo 2: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "=", 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["n", "2"], 
      SubscriptBox["a", 
       RowBox[{"n", "-", "1"}]]}], "+", 
     RowBox[{"2", "n"}], "+", 
     SuperscriptBox["3", 
      RowBox[{"n", "-", "1"}]]}]}], TraditionalForm]]]
}], "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6633441494012117`*^9, 
   3.6633441531245947`*^9}, {3.6633441880036726`*^9, 3.6633441883317833`*^9}, 
   3.6733883524013815`*^9, {3.6790539523189526`*^9, 3.6790539699103312`*^9}, {
   3.679670459857464*^9, 3.6796704633521338`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["n", "2"]}], ",", 
     RowBox[{
      RowBox[{"2", "n"}], "+", 
      SuperscriptBox["3", 
       RowBox[{"n", "-", "1"}]]}]}], "}"}], ",", "5", ",", " ", 
   RowBox[{"ascendente", "\[Rule]", "True"}], ",", 
   RowBox[{"inicio", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.663952636506443*^9, 3.663952657263976*^9}, {
   3.664014599309925*^9, 3.6640146105532894`*^9}, {3.664014932723353*^9, 
   3.6640149402669926`*^9}, 3.679051846009096*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Por el m\[EAcute]todo iterativo:\"\>"], "Print",
 CellChangeTimes->{3.6790520301091003`*^9, 3.679053972266219*^9, 
  3.679246883903837*^9, 3.6796562544172955`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", "4", 
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
    RowBox[{
     TemplateBox[{"5","1"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"7","1"},
      "Superscript"]}]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "3", "]"}], " ", 
    TemplateBox[{"2","5"},
     "Superscript"]}]}],
  SequenceForm["n \[Rule] ", 4, ": ", CenterDot[
     Superscript[5, 1], 
     Superscript[7, 1]] + $CellContext`a[3] Superscript[2, 5]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520301091003`*^9, 3.679053972266219*^9, 
  3.679246883903837*^9, 3.6796562544243*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", "5", 
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
    RowBox[{"a", "[", "3", "]"}], " ", 
    RowBox[{
     TemplateBox[{"2","6"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"5","2"},
      "Superscript"]}]}], "+", 
   RowBox[{
    TemplateBox[{"7","1"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"13","1"},
     "Superscript"]}], "+", 
   RowBox[{
    TemplateBox[{"2","1"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"5","3"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"7","1"},
     "Superscript"]}]}],
  SequenceForm["n \[Rule] ", 5, ": ", $CellContext`a[3] CenterDot[
      Superscript[2, 6], 
      Superscript[5, 2]] + CenterDot[
     Superscript[7, 1], 
     Superscript[13, 1]] + CenterDot[
     Superscript[2, 1], 
     Superscript[5, 3], 
     Superscript[7, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520301091003`*^9, 3.679053972266219*^9, 
  3.679246883903837*^9, 3.6796562544333086`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", "6", 
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
    RowBox[{"a", "[", "3", "]"}], " ", 
    RowBox[{
     TemplateBox[{"2","9"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"3","2"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"5","2"},
      "Superscript"]}]}], "+", 
   RowBox[{
    TemplateBox[{"3","1"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"5","1"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"17","1"},
     "Superscript"]}], "+", 
   RowBox[{
    TemplateBox[{"2","3"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"3","2"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"7","1"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"13","1"},
     "Superscript"]}], "+", 
   RowBox[{
    TemplateBox[{"2","4"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"3","2"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"5","3"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"7","1"},
     "Superscript"]}]}],
  SequenceForm["n \[Rule] ", 6, ": ", $CellContext`a[3] CenterDot[
      Superscript[2, 9], 
      Superscript[3, 2], 
      Superscript[5, 2]] + CenterDot[
     Superscript[3, 1], 
     Superscript[5, 1], 
     Superscript[17, 1]] + CenterDot[
     Superscript[2, 3], 
     Superscript[3, 2], 
     Superscript[7, 1], 
     Superscript[13, 1]] + CenterDot[
     Superscript[2, 4], 
     Superscript[3, 2], 
     Superscript[5, 3], 
     Superscript[7, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520301091003`*^9, 3.679053972266219*^9, 
  3.679246883903837*^9, 3.6796562544398127`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", "7", 
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
    RowBox[{
     TemplateBox[{"2","4"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"3","2"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"7","3"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"13","1"},
      "Superscript"]}]}], "+", 
   RowBox[{
    TemplateBox[{"2","5"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"3","2"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"5","3"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"7","3"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "3", "]"}], " ", 
    RowBox[{
     TemplateBox[{"2","10"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"3","2"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"5","2"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"7","2"},
      "Superscript"]}]}], "+", 
   RowBox[{
    TemplateBox[{"2","1"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"3","1"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"5","1"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"7","2"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"17","1"},
     "Superscript"]}], "+", 
   TemplateBox[{"743","1"},
    "Superscript"]}],
  SequenceForm["n \[Rule] ", 7, ": ", CenterDot[
     Superscript[2, 4], 
     Superscript[3, 2], 
     Superscript[7, 3], 
     Superscript[13, 1]] + CenterDot[
     Superscript[2, 5], 
     Superscript[3, 2], 
     Superscript[5, 3], 
     Superscript[7, 3]] + $CellContext`a[3] CenterDot[
      Superscript[2, 10], 
      Superscript[3, 2], 
      Superscript[5, 2], 
      Superscript[7, 2]] + CenterDot[
     Superscript[2, 1], 
     Superscript[3, 1], 
     Superscript[5, 1], 
     Superscript[7, 2], 
     Superscript[17, 1]] + Superscript[743, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520301091003`*^9, 3.679053972266219*^9, 
  3.679246883903837*^9, 3.679656254447318*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", "8", 
    "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
    RowBox[{
     TemplateBox[{"2","7"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"743","1"},
      "Superscript"]}]}], "+", 
   RowBox[{
    TemplateBox[{"2","11"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"3","2"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"7","3"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"13","1"},
     "Superscript"]}], "+", 
   RowBox[{
    TemplateBox[{"2","12"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"3","2"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"5","3"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"7","3"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"a", "[", "3", "]"}], " ", 
    RowBox[{
     TemplateBox[{"2","17"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"3","2"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"5","2"},
      "Superscript"], "\[CenterDot]", 
     TemplateBox[{"7","2"},
      "Superscript"]}]}], "+", 
   RowBox[{
    TemplateBox[{"2","8"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"3","1"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"5","1"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"7","2"},
     "Superscript"], "\[CenterDot]", 
    TemplateBox[{"17","1"},
     "Superscript"]}], "+", 
   TemplateBox[{"2203","1"},
    "Superscript"]}],
  SequenceForm["n \[Rule] ", 8, ": ", CenterDot[
     Superscript[2, 7], 
     Superscript[743, 1]] + CenterDot[
     Superscript[2, 11], 
     Superscript[3, 2], 
     Superscript[7, 3], 
     Superscript[13, 1]] + CenterDot[
     Superscript[2, 12], 
     Superscript[3, 2], 
     Superscript[5, 3], 
     Superscript[7, 3]] + $CellContext`a[3] CenterDot[
      Superscript[2, 17], 
      Superscript[3, 2], 
      Superscript[5, 2], 
      Superscript[7, 2]] + CenterDot[
     Superscript[2, 8], 
     Superscript[3, 1], 
     Superscript[5, 1], 
     Superscript[7, 2], 
     Superscript[17, 1]] + Superscript[2203, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790520301091003`*^9, 3.679053972266219*^9, 
  3.679246883903837*^9, 3.679656254454839*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell["",
 Deletable->True,
 ShowCellBracket->False],

Cell[CellGroupData[{

Cell["An\[AAcute]lisis de algoritmos", "Section",
 CellChangeTimes->{{3.6621146329845805`*^9, 3.6621146423631773`*^9}, {
   3.6627220589671726`*^9, 3.662722059210923*^9}, 3.679052813734694*^9, {
   3.67924172058669*^9, 3.679241727342442*^9}}],

Cell[CellGroupData[{

Cell["\<\
PruebaADA2: analiza la eficiencia de dos algoritmos que resuelven el mismo \
problema, ejecutando un experimento con \[OpenCurlyDoubleQuote]k\
\[CloseCurlyDoubleQuote] invocaciones y retornando el n\[UAcute]mero de veces \
en el que cada m\[EAcute]todo se comport\[OAcute] m\[AAcute]s eficiente, en t\
\[EAcute]rminos de los tiempos de salida registrados por el software \
Mathematica. Sintaxis: PruebaADA2[{Metodo1, Metodo2}, k, inicio], o bien, \
PruebaADA2[{Metodo1, Metodo2}, k, inicio, lista->True]. \
\[OpenCurlyDoubleQuote]lista->True\[CloseCurlyDoubleQuote] indica que los m\
\[EAcute]todos reciben como par\[AAcute]metros una lista (internamente las \
listas son generadas de forma seudoaleatoria). \[OpenCurlyDoubleQuote]inicio\
\[CloseCurlyDoubleQuote] define el valor inicial de evaluaci\[OAcute]n. Se \
asume el dominio como el conjunto de los n\[UAcute]meros naturales o un \
subconjunto de \[EAcute]l.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.662722963491744*^9, 3.6627229717710986`*^9}, 
   3.662723040110764*^9, 3.664699554555964*^9, 3.6647197635955*^9}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{{3.6621226817922716`*^9, 3.662122699614063*^9}, 
   3.6621227615302906`*^9, {3.6646995574622464`*^9, 3.6646995577434998`*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Sumatoria1", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"s", "=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"j", "-", "3"}], ")"}], 
        SuperscriptBox["7", "j"]}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2", ",", 
         RowBox[{"n", "-", "2"}]}], "}"}]}], "]"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sumatoria2", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"suma", "=", 
      RowBox[{"-", "49"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"j", "=", "3"}], ",", 
       RowBox[{"j", "\[LessEqual]", 
        RowBox[{"n", "-", "2"}]}], ",", 
       RowBox[{
        RowBox[{"suma", "=", 
         RowBox[{"suma", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "-", "3"}], ")"}], 
           SuperscriptBox["7", "j"]}]}]}], ";", 
        RowBox[{"j", "++"}]}]}], "]"}], ";", "suma"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.664705320444123*^9, {3.664711003458902*^9, 3.664711004229514*^9}, {
   3.664720620913237*^9, 3.6647206342706647`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PruebaADA2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Sumatoria1", ",", "Sumatoria2"}], "}"}], ",", "2000", ",", "4"}],
   "]"}]], "Input",
 CellChangeTimes->{3.6681693735104094`*^9, 3.66816940383204*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "467"}],
  SequenceForm["El primer algoritmo fue mejor: ", 467],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792469118436623`*^9, 3.679656739670105*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El segundo algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "306"}],
  SequenceForm["El segundo algoritmo fue mejor: ", 306],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792469118436623`*^9, 3.6796567396751084`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se comportaron igual: \"\>", "\[InvisibleSpace]", "1227"}],
  SequenceForm["Se comportaron igual: ", 1227],
  Editable->False]], "Print",
 CellChangeTimes->{3.6792469118436623`*^9, 3.6796567396801167`*^9}]
}, Open  ]]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{{3.6621227379144974`*^9, 3.662122764092825*^9}, {
  3.662722362263655*^9, 3.6627223659233255`*^9}, {3.664699561502803*^9, 
  3.6646995638682528`*^9}, {3.6651706309315014`*^9, 3.665170631415885*^9}, {
  3.6796572633837423`*^9, 3.679657274619651*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"CalculaProducto", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", "=", "1"}], "}"}], ",", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"p", "\[LessEqual]", "n"}], ",", 
       RowBox[{"p", "=", 
        RowBox[{"p", "*", "3"}]}]}], "]"}], ";", 
     RowBox[{"Return", "[", "p", "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CalculaOtroProducto", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", "=", "1"}], "}"}], ",", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "\[LessEqual]", "n"}], ",", 
       RowBox[{
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"p", "\[LessEqual]", "i"}], ",", 
          RowBox[{"p", "=", 
           RowBox[{"p", "*", "3"}]}]}], "]"}], ";", 
        RowBox[{"i", "++"}]}]}], "]"}], ";", 
     RowBox[{"Return", "[", "p", "]"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6792437649072695`*^9, 3.679243790615866*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CalculaProducto", "[", "i", "]"}], "==", 
    RowBox[{"CalculaOtroProducto", "[", "i", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.679657844012801*^9, 3.6796578747762227`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.6796578760207195`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PruebaADA2", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"CalculaProducto", ",", " ", "CalculaOtroProducto"}], "}"}], ",", 
   " ", "2000", ",", " ", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.6651706362967515`*^9, 3.6651706912003374`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El primer algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "135"}],
  SequenceForm["El primer algoritmo fue mejor: ", 135],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6651706773409185`*^9, 3.6651706939659834`*^9}, 
   3.679243806021387*^9, 3.679246923621484*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El segundo algoritmo fue mejor: \"\>", "\[InvisibleSpace]", 
   "1"}],
  SequenceForm["El segundo algoritmo fue mejor: ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6651706773409185`*^9, 3.6651706939659834`*^9}, 
   3.679243806021387*^9, 3.6792469236284876`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se comportaron igual: \"\>", "\[InvisibleSpace]", "1864"}],
  SequenceForm["Se comportaron igual: ", 1864],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6651706773409185`*^9, 3.6651706939659834`*^9}, 
   3.679243806021387*^9, 3.6792469236364937`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
CDFGraficaNA: recibe dos funciones donde una se encuentra en el orden \
notacional asint\[OAcute]tico de la otra (O grande u omega), representando \
visualmente la notaci\[OAcute]n. Sintaxis: CDFGraficaNA[L, cmin, cmax, graph] \
donde \[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] es un vector que \
contiene a las funciones (en t\[EAcute]rminos de \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote]), \
\[OpenCurlyDoubleQuote]cmin\[CloseCurlyDoubleQuote] (real mayor que cero) y \
\[OpenCurlyDoubleQuote]cmax\[CloseCurlyDoubleQuote] (entero mayor o igual a \
10) corresponden a los valores m\[IAcute]nimo y m\[AAcute]ximo que es posible \
dar respectivamente, a la constante \[OpenCurlyDoubleQuote]c\
\[CloseCurlyDoubleQuote] de la definici\[OAcute]n de notaci\[OAcute]n asint\
\[OAcute]tica y \[OpenCurlyDoubleQuote]graph\[CloseCurlyDoubleQuote] (entero \
mayor o igual a 10) es un n\[UAcute]mero que representa la variaci\[OAcute]n \
probable sobre el eje x y el eje y. La instrucci\[OAcute]n genera una animaci\
\[OAcute]n.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.662722963491744*^9, 3.6627229717710986`*^9}, 
   3.662723040110764*^9, 3.664699554555964*^9, 3.664910517963889*^9, {
   3.6649115218848267`*^9, 3.664911525900575*^9}, {3.6650559345473795`*^9, 
   3.6650559351948433`*^9}, {3.679052229077406*^9, 3.679052316657891*^9}, 
   3.6792461664514217`*^9}],

Cell[TextData[{
 "Ejemplo 1: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["n", "5"], "+", 
   SuperscriptBox["n", "2"], "-", 
   RowBox[{"3", 
    SuperscriptBox["n", "3"]}], "-", "n", "+", "6"}]],
  CellChangeTimes->{
   3.664910602439328*^9, {3.664910643456648*^9, 3.6649106692854433`*^9}, {
    3.665055724735701*^9, 3.66505572641455*^9}}],
 " = \[CapitalTheta](",
 Cell[BoxData[
  SuperscriptBox["n", "5"]],
  CellChangeTimes->{
   3.664910602439328*^9, {3.664910643456648*^9, 3.6649106692854433`*^9}, {
    3.665055724735701*^9, 3.66505572641455*^9}}],
 ")"
}], "SubitemNumbered",
 CellChangeTimes->{{3.6621226817922716`*^9, 3.662122699614063*^9}, 
   3.6621227615302906`*^9, {3.6646995574622464`*^9, 3.6646995577434998`*^9}, {
   3.6790540125189667`*^9, 3.6790540564689035`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["n", "5"], "+", 
      SuperscriptBox["n", "2"], "-", 
      RowBox[{"3", 
       SuperscriptBox["n", "3"]}], "-", "n", "+", "6"}], ",", 
     SuperscriptBox["n", "5"]}], "}"}], ",", "0.001", ",", "10", ",", 
   "1000"}], "]"}]], "Input",
 CellChangeTimes->{
  3.664910602439328*^9, {3.664910643456648*^9, 3.6649106692854433`*^9}, {
   3.665055724735701*^9, 3.66505572641455*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.001, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.001, "c"}, 0.001, 10, 0.001}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {675., {209., 223.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    VilCretas`Private`Alc1$12117$$ = 0, VilCretas`Private`Ala1$12118$$ = 0, 
    VilCretas`Private`Alb1$12119$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.001}, "ControllerVariables" :> {
        Hold[VilCretas`Private`Alc1$$, VilCretas`Private`Alc1$12117$$, 0], 
        Hold[VilCretas`Private`Ala1$$, VilCretas`Private`Ala1$12118$$, 0], 
        Hold[VilCretas`Private`Alb1$$, VilCretas`Private`Alb1$12119$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.001, "c"}, 0.001, 
         10, 0.001, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{821., {391., 406.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{
  3.6649106724573703`*^9, 3.664920646426865*^9, 3.6649207783568764`*^9, {
   3.664921090121381*^9, 3.6649210948283925`*^9}, 3.664921134216606*^9, 
   3.6649213007129927`*^9, 3.665052803882079*^9, {3.6650556988212028`*^9, 
   3.6650557269191895`*^9}, 3.6650622974692163`*^9, 3.665065170200042*^9, 
   3.6650652477237606`*^9, 3.6650693998567777`*^9, 3.665070524176777*^9, 
   3.665075404213291*^9, {3.665156137706616*^9, 3.6651561528493958`*^9}, 
   3.665156245261939*^9, 3.665175677831554*^9, 3.6651759589922504`*^9, 
   3.665176118763791*^9, 3.6662097074003263`*^9, 3.666352666958346*^9, 
   3.66635351411977*^9, 3.6663546230769296`*^9, 3.666365931881536*^9, 
   3.6663661877962956`*^9, 3.666366384903656*^9, 3.666471332709521*^9, 
   3.666475392473463*^9, 3.668169543919778*^9, 3.6790523778973875`*^9, 
   3.679054027082383*^9, 3.6792469473419056`*^9, 3.6796581650448847`*^9, 
   3.6796634277697687`*^9}]
}, Closed]],

Cell[TextData[{
 "Ejemplo 2: ",
 Cell[BoxData[
  RowBox[{"Ln", 
   RowBox[{"(", 
    RowBox[{"n", "!"}], ")"}]}]],
  CellChangeTimes->{
   3.664910602439328*^9, {3.664910643456648*^9, 3.6649106692854433`*^9}, {
    3.665055724735701*^9, 3.66505572641455*^9}}],
 " = \[CapitalTheta](",
 Cell[BoxData[
  RowBox[{"nLn", 
   RowBox[{"(", "n", ")"}]}]],
  CellChangeTimes->{
   3.664910602439328*^9, {3.664910643456648*^9, 3.6649106692854433`*^9}, {
    3.665055724735701*^9, 3.66505572641455*^9}}],
 ")"
}], "SubitemNumbered",
 CellChangeTimes->{{3.6621226817922716`*^9, 3.662122699614063*^9}, 
   3.6621227615302906`*^9, {3.6646995574622464`*^9, 3.6646995577434998`*^9}, {
   3.6649106955332737`*^9, 3.6649106959245377`*^9}, {3.6651561243022656`*^9, 
   3.66515612472409*^9}, {3.6790524399796114`*^9, 3.679052440318281*^9}, {
   3.679054072652459*^9, 3.679054092581401*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFGraficaNA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"n", "!"}], "]"}], ",", 
     RowBox[{"n", " ", 
      RowBox[{"Log", "[", "n", "]"}]}]}], "}"}], ",", "0.001", ",", "10", ",",
    "1000"}], "]"}]], "Input",
 CellChangeTimes->{
  3.664910602439328*^9, {3.664910705920694*^9, 3.664910741449517*^9}, {
   3.6649208388868327`*^9, 3.664920839246193*^9}, {3.665055733868554*^9, 
   3.665055737817217*^9}, {3.6790524532518883`*^9, 3.6790524751302347`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 
    3, VilCretas`Private`Alc1$$ = 0.001, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alc1$$], 0.001, "c"}, 0.001, 10, 0.001}, {{
       Hold[VilCretas`Private`Ala1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
       Hold[VilCretas`Private`Alb1$$], 3, 
       "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
    Typeset`size$$ = {675., {209., 223.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    VilCretas`Private`Alc1$12316$$ = 0, VilCretas`Private`Ala1$12317$$ = 0, 
    VilCretas`Private`Alb1$12318$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`Ala1$$ = 3, VilCretas`Private`Alb1$$ = 3, 
        VilCretas`Private`Alc1$$ = 0.001}, "ControllerVariables" :> {
        Hold[VilCretas`Private`Alc1$$, VilCretas`Private`Alc1$12316$$, 0], 
        Hold[VilCretas`Private`Ala1$$, VilCretas`Private`Ala1$12317$$, 0], 
        Hold[VilCretas`Private`Alb1$$, VilCretas`Private`Alb1$12318$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[{
          Evaluate[
           And[
            Abs[
             VilCretas`Private`Alf1[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
               VilCretas`Private`Alf1[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]], 
          Evaluate[
           And[
            Abs[
            VilCretas`Private`Alc1$$ 
             VilCretas`Private`Alf2[VilCretas`Private`x]], 
            Normal[
             FunctionDomain[
              Abs[
              VilCretas`Private`Alc1$$ 
               VilCretas`Private`Alf2[VilCretas`Private`x]], 
              VilCretas`Private`x, Method -> {"Reduced" -> False}]]]]}, {
         VilCretas`Private`x, 0.0001, VilCretas`Private`Ala1$$}, PlotRange -> 
         VilCretas`Private`Alb1$$, PlotStyle -> {Thick}], 
        Graphics[{
          Text[
           Style["|f|", 10, Bold], {1.0001, 
            Abs[
             VilCretas`Private`Alf1[1.0001]]}], 
          Text[
           Style["c*|g|", 10, Bold], {1.5001, 
            Abs[VilCretas`Private`Alc1$$ VilCretas`Private`Alf2[1.5001]]}]}]],
       "Specifications" :> {{{VilCretas`Private`Alc1$$, 0.001, "c"}, 0.001, 
         10, 0.001, Appearance -> "Open"}, 
        Delimiter, {{
         VilCretas`Private`Ala1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en x"}, 3, 1000, 1}, {{
         VilCretas`Private`Alb1$$, 3, 
          "Intervalo de graficaci\[OAcute]n en y"}, 3, 1000, 1}}, 
      "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
     ImageSizeCache->{821., {391., 406.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.6663660111725335`*^9, 3.6663660627895093`*^9, 
  3.666366165690709*^9, 3.6663661966852317`*^9, 3.6663663908378873`*^9, 
  3.666471340092785*^9, 3.666475396942973*^9, 3.6681695469206877`*^9, 
  3.679052412054513*^9, 3.6790524761915603`*^9, 3.6790540359572787`*^9, 
  3.6790541092712293`*^9, 3.67924695348392*^9, 3.67965850832697*^9, 
  3.679663431137127*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
CompLimit: compara en el l\[IAcute]mite dos funciones para determinar si la \
primera es \[OpenCurlyDoubleQuote]theta\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]O grande\[CloseCurlyDoubleQuote] u \
\[OpenCurlyDoubleQuote]Omega\[CloseCurlyDoubleQuote] de la segunda. Sintaxis: \
CompLimit[L] con \[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] un vector \
que contiene las funciones (en t\[EAcute]rminos de \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote]). \
Si alguna contiene a \[OpenCurlyDoubleQuote]j\[CloseCurlyDoubleQuote] el \
comando genera una animaci\[OAcute]n haciendo variar \[OpenCurlyDoubleQuote]j\
\[CloseCurlyDoubleQuote] de uno a mil y mostrando el comportamiento asint\
\[OAcute]tico en cada caso.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.662722963491744*^9, 3.6627229717710986`*^9}, 
   3.662723040110764*^9, 3.664699554555964*^9, 3.665164331393982*^9, {
   3.6790525335437775`*^9, 3.6790525738818073`*^9}, {3.679083002750984*^9, 
   3.6790830051538577`*^9}, {3.679246275217001*^9, 3.6792462781311035`*^9}}],

Cell[TextData[{
 "Ejemplo 1: ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["log", "3"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "(n)+c = \[CapitalTheta](ln(n))"
}], "SubitemNumbered",
 CellChangeTimes->{{3.6621226817922716`*^9, 3.662122699614063*^9}, 
   3.6621227615302906`*^9, {3.6646995574622464`*^9, 3.6646995577434998`*^9}, {
   3.679054118867235*^9, 3.679054170280969*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CompLimit", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"3", ",", "n"}], "]"}], "+", "c"}], ",", 
    RowBox[{"Log", "[", "n", "]"}]}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"Log", "[", "3", "]"}]], 
   "\[InvisibleSpace]", "\<\"\[RightArrow] \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     RowBox[{"c", " ", 
      RowBox[{"Log", "[", "3", "]"}]}], "+", 
     RowBox[{"Log", "[", "n", "]"}]}], 
    RowBox[{"Log", "[", "3", "]"}]], 
   "\[InvisibleSpace]", "\<\"=\[CapitalTheta](\"\>", "\[InvisibleSpace]", 
   RowBox[{"Log", "[", "n", "]"}], "\[InvisibleSpace]", "\<\")\"\>", 
   "\[InvisibleSpace]", "\<\", Notaci\[OAcute]n theta\"\>"}],
  SequenceForm[
  Log[3]^(-1), "\[RightArrow] ", 
   Log[3]^(-1) ($CellContext`c Log[3] + Log[$CellContext`n]), 
   "=\[CapitalTheta](", 
   Log[$CellContext`n], ")", ", Notaci\[OAcute]n theta"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6663563832893577`*^9, {3.666356536229887*^9, 3.666356546087576*^9}, 
   3.666356718308352*^9, 3.6663571252614355`*^9, 3.666357325016182*^9, 
   3.6663598212431335`*^9, 3.666366812554584*^9, 3.6663669395497675`*^9, 
   3.6664717798390865`*^9, 3.666475520009391*^9, 3.6681701327810183`*^9, 
   3.679052663547411*^9, 3.679052784921961*^9, 3.679054041669733*^9, 
   3.67924695975369*^9, 3.6796586691739635`*^9, 3.6796589360210075`*^9}]
}, Closed]],

Cell[TextData[{
 "Ejemplo 2: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "n"], 
    SuperscriptBox["i", "7"]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  RowBox[{"2", 
   SuperscriptBox["n", "j"]}]],
  CellChangeTimes->{{3.665164834021794*^9, 3.6651648417304173`*^9}}]
}], "SubitemNumbered",
 CellChangeTimes->{{3.6621227379144974`*^9, 3.662122764092825*^9}, {
  3.662722362263655*^9, 3.6627223659233255`*^9}, {3.664699561502803*^9, 
  3.6646995638682528`*^9}, {3.6651672126349287`*^9, 3.6651672129917097`*^9}, {
  3.665171476641327*^9, 3.665171476969457*^9}, {3.679052711168374*^9, 
  3.6790527115012684`*^9}, {3.6790542025787163`*^9, 3.6790542408446198`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CompLimit", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      SuperscriptBox["i", "7"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
    RowBox[{"2", 
     SuperscriptBox["n", "j"]}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.665164834021794*^9, 3.6651648417304173`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Alj2$$ = 9, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Alj2$$], 1, "j"}, 1, 1000, 1}}, 
    Typeset`size$$ = {1155.4, {21.9, 38.679117647058824`}}, Typeset`update$$ =
     0, Typeset`initDone$$, Typeset`skipInitDone$$ = False, 
    VilCretas`Private`Alj2$15672$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Alj2$$ = 1}, 
      "ControllerVariables" :> {
        Hold[VilCretas`Private`Alj2$$, VilCretas`Private`Alj2$15672$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       VilCretas`Private`AlVl36 = 
        Limit[VilCretas`Private`Alf7[
           VilCretas`Private`n, VilCretas`Private`Alj2$$]/
          VilCretas`Private`Alf8[
          VilCretas`Private`n, VilCretas`Private`Alj2$$], VilCretas`Private`n -> 
          Infinity]; If[
         Or[
          NumericQ[VilCretas`Private`AlVl36], VilCretas`Private`AlVl36 == 
          Infinity], 
         If[
          NumericQ[VilCretas`Private`AlVl36], 
          If[VilCretas`Private`AlVl36 > 0, 
           Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
             VilCretas`Private`Alf7[$CellContext`n, VilCretas`Private`Alj2$$],
              "=\[CapitalTheta](", 
             VilCretas`Private`Alf8[$CellContext`n, VilCretas`Private`Alj2$$],
              ")", ", Notaci\[OAcute]n theta"}], 
           If[VilCretas`Private`AlVl36 == 0, 
            Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
              
              VilCretas`Private`Alf7[$CellContext`n, 
               VilCretas`Private`Alj2$$], "=\[CapitalOmicron](", 
              VilCretas`Private`Alf8[$CellContext`n, 
               VilCretas`Private`Alj2$$], ")", 
              ", Notaci\[OAcute]n O grande"}]]], 
          Row[{VilCretas`Private`AlVl36, "\[RightArrow] ", 
            VilCretas`Private`Alf7[$CellContext`n, VilCretas`Private`Alj2$$], 
            "=\[CapitalOmega](", 
            VilCretas`Private`Alf8[$CellContext`n, VilCretas`Private`Alj2$$], 
            ")", ", Notaci\[OAcute]n omega"}]], "NaD"]), 
      "Specifications" :> {{{VilCretas`Private`Alj2$$, 1, "j"}, 1, 1000, 1, 
         Appearance -> "Open"}}, "Options" :> {Alignment -> Center}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{1246., {134., 149.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((VilCretas`Private`Alf7[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            First[{((
                Rational[1, 24] $CellContext`n^2) (1 + $CellContext`n)^2) (2 - 
               4 $CellContext`n - $CellContext`n^2 + 6 $CellContext`n^3 + 
               3 $CellContext`n^4), 
              2 $CellContext`n^$CellContext`j}]]]], {$CellContext`n -> 
          VilCretas`Private`Aln$, $CellContext`j -> VilCretas`Private`Alj$}]; 
      VilCretas`Private`Alf8[
         Pattern[VilCretas`Private`Aln$, 
          Blank[]], 
         Pattern[VilCretas`Private`Alj$, 
          Blank[]]] := ReplaceAll[
         FullSimplify[
          Together[
           Expand[
            
            Last[{((Rational[1, 24] $CellContext`n^2) (
                 1 + $CellContext`n)^2) (2 - 
               4 $CellContext`n - $CellContext`n^2 + 6 $CellContext`n^3 + 
               3 $CellContext`n^4), 
              2 $CellContext`n^$CellContext`j}]]]], {$CellContext`n -> 
          VilCretas`Private`Aln$, $CellContext`j -> VilCretas`Private`Alj$}]); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.6790527890265307`*^9, 3.679246965342136*^9, 
  3.6796586944034505`*^9, 3.679658958960269*^9}]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell["",
 Deletable->True,
 ShowCellBracket->False],

Cell[CellGroupData[{

Cell["Relaciones binarias", "Section",
 CellChangeTimes->{{3.6621146329845805`*^9, 3.6621146423631773`*^9}, {
  3.6621146904244285`*^9, 3.6621147363634095`*^9}, {3.662114780047743*^9, 
  3.662114793159992*^9}, {3.6621148255820665`*^9, 3.6621148303337464`*^9}, {
  3.66211487945687*^9, 3.6621148833617144`*^9}, {3.673388516042733*^9, 
  3.6733885199943733`*^9}, {3.679241730291298*^9, 3.6792417352757945`*^9}}],

Cell[CellGroupData[{

Cell["\<\
RelBin: retorna de forma expl\[IAcute]cita los elementos de una relaci\
\[OAcute]n binaria finita, dada la condici\[OAcute]n que la define y los \
conjuntos sobre los cu\[AAcute]les se construye. Sintaxis: RelBin[Condicion, \
A, B] con \[OpenCurlyDoubleQuote]Condicion\[CloseCurlyDoubleQuote] un \
\[OpenCurlyDoubleQuote]string\[CloseCurlyDoubleQuote] que contiene la condici\
\[OAcute]n de creaci\[OAcute]n de la relaci\[OAcute]n binaria (en funci\
\[OAcute]n de \[OpenCurlyDoubleQuote]a\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]b\[CloseCurlyDoubleQuote]) y, \[OpenCurlyDoubleQuote]A\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]B\[CloseCurlyDoubleQuote] \
los conjuntos que la determinan.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.666367862698716*^9, 3.666367866730955*^9}, {
   3.6663683855823317`*^9, 3.6663683890295763`*^9}, 3.6663684244276752`*^9, 
   3.666376132773621*^9, {3.6663780837266912`*^9, 3.666378087080493*^9}, {
   3.6733890465622516`*^9, 3.673389052738377*^9}, {3.6733890977864814`*^9, 
   3.6733891236217437`*^9}, {3.67905427216974*^9, 3.6790543252230535`*^9}, 
   3.6792460839231668`*^9}],

Cell["Example 1", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6663679546116076`*^9, 
   3.666367954965022*^9}, {3.666368410969475*^9, 3.6663684112527776`*^9}, 
   3.6733891517285275`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "5", ",", "7"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6", ",", "8"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RelBin", "[", 
  RowBox[{"\"\<GCD[a,b]==1\>\"", ",", "A", ",", "B"}], "]"}]}], "Input",
 CellChangeTimes->{{3.666375126407111*^9, 3.666375144764203*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.666375150065342*^9, 3.6663757698171625`*^9, 
  3.666376229999672*^9, 3.6663817565797634`*^9, 3.6665209421420603`*^9, 
  3.6665390425614777`*^9, 3.6672492215546083`*^9, 3.6790544315398903`*^9, 
  3.679246976256566*^9, 3.679659223136562*^9}]
}, Closed]],

Cell["Example 2", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6663679546116076`*^9, 
   3.666367954965022*^9}, {3.6663756731117387`*^9, 3.6663756734959517`*^9}, {
   3.6665391117219715`*^9, 3.6665391136703806`*^9}, {3.6665467142505603`*^9, 
   3.666546714712832*^9}, {3.667311391514657*^9, 3.6673113918454075`*^9}, 
   3.673389158259892*^9, {3.67905440489806*^9, 3.6790544052722683`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RelBin", "[", 
  RowBox[{
  "\"\<a+\!\(\*SuperscriptBox[\(b\), \(2\)]\)==12\>\"", ",", "A", ",", "A"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6663756851521673`*^9, 3.666375721244114*^9}, {
  3.66638179047211*^9, 3.6663817975219088`*^9}, {3.666539119448394*^9, 
  3.6665391520412035`*^9}, {3.66654675888383*^9, 3.6665467848249235`*^9}, {
  3.6672492444430275`*^9, 3.6672492451598234`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6665467889406433`*^9, {3.667249225699031*^9, 3.6672492486154776`*^9}, 
   3.6673149629869404`*^9, 3.6790544359269905`*^9, 3.679246982195366*^9, 
   3.6796592576403313`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
RelBinMatriz: retorna los pares ordenados de una relaci\[OAcute]n binaria \
definida sobre dos conjuntos finitos \[OpenCurlyDoubleQuote]A\
\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]B\[CloseCurlyDoubleQuote] \
distintos de vac\[IAcute]o, dada su matriz de reprensentaci\[OAcute]n. \
Sintaxis: RelBinMatriz[M, A, B] siendo \[OpenCurlyDoubleQuote]M\
\[CloseCurlyDoubleQuote] la matriz de la relaci\[OAcute]n binaria.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.666367862698716*^9, 3.666367866730955*^9}, {
   3.6663683855823317`*^9, 3.6663683890295763`*^9}, 3.6663684244276752`*^9, 
   3.6665303842831607`*^9, 3.6665306180688705`*^9, {3.667138509324092*^9, 
   3.667138510909442*^9}}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6663679546116076`*^9, 
   3.666367954965022*^9}, {3.666368410969475*^9, 3.6663684112527776`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RelBinMatriz", "[", 
  RowBox[{
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "0", "0", "0", "1"},
      {"1", "0", "0", "0", "0"},
      {"0", "1", "0", "0", "0"},
      {"0", "1", "0", "0", "0"},
      {"0", "1", "1", "1", "0"}
     }], ")"}], ",", "A", ",", "B"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6665323745100727`*^9, 3.6665324156157513`*^9}, {
  3.666532487205641*^9, 3.6665324950252776`*^9}, {3.667311236656308*^9, 
  3.667311263821111*^9}, {3.6792469958365593`*^9, 3.679247010683051*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "4"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.679246989124449*^9, 3.679247011617296*^9}, 
   3.679659505597854*^9}]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6663679546116076`*^9, 
   3.666367954965022*^9}, {3.6673112836998525`*^9, 3.6673112841158447`*^9}, {
   3.6792439919883957`*^9, 3.6792439923893228`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"A", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"2", "i"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"B", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "i"}], "-", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "9"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Matriz", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "9"}], "}"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"RelBinMatriz", "[", 
  RowBox[{"Matriz", ",", "A", ",", "B"}], "]"}]}], "Input",
 CellChangeTimes->{{3.666533137834307*^9, 3.666533145774635*^9}, {
  3.6665331842216625`*^9, 3.666533296967072*^9}, {3.666533594121296*^9, 
  3.666533613080266*^9}, {3.666533649756815*^9, 3.666533651972974*^9}, {
  3.6665337506404867`*^9, 3.6665338221746044`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "6", ",", "8", ",", "10", ",", "12"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6792470184647837`*^9, {3.6796595551832356`*^9, 3.6796595728458233`*^9}, {
   3.679659704126872*^9, 3.6796597241632833`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "5", ",", "7", ",", "9", ",", "11", ",", "13", ",", 
   "15", ",", "17"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6792470184647837`*^9, {3.6796595551832356`*^9, 3.6796595728458233`*^9}, {
   3.679659704126872*^9, 3.6796597241678033`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "0", "0", "1", "0", "0", "1", "0"},
     {"1", "0", "0", "0", "1", "1", "1", "1", "0"},
     {"1", "0", "1", "0", "0", "0", "0", "0", "1"},
     {"0", "1", "0", "1", "1", "1", "0", "0", "1"},
     {"1", "1", "1", "1", "0", "0", "0", "0", "0"},
     {"1", "1", "1", "0", "0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.6792470184647837`*^9, {3.6796595551832356`*^9, 3.6796595728458233`*^9}, {
   3.679659704126872*^9, 3.6796597241772995`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6792470184647837`*^9, {3.6796595551832356`*^9, 3.6796595728458233`*^9}, {
   3.679659704126872*^9, 3.6796597241838074`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
GrafoRelBin: representa mediante un grafo una relaci\[OAcute]n binaria sobre \
un conjunto finito no vac\[IAcute]o \[OpenCurlyDoubleQuote]A\
\[CloseCurlyDoubleQuote], recibida como par\[AAcute]metro a trav\[EAcute]s de \
los pares ordenados que la conforman. Sintaxis: GrafoRelBin[R, A] con \
\[OpenCurlyDoubleQuote]R\[CloseCurlyDoubleQuote] la relaci\[OAcute]n binaria \
expl\[IAcute]cita. La instrucci\[OAcute]n retorna un digrafo solamente en los \
casos en los que la relaci\[OAcute]n no es sim\[EAcute]trica.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.666367862698716*^9, 3.666367866730955*^9}, {
   3.6663683855823317`*^9, 3.6663683890295763`*^9}, 3.6663684244276752`*^9, 
   3.6665366271486173`*^9, 3.666537175535097*^9}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6663679546116076`*^9, 
   3.666367954965022*^9}, {3.666368410969475*^9, 3.6663684112527776`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6", ",", "8"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RelBin", "[", 
  RowBox[{"\"\<GCD[a,b]==2\>\"", ",", "A", ",", "A"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"GrafoRelBin", "[", 
  RowBox[{
   RowBox[{"RelBin", "[", 
    RowBox[{"\"\<GCD[a,b]==2\>\"", ",", "A", ",", "A"}], "]"}], ",", "A"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6665349415389595`*^9, 3.6665349453736696`*^9}, {
   3.6665349915831313`*^9, 3.666535013963254*^9}, {3.6665350634300356`*^9, 
   3.666535098211273*^9}, {3.666535889358429*^9, 3.6665358957571936`*^9}, {
   3.6665359831979775`*^9, 3.6665360111205015`*^9}, 3.666536065489145*^9, {
   3.6665375982172785`*^9, 3.666537598585785*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6792470303098183`*^9, 3.6796598939422107`*^9}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4}, {
      Null, SparseArray[
       Automatic, {4, 4}, 0, {
        1, {{0, 4, 5, 6, 6}, {{1}, {2}, {3}, {4}, {3}, {4}}}, {1, 1, 1, 1, 1, 
         1}}]}, {ImagePadding -> 10, 
       VertexLabels -> {3 -> 6, 4 -> 8, 2 -> 4, 1 -> 2}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0.9329038775049628, 0.868997056961016}, {
          0.7420604806951387, 0.9573471150913362}, {0.6855295931235691, 
          1.1561873618768264`}, {0.7444005528032658, 1.283397876274346}, {
          1.1208458586552, 1.2836527625680614`}, {1.1798890294965596`, 
          1.1565220863176455`}, {1.1236274580016237`, 0.9576054692031762}, {
          0.9329038775049628, 0.868997056961016}},
          SplineDegree->7], 0.02153191880895003]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.9329038775049628, 0.868997056961016}, {0., 
          0.4347904415891483}}, 0.02153191880895003]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.9329038775049628, 0.868997056961016}, {
          0.9339517502051011, 0.}}, 0.02153191880895003]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.9329038775049628, 0.868997056961016}, {
          1.8680693714551628`, 0.43527754789663736`}}, 
          0.02153191880895003]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0., 0.4347904415891483}, {0.9339517502051011, 0.}}, 
          0.02153191880895003]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.9339517502051011, 0.}, {1.8680693714551628`, 
          0.43527754789663736`}}, 0.02153191880895003]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.9329038775049628, 0.868997056961016}, 
          0.02153191880895003], 
         InsetBox["2", 
          Offset[{2, 2}, {0.9544357963139128, 0.890528975769966}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.4347904415891483}, 0.02153191880895003], 
         InsetBox["4", 
          Offset[{2, 2}, {0.02153191880895003, 0.45632236039809837`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9339517502051011, 0.}, 0.02153191880895003], 
         InsetBox["6", 
          Offset[{2, 2}, {0.9554836690140511, 0.02153191880895003}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8680693714551628`, 0.43527754789663736`}, 
          0.02153191880895003], 
         InsetBox["8", 
          Offset[{2, 2}, {1.8896012902641128`, 0.4568094667055874}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.6792470303098183`*^9, 3.6796598943317537`*^9}]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6663679546116076`*^9, 
   3.666367954965022*^9}, {3.6663684167920017`*^9, 3.666368417139153*^9}, {
   3.6673121812470512`*^9, 3.667312181564602*^9}, {3.6792440859963675`*^9, 
   3.679244086730692*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "i"}], "+", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RelBin", "[", 
  RowBox[{
  "\"\<\!\(\*SuperscriptBox[\(a\), \(2\)]\)>=\!\(\*SuperscriptBox[\(b\), \
\(3\)]\)\>\"", ",", "A", ",", "A"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"GrafoRelBin", "[", 
  RowBox[{
   RowBox[{"RelBin", "[", 
    RowBox[{
    "\"\<\!\(\*SuperscriptBox[\(a\), \(2\)]\)>=\!\(\*SuperscriptBox[\(b\), \
\(3\)]\)\>\"", ",", "A", ",", "A"}], "]"}], ",", "A"}], "]"}]}], "Input",
 CellChangeTimes->{{3.666536254823058*^9, 3.6665363019913454`*^9}, {
  3.6665376172903786`*^9, 3.666537617605937*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "7"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6792470456326494`*^9, 3.679659939353832*^9}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {
       SparseArray[
       Automatic, {10, 10}, 0, {
        1, {{0, 0, 0, 1, 2, 3, 5, 7, 9, 12, 15}, {{1}, {1}, {1}, {1}, {2}, {
          1}, {2}, {1}, {2}, {1}, {2}, {3}, {1}, {2}, {3}}}, Pattern}], 
       Null}, {ImagePadding -> 10, 
       VertexLabels -> {
        6 -> 13, 3 -> 7, 5 -> 11, 8 -> 17, 7 -> 15, 10 -> 21, 9 -> 19, 4 -> 9,
          2 -> 5, 1 -> 3}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.05783410138248847], 
        ArrowBox[{{-3., 1.}, {0., 0.}}, 0.05783410138248847], 
        ArrowBox[{{-2., 1.}, {0., 0.}}, 0.05783410138248847], 
        ArrowBox[{{1., 1.}, {0., 0.}}, 0.05783410138248847], 
        ArrowBox[{{1., 1.}, {3., 0.}}, 0.05783410138248847], 
        ArrowBox[{{2., 1.}, {0., 0.}}, 0.05783410138248847], 
        ArrowBox[{{2., 1.}, {3., 0.}}, 0.05783410138248847], 
        ArrowBox[{{3., 1.}, {0., 0.}}, 0.05783410138248847], 
        ArrowBox[{{3., 1.}, {3., 0.}}, 0.05783410138248847], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQYcfmqd6eRjXbF/+byN3dft/9vff3ntzwaPnfuT
Jhp9KMn+Zz/F7uVku5eH9+vdaNK90fTXfmX6m0dfz5/ez1O8yJmx7Y+9ZMUu
U3udS/t/JYI0/LYXyzkIRNf2/1riD0L25/i7pzQuv72fx+buLHmxn/Zga/If
7DdUtxJJOPHd3hgMHu9PA4Nv9kDLgUY+3b8YrP2Lfcj5G0dfz3++/7FFHxB9
trcEUY9f7FdWAoFP9qveZhTFt77cn8i9LYF72wf71VC+PcjZk9/ZW0HV79kN
Aq/h5kHNsf8LtQ+kO4H7Gdw9UBruXigN9w+UtheH+hdKw8MDStuvgIYXlIaH
J5S2fwANbyht/w8aH1DaHj3CABl66B4=
         "]], 0.05783410138248847], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQYcmE6k1gesO2m//yJLTa/Rf/sPylwvTGbfsT8Y
W7/Rx+yf/Yv7TX+Elj23Z1mSv8CW+6/9s9yVd+qsPtq3L7nqkbDxt/3VJqtQ
3djv9t7xG1dt0fhlv2/dl+ci1v/sA68wHbMq/GF/6Uf2KalXTA7TmU/N+tT1
zf6Q6qe17iLsDvJv2TTvlH6xN7jXIyc4h9vhxYSdBd8NP9mzqldoXa/lcZgs
enzn6eUf7a+6K29cpM/rkMdQ/Zib+aP9PIe+TcUbeR0qA6++3e78wT5RcKee
FzOfQ7Lgmo3zL7+zl9m1WFVNlc/BzOeXx/JXb+wvWflNZxfnc8gInrqw7cwr
+6bJO5rf3eB1+KZWu9u28oW9zpFHr25l8To8O7Zx2pkPT+3PngEBHgdjMHhs
n/7m0dfz0jwO8zZ2X7fPf2D/K3Gi0YcSbodz/N1TGpfftm/RvdGke4PLQTzn
oFjOwWv2LP7bn7W7cjlIVuwytde5ZF99TC/u/x5OhxVgg07bv5ps93KyHafD
FBD18rA9WPkpDocHL6/92eCx036NgbqVSAKHwz+tM518rCvsIdHE4QCLMABS
us2T
         "]], 0.05783410138248847], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.05783410138248847], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEiDlCGA4y/fN7G7uv2/+1h/KSJRh9Ksv/ZM0L5
ejeadG80/YXL8xQvcmZs+wPn/0oEafiN4C/xByGEepu7s+TFfsL5hupWIgkn
vsP5aWDwzf6r9tmZXL+FHZRbTd0ncX21v7reJF3rjbDDA77qHOfzn+0Xdptl
xF8WdpjLbH6tcssn+9D9l+as3CDsEJac2WK666P9Vy9OVs4WYQd+PaHysgcf
7Ov1bi2o9RV2OJZsuM5G/YP9l0zXAnZeYYdfHH3BArLv7UP+ehUvOyTkkKyw
7PJGnXf28168WhmVJ+Rwinf1ndjat/bzeAuMtm7hc/AqVPs6YcIL+0BmnXmT
BTgdljN9eOLE+8Q+dBPn9IAPzA67mvkjnj+7b+9rKmR1Y/k/+xuxt6e4td2w
n1oRknCm7Jv9qsnODYt/XLT/F7PF8fesd/ZpXhNM/lSfsBdc5/b9evgj+62e
S7ojI/faXzqx/1CsxwX7l7eMLibxrrJnQAMAcCOpcQ==
         "]], 
         0.05783410138248847], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQEiDlCGQ+gMYVkuAxGH5fM2dl+3/2+/PPrzYaVU
EYekiUYfSrL/2X/1nP/Fc76Ig96NJt0bTX/tbZPF19ffE3HgKV7kzNj2x74J
rEHU4VciSMNv+wNiOQfFcoD8Jf4gZP9ng4dkxS5RBx6bu7PkxX7am5R9/PWc
V8zBUN1KJOHEd/s0MBBzgNDf7J10Tu2bslXMQdZ0Dl8d61f7qiL7dJG3Yg4n
zol2fdr12Z7b8lj8Ux5xhwzjyzcOt32y/1Ift4JdVNzhe9KVXx8zPtqbu3M4
VrOKO1THSn6oSfxgf6XvsKbDPTGHh64uhScfvLM/FTYhKWy+mMOWtLsrgrTf
2kvNz3u910PMIVv2X9vURa/tD6fHHSm7JerAkbWMe5LbK/v4TP392U4iDkF5
dStK2J7Zqxy5/jXwlJBDYoK9Vav0I3vhivAMzSJBh5SGS43t3HfttVrXiX2y
FHBok/5RkdB1zf7itZ2MEc58DvqT3kdO3XzBfknoUd91QTwOu04UevrwHbc/
1lYv+Hwhl4OlR0Cqt8gee6usFz5MhpwO2rc49t3OWmkPiSYOWHwxAABnpbxK

         "]], 0.05783410138248847], 
        ArrowBox[{{5., 2.}, {0., 1.}}, 0.05783410138248847]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 0.}, 0.05783410138248847], 
         InsetBox["3", 
          Offset[{2, 2}, {0.05783410138248847, 0.05783410138248847}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 0.}, 0.05783410138248847], 
         InsetBox["5", 
          Offset[{2, 2}, {3.0578341013824883`, 0.05783410138248847}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.05783410138248847], 
         InsetBox["7", 
          Offset[{2, 2}, {0.05783410138248847, 1.0578341013824886`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 1.}, 0.05783410138248847], 
         InsetBox["9", 
          Offset[{2, 2}, {-2.9421658986175117`, 1.0578341013824886`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.05783410138248847], 
         InsetBox["11", 
          Offset[{2, 2}, {-1.9421658986175114`, 1.0578341013824886`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.05783410138248847], 
         InsetBox["13", 
          Offset[{2, 2}, {1.0578341013824886`, 1.0578341013824886`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 1.}, 0.05783410138248847], 
         InsetBox["15", 
          Offset[{2, 2}, {2.0578341013824883`, 1.0578341013824886`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 1.}, 0.05783410138248847], 
         InsetBox["17", 
          Offset[{2, 2}, {3.0578341013824883`, 1.0578341013824886`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.05783410138248847], 
         InsetBox["19", 
          Offset[{2, 2}, {0.05783410138248847, 2.0578341013824883`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{5., 2.}, 0.05783410138248847], 
         InsetBox["21", 
          Offset[{2, 2}, {5.057834101382489, 2.0578341013824883`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.6792470456326494`*^9, 3.679659939518237*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
TipoRelacion: clasifica una relaci\[OAcute]n binaria en reflexiva, sim\
\[EAcute]trica, antisim\[EAcute]trica, transitiva, de equivalencia y de orden \
parcial, dados sus pares ordenados de forma expl\[IAcute]cita. En caso de no \
cumplir alguna de las propiedades retorna un contraejemplo. Sintaxis: \
TipoRelacion[R, A], con \[OpenCurlyDoubleQuote]R\[CloseCurlyDoubleQuote] la \
relaci\[OAcute]n binaria definida sobre el conjunto finito no vac\[IAcute]o \
\[OpenCurlyDoubleQuote]A\[CloseCurlyDoubleQuote].\
\>", "ItemNumbered",
 CellChangeTimes->{{3.666367862698716*^9, 3.666367866730955*^9}, {
   3.6663683855823317`*^9, 3.6663683890295763`*^9}, 3.6663684244276752`*^9, {
   3.667248758266817*^9, 3.667248762892157*^9}, 3.67339948342488*^9, {
   3.6733995264816537`*^9, 3.673399548727517*^9}, {3.679054583936932*^9, 
   3.6790545900441246`*^9}, {3.6790546216188393`*^9, 3.6790546265031223`*^9}, 
   3.679082404292363*^9, {3.679083046319867*^9, 3.679083046636614*^9}, 
   3.6792461198586407`*^9}],

Cell["Example 1", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6663679546116076`*^9, 
   3.666367954965022*^9}, {3.666368410969475*^9, 3.6663684112527776`*^9}, {
   3.6733995515123777`*^9, 3.6733995525300584`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TipoRelacion", "[", 
  RowBox[{"R", ",", "A"}], "]"}]}], "Input",
 CellChangeTimes->{{3.667248276706856*^9, 3.667248286674443*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"La relaci\[OAcute]n es reflexiva\"\>"], "Print",
 CellChangeTimes->{
  3.667250305415654*^9, 3.6672506102338552`*^9, 3.6672511441898637`*^9, 
   3.667303667477462*^9, 3.667684167919196*^9, 3.667684443314993*^9, 
   3.6676845132432227`*^9, {3.667685450159721*^9, 3.66768545331359*^9}, 
   3.67905472438052*^9, 3.6792470518591566`*^9, 3.679660097109561*^9}],

Cell[BoxData["\<\"La relaci\[OAcute]n es sim\[EAcute]trica\"\>"], "Print",
 CellChangeTimes->{
  3.667250305415654*^9, 3.6672506102338552`*^9, 3.6672511441898637`*^9, 
   3.667303667477462*^9, 3.667684167919196*^9, 3.667684443314993*^9, 
   3.6676845132432227`*^9, {3.667685450159721*^9, 3.66768545331359*^9}, 
   3.67905472438052*^9, 3.6792470518591566`*^9, 3.6796600971155453`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es antisim\[EAcute]trica, un \
contraejemplo es: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], "\[InvisibleSpace]", "\<\" y \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" est\[AAcute]n en la relaci\[OAcute]n\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es antisim\[EAcute]trica, un contraejemplo es: ", {
   1, 2}, " y ", {2, 1}, " est\[AAcute]n en la relaci\[OAcute]n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.667250305415654*^9, 3.6672506102338552`*^9, 3.6672511441898637`*^9, 
   3.667303667477462*^9, 3.667684167919196*^9, 3.667684443314993*^9, 
   3.6676845132432227`*^9, {3.667685450159721*^9, 3.66768545331359*^9}, 
   3.67905472438052*^9, 3.6792470518591566`*^9, 3.6796600971235714`*^9}],

Cell[BoxData["\<\"La relaci\[OAcute]n es transitiva\"\>"], "Print",
 CellChangeTimes->{
  3.667250305415654*^9, 3.6672506102338552`*^9, 3.6672511441898637`*^9, 
   3.667303667477462*^9, 3.667684167919196*^9, 3.667684443314993*^9, 
   3.6676845132432227`*^9, {3.667685450159721*^9, 3.66768545331359*^9}, 
   3.67905472438052*^9, 3.6792470518591566`*^9, 3.679660097129055*^9}],

Cell[BoxData["\<\"La relaci\[OAcute]n es de equivalencia\"\>"], "Print",
 CellChangeTimes->{
  3.667250305415654*^9, 3.6672506102338552`*^9, 3.6672511441898637`*^9, 
   3.667303667477462*^9, 3.667684167919196*^9, 3.667684443314993*^9, 
   3.6676845132432227`*^9, {3.667685450159721*^9, 3.66768545331359*^9}, 
   3.67905472438052*^9, 3.6792470518591566`*^9, 3.679660097138564*^9}]
}, Open  ]]
}, Closed]],

Cell["Example 2", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6663679546116076`*^9, 
   3.666367954965022*^9}, {3.6663684167920017`*^9, 3.666368417139153*^9}, 
   3.6733995642699027`*^9, {3.6790546586827507`*^9, 3.6790546589939747`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TipoRelacion", "[", 
  RowBox[{"R", ",", "A"}], "]"}]}], "Input",
 CellChangeTimes->{{3.667247458290496*^9, 3.6672474790320683`*^9}, {
  3.667248897361109*^9, 3.6672489042974477`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es reflexiva, un contraejemplo es: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" no pertenece\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es reflexiva, un contraejemplo es: ", {2, 2}, 
   " no pertenece"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6672493887663393`*^9, 3.667250320989024*^9, 3.6672506428692307`*^9, 
   3.6672511562171993`*^9, 3.66730367822845*^9, 3.6676841822117867`*^9, 
   3.6676844557164235`*^9, 3.667684520916439*^9, {3.667685476792742*^9, 
   3.6676854812435684`*^9}, 3.679054731262739*^9, 3.6792470580661564`*^9, 
   3.6796601130645523`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es sim\[EAcute]trica, un contraejemplo \
es: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" est\[AAcute] en la relaci\[OAcute]n pero \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" no pertenece\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es sim\[EAcute]trica, un contraejemplo es: ", {1, 
   2}, " est\[AAcute] en la relaci\[OAcute]n pero ", {2, 1}, " no pertenece"],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6672493887663393`*^9, 3.667250320989024*^9, 3.6672506428692307`*^9, 
   3.6672511562171993`*^9, 3.66730367822845*^9, 3.6676841822117867`*^9, 
   3.6676844557164235`*^9, 3.667684520916439*^9, {3.667685476792742*^9, 
   3.6676854812435684`*^9}, 3.679054731262739*^9, 3.6792470580661564`*^9, 
   3.679660113069866*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es antisim\[EAcute]trica, un \
contraejemplo es: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], "\[InvisibleSpace]", "\<\" y \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" est\[AAcute]n en la relaci\[OAcute]n\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es antisim\[EAcute]trica, un contraejemplo es: ", {
   1, 4}, " y ", {4, 1}, " est\[AAcute]n en la relaci\[OAcute]n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6672493887663393`*^9, 3.667250320989024*^9, 3.6672506428692307`*^9, 
   3.6672511562171993`*^9, 3.66730367822845*^9, 3.6676841822117867`*^9, 
   3.6676844557164235`*^9, 3.667684520916439*^9, {3.667685476792742*^9, 
   3.6676854812435684`*^9}, 3.679054731262739*^9, 3.6792470580661564`*^9, 
   3.679660113079919*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La relaci\[OAcute]n no es transitiva, un contraejemplo es: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" est\[AAcute]n en la relaci\[OAcute]n, sin \
embargo, \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" no pertenece\"\>"}],
  SequenceForm[
  "La relaci\[OAcute]n no es transitiva, un contraejemplo es: ", {4, 1}, 
   ", ", {1, 3}, " est\[AAcute]n en la relaci\[OAcute]n, sin embargo, ", {4, 
   3}, " no pertenece"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6672493887663393`*^9, 3.667250320989024*^9, 3.6672506428692307`*^9, 
   3.6672511562171993`*^9, 3.66730367822845*^9, 3.6676841822117867`*^9, 
   3.6676844557164235`*^9, 3.667684520916439*^9, {3.667685476792742*^9, 
   3.6676854812435684`*^9}, 3.679054731262739*^9, 3.6792470580661564`*^9, 
   3.679660113085903*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Teor\[IAcute]a de grafos", "Section",
 CellChangeTimes->{{3.672324005547202*^9, 3.6723240090386314`*^9}, 
   3.673401049422349*^9, {3.6792417380668097`*^9, 3.679241746616847*^9}}],

Cell[CellGroupData[{

Cell["\<\
Grafo: construye un grafo a trav\[EAcute]s del \[OpenCurlyDoubleQuote]Wolfram \
System\[CloseCurlyDoubleQuote] dadas sus aristas como una matriz de pares \
ordenados. El comando presenta seis opciones: \
\[OpenCurlyDoubleQuote]dirigido->True\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]vertices->Lista\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]dimensions3d->True\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]pesos->Lista\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]mostrarpesos->True\[CloseCurlyDoubleQuote] y \
\[OpenCurlyDoubleQuote]shape->True\[CloseCurlyDoubleQuote]. \
\[OpenCurlyDoubleQuote]dirigido\[CloseCurlyDoubleQuote] crea un digrafo, \
\[OpenCurlyDoubleQuote]v\[EAcute]rtices\[CloseCurlyDoubleQuote] a\[NTilde]ade \
nuevos v\[EAcute]rtices mediante una lista de nodos, \
\[OpenCurlyDoubleQuote]dimensions3d\[CloseCurlyDoubleQuote] presenta el grafo \
en tercera dimensi\[OAcute]n, \[OpenCurlyDoubleQuote]pesos\
\[CloseCurlyDoubleQuote] genera un grafo ponderado, \
\[OpenCurlyDoubleQuote]mostrarpesos\[CloseCurlyDoubleQuote] muestra los pesos \
sobre cada una de sus aristas y \[OpenCurlyDoubleQuote]shape\
\[CloseCurlyDoubleQuote] coloca los nodos del grafo en discos, o bien, \
esferas dependiendo de la dimensi\[OAcute]n de graficaci\[OAcute]n. Si se \
muestran los pesos de un grafo con aristas m\[UAcute]ltiples, por \
limitaciones en el software Mathematica, toma el mismo valor para cada lado \
repetido. Sintaxis: Grafo[Aristas], o bien, Grafo[Aristas, dirigido->True, \
vertices->Lista, dimensions3d->True, pesos->Lista, mostrarpesos->True, \
shape->True]. En esta \[UAcute]ltima invocaci\[OAcute]n, es posible \
prescindir de cualquiera de las opciones.\
\>", "ItemNumbered",
 CellChangeTimes->{
  3.6790548913559227`*^9, {3.6790590062384443`*^9, 3.679059055385951*^9}, 
   3.679059106376544*^9, {3.6790591380948863`*^9, 3.679059160313616*^9}, {
   3.679059244237785*^9, 3.679059254066717*^9}, {3.679059875890663*^9, 
   3.6790598994600315`*^9}, 3.6790601870404296`*^9, {3.679060969539628*^9, 
   3.679060972525633*^9}, {3.6790610287429256`*^9, 3.679061049798726*^9}, {
   3.6790614569281874`*^9, 3.679061458298237*^9}, 3.6792459428287997`*^9}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{
  3.679054905503214*^9, {3.679245946648251*^9, 3.6792459490273085`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"2", "i"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"aristas", "=", 
  RowBox[{"RelBin", "[", 
   RowBox[{"\"\<a-b>=4\>\"", ",", "A", ",", "A"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Grafo", "[", 
  RowBox[{"aristas", ",", 
   RowBox[{"vertices", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], ",", 
   RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6790551414674983`*^9, 3.6790551439851537`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "16"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.67905495549273*^9, 3.679055146413578*^9, 
  3.679059171836483*^9, 3.6792470689024677`*^9, 3.6796603772988615`*^9, 
  3.679660537254672*^9}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, 6, 2, 8, 4, 10, 12, 14, 16, 18, 
       20}, {{{3, 4}, {5, 4}, {5, 6}, {7, 4}, {7, 6}, {7, 3}, {8, 4}, {8, 
       6}, {8, 3}, {8, 5}, {9, 4}, {9, 6}, {9, 3}, {9, 5}, {9, 7}, {10, 4}, {
       10, 6}, {10, 3}, {10, 5}, {10, 7}, {10, 8}, {11, 4}, {11, 6}, {11, 
       3}, {11, 5}, {11, 7}, {11, 8}, {11, 9}, {12, 4}, {12, 6}, {12, 3}, {12,
        5}, {12, 7}, {12, 8}, {12, 9}, {12, 10}}, Null}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{6.8750100079764564`, -3.8750100001593744`}, {
         8.03603902228626, -4.875010000159374}}, 0.06902834008686508], 
        ArrowBox[{{10.87501000912404, -3.8750100001593744`}, {
         8.03603902228626, -4.875010000159374}}, 0.06902834008686508], 
        ArrowBox[{{10.87501000912404, -3.8750100001593744`}, {
         10.87501000894828, -4.875010000159374}}, 0.06902834008686508], 
        ArrowBox[{{6.87501000185712, -2.8750100001593744`}, {
         6.8750100079764564`, -3.8750100001593744`}}, 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAA0Jg2nwKAG0AY3DI+BQAHwPmNJ4L4
TxtAxAxaeBlgB8DY0kzb3xobQGeTGcZKygfAZ2emqrjgGkABcHEnmT4IwKpL
NPCCoRpAkaJhnAS9CMCif/arPl0aQBor6iSNRQnATQPt3esTGkCaCQvBMtgJ
wKzWF4aKxRlAET7EcPV0CsC++XakGnIZQH/IFTTVGwvAg2wKOZwZGUDkqP8K
0swLwKqeao8iyhhAyWrABsJ+DMDi/y/zwJEYQLqZljh7KA3AKpBaZHdwGEC3
NYKg/ckNwIJP6uJFZhhAvj6DPkljDsDpPd9uLHMYQM60mRJe9A7AYls5CCuX
GEDql8UcPH0PwOqn+K5B0hhAD+gGXeP9D8CCIx1jcCQZQKDSrukpOxDAKs6m
JLeNGUC+5+S/RnMQwPNgXsxkmBpAgsh+Ba7uEMAkjDDTRI8bQNI0V1zrYBHA
u08dOVdyHECrLG7E/skRwLmrJP6bQR1ADrDDPegpEsAcoEYiE/0dQPm+V8in
gBLA6CyDpbykHkBwWSpkPc4SwBlS2oeYOB9Ab387EakSE8CyD0zJprgfQPkw
i8/qTRPA2DLstHMSIEAMbhmfAoATwDPfyWQ=
         "]], 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAA0Jg2nwKAG0AY3DI+BQAHwNAjscWD
GBxAlCkrrbBlB8CyzAQo9tAcQKcGXpmn4AfAdJMxxlmpHUBSc8sC6nAIwBN4
N6CuoR5Akm9z6XcWCcCTeha29LkfQGz7VU1R0QnAek3nAxZ5IEDcFnMudqEK
wJvsr0oqJSFA5MHKjOaGC8CrGmUvN+EhQIP8XGiigQzAq9cGsjytIkC4xinB
qZENwMJSW89u6SJAR+j8n6roDcC43FCo5iMjQHhDcujZSg7AiXXnPKRcI0BK
2ImaN7gOwDYdH42nkyNAuqZDtsMwD8DA0/eY8MgjQMqunzt+tA/AJplxYH/8
I0A9+E6VsyEQwGhtjONTLiRA5TWfQb9uEMCHUEgibl4kQF6QwCJiwRDAgkKl
HM6MJECmB7M4nBkRwG+xX1INuSRA2PcnpBpyEcBmCzRDxeIkQBC90IWKxRHA
ZFAi7/UJJUBLV63d6xMSwGqAKlafLiVAi8a9qz5dEsB4m0x4wVAlQM4KAvCC
oRLAkKGIVVxwJUAYJHqquOASwLCS3u1vjSVAZBIm298aE8DYbk5B/KclQLbV
BYL4TxPACDbYTwHAJUAMbhmfAoATwPajy3U=
         "]], 0.06902834008686508], 
        ArrowBox[{{9.875010002252694, -2.8750100001593744`}, {
         6.8750100079764564`, -3.8750100001593744`}}, 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAASLKeTwHAI0AY3DI+BQAHwCQGxGrK
pyNAgxGo0eBgB8BDk1yUqIwjQGWmUStozQfApFlozJtuI0C9mi9Lm0UIwERZ
5xKkTSNAiu5BMXrJCMAmktlnwSkjQM+hiN0EWQnASQQ/y/MCI0CKtANQO/QJ
wK2vFz072SJAuyaziB2bCsBTlGO9l6wiQGL4loerTQvAOrIiTAl9IkB/Ka9M
5QsMwAQOLOo9UyJAJ+Q2v7O0DMCQ3NtQ3ykiQE+oWuQQXw3A3B0ygO0AIkD3
dRq8/AoOwObRLnho2CFAHE12Rne4DsCy+NE4ULAhQMItboOAZw/APpIbwqSI
IUDzC4E5DAwQwIueCxRmYSFAxAWZih9lEMCYHaIulDohQFYE/zT6vhDAZQ/f
ES8UIUCmB7M4nBkRwJjHjt4P7yBA2PcnpBpyEcDYmX21D8wgQBC90IWKxRHA
I4arli6rIEBLV63d6xMSwHmMGIJsjCBAi8a9qz5dEsDbrMR3yW8gQM4KAvCC
oRLASeevd0VVIEAYJHqquOASwMI72oHgPCBAZBIm298aE8BHqkOWmiYgQLbV
BYL4TxPA2DLstHMSIEAMbhmfAoATwLKMweE=
         "]], 0.06902834008686508], 
        ArrowBox[{{9.875010002252694, -2.8750100001593744`}, {
         10.87501000912404, -3.8750100001593744`}}, 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAASLKeTwHAI0AY3DI+BQAHwE6fQTlJ
CiRAmPMHyw9jB8DaJ5xtmGAkQLgu0RAk1gfA7Uuu7O7CJEB5jY4PQlkIwIIL
eLZMMSVA2A9Ax2nsCMCcZvnKsaslQNi15TebjwnAPV0yKh4yJkB4f39h1kIK
wGLvItSRxCZAuWwNRBsGC8AMHcvIDGMnQJp9j99p2QvAO+YqCI8NKEAZsgU0
wrwMwBOMD5quYyhAXmkvF3JADcBbsfv29qQoQE3utJ8Oyg3AF1bvHmjRKEDm
QJbNl1kOwD966hEC6ShAJmHToA3vDsDaHe3PxOsoQBBPbBlwig/A5kD3WLDZ
KEBQhbCb3xUQwGLjCK3EsihA7slYfX1pEMBQBSLMAXcoQGD1rrERwBDArqZC
tmcmKECmB7M4nBkRwIQhzUrpzSdA2PcnpBpyEcDazyNpeXonQBC90IWKxRHA
r7FGERgsJ0BLV63d6xMSwP/GNUPF4iZAi8a9qz5dEsDQD/H+gJ4mQM4KAvCC
oRLAIIx4REtfJkAYJHqquOASwO87zBMkJSZAZBIm298aE8A9H+xsC/AlQLbV
BYL4TxPACDbYTwHAJUAMbhmfAoATwIPCxFw=
         "]], 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAcLgNnwKAF0AwuGV8CgD+vwKw+4H4
TxdAhxm08DLA/r+yph3b3xoXQM4mM4yVlP+/f5xzqrjgFkACcHEnmT4AwGiR
/e+CoRZAk6JhnAS9AMBuhburPl0WQBwr6iSNRQHAknit3esTFkCcCQvBMtgB
wNJq04WKxRVAEj7EcPV0AsAwXC2kGnIVQIDIFTTVGwPAqky7OJwZFUDlqP8K
0swDwKAY/IsKyhRAPN/p0SV/BMB2nG7mYJEUQIJrPGUKKgXAKNgSSJ9vFEC2
TffEf80FwLfL6LDFZBRA1oUa8YVpBsAid/Ag1HAUQOUTpukc/gbAbNopmMqT
FEDj95muRIsHwJL1lBapzRRAzjH2P/0QCMCXyDGcbx4VQKbBup1GjwjAeFMA
KR6GFUBsp+fHIAYJwDmRgDZMdhZAaq1a1U72CcC618/87VQXQGKznZvw1ArA
+CbuewMiGEBPubAaBqILwPB+27OM3RhAMr+TUo9dDMCp35ekiYcZQAzFRkOM
Bw3AHkkjTvofGkDeysns/J8NwFK7fbDephpApNAcT+EmDsBCNqfLNhwbQGTW
P2o5nA7A8LmfnwKAG0AY3DI+BQAPwOv6z90=
         "]], 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAAcLgNnwKAF0AwuGV8CgD+v+0jDi3j
GxdALOVnYEnI/r/5s8I3kKUWQGRVAkvvtP+/k2grvwkdFkBrhBoe/mIAwLpB
SMNPghVAv///Gbj9AMBwPxlEYtUUQLCcMZmlqgHAtWGeQUEWFEA+W6+bxmkC
wIio17vsRBNAaTt5IRs7A8DpE8WyZGESQDA9jyqjHgTA2KNmJqlrEUCUYPG2
XhQFwDmUlR4ACRFA9SgvYquFBcAX4Obth7sQQP68IH0O/wXAdIdalECDEECr
HMYHiIAGwE6K8BEqYBBA/EcfAhgKB8Cm6KhmRFIQQPU+LGy+mwfAfKKDko9Z
EECSAe1FezUIwM+3gJULdhBA1Y9hj07XCMChKKBvuKcQQL7piUg4gQnAkKe8
4d+lEUDkqP8K0swLwKZLoZRM+RFAuHFlj7l8DMDOQ6lzplASQHW1KltZIA3A
BpDUfu2rEkAbdE9usbcNwE8wI7YhCxNAqK3TyMFCDsCoJJUZQ24TQB5it2qK
wQ7AEm0qqVHVE0B6kfpTCzQPwI0J42RNQBRAvjudhESaD8AZ+r5MNq8UQOxg
n/w19A/AtT6+YAwiFUCAgADe7yAQwFfczpGI7RZAWKYfGp+tEMD9KKPocpQY
QKpeIvAbLxHApCQ7ZcsWGkBzqQhgZqURwE3PlgeSdBtAtYbSaX4QEsD2KLbP
xq0cQG72fw1kcBLAojGZvWnCHUCi+BBLF8USwFDpP9F6sh5ATI2FIpgOE8D/
T6oK+n0fQHC03ZPmTBPA2DLstHMSIEAMbhmfAoATwOGMBd0=
         "]], 
         0.06902834008686508], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQXbCDdz5Tg7iDwY7UGi6Gf/u/nbCp7miRcIiKej+p
9MK//YHT/s79e0rSQUZLQXTB1f/76xQC2JOCpR12C9cwHm1nOFCTbrJ9q6ys
g8FK63WS9owHfLJXrf2hKe9QePWcwDkBpgM/RCNLRfcoONTNMNV89IfpwJYr
quZqLEoOIZ/yv4cysxy4UWg9Ry9X2eHro9pqTRXWA2lvZy7R+67ikJgVvzUm
nu3AUXuvzhBFVYdd52Q3G3azHfjofIK91U3V4WWxeLDncbYDL38KKxxIA/Ij
faYuFmY/sDpR9xJrk6rDvoY9lQ4F7AesqkXkwmaoOqS9SGdQuMt+YJrbSeaN
K1UdHk3w03SK4jiw57B3s9g2VQejqoIvy55zHNjwafactr2qDqFLzib6tXIe
yLu805/xgKqDD39aoYUx14GK7H1g/ob3/h6mT7gOBB44BObLVS3kFu3mPvDl
4jEwf/q6qN3X1XkOJC84BeaL9laH1+7iOTBf+xyYP0+U5QGrM++B5cUXwXwD
jy8hhQd5D9RUXAHzT6j4bNtvyndAxuo6mJ+zmpvl43y+Ax07boL5EneM7FgZ
+A8AAMiWwU8=
         "]], 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQXbCDdz5Tg7iDwY7UGi6Gf/sZL/GD+e2SWz4YHfi3
X0NFCMw/p2bcM3XK//3P1omA+UwFheoz7RgOmBeJg/mTFyXOYdnLcEA+TwrM
l9F+pdLrynhg3iJZMH8OJ/dBoxuMBzbxK4L5QnZHCr6WMB2I2aoC5jecEDW5
Ks18YO5kDTD/6Yr/XJfOMB/Yc+RzbUeLuMPxiU/M3GpZDrAn+0pJTRJ3WGuq
/rNbifVATZ5pyfYV4g5TpxwPXLyH9YDk89XdCSeA5q076tDjzXbgwZkNCaIf
xR3ymhWPuZ1nO3BJ3uXzVSUJh0Th2w8vubMfeHc/1XlRrIRDaNynyQZb2Q8Y
84oFVi2UcPBJSb8TL85xwGaRW855HxmHJ2D3cB94tOzsrXJmWYc5vhySz+t5
Dqy88TglaresA6vqtkZ+Xd4DPeadXOUlcg7y+pyu3ld4D3Qd3nv6rJ68w4ts
xuRZpXwHltY0roh7Je+QcHve7T8C/AfyDbMuTAlWcOisfbiuaBn/AUnr6Kjp
mxQcDFamvPsrJXAg+LbwJzMhRYevOquNzsQLHJASmjK9uEjRQdDLRWXJQoED
p9ieX/sqo+RwQ6naL0BY8MDiKc2nC3YrOfzKtJjzvUbwwPLdmaVPfJUdquVr
eGfdEzxwoXrmlYAryg5hzm6LzC2EDqhcFXq51U/Foe/qtKgLnUIHFhy/ukl4
r4qDyrVcs5TLQgdcgh8ZZsmrOoi4njb9LCJ8QKjCIm1nqapDktL6iFo/4QMc
Zjf8GQ+oOvDkSQLjTfgAAGue/Y4=
         "]], 0.06902834008686508], 
        ArrowBox[{{5.875009999477797, -1.8750100001593744`}, {
         6.87501000185712, -2.8750100001593744`}}, 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQHaExx5/xgLqDwY7UGi6Gf/tF0iD8dsktH4wO/Nsf
tArCP6dm3DN1yv/9/F8hfKaCQvWZdgwHvNzmgvmTFyXOYdnLcIBtHoQvo/1K
pdeV8YDTHwh/Dif3QaMbjAf+JMwD84XsjhR8LWE6YH4Gwm84IWpyVZr5wCfb
+WD+0xX/uS6dYT5ww6ltTttedYd0pRlSe6pYDsxMt2oW26buoFfxtT1ZgvWA
8ZrdzBtXqjuYrxIPPrGU9cBSAS65sBnqDi07/lW/UmI78GmK6iXWJnUHkcWr
mE71sx0Qt+RTOJCm7vAqU/p52hu2A2J/D7O3uqk7MPIGah60YD/w7oFbZ4ii
ukNMj/fJGyXsB+Y/mbZE77uaw+/nXMfXLmA/IB7tOkcvV9VBseI1w8PbHAd0
Jlibq7GoOEzp+9Gy5Q/ngfvNlaWie5QcwrSNgjWYuQ/om/0P+zNF0SHJb0a2
zXvuAzLLz9y+1afgsPO71rkPB3gO+K09zJ4ULO+QoP6qyrWC98C8ztp5f0/J
OgTcvVpoJcp3QPvxseqOFhmHPsl3m85P5zvwYef8+UwN0g4Sd4zsWBn4DwAA
gLjDKA==
         "]], 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAAWCicTwHAJ0AwuGV8CgD+vxkrsGwL
8CdAWRi18DLA/r+/3JATJCUoQBgiN4yVlP+/SD0+REtfKEC26nUnmT4AwLZM
uP6AnihAKJlpnAS9AMAIC/9CxeIoQGSc9iSNRQHAPHgSERgsKUBq9BzBMtgB
wFaU8mh5eilAOqHccPV0AsBTX59K6c0pQNOiNTTVGwPANNkYtmcmKkA2+ScL
0swDwH/l11JQdypAmI7Va92CBMCRUmfI/rMqQM8ihMzoOAXAYyDHFnPcKkDW
tTMt9O4FwPZO9z2t8CpAsEfkjf+kBsBM3vc9rfAqQF3Yle4KWwfAZc7IFnPc
KkDdZ0hPFhEIwEAfasj+sypAMPb7ryHHCMDf0NtSUHcqQFWDsBAtfQnAcvlc
6ZpZKUDkqP8K0swLwPtXOSkr/ihAZ7WPsXN+DMAW7nlJ56EoQDLE0+NBJw3A
wbseSs9EKEBF1cuhPMcNwPrAJyvj5idAnuh362NeDsDF/ZTsIognQDz+18C3
7A7AIHJmjo4oJ0AhFuwhOHIPwAoenBAmyCZATDC0DuXuD8CGATZz6WYmQGAm
mENfMRDAkhw0ttgEJkC8NbBF4mYQwFub4qz7EiVAQhxoX+PkEMD2szH7SzMk
QPDYLTVsWRHAX2YhocllI0DHawHHfMQRwJaysZ50qiJAxNTiFBUmEsCemOLz
TAEiQOkT0h41fhLAdRi0oFJqIUA2Kc/k3MwSwBwyJqWF5SBAqxTaZgwSE8CS
5TgB5nIgQEjW8qTDTRPA2DLstHMSIEAMbhmfAoATwBxiEG4=
         "]], 
         0.06902834008686508], ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAWCicTwHAJ0AwuGV8CgD+v9LaJV4G
2CdAhxm08DLA/r8XoJWxkvInQM4mM4yVlP+/JnjrSaYPKEACcHEnmT4AwP1i
JydBLyhAk6JhnAS9AMCeYElJY1EoQBwr6iSNRQHACXFRsAx2KECcCQvBMtgB
wD2UP1w9nShAEj7EcPV0AsA6yhNN9cYoQIDIFTTVGwPAAhPOgjTzKEDlqP8K
0swDwHbsLln9GilABpDq0SV/BMB/1PYrUjcpQKkuP2UKKgXAGssl+zJIKUDO
hP3Ef80FwEjQu8afTSlAcpIl8YVpBsAI5LiOmEcpQJpXt+kc/gbAWwYdUx02
KUBD1LKuRIsHwEA36BMuGSlAbAgYQP0QCMC6dhrRyvAoQBj05p1GjwjAxMSz
ivO8KEBElx/IIAYJwPWYB4TcRChA3N+G1U72CcCqMPKgi9UnQAKKv5vw1ArA
3Itz4QBvJ0CvlckaBqILwI6qi0U8ESdA5gKlUo9dDMDAjDrNPbwmQKjRUUOM
Bw3AcjKAeAVwJkD2AdDs/J8NwKSbXEeTLCZAzJMfT+EmDsBXyM855/ElQC2H
QGo5nA7AiLjZTwHAJUAY3DI+BQAPwMbHxVU=
         "]], 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAAWCicTwHAJ0AwuGV8CgD+vzhCX+Ee
JyhAORDrn0XO/r+HwvE1bKYoQJgBD0ngzP+/RKlTTek9KUAlxug77X0AwG32
hCeW7SlAJ1gZFpotAcAGqoXEcrUqQNI2GbN29QHADsRVJH+VK0AoYugSg9UC
wIJE9Ua7jSxAJtqGNb/NA8BmK2QsJ54tQM+e9Bor3gTAt3ii1MLGLkAhsDHD
xgYGwCTt6A4o+S5AlIqUUjNFBsA1Fi1OkSEvQLxbLpGykQbA6PNukv4/L0CU
I/9+ROwGwDqGrttvVC9AHuIGHOlUB8Axzesp5V4vQF2XRWigywfAyMgmfV5f
L0BMQ7tjalAIwAR5X9XbVS9A8OVnDkfjCMDg3ZUyXUIvQEV/S2g2hAnA8ptc
N1PXLkDkqP8K0swLwGTBeouusy5AHiYKeql7DMAaSm++sY0uQA6HvQUZHA3A
GTY60FxlLkCzyxmuIK4NwFqF28CvOi5ADPQec8AxDsDgN1OQqg0uQBkAzVT4
pg7ArE2hPk3eLUDa7yNTyA0PwLzGxcuXrC1AT8MjbjBmD8ASo8A3ingtQHp6
zKUwsA/AreKRgiRCLUBYFR76yOsPwDVUj92LBCxAHzO2bpyLEMADQUjZ9OAq
QHKi5eQRFRHAFam8dV/XKUCjWJ3fRJIRwGiM7LLL5yhAslXdXjUDEsAA69eQ
ORIoQKCZpWLjZxLA3sR+D6lWJ0BuJPbqTsASwPwZ4S4atSZAGfbO93cME8Bh
6v7ujC0mQKMOMIleTBPACDbYTwHAJUAMbhmfAoATwFSKCOc=
         "]], 
         0.06902834008686508], 
        ArrowBox[{{11.875010001957136`, -1.8750100001593744`}, {
         6.87501000185712, -2.8750100001593744`}}, 0.06902834008686508], 
        ArrowBox[{{11.875010001957136`, -1.8750100001593744`}, {
         9.875010002252694, -2.8750100001593744`}}, 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAA0NEAnwKAE0BgcMv4FADsv/ZFBzBX
GhNAji+stMKW7b//HNNDYJ8SQJg/dmWegu+/6lZk2h0PEkBA0JQF1OHwv7fz
uvOPaRFAHinj0u8s8r9o89aPtq4QQGwqppqiovO/9qtwXSO9D0Am1N1c7EL1
v+I2vqBC8g1ATyaKGc0N97+Th5bpyvwLQOQgq9BEA/m/CZ75N7zcCUDnw0CC
UyP7vxusfqH0QglAb/jqP1XR+7+8nSKGRLsIQHcp2dCzlfy/63Ll5atFCEAA
Vws1b3D9v6Urx8Aq4gdABIGBbIdh/r/tx8cWwZAHQImnO3f8aP+/wkfn525R
B0BH5ZwqZ0MAwCWrJTQ0JAdACfU9g37dAMAW8oL7EAkHQAoDgUXEggHALTwZ
PgUAB0DlqP8K0swDwAQLFATVCQdAr0GZSTR7BMAEP+1VRCcHQE31+UNEGgXA
KNikM1NYB0C9wyH6AaoFwHLWOp0BnQdA/6wQbG0qBsDlOa+ST/UHQBWxxpmG
mwbAfgICFD1hCEAA0EODTf0GwD4wMyHK4AhAuwmIKMJPB8Akw0K69nMJQEpe
k4nkkgfAMLsw38IaCkCszWWmtMYHwAD5ikqj5w5AD0ozwez5CMB4pE4rY6cR
QFCLL4S1EwrAgNWzARaoE0BskVrvDhQLwJYPdSjqdRVAYly0Avn6C8C8UpKf
3xAXQDbsPL5zyAzA8p4LZ/Z4GEDkQPQhf3wNwDb04H4urhlAb1raLRsXDsCM
UhLnh7AaQNY47+FHmA7A8LmfnwKAG0AY3DI+BQAPwH9mEQ0=
         "]], 
         0.06902834008686508], ArrowBox[BezierCurveBox[CompressedData["
1:eJwB8QIO/SFib1JlAgAAAC4AAAACAAAA0NEAnwKAE0BgcMv4FADsvy3ZtxBn
0hJA/ysiWlKb7b/yoUse/PwRQF0xTvvclO+/Gyy8x8H/EEA+wCduWvbwv1Tv
EhpwtQ9AqQyT/mxR8r9ACWfcvRsNQPT96C6m2/O/96V01mwyCkAelCn/BZX1
v3rFOwh9+QZAJ89Ub4x997/JZ7xx7nADQA6van85lfm/xhntJYIx/z/UM2sv
Ddz7v6mGflt+oP0/mYaq7klj/L8Aknl3+yP8P1DSoyZzBf2/zDveefm7+j/4
FlfXiML9vwuErGJ4aPk/jlTEAIua/r+8auQxeCn4PxSL66J5jf+/5O+F5/j+
9j9GXeZeqk0AwH0TkYP66PU/evGzKA7iAMCM1QUGfef0PyaC3i7ogwHAc2EP
Hln88T/lqP8K0swDwJ+QNHcFOPE//KrZaqqABMCtvn3KgrDwP4Ga+8gcMAXA
nOvqF9Fl8D9zd2UlKdsFwGsXfF/wV/A/0UEXgM+BBsAbQjGh4IbwP535ENkP
JAfArWsK3aHy8D/YnlIw6sEHwCCUBxM0m/E/fjHchV5bCMB0uyhDl4DyP5Kx
rdls8AjA2veRv4nN+D/kqP8K0swLwAIzqE+Fbvo/PwWuaj17DMAztQPsDx78
P5MDTchoGg3AbH6klCnc/T/eo9wjVKoNwKqOiknSqP8/H+Zcff8qDsD48loF
BcIAQFfKzdRqnA7AH0ITbOi2AUCFUC8qlv4OwMo07lgTswJAqniBfYFRD8D5
yuvLhbYDQMZCxM4slQ/AqwQMxT/BBEDZrvcdmMkPwOquhfni+wtARhcygxp+
EMCAFojJt04RQCB9lGy6ChHAer/VyPJSFED5CCPLq4oRwF/Sq3qiChdA0brd
nu79EcAwTwrfxnUZQKqSxOeCZBLA7DXx9V+UG0CDkNelaL4SwJaGYL9tZh1A
XLQW2Z8LE8AtQVg78OseQDT+gYEoTBPA2DLstHMSIEAMbhmfAoATwPJodgA=

         "]], 0.06902834008686508], ArrowBox[BezierCurveBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAA0NEAnwKAE0BgcMv4FADsv5qmxq16
ghRA3j043aGd7b/az01oxsIVQNh4pgcbnu+/j02WzuVAF0CoEAs8wADxv7gf
oODY/BhAnptDF+lj8r9XRmuen/YaQFTdfBWI+PO/bMH3BzouHUDH1bY2nb71
v/WQRR2oox9A+ITxeii29796WirvdCshQOXqLOIp3/m/tJaSpf+jIkCRB2ls
oTn8vz7oUJcT3SJAccJsUTqt/L9RVajLFQojQCGIQDIPPv2/6d2YQgYrI0Cg
WOQOIOz9vweCIvzkPyNA7DNY52y3/r+sQUX4sUgjQAoanLv1n/+/1hwBN21F
I0B7BdhF3VIAwIgTVrgWNiNAWQPKq13kAMDAJUR8rhojQJ4GpA98hAHAYrln
HM6MIkDlqP8K0swDwHroB0YFZSJAZ+Lp0SV/BMDA/kBzsEgiQC94PGUKKgXA
NfwSpM83IkA7avfEf80FwNXgfdhiMiJAirga8YVpBsClrIEQajgiQB5jpukc
/gbAol8eTOVJIkD4aZquRIsHwM35U4vUZiJAFM32P/0QCMAmeyLON48iQHSM
u51GjwjArOOJFA/DIkAaqOjHIAYJwAsBShsmOyNAOnhb1U72CcAZpHH+dqoj
QKhOnpvw1ArA1MwAvgERJEBkK7EaBqILwD5791nGbiRAaw6UUo9dDMBWr1XS
xMMkQMD3RkOMBw3AHWkbJ/0PJUBi58ns/J8NwJKoSFhvUyVAUt0cT+EmDsC2
bd1lG44lQI/ZP2o5nA7AiLjZTwHAJUAY3DI+BQAPwIxTE+o=
         "]], 
         0.06902834008686508], ArrowBox[BezierCurveBox[CompressedData["
1:eJwt0n8w03Ecx/H9MNsYY98kK6Tm0Nr8PERd74pOF5JzouvX1JxwEp3z+2eS
frHLj8iPZLRYnRR11fX54BL9RCj9cH6dsmOhrrTJCv3xuuc9/n9ZhJzwF1NI
JJLw3xbb1U2qpKQTcCT6xdwK0iRicchLZjuGDYvTpxAreNllPqGr+DbfUFft
srWGRnwdUqZRgHrZlp5trszEGVQWSFmyc2DvLu75WSR78N/Eykxxw3cUZ0Fd
Mi/57LBi4gdiSJZNkvDD6lx+ogN0rSU/36sxkpb8QrVddVnOSQRY36JvGP81
h7ibKux7IglolXiNprqpUDMMyvoCCLiiadkWJVKj+C/hE+BIgPRnrOe9yHl0
TODxnWAQoIw7pPQ78AclcMLbfd9yICY9Y7OH3QJqKvoUMlPAATvis+2lrwuI
+/Bqh9qbA9a2JzuE2RrUOGnl1v1BCzJdXBQRLBo2P6dqUTZQoXBEVX00jYZH
icdmx19RYM399LytKhr+kxvpB3YUMGrqkGuStXH4pO6+UwNkSP3Uo66m07HQ
vdSB1kmGg4LK5I2ldOwVZzw6u0AG+Q2BbYkTAzeXZ4VtSaJA9O5UQtHPwAl3
BlvHtlChZpXExjyDieXq1S/3K7RhTKbR6Xmpi+1FodmOJgwwtzcJFSWxsHtN
a0qQDxMM7v5umuPq4fZndk2dZ3TgvrBKVVyvh7s7Gvg5T3WBkLKdtgr0cYhs
+3A+Uw94hGeIslIfx4SO943764MiaVt2DZWNtallzNwqNogHtcqPBbExG9k/
eZRoAEVueTf5FWz8McLMONjKEFLyh+pUvWx8bYPE/HS2EQgvF0+XZBpgm/7X
0ak5JjBvGzjP1zfEp6Le6XgJTKHeTB7veNEQ44S+uGj3teB6uETcoDHEtY3S
C7xGC5DOmLZdF3OwUjSwE6vWwXTfJokO4uDCnNiaHUY84LKm3nzRJXDl+ljZ
bbIl8Apc0ty8Ccxwfr+HjC2BFWWy+CP8F0M9SQo=
         "]], 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAA0NEAnwKAE0BgcMv4FADsv5iV7IH4
TxNADzNo4WWA7b8mHQzb3xoTQJxNZhgrKe+/d2hfqrjgEkAE4OJOMn3wv4x3
5u+CoRJAJUXDOAl68b9mSqGrPl0SQDZW1Ekai/K/BOGP3esTEkA2ExaCZbDz
v2U7soWKxRFAJHyI4erp9L+LWQikGnIRQACRK2iqN/a/djuSOJwZEUDKUf8V
pJn3v7hfLeBtyhBAwWTJbYz6+L/mRLc37pIQQCdwT/IXRfq/AOsvPx1zEED6
c5GjRnn7vwRSl/b6ahBANnCPgRiX/L/0ee1dh3oQQORkSYyNnv2/0GIydcKh
EED8Ub/DpY/+v5YMZjys4BBAgjfxJ2Fq/79Jd4izRDcRQLqKb9xfFwDA5qKZ
2oulEUDqdUS7YG4AwGUY09+WPRNAf3YPFGh+AcDMUzSpsLUUQFUdoO8jeQLA
GVW9NtkNFkBravZNlF4DwEwcbogQRhdAvl0SL7kuBMBmqUaeVl4YQFH385KS
6QTAZvxGeKtWGUAkN5t5II8FwE4VbxYPLxpANh0I42IfBsAc9L54gecaQIip
Os9ZmgbA0Jg2nwKAG0AY3DI+BQAHwMxazcg=
         "]], 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAA0NEAnwKAE0BgcMv4FADsv8DoKNkW
4BNADzNo4WWA7b/mbekmSEoUQJxNZhgrKe+/P2FCiJa+FEAE4OJOMn3wv83C
M/0BPRVAJUXDOAl68b+Pkr2FisUVQDZW1Ekai/K/htDfITBYFkA2ExaCZbDz
v7B8mtHy9BZAJHyI4erp9L8Ql+2U0psXQACRK2iqN/a/ox/Za89MGEDKUf8V
pJn3vwKJWNp3AxlAeQAQMs7/+L/LRWdkWrsZQAffaQMfWvq/+lUFCnd0GkBx
7QyKlqj7v5C5MsvNLhtAtSv5xTTr/L+KcO+nXuobQNmZLrf5If6/7Xo7oCmn
HEDYN61d5Uz/v7bYFrQuZR1A2oK63Ps1AMDmiYHjbSQeQLcBQ2WYvwDAfI57
LufkHkCCGHBISEMBwDszltb1HCBAfO3inKAmAsAypzfLcLsgQG4EYjjv+QLA
IyMideRNIUBZXe0aNL0DwA6nVdRQ1CFAOPiERG9wBMDyMtLotU4iQBDVKLWg
EwXA0caXshO9IkDg89hsyKYFwKlipjFqHyNAplSVa+YpBsB8Bv5luXUjQGT3
XbH6nAbASLKeTwHAI0AY3DI+BQAHwEj21nY=
         "]], 0.06902834008686508], 
        ArrowBox[{{4.875009998726867, -0.8750100001593744}, {
         5.875009999477797, -1.8750100001593744`}}, 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAAGGtuXELFJkBgcMv4FADsv0YzBDDw
hSZAWQg5+a2T7b/67pRWODomQMSiqXdLdu+/NJ4g0BriJUDRnw669tPwv/JA
p5yXfSVAdu9J90kU8r821yi8rgwlQFXAhnMffPO/AGGlLmCPJEBsEsUudwv1
v1DeHPSrBSRAvOUEKVHC9r8kT48Mkm8jQEM6RmKtoPi/frP8dxLNIkAEEIna
i6b6v8Z4BqkSkiJAzxGG0b1u+7+AETcVqVgiQOToU+A3Svy/qX2OvNUgIkBF
lfIG+jj9v0K9DJ+Y6iFA7hZiRQQ7/r9M0LG88bUhQOFtoptWUP+/xrZ9FeGC
IUAQzdmEeDwAwLBwcKlmUSFA1M3Kx2naAMAL/ol4giEhQD05pBb/gQHA5T9g
HM6MIEA+QxoL0swDwMiZNURLXyBASbnKa92CBMCzHQtsyDEgQH7Xe8zoOAXA
qsvgk0UEIEDanS0t9O4FwFRHbXeFrR9AXgzgjf+kBsBoSxnHf1IfQAojk+4K
WwfAkKPFFnr3HkDe4UZPFhEIwM1PcmZ0nB5A2kj7ryHHCMAfUB+2bkEeQABY
sBAtfQnAg6TMBWnmHUBMD2ZxODMKwN/7X5rqjR1AsO9PSDXkCsAcBb+4ejod
QB56oQsViwvANcDpYBnsHECXrlq71ycMwCot4JLGohxAFY17V326DMD9S6JO
gl4cQJ4VBOAFQw3ArhwwlEwfHEAwSPRUccENwDufiWMl5RtAyCRMtr81DsCo
0668DLAbQGyrCwTxnw7A8LmfnwKAG0AY3DI+BQAPwI6ODrg=
         "]], 
         0.06902834008686508], ArrowBox[BezierCurveBox[CompressedData["
1:eJwB8QIO/SFib1JlAgAAAC4AAAACAAAAGGtuXELFJkBgcMv4FADsv2CHZ2fo
8CZAstPCZYSC7b9CkqXEmiEnQCjQ0CmlMe+/v4sodFlXJ0Dhsnqiu4bwv9Rz
8HUkkidAPkqYW/2K8b+CSv3J+9EnQC0uQcCXpfK/yQ9PcN8WKECsXnXQitbz
v6rD5WjPYChAvts0jNYd9b8mZsGzy68oQGKlf/N6e/a/OvfhUNQDKUCWu1UG
eO/3vxdNcp6xUSlA7Hy/YotJ+b+YN/QEaJ8pQOfeg0O9pfq/u7ZnhPfsKUCG
4aKoDQT8v3vKzBxgOipAxoQcknxk/b/fciPOoYcqQKnI8P8Jx/6/5K9rmLzU
KkCY1g/52hUAwIiBpXuwIStALZlUNEDJAMDQ59B3fW4rQBOsxrG0fQHAl5ta
SMjOLEC5OmxVicIEwFX4coAK/yxAeIlHyQJFBcCg9GNemyQtQOJmD2iNzQXA
eZAt4no/LUD00sMxKVwGwNzLzwupTy1AsM1kJtbwBsDKpkrbJVUtQBZX8kWU
iwfARiGeUPFPLUAkb2yQYywIwEw7ymsLQC1A3hXTBUTTCMDf9M4sdCUtQEBL
JqY1gAnAAgqytUCgLEDkqP8K0swLwAUJaVCTdCxApTxV8BB7DMBMtPqszUYs
QCvh6d62GQ3A0wtny+8WLEB0lr3Ww6gNwJgPrqv55CtAgFzQ1zcoDsCdv89N
67ArQE4zIuISmA7A5BvMscR6K0DeGrP1VPgOwGoko9eFQitAMRODEv5ID8Ay
2VS/LggrQEgckjgOig/AODrhaL/LKkAhNuBnhbsPwOWztvj1AilABgQZOIt4
EMDYx0HKHGAnQGJKFbd4BhHADnaC3TPjJUAl7uQwi4cRwIa+eDI7jCRATO+H
pcL7EcBBoSTJMlsjQNpN/hQfYxLAQh6GoRpQIkDOCUh/oL0SwIY1nbvyaiFA
KCNl5EYLE8AN52kXu6sgQOeZVUQSTBPA2DLstHMSIEAMbhmfAoATwKXWX20=

         "]], 0.06902834008686508], ArrowBox[BezierCurveBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAAGGtuXELFJkBgcMv4FADsv5Uddew1
FydAApXN4LeM7b9Y8/mYnHYnQGbV+xVzWu+/X+z8YXbjJ0DIGCtMo7Twv6gI
fkfDXShAu1TuM5nc8b82SH1Jg+UoQJCeR0IbJfO/Bqv6Z7Z6KUBG9jZ3KY70
vxwx9qJcHSpA3lu80sMX9r912m/6dc0qQFbP11Tqwfe/EadnbgKLK0CwUIn9
nIz5v0F/0eVZ8ytA4qYXxPqP+r9wvT9CHFssQAhfC4qqn/u/mmGyg0nCLEAg
eWRPrLv8v75rKarhKC1AKvUiFADk/b/h26S15I4tQCbTRtilGP+//rEkplL0
LUCLCejNziwAwBjuqHsrWS5AfVpfr3PTAMAukDE2b70uQGdciZBBgAHAkW4w
f18AMEDlqP8K0swDwMqYAPpPLDBAWOFAtr58BMBn3GFYvUwwQPNzmPZtIAXA
aDlUmqdhMECzYAbM37cFwMqv178OazBAmaeKNhRDBsCRP+zI8mgwQKZIJTYL
wgbAuuiRtVNbMEDZQ9bKxDQHwEeryIUxQjBAMpmd9ECbB8A4h5A5jB0wQLJI
e7N/9QfAFfnSocfaL0BWUm8HgUMIwMJTWEw9NS5AdTQb64dcCcD9FaC0OrEs
QMYaRVA0XwrAvj+q2r9OK0BGBe02hksLwAnRdr7MDSpA8vMSn30hDMDcyQVg
Ye4oQM/mtoga4QzAOipXv33wJ0Da3djzXIoNwCDyatwhFCdAFdl44EQdDsCQ
IUG3TVkmQIDYlk7SmQ7AiLjZTwHAJUAY3DI+BQAPwNXfG98=
         "]], 
         0.06902834008686508], ArrowBox[BezierCurveBox[CompressedData["
1:eJwB8QIO/SFib1JlAgAAAC4AAAACAAAAGGtuXELFJkBgcMv4FADsv3YM1Xs1
SidAsXn04BKc7b/EYI49E+4nQCRolxbfl++/BWiaoduwKEDdHdrMvPnwvzQi
+aeOkilANnolNXFX8r9Sj6pQLJMqQCLJLcQM5fO/Y6+um7SyK0CcCvN5j6L1
v2SCBYkn8SxAqD51VvmP979VCK8YhU4uQERltFlKrfm/NkGrSs3KL0BxfrCD
gvr7vyDPcv0gCjBAzzz0yFp7/L90zfpPFi4wQNJBxA3gF/2/lpvtnEZRMEB1
jSBSEtD9v4Y5S+SxczBAuh8JlvGj/r9EpxMmWJUwQKH4fdl9k/+/0ORGYjm2
MEAWjD+OW08AwCvy5JhV1jBALD+Gr87iAMBTz+3JrPUwQJMVk1AYhAHADIYe
wFdmMUCjw0XqUiIEwMEqlst7fjFABDgDVWzGBMCFF+S/1ZAxQIUYCzeibAXA
VUwInWWdMUAjZV2Q9BQGwC/JAmMrpDFA3h36YGO/BsAXjtMRJ6UxQLhC4aju
awfAC5t6qVigMUCw0xJolhoIwAvw9ynAlTFAxtCOnlrLCMAYjUuTXYUxQPo5
VUw7fgnAt8ZEBMk2MUDkqP8K0swLwFdPqRZBHTFAyeZzP0R7DMD51qzAzAIx
QLmJZBuEGg3Aml1PAmznMEC1kdGekaoNwD7jkNseyzBAuv66yWwrDsDjZ3FM
5a0wQMjQIJwVnQ7AiOvwVL+PMEDgBwMWjP8OwC9uD/WscDBAAqRhN9BSD8DX
78wsrlAwQDClPADilg/AgHAp/MIvMEBmC5RwwcsPwCx0vgwRnC5AekjuG/V+
EMDMnUSQ7v0sQMyShMlhCxHA413lgh6FK0Cn5AzBJosRwG60oOSgMSpACj6H
AkT+EcBuoXa1dQMpQPie8425ZBLA5SRn9Zz6J0BuB1Jjh74SwNA+cqQWFydA
bneigq0LE8Ay75fC4lgmQPnu5OsrTBPACDbYTwHAJUAMbhmfAoATwA9IWm8=

         "]], 0.06902834008686508], ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAGGtuXELFJkBgcMv4FADsv/jl4NOB
ayZAGrvWfS2Z7b8rPjW+Af4lQMltIIpJjO+/sHNrG8J8JUA2RNSOtOzwv4WG
g+vC5yRAgIU3HEZA8r+sdn0uBD8kQMT6OW3ZwPO/JkRZ5IWCI0AApNuBbm71
v/DuFg1IsiJAOIEcWgVJ978Od7aoSs4hQGmS/PWdUPm/fNw3t43WIECT13tV
OIX7v2+yK3yQmSBA82k8Za4e/L/Aet9qZV4gQGCEaxHs0Py/bDVTgwwlIEDa
Jgla8Zv9v+TEDYsL2x9AXFEVP75//r+oA/Viom8fQOsDkMBSfP+/JCdcjt0H
H0BCnzxv10gAwFgvQw29ox5AlYBoTOnfAMBCHKrfQEMeQO2ly/degwHA4+2Q
BWnmHUBLD2ZxODMCwKa6HZrqjR1Ar+9PSDXkAsD6mHa4ejodQB56oQsViwPA
3IibYBnsHECWrlq71ycEwEyKjJLGohxAFY17V326BMBJnUlOgl4cQJ0VBOAF
QwXA1cHSk0wfHEAvSPRUccEFwPD3J2Ml5RtAySRMtr81BsCZP0m8DLAbQGyr
CwTxnwbA0Jg2nwKAG0AY3DI+BQAHwJKI0TU=
         "]], 0.06902834008686508], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAGGtuXELFJkBgcMv4FADsv3i9RrsA
uSZADzNo4WWA7b9pTkPTdKsmQJxNZhgrKe+/6x1kpJ6cJkAE4OJOMn3wv/wr
qS5+jCZAJUXDOAl68b+geBJyE3smQDZW1Ekai/K/1AOgbl5oJkA2ExaCZbDz
v5nNUSRfVCZAJHyI4erp9L/u1SeTFT8mQACRK2iqN/a/1Rwiu4EoJkDKUf8V
pJn3v/9cXTKRECZAoB6iUY8B+b8mUfaOMfclQKFXsoEjYfq/Rvns0GLcJUDN
/C+mYLj7v11VQfgkwCVAHg4bv0YH/b9uZfMEeKIlQJ6Lc8zVTf6/eikD91uD
JUBGdTnODYz/v36hcM7QYiVAjGU2YvdgAMB8zTuL1kAlQIrGhle89wDAdK1k
LW0dJUCd3Q3HVYoBwGj3XntR6CRAT7Imj8ReAsDJoLHvx7YkQCDn3b3qJAPA
mKlcitCIJEAPfDNTyNwDwNERYEtrXiRAHHEnT12GBMB22bsymDckQEXGubGp
IQXAiABwQFcUJECNe+p6ra4FwAaHfHSo9CNA85C5qmgtBsDybOHOi9gjQHcG
J0HbnQbASLKeTwHAI0AY3DI+BQAHwJd+0GQ=
         "]], 0.06902834008686508], 
        ArrowBox[{{11.385271919707108`, -0.8750100001593744}, {
         5.875009999477797, -1.8750100001593744`}}, 0.06902834008686508], 
        ArrowBox[{{11.385271919707108`, -0.8750100001593744}, {
         11.875010001957136`, -1.8750100001593744`}}, 0.06902834008686508]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{10.250020002231253`, -6.625030000478123}, 
          0.06902834008686508], 
         InsetBox["a", 
          Offset[{2, 2}, {10.319048342318117`, -6.556001660391258}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8750100001593779, -6.625030000478123}, 
          0.06902834008686508], 
         InsetBox["b", 
          Offset[{2, 2}, {0.944038340246243, -6.556001660391258}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.8750100079764564`, -3.8750100001593744`}, 
          0.06902834008686508], 
         InsetBox["6", 
          Offset[{2, 2}, {6.944038348063321, -3.805981660072509}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{8.03603902228626, -4.875010000159374}, 0.06902834008686508],
          InsetBox["2", 
          Offset[{2, 2}, {8.105067362373125, -4.80598166007251}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{10.87501000912404, -3.8750100001593744`}, 
          0.06902834008686508], 
         InsetBox["8", 
          Offset[{2, 2}, {10.944038349210905`, -3.805981660072509}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{10.87501000894828, -4.875010000159374}, 
          0.06902834008686508], 
         InsetBox["4", 
          Offset[{2, 2}, {10.944038349035145`, -4.80598166007251}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.87501000185712, -2.8750100001593744`}, 
          0.06902834008686508], 
         InsetBox["10", 
          Offset[{2, 2}, {6.944038341943985, -2.805981660072509}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{9.875010002252694, -2.8750100001593744`}, 
          0.06902834008686508], 
         InsetBox["12", 
          Offset[{2, 2}, {9.944038342339558, -2.805981660072509}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.875009999477797, -1.8750100001593744`}, 
          0.06902834008686508], 
         InsetBox["14", 
          Offset[{2, 2}, {5.944038339564662, -1.8059816600725094`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{11.875010001957136`, -1.8750100001593744`}, 
          0.06902834008686508], 
         InsetBox["16", 
          Offset[{2, 2}, {11.944038342044001`, -1.8059816600725094`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.875009998726867, -0.8750100001593744}, 
          0.06902834008686508], 
         InsetBox["18", 
          Offset[{2, 2}, {4.944038338813732, -0.8059816600725093}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{11.385271919707108`, -0.8750100001593744}, 
          0.06902834008686508], 
         InsetBox["20", 
          Offset[{2, 2}, {11.454300259793973`, -0.8059816600725093}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.67905495549273*^9, 3.679055146413578*^9, 
  3.679059171836483*^9, 3.6792470689024677`*^9, 3.6796603772988615`*^9, 
  3.6796605374149094`*^9}]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{
  3.679054905503214*^9, {3.6790550002613416`*^9, 3.6790550005626945`*^9}, {
   3.6792459510600014`*^9, 3.6792459533757296`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grafo", "[", 
  RowBox[{
   RowBox[{"AristasWolframSystemToCombinatorica", "[", 
    RowBox[{"EdgeList", "[", 
     RowBox[{"GrafoRandomConexo", "[", 
      RowBox[{"15", ",", "50"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
   RowBox[{"shape", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.679055012592317*^9, 3.679055111033562*^9}, {
  3.679055152185417*^9, 3.6790552645810738`*^9}, {3.6790553130588255`*^9, 
  3.67905531399012*^9}}],

Cell[BoxData[
 Graphics3DBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 8, 10, 11, 13, 4, 12, 15, 5, 6, 14, 7, 9}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {2, 3}, {2, 8}, {
       2, 4}, {2, 6}, {2, 9}, {2, 7}, {2, 10}, {3, 11}, {3, 12}, {3, 6}, {3, 
       9}, {3, 7}, {3, 13}, {8, 11}, {8, 5}, {8, 9}, {8, 13}, {11, 14}, {11, 
       4}, {11, 15}, {11, 7}, {11, 10}, {12, 9}, {14, 6}, {14, 9}, {14, 10}, {
       4, 5}, {4, 6}, {4, 13}, {15, 9}, {15, 13}, {15, 10}, {5, 9}, {5, 7}, {
       5, 13}, {5, 10}, {6, 7}, {6, 13}, {6, 10}, {9, 13}, {9, 10}, {7, 13}, {
       7, 10}, {13, 10}}}, {
      GraphLayout -> {"Dimension" -> 3}, ImagePadding -> 10, 
       VertexShapeFunction -> {{White, 
          EdgeForm[Black], 
          Sphere[#, 0.1], Black, 
          Text[#2, #]}& }}]]}, 
    TagBox[GraphicsGroup3DBox[{
       {Hue[0.6, 0.2, 0.8], 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.0493916201557445, 0.5518481702239879, 
          1.075220156971738}, {0.7381067201581237, 0.7978039206380596, 
          0.729582884306727}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.0493916201557445, 0.5518481702239879, 
          1.075220156971738}, {1.224958316762407, 0.6043049041407087, 
          1.1305363330702116`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.0493916201557445, 0.5518481702239879, 
          1.075220156971738}, {0., 1.482327078526706, 1.0061274080156435`}}}],
           0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.0493916201557445, 0.5518481702239879, 
          1.075220156971738}, {0.5082258145742579, 1.2955591097305998`, 
          0.38697152058429474`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.0493916201557445, 0.5518481702239879, 
          1.075220156971738}, {0.7153950051267053, 1.007157705028371, 
          1.6820375588911254`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.0493916201557445, 0.5518481702239879, 
          1.075220156971738}, {0.4619712629058239, 1.1926916566782475`, 
          1.2585299344705043`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7381067201581237, 0.7978039206380596, 
          0.729582884306727}, {1.224958316762407, 0.6043049041407087, 
          1.1305363330702116`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7381067201581237, 0.7978039206380596, 
          0.729582884306727}, {0., 1.482327078526706, 1.0061274080156435`}}}],
           0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7381067201581237, 0.7978039206380596, 
          0.729582884306727}, {0.7153950051267053, 1.007157705028371, 
          1.6820375588911254`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7381067201581237, 0.7978039206380596, 
          0.729582884306727}, {0.4619712629058239, 1.1926916566782475`, 
          1.2585299344705043`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7381067201581237, 0.7978039206380596, 
          0.729582884306727}, {1.150967349264792, 1.6226279538326596`, 0.}}}],
           0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7381067201581237, 0.7978039206380596, 
          0.729582884306727}, {1.723791084534776, 1.1328403433283056`, 
          0.7242315574394695}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7381067201581237, 0.7978039206380596, 
          0.729582884306727}, {1.3199395361417607`, 1.4897397924856943`, 
          1.2623205029732216`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.224958316762407, 0.6043049041407087, 
          1.1305363330702116`}, {0.7153950051267053, 1.007157705028371, 
          1.6820375588911254`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.224958316762407, 0.6043049041407087, 
          1.1305363330702116`}, {0.4619712629058239, 1.1926916566782475`, 
          1.2585299344705043`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.224958316762407, 0.6043049041407087, 
          1.1305363330702116`}, {1.723791084534776, 1.1328403433283056`, 
          0.7242315574394695}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.224958316762407, 0.6043049041407087, 
          1.1305363330702116`}, {1.0476524424568696`, 1.9705839520495934`, 
          1.2128311852741394`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.224958316762407, 0.6043049041407087, 
          1.1305363330702116`}, {2.3584601269376653`, 0., 
          0.782289064510047}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.224958316762407, 0.6043049041407087, 
          1.1305363330702116`}, {1.0126683727940118`, 1.5654569647935344`, 
          0.751968721764801}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0., 1.482327078526706, 1.0061274080156435`}, {
          0.5082258145742579, 1.2955591097305998`, 0.38697152058429474`}}}], 
          0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0., 1.482327078526706, 1.0061274080156435`}, {
          0.7153950051267053, 1.007157705028371, 1.6820375588911254`}}}], 
          0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0., 1.482327078526706, 1.0061274080156435`}, {
          1.0476524424568696`, 1.9705839520495934`, 1.2128311852741394`}}}], 
          0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0., 1.482327078526706, 1.0061274080156435`}, {
          1.0126683727940118`, 1.5654569647935344`, 0.751968721764801}}}], 
          0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.5082258145742579, 1.2955591097305998`, 
          0.38697152058429474`}, {0.4619712629058239, 1.1926916566782475`, 
          1.2585299344705043`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.5082258145742579, 1.2955591097305998`, 
          0.38697152058429474`}, {1.150967349264792, 1.6226279538326596`, 
          0.}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.5082258145742579, 1.2955591097305998`, 
          0.38697152058429474`}, {1.723791084534776, 1.1328403433283056`, 
          0.7242315574394695}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.5082258145742579, 1.2955591097305998`, 
          0.38697152058429474`}, {1.3199395361417607`, 1.4897397924856943`, 
          1.2623205029732216`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.5082258145742579, 1.2955591097305998`, 
          0.38697152058429474`}, {1.0126683727940118`, 1.5654569647935344`, 
          0.751968721764801}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7153950051267053, 1.007157705028371, 
          1.6820375588911254`}, {0.4619712629058239, 1.1926916566782475`, 
          1.2585299344705043`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7153950051267053, 1.007157705028371, 
          1.6820375588911254`}, {1.3199395361417607`, 1.4897397924856943`, 
          1.2623205029732216`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7153950051267053, 1.007157705028371, 
          1.6820375588911254`}, {1.0126683727940118`, 1.5654569647935344`, 
          0.751968721764801}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.7153950051267053, 1.007157705028371, 
          1.6820375588911254`}, {1.7109721573923329`, 1.5558225172106912`, 
          1.968752801455817}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.4619712629058239, 1.1926916566782475`, 
          1.2585299344705043`}, {1.3199395361417607`, 1.4897397924856943`, 
          1.2623205029732216`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.4619712629058239, 1.1926916566782475`, 
          1.2585299344705043`}, {1.0476524424568696`, 1.9705839520495934`, 
          1.2128311852741394`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{0.4619712629058239, 1.1926916566782475`, 
          1.2585299344705043`}, {1.0126683727940118`, 1.5654569647935344`, 
          0.751968721764801}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.150967349264792, 1.6226279538326596`, 0.}, {
          1.723791084534776, 1.1328403433283056`, 0.7242315574394695}}}], 
          0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.150967349264792, 1.6226279538326596`, 0.}, {
          1.0476524424568696`, 1.9705839520495934`, 1.2128311852741394`}}}], 
          0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.150967349264792, 1.6226279538326596`, 0.}, {
          1.0126683727940118`, 1.5654569647935344`, 0.751968721764801}}}], 
          0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.723791084534776, 1.1328403433283056`, 
          0.7242315574394695}, {1.3199395361417607`, 1.4897397924856943`, 
          1.2623205029732216`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.723791084534776, 1.1328403433283056`, 
          0.7242315574394695}, {2.3584601269376653`, 0., 
          0.782289064510047}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.723791084534776, 1.1328403433283056`, 
          0.7242315574394695}, {1.0126683727940118`, 1.5654569647935344`, 
          0.751968721764801}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.723791084534776, 1.1328403433283056`, 
          0.7242315574394695}, {1.7109721573923329`, 1.5558225172106912`, 
          1.968752801455817}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.723791084534776, 1.1328403433283056`, 
          0.7242315574394695}, {1.9248751535623398`, 2.2182205812548768`, 
          0.8537936514313105}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.3199395361417607`, 1.4897397924856943`, 
          1.2623205029732216`}, {1.0476524424568696`, 1.9705839520495934`, 
          1.2128311852741394`}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.3199395361417607`, 1.4897397924856943`, 
          1.2623205029732216`}, {1.0126683727940118`, 1.5654569647935344`, 
          0.751968721764801}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.3199395361417607`, 1.4897397924856943`, 
          1.2623205029732216`}, {1.7109721573923329`, 1.5558225172106912`, 
          1.968752801455817}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.3199395361417607`, 1.4897397924856943`, 
          1.2623205029732216`}, {1.9248751535623398`, 2.2182205812548768`, 
          0.8537936514313105}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.0476524424568696`, 1.9705839520495934`, 
          1.2128311852741394`}, {1.7109721573923329`, 1.5558225172106912`, 
          1.968752801455817}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.0476524424568696`, 1.9705839520495934`, 
          1.2128311852741394`}, {1.9248751535623398`, 2.2182205812548768`, 
          0.8537936514313105}}}], 0.05091011414661731]}, 
        {Arrowheads[0.], 
         Arrow3DBox[TubeBox[{{{1.0126683727940118`, 1.5654569647935344`, 
          0.751968721764801}, {1.9248751535623398`, 2.2182205812548768`, 
          0.8537936514313105}}}], 0.05091011414661731]}}, 
       {Hue[0.6, 0.6, 1], 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{0.0493916201557445, 0.5518481702239879, 
          1.075220156971738}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["1", {0.0493916201557445, 0.5518481702239879, 
           1.075220156971738}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{0.7381067201581237, 0.7978039206380596, 
          0.729582884306727}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["2", {0.7381067201581237, 0.7978039206380596, 
           0.729582884306727}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.224958316762407, 0.6043049041407087, 
          1.1305363330702116`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["3", {1.224958316762407, 0.6043049041407087, 
           1.1305363330702116`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{0., 1.482327078526706, 1.0061274080156435`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["8", {0., 1.482327078526706, 1.0061274080156435`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{0.5082258145742579, 1.2955591097305998`, 
          0.38697152058429474`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["10", {0.5082258145742579, 1.2955591097305998`, 
           0.38697152058429474`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{0.7153950051267053, 1.007157705028371, 
          1.6820375588911254`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["11", {0.7153950051267053, 1.007157705028371, 
           1.6820375588911254`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{0.4619712629058239, 1.1926916566782475`, 
          1.2585299344705043`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["13", {0.4619712629058239, 1.1926916566782475`, 
           1.2585299344705043`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.150967349264792, 1.6226279538326596`, 0.}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["4", {1.150967349264792, 1.6226279538326596`, 0.}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.723791084534776, 1.1328403433283056`, 
          0.7242315574394695}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["12", {1.723791084534776, 1.1328403433283056`, 
           0.7242315574394695}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.3199395361417607`, 1.4897397924856943`, 
          1.2623205029732216`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["15", {1.3199395361417607`, 1.4897397924856943`, 
           1.2623205029732216`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.0476524424568696`, 1.9705839520495934`, 
          1.2128311852741394`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["5", {1.0476524424568696`, 1.9705839520495934`, 
           1.2128311852741394`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{2.3584601269376653`, 0., 0.782289064510047}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["6", {2.3584601269376653`, 0., 0.782289064510047}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.0126683727940118`, 1.5654569647935344`, 
          0.751968721764801}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["14", {1.0126683727940118`, 1.5654569647935344`, 
           0.751968721764801}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.7109721573923329`, 1.5558225172106912`, 
          1.968752801455817}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["7", {1.7109721573923329`, 1.5558225172106912`, 
           1.968752801455817}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.9248751535623398`, 2.2182205812548768`, 
          0.8537936514313105}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["9", {1.9248751535623398`, 2.2182205812548768`, 
           0.8537936514313105}]}}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  Boxed->False,
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  ImagePadding->10,
  ImageSize->{380.5815539714975, 311.586365613665},
  Lighting->Dynamic[
    FEPrivate`If[
     FEPrivate`SameQ[
     FEPrivate`$OperatingSystem, "Windows"], {{"Directional", 
       GrayLevel[0.7], 
       ImageScaled[{1, 1, 0}]}, {"Point", 
       GrayLevel[0.9], 
       ImageScaled[{0, 0, 3.5}], {0, 0, 0.07}}}, {{"Directional", 
       GrayLevel[0.7], 
       ImageScaled[{1, 1, 0}]}, {"Point", 
       GrayLevel[0.9], 
       ImageScaled[{0, 0, 0}], {0, 0, 0.07}}}]],
  ViewPoint->{0.06758178139110815, -2.610134091034937, 2.1523551588065635`},
  ViewVertical->{0.3877174501244493, -0.3699940908479486, 
   1.0061159566360303`}]], "Output",
 CellChangeTimes->{{3.67905507745686*^9, 3.679055111542524*^9}, {
   3.6790551545814123`*^9, 3.6790551707619886`*^9}, {3.6790552526993113`*^9, 
   3.679055265521768*^9}, 3.6790553152318354`*^9, 3.6790591758930635`*^9, 
   3.679247076076039*^9, 3.679660602525429*^9}]
}, Closed]],

Cell["Example 3", "SubitemNumbered",
 CellChangeTimes->{
  3.679054905503214*^9, {3.6790550002613416`*^9, 3.6790550005626945`*^9}, {
   3.679055306047937*^9, 3.679055306496003*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grafo", "[", 
  RowBox[{
   RowBox[{"AristasWolframSystemToCombinatorica", "[", 
    RowBox[{"EdgeList", "[", 
     RowBox[{"GrafoRandomConexo", "[", 
      RowBox[{"15", ",", "50"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"pesos", "\[Rule]", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "10"}], "}"}], ",", "50"}], "]"}]}], ",", 
   RowBox[{"mostrarpesos", "\[Rule]", "True"}], ",", 
   RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
   RowBox[{"shape", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.679055012592317*^9, 3.679055111033562*^9}, {
  3.679055152185417*^9, 3.6790552645810738`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 3, 4, 5, 7, 10, 11, 14, 15, 2, 6, 8, 12, 9, 13}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {
       10, 2}, {10, 11}, {10, 12}, {10, 9}, {2, 4}, {2, 12}, {2, 8}, {2, 9}, {
       3, 11}, {3, 12}, {3, 6}, {3, 7}, {3, 9}, {4, 5}, {4, 12}, {4, 7}, {4, 
       13}, {11, 5}, {11, 14}, {11, 6}, {11, 7}, {11, 15}, {11, 8}, {5, 12}, {
       5, 14}, {5, 13}, {5, 8}, {5, 9}, {12, 13}, {12, 8}, {12, 9}, {14, 
       13}, {14, 15}, {14, 8}, {14, 9}, {6, 7}, {6, 13}, {6, 9}, {7, 8}, {13, 
       9}, {15, 8}, {8, 9}}}, {
      EdgeLabels -> {
        UndirectedEdge[1, 7] -> 3, UndirectedEdge[1, 14] -> 7, 
         UndirectedEdge[6, 14] -> 7, UndirectedEdge[9, 15] -> 10, 
         UndirectedEdge[10, 11] -> 10, UndirectedEdge[7, 9] -> 7, 
         UndirectedEdge[2, 3] -> 7, UndirectedEdge[4, 6] -> 3, 
         UndirectedEdge[2, 15] -> 4, UndirectedEdge[5, 7] -> 7, 
         UndirectedEdge[3, 8] -> 6, UndirectedEdge[10, 15] -> 3, 
         UndirectedEdge[3, 14] -> 9, UndirectedEdge[4, 10] -> 9, 
         UndirectedEdge[11, 14] -> 7, UndirectedEdge[5, 8] -> 7, 
         UndirectedEdge[14, 15] -> 8, UndirectedEdge[6, 13] -> 10, 
         UndirectedEdge[13, 14] -> 10, UndirectedEdge[4, 8] -> 3, 
         UndirectedEdge[2, 8] -> 6, UndirectedEdge[1, 4] -> 2, 
         UndirectedEdge[7, 15] -> 3, UndirectedEdge[9, 12] -> 3, 
         UndirectedEdge[1, 11] -> 2, UndirectedEdge[7, 14] -> 2, 
         UndirectedEdge[3, 5] -> 8, UndirectedEdge[1, 15] -> 9, 
         UndirectedEdge[6, 7] -> 3, UndirectedEdge[5, 12] -> 3, 
         UndirectedEdge[8, 15] -> 2, UndirectedEdge[8, 14] -> 4, 
         UndirectedEdge[5, 11] -> 10, UndirectedEdge[9, 13] -> 9, 
         UndirectedEdge[1, 3] -> 7, UndirectedEdge[6, 11] -> 4, 
         UndirectedEdge[3, 15] -> 4, UndirectedEdge[1, 5] -> 9, 
         UndirectedEdge[12, 15] -> 1, UndirectedEdge[7, 8] -> 5, 
         UndirectedEdge[10, 12] -> 4, UndirectedEdge[1, 10] -> 6, 
         UndirectedEdge[8, 12] -> 9, UndirectedEdge[7, 12] -> 9, 
         UndirectedEdge[4, 11] -> 6, UndirectedEdge[2, 6] -> 10, 
         UndirectedEdge[6, 9] -> 10, UndirectedEdge[6, 10] -> 8, 
         UndirectedEdge[9, 14] -> 3, UndirectedEdge[4, 15] -> 9}, 
       EdgeWeight -> {7, 2, 9, 3, 6, 2, 7, 9, 7, 10, 6, 4, 8, 6, 9, 4, 3, 3, 
        9, 6, 9, 7, 7, 10, 3, 3, 10, 8, 4, 10, 7, 5, 7, 9, 2, 3, 9, 4, 2, 3, 
        9, 3, 10, 10, 4, 3, 7, 1, 10, 8}, GraphLayout -> {"Dimension" -> 3}, 
       ImagePadding -> 10, VertexShapeFunction -> {{White, 
          EdgeForm[Black], 
          Sphere[#, 0.1], Black, 
          Text[#2, #]}& }}]]}, 
    TagBox[GraphicsGroup3DBox[{
       {Hue[0.6, 0.2, 0.8], {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.3519169133398985`, 0.686931780938592, 
           1.138258499833048}, {2.475754255181927, 1.632052010438301, 
           0.8757509265852909}}}], 0.055971214959151666`]}, 
         Text3DBox["7", {2.4138355842609127`, 1.1594918956884466`, 
          1.0070047132091695`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.3519169133398985`, 0.686931780938592, 
           1.138258499833048}, {1.9036910099922604`, 0.8869771479215288, 
           1.6721687025354663`}}}], 0.055971214959151666`]}, 
         Text3DBox["2", {2.1278039616660793`, 0.7869544644300603, 
          1.4052136011842573`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.3519169133398985`, 0.686931780938592, 
           1.138258499833048}, {2.6915088924056016`, 0.598242427493702, 
           0.5116393627376687}}}], 0.055971214959151666`]}, 
         Text3DBox["9", {2.52171290287275, 0.6425871042161471, 
          0.8249489312853584}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.3519169133398985`, 0.686931780938592, 
           1.138258499833048}, {1.6276616544083904`, 0.6625572405726774, 
           0.30351848506972146`}}}], 0.055971214959151666`]}, 
         Text3DBox["3", {1.9897892838741444`, 0.6747445107556347, 
          0.7208884924513848}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.3519169133398985`, 0.686931780938592, 
           1.138258499833048}, {1.734559492693617, 0., 1.121775483454078}}}], 
           0.055971214959151666`]}, 
         Text3DBox["6", {2.0432382030167577`, 0.343465890469296, 
          1.1300169916435632`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.3519169133398985`, 0.686931780938592, 
           1.138258499833048}, {1.9896497112668106`, 0.2740773971009981, 
           1.6227873134389312`}}}], 0.055971214959151666`]}, 
         Text3DBox["2", {2.1707833123033544`, 0.48050458901979504`, 
          1.3805229066359896`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.3519169133398985`, 0.686931780938592, 
           1.138258499833048}, {1.3185464745050623`, 1.1132259461983107`, 
           0.9351091217286905}}}], 0.055971214959151666`]}, 
         Text3DBox["7", {1.8352316939224804`, 0.9000788635684513, 
          1.0366838107808694`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.3519169133398985`, 0.686931780938592, 
           1.138258499833048}, {1.7879146445617102`, 1.0112611197431685`, 
           0.7285759123884328}}}], 0.055971214959151666`]}, 
         Text3DBox["9", {2.0699157789508043`, 0.8490964503408802, 
          0.9334172061107404}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.475754255181927, 1.632052010438301, 
           0.8757509265852909}, {2.6915088924056016`, 0.598242427493702, 
           0.5116393627376687}}}], 0.055971214959151666`]}, 
         Text3DBox["8", {2.583631573793764, 1.1151472189660014`, 
          0.6936951446614799}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.475754255181927, 1.632052010438301, 
           0.8757509265852909}, {1.3185464745050623`, 1.1132259461983107`, 
           0.9351091217286905}}}], 0.055971214959151666`]}, 
         Text3DBox["9", {1.8971503648434946`, 1.3726389783183057`, 
          0.9054300241569907}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.475754255181927, 1.632052010438301, 
           0.8757509265852909}, {1.7879146445617102`, 1.0112611197431685`, 
           0.7285759123884328}}}], 0.055971214959151666`]}, 
         Text3DBox["4", {2.1318344498718185`, 1.3216565650907346`, 
          0.8021634194868619}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.475754255181927, 1.632052010438301, 
           0.8757509265852909}, {1.631791410930563, 2.049089153079553, 
           0.9547418060822711}}}], 0.055971214959151666`]}, 
         Text3DBox["7", {2.053772833056245, 1.8405705817589268`, 
          0.915246366333781}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.475754255181927, 1.632052010438301, 
           0.8757509265852909}, {2.128896642523567, 1.3277438522753944`, 
           0.41606517688174877`}}}], 0.055971214959151666`]}, 
         Text3DBox["6", {2.3023254488527467`, 1.4798979313568477`, 
          0.6459080517335198}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.9036910099922604`, 0.8869771479215288, 
           1.6721687025354663`}, {1.734559492693617, 0., 
           1.121775483454078}}}], 0.055971214959151666`]}, 
         Text3DBox["9", {1.8191252513429386`, 0.4434885739607644, 
          1.3969720929947722`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.9036910099922604`, 0.8869771479215288, 
           1.6721687025354663`}, {1.9896497112668106`, 0.2740773971009981, 
           1.6227873134389312`}}}], 0.055971214959151666`]}, 
         Text3DBox["6", {1.9466703606295355`, 0.5805272725112635, 
          1.647478007987199}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.9036910099922604`, 0.8869771479215288, 
           1.6721687025354663`}, {1.7879146445617102`, 1.0112611197431685`, 
           0.7285759123884328}}}], 0.055971214959151666`]}, 
         Text3DBox["9", {1.8458028272769853`, 0.9491191338323486, 
          1.2003723074619495`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.9036910099922604`, 0.8869771479215288, 
           1.6721687025354663`}, {1.0114930535162876`, 0.7903790740417578, 
           1.2583268681935564`}}}], 0.055971214959151666`]}, 
         Text3DBox["3", {1.4575920317542739`, 0.8386781109816432, 
          1.4652477853645114`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.9036910099922604`, 0.8869771479215288, 
           1.6721687025354663`}, {2.128896642523567, 1.3277438522753944`, 
           0.41606517688174877`}}}], 0.055971214959151666`]}, 
         Text3DBox["3", {2.0162938262579138`, 1.1073605000984617`, 
          1.0441169397086076`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.6915088924056016`, 0.598242427493702, 
           0.5116393627376687}, {1.6276616544083904`, 0.6625572405726774, 
           0.30351848506972146`}}}], 0.055971214959151666`]}, 
         Text3DBox["7", {2.159585273406996, 0.6303998340331898, 
          0.4075789239036951}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.6915088924056016`, 0.598242427493702, 
           0.5116393627376687}, {1.9896497112668106`, 0.2740773971009981, 
           1.6227873134389312`}}}], 0.055971214959151666`]}, 
         Text3DBox["10", {2.340579301836206, 0.43615991229735007`, 
          1.0672133380883}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.6915088924056016`, 0.598242427493702, 
           0.5116393627376687}, {2.128896642523567, 1.3277438522753944`, 
           0.41606517688174877`}}}], 0.055971214959151666`]}, 
         Text3DBox["7", {2.4102027674645843`, 0.9629931398845482, 
          0.46385226980970873`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.6915088924056016`, 0.598242427493702, 
           0.5116393627376687}, {1.8873718232752619`, 0.28141603873457977`, 
           0.}}}], 0.055971214959151666`]}, 
         Text3DBox["3", {2.289440357840432, 0.4398292331141409, 
          0.2558196813688344}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.6276616544083904`, 0.6625572405726774, 
           0.30351848506972146`}, {1.3185464745050623`, 1.1132259461983107`, 
           0.9351091217286905}}}], 0.055971214959151666`]}, 
         Text3DBox["2", {1.4731040644567264`, 0.8878915933854941, 
          0.619313803399206}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.6276616544083904`, 0.6625572405726774, 
           0.30351848506972146`}, {1.7879146445617102`, 1.0112611197431685`, 
           0.7285759123884328}}}], 0.055971214959151666`]}, 
         Text3DBox["3", {1.7077881494850504`, 0.8369091801579229, 
          0.5160471987290771}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.6276616544083904`, 0.6625572405726774, 
           0.30351848506972146`}, {1.0114930535162876`, 0.7903790740417578, 
           1.2583268681935564`}}}], 0.055971214959151666`]}, 
         Text3DBox["3", {1.319577353962339, 0.7264681573072176, 
          0.780922676631639}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.6276616544083904`, 0.6625572405726774, 
           0.30351848506972146`}, {2.128896642523567, 1.3277438522753944`, 
           0.41606517688174877`}}}], 0.055971214959151666`]}, 
         Text3DBox["5", {1.8782791484659787`, 0.9951505464240359, 
          0.3597918309757351}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.6276616544083904`, 0.6625572405726774, 
           0.30351848506972146`}, {1.8873718232752619`, 0.28141603873457977`, 
           0.}}}], 0.055971214959151666`]}, 
         Text3DBox["9", {1.7575167388418262`, 0.4719866396536286, 
          0.15175924253486073`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.6276616544083904`, 0.6625572405726774, 
           0.30351848506972146`}, {0.7687601953119882, 0.6690189024137008, 
           0.32143309099042083`}}}], 0.055971214959151666`]}, 
         Text3DBox["7", {1.1982109248601893`, 0.6657880714931891, 
          0.31247578803007114`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.734559492693617, 0., 1.121775483454078}, {
           1.9896497112668106`, 0.2740773971009981, 1.6227873134389312`}}}], 
           0.055971214959151666`]}, 
         Text3DBox["10", {1.8621046019802137`, 0.13703869855049905`, 
          1.3722813984465048`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.734559492693617, 0., 1.121775483454078}, {
           1.7879146445617102`, 1.0112611197431685`, 0.7285759123884328}}}], 
           0.055971214959151666`]}, 
         Text3DBox["3", {1.7612370686276635`, 0.5056305598715842, 
          0.9251756979212554}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.734559492693617, 0., 1.121775483454078}, {
           1.0114930535162876`, 0.7903790740417578, 1.2583268681935564`}}}], 
           0.055971214959151666`]}, 
         Text3DBox["8", {1.3730262731049523`, 0.3951895370208789, 
          1.1900511758238173`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.734559492693617, 0., 1.121775483454078}, {
           1.8873718232752619`, 0.28141603873457977`, 0.}}}], 
           0.055971214959151666`]}, 
         Text3DBox["4", {1.8109656579844393`, 0.14070801936728988`, 
          0.560887741727039}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.9896497112668106`, 0.2740773971009981, 
           1.6227873134389312`}, {1.3185464745050623`, 1.1132259461983107`, 
           0.9351091217286905}}}], 0.055971214959151666`]}, 
         Text3DBox["7", {1.6540980928859366`, 0.6936516716496544, 
          1.278948217583811}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.9896497112668106`, 0.2740773971009981, 
           1.6227873134389312`}, {1.0114930535162876`, 0.7903790740417578, 
           1.2583268681935564`}}}], 0.055971214959151666`]}, 
         Text3DBox["4", {1.500571382391549, 0.5322282355713779, 
          1.440557090816244}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.3185464745050623`, 1.1132259461983107`, 
           0.9351091217286905}, {1.7879146445617102`, 1.0112611197431685`, 
           0.7285759123884328}}}], 0.055971214959151666`]}, 
         Text3DBox["8", {1.5532305595333864`, 1.0622435329707396`, 
          0.8318425170585617}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.3185464745050623`, 1.1132259461983107`, 
           0.9351091217286905}, {1.0114930535162876`, 0.7903790740417578, 
           1.2583268681935564`}}}], 0.055971214959151666`]}, 
         Text3DBox["7", {1.165019764010675, 0.9518025101200343, 
          1.0967179949611234`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.3185464745050623`, 1.1132259461983107`, 
           0.9351091217286905}, {2.128896642523567, 1.3277438522753944`, 
           0.41606517688174877`}}}], 0.055971214959151666`]}, 
         Text3DBox["4", {1.7237215585143146`, 1.2204848992368524`, 
          0.6755871493052197}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.3185464745050623`, 1.1132259461983107`, 
           0.9351091217286905}, {0.7687601953119882, 0.6690189024137008, 
           0.32143309099042083`}}}], 0.055971214959151666`]}, 
         Text3DBox["3", {1.0436533349085253`, 0.8911224243060057, 
          0.6282711063595556}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.3185464745050623`, 1.1132259461983107`, 
           0.9351091217286905}, {0., 0.9783942581698489, 
           0.9255978577225303}}}], 0.055971214959151666`]}, 
         Text3DBox["10", {0.6592732372525312, 1.0458101021840798`, 
          0.9303534897256105}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.7879146445617102`, 1.0112611197431685`, 
           0.7285759123884328}, {1.631791410930563, 2.049089153079553, 
           0.9547418060822711}}}], 0.055971214959151666`]}, 
         Text3DBox["4", {1.7098530277461366`, 1.5301751364113607`, 
          0.841658859235352}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.7879146445617102`, 1.0112611197431685`, 
           0.7285759123884328}, {2.128896642523567, 1.3277438522753944`, 
           0.41606517688174877`}}}], 0.055971214959151666`]}, 
         Text3DBox["2", {1.9584056435426387`, 1.1695024860092813`, 
          0.5723205446350907}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.7879146445617102`, 1.0112611197431685`, 
           0.7285759123884328}, {1.8873718232752619`, 0.28141603873457977`, 
           0.}}}], 0.055971214959151666`]}, 
         Text3DBox["1", {1.837643233918486, 0.6463385792388741, 
          0.3642879561942164}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.7879146445617102`, 1.0112611197431685`, 
           0.7285759123884328}, {0.7687601953119882, 0.6690189024137008, 
           0.32143309099042083`}}}], 0.055971214959151666`]}, 
         Text3DBox["10", {1.2783374199368494`, 0.8401400110784346, 
          0.5250045016894268}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.631791410930563, 2.049089153079553, 
           0.9547418060822711}, {1.0114930535162876`, 0.7903790740417578, 
           1.2583268681935564`}}}], 0.055971214959151666`]}, 
         Text3DBox["10", {1.3216422322234251`, 1.4197341135606554`, 
          1.1065343371379137`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.631791410930563, 2.049089153079553, 
           0.9547418060822711}, {2.128896642523567, 1.3277438522753944`, 
           0.41606517688174877`}}}], 0.055971214959151666`]}, 
         Text3DBox["6", {1.880344026727065, 1.6884165026774736`, 
          0.68540349148201}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.0114930535162876`, 0.7903790740417578, 
           1.2583268681935564`}, {0.7687601953119882, 0.6690189024137008, 
           0.32143309099042083`}}}], 0.055971214959151666`]}, 
         Text3DBox["10", {0.8901266244141379, 0.7296989882277293, 
          0.7898799795919886}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.0114930535162876`, 0.7903790740417578, 
           1.2583268681935564`}, {0., 0.9783942581698489, 
           0.9255978577225303}}}], 0.055971214959151666`]}, 
         Text3DBox["10", {0.5057465267581438, 0.8843866661058033, 
          1.0919623629580433`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{2.128896642523567, 1.3277438522753944`, 
           0.41606517688174877`}, {1.8873718232752619`, 0.28141603873457977`, 
           0.}}}], 0.055971214959151666`]}, 
         Text3DBox["9", {2.0081342328994145`, 0.8045799455049871, 
          0.20803258844087438`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{1.8873718232752619`, 0.28141603873457977`, 
           0.}, {0.7687601953119882, 0.6690189024137008, 
           0.32143309099042083`}}}], 0.055971214959151666`]}, 
         Text3DBox["3", {1.3280660092936252`, 0.47521747057414027`, 
          0.16071654549521042`}, {0., 0.},
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          Arrow3DBox[TubeBox[{{{0.7687601953119882, 0.6690189024137008, 
           0.32143309099042083`}, {0., 0.9783942581698489, 
           0.9255978577225303}}}], 0.055971214959151666`]}, 
         Text3DBox["9", {0.3843800976559941, 0.8237065802917749, 
          0.6235154743564756}, {0., 0.},
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.6, 1], 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{2.3519169133398985`, 0.686931780938592, 
          1.138258499833048}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["1", {2.3519169133398985`, 0.686931780938592, 
           1.138258499833048}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{2.475754255181927, 1.632052010438301, 0.8757509265852909},
           0.1], 
         {GrayLevel[0], 
          Text3DBox["3", {2.475754255181927, 1.632052010438301, 
           0.8757509265852909}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.9036910099922604`, 0.8869771479215288, 
          1.6721687025354663`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["4", {1.9036910099922604`, 0.8869771479215288, 
           1.6721687025354663`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{2.6915088924056016`, 0.598242427493702, 
          0.5116393627376687}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["5", {2.6915088924056016`, 0.598242427493702, 
           0.5116393627376687}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.6276616544083904`, 0.6625572405726774, 
          0.30351848506972146`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["7", {1.6276616544083904`, 0.6625572405726774, 
           0.30351848506972146`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.734559492693617, 0., 1.121775483454078}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["10", {1.734559492693617, 0., 1.121775483454078}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.9896497112668106`, 0.2740773971009981, 
          1.6227873134389312`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["11", {1.9896497112668106`, 0.2740773971009981, 
           1.6227873134389312`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.3185464745050623`, 1.1132259461983107`, 
          0.9351091217286905}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["14", {1.3185464745050623`, 1.1132259461983107`, 
           0.9351091217286905}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.7879146445617102`, 1.0112611197431685`, 
          0.7285759123884328}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["15", {1.7879146445617102`, 1.0112611197431685`, 
           0.7285759123884328}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.631791410930563, 2.049089153079553, 0.9547418060822711},
           0.1], 
         {GrayLevel[0], 
          Text3DBox["2", {1.631791410930563, 2.049089153079553, 
           0.9547418060822711}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.0114930535162876`, 0.7903790740417578, 
          1.2583268681935564`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["6", {1.0114930535162876`, 0.7903790740417578, 
           1.2583268681935564`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{2.128896642523567, 1.3277438522753944`, 
          0.41606517688174877`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["8", {2.128896642523567, 1.3277438522753944`, 
           0.41606517688174877`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{1.8873718232752619`, 0.28141603873457977`, 0.}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["12", {1.8873718232752619`, 0.28141603873457977`, 
           0.}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{0.7687601953119882, 0.6690189024137008, 
          0.32143309099042083`}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["9", {0.7687601953119882, 0.6690189024137008, 
           0.32143309099042083`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         SphereBox[{0., 0.9783942581698489, 0.9255978577225303}, 0.1], 
         {GrayLevel[0], 
          Text3DBox["13", {0., 0.9783942581698489, 0.9255978577225303}]}}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  Boxed->False,
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  ImagePadding->10,
  ImageSize->{381.4656981162119, 382.1308342077852},
  Lighting->Dynamic[
    FEPrivate`If[
     FEPrivate`SameQ[
     FEPrivate`$OperatingSystem, "Windows"], {{"Directional", 
       GrayLevel[0.7], 
       ImageScaled[{1, 1, 0}]}, {"Point", 
       GrayLevel[0.9], 
       ImageScaled[{0, 0, 3.5}], {0, 0, 0.07}}}, {{"Directional", 
       GrayLevel[0.7], 
       ImageScaled[{1, 1, 0}]}, {"Point", 
       GrayLevel[0.9], 
       ImageScaled[{0, 0, 0}], {0, 0, 0.07}}}]],
  ViewPoint->{-0.4894609288015362, -1.0460808618573316`, 3.1805884407814475`},
  
  ViewVertical->{-0.7987170873584221, -0.48583812142912475`, 
   0.7231761397985133}]], "Output",
 CellChangeTimes->{3.679055321046646*^9, 3.679059183786168*^9, 
  3.6792470856681633`*^9, 3.679660861750239*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
GrafoC: construye un grafo con el paquete \
\[OpenCurlyDoubleQuote]Combinatorica\[CloseCurlyDoubleQuote] de Mathematica, \
dadas sus aristas como una matriz de pares ordenados. El comando presenta \
cuatro opciones: \
\[OpenCurlyDoubleQuote]dirigido->True\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]vertices->n\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]pesos->Lista\[CloseCurlyDoubleQuote] y \
\[OpenCurlyDoubleQuote]mostrarpesos->True\[CloseCurlyDoubleQuote]. \
\[OpenCurlyDoubleQuote]dirigido\[CloseCurlyDoubleQuote] genera un digrafo, \
\[OpenCurlyDoubleQuote]v\[EAcute]rtices\[CloseCurlyDoubleQuote] a\[NTilde]ade \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] nodos aislados en posiciones \
seudoaleatorias, \[OpenCurlyDoubleQuote]pesos\[CloseCurlyDoubleQuote] crea un \
grafo ponderado y \[OpenCurlyDoubleQuote]mostrarpesos\[CloseCurlyDoubleQuote] \
muestra los pesos sobre cada uno de los lados del grafo. Si se muestran los \
pesos de un grafo con aristas m\[UAcute]ltiples, por limitaciones en el \
software Mathematica, toma el mismo valor para cada lado repetido. Sintaxis: \
GrafoC[Aristas], o bien, GrafoC[Aristas, dirigido->True, vertices->n, \
pesos->Lista, mostrarpesos->True], pudiendo prescindir de cualquiera de las \
opciones. Por defecto, el grafo creado se almacena en una variable llamada \
\[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote].\
\>", "ItemNumbered",
 CellChangeTimes->{
  3.6683413894749837`*^9, {3.668341602126479*^9, 3.6683416024796114`*^9}}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6681615258125625`*^9, 
   3.6681615270506372`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"aristas", "=", 
  RowBox[{"RelBin", "[", 
   RowBox[{"\"\<a>b\>\"", ",", "A", ",", "A"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"GrafoC", "[", "aristas", "]"}], "\[IndentingNewLine]", 
 RowBox[{"GrafoC", "[", 
  RowBox[{"aristas", ",", 
   RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6683419454402447`*^9, 3.6683419519452353`*^9}, {
   3.6683427594038105`*^9, 3.668342793864458*^9}, {3.668342840832737*^9, 
   3.6683428540656624`*^9}, {3.6683428854574285`*^9, 
   3.6683428951493206`*^9}, {3.668342928369088*^9, 3.6683429508303986`*^9}, {
   3.6683429809988194`*^9, 3.6683430290228987`*^9}, {3.668372833435131*^9, 
   3.6683728429283123`*^9}, {3.668540832410922*^9, 3.6685408512868023`*^9}, {
   3.668540937187076*^9, 3.668540947891884*^9}, {3.668540979539482*^9, 
   3.668540994346823*^9}, {3.6792443157807207`*^9, 3.679244324958687*^9}, 
   3.679244390328472*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.668342756885948*^9, 3.6683427946481304`*^9}, {
   3.6683428348364716`*^9, 3.6683428547470584`*^9}, 3.668342896149705*^9, {
   3.668342931249338*^9, 3.668342951894041*^9}, 3.668342989918112*^9, 
   3.6683430383956957`*^9, 3.668343484194454*^9, 3.6683733221301746`*^9, 
   3.668375320019981*^9, 3.668376459311911*^9, 3.66854075354366*^9, 
   3.6685409486388483`*^9, {3.668540980702764*^9, 3.668540987960962*^9}, 
   3.6685411667306795`*^9, 3.668851982975193*^9, 3.668856572113917*^9, 
   3.668959330902695*^9, 3.6696368170569677`*^9, 3.669641734500167*^9, 
   3.6700577775613823`*^9, 3.670062478869009*^9, 3.67924432612008*^9, 
   3.679244391323191*^9, 3.679247099819332*^9, 3.6796610014863544`*^9}],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.645841624856078, 0.9749143690630834}, {0.07280133647277633, 
      0.788722292632364}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.645841624856078, 0.9749143690630834}, {0.07280133647277627, 
      0.18619207643071953`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.07280133647277633, 0.788722292632364}, {0.07280133647277627, 
      0.18619207643071953`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.645841624856078, 0.9749143690630834}, {0.6458416248560779, 
      0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.07280133647277633, 0.788722292632364}, {0.6458416248560779, 
      0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.07280133647277627, 0.18619207643071953`}, {
      0.6458416248560779, 0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.645841624856078, 0.9749143690630834}, {1., 
      0.4874571845315417}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.07280133647277633, 0.788722292632364}, {1., 
      0.4874571845315417}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.07280133647277627, 0.18619207643071953`}, {1., 
      0.4874571845315417}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6458416248560779, 0.}, {1., 0.4874571845315417}}], 
     {GrayLevel[0]}}}, {
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.645841624856078, 0.9749143690630834}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["1", 
       Scaled[{0.02, 0.02}, {0.645841624856078, 0.9749143690630834}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.07280133647277633, 0.788722292632364}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["2", Scaled[{0.02, 0.02}, 
       {0.07280133647277633, 0.788722292632364}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.07280133647277627, 0.18619207643071953`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["3", 
       Scaled[{0.02, 0.02}, {0.07280133647277627, 0.18619207643071953`}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.6458416248560779, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["4", 
       Scaled[{0.02, 0.02}, {0.6458416248560779, 0.}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{1., 0.4874571845315417}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["5", 
       Scaled[{0.02, 0.02}, {1., 0.4874571845315417}], {-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{-0.028558596703584918`, 
   1.1013599331763613`}, {-0.10374571845315417`, 1.0786600875162375`}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{{3.668342756885948*^9, 3.6683427946481304`*^9}, {
   3.6683428348364716`*^9, 3.6683428547470584`*^9}, 3.668342896149705*^9, {
   3.668342931249338*^9, 3.668342951894041*^9}, 3.668342989918112*^9, 
   3.6683430383956957`*^9, 3.668343484194454*^9, 3.6683733221301746`*^9, 
   3.668375320019981*^9, 3.668376459311911*^9, 3.66854075354366*^9, 
   3.6685409486388483`*^9, {3.668540980702764*^9, 3.668540987960962*^9}, 
   3.6685411667306795`*^9, 3.668851982975193*^9, 3.668856572113917*^9, 
   3.668959330902695*^9, 3.6696368170569677`*^9, 3.669641734500167*^9, 
   3.6700577775613823`*^9, 3.670062478869009*^9, 3.67924432612008*^9, 
   3.679244391323191*^9, 3.679247099819332*^9, 3.6796610015043745`*^9}],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.07280133647277633, 0.788722292632364}, {0.645841624856078, 
      0.9749143690630834}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.07280133647277627, 0.18619207643071953`}, {
      0.645841624856078, 0.9749143690630834}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.07280133647277627, 0.18619207643071953`}, {
      0.07280133647277633, 0.788722292632364}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6458416248560779, 0.}, {0.645841624856078, 
      0.9749143690630834}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6458416248560779, 0.}, {0.07280133647277633, 
      0.788722292632364}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{0.6458416248560779, 0.}, {0.07280133647277627, 
      0.18619207643071953`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{1., 0.4874571845315417}, {0.645841624856078, 
      0.9749143690630834}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{1., 0.4874571845315417}, {0.07280133647277633, 
      0.788722292632364}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{1., 0.4874571845315417}, {0.07280133647277627, 
      0.18619207643071953`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     ArrowBox[{{1., 0.4874571845315417}, {0.6458416248560779, 0.}}], 
     {GrayLevel[0]}}}, {
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.645841624856078, 0.9749143690630834}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["1", 
       Scaled[{0.02, 0.02}, {0.645841624856078, 0.9749143690630834}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.07280133647277633, 0.788722292632364}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["2", 
       Scaled[{0.02, 0.02}, {0.07280133647277633, 0.788722292632364}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.07280133647277627, 0.18619207643071953`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["3", 
       Scaled[{0.02, 0.02}, {0.07280133647277627, 0.18619207643071953`}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.6458416248560779, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["4", 
       Scaled[{0.02, 0.02}, {0.6458416248560779, 0.}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{1., 0.4874571845315417}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["5", 
       Scaled[{0.02, 0.02}, {1., 0.4874571845315417}], {-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{-0.028558596703584918`, 
   1.1013599331763613`}, {-0.10374571845315417`, 1.0786600875162375`}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{{3.668342756885948*^9, 3.6683427946481304`*^9}, {
   3.6683428348364716`*^9, 3.6683428547470584`*^9}, 3.668342896149705*^9, {
   3.668342931249338*^9, 3.668342951894041*^9}, 3.668342989918112*^9, 
   3.6683430383956957`*^9, 3.668343484194454*^9, 3.6683733221301746`*^9, 
   3.668375320019981*^9, 3.668376459311911*^9, 3.66854075354366*^9, 
   3.6685409486388483`*^9, {3.668540980702764*^9, 3.668540987960962*^9}, 
   3.6685411667306795`*^9, 3.668851982975193*^9, 3.668856572113917*^9, 
   3.668959330902695*^9, 3.6696368170569677`*^9, 3.669641734500167*^9, 
   3.6700577775613823`*^9, 3.670062478869009*^9, 3.67924432612008*^9, 
   3.679244391323191*^9, 3.679247099819332*^9, 3.679661001528897*^9}]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.668161528797081*^9, 
   3.6681615302506895`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"aristas", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "14"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "14"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "16"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "18"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "18"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "20"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"GrafoC", "[", 
    RowBox[{"aristas", ",", 
     RowBox[{"vertices", "\[Rule]", "5"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.66834199271655*^9, 3.668342021491995*^9}, {
  3.6683421245764637`*^9, 3.668342188367578*^9}, {3.668342252655208*^9, 
  3.6683422573295336`*^9}, {3.668342970387177*^9, 3.668342975511243*^9}, {
  3.668343044882268*^9, 3.6683430531079297`*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9755282581475768, 0.6545084971874737}, {0.9045084971874737, 
      0.7938926261462366}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9755282581475768, 0.6545084971874737}, {0.5, 1.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9755282581475768, 0.6545084971874737}, {0.34549150281252633`,
       0.9755282581475768}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.7938926261462366, 
      0.9045084971874737}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.2061073738537635, 
      0.9045084971874737}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.7938926261462366, 0.9045084971874737}, {0.6545084971874737, 
      0.9755282581475768}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.7938926261462366, 0.9045084971874737}, {0.09549150281252633, 
      0.7938926261462367}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6545084971874737, 0.9755282581475768}, {0.5, 1.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6545084971874737, 0.9755282581475768}, {
      0.024471741852423234`, 0.6545084971874737}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], LineBox[{{0.5, 1.}, {0., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.34549150281252633`, 0.9755282581475768}, {
      0.02447174185242318, 0.3454915028125264}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.34549150281252633`, 0.9755282581475768}, {
      0.09549150281252627, 0.2061073738537635}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.2061073738537635, 0.9045084971874737}, {0.02447174185242318, 
      0.3454915028125264}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.2061073738537635, 0.9045084971874737}, {0.5, 0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.09549150281252633, 0.7938926261462367}, {0.3454915028125262, 
      0.024471741852423234`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.09549150281252633, 0.7938926261462367}, {0.5, 0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.024471741852423234`, 0.6545084971874737}, {
      0.20610737385376338`, 0.09549150281252633}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.024471741852423234`, 0.6545084971874737}, {
      0.3454915028125262, 0.024471741852423234`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0., 0.5}, {0.09549150281252627, 0.2061073738537635}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0., 0.5}, {0.20610737385376338`, 0.09549150281252633}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.02447174185242318, 0.3454915028125264}, {0.6545084971874736, 
      0.02447174185242318}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.09549150281252627, 0.2061073738537635}, {0.7938926261462365, 
      0.09549150281252622}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.20610737385376338`, 0.09549150281252633}, {
      0.9045084971874737, 0.20610737385376332`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.3454915028125262, 0.024471741852423234`}, {
      0.9755282581475768, 0.34549150281252616`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], LineBox[{{0.5, 0.}, {1., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6545084971874736, 0.02447174185242318}, {0.7938926261462365, 
      0.09549150281252622}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6545084971874736, 0.02447174185242318}, {1., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.7938926261462365, 0.09549150281252622}, {0.9045084971874737, 
      0.20610737385376332`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.20610737385376332`}, {0.9755282581475768,
       0.34549150281252616`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9755282581475768, 0.34549150281252616`}, {1., 0.5}}], 
     {GrayLevel[0]}}}, {
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.9755282581475768, 0.6545084971874737}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["1", 
       Scaled[{0.02, 0.02}, {0.9755282581475768, 0.6545084971874737}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.9045084971874737, 0.7938926261462366}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["2", 
       Scaled[{0.02, 0.02}, {0.9045084971874737, 0.7938926261462366}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.7938926261462366, 0.9045084971874737}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["3", 
       Scaled[{0.02, 0.02}, {0.7938926261462366, 0.9045084971874737}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.6545084971874737, 0.9755282581475768}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["4", 
       Scaled[{0.02, 0.02}, {0.6545084971874737, 0.9755282581475768}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.5, 1.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], InsetBox["5", Scaled[{0.02, 0.02}, {0.5, 1.}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.34549150281252633`, 0.9755282581475768}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["6", 
       Scaled[{0.02, 0.02}, {0.34549150281252633`, 0.9755282581475768}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.2061073738537635, 0.9045084971874737}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["7", 
       Scaled[{0.02, 0.02}, {0.2061073738537635, 0.9045084971874737}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.09549150281252633, 0.7938926261462367}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["8", 
       Scaled[{0.02, 0.02}, {0.09549150281252633, 0.7938926261462367}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.024471741852423234`, 0.6545084971874737}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["9", 
       Scaled[{0.02, 0.02}, {0.024471741852423234`, 0.6545084971874737}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0., 0.5}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["10", Scaled[{0.02, 0.02}, {0., 0.5}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.02447174185242318, 0.3454915028125264}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["11", 
       Scaled[{0.02, 0.02}, {0.02447174185242318, 0.3454915028125264}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.09549150281252627, 0.2061073738537635}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["12", 
       Scaled[{0.02, 0.02}, {0.09549150281252627, 0.2061073738537635}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.20610737385376338`, 0.09549150281252633}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["13", 
       Scaled[{0.02, 0.02}, {0.20610737385376338`, 0.09549150281252633}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.3454915028125262, 0.024471741852423234`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["14", 
       Scaled[{0.02, 0.02}, {0.3454915028125262, 0.024471741852423234`}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.5, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["15", Scaled[{0.02, 0.02}, {0.5, 0.}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.6545084971874736, 0.02447174185242318}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["16", 
       Scaled[{0.02, 0.02}, {0.6545084971874736, 0.02447174185242318}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.7938926261462365, 0.09549150281252622}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["17", 
       Scaled[{0.02, 0.02}, {0.7938926261462365, 0.09549150281252622}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.9045084971874737, 0.20610737385376332`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["18", 
       Scaled[{0.02, 0.02}, {0.9045084971874737, 0.20610737385376332`}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.9755282581475768, 0.34549150281252616`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["19", 
       Scaled[{0.02, 0.02}, {0.9755282581475768, 0.34549150281252616`}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{1., 0.5}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["20", Scaled[{0.02, 0.02}, {1., 0.5}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.2852909849063996, 0.9884586247910869}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["21", 
       Scaled[{0.02, 0.02}, {0.2852909849063996, 0.9884586247910869}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.23612766471399405`, 0.5298883074093634}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["22", 
       Scaled[{0.02, 0.02}, {0.23612766471399405`, 0.5298883074093634}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.20211609232765393`, 0.9721278358510868}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["23", 
       Scaled[{0.02, 0.02}, {0.20211609232765393`, 0.9721278358510868}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.29534423130489973`, 0.4917814396157183}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["24", 
       Scaled[{0.02, 0.02}, {0.29534423130489973`, 0.4917814396157183}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.30988232792190384`, 0.45308919117213486`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["25", 
       Scaled[{0.02, 0.02}, {0.30988232792190384`, 0.45308919117213486`}], \
{-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{-0.10500000000000001`, 1.105}, {-0.10500000000000001`, 1.105}},
  
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.6792443961655073`*^9, 3.6792471107297926`*^9, 
  3.679661023127578*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
GraphToCombinatorica: convierte un grafo \[OpenCurlyDoubleQuote]G\
\[CloseCurlyDoubleQuote] construido en el ambiente provisto por \
\[OpenCurlyDoubleQuote]Wolfram System\[CloseCurlyDoubleQuote] de Mathematica, \
a otro equivalente a trav\[EAcute]s del uso del paquete \
\[OpenCurlyDoubleQuote]Combinatorica\[CloseCurlyDoubleQuote]. La instrucci\
\[OAcute]n presenta la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]mostrarpesos->True\[CloseCurlyDoubleQuote] que muestra \
un grafo ponderado con los pesos sobre cada uno de sus lados. Sintaxis: \
GraphToCombinatorica[G], o bien, GraphToCombinatorica[G, mostrarpesos->True]. \
Por la forma en c\[OAcute]mo funciona el paquete \
\[OpenCurlyDoubleQuote]Combinatorica\[CloseCurlyDoubleQuote], los \
v\[EAcute]rtices del grafo \[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote] \
deben ser n\[UAcute]meros naturales consecutivos, iniciando en uno. En caso \
contrario, el comando no corre. Por defecto, el nuevo grafo se almacena en \
una variable denominada \[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote].\
\>", "ItemNumbered",
 CellChangeTimes->{
  3.668425973503515*^9, {3.668427500322438*^9, 3.6684275355312366`*^9}, {
   3.6684276244032907`*^9, 3.6684276262341905`*^9}, {3.6692225442092676`*^9, 
   3.669222565772647*^9}, {3.669298654386029*^9, 3.6692986550830774`*^9}}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6681615258125625`*^9, 
   3.6681615270506372`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Quiet", "[", 
  RowBox[{"<<", "Combinatorica`"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aristas", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", "aristas", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"GraphToCombinatorica", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"UnweightedQ", "[", "G", "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "El", " ", "grafo", " ", "se", " ", "almacen\[OAcute]", " ", 
    "autom\[AAcute]ticamente", " ", "en", " ", "la", " ", "variable", " ", 
    "G"}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.668248979334944*^9, 3.66824900777978*^9}, {
   3.668249347741356*^9, 3.6682493997342343`*^9}, {3.66824959664108*^9, 
   3.6682495986269813`*^9}, 3.6682496506324263`*^9, {3.6682504005693626`*^9, 
   3.6682504228271637`*^9}, {3.668252606596198*^9, 3.668252755573332*^9}, {
   3.6682543592642336`*^9, 3.668254359589859*^9}, {3.668426328475658*^9, 
   3.668426358844962*^9}, {3.668426932082274*^9, 3.66842697709332*^9}, {
   3.668427101651017*^9, 3.668427165371847*^9}, {3.6684273199036875`*^9, 
   3.6684273503939385`*^9}, {3.6684274521815734`*^9, 3.668427452561695*^9}, {
   3.6684279847144012`*^9, 3.6684280068842697`*^9}, {3.668430253743915*^9, 
   3.6684302820715847`*^9}, {3.6688552905697412`*^9, 
   3.6688553190699806`*^9}, {3.6692957047776146`*^9, 
   3.6692957402868943`*^9}, {3.679244515081492*^9, 3.6792445477835984`*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5}, {
      Null, {{1, 1}, {1, 2}, {1, 2}, {3, 4}, {4, 5}, {1, 1}}}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          1.2812599941645846`, -0.7812599941645845}, {
          1.1361513535310714`, -0.5208123067237724}, {
          1.1920449821842611`, -0.37353051707863427`}, {
          1.2783460324685436`, -0.31157919051991534`}, {
          1.5596888883648525`, -0.40299302579504226`}, {
          1.5930938285660738`, -0.5038391864195703}, {
          1.5517426601391324`, -0.6558461078239002}, {
          1.2812599941645846`, -0.7812599941645845}},
          SplineDegree->7], 0.022611464210583382`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          1.2812599941645846`, -0.7812599941645845}, {
          1.5517426601391326`, -0.9066738805052688}, {
          1.593093828566074, -1.0586808019095986`}, {
          1.5596888883648528`, -1.1595269625341267`}, {
          1.2783460324685438`, -1.2509407978092537`}, {
          1.1920449821842616`, -1.1889894712505347`}, {
          1.1361513535310717`, -1.0417076816053965`}, {
          1.2812599941645846`, -0.7812599941645845}},
          SplineDegree->7], 0.022611464210583382`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          1.2812599941645846`, -0.7812599941645845}, {
          0.781259994164585, -0.9457007413473143}, {
          0.2812599941645846, -0.7812599941645845}}], 0.022611464210583382`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{
          1.2812599941645846`, -0.7812599941645845}, {
          0.781259994164585, -0.6168192469815897}, {
          0.2812599941645846, -0.7812599941645845}}], 0.022611464210583382`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.28125999416458436`, -1.8437799824937535`}, {
          1.2815655070419352`, -1.8437799824937535`}}, 
          0.022611464210583382`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.2815655070419352`, -1.8437799824937535`}, {
          2.281259900797937, -1.8437799824937535`}}, 0.022611464210583382`]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.2812599941645846`, -0.7812599941645845}, 
          0.022611464210583382`], 
         InsetBox["1", 
          Offset[{2, 2}, {1.303871458375168, -0.7586485299540011}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.2812599941645846, -0.7812599941645845}, 
          0.022611464210583382`], 
         InsetBox["2", 
          Offset[{2, 2}, {0.30387145837516794`, -0.7586485299540011}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.28125999416458436`, -1.8437799824937535`}, 
          0.022611464210583382`], 
         InsetBox["3", 
          Offset[{2, 2}, {0.3038714583751677, -1.82116851828317}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.2815655070419352`, -1.8437799824937535`}, 
          0.022611464210583382`], 
         InsetBox["4", 
          Offset[{2, 2}, {1.3041769712525186`, -1.82116851828317}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.281259900797937, -1.8437799824937535`}, 
          0.022611464210583382`], 
         InsetBox["5", 
          Offset[{2, 2}, {2.3038713650085203`, -1.82116851828317}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.679244526720642*^9, 3.679244548507942*^9}, 
   3.679247118876787*^9, 3.679661275264083*^9}],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.670841624856078, 0.9999143690630834}, 
      0.03535533905932741], 
     {RGBColor[1, 0, 0], 
      InsetBox["1", 
       Scaled[{-0.02, -0.02}, {0.645841624856078, 0.9749143690630834}], \
{1, 0}]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.645841624856078, 0.9749143690630834}, {0.35311507811673626`, 
      0.9009196737938344}, {0.07280133647277633, 0.788722292632364}}], 
     {RGBColor[1, 0, 0], 
      InsetBox["1", 
       Scaled[{-0.02, -0.02}, {0.35932148066442715`, 0.8818183308477237}], \
{1, 0}]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.645841624856078, 0.9749143690630834}, {0.36552788321211804`, 
      0.8627169879016129}, {0.07280133647277633, 0.788722292632364}}], 
     {RGBColor[1, 0, 0], 
      InsetBox["1", 
       Scaled[{-0.02, -0.02}, {0.35932148066442715`, 0.8818183308477237}], \
{1, 0}]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.07280133647277627, 0.18619207643071953`}, {
      0.6458416248560779, 0.}}], 
     {RGBColor[1, 0, 0], 
      InsetBox["1", 
       Scaled[{-0.02, -0.02}, {0.3593214806644271, 0.09309603821535976}], \
{1, 0}]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6458416248560779, 0.}, {1., 0.4874571845315417}}], 
     {RGBColor[1, 0, 0], 
      InsetBox["1", 
       Scaled[{-0.02, -0.02}, {0.8229208124280389, 0.24372859226577084`}], \
{1, 0}]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.660841624856078, 0.9899143690630834}, 
      0.021213203435596444`], 
     {RGBColor[1, 0, 0], 
      InsetBox["1", 
       Scaled[{-0.02, -0.02}, {0.645841624856078, 0.9749143690630834}], \
{1, 0}]}}}, {
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.645841624856078, 0.9749143690630834}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["1", 
       Scaled[{0.02, 0.02}, {0.645841624856078, 0.9749143690630834}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.07280133647277633, 0.788722292632364}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["2", 
       Scaled[{0.02, 0.02}, {0.07280133647277633, 0.788722292632364}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.07280133647277627, 0.18619207643071953`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["3", 
       Scaled[{0.02, 0.02}, {0.07280133647277627, 0.18619207643071953`}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.6458416248560779, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["4", 
       Scaled[{0.02, 0.02}, {0.6458416248560779, 0.}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{1., 0.4874571845315417}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["5", 
       Scaled[{0.02, 0.02}, {1., 0.4874571845315417}], {-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{-0.028558596703584918`, 
   1.1013599331763613`}, {-0.10374571845315417`, 1.0786600875162375`}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{{3.679244526720642*^9, 3.679244548507942*^9}, 
   3.679247118876787*^9, 3.6796612752951126`*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.679244526720642*^9, 3.679244548507942*^9}, 
   3.679247118876787*^9, 3.679661275301617*^9}]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6681615258125625`*^9, 
   3.6681615270506372`*^9}, {3.679244599913637*^9, 3.679244600656681*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"aristas", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}]}], "}"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{"aristas", ",", 
    RowBox[{"shape", "\[Rule]", "True"}], ",", 
    RowBox[{"pesos", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
      "}"}]}], ",", 
    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"GraphToCombinatorica", "[", 
  RowBox[{"grafo", ",", 
   RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6}, {
      Null, {{1, 1}, {1, 2}, {1, 2}, {3, 4}, {4, 5}, {5, 6}}}, {
      EdgeLabels -> {
        UndirectedEdge[3, 4] -> 4, UndirectedEdge[1, 1] -> 1, 
         UndirectedEdge[5, 6] -> 6, UndirectedEdge[1, 2] -> 3, 
         UndirectedEdge[4, 5] -> 5}, EdgeWeight -> {1, 2, 3, 4, 5, 6}, 
       ImagePadding -> 10, VertexShapeFunction -> {{White, 
          EdgeForm[Black], 
          Disk[#, 0.1], Black, 
          Text[#2, #]}& }}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{
           1.3435611750875718`, -0.8435611750875718}, {
           1.432040430555332, -0.6527776427022693}, {
           1.630918908092923, -0.596381400241675}, {
           1.7580895325673802`, -0.6553384790165482}, {
           1.7580895325673807`, -1.0317838711585945`}, {
           1.6309189080929234`, -1.0907409499334677`}, {
           1.4320404305553325`, -1.0343447074728738`}, {
           1.3435611750875718`, -0.8435611750875718}},
           SplineDegree->7], 0.03021670332601524]}, 
         InsetBox["1", {1.8435611750875718`, -0.8435611750875712}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{
           1.3435611750875718`, -0.8435611750875718}, {
           0.8435611750875721, -1.008001922271476}, {
           0.3435611750875718, -0.8435611750875718}}], 0.03021670332601524]}, 
         InsetBox["3", {0.8435611750875718, -0.913561175087572}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[BezierCurveBox[{{
           1.3435611750875718`, -0.8435611750875718}, {
           0.8435611750875722, -0.6791204279046227}, {
           0.3435611750875718, -0.8435611750875718}}], 0.03021670332601524]}, 
         InsetBox["3", {0.8435611750875718, -0.7735611750875717}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{3.3403799764887183`, -2.0306835252627153`}, {
           2.373346317251191, -2.030683525262718}}, 0.03021670332601524]}, 
         InsetBox["4", {2.8568631468699546`, -2.0306835252627167`}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{2.373346317251191, -2.030683525262718}, {
           1.309300718655373, -2.0306835252627176`}}, 0.03021670332601524]}, 
         InsetBox["5", {1.8413235179532819`, -2.0306835252627176`}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.309300718655373, -2.0306835252627176`}, {
           0.3435611750875718, -2.0306835252627153`}}, 0.03021670332601524]}, 
         InsetBox["6", {0.8264309468714723, -2.0306835252627167`}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         DiskBox[{1.3435611750875718`, -0.8435611750875718}, 0.1], 
         {GrayLevel[0], 
          InsetBox["1", {1.3435611750875718`, -0.8435611750875718}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         DiskBox[{0.3435611750875718, -0.8435611750875718}, 0.1], 
         {GrayLevel[0], 
          InsetBox["2", {0.3435611750875718, -0.8435611750875718}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         DiskBox[{3.3403799764887183`, -2.0306835252627153`}, 0.1], 
         {GrayLevel[0], 
          InsetBox["3", {3.3403799764887183`, -2.0306835252627153`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         DiskBox[{2.373346317251191, -2.030683525262718}, 0.1], 
         {GrayLevel[0], 
          InsetBox["4", {2.373346317251191, -2.030683525262718}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         DiskBox[{1.309300718655373, -2.0306835252627176`}, 0.1], 
         {GrayLevel[0], 
          InsetBox["5", {1.309300718655373, -2.0306835252627176`}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         DiskBox[{0.3435611750875718, -2.0306835252627153`}, 0.1], 
         {GrayLevel[0], 
          InsetBox["6", {0.3435611750875718, -2.0306835252627153`}]}}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.679244603494533*^9, 3.679247126917349*^9}],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.77, 0.9530127018922193}, 0.028284271247461926`], 
     {RGBColor[1, 0, 0], 
      InsetBox["1", 
       Scaled[{-0.02, -0.02}, {0.75, 0.9330127018922193}], {1, 0}]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.75, 0.9330127018922193}, {0.5, 0.949679368558886}, {
      0.2500000000000001, 0.9330127018922194}}], 
     {RGBColor[1, 0, 0], 
      InsetBox["2", 
       Scaled[{-0.02, -0.02}, {0.5, 0.9330127018922194}], {1, 0}]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.75, 0.9330127018922193}, {0.5, 0.9163460352255528}, {
      0.2500000000000001, 0.9330127018922194}}], 
     {RGBColor[1, 0, 0], 
      InsetBox["2", 
       Scaled[{-0.02, -0.02}, {0.5, 0.9330127018922194}], {1, 0}]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0., 0.5}, {0.24999999999999978`, 0.06698729810778076}}], 
     {RGBColor[1, 0, 0], 
      InsetBox["4", 
       Scaled[{-0.02, -0.02}, {0.12499999999999989`, 0.2834936490538904}], \
{1, 0}]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.24999999999999978`, 0.06698729810778076}, {
      0.7499999999999997, 0.06698729810778048}}], 
     {RGBColor[1, 0, 0], 
      InsetBox["5", 
       Scaled[{-0.02, -0.02}, {0.4999999999999997, 0.06698729810778062}], \
{1, 0}]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.7499999999999997, 0.06698729810778048}, {1., 0.5}}], 
     {RGBColor[1, 0, 0], 
      InsetBox["6", 
       Scaled[{-0.02, -0.02}, {0.8749999999999998, 0.28349364905389024`}], \
{1, 0}]}}}, {
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.75, 0.9330127018922193}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["1", 
       Scaled[{0.02, 0.02}, {0.75, 0.9330127018922193}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.2500000000000001, 0.9330127018922194}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["2", 
       Scaled[{0.02, 0.02}, {0.2500000000000001, 0.9330127018922194}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0., 0.5}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], InsetBox["3", Scaled[{0.02, 0.02}, {0., 0.5}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.24999999999999978`, 0.06698729810778076}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["4", 
       Scaled[{0.02, 0.02}, {0.24999999999999978`, 0.06698729810778076}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.7499999999999997, 0.06698729810778048}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["5", 
       Scaled[{0.02, 0.02}, {0.7499999999999997, 0.06698729810778048}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{1., 0.5}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["6", Scaled[{0.02, 0.02}, {1., 0.5}], {-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{-0.10500000000000001`, 1.105}, {-0.031313972081441474`, 
   1.0313139720814415`}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.679244603494533*^9, 3.6792471269518957`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
AnimarGrafo: construye una animaci\[OAcute]n sobre un grafo \
\[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote] y una lista \
\[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] de aristas, remarcando paso \
a paso las aristas sobre el grafo \[OpenCurlyDoubleQuote]G\
\[CloseCurlyDoubleQuote] en el orden de \[OpenCurlyDoubleQuote]L\
\[CloseCurlyDoubleQuote]. El comando es capaz de procesar a \
\[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote], tanto si \[EAcute]ste ha \
sido creado en el \[OpenCurlyDoubleQuote]Wolfram System\
\[CloseCurlyDoubleQuote] de Mathematica, como tambi\[EAcute]n, si ha sido \
generado con el paquete \[OpenCurlyDoubleQuote]Combinatorica\
\[CloseCurlyDoubleQuote] (sin aristas mixtas: dirigidas y no dirigidas). \
Sintaxis: AnimarGrafo[G, L], \[OpenCurlyDoubleQuote]L\[CloseCurlyDoubleQuote] \
es un conjunto de pares ordenados.\
\>", "ItemNumbered",
 CellChangeTimes->{
  3.6691191875838223`*^9, 3.6691215619423957`*^9, {3.669566174235631*^9, 
   3.6695661870084085`*^9}, {3.669566678754733*^9, 3.6695666832075253`*^9}}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.668161528797081*^9, 
   3.6681615302506895`*^9}, {3.6695662855845017`*^9, 3.669566285873742*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "GeneraRutasGraphSimple"}]], "Input",
 CellChangeTimes->{3.679244964741887*^9}],

Cell[BoxData[
 StyleBox["\<\"Retorna una cantidad m\[AAcute]xima de \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] rutas de un nodo \
\[OpenCurlyDoubleQuote]a\[CloseCurlyDoubleQuote] a un nodo \
\[OpenCurlyDoubleQuote]b\[CloseCurlyDoubleQuote] sobre un grafo \
\[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote] simple (sin aristas m\
\[UAcute]ltiples, ni lazos), en caso de lograr encontrar los caminos. El \
grafo pudo haber sido creado tanto en el \[OpenCurlyDoubleQuote]Wolfram \
System\[CloseCurlyDoubleQuote] de Mathematica, como tambi\[EAcute]n, a trav\
\[EAcute]s del uso del paquete \[OpenCurlyDoubleQuote]Combinatorica\
\[CloseCurlyDoubleQuote] (sin aristas mixtas: dirigidas y no dirigidas). \
Sintaxis: GeneraRutasGraphSimple[G, a, b, n].\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellChangeTimes->{3.6796618745717993`*^9},
 CellTags->"Info1373679640274-3503622"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo", "=", 
  RowBox[{
  "GrafoFronteraCountries", "[", "\"\<Colombia\>\"", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"L", "=", 
  RowBox[{"GeneraRutasGraphSimple", "[", 
   RowBox[{"grafo", ",", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"VertexList", "[", "grafo", "]"}], "]"}], ",", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"VertexList", "[", "grafo", "]"}], "]"}], ",", "5"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ruta", "=", 
  RowBox[{"L", "[", 
   RowBox[{"[", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"Length", "[", "L", "]"}]}], "}"}], "]"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"AnimarGrafo", "[", 
  RowBox[{"grafo", ",", "ruta"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6792447948921227`*^9, 3.6792448498390746`*^9}, {
  3.6796617946836143`*^9, 3.679661797841073*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{
       Entity["Country", "Brazil"], 
       Entity["Country", "Argentina"], 
       Entity["Country", "Bolivia"], 
       Entity["Country", "Colombia"], 
       Entity["Country", "FrenchGuiana"], 
       Entity["Country", "Guyana"], 
       Entity["Country", "Paraguay"], 
       Entity["Country", "Peru"], 
       Entity["Country", "Suriname"], 
       Entity["Country", "Uruguay"], 
       Entity["Country", "Venezuela"], 
       Entity["Country", "Ecuador"], 
       Entity["Country", "Panama"], 
       Entity["Country", "CostaRica"], 
       Entity["Country", "Chile"]}, {{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 
       6}, {1, 7}, {1, 8}, {1, 9}, {1, 10}, {1, 11}, {4, 1}, {4, 12}, {4, 
       13}, {4, 8}, {4, 11}, {12, 4}, {12, 8}, {13, 4}, {13, 14}, {8, 3}, {8, 
       1}, {8, 15}, {8, 4}, {8, 12}, {11, 1}, {11, 4}, {11, 6}}, Null}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{1.0745805827099475`, 1.7667682063559729`}, {
         0.719753231004881, 2.788851551871084}}, 0.040506668250256256`], 
        ArrowBox[{{1.0745805827099475`, 1.7667682063559729`}, {
         1.3807532906252122`, 0.9343092076248725}}, 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{1.0745805827099475`, 1.7667682063559729`}, {
         1.7562308508358861`, 1.9767510455521153`}, {2.4294529485601633`, 
         1.7411414363916402`}}], 0.040506668250256256`], 
        ArrowBox[{{1.0745805827099475`, 1.7667682063559729`}, {
         0.09776650400932008, 1.3109941993723466`}}, 0.040506668250256256`], 
        ArrowBox[{{1.0745805827099475`, 1.7667682063559729`}, {
         1.4355683421033187`, 2.6275891712197685`}}, 0.040506668250256256`], 
        ArrowBox[{{1.0745805827099475`, 1.7667682063559729`}, {0., 
         1.8907944922307451`}}, 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{1.0745805827099475`, 1.7667682063559729`}, {
         1.689036270398853, 1.5358169391021317`}, {2.046459397731879, 
         0.985232714822169}}], 0.040506668250256256`], 
        ArrowBox[{{1.0745805827099475`, 1.7667682063559729`}, {
         0.5250770519644001, 0.8686458872214974}}, 0.040506668250256256`], 
        ArrowBox[{{1.0745805827099475`, 1.7667682063559729`}, {
         0.22393275731117934`, 2.432455967062454}}, 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{1.0745805827099475`, 1.7667682063559729`}, {
         1.3830307568808853`, 2.1177710925451416`}, {1.8396097591505056`, 
         2.2171700399530003`}}], 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{2.4294529485601633`, 1.7411414363916402`}, {
         1.747802680434231, 1.5311585971950643`}, {1.0745805827099475`, 
         1.7667682063559729`}}], 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{2.4294529485601633`, 1.7411414363916402`}, {
         2.362258368123138, 1.3002073299433448`}, {2.046459397731879, 
         0.985232714822169}}], 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{2.4294529485601633`, 1.7411414363916402`}, {
         2.0562528546051646`, 1.8821614833882028`}, {1.8396097591505056`, 
         2.2171700399530003`}}], 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{2.4294529485601633`, 1.7411414363916402`}, {
         2.742327189484679, 1.4713593257200301`}, {2.833992514782209, 
         1.0685316379800582`}}], 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{2.4294529485601633`, 1.7411414363916402`}, {
         2.9771467120270985`, 2.1467675128815835`}, {3.6586884503952373`, 
         2.148120780605429}}], 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{2.046459397731879, 0.985232714822169}, {
         1.4320037100429766`, 1.2161839820743174`}, {1.0745805827099475`, 
         1.7667682063559729`}}], 0.040506668250256256`], 
        ArrowBox[{{2.046459397731879, 0.985232714822169}, {
         1.3807532906252122`, 0.9343092076248725}}, 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{2.046459397731879, 0.985232714822169}, {
         2.1136539781689043`, 1.4261668212714138`}, {2.4294529485601633`, 
         1.7411414363916402`}}], 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{2.046459397731879, 0.985232714822169}, {
         2.4265282190934134`, 1.1563847105998228`}, {2.833992514782209, 
         1.0685316379800582`}}], 0.040506668250256256`], 
        ArrowBox[{{2.046459397731879, 0.985232714822169}, {2.403255272306523, 
         0.}}, 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{1.8396097591505056`, 2.2171700399530003`}, {
         1.5311595849795754`, 1.8661671537656135`}, {1.0745805827099475`, 
         1.7667682063559729`}}], 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{1.8396097591505056`, 2.2171700399530003`}, {
         2.2128098531055045`, 2.076149992955132}, {2.4294529485601633`, 
         1.7411414363916402`}}], 0.040506668250256256`], 
        ArrowBox[{{1.8396097591505056`, 2.2171700399530003`}, {
         1.4355683421033187`, 2.6275891712197685`}}, 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{2.833992514782209, 1.0685316379800582`}, {
         2.5211182738576943`, 1.3383137486535102`}, {2.4294529485601633`, 
         1.7411414363916402`}}], 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{2.833992514782209, 1.0685316379800582`}, {
         2.4539236934206703`, 0.8973796421996874}, {2.046459397731879, 
         0.985232714822169}}], 0.040506668250256256`], 
        ArrowBox[BezierCurveBox[{{3.6586884503952373`, 2.148120780605429}, {
         3.1109946869283114`, 1.7424947041135974`}, {2.4294529485601633`, 
         1.7411414363916402`}}], 0.040506668250256256`], 
        ArrowBox[{{3.6586884503952373`, 2.148120780605429}, {4.56595252915647,
          2.432660390082351}}, 0.040506668250256256`]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.0745805827099475`, 1.7667682063559729`}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Brazil\"\>",
           Entity["Country", "Brazil"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {1.1150872509602037`, 1.807274874606229}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.719753231004881, 2.788851551871084}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Argentina\"\>",
           Entity["Country", "Argentina"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.7602598992551373, 2.8293582201213403`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.3807532906252122`, 0.9343092076248725}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Bolivia\"\>",
           Entity["Country", "Bolivia"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {1.4212599588754684`, 0.9748158758751287}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.4294529485601633`, 1.7411414363916402`}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Colombia\"\>",
           Entity["Country", "Colombia"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {2.4699596168104194`, 1.7816481046418964`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.09776650400932008, 1.3109941993723466`}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"French Guiana\"\>",
           Entity["Country", "FrenchGuiana"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.13827317225957633`, 1.3515008676226028`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.4355683421033187`, 2.6275891712197685`}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Guyana\"\>",
           Entity["Country", "Guyana"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {1.476075010353575, 2.6680958394700247`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.8907944922307451`}, 0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Paraguay\"\>",
           Entity["Country", "Paraguay"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.040506668250256256`, 1.9313011604810013`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.046459397731879, 0.985232714822169}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Peru\"\>",
           Entity["Country", "Peru"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {2.086966065982135, 1.0257393830724253`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.5250770519644001, 0.8686458872214974}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Suriname\"\>",
           Entity["Country", "Suriname"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.5655837202146564, 0.9091525554717537}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.22393275731117934`, 2.432455967062454}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Uruguay\"\>",
           Entity["Country", "Uruguay"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.2644394255614356, 2.4729626353127103`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8396097591505056`, 2.2171700399530003`}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Venezuela\"\>",
           Entity["Country", "Venezuela"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {1.8801164274007618`, 2.2576767082032565`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.833992514782209, 1.0685316379800582`}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Ecuador\"\>",
           Entity["Country", "Ecuador"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {2.8744991830324653`, 1.1090383062303144`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.6586884503952373`, 2.148120780605429}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Panama\"\>",
           Entity["Country", "Panama"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {3.6991951186454934`, 2.1886274488556854`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.56595252915647, 2.432660390082351}, 
          0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Costa Rica\"\>",
           Entity["Country", "CostaRica"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {4.606459197406727, 2.4731670583326073`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.403255272306523, 0.}, 0.040506668250256256`], InsetBox[
          InterpretationBox["\<\"Chile\"\>",
           Entity["Country", "Chile"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {2.443761940556779, 0.040506668250256256`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.6796617984808493`*^9, 3.679661800621338*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      TemplateBox[{"\"Venezuela\"",RowBox[{"Entity", "[", 
          RowBox[{"\"Country\"", ",", "\"Venezuela\""}], "]"}],
        "\"Entity[\\\"Country\\\", \\\"Venezuela\\\"]\"","\"country\""},
       "Entity"], ",", 
      TemplateBox[{"\"Brazil\"",RowBox[{"Entity", "[", 
          RowBox[{"\"Country\"", ",", "\"Brazil\""}], "]"}],
        "\"Entity[\\\"Country\\\", \\\"Brazil\\\"]\"","\"country\""},
       "Entity"]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Venezuela\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Venezuela\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Venezuela\\\"]\"","\"country\""},
        "Entity"], ",", 
       TemplateBox[{"\"Colombia\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Colombia\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Colombia\\\"]\"","\"country\""},
        "Entity"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Colombia\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Colombia\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Colombia\\\"]\"","\"country\""},
        "Entity"], ",", 
       TemplateBox[{"\"Brazil\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Brazil\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Brazil\\\"]\"","\"country\""},
        "Entity"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Venezuela\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Venezuela\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Venezuela\\\"]\"","\"country\""},
        "Entity"], ",", 
       TemplateBox[{"\"Colombia\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Colombia\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Colombia\\\"]\"","\"country\""},
        "Entity"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Colombia\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Colombia\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Colombia\\\"]\"","\"country\""},
        "Entity"], ",", 
       TemplateBox[{"\"Peru\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Peru\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Peru\\\"]\"","\"country\""},
        "Entity"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Peru\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Peru\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Peru\\\"]\"","\"country\""},
        "Entity"], ",", 
       TemplateBox[{"\"Brazil\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Brazil\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Brazil\\\"]\"","\"country\""},
        "Entity"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Venezuela\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Venezuela\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Venezuela\\\"]\"","\"country\""},
        "Entity"], ",", 
       TemplateBox[{"\"Colombia\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Colombia\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Colombia\\\"]\"","\"country\""},
        "Entity"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Colombia\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Colombia\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Colombia\\\"]\"","\"country\""},
        "Entity"], ",", 
       TemplateBox[{"\"Ecuador\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Ecuador\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Ecuador\\\"]\"","\"country\""},
        "Entity"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Ecuador\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Ecuador\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Ecuador\\\"]\"","\"country\""},
        "Entity"], ",", 
       TemplateBox[{"\"Peru\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Peru\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Peru\\\"]\"","\"country\""},
        "Entity"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Peru\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Peru\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Peru\\\"]\"","\"country\""},
        "Entity"], ",", 
       TemplateBox[{"\"Brazil\"",RowBox[{"Entity", "[", 
           RowBox[{"\"Country\"", ",", "\"Brazil\""}], "]"}],
         "\"Entity[\\\"Country\\\", \\\"Brazil\\\"]\"","\"country\""},
        "Entity"]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6796617984808493`*^9, 3.679661800631345*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TemplateBox[{"\"Venezuela\"",RowBox[{"Entity", "[", 
         RowBox[{"\"Country\"", ",", "\"Venezuela\""}], "]"}],
       "\"Entity[\\\"Country\\\", \\\"Venezuela\\\"]\"","\"country\""},
      "Entity"], ",", 
     TemplateBox[{"\"Colombia\"",RowBox[{"Entity", "[", 
         RowBox[{"\"Country\"", ",", "\"Colombia\""}], "]"}],
       "\"Entity[\\\"Country\\\", \\\"Colombia\\\"]\"","\"country\""},
      "Entity"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TemplateBox[{"\"Colombia\"",RowBox[{"Entity", "[", 
         RowBox[{"\"Country\"", ",", "\"Colombia\""}], "]"}],
       "\"Entity[\\\"Country\\\", \\\"Colombia\\\"]\"","\"country\""},
      "Entity"], ",", 
     TemplateBox[{"\"Peru\"",RowBox[{"Entity", "[", 
         RowBox[{"\"Country\"", ",", "\"Peru\""}], "]"}],
       "\"Entity[\\\"Country\\\", \\\"Peru\\\"]\"","\"country\""},
      "Entity"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TemplateBox[{"\"Peru\"",RowBox[{"Entity", "[", 
         RowBox[{"\"Country\"", ",", "\"Peru\""}], "]"}],
       "\"Entity[\\\"Country\\\", \\\"Peru\\\"]\"","\"country\""},
      "Entity"], ",", 
     TemplateBox[{"\"Brazil\"",RowBox[{"Entity", "[", 
         RowBox[{"\"Country\"", ",", "\"Brazil\""}], "]"}],
       "\"Entity[\\\"Country\\\", \\\"Brazil\\\"]\"","\"country\""},
      "Entity"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6796617984808493`*^9, 3.679661800655884*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 3, 1}}, 
    Typeset`size$$ = {1254.5, {54., 27.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    VilCretas`Private`Gi13$23781$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {
        Hold[VilCretas`Private`Gi13$$, VilCretas`Private`Gi13$23781$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 10, 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 3, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{1345., {120., 135.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.6796618006883864`*^9}]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.668161528797081*^9, 
   3.6681615302506895`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Quiet", "[", 
  RowBox[{"<<", "Combinatorica`"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ShowGraph", "[", 
   RowBox[{
    RowBox[{"grafo", "=", 
     RowBox[{"SetGraphOptions", "[", 
      RowBox[{"DodecahedralGraph", ",", 
       RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
       RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ",", 
    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "0.1"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"GeneraRutasGraphSimple", "[", 
    RowBox[{"grafo", ",", "1", ",", "20", ",", "5"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ruta", "=", 
  RowBox[{"L", "[", 
   RowBox[{"[", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"Length", "[", "L", "]"}]}], "}"}], "]"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"AnimarGrafo", "[", 
  RowBox[{"grafo", ",", "ruta"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.6685100562344065`*^9, {3.668510165083562*^9, 3.6685101685051594`*^9}, 
   3.6685116101152315`*^9, {3.6685128840228405`*^9, 3.668512898917592*^9}, {
   3.6688546309783125`*^9, 3.6688546579284067`*^9}, {3.6688558657686977`*^9, 
   3.668855876407792*^9}, 3.668857307263667*^9, 3.668970552108875*^9, {
   3.6695756895232596`*^9, 3.6695757290674458`*^9}, 3.670317469556158*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "20"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.679244920460462*^9, 3.679247150403428*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i30$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = Automatic, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i30$$], 1, ""}, 1, 17, 1}}, Typeset`size$$ = 
    Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`i30$50972$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[GridBox[{
         {
          ItemBox[
           ItemBox[
            TagBox[
             StyleBox[GridBox[{
                {"\<\"\"\>", 
                 TagBox[
                  PaneBox[
                   
                   DynamicModuleBox[{Typeset`open$$ = False, 
                    Typeset`paused$$ = Automatic, Typeset`rate$$ = Automatic, 
                    Typeset`dir$$ = Forward}, 
                    StyleBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEExpressions", "Manipulator04"][
                    Dynamic[$CellContext`i30$$], 
                    Dynamic[$CellContext`i30$$], {1, 17, 1}, Medium, Small, 
                    Automatic, True, Automatic, False, True, False, {
                    "DirectionButton", "FasterSlowerButtons", 
                    "PlayPauseButton"}, False, {}, 
                    Dynamic[Typeset`open$$], 
                    Dynamic[Typeset`paused$$], 
                    Dynamic[Typeset`rate$$], 
                    Dynamic[Typeset`dir$$]],
                    ImageSizeCache->{268., {8., 16.}}],
                    DynamicUpdating->True],
                    DynamicModuleValues:>{}],
                   BaselinePosition->Baseline,
                   ImageMargins->0],
                  Manipulate`InterpretManipulator[
                   Dynamic[$CellContext`i30$$], {1, 17, 1}, {
                   AutoAction -> False, AnimationRate -> Automatic, 
                    AnimationDirection -> Forward, AnimationRate -> Automatic,
                     PausedTime -> Automatic, 
                    AppearanceElements -> {
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"}}]]}
               },
               AutoDelete->False,
               
               GridBoxAlignment->{
                "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "ListAnimateLabel",
              StripOnInput->False],
             {"ControlArea", Top}],
            Alignment->{Automatic, Inherited},
            StripOnInput->False],
           Background->None,
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            StyleBox[
             PaneBox[
              TagBox[
               PaneSelectorBox[{1->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", Scaled[{0.02, 0.02}, 
                    {0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 2->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", Scaled[{0.02, 0.02}, {0.3388625592417062, 0.6492890995260663}],\
 {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 3->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", Scaled[{0.02, 0.02}, 
                    {0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 4->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", Scaled[{0.02, 0.02}, 
                    {0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 5->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", Scaled[{0.02, 0.02}, 
                    {0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 6->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 7->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 8->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", Scaled[{0.02, 0.02}, 
                    {0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 9->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 10->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 11->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 12->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 13->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 14->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 15->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 16->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}], 17->
                GraphicsBox[{{
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {0., 
                    0.5995260663507109}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.47630331753554506`, 0.962085308056872}, {
                    0.48341232227488157`, 0.7938388625592416}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0., 0.5995260663507109}, {0.21563981042654032`, 
                    0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0., 0.5995260663507109}, {0.14218009478672988`, 
                    0.5592417061611374}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.7725118483412323, 0.05213270142180096}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.21563981042654032`, 0.05213270142180096}, {
                    0.3080568720379147, 0.18009478672985782`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {1., 
                    0.5947867298578199}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.7725118483412323, 0.05213270142180096}, {
                    0.7203791469194313, 0.18246445497630331`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{1., 0.5947867298578199}, {0.8317535545023697, 
                    0.5687203791469194}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.48341232227488157`, 0.7938388625592416}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.3388625592417062, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.14218009478672988`, 0.5592417061611374}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.3080568720379147, 0.18009478672985782`}, {
                    0.26066350710900477`, 0.4028436018957346}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7203791469194313, 0.18246445497630331`}, {
                    0.49999999999999994`, 0.25355450236966826`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.637440758293839, 0.6492890995260663}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.8317535545023697, 0.5687203791469194}, {
                    0.7274881516587678, 0.41232227488151657`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.3388625592417062, 0.6492890995260663}, {
                    0.4265402843601896, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.637440758293839, 0.6492890995260663}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.7274881516587678, 0.41232227488151657`}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.49999999999999994`, 0.25355450236966826`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.26066350710900477`, 0.4028436018957346}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.5497630331753555, 0.542654028436019}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.4265402843601896, 0.542654028436019}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {GrayLevel[0], Thickness[0.005], 
                    LineBox[{{0.5497630331753555, 0.542654028436019}, {
                    0.580568720379147, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.580568720379147, 0.43364928909952605`}, {
                    0.49999999999999994`, 0.3554502369668247}}], 
                    {GrayLevel[0]}}, 
                   {RGBColor[0, 1, 0], Thickness[0.02], 
                    LineBox[{{0.49999999999999994`, 0.3554502369668247}, {
                    0.39810426540284355`, 0.43364928909952605`}}], 
                    {GrayLevel[0]}}}, {
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.47630331753554506`, 0.962085308056872}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["1", 
                    Scaled[{0.02, 0.02}, \
{0.47630331753554506`, 0.962085308056872}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{0., 0.5995260663507109}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["2", 
                    Scaled[{0.02, 0.02}, {0., 0.5995260663507109}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.21563981042654032`, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["3", 
                    Scaled[{0.02, 0.02}, \
{0.21563981042654032`, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7725118483412323, 0.05213270142180096}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["4", 
                    Scaled[{0.02, 0.02}, \
{0.7725118483412323, 0.05213270142180096}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], PointBox[{1., 0.5947867298578199}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["5", 
                    Scaled[{0.02, 0.02}, {1., 0.5947867298578199}], \
{-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.48341232227488157`, 0.7938388625592416}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["6", 
                    Scaled[{0.02, 0.02}, \
{0.48341232227488157`, 0.7938388625592416}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.14218009478672988`, 0.5592417061611374}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["7", 
                    Scaled[{0.02, 0.02}, \
{0.14218009478672988`, 0.5592417061611374}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3080568720379147, 0.18009478672985782`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["8", 
                    Scaled[{0.02, 0.02}, \
{0.3080568720379147, 0.18009478672985782`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7203791469194313, 0.18246445497630331`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["9", 
                    Scaled[{0.02, 0.02}, \
{0.7203791469194313, 0.18246445497630331`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.8317535545023697, 0.5687203791469194}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["10", 
                    Scaled[{0.02, 0.02}, \
{0.8317535545023697, 0.5687203791469194}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.3388625592417062, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["11", 
                    Scaled[{0.02, 0.02}, \
{0.3388625592417062, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.637440758293839, 0.6492890995260663}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["12", 
                    Scaled[{0.02, 0.02}, \
{0.637440758293839, 0.6492890995260663}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.7274881516587678, 0.41232227488151657`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["13", 
                    Scaled[{0.02, 0.02}, \
{0.7274881516587678, 0.41232227488151657`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.25355450236966826`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["14", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.25355450236966826`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.26066350710900477`, 0.4028436018957346}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["15", 
                    Scaled[{0.02, 0.02}, \
{0.26066350710900477`, 0.4028436018957346}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.4265402843601896, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["16", 
                    Scaled[{0.02, 0.02}, \
{0.4265402843601896, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.5497630331753555, 0.542654028436019}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["17", 
                    Scaled[{0.02, 0.02}, \
{0.5497630331753555, 0.542654028436019}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.580568720379147, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["18", 
                    Scaled[{0.02, 0.02}, \
{0.580568720379147, 0.43364928909952605`}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.49999999999999994`, 0.3554502369668247}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["19", 
                    Scaled[{0.02, 0.02}, \
{0.49999999999999994`, 0.3554502369668247}], {-1, 0}]}}, 
                   {RGBColor[0, 0, 1], 
                    {PointSize[0.025], 
                    PointBox[{0.39810426540284355`, 0.43364928909952605`}]}, 
                    {GrayLevel[0]}, 
                    {GrayLevel[0], 
                    InsetBox["20", 
                    Scaled[{0.02, 0.02}, \
{0.39810426540284355`, 0.43364928909952605`}], {-1, 0}]}}}},
                 AlignmentPoint->Center,
                 AspectRatio->Automatic,
                 Axes->False,
                 AxesLabel->None,
                 AxesOrigin->Automatic,
                 AxesStyle->{},
                 Background->None,
                 BaseStyle->{},
                 BaselinePosition->Automatic,
                 ColorOutput->Automatic,
                 ContentSelectable->Automatic,
                 CoordinatesToolOptions:>Automatic,
                 DisplayFunction:>$DisplayFunction,
                 Epilog->{},
                 FormatType:>TraditionalForm,
                 Frame->False,
                 FrameLabel->None,
                 FrameStyle->{},
                 FrameTicks->Automatic,
                 FrameTicksStyle->{},
                 GridLines->None,
                 GridLinesStyle->{},
                 ImageMargins->0.,
                 ImagePadding->All,
                 ImageSize->Automatic,
                 ImageSizeRaw->Automatic,
                 LabelStyle->{},
                 Method->Automatic,
                 PlotLabel->None,
                 
                 PlotRange->{{-0.05, 1.05}, {0.002132701421800956, 
                  1.012085308056872}},
                 PlotRangeClipping->False,
                 PlotRangePadding->Automatic,
                 PlotRegion->Automatic,
                 PreserveImageOptions->Automatic,
                 Prolog->{},
                 RotateLabel->True,
                 Ticks->Automatic,
                 TicksStyle->{}]}, Dynamic[$CellContext`i30$$],
                Alignment->Automatic,
                ImageSize->All,
                TransitionDirection->Horizontal,
                TransitionDuration->0.5,
                TransitionEffect->Automatic],
               Identity,
               Editable->True,
               Selectable->True],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False,
             ScriptLevel->0,
             GraphicsBoxOptions->{PreserveImageOptions->True},
             Graphics3DBoxOptions->{PreserveImageOptions->True}],
            Identity,
            Editable->False,
            Selectable->False],
           Alignment->{Left, Center},
           Background->GrayLevel[1],
           Frame->1,
           FrameStyle->GrayLevel[0, 0.2],
           ItemSize->Automatic,
           StripOnInput->False]}
        },
        AutoDelete->False,
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
          "RowsIndexed" -> {}},
        GridBoxDividers->{
         "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
          "RowsIndexed" -> {}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.7], {
             Offset[0.5599999999999999]}, 
            Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.4], {
             Offset[0.8]}, 
            Offset[0.4]}, "RowsIndexed" -> {}}], If[
        And[
         CurrentValue["NotebookSelected"], 
         CurrentValue["SelectionOver"]], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i30$$, \
$CellContext`i30$50972$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 17, 1}, 17, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{493., {238.75, 247.75}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "ListAnimate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.679244920460462*^9, 3.67924715118202*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
GrafoRandom: construye si es posible, un grafo seudoaleatorio no dirigido con \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] v\[EAcute]rtices y un m\
\[IAcute]nimo de \[OpenCurlyDoubleQuote]m\[CloseCurlyDoubleQuote] aristas. \
Por defecto, el comando lo hace en el ambiente provisto por \
\[OpenCurlyDoubleQuote]Wolfram System\[CloseCurlyDoubleQuote] de Mathematica, \
sin embargo, brinda la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]combinatorica->True\[CloseCurlyDoubleQuote] creando el \
grafo por medio del paquete \[OpenCurlyDoubleQuote]Combinatorica\
\[CloseCurlyDoubleQuote] (en este caso, el grafo queda almacenado en una \
variable denominada \[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote]). Adem\
\[AAcute]s, la instrucci\[OAcute]n integra la propiedad \
\[OpenCurlyDoubleQuote]simple->Valor\[CloseCurlyDoubleQuote] donde \
\[OpenCurlyDoubleQuote]Valor\[CloseCurlyDoubleQuote] toma un contenido \
booleano, \[OpenCurlyDoubleQuote]True\[CloseCurlyDoubleQuote] genera un grafo \
simple (sin lazos y lados m\[UAcute]ltiples) y \[OpenCurlyDoubleQuote]False\
\[CloseCurlyDoubleQuote], realiza lo contrario. Sintaxis: GrafoRandom[n, m], \
o bien, GrafoRandom[n, m, combinatorica->True, simple->Valor], pudiendo \
prescindir de cualquiera de sus opciones. Inicialmente \
\[OpenCurlyDoubleQuote]simple->True\[CloseCurlyDoubleQuote].\
\>", "ItemNumbered",
 CellChangeTimes->{
  3.6687971083981295`*^9, {3.668798180002513*^9, 3.6687981807346897`*^9}, {
   3.6688023629635234`*^9, 3.6688023686427326`*^9}, {3.669977716776227*^9, 
   3.6699777213436832`*^9}, {3.669979917144618*^9, 3.669979918792534*^9}}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6681615321333113`*^9, 
   3.6681615335506926`*^9}, {3.6792451029459763`*^9, 3.679245103337761*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoRandom", "[", 
  RowBox[{"5", ",", "6"}], "]"}]], "Input",
 CellChangeTimes->{{3.668801703936448*^9, 3.668801745704442*^9}, {
  3.6688018254508934`*^9, 3.668801899630908*^9}, {3.6688019646141624`*^9, 
  3.668801985989455*^9}, {3.668803992593809*^9, 3.668803996195203*^9}, {
  3.6792459879251623`*^9, 3.6792459884756813`*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5}, {Null, 
       SparseArray[
       Automatic, {5, 5}, 0, {
        1, {{0, 1, 3, 6, 9, 12}, {{3}, {4}, {5}, {1}, {4}, {5}, {2}, {3}, {
          5}, {2}, {3}, {4}}}, Pattern}]}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[{{3.0281082503288403`, 0.3736700080628014}, {
          1.8913792439388064`, 0.37357707183912336`}}, 
          0.030440754562866712`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0., 0.37371241091493473`}, {0.8867733155320616, 
          0.7472009582530161}}, 0.030440754562866712`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0., 0.37371241091493473`}, {0.8866520670551049, 0.}}, 
          0.030440754562866712`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.8913792439388064`, 0.37357707183912336`}, {
          0.8867733155320616, 0.7472009582530161}}, 0.030440754562866712`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.8913792439388064`, 0.37357707183912336`}, {
          0.8866520670551049, 0.}}, 0.030440754562866712`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.8867733155320616, 0.7472009582530161}, {
          0.8866520670551049, 0.}}, 0.030440754562866712`]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{3.0281082503288403`, 0.3736700080628014}, 
          0.030440754562866712`], 
         InsetBox["1", 
          Offset[{2, 2}, {3.0585490048917072`, 0.4041107626256681}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.37371241091493473`}, 0.030440754562866712`], 
         InsetBox["2", 
          Offset[{2, 2}, {0.030440754562866712`, 0.40415316547780145`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8913792439388064`, 0.37357707183912336`}, 
          0.030440754562866712`], 
         InsetBox["3", 
          Offset[{2, 2}, {1.921819998501673, 0.4040178264019901}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8867733155320616, 0.7472009582530161}, 
          0.030440754562866712`], 
         InsetBox["4", 
          Offset[{2, 2}, {0.9172140700949283, 0.7776417128158828}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8866520670551049, 0.}, 0.030440754562866712`], 
         InsetBox["5", 
          Offset[{2, 2}, {0.9170928216179717, 0.030440754562866712`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.6792471697619505`*^9, {3.6796622842848873`*^9, 3.679662287650694*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoRandom", "[", 
  RowBox[{"5", ",", "6", ",", 
   RowBox[{"simple", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5}, {
      Null, {{1, 2}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {3, 4}, {1, 4}, {2, 3}, {
       2, 3}, {1, 5}, {2, 4}, {2, 4}, {3, 3}, {5, 5}, {5, 5}, {4, 4}, {4, 
       4}}}, {ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[{{1.137577823890619, 0.37334197785964884`}, {
          2.142868333540449, 0.}}, 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{1.137577823890619, 0.37334197785964884`}, {
          1.5791959589575333`, 0.7253679930702612}, {2.143554306096417, 
          0.7465469595157017}}], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{1.137577823890619, 0.37334197785964884`}, {
          1.701936171029504, 0.39452094430525386`}, {2.143554306096417, 
          0.7465469595157017}}], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{1.137577823890619, 0.37334197785964884`}, {
          0.5687404761991824, 0.18642510468107448`}, {0., 
          0.37363652618149656`}}], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{1.137577823890619, 0.37334197785964884`}, {
          0.5688373476914381, 0.5605533993600753}, {0., 
          0.37363652618149656`}}], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{2.142868333540449, 0.}, {2.52442094113383, 
          0.33247330897499006`}, {3.0288335024669775`, 0.3735690692372827}}], 
          0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.142868333540449, 0.}, {3.0288335024669775`, 
          0.3735690692372827}}, 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{2.142868333540449, 0.}, {
          2.6472808948735813`, 0.04109576026215042}, {3.0288335024669775`, 
          0.3735690692372827}}], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{2.142868333540449, 0.}, {
          2.0204485799883867`, 0.3733862815975319}, {2.143554306096417, 
          0.7465469595157017}}], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.142868333540449, 0.}, {2.143554306096417, 
          0.7465469595157017}}, 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{2.142868333540449, 0.}, {
          2.2659740596484763`, 0.3731606779181279}, {2.143554306096417, 
          0.7465469595157017}}], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{3.0288335024669775`, 0.3735690692372827}, {
          3.117285130102943, 0.564365412090314}, {3.316155438951239, 
          0.6207904530732623}, {3.4433345995250333`, 0.561851790188572}, {
          3.4433891116761948`, 0.18540640199341252`}, {3.3162270259677458`, 
          0.1264309085646413}, {3.117340383911191, 0.1827983513202947}, {
          3.0288335024669775`, 0.3735690692372827}},
          SplineDegree->7], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.0288335024669775`, 0.3735690692372827}, {
          2.143554306096417, 0.7465469595157017}}, 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{2.143554306096417, 0.7465469595157017}, {
          1.8089606293899239`, 0.7338669512700952}, {1.7184765816998802`, 
          0.8271930276709849}, {1.6980311287728724`, 0.9122618738665667}, {
          1.8411262555268786`, 1.113275208495092}, {1.928200861226018, 
          1.1218038766664675`}, {2.0460051421713925`, 1.0668559848624855`}, {
          2.143554306096417, 0.7465469595157017}},
          SplineDegree->7], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{2.143554306096417, 0.7465469595157017}, {
          2.254938167089608, 1.0623116608540994`}, {2.3750201608876744`, 
          1.112085491209417}, {2.4616415968191494`, 1.099778908596547}, {
          2.595861395347295, 0.8927339335735139}, {2.5717365074397813`, 
          0.8086344988436187}, {2.47728023749726, 0.7193309015403496}, {
          2.143554306096417, 0.7465469595157017}},
          SplineDegree->7], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0., 0.37363652618149656`}, {
          0.14504119912883304`, 0.11315127509222074`}, {
          0.08910943728579307, -0.034116037310188696`}, {
          0.0027923490941659246`, -0.09604501621888833}, \
{-0.2785268279656032, -0.00455833706824077}, {-0.3119056553685696, 
          0.0962964695785338}, {-0.2705151298055095, 0.24829267900070678`}, {
          0., 0.37363652618149656`}},
          SplineDegree->7], 0.030445937865000383`]}, 
        {Arrowheads[0.], 
         ArrowBox[BezierCurveBox[{{0., 
          0.37363652618149656`}, {-0.270450184009725, 
          0.49912044327400196`}, {-0.3117619925282581, 
          0.6511380664695494}, {-0.2783309417683359, 0.7519755743108424}, {
          0.003035574102556074, 0.8433165595818276}, {0.08932058069364701, 
          0.7813428895264672}, {0.14517607240973238`, 0.6340466325127545}, {
          0., 0.37363652618149656`}},
          SplineDegree->7], 0.030445937865000383`]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.137577823890619, 0.37334197785964884`}, 
          0.030445937865000383`], 
         InsetBox["1", 
          Offset[{2, 2}, {1.1680237617556193`, 0.4037879157246492}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.142868333540449, 0.}, 0.030445937865000383`], 
         InsetBox["2", 
          Offset[{2, 2}, {2.1733142714054496`, 0.030445937865000383`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.0288335024669775`, 0.3735690692372827}, 
          0.030445937865000383`], 
         InsetBox["3", 
          Offset[{2, 2}, {3.059279440331978, 0.4040150071022831}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.143554306096417, 0.7465469595157017}, 
          0.030445937865000383`], 
         InsetBox["4", 
          Offset[{2, 2}, {2.1740002439614177`, 0.7769928973807021}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.37363652618149656`}, 0.030445937865000383`], 
         InsetBox["5", 
          Offset[{2, 2}, {0.030445937865000383`, 0.40408246404649695`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.6792471630996256`*^9, 3.6792471751829824`*^9}, {
  3.679662274991362*^9, 3.6796622983275003`*^9}}]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.6681615387820067`*^9, 
   3.668161540113942*^9}, {3.679245133334634*^9, 3.679245134015806*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GrafoRandom", "[", 
  RowBox[{"10", ",", "20", ",", 
   RowBox[{"combinatorica", "\[Rule]", "True"}], ",", 
   RowBox[{"simple", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.668801703936448*^9, 3.668801745704442*^9}, {
   3.6688018254508934`*^9, 3.668801899630908*^9}, {3.668801991740201*^9, 
   3.6688019920403976`*^9}, 3.6688020368049707`*^9, {3.668841664185747*^9, 
   3.6688416769639883`*^9}, {3.679245979425514*^9, 3.6792459802517605`*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.7734539761207695, 
      0.8763771088135832}, {0.6545084971874737, 0.9755282581475768}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.6189454789332873, 
      0.8660765423344045}, {0.34549150281252633`, 0.9755282581475768}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.5, 
      0.8208598592920683}, {0.09549150281252633, 0.7938926261462367}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.44245782772220077`,
       0.677096596312685}, {0., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.48040715825691876`,
       0.5269672331458299}, {0.09549150281252627, 0.2061073738537635}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.5993526371902049, 
      0.4278160838118291}, {0.3454915028125262, 0.024471741852423234`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6545084971874737, 0.9755282581475768}, {0.34549150281252633`,
       0.9755282581475768}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6545084971874737, 0.9755282581475768}, {0.6228066133109684, 
      0.5}, {0.6545084971874736, 0.02447174185242318}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.34549150281252633`, 0.9755282581475768}, {0., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.34549150281252633`, 0.9755282581475768}, {
      0.09549150281252627, 0.2061073738537635}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.34549150281252633`, 0.9755282581475768}, {0.3137896189360212,
       0.5}, {0.3454915028125262, 0.024471741852423234`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.09549150281252633, 0.7938926261462367}, {0.03794933053472192,
       0.6501293631668692}, {0., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.09549150281252633, 0.7938926261462367}, {0.07589866106944387,
       0.5000000000000001}, {0.09549150281252627, 0.2061073738537635}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.09549150281252633, 0.7938926261462367}, {0.6545084971874736, 
      0.02447174185242318}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.09549150281252633, 0.7938926261462367}, {
      0.48040715825691743`, 0.47303276685416823`}, {0.9045084971874737, 
      0.20610737385376332`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0., 0.5}, {0.3454915028125262, 0.024471741852423234`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], LineBox[{{0., 0.5}, {1., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.3454915028125262, 0.024471741852423234`}, {
      0.4999999999999999, 0.03477230833158812}, {0.6545084971874736, 
      0.02447174185242318}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6545084971874736, 0.02447174185242318}, {0.8114033066554817, 
      0.2737522543532977}, {1., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.20610737385376332`}, {0.9424578277222032,
       0.3562367370206301}, {1., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.7673994550540522, 
      0.8680437754802416}, {0.6545084971874737, 0.9755282581475768}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.34549150281252633`, 0.9755282581475768}, {
      0.37719338668903135`, 0.5}, {0.3454915028125262, 
      0.024471741852423234`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.4326614068506566, 
      0.7072468795522765}, {0., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6545084971874736, 0.02447174185242318}, {0.8431051905319923, 
      0.2507194874991253}, {1., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.785563018254178, 
      0.8930437754802303}, {0.6545084971874737, 0.9755282581475768}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.6506473628097952, 
      0.3905482841868307}, {0.3454915028125262, 0.024471741852423234`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.5195928417430812, 
      0.4730327668541702}, {0.09549150281252627, 0.2061073738537635}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.46205066946527273`,
       0.6167960298335523}, {0., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.09549150281252633, 0.7938926261462367}, {0.05754217227780442,
       0.6437632629793675}, {0., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.09549150281252633, 0.7938926261462367}, {0.5195928417430826, 
      0.5269672331458318}, {0.9045084971874737, 0.20610737385376332`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.20610737385376332`}, {0.9620506694652704,
       0.3498706368331333}, {1., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.7916175393208953, 
      0.9013771088135719}, {0.6545084971874737, 0.9755282581475768}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6545084971874737, 0.9755282581475768}, {0.686210381063979, 
      0.5}, {0.6545084971874736, 0.02447174185242318}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.5, 
      0.7669253930004051}, {0.09549150281252633, 0.7938926261462367}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.6310545210667128, 
      0.9033443419594094}, {0.34549150281252633`, 0.9755282581475768}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.3454915028125262, 0.024471741852423234`}, {
      0.4999999999999999, 0.014171175373258293`}, {0.6545084971874736, 
      0.02447174185242318}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.09549150281252633, 0.7938926261462367}, {
      0.11508434455560873`, 0.5000000000000001}, {0.09549150281252627, 
      0.2061073738537635}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.34549150281252633`, 0.9755282581475768}, {0.3454915028125263,
       0.5}, {0.3454915028125262, 0.024471741852423234`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.7938926261462366}, {0.4718470903368169, 
      0.5866457465939608}, {0., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9045084971874737, 0.20610737385376332`}, {0.9522542485937368,
       0.3530536869268817}, {1., 0.5}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.37049150281252635`, 1.0005282581475767`}, 
      0.03535533905932733], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.11549150281252633`, 0.8138926261462367}, 
      0.028284271247461915`], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.3754915028125263, 1.0055282581475768`}, 
      0.042426406871192854`], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.11549150281252628`, 0.22610737385376348`}, 
      0.028284271247461894`], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.6745084971874737, 0.9955282581475768}, 
      0.028284271247461926`], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.9245084971874737, 0.2261073738537633}, 0.02828427124746191], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.6745084971874736, 0.04447174185242318}, 
      0.028284271247461915`], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.36049150281252634`, 0.9905282581475768}, 
      0.021213203435596444`], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.9245084971874737, 0.8138926261462366}, 
      0.028284271247461926`], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     CircleBox[{0.35549150281252634`, 0.9855282581475768}, 
      0.014142135623730963`], 
     {GrayLevel[0]}}}, {
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.9045084971874737, 0.7938926261462366}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["1", 
       Scaled[{0.02, 0.02}, {0.9045084971874737, 0.7938926261462366}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.6545084971874737, 0.9755282581475768}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["2", 
       Scaled[{0.02, 0.02}, {0.6545084971874737, 0.9755282581475768}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.34549150281252633`, 0.9755282581475768}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["3", 
       Scaled[{0.02, 0.02}, {0.34549150281252633`, 0.9755282581475768}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.09549150281252633, 0.7938926261462367}]}, 
     
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["4", 
       Scaled[{0.02, 0.02}, {0.09549150281252633, 0.7938926261462367}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0., 0.5}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], InsetBox["5", Scaled[{0.02, 0.02}, {0., 0.5}], {-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.09549150281252627, 0.2061073738537635}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["6", 
       Scaled[{0.02, 0.02}, {0.09549150281252627, 0.2061073738537635}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.3454915028125262, 0.024471741852423234`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["7", 
       Scaled[{0.02, 0.02}, {0.3454915028125262, 0.024471741852423234`}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], 
      PointBox[{0.6545084971874736, 0.02447174185242318}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["8", 
       Scaled[{0.02, 0.02}, {0.6545084971874736, 0.02447174185242318}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{0.9045084971874737, 0.20610737385376332`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["9", 
       Scaled[{0.02, 0.02}, {0.9045084971874737, 0.20610737385376332`}], \
{-1, 0}]}}, 
    {RGBColor[0, 0, 1], 
     {PointSize[0.025], PointBox[{1., 0.5}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0], 
      InsetBox["10", Scaled[{0.02, 0.02}, {1., 0.5}], {-1, 0}]}}}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{-0.10500000000000001`, 1.105}, {-0.07808108396233451, 
   1.0780810839623345`}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{{3.679247179826926*^9, 3.6792471815089517`*^9}, {
  3.679662303097433*^9, 3.6796623064145727`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
AlDijkstra: ejecuta paso a paso el algoritmo de Dijkstra o de la longitud del \
camino m\[AAcute]s corto con respecto a dos v\[EAcute]rtices distintos \
\[OpenCurlyDoubleQuote]a\[CloseCurlyDoubleQuote] y \[OpenCurlyDoubleQuote]b\
\[CloseCurlyDoubleQuote], sobre un grafo \[OpenCurlyDoubleQuote]G\
\[CloseCurlyDoubleQuote] conexo y simple, creado o no, a trav\[EAcute]s del \
paquete \[OpenCurlyDoubleQuote]Combinatorica\[CloseCurlyDoubleQuote]. Retorna \
adem\[AAcute]s, una ruta de recorrido m\[AAcute]s corto. Sintaxis: \
AlDijkstra[G, a, b].\
\>", "ItemNumbered",
 CellChangeTimes->{
  3.6790554092687683`*^9, {3.679055448402439*^9, 3.6790554714365673`*^9}, {
   3.679059206073597*^9, 3.6790592113306494`*^9}, {3.679083123565483*^9, 
   3.6790831281256266`*^9}, 3.679245218790515*^9}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{{3.679055519982996*^9, 3.6790555338026423`*^9}, {
  3.6792449876751523`*^9, 3.679244990714875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grafo", "=", 
   RowBox[{"System`Graph", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[UndirectedEdge]", "b"}], ",", 
       RowBox[{"a", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"a", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"a", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"b", "\[UndirectedEdge]", "c"}], ",", 
       RowBox[{"b", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"b", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"c", "\[UndirectedEdge]", "d"}], ",", 
       RowBox[{"c", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"c", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"c", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"d", "\[UndirectedEdge]", "e"}], ",", 
       RowBox[{"d", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"e", "\[UndirectedEdge]", "f"}], ",", 
       RowBox[{"e", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"e", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"f", "\[UndirectedEdge]", "g"}], ",", 
       RowBox[{"f", "\[UndirectedEdge]", "h"}], ",", 
       RowBox[{"g", "\[UndirectedEdge]", "h"}]}], "}"}], ",", 
     RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"grafo", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{
    RowBox[{"AristasWolframSystemToCombinatorica", "[", 
     RowBox[{"EdgeList", "[", "grafo", "]"}], "]"}], ",", 
    RowBox[{"pesos", "\[Rule]", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "10"}], "}"}], ",", 
       RowBox[{"Length", "[", 
        RowBox[{"EdgeList", "[", "grafo", "]"}], "]"}]}], "]"}]}], ",", 
    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], "]"}]}], "\n", 
 RowBox[{"AlDijkstra", "[", 
  RowBox[{"grafo", ",", "a", ",", "h"}], "]"}]}], "Input",
 CellChangeTimes->{{3.679055525292879*^9, 3.679055525300436*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`f, \
$CellContext`g, $CellContext`d, $CellContext`e, $CellContext`h}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 6}, {2, 7}, {3, 6}, {
       3, 7}, {3, 4}, {3, 5}, {6, 7}, {6, 8}, {7, 4}, {7, 5}, {7, 8}, {4, 
       5}, {4, 8}, {5, 8}}}, {
      EdgeLabels -> {
        UndirectedEdge[$CellContext`b, $CellContext`e] -> 8.262354314906776, 
         UndirectedEdge[$CellContext`c, $CellContext`f] -> 
         3.3694437611403956`, UndirectedEdge[$CellContext`e, $CellContext`h] -> 
         6.991692707249484, UndirectedEdge[$CellContext`c, $CellContext`d] -> 
         4.401901185836072, UndirectedEdge[$CellContext`e, $CellContext`g] -> 
         6.3466564022737515`, UndirectedEdge[$CellContext`b, $CellContext`d] -> 
         3.882067640496544, UndirectedEdge[$CellContext`g, $CellContext`h] -> 
         2.159791653777395, UndirectedEdge[$CellContext`d, $CellContext`h] -> 
         4.992399509268973, UndirectedEdge[$CellContext`c, $CellContext`g] -> 
         3.569149679325344, UndirectedEdge[$CellContext`a, $CellContext`c] -> 
         2.702825828959922, UndirectedEdge[$CellContext`f, $CellContext`g] -> 
         3.5997772947336504`, UndirectedEdge[$CellContext`a, $CellContext`f] -> 
         9.370482957474003, UndirectedEdge[$CellContext`c, $CellContext`e] -> 
         5.108561135704473, UndirectedEdge[$CellContext`b, $CellContext`c] -> 
         9.325253035366707, UndirectedEdge[$CellContext`d, $CellContext`e] -> 
         2.0366110920474974`, UndirectedEdge[$CellContext`e, $CellContext`f] -> 
         7.625512343935467, UndirectedEdge[$CellContext`f, $CellContext`h] -> 
         6.428939203438368, UndirectedEdge[$CellContext`a, $CellContext`g] -> 
         6.3296803069777905`, UndirectedEdge[$CellContext`a, $CellContext`b] -> 
         9.611931350690817}, 
       EdgeWeight -> {9.611931350690817, 2.702825828959922, 9.370482957474003,
         6.3296803069777905`, 9.325253035366707, 3.882067640496544, 
        8.262354314906776, 4.401901185836072, 5.108561135704473, 
        3.3694437611403956`, 3.569149679325344, 2.0366110920474974`, 
        4.992399509268973, 7.625512343935467, 6.3466564022737515`, 
        6.991692707249484, 3.5997772947336504`, 6.428939203438368, 
        2.159791653777395}, ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], {
         {Arrowheads[0.], 
          ArrowBox[{{0., 1.1598065358155063`}, {0.4962034745953048, 0.}}, 
           0.022436851361613025`]}, 
         InsetBox["9.611931350690817`", {0.2481017372976524, 0.5799032679077532},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0., 1.1598065358155063`}, {0.6707037912338543, 
           0.7444133535549557}}, 0.022436851361613025`]}, 
         InsetBox["2.702825828959922`", {0.33535189561692713`, 0.952109944685231},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0., 1.1598065358155063`}, {0.7322031295145217, 
           1.6481974602503038`}}, 0.022436851361613025`]}, 
         InsetBox["9.370482957474003`", {0.36610156475726086`, 1.404001998032905},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0., 1.1598065358155063`}, {1.2106399074259586`, 
           1.6680902126054726`}}, 0.022436851361613025`]}, 
         InsetBox["6.3296803069777905`", {0.6053199537129793, 1.4139483742104895`},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.4962034745953048, 0.}, {0.6707037912338543, 
           0.7444133535549557}}, 0.022436851361613025`]}, 
         InsetBox["9.325253035366707`", {0.5834536329145795, 0.3722066767774779},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.4962034745953048, 0.}, {1.5759361903925004`, 
           0.042434104354632685`}}, 0.022436851361613025`]}, 
         InsetBox["3.882067640496544`", {1.0360698324939026`, 0.021217052177316342`},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.4962034745953048, 0.}, {1.3445609010976765`, 
           0.7703029958929275}}, 0.022436851361613025`]}, 
         InsetBox["8.262354314906776`", {0.9203821878464906, 0.38515149794646375`},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.6707037912338543, 0.7444133535549557}, {
           0.7322031295145217, 1.6481974602503038`}}, 0.022436851361613025`]},
          InsetBox["3.3694437611403956`", {0.701453460374188, 1.1963054069026298`},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.6707037912338543, 0.7444133535549557}, {
           1.2106399074259586`, 1.6680902126054726`}}, 
           0.022436851361613025`]}, 
         InsetBox["3.569149679325344`", {0.9406718493299064, 1.2062517830802142`},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.6707037912338543, 0.7444133535549557}, {
           1.5759361903925004`, 0.042434104354632685`}}, 
           0.022436851361613025`]}, 
         InsetBox["4.401901185836072`", {1.1233199908131772`, 0.3934237289547942},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.6707037912338543, 0.7444133535549557}, {
           1.3445609010976765`, 0.7703029958929275}}, 0.022436851361613025`]},
          InsetBox["5.108561135704473`", {1.0076323461657655`, 0.7573581747239416},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.7322031295145217, 1.6481974602503038`}, {
           1.2106399074259586`, 1.6680902126054726`}}, 
           0.022436851361613025`]}, 
         InsetBox["3.5997772947336504`", {0.9714215184702402, 1.6581438364278882`},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.7322031295145217, 1.6481974602503038`}, {
           1.3445609010976765`, 0.7703029958929275}}, 0.022436851361613025`]},
          InsetBox["7.625512343935467`", {1.038382015306099, 1.2092502280716158`},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.7322031295145217, 1.6481974602503038`}, {
           1.9785092038575596`, 1.2377053477262487`}}, 
           0.022436851361613025`]}, 
         InsetBox["6.428939203438368`", {1.3553561666860405`, 1.4429514039882763`},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.2106399074259586`, 1.6680902126054726`}, {
           1.3445609010976765`, 0.7703029958929275}}, 0.022436851361613025`]},
          InsetBox["6.3466564022737515`", {1.2776004042618174`, 1.2191966042492002`},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.2106399074259586`, 1.6680902126054726`}, {
           1.9785092038575596`, 1.2377053477262487`}}, 
           0.022436851361613025`]}, 
         InsetBox["2.159791653777395`", {1.594574555641759, 1.4528977801658607`},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.5759361903925004`, 0.042434104354632685`}, {
           1.3445609010976765`, 0.7703029958929275}}, 0.022436851361613025`]},
          InsetBox["2.0366110920474974`", {1.4602485457450884`, 0.4063685501237801},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.5759361903925004`, 0.042434104354632685`}, {
           1.9785092038575596`, 1.2377053477262487`}}, 
           0.022436851361613025`]}, 
         InsetBox["4.992399509268973`", {1.77722269712503, 0.6400697260404407},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.3445609010976765`, 0.7703029958929275}, {
           1.9785092038575596`, 1.2377053477262487`}}, 
           0.022436851361613025`]}, 
         InsetBox["6.991692707249484`", {1.661535052477618, 1.004004171809588},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 1.1598065358155063`}, 0.022436851361613025`], 
         InsetBox["a", 
          Offset[{2, 2}, {0.022436851361613025`, 1.1822433871771194`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4962034745953048, 0.}, 0.022436851361613025`], 
         InsetBox["b", 
          Offset[{2, 2}, {0.5186403259569178, 0.022436851361613025`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.6707037912338543, 0.7444133535549557}, 
          0.022436851361613025`], 
         InsetBox["c", 
          Offset[{2, 2}, {0.6931406425954673, 0.7668502049165687}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7322031295145217, 1.6481974602503038`}, 
          0.022436851361613025`], 
         InsetBox["f", 
          Offset[{2, 2}, {0.7546399808761347, 1.670634311611917}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.2106399074259586`, 1.6680902126054726`}, 
          0.022436851361613025`], 
         InsetBox["g", 
          Offset[{2, 2}, {1.2330767587875717`, 1.6905270639670857`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.5759361903925004`, 0.042434104354632685`}, 
          0.022436851361613025`], 
         InsetBox["d", 
          Offset[{2, 2}, {1.5983730417541135`, 0.06487095571624571}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.3445609010976765`, 0.7703029958929275}, 
          0.022436851361613025`], 
         InsetBox["e", 
          Offset[{2, 2}, {1.3669977524592896`, 0.7927398472545405}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.9785092038575596`, 1.2377053477262487`}, 
          0.022436851361613025`], 
         InsetBox["h", 
          Offset[{2, 2}, {2.0009460552191727`, 1.2601421990878618`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.6790555472513485`*^9, 3.679055562995011*^9}, 
   3.67905892980626*^9, 3.6792471907890964`*^9, 3.6796623451734557`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Tabla de pesos del grafo\"\>"], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345193474*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox[
       StyleBox["a",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "9.611931350690817`", "2.702825828959922`", 
      "9.370482957474003`", "6.3296803069777905`", "0", "0", "0"},
     {
      TagBox[
       StyleBox["b",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "9.611931350690817`", "0", "9.325253035366707`", "0", "0", 
      "3.882067640496544`", "8.262354314906776`", "0"},
     {
      TagBox[
       StyleBox["c",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "2.702825828959922`", "9.325253035366707`", "0", 
      "3.3694437611403956`", "3.569149679325344`", "4.401901185836072`", 
      "5.108561135704473`", "0"},
     {
      TagBox[
       StyleBox["f",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "9.370482957474003`", "0", "3.3694437611403956`", "0", 
      "3.5997772947336504`", "0", "7.625512343935467`", 
      "6.428939203438368`"},
     {
      TagBox[
       StyleBox["g",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "6.3296803069777905`", "0", "3.569149679325344`", 
      "3.5997772947336504`", "0", "0", "6.3466564022737515`", 
      "2.159791653777395`"},
     {
      TagBox[
       StyleBox["d",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "3.882067640496544`", "4.401901185836072`", "0", "0", 
      "0", "2.0366110920474974`", "4.992399509268973`"},
     {
      TagBox[
       StyleBox["e",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "8.262354314906776`", "5.108561135704473`", 
      "7.625512343935467`", "6.3466564022737515`", "2.0366110920474974`", "0",
       "6.991692707249484`"},
     {
      TagBox[
       StyleBox["h",
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", "0", "0", "6.428939203438368`", "2.159791653777395`", 
      "4.992399509268973`", "6.991692707249484`", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]]}, {
       Style[$CellContext`a, 
        GrayLevel[0]], 
       Style[$CellContext`b, 
        GrayLevel[0]], 
       Style[$CellContext`c, 
        GrayLevel[0]], 
       Style[$CellContext`f, 
        GrayLevel[0]], 
       Style[$CellContext`g, 
        GrayLevel[0]], 
       Style[$CellContext`d, 
        GrayLevel[0]], 
       Style[$CellContext`e, 
        GrayLevel[0]], 
       Style[$CellContext`h, 
        GrayLevel[0]]}}]]]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623452019825`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Inicializaci\[OAcute]n: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "\[Infinity]"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Inicializaci\[OAcute]n: ", {{$CellContext`a, 0}, {$CellContext`b, 
     DirectedInfinity[1]}, {$CellContext`c, 
     DirectedInfinity[1]}, {$CellContext`f, 
     DirectedInfinity[1]}, {$CellContext`g, 
     DirectedInfinity[1]}, {$CellContext`d, 
     DirectedInfinity[1]}, {$CellContext`e, 
     DirectedInfinity[1]}, {$CellContext`h, 
     DirectedInfinity[1]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623452478895`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "a"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`a],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623452624016`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "f", ",", "g", ",", "d", ",", "e", ",", "h"}],
     "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`b, $CellContext`c, \
$CellContext`f, $CellContext`g, $CellContext`d, $CellContext`e, \
$CellContext`h}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345269908*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "9.611931350690817`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "2.702825828959922`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "9.370482957474003`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "6.3296803069777905`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "\[Infinity]"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`b, 
     9.611931350690817}, {$CellContext`c, 2.702825828959922}, {$CellContext`f,
      9.370482957474003}, {$CellContext`g, 
     6.3296803069777905`}, {$CellContext`d, 
     DirectedInfinity[1]}, {$CellContext`e, 
     DirectedInfinity[1]}, {$CellContext`h, 
     DirectedInfinity[1]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345275411*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "c"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`c],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345281419*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"b", ",", "f", ",", "g", ",", "d", ",", "e", ",", "h"}], "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`b, $CellContext`f, \
$CellContext`g, $CellContext`d, $CellContext`e, $CellContext`h}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623452869234`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "9.611931350690817`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "6.072269590100317`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "6.271975508285266`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "7.104727014795994`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "7.811386964664395`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "\[Infinity]"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`b, 
     9.611931350690817}, {$CellContext`f, 6.072269590100317}, {$CellContext`g,
      6.271975508285266}, {$CellContext`d, 
     7.104727014795994}, {$CellContext`e, 7.811386964664395}, {$CellContext`h, 
     DirectedInfinity[1]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623452974353`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "f"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`f],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345303443*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"b", ",", "g", ",", "d", ",", "e", ",", "h"}], "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`b, $CellContext`g, \
$CellContext`d, $CellContext`e, $CellContext`h}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345308959*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "9.611931350690817`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "6.271975508285266`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "7.104727014795994`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "7.811386964664395`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "12.501208793538686`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`b, 
     9.611931350690817}, {$CellContext`g, 6.271975508285266}, {$CellContext`d,
      7.104727014795994}, {$CellContext`e, 
     7.811386964664395}, {$CellContext`h, 12.501208793538686`}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345315483*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "g"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`g],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623453214693`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d", ",", "e", ",", "h"}], "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`b, $CellContext`d, \
$CellContext`e, $CellContext`h}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345326473*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "9.611931350690817`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "7.104727014795994`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "7.811386964664395`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "8.43176716206266`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`b, 
     9.611931350690817}, {$CellContext`d, 7.104727014795994}, {$CellContext`e,
      7.811386964664395}, {$CellContext`h, 8.43176716206266}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623453364897`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "d"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`d],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345341994*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"b", ",", "e", ",", "h"}], "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`b, $CellContext`e, \
$CellContext`h}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345347498*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "9.611931350690817`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "7.811386964664395`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "8.43176716206266`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`b, 
     9.611931350690817}, {$CellContext`e, 7.811386964664395}, {$CellContext`h,
      8.43176716206266}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623453569016`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "e"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`e],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345362311*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"b", ",", "h"}], "}"}]}],
  SequenceForm[
  "Lista actual de v\[EAcute]rtices: ", {$CellContext`b, $CellContext`h}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623453683147`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "9.611931350690817`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "8.43176716206266`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`b, 
     9.611931350690817}, {$CellContext`h, 8.43176716206266}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345373819*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   "h"}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", $CellContext`h],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623453793273`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La longitud del camino m\[AAcute]s corto es: \"\>", 
   "\[InvisibleSpace]", "8.43176716206266`"}],
  SequenceForm[
  "La longitud del camino m\[AAcute]s corto es: ", 8.43176716206266],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.679662345385334*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "b", "}"}]}],
  SequenceForm["Lista actual de v\[EAcute]rtices: ", {$CellContext`b}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623453948374`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"b", ",", "9.611931350690817`"}], "}"}], "}"}]}],
  SequenceForm[
  "Lista actual de marcas: ", {{$CellContext`b, 9.611931350690817}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623454008465`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"En resumen: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"a", "b", "c", "f", "g", "d", "e", "h"},
       {"0", "\[Infinity]", "\[Infinity]", "\[Infinity]", "\[Infinity]", 
        "\[Infinity]", "\[Infinity]", "\[Infinity]"},
       {"0", "9.611931350690817`", "2.702825828959922`", "9.370482957474003`",
         "6.3296803069777905`", "\[Infinity]", "\[Infinity]", "\[Infinity]"},
       {"0", "9.611931350690817`", "2.702825828959922`", "6.072269590100317`",
         "6.271975508285266`", "7.104727014795994`", "7.811386964664395`", 
        "\[Infinity]"},
       {"0", "9.611931350690817`", "2.702825828959922`", "6.072269590100317`",
         "6.271975508285266`", "7.104727014795994`", "7.811386964664395`", 
        "12.501208793538686`"},
       {"0", "9.611931350690817`", "2.702825828959922`", "6.072269590100317`",
         "6.271975508285266`", "7.104727014795994`", "7.811386964664395`", 
        "8.43176716206266`"},
       {"0", "9.611931350690817`", "2.702825828959922`", "6.072269590100317`",
         "6.271975508285266`", "7.104727014795994`", "7.811386964664395`", 
        "8.43176716206266`"},
       {"0", "9.611931350690817`", "2.702825828959922`", "6.072269590100317`",
         "6.271975508285266`", "7.104727014795994`", "7.811386964664395`", 
        "8.43176716206266`"},
       {"0", "9.611931350690817`", "2.702825828959922`", "6.072269590100317`",
         "6.271975508285266`", "7.104727014795994`", "7.811386964664395`", 
        "8.43176716206266`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["En resumen: ", 
   MatrixForm[{{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`f, $CellContext`g, $CellContext`d, $CellContext`e, \
$CellContext`h}, {0, 
      DirectedInfinity[1], 
      DirectedInfinity[1], 
      DirectedInfinity[1], 
      DirectedInfinity[1], 
      DirectedInfinity[1], 
      DirectedInfinity[1], 
      DirectedInfinity[1]}, {
     0, 9.611931350690817, 2.702825828959922, 9.370482957474003, 
      6.3296803069777905`, 
      DirectedInfinity[1], 
      DirectedInfinity[1], 
      DirectedInfinity[1]}, {
     0, 9.611931350690817, 2.702825828959922, 6.072269590100317, 
      6.271975508285266, 7.104727014795994, 7.811386964664395, 
      DirectedInfinity[1]}, {
     0, 9.611931350690817, 2.702825828959922, 6.072269590100317, 
      6.271975508285266, 7.104727014795994, 7.811386964664395, 
      12.501208793538686`}, {
     0, 9.611931350690817, 2.702825828959922, 6.072269590100317, 
      6.271975508285266, 7.104727014795994, 7.811386964664395, 
      8.43176716206266}, {
     0, 9.611931350690817, 2.702825828959922, 6.072269590100317, 
      6.271975508285266, 7.104727014795994, 7.811386964664395, 
      8.43176716206266}, {
     0, 9.611931350690817, 2.702825828959922, 6.072269590100317, 
      6.271975508285266, 7.104727014795994, 7.811386964664395, 
      8.43176716206266}, {
     0, 9.611931350690817, 2.702825828959922, 6.072269590100317, 
      6.271975508285266, 7.104727014795994, 7.811386964664395, 
      8.43176716206266}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623454078517`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.43176716206266`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h"}], "}"}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623454173794`*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Gi13$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Gi13$$], 1, "Aristas"}, 1, 3, 1}}, 
    Typeset`size$$ = {1254.5, {54., 27.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    VilCretas`Private`Gi13$28241$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Gi13$$ = 1}, 
      "ControllerVariables" :> {
        Hold[VilCretas`Private`Gi13$$, VilCretas`Private`Gi13$28241$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`GGrafoAuxiliar12, 
        Cases[VilCretas`Private`GList6, 
         Condition[
          Pattern[VilCretas`Private`Gicontador10$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Gi14, {
            VilCretas`Private`Gi14, VilCretas`Private`Gi13$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`GList6, VilCretas`Private`Gicontador10$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 10, 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Gi13$$, 1, "Aristas"}, 1, 3, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{1345., {120., 135.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{{3.67905554726338*^9, 3.679055563006035*^9}, 
   3.679058929821887*^9, 3.679247190804109*^9, 3.6796623454444017`*^9}]
}, Open  ]]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{{3.679055519982996*^9, 3.679055542438585*^9}, {
  3.679244993999036*^9, 3.6792449964178905`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo", "=", 
  RowBox[{
  "GrafoCountryRegions", "[", "\"\<CostaRica\>\"", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"AlDijkstra", "[", 
  RowBox[{"grafo", ",", 
   TemplateBox[{"\"Alajuela\"",RowBox[{"Entity", "[", 
       RowBox[{"\"City\"", ",", 
         RowBox[{"{", 
           
           RowBox[{"\"Alajuela\"", ",", "\"Alajuela\"", ",", 
             "\"CostaRica\""}], "}"}]}], "]"}],
     "\"Entity[\\\"City\\\", {\\\"Alajuela\\\", \\\"Alajuela\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
    "Entity"], ",", 
   TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
       RowBox[{"\"City\"", ",", 
         RowBox[{"{", 
           RowBox[{"\"Cartago\"", ",", "\"Cartago\"", ",", "\"CostaRica\""}], 
           "}"}]}], "]"}],
     "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \\\"CostaRica\
\\\"}]\"","\"city\""},
    "Entity"]}], "]"}]}], "Input"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{
       Entity["City", {"Alajuela", "Alajuela", "CostaRica"}], 
       Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
       Entity["City", {"Heredia", "Heredia", "CostaRica"}], 
       Entity["City", {"Limon", "Limon", "CostaRica"}], 
       Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
       Entity["City", {"SanJose", "SanJose", "CostaRica"}]}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 4}, {2, 5}, {
       2, 6}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}}, {
      EdgeLabels -> {UndirectedEdge[
           Entity["City", {"Alajuela", "Alajuela", "CostaRica"}], 
           Entity["City", {"Cartago", "Cartago", "CostaRica"}]] -> 
         Quantity[36.844242546461636`, "Kilometers"], UndirectedEdge[
           Entity["City", {"Heredia", "Heredia", "CostaRica"}], 
           Entity["City", {"SanJose", "SanJose", "CostaRica"}]] -> 
         Quantity[8.898544870602526, "Kilometers"], UndirectedEdge[
           Entity["City", {"Alajuela", "Alajuela", "CostaRica"}], 
           Entity["City", {"Limon", "Limon", "CostaRica"}]] -> 
         Quantity[130.5109655292899, "Kilometers"], UndirectedEdge[
           Entity["City", {"Limon", "Limon", "CostaRica"}], 
           Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}]] -> 
         Quantity[197.36275469372174`, "Kilometers"], UndirectedEdge[
           Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
           Entity["City", {"SanJose", "SanJose", "CostaRica"}]] -> 
         Quantity[83.52063439533288, "Kilometers"], UndirectedEdge[
           Entity["City", {"Heredia", "Heredia", "CostaRica"}], 
           Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}]] -> 
         Quantity[78.97372715510664, "Kilometers"], UndirectedEdge[
           Entity["City", {"Alajuela", "Alajuela", "CostaRica"}], 
           Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}]] -> 
         Quantity[67.02618195773445, "Kilometers"], UndirectedEdge[
           Entity["City", {"Alajuela", "Alajuela", "CostaRica"}], 
           Entity["City", {"SanJose", "SanJose", "CostaRica"}]] -> 
         Quantity[19.22510713940343, "Kilometers"], UndirectedEdge[
           Entity["City", {"Heredia", "Heredia", "CostaRica"}], 
           Entity["City", {"Limon", "Limon", "CostaRica"}]] -> 
         Quantity[118.41743572782104`, "Kilometers"], UndirectedEdge[
           Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
           Entity["City", {"Limon", "Limon", "CostaRica"}]] -> 
         Quantity[98.49817106404431, "Kilometers"], UndirectedEdge[
           Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
           Entity["City", {"Heredia", "Heredia", "CostaRica"}]] -> 
         Quantity[25.315539991558442`, "Kilometers"], UndirectedEdge[
           Entity["City", {"Alajuela", "Alajuela", "CostaRica"}], 
           Entity["City", {"Heredia", "Heredia", "CostaRica"}]] -> 
         Quantity[12.261170261519787`, "Kilometers"], UndirectedEdge[
           Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
           Entity["City", {"SanJose", "SanJose", "CostaRica"}]] -> 
         Quantity[17.739067006398937`, "Kilometers"], UndirectedEdge[
           Entity["City", {"Limon", "Limon", "CostaRica"}], 
           Entity["City", {"SanJose", "SanJose", "CostaRica"}]] -> 
         Quantity[114.23174353340677`, "Kilometers"], UndirectedEdge[
           Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
           Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}]] -> 
         Quantity[100.53351036320987`, "Kilometers"]}, EdgeWeight -> {
         Quantity[36.844242546461636`, "Kilometers"], 
         Quantity[12.261170261519787`, "Kilometers"], 
         Quantity[130.5109655292899, "Kilometers"], 
         Quantity[67.02618195773445, "Kilometers"], 
         Quantity[19.22510713940343, "Kilometers"], 
         Quantity[25.315539991558442`, "Kilometers"], 
         Quantity[98.49817106404431, "Kilometers"], 
         Quantity[100.53351036320987`, "Kilometers"], 
         Quantity[17.739067006398937`, "Kilometers"], 
         Quantity[118.41743572782104`, "Kilometers"], 
         Quantity[78.97372715510664, "Kilometers"], 
         Quantity[8.898544870602526, "Kilometers"], 
         Quantity[197.36275469372174`, "Kilometers"], 
         Quantity[114.23174353340677`, "Kilometers"], 
         Quantity[83.52063439533288, "Kilometers"]}, ImagePadding -> 10, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], {
         {Arrowheads[0.], 
          ArrowBox[{{-0.8660254037844389, 
           0.5000000000000008}, {-0.8660254037844384, -0.49999999999999933`}},
            0.02261146496815286]}, InsetBox[
          
          TemplateBox[{
           "36.844242546461636`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {-0.8660254037844386, 7.216449660063518*^-16}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{-0.8660254037844389, 0.5000000000000008}, {
           3.8285686989269494`*^-16, -1.}}, 0.02261146496815286]}, InsetBox[
          
          TemplateBox[{
           "12.261170261519787`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {-0.4330127018922193, -0.2499999999999996}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{-0.8660254037844389, 0.5000000000000008}, {
           0.8660254037844389, -0.5000000000000012}}, 0.02261146496815286]}, 
         InsetBox[
          
          TemplateBox[{
           "130.5109655292899`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {0., -2.220446049250313*^-16}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{-0.8660254037844389, 0.5000000000000008}, {
           0.8660254037844386, 0.4999999999999993}}, 0.02261146496815286]}, 
         InsetBox[
          
          TemplateBox[{
           "67.02618195773445`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {-1.6653345369377348`*^-16, 0.5}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{-0.8660254037844389, 0.5000000000000008}, {
           1.8369701987210297`*^-16, 1.}}, 0.02261146496815286]}, InsetBox[
          
          TemplateBox[{
           "19.22510713940343`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {-0.43301270189221935`, 0.7500000000000004}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{-0.8660254037844384, -0.49999999999999933`}, {
           3.8285686989269494`*^-16, -1.}}, 0.02261146496815286]}, InsetBox[
          
          TemplateBox[{
           "25.315539991558442`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {-0.433012701892219, -0.7499999999999997}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{-0.8660254037844384, -0.49999999999999933`}, {
           0.8660254037844389, -0.5000000000000012}}, 0.02261146496815286]}, 
         InsetBox[
          
          TemplateBox[{
           "98.49817106404431`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {2.7755575615628914`*^-16, -0.5000000000000002}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{-0.8660254037844384, -0.49999999999999933`}, {
           0.8660254037844386, 0.4999999999999993}}, 0.02261146496815286]}, 
         InsetBox[
          
          TemplateBox[{
           "100.53351036320987`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {1.1102230246251565`*^-16, -2.7755575615628914`*^-17},
           ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{-0.8660254037844384, -0.49999999999999933`}, {
           1.8369701987210297`*^-16, 1.}}, 0.02261146496815286]}, InsetBox[
          
          TemplateBox[{
           "17.739067006398937`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {-0.4330127018922191, 0.25000000000000033`}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{3.8285686989269494`*^-16, -1.}, {
           0.8660254037844389, -0.5000000000000012}}, 0.02261146496815286]}, 
         InsetBox[
          
          TemplateBox[{
           "118.41743572782104`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {0.43301270189221963`, -0.7500000000000007}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{3.8285686989269494`*^-16, -1.}, {0.8660254037844386, 
           0.4999999999999993}}, 0.02261146496815286]}, InsetBox[
          
          TemplateBox[{
           "78.97372715510664`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {0.43301270189221946`, -0.25000000000000033`}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{3.8285686989269494`*^-16, -1.}, {
           1.8369701987210297`*^-16, 1.}}, 0.02261146496815286]}, InsetBox[
          
          TemplateBox[{
           "8.898544870602526`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {2.83276944882399*^-16, 0.}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.8660254037844389, -0.5000000000000012}, {
           0.8660254037844386, 0.4999999999999993}}, 0.02261146496815286]}, 
         InsetBox[
          
          TemplateBox[{
           "197.36275469372174`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {0.8660254037844388, -9.71445146547012*^-16}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.8660254037844389, -0.5000000000000012}, {
           1.8369701987210297`*^-16, 1.}}, 0.02261146496815286]}, InsetBox[
          TemplateBox[{
           "114.23174353340677`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {0.4330127018922196, 0.2499999999999994}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{0.8660254037844386, 0.4999999999999993}, {
           1.8369701987210297`*^-16, 1.}}, 0.02261146496815286]}, InsetBox[
          
          TemplateBox[{
           "83.52063439533288`","\"km\"","kilometers","\"Kilometers\""},
           "QuantityTF"], {0.4330127018922194, 0.7499999999999997}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{-0.8660254037844389, 0.5000000000000008}, 
          0.02261146496815286], InsetBox[
          InterpretationBox["\<\"Alajuela\"\>",
           Entity["City", {"Alajuela", "Alajuela", "CostaRica"}],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {-0.843413938816286, 0.5226114649681537}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.8660254037844384, -0.49999999999999933`}, 
          0.02261146496815286], InsetBox[
          InterpretationBox["\<\"Cartago\"\>",
           Entity["City", {"Cartago", "Cartago", "CostaRica"}],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {-0.8434139388162856, -0.4773885350318465}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.8285686989269494`*^-16, -1.}, 0.02261146496815286], 
         InsetBox[
          InterpretationBox["\<\"Heredia\"\>",
           Entity["City", {"Heredia", "Heredia", "CostaRica"}],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.022611464968153243`, -0.9773885350318472}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8660254037844389, -0.5000000000000012}, 
          0.02261146496815286], InsetBox[
          InterpretationBox["\<\"Limon\"\>",
           Entity["City", {"Limon", "Limon", "CostaRica"}],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.8886368687525918, -0.47738853503184836`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8660254037844386, 0.4999999999999993}, 
          0.02261146496815286], InsetBox[
          InterpretationBox["\<\"Puntarenas\"\>",
           Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.8886368687525914, 0.5226114649681521}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8369701987210297`*^-16, 1.}, 0.02261146496815286], 
         InsetBox[
          InterpretationBox["\<\"San Jos\[EAcute]\"\>",
           Entity["City", {"SanJose", "SanJose", "CostaRica"}],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.022611464968153045`, 1.0226114649681528`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.679055941304215*^9, 3.6790568363640747`*^9, 
  3.679057631518838*^9, 3.6790588090072775`*^9, 3.6792482071959085`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Tabla de pesos del grafo\"\>"], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.679248207238947*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox[
       StyleBox[
        TemplateBox[{"\"Alajuela\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Alajuela\"", ",", "\"Alajuela\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Alajuela\\\", \\\"Alajuela\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Cartago\"", ",", "\"Cartago\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        TemplateBox[{"\"Heredia\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Heredia\"", ",", "\"Heredia\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Heredia\\\", \\\"Heredia\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}],
                 "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
                  "\"CostaRica\""}], "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \\\
\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TagBox[
       StyleBox[
        TemplateBox[{"\"San Jos\[EAcute]\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"SanJose\"", ",", "\"SanJose\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"SanJose\\\", \\\"SanJose\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm]},
     {
      TagBox[
       StyleBox[
        TemplateBox[{"\"Alajuela\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Alajuela\"", ",", "\"Alajuela\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Alajuela\\\", \\\"Alajuela\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], "0", 
      TemplateBox[{
       "36.844242546461636`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "12.261170261519787`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "130.5109655292899`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "67.02618195773445`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "19.22510713940343`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"]},
     {
      TagBox[
       StyleBox[
        TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Cartago\"", ",", "\"Cartago\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TemplateBox[{
       "36.844242546461636`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], "0", 
      TemplateBox[{
       "25.315539991558442`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "98.49817106404431`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "100.53351036320987`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "17.739067006398937`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"]},
     {
      TagBox[
       StyleBox[
        TemplateBox[{"\"Heredia\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Heredia\"", ",", "\"Heredia\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Heredia\\\", \\\"Heredia\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TemplateBox[{
       "12.261170261519787`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "25.315539991558442`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], "0", 
      TemplateBox[{
       "118.41743572782104`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "78.97372715510664`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "8.898544870602526`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"]},
     {
      TagBox[
       StyleBox[
        TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}],
                 "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TemplateBox[{
       "130.5109655292899`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "98.49817106404431`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "118.41743572782104`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], "0", 
      TemplateBox[{
       "197.36275469372174`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "114.23174353340677`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"]},
     {
      TagBox[
       StyleBox[
        TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
                  "\"CostaRica\""}], "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \\\
\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TemplateBox[{
       "67.02618195773445`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "100.53351036320987`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "78.97372715510664`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "197.36275469372174`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], "0", 
      TemplateBox[{
       "83.52063439533288`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"]},
     {
      TagBox[
       StyleBox[
        TemplateBox[{"\"San Jos\[EAcute]\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"SanJose\"", ",", "\"SanJose\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"SanJose\\\", \\\"SanJose\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"],
        StripOnInput->False,
        LineColor->GrayLevel[0],
        FrontFaceColor->GrayLevel[0],
        BackFaceColor->GrayLevel[0],
        GraphicsColor->GrayLevel[0],
        FontColor->GrayLevel[0]],
       HoldForm], 
      TemplateBox[{
       "19.22510713940343`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "17.739067006398937`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "8.898544870602526`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "114.23174353340677`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], 
      TemplateBox[{
       "83.52063439533288`","\"km\"","kilometers","\"Kilometers\""},
       "Quantity"], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> {{
       Style[
        Entity["City", {"Alajuela", "Alajuela", "CostaRica"}], 
        GrayLevel[0]], 
       Style[
        Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
        GrayLevel[0]], 
       Style[
        Entity["City", {"Heredia", "Heredia", "CostaRica"}], 
        GrayLevel[0]], 
       Style[
        Entity["City", {"Limon", "Limon", "CostaRica"}], 
        GrayLevel[0]], 
       Style[
        Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
        GrayLevel[0]], 
       Style[
        Entity["City", {"SanJose", "SanJose", "CostaRica"}], 
        GrayLevel[0]]}, {
       Style[
        Entity["City", {"Alajuela", "Alajuela", "CostaRica"}], 
        GrayLevel[0]], 
       Style[
        Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
        GrayLevel[0]], 
       Style[
        Entity["City", {"Heredia", "Heredia", "CostaRica"}], 
        GrayLevel[0]], 
       Style[
        Entity["City", {"Limon", "Limon", "CostaRica"}], 
        GrayLevel[0]], 
       Style[
        Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
        GrayLevel[0]], 
       Style[
        Entity["City", {"SanJose", "SanJose", "CostaRica"}], 
        GrayLevel[0]]}}]]]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.6792482072459507`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Inicializaci\[OAcute]n: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Alajuela\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Alajuela\"", ",", "\"Alajuela\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Alajuela\\\", \\\"Alajuela\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Cartago\"", ",", "\"Cartago\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Heredia\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Heredia\"", ",", "\"Heredia\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Heredia\\\", \\\"Heredia\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \\\"CostaRica\
\\\"}]\"","\"city\""},
        "Entity"], ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
                 "\"CostaRica\""}], "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"San Jos\[EAcute]\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"SanJose\"", ",", "\"SanJose\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"SanJose\\\", \\\"SanJose\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "\[Infinity]"}], "}"}]}], "}"}]}],
  SequenceForm["Inicializaci\[OAcute]n: ", {{
     Entity["City", {"Alajuela", "Alajuela", "CostaRica"}], 0}, {
     Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
     DirectedInfinity[1]}, {
     Entity["City", {"Heredia", "Heredia", "CostaRica"}], 
     DirectedInfinity[1]}, {
     Entity["City", {"Limon", "Limon", "CostaRica"}], 
     DirectedInfinity[1]}, {
     Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
     DirectedInfinity[1]}, {
     Entity["City", {"SanJose", "SanJose", "CostaRica"}], 
     DirectedInfinity[1]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.6792482073060317`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   TemplateBox[{"\"Alajuela\"",RowBox[{"Entity", "[", 
       RowBox[{"\"City\"", ",", 
         RowBox[{"{", 
           
           RowBox[{"\"Alajuela\"", ",", "\"Alajuela\"", ",", 
             "\"CostaRica\""}], "}"}]}], "]"}],
     "\"Entity[\\\"City\\\", {\\\"Alajuela\\\", \\\"Alajuela\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
    "Entity"]}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", 
   Entity["City", {"Alajuela", "Alajuela", "CostaRica"}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.67924820731806*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             
             RowBox[{"\"Cartago\"", ",", "\"Cartago\"", ",", 
               "\"CostaRica\""}], "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
      "Entity"], ",", 
     TemplateBox[{"\"Heredia\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             
             RowBox[{"\"Heredia\"", ",", "\"Heredia\"", ",", 
               "\"CostaRica\""}], "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Heredia\\\", \\\"Heredia\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
      "Entity"], ",", 
     TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}], 
             "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \\\"CostaRica\\\
\"}]\"","\"city\""},
      "Entity"], ",", 
     TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             
             RowBox[{"\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
               "\"CostaRica\""}], "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
      "Entity"], ",", 
     TemplateBox[{"\"San Jos\[EAcute]\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             
             RowBox[{"\"SanJose\"", ",", "\"SanJose\"", ",", 
               "\"CostaRica\""}], "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"SanJose\\\", \\\"SanJose\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
      "Entity"]}], "}"}]}],
  SequenceForm["Lista actual de v\[EAcute]rtices: ", {
    Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
    Entity["City", {"Heredia", "Heredia", "CostaRica"}], 
    Entity["City", {"Limon", "Limon", "CostaRica"}], 
    Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
    Entity["City", {"SanJose", "SanJose", "CostaRica"}]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.679248207325064*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Cartago\"", ",", "\"Cartago\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "36.844242546461636`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Heredia\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Heredia\"", ",", "\"Heredia\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Heredia\\\", \\\"Heredia\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "12.261170261519787`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \\\"CostaRica\
\\\"}]\"","\"city\""},
        "Entity"], ",", "130.5109655292899`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
                 "\"CostaRica\""}], "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "67.02618195773445`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"San Jos\[EAcute]\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"SanJose\"", ",", "\"SanJose\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"SanJose\\\", \\\"SanJose\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "19.22510713940343`"}], "}"}]}], "}"}]}],
  SequenceForm["Lista actual de marcas: ", {{
     Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
     36.844242546461636`}, {
     Entity["City", {"Heredia", "Heredia", "CostaRica"}], 
     12.261170261519787`}, {
     Entity["City", {"Limon", "Limon", "CostaRica"}], 130.5109655292899}, {
     Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
     67.02618195773445}, {
     Entity["City", {"SanJose", "SanJose", "CostaRica"}], 19.22510713940343}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.679248207335067*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   TemplateBox[{"\"Heredia\"",RowBox[{"Entity", "[", 
       RowBox[{"\"City\"", ",", 
         RowBox[{"{", 
           RowBox[{"\"Heredia\"", ",", "\"Heredia\"", ",", "\"CostaRica\""}], 
           "}"}]}], "]"}],
     "\"Entity[\\\"City\\\", {\\\"Heredia\\\", \\\"Heredia\\\", \\\"CostaRica\
\\\"}]\"","\"city\""},
    "Entity"]}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", 
   Entity["City", {"Heredia", "Heredia", "CostaRica"}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.679248207345078*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             
             RowBox[{"\"Cartago\"", ",", "\"Cartago\"", ",", 
               "\"CostaRica\""}], "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
      "Entity"], ",", 
     TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}], 
             "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \\\"CostaRica\\\
\"}]\"","\"city\""},
      "Entity"], ",", 
     TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             
             RowBox[{"\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
               "\"CostaRica\""}], "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
      "Entity"], ",", 
     TemplateBox[{"\"San Jos\[EAcute]\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             
             RowBox[{"\"SanJose\"", ",", "\"SanJose\"", ",", 
               "\"CostaRica\""}], "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"SanJose\\\", \\\"SanJose\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
      "Entity"]}], "}"}]}],
  SequenceForm["Lista actual de v\[EAcute]rtices: ", {
    Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
    Entity["City", {"Limon", "Limon", "CostaRica"}], 
    Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
    Entity["City", {"SanJose", "SanJose", "CostaRica"}]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.6792482073520665`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Cartago\"", ",", "\"Cartago\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "36.844242546461636`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \\\"CostaRica\
\\\"}]\"","\"city\""},
        "Entity"], ",", "130.5109655292899`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
                 "\"CostaRica\""}], "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "67.02618195773445`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"San Jos\[EAcute]\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"SanJose\"", ",", "\"SanJose\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"SanJose\\\", \\\"SanJose\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "19.22510713940343`"}], "}"}]}], "}"}]}],
  SequenceForm["Lista actual de marcas: ", {{
     Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
     36.844242546461636`}, {
     Entity["City", {"Limon", "Limon", "CostaRica"}], 130.5109655292899}, {
     Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
     67.02618195773445}, {
     Entity["City", {"SanJose", "SanJose", "CostaRica"}], 19.22510713940343}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.6792482073610735`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   TemplateBox[{"\"San Jos\[EAcute]\"",RowBox[{"Entity", "[", 
       RowBox[{"\"City\"", ",", 
         RowBox[{"{", 
           RowBox[{"\"SanJose\"", ",", "\"SanJose\"", ",", "\"CostaRica\""}], 
           "}"}]}], "]"}],
     "\"Entity[\\\"City\\\", {\\\"SanJose\\\", \\\"SanJose\\\", \\\"CostaRica\
\\\"}]\"","\"city\""},
    "Entity"]}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", 
   Entity["City", {"SanJose", "SanJose", "CostaRica"}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.6792482073710985`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             
             RowBox[{"\"Cartago\"", ",", "\"Cartago\"", ",", 
               "\"CostaRica\""}], "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
      "Entity"], ",", 
     TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}], 
             "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \\\"CostaRica\\\
\"}]\"","\"city\""},
      "Entity"], ",", 
     TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             
             RowBox[{"\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
               "\"CostaRica\""}], "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
      "Entity"]}], "}"}]}],
  SequenceForm["Lista actual de v\[EAcute]rtices: ", {
    Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
    Entity["City", {"Limon", "Limon", "CostaRica"}], 
    Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.6792482073790846`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Cartago\"", ",", "\"Cartago\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "36.844242546461636`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \\\"CostaRica\
\\\"}]\"","\"city\""},
        "Entity"], ",", "130.5109655292899`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
                 "\"CostaRica\""}], "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "67.02618195773445`"}], "}"}]}], "}"}]}],
  SequenceForm["Lista actual de marcas: ", {{
     Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
     36.844242546461636`}, {
     Entity["City", {"Limon", "Limon", "CostaRica"}], 130.5109655292899}, {
     Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
     67.02618195773445}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.6792482073870916`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Se seleccion\[OAcute] el nodo: \"\>", "\[InvisibleSpace]", 
   TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
       RowBox[{"\"City\"", ",", 
         RowBox[{"{", 
           RowBox[{"\"Cartago\"", ",", "\"Cartago\"", ",", "\"CostaRica\""}], 
           "}"}]}], "]"}],
     "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \\\"CostaRica\
\\\"}]\"","\"city\""},
    "Entity"]}],
  SequenceForm["Se seleccion\[OAcute] el nodo: ", 
   Entity["City", {"Cartago", "Cartago", "CostaRica"}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.6792482073961143`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La longitud del camino m\[AAcute]s corto es: \"\>", 
   "\[InvisibleSpace]", "36.844242546461636`"}],
  SequenceForm[
  "La longitud del camino m\[AAcute]s corto es: ", 36.844242546461636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.679248207402638*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de v\[EAcute]rtices: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}], 
             "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \\\"CostaRica\\\
\"}]\"","\"city\""},
      "Entity"], ",", 
     TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
         RowBox[{"\"City\"", ",", 
           RowBox[{"{", 
             
             RowBox[{"\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
               "\"CostaRica\""}], "}"}]}], "]"}],
       "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
      "Entity"]}], "}"}]}],
  SequenceForm["Lista actual de v\[EAcute]rtices: ", {
    Entity["City", {"Limon", "Limon", "CostaRica"}], 
    Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.679248207408642*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lista actual de marcas: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}], 
               "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \\\"CostaRica\
\\\"}]\"","\"city\""},
        "Entity"], ",", "130.5109655292899`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
           RowBox[{"\"City\"", ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
                 "\"CostaRica\""}], "}"}]}], "]"}],
         "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
        "Entity"], ",", "67.02618195773445`"}], "}"}]}], "}"}]}],
  SequenceForm["Lista actual de marcas: ", {{
     Entity["City", {"Limon", "Limon", "CostaRica"}], 130.5109655292899}, {
     Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
     67.02618195773445}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.6792482074161625`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"En resumen: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        TemplateBox[{"\"Alajuela\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Alajuela\"", ",", "\"Alajuela\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Alajuela\\\", \\\"Alajuela\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"], 
        TemplateBox[{"\"Cartago\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Cartago\"", ",", "\"Cartago\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Cartago\\\", \\\"Cartago\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"], 
        TemplateBox[{"\"Heredia\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Heredia\"", ",", "\"Heredia\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Heredia\\\", \\\"Heredia\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"], 
        TemplateBox[{"\"Limon\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                RowBox[{"\"Limon\"", ",", "\"Limon\"", ",", "\"CostaRica\""}],
                 "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Limon\\\", \\\"Limon\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"], 
        TemplateBox[{"\"Puntarenas\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"Puntarenas\"", ",", "\"Puntarenas\"", ",", 
                  "\"CostaRica\""}], "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"Puntarenas\\\", \\\"Puntarenas\\\", \\\
\"CostaRica\\\"}]\"","\"city\""},
         "Entity"], 
        TemplateBox[{"\"San Jos\[EAcute]\"",RowBox[{"Entity", "[", 
            RowBox[{"\"City\"", ",", 
              RowBox[{"{", 
                
                RowBox[{
                 "\"SanJose\"", ",", "\"SanJose\"", ",", "\"CostaRica\""}], 
                "}"}]}], "]"}],
          "\"Entity[\\\"City\\\", {\\\"SanJose\\\", \\\"SanJose\\\", \
\\\"CostaRica\\\"}]\"","\"city\""},
         "Entity"]},
       {"0", "\[Infinity]", "\[Infinity]", "\[Infinity]", "\[Infinity]", 
        "\[Infinity]"},
       {"0", "36.844242546461636`", "12.261170261519787`", 
        "130.5109655292899`", "67.02618195773445`", "19.22510713940343`"},
       {"0", "36.844242546461636`", "12.261170261519787`", 
        "130.5109655292899`", "67.02618195773445`", "19.22510713940343`"},
       {"0", "36.844242546461636`", "12.261170261519787`", 
        "130.5109655292899`", "67.02618195773445`", "19.22510713940343`"},
       {"0", "36.844242546461636`", "12.261170261519787`", 
        "130.5109655292899`", "67.02618195773445`", "19.22510713940343`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["En resumen: ", 
   MatrixForm[{{
      Entity["City", {"Alajuela", "Alajuela", "CostaRica"}], 
      Entity["City", {"Cartago", "Cartago", "CostaRica"}], 
      Entity["City", {"Heredia", "Heredia", "CostaRica"}], 
      Entity["City", {"Limon", "Limon", "CostaRica"}], 
      Entity["City", {"Puntarenas", "Puntarenas", "CostaRica"}], 
      Entity["City", {"SanJose", "SanJose", "CostaRica"}]}, {0, 
      DirectedInfinity[1], 
      DirectedInfinity[1], 
      DirectedInfinity[1], 
      DirectedInfinity[1], 
      DirectedInfinity[1]}, {
     0, 36.844242546461636`, 12.261170261519787`, 130.5109655292899, 
      67.02618195773445, 19.22510713940343}, {
     0, 36.844242546461636`, 12.261170261519787`, 130.5109655292899, 
      67.02618195773445, 19.22510713940343}, {
     0, 36.844242546461636`, 12.261170261519787`, 130.5109655292899, 
      67.02618195773445, 19.22510713940343}, {
     0, 36.844242546461636`, 12.261170261519787`, 130.5109655292899, 
      67.02618195773445, 19.22510713940343}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6790576315529275`*^9, 3.679058809036355*^9, 
  3.679248207424169*^9}]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Teor\[IAcute]a de \[AAcute]rboles", "Section",
 CellChangeTimes->{{3.672324005547202*^9, 3.6723240090386314`*^9}, 
   3.673401049422349*^9, {3.6790567941010904`*^9, 3.679056795468208*^9}, {
   3.679241750534959*^9, 3.6792417602173653`*^9}}],

Cell[CellGroupData[{

Cell["\<\
ArbolR: construye un \[AAcute]rbol a trav\[EAcute]s del \
\[OpenCurlyDoubleQuote]Wolfram System\[CloseCurlyDoubleQuote] dadas sus \
aristas como una matriz de pares ordenados y un v\[EAcute]rtice \
\[OpenCurlyDoubleQuote]Raiz\[CloseCurlyDoubleQuote], correspondiente al nodo \
ra\[IAcute]z del \[AAcute]rbol. El comando presenta cuatro opciones: \
\[OpenCurlyDoubleQuote]dirigido->True\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]pesos->Lista\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]mostrarpesos->True\[CloseCurlyDoubleQuote] y \
\[OpenCurlyDoubleQuote]shape->forma\[CloseCurlyDoubleQuote]. \
\[OpenCurlyDoubleQuote]dirigido\[CloseCurlyDoubleQuote] crea un \[AAcute]rbol \
con aristas dirigidas, \[OpenCurlyDoubleQuote]pesos\[CloseCurlyDoubleQuote] \
genera un \[AAcute]rbol ponderado, \[OpenCurlyDoubleQuote]mostrarpesos\
\[CloseCurlyDoubleQuote] muestra los pesos sobre cada uno de sus lados y \
\[OpenCurlyDoubleQuote]shape\[CloseCurlyDoubleQuote] brinda una forma a los v\
\[EAcute]rtices del grafo en cualquiera de las siguientes alternativas: \
\[OpenCurlyDoubleQuote]circulo\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]triangulo\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]cuadrado\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]rectangulo\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]pentagono\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]hexagono\[CloseCurlyDoubleQuote] y \
\[OpenCurlyDoubleQuote]octagono\[CloseCurlyDoubleQuote]. Sintaxis: \
ArbolR[Aristas, Raiz], o bien, ArbolR[Aristas, Raiz, dirigido->True, \
pesos->Lista, mostrarpesos->True, shape->forma]. En esta \[UAcute]ltima \
invocaci\[OAcute]n, es posible prescindir de cualquiera de las opciones.\
\>", "ItemNumbered",
 CellChangeTimes->{
  3.67905898740736*^9, {3.6790611024972363`*^9, 3.679061286248579*^9}, 
   3.6790613584908714`*^9, 3.6792453710545*^9}],

Cell["Ejemplo  1", "SubitemNumbered",
 CellChangeTimes->{
  3.679054905503214*^9, {3.6792453736285534`*^9, 3.679245378072255*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArbolR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "h"}], "}"}]}], "}"}], ",", "5"}], "]"}]], "Input",
 CellChangeTimes->{{3.679662661000945*^9, 3.6796626660563946`*^9}, {
  3.679663517851866*^9, 3.679663518186186*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, 1, 2, 3, 4, 
       5, $CellContext`d, $CellContext`e, $CellContext`f, $CellContext`g, \
$CellContext`h}, {
      Null, {{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {3, 8}, {7, 9}, {
       7, 10}, {8, 11}, {8, 12}, {8, 13}}}, {
      ImagePadding -> 10, 
       VertexCoordinates -> {{0.3872983346207417, 1.5491933384829668`}, {
        0.3872983346207417, 0.7745966692414834}, {1.161895003862225, 
        2.32379000772445}, {0., 0.}, {0.7745966692414834, 0.}, {
        1.161895003862225, 1.5491933384829668`}, {1.9364916731037085`, 
        1.5491933384829668`}, {2.32379000772445, 3.0983866769659336`}, {
        1.5491933384829668`, 0.7745966692414834}, {2.32379000772445, 
        0.7745966692414834}, {1.9364916731037085`, 2.32379000772445}, {
        2.711088342345192, 2.32379000772445}, {3.4856850115866753`, 
        2.32379000772445}}, VertexLabels -> {"Name"}, 
       VertexShapeFunction -> {"Circle"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[{{0.3872983346207417, 1.5491933384829668`}, {
          0.3872983346207417, 0.7745966692414834}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.3872983346207417, 1.5491933384829668`}, {
          1.161895003862225, 2.32379000772445}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.3872983346207417, 0.7745966692414834}, {0., 0.}}, 
          0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.3872983346207417, 0.7745966692414834}, {
          0.7745966692414834, 0.}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.161895003862225, 2.32379000772445}, {1.161895003862225, 
          1.5491933384829668`}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.161895003862225, 2.32379000772445}, {
          1.9364916731037085`, 1.5491933384829668`}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.161895003862225, 2.32379000772445}, {2.32379000772445, 
          3.0983866769659336`}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.9364916731037085`, 1.5491933384829668`}, {
          1.5491933384829668`, 0.7745966692414834}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.9364916731037085`, 1.5491933384829668`}, {
          2.32379000772445, 0.7745966692414834}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.32379000772445, 3.0983866769659336`}, {
          1.9364916731037085`, 2.32379000772445}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.32379000772445, 3.0983866769659336`}, {
          2.711088342345192, 2.32379000772445}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.32379000772445, 3.0983866769659336`}, {
          3.4856850115866753`, 2.32379000772445}}, 0.03362407441707502]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.3872983346207417, 1.5491933384829668`}, 
          0.03362407441707502], 
         InsetBox["a", 
          Offset[{2, 2}, {0.42092240903781675`, 1.5828174129000419`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.3872983346207417, 0.7745966692414834}, 
          0.03362407441707502], 
         InsetBox["b", 
          Offset[{2, 2}, {0.42092240903781675`, 0.8082207436585584}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.161895003862225, 2.32379000772445}, 0.03362407441707502], 
         InsetBox["c", 
          Offset[{2, 2}, {1.1955190782793002`, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.03362407441707502], 
         InsetBox["1", 
          Offset[{2, 2}, {0.03362407441707502, 0.03362407441707502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7745966692414834, 0.}, 0.03362407441707502], 
         InsetBox["2", 
          Offset[{2, 2}, {0.8082207436585584, 0.03362407441707502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.161895003862225, 1.5491933384829668`}, 
          0.03362407441707502], 
         InsetBox["3", 
          Offset[{2, 2}, {1.1955190782793002`, 1.5828174129000419`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.9364916731037085`, 1.5491933384829668`}, 
          0.03362407441707502], 
         InsetBox["4", 
          Offset[{2, 2}, {1.9701157475207836`, 1.5828174129000419`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.32379000772445, 3.0983866769659336`}, 
          0.03362407441707502], 
         InsetBox["5", 
          Offset[{2, 2}, {2.357414082141525, 3.1320107513830084`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.5491933384829668`, 0.7745966692414834}, 
          0.03362407441707502], 
         InsetBox["d", 
          Offset[{2, 2}, {1.5828174129000419`, 0.8082207436585584}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.32379000772445, 0.7745966692414834}, 0.03362407441707502],
          InsetBox["e", 
          Offset[{2, 2}, {2.357414082141525, 0.8082207436585584}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.9364916731037085`, 2.32379000772445}, 
          0.03362407441707502], 
         InsetBox["f", 
          Offset[{2, 2}, {1.9701157475207836`, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.711088342345192, 2.32379000772445}, 0.03362407441707502], 
         InsetBox["g", 
          Offset[{2, 2}, {2.7447124167622667`, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.4856850115866753`, 2.32379000772445}, 
          0.03362407441707502], 
         InsetBox["h", Offset[{2, 2}, {3.51930908600375, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.679061537692029*^9, 3.6792482367359476`*^9, {3.679662658155137*^9, 
   3.679662666521924*^9}, 3.679663518585971*^9}]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{
  3.679054905503214*^9, {3.6790615350738077`*^9, 3.6790615354214115`*^9}, {
   3.6792453807419815`*^9, 3.6792453829923873`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArbolR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "h"}], "}"}]}], "}"}], ",", "5", ",", 
   RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
   RowBox[{"pesos", "\[Rule]", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"10", ",", "12"}], "]"}]}], ",", 
   RowBox[{"mostrarpesos", "\[Rule]", "True"}], ",", 
   RowBox[{"shape", "\[Rule]", "\"\<hexagono\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6790615812178173`*^9, 3.6790615817183533`*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, 1, 2, 3, 4, 
       5, $CellContext`d, $CellContext`e, $CellContext`f, $CellContext`g, \
$CellContext`h}, {{{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {3, 8}, {7,
        9}, {7, 10}, {8, 11}, {8, 12}, {8, 13}}, Null}, {
      EdgeLabels -> {
        DirectedEdge[$CellContext`c, 4] -> 7, DirectedEdge[5, $CellContext`h] -> 
         7, DirectedEdge[5, $CellContext`g] -> 0, 
         DirectedEdge[$CellContext`c, 3] -> 3, 
         DirectedEdge[$CellContext`a, $CellContext`c] -> 0, 
         DirectedEdge[$CellContext`b, 2] -> 2, 
         DirectedEdge[$CellContext`b, 1] -> 5, 
         DirectedEdge[4, $CellContext`d] -> 10, 
         DirectedEdge[5, $CellContext`f] -> 9, 
         DirectedEdge[4, $CellContext`e] -> 0, 
         DirectedEdge[$CellContext`c, 5] -> 1, 
         DirectedEdge[$CellContext`a, $CellContext`b] -> 5}, 
       EdgeWeight -> {5, 0, 5, 2, 3, 7, 1, 10, 0, 9, 0, 7}, ImagePadding -> 
       10, VertexCoordinates -> {{0.3872983346207417, 1.5491933384829668`}, {
        0.3872983346207417, 0.7745966692414834}, {1.161895003862225, 
        2.32379000772445}, {0., 0.}, {0.7745966692414834, 0.}, {
        1.161895003862225, 1.5491933384829668`}, {1.9364916731037085`, 
        1.5491933384829668`}, {2.32379000772445, 3.0983866769659336`}, {
        1.5491933384829668`, 0.7745966692414834}, {2.32379000772445, 
        0.7745966692414834}, {1.9364916731037085`, 2.32379000772445}, {
        2.711088342345192, 2.32379000772445}, {3.4856850115866753`, 
        2.32379000772445}}, VertexLabels -> {"Name"}, 
       VertexShapeFunction -> {"Hexagon"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
        Medium], {
         ArrowBox[{{0.3872983346207417, 1.5491933384829668`}, {
          0.3872983346207417, 0.7745966692414834}}, 0.03362407441707502], 
         InsetBox["5", {0.3872983346207417, 1.161895003862225}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{0.3872983346207417, 1.5491933384829668`}, {
          1.161895003862225, 2.32379000772445}}, 0.03362407441707502], 
         InsetBox["0", {0.7745966692414834, 1.9364916731037085`}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{0.3872983346207417, 0.7745966692414834}, {0., 0.}}, 
          0.03362407441707502], 
         InsetBox["5", {0.19364916731037085`, 0.3872983346207417}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{0.3872983346207417, 0.7745966692414834}, {
          0.7745966692414834, 0.}}, 0.03362407441707502], 
         InsetBox["2", {0.5809475019311126, 0.3872983346207417}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.161895003862225, 2.32379000772445}, {1.161895003862225, 
          1.5491933384829668`}}, 0.03362407441707502], 
         InsetBox["3", {1.161895003862225, 1.9364916731037085`}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.161895003862225, 2.32379000772445}, {
          1.9364916731037085`, 1.5491933384829668`}}, 0.03362407441707502], 
         InsetBox["7", {1.5491933384829668`, 1.9364916731037085`}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.161895003862225, 2.32379000772445}, {2.32379000772445, 
          3.0983866769659336`}}, 0.03362407441707502], 
         InsetBox["1", {1.7428425057933377`, 2.711088342345192}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.9364916731037085`, 1.5491933384829668`}, {
          1.5491933384829668`, 0.7745966692414834}}, 0.03362407441707502], 
         InsetBox["10", {1.7428425057933377`, 1.161895003862225}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{1.9364916731037085`, 1.5491933384829668`}, {
          2.32379000772445, 0.7745966692414834}}, 0.03362407441707502], 
         InsetBox["0", {2.1301408404140796`, 1.161895003862225}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.32379000772445, 3.0983866769659336`}, {
          1.9364916731037085`, 2.32379000772445}}, 0.03362407441707502], 
         InsetBox["9", {2.1301408404140796`, 2.711088342345192}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.32379000772445, 3.0983866769659336`}, {
          2.711088342345192, 2.32379000772445}}, 0.03362407441707502], 
         InsetBox["0", {2.517439175034821, 2.711088342345192}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         ArrowBox[{{2.32379000772445, 3.0983866769659336`}, {
          3.4856850115866753`, 2.32379000772445}}, 0.03362407441707502], 
         InsetBox["7", {2.904737509655563, 2.711088342345192}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         PolygonBox[{{0.4248782813929856, 1.5491933384829668`}, {
          0.4060882743827892, 1.5817384499760723`}, {0.3685083948586942, 
          1.5817384499760723`}, {0.3497183878484978, 1.5491933384829668`}, {
          0.3685083948586942, 1.5166482269898613`}, {0.4060882743827892, 
          1.5166482269898613`}, {0.4248782813929856, 1.5491933384829668`}}], 
         InsetBox["a", 
          Offset[{2, 2}, {0.42092240903781675`, 1.5828174129000419`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{0.4248782813929856, 0.7745966692414834}, {
          0.4060882743827892, 0.8071417807345889}, {0.3685083948586942, 
          0.8071417807345889}, {0.3497183878484978, 0.7745966692414834}, {
          0.3685083948586942, 0.7420515577483779}, {0.4060882743827892, 
          0.7420515577483779}, {0.4248782813929856, 0.7745966692414834}}], 
         InsetBox["b", 
          Offset[{2, 2}, {0.42092240903781675`, 0.8082207436585584}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{1.199474950634469, 2.32379000772445}, {
          1.1806849436242726`, 2.356335119217556}, {1.1431050641001776`, 
          2.356335119217556}, {1.1243150570899811`, 2.32379000772445}, {
          1.1431050641001776`, 2.2912448962313445`}, {1.1806849436242726`, 
          2.2912448962313445`}, {1.199474950634469, 2.32379000772445}}], 
         InsetBox["c", 
          Offset[{2, 2}, {1.1955190782793002`, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{0.0375799467722439, 0.}, {0.018789939762047528`, 
          0.032545111493105496`}, {-0.018789939762047528`, 
          0.032545111493105496`}, {-0.0375799467722439, 
          0.}, {-0.018789939762047528`, -0.032545111493105496`}, {
          0.018789939762047528`, -0.032545111493105496`}, {0.0375799467722439,
           0.}}], InsetBox["1", 
          Offset[{2, 2}, {0.03362407441707502, 0.03362407441707502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{0.8121766160137273, 0.}, {0.793386609003531, 
          0.032545111493105496`}, {0.7558067294794358, 
          0.032545111493105496`}, {0.7370167224692395, 0.}, {
          0.7558067294794358, -0.032545111493105496`}, {
          0.793386609003531, -0.032545111493105496`}, {0.8121766160137273, 
          0.}}], InsetBox["2", 
          Offset[{2, 2}, {0.8082207436585584, 0.03362407441707502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{1.199474950634469, 1.5491933384829668`}, {
          1.1806849436242726`, 1.5817384499760723`}, {1.1431050641001776`, 
          1.5817384499760723`}, {1.1243150570899811`, 1.5491933384829668`}, {
          1.1431050641001776`, 1.5166482269898613`}, {1.1806849436242726`, 
          1.5166482269898613`}, {1.199474950634469, 1.5491933384829668`}}], 
         InsetBox["3", 
          Offset[{2, 2}, {1.1955190782793002`, 1.5828174129000419`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{1.9740716198759525`, 1.5491933384829668`}, {
          1.955281612865756, 1.5817384499760723`}, {1.917701733341661, 
          1.5817384499760723`}, {1.8989117263314645`, 1.5491933384829668`}, {
          1.917701733341661, 1.5166482269898613`}, {1.955281612865756, 
          1.5166482269898613`}, {1.9740716198759525`, 1.5491933384829668`}}], 
         InsetBox["4", 
          Offset[{2, 2}, {1.9701157475207836`, 1.5828174129000419`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{2.361369954496694, 3.0983866769659336`}, {
          2.342579947486498, 3.1309317884590393`}, {2.3050000679624025`, 
          3.1309317884590393`}, {2.2862100609522065`, 3.0983866769659336`}, {
          2.3050000679624025`, 3.065841565472828}, {2.342579947486498, 
          3.065841565472828}, {2.361369954496694, 3.0983866769659336`}}], 
         InsetBox["5", 
          Offset[{2, 2}, {2.357414082141525, 3.1320107513830084`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{1.5867732852552108`, 0.7745966692414834}, {
          1.5679832782450143`, 0.8071417807345889}, {1.5304033987209194`, 
          0.8071417807345889}, {1.5116133917107228`, 0.7745966692414834}, {
          1.5304033987209194`, 0.7420515577483779}, {1.5679832782450143`, 
          0.7420515577483779}, {1.5867732852552108`, 0.7745966692414834}}], 
         InsetBox["d", 
          Offset[{2, 2}, {1.5828174129000419`, 0.8082207436585584}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{2.361369954496694, 0.7745966692414834}, {
          2.342579947486498, 0.8071417807345889}, {2.3050000679624025`, 
          0.8071417807345889}, {2.2862100609522065`, 0.7745966692414834}, {
          2.3050000679624025`, 0.7420515577483779}, {2.342579947486498, 
          0.7420515577483779}, {2.361369954496694, 0.7745966692414834}}], 
         InsetBox["e", 
          Offset[{2, 2}, {2.357414082141525, 0.8082207436585584}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{1.9740716198759525`, 2.32379000772445}, {
          1.955281612865756, 2.356335119217556}, {1.917701733341661, 
          2.356335119217556}, {1.8989117263314645`, 2.32379000772445}, {
          1.917701733341661, 2.2912448962313445`}, {1.955281612865756, 
          2.2912448962313445`}, {1.9740716198759525`, 2.32379000772445}}], 
         InsetBox["f", 
          Offset[{2, 2}, {1.9701157475207836`, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{2.7486682891174357`, 2.32379000772445}, {
          2.7298782821072396`, 2.356335119217556}, {2.6922984025831442`, 
          2.356335119217556}, {2.673508395572948, 2.32379000772445}, {
          2.6922984025831442`, 2.2912448962313445`}, {2.7298782821072396`, 
          2.2912448962313445`}, {2.7486682891174357`, 2.32379000772445}}], 
         InsetBox["g", 
          Offset[{2, 2}, {2.7447124167622667`, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         PolygonBox[{{3.523264958358919, 2.32379000772445}, {
          3.504474951348723, 2.356335119217556}, {3.4668950718246276`, 
          2.356335119217556}, {3.4481050648144316`, 2.32379000772445}, {
          3.4668950718246276`, 2.2912448962313445`}, {3.504474951348723, 
          2.2912448962313445`}, {3.523264958358919, 2.32379000772445}}], 
         InsetBox["h", Offset[{2, 2}, {3.51930908600375, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.6790615549821887`*^9, 3.6790615827354317`*^9}, 
   3.6792482427683372`*^9, 3.679662692812254*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
ArbolHuffman: construye un \[AAcute]rbol de c\[OAcute]digos de Huffman \
optimizado, dado el \[OpenCurlyDoubleQuote]string\[CloseCurlyDoubleQuote] que \
se desea codificar. Proporciona las opciones \
\[OpenCurlyDoubleQuote]grafico->True\[CloseCurlyDoubleQuote] que muestra el \
\[AAcute]rbol como un gr\[AAcute]fico y no como un grafo y, \
\[OpenCurlyDoubleQuote]frecuencias->True\[CloseCurlyDoubleQuote] que exhibe \
un vector con las frecuencias utilizadas por el comando. Sintaxis: \
ArbolHuffman[string], o bien, ArbolHuffman[string, grafico->True, \
frecuencias->True], pudiendo prescindir de cualquiera de las opciones.\
\>", "ItemNumbered",
 CellChangeTimes->{3.6757888036316175`*^9}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, 3.6736230583261657`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArbolHuffman", "[", "\"\<enrique\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.6757803919426928`*^9, 3.6757804407852244`*^9}, {
  3.675781885525793*^9, 3.6757819027026415`*^9}, {3.6757881354156437`*^9, 
  3.675788141939522*^9}, {3.679245574691681*^9, 3.6792455755218306`*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{3, "u", "q", 6, "i", 9, "r", "n", 12, "e", 21}, {
      Null, {{1, 2}, {1, 3}, {4, 1}, {4, 5}, {6, 7}, {6, 8}, {9, 4}, {9, 
       10}, {11, 6}, {11, 9}}}, {
      ImagePadding -> 10, 
       VertexCoordinates -> {{1.267731382092775, 0.8451542547285165}, {
        0.8451542547285166, 0.}, {1.6903085094570331`, 0.}, {
        1.6903085094570331`, 1.6903085094570331`}, {2.1128856368212916`, 
        0.8451542547285165}, {0.4225771273642583, 2.53546276418555}, {0., 
        1.6903085094570331`}, {0.8451542547285166, 1.6903085094570331`}, {
        2.1128856368212916`, 2.53546276418555}, {2.53546276418555, 
        1.6903085094570331`}, {1.267731382092775, 3.3806170189140663`}}, 
       VertexLabels -> {"Name"}, VertexShapeFunction -> {"Circle"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[{{1.267731382092775, 0.8451542547285165}, {
          0.8451542547285166, 0.}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.267731382092775, 0.8451542547285165}, {
          1.6903085094570331`, 0.}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.267731382092775, 0.8451542547285165}, {
          1.6903085094570331`, 1.6903085094570331`}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.6903085094570331`, 1.6903085094570331`}, {
          2.1128856368212916`, 0.8451542547285165}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.6903085094570331`, 1.6903085094570331`}, {
          2.1128856368212916`, 2.53546276418555}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.4225771273642583, 2.53546276418555}, {0., 
          1.6903085094570331`}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.4225771273642583, 2.53546276418555}, {
          0.8451542547285166, 1.6903085094570331`}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.4225771273642583, 2.53546276418555}, {1.267731382092775,
           3.3806170189140663`}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.1128856368212916`, 2.53546276418555}, {2.53546276418555,
           1.6903085094570331`}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.1128856368212916`, 2.53546276418555}, {
          1.267731382092775, 3.3806170189140663`}}, 0.03290821123233907]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.267731382092775, 0.8451542547285165}, 
          0.03290821123233907], 
         InsetBox["3", 
          Offset[{2, 2}, {1.300639593325114, 0.8780624659608556}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8451542547285166, 0.}, 0.03290821123233907], 
         InsetBox["\<\"u\"\>", 
          Offset[{2, 2}, {0.8780624659608557, 0.03290821123233907}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6903085094570331`, 0.}, 0.03290821123233907], 
         InsetBox["\<\"q\"\>", 
          Offset[{2, 2}, {1.7232167206893723`, 0.03290821123233907}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6903085094570331`, 1.6903085094570331`}, 
          0.03290821123233907], 
         InsetBox["6", 
          Offset[{2, 2}, {1.7232167206893723`, 1.7232167206893723`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1128856368212916`, 0.8451542547285165}, 
          0.03290821123233907], 
         InsetBox["\<\"i\"\>", 
          Offset[{2, 2}, {2.1457938480536307`, 0.8780624659608556}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4225771273642583, 2.53546276418555}, 0.03290821123233907],
          InsetBox["9", 
          Offset[{2, 2}, {0.45548533859659734`, 2.568370975417889}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.6903085094570331`}, 0.03290821123233907], 
         InsetBox["\<\"r\"\>", 
          Offset[{2, 2}, {0.03290821123233907, 1.7232167206893723`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8451542547285166, 1.6903085094570331`}, 
          0.03290821123233907], 
         InsetBox["\<\"n\"\>", 
          Offset[{2, 2}, {0.8780624659608557, 1.7232167206893723`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1128856368212916`, 2.53546276418555}, 
          0.03290821123233907], 
         InsetBox["12", 
          Offset[{2, 2}, {2.1457938480536307`, 2.568370975417889}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.53546276418555, 1.6903085094570331`}, 
          0.03290821123233907], 
         InsetBox["\<\"e\"\>", 
          Offset[{2, 2}, {2.568370975417889, 1.7232167206893723`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.267731382092775, 3.3806170189140663`}, 
          0.03290821123233907], 
         InsetBox["21", 
          Offset[{2, 2}, {1.300639593325114, 3.4135252301464054`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.679245560147009*^9, 3.6792455760268126`*^9}, 
   3.679248249119851*^9, 3.6796629291686635`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArbolHuffman", "[", 
  RowBox[{"\"\<enrique\>\"", ",", 
   RowBox[{"grafico", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.679245584303765*^9, 3.6792455958739243`*^9}}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.267731382092775, 0.8451542547285165}, {
    0.8451542547285166, 0.}, {1.6903085094570331`, 0.}, {1.6903085094570331`, 
    1.6903085094570331`}, {2.1128856368212916`, 0.8451542547285165}, {
    0.4225771273642583, 2.53546276418555}, {0., 1.6903085094570331`}, {
    0.8451542547285166, 1.6903085094570331`}, {2.1128856368212916`, 
    2.53546276418555}, {2.53546276418555, 1.6903085094570331`}, {
    1.267731382092775, 3.3806170189140663`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 1}, {4, 5}, {6, 7}, {6, 8}, {9, 4}, {9, 
       10}, {11, 6}, {11, 9}}]}, {InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"u\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"q\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"i\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"r\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"n\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"e\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["21",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.267731382092775, 0.8451542547285165}, {
     0.8451542547285166, 0.}, {1.6903085094570331`, 0.}, {1.6903085094570331`,
      1.6903085094570331`}, {2.1128856368212916`, 0.8451542547285165}, {
     0.4225771273642583, 2.53546276418555}, {0., 1.6903085094570331`}, {
     0.8451542547285166, 1.6903085094570331`}, {2.1128856368212916`, 
     2.53546276418555}, {2.53546276418555, 1.6903085094570331`}, {
     1.267731382092775, 3.3806170189140663`}}]& ],
  AspectRatio->1.1547005383792515`,
  FrameTicks->None,
  ImagePadding->10,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{{3.679245585983996*^9, 3.679245596707797*^9}, 
   3.6792482530781555`*^9, 3.679662938611641*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArbolHuffman", "[", 
  RowBox[{"\"\<enrique\>\"", ",", 
   RowBox[{"frecuencias", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6792456041334968`*^9, 3.6792456049719987`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "\<\"u\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "\<\"q\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "\<\"i\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "\<\"r\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "\<\"n\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "\<\"e\"\>"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6792456056745157`*^9, 3.6792482577744074`*^9, 
  3.6796629477536106`*^9}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{3, "u", "q", 6, "i", 9, "r", "n", 12, "e", 21}, {
      Null, {{1, 2}, {1, 3}, {4, 1}, {4, 5}, {6, 7}, {6, 8}, {9, 4}, {9, 
       10}, {11, 6}, {11, 9}}}, {
      ImagePadding -> 10, 
       VertexCoordinates -> {{1.267731382092775, 0.8451542547285165}, {
        0.8451542547285166, 0.}, {1.6903085094570331`, 0.}, {
        1.6903085094570331`, 1.6903085094570331`}, {2.1128856368212916`, 
        0.8451542547285165}, {0.4225771273642583, 2.53546276418555}, {0., 
        1.6903085094570331`}, {0.8451542547285166, 1.6903085094570331`}, {
        2.1128856368212916`, 2.53546276418555}, {2.53546276418555, 
        1.6903085094570331`}, {1.267731382092775, 3.3806170189140663`}}, 
       VertexLabels -> {"Name"}, VertexShapeFunction -> {"Circle"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[{{1.267731382092775, 0.8451542547285165}, {
          0.8451542547285166, 0.}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.267731382092775, 0.8451542547285165}, {
          1.6903085094570331`, 0.}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.267731382092775, 0.8451542547285165}, {
          1.6903085094570331`, 1.6903085094570331`}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.6903085094570331`, 1.6903085094570331`}, {
          2.1128856368212916`, 0.8451542547285165}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.6903085094570331`, 1.6903085094570331`}, {
          2.1128856368212916`, 2.53546276418555}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.4225771273642583, 2.53546276418555}, {0., 
          1.6903085094570331`}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.4225771273642583, 2.53546276418555}, {
          0.8451542547285166, 1.6903085094570331`}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.4225771273642583, 2.53546276418555}, {1.267731382092775,
           3.3806170189140663`}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.1128856368212916`, 2.53546276418555}, {2.53546276418555,
           1.6903085094570331`}}, 0.03290821123233907]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.1128856368212916`, 2.53546276418555}, {
          1.267731382092775, 3.3806170189140663`}}, 0.03290821123233907]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.267731382092775, 0.8451542547285165}, 
          0.03290821123233907], 
         InsetBox["3", 
          Offset[{2, 2}, {1.300639593325114, 0.8780624659608556}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8451542547285166, 0.}, 0.03290821123233907], 
         InsetBox["\<\"u\"\>", 
          Offset[{2, 2}, {0.8780624659608557, 0.03290821123233907}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6903085094570331`, 0.}, 0.03290821123233907], 
         InsetBox["\<\"q\"\>", 
          Offset[{2, 2}, {1.7232167206893723`, 0.03290821123233907}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6903085094570331`, 1.6903085094570331`}, 
          0.03290821123233907], 
         InsetBox["6", 
          Offset[{2, 2}, {1.7232167206893723`, 1.7232167206893723`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1128856368212916`, 0.8451542547285165}, 
          0.03290821123233907], 
         InsetBox["\<\"i\"\>", 
          Offset[{2, 2}, {2.1457938480536307`, 0.8780624659608556}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4225771273642583, 2.53546276418555}, 0.03290821123233907],
          InsetBox["9", 
          Offset[{2, 2}, {0.45548533859659734`, 2.568370975417889}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.6903085094570331`}, 0.03290821123233907], 
         InsetBox["\<\"r\"\>", 
          Offset[{2, 2}, {0.03290821123233907, 1.7232167206893723`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8451542547285166, 1.6903085094570331`}, 
          0.03290821123233907], 
         InsetBox["\<\"n\"\>", 
          Offset[{2, 2}, {0.8780624659608557, 1.7232167206893723`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1128856368212916`, 2.53546276418555}, 
          0.03290821123233907], 
         InsetBox["12", 
          Offset[{2, 2}, {2.1457938480536307`, 2.568370975417889}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.53546276418555, 1.6903085094570331`}, 
          0.03290821123233907], 
         InsetBox["\<\"e\"\>", 
          Offset[{2, 2}, {2.568370975417889, 1.7232167206893723`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.267731382092775, 3.3806170189140663`}, 
          0.03290821123233907], 
         InsetBox["21", 
          Offset[{2, 2}, {1.300639593325114, 3.4135252301464054`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.679245605778592*^9, 3.6792482578524466`*^9, 
  3.679662947845775*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArbolHuffman", "[", 
  RowBox[{"\"\<enrique\>\"", ",", 
   RowBox[{"grafico", "\[Rule]", "True"}], ",", 
   RowBox[{"frecuencias", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "\<\"u\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "\<\"q\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "\<\"i\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "\<\"r\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "\<\"n\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "\<\"e\"\>"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.679245611797557*^9, 3.6792482622385464`*^9, 
  3.6796629619397078`*^9}],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.267731382092775, 0.8451542547285165}, {
    0.8451542547285166, 0.}, {1.6903085094570331`, 0.}, {1.6903085094570331`, 
    1.6903085094570331`}, {2.1128856368212916`, 0.8451542547285165}, {
    0.4225771273642583, 2.53546276418555}, {0., 1.6903085094570331`}, {
    0.8451542547285166, 1.6903085094570331`}, {2.1128856368212916`, 
    2.53546276418555}, {2.53546276418555, 1.6903085094570331`}, {
    1.267731382092775, 3.3806170189140663`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 1}, {4, 5}, {6, 7}, {6, 8}, {9, 4}, {9, 
       10}, {11, 6}, {11, 9}}]}, {InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"u\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"q\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"i\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"r\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"n\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"e\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["21",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.267731382092775, 0.8451542547285165}, {
     0.8451542547285166, 0.}, {1.6903085094570331`, 0.}, {1.6903085094570331`,
      1.6903085094570331`}, {2.1128856368212916`, 0.8451542547285165}, {
     0.4225771273642583, 2.53546276418555}, {0., 1.6903085094570331`}, {
     0.8451542547285166, 1.6903085094570331`}, {2.1128856368212916`, 
     2.53546276418555}, {2.53546276418555, 1.6903085094570331`}, {
     1.267731382092775, 3.3806170189140663`}}]& ],
  AspectRatio->1.1547005383792515`,
  FrameTicks->None,
  ImagePadding->10,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.6792456118055625`*^9, 3.67924826224555*^9, 
  3.679662961950716*^9}]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, 3.6736230640041285`*^9, {
   3.679245654084896*^9, 3.6792456543976307`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArbolHuffman", "[", 
  RowBox[{"\"\<massachhusssettsss\>\"", ",", 
   RowBox[{"frecuencias", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.675780504513979*^9, 3.6757805288268*^9}, {
  3.6757819658070164`*^9, 3.675781976018753*^9}, {3.6757881521540194`*^9, 
  3.6757881578457527`*^9}, {3.6792456611095324`*^9, 3.679245665339875*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "\<\"e\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "\<\"u\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "\<\"c\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "\<\"m\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "\<\"t\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "\<\"h\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "\<\"a\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "\<\"s\"\>"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6792456662478447`*^9, 3.6792482677001114`*^9, 
  3.6796629717496195`*^9}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{
      3, "e", "u", 6, "c", 9, "m", "t", 12, "h", 15, "a", "s", 21, 36}, {
      Null, {{1, 2}, {1, 3}, {4, 1}, {4, 5}, {6, 7}, {6, 8}, {9, 4}, {9, 
       10}, {11, 12}, {11, 13}, {14, 6}, {14, 9}, {15, 11}, {15, 14}}}, {
      ImagePadding -> 10, 
       VertexCoordinates -> {{2.413832967579928, 0.8046109891933098}, {
        2.0115274729832735`, 0.}, {2.816138462176583, 0.}, {2.816138462176583,
         1.609221978386619}, {3.2184439567732372`, 0.8046109891933098}, {
        1.6092219783866186`, 2.4138329675799284`}, {1.206916483789964, 
        1.609221978386619}, {2.0115274729832735`, 1.609221978386619}, {
        3.2184439567732372`, 2.4138329675799284`}, {3.620749451369892, 
        1.609221978386619}, {0.40230549459665466`, 3.2184439567732377`}, {0., 
        2.4138329675799284`}, {0.8046109891933093, 2.4138329675799284`}, {
        2.413832967579928, 3.2184439567732377`}, {1.4080692310882914`, 
        4.023054945966547}}, VertexLabels -> {"Name"}, 
       VertexShapeFunction -> {"Circle"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[{{2.413832967579928, 0.8046109891933098}, {
          2.0115274729832735`, 0.}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.413832967579928, 0.8046109891933098}, {
          2.816138462176583, 0.}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.413832967579928, 0.8046109891933098}, {
          2.816138462176583, 1.609221978386619}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.816138462176583, 1.609221978386619}, {
          3.2184439567732372`, 0.8046109891933098}}, 
          0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.816138462176583, 1.609221978386619}, {
          3.2184439567732372`, 2.4138329675799284`}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.6092219783866186`, 2.4138329675799284`}, {
          1.206916483789964, 1.609221978386619}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.6092219783866186`, 2.4138329675799284`}, {
          2.0115274729832735`, 1.609221978386619}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.6092219783866186`, 2.4138329675799284`}, {
          2.413832967579928, 3.2184439567732377`}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.2184439567732372`, 2.4138329675799284`}, {
          3.620749451369892, 1.609221978386619}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.2184439567732372`, 2.4138329675799284`}, {
          2.413832967579928, 3.2184439567732377`}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.40230549459665466`, 3.2184439567732377`}, {0., 
          2.4138329675799284`}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.40230549459665466`, 3.2184439567732377`}, {
          0.8046109891933093, 2.4138329675799284`}}, 
          0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.40230549459665466`, 3.2184439567732377`}, {
          1.4080692310882914`, 4.023054945966547}}, 0.037152637843896955`]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.413832967579928, 3.2184439567732377`}, {
          1.4080692310882914`, 4.023054945966547}}, 
          0.037152637843896955`]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.413832967579928, 0.8046109891933098}, 
          0.037152637843896955`], 
         InsetBox["3", 
          Offset[{2, 2}, {2.450985605423825, 0.8417636270372068}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.0115274729832735`, 0.}, 0.037152637843896955`], 
         InsetBox["\<\"e\"\>", 
          Offset[{2, 2}, {2.0486801108271706`, 0.037152637843896955`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.816138462176583, 0.}, 0.037152637843896955`], 
         InsetBox["\<\"u\"\>", 
          Offset[{2, 2}, {2.85329110002048, 0.037152637843896955`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.816138462176583, 1.609221978386619}, 
          0.037152637843896955`], 
         InsetBox["6", Offset[{2, 2}, {2.85329110002048, 1.646374616230516}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.2184439567732372`, 0.8046109891933098}, 
          0.037152637843896955`], 
         InsetBox["\<\"c\"\>", 
          Offset[{2, 2}, {3.2555965946171344`, 0.8417636270372068}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6092219783866186`, 2.4138329675799284`}, 
          0.037152637843896955`], 
         InsetBox["9", 
          Offset[{2, 2}, {1.6463746162305155`, 2.4509856054238255`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.206916483789964, 1.609221978386619}, 
          0.037152637843896955`], 
         InsetBox["\<\"m\"\>", 
          Offset[{2, 2}, {1.2440691216338609`, 1.646374616230516}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.0115274729832735`, 1.609221978386619}, 
          0.037152637843896955`], 
         InsetBox["\<\"t\"\>", 
          Offset[{2, 2}, {2.0486801108271706`, 1.646374616230516}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.2184439567732372`, 2.4138329675799284`}, 
          0.037152637843896955`], 
         InsetBox["12", 
          Offset[{2, 2}, {3.2555965946171344`, 2.4509856054238255`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.620749451369892, 1.609221978386619}, 
          0.037152637843896955`], 
         InsetBox["\<\"h\"\>", 
          Offset[{2, 2}, {3.6579020892137892`, 1.646374616230516}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.40230549459665466`, 3.2184439567732377`}, 
          0.037152637843896955`], 
         InsetBox["15", 
          Offset[{2, 2}, {0.4394581324405516, 3.255596594617135}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 2.4138329675799284`}, 0.037152637843896955`], 
         InsetBox["\<\"a\"\>", 
          Offset[{2, 2}, {0.037152637843896955`, 2.4509856054238255`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8046109891933093, 2.4138329675799284`}, 
          0.037152637843896955`], 
         InsetBox["\<\"s\"\>", 
          Offset[{2, 2}, {0.8417636270372063, 2.4509856054238255`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.413832967579928, 3.2184439567732377`}, 
          0.037152637843896955`], 
         InsetBox["21", 
          Offset[{2, 2}, {2.450985605423825, 3.255596594617135}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.4080692310882914`, 4.023054945966547}, 
          0.037152637843896955`], 
         InsetBox["36", 
          Offset[{2, 2}, {1.4452218689321883`, 4.060207583810444}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.679245666352964*^9, 3.679248267799223*^9, 
  3.679662971847138*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Postfijo: recorre un k-\[AAcute]rbol \[OpenCurlyDoubleQuote]T\
\[CloseCurlyDoubleQuote] en orden final (postorden/postfijo) mostrando como \
salida una lista ordenada de los nodos transitados durante el proceso. \
\[OpenCurlyDoubleQuote]T\[CloseCurlyDoubleQuote] pudo haber sido creado en el \
\[OpenCurlyDoubleQuote]Wolfram System\[CloseCurlyDoubleQuote] de Mathematica, \
o bien, con el paquete \[OpenCurlyDoubleQuote]Combinatorica\
\[CloseCurlyDoubleQuote]. Brinda la opci\[OAcute]n \
\[OpenCurlyDoubleQuote]animacion->True\[CloseCurlyDoubleQuote] que exhibe \
paso a paso el recorrido postfijo. Sintaxis: Postfijo[T, nodo], o, \
Postfijo[T, nodo, animacion->True], con \[OpenCurlyDoubleQuote]nodo\
\[CloseCurlyDoubleQuote] el v\[EAcute]rtice ra\[IAcute]z del \[AAcute]rbol \
\[OpenCurlyDoubleQuote]T\[CloseCurlyDoubleQuote]. No acepta \[AAcute]rboles \
gr\[AAcute]ficos ni dirigidos.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6762006312481685`*^9, 3.6762006327976723`*^9}, {
   3.676201339899448*^9, 3.6762013510950127`*^9}, 3.6762041315684524`*^9, {
   3.679664039741297*^9, 3.679664040049184*^9}}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, 3.6736230583261657`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"arbol", "=", 
  RowBox[{"Arbol", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "h"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6762069316321983`*^9, 3.6762069330810733`*^9}, {
  3.676207031014502*^9, 3.6762070316571655`*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, 1, 2, 3, 4, 
       5, $CellContext`d, $CellContext`e, $CellContext`f, $CellContext`g, \
$CellContext`h}, {
      Null, {{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {3, 8}, {7, 9}, {
       7, 10}, {8, 11}, {8, 12}, {8, 13}}}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}, 
       VertexShapeFunction -> {"Circle"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[{{1.4174872092588753`, 2.0011584130713533`}, {
          0.3335264021785589, 1.3341056087142356`}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.4174872092588753`, 2.0011584130713533`}, {
          2.5014480163391917`, 1.3341056087142356`}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.3335264021785589, 1.3341056087142356`}, {0., 
          0.6670528043571178}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.3335264021785589, 1.3341056087142356`}, {
          0.6670528043571178, 0.6670528043571178}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.5014480163391917`, 1.3341056087142356`}, {
          1.3341056087142356`, 0.6670528043571178}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.5014480163391917`, 1.3341056087142356`}, {
          2.0011584130713533`, 0.6670528043571178}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.5014480163391917`, 1.3341056087142356`}, {
          3.668790423964148, 0.6670528043571178}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.0011584130713533`, 0.6670528043571178}, {
          1.6676320108927944`, 0.}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.0011584130713533`, 0.6670528043571178}, {
          2.3346848152499122`, 0.}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.668790423964148, 0.6670528043571178}, {3.00173761960703,
           0.}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.668790423964148, 0.6670528043571178}, {
          3.668790423964148, 0.}}, 0.03910970367831505]}, 
        {Arrowheads[0.], 
         ArrowBox[{{3.668790423964148, 0.6670528043571178}, {
          4.335843228321266, 0.}}, 0.03910970367831505]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.4174872092588753`, 2.0011584130713533`}, 
          0.03910970367831505], 
         InsetBox["a", 
          Offset[{2, 2}, {1.4565969129371903`, 2.0402681167496683`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.3335264021785589, 1.3341056087142356`}, 
          0.03910970367831505], 
         InsetBox["b", 
          Offset[{2, 2}, {0.37263610585687396`, 1.3732153123925506`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.5014480163391917`, 1.3341056087142356`}, 
          0.03910970367831505], 
         InsetBox["c", 
          Offset[{2, 2}, {2.5405577200175067`, 1.3732153123925506`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.6670528043571178}, 0.03910970367831505], 
         InsetBox["1", 
          Offset[{2, 2}, {0.03910970367831505, 0.7061625080354328}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.6670528043571178, 0.6670528043571178}, 
          0.03910970367831505], 
         InsetBox["2", 
          Offset[{2, 2}, {0.7061625080354328, 0.7061625080354328}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.3341056087142356`, 0.6670528043571178}, 
          0.03910970367831505], 
         InsetBox["3", 
          Offset[{2, 2}, {1.3732153123925506`, 0.7061625080354328}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.0011584130713533`, 0.6670528043571178}, 
          0.03910970367831505], 
         InsetBox["4", 
          Offset[{2, 2}, {2.0402681167496683`, 0.7061625080354328}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.668790423964148, 0.6670528043571178}, 
          0.03910970367831505], 
         InsetBox["5", 
          Offset[{2, 2}, {3.707900127642463, 0.7061625080354328}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6676320108927944`, 0.}, 0.03910970367831505], 
         InsetBox["d", 
          Offset[{2, 2}, {1.7067417145711095`, 0.03910970367831505}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.3346848152499122`, 0.}, 0.03910970367831505], 
         InsetBox["e", 
          Offset[{2, 2}, {2.3737945189282272`, 0.03910970367831505}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.00173761960703, 0.}, 0.03910970367831505], 
         InsetBox["f", 
          Offset[{2, 2}, {3.040847323285345, 0.03910970367831505}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.668790423964148, 0.}, 0.03910970367831505], 
         InsetBox["g", 
          Offset[{2, 2}, {3.707900127642463, 0.03910970367831505}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.335843228321266, 0.}, 0.03910970367831505], 
         InsetBox["h", 
          Offset[{2, 2}, {4.374952931999581, 0.03910970367831505}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.676212995798544*^9, 3.676214103146841*^9, 
  3.6762859148991356`*^9, 3.6762867799143906`*^9, 3.6763096661668553`*^9, 
  3.676310268106793*^9, 3.676548133082841*^9, 3.6781268686156445`*^9, 
  3.6781271699354224`*^9, 3.678127256158848*^9, 3.6792381248148985`*^9, 
  3.6792457678234735`*^9, 3.6792482735851536`*^9, 3.679663099097637*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Postfijo", "[", 
  RowBox[{"arbol", ",", "a"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Postfijo", "[", 
  RowBox[{"arbol", ",", "a", ",", 
   RowBox[{"animacion", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.676207040193078*^9, 3.6762070461726975`*^9}, {
  3.676212877180702*^9, 3.676212879551614*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "b", ",", "3", ",", "d", ",", "e", ",", "4", ",", "f", 
   ",", "g", ",", "h", ",", "5", ",", "c", ",", "a"}], "}"}]], "Output",
 CellChangeTimes->{3.6796631027936487`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "b", ",", "3", ",", "d", ",", "e", ",", "4", ",", "f", 
   ",", "g", ",", "h", ",", "5", ",", "c", ",", "a"}], "}"}]], "Print",
 CellChangeTimes->{3.679663102825713*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ai17$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Ai17$$], 1, "Nodos"}, 1, 13, 1}}, 
    Typeset`size$$ = {1254.5, {54., 27.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    VilCretas`Private`Ai17$29062$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Ai17$$ = 1}, 
      "ControllerVariables" :> {
        Hold[VilCretas`Private`Ai17$$, VilCretas`Private`Ai17$29062$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`AArbolAuxiliar11, 
        Cases[VilCretas`Private`AList22, 
         Condition[
          Pattern[VilCretas`Private`Aicontador13$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Ai16, {
            VilCretas`Private`Ai16, VilCretas`Private`Ai17$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`AList22, VilCretas`Private`Aicontador13$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 10, 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Ai17$$, 1, "Nodos"}, 1, 13, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{1345., {120., 135.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.679663102849739*^9}]
}, Open  ]]
}, Closed]],

Cell["Ejemplo 2", "SubitemNumbered",
 CellChangeTimes->{{3.662122048688426*^9, 3.662122056177115*^9}, 
   3.6621227564989743`*^9, {3.662722345772545*^9, 3.662722352240964*^9}, {
   3.662722410022896*^9, 3.6627224118058434`*^9}, {3.673623060406437*^9, 
   3.6736230617345734`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"arbol", "=", 
  RowBox[{"ArbolR", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "h"}], "}"}]}], "}"}], ",", "5"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Postfijo", "[", 
  RowBox[{"arbol", ",", "5"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Postfijo", "[", 
  RowBox[{"arbol", ",", "5", ",", 
   RowBox[{"animacion", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.676207103190506*^9, 3.6762071165303288`*^9}, {
  3.676212883069644*^9, 3.676212885256024*^9}}],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, 1, 2, 3, 4, 
       5, $CellContext`d, $CellContext`e, $CellContext`f, $CellContext`g, \
$CellContext`h}, {
      Null, {{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {3, 8}, {7, 9}, {
       7, 10}, {8, 11}, {8, 12}, {8, 13}}}, {
      ImagePadding -> 10, 
       VertexCoordinates -> {{0.3872983346207417, 1.5491933384829668`}, {
        0.3872983346207417, 0.7745966692414834}, {1.161895003862225, 
        2.32379000772445}, {0., 0.}, {0.7745966692414834, 0.}, {
        1.161895003862225, 1.5491933384829668`}, {1.9364916731037085`, 
        1.5491933384829668`}, {2.32379000772445, 3.0983866769659336`}, {
        1.5491933384829668`, 0.7745966692414834}, {2.32379000772445, 
        0.7745966692414834}, {1.9364916731037085`, 2.32379000772445}, {
        2.711088342345192, 2.32379000772445}, {3.4856850115866753`, 
        2.32379000772445}}, VertexLabels -> {"Name"}, 
       VertexShapeFunction -> {"Circle"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
        {Arrowheads[0.], 
         ArrowBox[{{0.3872983346207417, 1.5491933384829668`}, {
          0.3872983346207417, 0.7745966692414834}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.3872983346207417, 1.5491933384829668`}, {
          1.161895003862225, 2.32379000772445}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.3872983346207417, 0.7745966692414834}, {0., 0.}}, 
          0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{0.3872983346207417, 0.7745966692414834}, {
          0.7745966692414834, 0.}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.161895003862225, 2.32379000772445}, {1.161895003862225, 
          1.5491933384829668`}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.161895003862225, 2.32379000772445}, {
          1.9364916731037085`, 1.5491933384829668`}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.161895003862225, 2.32379000772445}, {2.32379000772445, 
          3.0983866769659336`}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.9364916731037085`, 1.5491933384829668`}, {
          1.5491933384829668`, 0.7745966692414834}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{1.9364916731037085`, 1.5491933384829668`}, {
          2.32379000772445, 0.7745966692414834}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.32379000772445, 3.0983866769659336`}, {
          1.9364916731037085`, 2.32379000772445}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.32379000772445, 3.0983866769659336`}, {
          2.711088342345192, 2.32379000772445}}, 0.03362407441707502]}, 
        {Arrowheads[0.], 
         ArrowBox[{{2.32379000772445, 3.0983866769659336`}, {
          3.4856850115866753`, 2.32379000772445}}, 0.03362407441707502]}}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.3872983346207417, 1.5491933384829668`}, 
          0.03362407441707502], 
         InsetBox["a", 
          Offset[{2, 2}, {0.42092240903781675`, 1.5828174129000419`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.3872983346207417, 0.7745966692414834}, 
          0.03362407441707502], 
         InsetBox["b", 
          Offset[{2, 2}, {0.42092240903781675`, 0.8082207436585584}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.161895003862225, 2.32379000772445}, 0.03362407441707502], 
         InsetBox["c", 
          Offset[{2, 2}, {1.1955190782793002`, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.03362407441707502], 
         InsetBox["1", 
          Offset[{2, 2}, {0.03362407441707502, 0.03362407441707502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7745966692414834, 0.}, 0.03362407441707502], 
         InsetBox["2", 
          Offset[{2, 2}, {0.8082207436585584, 0.03362407441707502}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.161895003862225, 1.5491933384829668`}, 
          0.03362407441707502], 
         InsetBox["3", 
          Offset[{2, 2}, {1.1955190782793002`, 1.5828174129000419`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.9364916731037085`, 1.5491933384829668`}, 
          0.03362407441707502], 
         InsetBox["4", 
          Offset[{2, 2}, {1.9701157475207836`, 1.5828174129000419`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.32379000772445, 3.0983866769659336`}, 
          0.03362407441707502], 
         InsetBox["5", 
          Offset[{2, 2}, {2.357414082141525, 3.1320107513830084`}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.5491933384829668`, 0.7745966692414834}, 
          0.03362407441707502], 
         InsetBox["d", 
          Offset[{2, 2}, {1.5828174129000419`, 0.8082207436585584}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.32379000772445, 0.7745966692414834}, 0.03362407441707502],
          InsetBox["e", 
          Offset[{2, 2}, {2.357414082141525, 0.8082207436585584}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.9364916731037085`, 2.32379000772445}, 
          0.03362407441707502], 
         InsetBox["f", 
          Offset[{2, 2}, {1.9701157475207836`, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.711088342345192, 2.32379000772445}, 0.03362407441707502], 
         InsetBox["g", 
          Offset[{2, 2}, {2.7447124167622667`, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.4856850115866753`, 2.32379000772445}, 
          0.03362407441707502], 
         InsetBox["h", Offset[{2, 2}, {3.51930908600375, 2.357414082141525}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{3.6792457948294525`*^9, 3.6792482839269857`*^9, 
  3.6796631203171315`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "b", ",", "a", ",", "3", ",", "d", ",", "e", ",", "4", 
   ",", "c", ",", "f", ",", "g", ",", "h", ",", "5"}], "}"}]], "Output",
 CellChangeTimes->{3.6792457948294525`*^9, 3.6792482839269857`*^9, 
  3.6796631203240633`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "b", ",", "a", ",", "3", ",", "d", ",", "e", ",", "4", 
   ",", "c", ",", "f", ",", "g", ",", "h", ",", "5"}], "}"}]], "Print",
 CellChangeTimes->{3.679245794863476*^9, 3.679248283966013*^9, 
  3.6796631203360834`*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{VilCretas`Private`Ai17$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[VilCretas`Private`Ai17$$], 1, "Nodos"}, 1, 13, 1}}, 
    Typeset`size$$ = {1254.5, {54., 27.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    VilCretas`Private`Ai17$29451$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {VilCretas`Private`Ai17$$ = 1}, 
      "ControllerVariables" :> {
        Hold[VilCretas`Private`Ai17$$, VilCretas`Private`Ai17$29451$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      HighlightGraph[VilCretas`Private`AArbolAuxiliar11, 
        Cases[VilCretas`Private`AList22, 
         Condition[
          Pattern[VilCretas`Private`Aicontador13$, 
           Blank[]], 
          MemberQ[
           Table[
           VilCretas`Private`Ai16, {
            VilCretas`Private`Ai16, VilCretas`Private`Ai17$$}], 
           Part[
            Flatten[
             Position[
             VilCretas`Private`AList22, VilCretas`Private`Aicontador13$]], 
            1]]]], VertexLabels -> "Name", ImagePadding -> 10, 
        GraphHighlightStyle -> "Thick"], 
      "Specifications" :> {{{VilCretas`Private`Ai17$$, 1, "Nodos"}, 1, 13, 
         1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{1345., {120., 135.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{3.679245794863476*^9, 3.679248283966013*^9, 
  3.6796631203641014`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
CDFArbolesGeneradores: construye una animaci\[OAcute]n dadas las aristas de \
un grafo \[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote], sus pesos y un \
orden en sus v\[EAcute]rtices, mostrando la aplicaci\[OAcute]n de los \
algoritmos: \[OpenCurlyDoubleQuote]buscar primero a lo ancho\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]buscar primero a lo largo\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]Prim\[CloseCurlyDoubleQuote] \
y \[OpenCurlyDoubleQuote]Kruskal\[CloseCurlyDoubleQuote] sobre \
\[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote]. Sintaxis: \
CDFArbolesGeneradores[lados, pesos, orden], siendo \
\[OpenCurlyDoubleQuote]lados\[CloseCurlyDoubleQuote] las aristas de \
\[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote] dadas como pares ordenados, \
\[OpenCurlyDoubleQuote]pesos\[CloseCurlyDoubleQuote] un vector de \
ponderaciones y \[OpenCurlyDoubleQuote]orden\[CloseCurlyDoubleQuote] la lista \
ordenada de los v\[EAcute]rtices, a trav\[EAcute]s de la cual, se aplicar\
\[AAcute]n los procedimientos.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6790616204924006`*^9, 3.6790616534192495`*^9}, 
   3.6792458490930896`*^9}],

Cell["Ejemplo 1", "SubitemNumbered",
 CellChangeTimes->{
  3.679054905503214*^9, {3.6792458516421175`*^9, 3.679245854331291*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDFArbolesGeneradores", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "g"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "10", ",", "15", ",", "5", ",", "6", ",", "7", ",", "12", ",", 
     "30", ",", "9", ",", "8", ",", "20", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{
    VilCretas`Private`AVl18$$ = {{$CellContext`a, $CellContext`b}, \
{$CellContext`a, $CellContext`c}, {$CellContext`b, $CellContext`c}, \
{$CellContext`b, $CellContext`d}, {$CellContext`b, $CellContext`f}, \
{$CellContext`c, $CellContext`d}, {$CellContext`c, $CellContext`g}, \
{$CellContext`c, $CellContext`e}, {$CellContext`d, $CellContext`f}, \
{$CellContext`d, $CellContext`g}, {$CellContext`e, $CellContext`g}, \
{$CellContext`f, $CellContext`g}}, VilCretas`Private`AVl19$$ = {5, 10, 15, 5, 
    6, 7, 12, 30, 9, 8, 20, 14}, 
    VilCretas`Private`AVl20$$ = {$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`g}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[
       VilCretas`Private`AVl18$$], {{$CellContext`a, $CellContext`b}, \
{$CellContext`a, $CellContext`c}, {$CellContext`b, $CellContext`c}, \
{$CellContext`b, $CellContext`d}, {$CellContext`b, $CellContext`f}, \
{$CellContext`c, $CellContext`d}, {$CellContext`c, $CellContext`g}, \
{$CellContext`c, $CellContext`e}, {$CellContext`d, $CellContext`f}, \
{$CellContext`d, $CellContext`g}, {$CellContext`e, $CellContext`g}, \
{$CellContext`f, $CellContext`g}}, "Aristas del grafo"}}, {{
       Hold[VilCretas`Private`AVl19$$], {5, 10, 15, 5, 6, 7, 12, 30, 9, 8, 20,
        14}, "Pesos de los lados"}}, {{
       Hold[
       VilCretas`Private`AVl20$$], {$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`g}, "Orden de los nodos"}}}, Typeset`size$$ = {
    1101., {272., 287.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {
       VilCretas`Private`AVl18$$ = {{$CellContext`a, $CellContext`b}, \
{$CellContext`a, $CellContext`c}, {$CellContext`b, $CellContext`c}, \
{$CellContext`b, $CellContext`d}, {$CellContext`b, $CellContext`f}, \
{$CellContext`c, $CellContext`d}, {$CellContext`c, $CellContext`g}, \
{$CellContext`c, $CellContext`e}, {$CellContext`d, $CellContext`f}, \
{$CellContext`d, $CellContext`g}, {$CellContext`e, $CellContext`g}, \
{$CellContext`f, $CellContext`g}}, 
        VilCretas`Private`AVl19$$ = {5, 10, 15, 5, 6, 7, 12, 30, 9, 8, 20, 
         14}, VilCretas`Private`AVl20$$ = {$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`g}}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[
        MatrixQ[VilCretas`Private`AVl18$$], 
        If[MemberQ[
           ToCharacterCode[
            ToString[VilCretas`Private`AVl18$$]], 62760] == False, 
         If[Part[
            Dimensions[VilCretas`Private`AVl18$$], 2] == 2, 
          If[MemberQ[
             Flatten[VilCretas`Private`AVl18$$], Null] == False, 
           If[
            VectorQ[VilCretas`Private`AVl19$$], 
            If[MemberQ[VilCretas`Private`AVl19$$, Null] == False, 
             If[VilCretas`Private`AVl19$$ != {}, 
              If[
              Length[VilCretas`Private`AVl18$$] == 
               Length[VilCretas`Private`AVl19$$], 
               If[
                VectorQ[VilCretas`Private`AVl20$$], 
                If[MemberQ[VilCretas`Private`AVl20$$, Null] == False, 
                 If[VilCretas`Private`AVl20$$ != {}, 
                  If[ToString[
                    Sort[
                    DeleteDuplicates[
                    Flatten[VilCretas`Private`AVl18$$]]]] == ToString[
                    Sort[VilCretas`Private`AVl20$$]], 
                   Column[{
                    VilCretas`Grafo[
                    VilCretas`Private`AVl18$$, VilCretas`Private`pesos -> 
                    VilCretas`Private`AVl19$$, VilCretas`Private`mostrarpesos -> 
                    True], 
                    Row[{"Buscar primero a lo ancho: ", 
                    VilCretas`BuscarPrimeroAncho[
                    VilCretas`Grafo[
                    VilCretas`Private`AVl18$$, VilCretas`Private`pesos -> 
                    VilCretas`Private`AVl19$$, VilCretas`Private`mostrarpesos -> 
                    True], VilCretas`Private`orden -> 
                    VilCretas`Private`AVl20$$]}], 
                    Row[{"Buscar primero a lo largo: ", 
                    VilCretas`BuscarPrimeroLargo[
                    VilCretas`Grafo[
                    VilCretas`Private`AVl18$$, VilCretas`Private`pesos -> 
                    VilCretas`Private`AVl19$$, VilCretas`Private`mostrarpesos -> 
                    True], VilCretas`Private`orden -> 
                    VilCretas`Private`AVl20$$]}], 
                    Row[{"Prim: ", 
                    If[
                    VectorQ[VilCretas`Private`AVl19$$, NumericQ], 
                    VilCretas`Private`OPrim[
                    VilCretas`Grafo[
                    VilCretas`Private`AVl18$$, VilCretas`Private`pesos -> 
                    VilCretas`Private`AVl19$$, VilCretas`Private`mostrarpesos -> 
                    True], VilCretas`Private`AVl20$$], ""]}], 
                    Row[{"Kruskal: ", 
                    If[
                    VectorQ[VilCretas`Private`AVl19$$, NumericQ], 
                    VilCretas`Private`OKruskal[
                    VilCretas`Grafo[
                    VilCretas`Private`AVl18$$, VilCretas`Private`pesos -> 
                    VilCretas`Private`AVl19$$, VilCretas`Private`mostrarpesos -> 
                    True]], ""]}]}], ""], ""], ""], ""], ""], ""], ""], ""], 
           ""], ""], ""], ""], 
      "Specifications" :> {{{
         VilCretas`Private`AVl18$$, {{$CellContext`a, $CellContext`b}, \
{$CellContext`a, $CellContext`c}, {$CellContext`b, $CellContext`c}, \
{$CellContext`b, $CellContext`d}, {$CellContext`b, $CellContext`f}, \
{$CellContext`c, $CellContext`d}, {$CellContext`c, $CellContext`g}, \
{$CellContext`c, $CellContext`e}, {$CellContext`d, $CellContext`f}, \
{$CellContext`d, $CellContext`g}, {$CellContext`e, $CellContext`g}, \
{$CellContext`f, $CellContext`g}}, "Aristas del grafo"}}, {{
         VilCretas`Private`AVl19$$, {5, 10, 15, 5, 6, 7, 12, 30, 9, 8, 20, 
          14}, "Pesos de los lados"}}, {{
         VilCretas`Private`AVl20$$, {$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`g}, "Orden de los nodos"}}}, "Options" :> {Alignment -> Center}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{1191., {441., 456.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((VilCretas`Private`OPrim[
         Pattern[VilCretas`Private`AGrafo, 
          Blank[]], 
         Pattern[VilCretas`Private`AAOrden, 
          Blank[]]] := 
       Module[{VilCretas`Private`AlgoritmoPrim}, 
         VilCretas`Private`AlgoritmoPrim[
            Pattern[VilCretas`Private`AAGrafo, 
             Blank[]], 
            Pattern[VilCretas`Private`OrdenLista, 
             Blank[]]] := 
          Module[{VilCretas`Private`AGrafoAuxiliar3, 
             VilCretas`Private`APReglas}, 
            VilCretas`Private`APReglas = Table[ToString[
                 Part[VilCretas`Private`OrdenLista, VilCretas`Private`APAi]] -> 
               VilCretas`Private`APAi, {VilCretas`Private`APAi, 
                VertexCount[VilCretas`Private`AAGrafo]}]; 
            VilCretas`Private`AGrafoAuxiliar3 = VilCretas`Grafo[
               ReplaceAll[
                Map[ToString, 
                 VilCretas`AristasWolframSystemToCombinatorica[
                  EdgeList[VilCretas`Private`AAGrafo]], {2}], 
                VilCretas`Private`APReglas], VilCretas`Private`pesos -> 
               Table[
                 Part[
                  Flatten[
                   Select[
                    VilCretas`PesosAristas[VilCretas`Private`AAGrafo], 
                    MemberQ[#, VilCretas`Private`APAi]& ]], 2], {
                 VilCretas`Private`APAi, 
                  EdgeList[VilCretas`Private`AAGrafo]}]]; 
            Module[{VilCretas`Private`APrimn = 
               VertexCount[VilCretas`Private`AGrafoAuxiliar3], 
               VilCretas`Private`APrimm = 
               EdgeCount[VilCretas`Private`AGrafoAuxiliar3], 
               VilCretas`Private`APrimT, VilCretas`Private`APrimL, 
               VilCretas`Private`APrimMP, VilCretas`Private`APrimAi, 
               VilCretas`Private`APLPesos, VilCretas`Private`APPesoMin, 
               VilCretas`Private`APLPosPesoMin, 
               VilCretas`Private`APPosPesoMin, VilCretas`Private`APArista, 
               VilCretas`Private`APAristasArbol, VilCretas`Private`APPeso, 
               VilCretas`Private`APAristasS, VilCretas`Private`APAristasSS, 
               VilCretas`Private`APPos1, VilCretas`Private`APPos1Ext, 
               VilCretas`Private`APArbol, VilCretas`Private`APNArbol, 
               VilCretas`Private`APContador}, 
              VilCretas`Private`APrimT = Sort[
                 VertexList[VilCretas`Private`AGrafoAuxiliar3]]; 
              VilCretas`Private`APrimL = 
               EdgeList[VilCretas`Private`AGrafoAuxiliar3]; 
              VilCretas`Private`APrimMP = Part[
                 VilCretas`MPGrafo[
                 VilCretas`Private`AGrafoAuxiliar3, VilCretas`Private`APrimT],
                  1]; VilCretas`Private`APAristasS = {}; 
              VilCretas`Private`APAristasSS = {}; 
              For[VilCretas`Private`APrimAi = 1, VilCretas`Private`APrimAi <= 
                VilCretas`Private`APrimn, If[
                  EdgeQ[VilCretas`Private`AGrafoAuxiliar3, 
                   UndirectedEdge[
                    Part[VilCretas`Private`APrimT, 1], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]]], 
                  VilCretas`Private`APAristasS = 
                   Append[VilCretas`Private`APAristasS, {{
                    Part[VilCretas`Private`APrimT, 1], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]}, 
                    Part[
                    VilCretas`Private`APrimMP, 1, 
                    VilCretas`Private`APrimAi]}]; 
                  VilCretas`Private`APAristasSS = 
                   Append[VilCretas`Private`APAristasSS, {
                    Part[VilCretas`Private`APrimT, 1], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]}]]; 
                Increment[VilCretas`Private`APrimAi]]; 
              VilCretas`Private`APLPesos = {}; 
              For[VilCretas`Private`APrimAi = 1, VilCretas`Private`APrimAi <= 
                Length[VilCretas`Private`APAristasS], 
                VilCretas`Private`APLPesos = 
                 Append[VilCretas`Private`APLPesos, 
                   Part[
                   VilCretas`Private`APAristasS, VilCretas`Private`APrimAi, 
                    2]]; Increment[VilCretas`Private`APrimAi]]; 
              VilCretas`Private`APPesoMin = Min[VilCretas`Private`APLPesos]; 
              VilCretas`Private`APLPosPesoMin = Flatten[
                 Position[
                 VilCretas`Private`APLPesos, VilCretas`Private`APPesoMin]]; 
              VilCretas`Private`APArista = Part[
                 Sort[
                  Part[
                  VilCretas`Private`APAristasS, 
                   VilCretas`Private`APLPosPesoMin]], 1, 1]; 
              VilCretas`Private`APPosPesoMin = Part[
                 Position[
                 VilCretas`Private`APAristasSS, VilCretas`Private`APArista], 
                 1, 1]; VilCretas`Private`APAristasArbol = {
                 UndirectedEdge[
                  Part[VilCretas`Private`APArista, 1], 
                  Part[VilCretas`Private`APArista, 2]]}; 
              VilCretas`Private`APPeso = VilCretas`Private`APPesoMin; 
              VilCretas`Private`APArista = 
               Last[VilCretas`Private`APAristasArbol]; 
              For[VilCretas`Private`APrimAi = 1, VilCretas`Private`APrimAi <= 
                VilCretas`Private`APrimn, If[
                  And[
                   EdgeQ[VilCretas`Private`AGrafoAuxiliar3, 
                    UndirectedEdge[
                    Part[VilCretas`Private`APArista, 2], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]]], 
                   ToString[
                    Part[VilCretas`Private`APArista, 1]] != ToString[
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]]], 
                  VilCretas`Private`APPos1 = 
                   Position[VilCretas`Private`APrimT, 
                    Part[VilCretas`Private`APArista, 2]]; 
                  VilCretas`Private`APPos1Ext = 
                   Part[VilCretas`Private`APPos1, 1, 1]; 
                  VilCretas`Private`APAristasS = 
                   Append[VilCretas`Private`APAristasS, {{
                    Part[VilCretas`Private`APArista, 2], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]}, 
                    Part[
                    VilCretas`Private`APrimMP, VilCretas`Private`APPos1Ext, 
                    VilCretas`Private`APrimAi]}]; 
                  VilCretas`Private`APAristasSS = 
                   Append[VilCretas`Private`APAristasSS, {
                    Part[VilCretas`Private`APArista, 2], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]}]]; 
                Increment[VilCretas`Private`APrimAi]]; 
              VilCretas`Private`APAristasS = 
               Delete[VilCretas`Private`APAristasS, 
                 VilCretas`Private`APPosPesoMin]; 
              VilCretas`Private`APAristasSS = 
               Delete[VilCretas`Private`APAristasSS, 
                 VilCretas`Private`APPosPesoMin]; 
              VilCretas`Private`APContador = 1; 
              While[Length[VilCretas`Private`APAristasArbol] < 
                VilCretas`Private`APrimn - 1, VilCretas`Private`APLPesos = {}; 
                For[VilCretas`Private`APrimAi = 1, VilCretas`Private`APrimAi <= 
                  Length[VilCretas`Private`APAristasS], 
                  VilCretas`Private`APLPesos = 
                   Append[VilCretas`Private`APLPesos, 
                    Part[
                    VilCretas`Private`APAristasS, VilCretas`Private`APrimAi, 
                    2]]; Increment[VilCretas`Private`APrimAi]]; 
                VilCretas`Private`APPesoMin = Min[VilCretas`Private`APLPesos]; 
                VilCretas`Private`APLPosPesoMin = Flatten[
                   Position[
                   VilCretas`Private`APLPesos, VilCretas`Private`APPesoMin]]; 
                VilCretas`Private`APArista = Part[
                   Sort[
                    Part[
                    VilCretas`Private`APAristasS, 
                    VilCretas`Private`APLPosPesoMin]], 1, 1]; 
                VilCretas`Private`APPosPesoMin = Part[
                   Position[
                   VilCretas`Private`APAristasSS, VilCretas`Private`APArista],
                    1, 1]; VilCretas`Private`APNArbol = Graph[
                   Append[VilCretas`Private`APAristasArbol, 
                    UndirectedEdge[
                    Part[VilCretas`Private`APArista, 1], 
                    Part[VilCretas`Private`APArista, 2]]]]; If[
                  AcyclicGraphQ[VilCretas`Private`APNArbol], 
                  VilCretas`Private`APAristasArbol = 
                   Append[VilCretas`Private`APAristasArbol, 
                    UndirectedEdge[
                    Part[VilCretas`Private`APArista, 1], 
                    Part[VilCretas`Private`APArista, 2]]]; 
                  VilCretas`Private`APArbol = 
                   Graph[VilCretas`Private`APAristasArbol, VertexLabels -> 
                    "Name", ImagePadding -> 10]; 
                  VilCretas`Private`APPeso = 
                   VilCretas`Private`APPeso + VilCretas`Private`APPesoMin; 
                  VilCretas`Private`APAristasS = 
                   Delete[VilCretas`Private`APAristasS, 
                    VilCretas`Private`APPosPesoMin]; 
                  VilCretas`Private`APAristasSS = 
                   Delete[VilCretas`Private`APAristasSS, 
                    VilCretas`Private`APPosPesoMin]; 
                  Increment[VilCretas`Private`APContador]; 
                  VilCretas`Private`APArista = 
                   Last[VilCretas`Private`APAristasArbol]; 
                  For[VilCretas`Private`APrimAi = 1, 
                    VilCretas`Private`APrimAi <= VilCretas`Private`APrimn, 
                    If[
                    And[
                    EdgeQ[VilCretas`Private`AGrafoAuxiliar3, 
                    UndirectedEdge[
                    Part[VilCretas`Private`APArista, 2], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]]], 
                    ToString[
                    Part[VilCretas`Private`APArista, 1]] != ToString[
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]], 
                    EdgeQ[VilCretas`Private`APArbol, 
                    UndirectedEdge[
                    Part[VilCretas`Private`APArista, 2], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]]] == 
                    False, MemberQ[VilCretas`Private`APAristasSS, {
                    Part[VilCretas`Private`APArista, 2], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]}] == 
                    False, MemberQ[VilCretas`Private`APAristasSS, {
                    Part[VilCretas`Private`APrimT, VilCretas`Private`APrimAi], 
                    Part[VilCretas`Private`APArista, 2]}] == False], 
                    VilCretas`Private`APPos1 = 
                    Position[VilCretas`Private`APrimT, 
                    Part[VilCretas`Private`APArista, 2]]; 
                    VilCretas`Private`APPos1Ext = 
                    Part[VilCretas`Private`APPos1, 1, 1]; 
                    VilCretas`Private`APAristasS = 
                    Append[VilCretas`Private`APAristasS, {{
                    Part[VilCretas`Private`APArista, 2], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]}, 
                    Part[
                    VilCretas`Private`APrimMP, VilCretas`Private`APPos1Ext, 
                    VilCretas`Private`APrimAi]}]; 
                    VilCretas`Private`APAristasSS = 
                    Append[VilCretas`Private`APAristasSS, {
                    Part[VilCretas`Private`APArista, 2], 
                    Part[
                    VilCretas`Private`APrimT, VilCretas`Private`APrimAi]}]]; 
                    Increment[VilCretas`Private`APrimAi]], 
                  VilCretas`Private`APAristasS = 
                   Delete[VilCretas`Private`APAristasS, 
                    VilCretas`Private`APPosPesoMin]; 
                  VilCretas`Private`APAristasSS = 
                   Delete[VilCretas`Private`APAristasSS, 
                    VilCretas`Private`APPosPesoMin]]]; {
                Table[{
                  If[
                   MemberQ[
                    VertexList[VilCretas`Private`AAGrafo], 
                    Part[VilCretas`Private`APAi, 1]], 
                   Part[VilCretas`Private`APAi, 1], 
                   ToExpression[
                    Part[VilCretas`Private`APAi, 1]]], 
                  If[
                   MemberQ[
                    VertexList[VilCretas`Private`AAGrafo], 
                    Part[VilCretas`Private`APAi, 2]], 
                   Part[VilCretas`Private`APAi, 2], 
                   ToExpression[
                    Part[VilCretas`Private`APAi, 2]]]}, {
                 VilCretas`Private`APAi, 
                  ReplaceAll[
                   VilCretas`AristasWolframSystemToCombinatorica[
                   VilCretas`Private`APAristasArbol], 
                   Map[Reverse, VilCretas`Private`APReglas]]}], 
                VilCretas`Private`APPeso}]]; If[
           VilCretas`GrafoQ[VilCretas`Private`AGrafo], 
           If[
            VilCretas`GrafoConexoQ[VilCretas`Private`AGrafo], 
            If[
             Not[
              VilCretas`GrafoDirigidoQ[VilCretas`Private`AGrafo]], 
             If[
              VilCretas`GrafoPonderadoQ[VilCretas`Private`AGrafo], 
              If[
               VectorQ[VilCretas`Private`AAOrden], 
               If[ToString[
                  Sort[VilCretas`Private`AAOrden]] == ToString[
                  Sort[
                   VertexList[VilCretas`Private`AGrafo]]], 
                If[
                 VilCretas`MBooleanQ[
                  Normal[
                   AdjacencyMatrix[VilCretas`Private`AGrafo]]], 
                 VilCretas`Private`AlgoritmoPrim[
                 VilCretas`Private`AGrafo, VilCretas`Private`AAOrden]]]]]]]]]; 
      VilCretas`Private`OKruskal[
         Pattern[VilCretas`Private`AGrafo, 
          Blank[]]] := If[
         VilCretas`GrafoQ[VilCretas`Private`AGrafo], 
         If[
          VilCretas`GrafoConexoQ[VilCretas`Private`AGrafo], 
          If[
           Not[
            VilCretas`GrafoDirigidoQ[VilCretas`Private`AGrafo]], 
           If[
            VilCretas`GrafoPonderadoQ[VilCretas`Private`AGrafo], 
            If[
             VilCretas`MBooleanQ[
              Normal[
               AdjacencyMatrix[VilCretas`Private`AGrafo]]], 
             
             Module[{VilCretas`Private`AKAristasArbol = {}, 
               VilCretas`Private`AKPesoMinimo = 0, 
               VilCretas`Private`AKLadosPesos, VilCretas`Private`AKruskalAi, 
               VilCretas`Private`AKPesos, VilCretas`Private`AKAristas, 
               VilCretas`Private`AKMinimo, VilCretas`Private`AKPos1, 
               VilCretas`Private`AKPos2, VilCretas`Private`AKOAristas, 
               VilCretas`Private`AKArista}, 
              VilCretas`Private`AKLadosPesos = 
               VilCretas`PesosAristas[VilCretas`Private`AGrafo]; 
              VilCretas`Private`AKPesos = Select[
                 Flatten[VilCretas`Private`AKLadosPesos], 
                 EdgeQ[VilCretas`Private`AGrafo, #] == False& ]; 
              VilCretas`Private`AKAristas = Select[
                 Flatten[VilCretas`Private`AKLadosPesos], EdgeQ[
                 VilCretas`Private`AGrafo, #]& ]; 
              VilCretas`Private`AKruskalAi = 1; 
              While[VilCretas`Private`AKruskalAi <= 
                VertexCount[VilCretas`Private`AGrafo] - 1, 
                VilCretas`Private`AKMinimo = Min[VilCretas`Private`AKPesos]; 
                VilCretas`Private`AKPos1 = 
                 Position[
                  VilCretas`Private`AKPesos, VilCretas`Private`AKMinimo]; 
                VilCretas`Private`AKPos2 = Flatten[
                   Position[
                   VilCretas`Private`AKPesos, VilCretas`Private`AKMinimo]]; 
                VilCretas`Private`AKOAristas = 
                 Part[VilCretas`Private`AKAristas, VilCretas`Private`AKPos2]; 
                VilCretas`Private`AKOAristas = 
                 Select[VilCretas`Private`AKOAristas, AcyclicGraphQ[
                    Graph[
                    Append[VilCretas`Private`AKAristasArbol, #]]]& ]; 
                If[ToString[VilCretas`Private`AKOAristas] != ToString[{}], 
                  VilCretas`Private`AKArista = 
                   RandomChoice[VilCretas`Private`AKOAristas]; 
                  VilCretas`Private`AKPos1 = Part[
                    Position[
                    VilCretas`Private`AKAristas, VilCretas`Private`AKArista], 
                    1, 1]; VilCretas`Private`AKAristasArbol = 
                   Append[VilCretas`Private`AKAristasArbol, 
                    VilCretas`Private`AKArista]; 
                  VilCretas`Private`AKPesoMinimo = 
                   VilCretas`Private`AKPesoMinimo + 
                    Part[VilCretas`Private`AKLadosPesos, 
                    VilCretas`Private`AKPos1, 2]; 
                  VilCretas`Private`AKLadosPesos = 
                   Delete[VilCretas`Private`AKLadosPesos, 
                    VilCretas`Private`AKPos1]; 
                  VilCretas`Private`AKAristas = 
                   Delete[VilCretas`Private`AKAristas, 
                    VilCretas`Private`AKPos1]; 
                  VilCretas`Private`AKPesos = 
                   Delete[VilCretas`Private`AKPesos, 
                    VilCretas`Private`AKPos1]; 
                  Increment[VilCretas`Private`AKruskalAi], 
                  VilCretas`Private`AKLadosPesos = 
                   Delete[
                    VilCretas`Private`AKLadosPesos, VilCretas`Private`AKPos1]; 
                  VilCretas`Private`AKAristas = 
                   Delete[VilCretas`Private`AKAristas, 
                    VilCretas`Private`AKPos1]; 
                  VilCretas`Private`AKPesos = 
                   Delete[VilCretas`Private`AKPesos, 
                    VilCretas`Private`AKPos1]]]; {
                Part[
                 Map[
                 VilCretas`AristasWolframSystemToCombinatorica, {
                  VilCretas`Private`AKAristasArbol}], 1], 
                VilCretas`Private`AKPesoMinimo}]]]]]]); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Print",
 CellChangeTimes->{
  3.6792484662666264`*^9, {3.679663245397582*^9, 3.679663255037653*^9}}]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Conclusiones", "Section",
 CellChangeTimes->{{3.672324005547202*^9, 3.6723240090386314`*^9}, 
   3.673401049422349*^9, {3.679055828878024*^9, 3.6790558309493465`*^9}, {
   3.6792417903834777`*^9, 3.679241791300763*^9}}],

Cell[CellGroupData[{

Cell["\<\
El paquete VilCretas personaliza un esfuerzo docente con miras a sistematizar \
una metodolog\[IAcute]a asistida por computadora.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6790558602836914`*^9, 3.6790558617941294`*^9}, 
   3.6790564311464396`*^9, {3.6792416144652185`*^9, 3.6792416355610247`*^9}}],

Cell["\<\
Dota al software Mathematica de una serie de nuevos comandos con fines did\
\[AAcute]cticos.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6790558602836914`*^9, 3.6790558617941294`*^9}, 
   3.6790564311464396`*^9, {3.6792416144652185`*^9, 3.6792416333205633`*^9}}],

Cell["\<\
Constituye un recurso disponible para otras instituciones educativas a nivel \
de toda Latinoam\[EAcute]rica.\
\>", "ItemNumbered",
 CellChangeTimes->{{3.6790558602836914`*^9, 3.67905590052875*^9}, 
   3.679056434651969*^9, {3.679241637799842*^9, 3.679241643867078*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Website y posibilidades de descarga", "Section",
 CellChangeTimes->{{3.6723240736853256`*^9, 3.672324080456191*^9}, {
  3.673401070878688*^9, 3.673401072949069*^9}, {3.6790563214684114`*^9, 
  3.679056323828266*^9}, {3.6792416718873463`*^9, 3.679241679278043*^9}, {
  3.679664671726968*^9, 3.679664672233985*^9}, {3.679665591275687*^9, 
  3.6796655915824604`*^9}, {3.6796658884094048`*^9, 3.6796658888827524`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Estructuras discretas con Mathematica: ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.escinf.una.ac.cr/discretas/"], None},
  ButtonNote->"http://www.escinf.una.ac.cr/discretas/"],
 "http://www.escinf.una.ac.cr/discretas/"
}], "ItemNumbered",
 CellChangeTimes->{{3.672324034964075*^9, 3.672324066549564*^9}, {
  3.672324114010763*^9, 3.6723241376445875`*^9}, {3.6790563310392075`*^9, 
  3.6790563761223783`*^9}, {3.6790567619764805`*^9, 3.679056780251313*^9}}],

Cell["Email: enrique.vilchez.quesada@una.cr", "ItemNumbered",
 CellChangeTimes->{{3.672324034964075*^9, 3.672324066549564*^9}, {
  3.672324114010763*^9, 3.6723241376445875`*^9}, {3.6790563310392075`*^9, 
  3.679056388362957*^9}}]
}, Open  ]],

Cell["\[DownExclamation]Muchas gracias por la atenci\[OAcute]n brindada!", \
"Text",
 CellChangeTimes->{
  3.679056668985691*^9, {3.6790567275463643`*^9, 3.6790567387052307`*^9}, {
   3.6792416516172886`*^9, 3.6792416664659777`*^9}},
 TextAlignment->Center,
 FontSize->36,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]
}, Open  ]]
}, Open  ]]
},
ScreenStyleEnvironment->"SlideShow",
WindowToolbars->"EditBar",
WindowSize->{1600, 817},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
TaggingRules->{"SlideShow" -> True},
Magnification:>1.25 Inherited,
FrontEndVersion->"10.4 para Microsoft Windows (64-bit) (April 11, 2016)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell["Style Environment Names", "Section"], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Presentation"], MenuSortingValue -> None], 
      Cell[
       StyleData[All, "Condensed"], MenuSortingValue -> None], 
      Cell[
       StyleData[All, "SlideShow"]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Notebook Options Settings", "Section"], 
      Cell[
       StyleData["Notebook"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.739193, 0.750317, 0.747173]}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Title and Section Cells", "Section"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], ShowCellBracket -> Automatic, ShowGroupOpener -> 
          False, CellMargins -> {{100, 100}, {14, 50}}, 
          CellGroupingRules -> {"TitleGrouping", 0}, PageBreakBelow -> False, 
          CellFrameMargins -> {{20, 20}, {20, 20}}, DefaultNewInlineCellStyle -> 
          "None", InputAutoReplacements -> {"TeX" -> StyleBox[
              RowBox[{"T", 
                AdjustmentBox[
                "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                 BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
              RowBox[{"L", 
                StyleBox[
                 AdjustmentBox[
                 "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                AdjustmentBox[
                "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                 BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
            "Mma" -> "Mathematica", "MMA" -> "Mathematica", "gridMathematica" -> 
            FormBox[
              RowBox[{"grid", 
                AdjustmentBox[
                 StyleBox["Mathematica", FontSlant -> "Italic"], 
                 BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
            "webMathematica" -> FormBox[
              RowBox[{"web", 
                AdjustmentBox[
                 StyleBox["Mathematica", FontSlant -> "Italic"], 
                 BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
            Inherited}, TextAlignment -> Center, LineSpacing -> {1, 0}, 
          LanguageCategory -> "NaturalLanguage", CounterIncrements -> "Title",
           CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {
            "Figure", 0}, {"Subtitle", 0}, {"Subsubtitle", 0}}, FontFamily -> 
          "Arial", FontSize -> 45, FontWeight -> "Bold", FontSlant -> "Plain",
           FontTracking -> "Plain", 
          FontVariations -> {
           "Masked" -> False, "Outline" -> False, "Shadow" -> False, 
            "StrikeThrough" -> False, "Underline" -> False}, FontColor -> 
          RGBColor[
           0.8156862745098039, 0.07058823529411765, 0.07058823529411765], 
          Background -> None], 
         Cell[
          StyleData["Title", "Presentation", StyleDefinitions -> None], 
          CellMargins -> {{55, 3}, {14, 125}}, LineSpacing -> {1, 5}, 
          FontSize -> 48], 
         Cell[
          StyleData[
          "Title", "SlideShow", StyleDefinitions -> 
           StyleData["Title", "Presentation"]], 
          CellMargins -> {{100, 100}, {52, 105}}, FontColor -> GrayLevel[1]], 
         
         Cell[
          StyleData["Title", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{2, 0}, {0, 20}}, FontSize -> 24]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subtitle"], ShowCellBracket -> Automatic, 
          CellMargins -> {{0, 0}, {0, 5}}, 
          CellGroupingRules -> {"TitleGrouping", 10}, PageBreakBelow -> False,
           DefaultNewInlineCellStyle -> "None", 
          InputAutoReplacements -> {"TeX" -> StyleBox[
              RowBox[{"T", 
                AdjustmentBox[
                "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                 BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
              RowBox[{"L", 
                StyleBox[
                 AdjustmentBox[
                 "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                AdjustmentBox[
                "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                 BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
            "Mma" -> "Mathematica", "MMA" -> "Mathematica", "gridMathematica" -> 
            FormBox[
              RowBox[{"grid", 
                AdjustmentBox[
                 StyleBox["Mathematica", FontSlant -> "Italic"], 
                 BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
            "webMathematica" -> FormBox[
              RowBox[{"web", 
                AdjustmentBox[
                 StyleBox["Mathematica", FontSlant -> "Italic"], 
                 BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
            Inherited}, TextAlignment -> Center, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "Subtitle", 
          CounterAssignments -> {{"Section", 0}, {"Equation", 0}, {
            "Figure", 0}, {"Subsubtitle", 0}}, FontFamily -> "Arial", 
          FontSize -> 27, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> RGBColor[0.4, 0.4, 0.4], Background -> None], 
         Cell[
          StyleData["Subtitle", "Presentation", StyleDefinitions -> None], 
          CellMargins -> {{58, 0}, {0, 5}}, FontSize -> 36], 
         Cell[
          StyleData[
          "Subtitle", "SlideShow", StyleDefinitions -> StyleData["Subtitle"]],
           CellMargins -> {{0, 0}, {0, 5}}, FontSize -> 27, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.9019607843137255, 0.9019607843137255]], 
         Cell[
          StyleData["Subtitle", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{2, 0}, {0, 5}}, FontSize -> 18, Background -> 
          GrayLevel[1]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubtitle", StyleDefinitions -> StyleData["Subtitle"]],
           CellMargins -> {{0, 0}, {30, 5}}, FontSize -> 24, FontSlant -> 
          "Plain", FontColor -> RGBColor[0.4, 0.4, 0.4]], 
         Cell[
          StyleData["Subsubtitle", "Presentation"], FontSize -> 24], 
         Cell[
          StyleData[
          "Subsubtitle", "SlideShow", StyleDefinitions -> 
           StyleData["Subsubtitle"]], CellMargins -> {{0, 0}, {10, 5}}, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.9019607843137255, 0.9019607843137255]], 
         Cell[
          StyleData["Subsubtitle", "Printout"], FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0.2, 0}}, 
          ShowGroupOpener -> False, CellMargins -> {{60, 50}, {7, 25}}, 
          FontSize -> 36, FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.8156862745098039, 0.07058823529411765, 0.07058823529411765]], 
         Cell[
          StyleData["Section", "Presentation"], 
          CellFrame -> {{0, 0}, {0.2, 0}}, 
          CellMargins -> {{58, 50}, {7, 35}}], 
         Cell[
          StyleData[
          "Section", "SlideShow", StyleDefinitions -> 
           StyleData["Section", "Presentation"]], 
          CellMargins -> {{58, 50}, {10, 35}}], 
         Cell[
          StyleData["Section", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{2, 0}, {4, 22}}, FontSize -> 20]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellDingbat -> None, ShowGroupOpener -> 
          False, CellMargins -> {{60, Inherited}, {0, 15}}, 
          CellGroupingRules -> {"SectionGrouping", 40}, PageBreakBelow -> 
          False, DefaultNewInlineCellStyle -> "None", 
          InputAutoReplacements -> {"TeX" -> StyleBox[
              RowBox[{"T", 
                AdjustmentBox[
                "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                 BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
              RowBox[{"L", 
                StyleBox[
                 AdjustmentBox[
                 "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                AdjustmentBox[
                "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                 BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
            "Mma" -> "Mathematica", "MMA" -> "Mathematica", "gridMathematica" -> 
            FormBox[
              RowBox[{"grid", 
                AdjustmentBox[
                 StyleBox["Mathematica", FontSlant -> "Italic"], 
                 BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
            "webMathematica" -> FormBox[
              RowBox[{"web", 
                AdjustmentBox[
                 StyleBox["Mathematica", FontSlant -> "Italic"], 
                 BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
            Inherited}, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsection", 
          CounterAssignments -> {{"Subsubsection", 0}}, FontFamily -> 
          "Helvetica", FontSize -> 24, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> RGBColor[0.4, 0.4, 0.4]], 
         Cell[
          StyleData["Subsection", "Presentation"], ShowGroupOpener -> True, 
          WholeCellGroupOpener -> True, CellMargins -> {{60, 50}, {0, 20}}, 
          LineSpacing -> {1, 0}, FontFamily -> "Helvetica"], 
         Cell[
          StyleData["Subsection", "SlideShow"], ShowGroupOpener -> True, 
          WholeCellGroupOpener -> True, CellMargins -> {{60, 50}, {8, 12}}, 
          LineSpacing -> {1, 0}, FontFamily -> "Helvetica"], 
         Cell[
          StyleData["Subsection", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{2, 0}, {0, 17}}, FontSize -> 16]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], CellDingbat -> None, ShowGroupOpener -> 
          False, CellMargins -> {{60, Inherited}, {0, 15}}, 
          CellGroupingRules -> {"SectionGrouping", 50}, PageBreakBelow -> 
          False, DefaultNewInlineCellStyle -> "None", 
          InputAutoReplacements -> {"TeX" -> StyleBox[
              RowBox[{"T", 
                AdjustmentBox[
                "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                 BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
              RowBox[{"L", 
                StyleBox[
                 AdjustmentBox[
                 "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                AdjustmentBox[
                "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                 BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
            "Mma" -> "Mathematica", "MMA" -> "Mathematica", "gridMathematica" -> 
            FormBox[
              RowBox[{"grid", 
                AdjustmentBox[
                 StyleBox["Mathematica", FontSlant -> "Italic"], 
                 BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
            "webMathematica" -> FormBox[
              RowBox[{"web", 
                AdjustmentBox[
                 StyleBox["Mathematica", FontSlant -> "Italic"], 
                 BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
            Inherited}, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsection", FontFamily -> "Helvetica", 
          FontSize -> 20, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> RGBColor[0.4, 0.4, 0.4]], 
         Cell[
          StyleData["Subsubsection", "Presentation"], ShowGroupOpener -> True,
           WholeCellGroupOpener -> True, CellMargins -> {{60, 50}, {0, 20}}, 
          LineSpacing -> {1, 0}], 
         Cell[
          StyleData[
          "Subsubsection", "SlideShow", StyleDefinitions -> 
           StyleData["Subsubsection", "Presentation"]]], 
         Cell[
          StyleData["Subsubsection", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{2, 0}, {0, 22}}, FontSize -> 14]}, Closed]]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Body Text", "Section"], 
      Cell[
       CellGroupData[{
         Cell["Standard", "Subsection"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Text"], CellMargins -> {{60, 10}, {7, 7}}, 
             InputAutoReplacements -> {"TeX" -> StyleBox[
                 RowBox[{"T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "LaTeX" -> StyleBox[
                 RowBox[{"L", 
                   StyleBox[
                    AdjustmentBox[
                    "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, 
                    BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
                   AdjustmentBox[
                   "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, 
                    BoxBaselineShift -> 0.5], "X"}]], "mma" -> "Mathematica", 
               "Mma" -> "Mathematica", "MMA" -> "Mathematica", 
               "gridMathematica" -> FormBox[
                 RowBox[{"grid", 
                   AdjustmentBox[
                    StyleBox["Mathematica", FontSlant -> "Italic"], 
                    BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
               "webMathematica" -> FormBox[
                 RowBox[{"web", 
                   AdjustmentBox[
                    StyleBox["Mathematica", FontSlant -> "Italic"], 
                    BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
               Inherited}, LineSpacing -> {1, 3}, CounterIncrements -> "Text",
              FontFamily -> "Helvetica", FontSize -> 12], 
            Cell[
             StyleData["Text", "Presentation"], 
             CellMargins -> {{60, 50}, {10, 10}}, FontSize -> 17], 
            Cell[
             StyleData[
             "Text", "SlideShow", StyleDefinitions -> 
              StyleData["Text", "Presentation"]]], 
            Cell[
             StyleData["Text", "Printout"], CellMargins -> {{2, 2}, {6, 6}}, 
             TextJustification -> 0.5, Hyphenation -> True, FontSize -> 10]}, 
           Closed]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Display", "Subsection"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Item", StyleDefinitions -> StyleData["Text"]], 
             CellDingbat -> 
             Cell["\[FilledSmallCircle]", FontWeight -> "Bold"], 
             ShowGroupOpener -> False, CellMargins -> {{84, 10}, {7, 7}}, 
             ReturnCreatesNewCell -> True, 
             CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
             CounterIncrements -> "Item"], 
            Cell[
             StyleData["Item", "Presentation"], 
             CellMargins -> {{124, 10}, {7, 7}}], 
            Cell[
             StyleData[
             "Item", "SlideShow", StyleDefinitions -> 
              StyleData["Item", "Presentation"]]], 
            Cell[
             StyleData["Item", "Printout"], 
             CellMargins -> {{39, 2}, {0, 6}}]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Subitem", StyleDefinitions -> StyleData["Item"]], 
             CellMargins -> {{108, 10}, {7, 7}}, ReturnCreatesNewCell -> True,
              CellGroupingRules -> {"GroupTogetherNestedGrouping", 15150}, 
             CounterIncrements -> "Subitem"], 
            Cell[
             StyleData["Subitem", "Presentation"], 
             CellMargins -> {{146, 10}, {7, 7}}], 
            Cell[
             StyleData[
             "Subitem", "SlideShow", StyleDefinitions -> 
              StyleData["Subitem", "Presentation"]]], 
            Cell[
             StyleData["Subitem", "Printout"], 
             CellMargins -> {{67, 2}, {0, 6}}]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ItemNumbered", StyleDefinitions -> StyleData["Text"]],
              CellDingbat -> Cell[
               TextData[{
                 CounterBox["ItemNumbered"], "."}]], ShowGroupOpener -> False,
              CellMargins -> {{84, 10}, {7, 7}}, ReturnCreatesNewCell -> True,
              CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
             CounterIncrements -> "ItemNumbered"], 
            Cell[
             StyleData["ItemNumbered", "Presentation"], 
             CellMargins -> {{124, 10}, {7, 7}}], 
            Cell[
             StyleData[
             "ItemNumbered", "SlideShow", StyleDefinitions -> 
              StyleData["ItemNumbered", "Presentation"]]], 
            Cell[
             StyleData["ItemNumbered", "Printout"], 
             CellMargins -> {{39, 2}, {0, 6}}]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData[
             "SubitemNumbered", StyleDefinitions -> 
              StyleData["ItemNumbered"]], CellDingbat -> Cell[
               TextData[{
                 CounterBox["SubitemNumbered", CounterFunction :> (Part[
                    CharacterRange["a", "z"], #]& )], "."}]], 
             CellMargins -> {{108, 10}, {7, 7}}, ReturnCreatesNewCell -> True,
              CellGroupingRules -> {"GroupTogetherNestedGrouping", 15150}, 
             CounterIncrements -> "SubitemNumbered"], 
            Cell[
             StyleData["SubitemNumbered", "Presentation"], 
             CellMargins -> {{146, 10}, {7, 7}}], 
            Cell[
             StyleData[
             "SubitemNumbered", "SlideShow", StyleDefinitions -> 
              StyleData["SubitemNumbered", "Presentation"]]], 
            Cell[
             StyleData["SubitemNumbered", "Printout"], 
             CellMargins -> {{67, 2}, {0, 6}}]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData[
             "ItemParagraph", StyleDefinitions -> StyleData["Item"]], 
             CellDingbat -> None, CellMargins -> {{84, 10}, {7, 7}}, 
             ReturnCreatesNewCell -> True, 
             CellGroupingRules -> {"GroupTogetherNestedGrouping", 15100}, 
             CounterIncrements -> "ItemParagraph"], 
            Cell[
             StyleData["ItemParagraph", "Presentation"], 
             CellMargins -> {{124, 10}, {7, 7}}], 
            Cell[
             StyleData[
             "ItemParagraph", "SlideShow", StyleDefinitions -> 
              StyleData["ItemParagraph", "Presentation"]]], 
            Cell[
             StyleData["ItemParagraph", "Printout"], 
             CellMargins -> {{39, 2}, {0, 6}}]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData[
             "SubitemParagraph", StyleDefinitions -> StyleData["Subitem"]], 
             CellDingbat -> None, ReturnCreatesNewCell -> True, 
             CellGroupingRules -> {"GroupTogetherNestedGrouping", 15200}, 
             CounterIncrements -> "SubitemParagraph"], 
            Cell[
             StyleData["SubitemParagraph", "Presentation"]], 
            Cell[
             StyleData[
             "SubitemParagraph", "SlideShow", StyleDefinitions -> 
              StyleData["SubitemParagraph", "Presentation"]]], 
            Cell[
             StyleData["SubitemParagraph", "Printout"]]}, Closed]]}, Open]]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Formulas and Programming", "Section"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"]], 
         Cell[
          StyleData["DisplayFormula", "Presentation"], 
          CellMargins -> {{60, Inherited}, {Inherited 1.5, Inherited 1.5}}, 
          FontSize -> 17], 
         Cell[
          StyleData[
          "DisplayFormula", "SlideShow", StyleDefinitions -> 
           StyleData["DisplayFormula", "Presentation"]]], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{39, Inherited}, {Inherited, Inherited}}, FontSize -> 
          10]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}]]}, {None, None}}, 
          CounterIncrements -> "DisplayFormulaNumbered"], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Presentation"], 
          CellMargins -> {{60, Inherited}, {Inherited 1.5, Inherited 1.5}}, 
          FontSize -> 17], 
         Cell[
          StyleData[
          "DisplayFormulaNumbered", "SlideShow", StyleDefinitions -> 
           StyleData["DisplayFormulaNumbered", "Presentation"]]], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{39, Inherited}, {Inherited, Inherited}}]}, 
        Closed]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Inline Formatting", "Section"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InlineFormula"]], 
         Cell[
          StyleData["InlineFormula", "Presentation"], FontSize -> 17], 
         Cell[
          StyleData[
          "InlineFormula", "SlideShow", StyleDefinitions -> 
           StyleData["InlineFormula", "Presentation"]]], 
         Cell[
          StyleData["InlineFormula", "Printout"]]}, Closed]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Input and Output Cells", "Section"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], ShowCellBracket -> True, ShowGroupOpener -> 
          False, CellMargins -> {{103, 10}, {5, 7}}, 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.734936, 0.713848, 0.694041]}, Evaluatable -> 
          True, CellGroupingRules -> "InputGrouping", CellHorizontalScrolling -> 
          True, PageBreakWithin -> False, GroupPageBreakWithin -> False, 
          DefaultFormatType -> DefaultInputFormatType, 
          "TwoByteSyntaxCharacterAutoReplacement" -> True, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, LanguageCategory -> "Mathematica", 
          FormatType -> InputForm, ShowStringCharacters -> True, NumberMarks -> 
          True, LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
          CounterIncrements -> "Input", FontWeight -> "Bold"], 
         Cell[
          StyleData["Input", "Presentation"], 
          CellMargins -> {{110, 50}, {8, 10}}, LineSpacing -> {1, 0}, 
          FontSize -> 17], 
         Cell[
          StyleData[
          "Input", "SlideShow", StyleDefinitions -> 
           StyleData["Input", "Presentation"]]], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{39, 0}, {4, 6}}, 
          LinebreakAdjustments -> {0.85, 2, 10, 1, 1}, FontSize -> 9]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], ShowCellBracket -> True, ShowGroupOpener -> 
          False, CellMargins -> {{103, 10}, {7, 7}}, 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.734936, 0.713848, 0.694041]}, Evaluatable -> 
          True, CellGroupingRules -> "InputGrouping", CellHorizontalScrolling -> 
          True, DefaultFormatType -> DefaultInputFormatType, 
          "TwoByteSyntaxCharacterAutoReplacement" -> True, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, LanguageCategory -> "Mathematica", 
          FormatType -> InputForm, ShowStringCharacters -> True, NumberMarks -> 
          True, LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
          CounterIncrements -> "Input", MenuSortingValue -> 1550, FontWeight -> 
          "Bold"], 
         Cell[
          StyleData["InputOnly", "Presentation"], 
          CellMargins -> {{110, Inherited}, {8, 10}}, LineSpacing -> {1, 0}, 
          FontSize -> 17], 
         Cell[
          StyleData[
          "InputOnly", "SlideShow", StyleDefinitions -> 
           StyleData["InputOnly", "Presentation"]]], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{39, 0}, {4, 6}}, 
          LinebreakAdjustments -> {0.85, 2, 10, 1, 1}, FontSize -> 9]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], ShowCellBracket -> True, 
          CellMargins -> {{103, 10}, {7, 5}}, 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.734936, 0.713848, 0.694041]}, 
          CellEditDuplicate -> True, CellGroupingRules -> "OutputGrouping", 
          CellHorizontalScrolling -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, DefaultFormatType -> 
          DefaultOutputFormatType, "TwoByteSyntaxCharacterAutoReplacement" -> 
          True, HyphenationOptions -> {
           "HyphenationCharacter" -> "\[Continuation]"}, 
          AutoItalicWords -> {}, LanguageCategory -> None, FormatType -> 
          InputForm, CounterIncrements -> "Output"], 
         Cell[
          StyleData["Output", "Presentation"], 
          CellMargins -> {{110, 50}, {10, 8}}, LineSpacing -> {1, 0}, 
          FontSize -> 17], 
         Cell[
          StyleData[
          "Output", "SlideShow", StyleDefinitions -> 
           StyleData["Output", "Presentation"]]], 
         Cell[
          StyleData["Output", "Printout"], CellMargins -> {{39, 0}, {6, 4}}, 
          FontSize -> 9]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Code"], CellMargins -> {{103, 10}, {5, 10}}], 
         Cell[
          StyleData["Code", "Presentation"], 
          CellMargins -> {{110, 50}, {8, 10}}, LineSpacing -> {1, 0}, 
          FontSize -> 17], 
         Cell[
          StyleData[
          "Code", "SlideShow", StyleDefinitions -> 
           StyleData["Code", "Presentation"]]], 
         Cell[
          StyleData["Code", "Printout"], CellMargins -> {{39, 0}, {4, 6}}, 
          LinebreakAdjustments -> {0.85, 2, 10, 1, 1}, FontSize -> 9]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], 
          CellMargins -> {{103, Inherited}, {Inherited, Inherited}}, FontSize -> 
          14], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{70, Inherited}, {Inherited 1.5, Inherited 1.5}}, 
          FontSize -> 17, Magnification -> Inherited 1.5], 
         Cell[
          StyleData[
          "Print", "SlideShow", StyleDefinitions -> 
           StyleData["Print", "Presentation"]]], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{39, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "WolframAlphaShortInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{98, 10}, {5, 7}}, EvaluationMode -> 
          "WolframAlphaShort", 
          CellEventActions -> {"ReturnKeyDown" :> FrontEndTokenExecute[
              EvaluationNotebook[], "HandleShiftReturn"]}, 
          CellFrameLabels -> {{
             Cell[
              BoxData[
               DynamicBox[
                FEPrivate`FrontEndResource["WABitmaps", "Equal"]]], 
              CellBaseline -> Baseline], None}, {None, None}}, FormatType -> 
          TextForm, FontFamily -> "Helvetica"], 
         Cell[
          StyleData["WolframAlphaShortInput", "Presentation"], 
          CellMargins -> {{107, 50}, {8, 10}}], 
         Cell[
          StyleData[
          "WolframAlphaShortInput", "SlideShow", StyleDefinitions -> 
           StyleData["WolframAlphaShortInput", "Presentation"]]], 
         Cell[
          StyleData["WolframAlphaShortInput", "Printout"], 
          CellFrameLabelMargins -> 3]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "WolframAlphaLong", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{100, 10}, {5, 7}}, 
          StyleKeyMapping -> {
           "=" -> "Input", "Backspace" -> "WolframAlphaShort"}, 
          EvaluationMode -> "WolframAlphaLong", 
          CellEventActions -> {"ReturnKeyDown" :> FrontEndTokenExecute[
              EvaluationNotebook[], "HandleShiftReturn"]}, 
          CellFrameLabels -> {{
             Cell[
              BoxData[
               DynamicBox[
                FEPrivate`FrontEndResource["WABitmaps", "SpikeyEqual"]]]], 
             None}, {None, None}}, DefaultFormatType -> TextForm, FormatType -> 
          TextForm, FontFamily -> "Helvetica"], 
         Cell[
          StyleData["WolframAlphaLong", "Presentation"], 
          CellMargins -> {{107, 50}, {8, 10}}], 
         Cell[
          StyleData[
          "WolframAlphaLong", "SlideShow", StyleDefinitions -> 
           StyleData["WolframAlphaLong", "Presentation"]], 
          CellMargins -> {{107, 50}, {8, 10}}], 
         Cell[
          StyleData["WolframAlphaLong", "Printout"], CellFrameLabelMargins -> 
          3]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Program"], CellMargins -> {{60, 4}, {6, 8}}], 
         Cell[
          StyleData["Program", "Presentation"], 
          CellMargins -> {{60, 50}, {8, 10}}, LineSpacing -> {1, 0}, FontSize -> 
          17], 
         Cell[
          StyleData[
          "Program", "SlideShow", StyleDefinitions -> 
           StyleData["Program", "Presentation"]]], 
         Cell[
          StyleData["Program", "Printout"], CellMargins -> {{2, 0}, {0, 8}}, 
          FontSize -> 10]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"]], 
         Cell[
          StyleData["CellLabel", "Presentation"], FontSize -> 12], 
         Cell[
          StyleData[
          "CellLabel", "SlideShow", StyleDefinitions -> 
           StyleData["CellLabel", "Presentation"]]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ManipulateLabel"]], 
         Cell[
          StyleData["ManipulateLabel", "Presentation"], FontSize -> 15], 
         Cell[
          StyleData[
          "ManipulateLabel", "SlideShow", StyleDefinitions -> 
           StyleData["ManipulateLabel", "Presentation"]]], 
         Cell[
          StyleData["ManipulateLabel", "Printout"], FontSize -> 8]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GraphicsLabel"]], 
         Cell[
          StyleData["GraphicsLabel", "Presentation"], FontSize -> 14], 
         Cell[
          StyleData[
          "GraphicsLabel", "SlideShow", StyleDefinitions -> 
           StyleData["GraphicsLabel", "Presentation"]]], 
         Cell[
          StyleData["GraphicsLabel", "Printout"], FontSize -> 8]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Graphics3DLabel"]], 
         Cell[
          StyleData["Graphics3DLabel", "Presentation"], FontSize -> 14], 
         Cell[
          StyleData[
          "Graphics3DLabel", "SlideShow", StyleDefinitions -> 
           StyleData["Graphics3DLabel", "Presentation"]]], 
         Cell[
          StyleData["Graphics3DLabel", "Printout"], FontSize -> 8]}, 
        Closed]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Styles for SlideShow", "Section", 
       CellChangeTimes -> {{3.514665148412793*^9, 3.5146651505550737`*^9}}], 
      Cell[
       StyleData["slideshowheader"], ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -2}}, Evaluatable -> False, 
       CellHorizontalScrolling -> False, PageBreakBelow -> False, 
       CellFrameMargins -> 0, ImageMargins -> {{0, 0}, {0, 0}}, 
       ImageRegion -> {{0, 1}, {0, 1}}, Magnification -> 1, Background -> 
       GrayLevel[1], CellPadding -> 0, CellFramePadding -> 0], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["hidefromslideshowgraphic"], ShowCellBracket -> False, 
          CellMargins -> {{0, 0}, {0, 0}}, Evaluatable -> False, 
          CellHorizontalScrolling -> False, PageBreakBelow -> False, 
          CellFrameMargins -> 0, ImageMargins -> {{0, 0}, {0, 0}}, 
          ImageRegion -> {{0, 1}, {0, 1}}, Magnification -> 1, Background -> 
          None, CellPadding -> 0], 
         Cell[
          StyleData["hidefromslideshowgraphic", "SlideShow"], ShowCellBracket -> 
          False, CellElementSpacings -> {
           "CellMinHeight" -> 0, "ClosedCellHeight" -> 0, 
            "ClosedGroupTopMargin" -> 0}, CellOpen -> False, 
          CellHorizontalScrolling -> False], 
         Cell[
          StyleData["hidefromslideshowgraphic", "Printout"], Magnification -> 
          0.6]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["slideshowheader2"], ShowCellBracket -> False, 
          CellMargins -> {{0, 0}, {0, 0}}, Evaluatable -> False, 
          CellHorizontalScrolling -> False, PageBreakBelow -> False, 
          ImageMargins -> {{0, 0}, {0, 0}}, ImageRegion -> {{0, 1}, {0, 1}}, 
          Magnification -> 1, Background -> GrayLevel[1]], 
         Cell[
          StyleData["ConferenceGraphicCell", "SlideShow"], ShowCellBracket -> 
          False, CellElementSpacings -> {
           "CellMinHeight" -> 0, "ClosedCellHeight" -> 0, 
            "ClosedGroupTopMargin" -> 0}, CellOpen -> False, 
          CellHorizontalScrolling -> True], 
         Cell[
          StyleData["slideshowheader", "Printout"], FontSize -> 8, 
          Magnification -> 0.75]}, Closed]], 
      Cell[
       StyleData[
       "ConferenceGraphicCellSlideShowOnly", StyleDefinitions -> 
        StyleData["ConferenceCellGraphic"]], ShowCellBracket -> False, 
       CellMargins -> 0, 
       CellElementSpacings -> {
        "CellMinHeight" -> 0, "ClosedCellHeight" -> 0, "ClosedGroupTopMargin" -> 
         0}, CellOpen -> False], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SlideShowNavigationBar"], Editable -> True, Selectable -> 
          False, CellFrame -> 0, ShowGroupOpener -> False, 
          CellMargins -> {{0, 0}, {3, 3}}, CellOpen -> True, CellFrameMargins -> 
          0, CellFrameColor -> None, Background -> None], 
         Cell[
          StyleData["SlideShowNavigationBar", "Printout"], PageBreakAbove -> 
          Automatic]}, Closed]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Styles for Slide Show Environment Documents", "Section", 
       CellChangeTimes -> {{3.559592561220532*^9, 3.559592575768806*^9}, 
         3.559652073182283*^9}], 
      Cell[
       StyleData["FirstSlide"], 
       PrivateCellOptions -> {
        "PagewiseNotebookBaseStyle" -> {
          FrontEnd`BackgroundAppearance -> FrontEnd`CurrentValue[
             FrontEnd`EvaluationNotebook[], {
             FrontEnd`UnknownOptions, presentertemplt`firstslideimage}]}}]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "10.4 para Microsoft Windows (64-bit) (April 11, 2016)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
presentertemplt`firstslideimage -> Image[CompressedData["
1:eJzt3UmudOtVreFDUqBIF5BL0AKqFKkaIcq2MBYVI9lIiF7QEMDkeZ7n0CNz
flmW5eO9IlYykzHmfAuTey+6hR0r9ol4/jHm9+2f+uqvfflXfvSzzz771k98
/j++/JXf+LlvfvMrv/kLP/n5/+MXv/GtX/36N772yz//jV//2te/9s2f/eqP
ff6//K0f+eyzX/r8//+Pf/5//853vvPZp/+DYRiGYRiGeTbfc9Vvf+lnmID5
nS/99OH87pv59pv5vRfz+yfmDz7/+d7NH76ZPzoxf3xy/uTC/OmF+bOL8+c3
5y+C5i+D56+Y1ol+P6N+z+78jl/9b+nTXPlv9ex//2c/U858Pn2ad59zZz4r
z3zmHn1ev/us//aJ74uj75nu70Dmu4OtYsfVVe8+a7pcdeVzuspVeIrpcJaT
sTJ8FW0sfMVkDraKG0VXVWVVZ13lmlWpearbDEfz1wLT/QwqrLXZWPgKXzkM
toqZqa46Y6vOrGqLqbpNoOKmSQZTcZaSsaIzrAhfnTHWE1+dMRa+8hts9Xxw
lb6rOro/V091m6d7HJ3lkGN1ZVgOvnqaX73a8+3+ftw62OrZ4KpZpurOqTCU
5mxyloqxqjtCdV/dza7wVc9gq/sz1VWqWZWyqdQ91W2TqaPsrGpjTciwInx1
xlh3+0F85TPY6t7gKlylbKpuc2wcVWdNMNYmX7F7NWOw1fW5e4fVBldhqh5P
dbvibwSn+5lMc1aWsVw7QnzFvBpsdW0cXeW6WzXFVBMs1e2kCf7aaKzpGRa+
Yo4GW12bjC5wi6u6syp3U2GoOd7CWBq+ijhDiK+YjwZbnR9cpeMqZVNFugpH
6YyDs6qN5ZBh4St81THY6tzgqtwOUC2rmuapbpdMHVVrTTAWvsJXzoOt3k/1
mUBchamwlN9MMRa+mucrbFU/2Or1THPVmc8P5w7QzVRYau64O8vNWFU7WBF3
NOCr+YOtjgdX5blKJavqMNVET/3t57+fatP9TLKsNc1YjhkWvmLeDbY6nsq7
FnCVflalYCr8NMNeW4ylnGFNvZ+B3SuNwVYfD67q6wDVsqptnuo2T/e4OWuS
sab56p2x7toKX+kPtvrhwVXXbOWSVbnkVBhKbxyctc1YER3hmTtmuvtBfOU5
2OoHp/KuBVyl6aqppur2yaRRdha+0vMVu1f7Blt9f3BVj6s2mwpLzRmM5dsR
4it8FT3Y6vsT3QXevRsUVz13VVX/p5RRdduC0XRWlbEcMqzu/St8tWew1XdH
Zccq21Vn/n2m5CrlrErBVN2G+OL8nch0P4dsZ00yFr7i7ODEwVY6rnpnq25X
Ve9WTTHVFE91e2mKvbqdpeirs8bCV7W+6v5udp7ttnLZsZriqu4O0NVUGGqm
uxxzrCkZFr4iu8ocbFWzY9W5u+7kKsWsqqv7w1Ea4+QsRWPhq9q7Gdi90pjN
tprgKoX9KnVXOZkKS3kMxtLIsPAVvlKdrbba4KqK84AdHWB2VjXJU90G2TKq
zlIzFr7S8BW7V/mz0VYqO1bdZwInu8phpwpLzZwJxlLKsPAVu1eOg61w1VVX
TewAnU3VbYnvzd8LTfezyLTWFGPhK3w1ebbZSqELxFX7TDXBU91emmCvLcZS
7gjx1TNfdX+Huwy20tqxwlWarlIwFY6aZS43Y03KsJR9pb571f0d7jLbbaXU
BeKq665SNVWUq3BU/zg4q3IfC1/t8hXZ1b3ZZKvuzKrzroVuVylkVS6mwlHa
o2ysJ85S6AnxFb6aMltshatyzgO6dIAO/R+e8hxFZzlnWJt8Vb17FXnvVfd3
uvpstZXLjhWuwlRYymu2GcuhI9zoK7IrbKXkqju2wlXeruow1URP/YPYdD+P
Cc6alGF1+qrr7CC+wlYKrnLZW59iqk2ecjNUt4umW6zbWkrOmmSsrv2r6H4Q
X2GrK656Zasp+1WdrpqcU3WaCkfN9tZUY3XmWE/3sKb5KjK/4k7R3ba6ekeo
Smbl6qrOvErRVBGuwlJ6o2wsfFWXX23fv8JW2GqLq97ZCld5ZFV4ymswlnZH
iK9yzg6SXe20laOrMnesnrjqna0ie0BMtdtS//iF6f55FKzlYKzJvlI9P6iw
e4WvdtkquwvsOBOIq7RdpWKqbld85KOO6X4GE4yVlWEp+sr1/CDdoPZssJV6
ZtW1Y1XhKpcOsNJUzp7qdpOrvbqN5Zph4St85TqTbIWrcNUGU+Eob3O5Gcsh
w1L31YTdK7rBnbbq7AI7dqy6zgTiqpmm6naN4mCs/AwLX/XtXpFdYau7tpq6
Y7XJVdtNhaW0RtVZ+MrfV87dINnVTFtdyawcukDFuxZUd9azXdXR/2Epj1Ez
lmqGpbqDha/oBrHVdVspd4FZO1bdZwKn5VXVrsJTvrPRWJ0Zlnp+lbXbrpBd
HX230g3OstUVV72y1dXMSm3HCldhKgVP/ZPAdD+DaGsp94TuvlK9W1TZV1dt
tdVXzraK2l936AKVzwQq94DKe1Wunuq2k5u9MFafr84Yq8tXDrvtZFfYKjqz
UnLVk8zqiavO2KrSVZkdoJupcJSftzqNtdlX2flVx+7VXVu98lVUN0h25W2r
rszKyVVPdtcrXbUlq1I3Vbdv1EbdWe7Gwle7usFuM2Cr+7a6mlm5d4G4yiOr
UvVUt13cRtVZFcbqzLBUfLV594pucIettnSBWTtWuKrGVYqm6vbJlMFX+Kpq
9yrjXoaKc4Pbu0E3Wynur6t1gdtcld0BVmdVWMpvFJx1d/8v01iOvlLcbSe7
8psJttqWWXWdCXR3lbKp8NSccTSWi6/OGqszv5q8e0V2NdNWmZkVrqqxFa7K
cVW3Jz6afy6e7te7zVhdO+4O+ZXL7hV77djqyFad++vsWM1zVZWpJmRU1XZy
tleXsVwzrM2+mpZdbfWVi63IrGa7SmFn3cVVOMrXWy7G2uKrabvt0b7CVjtt
lb1nNcFV2V2gqquyO8DJpur2Tve4OEvNWPhKe/cqKrs6+m7FV362inLVR7aK
zqxwVY6rVLKqalNhqf6ZZiyVDAtfeWRXUb7CVnpDZhXfBTq5KiuvynaVqqm6
reI8qsbKzrCm++qprSb4iuxql63UMqsJrnq6Y0VelecqPOU1SsZy7Qin+Mpl
90otu5rqq0m2ogvc6SolU9111TRP/UvD4Cy9DEvRV3SD7LVvt1VHZkUX+MxV
72zVmVcpZlXunuowlLq78BW+UveVWnbVbQ1sRWaFq/Lzqoqsys1U3TZyNZeb
sbI6wmm+ctm9IrvCVk9cpbq/PsVVlV2gm6s6TYWjvKw11Vj4quZehkl77djK
w1aT9tff/XeXZStc5eMqPOVtrS5j4Su6QbKr3bZyyaw2dIFnbKXoKkyFpdSd
1WEsBV+dNRa+6u0GI2y1+cygu62uZFZ3bEUXiKvuugpPzR4lY6lkWBt9lbF7
RXblP2q2IrPyuW9hk6vu7LgouKrbHxtGxVhuvqrsB5/Yqmv3SiG7OvJVZnbV
bRBsFZNZbd5ff/d5kn0mcKqr8NQPzr8mT/fri3aWsrGc86st3WDVXjvZlY+t
lDKr6P11NVdlZlbKrlLdrXI2VbadXO3VaSwFX0VnWOrdYIavlLtBsquZturK
rBy6QHVXnbVVp6ucsiocpe2tLmM5+SqyH1TdvSK72uUrFVuRWWl0gbjKI6vC
UX7emmasqfmV0+4V2ZXuONpqSmal5qp3tqraXXdx1TRTddtGaZSdVWEs9R33
ibtX6nvtZFd+tnLPrCr317u6QFzV6yo8NdNa+KqvH6QbJLvCVmRW7l2gsqsq
OkAlU3U7xX3cjYWvPH1FduU13bYis8JVLq5yNlW3R6aOgrEcd7DoBsmusJWO
rZwyqyld4CtbVd+1sMFVkz31b5//PkRN92vJNJZ7R+jkq3effWrZVfReO9nV
HltNz6zoAnHVVFNF2snZX13GwldzfKWcXUXYakN21Wkrh78b6J5ZPXFVRWal
7Kq731UdrtpsKFVzORkLX/V0g47Z1dF3K9nVLFtdcdWRrVwzK/cucLurXEzV
bSF3a3UYy8lXZ3ctI3y1ea+d7GqHrcisPLtAXDXfVN3W6R5lYyllWIq+ohus
uU80O7vCVr22mp5ZqbnqjK0UXaW0W6Vqqm7PqI6qs/CVnq+qu8GqOxnIrnxs
5XDvAplVTma1Na9SNFW3W9wGX2n4ynn3SnmvXW3vClvl2iqzDySz8u0Cu/Oq
qqwKT2mOo7HwlXY3qLzXTnblaavJmVX1/nrGuUBcVZ9V4SmPUTFWZoaFr/qz
q6q9drIrX1uRWc3LrNRcddZWqrtV20z17y+m+2frcBa+ivPVpHODkdmV2pnB
ifcxONqKzMprf10xr8o01V1XTfHUKytlT/dr7zaWi6/O7lQqZ1dP9to3ZFfb
e8FKW5FZ9eyvb3FVVl6FqfQM5WAufKWRXb3z1dbsSm3vClv5ZFZXbaV8NlAx
s1LrAje6CkvpW6vDWPjKuxvcmF1N6wWrbPXRs+noAyMzKxVXkVn5ucrBVN3+
mWatSRnWNF+p2cpt74qddi1bTc2s2F/f46rqrApP+VtrSoal5qtp3aBqdqWy
095tp622itph796zmtoF4iodV3U7RnlUjbXRV67d4LTs6qqttmZXFbZS2WE/
stXEzApXablKzVTdZnEcd2Phq93ZFTvt2CrLVVdtRWbV0wXiqp2m+o8vTPfP
U+ksxQwr2lebd6+2Z1cb72PYZCvFHfZJmVXVjtXZfyfjqn5TfdFLWbPdWPiq
ZveK7Oq1rciu6mylssNOZvVsf31yF6jkKkdPVflJ2Vzdvrqz++fsK8fs6p2v
VLMrekFs1ZlZVe5ZOXaBuGqGqbqt5OAtJ2PhK49u0Cm7Yqe9x1avzlhO3GFX
yqyU99dxla6pui3k6Cx89dxXFd3g5Owq+z4GesE+W03rA9mz6suscFWtqbrN
M8VaXcbq9pXL7pXTnQwV2ZXrTnu3o6bbSi2zumMrNVe9sxWummOqbteojZqx
8FVON3jXV2RXZFcqtoq402rCDrtSZvXEVSpdIK7CUxirzleOu1fTs6up9zFg
K6/MSnWHXW3PKjuzqt6xmuAqTDXDWfhKa/eK7Kpup33LXVcbbeV470L1nQvT
usBuVymYqtslk8bNV1eNVe0rsiuPvSvuY+i11ZYddoXMynXPSrELnOqqbod8
b/4zeLpfj4KxJuVXZFf12VXXfQzYysNWajvslfcuOGZWuGquqaL95OIulwyr
01cV3WDmXrtDdtV1l2jETvu0XhBb9d+7oJZZPXFVhK2qu8BprtrmKCVvdRnL
pR9U8FVHN+iYXdELatlKxVVdfSCZFa56aitlV3X7yMVZ6r5Szq9cd6/Us6uo
nXZstdtWXecDo+9dULqD3akLdHSVoqm6DeTurGpjOWRXFbtXTra6m1117bRf
tVW1r7pNha127rA7Z1YOrqrOqvCUh7NUfXXFWHSDPdmV4k472VW/rZRclW0r
lXsXHDMr1S5QOa/CVF7OUvWVaze4xVaKO+3YqtZWGzIr5x12MistVymYqtsv
DqNgLHyl5avqM4NqO+30gtiKzMo/s1J3VVVWhan6xy3D6vKVSze4Mbtip93f
Vkqu6rLV9MzKaX9dZceq01XdNpkw+KrWV122yvLV1p12bEVm5brDnpFZZdsK
V9W4qtsjR/NfJ6f758x0lquvpnSDZFd6vSC2wlaV9y5My6y2dYHbTHXWTVHj
bKztvlK1VdbeVVV2RS/obavNrorOrJRc9cpWLq7aaKqpdnKxV7Wzsozl1g9O
8ZVTdpXpK2y121YKXeBdW6l2gbhK01TdNnJy1jZfTc+vlLpB9q48zguq2mrq
PeyVZwMnZ1YdPWCmq5Szqm4HOTurylcO/SDZ1czsStlWnb7KsBWZlX4f2JVZ
uXaBV7+7rthK0VTd3pnkLHxFduW2d4Wt+m1FH6h5NnBzZoWr8NRWY6l3gwrn
BquzK3rBnb0gttKwlVIfeDezmrq/jqv2joqvFPKrDdmV0n1X9ILe2VW3rba4
KqMPrL7Pisyq31V4CmPhK7IrbDXbVmRWZFa4ys9V3U5xHnyl0w0qZleVO+1d
vSB3MWArd1sp7bBPyaxwVe/8d9B0vw4HX5Fd+e+0K/aC1bZy3blSs1XH3QtR
rqq0VUYfqHw2UDmzynSVq6miDKVuri5fkV35ZVdTekFHW3X4qsJWKplVtq3U
+0DFzCpifx1X9Zqqy1Eq1iK/Irsiu6IXzLSVeh/oZKspfaBKZtXZBU51Vbeb
1Jw1Jb9y6wax1XxbHflqoq0Udq3cXaV0p1XHDvuGLnCaq7p9pO4sfKWXXXFe
cK6tlHeulGxFZqXXBz6x1eTMKqsLVDRVt4McnbXFV2RX/dkVttLMrrJtRR/o
vcP+ylaTMitctc9U2caq9BXZ1Yzs6tW/tzf5Cluxa6ViK7U+kMzK11Xdxuke
fOXpq7vZ1bt/W9ILamdXk2zFrtWOHfaszOqMrXAVpuoefBXbDU7MrugF+22l
unOlYisyqx5bTe4DcRWm2uYrsqv47EqlF+w8LzjFVpW+6rAVfSA77Aqu6j4X
2O2qbrd8mv85Md0/o4KxHHw11VZkVzq+2marDbtWrncvkFlpZlabXHXGT0/G
zVj46pmv6AWx1URbKe9aHdlqa2bVYavsHfaOzEqpC3QwVbaluq01yVeOtnLL
rtx6QWVbOe2zK9hKPbPaaCsyK70uUNlV3Z7qcJa6r1yzq2k77RvPCyrvXGEr
X1tt7QNdMivHLlDRVd1uUnBWh686u8EJ2ZX7XVcOtrrqq4n77NW2Uti1csus
qm01fYd9k