(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      8468,        263]
NotebookOptionsPosition[      7107,        231]
NotebookOutlinePosition[      7539,        248]
CellTagsIndexPosition[      7496,        245]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.806322977812872*^9, 3.8063229859532814`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"478b58dc-6182-456d-8e98-3a49d3810d9d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"2", "+", 
      SuperscriptBox["3", 
       RowBox[{"n", "-", "1"}]]}]}], "}"}], ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.806323425411912*^9, 3.8063234337861013`*^9}, {
  3.8063239089868307`*^9, 3.8063239116334314`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"6ca5af4d-33e1-48c2-84f8-291b6969cc82"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Por el m\[EAcute]todo iterativo:\"\>"], "Print",
 CellChangeTimes->{3.806323912311661*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"72dbc2dd-3867-4861-b04e-561fa29208af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "2"}], "+", 
   SuperscriptBox["3", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}]]}], ")"}], " ", 
    TemplateBox[{"1", "1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"1", "1"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -1 + $CellContext`n, ": ", 2 + 
   3^(-1 + $CellContext`n) + (2 + 3^(-2 + $CellContext`n)) 
    Superscript[1, 1] + $CellContext`a[-2 + $CellContext`n] Superscript[1, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8063239123216324`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"fd6ebcec-f270-4179-9ff1-2f511a687110"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "2"}], "+", 
   SuperscriptBox["3", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "n"}]]}], ")"}], " ", 
    TemplateBox[{"1", "1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}]]}], ")"}], " ", 
    TemplateBox[{"1", "1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"1", "1"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -2 + $CellContext`n, ": ", 2 + 
   3^(-1 + $CellContext`n) + (2 + 3^(-3 + $CellContext`n)) 
    Superscript[1, 1] + (2 + 3^(-2 + $CellContext`n)) 
    Superscript[1, 1] + $CellContext`a[-3 + $CellContext`n] Superscript[1, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.806323912342577*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"4efc09a9-8516-4e21-b7f9-185d36a718e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"n \[Rule] \"\>", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "n"}], "\[InvisibleSpace]", "\<\": \"\>", 
    "\[InvisibleSpace]", "2"}], "+", 
   SuperscriptBox["3", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "4"}], "+", "n"}]]}], ")"}], " ", 
    TemplateBox[{"1", "1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "n"}]]}], ")"}], " ", 
    TemplateBox[{"1", "1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SuperscriptBox["3", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "n"}]]}], ")"}], " ", 
    TemplateBox[{"1", "1"},
     "Superscript"]}], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"-", "4"}], "+", "n"}], "]"}], " ", 
    TemplateBox[{"1", "1"},
     "Superscript"]}]}],
  SequenceForm[
  "n \[Rule] ", -3 + $CellContext`n, ": ", 2 + 
   3^(-1 + $CellContext`n) + (2 + 3^(-4 + $CellContext`n)) 
    Superscript[1, 1] + (2 + 3^(-3 + $CellContext`n)) 
    Superscript[1, 1] + (2 + 3^(-2 + $CellContext`n)) 
    Superscript[1, 1] + $CellContext`a[-4 + $CellContext`n] Superscript[1, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8063239123455687`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"fa20734d-6e57-4507-95b8-bea8f69c6fdd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "n"}], "+", 
   RowBox[{"Sum", "[", 
    RowBox[{
     SuperscriptBox["3", 
      RowBox[{"n", "-", "j"}]], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8063228465312424`*^9, 3.8063228473067155`*^9}, {
  3.8063229095825777`*^9, 3.8063229651699743`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"abdab3e1-6368-446f-abaa-199f441069e3"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["3", "n"], "+", 
    RowBox[{"4", " ", "n"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.806322960956357*^9, 3.806322966048545*^9}},
 CellLabel->"Out[3]=",ExpressionUUID->"7d1fe3de-f757-44ce-9eac-656bcf37e67e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"2", "+", 
      SuperscriptBox["3", 
       RowBox[{"n", "-", "1"}]]}]}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", "n", ",", 
   RowBox[{"inicio", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806323047787896*^9, 3.806323062323374*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"b760db8e-0e90-41ba-a7c0-bf3661303582"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["3", "n"], "+", 
    RowBox[{"4", " ", "n"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8063230638337793`*^9, 3.8063230681890097`*^9}},
 CellLabel->"Out[6]=",ExpressionUUID->"5bcb00f7-429f-4e9a-aa8f-4a02d909cd64"]
}, Open  ]]
},
WindowSize->{946.5, 381.5},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"76b30f08-22e0-4ce9-be66-e4c98946f93a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"478b58dc-6182-456d-8e98-3a49d3810d9d"],
Cell[CellGroupData[{
Cell[783, 27, 413, 10, 70, "Input",ExpressionUUID->"6ca5af4d-33e1-48c2-84f8-291b6969cc82"],
Cell[CellGroupData[{
Cell[1221, 41, 224, 4, 50, "Print",ExpressionUUID->"72dbc2dd-3867-4861-b04e-561fa29208af"],
Cell[1448, 47, 1061, 32, 55, "Print",ExpressionUUID->"fd6ebcec-f270-4179-9ff1-2f511a687110"],
Cell[2512, 81, 1324, 41, 96, "Print",ExpressionUUID->"4efc09a9-8516-4e21-b7f9-185d36a718e2"],
Cell[3839, 124, 1591, 50, 101, "Print",ExpressionUUID->"fa20734d-6e57-4507-95b8-bea8f69c6fdd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5479, 180, 487, 12, 104, "Input",ExpressionUUID->"abdab3e1-6368-446f-abaa-199f441069e3"],
Cell[5969, 194, 323, 8, 124, "Output",ExpressionUUID->"7d1fe3de-f757-44ce-9eac-656bcf37e67e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6329, 207, 432, 11, 70, "Input",ExpressionUUID->"b760db8e-0e90-41ba-a7c0-bf3661303582"],
Cell[6764, 220, 327, 8, 124, "Output",ExpressionUUID->"5bcb00f7-429f-4e9a-aa8f-4a02d909cd64"]
}, Open  ]]
}
]
*)

